/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.icons;

import com.intellij.openapi.util.IconLoader;

import javax.swing.*;

/**
 * NOTE THIS FILE IS AUTO-GENERATED
 * DO NOT EDIT IT BY HAND, run build/scripts/icons.gant instead
 */
public class AllIcons {
  
  public static class Actions {
    public static final Icon AddFacesSupport = IconLoader.getIcon("/actions/addFacesSupport.png"); // 16x16
    public static final Icon AddMulticaret = IconLoader.getIcon("/actions/AddMulticaret.png"); // 16x16
    public static final Icon AllLeft = IconLoader.getIcon("/actions/allLeft.png"); // 16x16
    public static final Icon AllRight = IconLoader.getIcon("/actions/allRight.png"); // 16x16
    public static final Icon Annotate = IconLoader.getIcon("/actions/annotate.png"); // 16x16
    public static final Icon Back = IconLoader.getIcon("/actions/back.png"); // 16x16
    public static final Icon Browser_externalJavaDoc = IconLoader.getIcon("/actions/browser-externalJavaDoc.png"); // 16x16
    public static final Icon Cancel = IconLoader.getIcon("/actions/cancel.png"); // 16x16
    public static final Icon ChangeView = IconLoader.getIcon("/actions/changeView.png"); // 16x16
    public static final Icon Checked = IconLoader.getIcon("/actions/checked.png"); // 12x12
    public static final Icon Checked_selected = IconLoader.getIcon("/actions/checked_selected.png"); // 12x12
    public static final Icon Checked_small = IconLoader.getIcon("/actions/checked_small.png"); // 11x11
    public static final Icon Checked_small_selected = IconLoader.getIcon("/actions/checked_small_selected.png"); // 11x11
    public static final Icon CheckedBlack = IconLoader.getIcon("/actions/checkedBlack.png"); // 12x12
    public static final Icon CheckedGrey = IconLoader.getIcon("/actions/checkedGrey.png"); // 12x12
    public static final Icon CheckMulticaret = IconLoader.getIcon("/actions/CheckMulticaret.png"); // 16x16
    public static final Icon CheckOut = IconLoader.getIcon("/actions/checkOut.png"); // 16x16
    public static final Icon Clean = IconLoader.getIcon("/actions/clean.png"); // 16x16
    public static final Icon CleanLight = IconLoader.getIcon("/actions/cleanLight.png"); // 16x16
    public static final Icon Close = IconLoader.getIcon("/actions/close.png"); // 16x16
    public static final Icon CloseHovered = IconLoader.getIcon("/actions/closeHovered.png"); // 16x16
    public static final Icon CloseNew = IconLoader.getIcon("/actions/closeNew.png"); // 16x16
    public static final Icon CloseNewHovered = IconLoader.getIcon("/actions/closeNewHovered.png"); // 16x16
    public static final Icon Collapseall = IconLoader.getIcon("/actions/collapseall.png"); // 16x16
    public static final Icon Commit = IconLoader.getIcon("/actions/commit.png"); // 16x16
    public static final Icon Compile = IconLoader.getIcon("/actions/compile.png"); // 16x16
    public static final Icon Copy = IconLoader.getIcon("/actions/copy.png"); // 16x16
    public static final Icon CreateFromUsage = IconLoader.getIcon("/actions/createFromUsage.png"); // 16x16
    public static final Icon CreatePatch = IconLoader.getIcon("/actions/createPatch.png"); // 16x16
    public static final Icon Cross = IconLoader.getIcon("/actions/cross.png"); // 12x12
    public static final Icon Delete = IconLoader.getIcon("/actions/delete.png"); // 16x16
    public static final Icon Diff = IconLoader.getIcon("/actions/diff.png"); // 16x16
    public static final Icon DiffWithCurrent = IconLoader.getIcon("/actions/diffWithCurrent.png"); // 16x16
    public static final Icon Down = IconLoader.getIcon("/actions/down.png"); // 16x16
    public static final Icon Download = IconLoader.getIcon("/actions/download.png"); // 16x16
    public static final Icon Dump = IconLoader.getIcon("/actions/dump.png"); // 16x16
    public static final Icon Edit = IconLoader.getIcon("/actions/edit.png"); // 14x14
    public static final Icon EditSource = IconLoader.getIcon("/actions/editSource.png"); // 16x16
    public static final Icon ErDiagram = IconLoader.getIcon("/actions/erDiagram.png"); // 16x16
    public static final Icon Exclude = IconLoader.getIcon("/actions/exclude.png"); // 14x14
    public static final Icon Execute = IconLoader.getIcon("/actions/execute.png"); // 16x16
    public static final Icon Exit = IconLoader.getIcon("/actions/exit.png"); // 16x16
    public static final Icon Expandall = IconLoader.getIcon("/actions/expandall.png"); // 16x16
    public static final Icon Export = IconLoader.getIcon("/actions/export.png"); // 16x16
    
    @SuppressWarnings("unused")
    @Deprecated
    public static final Icon FileStatus = IconLoader.getIcon("/actions/fileStatus.png"); // 16x16
    public static final Icon Filter_small = IconLoader.getIcon("/actions/filter_small.png"); // 16x16
    public static final Icon Find = IconLoader.getIcon("/actions/find.png"); // 16x16
    public static final Icon FindPlain = IconLoader.getIcon("/actions/findPlain.png"); // 16x16
    public static final Icon FindWhite = IconLoader.getIcon("/actions/findWhite.png"); // 16x16
    public static final Icon ForceRefresh = IconLoader.getIcon("/actions/forceRefresh.png"); // 16x16
    public static final Icon Forward = IconLoader.getIcon("/actions/forward.png"); // 16x16
    public static final Icon GC = IconLoader.getIcon("/actions/gc.png"); // 16x16
    public static final Icon Get = IconLoader.getIcon("/actions/get.png"); // 16x16
    public static final Icon GroupByClass = IconLoader.getIcon("/actions/GroupByClass.png"); // 16x16
    public static final Icon GroupByFile = IconLoader.getIcon("/actions/GroupByFile.png"); // 16x16
    public static final Icon GroupByMethod = IconLoader.getIcon("/actions/groupByMethod.png"); // 16x16
    public static final Icon GroupByModule = IconLoader.getIcon("/actions/GroupByModule.png"); // 16x16
    public static final Icon GroupByModuleGroup = IconLoader.getIcon("/actions/GroupByModuleGroup.png"); // 16x16
    public static final Icon GroupByPackage = IconLoader.getIcon("/actions/GroupByPackage.png"); // 16x16
    public static final Icon GroupByPrefix = IconLoader.getIcon("/actions/GroupByPrefix.png"); // 16x16
    public static final Icon GroupByTestProduction = IconLoader.getIcon("/actions/groupByTestProduction.png"); // 16x16
    public static final Icon Help = IconLoader.getIcon("/actions/help.png"); // 16x16
    public static final Icon Install = IconLoader.getIcon("/actions/install.png"); // 16x16
    public static final Icon IntentionBulb = IconLoader.getIcon("/actions/intentionBulb.png"); // 16x16
    public static final Icon Left = IconLoader.getIcon("/actions/left.png"); // 16x16
    public static final Icon Lightning = IconLoader.getIcon("/actions/lightning.png"); // 16x16
    public static final Icon Menu_cut = IconLoader.getIcon("/actions/menu-cut.png"); // 16x16
    public static final Icon Menu_find = IconLoader.getIcon("/actions/menu-find.png"); // 16x16
    public static final Icon Menu_help = IconLoader.getIcon("/actions/menu-help.png"); // 16x16
    public static final Icon Menu_open = IconLoader.getIcon("/actions/menu-open.png"); // 16x16
    public static final Icon Menu_paste = IconLoader.getIcon("/actions/menu-paste.png"); // 16x16
    public static final Icon Menu_replace = IconLoader.getIcon("/actions/menu-replace.png"); // 16x16
    public static final Icon Menu_saveall = IconLoader.getIcon("/actions/menu-saveall.png"); // 16x16
    public static final Icon Minimize = IconLoader.getIcon("/actions/minimize.png"); // 16x16
    public static final Icon Module = IconLoader.getIcon("/actions/module.png"); // 16x16
    public static final Icon Move_to_button_top = IconLoader.getIcon("/actions/move-to-button-top.png"); // 11x12
    public static final Icon Move_to_button = IconLoader.getIcon("/actions/move-to-button.png"); // 11x10
    public static final Icon MoveDown = IconLoader.getIcon("/actions/moveDown.png"); // 14x14
    public static final Icon MoveTo2 = IconLoader.getIcon("/actions/MoveTo2.png"); // 16x16
    public static final Icon MoveToAnotherChangelist = IconLoader.getIcon("/actions/moveToAnotherChangelist.png"); // 16x16
    public static final Icon MoveToStandardPlace = IconLoader.getIcon("/actions/moveToStandardPlace.png"); // 16x16
    public static final Icon MoveUp = IconLoader.getIcon("/actions/moveUp.png"); // 14x14
    public static final Icon New = IconLoader.getIcon("/actions/new.png"); // 16x16
    public static final Icon NewFolder = IconLoader.getIcon("/actions/newFolder.png"); // 16x16
    public static final Icon Nextfile = IconLoader.getIcon("/actions/nextfile.png"); // 16x16
    public static final Icon NextOccurence = IconLoader.getIcon("/actions/nextOccurence.png"); // 16x16
    public static final Icon Pause = IconLoader.getIcon("/actions/pause.png"); // 16x16
    public static final Icon PopFrame = IconLoader.getIcon("/actions/popFrame.png"); // 16x16
    public static final Icon Prevfile = IconLoader.getIcon("/actions/prevfile.png"); // 16x16
    public static final Icon Preview = IconLoader.getIcon("/actions/preview.png"); // 16x16
    public static final Icon PreviewDetails = IconLoader.getIcon("/actions/previewDetails.png"); // 16x16
    public static final Icon PreviousOccurence = IconLoader.getIcon("/actions/previousOccurence.png"); // 14x14
    public static final Icon Profile = IconLoader.getIcon("/actions/profile.png"); // 16x16
    public static final Icon ProfileCPU = IconLoader.getIcon("/actions/profileCPU.png"); // 16x16
    public static final Icon ProfileMemory = IconLoader.getIcon("/actions/profileMemory.png"); // 16x16
    public static final Icon Properties = IconLoader.getIcon("/actions/properties.png"); // 16x16
    public static final Icon QuickfixBulb = IconLoader.getIcon("/actions/quickfixBulb.png"); // 16x16
    public static final Icon QuickfixOffBulb = IconLoader.getIcon("/actions/quickfixOffBulb.png"); // 16x16
    public static final Icon QuickList = IconLoader.getIcon("/actions/quickList.png"); // 16x16
    public static final Icon RealIntentionBulb = IconLoader.getIcon("/actions/realIntentionBulb.png"); // 16x16
    public static final Icon RealIntentionOffBulb = IconLoader.getIcon("/actions/realIntentionOffBulb.png"); // 16x16
    public static final Icon Redo = IconLoader.getIcon("/actions/redo.png"); // 16x16
    public static final Icon RefactoringBulb = IconLoader.getIcon("/actions/refactoringBulb.png"); // 16x16
    public static final Icon Refresh = IconLoader.getIcon("/actions/refresh.png"); // 16x16
    public static final Icon RemoveMulticaret = IconLoader.getIcon("/actions/RemoveMulticaret.png"); // 16x16
    public static final Icon Replace = IconLoader.getIcon("/actions/replace.png"); // 16x16
    public static final Icon Rerun = IconLoader.getIcon("/actions/rerun.png"); // 16x16
    public static final Icon Reset_to_default = IconLoader.getIcon("/actions/reset-to-default.png"); // 16x16
    public static final Icon Reset = IconLoader.getIcon("/actions/reset.png"); // 16x16
    public static final Icon Reset_to_empty = IconLoader.getIcon("/actions/Reset_to_empty.png"); // 16x16
    public static final Icon Restart = IconLoader.getIcon("/actions/restart.png"); // 16x16
    public static final Icon Resume = IconLoader.getIcon("/actions/resume.png"); // 16x16
    public static final Icon Right = IconLoader.getIcon("/actions/right.png"); // 16x16
    public static final Icon Rollback = IconLoader.getIcon("/actions/rollback.png"); // 16x16
    public static final Icon RunToCursor = IconLoader.getIcon("/actions/runToCursor.png"); // 16x16
    public static final Icon Scratch = IconLoader.getIcon("/actions/scratch.png"); // 16x16
    public static final Icon Search = IconLoader.getIcon("/actions/search.png"); // 16x16
    public static final Icon Selectall = IconLoader.getIcon("/actions/selectall.png"); // 16x16
    public static final Icon Share = IconLoader.getIcon("/actions/share.png"); // 14x14
    public static final Icon ShortcutFilter = IconLoader.getIcon("/actions/shortcutFilter.png"); // 16x16
    public static final Icon ShowAsTree = IconLoader.getIcon("/actions/showAsTree.png"); // 16x16
    public static final Icon ShowChangesOnly = IconLoader.getIcon("/actions/showChangesOnly.png"); // 16x16
    public static final Icon ShowHiddens = IconLoader.getIcon("/actions/showHiddens.png"); // 16x16
    public static final Icon ShowImportStatements = IconLoader.getIcon("/actions/showImportStatements.png"); // 16x16
    public static final Icon ShowReadAccess = IconLoader.getIcon("/actions/showReadAccess.png"); // 16x16
    public static final Icon ShowViewer = IconLoader.getIcon("/actions/showViewer.png"); // 16x16
    public static final Icon ShowWriteAccess = IconLoader.getIcon("/actions/showWriteAccess.png"); // 16x16
    public static final Icon SortAsc = IconLoader.getIcon("/actions/sortAsc.png"); // 9x8
    public static final Icon SortDesc = IconLoader.getIcon("/actions/sortDesc.png"); // 9x8
    public static final Icon SplitHorizontally = IconLoader.getIcon("/actions/splitHorizontally.png"); // 16x16
    public static final Icon SplitVertically = IconLoader.getIcon("/actions/splitVertically.png"); // 16x16
    public static final Icon StartDebugger = IconLoader.getIcon("/actions/startDebugger.png"); // 16x16
    public static final Icon StepOut = IconLoader.getIcon("/actions/stepOut.png"); // 16x16
    public static final Icon Submit1 = IconLoader.getIcon("/actions/submit1.png"); // 11x11
    public static final Icon Suspend = IconLoader.getIcon("/actions/suspend.png"); // 16x16
    public static final Icon SwapPanels = IconLoader.getIcon("/actions/swapPanels.png"); // 16x16
    public static final Icon SynchronizeScrolling = IconLoader.getIcon("/actions/synchronizeScrolling.png"); // 16x16
    public static final Icon SyncPanels = IconLoader.getIcon("/actions/syncPanels.png"); // 16x16
    public static final Icon ToggleSoftWrap = IconLoader.getIcon("/actions/toggleSoftWrap.png"); // 16x16
    public static final Icon TraceInto = IconLoader.getIcon("/actions/traceInto.png"); // 16x16
    public static final Icon TraceOver = IconLoader.getIcon("/actions/traceOver.png"); // 16x16
    public static final Icon Undo = IconLoader.getIcon("/actions/undo.png"); // 16x16
    public static final Icon Uninstall = IconLoader.getIcon("/actions/uninstall.png"); // 16x16
    public static final Icon Unselectall = IconLoader.getIcon("/actions/unselectall.png"); // 16x16
    public static final Icon Unshare = IconLoader.getIcon("/actions/unshare.png"); // 14x14
    public static final Icon UP = IconLoader.getIcon("/actions/up.png"); // 16x16

  }
  
  public static class CodeStyle {
    public static final Icon AddNewSectionRule = IconLoader.getIcon("/codeStyle/AddNewSectionRule.png"); // 16x16
    public static final Icon Gear = IconLoader.getIcon("/codeStyle/Gear.png"); // 16x16
    
    public static class Mac {
      public static final Icon AddNewSectionRule = IconLoader.getIcon("/codeStyle/mac/AddNewSectionRule.png"); // 16x16

    }

  }
  
  public static class Css {
    public static final Icon Atrule = IconLoader.getIcon("/css/atrule.png"); // 16x16
    public static final Icon Import = IconLoader.getIcon("/css/import.png"); // 16x16
    public static final Icon Property = IconLoader.getIcon("/css/property.png"); // 16x16
    public static final Icon Pseudo_class = IconLoader.getIcon("/css/pseudo-class.png"); // 16x16
    public static final Icon Pseudo_element = IconLoader.getIcon("/css/pseudo-element.png"); // 16x16
    public static final Icon Toolwindow = IconLoader.getIcon("/css/toolwindow.png"); // 13x13

  }
  
  public static class Darcula {
    public static final Icon DoubleComboArrow = IconLoader.getIcon("/darcula/doubleComboArrow.png"); // 7x11
    public static final Icon TreeNodeCollapsed = IconLoader.getIcon("/darcula/treeNodeCollapsed.png"); // 9x9
    public static final Icon TreeNodeExpanded = IconLoader.getIcon("/darcula/treeNodeExpanded.png"); // 9x9

  }
  
  public static class Debugger {
    
    public static class Actions {
      public static final Icon Force_run_to_cursor = IconLoader.getIcon("/debugger/actions/force_run_to_cursor.png"); // 16x16
      public static final Icon Force_step_into = IconLoader.getIcon("/debugger/actions/force_step_into.png"); // 16x16
      public static final Icon Force_step_over = IconLoader.getIcon("/debugger/actions/force_step_over.png"); // 16x16

    }
    public static final Icon AddToWatch = IconLoader.getIcon("/debugger/addToWatch.png"); // 16x16
    public static final Icon AutoVariablesMode = IconLoader.getIcon("/debugger/autoVariablesMode.png"); // 16x16
    public static final Icon BreakpointAlert = IconLoader.getIcon("/debugger/breakpointAlert.png"); // 16x16
    public static final Icon Class_filter = IconLoader.getIcon("/debugger/class_filter.png"); // 16x16
    public static final Icon CommandLine = IconLoader.getIcon("/debugger/commandLine.png"); // 16x16
    public static final Icon Console = IconLoader.getIcon("/debugger/console.png"); // 16x16
    public static final Icon Console_log = IconLoader.getIcon("/debugger/console_log.png"); // 16x16
    public static final Icon Db_array = IconLoader.getIcon("/debugger/db_array.png"); // 16x16
    public static final Icon Db_db_object = IconLoader.getIcon("/debugger/db_db_object.png"); // 16x16
    public static final Icon Db_dep_exception_breakpoint = IconLoader.getIcon("/debugger/db_dep_exception_breakpoint.png"); // 12x12
    public static final Icon Db_dep_field_breakpoint = IconLoader.getIcon("/debugger/db_dep_field_breakpoint.png"); // 12x12
    public static final Icon Db_dep_line_breakpoint = IconLoader.getIcon("/debugger/db_dep_line_breakpoint.png"); // 12x12
    public static final Icon Db_dep_method_breakpoint = IconLoader.getIcon("/debugger/db_dep_method_breakpoint.png"); // 12x12
    public static final Icon Db_disabled_breakpoint = IconLoader.getIcon("/debugger/db_disabled_breakpoint.png"); // 12x12
    public static final Icon Db_disabled_breakpoint_process = IconLoader.getIcon("/debugger/db_disabled_breakpoint_process.png"); // 16x16
    public static final Icon Db_disabled_exception_breakpoint = IconLoader.getIcon("/debugger/db_disabled_exception_breakpoint.png"); // 12x12
    public static final Icon Db_disabled_field_breakpoint = IconLoader.getIcon("/debugger/db_disabled_field_breakpoint.png"); // 12x12
    public static final Icon Db_disabled_method_breakpoint = IconLoader.getIcon("/debugger/db_disabled_method_breakpoint.png"); // 12x12
    public static final Icon Db_exception_breakpoint = IconLoader.getIcon("/debugger/db_exception_breakpoint.png"); // 12x12
    public static final Icon Db_field_breakpoint = IconLoader.getIcon("/debugger/db_field_breakpoint.png"); // 12x12
    public static final Icon Db_field_warning_breakpoint = IconLoader.getIcon("/debugger/db_field_warning_breakpoint.png"); // 16x16
    public static final Icon Db_invalid_breakpoint = IconLoader.getIcon("/debugger/db_invalid_breakpoint.png"); // 12x12
    public static final Icon Db_invalid_field_breakpoint = IconLoader.getIcon("/debugger/db_invalid_field_breakpoint.png"); // 12x12
    public static final Icon Db_invalid_method_breakpoint = IconLoader.getIcon("/debugger/db_invalid_method_breakpoint.png"); // 12x12
    public static final Icon Db_method_breakpoint = IconLoader.getIcon("/debugger/db_method_breakpoint.png"); // 12x12
    public static final Icon Db_method_warning_breakpoint = IconLoader.getIcon("/debugger/db_method_warning_breakpoint.png"); // 16x16
    public static final Icon Db_muted_breakpoint = IconLoader.getIcon("/debugger/db_muted_breakpoint.png"); // 12x12
    public static final Icon Db_muted_dep_exception_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_exception_breakpoint.png"); // 12x12
    public static final Icon Db_muted_dep_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_field_breakpoint.png"); // 12x12
    public static final Icon Db_muted_dep_line_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_line_breakpoint.png"); // 12x12
    public static final Icon Db_muted_dep_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_dep_method_breakpoint.png"); // 12x12
    public static final Icon Db_muted_disabled_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_breakpoint.png"); // 12x12
    public static final Icon Db_muted_disabled_breakpoint_process = IconLoader.getIcon("/debugger/db_muted_disabled_breakpoint_process.png"); // 16x16
    public static final Icon Db_muted_disabled_exception_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_exception_breakpoint.png"); // 12x12
    public static final Icon Db_muted_disabled_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_field_breakpoint.png"); // 12x12
    public static final Icon Db_muted_disabled_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_disabled_method_breakpoint.png"); // 12x12
    public static final Icon Db_muted_exception_breakpoint = IconLoader.getIcon("/debugger/db_muted_exception_breakpoint.png"); // 12x12
    public static final Icon Db_muted_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_field_breakpoint.png"); // 12x12
    public static final Icon Db_muted_field_warning_breakpoint = IconLoader.getIcon("/debugger/db_muted_field_warning_breakpoint.png"); // 16x16
    public static final Icon Db_muted_invalid_breakpoint = IconLoader.getIcon("/debugger/db_muted_invalid_breakpoint.png"); // 12x12
    public static final Icon Db_muted_invalid_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_invalid_field_breakpoint.png"); // 12x12
    public static final Icon Db_muted_invalid_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_invalid_method_breakpoint.png"); // 12x12
    public static final Icon Db_muted_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_method_breakpoint.png"); // 12x12
    public static final Icon Db_muted_method_warning_breakpoint = IconLoader.getIcon("/debugger/db_muted_method_warning_breakpoint.png"); // 16x16
    public static final Icon Db_muted_temporary_breakpoint = IconLoader.getIcon("/debugger/db_muted_temporary_breakpoint.png"); // 12x12
    public static final Icon Db_muted_verified_breakpoint = IconLoader.getIcon("/debugger/db_muted_verified_breakpoint.png"); // 12x12
    public static final Icon Db_muted_verified_field_breakpoint = IconLoader.getIcon("/debugger/db_muted_verified_field_breakpoint.png"); // 12x12
    public static final Icon Db_muted_verified_method_breakpoint = IconLoader.getIcon("/debugger/db_muted_verified_method_breakpoint.png"); // 12x12
    public static final Icon Db_muted_verified_warning_breakpoint = IconLoader.getIcon("/debugger/db_muted_verified_warning_breakpoint.png"); // 16x16
    public static final Icon Db_obsolete = IconLoader.getIcon("/debugger/db_obsolete.png"); // 12x12
    public static final Icon Db_primitive = IconLoader.getIcon("/debugger/db_primitive.png"); // 16x16
    public static final Icon Db_set_breakpoint = IconLoader.getIcon("/debugger/db_set_breakpoint.png"); // 12x12
    public static final Icon Db_temporary_breakpoint = IconLoader.getIcon("/debugger/db_temporary_breakpoint.png"); // 12x12
    public static final Icon Db_verified_breakpoint = IconLoader.getIcon("/debugger/db_verified_breakpoint.png"); // 12x12
    public static final Icon Db_verified_field_breakpoint = IconLoader.getIcon("/debugger/db_verified_field_breakpoint.png"); // 12x12
    public static final Icon Db_verified_method_breakpoint = IconLoader.getIcon("/debugger/db_verified_method_breakpoint.png"); // 12x12
    public static final Icon Db_verified_warning_breakpoint = IconLoader.getIcon("/debugger/db_verified_warning_breakpoint.png"); // 16x16
    public static final Icon Disable_value_calculation = IconLoader.getIcon("/debugger/disable_value_calculation.png"); // 16x16
    public static final Icon EvaluateExpression = IconLoader.getIcon("/debugger/evaluateExpression.png"); // 16x16
    public static final Icon Frame = IconLoader.getIcon("/debugger/frame.png"); // 16x16
    public static final Icon KillProcess = IconLoader.getIcon("/debugger/killProcess.png"); // 16x16
    public static final Icon MuteBreakpoints = IconLoader.getIcon("/debugger/muteBreakpoints.png"); // 16x16
    public static final Icon NewWatch = IconLoader.getIcon("/debugger/newWatch.png"); // 16x16
    public static final Icon RestoreLayout = IconLoader.getIcon("/debugger/restoreLayout.png"); // 16x16
    public static final Icon ShowCurrentFrame = IconLoader.getIcon("/debugger/showCurrentFrame.png"); // 16x16
    public static final Icon SmartStepInto = IconLoader.getIcon("/debugger/smartStepInto.png"); // 16x16
    public static final Icon StackFrame = IconLoader.getIcon("/debugger/stackFrame.png"); // 16x16
    public static final Icon ThreadAtBreakpoint = IconLoader.getIcon("/debugger/threadAtBreakpoint.png"); // 16x16
    public static final Icon ThreadCurrent = IconLoader.getIcon("/debugger/threadCurrent.png"); // 16x16
    public static final Icon ThreadFrozen = IconLoader.getIcon("/debugger/threadFrozen.png"); // 16x16
    public static final Icon ThreadGroup = IconLoader.getIcon("/debugger/threadGroup.png"); // 16x16
    public static final Icon ThreadGroupCurrent = IconLoader.getIcon("/debugger/threadGroupCurrent.png"); // 16x16
    public static final Icon ThreadRunning = IconLoader.getIcon("/debugger/threadRunning.png"); // 16x16
    public static final Icon Threads = IconLoader.getIcon("/debugger/threads.png"); // 16x16
    
    public static class ThreadStates {
      public static final Icon Daemon_sign = IconLoader.getIcon("/debugger/threadStates/daemon_sign.png"); // 16x16
      public static final Icon EdtBusy = IconLoader.getIcon("/debugger/threadStates/edtBusy.png"); // 16x16
      public static final Icon Exception = IconLoader.getIcon("/debugger/threadStates/exception.png"); // 16x16
      public static final Icon Idle = IconLoader.getIcon("/debugger/threadStates/idle.png"); // 16x16
      public static final Icon IO = IconLoader.getIcon("/debugger/threadStates/io.png"); // 16x16
      public static final Icon Locked = IconLoader.getIcon("/debugger/threadStates/locked.png"); // 16x16
      public static final Icon Paused = IconLoader.getIcon("/debugger/threadStates/paused.png"); // 16x16
      public static final Icon Running = IconLoader.getIcon("/debugger/threadStates/running.png"); // 16x16
      public static final Icon Socket = IconLoader.getIcon("/debugger/threadStates/socket.png"); // 16x16
      public static final Icon Threaddump = IconLoader.getIcon("/debugger/threadStates/threaddump.png"); // 16x16

    }
    public static final Icon ThreadSuspended = IconLoader.getIcon("/debugger/threadSuspended.png"); // 16x16
    public static final Icon ToolConsole = IconLoader.getIcon("/debugger/toolConsole.png"); // 16x16
    public static final Icon Value = IconLoader.getIcon("/debugger/value.png"); // 16x16
    public static final Icon ViewBreakpoints = IconLoader.getIcon("/debugger/viewBreakpoints.png"); // 16x16
    public static final Icon Watch = IconLoader.getIcon("/debugger/watch.png"); // 16x16
    public static final Icon Watches = IconLoader.getIcon("/debugger/watches.png"); // 16x16
    public static final Icon WatchLastReturnValue = IconLoader.getIcon("/debugger/watchLastReturnValue.png"); // 16x16

  }
  
  public static class Diff {
    public static final Icon ApplyNotConflicts = IconLoader.getIcon("/diff/applyNotConflicts.png"); // 16x16
    public static final Icon ApplyNotConflictsLeft = IconLoader.getIcon("/diff/applyNotConflictsLeft.png"); // 16x16
    public static final Icon ApplyNotConflictsRight = IconLoader.getIcon("/diff/applyNotConflictsRight.png"); // 16x16
    public static final Icon Arrow = IconLoader.getIcon("/diff/arrow.png"); // 11x11
    public static final Icon ArrowLeftDown = IconLoader.getIcon("/diff/arrowLeftDown.png"); // 11x11
    public static final Icon ArrowRight = IconLoader.getIcon("/diff/arrowRight.png"); // 11x11
    public static final Icon ArrowRightDown = IconLoader.getIcon("/diff/arrowRightDown.png"); // 11x11
    public static final Icon BranchDiff = IconLoader.getIcon("/diff/branchDiff.png"); // 16x16
    public static final Icon CurrentLine = IconLoader.getIcon("/diff/currentLine.png"); // 16x16
    public static final Icon Diff = IconLoader.getIcon("/diff/Diff.png"); // 16x16
    public static final Icon LeftDiff = IconLoader.getIcon("/diff/leftDiff.png"); // 16x16
    public static final Icon Remove = IconLoader.getIcon("/diff/remove.png"); // 11x11
    public static final Icon RightDiff = IconLoader.getIcon("/diff/rightDiff.png"); // 16x16

  }
  
  public static class Duplicates {
    public static final Icon SendToTheLeft = IconLoader.getIcon("/duplicates/sendToTheLeft.png"); // 16x16
    public static final Icon SendToTheLeftGrayed = IconLoader.getIcon("/duplicates/sendToTheLeftGrayed.png"); // 16x16
    public static final Icon SendToTheRight = IconLoader.getIcon("/duplicates/sendToTheRight.png"); // 16x16
    public static final Icon SendToTheRightGrayed = IconLoader.getIcon("/duplicates/sendToTheRightGrayed.png"); // 16x16

  }
  
  public static class FileTypes {
    public static final Icon Any_type = IconLoader.getIcon("/fileTypes/any_type.png"); // 16x16
    public static final Icon Archive = IconLoader.getIcon("/fileTypes/archive.png"); // 16x16
    public static final Icon AS = IconLoader.getIcon("/fileTypes/as.png"); // 16x16
    public static final Icon Aspectj = IconLoader.getIcon("/fileTypes/aspectj.png"); // 16x16
    public static final Icon Config = IconLoader.getIcon("/fileTypes/config.png"); // 16x16
    public static final Icon Css = IconLoader.getIcon("/fileTypes/css.png"); // 16x16
    public static final Icon Custom = IconLoader.getIcon("/fileTypes/custom.png"); // 16x16
    public static final Icon Diagram = IconLoader.getIcon("/fileTypes/diagram.png"); // 16x16
    public static final Icon Dtd = IconLoader.getIcon("/fileTypes/dtd.png"); // 16x16
    public static final Icon Facelets = IconLoader.getIcon("/fileTypes/facelets.png"); // 16x16
    public static final Icon FacesConfig = IconLoader.getIcon("/fileTypes/facesConfig.png"); // 16x16
    public static final Icon Htaccess = IconLoader.getIcon("/fileTypes/htaccess.png"); // 16x16
    public static final Icon Html = IconLoader.getIcon("/fileTypes/html.png"); // 16x16
    public static final Icon Idl = IconLoader.getIcon("/fileTypes/idl.png"); // 16x16
    public static final Icon Java = IconLoader.getIcon("/fileTypes/java.png"); // 16x16
    public static final Icon JavaClass = IconLoader.getIcon("/fileTypes/javaClass.png"); // 16x16
    public static final Icon JavaOutsideSource = IconLoader.getIcon("/fileTypes/javaOutsideSource.png"); // 16x16
    public static final Icon JavaScript = IconLoader.getIcon("/fileTypes/javaScript.png"); // 16x16
    public static final Icon Json = IconLoader.getIcon("/fileTypes/json.png"); // 16x16
    public static final Icon Jsp = IconLoader.getIcon("/fileTypes/jsp.png"); // 16x16
    public static final Icon Jspx = IconLoader.getIcon("/fileTypes/jspx.png"); // 16x16
    public static final Icon Manifest = IconLoader.getIcon("/fileTypes/manifest.png"); // 16x16
    public static final Icon Properties = IconLoader.getIcon("/fileTypes/properties.png"); // 16x16
    public static final Icon Text = IconLoader.getIcon("/fileTypes/text.png"); // 16x16
    public static final Icon TypeScript = IconLoader.getIcon("/fileTypes/typeScript.png"); // 16x16
    public static final Icon UiForm = IconLoader.getIcon("/fileTypes/uiForm.png"); // 16x16
    public static final Icon Unknown = IconLoader.getIcon("/fileTypes/unknown.png"); // 16x16
    public static final Icon WsdlFile = IconLoader.getIcon("/fileTypes/wsdlFile.png"); // 16x16
    public static final Icon Xhtml = IconLoader.getIcon("/fileTypes/xhtml.png"); // 16x16
    public static final Icon Xml = IconLoader.getIcon("/fileTypes/xml.png"); // 16x16
    public static final Icon XsdFile = IconLoader.getIcon("/fileTypes/xsdFile.png"); // 16x16

  }
  public static final Icon Frame_background = IconLoader.getIcon("/frame_background.png"); // 256x256
  
  public static class General {
    public static final Icon Add = IconLoader.getIcon("/general/add.png"); // 16x16
    public static final Icon AddFavoritesList = IconLoader.getIcon("/general/addFavoritesList.png"); // 16x16
    public static final Icon AddJdk = IconLoader.getIcon("/general/addJdk.png"); // 16x16
    public static final Icon ArrowDown = IconLoader.getIcon("/general/arrowDown.png"); // 7x6
    public static final Icon AutohideOff = IconLoader.getIcon("/general/autohideOff.png"); // 14x14
    public static final Icon AutohideOffInactive = IconLoader.getIcon("/general/autohideOffInactive.png"); // 14x14
    public static final Icon AutohideOffPressed = IconLoader.getIcon("/general/autohideOffPressed.png"); // 22x20
    public static final Icon AutoscrollFromSource = IconLoader.getIcon("/general/autoscrollFromSource.png"); // 16x16
    public static final Icon AutoscrollToSource = IconLoader.getIcon("/general/autoscrollToSource.png"); // 16x16
    public static final Icon Balloon = IconLoader.getIcon("/general/balloon.png"); // 16x16
    public static final Icon BalloonClose = IconLoader.getIcon("/general/balloonClose.png"); // 32x32
    public static final Icon BalloonError = IconLoader.getIcon("/general/balloonError.png"); // 16x16
    public static final Icon BalloonInformation = IconLoader.getIcon("/general/balloonInformation.png"); // 16x16
    public static final Icon BalloonWarning = IconLoader.getIcon("/general/balloonWarning.png"); // 16x16
    public static final Icon Bullet = IconLoader.getIcon("/general/bullet.png"); // 16x16
    public static final Icon CollapseAll = IconLoader.getIcon("/general/collapseAll.png"); // 11x16
    public static final Icon CollapseAllHover = IconLoader.getIcon("/general/collapseAllHover.png"); // 11x16
    public static final Icon Combo = IconLoader.getIcon("/general/combo.png"); // 16x16
    public static final Icon Combo2 = IconLoader.getIcon("/general/combo2.png"); // 16x16
    public static final Icon Combo3 = IconLoader.getIcon("/general/combo3.png"); // 16x16
    public static final Icon ComboArrow = IconLoader.getIcon("/general/comboArrow.png"); // 16x16
    public static final Icon ComboArrowDown = IconLoader.getIcon("/general/comboArrowDown.png"); // 9x5
    public static final Icon ComboArrowLeft = IconLoader.getIcon("/general/comboArrowLeft.png"); // 5x9
    public static final Icon ComboArrowLeftPassive = IconLoader.getIcon("/general/comboArrowLeftPassive.png"); // 5x9
    public static final Icon ComboArrowRight = IconLoader.getIcon("/general/comboArrowRight.png"); // 5x9
    public static final Icon ComboArrowRightPassive = IconLoader.getIcon("/general/comboArrowRightPassive.png"); // 5x9
    public static final Icon ComboBoxButtonArrow = IconLoader.getIcon("/general/comboBoxButtonArrow.png"); // 16x16
    public static final Icon ComboUpPassive = IconLoader.getIcon("/general/comboUpPassive.png"); // 16x16
    public static final Icon ConfigurableDefault = IconLoader.getIcon("/general/configurableDefault.png"); // 32x32
    public static final Icon Configure = IconLoader.getIcon("/general/Configure.png"); // 32x32
    public static final Icon CreateNewProject = IconLoader.getIcon("/general/createNewProject.png"); // 32x32
    public static final Icon CreateNewProjectfromExistingFiles = IconLoader.getIcon("/general/CreateNewProjectfromExistingFiles.png"); // 32x32
    public static final Icon Debug = IconLoader.getIcon("/general/debug.png"); // 16x16
    public static final Icon DefaultKeymap = IconLoader.getIcon("/general/defaultKeymap.png"); // 32x32
    public static final Icon Divider = IconLoader.getIcon("/general/divider.png"); // 2x19
    public static final Icon DownloadPlugin = IconLoader.getIcon("/general/downloadPlugin.png"); // 16x16
    public static final Icon Dropdown = IconLoader.getIcon("/general/dropdown.png"); // 16x16
    public static final Icon EditColors = IconLoader.getIcon("/general/editColors.png"); // 16x16
    public static final Icon EditItemInSection = IconLoader.getIcon("/general/editItemInSection.png"); // 16x16
    public static final Icon Ellipsis = IconLoader.getIcon("/general/ellipsis.png"); // 9x9
    public static final Icon Error = IconLoader.getIcon("/general/error.png"); // 16x16
    public static final Icon ErrorDialog = IconLoader.getIcon("/general/errorDialog.png"); // 32x32
    public static final Icon ErrorsInProgress = IconLoader.getIcon("/general/errorsInProgress.png"); // 12x12
    public static final Icon ExclMark = IconLoader.getIcon("/general/exclMark.png"); // 16x16
    public static final Icon ExpandAll = IconLoader.getIcon("/general/expandAll.png"); // 11x16
    public static final Icon ExpandAllHover = IconLoader.getIcon("/general/expandAllHover.png"); // 11x16
    public static final Icon ExportSettings = IconLoader.getIcon("/general/ExportSettings.png"); // 32x32
    public static final Icon ExternalTools = IconLoader.getIcon("/general/externalTools.png"); // 32x32
    public static final Icon ExternalToolsSmall = IconLoader.getIcon("/general/externalToolsSmall.png"); // 16x16
    public static final Icon Filter = IconLoader.getIcon("/general/filter.png"); // 16x16
    public static final Icon Floating = IconLoader.getIcon("/general/floating.png"); // 14x14
    public static final Icon Gear = IconLoader.getIcon("/general/gear.png"); // 21x16
    public static final Icon GearHover = IconLoader.getIcon("/general/gearHover.png"); // 21x16
    public static final Icon GearPlain = IconLoader.getIcon("/general/gearPlain.png"); // 16x16
    public static final Icon GetProjectfromVCS = IconLoader.getIcon("/general/getProjectfromVCS.png"); // 32x32
    public static final Icon Help = IconLoader.getIcon("/general/help.png"); // 10x10
    public static final Icon Help_small = IconLoader.getIcon("/general/help_small.png"); // 16x16
    public static final Icon HideDown = IconLoader.getIcon("/general/hideDown.png"); // 16x16
    public static final Icon HideDownHover = IconLoader.getIcon("/general/hideDownHover.png"); // 16x16
    public static final Icon HideDownPart = IconLoader.getIcon("/general/hideDownPart.png"); // 16x16
    public static final Icon HideDownPartHover = IconLoader.getIcon("/general/hideDownPartHover.png"); // 16x16
    public static final Icon HideLeft = IconLoader.getIcon("/general/hideLeft.png"); // 16x16
    public static final Icon HideLeftHover = IconLoader.getIcon("/general/hideLeftHover.png"); // 16x16
    public static final Icon HideLeftPart = IconLoader.getIcon("/general/hideLeftPart.png"); // 16x16
    public static final Icon HideLeftPartHover = IconLoader.getIcon("/general/hideLeftPartHover.png"); // 16x16
    public static final Icon HideRight = IconLoader.getIcon("/general/hideRight.png"); // 16x16
    public static final Icon HideRightHover = IconLoader.getIcon("/general/hideRightHover.png"); // 16x16
    public static final Icon HideRightPart = IconLoader.getIcon("/general/hideRightPart.png"); // 16x16
    public static final Icon HideRightPartHover = IconLoader.getIcon("/general/hideRightPartHover.png"); // 16x16
    public static final Icon HideToolWindow = IconLoader.getIcon("/general/hideToolWindow.png"); // 14x14
    public static final Icon HideToolWindowInactive = IconLoader.getIcon("/general/hideToolWindowInactive.png"); // 14x14
    public static final Icon HideWarnings = IconLoader.getIcon("/general/hideWarnings.png"); // 16x16
    public static final Icon IjLogo = IconLoader.getIcon("/general/ijLogo.png"); // 16x16
    public static final Icon ImplementingMethod = IconLoader.getIcon("/general/implementingMethod.png"); // 10x14
    public static final Icon ImportProject = IconLoader.getIcon("/general/importProject.png"); // 32x32
    public static final Icon ImportSettings = IconLoader.getIcon("/general/ImportSettings.png"); // 32x32
    public static final Icon Information = IconLoader.getIcon("/general/information.png"); // 16x16
    public static final Icon InformationDialog = IconLoader.getIcon("/general/informationDialog.png"); // 32x32
    public static final Icon InheritedMethod = IconLoader.getIcon("/general/inheritedMethod.png"); // 11x14
    public static final Icon InspectionsError = IconLoader.getIcon("/general/inspectionsError.png"); // 14x14
    public static final Icon InspectionsEye = IconLoader.getIcon("/general/inspectionsEye.png"); // 14x14
    public static final Icon InspectionsOff = IconLoader.getIcon("/general/inspectionsOff.png"); // 16x16
    public static final Icon InspectionsOK = IconLoader.getIcon("/general/inspectionsOK.png"); // 14x14
    public static final Icon InspectionsPause = IconLoader.getIcon("/general/inspectionsPause.png"); // 14x14
    public static final Icon InspectionsTrafficOff = IconLoader.getIcon("/general/inspectionsTrafficOff.png"); // 14x14
    public static final Icon InspectionsTypos = IconLoader.getIcon("/general/inspectionsTypos.png"); // 14x14
    public static final Icon Jdk = IconLoader.getIcon("/general/jdk.png"); // 16x16
    public static final Icon KeyboardShortcut = IconLoader.getIcon("/general/keyboardShortcut.png"); // 13x13
    public static final Icon Keymap = IconLoader.getIcon("/general/keymap.png"); // 32x32
    public static final Icon Locate = IconLoader.getIcon("/general/locate.png"); // 14x16
    public static final Icon LocateHover = IconLoader.getIcon("/general/locateHover.png"); // 14x16
    public static final Icon MacCorner = IconLoader.getIcon("/general/macCorner.png"); // 16x16
    public static final Icon Mdot_empty = IconLoader.getIcon("/general/mdot-empty.png"); // 8x8
    public static final Icon Mdot_white = IconLoader.getIcon("/general/mdot-white.png"); // 8x8
    public static final Icon Mdot = IconLoader.getIcon("/general/mdot.png"); // 8x8
    public static final Icon MessageHistory = IconLoader.getIcon("/general/messageHistory.png"); // 16x16
    public static final Icon Modified = IconLoader.getIcon("/general/modified.png"); // 24x16
    public static final Icon MoreTabs = IconLoader.getIcon("/general/moreTabs.png"); // 16x16
    public static final Icon Mouse = IconLoader.getIcon("/general/mouse.png"); // 32x32
    public static final Icon MouseShortcut = IconLoader.getIcon("/general/mouseShortcut.png"); // 13x13
    public static final Icon NotificationError = IconLoader.getIcon("/general/notificationError.png"); // 24x24
    public static final Icon NotificationInfo = IconLoader.getIcon("/general/notificationInfo.png"); // 24x24
    public static final Icon NotificationWarning = IconLoader.getIcon("/general/notificationWarning.png"); // 24x24
    public static final Icon OpenProject = IconLoader.getIcon("/general/openProject.png"); // 32x32
    public static final Icon OverridenMethod = IconLoader.getIcon("/general/overridenMethod.png"); // 10x14
    public static final Icon OverridingMethod = IconLoader.getIcon("/general/overridingMethod.png"); // 10x14
    public static final Icon PackagesTab = IconLoader.getIcon("/general/packagesTab.png"); // 16x16
    public static final Icon PasswordLock = IconLoader.getIcon("/general/passwordLock.png"); // 64x64
    public static final Icon PathVariables = IconLoader.getIcon("/general/pathVariables.png"); // 32x32
    public static final Icon Pin_tab = IconLoader.getIcon("/general/pin_tab.png"); // 16x16
    public static final Icon PluginManager = IconLoader.getIcon("/general/pluginManager.png"); // 32x32
    public static final Icon Progress = IconLoader.getIcon("/general/progress.png"); // 8x10
    public static final Icon ProjectConfigurable = IconLoader.getIcon("/general/projectConfigurable.png"); // 9x9
    public static final Icon ProjectConfigurableBanner = IconLoader.getIcon("/general/projectConfigurableBanner.png"); // 9x9
    public static final Icon ProjectConfigurableSelected = IconLoader.getIcon("/general/projectConfigurableSelected.png"); // 9x9
    public static final Icon ProjectSettings = IconLoader.getIcon("/general/projectSettings.png"); // 16x16
    public static final Icon ProjectStructure = IconLoader.getIcon("/general/projectStructure.png"); // 16x16
    public static final Icon ProjectTab = IconLoader.getIcon("/general/projectTab.png"); // 16x16
    public static final Icon QuestionDialog = IconLoader.getIcon("/general/questionDialog.png"); // 32x32
    public static final Icon ReadHelp = IconLoader.getIcon("/general/readHelp.png"); // 32x32
    public static final Icon Remove = IconLoader.getIcon("/general/remove.png"); // 16x16
    public static final Icon Reset = IconLoader.getIcon("/general/reset.png"); // 16x16
    public static final Icon Run = IconLoader.getIcon("/general/run.png"); // 7x10
    public static final Icon RunWithCoverage = IconLoader.getIcon("/general/runWithCoverage.png"); // 16x16
    public static final Icon SafeMode = IconLoader.getIcon("/general/safeMode.png"); // 13x13
    public static final Icon SearchEverywhereGear = IconLoader.getIcon("/general/searchEverywhereGear.png"); // 16x16
    public static final Icon SecondaryGroup = IconLoader.getIcon("/general/secondaryGroup.png"); // 16x16
    public static final Icon SeparatorH = IconLoader.getIcon("/general/separatorH.png"); // 17x11
    public static final Icon Settings = IconLoader.getIcon("/general/settings.png"); // 16x16
    public static final Icon Show_to_implement = IconLoader.getIcon("/general/show_to_implement.png"); // 16x16
    public static final Icon Show_to_override = IconLoader.getIcon("/general/show_to_override.png"); // 16x16
    public static final Icon SmallConfigurableVcs = IconLoader.getIcon("/general/smallConfigurableVcs.png"); // 16x16
    public static final Icon SplitCenterH = IconLoader.getIcon("/general/splitCenterH.png"); // 7x7
    public static final Icon SplitCenterV = IconLoader.getIcon("/general/splitCenterV.png"); // 6x7
    public static final Icon SplitDown = IconLoader.getIcon("/general/splitDown.png"); // 7x7
    public static final Icon SplitGlueH = IconLoader.getIcon("/general/splitGlueH.png"); // 6x17
    public static final Icon SplitGlueV = IconLoader.getIcon("/general/splitGlueV.png"); // 17x6
    public static final Icon SplitLeft = IconLoader.getIcon("/general/splitLeft.png"); // 7x7
    public static final Icon SplitRight = IconLoader.getIcon("/general/splitRight.png"); // 7x7
    public static final Icon SplitUp = IconLoader.getIcon("/general/splitUp.png"); // 7x7
    public static final Icon Tab_white_center = IconLoader.getIcon("/general/tab-white-center.png"); // 1x17
    public static final Icon Tab_white_left = IconLoader.getIcon("/general/tab-white-left.png"); // 4x17
    public static final Icon Tab_white_right = IconLoader.getIcon("/general/tab-white-right.png"); // 4x17
    public static final Icon Tab_grey_bckgrnd = IconLoader.getIcon("/general/tab_grey_bckgrnd.png"); // 1x17
    public static final Icon Tab_grey_left = IconLoader.getIcon("/general/tab_grey_left.png"); // 4x17
    public static final Icon Tab_grey_left_inner = IconLoader.getIcon("/general/tab_grey_left_inner.png"); // 4x17
    public static final Icon Tab_grey_right = IconLoader.getIcon("/general/tab_grey_right.png"); // 4x17
    public static final Icon Tab_grey_right_inner = IconLoader.getIcon("/general/tab_grey_right_inner.png"); // 4x17
    public static final Icon TbHidden = IconLoader.getIcon("/general/tbHidden.png"); // 16x16
    public static final Icon TbShown = IconLoader.getIcon("/general/tbShown.png"); // 16x16
    public static final Icon TemplateProjectSettings = IconLoader.getIcon("/general/TemplateProjectSettings.png"); // 32x32
    public static final Icon TemplateProjectStructure = IconLoader.getIcon("/general/TemplateProjectStructure.png"); // 32x32
    public static final Icon Tip = IconLoader.getIcon("/general/tip.png"); // 32x32
    public static final Icon TodoDefault = IconLoader.getIcon("/general/todoDefault.png"); // 12x12
    public static final Icon TodoImportant = IconLoader.getIcon("/general/todoImportant.png"); // 12x12
    public static final Icon TodoQuestion = IconLoader.getIcon("/general/todoQuestion.png"); // 12x12
    public static final Icon UninstallPlugin = IconLoader.getIcon("/general/uninstallPlugin.png"); // 16x16
    public static final Icon Warning = IconLoader.getIcon("/general/warning.png"); // 16x16
    public static final Icon WarningDecorator = IconLoader.getIcon("/general/warningDecorator.png"); // 16x16
    public static final Icon WarningDialog = IconLoader.getIcon("/general/warningDialog.png"); // 32x32
    public static final Icon Web = IconLoader.getIcon("/general/web.png"); // 13x13
    public static final Icon WebSettings = IconLoader.getIcon("/general/webSettings.png"); // 16x16

  }
  
  public static class Graph {
    public static final Icon ActualZoom = IconLoader.getIcon("/graph/actualZoom.png"); // 16x16
    public static final Icon Export = IconLoader.getIcon("/graph/export.png"); // 16x16
    public static final Icon FitContent = IconLoader.getIcon("/graph/fitContent.png"); // 16x16
    public static final Icon Grid = IconLoader.getIcon("/graph/grid.png"); // 16x16
    public static final Icon Layout = IconLoader.getIcon("/graph/layout.png"); // 16x16
    public static final Icon NodeSelectionMode = IconLoader.getIcon("/graph/nodeSelectionMode.png"); // 16x16
    public static final Icon Print = IconLoader.getIcon("/graph/print.png"); // 16x16
    public static final Icon PrintPreview = IconLoader.getIcon("/graph/printPreview.png"); // 16x16
    public static final Icon SnapToGrid = IconLoader.getIcon("/graph/snapToGrid.png"); // 16x16
    public static final Icon ZoomIn = IconLoader.getIcon("/graph/zoomIn.png"); // 16x16
    public static final Icon ZoomOut = IconLoader.getIcon("/graph/zoomOut.png"); // 16x16

  }
  
  public static class Gutter {
    public static final Icon Colors = IconLoader.getIcon("/gutter/colors.png"); // 12x12
    public static final Icon ExtAnnotation = IconLoader.getIcon("/gutter/extAnnotation.png"); // 12x12
    public static final Icon ImplementedMethod = IconLoader.getIcon("/gutter/implementedMethod.png"); // 12x12
    public static final Icon ImplementingFunctionalInterface = IconLoader.getIcon("/gutter/implementingFunctionalInterface.png"); // 12x12
    public static final Icon ImplementingMethod = IconLoader.getIcon("/gutter/implementingMethod.png"); // 12x12
    public static final Icon OverridenMethod = IconLoader.getIcon("/gutter/overridenMethod.png"); // 12x12
    public static final Icon OverridingMethod = IconLoader.getIcon("/gutter/overridingMethod.png"); // 12x12
    public static final Icon RecursiveMethod = IconLoader.getIcon("/gutter/recursiveMethod.png"); // 12x12
    public static final Icon Unique = IconLoader.getIcon("/gutter/unique.png"); // 8x8

  }
  
  public static class Hierarchy {
    public static final Icon Base = IconLoader.getIcon("/hierarchy/base.png"); // 16x16
    public static final Icon Callee = IconLoader.getIcon("/hierarchy/callee.png"); // 16x16
    public static final Icon Caller = IconLoader.getIcon("/hierarchy/caller.png"); // 16x16
    public static final Icon Class = IconLoader.getIcon("/hierarchy/class.png"); // 16x16
    public static final Icon MethodDefined = IconLoader.getIcon("/hierarchy/methodDefined.png"); // 9x9
    public static final Icon MethodNotDefined = IconLoader.getIcon("/hierarchy/methodNotDefined.png"); // 8x8
    public static final Icon ShouldDefineMethod = IconLoader.getIcon("/hierarchy/shouldDefineMethod.png"); // 9x9
    public static final Icon Subtypes = IconLoader.getIcon("/hierarchy/subtypes.png"); // 16x16
    public static final Icon Supertypes = IconLoader.getIcon("/hierarchy/supertypes.png"); // 16x16

  }
  public static final Icon Icon = IconLoader.getIcon("/icon.png"); // 32x32
  public static final Icon Icon_128 = IconLoader.getIcon("/icon_128.png"); // 128x128
  public static final Icon Icon_CE = IconLoader.getIcon("/icon_CE.png"); // 32x32
  public static final Icon Icon_CE_128 = IconLoader.getIcon("/icon_CE_128.png"); // 128x128
  public static final Icon Icon_CEsmall = IconLoader.getIcon("/icon_CEsmall.png"); // 16x16
  public static final Icon Icon_small = IconLoader.getIcon("/icon_small.png"); // 16x16
  
  public static class Icons {
    
    public static class Ide {
      public static final Icon NextStep = IconLoader.getIcon("/icons/ide/nextStep.png"); // 12x12
      public static final Icon NextStepGrayed = IconLoader.getIcon("/icons/ide/nextStepGrayed.png"); // 12x12
      public static final Icon NextStepInverted = IconLoader.getIcon("/icons/ide/nextStepInverted.png"); // 12x12
      public static final Icon SpeedSearchPrompt = IconLoader.getIcon("/icons/ide/speedSearchPrompt.png"); // 16x16

    }

  }
  
  public static class Ide {
    
    public static class Dnd {
      public static final Icon Bottom = IconLoader.getIcon("/ide/dnd/bottom.png"); // 16x16
      public static final Icon Left = IconLoader.getIcon("/ide/dnd/left.png"); // 16x16
      public static final Icon Right = IconLoader.getIcon("/ide/dnd/right.png"); // 16x16
      public static final Icon Top = IconLoader.getIcon("/ide/dnd/top.png"); // 16x16

    }
    public static final Icon EmptyFatalError = IconLoader.getIcon("/ide/emptyFatalError.png"); // 16x16
    public static final Icon Error = IconLoader.getIcon("/ide/error.png"); // 16x16
    public static final Icon Error_notifications = IconLoader.getIcon("/ide/error_notifications.png"); // 16x16
    public static final Icon ErrorPoint = IconLoader.getIcon("/ide/errorPoint.png"); // 6x6
    public static final Icon FatalError_read = IconLoader.getIcon("/ide/fatalError-read.png"); // 16x16
    public static final Icon FatalError = IconLoader.getIcon("/ide/fatalError.png"); // 16x16
    public static final Icon HectorNo = IconLoader.getIcon("/ide/hectorNo.png"); // 16x16
    public static final Icon HectorOff = IconLoader.getIcon("/ide/hectorOff.png"); // 16x16
    public static final Icon HectorOn = IconLoader.getIcon("/ide/hectorOn.png"); // 16x16
    public static final Icon HectorSyntax = IconLoader.getIcon("/ide/hectorSyntax.png"); // 16x16
    public static final Icon IncomingChangesOff = IconLoader.getIcon("/ide/incomingChangesOff.png"); // 16x16
    public static final Icon IncomingChangesOn = IconLoader.getIcon("/ide/incomingChangesOn.png"); // 16x16
    public static final Icon Info_notifications = IconLoader.getIcon("/ide/info_notifications.png"); // 16x16
    public static final Icon Link = IconLoader.getIcon("/ide/link.png"); // 12x12
    public static final Icon LocalScope = IconLoader.getIcon("/ide/localScope.png"); // 16x16
    public static final Icon LookupAlphanumeric = IconLoader.getIcon("/ide/lookupAlphanumeric.png"); // 12x12
    public static final Icon LookupRelevance = IconLoader.getIcon("/ide/lookupRelevance.png"); // 12x12
    
    public static class Macro {
      public static final Icon Recording_1 = IconLoader.getIcon("/ide/macro/recording_1.png"); // 16x16
      public static final Icon Recording_2 = IconLoader.getIcon("/ide/macro/recording_2.png"); // 16x16
      public static final Icon Recording_3 = IconLoader.getIcon("/ide/macro/recording_3.png"); // 16x16
      public static final Icon Recording_4 = IconLoader.getIcon("/ide/macro/recording_4.png"); // 16x16
      public static final Icon Recording_stop = IconLoader.getIcon("/ide/macro/recording_stop.png"); // 16x16

    }
    public static final Icon NoNotifications13 = IconLoader.getIcon("/ide/noNotifications13.png"); // 13x13
    
    public static class Notification {
      public static final Icon Close = IconLoader.getIcon("/ide/notification/close.png"); // 16x16
      public static final Icon CloseHover = IconLoader.getIcon("/ide/notification/closeHover.png"); // 16x16
      public static final Icon Collapse = IconLoader.getIcon("/ide/notification/collapse.png"); // 16x16
      public static final Icon CollapseHover = IconLoader.getIcon("/ide/notification/collapseHover.png"); // 16x16
      public static final Icon DropTriangle = IconLoader.getIcon("/ide/notification/dropTriangle.png"); // 11x8
      public static final Icon Expand = IconLoader.getIcon("/ide/notification/expand.png"); // 16x16
      public static final Icon ExpandHover = IconLoader.getIcon("/ide/notification/expandHover.png"); // 16x16
      public static final Icon Gear = IconLoader.getIcon("/ide/notification/gear.png"); // 16x16
      public static final Icon GearHover = IconLoader.getIcon("/ide/notification/gearHover.png"); // 16x16
      
      public static class Shadow {
        public static final Icon Bottom_left = IconLoader.getIcon("/ide/notification/shadow/bottom-left.png"); // 14x16
        public static final Icon Bottom_right = IconLoader.getIcon("/ide/notification/shadow/bottom-right.png"); // 14x16
        public static final Icon Bottom = IconLoader.getIcon("/ide/notification/shadow/bottom.png"); // 4x8
        public static final Icon Left = IconLoader.getIcon("/ide/notification/shadow/left.png"); // 6x4
        public static final Icon Right = IconLoader.getIcon("/ide/notification/shadow/right.png"); // 6x4
        public static final Icon Top_left = IconLoader.getIcon("/ide/notification/shadow/top-left.png"); // 14x12
        public static final Icon Top_right = IconLoader.getIcon("/ide/notification/shadow/top-right.png"); // 14x12
        public static final Icon Top = IconLoader.getIcon("/ide/notification/shadow/top.png"); // 4x4

      }

    }
    public static final Icon Notifications = IconLoader.getIcon("/ide/notifications.png"); // 16x16
    public static final Icon OutgoingChangesOn = IconLoader.getIcon("/ide/outgoingChangesOn.png"); // 16x16
    public static final Icon Pipette = IconLoader.getIcon("/ide/pipette.png"); // 16x16
    public static final Icon Pipette_rollover = IconLoader.getIcon("/ide/pipette_rollover.png"); // 16x16
    public static final Icon Rating = IconLoader.getIcon("/ide/rating.png"); // 11x11
    public static final Icon Rating1 = IconLoader.getIcon("/ide/rating1.png"); // 11x11
    public static final Icon Rating2 = IconLoader.getIcon("/ide/rating2.png"); // 11x11
    public static final Icon Rating3 = IconLoader.getIcon("/ide/rating3.png"); // 11x11
    public static final Icon Rating4 = IconLoader.getIcon("/ide/rating4.png"); // 11x11
    public static final Icon Readonly = IconLoader.getIcon("/ide/readonly.png"); // 16x16
    public static final Icon Readwrite = IconLoader.getIcon("/ide/readwrite.png"); // 16x16
    
    public static class Shadow {
      public static final Icon Bottom_left = IconLoader.getIcon("/ide/shadow/bottom-left.png"); // 70x70
      public static final Icon Bottom_right = IconLoader.getIcon("/ide/shadow/bottom-right.png"); // 70x70
      public static final Icon Bottom = IconLoader.getIcon("/ide/shadow/bottom.png"); // 1x49
      public static final Icon Left = IconLoader.getIcon("/ide/shadow/left.png"); // 35x1
      
      public static class Popup {
        public static final Icon Bottom_left = IconLoader.getIcon("/ide/shadow/popup/bottom-left.png"); // 20x20
        public static final Icon Bottom_right = IconLoader.getIcon("/ide/shadow/popup/bottom-right.png"); // 20x20
        public static final Icon Bottom = IconLoader.getIcon("/ide/shadow/popup/bottom.png"); // 1x10
        public static final Icon Left = IconLoader.getIcon("/ide/shadow/popup/left.png"); // 7x1
        public static final Icon Right = IconLoader.getIcon("/ide/shadow/popup/right.png"); // 7x1
        public static final Icon Top_left = IconLoader.getIcon("/ide/shadow/popup/top-left.png"); // 14x14
        public static final Icon Top_right = IconLoader.getIcon("/ide/shadow/popup/top-right.png"); // 14x14
        public static final Icon Top = IconLoader.getIcon("/ide/shadow/popup/top.png"); // 1x4

      }
      public static final Icon Right = IconLoader.getIcon("/ide/shadow/right.png"); // 35x1
      public static final Icon Top_left = IconLoader.getIcon("/ide/shadow/top-left.png"); // 70x70
      public static final Icon Top_right = IconLoader.getIcon("/ide/shadow/top-right.png"); // 70x70
      public static final Icon Top = IconLoader.getIcon("/ide/shadow/top.png"); // 1x20

    }
    public static final Icon Statusbar_arrows = IconLoader.getIcon("/ide/statusbar_arrows.png"); // 7x10
    public static final Icon UpDown = IconLoader.getIcon("/ide/upDown.png"); // 16x16
    public static final Icon Warning_notifications = IconLoader.getIcon("/ide/warning_notifications.png"); // 16x16

  }
  public static final Icon Idea_logo_background = IconLoader.getIcon("/idea_logo_background.png"); // 500x500
  public static final Icon Idea_logo_welcome = IconLoader.getIcon("/idea_logo_welcome.png"); // 100x100
  
  public static class Javaee {
    public static final Icon Application_xml = IconLoader.getIcon("/javaee/application_xml.png"); // 16x16
    public static final Icon BuildOnFrameDeactivation = IconLoader.getIcon("/javaee/buildOnFrameDeactivation.png"); // 16x16
    public static final Icon DataSourceImport = IconLoader.getIcon("/javaee/dataSourceImport.png"); // 16x16
    public static final Icon DbSchemaImportBig = IconLoader.getIcon("/javaee/dbSchemaImportBig.png"); // 32x32
    public static final Icon Ejb_jar_xml = IconLoader.getIcon("/javaee/ejb-jar_xml.png"); // 16x16
    public static final Icon EjbClass = IconLoader.getIcon("/javaee/ejbClass.png"); // 16x16
    public static final Icon EjbModule = IconLoader.getIcon("/javaee/ejbModule.png"); // 16x16
    public static final Icon EmbeddedAttributeOverlay = IconLoader.getIcon("/javaee/embeddedAttributeOverlay.png"); // 16x16
    public static final Icon EntityBean = IconLoader.getIcon("/javaee/entityBean.png"); // 16x16
    public static final Icon EntityBeanBig = IconLoader.getIcon("/javaee/entityBeanBig.png"); // 24x24
    public static final Icon Home = IconLoader.getIcon("/javaee/home.png"); // 16x16
    public static final Icon InheritedAttributeOverlay = IconLoader.getIcon("/javaee/inheritedAttributeOverlay.png"); // 16x16
    public static final Icon InterceptorClass = IconLoader.getIcon("/javaee/interceptorClass.png"); // 16x16
    public static final Icon InterceptorMethod = IconLoader.getIcon("/javaee/interceptorMethod.png"); // 16x16
    public static final Icon JavaeeAppModule = IconLoader.getIcon("/javaee/JavaeeAppModule.png"); // 16x16
    public static final Icon JpaFacet = IconLoader.getIcon("/javaee/jpaFacet.png"); // 16x16
    public static final Icon Local = IconLoader.getIcon("/javaee/local.png"); // 16x16
    public static final Icon LocalHome = IconLoader.getIcon("/javaee/localHome.png"); // 16x16
    public static final Icon MessageBean = IconLoader.getIcon("/javaee/messageBean.png"); // 16x16
    public static final Icon PersistenceAttribute = IconLoader.getIcon("/javaee/persistenceAttribute.png"); // 16x16
    public static final Icon PersistenceEmbeddable = IconLoader.getIcon("/javaee/persistenceEmbeddable.png"); // 16x16
    public static final Icon PersistenceEntity = IconLoader.getIcon("/javaee/persistenceEntity.png"); // 16x16
    public static final Icon PersistenceEntityListener = IconLoader.getIcon("/javaee/persistenceEntityListener.png"); // 16x16
    public static final Icon PersistenceId = IconLoader.getIcon("/javaee/persistenceId.png"); // 16x16
    public static final Icon PersistenceIdRelationship = IconLoader.getIcon("/javaee/persistenceIdRelationship.png"); // 16x16
    public static final Icon PersistenceMappedSuperclass = IconLoader.getIcon("/javaee/persistenceMappedSuperclass.png"); // 16x16
    public static final Icon PersistenceRelationship = IconLoader.getIcon("/javaee/persistenceRelationship.png"); // 16x16
    public static final Icon PersistenceUnit = IconLoader.getIcon("/javaee/persistenceUnit.png"); // 16x16
    public static final Icon Remote = IconLoader.getIcon("/javaee/remote.png"); // 16x16
    public static final Icon SessionBean = IconLoader.getIcon("/javaee/sessionBean.png"); // 16x16
    public static final Icon UpdateRunningApplication = IconLoader.getIcon("/javaee/updateRunningApplication.png"); // 16x16
    public static final Icon Web_xml = IconLoader.getIcon("/javaee/web_xml.png"); // 16x16
    public static final Icon WebModule = IconLoader.getIcon("/javaee/webModule.png"); // 16x16
    public static final Icon WebModuleGroup = IconLoader.getIcon("/javaee/webModuleGroup.png"); // 16x16
    public static final Icon WebService = IconLoader.getIcon("/javaee/WebService.png"); // 16x16
    public static final Icon WebService2 = IconLoader.getIcon("/javaee/WebService2.png"); // 16x16
    public static final Icon WebServiceClient = IconLoader.getIcon("/javaee/WebServiceClient.png"); // 16x16
    public static final Icon WebServiceClient2 = IconLoader.getIcon("/javaee/WebServiceClient2.png"); // 16x16

  }
  
  public static class Json {
    public static final Icon Array = IconLoader.getIcon("/json/array.png"); // 16x16
    public static final Icon Object = IconLoader.getIcon("/json/object.png"); // 16x16
    public static final Icon Property_braces = IconLoader.getIcon("/json/property_braces.png"); // 16x16
    public static final Icon Property_brackets = IconLoader.getIcon("/json/property_brackets.png"); // 16x16

  }
  public static final Icon Logo_welcomeScreen = IconLoader.getIcon("/Logo_welcomeScreen.png"); // 80x80
  
  public static class Mac {
    public static final Icon AppIconOk512 = IconLoader.getIcon("/mac/appIconOk512.png"); // 55x55
    public static final Icon Text = IconLoader.getIcon("/mac/text.gif"); // 32x32
    public static final Icon Tree_white_down_arrow = IconLoader.getIcon("/mac/tree_white_down_arrow.png"); // 11x11
    public static final Icon Tree_white_right_arrow = IconLoader.getIcon("/mac/tree_white_right_arrow.png"); // 11x11
    public static final Icon YosemiteOptionButtonSelector = IconLoader.getIcon("/mac/yosemiteOptionButtonSelector.png"); // 8x12

  }
  
  public static class Modules {
    public static final Icon AddContentEntry = IconLoader.getIcon("/modules/addContentEntry.png"); // 16x16
    public static final Icon AddExcludedRoot = IconLoader.getIcon("/modules/addExcludedRoot.png"); // 16x16
    public static final Icon Annotation = IconLoader.getIcon("/modules/annotation.png"); // 16x16
    public static final Icon DeleteContentFolder = IconLoader.getIcon("/modules/deleteContentFolder.png"); // 9x9
    public static final Icon DeleteContentFolderRollover = IconLoader.getIcon("/modules/deleteContentFolderRollover.png"); // 9x9
    public static final Icon DeleteContentRoot = IconLoader.getIcon("/modules/deleteContentRoot.png"); // 9x9
    public static final Icon DeleteContentRootRollover = IconLoader.getIcon("/modules/deleteContentRootRollover.png"); // 9x9
    public static final Icon Edit = IconLoader.getIcon("/modules/edit.png"); // 14x14
    public static final Icon EditFolder = IconLoader.getIcon("/modules/editFolder.png"); // 16x16
    public static final Icon ExcludedGeneratedRoot = IconLoader.getIcon("/modules/excludedGeneratedRoot.png"); // 16x16
    public static final Icon ExcludeRoot = IconLoader.getIcon("/modules/excludeRoot.png"); // 16x16
    public static final Icon GeneratedFolder = IconLoader.getIcon("/modules/generatedFolder.png"); // 16x16
    public static final Icon GeneratedSourceRoot = IconLoader.getIcon("/modules/generatedSourceRoot.png"); // 16x16
    public static final Icon GeneratedTestRoot = IconLoader.getIcon("/modules/generatedTestRoot.png"); // 16x16
    public static final Icon Library = IconLoader.getIcon("/modules/library.png"); // 16x16
    public static final Icon Merge = IconLoader.getIcon("/modules/merge.png"); // 16x16
    public static final Icon ModulesNode = IconLoader.getIcon("/modules/modulesNode.png"); // 16x16
    public static final Icon Output = IconLoader.getIcon("/modules/output.png"); // 16x16
    public static final Icon ResourcesRoot = IconLoader.getIcon("/modules/resourcesRoot.png"); // 16x16
    public static final Icon SetPackagePrefix = IconLoader.getIcon("/modules/setPackagePrefix.png"); // 9x9
    public static final Icon SetPackagePrefixRollover = IconLoader.getIcon("/modules/setPackagePrefixRollover.png"); // 9x9
    public static final Icon SourceFolder = IconLoader.getIcon("/modules/sourceFolder.png"); // 16x16
    public static final Icon SourceRoot = IconLoader.getIcon("/modules/sourceRoot.png"); // 16x16
    public static final Icon Sources = IconLoader.getIcon("/modules/sources.png"); // 16x16
    public static final Icon Split = IconLoader.getIcon("/modules/split.png"); // 16x16
    public static final Icon TestResourcesRoot = IconLoader.getIcon("/modules/testResourcesRoot.png"); // 16x16
    public static final Icon TestRoot = IconLoader.getIcon("/modules/testRoot.png"); // 16x16
    public static final Icon TestSourceFolder = IconLoader.getIcon("/modules/testSourceFolder.png"); // 16x16
    
    public static class Types {
      public static final Icon EjbModule = IconLoader.getIcon("/modules/types/ejbModule.png"); // 24x24
      public static final Icon EmptyProjectType = IconLoader.getIcon("/modules/types/emptyProjectType.png"); // 24x24
      public static final Icon JavaeeAppModule = IconLoader.getIcon("/modules/types/JavaeeAppModule.png"); // 24x24
      public static final Icon JavaModule = IconLoader.getIcon("/modules/types/javaModule.png"); // 24x24
      public static final Icon PluginModule = IconLoader.getIcon("/modules/types/pluginModule.png"); // 24x24
      public static final Icon UserDefined = IconLoader.getIcon("/modules/types/userDefined.png"); // 16x16
      public static final Icon WebModule = IconLoader.getIcon("/modules/types/webModule.png"); // 24x24

    }
    public static final Icon UnmarkWebroot = IconLoader.getIcon("/modules/unmarkWebroot.png"); // 16x16
    public static final Icon WebRoot = IconLoader.getIcon("/modules/webRoot.png"); // 16x16

  }
  
  public static class Nodes {
    public static final Icon AbstractClass = IconLoader.getIcon("/nodes/abstractClass.png"); // 16x16
    public static final Icon AbstractException = IconLoader.getIcon("/nodes/abstractException.png"); // 16x16
    public static final Icon AbstractMethod = IconLoader.getIcon("/nodes/abstractMethod.png"); // 16x16
    public static final Icon Advice = IconLoader.getIcon("/nodes/advice.png"); // 16x16
    public static final Icon Annotationtype = IconLoader.getIcon("/nodes/annotationtype.png"); // 16x16
    public static final Icon AnonymousClass = IconLoader.getIcon("/nodes/anonymousClass.png"); // 16x16
    public static final Icon Artifact = IconLoader.getIcon("/nodes/artifact.png"); // 16x16
    public static final Icon Aspect = IconLoader.getIcon("/nodes/aspect.png"); // 14x14
    public static final Icon C_plocal = IconLoader.getIcon("/nodes/c_plocal.png"); // 16x16
    public static final Icon C_private = IconLoader.getIcon("/nodes/c_private.png"); // 16x16
    public static final Icon C_protected = IconLoader.getIcon("/nodes/c_protected.png"); // 16x16
    public static final Icon C_public = IconLoader.getIcon("/nodes/c_public.png"); // 16x16
    public static final Icon Class = IconLoader.getIcon("/nodes/class.png"); // 16x16
    public static final Icon ClassInitializer = IconLoader.getIcon("/nodes/classInitializer.png"); // 16x16
    public static final Icon CollapseNode = IconLoader.getIcon("/nodes/collapseNode.png"); // 9x9
    public static final Icon CompiledClassesFolder = IconLoader.getIcon("/nodes/compiledClassesFolder.png"); // 16x16
    public static final Icon CopyOfFolder = IconLoader.getIcon("/nodes/copyOfFolder.png"); // 16x16
    public static final Icon CustomRegion = IconLoader.getIcon("/nodes/customRegion.png"); // 16x16
    public static final Icon Cvs_global = IconLoader.getIcon("/nodes/cvs_global.png"); // 16x16
    public static final Icon Cvs_roots = IconLoader.getIcon("/nodes/cvs_roots.png"); // 16x16
    public static final Icon DataColumn = IconLoader.getIcon("/nodes/dataColumn.png"); // 16x16
    public static final Icon DataSchema = IconLoader.getIcon("/nodes/dataSchema.png"); // 16x16
    public static final Icon DataSource = IconLoader.getIcon("/nodes/DataSource.png"); // 16x16
    public static final Icon DataTables = IconLoader.getIcon("/nodes/DataTables.png"); // 16x16
    public static final Icon DataView = IconLoader.getIcon("/nodes/dataView.png"); // 16x16
    public static final Icon Deploy = IconLoader.getIcon("/nodes/deploy.png"); // 16x16
    public static final Icon Desktop = IconLoader.getIcon("/nodes/desktop.png"); // 16x16
    public static final Icon DisabledPointcut = IconLoader.getIcon("/nodes/disabledPointcut.png"); // 16x16
    public static final Icon Ejb = IconLoader.getIcon("/nodes/ejb.png"); // 16x16
    public static final Icon EjbBusinessMethod = IconLoader.getIcon("/nodes/ejbBusinessMethod.png"); // 16x16
    public static final Icon EjbCmpField = IconLoader.getIcon("/nodes/ejbCmpField.png"); // 16x16
    public static final Icon EjbCmrField = IconLoader.getIcon("/nodes/ejbCmrField.png"); // 16x16
    public static final Icon EjbCreateMethod = IconLoader.getIcon("/nodes/ejbCreateMethod.png"); // 16x16
    public static final Icon EjbFinderMethod = IconLoader.getIcon("/nodes/ejbFinderMethod.png"); // 16x16
    public static final Icon EjbPrimaryKeyClass = IconLoader.getIcon("/nodes/ejbPrimaryKeyClass.png"); // 16x16
    public static final Icon EjbReference = IconLoader.getIcon("/nodes/ejbReference.png"); // 16x16
    public static final Icon EmptyNode = IconLoader.getIcon("/nodes/emptyNode.png"); // 18x18
    public static final Icon EnterpriseProject = IconLoader.getIcon("/nodes/enterpriseProject.png"); // 16x16
    public static final Icon EntryPoints = IconLoader.getIcon("/nodes/entryPoints.png"); // 16x16
    public static final Icon Enum = IconLoader.getIcon("/nodes/enum.png"); // 16x16
    public static final Icon ErrorIntroduction = IconLoader.getIcon("/nodes/errorIntroduction.png"); // 16x16
    public static final Icon ErrorMark = IconLoader.getIcon("/nodes/errorMark.png"); // 16x16
    public static final Icon ExceptionClass = IconLoader.getIcon("/nodes/exceptionClass.png"); // 16x16
    public static final Icon ExcludedFromCompile = IconLoader.getIcon("/nodes/excludedFromCompile.png"); // 16x16
    public static final Icon ExpandNode = IconLoader.getIcon("/nodes/expandNode.png"); // 9x9
    public static final Icon ExtractedFolder = IconLoader.getIcon("/nodes/extractedFolder.png"); // 16x16
    public static final Icon Field = IconLoader.getIcon("/nodes/field.png"); // 16x16
    public static final Icon FieldPK = IconLoader.getIcon("/nodes/fieldPK.png"); // 16x16
    public static final Icon FinalMark = IconLoader.getIcon("/nodes/finalMark.png"); // 16x16
    public static final Icon Folder = IconLoader.getIcon("/nodes/folder.png"); // 16x16
    public static final Icon Function = IconLoader.getIcon("/nodes/function.png"); // 16x16
    public static final Icon HomeFolder = IconLoader.getIcon("/nodes/homeFolder.png"); // 16x16
    public static final Icon IdeaModule = IconLoader.getIcon("/nodes/ideaModule.png"); // 16x16
    public static final Icon IdeaProject = IconLoader.getIcon("/nodes/ideaProject.png"); // 16x16
    public static final Icon IdeaWorkspace = IconLoader.getIcon("/nodes/ideaWorkspace.png"); // 16x16
    public static final Icon InspectionResults = IconLoader.getIcon("/nodes/inspectionResults.png"); // 16x16
    public static final Icon Interface = IconLoader.getIcon("/nodes/interface.png"); // 16x16
    public static final Icon J2eeParameter = IconLoader.getIcon("/nodes/j2eeParameter.png"); // 16x16
    public static final Icon JarDirectory = IconLoader.getIcon("/nodes/jarDirectory.png"); // 16x16
    public static final Icon JavaDocFolder = IconLoader.getIcon("/nodes/javaDocFolder.png"); // 16x16
    
    public static class Jsf {
      public static final Icon Component = IconLoader.getIcon("/nodes/jsf/component.png"); // 16x16
      public static final Icon Converter = IconLoader.getIcon("/nodes/jsf/converter.png"); // 16x16
      public static final Icon General = IconLoader.getIcon("/nodes/jsf/general.png"); // 16x16
      public static final Icon GenericValue = IconLoader.getIcon("/nodes/jsf/genericValue.png"); // 18x18
      public static final Icon ManagedBean = IconLoader.getIcon("/nodes/jsf/managedBean.png"); // 16x16
      public static final Icon NavigationCase = IconLoader.getIcon("/nodes/jsf/navigationCase.png"); // 18x18
      public static final Icon NavigationRule = IconLoader.getIcon("/nodes/jsf/navigationRule.png"); // 16x16
      public static final Icon Renderer = IconLoader.getIcon("/nodes/jsf/renderer.png"); // 16x16
      public static final Icon RenderKit = IconLoader.getIcon("/nodes/jsf/renderKit.png"); // 16x16
      public static final Icon Validator = IconLoader.getIcon("/nodes/jsf/validator.png"); // 16x16

    }
    public static final Icon Jsr45 = IconLoader.getIcon("/nodes/jsr45.png"); // 16x16
    public static final Icon JunitTestMark = IconLoader.getIcon("/nodes/junitTestMark.png"); // 16x16
    public static final Icon KeymapAnt = IconLoader.getIcon("/nodes/keymapAnt.png"); // 16x16
    public static final Icon KeymapEditor = IconLoader.getIcon("/nodes/keymapEditor.png"); // 16x16
    public static final Icon KeymapMainMenu = IconLoader.getIcon("/nodes/keymapMainMenu.png"); // 16x16
    public static final Icon KeymapOther = IconLoader.getIcon("/nodes/keymapOther.png"); // 16x16
    public static final Icon KeymapTools = IconLoader.getIcon("/nodes/keymapTools.png"); // 16x16
    public static final Icon Locked = IconLoader.getIcon("/nodes/locked.png"); // 16x16
    public static final Icon Method = IconLoader.getIcon("/nodes/method.png"); // 16x16
    public static final Icon MethodReference = IconLoader.getIcon("/nodes/methodReference.png"); // 16x16
    public static final Icon Module = IconLoader.getIcon("/nodes/Module.png"); // 16x16
    public static final Icon ModuleGroup = IconLoader.getIcon("/nodes/moduleGroup.png"); // 16x16
    public static final Icon NativeLibrariesFolder = IconLoader.getIcon("/nodes/nativeLibrariesFolder.png"); // 16x16
    public static final Icon NewException = IconLoader.getIcon("/nodes/newException.png"); // 14x14
    public static final Icon NewFolder = IconLoader.getIcon("/nodes/newFolder.png"); // 16x16
    public static final Icon NewParameter = IconLoader.getIcon("/nodes/newParameter.png"); // 14x14
    public static final Icon NodePlaceholder = IconLoader.getIcon("/nodes/nodePlaceholder.png"); // 16x16
    public static final Icon Package = IconLoader.getIcon("/nodes/package.png"); // 16x16
    public static final Icon Padlock = IconLoader.getIcon("/nodes/padlock.png"); // 16x16
    public static final Icon Parameter = IconLoader.getIcon("/nodes/parameter.png"); // 16x16
    public static final Icon PinToolWindow = IconLoader.getIcon("/nodes/pinToolWindow.png"); // 13x13
    public static final Icon Plugin = IconLoader.getIcon("/nodes/plugin.png"); // 16x16
    public static final Icon PluginJB = IconLoader.getIcon("/nodes/pluginJB.png"); // 16x16
    public static final Icon PluginLogo = IconLoader.getIcon("/nodes/pluginLogo.png"); // 32x32
    public static final Icon Pluginnotinstalled = IconLoader.getIcon("/nodes/pluginnotinstalled.png"); // 16x16
    public static final Icon Pluginobsolete = IconLoader.getIcon("/nodes/pluginobsolete.png"); // 16x16
    public static final Icon PluginRestart = IconLoader.getIcon("/nodes/pluginRestart.png"); // 16x16
    public static final Icon PluginUpdate = IconLoader.getIcon("/nodes/pluginUpdate.png"); // 16x16
    public static final Icon Pointcut = IconLoader.getIcon("/nodes/pointcut.png"); // 16x16
    public static final Icon PpFile = IconLoader.getIcon("/nodes/ppFile.png"); // 16x16
    public static final Icon PpInvalid = IconLoader.getIcon("/nodes/ppInvalid.png"); // 16x16
    public static final Icon PpJar = IconLoader.getIcon("/nodes/ppJar.png"); // 16x16
    public static final Icon PpJdk = IconLoader.getIcon("/nodes/ppJdk.png"); // 16x16
    public static final Icon PpLib = IconLoader.getIcon("/nodes/ppLib.png"); // 16x16
    public static final Icon PpLibFolder = IconLoader.getIcon("/nodes/ppLibFolder.png"); // 16x16
    public static final Icon PpWeb = IconLoader.getIcon("/nodes/ppWeb.png"); // 16x16
    public static final Icon PpWebLogo = IconLoader.getIcon("/nodes/ppWebLogo.png"); // 32x32
    public static final Icon Project = IconLoader.getIcon("/nodes/project.png"); // 16x16
    public static final Icon Property = IconLoader.getIcon("/nodes/property.png"); // 16x16
    public static final Icon PropertyRead = IconLoader.getIcon("/nodes/propertyRead.png"); // 16x16
    public static final Icon PropertyReadStatic = IconLoader.getIcon("/nodes/propertyReadStatic.png"); // 16x16
    public static final Icon PropertyReadWrite = IconLoader.getIcon("/nodes/propertyReadWrite.png"); // 16x16
    public static final Icon PropertyReadWriteStatic = IconLoader.getIcon("/nodes/propertyReadWriteStatic.png"); // 16x16
    public static final Icon PropertyWrite = IconLoader.getIcon("/nodes/propertyWrite.png"); // 16x16
    public static final Icon PropertyWriteStatic = IconLoader.getIcon("/nodes/propertyWriteStatic.png"); // 16x16
    public static final Icon Read_access = IconLoader.getIcon("/nodes/read-access.png"); // 13x9
    public static final Icon ResourceBundle = IconLoader.getIcon("/nodes/resourceBundle.png"); // 16x16
    public static final Icon RunnableMark = IconLoader.getIcon("/nodes/runnableMark.png"); // 16x16
    public static final Icon Rw_access = IconLoader.getIcon("/nodes/rw-access.png"); // 13x9
    public static final Icon SecurityRole = IconLoader.getIcon("/nodes/SecurityRole.png"); // 16x16
    public static final Icon Servlet = IconLoader.getIcon("/nodes/servlet.png"); // 16x16
    public static final Icon Shared = IconLoader.getIcon("/nodes/shared.png"); // 16x16
    public static final Icon SortBySeverity = IconLoader.getIcon("/nodes/sortBySeverity.png"); // 16x16
    public static final Icon SourceFolder = IconLoader.getIcon("/nodes/sourceFolder.png"); // 16x16
    public static final Icon Static = IconLoader.getIcon("/nodes/static.png"); // 16x16
    public static final Icon StaticMark = IconLoader.getIcon("/nodes/staticMark.png"); // 16x16
    public static final Icon Symlink = IconLoader.getIcon("/nodes/symlink.png"); // 16x16
    public static final Icon TabAlert = IconLoader.getIcon("/nodes/tabAlert.png"); // 16x16
    public static final Icon TabPin = IconLoader.getIcon("/nodes/tabPin.png"); // 16x16
    public static final Icon Tag = IconLoader.getIcon("/nodes/tag.png"); // 16x16
    public static final Icon TestSourceFolder = IconLoader.getIcon("/nodes/testSourceFolder.png"); // 16x16
    public static final Icon TreeClosed = IconLoader.getIcon("/nodes/TreeClosed.png"); // 16x16
    public static final Icon TreeCollapseNode = IconLoader.getIcon("/nodes/treeCollapseNode.png"); // 16x16
    public static final Icon TreeDownArrow = IconLoader.getIcon("/nodes/treeDownArrow.png"); // 11x11
    public static final Icon TreeExpandNode = IconLoader.getIcon("/nodes/treeExpandNode.png"); // 16x16
    public static final Icon TreeOpen = IconLoader.getIcon("/nodes/TreeOpen.png"); // 16x16
    public static final Icon TreeRightArrow = IconLoader.getIcon("/nodes/treeRightArrow.png"); // 11x11
    public static final Icon Undeploy = IconLoader.getIcon("/nodes/undeploy.png"); // 16x16
    public static final Icon UnknownJdk = IconLoader.getIcon("/nodes/unknownJdk.png"); // 16x16
    public static final Icon UpFolder = IconLoader.getIcon("/nodes/upFolder.png"); // 16x16
    public static final Icon UpLevel = IconLoader.getIcon("/nodes/upLevel.png"); // 16x16
    public static final Icon Variable = IconLoader.getIcon("/nodes/variable.png"); // 16x16
    public static final Icon WarningIntroduction = IconLoader.getIcon("/nodes/warningIntroduction.png"); // 16x16
    public static final Icon WebFolder = IconLoader.getIcon("/nodes/webFolder.png"); // 16x16
    public static final Icon Weblistener = IconLoader.getIcon("/nodes/weblistener.png"); // 16x16
    public static final Icon Write_access = IconLoader.getIcon("/nodes/write-access.png"); // 13x9

  }
  
  public static class ObjectBrowser {
    public static final Icon AbbreviatePackageNames = IconLoader.getIcon("/objectBrowser/abbreviatePackageNames.png"); // 16x16
    public static final Icon CompactEmptyPackages = IconLoader.getIcon("/objectBrowser/compactEmptyPackages.png"); // 16x16
    public static final Icon FlattenPackages = IconLoader.getIcon("/objectBrowser/flattenPackages.png"); // 16x16
    public static final Icon ShowEditorHighlighting = IconLoader.getIcon("/objectBrowser/showEditorHighlighting.png"); // 16x16
    public static final Icon ShowLibraryContents = IconLoader.getIcon("/objectBrowser/showLibraryContents.png"); // 16x16
    public static final Icon ShowMembers = IconLoader.getIcon("/objectBrowser/showMembers.png"); // 16x16
    public static final Icon ShowModules = IconLoader.getIcon("/objectBrowser/showModules.png"); // 16x16
    public static final Icon SortByType = IconLoader.getIcon("/objectBrowser/sortByType.png"); // 16x16
    public static final Icon Sorted = IconLoader.getIcon("/objectBrowser/sorted.png"); // 16x16
    public static final Icon SortedByUsage = IconLoader.getIcon("/objectBrowser/sortedByUsage.png"); // 16x16
    public static final Icon VisibilitySort = IconLoader.getIcon("/objectBrowser/visibilitySort.png"); // 16x16

  }
  
  public static class Preferences {
    public static final Icon Appearance = IconLoader.getIcon("/preferences/Appearance.png"); // 32x32
    public static final Icon CodeStyle = IconLoader.getIcon("/preferences/CodeStyle.png"); // 32x32
    public static final Icon Compiler = IconLoader.getIcon("/preferences/Compiler.png"); // 32x32
    public static final Icon Editor = IconLoader.getIcon("/preferences/Editor.png"); // 32x32
    public static final Icon FileColors = IconLoader.getIcon("/preferences/FileColors.png"); // 32x32
    public static final Icon FileTypes = IconLoader.getIcon("/preferences/FileTypes.png"); // 32x32
    public static final Icon General = IconLoader.getIcon("/preferences/General.png"); // 32x32
    public static final Icon Keymap = IconLoader.getIcon("/preferences/Keymap.png"); // 32x32
    public static final Icon Plugins = IconLoader.getIcon("/preferences/Plugins.png"); // 32x32
    public static final Icon Updates = IconLoader.getIcon("/preferences/Updates.png"); // 32x32
    public static final Icon VersionControl = IconLoader.getIcon("/preferences/VersionControl.png"); // 32x32

  }
  
  public static class Process {
    
    public static class Big {
      public static final Icon Step_1 = IconLoader.getIcon("/process/big/step_1.png"); // 32x32
      public static final Icon Step_10 = IconLoader.getIcon("/process/big/step_10.png"); // 32x32
      public static final Icon Step_11 = IconLoader.getIcon("/process/big/step_11.png"); // 32x32
      public static final Icon Step_12 = IconLoader.getIcon("/process/big/step_12.png"); // 32x32
      public static final Icon Step_2 = IconLoader.getIcon("/process/big/step_2.png"); // 32x32
      public static final Icon Step_3 = IconLoader.getIcon("/process/big/step_3.png"); // 32x32
      public static final Icon Step_4 = IconLoader.getIcon("/process/big/step_4.png"); // 32x32
      public static final Icon Step_5 = IconLoader.getIcon("/process/big/step_5.png"); // 32x32
      public static final Icon Step_6 = IconLoader.getIcon("/process/big/step_6.png"); // 32x32
      public static final Icon Step_7 = IconLoader.getIcon("/process/big/step_7.png"); // 32x32
      public static final Icon Step_8 = IconLoader.getIcon("/process/big/step_8.png"); // 32x32
      public static final Icon Step_9 = IconLoader.getIcon("/process/big/step_9.png"); // 32x32
      public static final Icon Step_passive = IconLoader.getIcon("/process/big/step_passive.png"); // 32x32

    }
    public static final Icon DisabledDebug = IconLoader.getIcon("/process/disabledDebug.png"); // 13x13
    public static final Icon DisabledRun = IconLoader.getIcon("/process/disabledRun.png"); // 13x13
    
    public static class FS {
      public static final Icon Step_1 = IconLoader.getIcon("/process/fs/step_1.png"); // 16x16
      public static final Icon Step_10 = IconLoader.getIcon("/process/fs/step_10.png"); // 16x16
      public static final Icon Step_11 = IconLoader.getIcon("/process/fs/step_11.png"); // 16x16
      public static final Icon Step_12 = IconLoader.getIcon("/process/fs/step_12.png"); // 16x16
      public static final Icon Step_13 = IconLoader.getIcon("/process/fs/step_13.png"); // 16x16
      public static final Icon Step_14 = IconLoader.getIcon("/process/fs/step_14.png"); // 16x16
      public static final Icon Step_15 = IconLoader.getIcon("/process/fs/step_15.png"); // 16x16
      public static final Icon Step_16 = IconLoader.getIcon("/process/fs/step_16.png"); // 16x16
      public static final Icon Step_17 = IconLoader.getIcon("/process/fs/step_17.png"); // 16x16
      public static final Icon Step_18 = IconLoader.getIcon("/process/fs/step_18.png"); // 16x16
      public static final Icon Step_2 = IconLoader.getIcon("/process/fs/step_2.png"); // 16x16
      public static final Icon Step_3 = IconLoader.getIcon("/process/fs/step_3.png"); // 16x16
      public static final Icon Step_4 = IconLoader.getIcon("/process/fs/step_4.png"); // 16x16
      public static final Icon Step_5 = IconLoader.getIcon("/process/fs/step_5.png"); // 16x16
      public static final Icon Step_6 = IconLoader.getIcon("/process/fs/step_6.png"); // 16x16
      public static final Icon Step_7 = IconLoader.getIcon("/process/fs/step_7.png"); // 16x16
      public static final Icon Step_8 = IconLoader.getIcon("/process/fs/step_8.png"); // 16x16
      public static final Icon Step_9 = IconLoader.getIcon("/process/fs/step_9.png"); // 16x16
      public static final Icon Step_mask = IconLoader.getIcon("/process/fs/step_mask.png"); // 16x16
      public static final Icon Step_passive = IconLoader.getIcon("/process/fs/step_passive.png"); // 16x16

    }
    
    public static class State {
      public static final Icon GreenOK = IconLoader.getIcon("/process/state/GreenOK.png"); // 16x16
      public static final Icon GreyProgr = IconLoader.getIcon("/process/state/GreyProgr.png"); // 16x16
      public static final Icon GreyProgr_1 = IconLoader.getIcon("/process/state/GreyProgr_1.png"); // 16x16
      public static final Icon GreyProgr_2 = IconLoader.getIcon("/process/state/GreyProgr_2.png"); // 16x16
      public static final Icon GreyProgr_3 = IconLoader.getIcon("/process/state/GreyProgr_3.png"); // 16x16
      public static final Icon GreyProgr_4 = IconLoader.getIcon("/process/state/GreyProgr_4.png"); // 16x16
      public static final Icon GreyProgr_5 = IconLoader.getIcon("/process/state/GreyProgr_5.png"); // 16x16
      public static final Icon GreyProgr_6 = IconLoader.getIcon("/process/state/GreyProgr_6.png"); // 16x16
      public static final Icon GreyProgr_7 = IconLoader.getIcon("/process/state/GreyProgr_7.png"); // 16x16
      public static final Icon GreyProgr_8 = IconLoader.getIcon("/process/state/GreyProgr_8.png"); // 16x16
      public static final Icon RedExcl = IconLoader.getIcon("/process/state/RedExcl.png"); // 16x16
      public static final Icon YellowStr = IconLoader.getIcon("/process/state/YellowStr.png"); // 16x16

    }
    public static final Icon Step_1 = IconLoader.getIcon("/process/step_1.png"); // 16x16
    public static final Icon Step_10 = IconLoader.getIcon("/process/step_10.png"); // 16x16
    public static final Icon Step_11 = IconLoader.getIcon("/process/step_11.png"); // 16x16
    public static final Icon Step_12 = IconLoader.getIcon("/process/step_12.png"); // 16x16
    public static final Icon Step_2 = IconLoader.getIcon("/process/step_2.png"); // 16x16
    public static final Icon Step_3 = IconLoader.getIcon("/process/step_3.png"); // 16x16
    public static final Icon Step_4 = IconLoader.getIcon("/process/step_4.png"); // 16x16
    public static final Icon Step_5 = IconLoader.getIcon("/process/step_5.png"); // 16x16
    public static final Icon Step_6 = IconLoader.getIcon("/process/step_6.png"); // 16x16
    public static final Icon Step_7 = IconLoader.getIcon("/process/step_7.png"); // 16x16
    public static final Icon Step_8 = IconLoader.getIcon("/process/step_8.png"); // 16x16
    public static final Icon Step_9 = IconLoader.getIcon("/process/step_9.png"); // 16x16
    public static final Icon Step_mask = IconLoader.getIcon("/process/step_mask.png"); // 16x16
    public static final Icon Step_passive = IconLoader.getIcon("/process/step_passive.png"); // 16x16
    public static final Icon Stop = IconLoader.getIcon("/process/stop.png"); // 16x16
    public static final Icon StopHovered = IconLoader.getIcon("/process/stopHovered.png"); // 16x16

  }
  
  public static class Providers {
    public static final Icon Apache = IconLoader.getIcon("/providers/apache.png"); // 16x16
    public static final Icon Bea = IconLoader.getIcon("/providers/bea.png"); // 16x16
    public static final Icon Cvs = IconLoader.getIcon("/providers/cvs.png"); // 16x16
    public static final Icon Eclipse = IconLoader.getIcon("/providers/eclipse.png"); // 16x16
    public static final Icon H2 = IconLoader.getIcon("/providers/h2.png"); // 16x16
    public static final Icon Hibernate = IconLoader.getIcon("/providers/hibernate.png"); // 16x16
    public static final Icon Hsqldb = IconLoader.getIcon("/providers/hsqldb.png"); // 16x16
    public static final Icon Ibm = IconLoader.getIcon("/providers/ibm.png"); // 16x16
    public static final Icon Microsoft = IconLoader.getIcon("/providers/microsoft.png"); // 16x16
    public static final Icon Mysql = IconLoader.getIcon("/providers/mysql.png"); // 16x16
    public static final Icon Oracle = IconLoader.getIcon("/providers/oracle.png"); // 16x16
    public static final Icon Postgresql = IconLoader.getIcon("/providers/postgresql.png"); // 16x16
    public static final Icon Sqlite = IconLoader.getIcon("/providers/sqlite.png"); // 16x16
    public static final Icon SqlServer = IconLoader.getIcon("/providers/sqlServer.png"); // 16x16
    public static final Icon Sun = IconLoader.getIcon("/providers/sun.png"); // 16x16
    public static final Icon Sybase = IconLoader.getIcon("/providers/sybase.png"); // 16x16

  }
  
  public static class RunConfigurations {
    public static final Icon Applet = IconLoader.getIcon("/runConfigurations/applet.png"); // 16x16
    public static final Icon Application = IconLoader.getIcon("/runConfigurations/application.png"); // 16x16
    public static final Icon ConfigurationWarning = IconLoader.getIcon("/runConfigurations/configurationWarning.png"); // 16x16
    public static final Icon HideIgnored = IconLoader.getIcon("/runConfigurations/hideIgnored.png"); // 16x16
    public static final Icon HidePassed = IconLoader.getIcon("/runConfigurations/hidePassed.png"); // 16x16
    public static final Icon IgnoredTest = IconLoader.getIcon("/runConfigurations/ignoredTest.png"); // 16x16
    public static final Icon IncludeNonStartedTests_Rerun = IconLoader.getIcon("/runConfigurations/includeNonStartedTests_Rerun.png"); // 16x16
    public static final Icon InvalidConfigurationLayer = IconLoader.getIcon("/runConfigurations/invalidConfigurationLayer.png"); // 16x16
    public static final Icon Junit = IconLoader.getIcon("/runConfigurations/junit.png"); // 16x16
    public static final Icon LoadingTree = IconLoader.getIcon("/runConfigurations/loadingTree.png"); // 16x16
    public static final Icon Ql_console = IconLoader.getIcon("/runConfigurations/ql_console.png"); // 16x16
    public static final Icon Remote = IconLoader.getIcon("/runConfigurations/remote.png"); // 16x16
    public static final Icon RerunFailedTests = IconLoader.getIcon("/runConfigurations/rerunFailedTests.png"); // 16x16
    public static final Icon SaveTempConfig = IconLoader.getIcon("/runConfigurations/saveTempConfig.png"); // 16x16
    public static final Icon Scroll_down = IconLoader.getIcon("/runConfigurations/scroll_down.png"); // 16x16
    public static final Icon ScrollToStackTrace = IconLoader.getIcon("/runConfigurations/scrollToStackTrace.png"); // 16x16
    public static final Icon SelectFirstDefect = IconLoader.getIcon("/runConfigurations/selectFirstDefect.png"); // 16x16
    public static final Icon SortbyDuration = IconLoader.getIcon("/runConfigurations/sortbyDuration.png"); // 16x16
    public static final Icon SourceAtException = IconLoader.getIcon("/runConfigurations/sourceAtException.png"); // 16x16
    public static final Icon TestError = IconLoader.getIcon("/runConfigurations/testError.png"); // 16x16
    public static final Icon TestFailed = IconLoader.getIcon("/runConfigurations/testFailed.png"); // 16x16
    public static final Icon TestIgnored = IconLoader.getIcon("/runConfigurations/testIgnored.png"); // 16x16
    public static final Icon TestInProgress1 = IconLoader.getIcon("/runConfigurations/testInProgress1.png"); // 16x16
    public static final Icon TestInProgress2 = IconLoader.getIcon("/runConfigurations/testInProgress2.png"); // 16x16
    public static final Icon TestInProgress3 = IconLoader.getIcon("/runConfigurations/testInProgress3.png"); // 16x16
    public static final Icon TestInProgress4 = IconLoader.getIcon("/runConfigurations/testInProgress4.png"); // 16x16
    public static final Icon TestInProgress5 = IconLoader.getIcon("/runConfigurations/testInProgress5.png"); // 16x16
    public static final Icon TestInProgress6 = IconLoader.getIcon("/runConfigurations/testInProgress6.png"); // 16x16
    public static final Icon TestInProgress7 = IconLoader.getIcon("/runConfigurations/testInProgress7.png"); // 16x16
    public static final Icon TestInProgress8 = IconLoader.getIcon("/runConfigurations/testInProgress8.png"); // 16x16
    public static final Icon TestMark = IconLoader.getIcon("/runConfigurations/testMark.png"); // 16x16
    public static final Icon TestNotRan = IconLoader.getIcon("/runConfigurations/testNotRan.png"); // 16x16
    public static final Icon TestPassed = IconLoader.getIcon("/runConfigurations/testPassed.png"); // 16x16
    public static final Icon TestPaused = IconLoader.getIcon("/runConfigurations/testPaused.png"); // 16x16
    public static final Icon TestSkipped = IconLoader.getIcon("/runConfigurations/testSkipped.png"); // 16x16
    
    public static class TestState {
      public static final Icon Green2 = IconLoader.getIcon("/runConfigurations/testState/green2.png"); // 12x12
      public static final Icon Red2 = IconLoader.getIcon("/runConfigurations/testState/red2.png"); // 12x12
      public static final Icon Run = IconLoader.getIcon("/runConfigurations/testState/run.png"); // 12x12
      public static final Icon Run_run = IconLoader.getIcon("/runConfigurations/testState/run_run.png"); // 12x12
      public static final Icon Yellow2 = IconLoader.getIcon("/runConfigurations/testState/yellow2.png"); // 12x12

    }
    public static final Icon TestTerminated = IconLoader.getIcon("/runConfigurations/testTerminated.png"); // 16x16
    public static final Icon Tomcat = IconLoader.getIcon("/runConfigurations/tomcat.png"); // 16x16
    public static final Icon TrackCoverage = IconLoader.getIcon("/runConfigurations/trackCoverage.png"); // 16x16
    public static final Icon TrackTests = IconLoader.getIcon("/runConfigurations/trackTests.png"); // 16x16
    public static final Icon Unknown = IconLoader.getIcon("/runConfigurations/unknown.png"); // 16x16
    public static final Icon Variables = IconLoader.getIcon("/runConfigurations/variables.png"); // 16x16
    public static final Icon Web_app = IconLoader.getIcon("/runConfigurations/web_app.png"); // 16x16
    public static final Icon WithCoverageLayer = IconLoader.getIcon("/runConfigurations/withCoverageLayer.png"); // 16x16

  }
  
  public static class Toolbar {
    public static final Icon Filterdups = IconLoader.getIcon("/toolbar/filterdups.png"); // 16x16
    public static final Icon Folders = IconLoader.getIcon("/toolbar/folders.png"); // 16x16
    public static final Icon Unknown = IconLoader.getIcon("/toolbar/unknown.png"); // 16x16

  }
  
  public static class ToolbarDecorator {
    public static final Icon Add = IconLoader.getIcon("/toolbarDecorator/add.png"); // 14x14
    public static final Icon AddBlankLine = IconLoader.getIcon("/toolbarDecorator/addBlankLine.png"); // 16x16
    public static final Icon AddClass = IconLoader.getIcon("/toolbarDecorator/addClass.png"); // 16x16
    public static final Icon AddFolder = IconLoader.getIcon("/toolbarDecorator/addFolder.png"); // 16x16
    public static final Icon AddIcon = IconLoader.getIcon("/toolbarDecorator/addIcon.png"); // 16x16
    public static final Icon AddJira = IconLoader.getIcon("/toolbarDecorator/addJira.png"); // 16x16
    public static final Icon AddLink = IconLoader.getIcon("/toolbarDecorator/addLink.png"); // 16x16
    public static final Icon AddPackage = IconLoader.getIcon("/toolbarDecorator/addPackage.png"); // 16x16
    public static final Icon AddPattern = IconLoader.getIcon("/toolbarDecorator/addPattern.png"); // 16x16
    public static final Icon AddRemoteDatasource = IconLoader.getIcon("/toolbarDecorator/addRemoteDatasource.png"); // 16x16
    public static final Icon AddYouTrack = IconLoader.getIcon("/toolbarDecorator/addYouTrack.png"); // 16x16
    public static final Icon Analyze = IconLoader.getIcon("/toolbarDecorator/analyze.png"); // 14x14
    public static final Icon Edit = IconLoader.getIcon("/toolbarDecorator/edit.png"); // 14x14
    public static final Icon Export = IconLoader.getIcon("/toolbarDecorator/export.png"); // 16x16
    public static final Icon Import = IconLoader.getIcon("/toolbarDecorator/import.png"); // 16x16
    
    public static class Mac {
      public static final Icon Add = IconLoader.getIcon("/toolbarDecorator/mac/add.png"); // 14x14
      public static final Icon AddBlankLine = IconLoader.getIcon("/toolbarDecorator/mac/addBlankLine.png"); // 16x16
      public static final Icon AddClass = IconLoader.getIcon("/toolbarDecorator/mac/addClass.png"); // 16x16
      public static final Icon AddFolder = IconLoader.getIcon("/toolbarDecorator/mac/addFolder.png"); // 16x16
      public static final Icon AddIcon = IconLoader.getIcon("/toolbarDecorator/mac/addIcon.png"); // 16x16
      public static final Icon AddJira = IconLoader.getIcon("/toolbarDecorator/mac/addJira.png"); // 16x16
      public static final Icon AddLink = IconLoader.getIcon("/toolbarDecorator/mac/addLink.png"); // 16x16
      public static final Icon AddPackage = IconLoader.getIcon("/toolbarDecorator/mac/addPackage.png"); // 16x16
      public static final Icon AddPattern = IconLoader.getIcon("/toolbarDecorator/mac/addPattern.png"); // 16x16
      public static final Icon AddRemoteDatasource = IconLoader.getIcon("/toolbarDecorator/mac/addRemoteDatasource.png"); // 16x16
      public static final Icon AddYouTrack = IconLoader.getIcon("/toolbarDecorator/mac/addYouTrack.png"); // 16x16
      public static final Icon Analyze = IconLoader.getIcon("/toolbarDecorator/mac/analyze.png"); // 14x14
      public static final Icon Edit = IconLoader.getIcon("/toolbarDecorator/mac/edit.png"); // 14x14
      public static final Icon MoveDown = IconLoader.getIcon("/toolbarDecorator/mac/moveDown.png"); // 14x14
      public static final Icon MoveUp = IconLoader.getIcon("/toolbarDecorator/mac/moveUp.png"); // 14x14
      public static final Icon Remove = IconLoader.getIcon("/toolbarDecorator/mac/remove.png"); // 14x14

    }
    public static final Icon MoveDown = IconLoader.getIcon("/toolbarDecorator/moveDown.png"); // 14x14
    public static final Icon MoveUp = IconLoader.getIcon("/toolbarDecorator/moveUp.png"); // 14x14
    public static final Icon Remove = IconLoader.getIcon("/toolbarDecorator/remove.png"); // 14x14

  }
  
  public static class Toolwindows {
    public static final Icon Documentation = IconLoader.getIcon("/toolwindows/documentation.png"); // 13x13
    public static final Icon Problems = IconLoader.getIcon("/toolwindows/problems.png"); // 13x13
    public static final Icon ToolWindowAnt = IconLoader.getIcon("/toolwindows/toolWindowAnt.png"); // 13x13
    public static final Icon ToolWindowChanges = IconLoader.getIcon("/toolwindows/toolWindowChanges.png"); // 13x13
    public static final Icon ToolWindowCommander = IconLoader.getIcon("/toolwindows/toolWindowCommander.png"); // 13x13
    public static final Icon ToolWindowCoverage = IconLoader.getIcon("/toolwindows/toolWindowCoverage.png"); // 13x13
    public static final Icon ToolWindowCvs = IconLoader.getIcon("/toolwindows/toolWindowCvs.png"); // 13x13
    public static final Icon ToolWindowDebugger = IconLoader.getIcon("/toolwindows/toolWindowDebugger.png"); // 13x13
    public static final Icon ToolWindowFavorites = IconLoader.getIcon("/toolwindows/toolWindowFavorites.png"); // 13x13
    public static final Icon ToolWindowFind = IconLoader.getIcon("/toolwindows/toolWindowFind.png"); // 13x13
    public static final Icon ToolWindowHierarchy = IconLoader.getIcon("/toolwindows/toolWindowHierarchy.png"); // 13x13
    public static final Icon ToolWindowInspection = IconLoader.getIcon("/toolwindows/toolWindowInspection.png"); // 13x13
    public static final Icon ToolWindowMessages = IconLoader.getIcon("/toolwindows/toolWindowMessages.png"); // 13x13
    public static final Icon ToolWindowModuleDependencies = IconLoader.getIcon("/toolwindows/toolWindowModuleDependencies.png"); // 13x13
    public static final Icon ToolWindowPalette = IconLoader.getIcon("/toolwindows/toolWindowPalette.png"); // 13x13
    public static final Icon ToolWindowPreview = IconLoader.getIcon("/toolwindows/toolWindowPreview.png"); // 13x13
    public static final Icon ToolWindowProject = IconLoader.getIcon("/toolwindows/toolWindowProject.png"); // 13x13
    public static final Icon ToolWindowRun = IconLoader.getIcon("/toolwindows/toolWindowRun.png"); // 13x13
    public static final Icon ToolWindowStructure = IconLoader.getIcon("/toolwindows/toolWindowStructure.png"); // 13x13
    public static final Icon ToolWindowTodo = IconLoader.getIcon("/toolwindows/toolWindowTodo.png"); // 13x13
    public static final Icon VcsSmallTab = IconLoader.getIcon("/toolwindows/vcsSmallTab.png"); // 13x13
    public static final Icon WebToolWindow = IconLoader.getIcon("/toolwindows/webToolWindow.png"); // 13x13

  }
  
  public static class Vcs {
    public static final Icon AllRevisions = IconLoader.getIcon("/vcs/allRevisions.png"); // 16x16
    public static final Icon Arrow_left = IconLoader.getIcon("/vcs/arrow_left.png"); // 16x16
    public static final Icon Arrow_right = IconLoader.getIcon("/vcs/arrow_right.png"); // 16x16
    public static final Icon CheckSpelling = IconLoader.getIcon("/vcs/checkSpelling.png"); // 16x16
    public static final Icon Equal = IconLoader.getIcon("/vcs/equal.png"); // 16x16
    public static final Icon History = IconLoader.getIcon("/vcs/history.png"); // 16x16
    public static final Icon MapBase = IconLoader.getIcon("/vcs/mapBase.png"); // 16x16
    public static final Icon Merge = IconLoader.getIcon("/vcs/merge.png"); // 12x12
    public static final Icon MergeSourcesTree = IconLoader.getIcon("/vcs/mergeSourcesTree.png"); // 16x16
    public static final Icon Not_equal = IconLoader.getIcon("/vcs/not_equal.png"); // 16x16
    public static final Icon Remove = IconLoader.getIcon("/vcs/remove.png"); // 16x16
    public static final Icon ResetStrip = IconLoader.getIcon("/vcs/resetStrip.png"); // 16x16
    public static final Icon StripDown = IconLoader.getIcon("/vcs/stripDown.png"); // 16x16
    public static final Icon StripNull = IconLoader.getIcon("/vcs/stripNull.png"); // 16x16
    public static final Icon StripUp = IconLoader.getIcon("/vcs/stripUp.png"); // 16x16

  }
  
  public static class Webreferences {
    public static final Icon Server = IconLoader.getIcon("/webreferences/server.png"); // 16x16

  }
  
  public static class Welcome {
    public static final Icon CreateDesktopEntry = IconLoader.getIcon("/welcome/createDesktopEntry.png"); // 32x32
    public static final Icon CreateNewProject = IconLoader.getIcon("/welcome/createNewProject.png"); // 16x16
    public static final Icon CreateNewProjectfromExistingFiles = IconLoader.getIcon("/welcome/CreateNewProjectfromExistingFiles.png"); // 16x16
    public static final Icon FromVCS = IconLoader.getIcon("/welcome/fromVCS.png"); // 16x16
    public static final Icon ImportProject = IconLoader.getIcon("/welcome/importProject.png"); // 16x16
    public static final Icon OpenProject = IconLoader.getIcon("/welcome/openProject.png"); // 16x16
    
    public static class Project {
      public static final Icon Remove_hover = IconLoader.getIcon("/welcome/project/remove-hover.png"); // 10x10
      public static final Icon Remove = IconLoader.getIcon("/welcome/project/remove.png"); // 10x10

    }
    public static final Icon Register = IconLoader.getIcon("/welcome/register.png"); // 32x32

  }
  
  public static class Windows {
    public static final Icon Close = IconLoader.getIcon("/windows/close.png"); // 16x16
    public static final Icon Iconify = IconLoader.getIcon("/windows/iconify.png"); // 16x16
    public static final Icon Maximize = IconLoader.getIcon("/windows/maximize.png"); // 16x16
    public static final Icon Minimize = IconLoader.getIcon("/windows/minimize.png"); // 16x16

  }
  
  public static class Xml {
    
    public static class Browsers {
      public static final Icon Canary16 = IconLoader.getIcon("/xml/browsers/canary16.png"); // 16x16
      public static final Icon Chrome16 = IconLoader.getIcon("/xml/browsers/chrome16.png"); // 16x16
      public static final Icon Chromium16 = IconLoader.getIcon("/xml/browsers/chromium16.png"); // 16x16
      public static final Icon Edge16 = IconLoader.getIcon("/xml/browsers/edge16.png"); // 16x16
      public static final Icon Explorer16 = IconLoader.getIcon("/xml/browsers/explorer16.png"); // 16x16
      public static final Icon Firefox16 = IconLoader.getIcon("/xml/browsers/firefox16.png"); // 16x16
      public static final Icon Nwjs16 = IconLoader.getIcon("/xml/browsers/nwjs16.png"); // 16x16
      public static final Icon Opera16 = IconLoader.getIcon("/xml/browsers/opera16.png"); // 16x16
      public static final Icon Safari16 = IconLoader.getIcon("/xml/browsers/safari16.png"); // 16x16
      public static final Icon Yandex16 = IconLoader.getIcon("/xml/browsers/yandex16.png"); // 16x16

    }
    public static final Icon Css_class = IconLoader.getIcon("/xml/css_class.png"); // 16x16
    public static final Icon Html5 = IconLoader.getIcon("/xml/html5.png"); // 16x16
    public static final Icon Html_id = IconLoader.getIcon("/xml/html_id.png"); // 16x16

  }
}
