!{\src2tex{textfont=tt}}
!!****f* ABINIT/lineint
!! NAME
!! lineint
!!
!! FUNCTION
!! Computes the values along a line
!! defined by two points
!!
!! COPYRIGHT
!! Copyright (C) 2000-2007 ABINIT group (GMR,RC,XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! grid(nr1,nr2,nr3)=grid matrix
!! nr1=grid size along x
!! nr2=grid size along y
!! nr3=grid size along z
!! rprimd(3,3)=orientation of the unit cell in 3D
!!
!! OUTPUT
!!  only writing
!!
!! PARENTS
!!      cut3d
!!
!! CHILDREN
!!      interpol3d,linedirectint,reduce
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine lineint(grid,nr1,nr2,nr3,rprimd)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_11util
 use interfaces_19cut3d, except_this_one => lineint
#endif
!End of the abilint section

 implicit none

!Arguments-------------------------------------------------------------
!scalars
 integer,intent(in) :: nr1,nr2,nr3
!arrays
 real(dp),intent(in) :: grid(nr1,nr2,nr3),rprimd(3,3)

!Local variables--------------------------------------------------------
!scalars
 integer :: iat,idir,ii,inpopt,isp,jj,k2,nresol,okline
 real(dp) :: denval,dx,dy,dz,length,xcoord,ycoord
 character(len=fnlen) :: filnam
!arrays
 real(dp) :: cent(3),mm(3,3),r1(3),r2(3),rcart(3),rr(3),x1(3),x2(3)

! *********************************************************************

 okline=0
 do while (okline==0)
  write(*,*) ' Type 1) for a line between two cartesian-defined points'
  write(*,*) '   or 2) for a line between two crystallographic-defined points '
  write(*,*) '   or 3) for a line defined by its direction'
  read(*,*) inpopt
  if (inpopt==1 .or. inpopt ==2 .or. inpopt==3) okline=1
 end do

!In case of a line defined by its direction the code will be re-directed
 if(inpopt==3)then
  call linedirectint(rprimd,nr1,nr2,nr3,grid)
 end if

!In the case of a line defined by its two extreme points
 if (inpopt==1) then
  write(*,*) ' Type the first point coordinates (Bohrs):'
  write(*,*) '    -> X-dir   Y-dir   Z-dir:'
  read(*,*) x1
  call reduce(r1,x1,rprimd)

  write(*,*) ' Type the second point coordinates (Bohrs):'
  write(*,*) '    -> X-dir   Y-dir   Z-dir:'
  read(*,*) x2
  call reduce(r2,x2,rprimd)
 end if

 if (inpopt==2) then
  write(*,*) ' Type the first point coordinates (fractional):'
  write(*,*) '    -> X-dir   Y-dir   Z-dir:'
  read(*,*) r1

  write(*,*) ' Type the second point coordinates (fractional):'
  write(*,*) '    -> X-dir   Y-dir   Z-dir:'
  read(*,*) r2
 end if

 if (inpopt/=3) then

  write(*,*) '  Enter line resolution:   (integer, number of points on the line)'
  read(*,*) nresol

! At this moment the code knows everything about the geometric input, the data and
! the line direction. It will further calculate the values along this line using
! an interpolation

  write(*,*) ch10,'  Enter the name of an output file:'
  read(*,*) filnam
  write(*,*) '  The name of your file is : ',trim(filnam)

  open(unit=31,file=trim(filnam),status='unknown')

  dx=(r2(1)-r1(1))/nresol
  dy=(r2(2)-r1(2))/nresol
  dz=(r2(3)-r1(3))/nresol

  do k2=0,nresol
   rr(1)=r1(1)+k2*dx
   rr(2)=r1(2)+k2*dy
   rr(3)=r1(3)+k2*dz

   rr(1)=mod(mod(rr(1),1._dp)+1._dp,1._dp)
   rr(2)=mod(mod(rr(2),1._dp)+1._dp,1._dp)
   rr(3)=mod(mod(rr(3),1._dp)+1._dp,1._dp)

   call interpol3d(rr,nr1,nr2,nr3,denval,grid)
   write(31, '(i13,es22.12)' ) k2,denval
  end do

  close(31)

 end if

end subroutine lineint
!!***
