!{\src2tex{textfont=tt}}
!!****f* ABINIT/ckxcldag
!! NAME
!! ckxcldag
!!
!! FUNCTION
!! Calculate exchange-correlation kernel Kxclda in G-space
!! put it into Kxclda in igfft form
!! (Needed only if GWGamma calculation - not operational ?!)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  nr=number of points of FFT grid
!!  rho2(nr)=density in real space
!!
!! OUTPUT
!!  kxclda(nr)=XC kernel in reciprocal space
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      ckxcldar,fourdp
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine ckxcldag(ngfft1,ngfft1a,ngfft2,ngfft3,nr,rho2,kxclda)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_12ffts
 use interfaces_15gw, except_this_one => ckxcldag
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngfft1,ngfft1a,ngfft2,ngfft3,nr
!arrays
 real(dp),intent(in) :: rho2(nr)
 complex,intent(out) :: kxclda(nr)

!Local variables-------------------------------
!scalars
 integer :: tim_fourdp
 real(dp) :: fftfct
 type(MPI_type) :: mpi_enreg
!arrays
 integer :: ngfft(18)
 real(dp),allocatable :: kxcldag(:,:),kxcldar(:,:)

! *************************************************************************

 allocate(kxcldar(2,nr),kxcldag(2,nr))

 call ckxcldar(nr,rho2,kxclda)
 kxcldar(1,:)=real(kxclda(:))
 kxcldar(2,:)=aimag(kxclda(:))

 write(6,*) 'fft kxclda(r)->kxclda(g)'
 write(6,*)

!call c3dfft(kxclda,ngfft1a,ngfft2,ngfft3,ngfft1,ngfft2,ngfft3,-1)
 ngfft(1)=ngfft1
 ngfft(2)=ngfft2
 ngfft(3)=ngfft3
 ngfft(4)=2*(ngfft(1)/2)+1
 ngfft(5)=2*(ngfft(2)/2)+1
 ngfft(6)=ngfft(3)
 ngfft(7)=200
 ngfft(8)=256
 ngfft(9)=0
 ngfft(10)=1
 ngfft(11)=0
 ngfft(12)=ngfft2
 ngfft(13)=ngfft3
 ngfft(14)=0
 tim_fourdp=3
 mpi_enreg%nproc_fft=1
 mpi_enreg%me_fft=0
 call fourdp(2,kxcldag,kxcldar,-1,mpi_enreg,nr,ngfft,tim_fourdp)

!do ig=1, npwvec
!  kxcg(ig)=Kxclda(igfft(ig,3,3,3))*fftfct
!end do

!renormalization after fft
!fftfct=1/real(ngfft1*ngfft2*ngfft3)
!kxclda(:)=kxclda(:)*fftfct
 kxclda(:)=kxcldag(1,:)+(0.0,1.0)*kxcldag(2,:)

 deallocate(kxcldar,kxcldag)

end subroutine ckxcldag
!!***
