/*
 * Copyright (C) 2016-2019 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(APPLE_PAY)

#include "ApplePayContactField.h"
#include "ApplePayInstallmentConfigurationWebCore.h"
#include "ApplePayMerchantCapability.h"
#include "ApplePayPaymentContact.h"

#if USE(APPLE_INTERNAL_SDK)
#include <WebKitAdditions/ApplePayRequestBaseAdditions.h>
#endif

namespace WebCore {

class Document;
class PaymentCoordinator;

struct ApplePayRequestBase {
    Vector<ApplePayMerchantCapability> merchantCapabilities;
    Vector<String> supportedNetworks;
    String countryCode;

    Optional<Vector<ApplePayContactField>> requiredBillingContactFields;
    Optional<ApplePayPaymentContact> billingContact;

    Optional<Vector<ApplePayContactField>> requiredShippingContactFields;
    Optional<ApplePayPaymentContact> shippingContact;

    String applicationData;
    Vector<String> supportedCountries;

#if ENABLE(APPLE_PAY_INSTALLMENTS)
    Optional<ApplePayInstallmentConfiguration> installmentConfiguration;
#endif

#if defined(ApplePayRequestBaseAdditions_members)
    ApplePayRequestBaseAdditions_members
#endif
};

ExceptionOr<ApplePaySessionPaymentRequest> convertAndValidate(Document&, unsigned version, ApplePayRequestBase&, const PaymentCoordinator&);

} // namespace WebCore

#endif // ENABLE(APPLE_PAY)
