/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* 2pc.sql */

static const char *tbl0 = 
"create table _2PC.DBA.TRANSACTIONS (TRX_ID INTEGER, TRX_STATE VARCHAR)\n";

static const char *proc0 = 
"#line 27 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA._FFFF_GET_SEQ_NEXT (IN seqobj VARCHAR, IN _min INTEGER, IN _max INTEGER)\n"
"{\n"
"DECLARE id INTEGER;\n"
"id := sequence_next (seqobj);\n"
"IF ((id < _min) OR (id > _max))\n"
"{\n"
"sequence_set (seqobj, _min, 0);\n"
"return _min;\n"
"}\n"
"return sequence_next (seqobj);\n"
"}\n"
"--src 2pc.sql:25\n";

static const char *proc1 = 
"#line 40 \"[executable]/2pc.sql\"\n"
"create procedure\n"
"_2PC.DBA._0001_ADD_ENTRY ()\n"
"{\n"
"DECLARE _trx_id0 INTEGER;\n"
"DECLARE _trx_id INTEGER;\n"
"_trx_id0 := -1;\n"
"again:\n"
"_trx_id := _2PC.DBA._FFFF_GET_SEQ_NEXT (\'_2PC/TRANSACTIONS/_ID\', 1, 10000);\n"
"IF (_trx_id0 = -1)\n"
"{\n"
"_trx_id0 := _trx_id;\n"
"} ELSE IF (_trx_id0 = _trx_id)\n"
"{\n"
"signal (\'TP000\', sprintf (\'Not enough space in system table for new entry, try to empty _2PC.DBA.TRANSACTIONS table\'));\n"
"RETURN;\n"
"}\n"
"\n"
"WHENEVER SQLSTATE \'23000\' GOTO again;\n"
"INSERT INTO _2PC.DBA.TRANSACTIONS (TRX_ID, TRX_STATE)\n"
"VALUES (_trx_id, \'STARTED\');\n"
"RETURN _trx_id;\n"
"}\n"
"--src 2pc.sql:38\n";

static const char *proc2 = 
"#line 64 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA._FFFF_CHECK_TRX_ID ( IN _trx_id INTEGER)\n"
"{\n"
"FOR SELECT TRX_ID FROM _2PC.DBA.TRANSACTIONS WHERE TRX_ID=_trx_id DO\n"
"{\n"
"RETURN;\n"
"}\n"
"signal (\'TP000\', sprintf (\'No such transaction id [%lx]\', _trx_id));\n"
"}\n"
"--src 2pc.sql:62\n";

static const char *proc3 = 
"#line 75 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA._0001_TRX_SSTATE ( IN _trx_id INTEGER, IN _state VARCHAR)\n"
"{\n"
"_2PC.DBA._FFFF_CHECK_TRX_ID (_trx_id);\n"
"\n"
"IF ((_state = \'COMMITTED\') OR (_state = \'ROLLBACKED\'))\n"
"{\n"
"DELETE FROM _2PC.DBA.TRANSACTIONS WHERE TRX_ID=_trx_id;\n"
"RETURN 0;\n"
"}\n"
"UPDATE _2PC.DBA.TRANSACTIONS SET TRX_STATE=_state WHERE TRX_ID=_trx_id;\n"
"RETURN 0;\n"
"}\n"
"--src 2pc.sql:73\n";

static const char *proc4 = 
"#line 89 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA._0001_GET_TRX_STATE (IN _trx_id INTEGER)\n"
"{\n"
"_2PC.DBA._FFFF_CHECK_TRX_ID (_trx_id);\n"
"FOR SELECT TRX_STATE FROM _2PC.DBA.TRANSACTIONS WHERE TRX_ID=_trx_id DO\n"
"{\n"
"\n"
"IF (TRX_STATE=\'COMMIT_PENDING\')\n"
"RETURN 0;\n"
"\n"
"IF (TRX_STATE=\'ROLLBACK_PENDING\')\n"
"RETURN 1;\n"
"signal (\'TP000\', \'VirtDTC error - unexpected state [%s]\', TRX_STATE);\n"
"RETURN;\n"
"}\n"
"}\n"
"--src 2pc.sql:87\n";

static const char *proc5 = 
"#line 106 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA.virt_tp_enlist_branch (IN trx_cookie VARCHAR)\n"
"{\n"
"virt_tp_update_cli_001 (trx_cookie);\n"
"}\n"
"--src 2pc.sql:104\n";

static const char *proc6 = 
"#line 112 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA.XA_GET_ALL_XIDS_COUNT ()\n"
"{\n"
"DECLARE xid VARCHAR;\n"
"DECLARE c INTEGER;\n"
"\n"
"c := 0;\n"
"\n"
"get_rec_xid_beg ();\n"
"xid := get_rec_xid ();\n"
"WHILE (xid IS NOT NULL)\n"
"{\n"
"c := c + 1;\n"
"xid := get_rec_xid ();\n"
"}\n"
"get_rec_xid_end();\n"
"RETURN c;\n"
"}\n"
"--src 2pc.sql:110\n";

static const char *proc7 = 
"#line 131 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA.OLD_XA_GET_ALL_XIDS ()\n"
"{\n"
"declare xid varchar;\n"
"\n"
"result_names (xid);\n"
"\n"
"get_rec_xid_beg ();\n"
"xid := get_rec_xid ();\n"
"while (xid is not null)\n"
"{\n"
"result (xid);\n"
"xid := get_rec_xid ();\n"
"}\n"
"get_rec_xid_end();\n"
"return NULL;\n"
"}\n"
"--src 2pc.sql:129\n";

static const char *proc8 = 
"#line 149 \"[executable]/2pc.sql\"\n"
"create procedure _2PC.DBA.XA_GET_ALL_XIDS ()\n"
"{\n"
"declare xid varchar;\n"
"\n"
"result_names (xid);\n"
"\n"
"declare xids any;\n"
"xids := txa_get_all_trx();\n"
"if (xids is not null)\n"
"{\n"
"declare idx integer;\n"
"idx := 0;\n"
"while (idx < length (xids))\n"
"{\n"
"declare st varchar;\n"
"st := xids[idx][3];\n"
"if (substring (st, 1, 3) = \'PRP\')\n"
"{\n"
"result (txa_bin_encode (xids[idx][0]));\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src 2pc.sql:147\n";

static const char *other0 = 
"grant execute on \"_2PC.DBA._0001_ADD_ENTRY\" to public\n";
static const char *other1 = 
"grant execute on \"_2PC.DBA._0001_TRX_SSTATE\" to public\n";
static const char *other2 = 
"grant execute on \"_2PC.DBA._0001_GET_TRX_STATE\" to public\n";
static const char *other3 = 
"grant execute on \"DB.DBA.XA_GET_ALL_XIDS_COUNT\" to public\n";
static const char *other4 = 
"grant execute on \"DB.DBA.XA_GET_ALL_XIDS\" to public\n";
static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_2pc (void)
{
  /* 2pc.sql */

  ddl_ensure_table ("_2PC.DBA.TRANSACTIONS", tbl0);
  DEFINE_PROC ("_2PC.DBA._FFFF_GET_SEQ_NEXT", proc0);
  DEFINE_PROC ("_2PC.DBA._0001_ADD_ENTRY", proc1);
  DEFINE_PROC ("_2PC.DBA._FFFF_CHECK_TRX_ID", proc2);
  DEFINE_PROC ("_2PC.DBA._0001_TRX_SSTATE", proc3);
  DEFINE_PROC ("_2PC.DBA._0001_GET_TRX_STATE", proc4);
  DEFINE_PROC ("_2PC.DBA.virt_tp_enlist_branch", proc5);
  DEFINE_PROC ("_2PC.DBA.XA_GET_ALL_XIDS_COUNT", proc6);
  DEFINE_PROC ("_2PC.DBA.OLD_XA_GET_ALL_XIDS", proc7);
  DEFINE_PROC ("_2PC.DBA.XA_GET_ALL_XIDS", proc8);
  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("do this always", other2);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
}


void
sqls_arfw_define_2pc (void)
{
}
