/*
 * Copyright (C) 2011-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

namespace UnityFriends {

    /* Canonical schema for the results model shared with the Unity shell */
    public enum ResultsColumn
    {
        URI = 0,
        ICON_HINT,
        GROUP_ID,
        MIMETYPE,
        DISPLAY_NAME,
        COMMENT
    }
  
    /* Canonical schema for the sections model shared with the Unity shell */
    public enum CategoriesColumn
    {
        RENDERER = 0,
        DISPLAY_NAME,
        ICON_HINT
    }
  
    public enum Categories
    {
        MESSAGES = 0,
        REPLIES,
        IMAGES,
        VIDEOS,
        LINKS,
        PRIVATE,
        PUBLIC
    }

    /* Dee.Model schema */
    public enum StreamModelColumn
    {
        PROTOCOL,
        ACCOUNT_ID,
        MESSAGE_ID,
        STREAM,
        SENDER,
        SENDER_ID,
        SENDER_NICK,
        FROM_ME,
        TIMESTAMP,
        MESSAGE,
        ICON_URI,
        URL,
        LIKES,
        LIKED,
        LINK_PICTURE,
        LINK_NAME,
        LINK_URL,
        LINK_DESC,
        LINK_CAPTION,
        LINK_ICON,
        LOCATION,
        LATITUDE,
        LONGITUDE
    }

} /* end UnityFriends namespace */
