/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.model;

import com.github.arara.exception.AraraException;
import com.github.arara.model.AraraFilePattern;
import com.github.arara.utils.AraraUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AraraConfiguration {
    private String language;
    private List<String> paths = new ArrayList<String>();
    private List<AraraFilePattern> filetypes = new ArrayList<AraraFilePattern>();
    private RuntimeException pathRuntimeException = null;
    private IOException pathIOException;

    public List<String> getPaths() {
        return this.paths;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setPaths(List<String> rules) throws AraraException, Exception {
        this.paths = rules;
        this.refreshPaths();
    }

    public List<AraraFilePattern> getFiletypes() {
        return this.filetypes;
    }

    public void setFiletypes(List<AraraFilePattern> filetypes) {
        this.filetypes = filetypes;
    }

    private void refreshPaths() throws AraraException, Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userhome", SystemUtils.USER_HOME);
        for (int i = 0; i < this.paths.size(); ++i) {
            try {
                String fullPath = AraraUtils.removeKeyword(this.paths.get(i));
                fullPath = (String)TemplateRuntime.eval(fullPath, map);
                try {
                    File validFile = new File(fullPath);
                    validFile.getCanonicalPath();
                    fullPath = new File(new File(fullPath).toURI()).getPath();
                    this.paths.set(i, fullPath);
                }
                catch (IOException ioException) {
                    if (this.pathIOException != null) continue;
                    this.pathIOException = ioException;
                }
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (this.pathRuntimeException != null) continue;
                this.pathRuntimeException = runtimeException;
            }
        }
    }

    public RuntimeException getPathRuntimeException() {
        return this.pathRuntimeException;
    }

    public IOException getPathIOException() {
        return this.pathIOException;
    }
}

