/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara;

import com.github.arara.model.AraraDirective;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraUtils;
import com.github.arara.utils.CommandLineAnalyzer;
import com.github.arara.utils.CommandTrigger;
import com.github.arara.utils.ConfigurationLoader;
import com.github.arara.utils.DirectiveExtractor;
import com.github.arara.utils.DirectiveParser;
import com.github.arara.utils.TaskDeployer;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Arara {
    static final Logger logger = LoggerFactory.getLogger(Arara.class);
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public static void main(String[] args) {
        int exitStatus;
        try {
            AraraUtils.printHeader();
            ConfigurationLoader configuration = new ConfigurationLoader();
            configuration.load();
            CommandLineAnalyzer commandLine = new CommandLineAnalyzer(args, configuration);
            if (!commandLine.parse()) {
                exitStatus = 0;
                System.exit(exitStatus);
            }
            File file = new File(commandLine.getFile());
            logger.info(localization.getMessage("Log_WelcomeMessage"));
            logger.info(localization.getMessage("Log_ProcessingFile", file.getName()));
            DirectiveExtractor dirExtractor = new DirectiveExtractor(file, configuration);
            dirExtractor.extract();
            List<AraraDirective> directives = dirExtractor.getDirectives();
            boolean overallResult = true;
            if (!directives.isEmpty()) {
                DirectiveParser dirParser = new DirectiveParser(directives);
                dirParser.setFile(file);
                TaskDeployer taskDeployer = new TaskDeployer(dirParser.parse(), configuration);
                CommandTrigger commandTrigger = new CommandTrigger(taskDeployer.deploy());
                commandTrigger.setVerbose(commandLine.isVerbose());
                commandTrigger.setExecutionTimeout(commandLine.getExecutionTimeout());
                overallResult = commandTrigger.execute();
            } else {
                logger.info(localization.getMessage("Log_NoDirectivesFound", file.getName()));
                System.out.println(AraraUtils.wrap(localization.getMessage("Msg_NoDirectivesFound", file.getName())));
            }
            logger.info(localization.getMessage("Log_Done"));
            exitStatus = overallResult ? 0 : 1;
        }
        catch (Exception exception) {
            System.out.println(AraraUtils.wrap(exception.getMessage()));
            logger.error(localization.getMessage("Log_ExceptionRaised"));
            logger.error(exception.getMessage());
            exitStatus = 1;
        }
        System.exit(exitStatus);
    }
}

