## RabbitMQ 3.13.2

RabbitMQ `3.13.2` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * Several Quorum queues WAL and segment file operations are now more resilient to certain filesystem operation failures.

   GitHub issue: [#11113](https://github.com/rabbitmq/rabbitmq-server/pull/11113)

 * Classic queues v2 could run into an exception after a node restart.

   GitHub issue: [#11111](https://github.com/rabbitmq/rabbitmq-server/pull/11111)

 * Peer discovery failed in at some IPv6-only environments. This behavior was new in 3.13.x.

   GitHub issue: [#10728](https://github.com/rabbitmq/rabbitmq-server/issues/10728)

 * `rabbitmqctl stop_app` is now faster, in particular for nodes that are not under significant load.

   GitHub issue: [#11075](https://github.com/rabbitmq/rabbitmq-server/pull/11075)

 * `x-death` counter was not incremented for messages that expired due to [message TTL]().
   This behavior was new in 3.13.x.

   GitHub issue: [#10709](https://github.com/rabbitmq/rabbitmq-server/issues/10709)

 * Quorum queue replica removal now more resilient in clusters under close to peak load,
   a condition that can trigger timeouts for certain operations involving multiple nodes.

   GitHub issue: [#11065](https://github.com/rabbitmq/rabbitmq-server/pull/11065)

 * `rabbitmq-server` (the shell script) now propagetes the exit code from the runtime process.

   Contributed by @giner.

   GitHub issue: [#10819](https://github.com/rabbitmq/rabbitmq-server/pull/10819)

#### Enhancements

 * [Definition import](https://www.rabbitmq.com/docs/definitions) did not handle a scenario where some virtual hosts did not have
   the default queue type metadata key set.

   GitHub issue: [#10897](https://github.com/rabbitmq/rabbitmq-server/pull/10897)

 * When a virtual host is deleted, several more [internal events](https://www.rabbitmq.com/docs/logging#internal-events) are emitted: for example,
   the events related to removal of user permissions and runtime parameters associated
   with the virtual host.

   GitHub issue: [#11077](https://github.com/rabbitmq/rabbitmq-server/pull/11077)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl list_unresponsive_queues` now supports the (queue) `type` column.

   Contributed by @aaron-seo.

   GitHub issue: [#11081](https://github.com/rabbitmq/rabbitmq-server/pull/11081)


### MQTT Plugin

#### Bug Fixes

 * MQTT clients that did not configure a will (message) delay interval could run into
   an exception due to an unnecessary permission check on the will target.

   GitHub issue: [#11024](https://github.com/rabbitmq/rabbitmq-server/pull/11024)

 * Messages published by MQTT clients were missing the `timestamp_in_ms` (the more precise header).
   This behavior was new in 3.13.x.

   GitHub issue: [#10925](https://github.com/rabbitmq/rabbitmq-server/pull/10925)

 * Messages published using QoS 0 were unintentionally marked as durable internally.

   GitHub issue: [#11012](https://github.com/rabbitmq/rabbitmq-server/pull/11012)


### Management Plugin

#### Bug Fixes

 * `GET /api/queues/{vhost}/{name}` could return duplicate keys for quorum queues.

   GitHub issue: [#10929](https://github.com/rabbitmq/rabbitmq-server/issues/10929)

 * Several endpoints responded with a 500 instead of a 404 when target virtual host
   was non-existent.

   Partially contributed by @LoisSotoLopez.

   GitHub issue: [#10901](https://github.com/rabbitmq/rabbitmq-server/issues/10901)


### OAuth 2 AuthN/AuthZ Plugin

#### Enhancements

 * The [OpenID Connect RP-Initiated Logout](https://openid.net/specs/openid-connect-rpinitiated-1_0.html) feature is now only used if the identity provider service
   lists it as supported.

   GitHub issue: [#11067](https://github.com/rabbitmq/rabbitmq-server/issues/11067)


### Kubernetes Peer Discovery Plugin

#### Enhancements

 * More [TLS client settings](https://www.rabbitmq.com/docs/ssl) now can be configured:

   ``` ini
   cluster_formation.k8s.tls.cacertfile = /path/to/kubernetes/api/ca/certificate.pem
   cluster_formation.k8s.tls.certfile = /path/to/client/tls/certificate.pem
   cluster_formation.k8s.tls.keyfile = /path/to/client/tls/private_key.pem

   cluster_formation.k8s.tls.verify = verify_peer
   cluster_formation.k8s.tls.fail_if_no_peer_cert = true

   ```

   GitHub issue: [#10916](https://github.com/rabbitmq/rabbitmq-server/pull/10916)


### JMS Topic Exchange Plugin

#### Enhancements

  * The plugin now stores its state on multiple nodes.

    GitHub issue: [#11091](https://github.com/rabbitmq/rabbitmq-server/pull/11091)


### Shovel Plugin

#### Bug Fixes

 * Shovel metrics and internal state are now deleted when their shovel is, regardless of what node
   it was hosted on and what node was targeted by the deleting (CLI or HTTP API) operation.

   GitHub issue: [#11101](https://github.com/rabbitmq/rabbitmq-server/pull/11101)

 * `rabbitmqctl list_shovels` CLI command now will list shovels running on all cluster nodes
   and not just the target node.

   GitHub issue: [#11119](https://github.com/rabbitmq/rabbitmq-server/pull/11119)


### Dependency Changes

 * `ra` was updated to [`2.10.0`](https://github.com/rabbitmq/ra/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.2.tar.xz`
instead of the source tarball produced by GitHub.
