/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScreen.h"

#include "Screen.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSScreen);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSScreenTableValues[9] =
{
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "colorDepth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenColorDepth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pixelDepth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenPixelDepth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "availLeft", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailLeft), (intptr_t)0 THUNK_GENERATOR(0) },
    { "availTop", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailTop), (intptr_t)0 THUNK_GENERATOR(0) },
    { "availHeight", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "availWidth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSScreenTable = { 18, 15, JSScreenTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSScreenPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSScreenPrototypeTable = { 1, 0, JSScreenPrototypeTableValues, 0 };
const ClassInfo JSScreenPrototype::s_info = { "ScreenPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSScreenPrototypeTable, 0 };

JSObject* JSScreenPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSScreen>(exec, globalObject);
}

const ClassInfo JSScreen::s_info = { "Screen", &JSDOMWrapper::s_info, &JSScreenTable, 0 };

JSScreen::JSScreen(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Screen> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSScreen::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSScreenPrototype(exec->globalData(), globalObject, JSScreenPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSScreen::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSScreen, Base>(exec, &JSScreenTable, this, propertyName, slot);
}

bool JSScreen::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSScreen, Base>(exec, &JSScreenTable, this, propertyName, descriptor);
}

JSValue jsScreenHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->height());
    return result;
}


JSValue jsScreenWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->width());
    return result;
}


JSValue jsScreenColorDepth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->colorDepth());
    return result;
}


JSValue jsScreenPixelDepth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->pixelDepth());
    return result;
}


JSValue jsScreenAvailLeft(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->availLeft());
    return result;
}


JSValue jsScreenAvailTop(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->availTop());
    return result;
}


JSValue jsScreenAvailHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->availHeight());
    return result;
}


JSValue jsScreenAvailWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScreen* castedThis = static_cast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* imp = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(imp->availWidth());
    return result;
}


static inline bool isObservable(JSScreen* jsScreen)
{
    if (jsScreen->hasCustomProperties())
        return true;
    return false;
}

bool JSScreenOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSScreen* jsScreen = static_cast<JSScreen*>(handle.get().asCell());
    if (!isObservable(jsScreen))
        return false;
    Frame* root = jsScreen->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSScreenOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSScreen* jsScreen = static_cast<JSScreen*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsScreen->impl(), jsScreen);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Screen* impl)
{
    return wrap<JSScreen>(exec, globalObject, impl);
}

Screen* toScreen(JSC::JSValue value)
{
    return value.inherits(&JSScreen::s_info) ? static_cast<JSScreen*>(asObject(value))->impl() : 0;
}

}
