/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/OperationXml.h"

#include "Doc/CafCoreTypesDoc/COperationDoc.h"
#include "Doc/ProviderRequestDoc/CProviderInvokeOperationDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderInvokeOperationXml.h"

using namespace Caf;

void ProviderInvokeOperationXml::add(
	const SmartPtrCProviderInvokeOperationDoc providerInvokeOperationDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderInvokeOperationXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerInvokeOperationDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string classNamespaceVal = providerInvokeOperationDoc->getClassNamespace();
		CAF_CM_VALIDATE_STRING(classNamespaceVal);
		thisXml->addAttribute("classNamespace", classNamespaceVal);

		const std::string classNameVal = providerInvokeOperationDoc->getClassName();
		CAF_CM_VALIDATE_STRING(classNameVal);
		thisXml->addAttribute("className", classNameVal);

		const std::string classVersionVal = providerInvokeOperationDoc->getClassVersion();
		CAF_CM_VALIDATE_STRING(classVersionVal);
		thisXml->addAttribute("classVersion", classVersionVal);

		const std::string jobIdVal =
			BasePlatform::UuidToString(providerInvokeOperationDoc->getJobId());
		CAF_CM_VALIDATE_STRING(jobIdVal);
		thisXml->addAttribute("jobId", jobIdVal);

		const std::string outputDirVal = providerInvokeOperationDoc->getOutputDir();
		CAF_CM_VALIDATE_STRING(outputDirVal);
		thisXml->addAttribute("outputDir", outputDirVal);

		const SmartPtrCOperationDoc operationVal =
			providerInvokeOperationDoc->getOperation();
		CAF_CM_VALIDATE_SMARTPTR(operationVal);

		const SmartPtrCXmlElement operationXml =
			thisXml->createAndAddElement("operation");
		OperationXml::add(operationVal, operationXml);
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderInvokeOperationDoc ProviderInvokeOperationXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderInvokeOperationXml", "parse");

	SmartPtrCProviderInvokeOperationDoc providerInvokeOperationDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string classNamespaceStrVal =
			thisXml->findRequiredAttribute("classNamespace");
		const std::string classNamespaceVal = classNamespaceStrVal;

		const std::string classNameStrVal =
			thisXml->findRequiredAttribute("className");
		const std::string classNameVal = classNameStrVal;

		const std::string classVersionStrVal =
			thisXml->findRequiredAttribute("classVersion");
		const std::string classVersionVal = classVersionStrVal;

		const std::string jobIdStrVal =
			thisXml->findRequiredAttribute("jobId");
		UUID jobIdVal = CAFCOMMON_GUID_NULL;
		if (! jobIdStrVal.empty()) {
			BasePlatform::UuidFromString(jobIdStrVal.c_str(), jobIdVal);
		}

		const std::string outputDirStrVal =
			thisXml->findRequiredAttribute("outputDir");
		const std::string outputDirVal = outputDirStrVal;

		const SmartPtrCXmlElement operationXml =
			thisXml->findRequiredChild("operation");

		SmartPtrCOperationDoc operationVal;
		if (! operationXml.IsNull()) {
			operationVal = OperationXml::parse(operationXml);
		}

		providerInvokeOperationDoc.CreateInstance();
		providerInvokeOperationDoc->initialize(
			classNamespaceVal,
			classNameVal,
			classVersionVal,
			jobIdVal,
			outputDirVal,
			operationVal);
	}
	CAF_CM_EXIT;

	return providerInvokeOperationDoc;
}

