/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.gui.datatransfer.InputStreamTransferable;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.util.ReversedList;

public class ImageMapOutputFormat
implements OutputFormat {
    private AffineTransform drawingTransform = new AffineTransform();
    private static boolean DEBUG = true;
    private boolean isIncludeNohref = false;
    private Rectangle bounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("HTML Image Map", "html");
    }

    @Override
    public String getFileExtension() {
        return "html";
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file, Drawing drawing) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.write((OutputStream)bufferedOutputStream, drawing);
        }
        finally {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }

    @Override
    public void write(OutputStream outputStream, Drawing drawing) throws IOException {
        this.write(outputStream, drawing.getChildren());
    }

    public void write(OutputStream outputStream, Drawing drawing, AffineTransform affineTransform, Dimension dimension) throws IOException {
        this.write(outputStream, drawing.getChildren(), affineTransform, dimension);
    }

    public void write(OutputStream outputStream, List<Figure> list, AffineTransform affineTransform, Dimension dimension) throws IOException {
        this.drawingTransform = affineTransform == null ? new AffineTransform() : affineTransform;
        this.bounds = dimension == null ? new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : new Rectangle(0, 0, dimension.width, dimension.height);
        XMLElement xMLElement = new XMLElement("map");
        for (Figure object : new ReversedList<Figure>(list)) {
            this.writeElement(xMLElement, object);
        }
        if (!this.isIncludeNohref) {
            for (int i = xMLElement.getChildrenCount() - 1; i >= 0; --i) {
                XMLElement xMLElement2 = (XMLElement)xMLElement.getChildAtIndex(i);
                if (!xMLElement2.hasAttribute("nohref")) continue;
                xMLElement.removeChildAtIndex(i);
            }
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        for (Object e : xMLElement.getChildren()) {
            XMLElement xMLElement3 = (XMLElement)e;
            new XMLWriter(printWriter).write(xMLElement3);
        }
        printWriter.flush();
    }

    public void write(OutputStream outputStream, List<Figure> list) throws IOException {
        Rectangle2D.Double double_ = null;
        for (Figure figure : list) {
            if (double_ == null) {
                double_ = figure.getBounds();
                continue;
            }
            double_.add(figure.getBounds());
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-Math.min(0.0, double_.x), -Math.min(0.0, double_.y));
        this.write(outputStream, list, affineTransform, new Dimension((int)(Math.abs(double_.x) + double_.width), (int)(Math.abs(double_.y) + double_.height)));
    }

    @Override
    public Transferable createTransferable(Drawing drawing, List<Figure> list, double d) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write((OutputStream)byteArrayOutputStream, list);
        return new InputStreamTransferable(new DataFlavor("text/html", "HTML Image Map"), byteArrayOutputStream.toByteArray());
    }

    protected void writeElement(IXMLElement iXMLElement, Figure figure) throws IOException {
        if (figure instanceof SVGEllipseFigure) {
            this.writeEllipseElement(iXMLElement, (SVGEllipseFigure)figure);
        } else if (figure instanceof SVGGroupFigure) {
            this.writeGElement(iXMLElement, (SVGGroupFigure)figure);
        } else if (figure instanceof SVGImageFigure) {
            this.writeImageElement(iXMLElement, (SVGImageFigure)figure);
        } else if (figure instanceof SVGPathFigure) {
            SVGPathFigure sVGPathFigure = (SVGPathFigure)figure;
            if (sVGPathFigure.getChildCount() == 1) {
                SVGBezierFigure sVGBezierFigure = sVGPathFigure.getChild(0);
                boolean bl = true;
                int n = sVGBezierFigure.getNodeCount();
                for (int i = 0; i < n; ++i) {
                    if (sVGBezierFigure.getNode(i).getMask() == 0) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    if (sVGBezierFigure.isClosed()) {
                        this.writePolygonElement(iXMLElement, sVGPathFigure);
                    } else if (sVGBezierFigure.getNodeCount() == 2) {
                        this.writeLineElement(iXMLElement, sVGPathFigure);
                    } else {
                        this.writePolylineElement(iXMLElement, sVGPathFigure);
                    }
                } else {
                    this.writePathElement(iXMLElement, sVGPathFigure);
                }
            } else {
                this.writePathElement(iXMLElement, sVGPathFigure);
            }
        } else if (figure instanceof SVGRectFigure) {
            this.writeRectElement(iXMLElement, (SVGRectFigure)figure);
        } else if (figure instanceof SVGTextFigure) {
            this.writeTextElement(iXMLElement, (SVGTextFigure)figure);
        } else if (figure instanceof SVGTextAreaFigure) {
            this.writeTextAreaElement(iXMLElement, (SVGTextAreaFigure)figure);
        } else {
            System.out.println("Unable to write: " + figure);
        }
    }

    private boolean writeCircleAttributes(IXMLElement iXMLElement, SVGFigure sVGFigure, Ellipse2D.Double double_) {
        AffineTransform affineTransform = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(sVGFigure);
        if (affineTransform == null) {
            affineTransform = this.drawingTransform;
        } else {
            affineTransform.preConcatenate(this.drawingTransform);
        }
        if ((affineTransform.getType() & 3) == affineTransform.getType() && double_.width == double_.height) {
            Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
            Point2D.Double double_3 = new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
            affineTransform.transform(double_2, double_2);
            affineTransform.transform(double_3, double_3);
            double_.x = Math.min(double_2.x, double_3.x);
            double_.y = Math.min(double_2.y, double_3.y);
            double_.width = Math.abs(double_2.x - double_3.x);
            double_.height = Math.abs(double_2.y - double_3.y);
            iXMLElement.setAttribute("shape", "circle");
            iXMLElement.setAttribute("coords", (int)(double_.x + double_.width / 2.0) + "," + (int)(double_.y + double_.height / 2.0) + "," + (int)(double_.width / 2.0));
            this.writeHrefAttribute(iXMLElement, sVGFigure);
            return this.bounds.intersects(double_.getBounds());
        }
        return this.writePolyAttributes(iXMLElement, sVGFigure, double_);
    }

    private boolean writeRectAttributes(IXMLElement iXMLElement, SVGFigure sVGFigure, Rectangle2D.Double double_) {
        AffineTransform affineTransform = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(sVGFigure);
        if (affineTransform == null) {
            affineTransform = this.drawingTransform;
        } else {
            affineTransform.preConcatenate(this.drawingTransform);
        }
        if ((affineTransform.getType() & 3) == affineTransform.getType()) {
            Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
            Point2D.Double double_3 = new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
            affineTransform.transform(double_2, double_2);
            affineTransform.transform(double_3, double_3);
            Rectangle rectangle = new Rectangle((int)Math.min(double_2.x, double_3.x), (int)Math.min(double_2.y, double_3.y), (int)Math.abs(double_2.x - double_3.x), (int)Math.abs(double_2.y - double_3.y));
            iXMLElement.setAttribute("shape", "rect");
            iXMLElement.setAttribute("coords", rectangle.x + "," + rectangle.y + "," + (rectangle.x + rectangle.width) + "," + (rectangle.y + rectangle.height));
            this.writeHrefAttribute(iXMLElement, sVGFigure);
            return this.bounds.intersects(rectangle);
        }
        return this.writePolyAttributes(iXMLElement, sVGFigure, double_);
    }

    private void writeHrefAttribute(IXMLElement iXMLElement, SVGFigure sVGFigure) {
        String string = sVGFigure.get(SVGAttributeKeys.LINK);
        if (string != null && string.trim().length() > 0) {
            iXMLElement.setAttribute("href", string);
            iXMLElement.setAttribute("title", string);
            iXMLElement.setAttribute("alt", string);
            String string2 = sVGFigure.get(SVGAttributeKeys.LINK_TARGET);
            if (string2 != null && string2.trim().length() > 0) {
                iXMLElement.setAttribute("target", string2);
            }
        } else {
            iXMLElement.setAttribute("nohref", "true");
        }
    }

    private boolean writePolyAttributes(IXMLElement iXMLElement, SVGFigure sVGFigure, Shape shape) {
        AffineTransform affineTransform = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(sVGFigure);
        if (affineTransform == null) {
            affineTransform = this.drawingTransform;
        } else {
            affineTransform.preConcatenate(this.drawingTransform);
        }
        StringBuilder stringBuilder = new StringBuilder();
        float[] fArray = new float[6];
        GeneralPath generalPath = new GeneralPath();
        PathIterator pathIterator = shape.getPathIterator(affineTransform, 1.5);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (stringBuilder.length() != 0) {
                        throw new IllegalArgumentException("Illegal shape " + shape);
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append((int)fArray[0]);
                    stringBuilder.append(',');
                    stringBuilder.append((int)fArray[1]);
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append((int)fArray[0]);
                    stringBuilder.append(',');
                    stringBuilder.append((int)fArray[1]);
                    generalPath.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                default: {
                    throw new InternalError("Illegal segment type " + pathIterator.currentSegment(fArray));
                }
            }
            pathIterator.next();
        }
        iXMLElement.setAttribute("shape", "poly");
        iXMLElement.setAttribute("coords", stringBuilder.toString());
        this.writeHrefAttribute(iXMLElement, sVGFigure);
        return generalPath.intersects(new Rectangle2D.Float(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height));
    }

    private void writePathElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        GrowStroke growStroke = new GrowStroke((float)(SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure) / 2.0), (float)SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure));
        BasicStroke basicStroke = new BasicStroke((float)SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure));
        for (Figure figure : sVGPathFigure.getChildren()) {
            SVGBezierFigure sVGBezierFigure = (SVGBezierFigure)figure;
            IXMLElement iXMLElement2 = iXMLElement.createElement("area");
            if (sVGBezierFigure.isClosed()) {
                this.writePolyAttributes(iXMLElement2, sVGPathFigure, growStroke.createStrokedShape(sVGBezierFigure.getBezierPath()));
            } else {
                this.writePolyAttributes(iXMLElement2, sVGPathFigure, basicStroke.createStrokedShape(sVGBezierFigure.getBezierPath()));
            }
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writePolygonElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("area");
        if (this.writePolyAttributes(iXMLElement2, sVGPathFigure, new GrowStroke((float)(SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure) / 2.0), (float)SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure)).createStrokedShape(sVGPathFigure.getChild(0).getBezierPath()))) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writePolylineElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("area");
        if (this.writePolyAttributes(iXMLElement2, sVGPathFigure, new BasicStroke((float)SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure)).createStrokedShape(sVGPathFigure.getChild(0).getBezierPath()))) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writeLineElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("area");
        if (this.writePolyAttributes(iXMLElement2, sVGPathFigure, new GrowStroke((float)(SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure) / 2.0), (float)SVGAttributeKeys.getStrokeTotalWidth(sVGPathFigure)).createStrokedShape(new Line2D.Double(sVGPathFigure.getStartPoint(), sVGPathFigure.getEndPoint())))) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writeRectElement(IXMLElement iXMLElement, SVGRectFigure sVGRectFigure) throws IOException {
        boolean bl;
        IXMLElement iXMLElement2 = iXMLElement.createElement("AREA");
        if (sVGRectFigure.getArcHeight() == 0.0 && sVGRectFigure.getArcWidth() == 0.0) {
            Rectangle2D.Double double_ = sVGRectFigure.getBounds();
            double d = SVGAttributeKeys.getPerpendicularHitGrowth(sVGRectFigure);
            double_.x -= d;
            double_.y -= d;
            double_.width += d;
            double_.height += d;
            bl = this.writeRectAttributes(iXMLElement2, sVGRectFigure, double_);
        } else {
            bl = this.writePolyAttributes(iXMLElement2, sVGRectFigure, new GrowStroke((float)(SVGAttributeKeys.getStrokeTotalWidth(sVGRectFigure) / 2.0), (float)SVGAttributeKeys.getStrokeTotalWidth(sVGRectFigure)).createStrokedShape(new RoundRectangle2D.Double(sVGRectFigure.getX(), sVGRectFigure.getY(), sVGRectFigure.getWidth(), sVGRectFigure.getHeight(), sVGRectFigure.getArcWidth(), sVGRectFigure.getArcHeight())));
        }
        if (bl) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writeTextElement(IXMLElement iXMLElement, SVGTextFigure sVGTextFigure) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("AREA");
        Rectangle2D.Double double_ = sVGTextFigure.getBounds();
        double d = SVGAttributeKeys.getPerpendicularHitGrowth(sVGTextFigure);
        double_.x -= d;
        double_.y -= d;
        double_.width += d;
        double_.height += d;
        if (this.writeRectAttributes(iXMLElement2, sVGTextFigure, double_)) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writeTextAreaElement(IXMLElement iXMLElement, SVGTextAreaFigure sVGTextAreaFigure) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("AREA");
        Rectangle2D.Double double_ = sVGTextAreaFigure.getBounds();
        double d = SVGAttributeKeys.getPerpendicularHitGrowth(sVGTextAreaFigure);
        double_.x -= d;
        double_.y -= d;
        double_.width += d;
        double_.height += d;
        if (this.writeRectAttributes(iXMLElement2, sVGTextAreaFigure, double_)) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writeEllipseElement(IXMLElement iXMLElement, SVGEllipseFigure sVGEllipseFigure) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("area");
        Rectangle2D.Double double_ = sVGEllipseFigure.getBounds();
        double d = SVGAttributeKeys.getPerpendicularHitGrowth(sVGEllipseFigure);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(double_.x - d, double_.y - d, double_.width + d, double_.height + d);
        if (this.writeCircleAttributes(iXMLElement2, sVGEllipseFigure, double_2)) {
            iXMLElement.addChild(iXMLElement2);
        }
    }

    private void writeGElement(IXMLElement iXMLElement, SVGGroupFigure sVGGroupFigure) throws IOException {
        for (Figure figure : new ReversedList<Figure>(sVGGroupFigure.getChildren())) {
            this.writeElement(iXMLElement, figure);
        }
    }

    private void writeImageElement(IXMLElement iXMLElement, SVGImageFigure sVGImageFigure) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("area");
        Rectangle2D.Double double_ = sVGImageFigure.getBounds();
        this.writeRectAttributes(iXMLElement2, sVGImageFigure, double_);
        iXMLElement.addChild(iXMLElement2);
    }
}

