/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.Locator;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorFile
implements Locator {
    static Logger log = LoggerFactory.getLogger(LocatorFile.class);
    private String thisDir = null;
    private String thisDirLogStr = "";

    public LocatorFile(String dir) {
        if (dir != null) {
            if (dir.endsWith("/") || dir.endsWith(File.separator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            this.thisDirLogStr = " [" + dir + "]";
        }
        this.thisDir = dir;
    }

    LocatorFile() {
        this(null);
    }

    public boolean equals(Object other) {
        return other instanceof LocatorFile && this.equals(this.thisDir, ((LocatorFile)other).thisDir);
    }

    private boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode() {
        if (this.thisDir == null) {
            return 157;
        }
        return this.thisDir.hashCode();
    }

    private File toFile(String filenameOrURI) {
        String fn = FileUtils.toFilename(filenameOrURI);
        if (fn == null) {
            return null;
        }
        if (this.thisDir != null && !fn.startsWith("/") && !fn.startsWith(FileManager.filePathSeparator)) {
            fn = this.thisDir + File.separator + fn;
        }
        return new File(fn);
    }

    public boolean exists(String filenameOrURI) {
        File f = this.toFile(filenameOrURI);
        if (f == null) {
            return false;
        }
        return f.exists();
    }

    @Override
    public TypedStream open(String filenameOrURI) {
        File f = this.toFile(filenameOrURI);
        try {
            if (f == null || !f.exists()) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameOrURI + this.thisDirLogStr);
                }
                return null;
            }
        }
        catch (AccessControlException e) {
            log.warn("Security problem testing for file", e);
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(f);
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI + this.thisDirLogStr);
            }
            return new TypedStream(in);
        }
        catch (IOException ioEx) {
            log.warn("File unreadable (but exists): " + f.getPath() + " Exception: " + ioEx.getMessage());
            return null;
        }
    }

    public String getDir() {
        return this.thisDir;
    }

    @Override
    public String getName() {
        String tmp = "LocatorFile";
        if (this.thisDir != null) {
            tmp = tmp + "(" + this.thisDir + ")";
        }
        return tmp;
    }
}

