/* benchmark.c generated by valac 0.54.6, the Vala compiler
 * generated from benchmark.vala, do not modify */

/* benchmark.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois

 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <glib-object.h>
#include <gee-internals.h>
#include <math.h>
#include <float.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEE_BENCHMARK_TYPE_FACTORY (gee_benchmark_factory_get_type ())
#define GEE_BENCHMARK_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_FACTORY, GeeBenchmarkFactory))
#define GEE_BENCHMARK_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_FACTORY))
#define GEE_BENCHMARK_FACTORY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_FACTORY, GeeBenchmarkFactoryIface))

typedef struct _GeeBenchmarkFactory GeeBenchmarkFactory;
typedef struct _GeeBenchmarkFactoryIface GeeBenchmarkFactoryIface;

#define GEE_BENCHMARK_TYPE_GENERATOR (gee_benchmark_generator_get_type ())
#define GEE_BENCHMARK_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_GENERATOR, GeeBenchmarkGenerator))
#define GEE_BENCHMARK_IS_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_GENERATOR))
#define GEE_BENCHMARK_GENERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_GENERATOR, GeeBenchmarkGeneratorIface))

typedef struct _GeeBenchmarkGenerator GeeBenchmarkGenerator;
typedef struct _GeeBenchmarkGeneratorIface GeeBenchmarkGeneratorIface;

#define GEE_BENCHMARK_TYPE_ALGORITHM (gee_benchmark_algorithm_get_type ())
#define GEE_BENCHMARK_ALGORITHM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_ALGORITHM, GeeBenchmarkAlgorithm))
#define GEE_BENCHMARK_IS_ALGORITHM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_ALGORITHM))
#define GEE_BENCHMARK_ALGORITHM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_ALGORITHM, GeeBenchmarkAlgorithmIface))

typedef struct _GeeBenchmarkAlgorithm GeeBenchmarkAlgorithm;
typedef struct _GeeBenchmarkAlgorithmIface GeeBenchmarkAlgorithmIface;

#define GEE_BENCHMARK_TYPE_RANDOM_INT32 (gee_benchmark_random_int32_get_type ())
#define GEE_BENCHMARK_RANDOM_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32))
#define GEE_BENCHMARK_RANDOM_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32Class))
#define GEE_BENCHMARK_IS_RANDOM_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32))
#define GEE_BENCHMARK_IS_RANDOM_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_RANDOM_INT32))
#define GEE_BENCHMARK_RANDOM_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32Class))

typedef struct _GeeBenchmarkRandomInt32 GeeBenchmarkRandomInt32;
typedef struct _GeeBenchmarkRandomInt32Class GeeBenchmarkRandomInt32Class;
typedef struct _GeeBenchmarkRandomInt32Private GeeBenchmarkRandomInt32Private;
enum  {
	GEE_BENCHMARK_RANDOM_INT32_0_PROPERTY,
	GEE_BENCHMARK_RANDOM_INT32_NAME_PROPERTY,
	GEE_BENCHMARK_RANDOM_INT32_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_random_int32_properties[GEE_BENCHMARK_RANDOM_INT32_NUM_PROPERTIES];

#define GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32 (gee_benchmark_fixed_variance_int32_get_type ())
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32))
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32Class))
#define GEE_BENCHMARK_IS_FIXED_VARIANCE_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32))
#define GEE_BENCHMARK_IS_FIXED_VARIANCE_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32))
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32Class))

typedef struct _GeeBenchmarkFixedVarianceInt32 GeeBenchmarkFixedVarianceInt32;
typedef struct _GeeBenchmarkFixedVarianceInt32Class GeeBenchmarkFixedVarianceInt32Class;
typedef struct _GeeBenchmarkFixedVarianceInt32Private GeeBenchmarkFixedVarianceInt32Private;
enum  {
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_0_PROPERTY,
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME_PROPERTY,
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_fixed_variance_int32_properties[GEE_BENCHMARK_FIXED_VARIANCE_INT32_NUM_PROPERTIES];

#define GEE_BENCHMARK_TYPE_MOUNTS_INT32 (gee_benchmark_mounts_int32_get_type ())
#define GEE_BENCHMARK_MOUNTS_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32))
#define GEE_BENCHMARK_MOUNTS_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32Class))
#define GEE_BENCHMARK_IS_MOUNTS_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32))
#define GEE_BENCHMARK_IS_MOUNTS_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_MOUNTS_INT32))
#define GEE_BENCHMARK_MOUNTS_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32Class))

typedef struct _GeeBenchmarkMountsInt32 GeeBenchmarkMountsInt32;
typedef struct _GeeBenchmarkMountsInt32Class GeeBenchmarkMountsInt32Class;
typedef struct _GeeBenchmarkMountsInt32Private GeeBenchmarkMountsInt32Private;
enum  {
	GEE_BENCHMARK_MOUNTS_INT32_0_PROPERTY,
	GEE_BENCHMARK_MOUNTS_INT32_NAME_PROPERTY,
	GEE_BENCHMARK_MOUNTS_INT32_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_mounts_int32_properties[GEE_BENCHMARK_MOUNTS_INT32_NUM_PROPERTIES];

#define GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32 (gee_benchmark_reverse_sorted_int32_get_type ())
#define GEE_BENCHMARK_REVERSE_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32))
#define GEE_BENCHMARK_REVERSE_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32Class))
#define GEE_BENCHMARK_IS_REVERSE_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32))
#define GEE_BENCHMARK_IS_REVERSE_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32))
#define GEE_BENCHMARK_REVERSE_SORTED_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32Class))

typedef struct _GeeBenchmarkReverseSortedInt32 GeeBenchmarkReverseSortedInt32;
typedef struct _GeeBenchmarkReverseSortedInt32Class GeeBenchmarkReverseSortedInt32Class;
typedef struct _GeeBenchmarkReverseSortedInt32Private GeeBenchmarkReverseSortedInt32Private;
enum  {
	GEE_BENCHMARK_REVERSE_SORTED_INT32_0_PROPERTY,
	GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME_PROPERTY,
	GEE_BENCHMARK_REVERSE_SORTED_INT32_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_reverse_sorted_int32_properties[GEE_BENCHMARK_REVERSE_SORTED_INT32_NUM_PROPERTIES];

#define GEE_BENCHMARK_TYPE_SORTED_INT32 (gee_benchmark_sorted_int32_get_type ())
#define GEE_BENCHMARK_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32))
#define GEE_BENCHMARK_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32Class))
#define GEE_BENCHMARK_IS_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32))
#define GEE_BENCHMARK_IS_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_SORTED_INT32))
#define GEE_BENCHMARK_SORTED_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32Class))

typedef struct _GeeBenchmarkSortedInt32 GeeBenchmarkSortedInt32;
typedef struct _GeeBenchmarkSortedInt32Class GeeBenchmarkSortedInt32Class;
typedef struct _GeeBenchmarkSortedInt32Private GeeBenchmarkSortedInt32Private;
enum  {
	GEE_BENCHMARK_SORTED_INT32_0_PROPERTY,
	GEE_BENCHMARK_SORTED_INT32_NAME_PROPERTY,
	GEE_BENCHMARK_SORTED_INT32_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_sorted_int32_properties[GEE_BENCHMARK_SORTED_INT32_NUM_PROPERTIES];

#define GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY (gee_benchmark_array_list_factory_get_type ())
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory))
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryClass))
#define GEE_BENCHMARK_IS_ARRAY_LIST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY))
#define GEE_BENCHMARK_IS_ARRAY_LIST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY))
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryClass))

typedef struct _GeeBenchmarkArrayListFactory GeeBenchmarkArrayListFactory;
typedef struct _GeeBenchmarkArrayListFactoryClass GeeBenchmarkArrayListFactoryClass;
typedef struct _GeeBenchmarkArrayListFactoryPrivate GeeBenchmarkArrayListFactoryPrivate;
enum  {
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_0_PROPERTY,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_array_list_factory_properties[GEE_BENCHMARK_ARRAY_LIST_FACTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_BENCHMARK_TYPE_BENCHMARK (gee_benchmark_benchmark_get_type ())
#define GEE_BENCHMARK_BENCHMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark))
#define GEE_BENCHMARK_BENCHMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkClass))
#define GEE_BENCHMARK_IS_BENCHMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_BENCHMARK))
#define GEE_BENCHMARK_IS_BENCHMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_BENCHMARK))
#define GEE_BENCHMARK_BENCHMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkClass))

typedef struct _GeeBenchmarkBenchmark GeeBenchmarkBenchmark;
typedef struct _GeeBenchmarkBenchmarkClass GeeBenchmarkBenchmarkClass;
typedef struct _GeeBenchmarkBenchmarkPrivate GeeBenchmarkBenchmarkPrivate;
enum  {
	GEE_BENCHMARK_BENCHMARK_0_PROPERTY,
	GEE_BENCHMARK_BENCHMARK_G_TYPE,
	GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC,
	GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC,
	GEE_BENCHMARK_BENCHMARK_NUM_PROPERTIES
};
static GParamSpec* gee_benchmark_benchmark_properties[GEE_BENCHMARK_BENCHMARK_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _GeeBenchmarkFactoryIface {
	GTypeInterface parent_iface;
	GeeCollection* (*create) (GeeBenchmarkFactory* self);
	GeeCollection* (*copy) (GeeBenchmarkFactory* self, GeeCollection* collection);
};

struct _GeeBenchmarkGeneratorIface {
	GTypeInterface parent_iface;
	void (*generate_collection) (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection);
	const gchar* (*get_name) (GeeBenchmarkGenerator* self);
};

struct _GeeBenchmarkAlgorithmIface {
	GTypeInterface parent_iface;
	void (*process_collection) (GeeBenchmarkAlgorithm* self, GeeCollection* collection);
	const gchar* (*get_name) (GeeBenchmarkAlgorithm* self);
};

struct _GeeBenchmarkRandomInt32 {
	GObject parent_instance;
	GeeBenchmarkRandomInt32Private * priv;
};

struct _GeeBenchmarkRandomInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkFixedVarianceInt32 {
	GObject parent_instance;
	GeeBenchmarkFixedVarianceInt32Private * priv;
};

struct _GeeBenchmarkFixedVarianceInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkMountsInt32 {
	GObject parent_instance;
	GeeBenchmarkMountsInt32Private * priv;
};

struct _GeeBenchmarkMountsInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkReverseSortedInt32 {
	GObject parent_instance;
	GeeBenchmarkReverseSortedInt32Private * priv;
};

struct _GeeBenchmarkReverseSortedInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkSortedInt32 {
	GObject parent_instance;
	GeeBenchmarkSortedInt32Private * priv;
};

struct _GeeBenchmarkSortedInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkArrayListFactory {
	GObject parent_instance;
	GeeBenchmarkArrayListFactoryPrivate * priv;
};

struct _GeeBenchmarkArrayListFactoryClass {
	GObjectClass parent_class;
};

struct _GeeBenchmarkArrayListFactoryPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeBenchmarkBenchmark {
	GObject parent_instance;
	GeeBenchmarkBenchmarkPrivate * priv;
};

struct _GeeBenchmarkBenchmarkClass {
	GObjectClass parent_class;
};

struct _GeeBenchmarkBenchmarkPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeBenchmarkFactory* factory;
	gint* sizes;
	gint sizes_length1;
	gint _sizes_size_;
	GeeList* generators;
	GeeList* algorithms;
	gint iteration_count;
	gdouble* results_sum;
	gint results_sum_length1;
	gint results_sum_length2;
	gint results_sum_length3;
	gdouble* results_squared_sum;
	gint results_squared_sum_length1;
	gint results_squared_sum_length2;
	gint results_squared_sum_length3;
};

static gpointer gee_benchmark_random_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface * gee_benchmark_random_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_fixed_variance_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface * gee_benchmark_fixed_variance_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_mounts_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface * gee_benchmark_mounts_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_reverse_sorted_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface * gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_sorted_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface * gee_benchmark_sorted_int32_gee_benchmark_generator_parent_iface = NULL;
static gint GeeBenchmarkArrayListFactory_private_offset;
static gpointer gee_benchmark_array_list_factory_parent_class = NULL;
static GeeBenchmarkFactoryIface * gee_benchmark_array_list_factory_gee_benchmark_factory_parent_iface = NULL;
static gint GeeBenchmarkBenchmark_private_offset;
static gpointer gee_benchmark_benchmark_parent_class = NULL;

 G_GNUC_INTERNAL void gee_benchmark_run_benchmark_option (const gchar* long_name,
                                         gchar short_name,
                                         const gchar* description,
                                         gboolean* do_run,
                                         GOptionEntry* result);
 G_GNUC_INTERNAL static gint gee_benchmark_main (gchar** args,
                         gint args_length1);
VALA_EXTERN void gee_benchmark_benchmark_sorts (void);
VALA_EXTERN GType gee_benchmark_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeCollection* gee_benchmark_factory_create (GeeBenchmarkFactory* self);
VALA_EXTERN GeeCollection* gee_benchmark_factory_copy (GeeBenchmarkFactory* self,
                                           GeeCollection* collection);
static GType gee_benchmark_factory_get_type_once (void);
VALA_EXTERN GType gee_benchmark_generator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gee_benchmark_generator_generate_collection (GeeBenchmarkGenerator* self,
                                                  gint size,
                                                  GeeCollection* collection);
VALA_EXTERN const gchar* gee_benchmark_generator_get_name (GeeBenchmarkGenerator* self);
static GType gee_benchmark_generator_get_type_once (void);
VALA_EXTERN GType gee_benchmark_algorithm_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gee_benchmark_algorithm_process_collection (GeeBenchmarkAlgorithm* self,
                                                 GeeCollection* collection);
VALA_EXTERN const gchar* gee_benchmark_algorithm_get_name (GeeBenchmarkAlgorithm* self);
static GType gee_benchmark_algorithm_get_type_once (void);
VALA_EXTERN GType gee_benchmark_random_int32_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkRandomInt32, g_object_unref)
static void gee_benchmark_random_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                          gint size,
                                                          GeeCollection* collection);
VALA_EXTERN GeeBenchmarkRandomInt32* gee_benchmark_random_int32_new (void);
VALA_EXTERN GeeBenchmarkRandomInt32* gee_benchmark_random_int32_construct (GType object_type);
static GType gee_benchmark_random_int32_get_type_once (void);
static void _vala_gee_benchmark_random_int32_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN GType gee_benchmark_fixed_variance_int32_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkFixedVarianceInt32, g_object_unref)
static void gee_benchmark_fixed_variance_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                                  gint size,
                                                                  GeeCollection* collection);
VALA_EXTERN GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_new (void);
VALA_EXTERN GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_construct (GType object_type);
static GType gee_benchmark_fixed_variance_int32_get_type_once (void);
static void _vala_gee_benchmark_fixed_variance_int32_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
VALA_EXTERN GType gee_benchmark_mounts_int32_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkMountsInt32, g_object_unref)
static void gee_benchmark_mounts_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                          gint size,
                                                          GeeCollection* collection);
VALA_EXTERN GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_new (void);
VALA_EXTERN GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_construct (GType object_type);
static GType gee_benchmark_mounts_int32_get_type_once (void);
static void _vala_gee_benchmark_mounts_int32_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN GType gee_benchmark_reverse_sorted_int32_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkReverseSortedInt32, g_object_unref)
static void gee_benchmark_reverse_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                                  gint size,
                                                                  GeeCollection* collection);
VALA_EXTERN GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_new (void);
VALA_EXTERN GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_construct (GType object_type);
static GType gee_benchmark_reverse_sorted_int32_get_type_once (void);
static void _vala_gee_benchmark_reverse_sorted_int32_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
VALA_EXTERN GType gee_benchmark_sorted_int32_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkSortedInt32, g_object_unref)
static void gee_benchmark_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                          gint size,
                                                          GeeCollection* collection);
VALA_EXTERN GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_new (void);
VALA_EXTERN GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_construct (GType object_type);
static GType gee_benchmark_sorted_int32_get_type_once (void);
static void _vala_gee_benchmark_sorted_int32_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN GType gee_benchmark_array_list_factory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkArrayListFactory, g_object_unref)
static GeeCollection* gee_benchmark_array_list_factory_real_create (GeeBenchmarkFactory* base);
static GeeCollection* gee_benchmark_array_list_factory_real_copy (GeeBenchmarkFactory* base,
                                                           GeeCollection* collection);
VALA_EXTERN GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_new (GType g_type,
                                                                    GBoxedCopyFunc g_dup_func,
                                                                    GDestroyNotify g_destroy_func);
VALA_EXTERN GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_construct (GType object_type,
                                                                          GType g_type,
                                                                          GBoxedCopyFunc g_dup_func,
                                                                          GDestroyNotify g_destroy_func);
static GType gee_benchmark_array_list_factory_get_type_once (void);
static void _vala_gee_benchmark_array_list_factory_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_gee_benchmark_array_list_factory_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
VALA_EXTERN GType gee_benchmark_benchmark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeBenchmarkBenchmark, g_object_unref)
VALA_EXTERN GeeBenchmarkBenchmark* gee_benchmark_benchmark_new (GType g_type,
                                                    GBoxedCopyFunc g_dup_func,
                                                    GDestroyNotify g_destroy_func,
                                                    GeeBenchmarkFactory* factory,
                                                    GeeList* algorithms,
                                                    GeeList* generators,
                                                    gint* sizes,
                                                    gint sizes_length1,
                                                    gint iteration_count);
VALA_EXTERN GeeBenchmarkBenchmark* gee_benchmark_benchmark_construct (GType object_type,
                                                          GType g_type,
                                                          GBoxedCopyFunc g_dup_func,
                                                          GDestroyNotify g_destroy_func,
                                                          GeeBenchmarkFactory* factory,
                                                          GeeList* algorithms,
                                                          GeeList* generators,
                                                          gint* sizes,
                                                          gint sizes_length1,
                                                          gint iteration_count);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
VALA_EXTERN void gee_benchmark_benchmark_run (GeeBenchmarkBenchmark* self);
VALA_EXTERN void gee_benchmark_benchmark_display_results (GeeBenchmarkBenchmark* self,
                                              gint iteration);
static void gee_benchmark_benchmark_finalize (GObject * obj);
static GType gee_benchmark_benchmark_get_type_once (void);
static void _vala_gee_benchmark_benchmark_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gee_benchmark_benchmark_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

 G_GNUC_INTERNAL void
gee_benchmark_run_benchmark_option (const gchar* long_name,
                                    gchar short_name,
                                    const gchar* description,
                                    gboolean* do_run,
                                    GOptionEntry* result)
{
	GOptionEntry _tmp0_ = {0};
	g_return_if_fail (long_name != NULL);
	g_return_if_fail (description != NULL);
	memset (&_tmp0_, 0, sizeof (GOptionEntry));
	_tmp0_.long_name = long_name;
	_tmp0_.short_name = short_name;
	_tmp0_.flags = (gint) 0;
	_tmp0_.arg = G_OPTION_ARG_NONE;
	_tmp0_.arg_data = do_run;
	_tmp0_.description = description;
	_tmp0_.arg_description = NULL;
	*result = _tmp0_;
	return;
}

 G_GNUC_INTERNAL static gint
gee_benchmark_main (gchar** args,
                    gint args_length1)
{
	gboolean run_sort = FALSE;
	GOptionEntry* entries = NULL;
	GOptionEntry _tmp0_ = {0};
	GOptionEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionEntry* _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	run_sort = FALSE;
	gee_benchmark_run_benchmark_option ("run-sort", 's', "Run sorting benchmark", &run_sort, &_tmp0_);
	_tmp1_ = g_new0 (GOptionEntry, 1);
	_tmp1_[0] = _tmp0_;
	entries = _tmp1_;
	entries_length1 = 1;
	_entries_size_ = entries_length1;
	_tmp2_ = g_option_context_new ("Run various benchmarks");
	context = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = entries;
	_tmp4__length1 = entries_length1;
	g_option_context_add_main_entries (_tmp3_, _tmp4_, "gee-benchmark");
	{
		GOptionContext* _tmp5_;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp6_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			entries = (g_free (entries), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "option parsing failed: %s\n", _tmp9_);
		result = 2;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		entries = (g_free (entries), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		_g_option_context_free0 (context);
		entries = (g_free (entries), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (run_sort) {
		gee_benchmark_benchmark_sorts ();
	}
	result = 0;
	_g_option_context_free0 (context);
	entries = (g_free (entries), NULL);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return gee_benchmark_main (argv, argc);
}

GeeCollection*
gee_benchmark_factory_create (GeeBenchmarkFactory* self)
{
	GeeBenchmarkFactoryIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_BENCHMARK_FACTORY_GET_INTERFACE (self);
	if (_iface_->create) {
		return _iface_->create (self);
	}
	return NULL;
}

GeeCollection*
gee_benchmark_factory_copy (GeeBenchmarkFactory* self,
                            GeeCollection* collection)
{
	GeeBenchmarkFactoryIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_BENCHMARK_FACTORY_GET_INTERFACE (self);
	if (_iface_->copy) {
		return _iface_->copy (self, collection);
	}
	return NULL;
}

static void
gee_benchmark_factory_default_init (GeeBenchmarkFactoryIface * iface,
                                    gpointer iface_data)
{
}

static GType
gee_benchmark_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkFactoryIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_factory_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_benchmark_factory_type_id;
	gee_benchmark_factory_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkFactory", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_benchmark_factory_type_id, G_TYPE_OBJECT);
	return gee_benchmark_factory_type_id;
}

GType
gee_benchmark_factory_get_type (void)
{
	static volatile gsize gee_benchmark_factory_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_factory_type_id__volatile)) {
		GType gee_benchmark_factory_type_id;
		gee_benchmark_factory_type_id = gee_benchmark_factory_get_type_once ();
		g_once_init_leave (&gee_benchmark_factory_type_id__volatile, gee_benchmark_factory_type_id);
	}
	return gee_benchmark_factory_type_id__volatile;
}

void
gee_benchmark_generator_generate_collection (GeeBenchmarkGenerator* self,
                                             gint size,
                                             GeeCollection* collection)
{
	GeeBenchmarkGeneratorIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_BENCHMARK_GENERATOR_GET_INTERFACE (self);
	if (_iface_->generate_collection) {
		_iface_->generate_collection (self, size, collection);
	}
}

const gchar*
gee_benchmark_generator_get_name (GeeBenchmarkGenerator* self)
{
	GeeBenchmarkGeneratorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_BENCHMARK_GENERATOR_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

static void
gee_benchmark_generator_default_init (GeeBenchmarkGeneratorIface * iface,
                                      gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_benchmark_generator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkGeneratorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_generator_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_benchmark_generator_type_id;
	gee_benchmark_generator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkGenerator", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_benchmark_generator_type_id, G_TYPE_OBJECT);
	return gee_benchmark_generator_type_id;
}

GType
gee_benchmark_generator_get_type (void)
{
	static volatile gsize gee_benchmark_generator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_generator_type_id__volatile)) {
		GType gee_benchmark_generator_type_id;
		gee_benchmark_generator_type_id = gee_benchmark_generator_get_type_once ();
		g_once_init_leave (&gee_benchmark_generator_type_id__volatile, gee_benchmark_generator_type_id);
	}
	return gee_benchmark_generator_type_id__volatile;
}

void
gee_benchmark_algorithm_process_collection (GeeBenchmarkAlgorithm* self,
                                            GeeCollection* collection)
{
	GeeBenchmarkAlgorithmIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_BENCHMARK_ALGORITHM_GET_INTERFACE (self);
	if (_iface_->process_collection) {
		_iface_->process_collection (self, collection);
	}
}

const gchar*
gee_benchmark_algorithm_get_name (GeeBenchmarkAlgorithm* self)
{
	GeeBenchmarkAlgorithmIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_BENCHMARK_ALGORITHM_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

static void
gee_benchmark_algorithm_default_init (GeeBenchmarkAlgorithmIface * iface,
                                      gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_benchmark_algorithm_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkAlgorithmIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_algorithm_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_benchmark_algorithm_type_id;
	gee_benchmark_algorithm_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkAlgorithm", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_benchmark_algorithm_type_id, G_TYPE_OBJECT);
	return gee_benchmark_algorithm_type_id;
}

GType
gee_benchmark_algorithm_get_type (void)
{
	static volatile gsize gee_benchmark_algorithm_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_algorithm_type_id__volatile)) {
		GType gee_benchmark_algorithm_type_id;
		gee_benchmark_algorithm_type_id = gee_benchmark_algorithm_get_type_once ();
		g_once_init_leave (&gee_benchmark_algorithm_type_id__volatile, gee_benchmark_algorithm_type_id);
	}
	return gee_benchmark_algorithm_type_id__volatile;
}

static void
gee_benchmark_random_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                     gint size,
                                                     GeeCollection* collection)
{
	GeeBenchmarkRandomInt32 * self;
	self = (GeeBenchmarkRandomInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				gee_collection_add (collection, (gpointer) ((gintptr) g_random_int_range ((gint32) 0, (gint32) (size - 1))));
			}
		}
	}
}

GeeBenchmarkRandomInt32*
gee_benchmark_random_int32_construct (GType object_type)
{
	GeeBenchmarkRandomInt32 * self = NULL;
	self = (GeeBenchmarkRandomInt32*) g_object_new (object_type, NULL);
	return self;
}

GeeBenchmarkRandomInt32*
gee_benchmark_random_int32_new (void)
{
	return gee_benchmark_random_int32_construct (GEE_BENCHMARK_TYPE_RANDOM_INT32);
}

static const gchar*
gee_benchmark_random_int32_real_get_name (GeeBenchmarkGenerator* base)
{
	const gchar* result;
	GeeBenchmarkRandomInt32* self;
	self = (GeeBenchmarkRandomInt32*) base;
	result = "FullRandom";
	return result;
}

static void
gee_benchmark_random_int32_class_init (GeeBenchmarkRandomInt32Class * klass,
                                       gpointer klass_data)
{
	gee_benchmark_random_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_random_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_RANDOM_INT32_NAME_PROPERTY, gee_benchmark_random_int32_properties[GEE_BENCHMARK_RANDOM_INT32_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_benchmark_random_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface,
                                                                   gpointer iface_data)
{
	gee_benchmark_random_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*) (GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_random_int32_real_generate_collection;
	iface->get_name = gee_benchmark_random_int32_real_get_name;
}

static void
gee_benchmark_random_int32_instance_init (GeeBenchmarkRandomInt32 * self,
                                          gpointer klass)
{
}

static GType
gee_benchmark_random_int32_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkRandomInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_random_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkRandomInt32), 0, (GInstanceInitFunc) gee_benchmark_random_int32_instance_init, NULL };
	static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_random_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_benchmark_random_int32_type_id;
	gee_benchmark_random_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkRandomInt32", &g_define_type_info, 0);
	g_type_add_interface_static (gee_benchmark_random_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
	return gee_benchmark_random_int32_type_id;
}

GType
gee_benchmark_random_int32_get_type (void)
{
	static volatile gsize gee_benchmark_random_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_random_int32_type_id__volatile)) {
		GType gee_benchmark_random_int32_type_id;
		gee_benchmark_random_int32_type_id = gee_benchmark_random_int32_get_type_once ();
		g_once_init_leave (&gee_benchmark_random_int32_type_id__volatile, gee_benchmark_random_int32_type_id);
	}
	return gee_benchmark_random_int32_type_id__volatile;
}

static void
_vala_gee_benchmark_random_int32_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GeeBenchmarkRandomInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32);
	switch (property_id) {
		case GEE_BENCHMARK_RANDOM_INT32_NAME_PROPERTY:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_benchmark_fixed_variance_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                             gint size,
                                                             GeeCollection* collection)
{
	GeeBenchmarkFixedVarianceInt32 * self;
	gint variance = 0;
	self = (GeeBenchmarkFixedVarianceInt32*) base;
	g_return_if_fail (collection != NULL);
	variance = (gint) sqrt ((gdouble) size);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				gee_collection_add (collection, (gpointer) ((gintptr) ((i + g_random_int_range ((gint32) 0, (gint32) variance)) - (variance / 2))));
			}
		}
	}
}

GeeBenchmarkFixedVarianceInt32*
gee_benchmark_fixed_variance_int32_construct (GType object_type)
{
	GeeBenchmarkFixedVarianceInt32 * self = NULL;
	self = (GeeBenchmarkFixedVarianceInt32*) g_object_new (object_type, NULL);
	return self;
}

GeeBenchmarkFixedVarianceInt32*
gee_benchmark_fixed_variance_int32_new (void)
{
	return gee_benchmark_fixed_variance_int32_construct (GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32);
}

static const gchar*
gee_benchmark_fixed_variance_int32_real_get_name (GeeBenchmarkGenerator* base)
{
	const gchar* result;
	GeeBenchmarkFixedVarianceInt32* self;
	self = (GeeBenchmarkFixedVarianceInt32*) base;
	result = "FixedVariance";
	return result;
}

static void
gee_benchmark_fixed_variance_int32_class_init (GeeBenchmarkFixedVarianceInt32Class * klass,
                                               gpointer klass_data)
{
	gee_benchmark_fixed_variance_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_fixed_variance_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME_PROPERTY, gee_benchmark_fixed_variance_int32_properties[GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_benchmark_fixed_variance_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface,
                                                                           gpointer iface_data)
{
	gee_benchmark_fixed_variance_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*) (GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_fixed_variance_int32_real_generate_collection;
	iface->get_name = gee_benchmark_fixed_variance_int32_real_get_name;
}

static void
gee_benchmark_fixed_variance_int32_instance_init (GeeBenchmarkFixedVarianceInt32 * self,
                                                  gpointer klass)
{
}

static GType
gee_benchmark_fixed_variance_int32_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkFixedVarianceInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_fixed_variance_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkFixedVarianceInt32), 0, (GInstanceInitFunc) gee_benchmark_fixed_variance_int32_instance_init, NULL };
	static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_fixed_variance_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_benchmark_fixed_variance_int32_type_id;
	gee_benchmark_fixed_variance_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkFixedVarianceInt32", &g_define_type_info, 0);
	g_type_add_interface_static (gee_benchmark_fixed_variance_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
	return gee_benchmark_fixed_variance_int32_type_id;
}

GType
gee_benchmark_fixed_variance_int32_get_type (void)
{
	static volatile gsize gee_benchmark_fixed_variance_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_fixed_variance_int32_type_id__volatile)) {
		GType gee_benchmark_fixed_variance_int32_type_id;
		gee_benchmark_fixed_variance_int32_type_id = gee_benchmark_fixed_variance_int32_get_type_once ();
		g_once_init_leave (&gee_benchmark_fixed_variance_int32_type_id__volatile, gee_benchmark_fixed_variance_int32_type_id);
	}
	return gee_benchmark_fixed_variance_int32_type_id__volatile;
}

static void
_vala_gee_benchmark_fixed_variance_int32_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GeeBenchmarkFixedVarianceInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32);
	switch (property_id) {
		case GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME_PROPERTY:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_benchmark_mounts_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                     gint size,
                                                     GeeCollection* collection)
{
	GeeBenchmarkMountsInt32 * self;
	gint index = 0;
	gint last = 0;
	gint variance = 0;
	self = (GeeBenchmarkMountsInt32*) base;
	g_return_if_fail (collection != NULL);
	index = 0;
	last = 0;
	variance = (gint) sqrt ((gdouble) size);
	while (TRUE) {
		gint width = 0;
		gint height = 0;
		if (!(index < size)) {
			break;
		}
		width = (gint) g_random_int_range ((gint32) 0, (gint32) variance);
		height = (gint) g_random_int_range ((gint32) ((-variance) / 2), (gint32) (variance / 2));
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(i < width)) {
						break;
					}
					gee_collection_add (collection, (gpointer) ((gintptr) (last + (height / width))));
				}
			}
		}
		index += width;
		last += height;
	}
}

GeeBenchmarkMountsInt32*
gee_benchmark_mounts_int32_construct (GType object_type)
{
	GeeBenchmarkMountsInt32 * self = NULL;
	self = (GeeBenchmarkMountsInt32*) g_object_new (object_type, NULL);
	return self;
}

GeeBenchmarkMountsInt32*
gee_benchmark_mounts_int32_new (void)
{
	return gee_benchmark_mounts_int32_construct (GEE_BENCHMARK_TYPE_MOUNTS_INT32);
}

static const gchar*
gee_benchmark_mounts_int32_real_get_name (GeeBenchmarkGenerator* base)
{
	const gchar* result;
	GeeBenchmarkMountsInt32* self;
	self = (GeeBenchmarkMountsInt32*) base;
	result = "Mounts";
	return result;
}

static void
gee_benchmark_mounts_int32_class_init (GeeBenchmarkMountsInt32Class * klass,
                                       gpointer klass_data)
{
	gee_benchmark_mounts_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_mounts_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_MOUNTS_INT32_NAME_PROPERTY, gee_benchmark_mounts_int32_properties[GEE_BENCHMARK_MOUNTS_INT32_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_benchmark_mounts_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface,
                                                                   gpointer iface_data)
{
	gee_benchmark_mounts_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*) (GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_mounts_int32_real_generate_collection;
	iface->get_name = gee_benchmark_mounts_int32_real_get_name;
}

static void
gee_benchmark_mounts_int32_instance_init (GeeBenchmarkMountsInt32 * self,
                                          gpointer klass)
{
}

static GType
gee_benchmark_mounts_int32_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkMountsInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_mounts_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkMountsInt32), 0, (GInstanceInitFunc) gee_benchmark_mounts_int32_instance_init, NULL };
	static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_mounts_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_benchmark_mounts_int32_type_id;
	gee_benchmark_mounts_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkMountsInt32", &g_define_type_info, 0);
	g_type_add_interface_static (gee_benchmark_mounts_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
	return gee_benchmark_mounts_int32_type_id;
}

GType
gee_benchmark_mounts_int32_get_type (void)
{
	static volatile gsize gee_benchmark_mounts_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_mounts_int32_type_id__volatile)) {
		GType gee_benchmark_mounts_int32_type_id;
		gee_benchmark_mounts_int32_type_id = gee_benchmark_mounts_int32_get_type_once ();
		g_once_init_leave (&gee_benchmark_mounts_int32_type_id__volatile, gee_benchmark_mounts_int32_type_id);
	}
	return gee_benchmark_mounts_int32_type_id__volatile;
}

static void
_vala_gee_benchmark_mounts_int32_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GeeBenchmarkMountsInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32);
	switch (property_id) {
		case GEE_BENCHMARK_MOUNTS_INT32_NAME_PROPERTY:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_benchmark_reverse_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                             gint size,
                                                             GeeCollection* collection)
{
	GeeBenchmarkReverseSortedInt32 * self;
	self = (GeeBenchmarkReverseSortedInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				gee_collection_add (collection, (gpointer) ((gintptr) ((size - i) - 1)));
			}
		}
	}
}

GeeBenchmarkReverseSortedInt32*
gee_benchmark_reverse_sorted_int32_construct (GType object_type)
{
	GeeBenchmarkReverseSortedInt32 * self = NULL;
	self = (GeeBenchmarkReverseSortedInt32*) g_object_new (object_type, NULL);
	return self;
}

GeeBenchmarkReverseSortedInt32*
gee_benchmark_reverse_sorted_int32_new (void)
{
	return gee_benchmark_reverse_sorted_int32_construct (GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32);
}

static const gchar*
gee_benchmark_reverse_sorted_int32_real_get_name (GeeBenchmarkGenerator* base)
{
	const gchar* result;
	GeeBenchmarkReverseSortedInt32* self;
	self = (GeeBenchmarkReverseSortedInt32*) base;
	result = "ReverseSorted";
	return result;
}

static void
gee_benchmark_reverse_sorted_int32_class_init (GeeBenchmarkReverseSortedInt32Class * klass,
                                               gpointer klass_data)
{
	gee_benchmark_reverse_sorted_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_reverse_sorted_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME_PROPERTY, gee_benchmark_reverse_sorted_int32_properties[GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface,
                                                                           gpointer iface_data)
{
	gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*) (GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_reverse_sorted_int32_real_generate_collection;
	iface->get_name = gee_benchmark_reverse_sorted_int32_real_get_name;
}

static void
gee_benchmark_reverse_sorted_int32_instance_init (GeeBenchmarkReverseSortedInt32 * self,
                                                  gpointer klass)
{
}

static GType
gee_benchmark_reverse_sorted_int32_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkReverseSortedInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_reverse_sorted_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkReverseSortedInt32), 0, (GInstanceInitFunc) gee_benchmark_reverse_sorted_int32_instance_init, NULL };
	static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_benchmark_reverse_sorted_int32_type_id;
	gee_benchmark_reverse_sorted_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkReverseSortedInt32", &g_define_type_info, 0);
	g_type_add_interface_static (gee_benchmark_reverse_sorted_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
	return gee_benchmark_reverse_sorted_int32_type_id;
}

GType
gee_benchmark_reverse_sorted_int32_get_type (void)
{
	static volatile gsize gee_benchmark_reverse_sorted_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_reverse_sorted_int32_type_id__volatile)) {
		GType gee_benchmark_reverse_sorted_int32_type_id;
		gee_benchmark_reverse_sorted_int32_type_id = gee_benchmark_reverse_sorted_int32_get_type_once ();
		g_once_init_leave (&gee_benchmark_reverse_sorted_int32_type_id__volatile, gee_benchmark_reverse_sorted_int32_type_id);
	}
	return gee_benchmark_reverse_sorted_int32_type_id__volatile;
}

static void
_vala_gee_benchmark_reverse_sorted_int32_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GeeBenchmarkReverseSortedInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32);
	switch (property_id) {
		case GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME_PROPERTY:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_benchmark_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base,
                                                     gint size,
                                                     GeeCollection* collection)
{
	GeeBenchmarkSortedInt32 * self;
	self = (GeeBenchmarkSortedInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				gee_collection_add (collection, (gpointer) ((gintptr) i));
			}
		}
	}
}

GeeBenchmarkSortedInt32*
gee_benchmark_sorted_int32_construct (GType object_type)
{
	GeeBenchmarkSortedInt32 * self = NULL;
	self = (GeeBenchmarkSortedInt32*) g_object_new (object_type, NULL);
	return self;
}

GeeBenchmarkSortedInt32*
gee_benchmark_sorted_int32_new (void)
{
	return gee_benchmark_sorted_int32_construct (GEE_BENCHMARK_TYPE_SORTED_INT32);
}

static const gchar*
gee_benchmark_sorted_int32_real_get_name (GeeBenchmarkGenerator* base)
{
	const gchar* result;
	GeeBenchmarkSortedInt32* self;
	self = (GeeBenchmarkSortedInt32*) base;
	result = "Sorted";
	return result;
}

static void
gee_benchmark_sorted_int32_class_init (GeeBenchmarkSortedInt32Class * klass,
                                       gpointer klass_data)
{
	gee_benchmark_sorted_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_sorted_int32_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_SORTED_INT32_NAME_PROPERTY, gee_benchmark_sorted_int32_properties[GEE_BENCHMARK_SORTED_INT32_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gee_benchmark_sorted_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface,
                                                                   gpointer iface_data)
{
	gee_benchmark_sorted_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*) (GeeBenchmarkGenerator*, gint, GeeCollection*)) gee_benchmark_sorted_int32_real_generate_collection;
	iface->get_name = gee_benchmark_sorted_int32_real_get_name;
}

static void
gee_benchmark_sorted_int32_instance_init (GeeBenchmarkSortedInt32 * self,
                                          gpointer klass)
{
}

static GType
gee_benchmark_sorted_int32_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkSortedInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_sorted_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkSortedInt32), 0, (GInstanceInitFunc) gee_benchmark_sorted_int32_instance_init, NULL };
	static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_sorted_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_benchmark_sorted_int32_type_id;
	gee_benchmark_sorted_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkSortedInt32", &g_define_type_info, 0);
	g_type_add_interface_static (gee_benchmark_sorted_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
	return gee_benchmark_sorted_int32_type_id;
}

GType
gee_benchmark_sorted_int32_get_type (void)
{
	static volatile gsize gee_benchmark_sorted_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_sorted_int32_type_id__volatile)) {
		GType gee_benchmark_sorted_int32_type_id;
		gee_benchmark_sorted_int32_type_id = gee_benchmark_sorted_int32_get_type_once ();
		g_once_init_leave (&gee_benchmark_sorted_int32_type_id__volatile, gee_benchmark_sorted_int32_type_id);
	}
	return gee_benchmark_sorted_int32_type_id__volatile;
}

static void
_vala_gee_benchmark_sorted_int32_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GeeBenchmarkSortedInt32 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32);
	switch (property_id) {
		case GEE_BENCHMARK_SORTED_INT32_NAME_PROPERTY:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gee_benchmark_array_list_factory_get_instance_private (GeeBenchmarkArrayListFactory* self)
{
	return G_STRUCT_MEMBER_P (self, GeeBenchmarkArrayListFactory_private_offset);
}

static GeeCollection*
gee_benchmark_array_list_factory_real_create (GeeBenchmarkFactory* base)
{
	GeeBenchmarkArrayListFactory * self;
	GeeArrayList* _tmp0_;
	GeeCollection* result = NULL;
	self = (GeeBenchmarkArrayListFactory*) base;
	_tmp0_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, NULL, NULL, NULL);
	result = (GeeCollection*) _tmp0_;
	return result;
}

static GeeCollection*
gee_benchmark_array_list_factory_real_copy (GeeBenchmarkFactory* base,
                                            GeeCollection* collection)
{
	GeeBenchmarkArrayListFactory * self;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* result = NULL;
	self = (GeeBenchmarkArrayListFactory*) base;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, NULL, NULL, NULL);
	copy = _tmp0_;
	{
		GeeIterator* _item_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gpointer item = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeArrayList* _tmp5_;
			gconstpointer _tmp6_;
			_tmp2_ = _item_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _item_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			item = _tmp4_;
			_tmp5_ = copy;
			_tmp6_ = item;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = (GeeCollection*) copy;
	return result;
}

GeeBenchmarkArrayListFactory*
gee_benchmark_array_list_factory_construct (GType object_type,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func)
{
	GeeBenchmarkArrayListFactory * self = NULL;
	self = (GeeBenchmarkArrayListFactory*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}

GeeBenchmarkArrayListFactory*
gee_benchmark_array_list_factory_new (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func)
{
	return gee_benchmark_array_list_factory_construct (GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, g_type, g_dup_func, g_destroy_func);
}

static void
gee_benchmark_array_list_factory_class_init (GeeBenchmarkArrayListFactoryClass * klass,
                                             gpointer klass_data)
{
	gee_benchmark_array_list_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeBenchmarkArrayListFactory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_array_list_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_benchmark_array_list_factory_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gee_benchmark_array_list_factory_gee_benchmark_factory_interface_init (GeeBenchmarkFactoryIface * iface,
                                                                       gpointer iface_data)
{
	gee_benchmark_array_list_factory_gee_benchmark_factory_parent_iface = g_type_interface_peek_parent (iface);
	iface->create = (GeeCollection* (*) (GeeBenchmarkFactory*)) gee_benchmark_array_list_factory_real_create;
	iface->copy = (GeeCollection* (*) (GeeBenchmarkFactory*, GeeCollection*)) gee_benchmark_array_list_factory_real_copy;
}

static void
gee_benchmark_array_list_factory_instance_init (GeeBenchmarkArrayListFactory * self,
                                                gpointer klass)
{
	self->priv = gee_benchmark_array_list_factory_get_instance_private (self);
}

static GType
gee_benchmark_array_list_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkArrayListFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_array_list_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkArrayListFactory), 0, (GInstanceInitFunc) gee_benchmark_array_list_factory_instance_init, NULL };
	static const GInterfaceInfo gee_benchmark_factory_info = { (GInterfaceInitFunc) gee_benchmark_array_list_factory_gee_benchmark_factory_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_benchmark_array_list_factory_type_id;
	gee_benchmark_array_list_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkArrayListFactory", &g_define_type_info, 0);
	g_type_add_interface_static (gee_benchmark_array_list_factory_type_id, GEE_BENCHMARK_TYPE_FACTORY, &gee_benchmark_factory_info);
	GeeBenchmarkArrayListFactory_private_offset = g_type_add_instance_private (gee_benchmark_array_list_factory_type_id, sizeof (GeeBenchmarkArrayListFactoryPrivate));
	return gee_benchmark_array_list_factory_type_id;
}

GType
gee_benchmark_array_list_factory_get_type (void)
{
	static volatile gsize gee_benchmark_array_list_factory_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_array_list_factory_type_id__volatile)) {
		GType gee_benchmark_array_list_factory_type_id;
		gee_benchmark_array_list_factory_type_id = gee_benchmark_array_list_factory_get_type_once ();
		g_once_init_leave (&gee_benchmark_array_list_factory_type_id__volatile, gee_benchmark_array_list_factory_type_id);
	}
	return gee_benchmark_array_list_factory_type_id__volatile;
}

static void
_vala_gee_benchmark_array_list_factory_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	GeeBenchmarkArrayListFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory);
	switch (property_id) {
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_benchmark_array_list_factory_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	GeeBenchmarkArrayListFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory);
	switch (property_id) {
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gee_benchmark_benchmark_get_instance_private (GeeBenchmarkBenchmark* self)
{
	return G_STRUCT_MEMBER_P (self, GeeBenchmarkBenchmark_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

GeeBenchmarkBenchmark*
gee_benchmark_benchmark_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   GeeBenchmarkFactory* factory,
                                   GeeList* algorithms,
                                   GeeList* generators,
                                   gint* sizes,
                                   gint sizes_length1,
                                   gint iteration_count)
{
	GeeBenchmarkBenchmark * self = NULL;
	GeeBenchmarkFactory* _tmp0_;
	GeeList* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	GeeList* _tmp3_;
	g_return_val_if_fail (factory != NULL, NULL);
	g_return_val_if_fail (algorithms != NULL, NULL);
	g_return_val_if_fail (generators != NULL, NULL);
	self = (GeeBenchmarkBenchmark*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (factory);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp0_;
	_tmp1_ = _g_object_ref0 (algorithms);
	_g_object_unref0 (self->priv->algorithms);
	self->priv->algorithms = _tmp1_;
	_tmp2_ = (sizes != NULL) ? _vala_array_dup1 (sizes, sizes_length1) : sizes;
	_tmp2__length1 = sizes_length1;
	self->priv->sizes = (g_free (self->priv->sizes), NULL);
	self->priv->sizes = _tmp2_;
	self->priv->sizes_length1 = _tmp2__length1;
	self->priv->_sizes_size_ = self->priv->sizes_length1;
	_tmp3_ = _g_object_ref0 (generators);
	_g_object_unref0 (self->priv->generators);
	self->priv->generators = _tmp3_;
	self->priv->iteration_count = iteration_count;
	return self;
}

GeeBenchmarkBenchmark*
gee_benchmark_benchmark_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             GeeBenchmarkFactory* factory,
                             GeeList* algorithms,
                             GeeList* generators,
                             gint* sizes,
                             gint sizes_length1,
                             gint iteration_count)
{
	return gee_benchmark_benchmark_construct (GEE_BENCHMARK_TYPE_BENCHMARK, g_type, g_dup_func, g_destroy_func, factory, algorithms, generators, sizes, sizes_length1, iteration_count);
}

void
gee_benchmark_benchmark_run (GeeBenchmarkBenchmark* self)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gdouble* _tmp7_;
	gint* _tmp8_;
	gint _tmp8__length1;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gdouble* _tmp15_;
	GTimer* timer = NULL;
	GTimer* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sizes;
	_tmp0__length1 = self->priv->sizes_length1;
	_tmp1_ = self->priv->generators;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->algorithms;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gdouble, (_tmp0__length1 * _tmp3_) * _tmp6_);
	self->priv->results_sum = (g_free (self->priv->results_sum), NULL);
	self->priv->results_sum = _tmp7_;
	self->priv->results_sum_length1 = _tmp0__length1;
	self->priv->results_sum_length2 = _tmp3_;
	self->priv->results_sum_length3 = _tmp6_;
	_tmp8_ = self->priv->sizes;
	_tmp8__length1 = self->priv->sizes_length1;
	_tmp9_ = self->priv->generators;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->algorithms;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (gdouble, (_tmp8__length1 * _tmp11_) * _tmp14_);
	self->priv->results_squared_sum = (g_free (self->priv->results_squared_sum), NULL);
	self->priv->results_squared_sum = _tmp15_;
	self->priv->results_squared_sum_length1 = _tmp8__length1;
	self->priv->results_squared_sum_length2 = _tmp11_;
	self->priv->results_squared_sum_length3 = _tmp14_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint* _tmp18_;
				gint _tmp18__length1;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = self->priv->sizes;
				_tmp18__length1 = self->priv->sizes_length1;
				if (!(i < _tmp18__length1)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							GeeList* _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							if (!_tmp19_) {
								gint _tmp20_;
								_tmp20_ = j;
								j = _tmp20_ + 1;
							}
							_tmp19_ = FALSE;
							_tmp21_ = self->priv->generators;
							_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
							_tmp23_ = _tmp22_;
							if (!(j < _tmp23_)) {
								break;
							}
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp24_ = FALSE;
									_tmp24_ = TRUE;
									while (TRUE) {
										GeeList* _tmp26_;
										gint _tmp27_;
										gint _tmp28_;
										gdouble* _tmp29_;
										gint _tmp29__length1;
										gint _tmp29__length2;
										gint _tmp29__length3;
										gdouble* _tmp30_;
										gint _tmp30__length1;
										gint _tmp30__length2;
										gint _tmp30__length3;
										if (!_tmp24_) {
											gint _tmp25_;
											_tmp25_ = k;
											k = _tmp25_ + 1;
										}
										_tmp24_ = FALSE;
										_tmp26_ = self->priv->algorithms;
										_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
										_tmp28_ = _tmp27_;
										if (!(k < _tmp28_)) {
											break;
										}
										_tmp29_ = self->priv->results_sum;
										_tmp29__length1 = self->priv->results_sum_length1;
										_tmp29__length2 = self->priv->results_sum_length2;
										_tmp29__length3 = self->priv->results_sum_length3;
										_tmp29_[(((i * _tmp29__length2) + j) * _tmp29__length3) + k] = (gdouble) 0;
										_tmp30_ = self->priv->results_squared_sum;
										_tmp30__length1 = self->priv->results_squared_sum_length1;
										_tmp30__length2 = self->priv->results_squared_sum_length2;
										_tmp30__length3 = self->priv->results_squared_sum_length3;
										_tmp30_[(((i * _tmp30__length2) + j) * _tmp30__length3) + k] = (gdouble) 0;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp31_ = g_timer_new ();
	timer = _tmp31_;
	{
		gint iteration = 0;
		iteration = 1;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				FILE* _tmp70_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = iteration;
					iteration = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				if (!(iteration <= self->priv->iteration_count)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							gint* _tmp36_;
							gint _tmp36__length1;
							gint size = 0;
							gint* _tmp37_;
							gint _tmp37__length1;
							gint _tmp38_;
							if (!_tmp34_) {
								gint _tmp35_;
								_tmp35_ = i;
								i = _tmp35_ + 1;
							}
							_tmp34_ = FALSE;
							_tmp36_ = self->priv->sizes;
							_tmp36__length1 = self->priv->sizes_length1;
							if (!(i < _tmp36__length1)) {
								break;
							}
							_tmp37_ = self->priv->sizes;
							_tmp37__length1 = self->priv->sizes_length1;
							_tmp38_ = _tmp37_[i];
							size = _tmp38_;
							{
								gint j = 0;
								j = 0;
								{
									gboolean _tmp39_ = FALSE;
									_tmp39_ = TRUE;
									while (TRUE) {
										GeeList* _tmp41_;
										gint _tmp42_;
										gint _tmp43_;
										GeeCollection* collection = NULL;
										GeeBenchmarkFactory* _tmp44_;
										GeeCollection* _tmp45_;
										GeeList* _tmp46_;
										gpointer _tmp47_;
										GeeBenchmarkGenerator* _tmp48_;
										GeeCollection* _tmp49_;
										if (!_tmp39_) {
											gint _tmp40_;
											_tmp40_ = j;
											j = _tmp40_ + 1;
										}
										_tmp39_ = FALSE;
										_tmp41_ = self->priv->generators;
										_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
										_tmp43_ = _tmp42_;
										if (!(j < _tmp43_)) {
											break;
										}
										_tmp44_ = self->priv->factory;
										_tmp45_ = gee_benchmark_factory_create (_tmp44_);
										collection = _tmp45_;
										_tmp46_ = self->priv->generators;
										_tmp47_ = gee_list_get (_tmp46_, j);
										_tmp48_ = (GeeBenchmarkGenerator*) _tmp47_;
										_tmp49_ = collection;
										gee_benchmark_generator_generate_collection (_tmp48_, size, _tmp49_);
										_g_object_unref0 (_tmp48_);
										{
											gint k = 0;
											k = 0;
											{
												gboolean _tmp50_ = FALSE;
												_tmp50_ = TRUE;
												while (TRUE) {
													GeeList* _tmp52_;
													gint _tmp53_;
													gint _tmp54_;
													GeeCollection* copy = NULL;
													GeeBenchmarkFactory* _tmp55_;
													GeeCollection* _tmp56_;
													GeeCollection* _tmp57_;
													GTimer* _tmp58_;
													GTimer* _tmp59_;
													GeeList* _tmp60_;
													gpointer _tmp61_;
													GeeBenchmarkAlgorithm* _tmp62_;
													GeeCollection* _tmp63_;
													GTimer* _tmp64_;
													gdouble elapsed = 0.0;
													GTimer* _tmp65_;
													gdouble* _tmp66_;
													gint _tmp66__length1;
													gint _tmp66__length2;
													gint _tmp66__length3;
													gdouble* _tmp67_;
													gint _tmp67__length1;
													gint _tmp67__length2;
													gint _tmp67__length3;
													if (!_tmp50_) {
														gint _tmp51_;
														_tmp51_ = k;
														k = _tmp51_ + 1;
													}
													_tmp50_ = FALSE;
													_tmp52_ = self->priv->algorithms;
													_tmp53_ = gee_collection_get_size ((GeeCollection*) _tmp52_);
													_tmp54_ = _tmp53_;
													if (!(k < _tmp54_)) {
														break;
													}
													_tmp55_ = self->priv->factory;
													_tmp56_ = collection;
													_tmp57_ = gee_benchmark_factory_copy (_tmp55_, _tmp56_);
													copy = _tmp57_;
													_tmp58_ = timer;
													g_timer_reset (_tmp58_);
													_tmp59_ = timer;
													g_timer_start (_tmp59_);
													_tmp60_ = self->priv->algorithms;
													_tmp61_ = gee_list_get (_tmp60_, k);
													_tmp62_ = (GeeBenchmarkAlgorithm*) _tmp61_;
													_tmp63_ = copy;
													gee_benchmark_algorithm_process_collection (_tmp62_, _tmp63_);
													_g_object_unref0 (_tmp62_);
													_tmp64_ = timer;
													g_timer_stop (_tmp64_);
													_tmp65_ = timer;
													elapsed = g_timer_elapsed (_tmp65_, NULL);
													_tmp66_ = self->priv->results_sum;
													_tmp66__length1 = self->priv->results_sum_length1;
													_tmp66__length2 = self->priv->results_sum_length2;
													_tmp66__length3 = self->priv->results_sum_length3;
													_tmp66_[(((i * _tmp66__length2) + j) * _tmp66__length3) + k] += elapsed;
													_tmp67_ = self->priv->results_squared_sum;
													_tmp67__length1 = self->priv->results_squared_sum_length1;
													_tmp67__length2 = self->priv->results_squared_sum_length2;
													_tmp67__length3 = self->priv->results_squared_sum_length3;
													_tmp67_[(((i * _tmp67__length2) + j) * _tmp67__length3) + k] += pow (elapsed, (gdouble) 2);
													_g_object_unref0 (copy);
												}
											}
										}
										_g_object_unref0 (collection);
									}
								}
							}
						}
					}
				}
				if ((iteration % 10) == 0) {
					FILE* _tmp68_;
					_tmp68_ = stdout;
					fprintf (_tmp68_, "|");
				} else {
					FILE* _tmp69_;
					_tmp69_ = stdout;
					fprintf (_tmp69_, "*");
				}
				_tmp70_ = stdout;
				fflush (_tmp70_);
				if ((iteration % 100) == 0) {
					FILE* _tmp71_;
					_tmp71_ = stdout;
					fprintf (_tmp71_, "\n\n");
					gee_benchmark_benchmark_display_results (self, iteration);
				}
			}
		}
	}
	_g_timer_destroy0 (timer);
}

void
gee_benchmark_benchmark_display_results (GeeBenchmarkBenchmark* self,
                                         gint iteration)
{
	FILE* _tmp0_;
	FILE* _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "After %d iterations: (average [sample standard deviation] in seconds)\n" \
"\n", iteration);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint* _tmp3_;
				gint _tmp3__length1;
				FILE* _tmp4_;
				gint* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				FILE* _tmp7_;
				FILE* _tmp19_;
				FILE* _tmp42_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->sizes;
				_tmp3__length1 = self->priv->sizes_length1;
				if (!(i < _tmp3__length1)) {
					break;
				}
				_tmp4_ = stdout;
				_tmp5_ = self->priv->sizes;
				_tmp5__length1 = self->priv->sizes_length1;
				_tmp6_ = _tmp5_[i];
				fprintf (_tmp4_, "%d elements:\n", _tmp6_);
				_tmp7_ = stdout;
				fprintf (_tmp7_, "%20s\t", "");
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							GeeList* _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							FILE* _tmp13_;
							GeeList* _tmp14_;
							gpointer _tmp15_;
							GeeBenchmarkAlgorithm* _tmp16_;
							const gchar* _tmp17_;
							const gchar* _tmp18_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = k;
								k = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = self->priv->algorithms;
							_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
							_tmp12_ = _tmp11_;
							if (!(k < _tmp12_)) {
								break;
							}
							_tmp13_ = stdout;
							_tmp14_ = self->priv->algorithms;
							_tmp15_ = gee_list_get (_tmp14_, k);
							_tmp16_ = (GeeBenchmarkAlgorithm*) _tmp15_;
							_tmp17_ = gee_benchmark_algorithm_get_name (_tmp16_);
							_tmp18_ = _tmp17_;
							fprintf (_tmp13_, "%-20s\t", _tmp18_);
							_g_object_unref0 (_tmp16_);
						}
					}
				}
				_tmp19_ = stdout;
				fprintf (_tmp19_, "\n");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							GeeList* _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							FILE* _tmp25_;
							GeeList* _tmp26_;
							gpointer _tmp27_;
							GeeBenchmarkGenerator* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							FILE* _tmp41_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = j;
								j = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = self->priv->generators;
							_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
							_tmp24_ = _tmp23_;
							if (!(j < _tmp24_)) {
								break;
							}
							_tmp25_ = stdout;
							_tmp26_ = self->priv->generators;
							_tmp27_ = gee_list_get (_tmp26_, j);
							_tmp28_ = (GeeBenchmarkGenerator*) _tmp27_;
							_tmp29_ = gee_benchmark_generator_get_name (_tmp28_);
							_tmp30_ = _tmp29_;
							fprintf (_tmp25_, "%20s\t", _tmp30_);
							_g_object_unref0 (_tmp28_);
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp31_ = FALSE;
									_tmp31_ = TRUE;
									while (TRUE) {
										GeeList* _tmp33_;
										gint _tmp34_;
										gint _tmp35_;
										gdouble average = 0.0;
										gdouble* _tmp36_;
										gint _tmp36__length1;
										gint _tmp36__length2;
										gint _tmp36__length3;
										gdouble _tmp37_;
										gdouble squared_deviation = 0.0;
										gdouble* _tmp38_;
										gint _tmp38__length1;
										gint _tmp38__length2;
										gint _tmp38__length3;
										gdouble _tmp39_;
										gdouble deviation = 0.0;
										FILE* _tmp40_;
										if (!_tmp31_) {
											gint _tmp32_;
											_tmp32_ = k;
											k = _tmp32_ + 1;
										}
										_tmp31_ = FALSE;
										_tmp33_ = self->priv->algorithms;
										_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
										_tmp35_ = _tmp34_;
										if (!(k < _tmp35_)) {
											break;
										}
										_tmp36_ = self->priv->results_sum;
										_tmp36__length1 = self->priv->results_sum_length1;
										_tmp36__length2 = self->priv->results_sum_length2;
										_tmp36__length3 = self->priv->results_sum_length3;
										_tmp37_ = _tmp36_[(((i * _tmp36__length2) + j) * _tmp36__length3) + k];
										average = _tmp37_ / iteration;
										_tmp38_ = self->priv->results_squared_sum;
										_tmp38__length1 = self->priv->results_squared_sum_length1;
										_tmp38__length2 = self->priv->results_squared_sum_length2;
										_tmp38__length3 = self->priv->results_squared_sum_length3;
										_tmp39_ = _tmp38_[(((i * _tmp38__length2) + j) * _tmp38__length3) + k];
										squared_deviation = (_tmp39_ - (((gdouble) iteration) * pow (average, (gdouble) 2))) / (iteration - 1);
										deviation = sqrt (squared_deviation);
										_tmp40_ = stdout;
										fprintf (_tmp40_, "%8f [%8f] \t", average, deviation);
									}
								}
							}
							_tmp41_ = stdout;
							fprintf (_tmp41_, "\n");
						}
					}
				}
				_tmp42_ = stdout;
				fprintf (_tmp42_, "\n");
			}
		}
	}
	_tmp43_ = stdout;
	fprintf (_tmp43_, "\n\n");
}

static void
gee_benchmark_benchmark_class_init (GeeBenchmarkBenchmarkClass * klass,
                                    gpointer klass_data)
{
	gee_benchmark_benchmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeBenchmarkBenchmark_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_benchmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_benchmark_benchmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_benchmark_benchmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gee_benchmark_benchmark_instance_init (GeeBenchmarkBenchmark * self,
                                       gpointer klass)
{
	self->priv = gee_benchmark_benchmark_get_instance_private (self);
}

static void
gee_benchmark_benchmark_finalize (GObject * obj)
{
	GeeBenchmarkBenchmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark);
	_g_object_unref0 (self->priv->factory);
	self->priv->sizes = (g_free (self->priv->sizes), NULL);
	_g_object_unref0 (self->priv->generators);
	_g_object_unref0 (self->priv->algorithms);
	self->priv->results_sum = (g_free (self->priv->results_sum), NULL);
	self->priv->results_squared_sum = (g_free (self->priv->results_squared_sum), NULL);
	G_OBJECT_CLASS (gee_benchmark_benchmark_parent_class)->finalize (obj);
}

static GType
gee_benchmark_benchmark_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkBenchmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_benchmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkBenchmark), 0, (GInstanceInitFunc) gee_benchmark_benchmark_instance_init, NULL };
	GType gee_benchmark_benchmark_type_id;
	gee_benchmark_benchmark_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkBenchmark", &g_define_type_info, 0);
	GeeBenchmarkBenchmark_private_offset = g_type_add_instance_private (gee_benchmark_benchmark_type_id, sizeof (GeeBenchmarkBenchmarkPrivate));
	return gee_benchmark_benchmark_type_id;
}

GType
gee_benchmark_benchmark_get_type (void)
{
	static volatile gsize gee_benchmark_benchmark_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_benchmark_type_id__volatile)) {
		GType gee_benchmark_benchmark_type_id;
		gee_benchmark_benchmark_type_id = gee_benchmark_benchmark_get_type_once ();
		g_once_init_leave (&gee_benchmark_benchmark_type_id__volatile, gee_benchmark_benchmark_type_id);
	}
	return gee_benchmark_benchmark_type_id__volatile;
}

static void
_vala_gee_benchmark_benchmark_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GeeBenchmarkBenchmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark);
	switch (property_id) {
		case GEE_BENCHMARK_BENCHMARK_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_benchmark_benchmark_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GeeBenchmarkBenchmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark);
	switch (property_id) {
		case GEE_BENCHMARK_BENCHMARK_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

