/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.instrumentor.AbstractStrategy;
import alt.jiapi.instrumentor.HotSpot;
import alt.jiapi.instrumentor.Strategy;
import alt.jiapi.reflect.InstructionList;
import java.util.List;
import org.apache.log4j.Category;

public class GrepInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(GrepInstrumentor.class);
    private Strategy strategy;

    public GrepInstrumentor(Strategy strategy) {
        log.info((Object)("GrepInstrumentor: " + strategy));
        this.strategy = strategy;
    }

    public void instrument(InstructionList il) {
        log.info((Object)("Instrumenting " + this.getCurrentClass().getName() + "." + il.getDeclaringMethod().getName()));
        ((AbstractStrategy)this.strategy).setInstrumentation(this.getInstrumentation());
        List hotSpots = this.strategy.findHotSpots(il);
        for (HotSpot hs : hotSpots) {
            InstructionList view = il.createView(hs.getStart(), hs.getEnd());
            this.forward(view);
        }
    }

    public void setResolution(String resolution) {
        this.setResolutions(new String[]{resolution});
    }

    public void setResolutions(String[] resolutions) {
        if (this.strategy instanceof AbstractStrategy) {
            ((AbstractStrategy)this.strategy).setResolutions(resolutions);
        } else {
            log.warn((Object)("Cannot set resolutions to " + this.strategy + ": It is not an instanceof AbstractStrategy"));
        }
    }

    public String toString() {
        return super.toString() + "#" + this.strategy.toString();
    }
}

