/* { dg-do run { target { riscv_v } } } */
/* { dg-additional-options "-std=c99" } */

#include "vec_sat_arith.h"

#define T                  uint64_t
#define N                  16
#define RUN_VEC_SAT_BINARY RUN_VEC_SAT_U_SUB_FMT_4

DEF_VEC_SAT_U_SUB_FMT_4(T)

T test_data[][3][N] = {
  {
    {
      0, 9, 0, 0,
      0, 9, 0, 0,
      0, 9, 0, 0,
      0, 9, 0, 0,
    }, /* arg_0 */
    {
      0, 2, 3, 1,
      0, 2, 3, 1,
      0, 2, 3, 1,
      0, 2, 3, 1,
    }, /* arg_1 */
    {
      0, 7, 0, 0,
      0, 7, 0, 0,
      0, 7, 0, 0,
      0, 7, 0, 0,
    }, /* expect */
  },
  {
    {
      18446744073709551615u, 18446744073709551615u, 18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u, 18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u, 18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u, 18446744073709551615u, 18446744073709551615u,
    },
    {
      10446744073709551615u, 11446744073709551615u, 12446744073709551615u, 18446744073709551615u,
      10446744073709551615u, 11446744073709551615u, 12446744073709551615u, 18446744073709551615u,
      10446744073709551615u, 11446744073709551615u, 12446744073709551615u, 18446744073709551615u,
      10446744073709551615u, 11446744073709551615u, 12446744073709551615u, 18446744073709551615u,
    },
    {
       8000000000000000000u,  7000000000000000000u,  6000000000000000000u,                    0u,
       8000000000000000000u,  7000000000000000000u,  6000000000000000000u,                    0u,
       8000000000000000000u,  7000000000000000000u,  6000000000000000000u,                    0u,
       8000000000000000000u,  7000000000000000000u,  6000000000000000000u,                    0u,
    },
  },
  {
    {
			  0, 18446744073709551615u,                     1,                     0,
			  1, 18446744073709551615u,                     3,                     0,
			  1, 18446744073709551614u,                     3,                     4,
			  5, 18446744073709551614u, 18446744073709551615u,                     9,
    },
    {
			  0,                     1,                     1, 18446744073709551614u,
      18446744073709551614u, 18446744073709551614u, 18446744073709551614u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u, 18446744073709551615u, 18446744073709551615u,
      18446744073709551615u, 18446744073709551615u, 18446744073709551615u,                     1,
    },
    {
			  0, 18446744073709551614u,                     0,                     0,
			  0,                     1,                     0,                     0,
			  0,                     0,                     0,                     0,
			  0,                     0,                     0,                     8,
    },
  },
};

#include "vec_sat_binary_vvv_run.h"
