/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2024 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Mapper templates for header class list */
struct bnxt_ulp_mapper_tmpl_info ulp_thor_class_tmpl_list[] = {
	/* class_tid: 1, ingress */
	[1] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 78,
	.start_tbl_idx = 0,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 0,
		.cond_nums = 0 }
	},
	/* class_tid: 2, egress */
	[2] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 48,
	.start_tbl_idx = 78,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 2471,
		.cond_nums = 0 }
	},
	/* class_tid: 3, ingress */
	[3] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 22,
	.start_tbl_idx = 126,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 4879,
		.cond_nums = 0 }
	},
	/* class_tid: 4, egress */
	[4] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 35,
	.start_tbl_idx = 148,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 4886,
		.cond_nums = 0 }
	},
	/* class_tid: 5, ingress */
	[5] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 7,
	.start_tbl_idx = 183,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 4890,
		.cond_nums = 0 }
	},
	/* class_tid: 6, ingress */
	[6] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 3,
	.start_tbl_idx = 190,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 4900,
		.cond_nums = 0 }
	},
	/* class_tid: 7, ingress */
	[7] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 21,
	.start_tbl_idx = 193,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 4902,
		.cond_nums = 0 }
	}
};

struct bnxt_ulp_mapper_tbl_info ulp_thor_class_tbl_list[] = {
	{ /* class_tid: 1, , table: port_table.rd */
	.description = "port_table.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 0,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 0,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.ident_start_idx = 0,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.vxlan_ip_check */
	.description = "control.vxlan_ip_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "invalid vxlan header combination",
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 0,
		.cond_nums = 3 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_rd */
	.description = "tunnel_gparse_cache.custom_tunnel_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 8,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 1,
	.blob_key_bit_size = 16,
	.key_bit_size = 16,
	.key_num_fields = 2,
	.ident_start_idx = 2,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.custom_tunnel */
	.description = "control.custom_tunnel",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 15,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: control.custom_tunnel_port_check_value */
	.description = "control.custom_tunnel_port_check_value",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "port does not match configured custom tunnel port",
	.execute_info = {
		.cond_true_goto  = 5,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 16,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_TUNNEL_PORT,
		.func_src2 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr2 = BNXT_ULP_RF_IDX_TUNNEL_PORT,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 1, , table: cust_tunnel.configure_vxlan_port */
	.description = "cust_tunnel.configure_vxlan_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 3,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 0,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 1, , table: cust_tunnel.configure_vxlan_ip_port */
	.description = "cust_tunnel.configure_vxlan_ip_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN_IP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 4,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 1, , table: cust_tunnel.configure_geneve_port */
	.description = "cust_tunnel.configure_geneve_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_GENEVE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 21,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 2,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_wr */
	.description = "tunnel_gparse_cache.custom_tunnel_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 22,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 3,
	.blob_key_bit_size = 16,
	.key_bit_size = 16,
	.key_num_fields = 2,
	.result_start_idx = 3,
	.result_bit_size = 88,
	.result_num_fields = 4
	},
	{ /* class_tid: 1, , table: prof_func_cache.ing_rd */
	.description = "prof_func_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROF_FUNC_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 27,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 5,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.ident_start_idx = 4,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.check_f1_f2_flow */
	.description = "control.check_f1_f2_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 28,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	.description = "tunnel_cache.f1_f2_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 30,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 6,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.ident_start_idx = 5,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.tunnel_cache_check */
	.description = "control.tunnel_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 3,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 30,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.f1_f2_alloc_l2_cntxt */
	.description = "l2_cntxt_tcam.f1_f2_alloc_l2_cntxt",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 31,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 6,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	.description = "tunnel_cache.f1_f2_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 31,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 8,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.result_start_idx = 7,
	.result_bit_size = 52,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: control.check_f2_flow */
	.description = "control.check_f2_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 31,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 31,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.dmac_calculation */
	.description = "control.dmac_calculation",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 32,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 48,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 2,
		.func_dst_opr = BNXT_ULP_RF_IDX_O_DMAC }
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam_cache.rd */
	.description = "l2_cntxt_tcam_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 36,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 10,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 7,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.prof_func_miss */
	.description = "control.prof_func_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "reject the flow since there is no dmac for the flow and port is in non-promisc mode.",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 37,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.check_tunnel_recycle */
	.description = "control.check_tunnel_recycle",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 5,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.multi_tunnel_check */
	.description = "control.multi_tunnel_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "reject multi tunnel flow if group id or partial mask is specified",
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 41,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: multi_flow_tunnel_cache.rd */
	.description = "multi_flow_tunnel_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 43,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 11,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.ident_start_idx = 9,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.multi_flow_cache_check */
	.description = "control.multi_flow_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 67,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: jump_index_table.multi_flow_alloc */
	.description = "jump_index_table.multi_flow_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 68,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 10,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.multi_flow_metadata_cal */
	.description = "control.multi_flow_metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 68,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 1, , table: control.outer_present_mode_1 */
	.description = "control.outer_present_mode_1",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 68,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_ADD }
	},
	{ /* class_tid: 1, , table: multi_flow_tunnel_cache.wr */
	.description = "multi_flow_tunnel_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 68,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 20,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.result_start_idx = 10,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.multi_flow_outer_loop_bit */
	.description = "control.multi_flow_outer_loop_bit",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 7,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 96,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 1, , table: control.group_id_check */
	.description = "control.group_id_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 11,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 96,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: flow_chain_cache.group_check */
	.description = "flow_chain_cache.group_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 97,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 29,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.ident_start_idx = 10,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.flow_chain_group_id */
	.description = "control.flow_chain_group_id",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 97,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: jump_index_table.alloc */
	.description = "jump_index_table.alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 98,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 12,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.metadata_cal */
	.description = "control.metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 98,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 1, , table: flow_chain_cache.write */
	.description = "flow_chain_cache.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 98,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 30,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.result_start_idx = 12,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: flow_chain_l2_cntxt.chaining_check */
	.description = "flow_chain_l2_cntxt.chaining_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_L2_CNTXT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 98,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 31,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 11,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.flow_chain_group_l2_cntxt_check */
	.description = "control.flow_chain_group_l2_cntxt_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 102,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.chain_entry */
	.description = "l2_cntxt_tcam.chain_entry",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 103,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 32,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 14,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 12,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.chain_entry_dup */
	.description = "l2_cntxt_tcam.chain_entry_dup",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 105,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 53,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 20,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 13,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: flow_chain_l2_cntxt.write */
	.description = "flow_chain_l2_cntxt.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_L2_CNTXT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 108,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 74,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 26,
	.result_bit_size = 42,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: mac_addr_cache.rd */
	.description = "mac_addr_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 110,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 75,
	.blob_key_bit_size = 110,
	.key_bit_size = 110,
	.key_num_fields = 8,
	.ident_start_idx = 13,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.mac_addr_cache_miss */
	.description = "control.mac_addr_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 117,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.allocate_l2_context */
	.description = "l2_cntxt_tcam.allocate_l2_context",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 118,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 14,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry */
	.description = "l2_cntxt_tcam.ingress_entry",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 120,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 83,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 28,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 15,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry_dup */
	.description = "l2_cntxt_tcam.ingress_entry_dup",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 122,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 104,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 34,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 15,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: mac_addr_cache.wr */
	.description = "mac_addr_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 125,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 125,
	.blob_key_bit_size = 110,
	.key_bit_size = 110,
	.key_num_fields = 8,
	.result_start_idx = 40,
	.result_bit_size = 69,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.check_f1_flow */
	.description = "control.check_f1_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 130,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.l2_only_check */
	.description = "control.l2_only_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 6,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.tunnel_ipv6_sip_check */
	.description = "control.tunnel_ipv6_sip_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 8,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.terminating_flow */
	.description = "control.terminating_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 146,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 5,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 1, , table: proto_header_cache.rd */
	.description = "proto_header_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 157,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 133,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.ident_start_idx = 15,
	.ident_nums = 7
	},
	{ /* class_tid: 1, , table: control.proto_header_cache_miss */
	.description = "control.proto_header_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 15,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 159,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	.description = "hdr_overlap_cache.overlap_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 160,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 136,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 138,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 22,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.overlap_miss */
	.description = "control.overlap_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 162,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1
	},
	{ /* class_tid: 1, , table: group_miss_action_cache.rd */
	.description = "group_miss_action_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GROUP_MISS_ACTION_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 163,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 139,
	.blob_key_bit_size = 43,
	.key_bit_size = 43,
	.key_num_fields = 2,
	.ident_start_idx = 24,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.ing_catch_all */
	.description = "control.ing_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 165,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET }
	},
	{ /* class_tid: 1, , table: profile_tcam.allocate_wc_profile */
	.description = "profile_tcam.allocate_wc_profile",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 165,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_APP,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 25,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: fkb_select.wc_gen_template */
	.description = "fkb_select.wc_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_WC_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 165,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 45,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: wm.ingress_generic_template_grp_catch_all */
	.description = "wm.ingress_generic_template_grp_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 421,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 1,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 141,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 151,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	.description = "hdr_overlap_cache.overlap_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 942,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 174,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 176,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 156,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template_alloc */
	.description = "fkb_select.em_gen_template_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 944,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 159,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: em_key_recipe.alloc_only */
	.description = "em_key_recipe.alloc_only",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 945,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 265,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.profile_tcam_priority */
	.description = "control.profile_tcam_priority",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 945,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 128,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 1, , table: profile_tcam.gen_template */
	.description = "profile_tcam.gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 961,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 177,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 265,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 26,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: wm_key_recipe.0 */
	.description = "wm_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1208,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 220,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 273,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: proto_header_cache.wr */
	.description = "proto_header_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1709,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 253,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.result_start_idx = 273,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.rd */
	.description = "em_flow_conflict_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1711,
		.cond_nums = 4 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 256,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.ident_start_idx = 27,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.em_flow_conflict_cache_miss */
	.description = "control.em_flow_conflict_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1717,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template */
	.description = "fkb_select.em_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1718,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 281,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: em_key_recipe.0 */
	.description = "em_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1965,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 260,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 387,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.wr */
	.description = "em_flow_conflict_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2459,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 293,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.result_start_idx = 387,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.field_sig_validation */
	.description = "control.field_sig_validation",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 4,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2461,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 1, , table: control.outer_loop_add_check */
	.description = "control.outer_loop_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 5,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2463,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: em.ingress_generic_template */
	.description = "em.ingress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2465,
		.cond_nums = 4 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 389,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 1, , table: control.em_add_check */
	.description = "control.em_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2469,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: wm.ingress_generic_template */
	.description = "wm.ingress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2470,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 395,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.outer_loop_check */
	.description = "control.outer_loop_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2470,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.reset_outer_loop */
	.description = "control.reset_outer_loop",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2471,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 1, , table: control.inner_loop_cal */
	.description = "control.inner_loop_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = -29,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2471,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_INNER_LOOP }
	},
	{ /* class_tid: 2, , table: l2_cntxt_tcam_cache.rd */
	.description = "l2_cntxt_tcam_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2471,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 297,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 28,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.l2_only_check */
	.description = "control.l2_only_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 9,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.tunnel_ipv6_sip_check */
	.description = "control.tunnel_ipv6_sip_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip or source mac",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 11,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.check_tunnel_recycle */
	.description = "control.check_tunnel_recycle",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_AND,
		.cond_start_idx = 13,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.multi_tunnel_check */
	.description = "control.multi_tunnel_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.false_message = "reject multi tunnel flow if group id or partial mask is specified",
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2493,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: multi_flow_tunnel_cache.rd */
	.description = "multi_flow_tunnel_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2495,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 298,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.ident_start_idx = 30,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.multi_flow_cache_check */
	.description = "control.multi_flow_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2523,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: jump_index_table.multi_flow_alloc */
	.description = "jump_index_table.multi_flow_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2524,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 400,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.multi_flow_metadata_cal */
	.description = "control.multi_flow_metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2524,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 2, , table: control.outer_present_mode_1 */
	.description = "control.outer_present_mode_1",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2524,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_ADD }
	},
	{ /* class_tid: 2, , table: multi_flow_tunnel_cache.wr */
	.description = "multi_flow_tunnel_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_FLOW_TUNNEL_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2524,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 307,
	.blob_key_bit_size = 447,
	.key_bit_size = 447,
	.key_num_fields = 9,
	.result_start_idx = 400,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: control.multi_flow_outer_loop_bit */
	.description = "control.multi_flow_outer_loop_bit",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2552,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 2, , table: control.terminating_flow */
	.description = "control.terminating_flow",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2552,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 390,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 2, , table: control.group_id_check */
	.description = "control.group_id_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2560,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: flow_chain_cache.group_check */
	.description = "flow_chain_cache.group_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2561,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 316,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.ident_start_idx = 31,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.flow_chain_group_id */
	.description = "control.flow_chain_group_id",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2561,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: jump_index_table.alloc */
	.description = "jump_index_table.alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2562,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 402,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.metadata_cal */
	.description = "control.metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2562,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 2, , table: flow_chain_cache.write */
	.description = "flow_chain_cache.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2562,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 317,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.result_start_idx = 402,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: proto_header_cache.rd */
	.description = "proto_header_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2562,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 318,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.ident_start_idx = 32,
	.ident_nums = 7
	},
	{ /* class_tid: 2, , table: control.proto_header_cache_miss */
	.description = "control.proto_header_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 15,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2564,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	.description = "hdr_overlap_cache.overlap_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2565,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 321,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 323,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 39,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.overlap_miss */
	.description = "control.overlap_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2567,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1
	},
	{ /* class_tid: 2, , table: group_miss_action_cache.rd */
	.description = "group_miss_action_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GROUP_MISS_ACTION_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2568,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 324,
	.blob_key_bit_size = 43,
	.key_bit_size = 43,
	.key_num_fields = 2,
	.ident_start_idx = 41,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.egr_catch_all */
	.description = "control.egr_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2570,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET }
	},
	{ /* class_tid: 2, , table: profile_tcam.allocate_wc_profile */
	.description = "profile_tcam.allocate_wc_profile",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2570,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 42,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: fkb_select.wc_gen_template */
	.description = "fkb_select.wc_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_WC_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2570,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID_1,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 404,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: wm.egress_generic_template_grp_catch_all */
	.description = "wm.egress_generic_template_grp_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2829,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 1,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 326,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 510,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	.description = "hdr_overlap_cache.overlap_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3356,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 359,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 2,
	.partial_key_start_idx = 361,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 515,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template_alloc */
	.description = "fkb_select.em_gen_template_alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3358,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 518,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: em_key_recipe.alloc_only */
	.description = "em_key_recipe.alloc_only",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3359,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 624,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.profile_tcam_priority */
	.description = "control.profile_tcam_priority",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3359,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 515,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 2, , table: profile_tcam.gen_template */
	.description = "profile_tcam.gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3375,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 362,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 624,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 43,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: wm_key_recipe.0 */
	.description = "wm_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3619,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 405,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 632,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: proto_header_cache.wr */
	.description = "proto_header_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4126,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 438,
	.blob_key_bit_size = 75,
	.key_bit_size = 75,
	.key_num_fields = 3,
	.result_start_idx = 632,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.rd */
	.description = "em_flow_conflict_cache.rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 9,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4128,
		.cond_nums = 4 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 441,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.ident_start_idx = 44,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.em_flow_conflict_cache_miss */
	.description = "control.em_flow_conflict_cache_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4134,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template */
	.description = "fkb_select.em_gen_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 640,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: em_key_recipe.0 */
	.description = "em_key_recipe.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4379,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 445,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 746,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.wr */
	.description = "em_flow_conflict_cache.wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4867,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 478,
	.blob_key_bit_size = 77,
	.key_bit_size = 77,
	.key_num_fields = 4,
	.result_start_idx = 746,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: control.field_sig_validation */
	.description = "control.field_sig_validation",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 4,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4869,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 2, , table: control.outer_loop_add_check */
	.description = "control.outer_loop_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 5,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4871,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: em.egress_generic_template */
	.description = "em.egress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4873,
		.cond_nums = 4 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 748,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 2, , table: control.em_add_check */
	.description = "control.em_add_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4877,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: wm.egress_generic_template */
	.description = "wm.egress_generic_template",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4878,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 754,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 2, , table: control.outer_loop_check */
	.description = "control.outer_loop_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4878,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.reset_outer_loop */
	.description = "control.reset_outer_loop",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4879,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_OUTER_LOOP }
	},
	{ /* class_tid: 2, , table: control.inner_loop_cal */
	.description = "control.inner_loop_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = -28,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4879,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr1 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_INNER_LOOP }
	},
	{ /* class_tid: 3, , table: int_full_act_record.0 */
	.description = "int_full_act_record.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4879,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 759,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 3, , table: port_table.ing_wr_0 */
	.description = "port_table.ing_wr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4879,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 482,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 776,
	.result_bit_size = 179,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: prof_func_cache.ing_rd */
	.description = "prof_func_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROF_FUNC_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4879,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 483,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.ident_start_idx = 45,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: control.prof_func_miss */
	.description = "control.prof_func_miss",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4879,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.alloc_prof_func */
	.description = "l2_cntxt_tcam.alloc_prof_func",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.ident_start_idx = 47,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: profile_tcam.prof_func_catch_all */
	.description = "profile_tcam.prof_func_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 484,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 784,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 48,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: prof_func_cache.ing_wr */
	.description = "prof_func_cache.ing_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROF_FUNC_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 527,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.result_start_idx = 792,
	.result_bit_size = 39,
	.result_num_fields = 2
	},
	{ /* class_tid: 3, , table: parif_def_arec_ptr.ing_0 */
	.description = "parif_def_arec_ptr.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_PHY_PORT_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 794,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: parif_def_err_arec_ptr.ing_0 */
	.description = "parif_def_err_arec_ptr.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_PHY_PORT_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 795,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: int_full_act_record.egr_0 */
	.description = "int_full_act_record.egr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 796,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 3, , table: port_table.egr_wr_0 */
	.description = "port_table.egr_wr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 528,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 813,
	.result_bit_size = 179,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: ilt_tbl.egr */
	.description = "ilt_tbl.egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 821,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_rd */
	.description = "l2_cntxt_tcam_cache.non_vfr_egr_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4880,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 529,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 48,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: control.non_vfr_egr_2 */
	.description = "control.non_vfr_egr_2",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4880,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.non_vfr_egr_0 */
	.description = "l2_cntxt_tcam.non_vfr_egr_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4881,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 530,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 829,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 48,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: profile_tcam.non_vfr_prof_func_egr_catch_all */
	.description = "profile_tcam.non_vfr_prof_func_egr_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4881,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 551,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 835,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 50,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_wr */
	.description = "l2_cntxt_tcam_cache.non_vfr_egr_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4881,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 594,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 843,
	.result_bit_size = 69,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: tunnel_gparse_cache.def_cust_tun_rd */
	.description = "tunnel_gparse_cache.def_cust_tun_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 14,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 595,
	.blob_key_bit_size = 16,
	.key_bit_size = 16,
	.key_num_fields = 2,
	.ident_start_idx = 50,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: control.default_custom_tunnel */
	.description = "control.default_custom_tunnel",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4883,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: cust_tunnel.def_conf_vxlan_port */
	.description = "cust_tunnel.def_conf_vxlan_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4884,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 848,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: cust_tunnel.def_conf_vxlan_ip_port */
	.description = "cust_tunnel.def_conf_vxlan_ip_port",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN_IP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4885,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 849,
	.result_bit_size = 16,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: tunnel_gparse_cache.def_cust_tun_wr */
	.description = "tunnel_gparse_cache.def_cust_tun_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_GPARSE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4886,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 597,
	.blob_key_bit_size = 16,
	.key_bit_size = 16,
	.key_num_fields = 2,
	.result_start_idx = 850,
	.result_bit_size = 88,
	.result_num_fields = 4
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_rd */
	.description = "profile_tcam_cache.vfr_glb_act_rec_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4886,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 599,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.ident_start_idx = 52,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.prof_tcam_cache.vfr_glb_act_rec_rd.0 */
	.description = "control.prof_tcam_cache.vfr_glb_act_rec_rd.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4886,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: mod_record.vf_2_vfr_egr */
	.description = "mod_record.vf_2_vfr_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_ACT_MODIFY_64B,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4887,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_MODIFY_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 854,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: int_full_act_record.vf_2_vfr_loopback */
	.description = "int_full_act_record.vf_2_vfr_loopback",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4887,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_LB_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 874,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 4, , table: parif_def_arec_ptr.vf_egr */
	.description = "parif_def_arec_ptr.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4887,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_CONST,
	.tbl_operand = ULP_THOR_SYM_LOOPBACK_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 891,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: parif_def_err_arec_ptr.vf_egr */
	.description = "parif_def_err_arec_ptr.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4887,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_CONST,
	.tbl_operand = ULP_THOR_SYM_LOOPBACK_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 892,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_wr */
	.description = "profile_tcam_cache.vfr_glb_act_rec_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4887,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 602,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.result_start_idx = 893,
	.result_bit_size = 138,
	.result_num_fields = 7
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_rd_egr */
	.description = "l2_cntxt_tcam_cache.vf_rd_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4887,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 605,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 52,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.vf_2_vfr.0 */
	.description = "control.vf_2_vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4887,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.get_drv_func_prof_func */
	.description = "l2_cntxt_tcam_cache.get_drv_func_prof_func",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4888,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 606,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 52,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf_egr */
	.description = "l2_cntxt_tcam.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4888,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 607,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 900,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 53,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: profile_tcam.prof_func_catch_all */
	.description = "profile_tcam.prof_func_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4888,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 628,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 906,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_egr_wr */
	.description = "l2_cntxt_tcam_cache.vf_egr_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4888,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 671,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 914,
	.result_bit_size = 69,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: int_full_act_record.vf_2_vfr_ing */
	.description = "int_full_act_record.vf_2_vfr_ing",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4888,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 919,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_rd */
	.description = "profile_tcam_cache.vfr_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4888,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 672,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.prof_tcam_cache.vfr.0 */
	.description = "control.prof_tcam_cache.vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 10,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4888,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: int_full_act_record.drop_action */
	.description = "int_full_act_record.drop_action",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_DROP_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 936,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf_2_vfr_ing.0 */
	.description = "l2_cntxt_tcam.vf_2_vfr_ing.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 675,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 953,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vfr_2_vf_ing.0 */
	.description = "l2_cntxt_tcam.vfr_2_vf_ing.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 696,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 959,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: fkb_select.vfr_em */
	.description = "fkb_select.vfr_em",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 965,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 4, , table: fkb_select.vf_em */
	.description = "fkb_select.vf_em",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_1,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1071,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 4, , table: profile_tcam.vf_2_vfr.0 */
	.description = "profile_tcam.vf_2_vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 717,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1177,
	.result_bit_size = 33,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: profile_tcam.vfr_2_vf.0 */
	.description = "profile_tcam.vfr_2_vf.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 760,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1185,
	.result_bit_size = 33,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_wr */
	.description = "profile_tcam_cache.vfr_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 803,
	.blob_key_bit_size = 15,
	.key_bit_size = 15,
	.key_num_fields = 3,
	.result_start_idx = 1193,
	.result_bit_size = 138,
	.result_num_fields = 7
	},
	{ /* class_tid: 4, , table: ilt_tbl.vfr_ing */
	.description = "ilt_tbl.vfr_ing",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1200,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: em.vf_2_vfr.0 */
	.description = "em.vf_2_vfr.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 806,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 3,
	.result_start_idx = 1208,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.rd_egr0 */
	.description = "l2_cntxt_tcam_cache.rd_egr0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4889,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 809,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 54,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.0 */
	.description = "control.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4889,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: ilt_tbl.vfr_egr */
	.description = "ilt_tbl.vfr_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1214,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vfr_wr_egr0 */
	.description = "l2_cntxt_tcam_cache.vfr_wr_egr0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 810,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 1222,
	.result_bit_size = 69,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: ilt_tbl.vf_egr */
	.description = "ilt_tbl.vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1227,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: mod_record.vfr_2_vf_egr */
	.description = "mod_record.vfr_2_vf_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_ACT_MODIFY_64B,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MODIFY_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1235,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: int_full_act_record.vfr_egr */
	.description = "int_full_act_record.vfr_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1255,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: int_full_act_record.vfr_2_vf.ing0 */
	.description = "int_full_act_record.vfr_2_vf.ing0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.track_type = CFA_TRACK_TYPE_SID,
	.result_start_idx = 1272,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: em.vfr_2_vf.0 */
	.description = "em.vfr_2_vf.0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.key_start_idx = 811,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 2,
	.result_start_idx = 1289,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 5, , table: port_table.ing_rd */
	.description = "port_table.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 813,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.ident_start_idx = 54,
	.ident_nums = 1
	},
	{ /* class_tid: 5, , table: prof_func_cache.ing_rd */
	.description = "prof_func_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROF_FUNC_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 814,
	.blob_key_bit_size = 8,
	.key_bit_size = 8,
	.key_num_fields = 1,
	.ident_start_idx = 55,
	.ident_nums = 1
	},
	{ /* class_tid: 5, , table: l2_cntxt_tcam_cache.ing_rd */
	.description = "l2_cntxt_tcam_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4890,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 815,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 56,
	.ident_nums = 1
	},
	{ /* class_tid: 5, , table: control.ing_0 */
	.description = "control.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4890,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 5, , table: l2_cntxt_tcam_cache.ing_rd_sock */
	.description = "l2_cntxt_tcam_cache.ing_rd_sock",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4891,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.ref_cnt_opcode = BNXT_ULP_REF_CNT_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_PHY_PORT_SVIF,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC },
	.key_start_idx = 816,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 57,
	.ident_nums = 2
	},
	{ /* class_tid: 5, , table: l2_cntxt_tcam.ing_0 */
	.description = "l2_cntxt_tcam.ing_0",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4892,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 817,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 1295,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 59,
	.ident_nums = 1
	},
	{ /* class_tid: 5, , table: l2_cntxt_tcam_cache.ing_wr */
	.description = "l2_cntxt_tcam_cache.ing_wr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4896,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 838,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 1301,
	.result_bit_size = 69,
	.result_num_fields = 5
	},
	{ /* class_tid: 6, , table: l2_cntxt_tcam_cache.ing_rd */
	.description = "l2_cntxt_tcam_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4900,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.ref_cnt_opcode = BNXT_ULP_REF_CNT_OPC_NOP,
	.key_start_idx = 839,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 60,
	.ident_nums = 1
	},
	{ /* class_tid: 6, , table: control.l2_cache_check */
	.description = "control.l2_cache_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4900,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 6, , table: control.l2_cache_cnt_check */
	.description = "control.l2_cache_cnt_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.false_message = "Promisc mode cannot be disabled as there are flows that is using the promisc rule.",
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4901,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_REF_CNT,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 1,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 7, , table: control.direction_check */
	.description = "control.direction_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 11,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4902,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_DIRECTION,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_DIR_INGRESS,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 7, , table: flow_chain_cache.group_check */
	.description = "flow_chain_cache.group_check",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4903,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 840,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.ident_start_idx = 61,
	.ident_nums = 1
	},
	{ /* class_tid: 7, , table: control.flow_chain_group_id */
	.description = "control.flow_chain_group_id",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4903,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 7, , table: jump_index_table.alloc */
	.description = "jump_index_table.alloc",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4904,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1306,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 7, , table: control.metadata_cal */
	.description = "control.metadata_cal",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4904,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 7, , table: flow_chain_cache.write */
	.description = "flow_chain_cache.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4904,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 841,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.result_start_idx = 1306,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 7, , table: group_miss_action_cache.rd_ing */
	.description = "group_miss_action_cache.rd_ing",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GROUP_MISS_ACTION_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4904,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 842,
	.blob_key_bit_size = 43,
	.key_bit_size = 43,
	.key_num_fields = 2,
	.ident_start_idx = 62,
	.ident_nums = 0
	},
	{ /* class_tid: 7, , table: control.group_miss_action */
	.description = "control.group_miss_action",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4904,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 7, , table: group_miss_action_cache.write */
	.description = "group_miss_action_cache.write",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GROUP_MISS_ACTION_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4905,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 844,
	.blob_key_bit_size = 43,
	.key_bit_size = 43,
	.key_num_fields = 2,
	.result_start_idx = 1308,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 7, , table: l2_cntxt_tcam_cache.ing_rd */
	.description = "l2_cntxt_tcam_cache.ing_rd",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4905,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 846,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 62,
	.ident_nums = 2
	},
	{ /* class_tid: 7, , table: profile_tcam_bypass.prof_func_group_catch_all */
	.description = "profile_tcam_bypass.prof_func_group_catch_all",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4905,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_GROUP_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC },
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_GRPCATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 847,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1310,
	.result_bit_size = 33,
	.result_num_fields = 4,
	.ident_start_idx = 64,
	.ident_nums = 0
	},
	{ /* class_tid: 7, , table: flow_chain_cache.group_check_egr */
	.description = "flow_chain_cache.group_check_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4906,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 890,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.ident_start_idx = 64,
	.ident_nums = 1
	},
	{ /* class_tid: 7, , table: control.flow_chain_group_id_egr */
	.description = "control.flow_chain_group_id_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4906,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 7, , table: jump_index_table.alloc_egr */
	.description = "jump_index_table.alloc_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_ALLOCATOR_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_ALLOCATOR_TABLE_JUMP_INDEX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4907,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_ALLOC_TBL_OPC_ALLOC,
	.tbl_operand = BNXT_ULP_RF_IDX_JUMP_META_IDX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1314,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 7, , table: control.metadata_cal_egr */
	.description = "control.metadata_cal_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4907,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_oper_size = 16,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_JUMP_META_IDX,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR_SYM_CHAIN_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_JUMP_META }
	},
	{ /* class_tid: 7, , table: flow_chain_cache.write_egr */
	.description = "flow_chain_cache.write_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_FLOW_CHAIN_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4907,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 891,
	.blob_key_bit_size = 32,
	.key_bit_size = 32,
	.key_num_fields = 1,
	.result_start_idx = 1314,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 7, , table: group_miss_action_cache.rd_egr */
	.description = "group_miss_action_cache.rd_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GROUP_MISS_ACTION_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4907,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 892,
	.blob_key_bit_size = 43,
	.key_bit_size = 43,
	.key_num_fields = 2,
	.ident_start_idx = 65,
	.ident_nums = 0
	},
	{ /* class_tid: 7, , table: control.group_miss_action_egr */
	.description = "control.group_miss_action_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1023,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4907,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 7, , table: group_miss_action_cache.write_egr */
	.description = "group_miss_action_cache.write_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GROUP_MISS_ACTION_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4908,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 894,
	.blob_key_bit_size = 43,
	.key_bit_size = 43,
	.key_num_fields = 2,
	.result_start_idx = 1316,
	.result_bit_size = 48,
	.result_num_fields = 2
	},
	{ /* class_tid: 7, , table: l2_cntxt_tcam_cache.ing_rd_egr */
	.description = "l2_cntxt_tcam_cache.ing_rd_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4908,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 896,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 65,
	.ident_nums = 2
	},
	{ /* class_tid: 7, , table: profile_tcam_bypass.prof_func_group_catch_all_egr */
	.description = "profile_tcam_bypass.prof_func_group_catch_all_egr",
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4908,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_GROUP_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC },
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = ULP_THOR_SYM_PROF_TCAM_PRI_GRPCATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.track_type = CFA_TRACK_TYPE_SID,
	.key_start_idx = 897,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1318,
	.result_bit_size = 33,
	.result_num_fields = 4,
	.ident_start_idx = 67,
	.ident_nums = 0
	}
};

struct bnxt_ulp_mapper_cond_list_info ulp_thor_class_cond_oper_list[] = {
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:0*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 0,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:0*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:0*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 5,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_port:17*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 17,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_ip_port:19*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 19,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 1, control.check_tunnel_recycle:38*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 38,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:131*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 131,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:131*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 136,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:141*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 141,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2471*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2471,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2471*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2476,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2481*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2481,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2481*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2486,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.check_tunnel_recycle:2491*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2491,
		.cond_nums = 2
	},
	/* cond_execute: class_tid: 3, tunnel_gparse_cache.def_cust_tun_rd:4881*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 4881,
		.cond_nums = 2
	}
};

struct bnxt_ulp_mapper_cond_info ulp_thor_class_cond_list[] = {
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:0*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:0*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* cond_execute: class_tid: 1, control.vxlan_ip_check:0*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* cond_execute: class_tid: 1, tunnel_gparse_cache.custom_tunnel_rd:8*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_rd:10*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_rd:12*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* cond_execute: class_tid: 1, control.custom_tunnel:15*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.custom_tunnel_port_check_value:16*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_port:17*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DYNAMIC_VXLAN_PORT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_vxlan_ip_port:19*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DYNAMIC_VXLAN_PORT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* cond_execute: class_tid: 1, cust_tunnel.configure_geneve_port:21*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DYNAMIC_GENEVE_PORT
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_wr:22*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, tunnel_gparse_cache.custom_tunnel_wr:24*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, prof_func_cache.ing_rd:27*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* cond_execute: class_tid: 1, control.check_f1_f2_flow:28*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* cond_execute: class_tid: 1, control.tunnel_cache_check:30*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.check_f2_flow:31*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:32*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:34*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PORT_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:35*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PARENT_DMAC
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam_cache.rd:36*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_O_DMAC
	},
	/* cond_execute: class_tid: 1, control.prof_func_miss:37*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.check_tunnel_recycle:38*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	/* cond_execute: class_tid: 1, control.multi_tunnel_check:41*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_OUTER_EM_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:43*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:45*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:47*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:49*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:51*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:53*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:55*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:57*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:59*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:61*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:63*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.rd:65*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* cond_execute: class_tid: 1, control.multi_flow_cache_check:67*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:68*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:70*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:72*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:74*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:76*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:78*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:80*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:82*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:84*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:86*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:88*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:90*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:92*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, multi_flow_tunnel_cache.wr:94*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* cond_execute: class_tid: 1, control.group_id_check:96*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* cond_execute: class_tid: 1, control.flow_chain_group_id:97*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, flow_chain_l2_cntxt.chaining_check:98*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.chaining_check:100*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.chaining_check:101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* cond_execute: class_tid: 1, control.flow_chain_group_l2_cntxt_check:102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry:103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry:104*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.chain_entry_dup:105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry_dup:106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.chain_entry_dup:107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.write:108*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, flow_chain_l2_cntxt.write:109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* cond_execute: class_tid: 1, mac_addr_cache.rd:110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_O_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:112*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.mac_addr_cache_miss:117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.allocate_l2_context:118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:120*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.ingress_entry_dup:122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry_dup:123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry_dup:124*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:127*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.check_f1_flow:130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:131*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:131*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:141*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, control.terminating_flow:146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:149*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:152*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:154*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 1, proto_header_cache.rd:157*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.proto_header_cache_miss:159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, hdr_overlap_cache.overlap_check:160*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.overlap_miss:162*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, group_miss_action_cache.rd:163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, group_miss_action_cache.rd:164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:170*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:171*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:175*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:179*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:184*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:189*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:194*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:199*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:203*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:208*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:220*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:224*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:228*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:236*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:240*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:244*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:248*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:253*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:257*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:260*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:263*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:267*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:277*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:291*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:296*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:300*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:304*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:309*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:313*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:318*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:323*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:327*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:336*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:345*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:349*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:354*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:363*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:372*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:377*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:381*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:385*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:390*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:395*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:405*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:408*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:409*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:412*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:414*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:418*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* cond_execute: class_tid: 1, wm.ingress_generic_template_grp_catch_all:421*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:422*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:424*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:426*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:429*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:432*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:433*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:450*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:460*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:475*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:490*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:494*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:498*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:503*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:507*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:516*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:520*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:540*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:564*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:576*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:588*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:609*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:612*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:615*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:618*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:622*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:632*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:636*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:639*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:643*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:646*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:651*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:660*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:664*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:669*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:674*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:678*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:682*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:687*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:692*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:696*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:700*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:705*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:709*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:714*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:718*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:722*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:725*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:729*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:736*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:743*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:746*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:750*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:753*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:757*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:760*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:764*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:767*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:771*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:774*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:778*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:782*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:785*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:788*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:792*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:796*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:799*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:802*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:808*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:810*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:812*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:816*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:820*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:823*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:826*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:832*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:834*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:836*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:840*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:844*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:854*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:858*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:868*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:872*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:882*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:886*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:894*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:898*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:902*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:905*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:908*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:910*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:914*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:918*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:921*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:924*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:926*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:930*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:934*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm.ingress_generic_template_grp_catch_all:940*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, hdr_overlap_cache.overlap_wr:942*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, fkb_select.em_gen_template_alloc:944*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:945*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:949*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:951*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:953*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:955*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:957*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:961*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:965*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:967*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:969*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:973*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:975*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:977*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:979*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:981*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:983*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:985*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:991*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:995*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:997*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:999*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1001*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1003*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1005*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1007*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1009*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1011*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1013*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1015*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1017*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1019*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1021*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1025*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1027*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1033*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1035*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1037*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1039*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1041*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1043*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1045*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1047*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1051*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1053*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1055*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1057*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1059*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1061*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1063*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1065*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1067*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1069*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1071*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1073*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1075*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1077*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1079*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1081*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1084*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1087*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1090*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1093*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1094*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1095*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1097*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1099*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1111*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1127*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1129*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1131*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1133*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1138*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1142*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1144*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1148*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1150*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1152*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1154*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1158*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1160*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1162*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1170*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1174*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1176*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1180*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1182*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1184*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1186*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1190*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1195*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1198*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1199*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1202*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:1207*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_GROUP_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1208*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1210*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1215*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1218*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_GROUP_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1219*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1220*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1221*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1225*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1229*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1233*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1237*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1242*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1247*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1252*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1257*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1262*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1267*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1272*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1277*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1281*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1285*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1289*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1295*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1299*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1303*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1307*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1311*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1315*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1319*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1323*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1327*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1335*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1339*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1343*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1347*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1351*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1355*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1363*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1371*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1375*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1380*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1384*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1393*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1396*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1402*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1405*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1409*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1412*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1416*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1419*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1426*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1433*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1447*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1451*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1456*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1469*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1479*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1483*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1487*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1492*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1496*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1505*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1516*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1519*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1523*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1526*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1537*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1540*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1547*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1551*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1558*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1561*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1565*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1579*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1583*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1586*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1589*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1600*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1603*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1607*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1611*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1614*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1628*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1635*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1639*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1642*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1645*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1649*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1653*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1656*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1661*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1669*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1672*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1685*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1688*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1691*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1693*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1697*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1701*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1704*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:1707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, proto_header_cache.wr:1709*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, em_flow_conflict_cache.rd:1711*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 1, em_flow_conflict_cache.rd:1715*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.em_flow_conflict_cache_miss:1717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1718*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1720*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1722*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1723*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1728*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1737*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1742*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1747*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1752*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1756*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1760*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1764*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1768*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1772*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1776*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1780*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1788*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1792*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1796*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1800*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1809*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1812*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1815*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1820*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1824*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1828*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1831*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1836*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1840*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1845*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1854*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1858*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1863*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1871*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1885*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1895*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1906*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1909*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1913*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1917*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1920*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1923*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1934*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1941*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1945*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1948*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1951*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1955*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1965*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1967*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1969*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1973*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1974*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1975*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1980*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1985*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1998*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2003*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2013*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2018*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2028*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2033*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2037*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2041*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2045*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2053*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2057*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2061*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2065*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2069*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2073*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2077*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2081*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2085*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2089*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2093*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2097*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2129*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2138*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2143*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2147*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2150*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2173*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2177*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2184*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2191*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2196*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2205*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2209*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2214*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2219*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2227*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2237*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2241*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2245*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2250*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2254*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2259*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2263*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2267*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2277*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2281*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2284*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2288*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2291*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2295*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2302*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2305*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2309*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2312*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2316*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2319*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2323*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2327*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2330*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2333*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2337*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2344*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2347*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2351*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2355*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2361*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2365*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2369*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2372*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2375*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2386*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2393*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2397*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2400*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2411*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2414*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2421*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2425*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2428*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2431*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2439*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2445*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2453*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:2456*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_flow_conflict_cache.wr:2459*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 1, control.field_sig_validation:2461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 1, control.outer_loop_add_check:2463*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_ADD
	},
	/* cond_execute: class_tid: 1, em.ingress_generic_template:2465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 1, control.em_add_check:2469*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 1, control.outer_loop_check:2470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2471*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:2471*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2481*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:2481*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* cond_execute: class_tid: 2, control.check_tunnel_recycle:2491*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* cond_execute: class_tid: 2, control.multi_tunnel_check:2493*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_OUTER_EM_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2499*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2503*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2505*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2507*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2511*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2513*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2515*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2517*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2519*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.rd:2521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* cond_execute: class_tid: 2, control.multi_flow_cache_check:2523*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2526*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2534*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2538*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2540*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2546*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, multi_flow_tunnel_cache.wr:2550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:2558*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* cond_execute: class_tid: 2, control.group_id_check:2560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* cond_execute: class_tid: 2, control.flow_chain_group_id:2561*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, proto_header_cache.rd:2562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.proto_header_cache_miss:2564*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, hdr_overlap_cache.overlap_check:2565*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.overlap_miss:2567*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 2, group_miss_action_cache.rd:2568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, group_miss_action_cache.rd:2569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2570*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2576*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2587*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2592*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2607*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2611*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2612*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2616*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2620*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2624*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2628*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2632*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2636*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2640*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2644*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2648*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2652*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2656*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2661*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2668*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2671*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2678*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2682*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2685*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2690*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2694*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2704*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2708*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2712*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2721*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2726*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2744*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2749*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2753*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2757*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2762*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2767*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2771*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2780*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2785*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2789*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2793*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2798*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2803*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2807*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2813*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2816*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2817*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2820*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2825*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:2826*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* cond_execute: class_tid: 2, wm.egress_generic_template_grp_catch_all:2829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2830*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2832*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2834*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2837*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2840*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2841*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2842*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2846*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2854*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2857*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2869*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2874*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2879*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2894*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2904*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2908*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2912*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2916*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2917*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2921*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2922*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2926*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2930*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2934*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2938*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2942*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2946*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2950*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2954*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2958*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2966*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2970*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2974*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2978*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2982*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2986*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2990*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2994*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:2998*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3002*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3007*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3011*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3016*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3026*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3032*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3036*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3039*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3043*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3046*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3050*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3053*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3057*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3060*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3065*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3069*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3074*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3078*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3083*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3088*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3092*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3096*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3139*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3143*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3150*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3157*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3160*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3171*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3174*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3185*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3196*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3199*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3202*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3206*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3210*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3213*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3219*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3222*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3224*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3230*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3234*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3237*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3240*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3243*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3246*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3248*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3250*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3254*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3258*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3261*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3264*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3268*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3272*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3275*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3289*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3292*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3296*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3300*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3303*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3308*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3312*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3316*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3319*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3322*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3324*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3328*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3332*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3335*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3338*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3344*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3348*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3351*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm.egress_generic_template_grp_catch_all:3354*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, hdr_overlap_cache.overlap_wr:3356*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, fkb_select.em_gen_template_alloc:3358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3361*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3363*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3365*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3369*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3371*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:3373*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3375*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3377*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3381*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3385*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3387*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3391*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3393*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3395*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3397*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3401*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3405*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3409*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3411*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3413*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3415*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3419*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3421*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3425*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3427*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3429*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3431*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3433*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3437*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3439*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3441*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3443*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3445*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3447*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3451*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3453*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3457*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3459*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3463*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3467*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3469*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3471*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3473*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3475*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3477*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3479*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3481*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3483*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3487*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3489*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3491*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3493*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3498*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3504*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3507*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3511*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3513*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3515*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3517*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3519*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3523*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3525*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3529*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3531*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3535*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3537*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3539*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3541*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3543*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3545*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3546*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3547*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3558*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3564*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3570*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3574*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3576*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3577*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3579*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3581*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3582*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3586*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3588*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3592*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3594*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3596*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3598*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3600*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3604*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3609*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3612*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3614*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3616*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:3618*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_GROUP_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3619*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3623*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3626*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GROUP_MISS_ACT_IS_SET
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_GROUP_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3630*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3632*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3636*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3640*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3644*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3651*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3654*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3664*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3669*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3674*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3679*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3689*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3694*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3698*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3702*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3706*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3711*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_MULTI_TUNNEL_FLOW
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3712*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3716*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3720*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3724*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3728*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3736*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3740*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3744*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3748*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3752*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3756*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3760*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3764*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3768*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3772*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3776*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3780*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3788*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3792*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3797*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3801*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3806*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3810*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3813*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3816*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3826*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3833*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3836*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3840*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3859*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3868*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3873*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3882*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3886*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3891*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3900*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3904*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3909*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3913*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3918*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3922*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3926*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3929*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3933*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3936*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3940*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3943*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3950*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3954*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3957*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3961*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3964*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3968*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3975*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3978*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3982*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3986*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3992*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:3996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4000*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4003*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4006*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4010*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4017*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4024*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4028*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4034*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4038*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4042*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4045*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4048*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4052*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4056*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4059*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4062*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4066*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4070*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4073*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4076*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4078*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4082*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4086*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4089*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4092*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4094*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4098*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4108*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:4124*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, proto_header_cache.wr:4126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, em_flow_conflict_cache.rd:4128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* field_cond: class_tid: 2, em_flow_conflict_cache.rd:4132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.em_flow_conflict_cache_miss:4134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4135*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4137*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4139*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4144*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4148*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4158*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4176*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4180*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4184*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4196*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4208*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4221*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4225*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4228*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4231*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4235*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4238*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4242*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4245*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4250*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4254*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4259*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4264*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4268*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4272*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4277*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4281*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4285*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4289*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4292*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4295*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4299*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4303*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4309*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4313*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4317*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4320*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4323*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4327*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4334*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4337*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4345*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4348*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4351*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4355*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4362*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4365*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4369*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4373*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:4376*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4381*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4385*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4387*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4388*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4393*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4397*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4401*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4405*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4410*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4415*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4420*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4425*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4440*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4445*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4453*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4457*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4469*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4473*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4477*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4481*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4489*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4493*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4505*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4513*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4517*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4525*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4529*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4537*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4541*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4546*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4555*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4559*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4565*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4571*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4578*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4582*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4585*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4589*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4592*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4596*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4599*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4604*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4608*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4622*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4627*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4635*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4640*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4645*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4649*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4653*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4658*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4662*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4667*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4671*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4678*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4682*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4685*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4689*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4692*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4696*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4703*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4706*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4710*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4713*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4720*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4724*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4727*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4738*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4741*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4745*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4749*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4752*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4755*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4759*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4763*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4766*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4769*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4773*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4777*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4780*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4783*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4787*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4791*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4794*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4797*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4801*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4808*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4815*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4825*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4833*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4836*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4839*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4853*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4857*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:4864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_flow_conflict_cache.wr:4867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_GROUP_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_INNER_LOOP
	},
	/* cond_execute: class_tid: 2, control.field_sig_validation:4869*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 2, control.outer_loop_add_check:4871*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_ADD
	},
	/* cond_execute: class_tid: 2, em.egress_generic_template:4873*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DEF_PRIO
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 2, control.em_add_check:4877*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 2, control.outer_loop_check:4878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_OUTER_LOOP
	},
	/* cond_execute: class_tid: 3, control.prof_func_miss:4879*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, control.non_vfr_egr_2:4880*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, tunnel_gparse_cache.def_cust_tun_rd:4881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_PORT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_IP_PORT
	},
	/* cond_execute: class_tid: 3, control.default_custom_tunnel:4883*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, cust_tunnel.def_conf_vxlan_port:4884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_PORT
	},
	/* cond_execute: class_tid: 3, cust_tunnel.def_conf_vxlan_ip_port:4885*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_STATIC_VXLAN_IP_PORT
	},
	/* cond_execute: class_tid: 4, control.prof_tcam_cache.vfr_glb_act_rec_rd.0:4886*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.vf_2_vfr.0:4887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.prof_tcam_cache.vfr.0:4888*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.0:4889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 5, control.ing_0:4890*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 5, l2_cntxt_tcam_cache.ing_rd_sock:4891*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	/* field_cond: class_tid: 5, l2_cntxt_tcam.ing_0:4892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* field_cond: class_tid: 5, l2_cntxt_tcam.ing_0:4894*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* field_cond: class_tid: 5, l2_cntxt_tcam_cache.ing_wr:4896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* field_cond: class_tid: 5, l2_cntxt_tcam_cache.ing_wr:4898*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_SOCKET_DIRECT
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 6, control.l2_cache_check:4900*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 6, control.l2_cache_cnt_check:4901*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 7, control.direction_check:4902*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 7, control.flow_chain_group_id:4903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 7, control.group_miss_action:4904*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 7, profile_tcam_bypass.prof_func_group_catch_all:4905*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	/* cond_execute: class_tid: 7, control.flow_chain_group_id_egr:4906*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 7, control.group_miss_action_egr:4907*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 7, profile_tcam_bypass.prof_func_group_catch_all_egr:4908*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	}
};

struct bnxt_ulp_mapper_key_info ulp_thor_class_key_info_list[] = {
	/* class_tid: 1, , table: port_table.rd */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_rd */
	{
	.field_info_mask = {
		.description = "tunnel_port",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_port",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(10 >> 8) & 0xff,
			10 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT
		}
	},
	/* class_tid: 1, , table: tunnel_gparse_cache.custom_tunnel_wr */
	{
	.field_info_mask = {
		.description = "tunnel_port",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_port",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(22 >> 8) & 0xff,
			22 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(1 >> 8) & 0xff,
		1 & 0xff}
		}
	},
	/* class_tid: 1, , table: prof_func_cache.ing_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(27 >> 8) & 0xff,
			27 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr3 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: multi_flow_tunnel_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(43 >> 8) & 0xff,
			43 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(45 >> 8) & 0xff,
			45 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(47 >> 8) & 0xff,
			47 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(49 >> 8) & 0xff,
			49 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(51 >> 8) & 0xff,
			51 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(53 >> 8) & 0xff,
			53 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(55 >> 8) & 0xff,
			55 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(57 >> 8) & 0xff,
			57 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(59 >> 8) & 0xff,
			59 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(61 >> 8) & 0xff,
			61 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(63 >> 8) & 0xff,
			63 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(65 >> 8) & 0xff,
			65 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: multi_flow_tunnel_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(68 >> 8) & 0xff,
			68 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(70 >> 8) & 0xff,
			70 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(72 >> 8) & 0xff,
			72 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(74 >> 8) & 0xff,
			74 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(76 >> 8) & 0xff,
			76 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(78 >> 8) & 0xff,
			78 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(80 >> 8) & 0xff,
			80 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(82 >> 8) & 0xff,
			82 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(84 >> 8) & 0xff,
			84 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(86 >> 8) & 0xff,
			86 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(88 >> 8) & 0xff,
			88 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(90 >> 8) & 0xff,
			90 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(92 >> 8) & 0xff,
			92 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(94 >> 8) & 0xff,
			94 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: flow_chain_cache.group_check */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: flow_chain_cache.write */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: flow_chain_l2_cntxt.chaining_check */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(100 >> 8) & 0xff,
			100 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(101 >> 8) & 0xff,
			101 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.chain_entry */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(103 >> 8) & 0xff,
			103 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(104 >> 8) & 0xff,
			104 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.chain_entry_dup */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(106 >> 8) & 0xff,
			106 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(107 >> 8) & 0xff,
			107 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: flow_chain_l2_cntxt.write */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(108 >> 8) & 0xff,
			108 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(109 >> 8) & 0xff,
			109 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(112 >> 8) & 0xff,
			112 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(113 >> 8) & 0xff,
			113 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(114 >> 8) & 0xff,
			114 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(115 >> 8) & 0xff,
			115 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(120 >> 8) & 0xff,
			120 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(121 >> 8) & 0xff,
			121 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		3}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry_dup */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_CHAIN_META_VAL_MASK >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_SOCKET_DIRECT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(123 >> 8) & 0xff,
			123 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(124 >> 8) & 0xff,
			124 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		3}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(125 >> 8) & 0xff,
			125 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(126 >> 8) & 0xff,
			126 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(127 >> 8) & 0xff,
			127 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(128 >> 8) & 0xff,
			128 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(157 >> 8) & 0xff,
			157 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(160 >> 8) & 0xff,
			160 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: group_miss_action_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(164 >> 8) & 0xff,
			164 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: wm.ingress_generic_template_grp_catch_all */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(422 >> 8) & 0xff,
			422 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(424 >> 8) & 0xff,
			424 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(426 >> 8) & 0xff,
			426 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(429 >> 8) & 0xff,
			429 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(432 >> 8) & 0xff,
			432 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(433 >> 8) & 0xff,
			433 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(434 >> 8) & 0xff,
			434 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(438 >> 8) & 0xff,
			438 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(442 >> 8) & 0xff,
			442 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(446 >> 8) & 0xff,
			446 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(450 >> 8) & 0xff,
			450 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(455 >> 8) & 0xff,
			455 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(460 >> 8) & 0xff,
			460 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(48 >> 8) & 0xff,
		48 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(470 >> 8) & 0xff,
			470 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(49 >> 8) & 0xff,
		49 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(480 >> 8) & 0xff,
			480 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(485 >> 8) & 0xff,
			485 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(490 >> 8) & 0xff,
			490 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(494 >> 8) & 0xff,
			494 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(498 >> 8) & 0xff,
			498 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(50 >> 8) & 0xff,
		50 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(503 >> 8) & 0xff,
			503 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(51 >> 8) & 0xff,
		51 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(508 >> 8) & 0xff,
			508 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(512 >> 8) & 0xff,
			512 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(516 >> 8) & 0xff,
			516 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(520 >> 8) & 0xff,
			520 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(524 >> 8) & 0xff,
			524 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(52 >> 8) & 0xff,
		52 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(532 >> 8) & 0xff,
			532 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(53 >> 8) & 0xff,
		53 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(540 >> 8) & 0xff,
			540 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(54 >> 8) & 0xff,
		54 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(548 >> 8) & 0xff,
			548 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(55 >> 8) & 0xff,
		55 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(556 >> 8) & 0xff,
			556 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(56 >> 8) & 0xff,
		56 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(564 >> 8) & 0xff,
			564 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(57 >> 8) & 0xff,
		57 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(572 >> 8) & 0xff,
			572 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(58 >> 8) & 0xff,
		58 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(580 >> 8) & 0xff,
			580 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(59 >> 8) & 0xff,
		59 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(588 >> 8) & 0xff,
			588 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(60 >> 8) & 0xff,
		60 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(597 >> 8) & 0xff,
			597 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(61 >> 8) & 0xff,
		61 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(606 >> 8) & 0xff,
			606 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(62 >> 8) & 0xff,
		62 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(612 >> 8) & 0xff,
			612 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(63 >> 8) & 0xff,
		63 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(618 >> 8) & 0xff,
			618 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(64 >> 8) & 0xff,
		64 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(625 >> 8) & 0xff,
			625 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(65 >> 8) & 0xff,
		65 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(632 >> 8) & 0xff,
			632 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(66 >> 8) & 0xff,
		66 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(639 >> 8) & 0xff,
			639 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(67 >> 8) & 0xff,
		67 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(646 >> 8) & 0xff,
			646 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(68 >> 8) & 0xff,
		68 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(655 >> 8) & 0xff,
			655 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(69 >> 8) & 0xff,
		69 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(664 >> 8) & 0xff,
			664 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(70 >> 8) & 0xff,
		70 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(682 >> 8) & 0xff,
			682 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(73 >> 8) & 0xff,
		73 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(700 >> 8) & 0xff,
			700 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(76 >> 8) & 0xff,
		76 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(709 >> 8) & 0xff,
			709 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(77 >> 8) & 0xff,
		77 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(718 >> 8) & 0xff,
			718 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(78 >> 8) & 0xff,
		78 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(725 >> 8) & 0xff,
			725 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(79 >> 8) & 0xff,
		79 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(732 >> 8) & 0xff,
			732 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(80 >> 8) & 0xff,
		80 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(739 >> 8) & 0xff,
			739 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(81 >> 8) & 0xff,
		81 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(746 >> 8) & 0xff,
			746 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(82 >> 8) & 0xff,
		82 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(753 >> 8) & 0xff,
			753 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(83 >> 8) & 0xff,
		83 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(760 >> 8) & 0xff,
			760 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(84 >> 8) & 0xff,
		84 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(767 >> 8) & 0xff,
			767 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(85 >> 8) & 0xff,
		85 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(774 >> 8) & 0xff,
			774 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(86 >> 8) & 0xff,
		86 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(788 >> 8) & 0xff,
			788 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(89 >> 8) & 0xff,
		89 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(802 >> 8) & 0xff,
			802 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(92 >> 8) & 0xff,
		92 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(826 >> 8) & 0xff,
			826 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(99 >> 8) & 0xff,
		99 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(850 >> 8) & 0xff,
			850 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(106 >> 8) & 0xff,
		106 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(864 >> 8) & 0xff,
			864 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(109 >> 8) & 0xff,
		109 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(878 >> 8) & 0xff,
			878 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(112 >> 8) & 0xff,
		112 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(894 >> 8) & 0xff,
			894 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(116 >> 8) & 0xff,
		116 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(910 >> 8) & 0xff,
			910 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(120 >> 8) & 0xff,
		120 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(926 >> 8) & 0xff,
			926 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(124 >> 8) & 0xff,
		124 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(942 >> 8) & 0xff,
			942 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(961 >> 8) & 0xff,
			961 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(136 >> 8) & 0xff,
		136 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(969 >> 8) & 0xff,
			969 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(139 >> 8) & 0xff,
		139 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(977 >> 8) & 0xff,
			977 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(142 >> 8) & 0xff,
		142 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(985 >> 8) & 0xff,
			985 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(145 >> 8) & 0xff,
		145 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(993 >> 8) & 0xff,
			993 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(148 >> 8) & 0xff,
		148 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1001 >> 8) & 0xff,
			1001 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(151 >> 8) & 0xff,
		151 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1009 >> 8) & 0xff,
			1009 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(154 >> 8) & 0xff,
		154 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1017 >> 8) & 0xff,
			1017 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(157 >> 8) & 0xff,
		157 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1025 >> 8) & 0xff,
			1025 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(160 >> 8) & 0xff,
		160 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1033 >> 8) & 0xff,
			1033 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(163 >> 8) & 0xff,
		163 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1041 >> 8) & 0xff,
			1041 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(166 >> 8) & 0xff,
		166 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1049 >> 8) & 0xff,
			1049 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(169 >> 8) & 0xff,
		169 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1057 >> 8) & 0xff,
			1057 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(172 >> 8) & 0xff,
		172 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1065 >> 8) & 0xff,
			1065 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(175 >> 8) & 0xff,
		175 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1073 >> 8) & 0xff,
			1073 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(178 >> 8) & 0xff,
		178 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1081 >> 8) & 0xff,
			1081 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(181 >> 8) & 0xff,
		181 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1087 >> 8) & 0xff,
			1087 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(182 >> 8) & 0xff,
		182 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1093 >> 8) & 0xff,
			1093 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1094 >> 8) & 0xff,
			1094 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1095 >> 8) & 0xff,
			1095 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(183 >> 8) & 0xff,
		183 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1099 >> 8) & 0xff,
			1099 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(184 >> 8) & 0xff,
		184 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1103 >> 8) & 0xff,
			1103 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(185 >> 8) & 0xff,
		185 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1107 >> 8) & 0xff,
			1107 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(186 >> 8) & 0xff,
		186 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1119 >> 8) & 0xff,
			1119 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(191 >> 8) & 0xff,
		191 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1131 >> 8) & 0xff,
			1131 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1132 >> 8) & 0xff,
			1132 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1133 >> 8) & 0xff,
			1133 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1134 >> 8) & 0xff,
			1134 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(196 >> 8) & 0xff,
		196 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1138 >> 8) & 0xff,
			1138 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(197 >> 8) & 0xff,
		197 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1142 >> 8) & 0xff,
			1142 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(198 >> 8) & 0xff,
		198 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1146 >> 8) & 0xff,
			1146 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(199 >> 8) & 0xff,
		199 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1150 >> 8) & 0xff,
			1150 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(200 >> 8) & 0xff,
		200 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1154 >> 8) & 0xff,
			1154 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(201 >> 8) & 0xff,
		201 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1158 >> 8) & 0xff,
			1158 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(202 >> 8) & 0xff,
		202 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1163 >> 8) & 0xff,
			1163 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(204 >> 8) & 0xff,
		204 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1168 >> 8) & 0xff,
			1168 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(206 >> 8) & 0xff,
		206 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1172 >> 8) & 0xff,
			1172 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(207 >> 8) & 0xff,
		207 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1176 >> 8) & 0xff,
			1176 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(208 >> 8) & 0xff,
		208 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1180 >> 8) & 0xff,
			1180 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(209 >> 8) & 0xff,
		209 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1184 >> 8) & 0xff,
			1184 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(210 >> 8) & 0xff,
		210 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1188 >> 8) & 0xff,
			1188 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(211 >> 8) & 0xff,
		211 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1192 >> 8) & 0xff,
			1192 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1195 >> 8) & 0xff,
			1195 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1198 >> 8) & 0xff,
			1198 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1199 >> 8) & 0xff,
			1199 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1200 >> 8) & 0xff,
			1200 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(212 >> 8) & 0xff,
		212 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1204 >> 8) & 0xff,
			1204 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(213 >> 8) & 0xff,
		213 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1208 >> 8) & 0xff,
			1208 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1210 >> 8) & 0xff,
			1210 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1212 >> 8) & 0xff,
			1212 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1215 >> 8) & 0xff,
			1215 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(214 >> 8) & 0xff,
		214 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1219 >> 8) & 0xff,
			1219 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1220 >> 8) & 0xff,
			1220 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1221 >> 8) & 0xff,
			1221 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1225 >> 8) & 0xff,
			1225 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1229 >> 8) & 0xff,
			1229 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1233 >> 8) & 0xff,
			1233 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1237 >> 8) & 0xff,
			1237 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1242 >> 8) & 0xff,
			1242 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1247 >> 8) & 0xff,
			1247 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(215 >> 8) & 0xff,
		215 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1257 >> 8) & 0xff,
			1257 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(216 >> 8) & 0xff,
		216 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1267 >> 8) & 0xff,
			1267 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1272 >> 8) & 0xff,
			1272 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1277 >> 8) & 0xff,
			1277 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1281 >> 8) & 0xff,
			1281 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1285 >> 8) & 0xff,
			1285 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(217 >> 8) & 0xff,
		217 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1290 >> 8) & 0xff,
			1290 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(218 >> 8) & 0xff,
		218 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1295 >> 8) & 0xff,
			1295 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1299 >> 8) & 0xff,
			1299 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1303 >> 8) & 0xff,
			1303 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1307 >> 8) & 0xff,
			1307 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1311 >> 8) & 0xff,
			1311 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(219 >> 8) & 0xff,
		219 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1319 >> 8) & 0xff,
			1319 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(220 >> 8) & 0xff,
		220 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1327 >> 8) & 0xff,
			1327 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(221 >> 8) & 0xff,
		221 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1335 >> 8) & 0xff,
			1335 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(222 >> 8) & 0xff,
		222 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1343 >> 8) & 0xff,
			1343 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(223 >> 8) & 0xff,
		223 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1351 >> 8) & 0xff,
			1351 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(224 >> 8) & 0xff,
		224 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1359 >> 8) & 0xff,
			1359 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(225 >> 8) & 0xff,
		225 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1367 >> 8) & 0xff,
			1367 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(226 >> 8) & 0xff,
		226 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1375 >> 8) & 0xff,
			1375 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(227 >> 8) & 0xff,
		227 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1384 >> 8) & 0xff,
			1384 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(228 >> 8) & 0xff,
		228 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1393 >> 8) & 0xff,
			1393 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(229 >> 8) & 0xff,
		229 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1399 >> 8) & 0xff,
			1399 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(230 >> 8) & 0xff,
		230 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1405 >> 8) & 0xff,
			1405 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(231 >> 8) & 0xff,
		231 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1412 >> 8) & 0xff,
			1412 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(232 >> 8) & 0xff,
		232 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1419 >> 8) & 0xff,
			1419 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(233 >> 8) & 0xff,
		233 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1426 >> 8) & 0xff,
			1426 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(234 >> 8) & 0xff,
		234 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1433 >> 8) & 0xff,
			1433 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(235 >> 8) & 0xff,
		235 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1442 >> 8) & 0xff,
			1442 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(236 >> 8) & 0xff,
		236 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1451 >> 8) & 0xff,
			1451 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(237 >> 8) & 0xff,
		237 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1469 >> 8) & 0xff,
			1469 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(240 >> 8) & 0xff,
		240 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1487 >> 8) & 0xff,
			1487 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(243 >> 8) & 0xff,
		243 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1496 >> 8) & 0xff,
			1496 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(244 >> 8) & 0xff,
		244 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1505 >> 8) & 0xff,
			1505 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(245 >> 8) & 0xff,
		245 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1512 >> 8) & 0xff,
			1512 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(246 >> 8) & 0xff,
		246 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1519 >> 8) & 0xff,
			1519 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(247 >> 8) & 0xff,
		247 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1526 >> 8) & 0xff,
			1526 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(248 >> 8) & 0xff,
		248 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1533 >> 8) & 0xff,
			1533 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(249 >> 8) & 0xff,
		249 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1540 >> 8) & 0xff,
			1540 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(250 >> 8) & 0xff,
		250 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1547 >> 8) & 0xff,
			1547 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(251 >> 8) & 0xff,
		251 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1554 >> 8) & 0xff,
			1554 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(252 >> 8) & 0xff,
		252 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1561 >> 8) & 0xff,
			1561 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(253 >> 8) & 0xff,
		253 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1575 >> 8) & 0xff,
			1575 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(256 >> 8) & 0xff,
		256 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1589 >> 8) & 0xff,
			1589 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(259 >> 8) & 0xff,
		259 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1603 >> 8) & 0xff,
			1603 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(262 >> 8) & 0xff,
		262 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1617 >> 8) & 0xff,
			1617 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(265 >> 8) & 0xff,
		265 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1631 >> 8) & 0xff,
			1631 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(268 >> 8) & 0xff,
		268 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1645 >> 8) & 0xff,
			1645 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(271 >> 8) & 0xff,
		271 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1661 >> 8) & 0xff,
			1661 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(275 >> 8) & 0xff,
		275 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1677 >> 8) & 0xff,
			1677 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(279 >> 8) & 0xff,
		279 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1693 >> 8) & 0xff,
			1693 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(283 >> 8) & 0xff,
		283 & 0xff}
		}
	},
	/* class_tid: 1, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1709 >> 8) & 0xff,
			1709 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1715 >> 8) & 0xff,
			1715 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1965 >> 8) & 0xff,
			1965 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1967 >> 8) & 0xff,
			1967 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1969 >> 8) & 0xff,
			1969 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(1971 >> 8) & 0xff,
			1971 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1973 >> 8) & 0xff,
			1973 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1974 >> 8) & 0xff,
			1974 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1975 >> 8) & 0xff,
			1975 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1980 >> 8) & 0xff,
			1980 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1985 >> 8) & 0xff,
			1985 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1989 >> 8) & 0xff,
			1989 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1993 >> 8) & 0xff,
			1993 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1998 >> 8) & 0xff,
			1998 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2003 >> 8) & 0xff,
			2003 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(324 >> 8) & 0xff,
		324 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2013 >> 8) & 0xff,
			2013 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(325 >> 8) & 0xff,
		325 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2023 >> 8) & 0xff,
			2023 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2028 >> 8) & 0xff,
			2028 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2033 >> 8) & 0xff,
			2033 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2037 >> 8) & 0xff,
			2037 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2041 >> 8) & 0xff,
			2041 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2045 >> 8) & 0xff,
			2045 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2049 >> 8) & 0xff,
			2049 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2053 >> 8) & 0xff,
			2053 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2057 >> 8) & 0xff,
			2057 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2061 >> 8) & 0xff,
			2061 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2065 >> 8) & 0xff,
			2065 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(326 >> 8) & 0xff,
		326 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2073 >> 8) & 0xff,
			2073 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(327 >> 8) & 0xff,
		327 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2081 >> 8) & 0xff,
			2081 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(328 >> 8) & 0xff,
		328 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2089 >> 8) & 0xff,
			2089 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(329 >> 8) & 0xff,
		329 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2097 >> 8) & 0xff,
			2097 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(330 >> 8) & 0xff,
		330 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2105 >> 8) & 0xff,
			2105 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(331 >> 8) & 0xff,
		331 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2113 >> 8) & 0xff,
			2113 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(332 >> 8) & 0xff,
		332 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2121 >> 8) & 0xff,
			2121 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(333 >> 8) & 0xff,
		333 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2129 >> 8) & 0xff,
			2129 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(334 >> 8) & 0xff,
		334 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2138 >> 8) & 0xff,
			2138 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(335 >> 8) & 0xff,
		335 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2147 >> 8) & 0xff,
			2147 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(336 >> 8) & 0xff,
		336 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2153 >> 8) & 0xff,
			2153 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(337 >> 8) & 0xff,
		337 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2159 >> 8) & 0xff,
			2159 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(338 >> 8) & 0xff,
		338 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2168 >> 8) & 0xff,
			2168 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(339 >> 8) & 0xff,
		339 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2177 >> 8) & 0xff,
			2177 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(340 >> 8) & 0xff,
		340 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2184 >> 8) & 0xff,
			2184 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(341 >> 8) & 0xff,
		341 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2191 >> 8) & 0xff,
			2191 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(342 >> 8) & 0xff,
		342 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2200 >> 8) & 0xff,
			2200 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(343 >> 8) & 0xff,
		343 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2209 >> 8) & 0xff,
			2209 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(344 >> 8) & 0xff,
		344 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2227 >> 8) & 0xff,
			2227 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(347 >> 8) & 0xff,
		347 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2245 >> 8) & 0xff,
			2245 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(350 >> 8) & 0xff,
		350 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2254 >> 8) & 0xff,
			2254 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(351 >> 8) & 0xff,
		351 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2263 >> 8) & 0xff,
			2263 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(352 >> 8) & 0xff,
		352 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2270 >> 8) & 0xff,
			2270 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(353 >> 8) & 0xff,
		353 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2277 >> 8) & 0xff,
			2277 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(354 >> 8) & 0xff,
		354 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2284 >> 8) & 0xff,
			2284 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(355 >> 8) & 0xff,
		355 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2291 >> 8) & 0xff,
			2291 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(356 >> 8) & 0xff,
		356 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2298 >> 8) & 0xff,
			2298 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(357 >> 8) & 0xff,
		357 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2305 >> 8) & 0xff,
			2305 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(358 >> 8) & 0xff,
		358 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2312 >> 8) & 0xff,
			2312 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(359 >> 8) & 0xff,
		359 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2319 >> 8) & 0xff,
			2319 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(360 >> 8) & 0xff,
		360 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2333 >> 8) & 0xff,
			2333 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(363 >> 8) & 0xff,
		363 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2347 >> 8) & 0xff,
			2347 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(366 >> 8) & 0xff,
		366 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2361 >> 8) & 0xff,
			2361 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(369 >> 8) & 0xff,
		369 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2375 >> 8) & 0xff,
			2375 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(372 >> 8) & 0xff,
		372 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2389 >> 8) & 0xff,
			2389 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(375 >> 8) & 0xff,
		375 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2403 >> 8) & 0xff,
			2403 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(378 >> 8) & 0xff,
		378 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2417 >> 8) & 0xff,
			2417 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(381 >> 8) & 0xff,
		381 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2431 >> 8) & 0xff,
			2431 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(384 >> 8) & 0xff,
		384 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2445 >> 8) & 0xff,
			2445 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(387 >> 8) & 0xff,
		387 & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2459 >> 8) & 0xff,
			2459 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: l2_cntxt_tcam_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 2, , table: multi_flow_tunnel_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2495 >> 8) & 0xff,
			2495 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2497 >> 8) & 0xff,
			2497 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2499 >> 8) & 0xff,
			2499 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2501 >> 8) & 0xff,
			2501 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2503 >> 8) & 0xff,
			2503 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2505 >> 8) & 0xff,
			2505 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2507 >> 8) & 0xff,
			2507 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2509 >> 8) & 0xff,
			2509 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2511 >> 8) & 0xff,
			2511 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2513 >> 8) & 0xff,
			2513 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2515 >> 8) & 0xff,
			2515 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2517 >> 8) & 0xff,
			2517 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2519 >> 8) & 0xff,
			2519 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2521 >> 8) & 0xff,
			2521 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: multi_flow_tunnel_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_HDR_BIT,
		.field_opr1 = {
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 56) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 48) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 40) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 32) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 24) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 16) & 0xff,
		((uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN >> 8) & 0xff,
		(uint64_t)BNXT_ULP_HDR_BIT_T_VXLAN & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_DPORT_TUN_TYPE_VXLAN},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2524 >> 8) & 0xff,
			2524 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2526 >> 8) & 0xff,
			2526 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2528 >> 8) & 0xff,
			2528 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2530 >> 8) & 0xff,
			2530 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2532 >> 8) & 0xff,
			2532 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2534 >> 8) & 0xff,
			2534 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2536 >> 8) & 0xff,
			2536 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2538 >> 8) & 0xff,
			2538 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2540 >> 8) & 0xff,
			2540 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_dip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2542 >> 8) & 0xff,
			2542 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2544 >> 8) & 0xff,
			2544 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sip_v4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2546 >> 8) & 0xff,
			2546 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2548 >> 8) & 0xff,
			2548 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_sport",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2550 >> 8) & 0xff,
			2550 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: flow_chain_cache.group_check */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 2, , table: flow_chain_cache.write */
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff}
		}
	},
	/* class_tid: 2, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2562 >> 8) & 0xff,
			2562 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2565 >> 8) & 0xff,
			2565 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: group_miss_action_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "group_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2569 >> 8) & 0xff,
			2569 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_GROUP_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_GROUP_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: wm.egress_generic_template_grp_catch_all */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2830 >> 8) & 0xff,
			2830 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2832 >> 8) & 0xff,
			2832 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2834 >> 8) & 0xff,
			2834 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(2837 >> 8) & 0xff,
			2837 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2840 >> 8) & 0xff,
			2840 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2841 >> 8) & 0xff,
			2841 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2842 >> 8) & 0xff,
			2842 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2846 >> 8) & 0xff,
			2846 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2850 >> 8) & 0xff,
			2850 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(433 >> 8) & 0xff,
		433 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2857 >> 8) & 0xff,
			2857 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(434 >> 8) & 0xff,
		434 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2864 >> 8) & 0xff,
			2864 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2869 >> 8) & 0xff,
			2869 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2874 >> 8) & 0xff,
			2874 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(435 >> 8) & 0xff,
		435 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2884 >> 8) & 0xff,
			2884 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(436 >> 8) & 0xff,
		436 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2894 >> 8) & 0xff,
			2894 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2899 >> 8) & 0xff,
			2899 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2904 >> 8) & 0xff,
			2904 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2908 >> 8) & 0xff,
			2908 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2912 >> 8) & 0xff,
			2912 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(437 >> 8) & 0xff,
		437 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2917 >> 8) & 0xff,
			2917 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(438 >> 8) & 0xff,
		438 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2922 >> 8) & 0xff,
			2922 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2926 >> 8) & 0xff,
			2926 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2930 >> 8) & 0xff,
			2930 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2934 >> 8) & 0xff,
			2934 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2938 >> 8) & 0xff,
			2938 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(439 >> 8) & 0xff,
		439 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2946 >> 8) & 0xff,
			2946 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(440 >> 8) & 0xff,
		440 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2954 >> 8) & 0xff,
			2954 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(441 >> 8) & 0xff,
		441 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2962 >> 8) & 0xff,
			2962 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(442 >> 8) & 0xff,
		442 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2970 >> 8) & 0xff,
			2970 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(443 >> 8) & 0xff,
		443 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2978 >> 8) & 0xff,
			2978 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(444 >> 8) & 0xff,
		444 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2986 >> 8) & 0xff,
			2986 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(445 >> 8) & 0xff,
		445 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2994 >> 8) & 0xff,
			2994 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(446 >> 8) & 0xff,
		446 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3002 >> 8) & 0xff,
			3002 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(447 >> 8) & 0xff,
		447 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3011 >> 8) & 0xff,
			3011 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(448 >> 8) & 0xff,
		448 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3020 >> 8) & 0xff,
			3020 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(449 >> 8) & 0xff,
		449 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3026 >> 8) & 0xff,
			3026 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(450 >> 8) & 0xff,
		450 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3032 >> 8) & 0xff,
			3032 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(451 >> 8) & 0xff,
		451 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3039 >> 8) & 0xff,
			3039 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(452 >> 8) & 0xff,
		452 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3046 >> 8) & 0xff,
			3046 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(453 >> 8) & 0xff,
		453 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3053 >> 8) & 0xff,
			3053 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(454 >> 8) & 0xff,
		454 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3060 >> 8) & 0xff,
			3060 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(455 >> 8) & 0xff,
		455 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3069 >> 8) & 0xff,
			3069 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(456 >> 8) & 0xff,
		456 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3078 >> 8) & 0xff,
			3078 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(457 >> 8) & 0xff,
		457 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3096 >> 8) & 0xff,
			3096 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(460 >> 8) & 0xff,
		460 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3114 >> 8) & 0xff,
			3114 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(463 >> 8) & 0xff,
		463 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3123 >> 8) & 0xff,
			3123 & 0xff,
			(5 >> 8) & 0xff,
			5 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(464 >> 8) & 0xff,
		464 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3132 >> 8) & 0xff,
			3132 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(465 >> 8) & 0xff,
		465 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3139 >> 8) & 0xff,
			3139 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(466 >> 8) & 0xff,
		466 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3146 >> 8) & 0xff,
			3146 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(467 >> 8) & 0xff,
		467 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3153 >> 8) & 0xff,
			3153 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(468 >> 8) & 0xff,
		468 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3160 >> 8) & 0xff,
			3160 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(469 >> 8) & 0xff,
		469 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3167 >> 8) & 0xff,
			3167 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(470 >> 8) & 0xff,
		470 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3174 >> 8) & 0xff,
			3174 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(471 >> 8) & 0xff,
		471 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3181 >> 8) & 0xff,
			3181 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(472 >> 8) & 0xff,
		472 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3188 >> 8) & 0xff,
			3188 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(473 >> 8) & 0xff,
		473 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3202 >> 8) & 0xff,
			3202 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(476 >> 8) & 0xff,
		476 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3216 >> 8) & 0xff,
			3216 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(479 >> 8) & 0xff,
		479 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3240 >> 8) & 0xff,
			3240 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(486 >> 8) & 0xff,
		486 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3264 >> 8) & 0xff,
			3264 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(493 >> 8) & 0xff,
		493 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3278 >> 8) & 0xff,
			3278 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(496 >> 8) & 0xff,
		496 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3292 >> 8) & 0xff,
			3292 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(499 >> 8) & 0xff,
		499 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3308 >> 8) & 0xff,
			3308 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(503 >> 8) & 0xff,
		503 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3324 >> 8) & 0xff,
			3324 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(507 >> 8) & 0xff,
		507 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3340 >> 8) & 0xff,
			3340 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(511 >> 8) & 0xff,
		511 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "group_metadata",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
		.field_opr1 = {
			(3356 >> 8) & 0xff,
			3356 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_JUMP_META >> 8) & 0xff,
		BNXT_ULP_RF_IDX_JUMP_META & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3375 >> 8) & 0xff,
			3375 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(523 >> 8) & 0xff,
		523 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3383 >> 8) & 0xff,
			3383 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(526 >> 8) & 0xff,
		526 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3391 >> 8) & 0xff,
			3391 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(529 >> 8) & 0xff,
		529 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3399 >> 8) & 0xff,
			3399 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(532 >> 8) & 0xff,
		532 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3407 >> 8) & 0xff,
			3407 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(535 >> 8) & 0xff,
		535 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3415 >> 8) & 0xff,
			3415 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(538 >> 8) & 0xff,
		538 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3423 >> 8) & 0xff,
			3423 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(541 >> 8) & 0xff,
		541 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3431 >> 8) & 0xff,
			3431 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(544 >> 8) & 0xff,
		544 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3439 >> 8) & 0xff,
			3439 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(547 >> 8) & 0xff,
		547 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3447 >> 8) & 0xff,
			3447 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(550 >> 8) & 0xff,
		550 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3455 >> 8) & 0xff,
			3455 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(553 >> 8) & 0xff,
		553 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3463 >> 8) & 0xff,
			3463 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(556 >> 8) & 0xff,
		556 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3471 >> 8) & 0xff,
			3471 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(559 >> 8) & 0xff,
		559 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3479 >> 8) & 0xff,
			3479 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(562 >> 8) & 0xff,
		562 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3487 >> 8) & 0xff,
			3487 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(565 >> 8) & 0xff,
		565 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3495 >> 8) & 0xff,
			3495 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(568 >> 8) & 0xff,
		568 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3501 >> 8) & 0xff,
			3501 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(569 >> 8) & 0xff,
		569 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3507 >> 8) & 0xff,
			3507 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3508 >> 8) & 0xff,
			3508 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3509 >> 8) & 0xff,
			3509 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(570 >> 8) & 0xff,
		570 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3513 >> 8) & 0xff,
			3513 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(571 >> 8) & 0xff,
		571 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3517 >> 8) & 0xff,
			3517 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(572 >> 8) & 0xff,
		572 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr