/* $Id: spawn.c,v 1.12 2000/02/01 10:56:45 cvs Exp $ */

#include <pthread.h>
#include <sys/stat.h>
#include "eXimon.h"
#include "color.h"
#include "errno.h"

static unsigned short int SSTR = sizeof(char) * SML_STR;
extern int errno;

/* moves two files, similar to `mv' -- that's actully what mv does ;>  */
void move ( const char *oldpath, const char *newpath ) {
  if ( link(oldpath, newpath) == -1 ) {
    perror("link error:");
    die("internal error");
  }  
  if ( unlink(oldpath) == -1 ) {
    perror("unlink error:");
    die("internal error");
  }
}

int spam_save_done ( char *usr, char *exim_id ) {
  char command[SML_STR], dir_msglog[SML_STR], dir_input[SML_STR],
    dir_base[SML_STR], input_H[SML_STR], input_D[SML_STR], msglog[SML_STR],
    new[SML_STR];
  char tmp;

  /* if there is a null sender */
  if ( usr == NULL || strcmp(usr, "") ) { 
    snprintf(usr, SSTR, "NULL_sender");
  }

  /* get end dirs */
  tmp = ( SPLIT_SPOOL_DIR )? exim_id[5] : '/';
  strcpy(command, usr+1);
  command[strlen(command)-1] = '\0';
  snprintf(dir_base,  SSTR,  "%s/%s",        SPAM_BASE_DIR,   command);
  snprintf(dir_msglog,SSTR,  "%s/%s/msglog", SPAM_BASE_DIR,   command);
  snprintf(dir_input, SSTR,  "%s/%s/input",  SPAM_BASE_DIR,   command);
  if ( MOVE_FROZEN_MAILS == False ) {
    snprintf(input_H, SSTR,  "%s/%c/%s-H",   BASE_DIR_INPUT,  tmp, exim_id);
    snprintf(input_D, SSTR,  "%s/%c/%s-D",   BASE_DIR_INPUT,  tmp, exim_id);
    snprintf(msglog,  SSTR,  "%s/%c/%s",     BASE_DIR_MSGLOG, tmp, exim_id);
  } else { 
    snprintf(input_H, SSTR,  "%s/%c/%s-H",   BASE_DIR_FINPUT,  tmp, exim_id);
    snprintf(input_D, SSTR,  "%s/%c/%s-D",   BASE_DIR_FINPUT,  tmp, exim_id);
    snprintf(msglog,  SSTR,  "%s/%c/%s",     BASE_DIR_FMSGLOG, tmp, exim_id);
  }

  /* NB: move input first, as exim never reads msglog. */
  snprintf(new,SSTR,  "%s/%s-H", dir_input, exim_id );
  move(input_H, new);
  snprintf(new,SSTR,  "%s/%s-D", dir_input, exim_id );
  move(input_D, new);
  snprintf(new,SSTR,  "%s/%s", dir_msglog, exim_id );
  move(msglog, new);

  return EXIT_SUCCESS;
}

/* Makes sure all dirs are there. */
int spam_save_init ( MAIL_MSG *msg ) {
  char command[SML_STR], dir_msglog[SML_STR], dir_input[SML_STR],
    dir_base[SML_STR];
  struct stat stat_base;

  /* we have a spam message: find (or create) the spam save dir for it. */
  strcpy(command, msg->usr+1);
  command[strlen(command)-1] = '\0';
  snprintf(dir_base, SSTR,   "%s/%s",        SPAM_BASE_DIR, command);
  snprintf(dir_msglog,SSTR,  "%s/%s/msglog", SPAM_BASE_DIR, command);
  snprintf(dir_input, SSTR,  "%s/%s/input",  SPAM_BASE_DIR, command);

  /* create the dirs if they don't exist */
  if ( stat(dir_base, &stat_base) == -1 ) {
    mkdir(dir_base,   S_IRWXU);
    mkdir(dir_msglog, S_IRWXU);
    mkdir(dir_input,  S_IRWXU);
    chmod(dir_base,   S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IWGRP|S_IXGRP);
    chmod(dir_msglog, S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IWGRP|S_IXGRP);
    chmod(dir_input,  S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IWGRP|S_IXGRP);
    chown(dir_base,   EXIM_UID, EXIM_GID);
    chown(dir_msglog, EXIM_UID, EXIM_GID);
    chown(dir_input,  EXIM_UID, EXIM_GID);
  }

  return EXIT_SUCCESS;
}

/* thread for thawed mails */
void *thread_spam (void * arg)
{
  int i;
  QUEUE_MAIL *qpt, *queue = (QUEUE_MAIL *)(arg);
  LIST *lst;

  /* more info */
  report( "THREAD_SPAM", "Sorting mails for spam save..." );

  /* loop over the hash table */
  for ( i = 0 ; i < HASH_TABLE_SIZE; i++ ) {
    for ( qpt = &queue[i]; qpt != NULL;  qpt = qpt->next ) {
      if ( qpt->msg && (qpt->msg->status == SPAM) ) {
        if ( spam_save_init(qpt->msg) ) {
	  die("spam_save_init returned something it shouldn't!");
	}
	if ( spam_save_done(qpt->msg->usr, qpt->msg->id) ) {
	  die("spam_save_done has barfed! PANIC");
	}
        for ( lst = qpt->msg->list; lst != NULL; lst = lst->next ) {
	  if ( spam_save_done(qpt->msg->usr, lst->exim_id) ) {
	    die("spam_save_done has barfed! PANIC");
	  }
        }
      }
    }
  }

#ifdef DEBUGG
  report( "THREAD_SPAM", "Done saving spam." );
  report( "THREAD_SPAM", "Could not think of anything to write here." );
#endif

  return NULL;
}

/* move frozen amils back inteh main spool */
int  move_mail_back( char *id ) {
  char tmp = id[5];
  char input_H[SML_STR],  input_D[SML_STR],  msglog[SML_STR];
  char finput_H[SML_STR], finput_D[SML_STR], fmsglog[SML_STR];
  
  /* get where the frozen mail is and where it is going */
  snprintf(finput_H,SSTR,  "%s/%c/%s-H", BASE_DIR_FINPUT,  tmp, id);
  snprintf(finput_D,SSTR,  "%s/%c/%s-D", BASE_DIR_FINPUT,  tmp, id);
  snprintf(fmsglog, SSTR,  "%s/%c/%s",   BASE_DIR_FMSGLOG, tmp, id);
  snprintf(input_H, SSTR, "%s/%c/%s-H", BASE_DIR_INPUT,  tmp, id);
  snprintf(input_D,SSTR,  "%s/%c/%s-D", BASE_DIR_INPUT,  tmp, id);
  snprintf(msglog, SSTR,  "%s/%c/%s",   BASE_DIR_MSGLOG, tmp, id);

  /* moving the files... */
  move(finput_D, input_D );
  move(fmsglog,  msglog  );
  move(finput_H, input_H );

  /* all ends well */
  return EXIT_SUCCESS;
}

/* thread for thawed mails */
void *thread_thaw (void * arg)
{
  int i, do_thaw = False;
  char *lst_thaw = emalloc(  sizeof(char) * strlen(BASE_EXIM)
                            + sizeof(char) * MAX_FROZEN_MAILS * EXIM_ID_LEN);
  QUEUE_MAIL *qpt, *queue = (QUEUE_MAIL *)(arg);
  LIST *lst;

  /* more info */
  report( "THREAD_THAW", "Sorting mails for delivery..."  );

  for ( i = 0 ; i < HASH_TABLE_SIZE; i++ ) {
    for ( qpt = &queue[i]; qpt != NULL;  qpt = qpt->next ) {
      snprintf(lst_thaw, SSTR, "%s ", BASE_EXIM); /* exim -Mt... */
      if ( qpt->msg && (qpt->msg->status == THAW) ) {
        strcat( lst_thaw, " " );
	strcat( lst_thaw, qpt->msg->id );
	do_thaw = True;
	if ( MOVE_FROZEN_MAILS == True ) {
	  move_mail_back(qpt->msg->id);
	}
        for ( lst = qpt->msg->list; lst != NULL; lst = lst->next ) {
	  strcat( lst_thaw, " " );
	  strcat( lst_thaw, lst->exim_id );

	  /* move the mail back into main spool */
	  if ( MOVE_FROZEN_MAILS == True ) {
	    move_mail_back(lst->exim_id);
	  }
	}

      /* calls exim and delivers this mail */
#ifdef DEBUGG   
  report("THREAD_THAW","Executing: %s%s", MY_COLOR_GREEN, lst_thaw );
#endif
      if ( do_thaw == True ) 
        system(lst_thaw);
      }
    }
  }

#ifdef DEBUGG
  report( "THREAD_THAW", "Done mail delivery." );
  report( "THREAD_THAW", "Command executed: %s%s", MY_COLOR_GREEN, lst_thaw );
#endif
/*
  if( do_thaw == True )
    system(lst_thaw);
*/

  return NULL;
}

/* error catching from daft users */
void question ( void ) {
  int c;

    report( "\rWARNING", "Are you sure that you want to continue?" );
  while ( FOREVER ) {
    c = fgetc(stdin);
    if ( c == '\n' ) {
      continue;
    } else if ( c == 'y' || c == 'Y' ) {
        report( "THREADING", "All changes will take effect." );
      break;
    } else if ( c == 'n' || c == 'N' ) {
      report( "ABORTING", "None of your changes will be processed." );
       exit(EXIT_FAILURE);
    } else {
      error( "AHEM", "Does `%c' looks like `yes' or `no'?  Press 'y' or 'n'", c );
    }
  }
  report( "THREADING", "eXimon has started to thread..." );
  return;
}

/* master proccess of the threading. It creates two threads, one for the 
 * frozen amils, and one for the thawed mails. Frozen amils are kept where 
 * they are.
 */
int spawn( QUEUE_MAIL * queue ) {
  pthread_t thread_thaw_id, thread_spam_id;

  /* error catching from daft users */
  if ( EXPERT == False ) {
    question();
  }

  /* threading for delivery then for spam save */
  pthread_create(&thread_thaw_id, NULL, &thread_thaw, (void *)(queue));
  pthread_create(&thread_spam_id, NULL, &thread_spam, (void *)(queue));
  pthread_exit(NULL);
  
  /* all done */
  return EXIT_SUCCESS;
}
