/* $Id: mstrcmp.c,v 1.1.1.1 1999/09/17 14:47:11 cvs Exp $ */

#include <stdio.h>
#include <ctype.h>

/* does the same things a strcasecmp but since some systems don't use
 * strcasecmp, this is a safe bet
 */

int mstrcmp(char *s1, char *s2)
{
    register int c1, c2;

    for (;;) {
	c1 = *s1, c2 = *s2;
	if (!c1 || !c2)
	    return (c1 - c2);
	if (isupper(c1))
	    c1 = tolower(c1);
	if (isupper(c2))
	    c2 = tolower(c2);
	if (c1 != c2)
	    return (c1 - c2);
	s1++, s2++;
    }
}
