/* $Id: eXimon.c,v 1.11 1999/11/29 16:22:02 cvs Exp $ */

#include "eXimon.h"

unsigned int     WARNING_LOAD      = 5;
unsigned int     HASH_TABLE_SIZE   = 10007;
unsigned int     TOLERENCE         = 0;
unsigned int 	 NO_HUMOUR 	   = False;
unsigned int 	 EXPERT 	   = False;
unsigned int 	 MOVE_FROZEN_MAILS = False;
unsigned int     SPLIT_SPOOL_DIR   = True;
unsigned int 	 CHAR		   = sizeof(char);
unsigned int 	 NBR_FRLST         = 0;
char 		 PAGER[SML_STR]    = "/usr/bin/less -m -e -w";

/* main */
int main ( int argc, char **argv ) {
  FILE *RC_FILE, *tmp;
  int i, c, load;
  char str[SML_STR];
  char *stmp = str;
  char *rcfile = malloc( SML_STR );
  QUEUE_MAIL *queue = NULL;
  

#ifdef MEMWATCH
  mwInit();
  mwTerm();
#endif

#ifdef LINUX
  /* load */
  if ( (tmp = fopen("/proc/loadavg", "r")) == NULL ) 
    die("cannot find /proc/loadavg!!! PANIC NOW!!!");
  while ( (c = fgetc(tmp)) != '.' )
    *stmp++ = c;
  if ( (load = atoi(str)) >= WARNING_LOAD ) {
    fprintf( stderr
             ,"%sWARNING:%s the load is above %d, be patient%s\n"
	     ,MY_COLOR_BRIGHT_YELLOW
	     ,MY_COLOR_YELLOW
             ,WARNING_LOAD
	     ,MY_COLOR_NORMAL
	   );
    NO_HUMOUR = True; /* no time for little things like that */
    getchar();
  } else if ( load >= MAX_LOAD ) {
    die("too much load, aborting...");
  }
#endif

  /* default file name */
  strncpy( rcfile, getenv( "HOME" ), ( SML_STR-strlen(RC_FILE_NAME)-2 ) );
  strcat(  rcfile, "/" );
  strcat(  rcfile, RC_FILE_NAME );

  /* read from rc file */
  if ((RC_FILE = fopen( rcfile, "r"))) {
    if ( read_options(RC_FILE) )
      die("Daemons have got to .eXimonrc, it is corrupted!");
  } else {
    report("eXimon","You do not have a .eXimonrc file. Using default values.");
  }
  free(rcfile);

  /* options: overwrite rcfile ones */
  for (i = 1; i < argc; i++) {
    
    /* help */
    if (   !mstrcmp(argv[i], "--help")
        || !mstrcmp(argv[i], "-help")
        || !mstrcmp(argv[i], "-h")
        ) {
      usage();

    /* ini file */
    } else if (   !mstrcmp(argv[i], "--File")
               || !mstrcmp(argv[i], "-File")
               || !mstrcmp(argv[i], "-F")
               ) {
      if (++i >= argc)
        usage();
      if (!(RC_FILE = fopen( argv[i], "r"))) 
        die("No file named \"%s\"", argv[i]);
      if ( read_options(RC_FILE) )
        die("%s is corrupted!", argv[i]);
    
    /* testing */
    } else if ( !mstrcmp(argv[i], "--test")) {
      fprintf(stderr,"Testing values:\n");
      fprintf(stderr,"\t.eXimonrc file:\t\t'%s'\n",RC_FILE_NAME);
      fprintf(stderr,"\tExim UID/GID:\t\t'%d'/'%d'\n",EXIM_UID, EXIM_UID);
      fprintf(stderr,"\tExim base:\t\t'%s'\n",BASE_EXIM);
      fprintf(stderr,"\tDirs:\t\t\t'%s' '%s'\n",BASE_DIR_INPUT,BASE_DIR_MSGLOG);
      fprintf(stderr,"\tDirs:\t\t\t'%s' '%s'\n",BASE_DIR_FINPUT,BASE_DIR_FMSGLOG);
      fprintf(stderr,"\tSpam save:\t\t'%s'\n",SPAM_BASE_DIR);
      fprintf(stderr,"\tMaximum load:\t\t%d\n",MAX_LOAD);
      fprintf(stderr,"\tMove frozen mails:\t%s\n", (MOVE_FROZEN_MAILS == True) ? "True" : "False");
      fprintf(stderr,"\tSplit Spool Dir:\t%s\n", (SPLIT_SPOOL_DIR == True) ? "True" : "False");
      fprintf(stderr,"testing done. Exiting.\n");
      return EXIT_SUCCESS;

    /* default */
    } else {
      fprintf( stderr
              ,"There is no \"%s\" option. try %s--help%s\n"
	      ,argv[i]
	      ,MY_COLOR_BRIGHT_BLUE
	      ,MY_COLOR_NORMAL
	     );
       exit(EXIT_FAILURE);
    }
  }

  /* reads the queue from the msglog directory */
  queue = read_from_mailq(queue);
  
  /* ncurses voodoo magic */
  queue = xcurs_voodoo(queue);

  /* send mail, save spam, etc... */
  if ( spawn(queue) ) {
    die("PANIC! ... everything is bokken!");
  }
  
  /* end of main */
  return EXIT_SUCCESS;
}
