-module(fit).

-compile(export_all).

test() ->
    LtcMat = << << (inv_matrix(M))/binary>> || M <- tabM() >>,
    io:format("~w~n", [byte_size(LtcMat)]),
    file:write_file("areal_ltcmat.bin", LtcMat),
    LtcAmp = << << F:32/little-float >> || F <- tabAmplitude() >>,
    file:write_file("areal_ltcamp.bin", LtcAmp),
    ok.

inv_matrix({M00, _, M02, _, M11, _, M20, _, _}) ->
    A = M00, B = M02, C = M11, D = M20,
    << << F:32/little-float >> || F <- [A, -B, (A-B*D)/C, -D] >>.



tabM() -> %%[size*size] = {
[{0.000200, 0.000000, 0.000000, 0.000000, 0.000200, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000000, 0.000000, 0.000504, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000000, 0.000000, 0.002016, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000000, 0.000000, 0.004535, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.000000, 0.000000, 0.008063, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.000000, 0.000000, 0.012598, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.000000, 0.000000, 0.018141, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.000000, 0.000000, 0.024692, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.000000, 0.000000, 0.032252, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.040821, 0.000000, 0.000000, 0.000000, 0.040821, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.050400, 0.000000, 0.000000, 0.000000, 0.050400, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.060989, 0.000000, 0.000000, 0.000000, 0.060989, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.072591, 0.000000, 0.000000, 0.000000, 0.072591, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.085206, 0.000000, 0.000000, 0.000000, 0.085206, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.098836, 0.000000, 0.000000, 0.000000, 0.098836, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.113483, 0.000000, 0.000000, 0.000000, 0.113483, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.129147, 0.000000, 0.000000, 0.000000, 0.129147, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.145828, 0.000000, 0.000000, 0.000000, 0.145828, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.163499, 0.000000, 0.000000, 0.000000, 0.163499, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.181972, 0.000000, 0.000000, 0.000000, 0.181972, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.199498, 0.000000, 0.000000, 0.000000, 0.199498, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.220031, 0.000000, 0.000000, 0.000000, 0.220031, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.241588, 0.000000, 0.000000, 0.000000, 0.241588, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.264120, 0.000000, 0.000000, 0.000000, 0.264120, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.287521, 0.000000, 0.000000, 0.000000, 0.287521, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.311478, 0.000000, 0.000000, 0.000000, 0.311478, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.335127, 0.000000, 0.000000, 0.000000, 0.335127, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.359811, 0.000000, 0.000000, 0.000000, 0.359811, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.386446, 0.000000, 0.000000, 0.000000, 0.386446, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.413161, 0.000000, 0.000000, 0.000000, 0.413161, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.439142, 0.000000, 0.000000, 0.000000, 0.439142, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.467039, 0.000000, 0.000000, 0.000000, 0.467039, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.495170, 0.000000, 0.000000, 0.000000, 0.495170, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.522324, 0.000000, 0.000000, 0.000000, 0.522324, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.551482, 0.000000, 0.000000, 0.000000, 0.551482, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.579621, 0.000000, 0.000000, 0.000000, 0.579621, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.608255, 0.000000, 0.000000, 0.000000, 0.608255, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.636515, 0.000000, 0.000000, 0.000000, 0.636515, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.664835, 0.000000, 0.000000, 0.000000, 0.664835, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.692549, 0.000000, 0.000000, 0.000000, 0.692549, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.720375, 0.000000, 0.000000, 0.000000, 0.720375, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.747238, 0.000000, 0.000000, 0.000000, 0.747238, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.773956, 0.000000, 0.000000, 0.000000, 0.773956, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.799879, 0.000000, 0.000000, 0.000000, 0.799879, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.824889, 0.000000, 0.000000, 0.000000, 0.824889, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.849357, 0.000000, 0.000000, 0.000000, 0.849357, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.873016, 0.000000, 0.000000, 0.000000, 0.873016, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.895670, 0.000000, 0.000000, 0.000000, 0.895670, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.917194, 0.000000, 0.000000, 0.000000, 0.917194, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.937978, 0.000000, 0.000000, 0.000000, 0.937978, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.957872, 0.000000, 0.000000, 0.000000, 0.957872, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.976736, 0.000000, 0.000000, 0.000000, 0.976736, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.994433, 0.000000, 0.000000, 0.000000, 0.994433, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.011206, 0.000000, 0.000000, 0.000000, 1.011206, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.026820, 0.000000, 0.000000, 0.000000, 1.026820, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.041720, 0.000000, 0.000000, 0.000000, 1.041720, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.055657, 0.000000, 0.000000, 0.000000, 1.055657, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.068642, 0.000000, 0.000000, 0.000000, 1.068642, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.080646, 0.000000, 0.000000, 0.000000, 1.080646, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.091637, 0.000000, 0.000000, 0.000000, 1.091637, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.101837, 0.000000, 0.000000, 0.000000, 1.101837, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.111292, 0.000000, 0.000000, 0.000000, 1.111292, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.120025, 0.000000, 0.000000, 0.000000, 1.120025, 0.000000, 0.000000, 0.000000, 1.000000}, 
{1.127918, 0.000000, 0.000000, 0.000000, 1.127918, 0.000000, 0.000000, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000005, 0.000000, 0.000200, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000013, 0.000000, 0.000504, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000050, 0.000000, 0.002016, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000113, 0.000000, 0.004535, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.000201, 0.000000, 0.008062, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.012596, 0.000000, 0.000314, 0.000000, 0.012598, 0.000000, -0.024937, 0.000000, 1.000000}, 
{0.018140, 0.000000, 0.000452, 0.000000, 0.018142, 0.000000, -0.024939, 0.000000, 1.000000}, 
{0.024693, 0.000000, 0.000616, 0.000000, 0.024695, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.032253, 0.000000, 0.000804, 0.000000, 0.032251, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.040815, 0.000000, 0.001018, 0.000000, 0.040819, 0.000000, -0.024940, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.001257, 0.000000, 0.050401, 0.000000, -0.024937, 0.000000, 1.000000}, 
{0.060989, 0.000000, 0.001521, 0.000000, 0.060987, 0.000000, -0.024937, 0.000000, 1.000000}, 
{0.072591, 0.000000, 0.001810, 0.000000, 0.072592, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.085204, 0.000000, 0.002125, 0.000000, 0.085204, 0.000000, -0.024939, 0.000000, 1.000000}, 
{0.098835, 0.000000, 0.002465, 0.000000, 0.098834, 0.000000, -0.024937, 0.000000, 1.000000}, 
{0.113483, 0.000000, 0.002830, 0.000000, 0.113481, 0.000000, -0.024939, 0.000000, 1.000000}, 
{0.129143, 0.000000, 0.003220, 0.000000, 0.129150, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.145830, 0.000000, 0.003633, 0.000000, 0.145828, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.163497, 0.000000, 0.004062, 0.000000, 0.163496, 0.000000, -0.024938, 0.000000, 1.000000}, 
{0.181956, 0.000000, 0.004424, 0.000000, 0.181955, 0.000000, -0.024924, 0.000000, 1.000000}, 
{0.199791, 0.000000, 0.004593, 0.000000, 0.199780, 0.000000, -0.024890, 0.000000, 1.000000}, 
{0.220029, 0.000000, 0.005480, 0.000000, 0.220035, 0.000000, -0.024935, 0.000000, 1.000000}, 
{0.241586, 0.000000, 0.006010, 0.000000, 0.241587, 0.000000, -0.024933, 0.000000, 1.000000}, 
{0.264115, 0.000000, 0.006550, 0.000000, 0.264118, 0.000000, -0.024927, 0.000000, 1.000000}, 
{0.287514, 0.000000, 0.007072, 0.000000, 0.287519, 0.000000, -0.024909, 0.000000, 1.000000}, 
{0.311455, 0.000000, 0.007472, 0.000000, 0.311449, 0.000000, -0.024872, 0.000000, 1.000000}, 
{0.335083, 0.000000, 0.007491, 0.000000, 0.335071, 0.000000, -0.024755, 0.000000, 1.000000}, 
{0.359805, 0.000000, 0.008810, 0.000000, 0.359808, 0.000000, -0.024877, 0.000000, 1.000000}, 
{0.386438, 0.000000, 0.009282, 0.000000, 0.386421, 0.000000, -0.024824, 0.000000, 1.000000}, 
{0.413131, 0.000000, 0.009534, 0.000000, 0.413119, 0.000000, -0.024708, 0.000000, 1.000000}, 
{0.439249, 0.000000, 0.009701, 0.000000, 0.439269, 0.000000, -0.024573, 0.000000, 1.000000}, 
{0.466997, 0.000000, 0.010878, 0.000000, 0.467047, 0.000000, -0.024652, 0.000000, 1.000000}, 
{0.495138, 0.000000, 0.010959, 0.000000, 0.495139, 0.000000, -0.024455, 0.000000, 1.000000}, 
{0.522654, 0.000000, 0.011386, 0.000000, 0.522660, 0.000000, -0.024318, 0.000000, 1.000000}, 
{0.551415, 0.000000, 0.012022, 0.000000, 0.551412, 0.000000, -0.024216, 0.000000, 1.000000}, 
{0.579610, 0.000000, 0.011805, 0.000000, 0.579605, 0.000000, -0.023867, 0.000000, 1.000000}, 
{0.608185, 0.000000, 0.012773, 0.000000, 0.608201, 0.000000, -0.023834, 0.000000, 1.000000}, 
{0.636492, 0.000000, 0.012377, 0.000000, 0.636470, 0.000000, -0.023327, 0.000000, 1.000000}, 
{0.664826, 0.000000, 0.013172, 0.000000, 0.664749, 0.000000, -0.023205, 0.000000, 1.000000}, 
{0.692674, 0.000000, 0.012847, 0.000000, 0.692616, 0.000000, -0.022708, 0.000000, 1.000000}, 
{0.720341, 0.000000, 0.013141, 0.000000, 0.720329, 0.000000, -0.022349, 0.000000, 1.000000}, 
{0.747373, 0.000000, 0.013227, 0.000000, 0.747327, 0.000000, -0.021871, 0.000000, 1.000000}, 
{0.773980, 0.000000, 0.012739, 0.000000, 0.773880, 0.000000, -0.021171, 0.000000, 1.000000}, 
{0.799839, 0.000000, 0.012999, 0.000000, 0.799790, 0.000000, -0.020606, 0.000000, 1.000000}, 
{0.825113, 0.000000, 0.012727, 0.000000, 0.825017, 0.000000, -0.020006, 0.000000, 1.000000}, 
{0.849579, 0.000000, 0.012170, 0.000000, 0.849413, 0.000000, -0.019089, 0.000000, 1.000000}, 
{0.873046, 0.000000, 0.011855, 0.000000, 0.872904, 0.000000, -0.018291, 0.000000, 1.000000}, 
{0.895777, 0.000000, 0.011711, 0.000000, 0.895601, 0.000000, -0.017534, 0.000000, 1.000000}, 
{0.917518, 0.000000, 0.011107, 0.000000, 0.917360, 0.000000, -0.016542, 0.000000, 1.000000}, 
{0.938264, 0.000000, 0.010439, 0.000000, 0.938124, 0.000000, -0.015512, 0.000000, 1.000000}, 
{0.958032, 0.000000, 0.009807, 0.000000, 0.957864, 0.000000, -0.014491, 0.000000, 1.000000}, 
{0.976838, 0.000000, 0.009268, 0.000000, 0.976630, 0.000000, -0.013468, 0.000000, 1.000000}, 
{0.994631, 0.000000, 0.008662, 0.000000, 0.994422, 0.000000, -0.012376, 0.000000, 1.000000}, 
{1.011434, 0.000000, 0.007923, 0.000000, 1.011230, 0.000000, -0.011187, 0.000000, 1.000000}, 
{1.027169, 0.000000, 0.007132, 0.000000, 1.027019, 0.000000, -0.010078, 0.000000, 1.000000}, 
{1.041929, 0.000000, 0.006332, 0.000000, 1.041885, 0.000000, -0.008924, 0.000000, 1.000000}, 
{1.055767, 0.000000, 0.005554, 0.000000, 1.055646, 0.000000, -0.007770, 0.000000, 1.000000}, 
{1.068595, 0.000000, 0.004811, 0.000000, 1.068537, 0.000000, -0.006611, 0.000000, 1.000000}, 
{1.080612, 0.000000, 0.003950, 0.000000, 1.080583, 0.000000, -0.005485, 0.000000, 1.000000}, 
{1.091785, 0.000000, 0.003174, 0.000000, 1.091680, 0.000000, -0.004352, 0.000000, 1.000000}, 
{1.101998, 0.000000, 0.002363, 0.000000, 1.101974, 0.000000, -0.003180, 0.000000, 1.000000}, 
{1.111423, 0.000000, 0.001552, 0.000000, 1.111443, 0.000000, -0.002091, 0.000000, 1.000000}, 
{1.120007, 0.000000, 0.000786, 0.000000, 1.120067, 0.000000, -0.000991, 0.000000, 1.000000}, 
{1.127918, 0.000000, -0.000004, 0.000000, 1.127918, 0.000000, 0.000004, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000010, 0.000000, 0.000200, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000025, 0.000000, 0.000504, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000101, 0.000000, 0.002016, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000226, 0.000000, 0.004535, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.000402, 0.000000, 0.008063, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.000629, 0.000000, 0.012599, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.018140, 0.000000, 0.000905, 0.000000, 0.018142, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.024691, 0.000000, 0.001232, 0.000000, 0.024691, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.032251, 0.000000, 0.001610, 0.000000, 0.032254, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.040821, 0.000000, 0.002037, 0.000000, 0.040825, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.050398, 0.000000, 0.002515, 0.000000, 0.050401, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.060989, 0.000000, 0.003044, 0.000000, 0.060990, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.072592, 0.000000, 0.003623, 0.000000, 0.072588, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.085204, 0.000000, 0.004252, 0.000000, 0.085206, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.098832, 0.000000, 0.004932, 0.000000, 0.098836, 0.000000, -0.049908, 0.000000, 1.000000}, 
{0.113481, 0.000000, 0.005663, 0.000000, 0.113482, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.129145, 0.000000, 0.006443, 0.000000, 0.129151, 0.000000, -0.049907, 0.000000, 1.000000}, 
{0.145825, 0.000000, 0.007271, 0.000000, 0.145824, 0.000000, -0.049906, 0.000000, 1.000000}, 
{0.163491, 0.000000, 0.008128, 0.000000, 0.163492, 0.000000, -0.049903, 0.000000, 1.000000}, 
{0.181911, 0.000000, 0.008826, 0.000000, 0.181904, 0.000000, -0.049879, 0.000000, 1.000000}, 
{0.200065, 0.000000, 0.009285, 0.000000, 0.200039, 0.000000, -0.049824, 0.000000, 1.000000}, 
{0.220025, 0.000000, 0.010966, 0.000000, 0.220033, 0.000000, -0.049897, 0.000000, 1.000000}, 
{0.241581, 0.000000, 0.012025, 0.000000, 0.241586, 0.000000, -0.049893, 0.000000, 1.000000}, 
{0.264099, 0.000000, 0.013105, 0.000000, 0.264120, 0.000000, -0.049881, 0.000000, 1.000000}, 
{0.287493, 0.000000, 0.014145, 0.000000, 0.287511, 0.000000, -0.049855, 0.000000, 1.000000}, 
{0.311399, 0.000000, 0.014925, 0.000000, 0.311390, 0.000000, -0.049769, 0.000000, 1.000000}, 
{0.335096, 0.000000, 0.015239, 0.000000, 0.335060, 0.000000, -0.049591, 0.000000, 1.000000}, 
{0.359815, 0.000000, 0.017559, 0.000000, 0.359820, 0.000000, -0.049777, 0.000000, 1.000000}, 
{0.386365, 0.000000, 0.018554, 0.000000, 0.386377, 0.000000, -0.049675, 0.000000, 1.000000}, 
{0.413017, 0.000000, 0.019043, 0.000000, 0.413010, 0.000000, -0.049444, 0.000000, 1.000000}, 
{0.439519, 0.000000, 0.019815, 0.000000, 0.439491, 0.000000, -0.049253, 0.000000, 1.000000}, 
{0.466938, 0.000000, 0.021741, 0.000000, 0.466933, 0.000000, -0.049327, 0.000000, 1.000000}, 
{0.494999, 0.000000, 0.021887, 0.000000, 0.494990, 0.000000, -0.048922, 0.000000, 1.000000}, 
{0.522922, 0.000000, 0.022844, 0.000000, 0.522932, 0.000000, -0.048677, 0.000000, 1.000000}, 
{0.551270, 0.000000, 0.024014, 0.000000, 0.551276, 0.000000, -0.048478, 0.000000, 1.000000}, 
{0.579771, 0.000000, 0.024156, 0.000000, 0.579734, 0.000000, -0.047904, 0.000000, 1.000000}, 
{0.608156, 0.000000, 0.025317, 0.000000, 0.608098, 0.000000, -0.047594, 0.000000, 1.000000}, 
{0.636662, 0.000000, 0.025321, 0.000000, 0.636592, 0.000000, -0.046876, 0.000000, 1.000000}, 
{0.664846, 0.000000, 0.026018, 0.000000, 0.664728, 0.000000, -0.046354, 0.000000, 1.000000}, 
{0.692877, 0.000000, 0.026041, 0.000000, 0.692783, 0.000000, -0.045504, 0.000000, 1.000000}, 
{0.720316, 0.000000, 0.026252, 0.000000, 0.720159, 0.000000, -0.044655, 0.000000, 1.000000}, 
{0.747658, 0.000000, 0.026159, 0.000000, 0.747357, 0.000000, -0.043670, 0.000000, 1.000000}, 
{0.774252, 0.000000, 0.026086, 0.000000, 0.773933, 0.000000, -0.042515, 0.000000, 1.000000}, 
{0.800179, 0.000000, 0.025653, 0.000000, 0.799801, 0.000000, -0.041211, 0.000000, 1.000000}, 
{0.825525, 0.000000, 0.025170, 0.000000, 0.825053, 0.000000, -0.039823, 0.000000, 1.000000}, 
{0.850013, 0.000000, 0.024788, 0.000000, 0.849431, 0.000000, -0.038409, 0.000000, 1.000000}, 
{0.873593, 0.000000, 0.023992, 0.000000, 0.873001, 0.000000, -0.036767, 0.000000, 1.000000}, 
{0.896343, 0.000000, 0.022985, 0.000000, 0.895653, 0.000000, -0.034900, 0.000000, 1.000000}, 
{0.918062, 0.000000, 0.022005, 0.000000, 0.917368, 0.000000, -0.033010, 0.000000, 1.000000}, 
{0.938928, 0.000000, 0.021110, 0.000000, 0.938175, 0.000000, -0.031143, 0.000000, 1.000000}, 
{0.958667, 0.000000, 0.019893, 0.000000, 0.957960, 0.000000, -0.029059, 0.000000, 1.000000}, 
{0.977457, 0.000000, 0.018546, 0.000000, 0.976789, 0.000000, -0.026888, 0.000000, 1.000000}, 
{0.995243, 0.000000, 0.017152, 0.000000, 0.994578, 0.000000, -0.024713, 0.000000, 1.000000}, 
{1.012023, 0.000000, 0.015750, 0.000000, 1.011265, 0.000000, -0.022496, 0.000000, 1.000000}, 
{1.027614, 0.000000, 0.014289, 0.000000, 1.027028, 0.000000, -0.020153, 0.000000, 1.000000}, 
{1.042389, 0.000000, 0.012688, 0.000000, 1.041861, 0.000000, -0.017839, 0.000000, 1.000000}, 
{1.056161, 0.000000, 0.011118, 0.000000, 1.055730, 0.000000, -0.015529, 0.000000, 1.000000}, 
{1.068968, 0.000000, 0.009540, 0.000000, 1.068660, 0.000000, -0.013240, 0.000000, 1.000000}, 
{1.080866, 0.000000, 0.007963, 0.000000, 1.080674, 0.000000, -0.010940, 0.000000, 1.000000}, 
{1.091944, 0.000000, 0.006416, 0.000000, 1.091723, 0.000000, -0.008716, 0.000000, 1.000000}, 
{1.102104, 0.000000, 0.004771, 0.000000, 1.101942, 0.000000, -0.006434, 0.000000, 1.000000}, 
{1.111571, 0.000000, 0.003056, 0.000000, 1.111419, 0.000000, -0.004169, 0.000000, 1.000000}, 
{1.120084, 0.000000, 0.001458, 0.000000, 1.120031, 0.000000, -0.002033, 0.000000, 1.000000}, 
{1.127981, 0.000000, -0.000021, 0.000000, 1.127996, 0.000000, 0.000027, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000015, 0.000000, 0.000200, 0.000000, -0.074940, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000038, 0.000000, 0.000504, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000151, 0.000000, 0.002016, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000340, 0.000000, 0.004535, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.000604, 0.000000, 0.008062, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.012597, 0.000000, 0.000944, 0.000000, 0.012597, 0.000000, -0.074940, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.001359, 0.000000, 0.018142, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.024695, 0.000000, 0.001851, 0.000000, 0.024698, 0.000000, -0.074940, 0.000000, 1.000000}, 
{0.032253, 0.000000, 0.002417, 0.000000, 0.032253, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.040822, 0.000000, 0.003059, 0.000000, 0.040823, 0.000000, -0.074940, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.003777, 0.000000, 0.050400, 0.000000, -0.074940, 0.000000, 1.000000}, 
{0.060989, 0.000000, 0.004570, 0.000000, 0.060990, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.072591, 0.000000, 0.005440, 0.000000, 0.072591, 0.000000, -0.074940, 0.000000, 1.000000}, 
{0.085203, 0.000000, 0.006385, 0.000000, 0.085203, 0.000000, -0.074939, 0.000000, 1.000000}, 
{0.098833, 0.000000, 0.007406, 0.000000, 0.098835, 0.000000, -0.074938, 0.000000, 1.000000}, 
{0.113481, 0.000000, 0.008502, 0.000000, 0.113482, 0.000000, -0.074938, 0.000000, 1.000000}, 
{0.129147, 0.000000, 0.009674, 0.000000, 0.129148, 0.000000, -0.074937, 0.000000, 1.000000}, 
{0.145817, 0.000000, 0.010916, 0.000000, 0.145831, 0.000000, -0.074937, 0.000000, 1.000000}, 
{0.163485, 0.000000, 0.012199, 0.000000, 0.163487, 0.000000, -0.074928, 0.000000, 1.000000}, 
{0.181824, 0.000000, 0.013172, 0.000000, 0.181801, 0.000000, -0.074885, 0.000000, 1.000000}, 
{0.200274, 0.000000, 0.014100, 0.000000, 0.200223, 0.000000, -0.074825, 0.000000, 1.000000}, 
{0.220017, 0.000000, 0.016464, 0.000000, 0.220034, 0.000000, -0.074928, 0.000000, 1.000000}, 
{0.241568, 0.000000, 0.018052, 0.000000, 0.241594, 0.000000, -0.074914, 0.000000, 1.000000}, 
{0.264084, 0.000000, 0.019671, 0.000000, 0.264116, 0.000000, -0.074898, 0.000000, 1.000000}, 
{0.287450, 0.000000, 0.021217, 0.000000, 0.287477, 0.000000, -0.074860, 0.000000, 1.000000}, 
{0.311281, 0.000000, 0.022341, 0.000000, 0.311271, 0.000000, -0.074717, 0.000000, 1.000000}, 
{0.335228, 0.000000, 0.023296, 0.000000, 0.335181, 0.000000, -0.074526, 0.000000, 1.000000}, 
{0.360047, 0.000000, 0.025965, 0.000000, 0.360076, 0.000000, -0.074649, 0.000000, 1.000000}, 
{0.386273, 0.000000, 0.027808, 0.000000, 0.386305, 0.000000, -0.074575, 0.000000, 1.000000}, 
{0.412855, 0.000000, 0.028504, 0.000000, 0.412838, 0.000000, -0.074237, 0.000000, 1.000000}, 
{0.439705, 0.000000, 0.030007, 0.000000, 0.439671, 0.000000, -0.074013, 0.000000, 1.000000}, 
{0.466975, 0.000000, 0.032263, 0.000000, 0.466988, 0.000000, -0.073967, 0.000000, 1.000000}, 
{0.494874, 0.000000, 0.032931, 0.000000, 0.494839, 0.000000, -0.073475, 0.000000, 1.000000}, 
{0.523066, 0.000000, 0.034348, 0.000000, 0.523048, 0.000000, -0.073084, 0.000000, 1.000000}, 
{0.551198, 0.000000, 0.035739, 0.000000, 0.551146, 0.000000, -0.072657, 0.000000, 1.000000}, 
{0.579889, 0.000000, 0.036575, 0.000000, 0.579806, 0.000000, -0.072029, 0.000000, 1.000000}, 
{0.608282, 0.000000, 0.037434, 0.000000, 0.608151, 0.000000, -0.071309, 0.000000, 1.000000}, 
{0.636812, 0.000000, 0.038323, 0.000000, 0.636593, 0.000000, -0.070507, 0.000000, 1.000000}, 
{0.665010, 0.000000, 0.038676, 0.000000, 0.664768, 0.000000, -0.069424, 0.000000, 1.000000}, 
{0.693063, 0.000000, 0.039237, 0.000000, 0.692739, 0.000000, -0.068370, 0.000000, 1.000000}, 
{0.720750, 0.000000, 0.039332, 0.000000, 0.720342, 0.000000, -0.066988, 0.000000, 1.000000}, 
{0.747911, 0.000000, 0.039179, 0.000000, 0.747398, 0.000000, -0.065447, 0.000000, 1.000000}, 
{0.774576, 0.000000, 0.039110, 0.000000, 0.773950, 0.000000, -0.063838, 0.000000, 1.000000}, 
{0.800737, 0.000000, 0.038542, 0.000000, 0.799902, 0.000000, -0.061923, 0.000000, 1.000000}, 
{0.825966, 0.000000, 0.037966, 0.000000, 0.825083, 0.000000, -0.059859, 0.000000, 1.000000}, 
{0.850534, 0.000000, 0.036943, 0.000000, 0.849443, 0.000000, -0.057529, 0.000000, 1.000000}, 
{0.874289, 0.000000, 0.035853, 0.000000, 0.873155, 0.000000, -0.055081, 0.000000, 1.000000}, 
{0.897152, 0.000000, 0.034730, 0.000000, 0.895795, 0.000000, -0.052476, 0.000000, 1.000000}, 
{0.919029, 0.000000, 0.033242, 0.000000, 0.917510, 0.000000, -0.049647, 0.000000, 1.000000}, 
{0.939851, 0.000000, 0.031508, 0.000000, 0.938305, 0.000000, -0.046670, 0.000000, 1.000000}, 
{0.959599, 0.000000, 0.029695, 0.000000, 0.958100, 0.000000, -0.043588, 0.000000, 1.000000}, 
{0.978293, 0.000000, 0.027845, 0.000000, 0.976761, 0.000000, -0.040401, 0.000000, 1.000000}, 
{0.996085, 0.000000, 0.025775, 0.000000, 0.994608, 0.000000, -0.037060, 0.000000, 1.000000}, 
{1.012768, 0.000000, 0.023607, 0.000000, 1.011407, 0.000000, -0.033726, 0.000000, 1.000000}, 
{1.028404, 0.000000, 0.021374, 0.000000, 1.027178, 0.000000, -0.030217, 0.000000, 1.000000}, 
{1.043150, 0.000000, 0.019108, 0.000000, 1.041993, 0.000000, -0.026820, 0.000000, 1.000000}, 
{1.056760, 0.000000, 0.016823, 0.000000, 1.055808, 0.000000, -0.023372, 0.000000, 1.000000}, 
{1.069471, 0.000000, 0.014378, 0.000000, 1.068727, 0.000000, -0.019891, 0.000000, 1.000000}, 
{1.081283, 0.000000, 0.011884, 0.000000, 1.080739, 0.000000, -0.016405, 0.000000, 1.000000}, 
{1.092238, 0.000000, 0.009398, 0.000000, 1.091799, 0.000000, -0.012950, 0.000000, 1.000000}, 
{1.102384, 0.000000, 0.007030, 0.000000, 1.102100, 0.000000, -0.009579, 0.000000, 1.000000}, 
{1.111737, 0.000000, 0.004751, 0.000000, 1.111517, 0.000000, -0.006384, 0.000000, 1.000000}, 
{1.120274, 0.000000, 0.002404, 0.000000, 1.120230, 0.000000, -0.003192, 0.000000, 1.000000}, 
{1.128182, 0.000000, -0.000031, 0.000000, 1.128160, 0.000000, -0.000033, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000020, 0.000000, 0.000200, 0.000000, -0.100065, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000050, 0.000000, 0.000504, 0.000000, -0.100065, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000202, 0.000000, 0.002016, 0.000000, -0.100064, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000454, 0.000000, 0.004535, 0.000000, -0.100065, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.000807, 0.000000, 0.008063, 0.000000, -0.100064, 0.000000, 1.000000}, 
{0.012599, 0.000000, 0.001261, 0.000000, 0.012597, 0.000000, -0.100064, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.001815, 0.000000, 0.018140, 0.000000, -0.100065, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.002471, 0.000000, 0.024692, 0.000000, -0.100066, 0.000000, 1.000000}, 
{0.032251, 0.000000, 0.003227, 0.000000, 0.032253, 0.000000, -0.100065, 0.000000, 1.000000}, 
{0.040818, 0.000000, 0.004084, 0.000000, 0.040820, 0.000000, -0.100067, 0.000000, 1.000000}, 
{0.050401, 0.000000, 0.005043, 0.000000, 0.050400, 0.000000, -0.100064, 0.000000, 1.000000}, 
{0.060988, 0.000000, 0.006102, 0.000000, 0.060990, 0.000000, -0.100064, 0.000000, 1.000000}, 
{0.072588, 0.000000, 0.007263, 0.000000, 0.072590, 0.000000, -0.100063, 0.000000, 1.000000}, 
{0.085205, 0.000000, 0.008525, 0.000000, 0.085204, 0.000000, -0.100063, 0.000000, 1.000000}, 
{0.098832, 0.000000, 0.009888, 0.000000, 0.098837, 0.000000, -0.100062, 0.000000, 1.000000}, 
{0.113479, 0.000000, 0.011352, 0.000000, 0.113483, 0.000000, -0.100063, 0.000000, 1.000000}, 
{0.129142, 0.000000, 0.012916, 0.000000, 0.129150, 0.000000, -0.100062, 0.000000, 1.000000}, 
{0.145817, 0.000000, 0.014573, 0.000000, 0.145828, 0.000000, -0.100058, 0.000000, 1.000000}, 
{0.163468, 0.000000, 0.016276, 0.000000, 0.163476, 0.000000, -0.100050, 0.000000, 1.000000}, 
{0.181674, 0.000000, 0.017411, 0.000000, 0.181624, 0.000000, -0.099975, 0.000000, 1.000000}, 
{0.200435, 0.000000, 0.019002, 0.000000, 0.200362, 0.000000, -0.099932, 0.000000, 1.000000}, 
{0.220005, 0.000000, 0.021978, 0.000000, 0.220043, 0.000000, -0.100043, 0.000000, 1.000000}, 
{0.241550, 0.000000, 0.024096, 0.000000, 0.241598, 0.000000, -0.100031, 0.000000, 1.000000}, 
{0.264058, 0.000000, 0.026250, 0.000000, 0.264104, 0.000000, -0.100002, 0.000000, 1.000000}, 
{0.287399, 0.000000, 0.028286, 0.000000, 0.287431, 0.000000, -0.099939, 0.000000, 1.000000}, 
{0.311134, 0.000000, 0.029698, 0.000000, 0.311111, 0.000000, -0.099748, 0.000000, 1.000000}, 
{0.335350, 0.000000, 0.031442, 0.000000, 0.335293, 0.000000, -0.099582, 0.000000, 1.000000}, 
{0.360295, 0.000000, 0.034401, 0.000000, 0.360308, 0.000000, -0.099613, 0.000000, 1.000000}, 
{0.386112, 0.000000, 0.037030, 0.000000, 0.386196, 0.000000, -0.099558, 0.000000, 1.000000}, 
{0.412733, 0.000000, 0.038163, 0.000000, 0.412699, 0.000000, -0.099137, 0.000000, 1.000000}, 
{0.439833, 0.000000, 0.040250, 0.000000, 0.439799, 0.000000, -0.098866, 0.000000, 1.000000}, 
{0.467099, 0.000000, 0.042583, 0.000000, 0.467090, 0.000000, -0.098626, 0.000000, 1.000000}, 
{0.494828, 0.000000, 0.044299, 0.000000, 0.494820, 0.000000, -0.098149, 0.000000, 1.000000}, 
{0.523217, 0.000000, 0.045876, 0.000000, 0.523137, 0.000000, -0.097600, 0.000000, 1.000000}, 
{0.551338, 0.000000, 0.047440, 0.000000, 0.551246, 0.000000, -0.096929, 0.000000, 1.000000}, 
{0.579917, 0.000000, 0.048995, 0.000000, 0.579776, 0.000000, -0.096178, 0.000000, 1.000000}, 
{0.608454, 0.000000, 0.049901, 0.000000, 0.608207, 0.000000, -0.095145, 0.000000, 1.000000}, 
{0.636785, 0.000000, 0.051224, 0.000000, 0.636539, 0.000000, -0.094151, 0.000000, 1.000000}, 
{0.665220, 0.000000, 0.051675, 0.000000, 0.664865, 0.000000, -0.092728, 0.000000, 1.000000}, 
{0.693194, 0.000000, 0.052278, 0.000000, 0.692686, 0.000000, -0.091195, 0.000000, 1.000000}, 
{0.721008, 0.000000, 0.052406, 0.000000, 0.720414, 0.000000, -0.089384, 0.000000, 1.000000}, 
{0.748196, 0.000000, 0.052529, 0.000000, 0.747395, 0.000000, -0.087461, 0.000000, 1.000000}, 
{0.774975, 0.000000, 0.051950, 0.000000, 0.774094, 0.000000, -0.085133, 0.000000, 1.000000}, 
{0.801129, 0.000000, 0.051456, 0.000000, 0.799995, 0.000000, -0.082628, 0.000000, 1.000000}, 
{0.826668, 0.000000, 0.050569, 0.000000, 0.825248, 0.000000, -0.079817, 0.000000, 1.000000}, 
{0.851291, 0.000000, 0.049328, 0.000000, 0.849659, 0.000000, -0.076710, 0.000000, 1.000000}, 
{0.875056, 0.000000, 0.047988, 0.000000, 0.873183, 0.000000, -0.073481, 0.000000, 1.000000}, 
{0.897872, 0.000000, 0.046149, 0.000000, 0.895955, 0.000000, -0.069943, 0.000000, 1.000000}, 
{0.919803, 0.000000, 0.044144, 0.000000, 0.917663, 0.000000, -0.066151, 0.000000, 1.000000}, 
{0.940701, 0.000000, 0.042095, 0.000000, 0.938485, 0.000000, -0.062247, 0.000000, 1.000000}, 
{0.960580, 0.000000, 0.039730, 0.000000, 0.958250, 0.000000, -0.058158, 0.000000, 1.000000}, 
{0.979427, 0.000000, 0.037104, 0.000000, 0.976994, 0.000000, -0.053850, 0.000000, 1.000000}, 
{0.997157, 0.000000, 0.034369, 0.000000, 0.994853, 0.000000, -0.049403, 0.000000, 1.000000}, 
{1.013777, 0.000000, 0.031555, 0.000000, 1.011532, 0.000000, -0.044944, 0.000000, 1.000000}, 
{1.029452, 0.000000, 0.028571, 0.000000, 1.027307, 0.000000, -0.040414, 0.000000, 1.000000}, 
{1.044029, 0.000000, 0.025416, 0.000000, 1.042125, 0.000000, -0.035723, 0.000000, 1.000000}, 
{1.057586, 0.000000, 0.022217, 0.000000, 1.055951, 0.000000, -0.031072, 0.000000, 1.000000}, 
{1.070148, 0.000000, 0.019037, 0.000000, 1.068831, 0.000000, -0.026429, 0.000000, 1.000000}, 
{1.081875, 0.000000, 0.015936, 0.000000, 1.080795, 0.000000, -0.021896, 0.000000, 1.000000}, 
{1.092789, 0.000000, 0.012734, 0.000000, 1.091859, 0.000000, -0.017288, 0.000000, 1.000000}, 
{1.102704, 0.000000, 0.009454, 0.000000, 1.102160, 0.000000, -0.012841, 0.000000, 1.000000}, 
{1.112011, 0.000000, 0.006199, 0.000000, 1.111633, 0.000000, -0.008446, 0.000000, 1.000000}, 
{1.120590, 0.000000, 0.003010, 0.000000, 1.120416, 0.000000, -0.004122, 0.000000, 1.000000}, 
{1.128283, 0.000000, -0.000027, 0.000000, 1.128333, 0.000000, 0.000038, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000025, 0.000000, 0.000200, 0.000000, -0.125315, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000063, 0.000000, 0.000504, 0.000000, -0.125316, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000253, 0.000000, 0.002016, 0.000000, -0.125315, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000568, 0.000000, 0.004535, 0.000000, -0.125314, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.001010, 0.000000, 0.008062, 0.000000, -0.125316, 0.000000, 1.000000}, 
{0.012599, 0.000000, 0.001579, 0.000000, 0.012597, 0.000000, -0.125315, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.002273, 0.000000, 0.018140, 0.000000, -0.125316, 0.000000, 1.000000}, 
{0.024691, 0.000000, 0.003094, 0.000000, 0.024692, 0.000000, -0.125316, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.004042, 0.000000, 0.032253, 0.000000, -0.125316, 0.000000, 1.000000}, 
{0.040820, 0.000000, 0.005115, 0.000000, 0.040821, 0.000000, -0.125316, 0.000000, 1.000000}, 
{0.050400, 0.000000, 0.006316, 0.000000, 0.050401, 0.000000, -0.125315, 0.000000, 1.000000}, 
{0.060989, 0.000000, 0.007642, 0.000000, 0.060990, 0.000000, -0.125315, 0.000000, 1.000000}, 
{0.072590, 0.000000, 0.009096, 0.000000, 0.072590, 0.000000, -0.125314, 0.000000, 1.000000}, 
{0.085203, 0.000000, 0.010676, 0.000000, 0.085207, 0.000000, -0.125314, 0.000000, 1.000000}, 
{0.098833, 0.000000, 0.012383, 0.000000, 0.098836, 0.000000, -0.125315, 0.000000, 1.000000}, 
{0.113477, 0.000000, 0.014215, 0.000000, 0.113484, 0.000000, -0.125312, 0.000000, 1.000000}, 
{0.129138, 0.000000, 0.016173, 0.000000, 0.129150, 0.000000, -0.125311, 0.000000, 1.000000}, 
{0.145815, 0.000000, 0.018246, 0.000000, 0.145825, 0.000000, -0.125306, 0.000000, 1.000000}, 
{0.163450, 0.000000, 0.020360, 0.000000, 0.163457, 0.000000, -0.125294, 0.000000, 1.000000}, 
{0.181595, 0.000000, 0.021807, 0.000000, 0.181519, 0.000000, -0.125204, 0.000000, 1.000000}, 
{0.200563, 0.000000, 0.023971, 0.000000, 0.200468, 0.000000, -0.125165, 0.000000, 1.000000}, 
{0.220186, 0.000000, 0.027280, 0.000000, 0.220209, 0.000000, -0.125250, 0.000000, 1.000000}, 
{0.241528, 0.000000, 0.030164, 0.000000, 0.241600, 0.000000, -0.125267, 0.000000, 1.000000}, 
{0.264020, 0.000000, 0.032847, 0.000000, 0.264101, 0.000000, -0.125233, 0.000000, 1.000000}, 
{0.287311, 0.000000, 0.035345, 0.000000, 0.287357, 0.000000, -0.125138, 0.000000, 1.000000}, 
{0.310993, 0.000000, 0.037108, 0.000000, 0.310944, 0.000000, -0.124903, 0.000000, 1.000000}, 
{0.335467, 0.000000, 0.039653, 0.000000, 0.335393, 0.000000, -0.124749, 0.000000, 1.000000}, 
{0.360497, 0.000000, 0.042914, 0.000000, 0.360506, 0.000000, -0.124702, 0.000000, 1.000000}, 
{0.385986, 0.000000, 0.046142, 0.000000, 0.386067, 0.000000, -0.124623, 0.000000, 1.000000}, 
{0.412703, 0.000000, 0.048050, 0.000000, 0.412669, 0.000000, -0.124193, 0.000000, 1.000000}, 
{0.439929, 0.000000, 0.050527, 0.000000, 0.439889, 0.000000, -0.123833, 0.000000, 1.000000}, 
{0.467163, 0.000000, 0.052880, 0.000000, 0.467107, 0.000000, -0.123375, 0.000000, 1.000000}, 
{0.494824, 0.000000, 0.055672, 0.000000, 0.494794, 0.000000, -0.122982, 0.000000, 1.000000}, 
{0.523222, 0.000000, 0.057388, 0.000000, 0.523094, 0.000000, -0.122166, 0.000000, 1.000000}, 
{0.551557, 0.000000, 0.059328, 0.000000, 0.551366, 0.000000, -0.121343, 0.000000, 1.000000}, 
{0.579884, 0.000000, 0.061315, 0.000000, 0.579698, 0.000000, -0.120430, 0.000000, 1.000000}, 
{0.608619, 0.000000, 0.062531, 0.000000, 0.608316, 0.000000, -0.119140, 0.000000, 1.000000}, 
{0.637014, 0.000000, 0.063778, 0.000000, 0.636612, 0.000000, -0.117721, 0.000000, 1.000000}, 
{0.665425, 0.000000, 0.064734, 0.000000, 0.664915, 0.000000, -0.116069, 0.000000, 1.000000}, 
{0.693580, 0.000000, 0.065315, 0.000000, 0.692920, 0.000000, -0.114146, 0.000000, 1.000000}, 
{0.721194, 0.000000, 0.065535, 0.000000, 0.720455, 0.000000, -0.111846, 0.000000, 1.000000}, 
{0.748586, 0.000000, 0.065501, 0.000000, 0.747600, 0.000000, -0.109309, 0.000000, 1.000000}, 
{0.775437, 0.000000, 0.065091, 0.000000, 0.774182, 0.000000, -0.106504, 0.000000, 1.000000}, 
{0.801554, 0.000000, 0.064332, 0.000000, 0.800090, 0.000000, -0.103308, 0.000000, 1.000000}, 
{0.827079, 0.000000, 0.063078, 0.000000, 0.825420, 0.000000, -0.099695, 0.000000, 1.000000}, 
{0.851693, 0.000000, 0.061728, 0.000000, 0.849770, 0.000000, -0.095946, 0.000000, 1.000000}, 
{0.875586, 0.000000, 0.059853, 0.000000, 0.873459, 0.000000, -0.091802, 0.000000, 1.000000}, 
{0.898589, 0.000000, 0.057727, 0.000000, 0.896093, 0.000000, -0.087339, 0.000000, 1.000000}, 
{0.920421, 0.000000, 0.055377, 0.000000, 0.917871, 0.000000, -0.082687, 0.000000, 1.000000}, 
{0.941533, 0.000000, 0.052571, 0.000000, 0.938552, 0.000000, -0.077716, 0.000000, 1.000000}, 
{0.961426, 0.000000, 0.049544, 0.000000, 0.958381, 0.000000, -0.072574, 0.000000, 1.000000}, 
{0.980287, 0.000000, 0.046400, 0.000000, 0.977159, 0.000000, -0.067217, 0.000000, 1.000000}, 
{0.998080, 0.000000, 0.042966, 0.000000, 0.994892, 0.000000, -0.061757, 0.000000, 1.000000}, 
{1.014940, 0.000000, 0.039321, 0.000000, 1.011736, 0.000000, -0.056072, 0.000000, 1.000000}, 
{1.030455, 0.000000, 0.035585, 0.000000, 1.027513, 0.000000, -0.050410, 0.000000, 1.000000}, 
{1.045078, 0.000000, 0.031823, 0.000000, 1.042172, 0.000000, -0.044622, 0.000000, 1.000000}, 
{1.058555, 0.000000, 0.027947, 0.000000, 1.056029, 0.000000, -0.038893, 0.000000, 1.000000}, 
{1.071009, 0.000000, 0.023891, 0.000000, 1.068907, 0.000000, -0.032977, 0.000000, 1.000000}, 
{1.082594, 0.000000, 0.019822, 0.000000, 1.080948, 0.000000, -0.027290, 0.000000, 1.000000}, 
{1.093265, 0.000000, 0.015765, 0.000000, 1.092073, 0.000000, -0.021543, 0.000000, 1.000000}, 
{1.103132, 0.000000, 0.011790, 0.000000, 1.102281, 0.000000, -0.016072, 0.000000, 1.000000}, 
{1.112348, 0.000000, 0.007784, 0.000000, 1.111818, 0.000000, -0.010511, 0.000000, 1.000000}, 
{1.120845, 0.000000, 0.003849, 0.000000, 1.120614, 0.000000, -0.005174, 0.000000, 1.000000}, 
{1.128573, 0.000000, -0.000057, 0.000000, 1.128601, 0.000000, 0.000039, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000030, 0.000000, 0.000200, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000076, 0.000000, 0.000504, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000304, 0.000000, 0.002016, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000684, 0.000000, 0.004535, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.001215, 0.000000, 0.008062, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.001899, 0.000000, 0.012598, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.002734, 0.000000, 0.018142, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.024694, 0.000000, 0.003722, 0.000000, 0.024692, 0.000000, -0.150724, 0.000000, 1.000000}, 
{0.032254, 0.000000, 0.004861, 0.000000, 0.032252, 0.000000, -0.150726, 0.000000, 1.000000}, 
{0.040815, 0.000000, 0.006152, 0.000000, 0.040816, 0.000000, -0.150724, 0.000000, 1.000000}, 
{0.050400, 0.000000, 0.007596, 0.000000, 0.050400, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.060990, 0.000000, 0.009192, 0.000000, 0.060989, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.072587, 0.000000, 0.010939, 0.000000, 0.072593, 0.000000, -0.150723, 0.000000, 1.000000}, 
{0.085203, 0.000000, 0.012839, 0.000000, 0.085206, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.098828, 0.000000, 0.014891, 0.000000, 0.098833, 0.000000, -0.150725, 0.000000, 1.000000}, 
{0.113473, 0.000000, 0.017095, 0.000000, 0.113486, 0.000000, -0.150720, 0.000000, 1.000000}, 
{0.129137, 0.000000, 0.019449, 0.000000, 0.129153, 0.000000, -0.150716, 0.000000, 1.000000}, 
{0.145803, 0.000000, 0.021938, 0.000000, 0.145827, 0.000000, -0.150712, 0.000000, 1.000000}, 
{0.163417, 0.000000, 0.024443, 0.000000, 0.163428, 0.000000, -0.150691, 0.000000, 1.000000}, 
{0.181580, 0.000000, 0.026329, 0.000000, 0.181479, 0.000000, -0.150600, 0.000000, 1.000000}, 
{0.200667, 0.000000, 0.028997, 0.000000, 0.200553, 0.000000, -0.150553, 0.000000, 1.000000}, 
{0.220429, 0.000000, 0.032584, 0.000000, 0.220422, 0.000000, -0.150610, 0.000000, 1.000000}, 
{0.241497, 0.000000, 0.036260, 0.000000, 0.241596, 0.000000, -0.150658, 0.000000, 1.000000}, 
{0.263975, 0.000000, 0.039465, 0.000000, 0.264078, 0.000000, -0.150619, 0.000000, 1.000000}, 
{0.287210, 0.000000, 0.042385, 0.000000, 0.287272, 0.000000, -0.150490, 0.000000, 1.000000}, 
{0.310935, 0.000000, 0.044758, 0.000000, 0.310891, 0.000000, -0.150241, 0.000000, 1.000000}, 
{0.335556, 0.000000, 0.047922, 0.000000, 0.335482, 0.000000, -0.150076, 0.000000, 1.000000}, 
{0.360667, 0.000000, 0.051493, 0.000000, 0.360656, 0.000000, -0.149931, 0.000000, 1.000000}, 
{0.386028, 0.000000, 0.054931, 0.000000, 0.386059, 0.000000, -0.149754, 0.000000, 1.000000}, 
{0.412665, 0.000000, 0.058007, 0.000000, 0.412656, 0.000000, -0.149400, 0.000000, 1.000000}, 
{0.439951, 0.000000, 0.060813, 0.000000, 0.439891, 0.000000, -0.148913, 0.000000, 1.000000}, 
{0.467262, 0.000000, 0.063461, 0.000000, 0.467176, 0.000000, -0.148319, 0.000000, 1.000000}, 
{0.494972, 0.000000, 0.066738, 0.000000, 0.494890, 0.000000, -0.147798, 0.000000, 1.000000}, 
{0.523153, 0.000000, 0.068976, 0.000000, 0.523019, 0.000000, -0.146903, 0.000000, 1.000000}, 
{0.551700, 0.000000, 0.071268, 0.000000, 0.551482, 0.000000, -0.145863, 0.000000, 1.000000}, 
{0.580046, 0.000000, 0.073439, 0.000000, 0.579774, 0.000000, -0.144695, 0.000000, 1.000000}, 
{0.608649, 0.000000, 0.075193, 0.000000, 0.608347, 0.000000, -0.143237, 0.000000, 1.000000}, 
{0.637239, 0.000000, 0.076536, 0.000000, 0.636766, 0.000000, -0.141463, 0.000000, 1.000000}, 
{0.665388, 0.000000, 0.077771, 0.000000, 0.664858, 0.000000, -0.139462, 0.000000, 1.000000}, 
{0.693755, 0.000000, 0.078344, 0.000000, 0.692985, 0.000000, -0.137082, 0.000000, 1.000000}, 
{0.721345, 0.000000, 0.078817, 0.000000, 0.720509, 0.000000, -0.134403, 0.000000, 1.000000}, 
{0.748879, 0.000000, 0.078512, 0.000000, 0.747677, 0.000000, -0.131252, 0.000000, 1.000000}, 
{0.775560, 0.000000, 0.078128, 0.000000, 0.774206, 0.000000, -0.127866, 0.000000, 1.000000}, 
{0.801897, 0.000000, 0.077094, 0.000000, 0.800345, 0.000000, -0.123928, 0.000000, 1.000000}, 
{0.827193, 0.000000, 0.075863, 0.000000, 0.825527, 0.000000, -0.119733, 0.000000, 1.000000}, 
{0.851990, 0.000000, 0.073973, 0.000000, 0.849966, 0.000000, -0.115055, 0.000000, 1.000000}, 
{0.875823, 0.000000, 0.071765, 0.000000, 0.873595, 0.000000, -0.110098, 0.000000, 1.000000}, 
{0.898655, 0.000000, 0.069241, 0.000000, 0.896172, 0.000000, -0.104722, 0.000000, 1.000000}, 
{0.920915, 0.000000, 0.066232, 0.000000, 0.918120, 0.000000, -0.098991, 0.000000, 1.000000}, 
{0.941969, 0.000000, 0.062980, 0.000000, 0.938827, 0.000000, -0.093044, 0.000000, 1.000000}, 
{0.961882, 0.000000, 0.059507, 0.000000, 0.958641, 0.000000, -0.086925, 0.000000, 1.000000}, 
{0.980952, 0.000000, 0.055606, 0.000000, 0.977364, 0.000000, -0.080520, 0.000000, 1.000000}, 
{0.998955, 0.000000, 0.051503, 0.000000, 0.995164, 0.000000, -0.073890, 0.000000, 1.000000}, 
{1.015756, 0.000000, 0.047292, 0.000000, 1.011948, 0.000000, -0.067302, 0.000000, 1.000000}, 
{1.031571, 0.000000, 0.042804, 0.000000, 1.027644, 0.000000, -0.060412, 0.000000, 1.000000}, 
{1.046095, 0.000000, 0.038132, 0.000000, 1.042389, 0.000000, -0.053497, 0.000000, 1.000000}, 
{1.059542, 0.000000, 0.033380, 0.000000, 1.056246, 0.000000, -0.046569, 0.000000, 1.000000}, 
{1.072006, 0.000000, 0.028613, 0.000000, 1.069152, 0.000000, -0.039679, 0.000000, 1.000000}, 
{1.083348, 0.000000, 0.023811, 0.000000, 1.081025, 0.000000, -0.032772, 0.000000, 1.000000}, 
{1.093969, 0.000000, 0.018930, 0.000000, 1.092201, 0.000000, -0.025894, 0.000000, 1.000000}, 
{1.103697, 0.000000, 0.014098, 0.000000, 1.102552, 0.000000, -0.019178, 0.000000, 1.000000}, 
{1.112813, 0.000000, 0.009339, 0.000000, 1.112019, 0.000000, -0.012652, 0.000000, 1.000000}, 
{1.121193, 0.000000, 0.004661, 0.000000, 1.120859, 0.000000, -0.006226, 0.000000, 1.000000}, 
{1.128930, 0.000000, -0.000052, 0.000000, 1.128943, 0.000000, 0.000008, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000035, 0.000000, 0.000200, 0.000000, -0.176327, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000089, 0.000000, 0.000504, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000355, 0.000000, 0.002016, 0.000000, -0.176325, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000800, 0.000000, 0.004535, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.001422, 0.000000, 0.008063, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.002221, 0.000000, 0.012597, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.003199, 0.000000, 0.018141, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.024695, 0.000000, 0.004354, 0.000000, 0.024690, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.032253, 0.000000, 0.005687, 0.000000, 0.032253, 0.000000, -0.176327, 0.000000, 1.000000}, 
{0.040821, 0.000000, 0.007197, 0.000000, 0.040824, 0.000000, -0.176326, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.008886, 0.000000, 0.050400, 0.000000, -0.176325, 0.000000, 1.000000}, 
{0.060987, 0.000000, 0.010752, 0.000000, 0.060994, 0.000000, -0.176323, 0.000000, 1.000000}, 
{0.072588, 0.000000, 0.012797, 0.000000, 0.072592, 0.000000, -0.176324, 0.000000, 1.000000}, 
{0.085200, 0.000000, 0.015019, 0.000000, 0.085208, 0.000000, -0.176322, 0.000000, 1.000000}, 
{0.098829, 0.000000, 0.017419, 0.000000, 0.098838, 0.000000, -0.176320, 0.000000, 1.000000}, 
{0.113474, 0.000000, 0.019997, 0.000000, 0.113487, 0.000000, -0.176317, 0.000000, 1.000000}, 
{0.129133, 0.000000, 0.022748, 0.000000, 0.129154, 0.000000, -0.176312, 0.000000, 1.000000}, 
{0.145800, 0.000000, 0.025655, 0.000000, 0.145828, 0.000000, -0.176306, 0.000000, 1.000000}, 
{0.163372, 0.000000, 0.028510, 0.000000, 0.163369, 0.000000, -0.176279, 0.000000, 1.000000}, 
{0.181578, 0.000000, 0.030914, 0.000000, 0.181457, 0.000000, -0.176187, 0.000000, 1.000000}, 
{0.200761, 0.000000, 0.034076, 0.000000, 0.200629, 0.000000, -0.176139, 0.000000, 1.000000}, 
{0.220645, 0.000000, 0.037985, 0.000000, 0.220613, 0.000000, -0.176160, 0.000000, 1.000000}, 
{0.241473, 0.000000, 0.042391, 0.000000, 0.241603, 0.000000, -0.176238, 0.000000, 1.000000}, 
{0.263922, 0.000000, 0.046105, 0.000000, 0.264059, 0.000000, -0.176175, 0.000000, 1.000000}, 
{0.287074, 0.000000, 0.049390, 0.000000, 0.287139, 0.000000, -0.176013, 0.000000, 1.000000}, 
{0.310915, 0.000000, 0.052511, 0.000000, 0.310869, 0.000000, -0.175776, 0.000000, 1.000000}, 
{0.335604, 0.000000, 0.056236, 0.000000, 0.335543, 0.000000, -0.175578, 0.000000, 1.000000}, 
{0.360775, 0.000000, 0.060118, 0.000000, 0.360728, 0.000000, -0.175359, 0.000000, 1.000000}, 
{0.386196, 0.000000, 0.063907, 0.000000, 0.386166, 0.000000, -0.175083, 0.000000, 1.000000}, 
{0.412599, 0.000000, 0.067997, 0.000000, 0.412615, 0.000000, -0.174791, 0.000000, 1.000000}, 
{0.439916, 0.000000, 0.071088, 0.000000, 0.439839, 0.000000, -0.174174, 0.000000, 1.000000}, 
{0.467444, 0.000000, 0.074247, 0.000000, 0.467292, 0.000000, -0.173487, 0.000000, 1.000000}, 
{0.495132, 0.000000, 0.077728, 0.000000, 0.495011, 0.000000, -0.172774, 0.000000, 1.000000}, 
{0.523117, 0.000000, 0.080822, 0.000000, 0.523007, 0.000000, -0.171824, 0.000000, 1.000000}, 
{0.551783, 0.000000, 0.083228, 0.000000, 0.551525, 0.000000, -0.170554, 0.000000, 1.000000}, 
{0.580234, 0.000000, 0.085682, 0.000000, 0.579869, 0.000000, -0.169090, 0.000000, 1.000000}, 
{0.608568, 0.000000, 0.087860, 0.000000, 0.608277, 0.000000, -0.167468, 0.000000, 1.000000}, 
{0.637357, 0.000000, 0.089346, 0.000000, 0.636878, 0.000000, -0.165283, 0.000000, 1.000000}, 
{0.665507, 0.000000, 0.090704, 0.000000, 0.665029, 0.000000, -0.162966, 0.000000, 1.000000}, 
{0.693704, 0.000000, 0.091388, 0.000000, 0.693083, 0.000000, -0.160131, 0.000000, 1.000000}, 
{0.721396, 0.000000, 0.091783, 0.000000, 0.720608, 0.000000, -0.156957, 0.000000, 1.000000}, 
{0.748676, 0.000000, 0.091688, 0.000000, 0.747853, 0.000000, -0.153292, 0.000000, 1.000000}, 
{0.775370, 0.000000, 0.090992, 0.000000, 0.774530, 0.000000, -0.149158, 0.000000, 1.000000}, 
{0.801547, 0.000000, 0.089881, 0.000000, 0.800415, 0.000000, -0.144551, 0.000000, 1.000000}, 
{0.827013, 0.000000, 0.088267, 0.000000, 0.825830, 0.000000, -0.139614, 0.000000, 1.000000}, 
{0.851708, 0.000000, 0.086132, 0.000000, 0.850121, 0.000000, -0.134026, 0.000000, 1.000000}, 
{0.875652, 0.000000, 0.083707, 0.000000, 0.873860, 0.000000, -0.128101, 0.000000, 1.000000}, 
{0.898703, 0.000000, 0.080619, 0.000000, 0.896465, 0.000000, -0.121841, 0.000000, 1.000000}, 
{0.920904, 0.000000, 0.077280, 0.000000, 0.918220, 0.000000, -0.115379, 0.000000, 1.000000}, 
{0.942077, 0.000000, 0.073484, 0.000000, 0.938987, 0.000000, -0.108355, 0.000000, 1.000000}, 
{0.962245, 0.000000, 0.069252, 0.000000, 0.958805, 0.000000, -0.101153, 0.000000, 1.000000}, 
{0.981385, 0.000000, 0.064807, 0.000000, 0.977568, 0.000000, -0.093666, 0.000000, 1.000000}, 
{0.999379, 0.000000, 0.060080, 0.000000, 0.995296, 0.000000, -0.086007, 0.000000, 1.000000}, 
{1.016494, 0.000000, 0.055007, 0.000000, 1.012100, 0.000000, -0.078194, 0.000000, 1.000000}, 
{1.032357, 0.000000, 0.049760, 0.000000, 1.027818, 0.000000, -0.070328, 0.000000, 1.000000}, 
{1.047061, 0.000000, 0.044468, 0.000000, 1.042670, 0.000000, -0.062358, 0.000000, 1.000000}, 
{1.060675, 0.000000, 0.038960, 0.000000, 1.056386, 0.000000, -0.054279, 0.000000, 1.000000}, 
{1.073032, 0.000000, 0.033343, 0.000000, 1.069320, 0.000000, -0.046158, 0.000000, 1.000000}, 
{1.084293, 0.000000, 0.027699, 0.000000, 1.081250, 0.000000, -0.038111, 0.000000, 1.000000}, 
{1.094724, 0.000000, 0.022130, 0.000000, 1.092396, 0.000000, -0.030239, 0.000000, 1.000000}, 
{1.104302, 0.000000, 0.016508, 0.000000, 1.102670, 0.000000, -0.022397, 0.000000, 1.000000}, 
{1.113290, 0.000000, 0.010846, 0.000000, 1.112245, 0.000000, -0.014747, 0.000000, 1.000000}, 
{1.121649, 0.000000, 0.005294, 0.000000, 1.121138, 0.000000, -0.007234, 0.000000, 1.000000}, 
{1.129230, 0.000000, -0.000071, 0.000000, 1.129258, 0.000000, 0.000053, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000040, 0.000000, 0.000200, 0.000000, -0.202155, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000102, 0.000000, 0.000504, 0.000000, -0.202154, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000407, 0.000000, 0.002015, 0.000000, -0.202152, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.000917, 0.000000, 0.004535, 0.000000, -0.202154, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.001630, 0.000000, 0.008063, 0.000000, -0.202153, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.002547, 0.000000, 0.012598, 0.000000, -0.202153, 0.000000, 1.000000}, 
{0.018140, 0.000000, 0.003667, 0.000000, 0.018141, 0.000000, -0.202153, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.004991, 0.000000, 0.024692, 0.000000, -0.202153, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.006519, 0.000000, 0.032252, 0.000000, -0.202153, 0.000000, 1.000000}, 
{0.040822, 0.000000, 0.008252, 0.000000, 0.040822, 0.000000, -0.202153, 0.000000, 1.000000}, 
{0.050397, 0.000000, 0.010187, 0.000000, 0.050404, 0.000000, -0.202151, 0.000000, 1.000000}, 
{0.060988, 0.000000, 0.012327, 0.000000, 0.060992, 0.000000, -0.202152, 0.000000, 1.000000}, 
{0.072582, 0.000000, 0.014669, 0.000000, 0.072597, 0.000000, -0.202149, 0.000000, 1.000000}, 
{0.085198, 0.000000, 0.017217, 0.000000, 0.085209, 0.000000, -0.202147, 0.000000, 1.000000}, 
{0.098827, 0.000000, 0.019968, 0.000000, 0.098836, 0.000000, -0.202141, 0.000000, 1.000000}, 
{0.113467, 0.000000, 0.022921, 0.000000, 0.113489, 0.000000, -0.202142, 0.000000, 1.000000}, 
{0.129129, 0.000000, 0.026074, 0.000000, 0.129155, 0.000000, -0.202137, 0.000000, 1.000000}, 
{0.145793, 0.000000, 0.029399, 0.000000, 0.145820, 0.000000, -0.202127, 0.000000, 1.000000}, 
{0.163294, 0.000000, 0.032524, 0.000000, 0.163261, 0.000000, -0.202078, 0.000000, 1.000000}, 
{0.181589, 0.000000, 0.035552, 0.000000, 0.181455, 0.000000, -0.201996, 0.000000, 1.000000}, 
{0.200844, 0.000000, 0.039208, 0.000000, 0.200690, 0.000000, -0.201948, 0.000000, 1.000000}, 
{0.220835, 0.000000, 0.043489, 0.000000, 0.220776, 0.000000, -0.201945, 0.000000, 1.000000}, 
{0.241471, 0.000000, 0.048523, 0.000000, 0.241628, 0.000000, -0.202031, 0.000000, 1.000000}, 
{0.263854, 0.000000, 0.052764, 0.000000, 0.264014, 0.000000, -0.201957, 0.000000, 1.000000}, 
{0.286935, 0.000000, 0.056387, 0.000000, 0.286976, 0.000000, -0.201743, 0.000000, 1.000000}, 
{0.310902, 0.000000, 0.060338, 0.000000, 0.310860, 0.000000, -0.201531, 0.000000, 1.000000}, 
{0.335642, 0.000000, 0.064594, 0.000000, 0.335572, 0.000000, -0.201286, 0.000000, 1.000000}, 
{0.360859, 0.000000, 0.068772, 0.000000, 0.360762, 0.000000, -0.200983, 0.000000, 1.000000}, 
{0.386419, 0.000000, 0.073086, 0.000000, 0.386341, 0.000000, -0.200651, 0.000000, 1.000000}, 
{0.412588, 0.000000, 0.077887, 0.000000, 0.412626, 0.000000, -0.200343, 0.000000, 1.000000}, 
{0.439836, 0.000000, 0.081391, 0.000000, 0.439733, 0.000000, -0.199618, 0.000000, 1.000000}, 
{0.467538, 0.000000, 0.085121, 0.000000, 0.467357, 0.000000, -0.198839, 0.000000, 1.000000}, 
{0.495286, 0.000000, 0.088718, 0.000000, 0.495073, 0.000000, -0.197895, 0.000000, 1.000000}, 
{0.523231, 0.000000, 0.092514, 0.000000, 0.523075, 0.000000, -0.196887, 0.000000, 1.000000}, 
{0.551730, 0.000000, 0.095238, 0.000000, 0.551517, 0.000000, -0.195390, 0.000000, 1.000000}, 
{0.580302, 0.000000, 0.097949, 0.000000, 0.580054, 0.000000, -0.193668, 0.000000, 1.000000}, 
{0.608559, 0.000000, 0.100418, 0.000000, 0.608372, 0.000000, -0.191773, 0.000000, 1.000000}, 
{0.637224, 0.000000, 0.102129, 0.000000, 0.636918, 0.000000, -0.189319, 0.000000, 1.000000}, 
{0.665597, 0.000000, 0.103578, 0.000000, 0.665284, 0.000000, -0.186529, 0.000000, 1.000000}, 
{0.693535, 0.000000, 0.104652, 0.000000, 0.693128, 0.000000, -0.183303, 0.000000, 1.000000}, 
{0.721325, 0.000000, 0.104766, 0.000000, 0.720945, 0.000000, -0.179497, 0.000000, 1.000000}, 
{0.748384, 0.000000, 0.104717, 0.000000, 0.747945, 0.000000, -0.175283, 0.000000, 1.000000}, 
{0.775058, 0.000000, 0.103846, 0.000000, 0.774648, 0.000000, -0.170493, 0.000000, 1.000000}, 
{0.801387, 0.000000, 0.102728, 0.000000, 0.800555, 0.000000, -0.165187, 0.000000, 1.000000}, 
{0.826412, 0.000000, 0.100679, 0.000000, 0.826012, 0.000000, -0.159362, 0.000000, 1.000000}, 
{0.851314, 0.000000, 0.098451, 0.000000, 0.850363, 0.000000, -0.153059, 0.000000, 1.000000}, 
{0.875100, 0.000000, 0.095363, 0.000000, 0.873926, 0.000000, -0.146284, 0.000000, 1.000000}, 
{0.898280, 0.000000, 0.092008, 0.000000, 0.896586, 0.000000, -0.138975, 0.000000, 1.000000}, 
{0.920450, 0.000000, 0.088095, 0.000000, 0.918357, 0.000000, -0.131361, 0.000000, 1.000000}, 
{0.941727, 0.000000, 0.083690, 0.000000, 0.939322, 0.000000, -0.123417, 0.000000, 1.000000}, 
{0.962308, 0.000000, 0.079077, 0.000000, 0.958953, 0.000000, -0.115201, 0.000000, 1.000000}, 
{0.981364, 0.000000, 0.073894, 0.000000, 0.977673, 0.000000, -0.106711, 0.000000, 1.000000}, 
{0.999798, 0.000000, 0.068435, 0.000000, 0.995537, 0.000000, -0.098063, 0.000000, 1.000000}, 
{1.016983, 0.000000, 0.062830, 0.000000, 1.012267, 0.000000, -0.089183, 0.000000, 1.000000}, 
{1.033039, 0.000000, 0.056914, 0.000000, 1.028050, 0.000000, -0.080190, 0.000000, 1.000000}, 
{1.047994, 0.000000, 0.050721, 0.000000, 1.042759, 0.000000, -0.071010, 0.000000, 1.000000}, 
{1.061580, 0.000000, 0.044454, 0.000000, 1.056527, 0.000000, -0.061867, 0.000000, 1.000000}, 
{1.074023, 0.000000, 0.038145, 0.000000, 1.069473, 0.000000, -0.052711, 0.000000, 1.000000}, 
{1.085470, 0.000000, 0.031679, 0.000000, 1.081562, 0.000000, -0.043595, 0.000000, 1.000000}, 
{1.095673, 0.000000, 0.025157, 0.000000, 1.092578, 0.000000, -0.034506, 0.000000, 1.000000}, 
{1.105000, 0.000000, 0.018702, 0.000000, 1.102906, 0.000000, -0.025468, 0.000000, 1.000000}, 
{1.113795, 0.000000, 0.012458, 0.000000, 1.112583, 0.000000, -0.016834, 0.000000, 1.000000}, 
{1.122012, 0.000000, 0.006169, 0.000000, 1.121448, 0.000000, -0.008265, 0.000000, 1.000000}, 
{1.129683, 0.000000, -0.000078, 0.000000, 1.129696, 0.000000, 0.000072, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000046, 0.000000, 0.000200, 0.000000, -0.228243, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000115, 0.000000, 0.000504, 0.000000, -0.228243, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000460, 0.000000, 0.002016, 0.000000, -0.228241, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001035, 0.000000, 0.004535, 0.000000, -0.228242, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.001840, 0.000000, 0.008063, 0.000000, -0.228242, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.002875, 0.000000, 0.012598, 0.000000, -0.228242, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.004140, 0.000000, 0.018141, 0.000000, -0.228242, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.005636, 0.000000, 0.024692, 0.000000, -0.228239, 0.000000, 1.000000}, 
{0.032251, 0.000000, 0.007361, 0.000000, 0.032253, 0.000000, -0.228243, 0.000000, 1.000000}, 
{0.040820, 0.000000, 0.009316, 0.000000, 0.040822, 0.000000, -0.228241, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.011501, 0.000000, 0.050401, 0.000000, -0.228239, 0.000000, 1.000000}, 
{0.060990, 0.000000, 0.013917, 0.000000, 0.060992, 0.000000, -0.228238, 0.000000, 1.000000}, 
{0.072586, 0.000000, 0.016562, 0.000000, 0.072592, 0.000000, -0.228236, 0.000000, 1.000000}, 
{0.085198, 0.000000, 0.019437, 0.000000, 0.085208, 0.000000, -0.228234, 0.000000, 1.000000}, 
{0.098824, 0.000000, 0.022542, 0.000000, 0.098841, 0.000000, -0.228229, 0.000000, 1.000000}, 
{0.113467, 0.000000, 0.025875, 0.000000, 0.113489, 0.000000, -0.228227, 0.000000, 1.000000}, 
{0.129121, 0.000000, 0.029430, 0.000000, 0.129157, 0.000000, -0.228219, 0.000000, 1.000000}, 
{0.145780, 0.000000, 0.033170, 0.000000, 0.145815, 0.000000, -0.228205, 0.000000, 1.000000}, 
{0.163222, 0.000000, 0.036567, 0.000000, 0.163153, 0.000000, -0.228143, 0.000000, 1.000000}, 
{0.181604, 0.000000, 0.040245, 0.000000, 0.181459, 0.000000, -0.228069, 0.000000, 1.000000}, 
{0.200913, 0.000000, 0.044395, 0.000000, 0.200751, 0.000000, -0.228010, 0.000000, 1.000000}, 
{0.221005, 0.000000, 0.049088, 0.000000, 0.220916, 0.000000, -0.227988, 0.000000, 1.000000}, 
{0.241667, 0.000000, 0.054506, 0.000000, 0.241794, 0.000000, -0.228044, 0.000000, 1.000000}, 
{0.263777, 0.000000, 0.059437, 0.000000, 0.263960, 0.000000, -0.227986, 0.000000, 1.000000}, 
{0.286841, 0.000000, 0.063590, 0.000000, 0.286890, 0.000000, -0.227755, 0.000000, 1.000000}, 
{0.310879, 0.000000, 0.068224, 0.000000, 0.310856, 0.000000, -0.227525, 0.000000, 1.000000}, 
{0.335650, 0.000000, 0.072986, 0.000000, 0.335592, 0.000000, -0.227253, 0.000000, 1.000000}, 
{0.360869, 0.000000, 0.077435, 0.000000, 0.360716, 0.000000, -0.226845, 0.000000, 1.000000}, 
{0.386609, 0.000000, 0.082385, 0.000000, 0.386488, 0.000000, -0.226466, 0.000000, 1.000000}, 
{0.412742, 0.000000, 0.087570, 0.000000, 0.412732, 0.000000, -0.226059, 0.000000, 1.000000}, 
{0.439789, 0.000000, 0.091929, 0.000000, 0.439702, 0.000000, -0.225331, 0.000000, 1.000000}, 
{0.467558, 0.000000, 0.096038, 0.000000, 0.467411, 0.000000, -0.224409, 0.000000, 1.000000}, 
{0.495406, 0.000000, 0.099938, 0.000000, 0.495199, 0.000000, -0.223288, 0.000000, 1.000000}, 
{0.523417, 0.000000, 0.104050, 0.000000, 0.523233, 0.000000, -0.222066, 0.000000, 1.000000}, 
{0.551755, 0.000000, 0.107503, 0.000000, 0.551518, 0.000000, -0.220487, 0.000000, 1.000000}, 
{0.580468, 0.000000, 0.110234, 0.000000, 0.580172, 0.000000, -0.218451, 0.000000, 1.000000}, 
{0.608904, 0.000000, 0.112993, 0.000000, 0.608661, 0.000000, -0.216200, 0.000000, 1.000000}, 
{0.637230, 0.000000, 0.115173, 0.000000, 0.637013, 0.000000, -0.213458, 0.000000, 1.000000}, 
{0.665566, 0.000000, 0.116433, 0.000000, 0.665440, 0.000000, -0.210158, 0.000000, 1.000000}, 
{0.693413, 0.000000, 0.117589, 0.000000, 0.693333, 0.000000, -0.206457, 0.000000, 1.000000}, 
{0.721025, 0.000000, 0.117885, 0.000000, 0.721010, 0.000000, -0.202197, 0.000000, 1.000000}, 
{0.748054, 0.000000, 0.117606, 0.000000, 0.748247, 0.000000, -0.197296, 0.000000, 1.000000}, 
{0.774631, 0.000000, 0.116771, 0.000000, 0.774862, 0.000000, -0.191813, 0.000000, 1.000000}, 
{0.800677, 0.000000, 0.115194, 0.000000, 0.800962, 0.000000, -0.185691, 0.000000, 1.000000}, 
{0.826062, 0.000000, 0.113138, 0.000000, 0.826103, 0.000000, -0.179053, 0.000000, 1.000000}, 
{0.850590, 0.000000, 0.110359, 0.000000, 0.850691, 0.000000, -0.171839, 0.000000, 1.000000}, 
{0.874550, 0.000000, 0.107072, 0.000000, 0.874298, 0.000000, -0.164067, 0.000000, 1.000000}, 
{0.897567, 0.000000, 0.103268, 0.000000, 0.896833, 0.000000, -0.155959, 0.000000, 1.000000}, 
{0.919609, 0.000000, 0.098794, 0.000000, 0.918651, 0.000000, -0.147320, 0.000000, 1.000000}, 
{0.941177, 0.000000, 0.094067, 0.000000, 0.939277, 0.000000, -0.138365, 0.000000, 1.000000}, 
{0.961752, 0.000000, 0.088670, 0.000000, 0.959176, 0.000000, -0.129051, 0.000000, 1.000000}, 
{0.981518, 0.000000, 0.082965, 0.000000, 0.977931, 0.000000, -0.119515, 0.000000, 1.000000}, 
{0.999880, 0.000000, 0.076971, 0.000000, 0.995602, 0.000000, -0.109897, 0.000000, 1.000000}, 
{1.017370, 0.000000, 0.070518, 0.000000, 1.012372, 0.000000, -0.099872, 0.000000, 1.000000}, 
{1.033661, 0.000000, 0.063830, 0.000000, 1.028147, 0.000000, -0.089883, 0.000000, 1.000000}, 
{1.048672, 0.000000, 0.057040, 0.000000, 1.042994, 0.000000, -0.079691, 0.000000, 1.000000}, 
{1.062479, 0.000000, 0.049917, 0.000000, 1.056784, 0.000000, -0.069458, 0.000000, 1.000000}, 
{1.075052, 0.000000, 0.042735, 0.000000, 1.069635, 0.000000, -0.059191, 0.000000, 1.000000}, 
{1.086371, 0.000000, 0.035513, 0.000000, 1.081627, 0.000000, -0.048894, 0.000000, 1.000000}, 
{1.096623, 0.000000, 0.028359, 0.000000, 1.092840, 0.000000, -0.038770, 0.000000, 1.000000}, 
{1.105871, 0.000000, 0.021111, 0.000000, 1.103249, 0.000000, -0.028745, 0.000000, 1.000000}, 
{1.114481, 0.000000, 0.013908, 0.000000, 1.112821, 0.000000, -0.018884, 0.000000, 1.000000}, 
{1.122610, 0.000000, 0.006843, 0.000000, 1.121843, 0.000000, -0.009264, 0.000000, 1.000000}, 
{1.130165, 0.000000, -0.000062, 0.000000, 1.130184, 0.000000, 0.000006, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000051, 0.000000, 0.000200, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000128, 0.000000, 0.000504, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000513, 0.000000, 0.002016, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001155, 0.000000, 0.004535, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.002053, 0.000000, 0.008062, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.003208, 0.000000, 0.012598, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.018140, 0.000000, 0.004619, 0.000000, 0.018144, 0.000000, -0.254631, 0.000000, 1.000000}, 
{0.024695, 0.000000, 0.006288, 0.000000, 0.024692, 0.000000, -0.254632, 0.000000, 1.000000}, 
{0.032251, 0.000000, 0.008211, 0.000000, 0.032252, 0.000000, -0.254630, 0.000000, 1.000000}, 
{0.040821, 0.000000, 0.010393, 0.000000, 0.040822, 0.000000, -0.254628, 0.000000, 1.000000}, 
{0.050398, 0.000000, 0.012830, 0.000000, 0.050401, 0.000000, -0.254627, 0.000000, 1.000000}, 
{0.060987, 0.000000, 0.015525, 0.000000, 0.060992, 0.000000, -0.254625, 0.000000, 1.000000}, 
{0.072584, 0.000000, 0.018474, 0.000000, 0.072597, 0.000000, -0.254621, 0.000000, 1.000000}, 
{0.085199, 0.000000, 0.021682, 0.000000, 0.085209, 0.000000, -0.254619, 0.000000, 1.000000}, 
{0.098826, 0.000000, 0.025144, 0.000000, 0.098840, 0.000000, -0.254613, 0.000000, 1.000000}, 
{0.113465, 0.000000, 0.028860, 0.000000, 0.113491, 0.000000, -0.254606, 0.000000, 1.000000}, 
{0.129119, 0.000000, 0.032823, 0.000000, 0.129156, 0.000000, -0.254598, 0.000000, 1.000000}, 
{0.145767, 0.000000, 0.036969, 0.000000, 0.145797, 0.000000, -0.254579, 0.000000, 1.000000}, 
{0.163190, 0.000000, 0.040754, 0.000000, 0.163102, 0.000000, -0.254506, 0.000000, 1.000000}, 
{0.181622, 0.000000, 0.044989, 0.000000, 0.181464, 0.000000, -0.254437, 0.000000, 1.000000}, 
{0.200981, 0.000000, 0.049642, 0.000000, 0.200808, 0.000000, -0.254370, 0.000000, 1.000000}, 
{0.221145, 0.000000, 0.054776, 0.000000, 0.221030, 0.000000, -0.254324, 0.000000, 1.000000}, 
{0.241896, 0.000000, 0.060538, 0.000000, 0.241979, 0.000000, -0.254346, 0.000000, 1.000000}, 
{0.263684, 0.000000, 0.066113, 0.000000, 0.263869, 0.000000, -0.254296, 0.000000, 1.000000}, 
{0.286796, 0.000000, 0.070925, 0.000000, 0.286851, 0.000000, -0.254059, 0.000000, 1.000000}, 
{0.310867, 0.000000, 0.076187, 0.000000, 0.310864, 0.000000, -0.253817, 0.000000, 1.000000}, 
{0.335644, 0.000000, 0.081406, 0.000000, 0.335573, 0.000000, -0.253481, 0.000000, 1.000000}, 
{0.360917, 0.000000, 0.086336, 0.000000, 0.360732, 0.000000, -0.253005, 0.000000, 1.000000}, 
{0.386786, 0.000000, 0.091790, 0.000000, 0.386597, 0.000000, -0.252558, 0.000000, 1.000000}, 
{0.412921, 0.000000, 0.097230, 0.000000, 0.412832, 0.000000, -0.252008, 0.000000, 1.000000}, 
{0.439722, 0.000000, 0.102574, 0.000000, 0.439689, 0.000000, -0.251323, 0.000000, 1.000000}, 
{0.467559, 0.000000, 0.106972, 0.000000, 0.467369, 0.000000, -0.250239, 0.000000, 1.000000}, 
{0.495605, 0.000000, 0.111329, 0.000000, 0.495281, 0.000000, -0.248944, 0.000000, 1.000000}, 
{0.523589, 0.000000, 0.115561, 0.000000, 0.523350, 0.000000, -0.247471, 0.000000, 1.000000}, 
{0.551787, 0.000000, 0.119732, 0.000000, 0.551570, 0.000000, -0.245777, 0.000000, 1.000000}, 
{0.580426, 0.000000, 0.122711, 0.000000, 0.580227, 0.000000, -0.243448, 0.000000, 1.000000}, 
{0.608778, 0.000000, 0.125436, 0.000000, 0.608759, 0.000000, -0.240769, 0.000000, 1.000000}, 
{0.637069, 0.000000, 0.127993, 0.000000, 0.637078, 0.000000, -0.237739, 0.000000, 1.000000}, 
{0.665251, 0.000000, 0.129448, 0.000000, 0.665426, 0.000000, -0.233928, 0.000000, 1.000000}, 
{0.692977, 0.000000, 0.130408, 0.000000, 0.693599, 0.000000, -0.229640, 0.000000, 1.000000}, 
{0.720346, 0.000000, 0.130931, 0.000000, 0.721158, 0.000000, -0.224829, 0.000000, 1.000000}, 
{0.747365, 0.000000, 0.130392, 0.000000, 0.748489, 0.000000, -0.219144, 0.000000, 1.000000}, 
{0.773734, 0.000000, 0.129540, 0.000000, 0.775183, 0.000000, -0.212965, 0.000000, 1.000000}, 
{0.799578, 0.000000, 0.127689, 0.000000, 0.801231, 0.000000, -0.206047, 0.000000, 1.000000}, 
{0.825002, 0.000000, 0.125456, 0.000000, 0.826322, 0.000000, -0.198576, 0.000000, 1.000000}, 
{0.849564, 0.000000, 0.122291, 0.000000, 0.850904, 0.000000, -0.190471, 0.000000, 1.000000}, 
{0.873412, 0.000000, 0.118720, 0.000000, 0.874305, 0.000000, -0.181739, 0.000000, 1.000000}, 
{0.896628, 0.000000, 0.114323, 0.000000, 0.897176, 0.000000, -0.172586, 0.000000, 1.000000}, 
{0.918952, 0.000000, 0.109587, 0.000000, 0.918730, 0.000000, -0.162914, 0.000000, 1.000000}, 
{0.940602, 0.000000, 0.104093, 0.000000, 0.939503, 0.000000, -0.153039, 0.000000, 1.000000}, 
{0.960917, 0.000000, 0.098187, 0.000000, 0.959262, 0.000000, -0.142774, 0.000000, 1.000000}, 
{0.980911, 0.000000, 0.091963, 0.000000, 0.977979, 0.000000, -0.132316, 0.000000, 1.000000}, 
{0.999686, 0.000000, 0.085159, 0.000000, 0.995713, 0.000000, -0.121453, 0.000000, 1.000000}, 
{1.017538, 0.000000, 0.078139, 0.000000, 1.012508, 0.000000, -0.110527, 0.000000, 1.000000}, 
{1.033918, 0.000000, 0.070797, 0.000000, 1.028277, 0.000000, -0.099437, 0.000000, 1.000000}, 
{1.049390, 0.000000, 0.063129, 0.000000, 1.043097, 0.000000, -0.088157, 0.000000, 1.000000}, 
{1.063402, 0.000000, 0.055354, 0.000000, 1.056974, 0.000000, -0.076951, 0.000000, 1.000000}, 
{1.076096, 0.000000, 0.047522, 0.000000, 1.069828, 0.000000, -0.065616, 0.000000, 1.000000}, 
{1.087562, 0.000000, 0.039447, 0.000000, 1.081912, 0.000000, -0.054310, 0.000000, 1.000000}, 
{1.097591, 0.000000, 0.031359, 0.000000, 1.093094, 0.000000, -0.042948, 0.000000, 1.000000}, 
{1.106782, 0.000000, 0.023393, 0.000000, 1.103432, 0.000000, -0.031799, 0.000000, 1.000000}, 
{1.115234, 0.000000, 0.015461, 0.000000, 1.113202, 0.000000, -0.020943, 0.000000, 1.000000}, 
{1.123166, 0.000000, 0.007589, 0.000000, 1.122281, 0.000000, -0.010288, 0.000000, 1.000000}, 
{1.130796, 0.000000, -0.000104, 0.000000, 1.130760, 0.000000, 0.000024, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000056, 0.000000, 0.000200, 0.000000, -0.281356, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000142, 0.000000, 0.000504, 0.000000, -0.281355, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.000567, 0.000000, 0.002016, 0.000000, -0.281355, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001276, 0.000000, 0.004535, 0.000000, -0.281356, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.002269, 0.000000, 0.008063, 0.000000, -0.281355, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.003544, 0.000000, 0.012598, 0.000000, -0.281355, 0.000000, 1.000000}, 
{0.018143, 0.000000, 0.005104, 0.000000, 0.018140, 0.000000, -0.281355, 0.000000, 1.000000}, 
{0.024691, 0.000000, 0.006947, 0.000000, 0.024693, 0.000000, -0.281353, 0.000000, 1.000000}, 
{0.032254, 0.000000, 0.009074, 0.000000, 0.032251, 0.000000, -0.281354, 0.000000, 1.000000}, 
{0.040822, 0.000000, 0.011484, 0.000000, 0.040821, 0.000000, -0.281353, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.014177, 0.000000, 0.050403, 0.000000, -0.281349, 0.000000, 1.000000}, 
{0.060987, 0.000000, 0.017153, 0.000000, 0.060994, 0.000000, -0.281347, 0.000000, 1.000000}, 
{0.072586, 0.000000, 0.020412, 0.000000, 0.072594, 0.000000, -0.281343, 0.000000, 1.000000}, 
{0.085203, 0.000000, 0.023956, 0.000000, 0.085214, 0.000000, -0.281336, 0.000000, 1.000000}, 
{0.098823, 0.000000, 0.027778, 0.000000, 0.098845, 0.000000, -0.281332, 0.000000, 1.000000}, 
{0.113464, 0.000000, 0.031882, 0.000000, 0.113492, 0.000000, -0.281325, 0.000000, 1.000000}, 
{0.129114, 0.000000, 0.036255, 0.000000, 0.129157, 0.000000, -0.281315, 0.000000, 1.000000}, 
{0.145748, 0.000000, 0.040790, 0.000000, 0.145772, 0.000000, -0.281287, 0.000000, 1.000000}, 
{0.163179, 0.000000, 0.045024, 0.000000, 0.163070, 0.000000, -0.281208, 0.000000, 1.000000}, 
{0.181649, 0.000000, 0.049791, 0.000000, 0.181468, 0.000000, -0.281137, 0.000000, 1.000000}, 
{0.201042, 0.000000, 0.054953, 0.000000, 0.200852, 0.000000, -0.281063, 0.000000, 1.000000}, 
{0.221267, 0.000000, 0.060551, 0.000000, 0.221128, 0.000000, -0.281006, 0.000000, 1.000000}, 
{0.242114, 0.000000, 0.066663, 0.000000, 0.242138, 0.000000, -0.280978, 0.000000, 1.000000}, 
{0.263568, 0.000000, 0.072771, 0.000000, 0.263731, 0.000000, -0.280925, 0.000000, 1.000000}, 
{0.286744, 0.000000, 0.078349, 0.000000, 0.286821, 0.000000, -0.280689, 0.000000, 1.000000}, 
{0.310840, 0.000000, 0.084201, 0.000000, 0.310858, 0.000000, -0.280418, 0.000000, 1.000000}, 
{0.335612, 0.000000, 0.089846, 0.000000, 0.335511, 0.000000, -0.280020, 0.000000, 1.000000}, 
{0.360975, 0.000000, 0.095394, 0.000000, 0.360768, 0.000000, -0.279513, 0.000000, 1.000000}, 
{0.386932, 0.000000, 0.101290, 0.000000, 0.386719, 0.000000, -0.278961, 0.000000, 1.000000}, 
{0.413171, 0.000000, 0.107042, 0.000000, 0.412931, 0.000000, -0.278283, 0.000000, 1.000000}, 
{0.439886, 0.000000, 0.113083, 0.000000, 0.439743, 0.000000, -0.277547, 0.000000, 1.000000}, 
{0.467535, 0.000000, 0.118010, 0.000000, 0.467330, 0.000000, -0.276311, 0.000000, 1.000000}, 
{0.495701, 0.000000, 0.122793, 0.000000, 0.495345, 0.000000, -0.274867, 0.000000, 1.000000}, 
{0.523772, 0.000000, 0.127278, 0.000000, 0.523448, 0.000000, -0.273153, 0.000000, 1.000000}, 
{0.551849, 0.000000, 0.131671, 0.000000, 0.551735, 0.000000, -0.271176, 0.000000, 1.000000}, 
{0.580338, 0.000000, 0.135293, 0.000000, 0.580270, 0.000000, -0.268626, 0.000000, 1.000000}, 
{0.608771, 0.000000, 0.138065, 0.000000, 0.608935, 0.000000, -0.265569, 0.000000, 1.000000}, 
{0.636756, 0.000000, 0.140565, 0.000000, 0.637357, 0.000000, -0.262054, 0.000000, 1.000000}, 
{0.664574, 0.000000, 0.142434, 0.000000, 0.665705, 0.000000, -0.257807, 0.000000, 1.000000}, 
{0.692151, 0.000000, 0.143237, 0.000000, 0.693755, 0.000000, -0.252930, 0.000000, 1.000000}, 
{0.719376, 0.000000, 0.143717, 0.000000, 0.721440, 0.000000, -0.247414, 0.000000, 1.000000}, 
{0.745852, 0.000000, 0.143117, 0.000000, 0.748619, 0.000000, -0.241001, 0.000000, 1.000000}, 
{0.772300, 0.000000, 0.141975, 0.000000, 0.775416, 0.000000, -0.233797, 0.000000, 1.000000}, 
{0.798050, 0.000000, 0.140114, 0.000000, 0.801463, 0.000000, -0.226218, 0.000000, 1.000000}, 
{0.823370, 0.000000, 0.137379, 0.000000, 0.826531, 0.000000, -0.217785, 0.000000, 1.000000}, 
{0.847735, 0.000000, 0.134119, 0.000000, 0.851173, 0.000000, -0.208748, 0.000000, 1.000000}, 
{0.871897, 0.000000, 0.129985, 0.000000, 0.874661, 0.000000, -0.198877, 0.000000, 1.000000}, 
{0.894950, 0.000000, 0.125324, 0.000000, 0.897268, 0.000000, -0.188803, 0.000000, 1.000000}, 
{0.917909, 0.000000, 0.120007, 0.000000, 0.919043, 0.000000, -0.178493, 0.000000, 1.000000}, 
{0.939567, 0.000000, 0.114099, 0.000000, 0.939787, 0.000000, -0.167466, 0.000000, 1.000000}, 
{0.960534, 0.000000, 0.107748, 0.000000, 0.959283, 0.000000, -0.156223, 0.000000, 1.000000}, 
{0.980423, 0.000000, 0.100748, 0.000000, 0.978022, 0.000000, -0.144716, 0.000000, 1.000000}, 
{0.999334, 0.000000, 0.093494, 0.000000, 0.995876, 0.000000, -0.133028, 0.000000, 1.000000}, 
{1.017561, 0.000000, 0.085728, 0.000000, 1.012680, 0.000000, -0.120953, 0.000000, 1.000000}, 
{1.034225, 0.000000, 0.077627, 0.000000, 1.028399, 0.000000, -0.108943, 0.000000, 1.000000}, 
{1.049937, 0.000000, 0.069375, 0.000000, 1.043189, 0.000000, -0.096678, 0.000000, 1.000000}, 
{1.064265, 0.000000, 0.060807, 0.000000, 1.057095, 0.000000, -0.084350, 0.000000, 1.000000}, 
{1.077188, 0.000000, 0.052052, 0.000000, 1.070131, 0.000000, -0.071964, 0.000000, 1.000000}, 
{1.088637, 0.000000, 0.043304, 0.000000, 1.082126, 0.000000, -0.059531, 0.000000, 1.000000}, 
{1.098766, 0.000000, 0.034458, 0.000000, 1.093396, 0.000000, -0.047134, 0.000000, 1.000000}, 
{1.107697, 0.000000, 0.025637, 0.000000, 1.103785, 0.000000, -0.034887, 0.000000, 1.000000}, 
{1.116055, 0.000000, 0.016932, 0.000000, 1.113536, 0.000000, -0.022948, 0.000000, 1.000000}, 
{1.123819, 0.000000, 0.008437, 0.000000, 1.122766, 0.000000, -0.011386, 0.000000, 1.000000}, 
{1.131333, 0.000000, -0.000087, 0.000000, 1.131387, 0.000000, 0.000097, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000062, 0.000000, 0.000200, 0.000000, -0.308458, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000155, 0.000000, 0.000504, 0.000000, -0.308458, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000622, 0.000000, 0.002016, 0.000000, -0.308458, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001399, 0.000000, 0.004535, 0.000000, -0.308458, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.002487, 0.000000, 0.008061, 0.000000, -0.308455, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.003886, 0.000000, 0.012598, 0.000000, -0.308458, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.005596, 0.000000, 0.018141, 0.000000, -0.308457, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.007616, 0.000000, 0.024692, 0.000000, -0.308457, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.009947, 0.000000, 0.032253, 0.000000, -0.308456, 0.000000, 1.000000}, 
{0.040822, 0.000000, 0.012589, 0.000000, 0.040823, 0.000000, -0.308453, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.015541, 0.000000, 0.050401, 0.000000, -0.308451, 0.000000, 1.000000}, 
{0.060985, 0.000000, 0.018803, 0.000000, 0.060995, 0.000000, -0.308448, 0.000000, 1.000000}, 
{0.072583, 0.000000, 0.022375, 0.000000, 0.072595, 0.000000, -0.308444, 0.000000, 1.000000}, 
{0.085197, 0.000000, 0.026258, 0.000000, 0.085211, 0.000000, -0.308438, 0.000000, 1.000000}, 
{0.098822, 0.000000, 0.030448, 0.000000, 0.098845, 0.000000, -0.308429, 0.000000, 1.000000}, 
{0.113460, 0.000000, 0.034944, 0.000000, 0.113496, 0.000000, -0.308419, 0.000000, 1.000000}, 
{0.129112, 0.000000, 0.039731, 0.000000, 0.129156, 0.000000, -0.308403, 0.000000, 1.000000}, 
{0.145711, 0.000000, 0.044610, 0.000000, 0.145721, 0.000000, -0.308365, 0.000000, 1.000000}, 
{0.163178, 0.000000, 0.049362, 0.000000, 0.163045, 0.000000, -0.308285, 0.000000, 1.000000}, 
{0.181679, 0.000000, 0.054666, 0.000000, 0.181490, 0.000000, -0.308210, 0.000000, 1.000000}, 
{0.201109, 0.000000, 0.060336, 0.000000, 0.200896, 0.000000, -0.308132, 0.000000, 1.000000}, 
{0.221388, 0.000000, 0.066414, 0.000000, 0.221218, 0.000000, -0.308047, 0.000000, 1.000000}, 
{0.242315, 0.000000, 0.072881, 0.000000, 0.242270, 0.000000, -0.307985, 0.000000, 1.000000}, 
{0.263651, 0.000000, 0.079453, 0.000000, 0.263747, 0.000000, -0.307902, 0.000000, 1.000000}, 
{0.286720, 0.000000, 0.085882, 0.000000, 0.286798, 0.000000, -0.307688, 0.000000, 1.000000}, 
{0.310817, 0.000000, 0.092274, 0.000000, 0.310825, 0.000000, -0.307379, 0.000000, 1.000000}, 
{0.335562, 0.000000, 0.098306, 0.000000, 0.335428, 0.000000, -0.306906, 0.000000, 1.000000}, 
{0.361043, 0.000000, 0.104572, 0.000000, 0.360816, 0.000000, -0.306374, 0.000000, 1.000000}, 
{0.387051, 0.000000, 0.110843, 0.000000, 0.386735, 0.000000, -0.305710, 0.000000, 1.000000}, 
{0.413405, 0.000000, 0.117062, 0.000000, 0.413067, 0.000000, -0.304906, 0.000000, 1.000000}, 
{0.440122, 0.000000, 0.123501, 0.000000, 0.439891, 0.000000, -0.304017, 0.000000, 1.000000}, 
{0.467522, 0.000000, 0.129245, 0.000000, 0.467309, 0.000000, -0.302783, 0.000000, 1.000000}, 
{0.495721, 0.000000, 0.134285, 0.000000, 0.495392, 0.000000, -0.301104, 0.000000, 1.000000}, 
{0.523925, 0.000000, 0.139143, 0.000000, 0.523603, 0.000000, -0.299142, 0.000000, 1.000000}, 
{0.551814, 0.000000, 0.143638, 0.000000, 0.551927, 0.000000, -0.296825, 0.000000, 1.000000}, 
{0.579878, 0.000000, 0.147774, 0.000000, 0.580347, 0.000000, -0.294071, 0.000000, 1.000000}, 
{0.608316, 0.000000, 0.150724, 0.000000, 0.609090, 0.000000, -0.290519, 0.000000, 1.000000}, 
{0.636059, 0.000000, 0.153168, 0.000000, 0.637600, 0.000000, -0.286424, 0.000000, 1.000000}, 
{0.663481, 0.000000, 0.155139, 0.000000, 0.665834, 0.000000, -0.281559, 0.000000, 1.000000}, 
{0.690753, 0.000000, 0.155944, 0.000000, 0.694088, 0.000000, -0.276024, 0.000000, 1.000000}, 
{0.717767, 0.000000, 0.156176, 0.000000, 0.721847, 0.000000, -0.269622, 0.000000, 1.000000}, 
{0.743937, 0.000000, 0.155783, 0.000000, 0.749069, 0.000000, -0.262532, 0.000000, 1.000000}, 
{0.770214, 0.000000, 0.154245, 0.000000, 0.775734, 0.000000, -0.254609, 0.000000, 1.000000}, 
{0.795542, 0.000000, 0.152192, 0.000000, 0.801622, 0.000000, -0.246007, 0.000000, 1.000000}, 
{0.821099, 0.000000, 0.149256, 0.000000, 0.826693, 0.000000, -0.236663, 0.000000, 1.000000}, 
{0.845452, 0.000000, 0.145605, 0.000000, 0.850965, 0.000000, -0.226751, 0.000000, 1.000000}, 
{0.869780, 0.000000, 0.141186, 0.000000, 0.874595, 0.000000, -0.216165, 0.000000, 1.000000}, 
{0.893141, 0.000000, 0.136137, 0.000000, 0.897276, 0.000000, -0.204937, 0.000000, 1.000000}, 
{0.916034, 0.000000, 0.130332, 0.000000, 0.918859, 0.000000, -0.193624, 0.000000, 1.000000}, 
{0.938089, 0.000000, 0.124040, 0.000000, 0.939707, 0.000000, -0.181756, 0.000000, 1.000000}, 
{0.959488, 0.000000, 0.117011, 0.000000, 0.959671, 0.000000, -0.169339, 0.000000, 1.000000}, 
{0.979594, 0.000000, 0.109617, 0.000000, 0.978328, 0.000000, -0.156875, 0.000000, 1.000000}, 
{0.998912, 0.000000, 0.101562, 0.000000, 0.996101, 0.000000, -0.144288, 0.000000, 1.000000}, 
{1.017100, 0.000000, 0.093164, 0.000000, 1.012685, 0.000000, -0.131370, 0.000000, 1.000000}, 
{1.034413, 0.000000, 0.084488, 0.000000, 1.028516, 0.000000, -0.118322, 0.000000, 1.000000}, 
{1.050347, 0.000000, 0.075377, 0.000000, 1.043381, 0.000000, -0.104963, 0.000000, 1.000000}, 
{1.064958, 0.000000, 0.066108, 0.000000, 1.057218, 0.000000, -0.091722, 0.000000, 1.000000}, 
{1.078045, 0.000000, 0.056702, 0.000000, 1.070183, 0.000000, -0.078231, 0.000000, 1.000000}, 
{1.089749, 0.000000, 0.047106, 0.000000, 1.082344, 0.000000, -0.064797, 0.000000, 1.000000}, 
{1.099831, 0.000000, 0.037467, 0.000000, 1.093642, 0.000000, -0.051315, 0.000000, 1.000000}, 
{1.108789, 0.000000, 0.027990, 0.000000, 1.104174, 0.000000, -0.038064, 0.000000, 1.000000}, 
{1.116865, 0.000000, 0.018464, 0.000000, 1.114068, 0.000000, -0.025008, 0.000000, 1.000000}, 
{1.124609, 0.000000, 0.009068, 0.000000, 1.123349, 0.000000, -0.012250, 0.000000, 1.000000}, 
{1.132040, 0.000000, -0.000093, 0.000000, 1.132058, 0.000000, 0.000071, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000067, 0.000000, 0.000200, 0.000000, -0.335981, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000169, 0.000000, 0.000504, 0.000000, -0.335981, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000677, 0.000000, 0.002016, 0.000000, -0.335981, 0.000000, 1.000000}, 
{0.004533, 0.000000, 0.001523, 0.000000, 0.004536, 0.000000, -0.335982, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.002709, 0.000000, 0.008063, 0.000000, -0.335979, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.004233, 0.000000, 0.012598, 0.000000, -0.335980, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.006095, 0.000000, 0.018141, 0.000000, -0.335980, 0.000000, 1.000000}, 
{0.024693, 0.000000, 0.008296, 0.000000, 0.024693, 0.000000, -0.335978, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.010834, 0.000000, 0.032252, 0.000000, -0.335976, 0.000000, 1.000000}, 
{0.040824, 0.000000, 0.013713, 0.000000, 0.040820, 0.000000, -0.335974, 0.000000, 1.000000}, 
{0.050398, 0.000000, 0.016927, 0.000000, 0.050402, 0.000000, -0.335971, 0.000000, 1.000000}, 
{0.060991, 0.000000, 0.020482, 0.000000, 0.060991, 0.000000, -0.335970, 0.000000, 1.000000}, 
{0.072587, 0.000000, 0.024371, 0.000000, 0.072595, 0.000000, -0.335962, 0.000000, 1.000000}, 
{0.085199, 0.000000, 0.028597, 0.000000, 0.085212, 0.000000, -0.335955, 0.000000, 1.000000}, 
{0.098822, 0.000000, 0.033159, 0.000000, 0.098846, 0.000000, -0.335943, 0.000000, 1.000000}, 
{0.113461, 0.000000, 0.038052, 0.000000, 0.113495, 0.000000, -0.335930, 0.000000, 1.000000}, 
{0.129108, 0.000000, 0.043255, 0.000000, 0.129154, 0.000000, -0.335910, 0.000000, 1.000000}, 
{0.145665, 0.000000, 0.048412, 0.000000, 0.145628, 0.000000, -0.335857, 0.000000, 1.000000}, 
{0.163185, 0.000000, 0.053786, 0.000000, 0.163039, 0.000000, -0.335781, 0.000000, 1.000000}, 
{0.181710, 0.000000, 0.059608, 0.000000, 0.181510, 0.000000, -0.335696, 0.000000, 1.000000}, 
{0.201166, 0.000000, 0.065794, 0.000000, 0.200946, 0.000000, -0.335606, 0.000000, 1.000000}, 
{0.221489, 0.000000, 0.072361, 0.000000, 0.221301, 0.000000, -0.335505, 0.000000, 1.000000}, 
{0.242471, 0.000000, 0.079184, 0.000000, 0.242344, 0.000000, -0.335396, 0.000000, 1.000000}, 
{0.263900, 0.000000, 0.086213, 0.000000, 0.263887, 0.000000, -0.335271, 0.000000, 1.000000}, 
{0.286688, 0.000000, 0.093491, 0.000000, 0.286778, 0.000000, -0.335089, 0.000000, 1.000000}, 
{0.310773, 0.000000, 0.100406, 0.000000, 0.310789, 0.000000, -0.334737, 0.000000, 1.000000}, 
{0.335573, 0.000000, 0.106987, 0.000000, 0.335386, 0.000000, -0.334208, 0.000000, 1.000000}, 
{0.361117, 0.000000, 0.113844, 0.000000, 0.360814, 0.000000, -0.333600, 0.000000, 1.000000}, 
{0.387175, 0.000000, 0.120463, 0.000000, 0.386729, 0.000000, -0.332828, 0.000000, 1.000000}, 
{0.413665, 0.000000, 0.127245, 0.000000, 0.413173, 0.000000, -0.331929, 0.000000, 1.000000}, 
{0.440386, 0.000000, 0.133927, 0.000000, 0.439980, 0.000000, -0.330851, 0.000000, 1.000000}, 
{0.467527, 0.000000, 0.140496, 0.000000, 0.467300, 0.000000, -0.329538, 0.000000, 1.000000}, 
{0.495630, 0.000000, 0.145874, 0.000000, 0.495390, 0.000000, -0.327618, 0.000000, 1.000000}, 
{0.523864, 0.000000, 0.150997, 0.000000, 0.523667, 0.000000, -0.325390, 0.000000, 1.000000}, 
{0.551705, 0.000000, 0.155713, 0.000000, 0.552076, 0.000000, -0.322688, 0.000000, 1.000000}, 
{0.579383, 0.000000, 0.159993, 0.000000, 0.580564, 0.000000, -0.319483, 0.000000, 1.000000}, 
{0.607301, 0.000000, 0.163238, 0.000000, 0.609314, 0.000000, -0.315522, 0.000000, 1.000000}, 
{0.634873, 0.000000, 0.165667, 0.000000, 0.637851, 0.000000, -0.310840, 0.000000, 1.000000}, 
{0.662028, 0.000000, 0.167606, 0.000000, 0.666262, 0.000000, -0.305377, 0.000000, 1.000000}, 
{0.688755, 0.000000, 0.168626, 0.000000, 0.694329, 0.000000, -0.299056, 0.000000, 1.000000}, 
{0.715612, 0.000000, 0.168578, 0.000000, 0.722036, 0.000000, -0.291963, 0.000000, 1.000000}, 
{0.741604, 0.000000, 0.167961, 0.000000, 0.749119, 0.000000, -0.284018, 0.000000, 1.000000}, 
{0.767757, 0.000000, 0.166439, 0.000000, 0.775655, 0.000000, -0.275474, 0.000000, 1.000000}, 
{0.793264, 0.000000, 0.164023, 0.000000, 0.801368, 0.000000, -0.266056, 0.000000, 1.000000}, 
{0.818165, 0.000000, 0.160965, 0.000000, 0.826353, 0.000000, -0.255750, 0.000000, 1.000000}, 
{0.843255, 0.000000, 0.156896, 0.000000, 0.850885, 0.000000, -0.244843, 0.000000, 1.000000}, 
{0.867249, 0.000000, 0.152262, 0.000000, 0.874546, 0.000000, -0.233464, 0.000000, 1.000000}, 
{0.890994, 0.000000, 0.146655, 0.000000, 0.897081, 0.000000, -0.221128, 0.000000, 1.000000}, 
{0.913829, 0.000000, 0.140574, 0.000000, 0.918702, 0.000000, -0.208554, 0.000000, 1.000000}, 
{0.936508, 0.000000, 0.133640, 0.000000, 0.939639, 0.000000, -0.195772, 0.000000, 1.000000}, 
{0.957720, 0.000000, 0.126220, 0.000000, 0.959238, 0.000000, -0.182420, 0.000000, 1.000000}, 
{0.978940, 0.000000, 0.118164, 0.000000, 0.978066, 0.000000, -0.168852, 0.000000, 1.000000}, 
{0.998285, 0.000000, 0.109558, 0.000000, 0.995930, 0.000000, -0.155261, 0.000000, 1.000000}, 
{1.016764, 0.000000, 0.100562, 0.000000, 1.012928, 0.000000, -0.141395, 0.000000, 1.000000}, 
{1.034387, 0.000000, 0.091064, 0.000000, 1.028500, 0.000000, -0.127311, 0.000000, 1.000000}, 
{1.050916, 0.000000, 0.081468, 0.000000, 1.043491, 0.000000, -0.113089, 0.000000, 1.000000}, 
{1.065652, 0.000000, 0.071463, 0.000000, 1.057337, 0.000000, -0.098879, 0.000000, 1.000000}, 
{1.079155, 0.000000, 0.061240, 0.000000, 1.070343, 0.000000, -0.084468, 0.000000, 1.000000}, 
{1.090822, 0.000000, 0.050980, 0.000000, 1.082707, 0.000000, -0.069940, 0.000000, 1.000000}, 
{1.101100, 0.000000, 0.040549, 0.000000, 1.093982, 0.000000, -0.055475, 0.000000, 1.000000}, 
{1.109824, 0.000000, 0.030101, 0.000000, 1.104487, 0.000000, -0.041033, 0.000000, 1.000000}, 
{1.117828, 0.000000, 0.019884, 0.000000, 1.114517, 0.000000, -0.027022, 0.000000, 1.000000}, 
{1.125443, 0.000000, 0.009900, 0.000000, 1.123907, 0.000000, -0.013306, 0.000000, 1.000000}, 
{1.132869, 0.000000, -0.000094, 0.000000, 1.132864, 0.000000, 0.000046, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000073, 0.000000, 0.000200, 0.000000, -0.363970, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000183, 0.000000, 0.000504, 0.000000, -0.363969, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000734, 0.000000, 0.002016, 0.000000, -0.363969, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001651, 0.000000, 0.004536, 0.000000, -0.363969, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.002934, 0.000000, 0.008063, 0.000000, -0.363966, 0.000000, 1.000000}, 
{0.012597, 0.000000, 0.004585, 0.000000, 0.012598, 0.000000, -0.363968, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.006602, 0.000000, 0.018141, 0.000000, -0.363967, 0.000000, 1.000000}, 
{0.024693, 0.000000, 0.008987, 0.000000, 0.024692, 0.000000, -0.363967, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.011737, 0.000000, 0.032251, 0.000000, -0.363965, 0.000000, 1.000000}, 
{0.040819, 0.000000, 0.014853, 0.000000, 0.040826, 0.000000, -0.363959, 0.000000, 1.000000}, 
{0.050398, 0.000000, 0.018336, 0.000000, 0.050400, 0.000000, -0.363958, 0.000000, 1.000000}, 
{0.060988, 0.000000, 0.022185, 0.000000, 0.060989, 0.000000, -0.363954, 0.000000, 1.000000}, 
{0.072582, 0.000000, 0.026396, 0.000000, 0.072596, 0.000000, -0.363943, 0.000000, 1.000000}, 
{0.085195, 0.000000, 0.030973, 0.000000, 0.085213, 0.000000, -0.363935, 0.000000, 1.000000}, 
{0.098822, 0.000000, 0.035913, 0.000000, 0.098846, 0.000000, -0.363922, 0.000000, 1.000000}, 
{0.113461, 0.000000, 0.041209, 0.000000, 0.113498, 0.000000, -0.363905, 0.000000, 1.000000}, 
{0.129116, 0.000000, 0.046833, 0.000000, 0.129167, 0.000000, -0.363867, 0.000000, 1.000000}, 
{0.145640, 0.000000, 0.052346, 0.000000, 0.145572, 0.000000, -0.363814, 0.000000, 1.000000}, 
{0.163199, 0.000000, 0.058275, 0.000000, 0.163031, 0.000000, -0.363734, 0.000000, 1.000000}, 
{0.181742, 0.000000, 0.064623, 0.000000, 0.181522, 0.000000, -0.363642, 0.000000, 1.000000}, 
{0.201227, 0.000000, 0.071336, 0.000000, 0.200987, 0.000000, -0.363539, 0.000000, 1.000000}, 
{0.221587, 0.000000, 0.078396, 0.000000, 0.221355, 0.000000, -0.363419, 0.000000, 1.000000}, 
{0.242625, 0.000000, 0.085545, 0.000000, 0.242381, 0.000000, -0.363256, 0.000000, 1.000000}, 
{0.264183, 0.000000, 0.093110, 0.000000, 0.264048, 0.000000, -0.363097, 0.000000, 1.000000}, 
{0.286668, 0.000000, 0.101206, 0.000000, 0.286761, 0.000000, -0.362939, 0.000000, 1.000000}, 
{0.310745, 0.000000, 0.108586, 0.000000, 0.310712, 0.000000, -0.362516, 0.000000, 1.000000}, 
{0.335602, 0.000000, 0.115827, 0.000000, 0.335374, 0.000000, -0.361953, 0.000000, 1.000000}, 
{0.361202, 0.000000, 0.123212, 0.000000, 0.360812, 0.000000, -0.361275, 0.000000, 1.000000}, 
{0.387298, 0.000000, 0.130294, 0.000000, 0.386738, 0.000000, -0.360376, 0.000000, 1.000000}, 
{0.413918, 0.000000, 0.137553, 0.000000, 0.413279, 0.000000, -0.359362, 0.000000, 1.000000}, 
{0.440680, 0.000000, 0.144577, 0.000000, 0.440148, 0.000000, -0.358069, 0.000000, 1.000000}, 
{0.467667, 0.000000, 0.151558, 0.000000, 0.467481, 0.000000, -0.356581, 0.000000, 1.000000}, 
{0.495449, 0.000000, 0.157621, 0.000000, 0.495454, 0.000000, -0.354531, 0.000000, 1.000000}, 
{0.523514, 0.000000, 0.162844, 0.000000, 0.523809, 0.000000, -0.351915, 0.000000, 1.000000}, 
{0.551250, 0.000000, 0.167744, 0.000000, 0.552280, 0.000000, -0.348797, 0.000000, 1.000000}, 
{0.578629, 0.000000, 0.172132, 0.000000, 0.580717, 0.000000, -0.345222, 0.000000, 1.000000}, 
{0.605757, 0.000000, 0.175733, 0.000000, 0.609420, 0.000000, -0.340665, 0.000000, 1.000000}, 
{0.633392, 0.000000, 0.178109, 0.000000, 0.638104, 0.000000, -0.335286, 0.000000, 1.000000}, 
{0.660783, 0.000000, 0.180009, 0.000000, 0.666652, 0.000000, -0.329286, 0.000000, 1.000000}, 
{0.687219, 0.000000, 0.181105, 0.000000, 0.694596, 0.000000, -0.322319, 0.000000, 1.000000}, 
{0.713873, 0.000000, 0.181046, 0.000000, 0.722153, 0.000000, -0.314616, 0.000000, 1.000000}, 
{0.740094, 0.000000, 0.180219, 0.000000, 0.749230, 0.000000, -0.306014, 0.000000, 1.000000}, 
{0.765233, 0.000000, 0.178559, 0.000000, 0.775346, 0.000000, -0.296704, 0.000000, 1.000000}, 
{0.790885, 0.000000, 0.175806, 0.000000, 0.801384, 0.000000, -0.286394, 0.000000, 1.000000}, 
{0.815464, 0.000000, 0.172354, 0.000000, 0.826116, 0.000000, -0.275189, 0.000000, 1.000000}, 
{0.840259, 0.000000, 0.168048, 0.000000, 0.850203, 0.000000, -0.263441, 0.000000, 1.000000}, 
{0.864285, 0.000000, 0.162904, 0.000000, 0.873699, 0.000000, -0.250918, 0.000000, 1.000000}, 
{0.888806, 0.000000, 0.157194, 0.000000, 0.896115, 0.000000, -0.237611, 0.000000, 1.000000}, 
{0.911682, 0.000000, 0.150486, 0.000000, 0.918282, 0.000000, -0.223809, 0.000000, 1.000000}, 
{0.934481, 0.000000, 0.143212, 0.000000, 0.939359, 0.000000, -0.209705, 0.000000, 1.000000}, 
{0.956337, 0.000000, 0.135233, 0.000000, 0.959120, 0.000000, -0.195281, 0.000000, 1.000000}, 
{0.977380, 0.000000, 0.126650, 0.000000, 0.978050, 0.000000, -0.180878, 0.000000, 1.000000}, 
{0.997427, 0.000000, 0.117552, 0.000000, 0.995930, 0.000000, -0.166112, 0.000000, 1.000000}, 
{1.016666, 0.000000, 0.107814, 0.000000, 1.012847, 0.000000, -0.151231, 0.000000, 1.000000}, 
{1.034337, 0.000000, 0.097814, 0.000000, 1.028603, 0.000000, -0.136375, 0.000000, 1.000000}, 
{1.051082, 0.000000, 0.087330, 0.000000, 1.043430, 0.000000, -0.121187, 0.000000, 1.000000}, 
{1.066326, 0.000000, 0.076614, 0.000000, 1.057443, 0.000000, -0.106043, 0.000000, 1.000000}, 
{1.079897, 0.000000, 0.065793, 0.000000, 1.070624, 0.000000, -0.090566, 0.000000, 1.000000}, 
{1.092136, 0.000000, 0.054654, 0.000000, 1.082878, 0.000000, -0.074988, 0.000000, 1.000000}, 
{1.102315, 0.000000, 0.043516, 0.000000, 1.094372, 0.000000, -0.059577, 0.000000, 1.000000}, 
{1.111105, 0.000000, 0.032509, 0.000000, 1.105019, 0.000000, -0.044202, 0.000000, 1.000000}, 
{1.118861, 0.000000, 0.021381, 0.000000, 1.115113, 0.000000, -0.028995, 0.000000, 1.000000}, 
{1.126363, 0.000000, 0.010489, 0.000000, 1.124635, 0.000000, -0.014269, 0.000000, 1.000000}, 
{1.133598, 0.000000, -0.000083, 0.000000, 1.133611, 0.000000, 0.000035, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000079, 0.000000, 0.000200, 0.000000, -0.392470, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000198, 0.000000, 0.000504, 0.000000, -0.392469, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000791, 0.000000, 0.002016, 0.000000, -0.392469, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001780, 0.000000, 0.004535, 0.000000, -0.392469, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.003164, 0.000000, 0.008063, 0.000000, -0.392466, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.004944, 0.000000, 0.012598, 0.000000, -0.392469, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.007119, 0.000000, 0.018141, 0.000000, -0.392468, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.009690, 0.000000, 0.024692, 0.000000, -0.392466, 0.000000, 1.000000}, 
{0.032254, 0.000000, 0.012656, 0.000000, 0.032252, 0.000000, -0.392465, 0.000000, 1.000000}, 
{0.040826, 0.000000, 0.016018, 0.000000, 0.040826, 0.000000, -0.392459, 0.000000, 1.000000}, 
{0.050399, 0.000000, 0.019771, 0.000000, 0.050401, 0.000000, -0.392456, 0.000000, 1.000000}, 
{0.060987, 0.000000, 0.023919, 0.000000, 0.060990, 0.000000, -0.392447, 0.000000, 1.000000}, 
{0.072588, 0.000000, 0.028461, 0.000000, 0.072594, 0.000000, -0.392442, 0.000000, 1.000000}, 
{0.085197, 0.000000, 0.033393, 0.000000, 0.085214, 0.000000, -0.392428, 0.000000, 1.000000}, 
{0.098822, 0.000000, 0.038716, 0.000000, 0.098848, 0.000000, -0.392412, 0.000000, 1.000000}, 
{0.113462, 0.000000, 0.044422, 0.000000, 0.113497, 0.000000, -0.392390, 0.000000, 1.000000}, 
{0.129101, 0.000000, 0.050455, 0.000000, 0.129137, 0.000000, -0.392359, 0.000000, 1.000000}, 
{0.145642, 0.000000, 0.056392, 0.000000, 0.145537, 0.000000, -0.392283, 0.000000, 1.000000}, 
{0.163223, 0.000000, 0.062859, 0.000000, 0.163030, 0.000000, -0.392201, 0.000000, 1.000000}, 
{0.181779, 0.000000, 0.069721, 0.000000, 0.181534, 0.000000, -0.392099, 0.000000, 1.000000}, 
{0.201289, 0.000000, 0.076968, 0.000000, 0.201020, 0.000000, -0.391978, 0.000000, 1.000000}, 
{0.221678, 0.000000, 0.084518, 0.000000, 0.221395, 0.000000, -0.391833, 0.000000, 1.000000}, 
{0.242752, 0.000000, 0.092017, 0.000000, 0.242391, 0.000000, -0.391618, 0.000000, 1.000000}, 
{0.264474, 0.000000, 0.100184, 0.000000, 0.264214, 0.000000, -0.391421, 0.000000, 1.000000}, 
{0.286768, 0.000000, 0.108921, 0.000000, 0.286783, 0.000000, -0.391249, 0.000000, 1.000000}, 
{0.310719, 0.000000, 0.116815, 0.000000, 0.310590, 0.000000, -0.390773, 0.000000, 1.000000}, 
{0.335638, 0.000000, 0.124785, 0.000000, 0.335350, 0.000000, -0.390168, 0.000000, 1.000000}, 
{0.361240, 0.000000, 0.132630, 0.000000, 0.360747, 0.000000, -0.389394, 0.000000, 1.000000}, 
{0.387443, 0.000000, 0.140298, 0.000000, 0.386778, 0.000000, -0.388391, 0.000000, 1.000000}, 
{0.414067, 0.000000, 0.147913, 0.000000, 0.413324, 0.000000, -0.387199, 0.000000, 1.000000}, 
{0.440904, 0.000000, 0.155362, 0.000000, 0.440250, 0.000000, -0.385742, 0.000000, 1.000000}, 
{0.467771, 0.000000, 0.162574, 0.000000, 0.467678, 0.000000, -0.383926, 0.000000, 1.000000}, 
{0.494907, 0.000000, 0.169312, 0.000000, 0.495495, 0.000000, -0.381715, 0.000000, 1.000000}, 
{0.522801, 0.000000, 0.174778, 0.000000, 0.523902, 0.000000, -0.378678, 0.000000, 1.000000}, 
{0.550751, 0.000000, 0.179824, 0.000000, 0.552619, 0.000000, -0.375158, 0.000000, 1.000000}, 
{0.578018, 0.000000, 0.184284, 0.000000, 0.581249, 0.000000, -0.370851, 0.000000, 1.000000}, 
{0.605291, 0.000000, 0.188215, 0.000000, 0.610020, 0.000000, -0.365928, 0.000000, 1.000000}, 
{0.632269, 0.000000, 0.190760, 0.000000, 0.638589, 0.000000, -0.360114, 0.000000, 1.000000}, 
{0.659432, 0.000000, 0.192457, 0.000000, 0.666900, 0.000000, -0.353498, 0.000000, 1.000000}, 
{0.685839, 0.000000, 0.193458, 0.000000, 0.694917, 0.000000, -0.346094, 0.000000, 1.000000}, 
{0.711876, 0.000000, 0.193502, 0.000000, 0.722170, 0.000000, -0.337754, 0.000000, 1.000000}, 
{0.738184, 0.000000, 0.192371, 0.000000, 0.749157, 0.000000, -0.328412, 0.000000, 1.000000}, 
{0.763723, 0.000000, 0.190531, 0.000000, 0.775306, 0.000000, -0.318164, 0.000000, 1.000000}, 
{0.789192, 0.000000, 0.187726, 0.000000, 0.800939, 0.000000, -0.306900, 0.000000, 1.000000}, 
{0.813744, 0.000000, 0.183783, 0.000000, 0.825707, 0.000000, -0.295021, 0.000000, 1.000000}, 
{0.838408, 0.000000, 0.179328, 0.000000, 0.849988, 0.000000, -0.282144, 0.000000, 1.000000}, 
{0.862116, 0.000000, 0.173573, 0.000000, 0.873043, 0.000000, -0.268438, 0.000000, 1.000000}, 
{0.885636, 0.000000, 0.167350, 0.000000, 0.895463, 0.000000, -0.254108, 0.000000, 1.000000}, 
{0.909342, 0.000000, 0.160229, 0.000000, 0.917138, 0.000000, -0.239082, 0.000000, 1.000000}, 
{0.931962, 0.000000, 0.152529, 0.000000, 0.938332, 0.000000, -0.224024, 0.000000, 1.000000}, 
{0.954671, 0.000000, 0.144080, 0.000000, 0.958335, 0.000000, -0.208393, 0.000000, 1.000000}, 
{0.975707, 0.000000, 0.135023, 0.000000, 0.977612, 0.000000, -0.192630, 0.000000, 1.000000}, 
{0.996644, 0.000000, 0.125258, 0.000000, 0.995879, 0.000000, -0.176741, 0.000000, 1.000000}, 
{1.015817, 0.000000, 0.115089, 0.000000, 1.012831, 0.000000, -0.160926, 0.000000, 1.000000}, 
{1.034301, 0.000000, 0.104317, 0.000000, 1.028829, 0.000000, -0.145042, 0.000000, 1.000000}, 
{1.051131, 0.000000, 0.093218, 0.000000, 1.043605, 0.000000, -0.129052, 0.000000, 1.000000}, 
{1.066836, 0.000000, 0.081828, 0.000000, 1.057652, 0.000000, -0.112905, 0.000000, 1.000000}, 
{1.081027, 0.000000, 0.070132, 0.000000, 1.070971, 0.000000, -0.096578, 0.000000, 1.000000}, 
{1.093225, 0.000000, 0.058382, 0.000000, 1.083313, 0.000000, -0.080077, 0.000000, 1.000000}, 
{1.103691, 0.000000, 0.046527, 0.000000, 1.094768, 0.000000, -0.063580, 0.000000, 1.000000}, 
{1.112431, 0.000000, 0.034624, 0.000000, 1.105547, 0.000000, -0.047118, 0.000000, 1.000000}, 
{1.120035, 0.000000, 0.022913, 0.000000, 1.115668, 0.000000, -0.031018, 0.000000, 1.000000}, 
{1.127336, 0.000000, 0.011284, 0.000000, 1.125343, 0.000000, -0.015283, 0.000000, 1.000000}, 
{1.134510, 0.000000, -0.000170, 0.000000, 1.134581, 0.000000, 0.000058, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000084, 0.000000, 0.000200, 0.000000, -0.421534, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000212, 0.000000, 0.000504, 0.000000, -0.421533, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000850, 0.000000, 0.002016, 0.000000, -0.421533, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.001912, 0.000000, 0.004535, 0.000000, -0.421533, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.003399, 0.000000, 0.008062, 0.000000, -0.421529, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.005310, 0.000000, 0.012597, 0.000000, -0.421533, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.007646, 0.000000, 0.018140, 0.000000, -0.421531, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.010407, 0.000000, 0.024692, 0.000000, -0.421530, 0.000000, 1.000000}, 
{0.032252, 0.000000, 0.013592, 0.000000, 0.032251, 0.000000, -0.421527, 0.000000, 1.000000}, 
{0.040821, 0.000000, 0.017201, 0.000000, 0.040823, 0.000000, -0.421524, 0.000000, 1.000000}, 
{0.050401, 0.000000, 0.021234, 0.000000, 0.050407, 0.000000, -0.421516, 0.000000, 1.000000}, 
{0.060988, 0.000000, 0.025688, 0.000000, 0.060992, 0.000000, -0.421509, 0.000000, 1.000000}, 
{0.072590, 0.000000, 0.030565, 0.000000, 0.072597, 0.000000, -0.421498, 0.000000, 1.000000}, 
{0.085200, 0.000000, 0.035860, 0.000000, 0.085214, 0.000000, -0.421482, 0.000000, 1.000000}, 
{0.098823, 0.000000, 0.041572, 0.000000, 0.098847, 0.000000, -0.421462, 0.000000, 1.000000}, 
{0.113465, 0.000000, 0.047694, 0.000000, 0.113499, 0.000000, -0.421436, 0.000000, 1.000000}, 
{0.129094, 0.000000, 0.054122, 0.000000, 0.129112, 0.000000, -0.421396, 0.000000, 1.000000}, 
{0.145652, 0.000000, 0.060530, 0.000000, 0.145514, 0.000000, -0.421311, 0.000000, 1.000000}, 
{0.163245, 0.000000, 0.067517, 0.000000, 0.163024, 0.000000, -0.421218, 0.000000, 1.000000}, 
{0.181825, 0.000000, 0.074919, 0.000000, 0.181553, 0.000000, -0.421108, 0.000000, 1.000000}, 
{0.201360, 0.000000, 0.082700, 0.000000, 0.201048, 0.000000, -0.420974, 0.000000, 1.000000}, 
{0.221773, 0.000000, 0.090727, 0.000000, 0.221419, 0.000000, -0.420795, 0.000000, 1.000000}, 
{0.242908, 0.000000, 0.098719, 0.000000, 0.242439, 0.000000, -0.420536, 0.000000, 1.000000}, 
{0.264742, 0.000000, 0.107417, 0.000000, 0.264346, 0.000000, -0.420296, 0.000000, 1.000000}, 
{0.287091, 0.000000, 0.116601, 0.000000, 0.286915, 0.000000, -0.420065, 0.000000, 1.000000}, 
{0.310723, 0.000000, 0.125265, 0.000000, 0.310522, 0.000000, -0.419582, 0.000000, 1.000000}, 
{0.335685, 0.000000, 0.133876, 0.000000, 0.335316, 0.000000, -0.418912, 0.000000, 1.000000}, 
{0.361285, 0.000000, 0.142140, 0.000000, 0.360707, 0.000000, -0.418006, 0.000000, 1.000000}, 
{0.387562, 0.000000, 0.150436, 0.000000, 0.386792, 0.000000, -0.416899, 0.000000, 1.000000}, 
{0.414175, 0.000000, 0.158388, 0.000000, 0.413368, 0.000000, -0.415513, 0.000000, 1.000000}, 
{0.441021, 0.000000, 0.166258, 0.000000, 0.440412, 0.000000, -0.413836, 0.000000, 1.000000}, 
{0.467698, 0.000000, 0.173720, 0.000000, 0.467861, 0.000000, -0.411702, 0.000000, 1.000000}, 
{0.494730, 0.000000, 0.180843, 0.000000, 0.495818, 0.000000, -0.409102, 0.000000, 1.000000}, 
{0.522524, 0.000000, 0.186906, 0.000000, 0.524307, 0.000000, -0.405789, 0.000000, 1.000000}, 
{0.550055, 0.000000, 0.192004, 0.000000, 0.553026, 0.000000, -0.401759, 0.000000, 1.000000}, 
{0.577512, 0.000000, 0.196588, 0.000000, 0.581666, 0.000000, -0.397153, 0.000000, 1.000000}, 
{0.604348, 0.000000, 0.200420, 0.000000, 0.610231, 0.000000, -0.391767, 0.000000, 1.000000}, 
{0.630970, 0.000000, 0.203320, 0.000000, 0.638890, 0.000000, -0.385573, 0.000000, 1.000000}, 
{0.658023, 0.000000, 0.204883, 0.000000, 0.667051, 0.000000, -0.378245, 0.000000, 1.000000}, 
{0.684422, 0.000000, 0.205716, 0.000000, 0.694861, 0.000000, -0.370191, 0.000000, 1.000000}, 
{0.710405, 0.000000, 0.205767, 0.000000, 0.722322, 0.000000, -0.361231, 0.000000, 1.000000}, 
{0.736417, 0.000000, 0.204513, 0.000000, 0.749248, 0.000000, -0.351106, 0.000000, 1.000000}, 
{0.761836, 0.000000, 0.202281, 0.000000, 0.775118, 0.000000, -0.340096, 0.000000, 1.000000}, 
{0.787140, 0.000000, 0.199395, 0.000000, 0.800630, 0.000000, -0.328139, 0.000000, 1.000000}, 
{0.812197, 0.000000, 0.195185, 0.000000, 0.825549, 0.000000, -0.315044, 0.000000, 1.000000}, 
{0.836342, 0.000000, 0.190191, 0.000000, 0.849339, 0.000000, -0.300933, 0.000000, 1.000000}, 
{0.860311, 0.000000, 0.184343, 0.000000, 0.872365, 0.000000, -0.286411, 0.000000, 1.000000}, 
{0.883597, 0.000000, 0.177415, 0.000000, 0.894903, 0.000000, -0.270897, 0.000000, 1.000000}, 
{0.906852, 0.000000, 0.170003, 0.000000, 0.916450, 0.000000, -0.254825, 0.000000, 1.000000}, 
{0.929991, 0.000000, 0.161592, 0.000000, 0.937300, 0.000000, -0.238176, 0.000000, 1.000000}, 
{0.952478, 0.000000, 0.152792, 0.000000, 0.957373, 0.000000, -0.221581, 0.000000, 1.000000}, 
{0.974216, 0.000000, 0.143032, 0.000000, 0.976753, 0.000000, -0.204378, 0.000000, 1.000000}, 
{0.995372, 0.000000, 0.132922, 0.000000, 0.995275, 0.000000, -0.187470, 0.000000, 1.000000}, 
{1.015330, 0.000000, 0.122009, 0.000000, 1.012594, 0.000000, -0.170538, 0.000000, 1.000000}, 
{1.034070, 0.000000, 0.110740, 0.000000, 1.028452, 0.000000, -0.153777, 0.000000, 1.000000}, 
{1.051295, 0.000000, 0.099016, 0.000000, 1.043695, 0.000000, -0.136916, 0.000000, 1.000000}, 
{1.067460, 0.000000, 0.086920, 0.000000, 1.057836, 0.000000, -0.119880, 0.000000, 1.000000}, 
{1.082022, 0.000000, 0.074729, 0.000000, 1.071118, 0.000000, -0.102565, 0.000000, 1.000000}, 
{1.094378, 0.000000, 0.062036, 0.000000, 1.083592, 0.000000, -0.084994, 0.000000, 1.000000}, 
{1.104998, 0.000000, 0.049413, 0.000000, 1.095199, 0.000000, -0.067650, 0.000000, 1.000000}, 
{1.113773, 0.000000, 0.036812, 0.000000, 1.105985, 0.000000, -0.050148, 0.000000, 1.000000}, 
{1.121263, 0.000000, 0.024274, 0.000000, 1.116324, 0.000000, -0.032976, 0.000000, 1.000000}, 
{1.128420, 0.000000, 0.012038, 0.000000, 1.126142, 0.000000, -0.016239, 0.000000, 1.000000}, 
{1.135496, 0.000000, -0.000106, 0.000000, 1.135448, 0.000000, 0.000062, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000090, 0.000000, 0.000200, 0.000000, -0.451217, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000227, 0.000000, 0.000504, 0.000000, -0.451215, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000909, 0.000000, 0.002016, 0.000000, -0.451215, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002046, 0.000000, 0.004535, 0.000000, -0.451215, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.003638, 0.000000, 0.008062, 0.000000, -0.451209, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.005684, 0.000000, 0.012598, 0.000000, -0.451214, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.008185, 0.000000, 0.018142, 0.000000, -0.451212, 0.000000, 1.000000}, 
{0.024694, 0.000000, 0.011141, 0.000000, 0.024693, 0.000000, -0.451211, 0.000000, 1.000000}, 
{0.032253, 0.000000, 0.014549, 0.000000, 0.032251, 0.000000, -0.451207, 0.000000, 1.000000}, 
{0.040815, 0.000000, 0.018409, 0.000000, 0.040822, 0.000000, -0.451203, 0.000000, 1.000000}, 
{0.050401, 0.000000, 0.022727, 0.000000, 0.050401, 0.000000, -0.451195, 0.000000, 1.000000}, 
{0.060990, 0.000000, 0.027495, 0.000000, 0.060986, 0.000000, -0.451188, 0.000000, 1.000000}, 
{0.072591, 0.000000, 0.032713, 0.000000, 0.072597, 0.000000, -0.451172, 0.000000, 1.000000}, 
{0.085203, 0.000000, 0.038378, 0.000000, 0.085214, 0.000000, -0.451154, 0.000000, 1.000000}, 
{0.098829, 0.000000, 0.044489, 0.000000, 0.098849, 0.000000, -0.451130, 0.000000, 1.000000}, 
{0.113466, 0.000000, 0.051031, 0.000000, 0.113499, 0.000000, -0.451098, 0.000000, 1.000000}, 
{0.129084, 0.000000, 0.057808, 0.000000, 0.129054, 0.000000, -0.451041, 0.000000, 1.000000}, 
{0.145669, 0.000000, 0.064769, 0.000000, 0.145500, 0.000000, -0.450956, 0.000000, 1.000000}, 
{0.163278, 0.000000, 0.072278, 0.000000, 0.163029, 0.000000, -0.450853, 0.000000, 1.000000}, 
{0.181880, 0.000000, 0.080224, 0.000000, 0.181574, 0.000000, -0.450721, 0.000000, 1.000000}, 
{0.201436, 0.000000, 0.088537, 0.000000, 0.201079, 0.000000, -0.450566, 0.000000, 1.000000}, 
{0.221865, 0.000000, 0.097009, 0.000000, 0.221417, 0.000000, -0.450351, 0.000000, 1.000000}, 
{0.243083, 0.000000, 0.105591, 0.000000, 0.242498, 0.000000, -0.450062, 0.000000, 1.000000}, 
{0.265033, 0.000000, 0.114818, 0.000000, 0.264473, 0.000000, -0.449769, 0.000000, 1.000000}, 
{0.287456, 0.000000, 0.124372, 0.000000, 0.287052, 0.000000, -0.449438, 0.000000, 1.000000}, 
{0.310758, 0.000000, 0.133892, 0.000000, 0.310469, 0.000000, -0.448974, 0.000000, 1.000000}, 
{0.335721, 0.000000, 0.143052, 0.000000, 0.335253, 0.000000, -0.448216, 0.000000, 1.000000}, 
{0.361348, 0.000000, 0.151868, 0.000000, 0.360655, 0.000000, -0.447202, 0.000000, 1.000000}, 
{0.387573, 0.000000, 0.160644, 0.000000, 0.386796, 0.000000, -0.445926, 0.000000, 1.000000}, 
{0.414159, 0.000000, 0.169028, 0.000000, 0.413418, 0.000000, -0.444313, 0.000000, 1.000000}, 
{0.440950, 0.000000, 0.177169, 0.000000, 0.440634, 0.000000, -0.442315, 0.000000, 1.000000}, 
{0.467998, 0.000000, 0.185090, 0.000000, 0.468182, 0.000000, -0.439960, 0.000000, 1.000000}, 
{0.494566, 0.000000, 0.192396, 0.000000, 0.496115, 0.000000, -0.436989, 0.000000, 1.000000}, 
{0.521730, 0.000000, 0.198915, 0.000000, 0.524417, 0.000000, -0.433439, 0.000000, 1.000000}, 
{0.549405, 0.000000, 0.204240, 0.000000, 0.553208, 0.000000, -0.428984, 0.000000, 1.000000}, 
{0.576755, 0.000000, 0.208861, 0.000000, 0.582044, 0.000000, -0.423839, 0.000000, 1.000000}, 
{0.603635, 0.000000, 0.212734, 0.000000, 0.610670, 0.000000, -0.418012, 0.000000, 1.000000}, 
{0.629979, 0.000000, 0.215712, 0.000000, 0.639126, 0.000000, -0.411445, 0.000000, 1.000000}, 
{0.656597, 0.000000, 0.217385, 0.000000, 0.667394, 0.000000, -0.403628, 0.000000, 1.000000}, 
{0.683317, 0.000000, 0.218093, 0.000000, 0.695357, 0.000000, -0.394639, 0.000000, 1.000000}, 
{0.708990, 0.000000, 0.217835, 0.000000, 0.722496, 0.000000, -0.385012, 0.000000, 1.000000}, 
{0.734898, 0.000000, 0.216774, 0.000000, 0.749326, 0.000000, -0.373999, 0.000000, 1.000000}, 
{0.760342, 0.000000, 0.214120, 0.000000, 0.775539, 0.000000, -0.362128, 0.000000, 1.000000}, 
{0.785517, 0.000000, 0.210821, 0.000000, 0.800713, 0.000000, -0.349184, 0.000000, 1.000000}, 
{0.809933, 0.000000, 0.206443, 0.000000, 0.825105, 0.000000, -0.335080, 0.000000, 1.000000}, 
{0.834339, 0.000000, 0.200942, 0.000000, 0.848863, 0.000000, -0.320257, 0.000000, 1.000000}, 
{0.858793, 0.000000, 0.194938, 0.000000, 0.872110, 0.000000, -0.304133, 0.000000, 1.000000}, 
{0.882300, 0.000000, 0.187615, 0.000000, 0.894222, 0.000000, -0.287771, 0.000000, 1.000000}, 
{0.905560, 0.000000, 0.179626, 0.000000, 0.915629, 0.000000, -0.270571, 0.000000, 1.000000}, 
{0.927916, 0.000000, 0.170753, 0.000000, 0.936355, 0.000000, -0.252741, 0.000000, 1.000000}, 
{0.950415, 0.000000, 0.161270, 0.000000, 0.956502, 0.000000, -0.234656, 0.000000, 1.000000}, 
{0.972920, 0.000000, 0.151239, 0.000000, 0.975998, 0.000000, -0.216652, 0.000000, 1.000000}, 
{0.993893, 0.000000, 0.140358, 0.000000, 0.994394, 0.000000, -0.198252, 0.000000, 1.000000}, 
{1.014204, 0.000000, 0.128963, 0.000000, 1.012231, 0.000000, -0.180113, 0.000000, 1.000000}, 
{1.033878, 0.000000, 0.117128, 0.000000, 1.028562, 0.000000, -0.162282, 0.000000, 1.000000}, 
{1.051754, 0.000000, 0.104678, 0.000000, 1.043665, 0.000000, -0.144366, 0.000000, 1.000000}, 
{1.067924, 0.000000, 0.092000, 0.000000, 1.057920, 0.000000, -0.126455, 0.000000, 1.000000}, 
{1.082643, 0.000000, 0.078837, 0.000000, 1.071334, 0.000000, -0.108194, 0.000000, 1.000000}, 
{1.095503, 0.000000, 0.065669, 0.000000, 1.083854, 0.000000, -0.089966, 0.000000, 1.000000}, 
{1.106290, 0.000000, 0.052345, 0.000000, 1.095667, 0.000000, -0.071530, 0.000000, 1.000000}, 
{1.115219, 0.000000, 0.039024, 0.000000, 1.106630, 0.000000, -0.053158, 0.000000, 1.000000}, 
{1.122587, 0.000000, 0.025789, 0.000000, 1.117009, 0.000000, -0.034959, 0.000000, 1.000000}, 
{1.129461, 0.000000, 0.012622, 0.000000, 1.126926, 0.000000, -0.017222, 0.000000, 1.000000}, 
{1.136468, 0.000000, -0.000152, 0.000000, 1.136509, 0.000000, 0.000065, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000096, 0.000000, 0.000200, 0.000000, -0.481574, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000243, 0.000000, 0.000504, 0.000000, -0.481572, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.000971, 0.000000, 0.002016, 0.000000, -0.481572, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002184, 0.000000, 0.004535, 0.000000, -0.481572, 0.000000, 1.000000}, 
{0.008061, 0.000000, 0.003882, 0.000000, 0.008064, 0.000000, -0.481566, 0.000000, 1.000000}, 
{0.012597, 0.000000, 0.006066, 0.000000, 0.012598, 0.000000, -0.481572, 0.000000, 1.000000}, 
{0.018142, 0.000000, 0.008736, 0.000000, 0.018144, 0.000000, -0.481569, 0.000000, 1.000000}, 
{0.024693, 0.000000, 0.011889, 0.000000, 0.024689, 0.000000, -0.481570, 0.000000, 1.000000}, 
{0.032254, 0.000000, 0.015528, 0.000000, 0.032252, 0.000000, -0.481563, 0.000000, 1.000000}, 
{0.040822, 0.000000, 0.019650, 0.000000, 0.040820, 0.000000, -0.481559, 0.000000, 1.000000}, 
{0.050402, 0.000000, 0.024255, 0.000000, 0.050402, 0.000000, -0.481550, 0.000000, 1.000000}, 
{0.060992, 0.000000, 0.029342, 0.000000, 0.060991, 0.000000, -0.481537, 0.000000, 1.000000}, 
{0.072592, 0.000000, 0.034908, 0.000000, 0.072593, 0.000000, -0.481521, 0.000000, 1.000000}, 
{0.085207, 0.000000, 0.040953, 0.000000, 0.085213, 0.000000, -0.481499, 0.000000, 1.000000}, 
{0.098834, 0.000000, 0.047469, 0.000000, 0.098848, 0.000000, -0.481469, 0.000000, 1.000000}, 
{0.113474, 0.000000, 0.054441, 0.000000, 0.113494, 0.000000, -0.481431, 0.000000, 1.000000}, 
{0.129077, 0.000000, 0.061556, 0.000000, 0.128986, 0.000000, -0.481359, 0.000000, 1.000000}, 
{0.145691, 0.000000, 0.069091, 0.000000, 0.145479, 0.000000, -0.481269, 0.000000, 1.000000}, 
{0.163321, 0.000000, 0.077151, 0.000000, 0.163033, 0.000000, -0.481156, 0.000000, 1.000000}, 
{0.181936, 0.000000, 0.085636, 0.000000, 0.181594, 0.000000, -0.481011, 0.000000, 1.000000}, 
{0.201516, 0.000000, 0.094484, 0.000000, 0.201093, 0.000000, -0.480830, 0.000000, 1.000000}, 
{0.221963, 0.000000, 0.103362, 0.000000, 0.221371, 0.000000, -0.480562, 0.000000, 1.000000}, 
{0.243264, 0.000000, 0.112628, 0.000000, 0.242540, 0.000000, -0.480247, 0.000000, 1.000000}, 
{0.265291, 0.000000, 0.122366, 0.000000, 0.264556, 0.000000, -0.479891, 0.000000, 1.000000}, 
{0.287824, 0.000000, 0.132256, 0.000000, 0.287132, 0.000000, -0.479461, 0.000000, 1.000000}, 
{0.310927, 0.000000, 0.142614, 0.000000, 0.310506, 0.000000, -0.478978, 0.000000, 1.000000}, 
{0.335749, 0.000000, 0.152326, 0.000000, 0.335190, 0.000000, -0.478132, 0.000000, 1.000000}, 
{0.361361, 0.000000, 0.161747, 0.000000, 0.360674, 0.000000, -0.476971, 0.000000, 1.000000}, 
{0.387480, 0.000000, 0.170879, 0.000000, 0.386787, 0.000000, -0.475477, 0.000000, 1.000000}, 
{0.414231, 0.000000, 0.179865, 0.000000, 0.413510, 0.000000, -0.473686, 0.000000, 1.000000}, 
{0.441065, 0.000000, 0.188331, 0.000000, 0.440786, 0.000000, -0.471415, 0.000000, 1.000000}, 
{0.467923, 0.000000, 0.196454, 0.000000, 0.468430, 0.000000, -0.468647, 0.000000, 1.000000}, 
{0.494526, 0.000000, 0.204048, 0.000000, 0.496405, 0.000000, -0.465459, 0.000000, 1.000000}, 
{0.521318, 0.000000, 0.211020, 0.000000, 0.524692, 0.000000, -0.461650, 0.000000, 1.000000}, 
{0.548654, 0.000000, 0.216520, 0.000000, 0.553431, 0.000000, -0.456868, 0.000000, 1.000000}, 
{0.575778, 0.000000, 0.221098, 0.000000, 0.582283, 0.000000, -0.451227, 0.000000, 1.000000}, 
{0.602610, 0.000000, 0.224923, 0.000000, 0.611150, 0.000000, -0.444866, 0.000000, 1.000000}, 
{0.628891, 0.000000, 0.227895, 0.000000, 0.639600, 0.000000, -0.437577, 0.000000, 1.000000}, 
{0.655635, 0.000000, 0.230020, 0.000000, 0.667765, 0.000000, -0.429369, 0.000000, 1.000000}, 
{0.682115, 0.000000, 0.230419, 0.000000, 0.695672, 0.000000, -0.419673, 0.000000, 1.000000}, 
{0.707514, 0.000000, 0.229789, 0.000000, 0.723222, 0.000000, -0.409143, 0.000000, 1.000000}, 
{0.733169, 0.000000, 0.228520, 0.000000, 0.749627, 0.000000, -0.397296, 0.000000, 1.000000}, 
{0.758342, 0.000000, 0.225793, 0.000000, 0.775506, 0.000000, -0.384578, 0.000000, 1.000000}, 
{0.783477, 0.000000, 0.222049, 0.000000, 0.800522, 0.000000, -0.370323, 0.000000, 1.000000}, 
{0.808497, 0.000000, 0.217562, 0.000000, 0.824953, 0.000000, -0.355253, 0.000000, 1.000000}, 
{0.832790, 0.000000, 0.211697, 0.000000, 0.848726, 0.000000, -0.339282, 0.000000, 1.000000}, 
{0.856677, 0.000000, 0.204989, 0.000000, 0.871450, 0.000000, -0.322181, 0.000000, 1.000000}, 
{0.880662, 0.000000, 0.197653, 0.000000, 0.893266, 0.000000, -0.304610, 0.000000, 1.000000}, 
{0.903474, 0.000000, 0.188858, 0.000000, 0.914669, 0.000000, -0.286042, 0.000000, 1.000000}, 
{0.926313, 0.000000, 0.179746, 0.000000, 0.935375, 0.000000, -0.267224, 0.000000, 1.000000}, 
{0.948458, 0.000000, 0.169542, 0.000000, 0.955591, 0.000000, -0.247978, 0.000000, 1.000000}, 
{0.970873, 0.000000, 0.159005, 0.000000, 0.975028, 0.000000, -0.228535, 0.000000, 1.000000}, 
{0.992958, 0.000000, 0.147658, 0.000000, 0.994123, 0.000000, -0.208819, 0.000000, 1.000000}, 
{1.013413, 0.000000, 0.135771, 0.000000, 1.011889, 0.000000, -0.189486, 0.000000, 1.000000}, 
{1.033483, 0.000000, 0.123256, 0.000000, 1.028223, 0.000000, -0.170422, 0.000000, 1.000000}, 
{1.051872, 0.000000, 0.110401, 0.000000, 1.043681, 0.000000, -0.152075, 0.000000, 1.000000}, 
{1.068396, 0.000000, 0.096860, 0.000000, 1.057923, 0.000000, -0.133169, 0.000000, 1.000000}, 
{1.083731, 0.000000, 0.083259, 0.000000, 1.071556, 0.000000, -0.114022, 0.000000, 1.000000}, 
{1.096849, 0.000000, 0.069266, 0.000000, 1.084262, 0.000000, -0.094772, 0.000000, 1.000000}, 
{1.107864, 0.000000, 0.055203, 0.000000, 1.096108, 0.000000, -0.075432, 0.000000, 1.000000}, 
{1.116600, 0.000000, 0.041097, 0.000000, 1.107259, 0.000000, -0.055980, 0.000000, 1.000000}, 
{1.123871, 0.000000, 0.027083, 0.000000, 1.117812, 0.000000, -0.036839, 0.000000, 1.000000}, 
{1.130718, 0.000000, 0.013510, 0.000000, 1.127830, 0.000000, -0.018156, 0.000000, 1.000000}, 
{1.137649, 0.000000, -0.000154, 0.000000, 1.137612, 0.000000, 0.000028, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000103, 0.000000, 0.000200, 0.000000, -0.512670, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000258, 0.000000, 0.000504, 0.000000, -0.512667, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001033, 0.000000, 0.002016, 0.000000, -0.512668, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002325, 0.000000, 0.004535, 0.000000, -0.512667, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.004133, 0.000000, 0.008063, 0.000000, -0.512659, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.006458, 0.000000, 0.012598, 0.000000, -0.512666, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.009299, 0.000000, 0.018142, 0.000000, -0.512665, 0.000000, 1.000000}, 
{0.024683, 0.000000, 0.012652, 0.000000, 0.024697, 0.000000, -0.512655, 0.000000, 1.000000}, 
{0.032257, 0.000000, 0.016532, 0.000000, 0.032254, 0.000000, -0.512656, 0.000000, 1.000000}, 
{0.040826, 0.000000, 0.020919, 0.000000, 0.040825, 0.000000, -0.512649, 0.000000, 1.000000}, 
{0.050403, 0.000000, 0.025820, 0.000000, 0.050400, 0.000000, -0.512639, 0.000000, 1.000000}, 
{0.060993, 0.000000, 0.031233, 0.000000, 0.060991, 0.000000, -0.512625, 0.000000, 1.000000}, 
{0.072597, 0.000000, 0.037157, 0.000000, 0.072593, 0.000000, -0.512607, 0.000000, 1.000000}, 
{0.085211, 0.000000, 0.043587, 0.000000, 0.085210, 0.000000, -0.512581, 0.000000, 1.000000}, 
{0.098842, 0.000000, 0.050520, 0.000000, 0.098847, 0.000000, -0.512544, 0.000000, 1.000000}, 
{0.113484, 0.000000, 0.057926, 0.000000, 0.113486, 0.000000, -0.512500, 0.000000, 1.000000}, 
{0.129097, 0.000000, 0.065460, 0.000000, 0.128947, 0.000000, -0.512420, 0.000000, 1.000000}, 
{0.145727, 0.000000, 0.073543, 0.000000, 0.145474, 0.000000, -0.512316, 0.000000, 1.000000}, 
{0.163375, 0.000000, 0.082134, 0.000000, 0.163035, 0.000000, -0.512190, 0.000000, 1.000000}, 
{0.182011, 0.000000, 0.091173, 0.000000, 0.181604, 0.000000, -0.512024, 0.000000, 1.000000}, 
{0.201598, 0.000000, 0.100540, 0.000000, 0.201096, 0.000000, -0.511810, 0.000000, 1.000000}, 
{0.222084, 0.000000, 0.109931, 0.000000, 0.221360, 0.000000, -0.511505, 0.000000, 1.000000}, 
{0.243446, 0.000000, 0.119838, 0.000000, 0.242587, 0.000000, -0.511151, 0.000000, 1.000000}, 
{0.265574, 0.000000, 0.130090, 0.000000, 0.264636, 0.000000, -0.510724, 0.000000, 1.000000}, 
{0.288230, 0.000000, 0.140421, 0.000000, 0.287252, 0.000000, -0.510191, 0.000000, 1.000000}, 
{0.311336, 0.000000, 0.151343, 0.000000, 0.310650, 0.000000, -0.509627, 0.000000, 1.000000}, 
{0.335719, 0.000000, 0.161689, 0.000000, 0.335104, 0.000000, -0.508688, 0.000000, 1.000000}, 
{0.361314, 0.000000, 0.171748, 0.000000, 0.360651, 0.000000, -0.507393, 0.000000, 1.000000}, 
{0.387541, 0.000000, 0.181399, 0.000000, 0.386787, 0.000000, -0.505758, 0.000000, 1.000000}, 
{0.414204, 0.000000, 0.190768, 0.000000, 0.413605, 0.000000, -0.503676, 0.000000, 1.000000}, 
{0.441092, 0.000000, 0.199659, 0.000000, 0.440877, 0.000000, -0.501129, 0.000000, 1.000000}, 
{0.467789, 0.000000, 0.207934, 0.000000, 0.468614, 0.000000, -0.498078, 0.000000, 1.000000}, 
{0.494454, 0.000000, 0.215747, 0.000000, 0.496653, 0.000000, -0.494630, 0.000000, 1.000000}, 
{0.520950, 0.000000, 0.222869, 0.000000, 0.524972, 0.000000, -0.490467, 0.000000, 1.000000}, 
{0.547802, 0.000000, 0.228881, 0.000000, 0.553766, 0.000000, -0.485444, 0.000000, 1.000000}, 
{0.575563, 0.000000, 0.233760, 0.000000, 0.582669, 0.000000, -0.479268, 0.000000, 1.000000}, 
{0.602426, 0.000000, 0.237566, 0.000000, 0.611549, 0.000000, -0.472272, 0.000000, 1.000000}, 
{0.628772, 0.000000, 0.240447, 0.000000, 0.640211, 0.000000, -0.464390, 0.000000, 1.000000}, 
{0.654963, 0.000000, 0.242427, 0.000000, 0.668357, 0.000000, -0.455345, 0.000000, 1.000000}, 
{0.681384, 0.000000, 0.242980, 0.000000, 0.695995, 0.000000, -0.444885, 0.000000, 1.000000}, 
{0.707173, 0.000000, 0.242150, 0.000000, 0.723373, 0.000000, -0.433338, 0.000000, 1.000000}, 
{0.732477, 0.000000, 0.240435, 0.000000, 0.749834, 0.000000, -0.420647, 0.000000, 1.000000}, 
{0.757567, 0.000000, 0.237806, 0.000000, 0.775746, 0.000000, -0.406799, 0.000000, 1.000000}, 
{0.782341, 0.000000, 0.233503, 0.000000, 0.800683, 0.000000, -0.391761, 0.000000, 1.000000}, 
{0.806690, 0.000000, 0.228346, 0.000000, 0.824784, 0.000000, -0.375576, 0.000000, 1.000000}, 
{0.830804, 0.000000, 0.222386, 0.000000, 0.848194, 0.000000, -0.358545, 0.000000, 1.000000}, 
{0.854940, 0.000000, 0.215141, 0.000000, 0.870812, 0.000000, -0.340431, 0.000000, 1.000000}, 
{0.878709, 0.000000, 0.207207, 0.000000, 0.892823, 0.000000, -0.321690, 0.000000, 1.000000}, 
{0.901928, 0.000000, 0.198273, 0.000000, 0.913741, 0.000000, -0.301930, 0.000000, 1.000000}, 
{0.924845, 0.000000, 0.188476, 0.000000, 0.934433, 0.000000, -0.281513, 0.000000, 1.000000}, 
{0.946932, 0.000000, 0.177996, 0.000000, 0.954335, 0.000000, -0.261234, 0.000000, 1.000000}, 
{0.969256, 0.000000, 0.166644, 0.000000, 0.973608, 0.000000, -0.240356, 0.000000, 1.000000}, 
{0.991323, 0.000000, 0.154968, 0.000000, 0.992915, 0.000000, -0.219748, 0.000000, 1.000000}, 
{1.013013, 0.000000, 0.142425, 0.000000, 1.010979, 0.000000, -0.199103, 0.000000, 1.000000}, 
{1.032845, 0.000000, 0.129456, 0.000000, 1.027992, 0.000000, -0.178936, 0.000000, 1.000000}, 
{1.051887, 0.000000, 0.115763, 0.000000, 1.043710, 0.000000, -0.159243, 0.000000, 1.000000}, 
{1.069179, 0.000000, 0.101851, 0.000000, 1.058201, 0.000000, -0.139560, 0.000000, 1.000000}, 
{1.084499, 0.000000, 0.087357, 0.000000, 1.071964, 0.000000, -0.119607, 0.000000, 1.000000}, 
{1.097921, 0.000000, 0.072796, 0.000000, 1.084792, 0.000000, -0.099501, 0.000000, 1.000000}, 
{1.109281, 0.000000, 0.058037, 0.000000, 1.096805, 0.000000, -0.079211, 0.000000, 1.000000}, 
{1.118194, 0.000000, 0.043226, 0.000000, 1.108004, 0.000000, -0.058873, 0.000000, 1.000000}, 
{1.125351, 0.000000, 0.028633, 0.000000, 1.118531, 0.000000, -0.038736, 0.000000, 1.000000}, 
{1.132002, 0.000000, 0.013996, 0.000000, 1.128866, 0.000000, -0.019063, 0.000000, 1.000000}, 
{1.138951, 0.000000, -0.000132, 0.000000, 1.138910, 0.000000, 0.000007, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000109, 0.000000, 0.000200, 0.000000, -0.544571, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000274, 0.000000, 0.000504, 0.000000, -0.544568, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001098, 0.000000, 0.002015, 0.000000, -0.544568, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002470, 0.000000, 0.004535, 0.000000, -0.544568, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.004390, 0.000000, 0.008063, 0.000000, -0.544559, 0.000000, 1.000000}, 
{0.012597, 0.000000, 0.006860, 0.000000, 0.012598, 0.000000, -0.544566, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.009878, 0.000000, 0.018141, 0.000000, -0.544565, 0.000000, 1.000000}, 
{0.024693, 0.000000, 0.013444, 0.000000, 0.024692, 0.000000, -0.544560, 0.000000, 1.000000}, 
{0.032256, 0.000000, 0.017559, 0.000000, 0.032251, 0.000000, -0.544557, 0.000000, 1.000000}, 
{0.040824, 0.000000, 0.022218, 0.000000, 0.040820, 0.000000, -0.544547, 0.000000, 1.000000}, 
{0.050408, 0.000000, 0.027426, 0.000000, 0.050397, 0.000000, -0.544532, 0.000000, 1.000000}, 
{0.060997, 0.000000, 0.033173, 0.000000, 0.060990, 0.000000, -0.544518, 0.000000, 1.000000}, 
{0.072600, 0.000000, 0.039463, 0.000000, 0.072592, 0.000000, -0.544496, 0.000000, 1.000000}, 
{0.085220, 0.000000, 0.046292, 0.000000, 0.085211, 0.000000, -0.544466, 0.000000, 1.000000}, 
{0.098851, 0.000000, 0.053648, 0.000000, 0.098845, 0.000000, -0.544422, 0.000000, 1.000000}, 
{0.113496, 0.000000, 0.061487, 0.000000, 0.113471, 0.000000, -0.544371, 0.000000, 1.000000}, 
{0.129112, 0.000000, 0.069467, 0.000000, 0.128921, 0.000000, -0.544273, 0.000000, 1.000000}, 
{0.145765, 0.000000, 0.078092, 0.000000, 0.145463, 0.000000, -0.544160, 0.000000, 1.000000}, 
{0.163431, 0.000000, 0.087231, 0.000000, 0.163031, 0.000000, -0.544017, 0.000000, 1.000000}, 
{0.182088, 0.000000, 0.096837, 0.000000, 0.181614, 0.000000, -0.543828, 0.000000, 1.000000}, 
{0.201698, 0.000000, 0.106713, 0.000000, 0.201075, 0.000000, -0.543585, 0.000000, 1.000000}, 
{0.222231, 0.000000, 0.116699, 0.000000, 0.221360, 0.000000, -0.543238, 0.000000, 1.000000}, 
{0.243653, 0.000000, 0.127208, 0.000000, 0.242617, 0.000000, -0.542836, 0.000000, 1.000000}, 
{0.265855, 0.000000, 0.137949, 0.000000, 0.264673, 0.000000, -0.542329, 0.000000, 1.000000}, 
{0.288623, 0.000000, 0.148847, 0.000000, 0.287371, 0.000000, -0.541700, 0.000000, 1.000000}, 
{0.311830, 0.000000, 0.160204, 0.000000, 0.310816, 0.000000, -0.540997, 0.000000, 1.000000}, 
{0.335728, 0.000000, 0.171324, 0.000000, 0.335085, 0.000000, -0.540045, 0.000000, 1.000000}, 
{0.361403, 0.000000, 0.181915, 0.000000, 0.360608, 0.000000, -0.538603, 0.000000, 1.000000}, 
{0.387647, 0.000000, 0.192124, 0.000000, 0.386772, 0.000000, -0.536741, 0.000000, 1.000000}, 
{0.414217, 0.000000, 0.201807, 0.000000, 0.413565, 0.000000, -0.534432, 0.000000, 1.000000}, 
{0.441090, 0.000000, 0.211093, 0.000000, 0.440972, 0.000000, -0.531623, 0.000000, 1.000000}, 
{0.467823, 0.000000, 0.219678, 0.000000, 0.468810, 0.000000, -0.528314, 0.000000, 1.000000}, 
{0.494361, 0.000000, 0.227581, 0.000000, 0.496944, 0.000000, -0.524391, 0.000000, 1.000000}, 
{0.521264, 0.000000, 0.235087, 0.000000, 0.525364, 0.000000, -0.519902, 0.000000, 1.000000}, 
{0.547881, 0.000000, 0.241508, 0.000000, 0.554046, 0.000000, -0.514574, 0.000000, 1.000000}, 
{0.574965, 0.000000, 0.246315, 0.000000, 0.583132, 0.000000, -0.507837, 0.000000, 1.000000}, 
{0.601847, 0.000000, 0.250061, 0.000000, 0.611961, 0.000000, -0.500286, 0.000000, 1.000000}, 
{0.628207, 0.000000, 0.252822, 0.000000, 0.640617, 0.000000, -0.491502, 0.000000, 1.000000}, 
{0.654445, 0.000000, 0.254691, 0.000000, 0.668824, 0.000000, -0.481726, 0.000000, 1.000000}, 
{0.680175, 0.000000, 0.255318, 0.000000, 0.696386, 0.000000, -0.470727, 0.000000, 1.000000}, 
{0.706168, 0.000000, 0.254257, 0.000000, 0.723694, 0.000000, -0.458045, 0.000000, 1.000000}, 
{0.731458, 0.000000, 0.252100, 0.000000, 0.750414, 0.000000, -0.444438, 0.000000, 1.000000}, 
{0.756378, 0.000000, 0.249115, 0.000000, 0.775782, 0.000000, -0.429611, 0.000000, 1.000000}, 
{0.781311, 0.000000, 0.244899, 0.000000, 0.801032, 0.000000, -0.413501, 0.000000, 1.000000}, 
{0.805755, 0.000000, 0.239225, 0.000000, 0.824854, 0.000000, -0.395889, 0.000000, 1.000000}, 
{0.829867, 0.000000, 0.232830, 0.000000, 0.848057, 0.000000, -0.377860, 0.000000, 1.000000}, 
{0.853067, 0.000000, 0.225193, 0.000000, 0.870458, 0.000000, -0.358704, 0.000000, 1.000000}, 
{0.877084, 0.000000, 0.216648, 0.000000, 0.892047, 0.000000, -0.338413, 0.000000, 1.000000}, 
{0.900123, 0.000000, 0.207390, 0.000000, 0.912686, 0.000000, -0.317596, 0.000000, 1.000000}, 
{0.923370, 0.000000, 0.197095, 0.000000, 0.933763, 0.000000, -0.296301, 0.000000, 1.000000}, 
{0.946021, 0.000000, 0.186084, 0.000000, 0.953363, 0.000000, -0.274498, 0.000000, 1.000000}, 
{0.967669, 0.000000, 0.174262, 0.000000, 0.972475, 0.000000, -0.252565, 0.000000, 1.000000}, 
{0.989761, 0.000000, 0.161814, 0.000000, 0.991830, 0.000000, -0.230312, 0.000000, 1.000000}, 
{1.012163, 0.000000, 0.149076, 0.000000, 1.010403, 0.000000, -0.208746, 0.000000, 1.000000}, 
{1.032547, 0.000000, 0.135299, 0.000000, 1.027461, 0.000000, -0.187180, 0.000000, 1.000000}, 
{1.052032, 0.000000, 0.121277, 0.000000, 1.043673, 0.000000, -0.166482, 0.000000, 1.000000}, 
{1.069907, 0.000000, 0.106582, 0.000000, 1.058345, 0.000000, -0.145939, 0.000000, 1.000000}, 
{1.085563, 0.000000, 0.091589, 0.000000, 1.072124, 0.000000, -0.125362, 0.000000, 1.000000}, 
{1.099447, 0.000000, 0.076263, 0.000000, 1.084969, 0.000000, -0.104087, 0.000000, 1.000000}, 
{1.110848, 0.000000, 0.060825, 0.000000, 1.097208, 0.000000, -0.083036, 0.000000, 1.000000}, 
{1.119923, 0.000000, 0.045319, 0.000000, 1.108668, 0.000000, -0.061719, 0.000000, 1.000000}, 
{1.126805, 0.000000, 0.029852, 0.000000, 1.119433, 0.000000, -0.040583, 0.000000, 1.000000}, 
{1.133282, 0.000000, 0.014846, 0.000000, 1.129811, 0.000000, -0.019969, 0.000000, 1.000000}, 
{1.140128, 0.000000, -0.000149, 0.000000, 1.140101, 0.000000, 0.000037, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000116, 0.000000, 0.000200, 0.000000, -0.577350, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000291, 0.000000, 0.000504, 0.000000, -0.577348, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.001164, 0.000000, 0.002016, 0.000000, -0.577347, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002618, 0.000000, 0.004535, 0.000000, -0.577347, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.004655, 0.000000, 0.008063, 0.000000, -0.577336, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.007273, 0.000000, 0.012598, 0.000000, -0.577345, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.010472, 0.000000, 0.018141, 0.000000, -0.577342, 0.000000, 1.000000}, 
{0.024694, 0.000000, 0.014253, 0.000000, 0.024694, 0.000000, -0.577339, 0.000000, 1.000000}, 
{0.032254, 0.000000, 0.018614, 0.000000, 0.032252, 0.000000, -0.577332, 0.000000, 1.000000}, 
{0.040827, 0.000000, 0.023556, 0.000000, 0.040822, 0.000000, -0.577321, 0.000000, 1.000000}, 
{0.050400, 0.000000, 0.029069, 0.000000, 0.050403, 0.000000, -0.577309, 0.000000, 1.000000}, 
{0.061000, 0.000000, 0.035166, 0.000000, 0.060991, 0.000000, -0.577288, 0.000000, 1.000000}, 
{0.072608, 0.000000, 0.041833, 0.000000, 0.072591, 0.000000, -0.577263, 0.000000, 1.000000}, 
{0.085227, 0.000000, 0.049067, 0.000000, 0.085209, 0.000000, -0.577226, 0.000000, 1.000000}, 
{0.098864, 0.000000, 0.056860, 0.000000, 0.098841, 0.000000, -0.577177, 0.000000, 1.000000}, 
{0.113507, 0.000000, 0.065114, 0.000000, 0.113442, 0.000000, -0.577109, 0.000000, 1.000000}, 
{0.129146, 0.000000, 0.073610, 0.000000, 0.128910, 0.000000, -0.577005, 0.000000, 1.000000}, 
{0.145808, 0.000000, 0.082766, 0.000000, 0.145459, 0.000000, -0.576872, 0.000000, 1.000000}, 
{0.163494, 0.000000, 0.092458, 0.000000, 0.163034, 0.000000, -0.576709, 0.000000, 1.000000}, 
{0.182176, 0.000000, 0.102639, 0.000000, 0.181616, 0.000000, -0.576501, 0.000000, 1.000000}, 
{0.201804, 0.000000, 0.112983, 0.000000, 0.201027, 0.000000, -0.576207, 0.000000, 1.000000}, 
{0.222394, 0.000000, 0.123650, 0.000000, 0.221371, 0.000000, -0.575823, 0.000000, 1.000000}, 
{0.243881, 0.000000, 0.134780, 0.000000, 0.242662, 0.000000, -0.575363, 0.000000, 1.000000}, 
{0.266122, 0.000000, 0.145931, 0.000000, 0.264662, 0.000000, -0.574751, 0.000000, 1.000000}, 
{0.289043, 0.000000, 0.157500, 0.000000, 0.287500, 0.000000, -0.574033, 0.000000, 1.000000}, 
{0.312330, 0.000000, 0.169208, 0.000000, 0.310960, 0.000000, -0.573181, 0.000000, 1.000000}, 
{0.336120, 0.000000, 0.181125, 0.000000, 0.335117, 0.000000, -0.572188, 0.000000, 1.000000}, 
{0.361506, 0.000000, 0.192232, 0.000000, 0.360519, 0.000000, -0.570631, 0.000000, 1.000000}, 
{0.387757, 0.000000, 0.202981, 0.000000, 0.386731, 0.000000, -0.568558, 0.000000, 1.000000}, 
{0.414365, 0.000000, 0.213160, 0.000000, 0.413559, 0.000000, -0.566027, 0.000000, 1.000000}, 
{0.440986, 0.000000, 0.222617, 0.000000, 0.441063, 0.000000, -0.562942, 0.000000, 1.000000}, 
{0.467943, 0.000000, 0.231583, 0.000000, 0.468934, 0.000000, -0.559219, 0.000000, 1.000000}, 
{0.494821, 0.000000, 0.239881, 0.000000, 0.497230, 0.000000, -0.554913, 0.000000, 1.000000}, 
{0.521486, 0.000000, 0.247336, 0.000000, 0.525741, 0.000000, -0.549953, 0.000000, 1.000000}, 
{0.547884, 0.000000, 0.253921, 0.000000, 0.554432, 0.000000, -0.544251, 0.000000, 1.000000}, 
{0.574582, 0.000000, 0.259099, 0.000000, 0.583527, 0.000000, -0.537120, 0.000000, 1.000000}, 
{0.601342, 0.000000, 0.262695, 0.000000, 0.612364, 0.000000, -0.528650, 0.000000, 1.000000}, 
{0.627861, 0.000000, 0.265337, 0.000000, 0.640949, 0.000000, -0.518978, 0.000000, 1.000000}, 
{0.653745, 0.000000, 0.266872, 0.000000, 0.669393, 0.000000, -0.508525, 0.000000, 1.000000}, 
{0.679348, 0.000000, 0.267403, 0.000000, 0.697134, 0.000000, -0.496705, 0.000000, 1.000000}, 
{0.705068, 0.000000, 0.266429, 0.000000, 0.723920, 0.000000, -0.482926, 0.000000, 1.000000}, 
{0.730312, 0.000000, 0.263829, 0.000000, 0.750644, 0.000000, -0.468519, 0.000000, 1.000000}, 
{0.755576, 0.000000, 0.260491, 0.000000, 0.776106, 0.000000, -0.452213, 0.000000, 1.000000}, 
{0.780371, 0.000000, 0.256166, 0.000000, 0.800744, 0.000000, -0.435127, 0.000000, 1.000000}, 
{0.804632, 0.000000, 0.250079, 0.000000, 0.825006, 0.000000, -0.416833, 0.000000, 1.000000}, 
{0.828983, 0.000000, 0.243181, 0.000000, 0.848147, 0.000000, -0.397009, 0.000000, 1.000000}, 
{0.852585, 0.000000, 0.235383, 0.000000, 0.870331, 0.000000, -0.376647, 0.000000, 1.000000}, 
{0.875237, 0.000000, 0.226031, 0.000000, 0.891572, 0.000000, -0.355506, 0.000000, 1.000000}, 
{0.899152, 0.000000, 0.216343, 0.000000, 0.912415, 0.000000, -0.333133, 0.000000, 1.000000}, 
{0.922121, 0.000000, 0.205772, 0.000000, 0.932811, 0.000000, -0.311073, 0.000000, 1.000000}, 
{0.944523, 0.000000, 0.193980, 0.000000, 0.952306, 0.000000, -0.287781, 0.000000, 1.000000}, 
{0.967313, 0.000000, 0.181920, 0.000000, 0.972114, 0.000000, -0.264350, 0.000000, 1.000000}, 
{0.989042, 0.000000, 0.168822, 0.000000, 0.990799, 0.000000, -0.241128, 0.000000, 1.000000}, 
{1.010881, 0.000000, 0.155350, 0.000000, 1.009148, 0.000000, -0.218138, 0.000000, 1.000000}, 
{1.032368, 0.000000, 0.141231, 0.000000, 1.027049, 0.000000, -0.195579, 0.000000, 1.000000}, 
{1.052254, 0.000000, 0.126521, 0.000000, 1.043518, 0.000000, -0.173399, 0.000000, 1.000000}, 
{1.070207, 0.000000, 0.111243, 0.000000, 1.058585, 0.000000, -0.151866, 0.000000, 1.000000}, 
{1.086528, 0.000000, 0.095617, 0.000000, 1.072266, 0.000000, -0.130711, 0.000000, 1.000000}, 
{1.100670, 0.000000, 0.079687, 0.000000, 1.085546, 0.000000, -0.108865, 0.000000, 1.000000}, 
{1.112461, 0.000000, 0.063593, 0.000000, 1.097907, 0.000000, -0.086760, 0.000000, 1.000000}, 
{1.121588, 0.000000, 0.047313, 0.000000, 1.109393, 0.000000, -0.064575, 0.000000, 1.000000}, 
{1.128522, 0.000000, 0.031385, 0.000000, 1.120408, 0.000000, -0.042499, 0.000000, 1.000000}, 
{1.134759, 0.000000, 0.015356, 0.000000, 1.131042, 0.000000, -0.020840, 0.000000, 1.000000}, 
{1.141448, 0.000000, -0.000114, 0.000000, 1.141473, 0.000000, 0.000056, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000122, 0.000000, 0.000200, 0.000000, -0.611086, 0.000000, 1.000000}, 
{0.000503, 0.000000, 0.000308, 0.000000, 0.000504, 0.000000, -0.611084, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001232, 0.000000, 0.002016, 0.000000, -0.611084, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002771, 0.000000, 0.004535, 0.000000, -0.611083, 0.000000, 1.000000}, 
{0.008061, 0.000000, 0.004926, 0.000000, 0.008064, 0.000000, -0.611083, 0.000000, 1.000000}, 
{0.012601, 0.000000, 0.007700, 0.000000, 0.012596, 0.000000, -0.611084, 0.000000, 1.000000}, 
{0.018142, 0.000000, 0.011084, 0.000000, 0.018141, 0.000000, -0.611078, 0.000000, 1.000000}, 
{0.024695, 0.000000, 0.015087, 0.000000, 0.024692, 0.000000, -0.611074, 0.000000, 1.000000}, 
{0.032255, 0.000000, 0.019701, 0.000000, 0.032252, 0.000000, -0.611066, 0.000000, 1.000000}, 
{0.040827, 0.000000, 0.024930, 0.000000, 0.040821, 0.000000, -0.611055, 0.000000, 1.000000}, 
{0.050408, 0.000000, 0.030769, 0.000000, 0.050399, 0.000000, -0.611037, 0.000000, 1.000000}, 
{0.061004, 0.000000, 0.037217, 0.000000, 0.060990, 0.000000, -0.611014, 0.000000, 1.000000}, 
{0.072613, 0.000000, 0.044270, 0.000000, 0.072592, 0.000000, -0.610982, 0.000000, 1.000000}, 
{0.085238, 0.000000, 0.051923, 0.000000, 0.085209, 0.000000, -0.610941, 0.000000, 1.000000}, 
{0.098878, 0.000000, 0.060161, 0.000000, 0.098837, 0.000000, -0.610883, 0.000000, 1.000000}, 
{0.113522, 0.000000, 0.068785, 0.000000, 0.113382, 0.000000, -0.610798, 0.000000, 1.000000}, 
{0.129176, 0.000000, 0.077863, 0.000000, 0.128893, 0.000000, -0.610683, 0.000000, 1.000000}, 
{0.145876, 0.000000, 0.087593, 0.000000, 0.145457, 0.000000, -0.610537, 0.000000, 1.000000}, 
{0.163570, 0.000000, 0.097847, 0.000000, 0.163046, 0.000000, -0.610349, 0.000000, 1.000000}, 
{0.182283, 0.000000, 0.108592, 0.000000, 0.181615, 0.000000, -0.610109, 0.000000, 1.000000}, 
{0.201930, 0.000000, 0.119420, 0.000000, 0.200989, 0.000000, -0.609763, 0.000000, 1.000000}, 
{0.222570, 0.000000, 0.130789, 0.000000, 0.221379, 0.000000, -0.609343, 0.000000, 1.000000}, 
{0.244123, 0.000000, 0.142514, 0.000000, 0.242683, 0.000000, -0.608815, 0.000000, 1.000000}, 
{0.266437, 0.000000, 0.154232, 0.000000, 0.264695, 0.000000, -0.608114, 0.000000, 1.000000}, 
{0.289467, 0.000000, 0.166370, 0.000000, 0.287576, 0.000000, -0.607291, 0.000000, 1.000000}, 
{0.312861, 0.000000, 0.178505, 0.000000, 0.311087, 0.000000, -0.606272, 0.000000, 1.000000}, 
{0.336736, 0.000000, 0.190980, 0.000000, 0.335239, 0.000000, -0.605153, 0.000000, 1.000000}, 
{0.361740, 0.000000, 0.202859, 0.000000, 0.360432, 0.000000, -0.603548, 0.000000, 1.000000}, 
{0.387878, 0.000000, 0.213997, 0.000000, 0.386664, 0.000000, -0.601268, 0.000000, 1.000000}, 
{0.414357, 0.000000, 0.224584, 0.000000, 0.413643, 0.000000, -0.598499, 0.000000, 1.000000}, 
{0.441442, 0.000000, 0.234664, 0.000000, 0.441106, 0.000000, -0.595066, 0.000000, 1.000000}, 
{0.468409, 0.000000, 0.243875, 0.000000, 0.469084, 0.000000, -0.590996, 0.000000, 1.000000}, 
{0.494999, 0.000000, 0.252121, 0.000000, 0.497588, 0.000000, -0.586293, 0.000000, 1.000000}, 
{0.521730, 0.000000, 0.259714, 0.000000, 0.526190, 0.000000, -0.580840, 0.000000, 1.000000}, 
{0.547894, 0.000000, 0.266242, 0.000000, 0.555059, 0.000000, -0.574494, 0.000000, 1.000000}, 
{0.573865, 0.000000, 0.271578, 0.000000, 0.583980, 0.000000, -0.567007, 0.000000, 1.000000}, 
{0.601124, 0.000000, 0.275503, 0.000000, 0.613017, 0.000000, -0.557771, 0.000000, 1.000000}, 
{0.627606, 0.000000, 0.277954, 0.000000, 0.641610, 0.000000, -0.547255, 0.000000, 1.000000}, 
{0.654004, 0.000000, 0.279404, 0.000000, 0.669762, 0.000000, -0.535766, 0.000000, 1.000000}, 
{0.679554, 0.000000, 0.279632, 0.000000, 0.697421, 0.000000, -0.522792, 0.000000, 1.000000}, 
{0.704280, 0.000000, 0.278457, 0.000000, 0.724560, 0.000000, -0.508488, 0.000000, 1.000000}, 
{0.729830, 0.000000, 0.275706, 0.000000, 0.750889, 0.000000, -0.492425, 0.000000, 1.000000}, 
{0.754376, 0.000000, 0.271640, 0.000000, 0.776386, 0.000000, -0.475285, 0.000000, 1.000000}, 
{0.779209, 0.000000, 0.266911, 0.000000, 0.800821, 0.000000, -0.456679, 0.000000, 1.000000}, 
{0.803562, 0.000000, 0.260838, 0.000000, 0.825063, 0.000000, -0.437267, 0.000000, 1.000000}, 
{0.827985, 0.000000, 0.253353, 0.000000, 0.847471, 0.000000, -0.416227, 0.000000, 1.000000}, 
{0.851737, 0.000000, 0.245027, 0.000000, 0.870231, 0.000000, -0.394728, 0.000000, 1.000000}, 
{0.874850, 0.000000, 0.235719, 0.000000, 0.891277, 0.000000, -0.372244, 0.000000, 1.000000}, 
{0.897680, 0.000000, 0.225051, 0.000000, 0.911638, 0.000000, -0.348846, 0.000000, 1.000000}, 
{0.921351, 0.000000, 0.214051, 0.000000, 0.932024, 0.000000, -0.324961, 0.000000, 1.000000}, 
{0.943818, 0.000000, 0.202039, 0.000000, 0.951191, 0.000000, -0.300836, 0.000000, 1.000000}, 
{0.966368, 0.000000, 0.189134, 0.000000, 0.970794, 0.000000, -0.276333, 0.000000, 1.000000}, 
{0.987426, 0.000000, 0.175613, 0.000000, 0.989906, 0.000000, -0.251862, 0.000000, 1.000000}, 
{1.010162, 0.000000, 0.161473, 0.000000, 1.007977, 0.000000, -0.227217, 0.000000, 1.000000}, 
{1.031224, 0.000000, 0.146866, 0.000000, 1.026130, 0.000000, -0.203582, 0.000000, 1.000000}, 
{1.052317, 0.000000, 0.131644, 0.000000, 1.043133, 0.000000, -0.180629, 0.000000, 1.000000}, 
{1.070879, 0.000000, 0.115909, 0.000000, 1.058604, 0.000000, -0.158165, 0.000000, 1.000000}, 
{1.087407, 0.000000, 0.099638, 0.000000, 1.072847, 0.000000, -0.135905, 0.000000, 1.000000}, 
{1.102159, 0.000000, 0.083091, 0.000000, 1.085988, 0.000000, -0.113394, 0.000000, 1.000000}, 
{1.114006, 0.000000, 0.066178, 0.000000, 1.098489, 0.000000, -0.090325, 0.000000, 1.000000}, 
{1.123374, 0.000000, 0.049430, 0.000000, 1.110208, 0.000000, -0.067302, 0.000000, 1.000000}, 
{1.130310, 0.000000, 0.032557, 0.000000, 1.121500, 0.000000, -0.044264, 0.000000, 1.000000}, 
{1.136334, 0.000000, 0.016157, 0.000000, 1.132176, 0.000000, -0.021807, 0.000000, 1.000000}, 
{1.142961, 0.000000, -0.000172, 0.000000, 1.143017, 0.000000, 0.000077, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000129, 0.000000, 0.000200, 0.000000, -0.645866, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000326, 0.000000, 0.000504, 0.000000, -0.645865, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001302, 0.000000, 0.002015, 0.000000, -0.645866, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.002929, 0.000000, 0.004535, 0.000000, -0.645865, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.005207, 0.000000, 0.008063, 0.000000, -0.645864, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.008136, 0.000000, 0.012598, 0.000000, -0.645862, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.011715, 0.000000, 0.018142, 0.000000, -0.645859, 0.000000, 1.000000}, 
{0.024690, 0.000000, 0.015941, 0.000000, 0.024692, 0.000000, -0.645853, 0.000000, 1.000000}, 
{0.032257, 0.000000, 0.020823, 0.000000, 0.032252, 0.000000, -0.645843, 0.000000, 1.000000}, 
{0.040827, 0.000000, 0.026347, 0.000000, 0.040821, 0.000000, -0.645829, 0.000000, 1.000000}, 
{0.050411, 0.000000, 0.032518, 0.000000, 0.050398, 0.000000, -0.645808, 0.000000, 1.000000}, 
{0.061007, 0.000000, 0.039330, 0.000000, 0.060991, 0.000000, -0.645781, 0.000000, 1.000000}, 
{0.072621, 0.000000, 0.046783, 0.000000, 0.072590, 0.000000, -0.645746, 0.000000, 1.000000}, 
{0.085249, 0.000000, 0.054865, 0.000000, 0.085208, 0.000000, -0.645695, 0.000000, 1.000000}, 
{0.098897, 0.000000, 0.063563, 0.000000, 0.098836, 0.000000, -0.645630, 0.000000, 1.000000}, 
{0.113546, 0.000000, 0.072607, 0.000000, 0.113347, 0.000000, -0.645529, 0.000000, 1.000000}, 
{0.129220, 0.000000, 0.082257, 0.000000, 0.128887, 0.000000, -0.645396, 0.000000, 1.000000}, 
{0.145888, 0.000000, 0.092515, 0.000000, 0.145431, 0.000000, -0.645268, 0.000000, 1.000000}, 
{0.163659, 0.000000, 0.103393, 0.000000, 0.163055, 0.000000, -0.645018, 0.000000, 1.000000}, 
{0.182385, 0.000000, 0.114684, 0.000000, 0.181609, 0.000000, -0.644739, 0.000000, 1.000000}, 
{0.202078, 0.000000, 0.126098, 0.000000, 0.200968, 0.000000, -0.644348, 0.000000, 1.000000}, 
{0.222772, 0.000000, 0.138145, 0.000000, 0.221400, 0.000000, -0.643872, 0.000000, 1.000000}, 
{0.244370, 0.000000, 0.150405, 0.000000, 0.242672, 0.000000, -0.643255, 0.000000, 1.000000}, 
{0.266787, 0.000000, 0.162798, 0.000000, 0.264748, 0.000000, -0.642463, 0.000000, 1.000000}, 
{0.289844, 0.000000, 0.175434, 0.000000, 0.287652, 0.000000, -0.641504, 0.000000, 1.000000}, 
{0.313540, 0.000000, 0.188158, 0.000000, 0.311198, 0.000000, -0.640346, 0.000000, 1.000000}, 
{0.337489, 0.000000, 0.201014, 0.000000, 0.335363, 0.000000, -0.639042, 0.000000, 1.000000}, 
{0.362008, 0.000000, 0.213719, 0.000000, 0.360403, 0.000000, -0.637412, 0.000000, 1.000000}, 
{0.387990, 0.000000, 0.225248, 0.000000, 0.386670, 0.000000, -0.634930, 0.000000, 1.000000}, 
{0.414728, 0.000000, 0.236348, 0.000000, 0.413621, 0.000000, -0.631861, 0.000000, 1.000000}, 
{0.441635, 0.000000, 0.246701, 0.000000, 0.441174, 0.000000, -0.628155, 0.000000, 1.000000}, 
{0.468588, 0.000000, 0.256167, 0.000000, 0.469204, 0.000000, -0.623625, 0.000000, 1.000000}, 
{0.495337, 0.000000, 0.264662, 0.000000, 0.497820, 0.000000, -0.618458, 0.000000, 1.000000}, 
{0.521886, 0.000000, 0.272207, 0.000000, 0.526585, 0.000000, -0.612373, 0.000000, 1.000000}, 
{0.548355, 0.000000, 0.278890, 0.000000, 0.555391, 0.000000, -0.605263, 0.000000, 1.000000}, 
{0.574535, 0.000000, 0.284442, 0.000000, 0.584384, 0.000000, -0.597048, 0.000000, 1.000000}, 
{0.600870, 0.000000, 0.288389, 0.000000, 0.613189, 0.000000, -0.587401, 0.000000, 1.000000}, 
{0.627715, 0.000000, 0.290816, 0.000000, 0.642115, 0.000000, -0.576001, 0.000000, 1.000000}, 
{0.653830, 0.000000, 0.291886, 0.000000, 0.670103, 0.000000, -0.563198, 0.000000, 1.000000}, 
{0.679175, 0.000000, 0.291629, 0.000000, 0.698132, 0.000000, -0.549249, 0.000000, 1.000000}, 
{0.704539, 0.000000, 0.290489, 0.000000, 0.724893, 0.000000, -0.533881, 0.000000, 1.000000}, 
{0.729126, 0.000000, 0.287529, 0.000000, 0.750986, 0.000000, -0.516966, 0.000000, 1.000000}, 
{0.754297, 0.000000, 0.283184, 0.000000, 0.776683, 0.000000, -0.498501, 0.000000, 1.000000}, 
{0.778678, 0.000000, 0.277732, 0.000000, 0.801212, 0.000000, -0.478728, 0.000000, 1.000000}, 
{0.802473, 0.000000, 0.271203, 0.000000, 0.824857, 0.000000, -0.457814, 0.000000, 1.000000}, 
{0.826596, 0.000000, 0.263494, 0.000000, 0.847710, 0.000000, -0.435865, 0.000000, 1.000000}, 
{0.850835, 0.000000, 0.254572, 0.000000, 0.869686, 0.000000, -0.412597, 0.000000, 1.000000}, 
{0.874203, 0.000000, 0.244815, 0.000000, 0.890695, 0.000000, -0.388995, 0.000000, 1.000000}, 
{0.897271, 0.000000, 0.233993, 0.000000, 0.911392, 0.000000, -0.364487, 0.000000, 1.000000}, 
{0.919667, 0.000000, 0.221934, 0.000000, 0.931155, 0.000000, -0.339344, 0.000000, 1.000000}, 
{0.943001, 0.000000, 0.209714, 0.000000, 0.950731, 0.000000, -0.313770, 0.000000, 1.000000}, 
{0.965688, 0.000000, 0.196367, 0.000000, 0.969834, 0.000000, -0.287928, 0.000000, 1.000000}, 
{0.987598, 0.000000, 0.182263, 0.000000, 0.988668, 0.000000, -0.262157, 0.000000, 1.000000}, 
{1.009280, 0.000000, 0.167775, 0.000000, 1.007339, 0.000000, -0.236855, 0.000000, 1.000000}, 
{1.031762, 0.000000, 0.152530, 0.000000, 1.025469, 0.000000, -0.211847, 0.000000, 1.000000}, 
{1.051965, 0.000000, 0.136809, 0.000000, 1.042798, 0.000000, -0.187546, 0.000000, 1.000000}, 
{1.071699, 0.000000, 0.120418, 0.000000, 1.058630, 0.000000, -0.164186, 0.000000, 1.000000}, 
{1.088881, 0.000000, 0.103618, 0.000000, 1.073033, 0.000000, -0.141184, 0.000000, 1.000000}, 
{1.103482, 0.000000, 0.086271, 0.000000, 1.086485, 0.000000, -0.117665, 0.000000, 1.000000}, 
{1.115646, 0.000000, 0.068973, 0.000000, 1.099167, 0.000000, -0.093896, 0.000000, 1.000000}, 
{1.125258, 0.000000, 0.051285, 0.000000, 1.111107, 0.000000, -0.069978, 0.000000, 1.000000}, 
{1.132045, 0.000000, 0.033998, 0.000000, 1.122401, 0.000000, -0.046126, 0.000000, 1.000000}, 
{1.138004, 0.000000, 0.016696, 0.000000, 1.133542, 0.000000, -0.022635, 0.000000, 1.000000}, 
{1.144463, 0.000000, -0.000089, 0.000000, 1.144478, 0.000000, 0.000016, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000136, 0.000000, 0.000200, 0.000000, -0.681786, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000344, 0.000000, 0.000504, 0.000000, -0.681785, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.001374, 0.000000, 0.002016, 0.000000, -0.681783, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.003092, 0.000000, 0.004535, 0.000000, -0.681784, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.005496, 0.000000, 0.008062, 0.000000, -0.681784, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.008588, 0.000000, 0.012597, 0.000000, -0.681781, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.012366, 0.000000, 0.018141, 0.000000, -0.681777, 0.000000, 1.000000}, 
{0.024692, 0.000000, 0.016829, 0.000000, 0.024692, 0.000000, -0.681770, 0.000000, 1.000000}, 
{0.032258, 0.000000, 0.021980, 0.000000, 0.032254, 0.000000, -0.681760, 0.000000, 1.000000}, 
{0.040829, 0.000000, 0.027811, 0.000000, 0.040822, 0.000000, -0.681742, 0.000000, 1.000000}, 
{0.050415, 0.000000, 0.034324, 0.000000, 0.050400, 0.000000, -0.681720, 0.000000, 1.000000}, 
{0.061013, 0.000000, 0.041513, 0.000000, 0.060991, 0.000000, -0.681688, 0.000000, 1.000000}, 
{0.072628, 0.000000, 0.049375, 0.000000, 0.072592, 0.000000, -0.681644, 0.000000, 1.000000}, 
{0.085264, 0.000000, 0.057903, 0.000000, 0.085207, 0.000000, -0.681588, 0.000000, 1.000000}, 
{0.098918, 0.000000, 0.067067, 0.000000, 0.098830, 0.000000, -0.681509, 0.000000, 1.000000}, 
{0.113568, 0.000000, 0.076570, 0.000000, 0.113324, 0.000000, -0.681389, 0.000000, 1.000000}, 
{0.129265, 0.000000, 0.086782, 0.000000, 0.128880, 0.000000, -0.681239, 0.000000, 1.000000}, 
{0.145997, 0.000000, 0.097637, 0.000000, 0.145459, 0.000000, -0.681047, 0.000000, 1.000000}, 
{0.163751, 0.000000, 0.109101, 0.000000, 0.163062, 0.000000, -0.680806, 0.000000, 1.000000}, 
{0.182505, 0.000000, 0.120922, 0.000000, 0.181583, 0.000000, -0.680480, 0.000000, 1.000000}, 
{0.202241, 0.000000, 0.133007, 0.000000, 0.200970, 0.000000, -0.680042, 0.000000, 1.000000}, 
{0.222987, 0.000000, 0.145693, 0.000000, 0.221409, 0.000000, -0.679503, 0.000000, 1.000000}, 
{0.244638, 0.000000, 0.158488, 0.000000, 0.242651, 0.000000, -0.678792, 0.000000, 1.000000}, 
{0.267132, 0.000000, 0.171585, 0.000000, 0.264793, 0.000000, -0.677907, 0.000000, 1.000000}, 
{0.290365, 0.000000, 0.184746, 0.000000, 0.287675, 0.000000, -0.676796, 0.000000, 1.000000}, 
{0.314178, 0.000000, 0.198101, 0.000000, 0.311265, 0.000000, -0.675498, 0.000000, 1.000000}, 
{0.338289, 0.000000, 0.211370, 0.000000, 0.335515, 0.000000, -0.673922, 0.000000, 1.000000}, 
{0.362543, 0.000000, 0.224489, 0.000000, 0.360516, 0.000000, -0.672151, 0.000000, 1.000000}, 
{0.388470, 0.000000, 0.236914, 0.000000, 0.386605, 0.000000, -0.669601, 0.000000, 1.000000}, 
{0.415105, 0.000000, 0.248342, 0.000000, 0.413563, 0.000000, -0.666255, 0.000000, 1.000000}, 
{0.441925, 0.000000, 0.258957, 0.000000, 0.441246, 0.000000, -0.662166, 0.000000, 1.000000}, 
{0.468668, 0.000000, 0.268556, 0.000000, 0.469521, 0.000000, -0.657229, 0.000000, 1.000000}, 
{0.495720, 0.000000, 0.277359, 0.000000, 0.498031, 0.000000, -0.651347, 0.000000, 1.000000}, 
{0.522574, 0.000000, 0.285078, 0.000000, 0.526819, 0.000000, -0.644598, 0.000000, 1.000000}, 
{0.548981, 0.000000, 0.291718, 0.000000, 0.555775, 0.000000, -0.636820, 0.000000, 1.000000}, 
{0.574946, 0.000000, 0.297087, 0.000000, 0.584773, 0.000000, -0.627812, 0.000000, 1.000000}, 
{0.600744, 0.000000, 0.301079, 0.000000, 0.613554, 0.000000, -0.617485, 0.000000, 1.000000}, 
{0.627565, 0.000000, 0.303566, 0.000000, 0.642137, 0.000000, -0.605047, 0.000000, 1.000000}, 
{0.653598, 0.000000, 0.304330, 0.000000, 0.670717, 0.000000, -0.591167, 0.000000, 1.000000}, 
{0.679239, 0.000000, 0.303820, 0.000000, 0.698364, 0.000000, -0.576025, 0.000000, 1.000000}, 
{0.704043, 0.000000, 0.302064, 0.000000, 0.725303, 0.000000, -0.559649, 0.000000, 1.000000}, 
{0.728796, 0.000000, 0.299095, 0.000000, 0.751360, 0.000000, -0.541271, 0.000000, 1.000000}, 
{0.753581, 0.000000, 0.294392, 0.000000, 0.776954, 0.000000, -0.521800, 0.000000, 1.000000}, 
{0.778577, 0.000000, 0.288603, 0.000000, 0.801316, 0.000000, -0.500628, 0.000000, 1.000000}, 
{0.802550, 0.000000, 0.281604, 0.000000, 0.825017, 0.000000, -0.478434, 0.000000, 1.000000}, 
{0.825803, 0.000000, 0.273472, 0.000000, 0.847250, 0.000000, -0.455384, 0.000000, 1.000000}, 
{0.849768, 0.000000, 0.264011, 0.000000, 0.869206, 0.000000, -0.430811, 0.000000, 1.000000}, 
{0.873250, 0.000000, 0.253653, 0.000000, 0.890167, 0.000000, -0.405524, 0.000000, 1.000000}, 
{0.896725, 0.000000, 0.242642, 0.000000, 0.910704, 0.000000, -0.380038, 0.000000, 1.000000}, 
{0.919158, 0.000000, 0.230191, 0.000000, 0.930643, 0.000000, -0.353482, 0.000000, 1.000000}, 
{0.942236, 0.000000, 0.217145, 0.000000, 0.949673, 0.000000, -0.326605, 0.000000, 1.000000}, 
{0.965031, 0.000000, 0.203555, 0.000000, 0.968617, 0.000000, -0.299842, 0.000000, 1.000000}, 
{0.987048, 0.000000, 0.188777, 0.000000, 0.987458, 0.000000, -0.272859, 0.000000, 1.000000}, 
{1.008718, 0.000000, 0.173613, 0.000000, 1.006158, 0.000000, -0.246040, 0.000000, 1.000000}, 
{1.031097, 0.000000, 0.157972, 0.000000, 1.024765, 0.000000, -0.219826, 0.000000, 1.000000}, 
{1.052493, 0.000000, 0.141589, 0.000000, 1.042521, 0.000000, -0.194278, 0.000000, 1.000000}, 
{1.071773, 0.000000, 0.124814, 0.000000, 1.058546, 0.000000, -0.169830, 0.000000, 1.000000}, 
{1.089646, 0.000000, 0.107321, 0.000000, 1.073341, 0.000000, -0.146135, 0.000000, 1.000000}, 
{1.104932, 0.000000, 0.089726, 0.000000, 1.086964, 0.000000, -0.122127, 0.000000, 1.000000}, 
{1.117687, 0.000000, 0.071433, 0.000000, 1.100018, 0.000000, -0.097461, 0.000000, 1.000000}, 
{1.127188, 0.000000, 0.053395, 0.000000, 1.112032, 0.000000, -0.072556, 0.000000, 1.000000}, 
{1.134010, 0.000000, 0.035151, 0.000000, 1.123405, 0.000000, -0.047749, 0.000000, 1.000000}, 
{1.139746, 0.000000, 0.017427, 0.000000, 1.134898, 0.000000, -0.023530, 0.000000, 1.000000}, 
{1.146205, 0.000000, -0.000151, 0.000000, 1.146182, 0.000000, 0.000106, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000144, 0.000000, 0.000200, 0.000000, -0.718949, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000362, 0.000000, 0.000504, 0.000000, -0.718947, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001449, 0.000000, 0.002016, 0.000000, -0.718946, 0.000000, 1.000000}, 
{0.004536, 0.000000, 0.003261, 0.000000, 0.004535, 0.000000, -0.718946, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.005796, 0.000000, 0.008063, 0.000000, -0.718945, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.009057, 0.000000, 0.012597, 0.000000, -0.718943, 0.000000, 1.000000}, 
{0.018140, 0.000000, 0.013039, 0.000000, 0.018142, 0.000000, -0.718937, 0.000000, 1.000000}, 
{0.024694, 0.000000, 0.017747, 0.000000, 0.024693, 0.000000, -0.718929, 0.000000, 1.000000}, 
{0.032260, 0.000000, 0.023178, 0.000000, 0.032250, 0.000000, -0.718917, 0.000000, 1.000000}, 
{0.040831, 0.000000, 0.029325, 0.000000, 0.040822, 0.000000, -0.718896, 0.000000, 1.000000}, 
{0.050419, 0.000000, 0.036192, 0.000000, 0.050400, 0.000000, -0.718870, 0.000000, 1.000000}, 
{0.061019, 0.000000, 0.043770, 0.000000, 0.060991, 0.000000, -0.718833, 0.000000, 1.000000}, 
{0.072638, 0.000000, 0.052056, 0.000000, 0.072593, 0.000000, -0.718782, 0.000000, 1.000000}, 
{0.085274, 0.000000, 0.061039, 0.000000, 0.085208, 0.000000, -0.718714, 0.000000, 1.000000}, 
{0.098938, 0.000000, 0.070676, 0.000000, 0.098817, 0.000000, -0.718623, 0.000000, 1.000000}, 
{0.113607, 0.000000, 0.080679, 0.000000, 0.113308, 0.000000, -0.718483, 0.000000, 1.000000}, 
{0.129329, 0.000000, 0.091485, 0.000000, 0.128882, 0.000000, -0.718316, 0.000000, 1.000000}, 
{0.146077, 0.000000, 0.102931, 0.000000, 0.145468, 0.000000, -0.718096, 0.000000, 1.000000}, 
{0.163856, 0.000000, 0.114986, 0.000000, 0.163070, 0.000000, -0.717818, 0.000000, 1.000000}, 
{0.182640, 0.000000, 0.127305, 0.000000, 0.181532, 0.000000, -0.717432, 0.000000, 1.000000}, 
{0.202432, 0.000000, 0.140147, 0.000000, 0.200981, 0.000000, -0.716939, 0.000000, 1.000000}, 
{0.223229, 0.000000, 0.153468, 0.000000, 0.221403, 0.000000, -0.716331, 0.000000, 1.000000}, 
{0.244943, 0.000000, 0.166875, 0.000000, 0.242637, 0.000000, -0.715527, 0.000000, 1.000000}, 
{0.267559, 0.000000, 0.180658, 0.000000, 0.264800, 0.000000, -0.714523, 0.000000, 1.000000}, 
{0.290926, 0.000000, 0.194405, 0.000000, 0.287695, 0.000000, -0.713266, 0.000000, 1.000000}, 
{0.314863, 0.000000, 0.208302, 0.000000, 0.311367, 0.000000, -0.711758, 0.000000, 1.000000}, 
{0.339053, 0.000000, 0.222020, 0.000000, 0.335670, 0.000000, -0.709982, 0.000000, 1.000000}, 
{0.363627, 0.000000, 0.235683, 0.000000, 0.360638, 0.000000, -0.707958, 0.000000, 1.000000}, 
{0.388887, 0.000000, 0.248723, 0.000000, 0.386547, 0.000000, -0.705346, 0.000000, 1.000000}, 
{0.415474, 0.000000, 0.260563, 0.000000, 0.413594, 0.000000, -0.701644, 0.000000, 1.000000}, 
{0.442065, 0.000000, 0.271352, 0.000000, 0.441434, 0.000000, -0.697134, 0.000000, 1.000000}, 
{0.469418, 0.000000, 0.281541, 0.000000, 0.469582, 0.000000, -0.691665, 0.000000, 1.000000}, 
{0.496419, 0.000000, 0.290429, 0.000000, 0.498272, 0.000000, -0.685227, 0.000000, 1.000000}, 
{0.523071, 0.000000, 0.298032, 0.000000, 0.527199, 0.000000, -0.677815, 0.000000, 1.000000}, 
{0.549641, 0.000000, 0.304679, 0.000000, 0.556157, 0.000000, -0.669063, 0.000000, 1.000000}, 
{0.575489, 0.000000, 0.309902, 0.000000, 0.585166, 0.000000, -0.659071, 0.000000, 1.000000}, 
{0.601108, 0.000000, 0.313771, 0.000000, 0.614138, 0.000000, -0.647799, 0.000000, 1.000000}, 
{0.627199, 0.000000, 0.316225, 0.000000, 0.642633, 0.000000, -0.634856, 0.000000, 1.000000}, 
{0.653243, 0.000000, 0.316679, 0.000000, 0.671098, 0.000000, -0.619627, 0.000000, 1.000000}, 
{0.678960, 0.000000, 0.315816, 0.000000, 0.698747, 0.000000, -0.603244, 0.000000, 1.000000}, 
{0.704055, 0.000000, 0.313776, 0.000000, 0.725630, 0.000000, -0.585191, 0.000000, 1.000000}, 
{0.728713, 0.000000, 0.310417, 0.000000, 0.751698, 0.000000, -0.565969, 0.000000, 1.000000}, 
{0.753301, 0.000000, 0.305786, 0.000000, 0.776866, 0.000000, -0.545347, 0.000000, 1.000000}, 
{0.777890, 0.000000, 0.299262, 0.000000, 0.801264, 0.000000, -0.522753, 0.000000, 1.000000}, 
{0.802354, 0.000000, 0.291830, 0.000000, 0.824620, 0.000000, -0.499017, 0.000000, 1.000000}, 
{0.826005, 0.000000, 0.283281, 0.000000, 0.847149, 0.000000, -0.474335, 0.000000, 1.000000}, 
{0.848920, 0.000000, 0.273512, 0.000000, 0.869067, 0.000000, -0.449019, 0.000000, 1.000000}, 
{0.872765, 0.000000, 0.262525, 0.000000, 0.889681, 0.000000, -0.422329, 0.000000, 1.000000}, 
{0.895950, 0.000000, 0.250769, 0.000000, 0.909906, 0.000000, -0.395057, 0.000000, 1.000000}, 
{0.918816, 0.000000, 0.238257, 0.000000, 0.929819, 0.000000, -0.367709, 0.000000, 1.000000}, 
{0.941089, 0.000000, 0.224381, 0.000000, 0.948483, 0.000000, -0.339350, 0.000000, 1.000000}, 
{0.964514, 0.000000, 0.210289, 0.000000, 0.967962, 0.000000, -0.311239, 0.000000, 1.000000}, 
{0.987128, 0.000000, 0.195488, 0.000000, 0.986617, 0.000000, -0.283272, 0.000000, 1.000000}, 
{1.009064, 0.000000, 0.179491, 0.000000, 1.005064, 0.000000, -0.255163, 0.000000, 1.000000}, 
{1.030163, 0.000000, 0.163172, 0.000000, 1.023578, 0.000000, -0.227757, 0.000000, 1.000000}, 
{1.052502, 0.000000, 0.146457, 0.000000, 1.042056, 0.000000, -0.200970, 0.000000, 1.000000}, 
{1.072971, 0.000000, 0.129054, 0.000000, 1.058589, 0.000000, -0.175767, 0.000000, 1.000000}, 
{1.091223, 0.000000, 0.111285, 0.000000, 1.073442, 0.000000, -0.151118, 0.000000, 1.000000}, 
{1.106518, 0.000000, 0.092617, 0.000000, 1.087526, 0.000000, -0.126196, 0.000000, 1.000000}, 
{1.119235, 0.000000, 0.074168, 0.000000, 1.100643, 0.000000, -0.100828, 0.000000, 1.000000}, 
{1.129311, 0.000000, 0.055212, 0.000000, 1.113084, 0.000000, -0.075240, 0.000000, 1.000000}, 
{1.135983, 0.000000, 0.036571, 0.000000, 1.124876, 0.000000, -0.049558, 0.000000, 1.000000}, 
{1.141648, 0.000000, 0.017954, 0.000000, 1.136456, 0.000000, -0.024273, 0.000000, 1.000000}, 
{1.147938, 0.000000, -0.000125, 0.000000, 1.147928, 0.000000, 0.000048, 0.000000, 1.000000}, 
{0.000199, 0.000000, 0.000151, 0.000000, 0.000200, 0.000000, -0.757466, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000382, 0.000000, 0.000504, 0.000000, -0.757466, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001527, 0.000000, 0.002016, 0.000000, -0.757466, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.003435, 0.000000, 0.004535, 0.000000, -0.757466, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.006107, 0.000000, 0.008062, 0.000000, -0.757464, 0.000000, 1.000000}, 
{0.012599, 0.000000, 0.009542, 0.000000, 0.012598, 0.000000, -0.757460, 0.000000, 1.000000}, 
{0.018142, 0.000000, 0.013739, 0.000000, 0.018141, 0.000000, -0.757455, 0.000000, 1.000000}, 
{0.024694, 0.000000, 0.018697, 0.000000, 0.024693, 0.000000, -0.757446, 0.000000, 1.000000}, 
{0.032259, 0.000000, 0.024418, 0.000000, 0.032252, 0.000000, -0.757429, 0.000000, 1.000000}, 
{0.040834, 0.000000, 0.030895, 0.000000, 0.040821, 0.000000, -0.757407, 0.000000, 1.000000}, 
{0.050422, 0.000000, 0.038127, 0.000000, 0.050400, 0.000000, -0.757376, 0.000000, 1.000000}, 
{0.061025, 0.000000, 0.046108, 0.000000, 0.060991, 0.000000, -0.757332, 0.000000, 1.000000}, 
{0.072650, 0.000000, 0.054835, 0.000000, 0.072592, 0.000000, -0.757274, 0.000000, 1.000000}, 
{0.085296, 0.000000, 0.064294, 0.000000, 0.085207, 0.000000, -0.757195, 0.000000, 1.000000}, 
{0.098962, 0.000000, 0.074376, 0.000000, 0.098790, 0.000000, -0.757087, 0.000000, 1.000000}, 
{0.113649, 0.000000, 0.084955, 0.000000, 0.113305, 0.000000, -0.756925, 0.000000, 1.000000}, 
{0.129389, 0.000000, 0.096334, 0.000000, 0.128880, 0.000000, -0.756729, 0.000000, 1.000000}, 
{0.146167, 0.000000, 0.108406, 0.000000, 0.145478, 0.000000, -0.756481, 0.000000, 1.000000}, 
{0.163973, 0.000000, 0.121056, 0.000000, 0.163067, 0.000000, -0.756158, 0.000000, 1.000000}, 
{0.182798, 0.000000, 0.133970, 0.000000, 0.181503, 0.000000, -0.755715, 0.000000, 1.000000}, 
{0.202650, 0.000000, 0.147522, 0.000000, 0.200973, 0.000000, -0.755167, 0.000000, 1.000000}, 
{0.223502, 0.000000, 0.161466, 0.000000, 0.221378, 0.000000, -0.754465, 0.000000, 1.000000}, 
{0.245269, 0.000000, 0.175539, 0.000000, 0.242638, 0.000000, -0.753552, 0.000000, 1.000000}, 
{0.268010, 0.000000, 0.189957, 0.000000, 0.264777, 0.000000, -0.752420, 0.000000, 1.000000}, 
{0.291474, 0.000000, 0.204361, 0.000000, 0.287713, 0.000000, -0.751008, 0.000000, 1.000000}, 
{0.315527, 0.000000, 0.218714, 0.000000, 0.311386, 0.000000, -0.749266, 0.000000, 1.000000}, 
{0.339954, 0.000000, 0.233029, 0.000000, 0.335788, 0.000000, -0.747232, 0.000000, 1.000000}, 
{0.364649, 0.000000, 0.247149, 0.000000, 0.360785, 0.000000, -0.744906, 0.000000, 1.000000}, 
{0.389520, 0.000000, 0.260672, 0.000000, 0.386650, 0.000000, -0.742123, 0.000000, 1.000000}, 
{0.415717, 0.000000, 0.272873, 0.000000, 0.413700, 0.000000, -0.738187, 0.000000, 1.000000}, 
{0.442862, 0.000000, 0.284317, 0.000000, 0.441376, 0.000000, -0.733189, 0.000000, 1.000000}, 
{0.469939, 0.000000, 0.294552, 0.000000, 0.469683, 0.000000, -0.727165, 0.000000, 1.000000}, 
{0.496916, 0.000000, 0.303517, 0.000000, 0.498497, 0.000000, -0.720043, 0.000000, 1.000000}, 
{0.523480, 0.000000, 0.311061, 0.000000, 0.527438, 0.000000, -0.711640, 0.000000, 1.000000}, 
{0.550092, 0.000000, 0.317596, 0.000000, 0.556574, 0.000000, -0.702174, 0.000000, 1.000000}, 
{0.576384, 0.000000, 0.322921, 0.000000, 0.585747, 0.000000, -0.691225, 0.000000, 1.000000}, 
{0.602280, 0.000000, 0.326806, 0.000000, 0.614418, 0.000000, -0.678841, 0.000000, 1.000000}, 
{0.627676, 0.000000, 0.329057, 0.000000, 0.642937, 0.000000, -0.664815, 0.000000, 1.000000}, 
{0.653458, 0.000000, 0.329372, 0.000000, 0.671172, 0.000000, -0.648548, 0.000000, 1.000000}, 
{0.679227, 0.000000, 0.328067, 0.000000, 0.698772, 0.000000, -0.630676, 0.000000, 1.000000}, 
{0.704476, 0.000000, 0.325585, 0.000000, 0.726118, 0.000000, -0.611585, 0.000000, 1.000000}, 
{0.729232, 0.000000, 0.321775, 0.000000, 0.751701, 0.000000, -0.590803, 0.000000, 1.000000}, 
{0.753405, 0.000000, 0.316713, 0.000000, 0.777081, 0.000000, -0.568653, 0.000000, 1.000000}, 
{0.777274, 0.000000, 0.309858, 0.000000, 0.801030, 0.000000, -0.544763, 0.000000, 1.000000}, 
{0.801882, 0.000000, 0.301866, 0.000000, 0.824522, 0.000000, -0.519747, 0.000000, 1.000000}, 
{0.826030, 0.000000, 0.292861, 0.000000, 0.847135, 0.000000, -0.493531, 0.000000, 1.000000}, 
{0.849359, 0.000000, 0.282794, 0.000000, 0.868777, 0.000000, -0.466900, 0.000000, 1.000000}, 
{0.871837, 0.000000, 0.271197, 0.000000, 0.889423, 0.000000, -0.439230, 0.000000, 1.000000}, 
{0.895896, 0.000000, 0.258954, 0.000000, 0.909175, 0.000000, -0.410570, 0.000000, 1.000000}, 
{0.918951, 0.000000, 0.245878, 0.000000, 0.928951, 0.000000, -0.381314, 0.000000, 1.000000}, 
{0.941148, 0.000000, 0.231897, 0.000000, 0.948180, 0.000000, -0.352268, 0.000000, 1.000000}, 
{0.963464, 0.000000, 0.216743, 0.000000, 0.966827, 0.000000, -0.322688, 0.000000, 1.000000}, 
{0.986628, 0.000000, 0.201486, 0.000000, 0.985573, 0.000000, -0.293523, 0.000000, 1.000000}, 
{1.009289, 0.000000, 0.185521, 0.000000, 1.004488, 0.000000, -0.264125, 0.000000, 1.000000}, 
{1.030659, 0.000000, 0.168429, 0.000000, 1.022674, 0.000000, -0.235706, 0.000000, 1.000000}, 
{1.052382, 0.000000, 0.151210, 0.000000, 1.041197, 0.000000, -0.208022, 0.000000, 1.000000}, 
{1.073476, 0.000000, 0.133289, 0.000000, 1.058946, 0.000000, -0.181245, 0.000000, 1.000000}, 
{1.092237, 0.000000, 0.114768, 0.000000, 1.074036, 0.000000, -0.155661, 0.000000, 1.000000}, 
{1.108200, 0.000000, 0.095917, 0.000000, 1.088052, 0.000000, -0.130223, 0.000000, 1.000000}, 
{1.121435, 0.000000, 0.076492, 0.000000, 1.101450, 0.000000, -0.104098, 0.000000, 1.000000}, 
{1.131382, 0.000000, 0.057204, 0.000000, 1.114122, 0.000000, -0.077776, 0.000000, 1.000000}, 
{1.137994, 0.000000, 0.037747, 0.000000, 1.126202, 0.000000, -0.051250, 0.000000, 1.000000}, 
{1.143441, 0.000000, 0.018673, 0.000000, 1.137871, 0.000000, -0.025245, 0.000000, 1.000000}, 
{1.149714, 0.000000, -0.000216, 0.000000, 1.149709, 0.000000, 0.000120, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000159, 0.000000, 0.000200, 0.000000, -0.797469, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000402, 0.000000, 0.000504, 0.000000, -0.797469, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001607, 0.000000, 0.002016, 0.000000, -0.797467, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.003617, 0.000000, 0.004535, 0.000000, -0.797468, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.006430, 0.000000, 0.008062, 0.000000, -0.797467, 0.000000, 1.000000}, 
{0.012599, 0.000000, 0.010046, 0.000000, 0.012597, 0.000000, -0.797462, 0.000000, 1.000000}, 
{0.018141, 0.000000, 0.014464, 0.000000, 0.018142, 0.000000, -0.797457, 0.000000, 1.000000}, 
{0.024696, 0.000000, 0.019685, 0.000000, 0.024693, 0.000000, -0.797445, 0.000000, 1.000000}, 
{0.032259, 0.000000, 0.025705, 0.000000, 0.032253, 0.000000, -0.797426, 0.000000, 1.000000}, 
{0.040835, 0.000000, 0.032523, 0.000000, 0.040822, 0.000000, -0.797401, 0.000000, 1.000000}, 
{0.050425, 0.000000, 0.040135, 0.000000, 0.050400, 0.000000, -0.797363, 0.000000, 1.000000}, 
{0.061033, 0.000000, 0.048536, 0.000000, 0.060991, 0.000000, -0.797313, 0.000000, 1.000000}, 
{0.072661, 0.000000, 0.057718, 0.000000, 0.072593, 0.000000, -0.797243, 0.000000, 1.000000}, 
{0.085315, 0.000000, 0.067666, 0.000000, 0.085207, 0.000000, -0.797150, 0.000000, 1.000000}, 
{0.098985, 0.000000, 0.078179, 0.000000, 0.098751, 0.000000, -0.797016, 0.000000, 1.000000}, 
{0.113699, 0.000000, 0.089383, 0.000000, 0.113293, 0.000000, -0.796839, 0.000000, 1.000000}, 
{0.129456, 0.000000, 0.101364, 0.000000, 0.128879, 0.000000, -0.796623, 0.000000, 1.000000}, 
{0.146275, 0.000000, 0.114081, 0.000000, 0.145485, 0.000000, -0.796331, 0.000000, 1.000000}, 
{0.164108, 0.000000, 0.127318, 0.000000, 0.163047, 0.000000, -0.795956, 0.000000, 1.000000}, 
{0.182983, 0.000000, 0.140901, 0.000000, 0.181487, 0.000000, -0.795458, 0.000000, 1.000000}, 
{0.202891, 0.000000, 0.155174, 0.000000, 0.200985, 0.000000, -0.794834, 0.000000, 1.000000}, 
{0.223787, 0.000000, 0.169654, 0.000000, 0.221336, 0.000000, -0.794015, 0.000000, 1.000000}, 
{0.245678, 0.000000, 0.184540, 0.000000, 0.242633, 0.000000, -0.793013, 0.000000, 1.000000}, 
{0.268495, 0.000000, 0.199543, 0.000000, 0.264760, 0.000000, -0.791727, 0.000000, 1.000000}, 
{0.292093, 0.000000, 0.214639, 0.000000, 0.287718, 0.000000, -0.790107, 0.000000, 1.000000}, 
{0.316184, 0.000000, 0.229499, 0.000000, 0.311432, 0.000000, -0.788154, 0.000000, 1.000000}, 
{0.340986, 0.000000, 0.244407, 0.000000, 0.335838, 0.000000, -0.785797, 0.000000, 1.000000}, 
{0.365808, 0.000000, 0.258907, 0.000000, 0.360981, 0.000000, -0.783093, 0.000000, 1.000000}, 
{0.390528, 0.000000, 0.272746, 0.000000, 0.386843, 0.000000, -0.779970, 0.000000, 1.000000}, 
{0.416510, 0.000000, 0.285845, 0.000000, 0.413585, 0.000000, -0.775852, 0.000000, 1.000000}, 
{0.443443, 0.000000, 0.297404, 0.000000, 0.441451, 0.000000, -0.770323, 0.000000, 1.000000}, 
{0.470442, 0.000000, 0.307757, 0.000000, 0.469847, 0.000000, -0.763721, 0.000000, 1.000000}, 
{0.497499, 0.000000, 0.316846, 0.000000, 0.498700, 0.000000, -0.755889, 0.000000, 1.000000}, 
{0.524316, 0.000000, 0.324561, 0.000000, 0.527843, 0.000000, -0.746662, 0.000000, 1.000000}, 
{0.551212, 0.000000, 0.331060, 0.000000, 0.556860, 0.000000, -0.736004, 0.000000, 1.000000}, 
{0.577323, 0.000000, 0.335956, 0.000000, 0.585911, 0.000000, -0.723810, 0.000000, 1.000000}, 
{0.602976, 0.000000, 0.339501, 0.000000, 0.614732, 0.000000, -0.710184, 0.000000, 1.000000}, 
{0.628357, 0.000000, 0.341577, 0.000000, 0.643279, 0.000000, -0.695017, 0.000000, 1.000000}, 
{0.653642, 0.000000, 0.342031, 0.000000, 0.671344, 0.000000, -0.677972, 0.000000, 1.000000}, 
{0.679440, 0.000000, 0.340342, 0.000000, 0.699180, 0.000000, -0.658877, 0.000000, 1.000000}, 
{0.704744, 0.000000, 0.337356, 0.000000, 0.726025, 0.000000, -0.638085, 0.000000, 1.000000}, 
{0.729692, 0.000000, 0.333042, 0.000000, 0.751816, 0.000000, -0.615615, 0.000000, 1.000000}, 
{0.753920, 0.000000, 0.327504, 0.000000, 0.777060, 0.000000, -0.592054, 0.000000, 1.000000}, 
{0.777695, 0.000000, 0.320537, 0.000000, 0.800995, 0.000000, -0.566967, 0.000000, 1.000000}, 
{0.801426, 0.000000, 0.311880, 0.000000, 0.824254, 0.000000, -0.540643, 0.000000, 1.000000}, 
{0.825649, 0.000000, 0.302211, 0.000000, 0.846735, 0.000000, -0.512906, 0.000000, 1.000000}, 
{0.849282, 0.000000, 0.291665, 0.000000, 0.868007, 0.000000, -0.484587, 0.000000, 1.000000}, 
{0.872341, 0.000000, 0.280050, 0.000000, 0.888447, 0.000000, -0.455556, 0.000000, 1.000000}, 
{0.895110, 0.000000, 0.266978, 0.000000, 0.908602, 0.000000, -0.425652, 0.000000, 1.000000}, 
{0.918841, 0.000000, 0.253326, 0.000000, 0.928459, 0.000000, -0.395015, 0.000000, 1.000000}, 
{0.941209, 0.000000, 0.238899, 0.000000, 0.946868, 0.000000, -0.364948, 0.000000, 1.000000}, 
{0.963142, 0.000000, 0.223523, 0.000000, 0.965405, 0.000000, -0.334151, 0.000000, 1.000000}, 
{0.985996, 0.000000, 0.207346, 0.000000, 0.984367, 0.000000, -0.303708, 0.000000, 1.000000}, 
{1.008718, 0.000000, 0.190889, 0.000000, 1.003383, 0.000000, -0.273008, 0.000000, 1.000000}, 
{1.030554, 0.000000, 0.173517, 0.000000, 1.021946, 0.000000, -0.243221, 0.000000, 1.000000}, 
{1.053085, 0.000000, 0.155645, 0.000000, 1.040832, 0.000000, -0.214426, 0.000000, 1.000000}, 
{1.074267, 0.000000, 0.137472, 0.000000, 1.058373, 0.000000, -0.187036, 0.000000, 1.000000}, 
{1.093591, 0.000000, 0.118385, 0.000000, 1.074495, 0.000000, -0.160512, 0.000000, 1.000000}, 
{1.109850, 0.000000, 0.098883, 0.000000, 1.088703, 0.000000, -0.134384, 0.000000, 1.000000}, 
{1.123516, 0.000000, 0.079050, 0.000000, 1.102503, 0.000000, -0.107424, 0.000000, 1.000000}, 
{1.133578, 0.000000, 0.058977, 0.000000, 1.115295, 0.000000, -0.080317, 0.000000, 1.000000}, 
{1.140289, 0.000000, 0.039013, 0.000000, 1.127588, 0.000000, -0.052944, 0.000000, 1.000000}, 
{1.145610, 0.000000, 0.019228, 0.000000, 1.139621, 0.000000, -0.025989, 0.000000, 1.000000}, 
{1.151704, 0.000000, -0.000105, 0.000000, 1.151726, 0.000000, 0.000019, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000168, 0.000000, 0.000200, 0.000000, -0.839096, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000423, 0.000000, 0.000504, 0.000000, -0.839097, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001691, 0.000000, 0.002016, 0.000000, -0.839091, 0.000000, 1.000000}, 
{0.004534, 0.000000, 0.003805, 0.000000, 0.004535, 0.000000, -0.839094, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.006765, 0.000000, 0.008062, 0.000000, -0.839092, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.010570, 0.000000, 0.012598, 0.000000, -0.839087, 0.000000, 1.000000}, 
{0.018142, 0.000000, 0.015219, 0.000000, 0.018142, 0.000000, -0.839079, 0.000000, 1.000000}, 
{0.024697, 0.000000, 0.020712, 0.000000, 0.024692, 0.000000, -0.839066, 0.000000, 1.000000}, 
{0.032261, 0.000000, 0.027046, 0.000000, 0.032253, 0.000000, -0.839045, 0.000000, 1.000000}, 
{0.040837, 0.000000, 0.034218, 0.000000, 0.040823, 0.000000, -0.839014, 0.000000, 1.000000}, 
{0.050429, 0.000000, 0.042224, 0.000000, 0.050401, 0.000000, -0.838972, 0.000000, 1.000000}, 
{0.061041, 0.000000, 0.051061, 0.000000, 0.060991, 0.000000, -0.838912, 0.000000, 1.000000}, 
{0.072676, 0.000000, 0.060717, 0.000000, 0.072593, 0.000000, -0.838831, 0.000000, 1.000000}, 
{0.085340, 0.000000, 0.071175, 0.000000, 0.085204, 0.000000, -0.838724, 0.000000, 1.000000}, 
{0.099023, 0.000000, 0.082182, 0.000000, 0.098730, 0.000000, -0.838567, 0.000000, 1.000000}, 
{0.113759, 0.000000, 0.094007, 0.000000, 0.113293, 0.000000, -0.838367, 0.000000, 1.000000}, 
{0.129546, 0.000000, 0.106621, 0.000000, 0.128885, 0.000000, -0.838112, 0.000000, 1.000000}, 
{0.146382, 0.000000, 0.119956, 0.000000, 0.145485, 0.000000, -0.837782, 0.000000, 1.000000}, 
{0.164260, 0.000000, 0.133760, 0.000000, 0.163000, 0.000000, -0.837346, 0.000000, 1.000000}, 
{0.183188, 0.000000, 0.148108, 0.000000, 0.181486, 0.000000, -0.836780, 0.000000, 1.000000}, 
{0.203158, 0.000000, 0.163075, 0.000000, 0.200977, 0.000000, -0.836073, 0.000000, 1.000000}, 
{0.224147, 0.000000, 0.178255, 0.000000, 0.221321, 0.000000, -0.835148, 0.000000, 1.000000}, 
{0.246147, 0.000000, 0.193900, 0.000000, 0.242636, 0.000000, -0.833992, 0.000000, 1.000000}, 
{0.269072, 0.000000, 0.209553, 0.000000, 0.264753, 0.000000, -0.832546, 0.000000, 1.000000}, 
{0.292718, 0.000000, 0.225226, 0.000000, 0.287726, 0.000000, -0.830727, 0.000000, 1.000000}, 
{0.317159, 0.000000, 0.240836, 0.000000, 0.311458, 0.000000, -0.828510, 0.000000, 1.000000}, 
{0.341979, 0.000000, 0.256103, 0.000000, 0.335926, 0.000000, -0.825843, 0.000000, 1.000000}, 
{0.366844, 0.000000, 0.270887, 0.000000, 0.361123, 0.000000, -0.822760, 0.000000, 1.000000}, 
{0.392043, 0.000000, 0.285324, 0.000000, 0.386948, 0.000000, -0.819159, 0.000000, 1.000000}, 
{0.417356, 0.000000, 0.298817, 0.000000, 0.413664, 0.000000, -0.814788, 0.000000, 1.000000}, 
{0.444093, 0.000000, 0.310711, 0.000000, 0.441460, 0.000000, -0.808751, 0.000000, 1.000000}, 
{0.471379, 0.000000, 0.321410, 0.000000, 0.469791, 0.000000, -0.801294, 0.000000, 1.000000}, 
{0.498267, 0.000000, 0.330421, 0.000000, 0.498772, 0.000000, -0.792711, 0.000000, 1.000000}, 
{0.525401, 0.000000, 0.338331, 0.000000, 0.527930, 0.000000, -0.782480, 0.000000, 1.000000}, 
{0.551846, 0.000000, 0.344430, 0.000000, 0.557089, 0.000000, -0.770659, 0.000000, 1.000000}, 
{0.578009, 0.000000, 0.349047, 0.000000, 0.586216, 0.000000, -0.757348, 0.000000, 1.000000}, 
{0.604054, 0.000000, 0.352490, 0.000000, 0.615079, 0.000000, -0.742541, 0.000000, 1.000000}, 
{0.629387, 0.000000, 0.354158, 0.000000, 0.643607, 0.000000, -0.726071, 0.000000, 1.000000}, 
{0.654435, 0.000000, 0.354422, 0.000000, 0.671685, 0.000000, -0.707524, 0.000000, 1.000000}, 
{0.679845, 0.000000, 0.352663, 0.000000, 0.699249, 0.000000, -0.687067, 0.000000, 1.000000}, 
{0.704892, 0.000000, 0.348994, 0.000000, 0.725900, 0.000000, -0.664637, 0.000000, 1.000000}, 
{0.729763, 0.000000, 0.344105, 0.000000, 0.751757, 0.000000, -0.640663, 0.000000, 1.000000}, 
{0.754345, 0.000000, 0.338129, 0.000000, 0.776631, 0.000000, -0.615484, 0.000000, 1.000000}, 
{0.778629, 0.000000, 0.330905, 0.000000, 0.800753, 0.000000, -0.589210, 0.000000, 1.000000}, 
{0.801939, 0.000000, 0.322113, 0.000000, 0.824295, 0.000000, -0.561550, 0.000000, 1.000000}, 
{0.825723, 0.000000, 0.311673, 0.000000, 0.846512, 0.000000, -0.532175, 0.000000, 1.000000}, 
{0.849387, 0.000000, 0.300410, 0.000000, 0.867491, 0.000000, -0.502055, 0.000000, 1.000000}, 
{0.872792, 0.000000, 0.288328, 0.000000, 0.887817, 0.000000, -0.471308, 0.000000, 1.000000}, 
{0.895083, 0.000000, 0.275087, 0.000000, 0.907734, 0.000000, -0.440427, 0.000000, 1.000000}, 
{0.918335, 0.000000, 0.260700, 0.000000, 0.927173, 0.000000, -0.409260, 0.000000, 1.000000}, 
{0.941577, 0.000000, 0.245717, 0.000000, 0.946186, 0.000000, -0.377142, 0.000000, 1.000000}, 
{0.963992, 0.000000, 0.230079, 0.000000, 0.965066, 0.000000, -0.345289, 0.000000, 1.000000}, 
{0.986510, 0.000000, 0.213523, 0.000000, 0.983167, 0.000000, -0.313508, 0.000000, 1.000000}, 
{1.008806, 0.000000, 0.196157, 0.000000, 1.001981, 0.000000, -0.281962, 0.000000, 1.000000}, 
{1.030724, 0.000000, 0.178467, 0.000000, 1.021183, 0.000000, -0.251177, 0.000000, 1.000000}, 
{1.053782, 0.000000, 0.160291, 0.000000, 1.040253, 0.000000, -0.220986, 0.000000, 1.000000}, 
{1.075451, 0.000000, 0.141308, 0.000000, 1.058335, 0.000000, -0.192256, 0.000000, 1.000000}, 
{1.094947, 0.000000, 0.121975, 0.000000, 1.074561, 0.000000, -0.165023, 0.000000, 1.000000}, 
{1.111783, 0.000000, 0.101744, 0.000000, 1.089564, 0.000000, -0.138228, 0.000000, 1.000000}, 
{1.125525, 0.000000, 0.081476, 0.000000, 1.103389, 0.000000, -0.110679, 0.000000, 1.000000}, 
{1.135873, 0.000000, 0.060770, 0.000000, 1.116671, 0.000000, -0.082672, 0.000000, 1.000000}, 
{1.142478, 0.000000, 0.040207, 0.000000, 1.129046, 0.000000, -0.054506, 0.000000, 1.000000}, 
{1.147889, 0.000000, 0.019908, 0.000000, 1.141388, 0.000000, -0.026938, 0.000000, 1.000000}, 
{1.153852, 0.000000, -0.000204, 0.000000, 1.153872, 0.000000, 0.000123, 0.000000, 1.000000}, 
{0.000199, 0.000000, 0.000176, 0.000000, 0.000200, 0.000000, -0.882501, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000445, 0.000000, 0.000504, 0.000000, -0.882504, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001779, 0.000000, 0.002015, 0.000000, -0.882498, 0.000000, 1.000000}, 
{0.004536, 0.000000, 0.004003, 0.000000, 0.004534, 0.000000, -0.882499, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.007115, 0.000000, 0.008063, 0.000000, -0.882496, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.011116, 0.000000, 0.012598, 0.000000, -0.882492, 0.000000, 1.000000}, 
{0.018142, 0.000000, 0.016005, 0.000000, 0.018142, 0.000000, -0.882481, 0.000000, 1.000000}, 
{0.024696, 0.000000, 0.021782, 0.000000, 0.024693, 0.000000, -0.882466, 0.000000, 1.000000}, 
{0.032262, 0.000000, 0.028444, 0.000000, 0.032253, 0.000000, -0.882442, 0.000000, 1.000000}, 
{0.040842, 0.000000, 0.035987, 0.000000, 0.040822, 0.000000, -0.882408, 0.000000, 1.000000}, 
{0.050436, 0.000000, 0.044404, 0.000000, 0.050402, 0.000000, -0.882364, 0.000000, 1.000000}, 
{0.061053, 0.000000, 0.053695, 0.000000, 0.060991, 0.000000, -0.882287, 0.000000, 1.000000}, 
{0.072692, 0.000000, 0.063842, 0.000000, 0.072591, 0.000000, -0.882190, 0.000000, 1.000000}, 
{0.085364, 0.000000, 0.074821, 0.000000, 0.085201, 0.000000, -0.882067, 0.000000, 1.000000}, 
{0.099064, 0.000000, 0.086368, 0.000000, 0.098717, 0.000000, -0.881884, 0.000000, 1.000000}, 
{0.113828, 0.000000, 0.098805, 0.000000, 0.113280, 0.000000, -0.881657, 0.000000, 1.000000}, 
{0.129649, 0.000000, 0.112090, 0.000000, 0.128890, 0.000000, -0.881361, 0.000000, 1.000000}, 
{0.146518, 0.000000, 0.126067, 0.000000, 0.145477, 0.000000, -0.880982, 0.000000, 1.000000}, 
{0.164440, 0.000000, 0.140493, 0.000000, 0.162968, 0.000000, -0.880484, 0.000000, 1.000000}, 
{0.183437, 0.000000, 0.155646, 0.000000, 0.181488, 0.000000, -0.879843, 0.000000, 1.000000}, 
{0.203468, 0.000000, 0.171266, 0.000000, 0.200952, 0.000000, -0.879035, 0.000000, 1.000000}, 
{0.224562, 0.000000, 0.187231, 0.000000, 0.221305, 0.000000, -0.877982, 0.000000, 1.000000}, 
{0.246665, 0.000000, 0.203540, 0.000000, 0.242594, 0.000000, -0.876667, 0.000000, 1.000000}, 
{0.269652, 0.000000, 0.219916, 0.000000, 0.264751, 0.000000, -0.875028, 0.000000, 1.000000}, 
{0.293531, 0.000000, 0.236255, 0.000000, 0.287693, 0.000000, -0.872977, 0.000000, 1.000000}, 
{0.318048, 0.000000, 0.252410, 0.000000, 0.311435, 0.000000, -0.870448, 0.000000, 1.000000}, 
{0.342963, 0.000000, 0.268192, 0.000000, 0.335993, 0.000000, -0.867400, 0.000000, 1.000000}, 
{0.368336, 0.000000, 0.283587, 0.000000, 0.361184, 0.000000, -0.863882, 0.000000, 1.000000}, 
{0.393512, 0.000000, 0.298186, 0.000000, 0.387141, 0.000000, -0.859724, 0.000000, 1.000000}, 
{0.418602, 0.000000, 0.311882, 0.000000, 0.413873, 0.000000, -0.854835, 0.000000, 1.000000}, 
{0.445080, 0.000000, 0.324500, 0.000000, 0.441336, 0.000000, -0.848353, 0.000000, 1.000000}, 
{0.472289, 0.000000, 0.335295, 0.000000, 0.469768, 0.000000, -0.840218, 0.000000, 1.000000}, 
{0.499128, 0.000000, 0.344256, 0.000000, 0.498811, 0.000000, -0.830556, 0.000000, 1.000000}, 
{0.525834, 0.000000, 0.351716, 0.000000, 0.528177, 0.000000, -0.819269, 0.000000, 1.000000}, 
{0.553177, 0.000000, 0.358241, 0.000000, 0.557104, 0.000000, -0.806222, 0.000000, 1.000000}, 
{0.579480, 0.000000, 0.362640, 0.000000, 0.586361, 0.000000, -0.791647, 0.000000, 1.000000}, 
{0.605205, 0.000000, 0.365513, 0.000000, 0.615297, 0.000000, -0.775398, 0.000000, 1.000000}, 
{0.630617, 0.000000, 0.366822, 0.000000, 0.643787, 0.000000, -0.757144, 0.000000, 1.000000}, 
{0.655730, 0.000000, 0.366785, 0.000000, 0.671619, 0.000000, -0.737323, 0.000000, 1.000000}, 
{0.680529, 0.000000, 0.364904, 0.000000, 0.698930, 0.000000, -0.715601, 0.000000, 1.000000}, 
{0.705800, 0.000000, 0.360990, 0.000000, 0.725790, 0.000000, -0.691547, 0.000000, 1.000000}, 
{0.730550, 0.000000, 0.355397, 0.000000, 0.751972, 0.000000, -0.666141, 0.000000, 1.000000}, 
{0.754970, 0.000000, 0.348664, 0.000000, 0.776630, 0.000000, -0.638929, 0.000000, 1.000000}, 
{0.779042, 0.000000, 0.340774, 0.000000, 0.800720, 0.000000, -0.611015, 0.000000, 1.000000}, 
{0.802839, 0.000000, 0.331767, 0.000000, 0.823200, 0.000000, -0.581877, 0.000000, 1.000000}, 
{0.825793, 0.000000, 0.321054, 0.000000, 0.845713, 0.000000, -0.551509, 0.000000, 1.000000}, 
{0.849512, 0.000000, 0.309016, 0.000000, 0.866985, 0.000000, -0.519698, 0.000000, 1.000000}, 
{0.873120, 0.000000, 0.296369, 0.000000, 0.887115, 0.000000, -0.487506, 0.000000, 1.000000}, 
{0.895942, 0.000000, 0.282704, 0.000000, 0.907056, 0.000000, -0.455320, 0.000000, 1.000000}, 
{0.917996, 0.000000, 0.268007, 0.000000, 0.926171, 0.000000, -0.422605, 0.000000, 1.000000}, 
{0.941281, 0.000000, 0.252329, 0.000000, 0.944988, 0.000000, -0.389347, 0.000000, 1.000000}, 
{0.964584, 0.000000, 0.236203, 0.000000, 0.963970, 0.000000, -0.356430, 0.000000, 1.000000}, 
{0.986371, 0.000000, 0.219209, 0.000000, 0.982539, 0.000000, -0.323089, 0.000000, 1.000000}, 
{1.009522, 0.000000, 0.201588, 0.000000, 1.001129, 0.000000, -0.290806, 0.000000, 1.000000}, 
{1.031976, 0.000000, 0.183296, 0.000000, 1.020220, 0.000000, -0.258682, 0.000000, 1.000000}, 
{1.053461, 0.000000, 0.164509, 0.000000, 1.039428, 0.000000, -0.227722, 0.000000, 1.000000}, 
{1.076121, 0.000000, 0.145165, 0.000000, 1.058506, 0.000000, -0.197439, 0.000000, 1.000000}, 
{1.096597, 0.000000, 0.125199, 0.000000, 1.075241, 0.000000, -0.169578, 0.000000, 1.000000}, 
{1.113908, 0.000000, 0.104921, 0.000000, 1.090101, 0.000000, -0.142222, 0.000000, 1.000000}, 
{1.127939, 0.000000, 0.083623, 0.000000, 1.104533, 0.000000, -0.113802, 0.000000, 1.000000}, 
{1.138391, 0.000000, 0.062589, 0.000000, 1.117666, 0.000000, -0.085164, 0.000000, 1.000000}, 
{1.145110, 0.000000, 0.041376, 0.000000, 1.130694, 0.000000, -0.056186, 0.000000, 1.000000}, 
{1.150141, 0.000000, 0.020433, 0.000000, 1.143274, 0.000000, -0.027654, 0.000000, 1.000000}, 
{1.156069, 0.000000, -0.000097, 0.000000, 1.156128, 0.000000, 0.000046, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000185, 0.000000, 0.000200, 0.000000, -0.927857, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000468, 0.000000, 0.000504, 0.000000, -0.927859, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.001870, 0.000000, 0.002016, 0.000000, -0.927855, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.004208, 0.000000, 0.004535, 0.000000, -0.927867, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.007480, 0.000000, 0.008063, 0.000000, -0.927855, 0.000000, 1.000000}, 
{0.012594, 0.000000, 0.011683, 0.000000, 0.012599, 0.000000, -0.927851, 0.000000, 1.000000}, 
{0.018142, 0.000000, 0.016828, 0.000000, 0.018141, 0.000000, -0.927839, 0.000000, 1.000000}, 
{0.024698, 0.000000, 0.022901, 0.000000, 0.024692, 0.000000, -0.927818, 0.000000, 1.000000}, 
{0.032263, 0.000000, 0.029903, 0.000000, 0.032253, 0.000000, -0.927791, 0.000000, 1.000000}, 
{0.040846, 0.000000, 0.037834, 0.000000, 0.040822, 0.000000, -0.927751, 0.000000, 1.000000}, 
{0.050440, 0.000000, 0.046680, 0.000000, 0.050405, 0.000000, -0.927690, 0.000000, 1.000000}, 
{0.061066, 0.000000, 0.056446, 0.000000, 0.060994, 0.000000, -0.927610, 0.000000, 1.000000}, 
{0.072713, 0.000000, 0.067109, 0.000000, 0.072595, 0.000000, -0.927505, 0.000000, 1.000000}, 
{0.085393, 0.000000, 0.078613, 0.000000, 0.085190, 0.000000, -0.927357, 0.000000, 1.000000}, 
{0.099120, 0.000000, 0.090747, 0.000000, 0.098704, 0.000000, -0.927145, 0.000000, 1.000000}, 
{0.113910, 0.000000, 0.103850, 0.000000, 0.113284, 0.000000, -0.926884, 0.000000, 1.000000}, 
{0.129755, 0.000000, 0.117777, 0.000000, 0.128883, 0.000000, -0.926546, 0.000000, 1.000000}, 
{0.146669, 0.000000, 0.132441, 0.000000, 0.145469, 0.000000, -0.926104, 0.000000, 1.000000}, 
{0.164648, 0.000000, 0.147565, 0.000000, 0.162956, 0.000000, -0.925530, 0.000000, 1.000000}, 
{0.183708, 0.000000, 0.163470, 0.000000, 0.181482, 0.000000, -0.924802, 0.000000, 1.000000}, 
{0.203832, 0.000000, 0.179763, 0.000000, 0.200899, 0.000000, -0.923871, 0.000000, 1.000000}, 
{0.225029, 0.000000, 0.196564, 0.000000, 0.221291, 0.000000, -0.922691, 0.000000, 1.000000}, 
{0.247221, 0.000000, 0.213537, 0.000000, 0.242549, 0.000000, -0.921198, 0.000000, 1.000000}, 
{0.270343, 0.000000, 0.230662, 0.000000, 0.264707, 0.000000, -0.919320, 0.000000, 1.000000}, 
{0.294399, 0.000000, 0.247740, 0.000000, 0.287692, 0.000000, -0.917008, 0.000000, 1.000000}, 
{0.319040, 0.000000, 0.264448, 0.000000, 0.311426, 0.000000, -0.914141, 0.000000, 1.000000}, 
{0.344269, 0.000000, 0.280831, 0.000000, 0.335974, 0.000000, -0.910707, 0.000000, 1.000000}, 
{0.369625, 0.000000, 0.296478, 0.000000, 0.361253, 0.000000, -0.906585, 0.000000, 1.000000}, 
{0.394925, 0.000000, 0.311287, 0.000000, 0.387335, 0.000000, -0.901918, 0.000000, 1.000000}, 
{0.420583, 0.000000, 0.325578, 0.000000, 0.413948, 0.000000, -0.896240, 0.000000, 1.000000}, 
{0.446200, 0.000000, 0.338384, 0.000000, 0.441308, 0.000000, -0.889335, 0.000000, 1.000000}, 
{0.472969, 0.000000, 0.349187, 0.000000, 0.469860, 0.000000, -0.880394, 0.000000, 1.000000}, 
{0.500490, 0.000000, 0.358687, 0.000000, 0.498796, 0.000000, -0.869705, 0.000000, 1.000000}, 
{0.527312, 0.000000, 0.366042, 0.000000, 0.527974, 0.000000, -0.857145, 0.000000, 1.000000}, 
{0.554207, 0.000000, 0.372045, 0.000000, 0.557350, 0.000000, -0.842943, 0.000000, 1.000000}, 
{0.580620, 0.000000, 0.376134, 0.000000, 0.586519, 0.000000, -0.826837, 0.000000, 1.000000}, 
{0.606480, 0.000000, 0.378636, 0.000000, 0.615501, 0.000000, -0.808891, 0.000000, 1.000000}, 
{0.631815, 0.000000, 0.379414, 0.000000, 0.644016, 0.000000, -0.789119, 0.000000, 1.000000}, 
{0.657021, 0.000000, 0.378972, 0.000000, 0.671877, 0.000000, -0.767564, 0.000000, 1.000000}, 
{0.681686, 0.000000, 0.376728, 0.000000, 0.698908, 0.000000, -0.744338, 0.000000, 1.000000}, 
{0.706498, 0.000000, 0.372844, 0.000000, 0.725648, 0.000000, -0.718799, 0.000000, 1.000000}, 
{0.731258, 0.000000, 0.366649, 0.000000, 0.751221, 0.000000, -0.691756, 0.000000, 1.000000}, 
{0.755937, 0.000000, 0.359354, 0.000000, 0.776331, 0.000000, -0.662683, 0.000000, 1.000000}, 
{0.779259, 0.000000, 0.350487, 0.000000, 0.800489, 0.000000, -0.632892, 0.000000, 1.000000}, 
{0.803295, 0.000000, 0.340941, 0.000000, 0.822859, 0.000000, -0.602160, 0.000000, 1.000000}, 
{0.826570, 0.000000, 0.330174, 0.000000, 0.845078, 0.000000, -0.570520, 0.000000, 1.000000}, 
{0.849954, 0.000000, 0.317854, 0.000000, 0.866236, 0.000000, -0.537651, 0.000000, 1.000000}, 
{0.873696, 0.000000, 0.304426, 0.000000, 0.886699, 0.000000, -0.503799, 0.000000, 1.000000}, 
{0.896695, 0.000000, 0.290120, 0.000000, 0.906186, 0.000000, -0.469645, 0.000000, 1.000000}, 
{0.919149, 0.000000, 0.275106, 0.000000, 0.925289, 0.000000, -0.435625, 0.000000, 1.000000}, 
{0.942121, 0.000000, 0.259282, 0.000000, 0.944444, 0.000000, -0.401228, 0.000000, 1.000000}, 
{0.964627, 0.000000, 0.242123, 0.000000, 0.963285, 0.000000, -0.367086, 0.000000, 1.000000}, 
{0.986614, 0.000000, 0.224575, 0.000000, 0.981316, 0.000000, -0.332885, 0.000000, 1.000000}, 
{1.009623, 0.000000, 0.206837, 0.000000, 1.000127, 0.000000, -0.299209, 0.000000, 1.000000}, 
{1.033126, 0.000000, 0.188092, 0.000000, 1.019725, 0.000000, -0.266187, 0.000000, 1.000000}, 
{1.054954, 0.000000, 0.168637, 0.000000, 1.039375, 0.000000, -0.233733, 0.000000, 1.000000}, 
{1.077660, 0.000000, 0.149166, 0.000000, 1.058185, 0.000000, -0.203192, 0.000000, 1.000000}, 
{1.097983, 0.000000, 0.128587, 0.000000, 1.075594, 0.000000, -0.173918, 0.000000, 1.000000}, 
{1.115586, 0.000000, 0.107339, 0.000000, 1.091004, 0.000000, -0.145531, 0.000000, 1.000000}, 
{1.130170, 0.000000, 0.086203, 0.000000, 1.105504, 0.000000, -0.116890, 0.000000, 1.000000}, 
{1.141018, 0.000000, 0.064171, 0.000000, 1.119320, 0.000000, -0.087388, 0.000000, 1.000000}, 
{1.147681, 0.000000, 0.042530, 0.000000, 1.132337, 0.000000, -0.057733, 0.000000, 1.000000}, 
{1.152560, 0.000000, 0.021011, 0.000000, 1.145274, 0.000000, -0.028413, 0.000000, 1.000000}, 
{1.158406, 0.000000, -0.000158, 0.000000, 1.158525, 0.000000, 0.000106, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000195, 0.000000, 0.000200, 0.000000, -0.975366, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000491, 0.000000, 0.000504, 0.000000, -0.975365, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.001966, 0.000000, 0.002016, 0.000000, -0.975362, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.004423, 0.000000, 0.004535, 0.000000, -0.975370, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.007863, 0.000000, 0.008063, 0.000000, -0.975362, 0.000000, 1.000000}, 
{0.012597, 0.000000, 0.012285, 0.000000, 0.012597, 0.000000, -0.975356, 0.000000, 1.000000}, 
{0.018145, 0.000000, 0.017692, 0.000000, 0.018140, 0.000000, -0.975340, 0.000000, 1.000000}, 
{0.024699, 0.000000, 0.024074, 0.000000, 0.024692, 0.000000, -0.975321, 0.000000, 1.000000}, 
{0.032266, 0.000000, 0.031434, 0.000000, 0.032254, 0.000000, -0.975288, 0.000000, 1.000000}, 
{0.040853, 0.000000, 0.039771, 0.000000, 0.040819, 0.000000, -0.975244, 0.000000, 1.000000}, 
{0.050452, 0.000000, 0.049067, 0.000000, 0.050402, 0.000000, -0.975173, 0.000000, 1.000000}, 
{0.061077, 0.000000, 0.059324, 0.000000, 0.060992, 0.000000, -0.975078, 0.000000, 1.000000}, 
{0.072736, 0.000000, 0.070526, 0.000000, 0.072594, 0.000000, -0.974951, 0.000000, 1.000000}, 
{0.085431, 0.000000, 0.082528, 0.000000, 0.085155, 0.000000, -0.974777, 0.000000, 1.000000}, 
{0.099182, 0.000000, 0.095345, 0.000000, 0.098698, 0.000000, -0.974540, 0.000000, 1.000000}, 
{0.113999, 0.000000, 0.109118, 0.000000, 0.113284, 0.000000, -0.974241, 0.000000, 1.000000}, 
{0.129888, 0.000000, 0.123741, 0.000000, 0.128879, 0.000000, -0.973852, 0.000000, 1.000000}, 
{0.146842, 0.000000, 0.139071, 0.000000, 0.145448, 0.000000, -0.973342, 0.000000, 1.000000}, 
{0.164890, 0.000000, 0.154986, 0.000000, 0.162947, 0.000000, -0.972684, 0.000000, 1.000000}, 
{0.184025, 0.000000, 0.171661, 0.000000, 0.181470, 0.000000, -0.971856, 0.000000, 1.000000}, 
{0.204245, 0.000000, 0.188672, 0.000000, 0.200856, 0.000000, -0.970785, 0.000000, 1.000000}, 
{0.225528, 0.000000, 0.206252, 0.000000, 0.221253, 0.000000, -0.969448, 0.000000, 1.000000}, 
{0.247841, 0.000000, 0.223972, 0.000000, 0.242505, 0.000000, -0.967742, 0.000000, 1.000000}, 
{0.271157, 0.000000, 0.241827, 0.000000, 0.264638, 0.000000, -0.965607, 0.000000, 1.000000}, 
{0.295297, 0.000000, 0.259562, 0.000000, 0.287605, 0.000000, -0.963007, 0.000000, 1.000000}, 
{0.320121, 0.000000, 0.276909, 0.000000, 0.311423, 0.000000, -0.959722, 0.000000, 1.000000}, 
{0.345566, 0.000000, 0.293883, 0.000000, 0.335993, 0.000000, -0.955831, 0.000000, 1.000000}, 
{0.371012, 0.000000, 0.309816, 0.000000, 0.361381, 0.000000, -0.951127, 0.000000, 1.000000}, 
{0.396834, 0.000000, 0.325157, 0.000000, 0.387413, 0.000000, -0.945725, 0.000000, 1.000000}, 
{0.422277, 0.000000, 0.339357, 0.000000, 0.414250, 0.000000, -0.939318, 0.000000, 1.000000}, 
{0.447928, 0.000000, 0.352387, 0.000000, 0.441434, 0.000000, -0.931470, 0.000000, 1.000000}, 
{0.474315, 0.000000, 0.363680, 0.000000, 0.469691, 0.000000, -0.921900, 0.000000, 1.000000}, 
{0.501560, 0.000000, 0.372963, 0.000000, 0.498763, 0.000000, -0.909996, 0.000000, 1.000000}, 
{0.528391, 0.000000, 0.380159, 0.000000, 0.528070, 0.000000, -0.896244, 0.000000, 1.000000}, 
{0.554754, 0.000000, 0.385545, 0.000000, 0.557557, 0.000000, -0.880326, 0.000000, 1.000000}, 
{0.581888, 0.000000, 0.389778, 0.000000, 0.586503, 0.000000, -0.862716, 0.000000, 1.000000}, 
{0.607791, 0.000000, 0.391839, 0.000000, 0.615517, 0.000000, -0.843146, 0.000000, 1.000000}, 
{0.633511, 0.000000, 0.392331, 0.000000, 0.644126, 0.000000, -0.821554, 0.000000, 1.000000}, 
{0.658621, 0.000000, 0.391193, 0.000000, 0.671914, 0.000000, -0.798336, 0.000000, 1.000000}, 
{0.683160, 0.000000, 0.388424, 0.000000, 0.699043, 0.000000, -0.773299, 0.000000, 1.000000}, 
{0.707429, 0.000000, 0.384104, 0.000000, 0.725186, 0.000000, -0.746668, 0.000000, 1.000000}, 
{0.732212, 0.000000, 0.377945, 0.000000, 0.751107, 0.000000, -0.717502, 0.000000, 1.000000}, 
{0.756871, 0.000000, 0.369856, 0.000000, 0.776164, 0.000000, -0.686954, 0.000000, 1.000000}, 
{0.781065, 0.000000, 0.360707, 0.000000, 0.800008, 0.000000, -0.655372, 0.000000, 1.000000}, 
{0.804167, 0.000000, 0.350091, 0.000000, 0.822722, 0.000000, -0.622683, 0.000000, 1.000000}, 
{0.827948, 0.000000, 0.338941, 0.000000, 0.844266, 0.000000, -0.589185, 0.000000, 1.000000}, 
{0.850901, 0.000000, 0.326427, 0.000000, 0.865573, 0.000000, -0.555005, 0.000000, 1.000000}, 
{0.873589, 0.000000, 0.312199, 0.000000, 0.885577, 0.000000, -0.519594, 0.000000, 1.000000}, 
{0.897085, 0.000000, 0.297374, 0.000000, 0.905114, 0.000000, -0.484105, 0.000000, 1.000000}, 
{0.920459, 0.000000, 0.281932, 0.000000, 0.924168, 0.000000, -0.448661, 0.000000, 1.000000}, 
{0.942637, 0.000000, 0.265625, 0.000000, 0.943476, 0.000000, -0.413051, 0.000000, 1.000000}, 
{0.965341, 0.000000, 0.248332, 0.000000, 0.961825, 0.000000, -0.377329, 0.000000, 1.000000}, 
{0.987530, 0.000000, 0.229983, 0.000000, 0.980584, 0.000000, -0.342349, 0.000000, 1.000000}, 
{1.010739, 0.000000, 0.211647, 0.000000, 0.999356, 0.000000, -0.307824, 0.000000, 1.000000}, 
{1.033449, 0.000000, 0.192725, 0.000000, 1.018983, 0.000000, -0.273368, 0.000000, 1.000000}, 
{1.055618, 0.000000, 0.172726, 0.000000, 1.037991, 0.000000, -0.240238, 0.000000, 1.000000}, 
{1.079345, 0.000000, 0.152640, 0.000000, 1.058615, 0.000000, -0.208322, 0.000000, 1.000000}, 
{1.100058, 0.000000, 0.131931, 0.000000, 1.076133, 0.000000, -0.178242, 0.000000, 1.000000}, 
{1.118547, 0.000000, 0.110351, 0.000000, 1.092032, 0.000000, -0.149493, 0.000000, 1.000000}, 
{1.132748, 0.000000, 0.088128, 0.000000, 1.106719, 0.000000, -0.119673, 0.000000, 1.000000}, 
{1.143419, 0.000000, 0.066069, 0.000000, 1.120745, 0.000000, -0.089728, 0.000000, 1.000000}, 
{1.150316, 0.000000, 0.043513, 0.000000, 1.134316, 0.000000, -0.059253, 0.000000, 1.000000}, 
{1.155208, 0.000000, 0.021593, 0.000000, 1.147226, 0.000000, -0.029140, 0.000000, 1.000000}, 
{1.160871, 0.000000, -0.000111, 0.000000, 1.160969, 0.000000, 0.000035, 0.000000, 1.000000}, 
{0.000201, 0.000000, 0.000206, 0.000000, 0.000200, 0.000000, -1.025243, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000516, 0.000000, 0.000504, 0.000000, -1.025237, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.002066, 0.000000, 0.002016, 0.000000, -1.025237, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.004650, 0.000000, 0.004535, 0.000000, -1.025255, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.008266, 0.000000, 0.008062, 0.000000, -1.025236, 0.000000, 1.000000}, 
{0.012600, 0.000000, 0.012915, 0.000000, 0.012596, 0.000000, -1.025226, 0.000000, 1.000000}, 
{0.018144, 0.000000, 0.018594, 0.000000, 0.018141, 0.000000, -1.025215, 0.000000, 1.000000}, 
{0.024700, 0.000000, 0.025304, 0.000000, 0.024693, 0.000000, -1.025190, 0.000000, 1.000000}, 
{0.032267, 0.000000, 0.033038, 0.000000, 0.032253, 0.000000, -1.025152, 0.000000, 1.000000}, 
{0.040852, 0.000000, 0.041795, 0.000000, 0.040814, 0.000000, -1.025090, 0.000000, 1.000000}, 
{0.050460, 0.000000, 0.051570, 0.000000, 0.050402, 0.000000, -1.025017, 0.000000, 1.000000}, 
{0.061094, 0.000000, 0.062347, 0.000000, 0.060992, 0.000000, -1.024908, 0.000000, 1.000000}, 
{0.072762, 0.000000, 0.074111, 0.000000, 0.072593, 0.000000, -1.024760, 0.000000, 1.000000}, 
{0.085475, 0.000000, 0.086661, 0.000000, 0.085131, 0.000000, -1.024555, 0.000000, 1.000000}, 
{0.099249, 0.000000, 0.100160, 0.000000, 0.098687, 0.000000, -1.024278, 0.000000, 1.000000}, 
{0.114106, 0.000000, 0.114628, 0.000000, 0.113275, 0.000000, -1.023941, 0.000000, 1.000000}, 
{0.130032, 0.000000, 0.130002, 0.000000, 0.128881, 0.000000, -1.023488, 0.000000, 1.000000}, 
{0.147050, 0.000000, 0.145985, 0.000000, 0.145405, 0.000000, -1.022905, 0.000000, 1.000000}, 
{0.165164, 0.000000, 0.162762, 0.000000, 0.162942, 0.000000, -1.022151, 0.000000, 1.000000}, 
{0.184380, 0.000000, 0.180172, 0.000000, 0.181436, 0.000000, -1.021200, 0.000000, 1.000000}, 
{0.204704, 0.000000, 0.198022, 0.000000, 0.200835, 0.000000, -1.019966, 0.000000, 1.000000}, 
{0.226129, 0.000000, 0.216359, 0.000000, 0.221186, 0.000000, -1.018424, 0.000000, 1.000000}, 
{0.248582, 0.000000, 0.234923, 0.000000, 0.242462, 0.000000, -1.016519, 0.000000, 1.000000}, 
{0.272011, 0.000000, 0.253474, 0.000000, 0.264571, 0.000000, -1.014072, 0.000000, 1.000000}, 
{0.296259, 0.000000, 0.271820, 0.000000, 0.287546, 0.000000, -1.011071, 0.000000, 1.000000}, 
{0.321423, 0.000000, 0.289959, 0.000000, 0.311336, 0.000000, -1.007389, 0.000000, 1.000000}, 
{0.346897, 0.000000, 0.307283, 0.000000, 0.336000, 0.000000, -1.002955, 0.000000, 1.000000}, 
{0.372750, 0.000000, 0.323817, 0.000000, 0.361401, 0.000000, -0.997633, 0.000000, 1.000000}, 
{0.398603, 0.000000, 0.339241, 0.000000, 0.387610, 0.000000, -0.991354, 0.000000, 1.000000}, 
{0.424351, 0.000000, 0.353633, 0.000000, 0.414402, 0.000000, -0.983937, 0.000000, 1.000000}, 
{0.449887, 0.000000, 0.366660, 0.000000, 0.441863, 0.000000, -0.975254, 0.000000, 1.000000}, 
{0.475715, 0.000000, 0.378213, 0.000000, 0.469733, 0.000000, -0.964753, 0.000000, 1.000000}, 
{0.502204, 0.000000, 0.387133, 0.000000, 0.498729, 0.000000, -0.951594, 0.000000, 1.000000}, 
{0.530179, 0.000000, 0.394976, 0.000000, 0.527759, 0.000000, -0.936344, 0.000000, 1.000000}, 
{0.556732, 0.000000, 0.400134, 0.000000, 0.557238, 0.000000, -0.918907, 0.000000, 1.000000}, 
{0.583123, 0.000000, 0.403439, 0.000000, 0.586468, 0.000000, -0.899504, 0.000000, 1.000000}, 
{0.609477, 0.000000, 0.405285, 0.000000, 0.615726, 0.000000, -0.878172, 0.000000, 1.000000}, 
{0.634927, 0.000000, 0.405055, 0.000000, 0.643912, 0.000000, -0.854396, 0.000000, 1.000000}, 
{0.660357, 0.000000, 0.403494, 0.000000, 0.671492, 0.000000, -0.829259, 0.000000, 1.000000}, 
{0.684851, 0.000000, 0.400104, 0.000000, 0.699012, 0.000000, -0.802359, 0.000000, 1.000000}, 
{0.709654, 0.000000, 0.395536, 0.000000, 0.724944, 0.000000, -0.773534, 0.000000, 1.000000}, 
{0.733472, 0.000000, 0.388996, 0.000000, 0.750711, 0.000000, -0.743230, 0.000000, 1.000000}, 
{0.757502, 0.000000, 0.380263, 0.000000, 0.775710, 0.000000, -0.711090, 0.000000, 1.000000}, 
{0.782249, 0.000000, 0.370594, 0.000000, 0.799128, 0.000000, -0.677166, 0.000000, 1.000000}, 
{0.806017, 0.000000, 0.359509, 0.000000, 0.821663, 0.000000, -0.642527, 0.000000, 1.000000}, 
{0.828687, 0.000000, 0.347126, 0.000000, 0.843788, 0.000000, -0.607589, 0.000000, 1.000000}, 
{0.852372, 0.000000, 0.334474, 0.000000, 0.864567, 0.000000, -0.571938, 0.000000, 1.000000}, 
{0.874266, 0.000000, 0.320074, 0.000000, 0.884679, 0.000000, -0.535518, 0.000000, 1.000000}, 
{0.898168, 0.000000, 0.304719, 0.000000, 0.904299, 0.000000, -0.498375, 0.000000, 1.000000}, 
{0.920456, 0.000000, 0.288246, 0.000000, 0.923485, 0.000000, -0.461179, 0.000000, 1.000000}, 
{0.942832, 0.000000, 0.271311, 0.000000, 0.942315, 0.000000, -0.424533, 0.000000, 1.000000}, 
{0.966458, 0.000000, 0.254154, 0.000000, 0.960561, 0.000000, -0.387784, 0.000000, 1.000000}, 
{0.988907, 0.000000, 0.235659, 0.000000, 0.979809, 0.000000, -0.351689, 0.000000, 1.000000}, 
{1.011557, 0.000000, 0.216322, 0.000000, 0.998059, 0.000000, -0.315743, 0.000000, 1.000000}, 
{1.035099, 0.000000, 0.197007, 0.000000, 1.018167, 0.000000, -0.280402, 0.000000, 1.000000}, 
{1.056354, 0.000000, 0.176878, 0.000000, 1.037719, 0.000000, -0.246472, 0.000000, 1.000000}, 
{1.079854, 0.000000, 0.156058, 0.000000, 1.058234, 0.000000, -0.212818, 0.000000, 1.000000}, 
{1.101494, 0.000000, 0.134772, 0.000000, 1.076772, 0.000000, -0.182143, 0.000000, 1.000000}, 
{1.120587, 0.000000, 0.113071, 0.000000, 1.092879, 0.000000, -0.152867, 0.000000, 1.000000}, 
{1.135399, 0.000000, 0.090411, 0.000000, 1.107897, 0.000000, -0.122796, 0.000000, 1.000000}, 
{1.146612, 0.000000, 0.067477, 0.000000, 1.122533, 0.000000, -0.091888, 0.000000, 1.000000}, 
{1.153168, 0.000000, 0.044849, 0.000000, 1.136233, 0.000000, -0.060779, 0.000000, 1.000000}, 
{1.157912, 0.000000, 0.021998, 0.000000, 1.149677, 0.000000, -0.029919, 0.000000, 1.000000}, 
{1.163607, 0.000000, -0.000121, 0.000000, 1.163655, 0.000000, -0.000003, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000216, 0.000000, 0.000200, 0.000000, -1.077737, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000543, 0.000000, 0.000504, 0.000000, -1.077732, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.002173, 0.000000, 0.002015, 0.000000, -1.077729, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.004887, 0.000000, 0.004535, 0.000000, -1.077749, 0.000000, 1.000000}, 
{0.008066, 0.000000, 0.008692, 0.000000, 0.008059, 0.000000, -1.077732, 0.000000, 1.000000}, 
{0.012599, 0.000000, 0.013576, 0.000000, 0.012599, 0.000000, -1.077727, 0.000000, 1.000000}, 
{0.018145, 0.000000, 0.019546, 0.000000, 0.018143, 0.000000, -1.077702, 0.000000, 1.000000}, 
{0.024702, 0.000000, 0.026599, 0.000000, 0.024693, 0.000000, -1.077675, 0.000000, 1.000000}, 
{0.032272, 0.000000, 0.034729, 0.000000, 0.032253, 0.000000, -1.077632, 0.000000, 1.000000}, 
{0.040862, 0.000000, 0.043936, 0.000000, 0.040818, 0.000000, -1.077575, 0.000000, 1.000000}, 
{0.050470, 0.000000, 0.054203, 0.000000, 0.050403, 0.000000, -1.077473, 0.000000, 1.000000}, 
{0.061113, 0.000000, 0.065528, 0.000000, 0.060991, 0.000000, -1.077348, 0.000000, 1.000000}, 
{0.072794, 0.000000, 0.077882, 0.000000, 0.072590, 0.000000, -1.077178, 0.000000, 1.000000}, 
{0.085528, 0.000000, 0.091030, 0.000000, 0.085116, 0.000000, -1.076937, 0.000000, 1.000000}, 
{0.099337, 0.000000, 0.105251, 0.000000, 0.098687, 0.000000, -1.076631, 0.000000, 1.000000}, 
{0.114228, 0.000000, 0.120456, 0.000000, 0.113278, 0.000000, -1.076229, 0.000000, 1.000000}, 
{0.130202, 0.000000, 0.136573, 0.000000, 0.128873, 0.000000, -1.075713, 0.000000, 1.000000}, 
{0.147284, 0.000000, 0.153306, 0.000000, 0.145379, 0.000000, -1.075031, 0.000000, 1.000000}, 
{0.165480, 0.000000, 0.170931, 0.000000, 0.162917, 0.000000, -1.074173, 0.000000, 1.000000}, 
{0.184793, 0.000000, 0.189083, 0.000000, 0.181378, 0.000000, -1.073063, 0.000000, 1.000000}, 
{0.205224, 0.000000, 0.207840, 0.000000, 0.200797, 0.000000, -1.071683, 0.000000, 1.000000}, 
{0.226743, 0.000000, 0.226939, 0.000000, 0.221156, 0.000000, -1.069914, 0.000000, 1.000000}, 
{0.249401, 0.000000, 0.246344, 0.000000, 0.242387, 0.000000, -1.067718, 0.000000, 1.000000}, 
{0.272955, 0.000000, 0.265640, 0.000000, 0.264485, 0.000000, -1.064924, 0.000000, 1.000000}, 
{0.297494, 0.000000, 0.284846, 0.000000, 0.287481, 0.000000, -1.061512, 0.000000, 1.000000}, 
{0.322731, 0.000000, 0.303452, 0.000000, 0.311310, 0.000000, -1.057359, 0.000000, 1.000000}, 
{0.348451, 0.000000, 0.321330, 0.000000, 0.335950, 0.000000, -1.052294, 0.000000, 1.000000}, 
{0.374451, 0.000000, 0.338201, 0.000000, 0.361414, 0.000000, -1.046153, 0.000000, 1.000000}, 
{0.400454, 0.000000, 0.353816, 0.000000, 0.387691, 0.000000, -1.039003, 0.000000, 1.000000}, 
{0.426434, 0.000000, 0.368216, 0.000000, 0.414520, 0.000000, -1.030498, 0.000000, 1.000000}, 
{0.452088, 0.000000, 0.381251, 0.000000, 0.441984, 0.000000, -1.020454, 0.000000, 1.000000}, 
{0.477901, 0.000000, 0.392833, 0.000000, 0.469892, 0.000000, -1.008793, 0.000000, 1.000000}, 
{0.504173, 0.000000, 0.402408, 0.000000, 0.498503, 0.000000, -0.994791, 0.000000, 1.000000}, 
{0.531520, 0.000000, 0.409545, 0.000000, 0.527634, 0.000000, -0.977733, 0.000000, 1.000000}, 
{0.558049, 0.000000, 0.414351, 0.000000, 0.557287, 0.000000, -0.958625, 0.000000, 1.000000}, 
{0.584778, 0.000000, 0.417437, 0.000000, 0.586320, 0.000000, -0.937189, 0.000000, 1.000000}, 
{0.610808, 0.000000, 0.418519, 0.000000, 0.615409, 0.000000, -0.913543, 0.000000, 1.000000}, 
{0.636915, 0.000000, 0.418094, 0.000000, 0.643855, 0.000000, -0.888137, 0.000000, 1.000000}, 
{0.662204, 0.000000, 0.415742, 0.000000, 0.671620, 0.000000, -0.860728, 0.000000, 1.000000}, 
{0.686848, 0.000000, 0.411746, 0.000000, 0.698657, 0.000000, -0.831793, 0.000000, 1.000000}, 
{0.710992, 0.000000, 0.406153, 0.000000, 0.724583, 0.000000, -0.800862, 0.000000, 1.000000}, 
{0.735382, 0.000000, 0.399519, 0.000000, 0.750109, 0.000000, -0.768768, 0.000000, 1.000000}, 
{0.759079, 0.000000, 0.390927, 0.000000, 0.774641, 0.000000, -0.734825, 0.000000, 1.000000}, 
{0.782912, 0.000000, 0.380111, 0.000000, 0.798427, 0.000000, -0.699450, 0.000000, 1.000000}, 
{0.806746, 0.000000, 0.368383, 0.000000, 0.821118, 0.000000, -0.663191, 0.000000, 1.000000}, 
{0.830269, 0.000000, 0.355606, 0.000000, 0.842407, 0.000000, -0.625927, 0.000000, 1.000000}, 
{0.853305, 0.000000, 0.341988, 0.000000, 0.863632, 0.000000, -0.588644, 0.000000, 1.000000}, 
{0.876326, 0.000000, 0.327545, 0.000000, 0.883694, 0.000000, -0.550849, 0.000000, 1.000000}, 
{0.898322, 0.000000, 0.311779, 0.000000, 0.902995, 0.000000, -0.512694, 0.000000, 1.000000}, 
{0.921811, 0.000000, 0.294944, 0.000000, 0.922662, 0.000000, -0.474225, 0.000000, 1.000000}, 
{0.944563, 0.000000, 0.277333, 0.000000, 0.940995, 0.000000, -0.435772, 0.000000, 1.000000}, 
{0.967089, 0.000000, 0.259340, 0.000000, 0.959553, 0.000000, -0.398001, 0.000000, 1.000000}, 
{0.989754, 0.000000, 0.240836, 0.000000, 0.978411, 0.000000, -0.360802, 0.000000, 1.000000}, 
{1.012470, 0.000000, 0.221293, 0.000000, 0.997736, 0.000000, -0.323566, 0.000000, 1.000000}, 
{1.036426, 0.000000, 0.201191, 0.000000, 1.017433, 0.000000, -0.287387, 0.000000, 1.000000}, 
{1.058709, 0.000000, 0.180590, 0.000000, 1.037603, 0.000000, -0.252184, 0.000000, 1.000000}, 
{1.081593, 0.000000, 0.159810, 0.000000, 1.057999, 0.000000, -0.218441, 0.000000, 1.000000}, 
{1.103146, 0.000000, 0.137772, 0.000000, 1.077124, 0.000000, -0.186223, 0.000000, 1.000000}, 
{1.122814, 0.000000, 0.115347, 0.000000, 1.094100, 0.000000, -0.156019, 0.000000, 1.000000}, 
{1.137790, 0.000000, 0.092582, 0.000000, 1.109423, 0.000000, -0.125579, 0.000000, 1.000000}, 
{1.149184, 0.000000, 0.069152, 0.000000, 1.124267, 0.000000, -0.093986, 0.000000, 1.000000}, 
{1.156062, 0.000000, 0.045661, 0.000000, 1.138364, 0.000000, -0.062122, 0.000000, 1.000000}, 
{1.160733, 0.000000, 0.022719, 0.000000, 1.152129, 0.000000, -0.030650, 0.000000, 1.000000}, 
{1.166487, 0.000000, -0.000231, 0.000000, 1.166413, 0.000000, 0.000120, 0.000000, 1.000000}, 
{0.000201, 0.000000, 0.000228, 0.000000, 0.000199, 0.000000, -1.133128, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000571, 0.000000, 0.000504, 0.000000, -1.133123, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.002284, 0.000000, 0.002016, 0.000000, -1.133123, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.005138, 0.000000, 0.004536, 0.000000, -1.133144, 0.000000, 1.000000}, 
{0.008048, 0.000000, 0.009119, 0.000000, 0.008111, 0.000000, -1.133138, 0.000000, 1.000000}, 
{0.012600, 0.000000, 0.014274, 0.000000, 0.012596, 0.000000, -1.133110, 0.000000, 1.000000}, 
{0.018147, 0.000000, 0.020553, 0.000000, 0.018140, 0.000000, -1.133093, 0.000000, 1.000000}, 
{0.024702, 0.000000, 0.027964, 0.000000, 0.024693, 0.000000, -1.133060, 0.000000, 1.000000}, 
{0.032272, 0.000000, 0.036510, 0.000000, 0.032255, 0.000000, -1.133007, 0.000000, 1.000000}, 
{0.040866, 0.000000, 0.046188, 0.000000, 0.040821, 0.000000, -1.132930, 0.000000, 1.000000}, 
{0.050481, 0.000000, 0.056979, 0.000000, 0.050401, 0.000000, -1.132824, 0.000000, 1.000000}, 
{0.061133, 0.000000, 0.068881, 0.000000, 0.060991, 0.000000, -1.132678, 0.000000, 1.000000}, 
{0.072830, 0.000000, 0.081850, 0.000000, 0.072582, 0.000000, -1.132481, 0.000000, 1.000000}, 
{0.085592, 0.000000, 0.095657, 0.000000, 0.085105, 0.000000, -1.132202, 0.000000, 1.000000}, 
{0.099431, 0.000000, 0.110594, 0.000000, 0.098673, 0.000000, -1.131845, 0.000000, 1.000000}, 
{0.114360, 0.000000, 0.126590, 0.000000, 0.113278, 0.000000, -1.131383, 0.000000, 1.000000}, 
{0.130388, 0.000000, 0.143454, 0.000000, 0.128857, 0.000000, -1.130784, 0.000000, 1.000000}, 
{0.147547, 0.000000, 0.161029, 0.000000, 0.145364, 0.000000, -1.130003, 0.000000, 1.000000}, 
{0.165836, 0.000000, 0.179523, 0.000000, 0.162894, 0.000000, -1.129016, 0.000000, 1.000000}, 
{0.185269, 0.000000, 0.198527, 0.000000, 0.181337, 0.000000, -1.127738, 0.000000, 1.000000}, 
{0.205822, 0.000000, 0.218138, 0.000000, 0.200744, 0.000000, -1.126156, 0.000000, 1.000000}, 
{0.227527, 0.000000, 0.238141, 0.000000, 0.221085, 0.000000, -1.124132, 0.000000, 1.000000}, 
{0.250325, 0.000000, 0.258302, 0.000000, 0.242290, 0.000000, -1.121594, 0.000000, 1.000000}, 
{0.274070, 0.000000, 0.278329, 0.000000, 0.264369, 0.000000, -1.118449, 0.000000, 1.000000}, 
{0.298793, 0.000000, 0.298310, 0.000000, 0.287377, 0.000000, -1.114528, 0.000000, 1.000000}, 
{0.324131, 0.000000, 0.317462, 0.000000, 0.311239, 0.000000, -1.109783, 0.000000, 1.000000}, 
{0.350101, 0.000000, 0.335853, 0.000000, 0.335842, 0.000000, -1.103901, 0.000000, 1.000000}, 
{0.376293, 0.000000, 0.353064, 0.000000, 0.361489, 0.000000, -1.096954, 0.000000, 1.000000}, 
{0.402547, 0.000000, 0.368950, 0.000000, 0.387810, 0.000000, -1.088642, 0.000000, 1.000000}, 
{0.428791, 0.000000, 0.383462, 0.000000, 0.414802, 0.000000, -1.078946, 0.000000, 1.000000}, 
{0.454976, 0.000000, 0.396635, 0.000000, 0.442148, 0.000000, -1.067536, 0.000000, 1.000000}, 
{0.480566, 0.000000, 0.407873, 0.000000, 0.470114, 0.000000, -1.054403, 0.000000, 1.000000}, 
{0.506154, 0.000000, 0.417303, 0.000000, 0.498467, 0.000000, -1.038894, 0.000000, 1.000000}, 
{0.532862, 0.000000, 0.424194, 0.000000, 0.527635, 0.000000, -1.020535, 0.000000, 1.000000}, 
{0.560354, 0.000000, 0.429344, 0.000000, 0.556786, 0.000000, -0.999295, 0.000000, 1.000000}, 
{0.587114, 0.000000, 0.431949, 0.000000, 0.586035, 0.000000, -0.975990, 0.000000, 1.000000}, 
{0.613345, 0.000000, 0.432547, 0.000000, 0.614963, 0.000000, -0.950239, 0.000000, 1.000000}, 
{0.639335, 0.000000, 0.431338, 0.000000, 0.643363, 0.000000, -0.922467, 0.000000, 1.000000}, 
{0.664996, 0.000000, 0.428473, 0.000000, 0.670996, 0.000000, -0.892593, 0.000000, 1.000000}, 
{0.688947, 0.000000, 0.423355, 0.000000, 0.698558, 0.000000, -0.861325, 0.000000, 1.000000}, 
{0.713403, 0.000000, 0.417235, 0.000000, 0.724457, 0.000000, -0.828289, 0.000000, 1.000000}, 
{0.737649, 0.000000, 0.409848, 0.000000, 0.749187, 0.000000, -0.793863, 0.000000, 1.000000}, 
{0.761275, 0.000000, 0.400901, 0.000000, 0.773665, 0.000000, -0.758074, 0.000000, 1.000000}, 
{0.784778, 0.000000, 0.390174, 0.000000, 0.797540, 0.000000, -0.721974, 0.000000, 1.000000}, 
{0.808762, 0.000000, 0.377683, 0.000000, 0.819509, 0.000000, -0.682718, 0.000000, 1.000000}, 
{0.831993, 0.000000, 0.364037, 0.000000, 0.841604, 0.000000, -0.644001, 0.000000, 1.000000}, 
{0.854696, 0.000000, 0.349494, 0.000000, 0.862692, 0.000000, -0.605478, 0.000000, 1.000000}, 
{0.877933, 0.000000, 0.334499, 0.000000, 0.882441, 0.000000, -0.565588, 0.000000, 1.000000}, 
{0.900180, 0.000000, 0.318435, 0.000000, 0.901816, 0.000000, -0.526138, 0.000000, 1.000000}, 
{0.923039, 0.000000, 0.301669, 0.000000, 0.921047, 0.000000, -0.486524, 0.000000, 1.000000}, 
{0.945895, 0.000000, 0.283298, 0.000000, 0.940061, 0.000000, -0.446747, 0.000000, 1.000000}, 
{0.968069, 0.000000, 0.264438, 0.000000, 0.958570, 0.000000, -0.408041, 0.000000, 1.000000}, 
{0.991179, 0.000000, 0.245463, 0.000000, 0.977329, 0.000000, -0.369477, 0.000000, 1.000000}, 
{1.012926, 0.000000, 0.225680, 0.000000, 0.996640, 0.000000, -0.331626, 0.000000, 1.000000}, 
{1.036995, 0.000000, 0.205401, 0.000000, 1.016563, 0.000000, -0.294288, 0.000000, 1.000000}, 
{1.060909, 0.000000, 0.184310, 0.000000, 1.037623, 0.000000, -0.257696, 0.000000, 1.000000}, 
{1.083531, 0.000000, 0.162846, 0.000000, 1.058375, 0.000000, -0.223343, 0.000000, 1.000000}, 
{1.105644, 0.000000, 0.141040, 0.000000, 1.077715, 0.000000, -0.190541, 0.000000, 1.000000}, 
{1.125691, 0.000000, 0.117965, 0.000000, 1.095199, 0.000000, -0.159310, 0.000000, 1.000000}, 
{1.141297, 0.000000, 0.094377, 0.000000, 1.111145, 0.000000, -0.128238, 0.000000, 1.000000}, 
{1.152672, 0.000000, 0.070831, 0.000000, 1.126055, 0.000000, -0.096282, 0.000000, 1.000000}, 
{1.159333, 0.000000, 0.046853, 0.000000, 1.140494, 0.000000, -0.063720, 0.000000, 1.000000}, 
{1.163819, 0.000000, 0.022991, 0.000000, 1.154701, 0.000000, -0.031234, 0.000000, 1.000000}, 
{1.169564, 0.000000, -0.000125, 0.000000, 1.169483, 0.000000, 0.000024, 0.000000, 1.000000}, 
{0.000202, 0.000000, 0.000241, 0.000000, 0.000199, 0.000000, -1.191742, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000600, 0.000000, 0.000504, 0.000000, -1.191740, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.002401, 0.000000, 0.002016, 0.000000, -1.191730, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.005405, 0.000000, 0.004532, 0.000000, -1.191756, 0.000000, 1.000000}, 
{0.008071, 0.000000, 0.009618, 0.000000, 0.008055, 0.000000, -1.191753, 0.000000, 1.000000}, 
{0.012600, 0.000000, 0.015012, 0.000000, 0.012598, 0.000000, -1.191727, 0.000000, 1.000000}, 
{0.018145, 0.000000, 0.021612, 0.000000, 0.018141, 0.000000, -1.191703, 0.000000, 1.000000}, 
{0.024704, 0.000000, 0.029410, 0.000000, 0.024693, 0.000000, -1.191662, 0.000000, 1.000000}, 
{0.032278, 0.000000, 0.038398, 0.000000, 0.032253, 0.000000, -1.191604, 0.000000, 1.000000}, 
{0.040874, 0.000000, 0.048574, 0.000000, 0.040823, 0.000000, -1.191515, 0.000000, 1.000000}, 
{0.050496, 0.000000, 0.059920, 0.000000, 0.050403, 0.000000, -1.191389, 0.000000, 1.000000}, 
{0.061160, 0.000000, 0.072432, 0.000000, 0.060990, 0.000000, -1.191221, 0.000000, 1.000000}, 
{0.072871, 0.000000, 0.086009, 0.000000, 0.072565, 0.000000, -1.190984, 0.000000, 1.000000}, 
{0.085664, 0.000000, 0.100559, 0.000000, 0.085097, 0.000000, -1.190664, 0.000000, 1.000000}, 
{0.099543, 0.000000, 0.116283, 0.000000, 0.098676, 0.000000, -1.190256, 0.000000, 1.000000}, 
{0.114520, 0.000000, 0.133071, 0.000000, 0.113271, 0.000000, -1.189719, 0.000000, 1.000000}, 
{0.130616, 0.000000, 0.150670, 0.000000, 0.128806, 0.000000, -1.189019, 0.000000, 1.000000}, 
{0.147856, 0.000000, 0.169197, 0.000000, 0.145337, 0.000000, -1.188125, 0.000000, 1.000000}, 
{0.166235, 0.000000, 0.188545, 0.000000, 0.162857, 0.000000, -1.186972, 0.000000, 1.000000}, 
{0.185804, 0.000000, 0.208480, 0.000000, 0.181289, 0.000000, -1.185515, 0.000000, 1.000000}, 
{0.206488, 0.000000, 0.228883, 0.000000, 0.200661, 0.000000, -1.183673, 0.000000, 1.000000}, 
{0.228383, 0.000000, 0.249897, 0.000000, 0.221005, 0.000000, -1.181382, 0.000000, 1.000000}, 
{0.251305, 0.000000, 0.270851, 0.000000, 0.242202, 0.000000, -1.178478, 0.000000, 1.000000}, 
{0.275349, 0.000000, 0.291780, 0.000000, 0.264263, 0.000000, -1.174857, 0.000000, 1.000000}, 
{0.300106, 0.000000, 0.312257, 0.000000, 0.287300, 0.000000, -1.170411, 0.000000, 1.000000}, 
{0.325849, 0.000000, 0.332225, 0.000000, 0.311080, 0.000000, -1.164883, 0.000000, 1.000000}, 
{0.351782, 0.000000, 0.350862, 0.000000, 0.335874, 0.000000, -1.158196, 0.000000, 1.000000}, 
{0.378248, 0.000000, 0.368431, 0.000000, 0.361481, 0.000000, -1.150173, 0.000000, 1.000000}, 
{0.404674, 0.000000, 0.384428, 0.000000, 0.387910, 0.000000, -1.140703, 0.000000, 1.000000}, 
{0.431385, 0.000000, 0.399230, 0.000000, 0.414811, 0.000000, -1.129555, 0.000000, 1.000000}, 
{0.457407, 0.000000, 0.411875, 0.000000, 0.442419, 0.000000, -1.116436, 0.000000, 1.000000}, 
{0.483275, 0.000000, 0.423013, 0.000000, 0.470300, 0.000000, -1.101373, 0.000000, 1.000000}, 
{0.509278, 0.000000, 0.432624, 0.000000, 0.498480, 0.000000, -1.084257, 0.000000, 1.000000}, 
{0.534751, 0.000000, 0.439261, 0.000000, 0.527345, 0.000000, -1.064592, 0.000000, 1.000000}, 
{0.561895, 0.000000, 0.443801, 0.000000, 0.556568, 0.000000, -1.040881, 0.000000, 1.000000}, 
{0.588677, 0.000000, 0.445872, 0.000000, 0.585753, 0.000000, -1.015208, 0.000000, 1.000000}, 
{0.614900, 0.000000, 0.445896, 0.000000, 0.614670, 0.000000, -0.987252, 0.000000, 1.000000}, 
{0.641051, 0.000000, 0.444148, 0.000000, 0.643083, 0.000000, -0.957271, 0.000000, 1.000000}, 
{0.666409, 0.000000, 0.440299, 0.000000, 0.670661, 0.000000, -0.924841, 0.000000, 1.000000}, 
{0.691872, 0.000000, 0.435318, 0.000000, 0.697452, 0.000000, -0.891185, 0.000000, 1.000000}, 
{0.716638, 0.000000, 0.428631, 0.000000, 0.723515, 0.000000, -0.855929, 0.000000, 1.000000}, 
{0.739864, 0.000000, 0.419872, 0.000000, 0.749130, 0.000000, -0.819676, 0.000000, 1.000000}, 
{0.763707, 0.000000, 0.410456, 0.000000, 0.772601, 0.000000, -0.781455, 0.000000, 1.000000}, 
{0.786744, 0.000000, 0.399390, 0.000000, 0.796180, 0.000000, -0.742965, 0.000000, 1.000000}, 
{0.809585, 0.000000, 0.386381, 0.000000, 0.818847, 0.000000, -0.703260, 0.000000, 1.000000}, 
{0.834164, 0.000000, 0.372622, 0.000000, 0.840273, 0.000000, -0.662385, 0.000000, 1.000000}, 
{0.856713, 0.000000, 0.357177, 0.000000, 0.861335, 0.000000, -0.621379, 0.000000, 1.000000}, 
{0.879820, 0.000000, 0.341458, 0.000000, 0.881345, 0.000000, -0.580238, 0.000000, 1.000000}, 
{0.902721, 0.000000, 0.325024, 0.000000, 0.900430, 0.000000, -0.539028, 0.000000, 1.000000}, 
{0.924650, 0.000000, 0.307543, 0.000000, 0.919539, 0.000000, -0.498592, 0.000000, 1.000000}, 
{0.947613, 0.000000, 0.289557, 0.000000, 0.938370, 0.000000, -0.457980, 0.000000, 1.000000}, 
{0.969590, 0.000000, 0.269799, 0.000000, 0.957785, 0.000000, -0.417696, 0.000000, 1.000000}, 
{0.992961, 0.000000, 0.250111, 0.000000, 0.976704, 0.000000, -0.377529, 0.000000, 1.000000}, 
{1.014582, 0.000000, 0.229761, 0.000000, 0.995756, 0.000000, -0.339096, 0.000000, 1.000000}, 
{1.038069, 0.000000, 0.209375, 0.000000, 1.015871, 0.000000, -0.301119, 0.000000, 1.000000}, 
{1.061661, 0.000000, 0.188038, 0.000000, 1.037311, 0.000000, -0.263506, 0.000000, 1.000000}, 
{1.085069, 0.000000, 0.165874, 0.000000, 1.058809, 0.000000, -0.227921, 0.000000, 1.000000}, 
{1.107744, 0.000000, 0.143437, 0.000000, 1.078495, 0.000000, -0.194062, 0.000000, 1.000000}, 
{1.127982, 0.000000, 0.120574, 0.000000, 1.096694, 0.000000, -0.162506, 0.000000, 1.000000}, 
{1.144541, 0.000000, 0.096569, 0.000000, 1.112793, 0.000000, -0.130788, 0.000000, 1.000000}, 
{1.155876, 0.000000, 0.072039, 0.000000, 1.128032, 0.000000, -0.098057, 0.000000, 1.000000}, 
{1.162719, 0.000000, 0.047888, 0.000000, 1.142831, 0.000000, -0.064956, 0.000000, 1.000000}, 
{1.167089, 0.000000, 0.023740, 0.000000, 1.157485, 0.000000, -0.031966, 0.000000, 1.000000}, 
{1.172775, 0.000000, -0.000277, 0.000000, 1.172696, 0.000000, 0.000111, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000251, 0.000000, 0.000200, 0.000000, -1.253951, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000632, 0.000000, 0.000504, 0.000000, -1.253940, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.002527, 0.000000, 0.002016, 0.000000, -1.253927, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.005687, 0.000000, 0.004535, 0.000000, -1.253948, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.010108, 0.000000, 0.008063, 0.000000, -1.253941, 0.000000, 1.000000}, 
{0.012588, 0.000000, 0.015780, 0.000000, 0.012605, 0.000000, -1.253934, 0.000000, 1.000000}, 
{0.018139, 0.000000, 0.022731, 0.000000, 0.018150, 0.000000, -1.253893, 0.000000, 1.000000}, 
{0.024709, 0.000000, 0.030948, 0.000000, 0.024693, 0.000000, -1.253853, 0.000000, 1.000000}, 
{0.032283, 0.000000, 0.040401, 0.000000, 0.032253, 0.000000, -1.253785, 0.000000, 1.000000}, 
{0.040883, 0.000000, 0.051105, 0.000000, 0.040821, 0.000000, -1.253683, 0.000000, 1.000000}, 
{0.050514, 0.000000, 0.063041, 0.000000, 0.050401, 0.000000, -1.253538, 0.000000, 1.000000}, 
{0.061188, 0.000000, 0.076195, 0.000000, 0.060989, 0.000000, -1.253336, 0.000000, 1.000000}, 
{0.072926, 0.000000, 0.090402, 0.000000, 0.072533, 0.000000, -1.253065, 0.000000, 1.000000}, 
{0.085746, 0.000000, 0.105745, 0.000000, 0.085082, 0.000000, -1.252697, 0.000000, 1.000000}, 
{0.099661, 0.000000, 0.122296, 0.000000, 0.098674, 0.000000, -1.252218, 0.000000, 1.000000}, 
{0.114699, 0.000000, 0.139912, 0.000000, 0.113251, 0.000000, -1.251590, 0.000000, 1.000000}, 
{0.130882, 0.000000, 0.158362, 0.000000, 0.128749, 0.000000, -1.250766, 0.000000, 1.000000}, 
{0.148202, 0.000000, 0.177856, 0.000000, 0.145318, 0.000000, -1.249744, 0.000000, 1.000000}, 
{0.166706, 0.000000, 0.198049, 0.000000, 0.162788, 0.000000, -1.248423, 0.000000, 1.000000}, 
{0.186404, 0.000000, 0.219014, 0.000000, 0.181231, 0.000000, -1.246741, 0.000000, 1.000000}, 
{0.207272, 0.000000, 0.240376, 0.000000, 0.200580, 0.000000, -1.244596, 0.000000, 1.000000}, 
{0.229345, 0.000000, 0.262230, 0.000000, 0.220874, 0.000000, -1.241917, 0.000000, 1.000000}, 
{0.252494, 0.000000, 0.284134, 0.000000, 0.242068, 0.000000, -1.238610, 0.000000, 1.000000}, 
{0.276690, 0.000000, 0.305828, 0.000000, 0.264165, 0.000000, -1.234474, 0.000000, 1.000000}, 
{0.301798, 0.000000, 0.327107, 0.000000, 0.287128, 0.000000, -1.229292, 0.000000, 1.000000}, 
{0.327423, 0.000000, 0.347300, 0.000000, 0.310990, 0.000000, -1.222997, 0.000000, 1.000000}, 
{0.353848, 0.000000, 0.366699, 0.000000, 0.335792, 0.000000, -1.215366, 0.000000, 1.000000}, 
{0.380342, 0.000000, 0.384421, 0.000000, 0.361560, 0.000000, -1.206199, 0.000000, 1.000000}, 
{0.407390, 0.000000, 0.400855, 0.000000, 0.387880, 0.000000, -1.195374, 0.000000, 1.000000}, 
{0.433913, 0.000000, 0.415241, 0.000000, 0.414990, 0.000000, -1.182290, 0.000000, 1.000000}, 
{0.460837, 0.000000, 0.428275, 0.000000, 0.442452, 0.000000, -1.167385, 0.000000, 1.000000}, 
{0.486381, 0.000000, 0.438573, 0.000000, 0.470601, 0.000000, -1.150401, 0.000000, 1.000000}, 
{0.511959, 0.000000, 0.447348, 0.000000, 0.498769, 0.000000, -1.130990, 0.000000, 1.000000}, 
{0.537586, 0.000000, 0.454152, 0.000000, 0.527334, 0.000000, -1.109302, 0.000000, 1.000000}, 
{0.564035, 0.000000, 0.458684, 0.000000, 0.556272, 0.000000, -1.084131, 0.000000, 1.000000}, 
{0.590690, 0.000000, 0.460058, 0.000000, 0.585176, 0.000000, -1.055803, 0.000000, 1.000000}, 
{0.617250, 0.000000, 0.459662, 0.000000, 0.614135, 0.000000, -1.025103, 0.000000, 1.000000}, 
{0.643406, 0.000000, 0.457260, 0.000000, 0.642669, 0.000000, -0.992502, 0.000000, 1.000000}, 
{0.668794, 0.000000, 0.452666, 0.000000, 0.670200, 0.000000, -0.957657, 0.000000, 1.000000}, 
{0.693930, 0.000000, 0.446641, 0.000000, 0.696632, 0.000000, -0.921340, 0.000000, 1.000000}, 
{0.718708, 0.000000, 0.439121, 0.000000, 0.722847, 0.000000, -0.883841, 0.000000, 1.000000}, 
{0.743469, 0.000000, 0.430429, 0.000000, 0.747689, 0.000000, -0.844931, 0.000000, 1.000000}, 
{0.766080, 0.000000, 0.419622, 0.000000, 0.771696, 0.000000, -0.804786, 0.000000, 1.000000}, 
{0.789801, 0.000000, 0.408368, 0.000000, 0.794837, 0.000000, -0.764206, 0.000000, 1.000000}, 
{0.812718, 0.000000, 0.395392, 0.000000, 0.817420, 0.000000, -0.722565, 0.000000, 1.000000}, 
{0.835453, 0.000000, 0.380699, 0.000000, 0.838958, 0.000000, -0.680585, 0.000000, 1.000000}, 
{0.858801, 0.000000, 0.364834, 0.000000, 0.859763, 0.000000, -0.637235, 0.000000, 1.000000}, 
{0.881537, 0.000000, 0.348092, 0.000000, 0.879605, 0.000000, -0.594579, 0.000000, 1.000000}, 
{0.904656, 0.000000, 0.331087, 0.000000, 0.899623, 0.000000, -0.552313, 0.000000, 1.000000}, 
{0.926357, 0.000000, 0.312966, 0.000000, 0.918494, 0.000000, -0.510080, 0.000000, 1.000000}, 
{0.949001, 0.000000, 0.294684, 0.000000, 0.937609, 0.000000, -0.468677, 0.000000, 1.000000}, 
{0.971598, 0.000000, 0.275361, 0.000000, 0.956437, 0.000000, -0.426723, 0.000000, 1.000000}, 
{0.994905, 0.000000, 0.254947, 0.000000, 0.975664, 0.000000, -0.385875, 0.000000, 1.000000}, 
{1.017981, 0.000000, 0.234109, 0.000000, 0.995209, 0.000000, -0.345751, 0.000000, 1.000000}, 
{1.040840, 0.000000, 0.213040, 0.000000, 1.015530, 0.000000, -0.306762, 0.000000, 1.000000}, 
{1.063893, 0.000000, 0.191616, 0.000000, 1.036813, 0.000000, -0.269066, 0.000000, 1.000000}, 
{1.086907, 0.000000, 0.169272, 0.000000, 1.058676, 0.000000, -0.232171, 0.000000, 1.000000}, 
{1.109937, 0.000000, 0.146076, 0.000000, 1.079488, 0.000000, -0.197826, 0.000000, 1.000000}, 
{1.130808, 0.000000, 0.122544, 0.000000, 1.097742, 0.000000, -0.165272, 0.000000, 1.000000}, 
{1.146831, 0.000000, 0.098492, 0.000000, 1.114549, 0.000000, -0.133280, 0.000000, 1.000000}, 
{1.158955, 0.000000, 0.073710, 0.000000, 1.130379, 0.000000, -0.100262, 0.000000, 1.000000}, 
{1.166161, 0.000000, 0.048610, 0.000000, 1.145609, 0.000000, -0.066165, 0.000000, 1.000000}, 
{1.170491, 0.000000, 0.024209, 0.000000, 1.160399, 0.000000, -0.032741, 0.000000, 1.000000}, 
{1.176111, 0.000000, -0.000010, 0.000000, 1.176061, 0.000000, -0.000056, 0.000000, 1.000000}, 
{0.000202, 0.000000, 0.000267, 0.000000, 0.000199, 0.000000, -1.320169, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000665, 0.000000, 0.000504, 0.000000, -1.320168, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.002660, 0.000000, 0.002017, 0.000000, -1.320143, 0.000000, 1.000000}, 
{0.004536, 0.000000, 0.005987, 0.000000, 0.004533, 0.000000, -1.320161, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.010644, 0.000000, 0.008061, 0.000000, -1.320162, 0.000000, 1.000000}, 
{0.012600, 0.000000, 0.016628, 0.000000, 0.012602, 0.000000, -1.320148, 0.000000, 1.000000}, 
{0.018144, 0.000000, 0.023937, 0.000000, 0.018146, 0.000000, -1.320127, 0.000000, 1.000000}, 
{0.024708, 0.000000, 0.032577, 0.000000, 0.024695, 0.000000, -1.320061, 0.000000, 1.000000}, 
{0.032290, 0.000000, 0.042536, 0.000000, 0.032251, 0.000000, -1.319976, 0.000000, 1.000000}, 
{0.040894, 0.000000, 0.053799, 0.000000, 0.040822, 0.000000, -1.319861, 0.000000, 1.000000}, 
{0.050533, 0.000000, 0.066361, 0.000000, 0.050400, 0.000000, -1.319691, 0.000000, 1.000000}, 
{0.061223, 0.000000, 0.080202, 0.000000, 0.060987, 0.000000, -1.319458, 0.000000, 1.000000}, 
{0.072985, 0.000000, 0.095109, 0.000000, 0.072518, 0.000000, -1.319138, 0.000000, 1.000000}, 
{0.085841, 0.000000, 0.111296, 0.000000, 0.085083, 0.000000, -1.318715, 0.000000, 1.000000}, 
{0.099808, 0.000000, 0.128685, 0.000000, 0.098660, 0.000000, -1.318156, 0.000000, 1.000000}, 
{0.114903, 0.000000, 0.147202, 0.000000, 0.113237, 0.000000, -1.317424, 0.000000, 1.000000}, 
{0.131164, 0.000000, 0.166575, 0.000000, 0.128742, 0.000000, -1.316485, 0.000000, 1.000000}, 
{0.148599, 0.000000, 0.187019, 0.000000, 0.145272, 0.000000, -1.315274, 0.000000, 1.000000}, 
{0.167245, 0.000000, 0.208240, 0.000000, 0.162741, 0.000000, -1.313733, 0.000000, 1.000000}, 
{0.187078, 0.000000, 0.230151, 0.000000, 0.181174, 0.000000, -1.311792, 0.000000, 1.000000}, 
{0.208153, 0.000000, 0.252538, 0.000000, 0.200500, 0.000000, -1.309343, 0.000000, 1.000000}, 
{0.230418, 0.000000, 0.275295, 0.000000, 0.220765, 0.000000, -1.306247, 0.000000, 1.000000}, 
{0.253802, 0.000000, 0.298066, 0.000000, 0.241932, 0.000000, -1.302374, 0.000000, 1.000000}, 
{0.278261, 0.000000, 0.320673, 0.000000, 0.264020, 0.000000, -1.297573, 0.000000, 1.000000}, 
{0.303527, 0.000000, 0.342528, 0.000000, 0.286987, 0.000000, -1.291625, 0.000000, 1.000000}, 
{0.329571, 0.000000, 0.363531, 0.000000, 0.310855, 0.000000, -1.284374, 0.000000, 1.000000}, 
{0.355939, 0.000000, 0.382963, 0.000000, 0.335680, 0.000000, -1.275478, 0.000000, 1.000000}, 
{0.382987, 0.000000, 0.401306, 0.000000, 0.361313, 0.000000, -1.264866, 0.000000, 1.000000}, 
{0.409917, 0.000000, 0.417455, 0.000000, 0.387815, 0.000000, -1.252184, 0.000000, 1.000000}, 
{0.437015, 0.000000, 0.432067, 0.000000, 0.414990, 0.000000, -1.237415, 0.000000, 1.000000}, 
{0.463474, 0.000000, 0.444204, 0.000000, 0.442685, 0.000000, -1.220687, 0.000000, 1.000000}, 
{0.489835, 0.000000, 0.454631, 0.000000, 0.470707, 0.000000, -1.200973, 0.000000, 1.000000}, 
{0.516054, 0.000000, 0.463338, 0.000000, 0.498884, 0.000000, -1.179346, 0.000000, 1.000000}, 
{0.541397, 0.000000, 0.469425, 0.000000, 0.527137, 0.000000, -1.155039, 0.000000, 1.000000}, 
{0.566798, 0.000000, 0.473526, 0.000000, 0.555768, 0.000000, -1.127866, 0.000000, 1.000000}, 
{0.593114, 0.000000, 0.474632, 0.000000, 0.584825, 0.000000, -1.097304, 0.000000, 1.000000}, 
{0.619945, 0.000000, 0.473597, 0.000000, 0.613201, 0.000000, -1.063603, 0.000000, 1.000000}, 
{0.646325, 0.000000, 0.470656, 0.000000, 0.641581, 0.000000, -1.027971, 0.000000, 1.000000}, 
{0.672320, 0.000000, 0.465675, 0.000000, 0.669123, 0.000000, -0.990692, 0.000000, 1.000000}, 
{0.697163, 0.000000, 0.458527, 0.000000, 0.695722, 0.000000, -0.951582, 0.000000, 1.000000}, 
{0.721472, 0.000000, 0.449904, 0.000000, 0.721510, 0.000000, -0.911197, 0.000000, 1.000000}, 
{0.745855, 0.000000, 0.440140, 0.000000, 0.746430, 0.000000, -0.869745, 0.000000, 1.000000}, 
{0.770089, 0.000000, 0.429338, 0.000000, 0.770476, 0.000000, -0.827648, 0.000000, 1.000000}, 
{0.792546, 0.000000, 0.416701, 0.000000, 0.793586, 0.000000, -0.784728, 0.000000, 1.000000}, 
{0.815161, 0.000000, 0.403151, 0.000000, 0.816040, 0.000000, -0.741884, 0.000000, 1.000000}, 
{0.837994, 0.000000, 0.388714, 0.000000, 0.837281, 0.000000, -0.697800, 0.000000, 1.000000}, 
{0.861220, 0.000000, 0.372573, 0.000000, 0.857822, 0.000000, -0.653341, 0.000000, 1.000000}, 
{0.883737, 0.000000, 0.355024, 0.000000, 0.878336, 0.000000, -0.609455, 0.000000, 1.000000}, 
{0.906784, 0.000000, 0.337092, 0.000000, 0.898096, 0.000000, -0.565275, 0.000000, 1.000000}, 
{0.928493, 0.000000, 0.318370, 0.000000, 0.917561, 0.000000, -0.521558, 0.000000, 1.000000}, 
{0.951495, 0.000000, 0.299605, 0.000000, 0.936380, 0.000000, -0.478149, 0.000000, 1.000000}, 
{0.973586, 0.000000, 0.280067, 0.000000, 0.955920, 0.000000, -0.436325, 0.000000, 1.000000}, 
{0.996400, 0.000000, 0.259823, 0.000000, 0.974302, 0.000000, -0.394409, 0.000000, 1.000000}, 
{1.019780, 0.000000, 0.238313, 0.000000, 0.994052, 0.000000, -0.353045, 0.000000, 1.000000}, 
{1.042775, 0.000000, 0.216506, 0.000000, 1.015160, 0.000000, -0.312803, 0.000000, 1.000000}, 
{1.066822, 0.000000, 0.194695, 0.000000, 1.036898, 0.000000, -0.274100, 0.000000, 1.000000}, 
{1.089869, 0.000000, 0.172290, 0.000000, 1.058930, 0.000000, -0.236657, 0.000000, 1.000000}, 
{1.113606, 0.000000, 0.149264, 0.000000, 1.080519, 0.000000, -0.201603, 0.000000, 1.000000}, 
{1.134229, 0.000000, 0.124814, 0.000000, 1.099501, 0.000000, -0.168398, 0.000000, 1.000000}, 
{1.150922, 0.000000, 0.100070, 0.000000, 1.116430, 0.000000, -0.135616, 0.000000, 1.000000}, 
{1.163224, 0.000000, 0.075155, 0.000000, 1.132682, 0.000000, -0.102144, 0.000000, 1.000000}, 
{1.169965, 0.000000, 0.049933, 0.000000, 1.148284, 0.000000, -0.067532, 0.000000, 1.000000}, 
{1.174200, 0.000000, 0.024461, 0.000000, 1.163476, 0.000000, -0.033215, 0.000000, 1.000000}, 
{1.179766, 0.000000, -0.000188, 0.000000, 1.179713, 0.000000, 0.000014, 0.000000, 1.000000}, 
{0.000202, 0.000000, 0.000281, 0.000000, 0.000200, 0.000000, -1.390880, 0.000000, 1.000000}, 
{0.000505, 0.000000, 0.000702, 0.000000, 0.000503, 0.000000, -1.390903, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.002802, 0.000000, 0.002017, 0.000000, -1.390863, 0.000000, 1.000000}, 
{0.004535, 0.000000, 0.006307, 0.000000, 0.004533, 0.000000, -1.390900, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.011213, 0.000000, 0.008063, 0.000000, -1.390890, 0.000000, 1.000000}, 
{0.012598, 0.000000, 0.017516, 0.000000, 0.012605, 0.000000, -1.390876, 0.000000, 1.000000}, 
{0.018147, 0.000000, 0.025221, 0.000000, 0.018145, 0.000000, -1.390832, 0.000000, 1.000000}, 
{0.024711, 0.000000, 0.034322, 0.000000, 0.024692, 0.000000, -1.390769, 0.000000, 1.000000}, 
{0.032295, 0.000000, 0.044810, 0.000000, 0.032252, 0.000000, -1.390674, 0.000000, 1.000000}, 
{0.040904, 0.000000, 0.056673, 0.000000, 0.040822, 0.000000, -1.390538, 0.000000, 1.000000}, 
{0.050555, 0.000000, 0.069906, 0.000000, 0.050399, 0.000000, -1.390342, 0.000000, 1.000000}, 
{0.061259, 0.000000, 0.084468, 0.000000, 0.060983, 0.000000, -1.390064, 0.000000, 1.000000}, 
{0.073053, 0.000000, 0.100152, 0.000000, 0.072508, 0.000000, -1.389695, 0.000000, 1.000000}, 
{0.085948, 0.000000, 0.117202, 0.000000, 0.085070, 0.000000, -1.389201, 0.000000, 1.000000}, 
{0.099968, 0.000000, 0.135531, 0.000000, 0.098659, 0.000000, -1.388548, 0.000000, 1.000000}, 
{0.115135, 0.000000, 0.154906, 0.000000, 0.113202, 0.000000, -1.387692, 0.000000, 1.000000}, 
{0.131496, 0.000000, 0.175352, 0.000000, 0.128730, 0.000000, -1.386611, 0.000000, 1.000000}, 
{0.149049, 0.000000, 0.196783, 0.000000, 0.145231, 0.000000, -1.385190, 0.000000, 1.000000}, 
{0.167848, 0.000000, 0.219066, 0.000000, 0.162685, 0.000000, -1.383407, 0.000000, 1.000000}, 
{0.187879, 0.000000, 0.241983, 0.000000, 0.181083, 0.000000, -1.381148, 0.000000, 1.000000}, 
{0.209143, 0.000000, 0.265398, 0.000000, 0.200387, 0.000000, -1.378261, 0.000000, 1.000000}, 
{0.231689, 0.000000, 0.289254, 0.000000, 0.220642, 0.000000, -1.374690, 0.000000, 1.000000}, 
{0.255223, 0.000000, 0.312776, 0.000000, 0.241766, 0.000000, -1.370166, 0.000000, 1.000000}, 
{0.279952, 0.000000, 0.336260, 0.000000, 0.263844, 0.000000, -1.364591, 0.000000, 1.000000}, 
{0.305572, 0.000000, 0.358865, 0.000000, 0.286810, 0.000000, -1.357758, 0.000000, 1.000000}, 
{0.331650, 0.000000, 0.380223, 0.000000, 0.310808, 0.000000, -1.349413, 0.000000, 1.000000}, 
{0.358491, 0.000000, 0.400252, 0.000000, 0.335592, 0.000000, -1.339084, 0.000000, 1.000000}, 
{0.385445, 0.000000, 0.418422, 0.000000, 0.361449, 0.000000, -1.326773, 0.000000, 1.000000}, 
{0.412947, 0.000000, 0.434993, 0.000000, 0.387753, 0.000000, -1.312141, 0.000000, 1.000000}, 
{0.439681, 0.000000, 0.448757, 0.000000, 0.415096, 0.000000, -1.295205, 0.000000, 1.000000}, 
{0.467272, 0.000000, 0.461427, 0.000000, 0.442475, 0.000000, -1.275573, 0.000000, 1.000000}, 
{0.493568, 0.000000, 0.471102, 0.000000, 0.470665, 0.000000, -1.253400, 0.000000, 1.000000}, 
{0.519743, 0.000000, 0.478930, 0.000000, 0.498795, 0.000000, -1.228890, 0.000000, 1.000000}, 
{0.544882, 0.000000, 0.484098, 0.000000, 0.527347, 0.000000, -1.201730, 0.000000, 1.000000}, 
{0.570690, 0.000000, 0.488125, 0.000000, 0.555533, 0.000000, -1.172022, 0.000000, 1.000000}, 
{0.595905, 0.000000, 0.489185, 0.000000, 0.583820, 0.000000, -1.139312, 0.000000, 1.000000}, 
{0.622747, 0.000000, 0.487535, 0.000000, 0.612392, 0.000000, -1.103038, 0.000000, 1.000000}, 
{0.648695, 0.000000, 0.483482, 0.000000, 0.640583, 0.000000, -1.064364, 0.000000, 1.000000}, 
{0.675159, 0.000000, 0.478096, 0.000000, 0.667772, 0.000000, -1.024098, 0.000000, 1.000000}, 
{0.700714, 0.000000, 0.470492, 0.000000, 0.694117, 0.000000, -0.982186, 0.000000, 1.000000}, 
{0.725641, 0.000000, 0.461398, 0.000000, 0.720236, 0.000000, -0.939137, 0.000000, 1.000000}, 
{0.748552, 0.000000, 0.449825, 0.000000, 0.744973, 0.000000, -0.894791, 0.000000, 1.000000}, 
{0.772808, 0.000000, 0.438185, 0.000000, 0.769057, 0.000000, -0.850373, 0.000000, 1.000000}, 
{0.795928, 0.000000, 0.425073, 0.000000, 0.792076, 0.000000, -0.805287, 0.000000, 1.000000}, 
{0.818900, 0.000000, 0.411028, 0.000000, 0.814075, 0.000000, -0.760003, 0.000000, 1.000000}, 
{0.841633, 0.000000, 0.396047, 0.000000, 0.835720, 0.000000, -0.714914, 0.000000, 1.000000}, 
{0.863213, 0.000000, 0.379637, 0.000000, 0.856042, 0.000000, -0.669271, 0.000000, 1.000000}, 
{0.886662, 0.000000, 0.362227, 0.000000, 0.876420, 0.000000, -0.622935, 0.000000, 1.000000}, 
{0.908504, 0.000000, 0.343068, 0.000000, 0.896332, 0.000000, -0.577757, 0.000000, 1.000000}, 
{0.931425, 0.000000, 0.323982, 0.000000, 0.916253, 0.000000, -0.532922, 0.000000, 1.000000}, 
{0.953835, 0.000000, 0.304347, 0.000000, 0.935135, 0.000000, -0.488154, 0.000000, 1.000000}, 
{0.975813, 0.000000, 0.284219, 0.000000, 0.954320, 0.000000, -0.444885, 0.000000, 1.000000}, 
{0.997662, 0.000000, 0.263544, 0.000000, 0.973301, 0.000000, -0.402224, 0.000000, 1.000000}, 
{1.021167, 0.000000, 0.242611, 0.000000, 0.993312, 0.000000, -0.360530, 0.000000, 1.000000}, 
{1.044038, 0.000000, 0.220065, 0.000000, 1.014461, 0.000000, -0.318968, 0.000000, 1.000000}, 
{1.068837, 0.000000, 0.197580, 0.000000, 1.036306, 0.000000, -0.279107, 0.000000, 1.000000}, 
{1.092548, 0.000000, 0.174779, 0.000000, 1.059252, 0.000000, -0.241111, 0.000000, 1.000000}, 
{1.116157, 0.000000, 0.151596, 0.000000, 1.081788, 0.000000, -0.204913, 0.000000, 1.000000}, 
{1.137486, 0.000000, 0.127478, 0.000000, 1.101245, 0.000000, -0.171410, 0.000000, 1.000000}, 
{1.154694, 0.000000, 0.101915, 0.000000, 1.118635, 0.000000, -0.137999, 0.000000, 1.000000}, 
{1.166867, 0.000000, 0.076246, 0.000000, 1.135248, 0.000000, -0.103807, 0.000000, 1.000000}, 
{1.173715, 0.000000, 0.050661, 0.000000, 1.151295, 0.000000, -0.068802, 0.000000, 1.000000}, 
{1.178236, 0.000000, 0.025355, 0.000000, 1.167053, 0.000000, -0.034155, 0.000000, 1.000000}, 
{1.183545, 0.000000, -0.000205, 0.000000, 1.183475, 0.000000, 0.000110, 0.000000, 1.000000}, 
{0.000201, 0.000000, 0.000294, 0.000000, 0.000200, 0.000000, -1.466721, 0.000000, 1.000000}, 
{0.000505, 0.000000, 0.000740, 0.000000, 0.000504, 0.000000, -1.466737, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.002957, 0.000000, 0.002015, 0.000000, -1.466688, 0.000000, 1.000000}, 
{0.004537, 0.000000, 0.006655, 0.000000, 0.004538, 0.000000, -1.466667, 0.000000, 1.000000}, 
{0.008066, 0.000000, 0.011828, 0.000000, 0.008060, 0.000000, -1.466694, 0.000000, 1.000000}, 
{0.012604, 0.000000, 0.018479, 0.000000, 0.012597, 0.000000, -1.466721, 0.000000, 1.000000}, 
{0.018150, 0.000000, 0.026598, 0.000000, 0.018140, 0.000000, -1.466636, 0.000000, 1.000000}, 
{0.024714, 0.000000, 0.036191, 0.000000, 0.024693, 0.000000, -1.466562, 0.000000, 1.000000}, 
{0.032301, 0.000000, 0.047249, 0.000000, 0.032252, 0.000000, -1.466450, 0.000000, 1.000000}, 
{0.040924, 0.000000, 0.059766, 0.000000, 0.040818, 0.000000, -1.466289, 0.000000, 1.000000}, 
{0.050579, 0.000000, 0.073703, 0.000000, 0.050399, 0.000000, -1.466055, 0.000000, 1.000000}, 
{0.061306, 0.000000, 0.089022, 0.000000, 0.060969, 0.000000, -1.465738, 0.000000, 1.000000}, 
{0.073135, 0.000000, 0.105563, 0.000000, 0.072497, 0.000000, -1.465301, 0.000000, 1.000000}, 
{0.086075, 0.000000, 0.123544, 0.000000, 0.085066, 0.000000, -1.464715, 0.000000, 1.000000}, 
{0.100153, 0.000000, 0.142853, 0.000000, 0.098653, 0.000000, -1.463956, 0.000000, 1.000000}, 
{0.115411, 0.000000, 0.163183, 0.000000, 0.113162, 0.000000, -1.462962, 0.000000, 1.000000}, 
{0.131876, 0.000000, 0.184760, 0.000000, 0.128703, 0.000000, -1.461670, 0.000000, 1.000000}, 
{0.149570, 0.000000, 0.207172, 0.000000, 0.145160, 0.000000, -1.460045, 0.000000, 1.000000}, 
{0.168523, 0.000000, 0.230578, 0.000000, 0.162614, 0.000000, -1.457945, 0.000000, 1.000000}, 
{0.188784, 0.000000, 0.254658, 0.000000, 0.180982, 0.000000, -1.455279, 0.000000, 1.000000}, 
{0.210264, 0.000000, 0.279114, 0.000000, 0.200282, 0.000000, -1.451998, 0.000000, 1.000000}, 
{0.233030, 0.000000, 0.303930, 0.000000, 0.220486, 0.000000, -1.447780, 0.000000, 1.000000}, 
{0.256959, 0.000000, 0.328517, 0.000000, 0.241594, 0.000000, -1.442568, 0.000000, 1.000000}, 
{0.281901, 0.000000, 0.352755, 0.000000, 0.263671, 0.000000, -1.436026, 0.000000, 1.000000}, 
{0.307728, 0.000000, 0.375894, 0.000000, 0.286579, 0.000000, -1.427979, 0.000000, 1.000000}, 
{0.334197, 0.000000, 0.397924, 0.000000, 0.310612, 0.000000, -1.418249, 0.000000, 1.000000}, 
{0.360966, 0.000000, 0.417914, 0.000000, 0.335477, 0.000000, -1.406370, 0.000000, 1.000000}, 
{0.388478, 0.000000, 0.436526, 0.000000, 0.361196, 0.000000, -1.392134, 0.000000, 1.000000}, 
{0.415567, 0.000000, 0.452366, 0.000000, 0.387962, 0.000000, -1.375244, 0.000000, 1.000000}, 
{0.443518, 0.000000, 0.466917, 0.000000, 0.414814, 0.000000, -1.355660, 0.000000, 1.000000}, 
{0.470631, 0.000000, 0.478417, 0.000000, 0.442629, 0.000000, -1.333123, 0.000000, 1.000000}, 
{0.497419, 0.000000, 0.487825, 0.000000, 0.470566, 0.000000, -1.308181, 0.000000, 1.000000}, 
{0.523961, 0.000000, 0.495064, 0.000000, 0.498766, 0.000000, -1.280227, 0.000000, 1.000000}, 
{0.549708, 0.000000, 0.499844, 0.000000, 0.526921, 0.000000, -1.249894, 0.000000, 1.000000}, 
{0.575296, 0.000000, 0.502844, 0.000000, 0.555126, 0.000000, -1.217130, 0.000000, 1.000000}, 
{0.600168, 0.000000, 0.503368, 0.000000, 0.583131, 0.000000, -1.181412, 0.000000, 1.000000}, 
{0.625874, 0.000000, 0.501622, 0.000000, 0.611054, 0.000000, -1.142648, 0.000000, 1.000000}, 
{0.652164, 0.000000, 0.496936, 0.000000, 0.639045, 0.000000, -1.101268, 0.000000, 1.000000}, 
{0.678029, 0.000000, 0.490319, 0.000000, 0.666175, 0.000000, -1.057782, 0.000000, 1.000000}, 
{0.703248, 0.000000, 0.481575, 0.000000, 0.692891, 0.000000, -1.012884, 0.000000, 1.000000}, 
{0.728520, 0.000000, 0.471822, 0.000000, 0.718612, 0.000000, -0.966487, 0.000000, 1.000000}, 
{0.752577, 0.000000, 0.460134, 0.000000, 0.743270, 0.000000, -0.919880, 0.000000, 1.000000}, 
{0.776163, 0.000000, 0.447164, 0.000000, 0.767429, 0.000000, -0.873087, 0.000000, 1.000000}, 
{0.800016, 0.000000, 0.433601, 0.000000, 0.790458, 0.000000, -0.825803, 0.000000, 1.000000}, 
{0.822176, 0.000000, 0.418388, 0.000000, 0.812555, 0.000000, -0.778249, 0.000000, 1.000000}, 
{0.844873, 0.000000, 0.402704, 0.000000, 0.833847, 0.000000, -0.730849, 0.000000, 1.000000}, 
{0.865955, 0.000000, 0.385633, 0.000000, 0.854658, 0.000000, -0.684037, 0.000000, 1.000000}, 
{0.888173, 0.000000, 0.368255, 0.000000, 0.874837, 0.000000, -0.637192, 0.000000, 1.000000}, 
{0.910994, 0.000000, 0.349332, 0.000000, 0.894278, 0.000000, -0.590131, 0.000000, 1.000000}, 
{0.934270, 0.000000, 0.329612, 0.000000, 0.913781, 0.000000, -0.543213, 0.000000, 1.000000}, 
{0.956653, 0.000000, 0.309228, 0.000000, 0.933404, 0.000000, -0.497752, 0.000000, 1.000000}, 
{0.978476, 0.000000, 0.288310, 0.000000, 0.953045, 0.000000, -0.452837, 0.000000, 1.000000}, 
{1.000755, 0.000000, 0.267243, 0.000000, 0.972662, 0.000000, -0.409481, 0.000000, 1.000000}, 
{1.023827, 0.000000, 0.246015, 0.000000, 0.993039, 0.000000, -0.367354, 0.000000, 1.000000}, 
{1.045572, 0.000000, 0.223777, 0.000000, 1.013627, 0.000000, -0.325171, 0.000000, 1.000000}, 
{1.070445, 0.000000, 0.200837, 0.000000, 1.036361, 0.000000, -0.284442, 0.000000, 1.000000}, 
{1.094268, 0.000000, 0.177211, 0.000000, 1.059665, 0.000000, -0.245138, 0.000000, 1.000000}, 
{1.118639, 0.000000, 0.153531, 0.000000, 1.082373, 0.000000, -0.208289, 0.000000, 1.000000}, 
{1.139786, 0.000000, 0.129074, 0.000000, 1.102734, 0.000000, -0.173607, 0.000000, 1.000000}, 
{1.157848, 0.000000, 0.104051, 0.000000, 1.120937, 0.000000, -0.140467, 0.000000, 1.000000}, 
{1.170697, 0.000000, 0.077694, 0.000000, 1.138175, 0.000000, -0.105594, 0.000000, 1.000000}, 
{1.177874, 0.000000, 0.051393, 0.000000, 1.154359, 0.000000, -0.069898, 0.000000, 1.000000}, 
{1.182242, 0.000000, 0.025392, 0.000000, 1.170686, 0.000000, -0.034532, 0.000000, 1.000000}, 
{1.187612, 0.000000, 0.000032, 0.000000, 1.187538, 0.000000, 0.000035, 0.000000, 1.000000}, 
{0.000202, 0.000000, 0.000313, 0.000000, 0.000199, 0.000000, -1.548291, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000780, 0.000000, 0.000504, 0.000000, -1.548289, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.003120, 0.000000, 0.002016, 0.000000, -1.548260, 0.000000, 1.000000}, 
{0.004533, 0.000000, 0.007019, 0.000000, 0.004537, 0.000000, -1.548217, 0.000000, 1.000000}, 
{0.008066, 0.000000, 0.012486, 0.000000, 0.008061, 0.000000, -1.548274, 0.000000, 1.000000}, 
{0.012600, 0.000000, 0.019500, 0.000000, 0.012599, 0.000000, -1.548245, 0.000000, 1.000000}, 
{0.018151, 0.000000, 0.028076, 0.000000, 0.018140, 0.000000, -1.548192, 0.000000, 1.000000}, 
{0.024722, 0.000000, 0.038209, 0.000000, 0.024695, 0.000000, -1.548109, 0.000000, 1.000000}, 
{0.032306, 0.000000, 0.049868, 0.000000, 0.032252, 0.000000, -1.547979, 0.000000, 1.000000}, 
{0.040936, 0.000000, 0.063077, 0.000000, 0.040823, 0.000000, -1.547785, 0.000000, 1.000000}, 
{0.050610, 0.000000, 0.077791, 0.000000, 0.050396, 0.000000, -1.547513, 0.000000, 1.000000}, 
{0.061360, 0.000000, 0.093869, 0.000000, 0.060942, 0.000000, -1.547134, 0.000000, 1.000000}, 
{0.073227, 0.000000, 0.111380, 0.000000, 0.072487, 0.000000, -1.546619, 0.000000, 1.000000}, 
{0.086217, 0.000000, 0.130371, 0.000000, 0.085062, 0.000000, -1.545938, 0.000000, 1.000000}, 
{0.100364, 0.000000, 0.150684, 0.000000, 0.098630, 0.000000, -1.545039, 0.000000, 1.000000}, 
{0.115733, 0.000000, 0.172116, 0.000000, 0.113135, 0.000000, -1.543880, 0.000000, 1.000000}, 
{0.132309, 0.000000, 0.194809, 0.000000, 0.128659, 0.000000, -1.542380, 0.000000, 1.000000}, 
{0.150174, 0.000000, 0.218431, 0.000000, 0.145111, 0.000000, -1.540462, 0.000000, 1.000000}, 
{0.169340, 0.000000, 0.242954, 0.000000, 0.162508, 0.000000, -1.538002, 0.000000, 1.000000}, 
{0.189788, 0.000000, 0.268175, 0.000000, 0.180877, 0.000000, -1.534894, 0.000000, 1.000000}, 
{0.211581, 0.000000, 0.293776, 0.000000, 0.200116, 0.000000, -1.530954, 0.000000, 1.000000}, 
{0.234561, 0.000000, 0.319619, 0.000000, 0.220338, 0.000000, -1.526033, 0.000000, 1.000000}, 
{0.258776, 0.000000, 0.345089, 0.000000, 0.241389, 0.000000, -1.519926, 0.000000, 1.000000}, 
{0.284059, 0.000000, 0.370176, 0.000000, 0.263436, 0.000000, -1.512296, 0.000000, 1.000000}, 
{0.310312, 0.000000, 0.394171, 0.000000, 0.286357, 0.000000, -1.502956, 0.000000, 1.000000}, 
{0.336748, 0.000000, 0.416137, 0.000000, 0.310480, 0.000000, -1.491463, 0.000000, 1.000000}, 
{0.364029, 0.000000, 0.436752, 0.000000, 0.335271, 0.000000, -1.477493, 0.000000, 1.000000}, 
{0.391575, 0.000000, 0.455102, 0.000000, 0.361123, 0.000000, -1.460933, 0.000000, 1.000000}, 
{0.419409, 0.000000, 0.471378, 0.000000, 0.387713, 0.000000, -1.441554, 0.000000, 1.000000}, 
{0.446811, 0.000000, 0.484714, 0.000000, 0.415081, 0.000000, -1.418861, 0.000000, 1.000000}, 
{0.474489, 0.000000, 0.496021, 0.000000, 0.442601, 0.000000, -1.393405, 0.000000, 1.000000}, 
{0.501751, 0.000000, 0.504991, 0.000000, 0.470529, 0.000000, -1.364633, 0.000000, 1.000000}, 
{0.528488, 0.000000, 0.511392, 0.000000, 0.498750, 0.000000, -1.333234, 0.000000, 1.000000}, 
{0.554428, 0.000000, 0.515395, 0.000000, 0.526760, 0.000000, -1.299138, 0.000000, 1.000000}, 
{0.580434, 0.000000, 0.517761, 0.000000, 0.554655, 0.000000, -1.262462, 0.000000, 1.000000}, 
{0.605474, 0.000000, 0.517598, 0.000000, 0.582402, 0.000000, -1.223784, 0.000000, 1.000000}, 
{0.629888, 0.000000, 0.514946, 0.000000, 0.610043, 0.000000, -1.182321, 0.000000, 1.000000}, 
{0.655579, 0.000000, 0.510177, 0.000000, 0.637637, 0.000000, -1.138515, 0.000000, 1.000000}, 
{0.681940, 0.000000, 0.503097, 0.000000, 0.664598, 0.000000, -1.091502, 0.000000, 1.000000}, 
{0.707228, 0.000000, 0.493537, 0.000000, 0.691266, 0.000000, -1.043464, 0.000000, 1.000000}, 
{0.731894, 0.000000, 0.482372, 0.000000, 0.716501, 0.000000, -0.994242, 0.000000, 1.000000}, 
{0.756741, 0.000000, 0.470312, 0.000000, 0.741731, 0.000000, -0.944749, 0.000000, 1.000000}, 
{0.780160, 0.000000, 0.456412, 0.000000, 0.765123, 0.000000, -0.894816, 0.000000, 1.000000}, 
{0.803384, 0.000000, 0.441492, 0.000000, 0.787845, 0.000000, -0.845202, 0.000000, 1.000000}, 
{0.826347, 0.000000, 0.425944, 0.000000, 0.810512, 0.000000, -0.795954, 0.000000, 1.000000}, 
{0.849145, 0.000000, 0.409532, 0.000000, 0.831808, 0.000000, -0.746915, 0.000000, 1.000000}, 
{0.870617, 0.000000, 0.391988, 0.000000, 0.852934, 0.000000, -0.698025, 0.000000, 1.000000}, 
{0.892943, 0.000000, 0.374229, 0.000000, 0.872404, 0.000000, -0.649579, 0.000000, 1.000000}, 
{0.913828, 0.000000, 0.355148, 0.000000, 0.892856, 0.000000, -0.601833, 0.000000, 1.000000}, 
{0.936830, 0.000000, 0.335238, 0.000000, 0.912685, 0.000000, -0.554521, 0.000000, 1.000000}, 
{0.958687, 0.000000, 0.313939, 0.000000, 0.931913, 0.000000, -0.507208, 0.000000, 1.000000}, 
{0.982008, 0.000000, 0.292741, 0.000000, 0.951813, 0.000000, -0.461357, 0.000000, 1.000000}, 
{1.003691, 0.000000, 0.270940, 0.000000, 0.971624, 0.000000, -0.416031, 0.000000, 1.000000}, 
{1.027223, 0.000000, 0.249102, 0.000000, 0.992304, 0.000000, -0.372457, 0.000000, 1.000000}, 
{1.050048, 0.000000, 0.226899, 0.000000, 1.014011, 0.000000, -0.330281, 0.000000, 1.000000}, 
{1.074105, 0.000000, 0.204329, 0.000000, 1.036791, 0.000000, -0.288987, 0.000000, 1.000000}, 
{1.098971, 0.000000, 0.180560, 0.000000, 1.060591, 0.000000, -0.249075, 0.000000, 1.000000}, 
{1.123324, 0.000000, 0.155987, 0.000000, 1.083827, 0.000000, -0.211519, 0.000000, 1.000000}, 
{1.145445, 0.000000, 0.130929, 0.000000, 1.104894, 0.000000, -0.176506, 0.000000, 1.000000}, 
{1.162856, 0.000000, 0.105269, 0.000000, 1.123408, 0.000000, -0.142345, 0.000000, 1.000000}, 
{1.175360, 0.000000, 0.079267, 0.000000, 1.141154, 0.000000, -0.107452, 0.000000, 1.000000}, 
{1.182514, 0.000000, 0.052547, 0.000000, 1.158011, 0.000000, -0.071252, 0.000000, 1.000000}, 
{1.186575, 0.000000, 0.025744, 0.000000, 1.174448, 0.000000, -0.035019, 0.000000, 1.000000}, 
{1.192050, 0.000000, -0.000318, 0.000000, 1.192035, 0.000000, 0.000152, 0.000000, 1.000000}, 
{0.000204, 0.000000, 0.000334, 0.000000, 0.000192, 0.000000, -1.636412, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000825, 0.000000, 0.000504, 0.000000, -1.636410, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.003298, 0.000000, 0.002015, 0.000000, -1.636387, 0.000000, 1.000000}, 
{0.004533, 0.000000, 0.007417, 0.000000, 0.004537, 0.000000, -1.636310, 0.000000, 1.000000}, 
{0.008062, 0.000000, 0.013190, 0.000000, 0.008063, 0.000000, -1.636376, 0.000000, 1.000000}, 
{0.012603, 0.000000, 0.020613, 0.000000, 0.012597, 0.000000, -1.636369, 0.000000, 1.000000}, 
{0.018153, 0.000000, 0.029675, 0.000000, 0.018141, 0.000000, -1.636299, 0.000000, 1.000000}, 
{0.024723, 0.000000, 0.040378, 0.000000, 0.024692, 0.000000, -1.636196, 0.000000, 1.000000}, 
{0.032318, 0.000000, 0.052708, 0.000000, 0.032252, 0.000000, -1.636038, 0.000000, 1.000000}, 
{0.040955, 0.000000, 0.066660, 0.000000, 0.040818, 0.000000, -1.635810, 0.000000, 1.000000}, 
{0.050645, 0.000000, 0.082203, 0.000000, 0.050395, 0.000000, -1.635494, 0.000000, 1.000000}, 
{0.061429, 0.000000, 0.099150, 0.000000, 0.060927, 0.000000, -1.635048, 0.000000, 1.000000}, 
{0.073333, 0.000000, 0.117679, 0.000000, 0.072481, 0.000000, -1.634437, 0.000000, 1.000000}, 
{0.086388, 0.000000, 0.137725, 0.000000, 0.085046, 0.000000, -1.633634, 0.000000, 1.000000}, 
{0.100620, 0.000000, 0.159081, 0.000000, 0.098586, 0.000000, -1.632571, 0.000000, 1.000000}, 
{0.116087, 0.000000, 0.181721, 0.000000, 0.113099, 0.000000, -1.631202, 0.000000, 1.000000}, 
{0.132820, 0.000000, 0.205611, 0.000000, 0.128605, 0.000000, -1.629432, 0.000000, 1.000000}, 
{0.150867, 0.000000, 0.230542, 0.000000, 0.145049, 0.000000, -1.627161, 0.000000, 1.000000}, 
{0.170234, 0.000000, 0.256239, 0.000000, 0.162417, 0.000000, -1.624266, 0.000000, 1.000000}, 
{0.190981, 0.000000, 0.282751, 0.000000, 0.180752, 0.000000, -1.620589, 0.000000, 1.000000}, 
{0.213013, 0.000000, 0.309430, 0.000000, 0.199966, 0.000000, -1.615999, 0.000000, 1.000000}, 
{0.236387, 0.000000, 0.336427, 0.000000, 0.220126, 0.000000, -1.610216, 0.000000, 1.000000}, 
{0.260943, 0.000000, 0.362931, 0.000000, 0.241197, 0.000000, -1.603047, 0.000000, 1.000000}, 
{0.286497, 0.000000, 0.388644, 0.000000, 0.263203, 0.000000, -1.593920, 0.000000, 1.000000}, 
{0.312769, 0.000000, 0.412912, 0.000000, 0.286256, 0.000000, -1.582961, 0.000000, 1.000000}, 
{0.339832, 0.000000, 0.435635, 0.000000, 0.310210, 0.000000, -1.569343, 0.000000, 1.000000}, 
{0.367214, 0.000000, 0.456181, 0.000000, 0.335222, 0.000000, -1.553137, 0.000000, 1.000000}, 
{0.394935, 0.000000, 0.474325, 0.000000, 0.361043, 0.000000, -1.533791, 0.000000, 1.000000}, 
{0.422935, 0.000000, 0.490318, 0.000000, 0.387722, 0.000000, -1.511093, 0.000000, 1.000000}, 
{0.451166, 0.000000, 0.503827, 0.000000, 0.414776, 0.000000, -1.485145, 0.000000, 1.000000}, 
{0.478695, 0.000000, 0.514185, 0.000000, 0.442467, 0.000000, -1.455617, 0.000000, 1.000000}, 
{0.506313, 0.000000, 0.522502, 0.000000, 0.470269, 0.000000, -1.422946, 0.000000, 1.000000}, 
{0.533427, 0.000000, 0.528119, 0.000000, 0.498350, 0.000000, -1.387843, 0.000000, 1.000000}, 
{0.559942, 0.000000, 0.531430, 0.000000, 0.526228, 0.000000, -1.349542, 0.000000, 1.000000}, 
{0.585150, 0.000000, 0.531978, 0.000000, 0.554251, 0.000000, -1.309303, 0.000000, 1.000000}, 
{0.610500, 0.000000, 0.531054, 0.000000, 0.581588, 0.000000, -1.266280, 0.000000, 1.000000}, 
{0.635380, 0.000000, 0.528058, 0.000000, 0.609190, 0.000000, -1.221709, 0.000000, 1.000000}, 
{0.659852, 0.000000, 0.522751, 0.000000, 0.636120, 0.000000, -1.175062, 0.000000, 1.000000}, 
{0.685151, 0.000000, 0.515026, 0.000000, 0.662561, 0.000000, -1.125078, 0.000000, 1.000000}, 
{0.710920, 0.000000, 0.505020, 0.000000, 0.688946, 0.000000, -1.074296, 0.000000, 1.000000}, 
{0.736066, 0.000000, 0.493268, 0.000000, 0.714592, 0.000000, -1.022420, 0.000000, 1.000000}, 
{0.760503, 0.000000, 0.480032, 0.000000, 0.739322, 0.000000, -0.970230, 0.000000, 1.000000}, 
{0.785091, 0.000000, 0.465986, 0.000000, 0.762815, 0.000000, -0.917077, 0.000000, 1.000000}, 
{0.807523, 0.000000, 0.449721, 0.000000, 0.785849, 0.000000, -0.864888, 0.000000, 1.000000}, 
{0.830974, 0.000000, 0.433461, 0.000000, 0.807539, 0.000000, -0.813006, 0.000000, 1.000000}, 
{0.852659, 0.000000, 0.415808, 0.000000, 0.829888, 0.000000, -0.761689, 0.000000, 1.000000}, 
{0.874841, 0.000000, 0.397855, 0.000000, 0.850863, 0.000000, -0.711258, 0.000000, 1.000000}, 
{0.896322, 0.000000, 0.379041, 0.000000, 0.871139, 0.000000, -0.661721, 0.000000, 1.000000}, 
{0.918134, 0.000000, 0.360048, 0.000000, 0.890506, 0.000000, -0.612263, 0.000000, 1.000000}, 
{0.939356, 0.000000, 0.340108, 0.000000, 0.910725, 0.000000, -0.564369, 0.000000, 1.000000}, 
{0.961025, 0.000000, 0.318877, 0.000000, 0.930118, 0.000000, -0.516506, 0.000000, 1.000000}, 
{0.984371, 0.000000, 0.297130, 0.000000, 0.949427, 0.000000, -0.469342, 0.000000, 1.000000}, 
{1.006905, 0.000000, 0.274661, 0.000000, 0.970317, 0.000000, -0.423080, 0.000000, 1.000000}, 
{1.029941, 0.000000, 0.252234, 0.000000, 0.991453, 0.000000, -0.378315, 0.000000, 1.000000}, 
{1.052751, 0.000000, 0.229268, 0.000000, 1.013527, 0.000000, -0.335169, 0.000000, 1.000000}, 
{1.077981, 0.000000, 0.206662, 0.000000, 1.037205, 0.000000, -0.293336, 0.000000, 1.000000}, 
{1.102542, 0.000000, 0.183331, 0.000000, 1.061800, 0.000000, -0.252984, 0.000000, 1.000000}, 
{1.126539, 0.000000, 0.158797, 0.000000, 1.085827, 0.000000, -0.214990, 0.000000, 1.000000}, 
{1.149023, 0.000000, 0.133014, 0.000000, 1.107483, 0.000000, -0.178903, 0.000000, 1.000000}, 
{1.167550, 0.000000, 0.106641, 0.000000, 1.126371, 0.000000, -0.144559, 0.000000, 1.000000}, 
{1.179994, 0.000000, 0.079952, 0.000000, 1.144451, 0.000000, -0.108667, 0.000000, 1.000000}, 
{1.187104, 0.000000, 0.053316, 0.000000, 1.161584, 0.000000, -0.072209, 0.000000, 1.000000}, 
{1.191406, 0.000000, 0.026826, 0.000000, 1.178866, 0.000000, -0.035833, 0.000000, 1.000000}, 
{1.196748, 0.000000, -0.000226, 0.000000, 1.196707, 0.000000, 0.000061, 0.000000, 1.000000}, 
{0.000200, 0.000000, 0.000346, 0.000000, 0.000200, 0.000000, -1.732034, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000873, 0.000000, 0.000504, 0.000000, -1.732038, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.003492, 0.000000, 0.002015, 0.000000, -1.732012, 0.000000, 1.000000}, 
{0.004538, 0.000000, 0.007859, 0.000000, 0.004531, 0.000000, -1.731962, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.013963, 0.000000, 0.008065, 0.000000, -1.731999, 0.000000, 1.000000}, 
{0.012590, 0.000000, 0.021794, 0.000000, 0.012600, 0.000000, -1.732004, 0.000000, 1.000000}, 
{0.018154, 0.000000, 0.031406, 0.000000, 0.018140, 0.000000, -1.731901, 0.000000, 1.000000}, 
{0.024727, 0.000000, 0.042733, 0.000000, 0.024692, 0.000000, -1.731774, 0.000000, 1.000000}, 
{0.032327, 0.000000, 0.055781, 0.000000, 0.032253, 0.000000, -1.731599, 0.000000, 1.000000}, 
{0.040974, 0.000000, 0.070543, 0.000000, 0.040819, 0.000000, -1.731325, 0.000000, 1.000000}, 
{0.050685, 0.000000, 0.086984, 0.000000, 0.050390, 0.000000, -1.730945, 0.000000, 1.000000}, 
{0.061506, 0.000000, 0.104897, 0.000000, 0.060915, 0.000000, -1.730417, 0.000000, 1.000000}, 
{0.073458, 0.000000, 0.124506, 0.000000, 0.072470, 0.000000, -1.729697, 0.000000, 1.000000}, 
{0.086573, 0.000000, 0.145706, 0.000000, 0.085041, 0.000000, -1.728747, 0.000000, 1.000000}, 
{0.100909, 0.000000, 0.168211, 0.000000, 0.098549, 0.000000, -1.727491, 0.000000, 1.000000}, 
{0.116509, 0.000000, 0.192198, 0.000000, 0.113076, 0.000000, -1.725854, 0.000000, 1.000000}, 
{0.133404, 0.000000, 0.217280, 0.000000, 0.128530, 0.000000, -1.723749, 0.000000, 1.000000}, 
{0.151659, 0.000000, 0.243556, 0.000000, 0.144967, 0.000000, -1.721093, 0.000000, 1.000000}, 
{0.171288, 0.000000, 0.270611, 0.000000, 0.162311, 0.000000, -1.717640, 0.000000, 1.000000}, 
{0.192301, 0.000000, 0.298389, 0.000000, 0.180614, 0.000000, -1.713272, 0.000000, 1.000000}, 
{0.214683, 0.000000, 0.326338, 0.000000, 0.199787, 0.000000, -1.707825, 0.000000, 1.000000}, 
{0.238392, 0.000000, 0.354394, 0.000000, 0.219940, 0.000000, -1.700956, 0.000000, 1.000000}, 
{0.263151, 0.000000, 0.381636, 0.000000, 0.241047, 0.000000, -1.692392, 0.000000, 1.000000}, 
{0.289155, 0.000000, 0.408266, 0.000000, 0.263012, 0.000000, -1.681769, 0.000000, 1.000000}, 
{0.315832, 0.000000, 0.433070, 0.000000, 0.286044, 0.000000, -1.668539, 0.000000, 1.000000}, 
{0.342942, 0.000000, 0.455741, 0.000000, 0.310084, 0.000000, -1.652513, 0.000000, 1.000000}, 
{0.370892, 0.000000, 0.476655, 0.000000, 0.334974, 0.000000, -1.633428, 0.000000, 1.000000}, 
{0.398985, 0.000000, 0.494692, 0.000000, 0.360726, 0.000000, -1.610694, 0.000000, 1.000000}, 
{0.427206, 0.000000, 0.510313, 0.000000, 0.387387, 0.000000, -1.584240, 0.000000, 1.000000}, 
{0.455266, 0.000000, 0.522760, 0.000000, 0.414520, 0.000000, -1.554195, 0.000000, 1.000000}, 
{0.483472, 0.000000, 0.532872, 0.000000, 0.442013, 0.000000, -1.520805, 0.000000, 1.000000}, 
{0.511192, 0.000000, 0.540229, 0.000000, 0.469883, 0.000000, -1.484026, 0.000000, 1.000000}, 
{0.538706, 0.000000, 0.545105, 0.000000, 0.497685, 0.000000, -1.443796, 0.000000, 1.000000}, 
{0.565422, 0.000000, 0.547251, 0.000000, 0.525617, 0.000000, -1.401429, 0.000000, 1.000000}, 
{0.591270, 0.000000, 0.547115, 0.000000, 0.553589, 0.000000, -1.356231, 0.000000, 1.000000}, 
{0.616787, 0.000000, 0.545113, 0.000000, 0.580582, 0.000000, -1.308887, 0.000000, 1.000000}, 
{0.641380, 0.000000, 0.540853, 0.000000, 0.607628, 0.000000, -1.260447, 0.000000, 1.000000}, 
{0.665344, 0.000000, 0.534561, 0.000000, 0.634284, 0.000000, -1.210634, 0.000000, 1.000000}, 
{0.690147, 0.000000, 0.527115, 0.000000, 0.660403, 0.000000, -1.158569, 0.000000, 1.000000}, 
{0.714578, 0.000000, 0.516171, 0.000000, 0.686714, 0.000000, -1.104593, 0.000000, 1.000000}, 
{0.740349, 0.000000, 0.504048, 0.000000, 0.712069, 0.000000, -1.049578, 0.000000, 1.000000}, 
{0.764563, 0.000000, 0.489683, 0.000000, 0.736796, 0.000000, -0.994458, 0.000000, 1.000000}, 
{0.788710, 0.000000, 0.474541, 0.000000, 0.759717, 0.000000, -0.938612, 0.000000, 1.000000}, 
{0.812154, 0.000000, 0.458099, 0.000000, 0.782895, 0.000000, -0.883694, 0.000000, 1.000000}, 
{0.834566, 0.000000, 0.440345, 0.000000, 0.805445, 0.000000, -0.830220, 0.000000, 1.000000}, 
{0.857486, 0.000000, 0.422491, 0.000000, 0.827384, 0.000000, -0.776499, 0.000000, 1.000000}, 
{0.879224, 0.000000, 0.403588, 0.000000, 0.848520, 0.000000, -0.724257, 0.000000, 1.000000}, 
{0.899971, 0.000000, 0.383819, 0.000000, 0.868937, 0.000000, -0.673311, 0.000000, 1.000000}, 
{0.922111, 0.000000, 0.364250, 0.000000, 0.888903, 0.000000, -0.622999, 0.000000, 1.000000}, 
{0.942842, 0.000000, 0.343873, 0.000000, 0.909128, 0.000000, -0.573304, 0.000000, 1.000000}, 
{0.964398, 0.000000, 0.323206, 0.000000, 0.928817, 0.000000, -0.525090, 0.000000, 1.000000}, 
{0.986860, 0.000000, 0.301711, 0.000000, 0.948939, 0.000000, -0.477580, 0.000000, 1.000000}, 
{1.009760, 0.000000, 0.278695, 0.000000, 0.969627, 0.000000, -0.430624, 0.000000, 1.000000}, 
{1.033347, 0.000000, 0.255591, 0.000000, 0.991156, 0.000000, -0.384482, 0.000000, 1.000000}, 
{1.055937, 0.000000, 0.232039, 0.000000, 1.013588, 0.000000, -0.340532, 0.000000, 1.000000}, 
{1.081178, 0.000000, 0.208664, 0.000000, 1.037291, 0.000000, -0.297311, 0.000000, 1.000000}, 
{1.105696, 0.000000, 0.184935, 0.000000, 1.062687, 0.000000, -0.256227, 0.000000, 1.000000}, 
{1.129575, 0.000000, 0.160673, 0.000000, 1.087436, 0.000000, -0.217709, 0.000000, 1.000000}, 
{1.152135, 0.000000, 0.135414, 0.000000, 1.109431, 0.000000, -0.181471, 0.000000, 1.000000}, 
{1.171221, 0.000000, 0.108462, 0.000000, 1.129449, 0.000000, -0.146380, 0.000000, 1.000000}, 
{1.184412, 0.000000, 0.081008, 0.000000, 1.147773, 0.000000, -0.110120, 0.000000, 1.000000}, 
{1.191820, 0.000000, 0.053710, 0.000000, 1.165553, 0.000000, -0.073052, 0.000000, 1.000000}, 
{1.196195, 0.000000, 0.026625, 0.000000, 1.183177, 0.000000, -0.036129, 0.000000, 1.000000}, 
{1.201677, 0.000000, 0.000175, 0.000000, 1.201743, 0.000000, -0.000098, 0.000000, 1.000000}, 
{0.000196, 0.000000, 0.000360, 0.000000, 0.000209, 0.000000, -1.836290, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000925, 0.000000, 0.000504, 0.000000, -1.836295, 0.000000, 1.000000}, 
{0.002018, 0.000000, 0.003706, 0.000000, 0.002012, 0.000000, -1.836243, 0.000000, 1.000000}, 
{0.004534, 0.000000, 0.008324, 0.000000, 0.004535, 0.000000, -1.836210, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.014805, 0.000000, 0.008062, 0.000000, -1.836256, 0.000000, 1.000000}, 
{0.012597, 0.000000, 0.023116, 0.000000, 0.012625, 0.000000, -1.836259, 0.000000, 1.000000}, 
{0.018158, 0.000000, 0.033299, 0.000000, 0.018140, 0.000000, -1.836123, 0.000000, 1.000000}, 
{0.024732, 0.000000, 0.045301, 0.000000, 0.024689, 0.000000, -1.835988, 0.000000, 1.000000}, 
{0.032344, 0.000000, 0.059143, 0.000000, 0.032249, 0.000000, -1.835768, 0.000000, 1.000000}, 
{0.040999, 0.000000, 0.074779, 0.000000, 0.040810, 0.000000, -1.835454, 0.000000, 1.000000}, 
{0.050739, 0.000000, 0.092178, 0.000000, 0.050382, 0.000000, -1.834974, 0.000000, 1.000000}, 
{0.061594, 0.000000, 0.111161, 0.000000, 0.060906, 0.000000, -1.834355, 0.000000, 1.000000}, 
{0.073604, 0.000000, 0.131958, 0.000000, 0.072463, 0.000000, -1.833499, 0.000000, 1.000000}, 
{0.086796, 0.000000, 0.154393, 0.000000, 0.085029, 0.000000, -1.832355, 0.000000, 1.000000}, 
{0.101246, 0.000000, 0.178201, 0.000000, 0.098524, 0.000000, -1.830880, 0.000000, 1.000000}, 
{0.116990, 0.000000, 0.203531, 0.000000, 0.113031, 0.000000, -1.828936, 0.000000, 1.000000}, 
{0.134086, 0.000000, 0.230043, 0.000000, 0.128469, 0.000000, -1.826442, 0.000000, 1.000000}, 
{0.152589, 0.000000, 0.257718, 0.000000, 0.144868, 0.000000, -1.823230, 0.000000, 1.000000}, 
{0.172514, 0.000000, 0.286176, 0.000000, 0.162168, 0.000000, -1.819124, 0.000000, 1.000000}, 
{0.193853, 0.000000, 0.315295, 0.000000, 0.180430, 0.000000, -1.813909, 0.000000, 1.000000}, 
{0.216582, 0.000000, 0.344507, 0.000000, 0.199576, 0.000000, -1.807410, 0.000000, 1.000000}, 
{0.240668, 0.000000, 0.373646, 0.000000, 0.219720, 0.000000, -1.799084, 0.000000, 1.000000}, 
{0.265904, 0.000000, 0.401897, 0.000000, 0.240705, 0.000000, -1.788905, 0.000000, 1.000000}, 
{0.292226, 0.000000, 0.429136, 0.000000, 0.262748, 0.000000, -1.776206, 0.000000, 1.000000}, 
{0.319045, 0.000000, 0.454057, 0.000000, 0.285828, 0.000000, -1.760500, 0.000000, 1.000000}, 
{0.346721, 0.000000, 0.477219, 0.000000, 0.309882, 0.000000, -1.741586, 0.000000, 1.000000}, 
{0.374849, 0.000000, 0.497883, 0.000000, 0.334803, 0.000000, -1.718818, 0.000000, 1.000000}, 
{0.403078, 0.000000, 0.515504, 0.000000, 0.360594, 0.000000, -1.692138, 0.000000, 1.000000}, 
{0.431597, 0.000000, 0.530621, 0.000000, 0.387217, 0.000000, -1.661434, 0.000000, 1.000000}, 
{0.460246, 0.000000, 0.542852, 0.000000, 0.414288, 0.000000, -1.626989, 0.000000, 1.000000}, 
{0.488899, 0.000000, 0.552238, 0.000000, 0.441601, 0.000000, -1.588582, 0.000000, 1.000000}, 
{0.517215, 0.000000, 0.559045, 0.000000, 0.469290, 0.000000, -1.546300, 0.000000, 1.000000}, 
{0.544480, 0.000000, 0.562351, 0.000000, 0.497009, 0.000000, -1.501299, 0.000000, 1.000000}, 
{0.571542, 0.000000, 0.563394, 0.000000, 0.524700, 0.000000, -1.453758, 0.000000, 1.000000}, 
{0.598167, 0.000000, 0.562590, 0.000000, 0.552027, 0.000000, -1.403321, 0.000000, 1.000000}, 
{0.624104, 0.000000, 0.559636, 0.000000, 0.579218, 0.000000, -1.352431, 0.000000, 1.000000}, 
{0.648789, 0.000000, 0.554148, 0.000000, 0.605756, 0.000000, -1.298758, 0.000000, 1.000000}, 
{0.672715, 0.000000, 0.546779, 0.000000, 0.632367, 0.000000, -1.244943, 0.000000, 1.000000}, 
{0.696258, 0.000000, 0.537896, 0.000000, 0.658165, 0.000000, -1.189971, 0.000000, 1.000000}, 
{0.720048, 0.000000, 0.527401, 0.000000, 0.683706, 0.000000, -1.134526, 0.000000, 1.000000}, 
{0.744078, 0.000000, 0.514142, 0.000000, 0.708978, 0.000000, -1.076504, 0.000000, 1.000000}, 
{0.768895, 0.000000, 0.499352, 0.000000, 0.733744, 0.000000, -1.018032, 0.000000, 1.000000}, 
{0.792551, 0.000000, 0.482982, 0.000000, 0.757325, 0.000000, -0.960250, 0.000000, 1.000000}, 
{0.817007, 0.000000, 0.466406, 0.000000, 0.780412, 0.000000, -0.903029, 0.000000, 1.000000}, 
{0.839035, 0.000000, 0.447616, 0.000000, 0.802874, 0.000000, -0.846484, 0.000000, 1.000000}, 
{0.862742, 0.000000, 0.429261, 0.000000, 0.824356, 0.000000, -0.791420, 0.000000, 1.000000}, 
{0.884307, 0.000000, 0.409479, 0.000000, 0.845441, 0.000000, -0.737125, 0.000000, 1.000000}, 
{0.905641, 0.000000, 0.389303, 0.000000, 0.866259, 0.000000, -0.683912, 0.000000, 1.000000}, 
{0.926185, 0.000000, 0.368344, 0.000000, 0.887156, 0.000000, -0.632690, 0.000000, 1.000000}, 
{0.947229, 0.000000, 0.347366, 0.000000, 0.906825, 0.000000, -0.581739, 0.000000, 1.000000}, 
{0.969502, 0.000000, 0.326720, 0.000000, 0.927201, 0.000000, -0.532305, 0.000000, 1.000000}, 
{0.990758, 0.000000, 0.304973, 0.000000, 0.947876, 0.000000, -0.484166, 0.000000, 1.000000}, 
{1.012749, 0.000000, 0.282816, 0.000000, 0.968824, 0.000000, -0.437385, 0.000000, 1.000000}, 
{1.035533, 0.000000, 0.259084, 0.000000, 0.990923, 0.000000, -0.390755, 0.000000, 1.000000}, 
{1.059915, 0.000000, 0.235239, 0.000000, 1.014020, 0.000000, -0.345399, 0.000000, 1.000000}, 
{1.084348, 0.000000, 0.211044, 0.000000, 1.038059, 0.000000, -0.301356, 0.000000, 1.000000}, 
{1.109544, 0.000000, 0.186698, 0.000000, 1.063499, 0.000000, -0.259708, 0.000000, 1.000000}, 
{1.133770, 0.000000, 0.161900, 0.000000, 1.089019, 0.000000, -0.220324, 0.000000, 1.000000}, 
{1.157553, 0.000000, 0.136604, 0.000000, 1.112377, 0.000000, -0.183857, 0.000000, 1.000000}, 
{1.176461, 0.000000, 0.110428, 0.000000, 1.132704, 0.000000, -0.148521, 0.000000, 1.000000}, 
{1.190137, 0.000000, 0.082898, 0.000000, 1.151656, 0.000000, -0.112124, 0.000000, 1.000000}, 
{1.197215, 0.000000, 0.054554, 0.000000, 1.169857, 0.000000, -0.074160, 0.000000, 1.000000}, 
{1.201654, 0.000000, 0.026744, 0.000000, 1.188061, 0.000000, -0.036527, 0.000000, 1.000000}, 
{1.207085, 0.000000, -0.000399, 0.000000, 1.207044, 0.000000, 0.000201, 0.000000, 1.000000}, 
{0.000191, 0.000000, 0.000373, 0.000000, 0.000219, 0.000000, -1.950551, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.000983, 0.000000, 0.000504, 0.000000, -1.950552, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.003931, 0.000000, 0.002016, 0.000000, -1.950518, 0.000000, 1.000000}, 
{0.004536, 0.000000, 0.008847, 0.000000, 0.004535, 0.000000, -1.950472, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.015725, 0.000000, 0.008063, 0.000000, -1.950517, 0.000000, 1.000000}, 
{0.012693, 0.000000, 0.024740, 0.000000, 0.012624, 0.000000, -1.949914, 0.000000, 1.000000}, 
{0.018159, 0.000000, 0.035365, 0.000000, 0.018141, 0.000000, -1.950349, 0.000000, 1.000000}, 
{0.024740, 0.000000, 0.048122, 0.000000, 0.024689, 0.000000, -1.950183, 0.000000, 1.000000}, 
{0.032361, 0.000000, 0.062822, 0.000000, 0.032252, 0.000000, -1.949917, 0.000000, 1.000000}, 
{0.041034, 0.000000, 0.079430, 0.000000, 0.040813, 0.000000, -1.949538, 0.000000, 1.000000}, 
{0.050815, 0.000000, 0.097841, 0.000000, 0.050343, 0.000000, -1.948972, 0.000000, 1.000000}, 
{0.061702, 0.000000, 0.118026, 0.000000, 0.060892, 0.000000, -1.948246, 0.000000, 1.000000}, 
{0.073766, 0.000000, 0.140112, 0.000000, 0.072459, 0.000000, -1.947204, 0.000000, 1.000000}, 
{0.087066, 0.000000, 0.163819, 0.000000, 0.084979, 0.000000, -1.945855, 0.000000, 1.000000}, 
{0.101637, 0.000000, 0.189122, 0.000000, 0.098497, 0.000000, -1.944052, 0.000000, 1.000000}, 
{0.117558, 0.000000, 0.215884, 0.000000, 0.112963, 0.000000, -1.941710, 0.000000, 1.000000}, 
{0.134884, 0.000000, 0.243968, 0.000000, 0.128384, 0.000000, -1.938727, 0.000000, 1.000000}, 
{0.153637, 0.000000, 0.273170, 0.000000, 0.144775, 0.000000, -1.934891, 0.000000, 1.000000}, 
{0.173890, 0.000000, 0.303146, 0.000000, 0.162046, 0.000000, -1.929976, 0.000000, 1.000000}, 
{0.195643, 0.000000, 0.333704, 0.000000, 0.180255, 0.000000, -1.923740, 0.000000, 1.000000}, 
{0.218767, 0.000000, 0.364170, 0.000000, 0.199372, 0.000000, -1.915888, 0.000000, 1.000000}, 
{0.243337, 0.000000, 0.394530, 0.000000, 0.219446, 0.000000, -1.905970, 0.000000, 1.000000}, 
{0.268860, 0.000000, 0.423512, 0.000000, 0.240528, 0.000000, -1.893623, 0.000000, 1.000000}, 
{0.295173, 0.000000, 0.450609, 0.000000, 0.262685, 0.000000, -1.878286, 0.000000, 1.000000}, 
{0.322784, 0.000000, 0.476488, 0.000000, 0.285649, 0.000000, -1.859391, 0.000000, 1.000000}, 
{0.350616, 0.000000, 0.499420, 0.000000, 0.309757, 0.000000, -1.836912, 0.000000, 1.000000}, 
{0.379127, 0.000000, 0.519862, 0.000000, 0.334645, 0.000000, -1.809625, 0.000000, 1.000000}, 
{0.407860, 0.000000, 0.537373, 0.000000, 0.360527, 0.000000, -1.778529, 0.000000, 1.000000}, 
{0.436717, 0.000000, 0.551802, 0.000000, 0.386754, 0.000000, -1.742684, 0.000000, 1.000000}, 
{0.465345, 0.000000, 0.562951, 0.000000, 0.413771, 0.000000, -1.702289, 0.000000, 1.000000}, 
{0.494158, 0.000000, 0.571334, 0.000000, 0.441181, 0.000000, -1.658666, 0.000000, 1.000000}, 
{0.522896, 0.000000, 0.577227, 0.000000, 0.468552, 0.000000, -1.611027, 0.000000, 1.000000}, 
{0.551379, 0.000000, 0.580514, 0.000000, 0.495923, 0.000000, -1.559742, 0.000000, 1.000000}, 
{0.578992, 0.000000, 0.580610, 0.000000, 0.523309, 0.000000, -1.507257, 0.000000, 1.000000}, 
{0.605095, 0.000000, 0.577729, 0.000000, 0.550774, 0.000000, -1.451941, 0.000000, 1.000000}, 
{0.630653, 0.000000, 0.573000, 0.000000, 0.577472, 0.000000, -1.395218, 0.000000, 1.000000}, 
{0.656175, 0.000000, 0.566944, 0.000000, 0.604148, 0.000000, -1.337862, 0.000000, 1.000000}, 
{0.681036, 0.000000, 0.558988, 0.000000, 0.629889, 0.000000, -1.279275, 0.000000, 1.000000}, 
{0.704713, 0.000000, 0.549211, 0.000000, 0.655726, 0.000000, -1.220526, 0.000000, 1.000000}, 
{0.726894, 0.000000, 0.537190, 0.000000, 0.681160, 0.000000, -1.161709, 0.000000, 1.000000}, 
{0.749865, 0.000000, 0.524167, 0.000000, 0.705729, 0.000000, -1.102095, 0.000000, 1.000000}, 
{0.773553, 0.000000, 0.508991, 0.000000, 0.730239, 0.000000, -1.042039, 0.000000, 1.000000}, 
{0.797102, 0.000000, 0.491658, 0.000000, 0.753996, 0.000000, -0.981588, 0.000000, 1.000000}, 
{0.821187, 0.000000, 0.474093, 0.000000, 0.776394, 0.000000, -0.921265, 0.000000, 1.000000}, 
{0.843848, 0.000000, 0.454980, 0.000000, 0.799178, 0.000000, -0.862757, 0.000000, 1.000000}, 
{0.866662, 0.000000, 0.435421, 0.000000, 0.821214, 0.000000, -0.804700, 0.000000, 1.000000}, 
{0.888696, 0.000000, 0.414990, 0.000000, 0.842419, 0.000000, -0.749432, 0.000000, 1.000000}, 
{0.910945, 0.000000, 0.394472, 0.000000, 0.863297, 0.000000, -0.694767, 0.000000, 1.000000}, 
{0.932300, 0.000000, 0.373239, 0.000000, 0.884111, 0.000000, -0.641106, 0.000000, 1.000000}, 
{0.952850, 0.000000, 0.351347, 0.000000, 0.904711, 0.000000, -0.589689, 0.000000, 1.000000}, 
{0.974718, 0.000000, 0.329809, 0.000000, 0.925853, 0.000000, -0.539322, 0.000000, 1.000000}, 
{0.996445, 0.000000, 0.307902, 0.000000, 0.946413, 0.000000, -0.490083, 0.000000, 1.000000}, 
{1.017580, 0.000000, 0.285392, 0.000000, 0.968276, 0.000000, -0.442702, 0.000000, 1.000000}, 
{1.040342, 0.000000, 0.262782, 0.000000, 0.989952, 0.000000, -0.395911, 0.000000, 1.000000}, 
{1.064399, 0.000000, 0.238995, 0.000000, 1.014481, 0.000000, -0.350206, 0.000000, 1.000000}, 
{1.089464, 0.000000, 0.214297, 0.000000, 1.039279, 0.000000, -0.305175, 0.000000, 1.000000}, 
{1.115565, 0.000000, 0.189293, 0.000000, 1.066047, 0.000000, -0.262686, 0.000000, 1.000000}, 
{1.140640, 0.000000, 0.163843, 0.000000, 1.092019, 0.000000, -0.223078, 0.000000, 1.000000}, 
{1.163824, 0.000000, 0.137789, 0.000000, 1.115750, 0.000000, -0.185651, 0.000000, 1.000000}, 
{1.182577, 0.000000, 0.111087, 0.000000, 1.136063, 0.000000, -0.150045, 0.000000, 1.000000}, 
{1.195775, 0.000000, 0.083945, 0.000000, 1.155674, 0.000000, -0.113457, 0.000000, 1.000000}, 
{1.203175, 0.000000, 0.056145, 0.000000, 1.174507, 0.000000, -0.075453, 0.000000, 1.000000}, 
{1.207282, 0.000000, 0.027685, 0.000000, 1.193333, 0.000000, -0.037217, 0.000000, 1.000000}, 
{1.213019, 0.000000, -0.000362, 0.000000, 1.213094, 0.000000, 0.000293, 0.000000, 1.000000}, 
{0.000187, 0.000000, 0.000388, 0.000000, 0.000230, 0.000000, -2.076500, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.001048, 0.000000, 0.000504, 0.000000, -2.076499, 0.000000, 1.000000}, 
{0.002014, 0.000000, 0.004182, 0.000000, 0.002016, 0.000000, -2.076523, 0.000000, 1.000000}, 
{0.004539, 0.000000, 0.009425, 0.000000, 0.004534, 0.000000, -2.076453, 0.000000, 1.000000}, 
{0.008063, 0.000000, 0.016737, 0.000000, 0.008060, 0.000000, -2.076410, 0.000000, 1.000000}, 
{0.012614, 0.000000, 0.026171, 0.000000, 0.012594, 0.000000, -2.076389, 0.000000, 1.000000}, 
{0.018158, 0.000000, 0.037641, 0.000000, 0.018145, 0.000000, -2.076265, 0.000000, 1.000000}, 
{0.024767, 0.000000, 0.051266, 0.000000, 0.024683, 0.000000, -2.076044, 0.000000, 1.000000}, 
{0.032372, 0.000000, 0.066859, 0.000000, 0.032248, 0.000000, -2.075743, 0.000000, 1.000000}, 
{0.041066, 0.000000, 0.084538, 0.000000, 0.040813, 0.000000, -2.075270, 0.000000, 1.000000}, 
{0.050871, 0.000000, 0.104062, 0.000000, 0.050339, 0.000000, -2.074622, 0.000000, 1.000000}, 
{0.061821, 0.000000, 0.125613, 0.000000, 0.060888, 0.000000, -2.073708, 0.000000, 1.000000}, 
{0.073970, 0.000000, 0.149085, 0.000000, 0.072436, 0.000000, -2.072457, 0.000000, 1.000000}, 
{0.087375, 0.000000, 0.174214, 0.000000, 0.084940, 0.000000, -2.070804, 0.000000, 1.000000}, 
{0.102105, 0.000000, 0.201136, 0.000000, 0.098453, 0.000000, -2.068647, 0.000000, 1.000000}, 
{0.118223, 0.000000, 0.229505, 0.000000, 0.112907, 0.000000, -2.065846, 0.000000, 1.000000}, 
{0.135814, 0.000000, 0.259217, 0.000000, 0.128288, 0.000000, -2.062189, 0.000000, 1.000000}, 
{0.154887, 0.000000, 0.289990, 0.000000, 0.144626, 0.000000, -2.057566, 0.000000, 1.000000}, 
{0.175510, 0.000000, 0.321618, 0.000000, 0.161865, 0.000000, -2.051593, 0.000000, 1.000000}, 
{0.197636, 0.000000, 0.353632, 0.000000, 0.180048, 0.000000, -2.043949, 0.000000, 1.000000}, 
{0.221168, 0.000000, 0.385303, 0.000000, 0.199138, 0.000000, -2.034445, 0.000000, 1.000000}, 
{0.246099, 0.000000, 0.416511, 0.000000, 0.219205, 0.000000, -2.022368, 0.000000, 1.000000}, 
{0.272070, 0.000000, 0.446377, 0.000000, 0.240297, 0.000000, -2.007160, 0.000000, 1.000000}, 
{0.299090, 0.000000, 0.474279, 0.000000, 0.262345, 0.000000, -1.988598, 0.000000, 1.000000}, 
{0.326702, 0.000000, 0.499809, 0.000000, 0.285555, 0.000000, -1.965865, 0.000000, 1.000000}, 
{0.355017, 0.000000, 0.522790, 0.000000, 0.309596, 0.000000, -1.938705, 0.000000, 1.000000}, 
{0.383856, 0.000000, 0.542755, 0.000000, 0.334410, 0.000000, -1.906370, 0.000000, 1.000000}, 
{0.413059, 0.000000, 0.559903, 0.000000, 0.360144, 0.000000, -1.869455, 0.000000, 1.000000}, 
{0.441882, 0.000000, 0.573174, 0.000000, 0.386636, 0.000000, -1.827946, 0.000000, 1.000000}, 
{0.471516, 0.000000, 0.584151, 0.000000, 0.413146, 0.000000, -1.781652, 0.000000, 1.000000}, 
{0.500872, 0.000000, 0.591843, 0.000000, 0.440067, 0.000000, -1.730885, 0.000000, 1.000000}, 
{0.529677, 0.000000, 0.596253, 0.000000, 0.467331, 0.000000, -1.676821, 0.000000, 1.000000}, 
{0.557683, 0.000000, 0.597604, 0.000000, 0.494714, 0.000000, -1.620064, 0.000000, 1.000000}, 
{0.585652, 0.000000, 0.596591, 0.000000, 0.521961, 0.000000, -1.560909, 0.000000, 1.000000}, 
{0.612819, 0.000000, 0.593138, 0.000000, 0.548785, 0.000000, -1.500318, 0.000000, 1.000000}, 
{0.639848, 0.000000, 0.588245, 0.000000, 0.574969, 0.000000, -1.438127, 0.000000, 1.000000}, 
{0.664758, 0.000000, 0.580140, 0.000000, 0.601837, 0.000000, -1.375746, 0.000000, 1.000000}, 
{0.688754, 0.000000, 0.570189, 0.000000, 0.627431, 0.000000, -1.312727, 0.000000, 1.000000}, 
{0.712848, 0.000000, 0.559420, 0.000000, 0.652967, 0.000000, -1.250063, 0.000000, 1.000000}, 
{0.735111, 0.000000, 0.546570, 0.000000, 0.677876, 0.000000, -1.187840, 0.000000, 1.000000}, 
{0.757521, 0.000000, 0.532944, 0.000000, 0.702044, 0.000000, -1.125513, 0.000000, 1.000000}, 
{0.780056, 0.000000, 0.517981, 0.000000, 0.725978, 0.000000, -1.063827, 0.000000, 1.000000}, 
{0.802513, 0.000000, 0.500724, 0.000000, 0.750015, 0.000000, -1.002154, 0.000000, 1.000000}, 
{0.825462, 0.000000, 0.481625, 0.000000, 0.773489, 0.000000, -0.939811, 0.000000, 1.000000}, 
{0.848973, 0.000000, 0.462327, 0.000000, 0.795548, 0.000000, -0.878279, 0.000000, 1.000000}, 
{0.871521, 0.000000, 0.441928, 0.000000, 0.817303, 0.000000, -0.819200, 0.000000, 1.000000}, 
{0.892325, 0.000000, 0.420297, 0.000000, 0.839747, 0.000000, -0.761607, 0.000000, 1.000000}, 
{0.914935, 0.000000, 0.399072, 0.000000, 0.860953, 0.000000, -0.705351, 0.000000, 1.000000}, 
{0.936429, 0.000000, 0.377232, 0.000000, 0.881937, 0.000000, -0.650213, 0.000000, 1.000000}, 
{0.957614, 0.000000, 0.355091, 0.000000, 0.903055, 0.000000, -0.597773, 0.000000, 1.000000}, 
{0.979578, 0.000000, 0.332767, 0.000000, 0.924045, 0.000000, -0.545914, 0.000000, 1.000000}, 
{1.000860, 0.000000, 0.310147, 0.000000, 0.945093, 0.000000, -0.495661, 0.000000, 1.000000}, 
{1.022550, 0.000000, 0.287395, 0.000000, 0.966858, 0.000000, -0.448026, 0.000000, 1.000000}, 
{1.045005, 0.000000, 0.264582, 0.000000, 0.989959, 0.000000, -0.400490, 0.000000, 1.000000}, 
{1.068703, 0.000000, 0.241464, 0.000000, 1.013919, 0.000000, -0.354088, 0.000000, 1.000000}, 
{1.093098, 0.000000, 0.217504, 0.000000, 1.039885, 0.000000, -0.309812, 0.000000, 1.000000}, 
{1.119230, 0.000000, 0.192140, 0.000000, 1.067603, 0.000000, -0.266297, 0.000000, 1.000000}, 
{1.144608, 0.000000, 0.165975, 0.000000, 1.094486, 0.000000, -0.225831, 0.000000, 1.000000}, 
{1.168599, 0.000000, 0.139174, 0.000000, 1.118924, 0.000000, -0.187761, 0.000000, 1.000000}, 
{1.187970, 0.000000, 0.111910, 0.000000, 1.140322, 0.000000, -0.151322, 0.000000, 1.000000}, 
{1.201240, 0.000000, 0.083978, 0.000000, 1.160292, 0.000000, -0.114337, 0.000000, 1.000000}, 
{1.208895, 0.000000, 0.056089, 0.000000, 1.179699, 0.000000, -0.076083, 0.000000, 1.000000}, 
{1.213344, 0.000000, 0.028369, 0.000000, 1.198742, 0.000000, -0.037735, 0.000000, 1.000000}, 
{1.219220, 0.000000, 0.000534, 0.000000, 1.219259, 0.000000, -0.000076, 0.000000, 1.000000}, 
{0.000182, 0.000000, 0.000404, 0.000000, 0.000243, 0.000000, -2.216201, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.001117, 0.000000, 0.000504, 0.000000, -2.216198, 0.000000, 1.000000}, 
{0.002017, 0.000000, 0.004469, 0.000000, 0.002014, 0.000000, -2.216190, 0.000000, 1.000000}, 
{0.004536, 0.000000, 0.010051, 0.000000, 0.004534, 0.000000, -2.216130, 0.000000, 1.000000}, 
{0.008065, 0.000000, 0.017867, 0.000000, 0.008062, 0.000000, -2.216145, 0.000000, 1.000000}, 
{0.012467, 0.000000, 0.027603, 0.000000, 0.012730, 0.000000, -2.216447, 0.000000, 1.000000}, 
{0.018156, 0.000000, 0.040159, 0.000000, 0.018157, 0.000000, -2.215958, 0.000000, 1.000000}, 
{0.024758, 0.000000, 0.054670, 0.000000, 0.024690, 0.000000, -2.215654, 0.000000, 1.000000}, 
{0.032395, 0.000000, 0.071352, 0.000000, 0.032248, 0.000000, -2.215283, 0.000000, 1.000000}, 
{0.041108, 0.000000, 0.090201, 0.000000, 0.040809, 0.000000, -2.214715, 0.000000, 1.000000}, 
{0.050955, 0.000000, 0.111004, 0.000000, 0.050326, 0.000000, -2.213905, 0.000000, 1.000000}, 
{0.061968, 0.000000, 0.134002, 0.000000, 0.060877, 0.000000, -2.212807, 0.000000, 1.000000}, 
{0.074206, 0.000000, 0.159038, 0.000000, 0.072422, 0.000000, -2.211303, 0.000000, 1.000000}, 
{0.087742, 0.000000, 0.185801, 0.000000, 0.084921, 0.000000, -2.209297, 0.000000, 1.000000}, 
{0.102652, 0.000000, 0.214368, 0.000000, 0.098384, 0.000000, -2.206657, 0.000000, 1.000000}, 
{0.119006, 0.000000, 0.244573, 0.000000, 0.112826, 0.000000, -2.203232, 0.000000, 1.000000}, 
{0.136883, 0.000000, 0.276067, 0.000000, 0.128198, 0.000000, -2.198778, 0.000000, 1.000000}, 
{0.156335, 0.000000, 0.308660, 0.000000, 0.144482, 0.000000, -2.193091, 0.000000, 1.000000}, 
{0.177396, 0.000000, 0.341940, 0.000000, 0.161691, 0.000000, -2.185858, 0.000000, 1.000000}, 
{0.200070, 0.000000, 0.375591, 0.000000, 0.179822, 0.000000, -2.176584, 0.000000, 1.000000}, 
{0.224067, 0.000000, 0.408564, 0.000000, 0.198889, 0.000000, -2.164759, 0.000000, 1.000000}, 
{0.249420, 0.000000, 0.440668, 0.000000, 0.218958, 0.000000, -2.149777, 0.000000, 1.000000}, 
{0.275879, 0.000000, 0.471138, 0.000000, 0.240047, 0.000000, -2.131225, 0.000000, 1.000000}, 
{0.303307, 0.000000, 0.499204, 0.000000, 0.262118, 0.000000, -2.108794, 0.000000, 1.000000}, 
{0.331189, 0.000000, 0.524547, 0.000000, 0.285361, 0.000000, -2.080585, 0.000000, 1.000000}, 
{0.359932, 0.000000, 0.547256, 0.000000, 0.309374, 0.000000, -2.047792, 0.000000, 1.000000}, 
{0.389063, 0.000000, 0.566479, 0.000000, 0.334274, 0.000000, -2.009518, 0.000000, 1.000000}, 
{0.418725, 0.000000, 0.583031, 0.000000, 0.359745, 0.000000, -1.965601, 0.000000, 1.000000}, 
{0.448181, 0.000000, 0.595809, 0.000000, 0.385874, 0.000000, -1.916911, 0.000000, 1.000000}, 
{0.477703, 0.000000, 0.605102, 0.000000, 0.412438, 0.000000, -1.863530, 0.000000, 1.000000}, 
{0.507999, 0.000000, 0.612462, 0.000000, 0.439074, 0.000000, -1.806286, 0.000000, 1.000000}, 
{0.536889, 0.000000, 0.615451, 0.000000, 0.466220, 0.000000, -1.745841, 0.000000, 1.000000}, 
{0.565778, 0.000000, 0.616029, 0.000000, 0.492822, 0.000000, -1.681137, 0.000000, 1.000000}, 
{0.593863, 0.000000, 0.613644, 0.000000, 0.519640, 0.000000, -1.615238, 0.000000, 1.000000}, 
{0.620770, 0.000000, 0.608268, 0.000000, 0.546360, 0.000000, -1.548003, 0.000000, 1.000000}, 
{0.647171, 0.000000, 0.601116, 0.000000, 0.572839, 0.000000, -1.480447, 0.000000, 1.000000}, 
{0.673458, 0.000000, 0.592840, 0.000000, 0.598485, 0.000000, -1.412084, 0.000000, 1.000000}, 
{0.698064, 0.000000, 0.581973, 0.000000, 0.624574, 0.000000, -1.345130, 0.000000, 1.000000}, 
{0.721011, 0.000000, 0.568963, 0.000000, 0.649766, 0.000000, -1.278440, 0.000000, 1.000000}, 
{0.744293, 0.000000, 0.555642, 0.000000, 0.674197, 0.000000, -1.212448, 0.000000, 1.000000}, 
{0.766314, 0.000000, 0.540934, 0.000000, 0.698298, 0.000000, -1.146287, 0.000000, 1.000000}, 
{0.788164, 0.000000, 0.525271, 0.000000, 0.722159, 0.000000, -1.082600, 0.000000, 1.000000}, 
{0.809019, 0.000000, 0.507986, 0.000000, 0.745667, 0.000000, -1.019978, 0.000000, 1.000000}, 
{0.830947, 0.000000, 0.489717, 0.000000, 0.768237, 0.000000, -0.956931, 0.000000, 1.000000}, 
{0.853732, 0.000000, 0.469345, 0.000000, 0.792170, 0.000000, -0.894207, 0.000000, 1.000000}, 
{0.874904, 0.000000, 0.447618, 0.000000, 0.815037, 0.000000, -0.833436, 0.000000, 1.000000}, 
{0.897289, 0.000000, 0.426124, 0.000000, 0.836190, 0.000000, -0.773611, 0.000000, 1.000000}, 
{0.919226, 0.000000, 0.404025, 0.000000, 0.858124, 0.000000, -0.716016, 0.000000, 1.000000}, 
{0.940860, 0.000000, 0.381454, 0.000000, 0.879241, 0.000000, -0.659515, 0.000000, 1.000000}, 
{0.962764, 0.000000, 0.358901, 0.000000, 0.900528, 0.000000, -0.604629, 0.000000, 1.000000}, 
{0.984322, 0.000000, 0.335983, 0.000000, 0.922279, 0.000000, -0.552335, 0.000000, 1.000000}, 
{1.005343, 0.000000, 0.312533, 0.000000, 0.944294, 0.000000, -0.501591, 0.000000, 1.000000}, 
{1.028153, 0.000000, 0.289452, 0.000000, 0.966499, 0.000000, -0.452032, 0.000000, 1.000000}, 
{1.049283, 0.000000, 0.265754, 0.000000, 0.989872, 0.000000, -0.404347, 0.000000, 1.000000}, 
{1.073687, 0.000000, 0.242571, 0.000000, 1.014744, 0.000000, -0.357445, 0.000000, 1.000000}, 
{1.097546, 0.000000, 0.218681, 0.000000, 1.041105, 0.000000, -0.312534, 0.000000, 1.000000}, 
{1.123340, 0.000000, 0.194465, 0.000000, 1.069207, 0.000000, -0.269437, 0.000000, 1.000000}, 
{1.148166, 0.000000, 0.168797, 0.000000, 1.096844, 0.000000, -0.228586, 0.000000, 1.000000}, 
{1.172518, 0.000000, 0.141552, 0.000000, 1.122199, 0.000000, -0.189866, 0.000000, 1.000000}, 
{1.192930, 0.000000, 0.113325, 0.000000, 1.144386, 0.000000, -0.152772, 0.000000, 1.000000}, 
{1.206816, 0.000000, 0.084800, 0.000000, 1.165165, 0.000000, -0.115390, 0.000000, 1.000000}, 
{1.215045, 0.000000, 0.056019, 0.000000, 1.185038, 0.000000, -0.076493, 0.000000, 1.000000}, 
{1.220048, 0.000000, 0.027733, 0.000000, 1.205023, 0.000000, -0.037767, 0.000000, 1.000000}, 
{1.225852, 0.000000, -0.000050, 0.000000, 1.225942, 0.000000, 0.000160, 0.000000, 1.000000}, 
{0.000178, 0.000000, 0.000422, 0.000000, 0.000257, 0.000000, -2.372253, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.001195, 0.000000, 0.000504, 0.000000, -2.372248, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.004782, 0.000000, 0.002016, 0.000000, -2.372187, 0.000000, 1.000000}, 
{0.004531, 0.000000, 0.010746, 0.000000, 0.004544, 0.000000, -2.372318, 0.000000, 1.000000}, 
{0.008081, 0.000000, 0.019161, 0.000000, 0.008062, 0.000000, -2.372084, 0.000000, 1.000000}, 
{0.012637, 0.000000, 0.029945, 0.000000, 0.012575, 0.000000, -2.372128, 0.000000, 1.000000}, 
{0.018167, 0.000000, 0.042999, 0.000000, 0.018140, 0.000000, -2.371902, 0.000000, 1.000000}, 
{0.024769, 0.000000, 0.058516, 0.000000, 0.024688, 0.000000, -2.371595, 0.000000, 1.000000}, 
{0.032421, 0.000000, 0.076370, 0.000000, 0.032247, 0.000000, -2.371120, 0.000000, 1.000000}, 
{0.041164, 0.000000, 0.096474, 0.000000, 0.040792, 0.000000, -2.370428, 0.000000, 1.000000}, 
{0.051057, 0.000000, 0.118786, 0.000000, 0.050321, 0.000000, -2.369440, 0.000000, 1.000000}, 
{0.062136, 0.000000, 0.143390, 0.000000, 0.060870, 0.000000, -2.368075, 0.000000, 1.000000}, 
{0.074490, 0.000000, 0.170034, 0.000000, 0.072378, 0.000000, -2.366218, 0.000000, 1.000000}, 
{0.088179, 0.000000, 0.198717, 0.000000, 0.084883, 0.000000, -2.363747, 0.000000, 1.000000}, 
{0.103307, 0.000000, 0.229147, 0.000000, 0.098325, 0.000000, -2.360517, 0.000000, 1.000000}, 
{0.119964, 0.000000, 0.261253, 0.000000, 0.112710, 0.000000, -2.356304, 0.000000, 1.000000}, 
{0.138173, 0.000000, 0.294703, 0.000000, 0.128045, 0.000000, -2.350797, 0.000000, 1.000000}, 
{0.158072, 0.000000, 0.329261, 0.000000, 0.144297, 0.000000, -2.343783, 0.000000, 1.000000}, 
{0.179592, 0.000000, 0.364298, 0.000000, 0.161465, 0.000000, -2.334673, 0.000000, 1.000000}, 
{0.202709, 0.000000, 0.399375, 0.000000, 0.179564, 0.000000, -2.323125, 0.000000, 1.000000}, 
{0.227335, 0.000000, 0.433616, 0.000000, 0.198605, 0.000000, -2.308547, 0.000000, 1.000000}, 
{0.253230, 0.000000, 0.466794, 0.000000, 0.218690, 0.000000, -2.289980, 0.000000, 1.000000}, 
{0.280100, 0.000000, 0.497509, 0.000000, 0.239779, 0.000000, -2.266964, 0.000000, 1.000000}, 
{0.308146, 0.000000, 0.525956, 0.000000, 0.261934, 0.000000, -2.239074, 0.000000, 1.000000}, 
{0.336544, 0.000000, 0.551101, 0.000000, 0.285053, 0.000000, -2.204809, 0.000000, 1.000000}, 
{0.365223, 0.000000, 0.572471, 0.000000, 0.309274, 0.000000, -2.164827, 0.000000, 1.000000}, 
{0.395484, 0.000000, 0.592088, 0.000000, 0.333835, 0.000000, -2.119489, 0.000000, 1.000000}, 
{0.424416, 0.000000, 0.606026, 0.000000, 0.359427, 0.000000, -2.067262, 0.000000, 1.000000}, 
{0.455641, 0.000000, 0.619671, 0.000000, 0.384964, 0.000000, -2.009937, 0.000000, 1.000000}, 
{0.485298, 0.000000, 0.627583, 0.000000, 0.411390, 0.000000, -1.948900, 0.000000, 1.000000}, 
{0.514774, 0.000000, 0.632072, 0.000000, 0.437868, 0.000000, -1.882692, 0.000000, 1.000000}, 
{0.544172, 0.000000, 0.634033, 0.000000, 0.464801, 0.000000, -1.814073, 0.000000, 1.000000}, 
{0.573283, 0.000000, 0.633239, 0.000000, 0.491072, 0.000000, -1.742717, 0.000000, 1.000000}, 
{0.602155, 0.000000, 0.630008, 0.000000, 0.517594, 0.000000, -1.669703, 0.000000, 1.000000}, 
{0.630520, 0.000000, 0.624550, 0.000000, 0.543428, 0.000000, -1.596021, 0.000000, 1.000000}, 
{0.657121, 0.000000, 0.615749, 0.000000, 0.569643, 0.000000, -1.522572, 0.000000, 1.000000}, 
{0.682071, 0.000000, 0.604738, 0.000000, 0.595666, 0.000000, -1.448978, 0.000000, 1.000000}, 
{0.707605, 0.000000, 0.593301, 0.000000, 0.620548, 0.000000, -1.376250, 0.000000, 1.000000}, 
{0.731492, 0.000000, 0.579628, 0.000000, 0.646003, 0.000000, -1.305297, 0.000000, 1.000000}, 
{0.754139, 0.000000, 0.564473, 0.000000, 0.670367, 0.000000, -1.235548, 0.000000, 1.000000}, 
{0.776505, 0.000000, 0.548787, 0.000000, 0.694032, 0.000000, -1.167051, 0.000000, 1.000000}, 
{0.796833, 0.000000, 0.531415, 0.000000, 0.718374, 0.000000, -1.100534, 0.000000, 1.000000}, 
{0.817565, 0.000000, 0.513778, 0.000000, 0.742172, 0.000000, -1.035144, 0.000000, 1.000000}, 
{0.837981, 0.000000, 0.495167, 0.000000, 0.765201, 0.000000, -0.971583, 0.000000, 1.000000}, 
{0.858513, 0.000000, 0.475690, 0.000000, 0.787843, 0.000000, -0.908841, 0.000000, 1.000000}, 
{0.879892, 0.000000, 0.454099, 0.000000, 0.810800, 0.000000, -0.846701, 0.000000, 1.000000}, 
{0.902258, 0.000000, 0.432038, 0.000000, 0.832434, 0.000000, -0.785332, 0.000000, 1.000000}, 
{0.924114, 0.000000, 0.409316, 0.000000, 0.854828, 0.000000, -0.726409, 0.000000, 1.000000}, 
{0.944230, 0.000000, 0.385618, 0.000000, 0.876906, 0.000000, -0.668588, 0.000000, 1.000000}, 
{0.967001, 0.000000, 0.362604, 0.000000, 0.898550, 0.000000, -0.612943, 0.000000, 1.000000}, 
{0.988579, 0.000000, 0.339117, 0.000000, 0.920667, 0.000000, -0.559038, 0.000000, 1.000000}, 
{1.010210, 0.000000, 0.315355, 0.000000, 0.943512, 0.000000, -0.506867, 0.000000, 1.000000}, 
{1.032084, 0.000000, 0.291408, 0.000000, 0.966793, 0.000000, -0.456934, 0.000000, 1.000000}, 
{1.054671, 0.000000, 0.267387, 0.000000, 0.990225, 0.000000, -0.407792, 0.000000, 1.000000}, 
{1.078314, 0.000000, 0.243346, 0.000000, 1.015683, 0.000000, -0.360992, 0.000000, 1.000000}, 
{1.102443, 0.000000, 0.219205, 0.000000, 1.042552, 0.000000, -0.315577, 0.000000, 1.000000}, 
{1.128524, 0.000000, 0.194996, 0.000000, 1.071546, 0.000000, -0.271742, 0.000000, 1.000000}, 
{1.153989, 0.000000, 0.169897, 0.000000, 1.099573, 0.000000, -0.230702, 0.000000, 1.000000}, 
{1.179420, 0.000000, 0.143960, 0.000000, 1.126325, 0.000000, -0.192146, 0.000000, 1.000000}, 
{1.200098, 0.000000, 0.116173, 0.000000, 1.148979, 0.000000, -0.155164, 0.000000, 1.000000}, 
{1.214837, 0.000000, 0.086655, 0.000000, 1.170786, 0.000000, -0.117071, 0.000000, 1.000000}, 
{1.222749, 0.000000, 0.056956, 0.000000, 1.191371, 0.000000, -0.077450, 0.000000, 1.000000}, 
{1.227273, 0.000000, 0.027883, 0.000000, 1.211794, 0.000000, -0.038092, 0.000000, 1.000000}, 
{1.233293, 0.000000, -0.000831, 0.000000, 1.233240, 0.000000, 0.000462, 0.000000, 1.000000}, 
{0.000173, 0.000000, 0.000442, 0.000000, 0.000274, 0.000000, -2.547922, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.001284, 0.000000, 0.000504, 0.000000, -2.547919, 0.000000, 1.000000}, 
{0.002014, 0.000000, 0.005132, 0.000000, 0.002016, 0.000000, -2.547844, 0.000000, 1.000000}, 
{0.004523, 0.000000, 0.011521, 0.000000, 0.004553, 0.000000, -2.547587, 0.000000, 1.000000}, 
{0.008059, 0.000000, 0.020524, 0.000000, 0.008064, 0.000000, -2.547725, 0.000000, 1.000000}, 
{0.012586, 0.000000, 0.032029, 0.000000, 0.012607, 0.000000, -2.547685, 0.000000, 1.000000}, 
{0.018081, 0.000000, 0.045948, 0.000000, 0.018207, 0.000000, -2.547686, 0.000000, 1.000000}, 
{0.024783, 0.000000, 0.062844, 0.000000, 0.024688, 0.000000, -2.547107, 0.000000, 1.000000}, 
{0.032451, 0.000000, 0.082011, 0.000000, 0.032243, 0.000000, -2.546522, 0.000000, 1.000000}, 
{0.041233, 0.000000, 0.103540, 0.000000, 0.040777, 0.000000, -2.545684, 0.000000, 1.000000}, 
{0.051181, 0.000000, 0.127537, 0.000000, 0.050310, 0.000000, -2.544438, 0.000000, 1.000000}, 
{0.062347, 0.000000, 0.153921, 0.000000, 0.060852, 0.000000, -2.542744, 0.000000, 1.000000}, 
{0.074829, 0.000000, 0.182427, 0.000000, 0.072345, 0.000000, -2.540459, 0.000000, 1.000000}, 
{0.088703, 0.000000, 0.213134, 0.000000, 0.084831, 0.000000, -2.537380, 0.000000, 1.000000}, 
{0.104080, 0.000000, 0.245750, 0.000000, 0.098264, 0.000000, -2.533347, 0.000000, 1.000000}, 
{0.121050, 0.000000, 0.279941, 0.000000, 0.112626, 0.000000, -2.528069, 0.000000, 1.000000}, 
{0.139697, 0.000000, 0.315591, 0.000000, 0.127906, 0.000000, -2.521237, 0.000000, 1.000000}, 
{0.160036, 0.000000, 0.351980, 0.000000, 0.144120, 0.000000, -2.512378, 0.000000, 1.000000}, 
{0.182147, 0.000000, 0.388993, 0.000000, 0.161232, 0.000000, -2.500993, 0.000000, 1.000000}, 
{0.205799, 0.000000, 0.425570, 0.000000, 0.179327, 0.000000, -2.486450, 0.000000, 1.000000}, 
{0.231091, 0.000000, 0.461093, 0.000000, 0.198353, 0.000000, -2.468174, 0.000000, 1.000000}, 
{0.257405, 0.000000, 0.494668, 0.000000, 0.218504, 0.000000, -2.444774, 0.000000, 1.000000}, 
{0.284956, 0.000000, 0.525889, 0.000000, 0.239593, 0.000000, -2.415538, 0.000000, 1.000000}, 
{0.313180, 0.000000, 0.553693, 0.000000, 0.261728, 0.000000, -2.380610, 0.000000, 1.000000}, 
{0.342327, 0.000000, 0.578724, 0.000000, 0.284806, 0.000000, -2.338525, 0.000000, 1.000000}, 
{0.371689, 0.000000, 0.599706, 0.000000, 0.308896, 0.000000, -2.290256, 0.000000, 1.000000}, 
{0.401919, 0.000000, 0.617615, 0.000000, 0.333287, 0.000000, -2.235157, 0.000000, 1.000000}, 
{0.432204, 0.000000, 0.631632, 0.000000, 0.358455, 0.000000, -2.173932, 0.000000, 1.000000}, 
{0.463151, 0.000000, 0.643082, 0.000000, 0.383937, 0.000000, -2.107298, 0.000000, 1.000000}, 
{0.493388, 0.000000, 0.649970, 0.000000, 0.409925, 0.000000, -2.036121, 0.000000, 1.000000}, 
{0.524128, 0.000000, 0.654188, 0.000000, 0.435989, 0.000000, -1.961595, 0.000000, 1.000000}, 
{0.553930, 0.000000, 0.654671, 0.000000, 0.462148, 0.000000, -1.883602, 0.000000, 1.000000}, 
{0.583856, 0.000000, 0.653051, 0.000000, 0.488463, 0.000000, -1.804521, 0.000000, 1.000000}, 
{0.611762, 0.000000, 0.646994, 0.000000, 0.514627, 0.000000, -1.724047, 0.000000, 1.000000}, 
{0.639117, 0.000000, 0.638860, 0.000000, 0.540835, 0.000000, -1.643016, 0.000000, 1.000000}, 
{0.666279, 0.000000, 0.629093, 0.000000, 0.566439, 0.000000, -1.563932, 0.000000, 1.000000}, 
{0.692936, 0.000000, 0.617862, 0.000000, 0.591412, 0.000000, -1.484614, 0.000000, 1.000000}, 
{0.716498, 0.000000, 0.603279, 0.000000, 0.616948, 0.000000, -1.406734, 0.000000, 1.000000}, 
{0.742273, 0.000000, 0.589878, 0.000000, 0.641597, 0.000000, -1.331469, 0.000000, 1.000000}, 
{0.764031, 0.000000, 0.572744, 0.000000, 0.665909, 0.000000, -1.256796, 0.000000, 1.000000}, 
{0.786601, 0.000000, 0.555933, 0.000000, 0.689848, 0.000000, -1.185290, 0.000000, 1.000000}, 
{0.807776, 0.000000, 0.537992, 0.000000, 0.713755, 0.000000, -1.115940, 0.000000, 1.000000}, 
{0.828400, 0.000000, 0.519596, 0.000000, 0.736897, 0.000000, -1.048371, 0.000000, 1.000000}, 
{0.847412, 0.000000, 0.499847, 0.000000, 0.760369, 0.000000, -0.982934, 0.000000, 1.000000}, 
{0.866850, 0.000000, 0.479920, 0.000000, 0.782983, 0.000000, -0.919972, 0.000000, 1.000000}, 
{0.886340, 0.000000, 0.459434, 0.000000, 0.806430, 0.000000, -0.858100, 0.000000, 1.000000}, 
{0.906933, 0.000000, 0.437767, 0.000000, 0.828574, 0.000000, -0.796714, 0.000000, 1.000000}, 
{0.927490, 0.000000, 0.414068, 0.000000, 0.850901, 0.000000, -0.736162, 0.000000, 1.000000}, 
{0.950217, 0.000000, 0.390910, 0.000000, 0.873857, 0.000000, -0.677613, 0.000000, 1.000000}, 
{0.971545, 0.000000, 0.366964, 0.000000, 0.896382, 0.000000, -0.620477, 0.000000, 1.000000}, 
{0.992901, 0.000000, 0.342603, 0.000000, 0.919173, 0.000000, -0.565807, 0.000000, 1.000000}, 
{1.015460, 0.000000, 0.318596, 0.000000, 0.942284, 0.000000, -0.513086, 0.000000, 1.000000}, 
{1.037859, 0.000000, 0.294242, 0.000000, 0.966550, 0.000000, -0.461573, 0.000000, 1.000000}, 
{1.060535, 0.000000, 0.269601, 0.000000, 0.990740, 0.000000, -0.411838, 0.000000, 1.000000}, 
{1.086885, 0.000000, 0.245608, 0.000000, 1.018000, 0.000000, -0.363221, 0.000000, 1.000000}, 
{1.111237, 0.000000, 0.220589, 0.000000, 1.045575, 0.000000, -0.317174, 0.000000, 1.000000}, 
{1.138718, 0.000000, 0.196008, 0.000000, 1.075956, 0.000000, -0.273213, 0.000000, 1.000000}, 
{1.164223, 0.000000, 0.170408, 0.000000, 1.104725, 0.000000, -0.231968, 0.000000, 1.000000}, 
{1.187256, 0.000000, 0.144205, 0.000000, 1.131212, 0.000000, -0.192987, 0.000000, 1.000000}, 
{1.207851, 0.000000, 0.116945, 0.000000, 1.154946, 0.000000, -0.156118, 0.000000, 1.000000}, 
{1.222217, 0.000000, 0.088852, 0.000000, 1.176749, 0.000000, -0.118674, 0.000000, 1.000000}, 
{1.230315, 0.000000, 0.059381, 0.000000, 1.198024, 0.000000, -0.078993, 0.000000, 1.000000}, 
{1.235052, 0.000000, 0.029145, 0.000000, 1.218967, 0.000000, -0.038924, 0.000000, 1.000000}, 
{1.241359, 0.000000, -0.000479, 0.000000, 1.241218, 0.000000, 0.000211, 0.000000, 1.000000}, 
{0.000169, 0.000000, 0.000465, 0.000000, 0.000292, 0.000000, -2.747437, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.001384, 0.000000, 0.000504, 0.000000, -2.747430, 0.000000, 1.000000}, 
{0.002015, 0.000000, 0.005537, 0.000000, 0.002016, 0.000000, -2.747339, 0.000000, 1.000000}, 
{0.004542, 0.000000, 0.012477, 0.000000, 0.004536, 0.000000, -2.747125, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.022143, 0.000000, 0.008077, 0.000000, -2.747341, 0.000000, 1.000000}, 
{0.012543, 0.000000, 0.034411, 0.000000, 0.012650, 0.000000, -2.747411, 0.000000, 1.000000}, 
{0.018178, 0.000000, 0.049792, 0.000000, 0.018137, 0.000000, -2.746874, 0.000000, 1.000000}, 
{0.024810, 0.000000, 0.067784, 0.000000, 0.024683, 0.000000, -2.746396, 0.000000, 1.000000}, 
{0.032489, 0.000000, 0.088416, 0.000000, 0.032241, 0.000000, -2.745730, 0.000000, 1.000000}, 
{0.041313, 0.000000, 0.111580, 0.000000, 0.040761, 0.000000, -2.744596, 0.000000, 1.000000}, 
{0.051332, 0.000000, 0.137462, 0.000000, 0.050297, 0.000000, -2.743082, 0.000000, 1.000000}, 
{0.062603, 0.000000, 0.165860, 0.000000, 0.060829, 0.000000, -2.740950, 0.000000, 1.000000}, 
{0.075240, 0.000000, 0.196548, 0.000000, 0.072322, 0.000000, -2.738057, 0.000000, 1.000000}, 
{0.089341, 0.000000, 0.229440, 0.000000, 0.084770, 0.000000, -2.734174, 0.000000, 1.000000}, 
{0.105021, 0.000000, 0.264395, 0.000000, 0.098165, 0.000000, -2.729086, 0.000000, 1.000000}, 
{0.122399, 0.000000, 0.301020, 0.000000, 0.112486, 0.000000, -2.722420, 0.000000, 1.000000}, 
{0.141526, 0.000000, 0.338997, 0.000000, 0.127747, 0.000000, -2.713686, 0.000000, 1.000000}, 
{0.162451, 0.000000, 0.377589, 0.000000, 0.143876, 0.000000, -2.702492, 0.000000, 1.000000}, 
{0.185098, 0.000000, 0.416349, 0.000000, 0.161010, 0.000000, -2.687893, 0.000000, 1.000000}, 
{0.209406, 0.000000, 0.454284, 0.000000, 0.179063, 0.000000, -2.669386, 0.000000, 1.000000}, 
{0.235098, 0.000000, 0.490450, 0.000000, 0.198185, 0.000000, -2.645590, 0.000000, 1.000000}, 
{0.262100, 0.000000, 0.524592, 0.000000, 0.218308, 0.000000, -2.615709, 0.000000, 1.000000}, 
{0.290103, 0.000000, 0.555558, 0.000000, 0.239524, 0.000000, -2.579231, 0.000000, 1.000000}, 
{0.319135, 0.000000, 0.583516, 0.000000, 0.261582, 0.000000, -2.534957, 0.000000, 1.000000}, 
{0.348286, 0.000000, 0.606714, 0.000000, 0.284643, 0.000000, -2.483017, 0.000000, 1.000000}, 
{0.378840, 0.000000, 0.627850, 0.000000, 0.308389, 0.000000, -2.424214, 0.000000, 1.000000}, 
{0.409608, 0.000000, 0.644715, 0.000000, 0.332603, 0.000000, -2.357563, 0.000000, 1.000000}, 
{0.440553, 0.000000, 0.657657, 0.000000, 0.357591, 0.000000, -2.285835, 0.000000, 1.000000}, 
{0.470599, 0.000000, 0.665621, 0.000000, 0.383185, 0.000000, -2.207940, 0.000000, 1.000000}, 
{0.503172, 0.000000, 0.673767, 0.000000, 0.408113, 0.000000, -2.126440, 0.000000, 1.000000}, 
{0.533884, 0.000000, 0.676009, 0.000000, 0.433545, 0.000000, -2.040694, 0.000000, 1.000000}, 
{0.563808, 0.000000, 0.674536, 0.000000, 0.459863, 0.000000, -1.953979, 0.000000, 1.000000}, 
{0.591849, 0.000000, 0.668913, 0.000000, 0.485858, 0.000000, -1.865897, 0.000000, 1.000000}, 
{0.621474, 0.000000, 0.663159, 0.000000, 0.511397, 0.000000, -1.777762, 0.000000, 1.000000}, 
{0.650500, 0.000000, 0.655018, 0.000000, 0.536605, 0.000000, -1.689902, 0.000000, 1.000000}, 
{0.678011, 0.000000, 0.643949, 0.000000, 0.562117, 0.000000, -1.603528, 0.000000, 1.000000}, 
{0.703490, 0.000000, 0.630030, 0.000000, 0.587460, 0.000000, -1.519484, 0.000000, 1.000000}, 
{0.728250, 0.000000, 0.614910, 0.000000, 0.612195, 0.000000, -1.436677, 0.000000, 1.000000}, 
{0.752165, 0.000000, 0.598649, 0.000000, 0.636832, 0.000000, -1.355753, 0.000000, 1.000000}, 
{0.775894, 0.000000, 0.581771, 0.000000, 0.662002, 0.000000, -1.278884, 0.000000, 1.000000}, 
{0.797650, 0.000000, 0.563193, 0.000000, 0.685335, 0.000000, -1.202767, 0.000000, 1.000000}, 
{0.818505, 0.000000, 0.543750, 0.000000, 0.708732, 0.000000, -1.130338, 0.000000, 1.000000}, 
{0.838596, 0.000000, 0.524017, 0.000000, 0.732412, 0.000000, -1.060263, 0.000000, 1.000000}, 
{0.858396, 0.000000, 0.504064, 0.000000, 0.756158, 0.000000, -0.993077, 0.000000, 1.000000}, 
{0.877088, 0.000000, 0.483418, 0.000000, 0.779442, 0.000000, -0.928606, 0.000000, 1.000000}, 
{0.896606, 0.000000, 0.462786, 0.000000, 0.801983, 0.000000, -0.866039, 0.000000, 1.000000}, 
{0.914342, 0.000000, 0.440943, 0.000000, 0.824433, 0.000000, -0.804293, 0.000000, 1.000000}, 
{0.933550, 0.000000, 0.419129, 0.000000, 0.847322, 0.000000, -0.745206, 0.000000, 1.000000}, 
{0.955237, 0.000000, 0.396100, 0.000000, 0.870694, 0.000000, -0.685832, 0.000000, 1.000000}, 
{0.976700, 0.000000, 0.371743, 0.000000, 0.893136, 0.000000, -0.627953, 0.000000, 1.000000}, 
{0.997681, 0.000000, 0.346882, 0.000000, 0.916409, 0.000000, -0.572127, 0.000000, 1.000000}, 
{1.020784, 0.000000, 0.322391, 0.000000, 0.940726, 0.000000, -0.517941, 0.000000, 1.000000}, 
{1.043840, 0.000000, 0.297564, 0.000000, 0.965265, 0.000000, -0.466188, 0.000000, 1.000000}, 
{1.067224, 0.000000, 0.272639, 0.000000, 0.991341, 0.000000, -0.415499, 0.000000, 1.000000}, 
{1.092358, 0.000000, 0.247664, 0.000000, 1.018886, 0.000000, -0.366782, 0.000000, 1.000000}, 
{1.117573, 0.000000, 0.222260, 0.000000, 1.048171, 0.000000, -0.319377, 0.000000, 1.000000}, 
{1.145730, 0.000000, 0.196933, 0.000000, 1.079329, 0.000000, -0.275293, 0.000000, 1.000000}, 
{1.170822, 0.000000, 0.170577, 0.000000, 1.108644, 0.000000, -0.233306, 0.000000, 1.000000}, 
{1.194559, 0.000000, 0.143878, 0.000000, 1.136320, 0.000000, -0.193950, 0.000000, 1.000000}, 
{1.214819, 0.000000, 0.116347, 0.000000, 1.160589, 0.000000, -0.156724, 0.000000, 1.000000}, 
{1.229830, 0.000000, 0.088233, 0.000000, 1.183416, 0.000000, -0.118984, 0.000000, 1.000000}, 
{1.238185, 0.000000, 0.059408, 0.000000, 1.205150, 0.000000, -0.079385, 0.000000, 1.000000}, 
{1.243527, 0.000000, 0.030703, 0.000000, 1.226722, 0.000000, -0.039893, 0.000000, 1.000000}, 
{1.249724, 0.000000, 0.001520, 0.000000, 1.249951, 0.000000, -0.000760, 0.000000, 1.000000}, 
{0.000164, 0.000000, 0.000489, 0.000000, 0.000314, 0.000000, -2.976300, 0.000000, 1.000000}, 
{0.000505, 0.000000, 0.001502, 0.000000, 0.000503, 0.000000, -2.976286, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.006000, 0.000000, 0.002016, 0.000000, -2.976197, 0.000000, 1.000000}, 
{0.004543, 0.000000, 0.013519, 0.000000, 0.004536, 0.000000, -2.975832, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.023985, 0.000000, 0.008061, 0.000000, -2.976170, 0.000000, 1.000000}, 
{0.012611, 0.000000, 0.037471, 0.000000, 0.012601, 0.000000, -2.975941, 0.000000, 1.000000}, 
{0.018162, 0.000000, 0.053866, 0.000000, 0.018155, 0.000000, -2.974968, 0.000000, 1.000000}, 
{0.024820, 0.000000, 0.073390, 0.000000, 0.024686, 0.000000, -2.975010, 0.000000, 1.000000}, 
{0.032545, 0.000000, 0.095758, 0.000000, 0.032243, 0.000000, -2.974073, 0.000000, 1.000000}, 
{0.041418, 0.000000, 0.120834, 0.000000, 0.040755, 0.000000, -2.972700, 0.000000, 1.000000}, 
{0.051511, 0.000000, 0.148861, 0.000000, 0.050292, 0.000000, -2.970736, 0.000000, 1.000000}, 
{0.062920, 0.000000, 0.179456, 0.000000, 0.060787, 0.000000, -2.968033, 0.000000, 1.000000}, 
{0.075744, 0.000000, 0.212674, 0.000000, 0.072270, 0.000000, -2.964371, 0.000000, 1.000000}, 
{0.090131, 0.000000, 0.248193, 0.000000, 0.084701, 0.000000, -2.959437, 0.000000, 1.000000}, 
{0.106187, 0.000000, 0.285748, 0.000000, 0.098059, 0.000000, -2.952881, 0.000000, 1.000000}, 
{0.124035, 0.000000, 0.325017, 0.000000, 0.112336, 0.000000, -2.944273, 0.000000, 1.000000}, 
{0.143733, 0.000000, 0.365463, 0.000000, 0.127543, 0.000000, -2.933093, 0.000000, 1.000000}, 
{0.165262, 0.000000, 0.406157, 0.000000, 0.143657, 0.000000, -2.918484, 0.000000, 1.000000}, 
{0.188622, 0.000000, 0.446833, 0.000000, 0.160762, 0.000000, -2.899529, 0.000000, 1.000000}, 
{0.213693, 0.000000, 0.486209, 0.000000, 0.178801, 0.000000, -2.875137, 0.000000, 1.000000}, 
{0.239987, 0.000000, 0.522925, 0.000000, 0.197953, 0.000000, -2.844166, 0.000000, 1.000000}, 
{0.267796, 0.000000, 0.557452, 0.000000, 0.218072, 0.000000, -2.805649, 0.000000, 1.000000}, 
{0.296547, 0.000000, 0.588266, 0.000000, 0.239237, 0.000000, -2.758720, 0.000000, 1.000000}, 
{0.325838, 0.000000, 0.614837, 0.000000, 0.261286, 0.000000, -2.702676, 0.000000, 1.000000}, 
{0.355479, 0.000000, 0.636760, 0.000000, 0.284269, 0.000000, -2.638483, 0.000000, 1.000000}, 
{0.386984, 0.000000, 0.657230, 0.000000, 0.307862, 0.000000, -2.566849, 0.000000, 1.000000}, 
{0.418853, 0.000000, 0.673592, 0.000000, 0.331786, 0.000000, -2.488091, 0.000000, 1.000000}, 
{0.450302, 0.000000, 0.684966, 0.000000, 0.356175, 0.000000, -2.402458, 0.000000, 1.000000}, 
{0.481149, 0.000000, 0.691591, 0.000000, 0.381244, 0.000000, -2.311816, 0.000000, 1.000000}, 
{0.512177, 0.000000, 0.695337, 0.000000, 0.406268, 0.000000, -2.217330, 0.000000, 1.000000}, 
{0.543437, 0.000000, 0.696370, 0.000000, 0.431621, 0.000000, -2.121285, 0.000000, 1.000000}, 
{0.574309, 0.000000, 0.694186, 0.000000, 0.456651, 0.000000, -2.024160, 0.000000, 1.000000}, 
{0.604787, 0.000000, 0.689158, 0.000000, 0.482298, 0.000000, -1.927738, 0.000000, 1.000000}, 
{0.633483, 0.000000, 0.680580, 0.000000, 0.507426, 0.000000, -1.830456, 0.000000, 1.000000}, 
{0.660766, 0.000000, 0.669088, 0.000000, 0.532880, 0.000000, -1.734934, 0.000000, 1.000000}, 
{0.688471, 0.000000, 0.656673, 0.000000, 0.557727, 0.000000, -1.642316, 0.000000, 1.000000}, 
{0.715729, 0.000000, 0.642820, 0.000000, 0.582166, 0.000000, -1.550744, 0.000000, 1.000000}, 
{0.740435, 0.000000, 0.626155, 0.000000, 0.606729, 0.000000, -1.463345, 0.000000, 1.000000}, 
{0.764114, 0.000000, 0.608299, 0.000000, 0.631489, 0.000000, -1.378151, 0.000000, 1.000000}, 
{0.787028, 0.000000, 0.589519, 0.000000, 0.656427, 0.000000, -1.297630, 0.000000, 1.000000}, 
{0.807985, 0.000000, 0.569257, 0.000000, 0.679920, 0.000000, -1.217830, 0.000000, 1.000000}, 
{0.830663, 0.000000, 0.550055, 0.000000, 0.702689, 0.000000, -1.142746, 0.000000, 1.000000}, 
{0.850416, 0.000000, 0.528812, 0.000000, 0.727199, 0.000000, -1.070757, 0.000000, 1.000000}, 
{0.869609, 0.000000, 0.507478, 0.000000, 0.750940, 0.000000, -1.001282, 0.000000, 1.000000}, 
{0.888324, 0.000000, 0.486131, 0.000000, 0.774031, 0.000000, -0.934987, 0.000000, 1.000000}, 
{0.907482, 0.000000, 0.464910, 0.000000, 0.797408, 0.000000, -0.871203, 0.000000, 1.000000}, 
{0.924829, 0.000000, 0.442742, 0.000000, 0.820647, 0.000000, -0.809260, 0.000000, 1.000000}, 
{0.942958, 0.000000, 0.420777, 0.000000, 0.843953, 0.000000, -0.750037, 0.000000, 1.000000}, 
{0.961999, 0.000000, 0.398842, 0.000000, 0.866824, 0.000000, -0.691715, 0.000000, 1.000000}, 
{0.981043, 0.000000, 0.375967, 0.000000, 0.890751, 0.000000, -0.635669, 0.000000, 1.000000}, 
{1.002371, 0.000000, 0.351469, 0.000000, 0.914434, 0.000000, -0.578689, 0.000000, 1.000000}, 
{1.025343, 0.000000, 0.326601, 0.000000, 0.939537, 0.000000, -0.524424, 0.000000, 1.000000}, 
{1.048511, 0.000000, 0.301395, 0.000000, 0.964374, 0.000000, -0.471403, 0.000000, 1.000000}, 
{1.072242, 0.000000, 0.275835, 0.000000, 0.991426, 0.000000, -0.419950, 0.000000, 1.000000}, 
{1.096758, 0.000000, 0.250200, 0.000000, 1.019825, 0.000000, -0.370733, 0.000000, 1.000000}, 
{1.122781, 0.000000, 0.224474, 0.000000, 1.049399, 0.000000, -0.322864, 0.000000, 1.000000}, 
{1.150871, 0.000000, 0.198592, 0.000000, 1.082303, 0.000000, -0.277723, 0.000000, 1.000000}, 
{1.177319, 0.000000, 0.171805, 0.000000, 1.113532, 0.000000, -0.234950, 0.000000, 1.000000}, 
{1.201765, 0.000000, 0.144291, 0.000000, 1.141531, 0.000000, -0.195376, 0.000000, 1.000000}, 
{1.222629, 0.000000, 0.115949, 0.000000, 1.167012, 0.000000, -0.157315, 0.000000, 1.000000}, 
{1.237334, 0.000000, 0.087140, 0.000000, 1.190128, 0.000000, -0.118843, 0.000000, 1.000000}, 
{1.246153, 0.000000, 0.058094, 0.000000, 1.212883, 0.000000, -0.079207, 0.000000, 1.000000}, 
{1.252570, 0.000000, 0.029194, 0.000000, 1.235563, 0.000000, -0.039376, 0.000000, 1.000000}, 
{1.259060, 0.000000, 0.000418, 0.000000, 1.259210, 0.000000, -0.000307, 0.000000, 1.000000}, 
{0.000159, 0.000000, 0.000515, 0.000000, 0.000339, 0.000000, -3.241865, 0.000000, 1.000000}, 
{0.000505, 0.000000, 0.001636, 0.000000, 0.000503, 0.000000, -3.241848, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.006534, 0.000000, 0.002016, 0.000000, -3.241718, 0.000000, 1.000000}, 
{0.004537, 0.000000, 0.014706, 0.000000, 0.004534, 0.000000, -3.241196, 0.000000, 1.000000}, 
{0.008068, 0.000000, 0.026134, 0.000000, 0.008061, 0.000000, -3.241693, 0.000000, 1.000000}, 
{0.012573, 0.000000, 0.040676, 0.000000, 0.012635, 0.000000, -3.241030, 0.000000, 1.000000}, 
{0.018212, 0.000000, 0.058794, 0.000000, 0.018136, 0.000000, -3.240924, 0.000000, 1.000000}, 
{0.024847, 0.000000, 0.079926, 0.000000, 0.024686, 0.000000, -3.240201, 0.000000, 1.000000}, 
{0.032603, 0.000000, 0.104160, 0.000000, 0.032215, 0.000000, -3.238994, 0.000000, 1.000000}, 
{0.041543, 0.000000, 0.131552, 0.000000, 0.040747, 0.000000, -3.237182, 0.000000, 1.000000}, 
{0.051738, 0.000000, 0.162012, 0.000000, 0.050273, 0.000000, -3.234635, 0.000000, 1.000000}, 
{0.063313, 0.000000, 0.195260, 0.000000, 0.060752, 0.000000, -3.231153, 0.000000, 1.000000}, 
{0.076381, 0.000000, 0.231205, 0.000000, 0.072207, 0.000000, -3.226361, 0.000000, 1.000000}, 
{0.091096, 0.000000, 0.269678, 0.000000, 0.084604, 0.000000, -3.219943, 0.000000, 1.000000}, 
{0.107600, 0.000000, 0.310170, 0.000000, 0.097931, 0.000000, -3.211448, 0.000000, 1.000000}, 
{0.126017, 0.000000, 0.352435, 0.000000, 0.112167, 0.000000, -3.200168, 0.000000, 1.000000}, 
{0.146411, 0.000000, 0.395551, 0.000000, 0.127313, 0.000000, -3.185328, 0.000000, 1.000000}, 
{0.168663, 0.000000, 0.438627, 0.000000, 0.143420, 0.000000, -3.165972, 0.000000, 1.000000}, 
{0.192730, 0.000000, 0.480660, 0.000000, 0.160503, 0.000000, -3.140735, 0.000000, 1.000000}, 
{0.218497, 0.000000, 0.520987, 0.000000, 0.178646, 0.000000, -3.108388, 0.000000, 1.000000}, 
{0.245752, 0.000000, 0.558483, 0.000000, 0.197724, 0.000000, -3.067586, 0.000000, 1.000000}, 
{0.273993, 0.000000, 0.592090, 0.000000, 0.217945, 0.000000, -3.016931, 0.000000, 1.000000}, 
{0.303495, 0.000000, 0.622416, 0.000000, 0.239081, 0.000000, -2.956444, 0.000000, 1.000000}, 
{0.333717, 0.000000, 0.648303, 0.000000, 0.261038, 0.000000, -2.885116, 0.000000, 1.000000}, 
{0.363928, 0.000000, 0.668640, 0.000000, 0.283769, 0.000000, -2.805963, 0.000000, 1.000000}, 
{0.396240, 0.000000, 0.687748, 0.000000, 0.306777, 0.000000, -2.718338, 0.000000, 1.000000}, 
{0.427161, 0.000000, 0.699903, 0.000000, 0.330854, 0.000000, -2.622346, 0.000000, 1.000000}, 
{0.460175, 0.000000, 0.711210, 0.000000, 0.354634, 0.000000, -2.522476, 0.000000, 1.000000}, 
{0.492593, 0.000000, 0.717734, 0.000000, 0.379031, 0.000000, -2.417984, 0.000000, 1.000000}, 
{0.524449, 0.000000, 0.719956, 0.000000, 0.403487, 0.000000, -2.310941, 0.000000, 1.000000}, 
{0.556010, 0.000000, 0.719127, 0.000000, 0.428068, 0.000000, -2.201885, 0.000000, 1.000000}, 
{0.587032, 0.000000, 0.715077, 0.000000, 0.452985, 0.000000, -2.093330, 0.000000, 1.000000}, 
{0.617030, 0.000000, 0.707574, 0.000000, 0.477512, 0.000000, -1.986585, 0.000000, 1.000000}, 
{0.644684, 0.000000, 0.695781, 0.000000, 0.503294, 0.000000, -1.881279, 0.000000, 1.000000}, 
{0.674483, 0.000000, 0.685313, 0.000000, 0.527133, 0.000000, -1.777918, 0.000000, 1.000000}, 
{0.700290, 0.000000, 0.669619, 0.000000, 0.552176, 0.000000, -1.678004, 0.000000, 1.000000}, 
{0.727892, 0.000000, 0.654728, 0.000000, 0.576604, 0.000000, -1.581162, 0.000000, 1.000000}, 
{0.751694, 0.000000, 0.635727, 0.000000, 0.600539, 0.000000, -1.487769, 0.000000, 1.000000}, 
{0.776271, 0.000000, 0.617343, 0.000000, 0.625557, 0.000000, -1.399628, 0.000000, 1.000000}, 
{0.799502, 0.000000, 0.597683, 0.000000, 0.648998, 0.000000, -1.313195, 0.000000, 1.000000}, 
{0.821768, 0.000000, 0.577090, 0.000000, 0.673235, 0.000000, -1.232316, 0.000000, 1.000000}, 
{0.841960, 0.000000, 0.555165, 0.000000, 0.697437, 0.000000, -1.153914, 0.000000, 1.000000}, 
{0.861582, 0.000000, 0.532983, 0.000000, 0.721657, 0.000000, -1.079598, 0.000000, 1.000000}, 
{0.881460, 0.000000, 0.510933, 0.000000, 0.745417, 0.000000, -1.008883, 0.000000, 1.000000}, 
{0.899952, 0.000000, 0.488321, 0.000000, 0.769389, 0.000000, -0.940802, 0.000000, 1.000000}, 
{0.918954, 0.000000, 0.466405, 0.000000, 0.793196, 0.000000, -0.875653, 0.000000, 1.000000}, 
{0.936130, 0.000000, 0.443623, 0.000000, 0.817180, 0.000000, -0.813130, 0.000000, 1.000000}, 
{0.954799, 0.000000, 0.421532, 0.000000, 0.840333, 0.000000, -0.752241, 0.000000, 1.000000}, 
{0.972435, 0.000000, 0.398897, 0.000000, 0.864272, 0.000000, -0.694711, 0.000000, 1.000000}, 
{0.990147, 0.000000, 0.376302, 0.000000, 0.888857, 0.000000, -0.638770, 0.000000, 1.000000}, 
{1.009189, 0.000000, 0.353623, 0.000000, 0.912690, 0.000000, -0.583826, 0.000000, 1.000000}, 
{1.029687, 0.000000, 0.330635, 0.000000, 0.938187, 0.000000, -0.530476, 0.000000, 1.000000}, 
{1.052604, 0.000000, 0.305698, 0.000000, 0.963693, 0.000000, -0.477187, 0.000000, 1.000000}, 
{1.076524, 0.000000, 0.279917, 0.000000, 0.992190, 0.000000, -0.425349, 0.000000, 1.000000}, 
{1.101701, 0.000000, 0.253951, 0.000000, 1.021527, 0.000000, -0.375165, 0.000000, 1.000000}, 
{1.127264, 0.000000, 0.227541, 0.000000, 1.051746, 0.000000, -0.326869, 0.000000, 1.000000}, 
{1.156397, 0.000000, 0.201265, 0.000000, 1.086064, 0.000000, -0.280912, 0.000000, 1.000000}, 
{1.183020, 0.000000, 0.173943, 0.000000, 1.117807, 0.000000, -0.237447, 0.000000, 1.000000}, 
{1.208448, 0.000000, 0.145860, 0.000000, 1.147308, 0.000000, -0.196694, 0.000000, 1.000000}, 
{1.230417, 0.000000, 0.116901, 0.000000, 1.173353, 0.000000, -0.158409, 0.000000, 1.000000}, 
{1.248617, 0.000000, 0.087507, 0.000000, 1.198542, 0.000000, -0.119483, 0.000000, 1.000000}, 
{1.257310, 0.000000, 0.057353, 0.000000, 1.221777, 0.000000, -0.079092, 0.000000, 1.000000}, 
{1.263076, 0.000000, 0.027785, 0.000000, 1.245317, 0.000000, -0.038883, 0.000000, 1.000000}, 
{1.269870, 0.000000, -0.001331, 0.000000, 1.269953, 0.000000, 0.000557, 0.000000, 1.000000}, 
{0.000154, 0.000000, 0.000549, 0.000000, 0.000369, 0.000000, -3.554136, 0.000000, 1.000000}, 
{0.000506, 0.000000, 0.001797, 0.000000, 0.000503, 0.000000, -3.554133, 0.000000, 1.000000}, 
{0.002014, 0.000000, 0.007156, 0.000000, 0.002016, 0.000000, -3.553937, 0.000000, 1.000000}, 
{0.004544, 0.000000, 0.016145, 0.000000, 0.004533, 0.000000, -3.553096, 0.000000, 1.000000}, 
{0.008070, 0.000000, 0.028652, 0.000000, 0.008064, 0.000000, -3.553894, 0.000000, 1.000000}, 
{0.012584, 0.000000, 0.044617, 0.000000, 0.012579, 0.000000, -3.554000, 0.000000, 1.000000}, 
{0.018180, 0.000000, 0.064288, 0.000000, 0.018141, 0.000000, -3.549637, 0.000000, 1.000000}, 
{0.024887, 0.000000, 0.087627, 0.000000, 0.024700, 0.000000, -3.552006, 0.000000, 1.000000}, 
{0.032690, 0.000000, 0.114134, 0.000000, 0.032201, 0.000000, -3.550341, 0.000000, 1.000000}, 
{0.041705, 0.000000, 0.144154, 0.000000, 0.040734, 0.000000, -3.547982, 0.000000, 1.000000}, 
{0.052035, 0.000000, 0.177400, 0.000000, 0.050237, 0.000000, -3.544641, 0.000000, 1.000000}, 
{0.063810, 0.000000, 0.213813, 0.000000, 0.060722, 0.000000, -3.539941, 0.000000, 1.000000}, 
{0.077171, 0.000000, 0.252978, 0.000000, 0.072146, 0.000000, -3.533696, 0.000000, 1.000000}, 
{0.092329, 0.000000, 0.294852, 0.000000, 0.084494, 0.000000, -3.524977, 0.000000, 1.000000}, 
{0.109390, 0.000000, 0.338688, 0.000000, 0.097757, 0.000000, -3.513655, 0.000000, 1.000000}, 
{0.128455, 0.000000, 0.384018, 0.000000, 0.111957, 0.000000, -3.498484, 0.000000, 1.000000}, 
{0.149661, 0.000000, 0.429960, 0.000000, 0.127084, 0.000000, -3.478323, 0.000000, 1.000000}, 
{0.172694, 0.000000, 0.475024, 0.000000, 0.143172, 0.000000, -3.451862, 0.000000, 1.000000}, 
{0.197650, 0.000000, 0.518614, 0.000000, 0.160304, 0.000000, -3.417602, 0.000000, 1.000000}, 
{0.224156, 0.000000, 0.559298, 0.000000, 0.178438, 0.000000, -3.372913, 0.000000, 1.000000}, 
{0.252008, 0.000000, 0.596110, 0.000000, 0.197567, 0.000000, -3.317454, 0.000000, 1.000000}, 
{0.281165, 0.000000, 0.629292, 0.000000, 0.217793, 0.000000, -3.251171, 0.000000, 1.000000}, 
{0.311434, 0.000000, 0.658379, 0.000000, 0.238732, 0.000000, -3.172222, 0.000000, 1.000000}, 
{0.342741, 0.000000, 0.683455, 0.000000, 0.260461, 0.000000, -3.082825, 0.000000, 1.000000}, 
{0.373543, 0.000000, 0.701674, 0.000000, 0.283077, 0.000000, -2.983976, 0.000000, 1.000000}, 
{0.407008, 0.000000, 0.719664, 0.000000, 0.305477, 0.000000, -2.876244, 0.000000, 1.000000}, 
{0.438623, 0.000000, 0.729882, 0.000000, 0.329099, 0.000000, -2.763279, 0.000000, 1.000000}, 
{0.471872, 0.000000, 0.738696, 0.000000, 0.352630, 0.000000, -2.645590, 0.000000, 1.000000}, 
{0.504700, 0.000000, 0.743136, 0.000000, 0.376465, 0.000000, -2.524680, 0.000000, 1.000000}, 
{0.537118, 0.000000, 0.743676, 0.000000, 0.400111, 0.000000, -2.402723, 0.000000, 1.000000}, 
{0.569412, 0.000000, 0.741181, 0.000000, 0.423901, 0.000000, -2.281437, 0.000000, 1.000000}, 
{0.598202, 0.000000, 0.732348, 0.000000, 0.449026, 0.000000, -2.161401, 0.000000, 1.000000}, 
{0.629640, 0.000000, 0.724832, 0.000000, 0.472753, 0.000000, -2.043872, 0.000000, 1.000000}, 
{0.659239, 0.000000, 0.713435, 0.000000, 0.497418, 0.000000, -1.930129, 0.000000, 1.000000}, 
{0.686547, 0.000000, 0.698539, 0.000000, 0.521306, 0.000000, -1.817654, 0.000000, 1.000000}, 
{0.715529, 0.000000, 0.684471, 0.000000, 0.545967, 0.000000, -1.712567, 0.000000, 1.000000}, 
{0.739456, 0.000000, 0.664983, 0.000000, 0.570927, 0.000000, -1.610687, 0.000000, 1.000000}, 
{0.764892, 0.000000, 0.646322, 0.000000, 0.594657, 0.000000, -1.512031, 0.000000, 1.000000}, 
{0.789301, 0.000000, 0.626393, 0.000000, 0.619088, 0.000000, -1.419033, 0.000000, 1.000000}, 
{0.809881, 0.000000, 0.603498, 0.000000, 0.643461, 0.000000, -1.330115, 0.000000, 1.000000}, 
{0.833385, 0.000000, 0.582934, 0.000000, 0.667628, 0.000000, -1.245859, 0.000000, 1.000000}, 
{0.854254, 0.000000, 0.560419, 0.000000, 0.691846, 0.000000, -1.165042, 0.000000, 1.000000}, 
{0.873964, 0.000000, 0.537294, 0.000000, 0.714580, 0.000000, -1.086633, 0.000000, 1.000000}, 
{0.893433, 0.000000, 0.514264, 0.000000, 0.740297, 0.000000, -1.015028, 0.000000, 1.000000}, 
{0.911756, 0.000000, 0.490657, 0.000000, 0.764177, 0.000000, -0.944938, 0.000000, 1.000000}, 
{0.930894, 0.000000, 0.467601, 0.000000, 0.787814, 0.000000, -0.878743, 0.000000, 1.000000}, 
{0.948078, 0.000000, 0.444043, 0.000000, 0.812690, 0.000000, -0.815356, 0.000000, 1.000000}, 
{0.966162, 0.000000, 0.421155, 0.000000, 0.836566, 0.000000, -0.753883, 0.000000, 1.000000}, 
{0.984166, 0.000000, 0.398238, 0.000000, 0.862388, 0.000000, -0.695534, 0.000000, 1.000000}, 
{1.002184, 0.000000, 0.375278, 0.000000, 0.886579, 0.000000, -0.638806, 0.000000, 1.000000}, 
{1.019669, 0.000000, 0.352159, 0.000000, 0.911731, 0.000000, -0.584549, 0.000000, 1.000000}, 
{1.039571, 0.000000, 0.329651, 0.000000, 0.937931, 0.000000, -0.531660, 0.000000, 1.000000}, 
{1.059989, 0.000000, 0.306804, 0.000000, 0.964945, 0.000000, -0.480529, 0.000000, 1.000000}, 
{1.081116, 0.000000, 0.283345, 0.000000, 0.992960, 0.000000, -0.430071, 0.000000, 1.000000}, 
{1.105742, 0.000000, 0.258568, 0.000000, 1.023520, 0.000000, -0.380277, 0.000000, 1.000000}, 
{1.133080, 0.000000, 0.232146, 0.000000, 1.057158, 0.000000, -0.331076, 0.000000, 1.000000}, 
{1.161888, 0.000000, 0.205244, 0.000000, 1.091343, 0.000000, -0.284040, 0.000000, 1.000000}, 
{1.192408, 0.000000, 0.177932, 0.000000, 1.125317, 0.000000, -0.239958, 0.000000, 1.000000}, 
{1.221043, 0.000000, 0.149532, 0.000000, 1.155950, 0.000000, -0.198751, 0.000000, 1.000000}, 
{1.244141, 0.000000, 0.120046, 0.000000, 1.183329, 0.000000, -0.160114, 0.000000, 1.000000}, 
{1.259465, 0.000000, 0.089542, 0.000000, 1.207947, 0.000000, -0.121101, 0.000000, 1.000000}, 
{1.268124, 0.000000, 0.058593, 0.000000, 1.231792, 0.000000, -0.079898, 0.000000, 1.000000}, 
{1.274330, 0.000000, 0.028011, 0.000000, 1.256102, 0.000000, -0.039038, 0.000000, 1.000000}, 
{1.281590, 0.000000, -0.002330, 0.000000, 1.281482, 0.000000, 0.001259, 0.000000, 1.000000}, 
{0.000149, 0.000000, 0.000587, 0.000000, 0.000405, 0.000000, -3.927143, 0.000000, 1.000000}, 
{0.000507, 0.000000, 0.001992, 0.000000, 0.000503, 0.000000, -3.927149, 0.000000, 1.000000}, 
{0.002014, 0.000000, 0.007910, 0.000000, 0.002016, 0.000000, -3.926821, 0.000000, 1.000000}, 
{0.004549, 0.000000, 0.017856, 0.000000, 0.004513, 0.000000, -3.927027, 0.000000, 1.000000}, 
{0.008064, 0.000000, 0.031632, 0.000000, 0.008075, 0.000000, -3.925487, 0.000000, 1.000000}, 
{0.012450, 0.000000, 0.048749, 0.000000, 0.012804, 0.000000, -3.928272, 0.000000, 1.000000}, 
{0.018030, 0.000000, 0.070371, 0.000000, 0.018275, 0.000000, -3.917862, 0.000000, 1.000000}, 
{0.024964, 0.000000, 0.096897, 0.000000, 0.024621, 0.000000, -3.924489, 0.000000, 1.000000}, 
{0.032807, 0.000000, 0.126073, 0.000000, 0.032193, 0.000000, -3.921896, 0.000000, 1.000000}, 
{0.041917, 0.000000, 0.159205, 0.000000, 0.040719, 0.000000, -3.918860, 0.000000, 1.000000}, 
{0.052416, 0.000000, 0.195762, 0.000000, 0.050205, 0.000000, -3.914339, 0.000000, 1.000000}, 
{0.064464, 0.000000, 0.235784, 0.000000, 0.060650, 0.000000, -3.907954, 0.000000, 1.000000}, 
{0.078225, 0.000000, 0.278812, 0.000000, 0.072043, 0.000000, -3.899254, 0.000000, 1.000000}, 
{0.093900, 0.000000, 0.324457, 0.000000, 0.084350, 0.000000, -3.887455, 0.000000, 1.000000}, 
{0.111657, 0.000000, 0.372174, 0.000000, 0.097565, 0.000000, -3.871777, 0.000000, 1.000000}, 
{0.131478, 0.000000, 0.420530, 0.000000, 0.111738, 0.000000, -3.850776, 0.000000, 1.000000}, 
{0.153574, 0.000000, 0.469330, 0.000000, 0.126829, 0.000000, -3.822348, 0.000000, 1.000000}, 
{0.177505, 0.000000, 0.516029, 0.000000, 0.142918, 0.000000, -3.785168, 0.000000, 1.000000}, 
{0.203383, 0.000000, 0.560585, 0.000000, 0.160114, 0.000000, -3.736602, 0.000000, 1.000000}, 
{0.230569, 0.000000, 0.600607, 0.000000, 0.178386, 0.000000, -3.675046, 0.000000, 1.000000}, 
{0.259188, 0.000000, 0.636296, 0.000000, 0.197650, 0.000000, -3.599811, 0.000000, 1.000000}, 
{0.289272, 0.000000, 0.668312, 0.000000, 0.217601, 0.000000, -3.510550, 0.000000, 1.000000}, 
{0.320490, 0.000000, 0.695986, 0.000000, 0.238466, 0.000000, -3.408535, 0.000000, 1.000000}, 
{0.353031, 0.000000, 0.719848, 0.000000, 0.259724, 0.000000, -3.295667, 0.000000, 1.000000}, 
{0.385228, 0.000000, 0.737073, 0.000000, 0.281850, 0.000000, -3.171998, 0.000000, 1.000000}, 
{0.419219, 0.000000, 0.752419, 0.000000, 0.303975, 0.000000, -3.042428, 0.000000, 1.000000}, 
{0.452096, 0.000000, 0.761179, 0.000000, 0.326780, 0.000000, -2.907108, 0.000000, 1.000000}, 
{0.484909, 0.000000, 0.766166, 0.000000, 0.349915, 0.000000, -2.769858, 0.000000, 1.000000}, 
{0.518306, 0.000000, 0.768596, 0.000000, 0.373055, 0.000000, -2.631935, 0.000000, 1.000000}, 
{0.550067, 0.000000, 0.765683, 0.000000, 0.396246, 0.000000, -2.492870, 0.000000, 1.000000}, 
{0.582562, 0.000000, 0.761197, 0.000000, 0.419895, 0.000000, -2.358645, 0.000000, 1.000000}, 
{0.614450, 0.000000, 0.753834, 0.000000, 0.444020, 0.000000, -2.227377, 0.000000, 1.000000}, 
{0.644563, 0.000000, 0.742860, 0.000000, 0.467421, 0.000000, -2.097547, 0.000000, 1.000000}, 
{0.673658, 0.000000, 0.729294, 0.000000, 0.490921, 0.000000, -1.974920, 0.000000, 1.000000}, 
{0.702857, 0.000000, 0.714839, 0.000000, 0.514981, 0.000000, -1.857613, 0.000000, 1.000000}, 
{0.729350, 0.000000, 0.696774, 0.000000, 0.538657, 0.000000, -1.743601, 0.000000, 1.000000}, 
{0.754958, 0.000000, 0.677394, 0.000000, 0.563291, 0.000000, -1.636607, 0.000000, 1.000000}, 
{0.779575, 0.000000, 0.657018, 0.000000, 0.587205, 0.000000, -1.533841, 0.000000, 1.000000}, 
{0.800491, 0.000000, 0.633342, 0.000000, 0.612352, 0.000000, -1.437092, 0.000000, 1.000000}, 
{0.825030, 0.000000, 0.612471, 0.000000, 0.636356, 0.000000, -1.344272, 0.000000, 1.000000}, 
{0.847535, 0.000000, 0.589882, 0.000000, 0.660170, 0.000000, -1.256436, 0.000000, 1.000000}, 
{0.865979, 0.000000, 0.564850, 0.000000, 0.685071, 0.000000, -1.173938, 0.000000, 1.000000}, 
{0.886254, 0.000000, 0.541357, 0.000000, 0.709791, 0.000000, -1.094722, 0.000000, 1.000000}, 
{0.905566, 0.000000, 0.517353, 0.000000, 0.734952, 0.000000, -1.021107, 0.000000, 1.000000}, 
{0.924607, 0.000000, 0.493320, 0.000000, 0.758581, 0.000000, -0.948941, 0.000000, 1.000000}, 
{0.943365, 0.000000, 0.469366, 0.000000, 0.783696, 0.000000, -0.881060, 0.000000, 1.000000}, 
{0.960405, 0.000000, 0.444745, 0.000000, 0.809084, 0.000000, -0.816479, 0.000000, 1.000000}, 
{0.977893, 0.000000, 0.420493, 0.000000, 0.834008, 0.000000, -0.754604, 0.000000, 1.000000}, 
{0.996573, 0.000000, 0.397150, 0.000000, 0.858912, 0.000000, -0.694917, 0.000000, 1.000000}, 
{1.014000, 0.000000, 0.373483, 0.000000, 0.885705, 0.000000, -0.638445, 0.000000, 1.000000}, 
{1.031807, 0.000000, 0.349985, 0.000000, 0.911639, 0.000000, -0.584035, 0.000000, 1.000000}, 
{1.051877, 0.000000, 0.327062, 0.000000, 0.938839, 0.000000, -0.530010, 0.000000, 1.000000}, 
{1.071701, 0.000000, 0.304134, 0.000000, 0.967175, 0.000000, -0.479439, 0.000000, 1.000000}, 
{1.093109, 0.000000, 0.280962, 0.000000, 0.997173, 0.000000, -0.429763, 0.000000, 1.000000}, 
{1.116681, 0.000000, 0.258121, 0.000000, 1.027896, 0.000000, -0.381050, 0.000000, 1.000000}, 
{1.143886, 0.000000, 0.235365, 0.000000, 1.062882, 0.000000, -0.333395, 0.000000, 1.000000}, 
{1.175163, 0.000000, 0.211621, 0.000000, 1.098594, 0.000000, -0.287477, 0.000000, 1.000000}, 
{1.203675, 0.000000, 0.184061, 0.000000, 1.132553, 0.000000, -0.243301, 0.000000, 1.000000}, 
{1.230477, 0.000000, 0.154815, 0.000000, 1.164029, 0.000000, -0.201826, 0.000000, 1.000000}, 
{1.253134, 0.000000, 0.124513, 0.000000, 1.192277, 0.000000, -0.162271, 0.000000, 1.000000}, 
{1.270092, 0.000000, 0.093383, 0.000000, 1.218180, 0.000000, -0.122855, 0.000000, 1.000000}, 
{1.279576, 0.000000, 0.061770, 0.000000, 1.242757, 0.000000, -0.081639, 0.000000, 1.000000}, 
{1.286472, 0.000000, 0.030317, 0.000000, 1.267939, 0.000000, -0.040411, 0.000000, 1.000000}, 
{1.294476, 0.000000, -0.000964, 0.000000, 1.294210, 0.000000, 0.000454, 0.000000, 1.000000}, 
{0.000144, 0.000000, 0.000630, 0.000000, 0.000449, 0.000000, -4.381146, 0.000000, 1.000000}, 
{0.000504, 0.000000, 0.002208, 0.000000, 0.000504, 0.000000, -4.381151, 0.000000, 1.000000}, 
{0.002017, 0.000000, 0.008834, 0.000000, 0.002015, 0.000000, -4.380687, 0.000000, 1.000000}, 
{0.004536, 0.000000, 0.019864, 0.000000, 0.004536, 0.000000, -4.380550, 0.000000, 1.000000}, 
{0.008174, 0.000000, 0.035759, 0.000000, 0.008016, 0.000000, -4.381247, 0.000000, 1.000000}, 
{0.012608, 0.000000, 0.055034, 0.000000, 0.012619, 0.000000, -4.382390, 0.000000, 1.000000}, 
{0.018198, 0.000000, 0.079119, 0.000000, 0.018140, 0.000000, -4.379815, 0.000000, 1.000000}, 
{0.025057, 0.000000, 0.108067, 0.000000, 0.024637, 0.000000, -4.376874, 0.000000, 1.000000}, 
{0.032962, 0.000000, 0.140630, 0.000000, 0.032158, 0.000000, -4.374143, 0.000000, 1.000000}, 
{0.042199, 0.000000, 0.177350, 0.000000, 0.040686, 0.000000, -4.369558, 0.000000, 1.000000}, 
{0.052928, 0.000000, 0.218094, 0.000000, 0.050160, 0.000000, -4.363287, 0.000000, 1.000000}, 
{0.065327, 0.000000, 0.262407, 0.000000, 0.060579, 0.000000, -4.354386, 0.000000, 1.000000}, 
{0.079568, 0.000000, 0.309833, 0.000000, 0.071940, 0.000000, -4.342127, 0.000000, 1.000000}, 
{0.095961, 0.000000, 0.360074, 0.000000, 0.084181, 0.000000, -4.325533, 0.000000, 1.000000}, 
{0.114516, 0.000000, 0.411747, 0.000000, 0.097375, 0.000000, -4.302950, 0.000000, 1.000000}, 
{0.135349, 0.000000, 0.463726, 0.000000, 0.111483, 0.000000, -4.271991, 0.000000, 1.000000}, 
{0.158293, 0.000000, 0.514211, 0.000000, 0.126606, 0.000000, -4.230856, 0.000000, 1.000000}, 
{0.183348, 0.000000, 0.562511, 0.000000, 0.142811, 0.000000, -4.176250, 0.000000, 1.000000}, 
{0.209959, 0.000000, 0.606310, 0.000000, 0.160067, 0.000000, -4.105895, 0.000000, 1.000000}, 
{0.238736, 0.000000, 0.646958, 0.000000, 0.178195, 0.000000, -4.020104, 0.000000, 1.000000}, 
{0.268543, 0.000000, 0.681574, 0.000000, 0.197290, 0.000000, -3.916094, 0.000000, 1.000000}, 
{0.299996, 0.000000, 0.712458, 0.000000, 0.217096, 0.000000, -3.798239, 0.000000, 1.000000}, 
{0.331930, 0.000000, 0.737130, 0.000000, 0.237721, 0.000000, -3.664191, 0.000000, 1.000000}, 
{0.365222, 0.000000, 0.758156, 0.000000, 0.258703, 0.000000, -3.521867, 0.000000, 1.000000}, 
{0.399061, 0.000000, 0.774364, 0.000000, 0.280079, 0.000000, -3.369831, 0.000000, 1.000000}, 
{0.433480, 0.000000, 0.786412, 0.000000, 0.301604, 0.000000, -3.212079, 0.000000, 1.000000}, 
{0.467002, 0.000000, 0.792373, 0.000000, 0.323796, 0.000000, -3.053715, 0.000000, 1.000000}, 
{0.500754, 0.000000, 0.795410, 0.000000, 0.346305, 0.000000, -2.894526, 0.000000, 1.000000}, 
{0.534023, 0.000000, 0.794617, 0.000000, 0.368842, 0.000000, -2.735959, 0.000000, 1.000000}, 
{0.566988, 0.000000, 0.790689, 0.000000, 0.391328, 0.000000, -2.581160, 0.000000, 1.000000}, 
{0.599960, 0.000000, 0.784433, 0.000000, 0.414333, 0.000000, -2.432318, 0.000000, 1.000000}, 
{0.630599, 0.000000, 0.773378, 0.000000, 0.437419, 0.000000, -2.287630, 0.000000, 1.000000}, 
{0.660807, 0.000000, 0.760334, 0.000000, 0.460744, 0.000000, -2.150183, 0.000000, 1.000000}, 
{0.690103, 0.000000, 0.745430, 0.000000, 0.484172, 0.000000, -2.017266, 0.000000, 1.000000}, 
{0.717315, 0.000000, 0.727511, 0.000000, 0.508052, 0.000000, -1.891699, 0.000000, 1.000000}, 
{0.743819, 0.000000, 0.708376, 0.000000, 0.531850, 0.000000, -1.772680, 0.000000, 1.000000}, 
{0.770147, 0.000000, 0.688632, 0.000000, 0.556000, 0.000000, -1.660620, 0.000000, 1.000000}, 
{0.793510, 0.000000, 0.665931, 0.000000, 0.579779, 0.000000, -1.553166, 0.000000, 1.000000}, 
{0.816535, 0.000000, 0.643045, 0.000000, 0.603780, 0.000000, -1.452080, 0.000000, 1.000000}, 
{0.839163, 0.000000, 0.619917, 0.000000, 0.627966, 0.000000, -1.355544, 0.000000, 1.000000}, 
{0.859066, 0.000000, 0.594923, 0.000000, 0.653220, 0.000000, -1.267232, 0.000000, 1.000000}, 
{0.879489, 0.000000, 0.570343, 0.000000, 0.677715, 0.000000, -1.181702, 0.000000, 1.000000}, 
{0.898525, 0.000000, 0.544975, 0.000000, 0.703461, 0.000000, -1.102089, 0.000000, 1.000000}, 
{0.918359, 0.000000, 0.520585, 0.000000, 0.727905, 0.000000, -1.024744, 0.000000, 1.000000}, 
{0.937502, 0.000000, 0.496044, 0.000000, 0.752554, 0.000000, -0.951712, 0.000000, 1.000000}, 
{0.955573, 0.000000, 0.471010, 0.000000, 0.778802, 0.000000, -0.883374, 0.000000, 1.000000}, 
{0.972957, 0.000000, 0.445712, 0.000000, 0.804977, 0.000000, -0.818008, 0.000000, 1.000000}, 
{0.991248, 0.000000, 0.421201, 0.000000, 0.829982, 0.000000, -0.754446, 0.000000, 1.000000}, 
{1.008997, 0.000000, 0.396444, 0.000000, 0.856421, 0.000000, -0.694518, 0.000000, 1.000000}, 
{1.028127, 0.000000, 0.372362, 0.000000, 0.883653, 0.000000, -0.637259, 0.000000, 1.000000}, 
{1.045710, 0.000000, 0.347895, 0.000000, 0.911047, 0.000000, -0.581515, 0.000000, 1.000000}, 
{1.065977, 0.000000, 0.324409, 0.000000, 0.939143, 0.000000, -0.527713, 0.000000, 1.000000}, 
{1.087469, 0.000000, 0.301181, 0.000000, 0.968884, 0.000000, -0.476281, 0.000000, 1.000000}, 
{1.109943, 0.000000, 0.277866, 0.000000, 1.000023, 0.000000, -0.426403, 0.000000, 1.000000}, 
{1.134440, 0.000000, 0.254849, 0.000000, 1.033369, 0.000000, -0.377822, 0.000000, 1.000000}, 
{1.160986, 0.000000, 0.231754, 0.000000, 1.069065, 0.000000, -0.330740, 0.000000, 1.000000}, 
{1.188458, 0.000000, 0.207973, 0.000000, 1.105679, 0.000000, -0.286014, 0.000000, 1.000000}, 
{1.214405, 0.000000, 0.183424, 0.000000, 1.140776, 0.000000, -0.243600, 0.000000, 1.000000}, 
{1.239504, 0.000000, 0.157972, 0.000000, 1.172863, 0.000000, -0.203686, 0.000000, 1.000000}, 
{1.262961, 0.000000, 0.130607, 0.000000, 1.202462, 0.000000, -0.165214, 0.000000, 1.000000}, 
{1.280340, 0.000000, 0.099652, 0.000000, 1.229090, 0.000000, -0.126067, 0.000000, 1.000000}, 
{1.292129, 0.000000, 0.067363, 0.000000, 1.255146, 0.000000, -0.084791, 0.000000, 1.000000}, 
{1.299876, 0.000000, 0.035026, 0.000000, 1.281164, 0.000000, -0.042786, 0.000000, 1.000000}, 
{1.308328, 0.000000, 0.002944, 0.000000, 1.308381, 0.000000, -0.001385, 0.000000, 1.000000}, 
{0.000138, 0.000000, 0.000681, 0.000000, 0.000505, 0.000000, -4.946556, 0.000000, 1.000000}, 
{0.000503, 0.000000, 0.002486, 0.000000, 0.000505, 0.000000, -4.946532, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.009973, 0.000000, 0.002014, 0.000000, -4.946311, 0.000000, 1.000000}, 
{0.004539, 0.000000, 0.022440, 0.000000, 0.004533, 0.000000, -4.945823, 0.000000, 1.000000}, 
{0.008069, 0.000000, 0.039836, 0.000000, 0.008067, 0.000000, -4.945311, 0.000000, 1.000000}, 
{0.012628, 0.000000, 0.062172, 0.000000, 0.012604, 0.000000, -4.945041, 0.000000, 1.000000}, 
{0.018294, 0.000000, 0.089609, 0.000000, 0.018131, 0.000000, -4.943295, 0.000000, 1.000000}, 
{0.025079, 0.000000, 0.121584, 0.000000, 0.024631, 0.000000, -4.939368, 0.000000, 1.000000}, 
{0.033142, 0.000000, 0.158595, 0.000000, 0.032181, 0.000000, -4.936200, 0.000000, 1.000000}, 
{0.042596, 0.000000, 0.199971, 0.000000, 0.040657, 0.000000, -4.929842, 0.000000, 1.000000}, 
{0.053628, 0.000000, 0.245624, 0.000000, 0.050096, 0.000000, -4.920586, 0.000000, 1.000000}, 
{0.066496, 0.000000, 0.295240, 0.000000, 0.060484, 0.000000, -4.907700, 0.000000, 1.000000}, 
{0.081434, 0.000000, 0.348006, 0.000000, 0.071764, 0.000000, -4.889647, 0.000000, 1.000000}, 
{0.098640, 0.000000, 0.403167, 0.000000, 0.083983, 0.000000, -4.864680, 0.000000, 1.000000}, 
{0.118231, 0.000000, 0.459106, 0.000000, 0.097123, 0.000000, -4.830574, 0.000000, 1.000000}, 
{0.140139, 0.000000, 0.513907, 0.000000, 0.111270, 0.000000, -4.783530, 0.000000, 1.000000}, 
{0.164198, 0.000000, 0.565953, 0.000000, 0.126495, 0.000000, -4.720530, 0.000000, 1.000000}, 
{0.190502, 0.000000, 0.614858, 0.000000, 0.142668, 0.000000, -4.638075, 0.000000, 1.000000}, 
{0.218530, 0.000000, 0.658304, 0.000000, 0.159903, 0.000000, -4.535464, 0.000000, 1.000000}, 
{0.248094, 0.000000, 0.696133, 0.000000, 0.178070, 0.000000, -4.411646, 0.000000, 1.000000}, 
{0.279435, 0.000000, 0.729388, 0.000000, 0.196878, 0.000000, -4.268872, 0.000000, 1.000000}, 
{0.312002, 0.000000, 0.757534, 0.000000, 0.216366, 0.000000, -4.109603, 0.000000, 1.000000}, 
{0.346173, 0.000000, 0.781866, 0.000000, 0.236327, 0.000000, -3.938782, 0.000000, 1.000000}, 
{0.379435, 0.000000, 0.797579, 0.000000, 0.256938, 0.000000, -3.756138, 0.000000, 1.000000}, 
{0.414945, 0.000000, 0.812334, 0.000000, 0.277571, 0.000000, -3.571258, 0.000000, 1.000000}, 
{0.449991, 0.000000, 0.821119, 0.000000, 0.298637, 0.000000, -3.384217, 0.000000, 1.000000}, 
{0.484636, 0.000000, 0.825066, 0.000000, 0.319892, 0.000000, -3.198076, 0.000000, 1.000000}, 
{0.518675, 0.000000, 0.824728, 0.000000, 0.341703, 0.000000, -3.015808, 0.000000, 1.000000}, 
{0.552559, 0.000000, 0.821710, 0.000000, 0.363523, 0.000000, -2.836886, 0.000000, 1.000000}, 
{0.587272, 0.000000, 0.817478, 0.000000, 0.384939, 0.000000, -2.664995, 0.000000, 1.000000}, 
{0.616960, 0.000000, 0.804441, 0.000000, 0.408026, 0.000000, -2.502223, 0.000000, 1.000000}, 
{0.648054, 0.000000, 0.792063, 0.000000, 0.430692, 0.000000, -2.345851, 0.000000, 1.000000}, 
{0.678575, 0.000000, 0.777793, 0.000000, 0.453490, 0.000000, -2.197150, 0.000000, 1.000000}, 
{0.707287, 0.000000, 0.760476, 0.000000, 0.476467, 0.000000, -2.056042, 0.000000, 1.000000}, 
{0.735851, 0.000000, 0.742541, 0.000000, 0.499003, 0.000000, -1.922805, 0.000000, 1.000000}, 
{0.760594, 0.000000, 0.720503, 0.000000, 0.523541, 0.000000, -1.798585, 0.000000, 1.000000}, 
{0.784534, 0.000000, 0.697719, 0.000000, 0.546812, 0.000000, -1.680605, 0.000000, 1.000000}, 
{0.811029, 0.000000, 0.677036, 0.000000, 0.570193, 0.000000, -1.568942, 0.000000, 1.000000}, 
{0.831809, 0.000000, 0.651479, 0.000000, 0.595234, 0.000000, -1.465496, 0.000000, 1.000000}, 
{0.854364, 0.000000, 0.627376, 0.000000, 0.620327, 0.000000, -1.367849, 0.000000, 1.000000}, 
{0.872639, 0.000000, 0.600496, 0.000000, 0.644964, 0.000000, -1.275644, 0.000000, 1.000000}, 
{0.894296, 0.000000, 0.576297, 0.000000, 0.670540, 0.000000, -1.188638, 0.000000, 1.000000}, 
{0.913123, 0.000000, 0.550377, 0.000000, 0.695273, 0.000000, -1.105652, 0.000000, 1.000000}, 
{0.932025, 0.000000, 0.524640, 0.000000, 0.721149, 0.000000, -1.028614, 0.000000, 1.000000}, 
{0.949876, 0.000000, 0.498402, 0.000000, 0.746244, 0.000000, -0.954421, 0.000000, 1.000000}, 
{0.968933, 0.000000, 0.473220, 0.000000, 0.772540, 0.000000, -0.884061, 0.000000, 1.000000}, 
{0.985366, 0.000000, 0.447086, 0.000000, 0.799236, 0.000000, -0.817765, 0.000000, 1.000000}, 
{1.004940, 0.000000, 0.422394, 0.000000, 0.827148, 0.000000, -0.753295, 0.000000, 1.000000}, 
{1.022217, 0.000000, 0.396726, 0.000000, 0.854017, 0.000000, -0.693380, 0.000000, 1.000000}, 
{1.041490, 0.000000, 0.371854, 0.000000, 0.882070, 0.000000, -0.635747, 0.000000, 1.000000}, 
{1.059920, 0.000000, 0.346769, 0.000000, 0.910845, 0.000000, -0.579508, 0.000000, 1.000000}, 
{1.080408, 0.000000, 0.322343, 0.000000, 0.940438, 0.000000, -0.525045, 0.000000, 1.000000}, 
{1.101632, 0.000000, 0.297979, 0.000000, 0.971020, 0.000000, -0.473773, 0.000000, 1.000000}, 
{1.124812, 0.000000, 0.274059, 0.000000, 1.005446, 0.000000, -0.422949, 0.000000, 1.000000}, 
{1.148503, 0.000000, 0.249954, 0.000000, 1.039122, 0.000000, -0.374609, 0.000000, 1.000000}, 
{1.174554, 0.000000, 0.225988, 0.000000, 1.075984, 0.000000, -0.327350, 0.000000, 1.000000}, 
{1.202931, 0.000000, 0.201932, 0.000000, 1.113913, 0.000000, -0.283494, 0.000000, 1.000000}, 
{1.229335, 0.000000, 0.176886, 0.000000, 1.150193, 0.000000, -0.241092, 0.000000, 1.000000}, 
{1.254254, 0.000000, 0.151225, 0.000000, 1.183206, 0.000000, -0.201514, 0.000000, 1.000000}, 
{1.275743, 0.000000, 0.124282, 0.000000, 1.212873, 0.000000, -0.162866, 0.000000, 1.000000}, 
{1.292929, 0.000000, 0.097122, 0.000000, 1.241158, 0.000000, -0.124991, 0.000000, 1.000000}, 
{1.305805, 0.000000, 0.068939, 0.000000, 1.268704, 0.000000, -0.085521, 0.000000, 1.000000}, 
{1.314991, 0.000000, 0.040082, 0.000000, 1.296160, 0.000000, -0.045247, 0.000000, 1.000000}, 
{1.324033, 0.000000, 0.009923, 0.000000, 1.324222, 0.000000, -0.004738, 0.000000, 1.000000}, 
{0.000131, 0.000000, 0.000745, 0.000000, 0.000576, 0.000000, -5.671075, 0.000000, 1.000000}, 
{0.000473, 0.000000, 0.002681, 0.000000, 0.000576, 0.000000, -5.670949, 0.000000, 1.000000}, 
{0.002021, 0.000000, 0.011462, 0.000000, 0.002033, 0.000000, -5.670177, 0.000000, 1.000000}, 
{0.004540, 0.000000, 0.025728, 0.000000, 0.004533, 0.000000, -5.670197, 0.000000, 1.000000}, 
{0.008087, 0.000000, 0.045746, 0.000000, 0.008056, 0.000000, -5.667313, 0.000000, 1.000000}, 
{0.012673, 0.000000, 0.071427, 0.000000, 0.012588, 0.000000, -5.668396, 0.000000, 1.000000}, 
{0.018358, 0.000000, 0.102673, 0.000000, 0.018103, 0.000000, -5.665252, 0.000000, 1.000000}, 
{0.025299, 0.000000, 0.139780, 0.000000, 0.024488, 0.000000, -5.653404, 0.000000, 1.000000}, 
{0.033469, 0.000000, 0.181718, 0.000000, 0.032038, 0.000000, -5.652829, 0.000000, 1.000000}, 
{0.043139, 0.000000, 0.228698, 0.000000, 0.040606, 0.000000, -5.645676, 0.000000, 1.000000}, 
{0.054622, 0.000000, 0.280648, 0.000000, 0.050011, 0.000000, -5.631547, 0.000000, 1.000000}, 
{0.068115, 0.000000, 0.336524, 0.000000, 0.060345, 0.000000, -5.611561, 0.000000, 1.000000}, 
{0.083957, 0.000000, 0.395671, 0.000000, 0.071582, 0.000000, -5.583449, 0.000000, 1.000000}, 
{0.102259, 0.000000, 0.456164, 0.000000, 0.083752, 0.000000, -5.543651, 0.000000, 1.000000}, 
{0.123021, 0.000000, 0.515765, 0.000000, 0.096936, 0.000000, -5.488278, 0.000000, 1.000000}, 
{0.146127, 0.000000, 0.572309, 0.000000, 0.111151, 0.000000, -5.413118, 0.000000, 1.000000}, 
{0.171749, 0.000000, 0.625710, 0.000000, 0.126411, 0.000000, -5.312369, 0.000000, 1.000000}, 
{0.199549, 0.000000, 0.673853, 0.000000, 0.142612, 0.000000, -5.185774, 0.000000, 1.000000}, 
{0.229188, 0.000000, 0.715905, 0.000000, 0.159751, 0.000000, -5.030582, 0.000000, 1.000000}, 
{0.260421, 0.000000, 0.751533, 0.000000, 0.177643, 0.000000, -4.853484, 0.000000, 1.000000}, 
{0.293421, 0.000000, 0.782309, 0.000000, 0.195942, 0.000000, -4.656137, 0.000000, 1.000000}, 
{0.327077, 0.000000, 0.806332, 0.000000, 0.215016, 0.000000, -4.443975, 0.000000, 1.000000}, 
{0.361892, 0.000000, 0.825818, 0.000000, 0.234494, 0.000000, -4.223844, 0.000000, 1.000000}, 
{0.397146, 0.000000, 0.840019, 0.000000, 0.254248, 0.000000, -3.998959, 0.000000, 1.000000}, 
{0.434169, 0.000000, 0.852434, 0.000000, 0.274188, 0.000000, -3.775443, 0.000000, 1.000000}, 
{0.469288, 0.000000, 0.856632, 0.000000, 0.294460, 0.000000, -3.552818, 0.000000, 1.000000}, 
{0.504319, 0.000000, 0.857130, 0.000000, 0.315322, 0.000000, -3.338825, 0.000000, 1.000000}, 
{0.540067, 0.000000, 0.855903, 0.000000, 0.335649, 0.000000, -3.130547, 0.000000, 1.000000}, 
{0.575404, 0.000000, 0.851565, 0.000000, 0.357006, 0.000000, -2.932930, 0.000000, 1.000000}, 
{0.606782, 0.000000, 0.839818, 0.000000, 0.378534, 0.000000, -2.743876, 0.000000, 1.000000}, 
{0.638660, 0.000000, 0.827508, 0.000000, 0.400145, 0.000000, -2.565115, 0.000000, 1.000000}, 
{0.670577, 0.000000, 0.814154, 0.000000, 0.421542, 0.000000, -2.395215, 0.000000, 1.000000}, 
{0.696718, 0.000000, 0.793162, 0.000000, 0.445254, 0.000000, -2.238233, 0.000000, 1.000000}, 
{0.725990, 0.000000, 0.775291, 0.000000, 0.467869, 0.000000, -2.090264, 0.000000, 1.000000}, 
{0.754140, 0.000000, 0.755758, 0.000000, 0.490120, 0.000000, -1.950834, 0.000000, 1.000000}, 
{0.775992, 0.000000, 0.729824, 0.000000, 0.514061, 0.000000, -1.820582, 0.000000, 1.000000}, 
{0.802990, 0.000000, 0.708909, 0.000000, 0.537790, 0.000000, -1.699191, 0.000000, 1.000000}, 
{0.828291, 0.000000, 0.686483, 0.000000, 0.561218, 0.000000, -1.583805, 0.000000, 1.000000}, 
{0.847406, 0.000000, 0.659162, 0.000000, 0.586917, 0.000000, -1.478093, 0.000000, 1.000000}, 
{0.864951, 0.000000, 0.631051, 0.000000, 0.612378, 0.000000, -1.378496, 0.000000, 1.000000}, 
{0.887154, 0.000000, 0.606590, 0.000000, 0.636265, 0.000000, -1.282127, 0.000000, 1.000000}, 
{0.906337, 0.000000, 0.580124, 0.000000, 0.662546, 0.000000, -1.194643, 0.000000, 1.000000}, 
{0.927184, 0.000000, 0.554835, 0.000000, 0.687605, 0.000000, -1.110354, 0.000000, 1.000000}, 
{0.943810, 0.000000, 0.527583, 0.000000, 0.714841, 0.000000, -1.031996, 0.000000, 1.000000}, 
{0.963630, 0.000000, 0.502243, 0.000000, 0.740970, 0.000000, -0.956718, 0.000000, 1.000000}, 
{0.979691, 0.000000, 0.475006, 0.000000, 0.768640, 0.000000, -0.886957, 0.000000, 1.000000}, 
{0.997690, 0.000000, 0.448815, 0.000000, 0.795746, 0.000000, -0.819006, 0.000000, 1.000000}, 
{1.016460, 0.000000, 0.423044, 0.000000, 0.823626, 0.000000, -0.754892, 0.000000, 1.000000}, 
{1.035485, 0.000000, 0.397637, 0.000000, 0.851768, 0.000000, -0.693707, 0.000000, 1.000000}, 
{1.053165, 0.000000, 0.371775, 0.000000, 0.881629, 0.000000, -0.634867, 0.000000, 1.000000}, 
{1.072394, 0.000000, 0.346372, 0.000000, 0.911619, 0.000000, -0.578574, 0.000000, 1.000000}, 
{1.093397, 0.000000, 0.321291, 0.000000, 0.942854, 0.000000, -0.524341, 0.000000, 1.000000}, 
{1.115194, 0.000000, 0.296102, 0.000000, 0.974664, 0.000000, -0.472059, 0.000000, 1.000000}, 
{1.137943, 0.000000, 0.271023, 0.000000, 1.009457, 0.000000, -0.421674, 0.000000, 1.000000}, 
{1.164163, 0.000000, 0.246367, 0.000000, 1.045436, 0.000000, -0.371963, 0.000000, 1.000000}, 
{1.191457, 0.000000, 0.221414, 0.000000, 1.084977, 0.000000, -0.325040, 0.000000, 1.000000}, 
{1.220253, 0.000000, 0.196228, 0.000000, 1.124249, 0.000000, -0.280343, 0.000000, 1.000000}, 
{1.245456, 0.000000, 0.169991, 0.000000, 1.160363, 0.000000, -0.238098, 0.000000, 1.000000}, 
{1.270647, 0.000000, 0.143314, 0.000000, 1.194734, 0.000000, -0.197886, 0.000000, 1.000000}, 
{1.292124, 0.000000, 0.115881, 0.000000, 1.225564, 0.000000, -0.159560, 0.000000, 1.000000}, 
{1.309091, 0.000000, 0.087816, 0.000000, 1.255130, 0.000000, -0.120547, 0.000000, 1.000000}, 
{1.321130, 0.000000, 0.059301, 0.000000, 1.283685, 0.000000, -0.080834, 0.000000, 1.000000}, 
{1.332484, 0.000000, 0.030912, 0.000000, 1.313046, 0.000000, -0.040933, 0.000000, 1.000000}, 
{1.342834, 0.000000, 0.002172, 0.000000, 1.343386, 0.000000, -0.001185, 0.000000, 1.000000}, 
{0.000125, 0.000000, 0.000830, 0.000000, 0.000671, 0.000000, -6.634228, 0.000000, 1.000000}, 
{0.000443, 0.000000, 0.002936, 0.000000, 0.000671, 0.000000, -6.634032, 0.000000, 1.000000}, 
{0.002016, 0.000000, 0.013374, 0.000000, 0.002015, 0.000000, -6.633008, 0.000000, 1.000000}, 
{0.004540, 0.000000, 0.030089, 0.000000, 0.004534, 0.000000, -6.633056, 0.000000, 1.000000}, 
{0.008092, 0.000000, 0.053499, 0.000000, 0.008046, 0.000000, -6.626466, 0.000000, 1.000000}, 
{0.012710, 0.000000, 0.083610, 0.000000, 0.012655, 0.000000, -6.630330, 0.000000, 1.000000}, 
{0.018485, 0.000000, 0.120260, 0.000000, 0.018001, 0.000000, -6.614516, 0.000000, 1.000000}, 
{0.025134, 0.000000, 0.161031, 0.000000, 0.024354, 0.000000, -6.600349, 0.000000, 1.000000}, 
{0.033897, 0.000000, 0.212161, 0.000000, 0.032047, 0.000000, -6.610186, 0.000000, 1.000000}, 
{0.043978, 0.000000, 0.266661, 0.000000, 0.040545, 0.000000, -6.593605, 0.000000, 1.000000}, 
{0.056094, 0.000000, 0.326582, 0.000000, 0.049888, 0.000000, -6.570142, 0.000000, 1.000000}, 
{0.070528, 0.000000, 0.390342, 0.000000, 0.060151, 0.000000, -6.536712, 0.000000, 1.000000}, 
{0.087498, 0.000000, 0.456162, 0.000000, 0.071350, 0.000000, -6.488329, 0.000000, 1.000000}, 
{0.107138, 0.000000, 0.521609, 0.000000, 0.083548, 0.000000, -6.420198, 0.000000, 1.000000}, 
{0.129461, 0.000000, 0.584225, 0.000000, 0.096745, 0.000000, -6.323702, 0.000000, 1.000000}, 
{0.154245, 0.000000, 0.641931, 0.000000, 0.111066, 0.000000, -6.193606, 0.000000, 1.000000}, 
{0.181228, 0.000000, 0.692829, 0.000000, 0.126364, 0.000000, -6.026897, 0.000000, 1.000000}, 
{0.210711, 0.000000, 0.738440, 0.000000, 0.142442, 0.000000, -5.825769, 0.000000, 1.000000}, 
{0.242181, 0.000000, 0.777397, 0.000000, 0.159291, 0.000000, -5.595428, 0.000000, 1.000000}, 
{0.275337, 0.000000, 0.809980, 0.000000, 0.176729, 0.000000, -5.342321, 0.000000, 1.000000}, 
{0.309698, 0.000000, 0.835990, 0.000000, 0.194669, 0.000000, -5.073076, 0.000000, 1.000000}, 
{0.345702, 0.000000, 0.858077, 0.000000, 0.212719, 0.000000, -4.794572, 0.000000, 1.000000}, 
{0.382135, 0.000000, 0.874122, 0.000000, 0.231440, 0.000000, -4.516676, 0.000000, 1.000000}, 
{0.419871, 0.000000, 0.887133, 0.000000, 0.250277, 0.000000, -4.241767, 0.000000, 1.000000}, 
{0.455609, 0.000000, 0.891199, 0.000000, 0.269612, 0.000000, -3.972124, 0.000000, 1.000000}, 
{0.492617, 0.000000, 0.894082, 0.000000, 0.289368, 0.000000, -3.717271, 0.000000, 1.000000}, 
{0.528186, 0.000000, 0.891270, 0.000000, 0.309382, 0.000000, -3.471719, 0.000000, 1.000000}, 
{0.563462, 0.000000, 0.885719, 0.000000, 0.329201, 0.000000, -3.237760, 0.000000, 1.000000}, 
{0.596013, 0.000000, 0.874241, 0.000000, 0.350237, 0.000000, -3.019060, 0.000000, 1.000000}, 
{0.629455, 0.000000, 0.862814, 0.000000, 0.370616, 0.000000, -2.813572, 0.000000, 1.000000}, 
{0.661110, 0.000000, 0.848126, 0.000000, 0.391945, 0.000000, -2.621046, 0.000000, 1.000000}, 
{0.690314, 0.000000, 0.829798, 0.000000, 0.413489, 0.000000, -2.441627, 0.000000, 1.000000}, 
{0.720589, 0.000000, 0.812314, 0.000000, 0.434868, 0.000000, -2.274629, 0.000000, 1.000000}, 
{0.745631, 0.000000, 0.788704, 0.000000, 0.458086, 0.000000, -2.119423, 0.000000, 1.000000}, 
{0.771488, 0.000000, 0.766133, 0.000000, 0.480588, 0.000000, -1.974380, 0.000000, 1.000000}, 
{0.798704, 0.000000, 0.744726, 0.000000, 0.503615, 0.000000, -1.839482, 0.000000, 1.000000}, 
{0.820172, 0.000000, 0.718062, 0.000000, 0.527120, 0.000000, -1.713244, 0.000000, 1.000000}, 
{0.844368, 0.000000, 0.693972, 0.000000, 0.550316, 0.000000, -1.594809, 0.000000, 1.000000}, 
{0.863128, 0.000000, 0.665748, 0.000000, 0.576898, 0.000000, -1.487512, 0.000000, 1.000000}, 
{0.880094, 0.000000, 0.637003, 0.000000, 0.602562, 0.000000, -1.386724, 0.000000, 1.000000}, 
{0.904252, 0.000000, 0.613728, 0.000000, 0.626720, 0.000000, -1.288131, 0.000000, 1.000000}, 
{0.920506, 0.000000, 0.585217, 0.000000, 0.653471, 0.000000, -1.199845, 0.000000, 1.000000}, 
{0.940919, 0.000000, 0.559603, 0.000000, 0.680268, 0.000000, -1.114958, 0.000000, 1.000000}, 
{0.957044, 0.000000, 0.531597, 0.000000, 0.707395, 0.000000, -1.034754, 0.000000, 1.000000}, 
{0.972648, 0.000000, 0.503583, 0.000000, 0.735885, 0.000000, -0.960912, 0.000000, 1.000000}, 
{0.994318, 0.000000, 0.478813, 0.000000, 0.763772, 0.000000, -0.889786, 0.000000, 1.000000}, 
{1.008754, 0.000000, 0.450943, 0.000000, 0.791243, 0.000000, -0.820833, 0.000000, 1.000000}, 
{1.028667, 0.000000, 0.425516, 0.000000, 0.820862, 0.000000, -0.756332, 0.000000, 1.000000}, 
{1.046145, 0.000000, 0.398977, 0.000000, 0.849613, 0.000000, -0.693921, 0.000000, 1.000000}, 
{1.067212, 0.000000, 0.373657, 0.000000, 0.881165, 0.000000, -0.635955, 0.000000, 1.000000}, 
{1.084111, 0.000000, 0.346657, 0.000000, 0.911983, 0.000000, -0.578832, 0.000000, 1.000000}, 
{1.106749, 0.000000, 0.321392, 0.000000, 0.944130, 0.000000, -0.523561, 0.000000, 1.000000}, 
{1.128440, 0.000000, 0.295773, 0.000000, 0.979092, 0.000000, -0.471146, 0.000000, 1.000000}, 
{1.151073, 0.000000, 0.270028, 0.000000, 1.014804, 0.000000, -0.420298, 0.000000, 1.000000}, 
{1.178601, 0.000000, 0.244816, 0.000000, 1.054058, 0.000000, -0.370575, 0.000000, 1.000000}, 
{1.206845, 0.000000, 0.219027, 0.000000, 1.094997, 0.000000, -0.323716, 0.000000, 1.000000}, 
{1.235963, 0.000000, 0.192622, 0.000000, 1.135387, 0.000000, -0.278058, 0.000000, 1.000000}, 
{1.263030, 0.000000, 0.165331, 0.000000, 1.173782, 0.000000, -0.235743, 0.000000, 1.000000}, 
{1.288937, 0.000000, 0.137489, 0.000000, 1.208955, 0.000000, -0.195390, 0.000000, 1.000000}, 
{1.310681, 0.000000, 0.108685, 0.000000, 1.242001, 0.000000, -0.156439, 0.000000, 1.000000}, 
{1.334352, 0.000000, 0.079710, 0.000000, 1.274514, 0.000000, -0.117096, 0.000000, 1.000000}, 
{1.344847, 0.000000, 0.049947, 0.000000, 1.303570, 0.000000, -0.076554, 0.000000, 1.000000}, 
{1.354943, 0.000000, 0.020272, 0.000000, 1.334211, 0.000000, -0.035585, 0.000000, 1.000000}, 
{1.365515, 0.000000, -0.009170, 0.000000, 1.365601, 0.000000, 0.004771, 0.000000, 1.000000}, 
{0.000117, 0.000000, 0.000935, 0.000000, 0.000804, 0.000000, -7.979243, 0.000000, 1.000000}, 
{0.000410, 0.000000, 0.003275, 0.000000, 0.000804, 0.000000, -7.979422, 0.000000, 1.000000}, 
{0.002009, 0.000000, 0.016024, 0.000000, 0.002017, 0.000000, -7.977156, 0.000000, 1.000000}, 
{0.004541, 0.000000, 0.036176, 0.000000, 0.004533, 0.000000, -7.976128, 0.000000, 1.000000}, 
{0.008109, 0.000000, 0.064384, 0.000000, 0.008031, 0.000000, -7.964988, 0.000000, 1.000000}, 
{0.012694, 0.000000, 0.099984, 0.000000, 0.012556, 0.000000, -7.971348, 0.000000, 1.000000}, 
{0.018554, 0.000000, 0.143991, 0.000000, 0.017937, 0.000000, -7.923116, 0.000000, 1.000000}, 
{0.025303, 0.000000, 0.192040, 0.000000, 0.025073, 0.000000, -7.953975, 0.000000, 1.000000}, 
{0.035297, 0.000000, 0.259442, 0.000000, 0.031544, 0.000000, -7.921861, 0.000000, 1.000000}, 
{0.045226, 0.000000, 0.318370, 0.000000, 0.040474, 0.000000, -7.909609, 0.000000, 1.000000}, 
{0.058370, 0.000000, 0.388821, 0.000000, 0.049713, 0.000000, -7.864696, 0.000000, 1.000000}, 
{0.074083, 0.000000, 0.461667, 0.000000, 0.059935, 0.000000, -7.801843, 0.000000, 1.000000}, 
{0.092537, 0.000000, 0.533744, 0.000000, 0.071156, 0.000000, -7.708949, 0.000000, 1.000000}, 
{0.113781, 0.000000, 0.601905, 0.000000, 0.083462, 0.000000, -7.575799, 0.000000, 1.000000}, 
{0.137786, 0.000000, 0.664409, 0.000000, 0.096787, 0.000000, -7.393524, 0.000000, 1.000000}, 
{0.164770, 0.000000, 0.721193, 0.000000, 0.110992, 0.000000, -7.161756, 0.000000, 1.000000}, 
{0.193894, 0.000000, 0.768842, 0.000000, 0.126209, 0.000000, -6.882018, 0.000000, 1.000000}, 
{0.225586, 0.000000, 0.810332, 0.000000, 0.141867, 0.000000, -6.564607, 0.000000, 1.000000}, 
{0.259311, 0.000000, 0.845096, 0.000000, 0.158112, 0.000000, -6.221983, 0.000000, 1.000000}, 
{0.294517, 0.000000, 0.872849, 0.000000, 0.174931, 0.000000, -5.865831, 0.000000, 1.000000}, 
{0.331163, 0.000000, 0.895159, 0.000000, 0.192172, 0.000000, -5.507064, 0.000000, 1.000000}, 
{0.368964, 0.000000, 0.912860, 0.000000, 0.209388, 0.000000, -5.149763, 0.000000, 1.000000}, 
{0.407255, 0.000000, 0.925338, 0.000000, 0.227222, 0.000000, -4.806172, 0.000000, 1.000000}, 
{0.444704, 0.000000, 0.930956, 0.000000, 0.245225, 0.000000, -4.472272, 0.000000, 1.000000}, 
{0.482041, 0.000000, 0.932576, 0.000000, 0.264047, 0.000000, -4.160864, 0.000000, 1.000000}, 
{0.519572, 0.000000, 0.931547, 0.000000, 0.282400, 0.000000, -3.865206, 0.000000, 1.000000}, 
{0.556236, 0.000000, 0.926554, 0.000000, 0.301291, 0.000000, -3.590445, 0.000000, 1.000000}, 
{0.590431, 0.000000, 0.915839, 0.000000, 0.320874, 0.000000, -3.332747, 0.000000, 1.000000}, 
{0.622723, 0.000000, 0.901266, 0.000000, 0.340967, 0.000000, -3.093264, 0.000000, 1.000000}, 
{0.657029, 0.000000, 0.888747, 0.000000, 0.360592, 0.000000, -2.873842, 0.000000, 1.000000}, 
{0.686164, 0.000000, 0.868666, 0.000000, 0.381209, 0.000000, -2.666740, 0.000000, 1.000000}, 
{0.719168, 0.000000, 0.853152, 0.000000, 0.401903, 0.000000, -2.479017, 0.000000, 1.000000}, 
{0.742294, 0.000000, 0.826169, 0.000000, 0.425287, 0.000000, -2.306498, 0.000000, 1.000000}, 
{0.770320, 0.000000, 0.804936, 0.000000, 0.446079, 0.000000, -2.141328, 0.000000, 1.000000}, 
{0.792337, 0.000000, 0.777772, 0.000000, 0.470243, 0.000000, -1.994663, 0.000000, 1.000000}, 
{0.819050, 0.000000, 0.755478, 0.000000, 0.492422, 0.000000, -1.853950, 0.000000, 1.000000}, 
{0.837684, 0.000000, 0.726072, 0.000000, 0.516209, 0.000000, -1.725590, 0.000000, 1.000000}, 
{0.861324, 0.000000, 0.701424, 0.000000, 0.540488, 0.000000, -1.606303, 0.000000, 1.000000}, 
{0.880741, 0.000000, 0.673615, 0.000000, 0.565780, 0.000000, -1.495452, 0.000000, 1.000000}, 
{0.903335, 0.000000, 0.648506, 0.000000, 0.590863, 0.000000, -1.391162, 0.000000, 1.000000}, 
{0.920311, 0.000000, 0.619640, 0.000000, 0.616955, 0.000000, -1.294734, 0.000000, 1.000000}, 
{0.935769, 0.000000, 0.590245, 0.000000, 0.644622, 0.000000, -1.204518, 0.000000, 1.000000}, 
{0.956592, 0.000000, 0.564944, 0.000000, 0.671277, 0.000000, -1.118630, 0.000000, 1.000000}, 
{0.972424, 0.000000, 0.536842, 0.000000, 0.699239, 0.000000, -1.038323, 0.000000, 1.000000}, 
{0.986269, 0.000000, 0.508020, 0.000000, 0.729387, 0.000000, -0.963803, 0.000000, 1.000000}, 
{1.006122, 0.000000, 0.482411, 0.000000, 0.757699, 0.000000, -0.890986, 0.000000, 1.000000}, 
{1.022504, 0.000000, 0.455110, 0.000000, 0.786154, 0.000000, -0.820936, 0.000000, 1.000000}, 
{1.037905, 0.000000, 0.427450, 0.000000, 0.817641, 0.000000, -0.758556, 0.000000, 1.000000}, 
{1.059281, 0.000000, 0.402198, 0.000000, 0.849051, 0.000000, -0.696126, 0.000000, 1.000000}, 
{1.076613, 0.000000, 0.375156, 0.000000, 0.880858, 0.000000, -0.636676, 0.000000, 1.000000}, 
{1.097828, 0.000000, 0.349577, 0.000000, 0.915163, 0.000000, -0.579947, 0.000000, 1.000000}, 
{1.116671, 0.000000, 0.322955, 0.000000, 0.949131, 0.000000, -0.525140, 0.000000, 1.000000}, 
{1.140514, 0.000000, 0.297406, 0.000000, 0.985192, 0.000000, -0.471460, 0.000000, 1.000000}, 
{1.166473, 0.000000, 0.271786, 0.000000, 1.024727, 0.000000, -0.420473, 0.000000, 1.000000}, 
{1.192591, 0.000000, 0.245461, 0.000000, 1.065631, 0.000000, -0.371118, 0.000000, 1.000000}, 
{1.223349, 0.000000, 0.219412, 0.000000, 1.109237, 0.000000, -0.322600, 0.000000, 1.000000}, 
{1.254833, 0.000000, 0.192660, 0.000000, 1.153589, 0.000000, -0.277572, 0.000000, 1.000000}, 
{1.285808, 0.000000, 0.165167, 0.000000, 1.194755, 0.000000, -0.234417, 0.000000, 1.000000}, 
{1.322015, 0.000000, 0.137236, 0.000000, 1.233019, 0.000000, -0.194640, 0.000000, 1.000000}, 
{1.342172, 0.000000, 0.106871, 0.000000, 1.264393, 0.000000, -0.155001, 0.000000, 1.000000}, 
{1.357238, 0.000000, 0.075759, 0.000000, 1.296496, 0.000000, -0.114648, 0.000000, 1.000000}, 
{1.367725, 0.000000, 0.044279, 0.000000, 1.326079, 0.000000, -0.073254, 0.000000, 1.000000}, 
{1.379461, 0.000000, 0.013001, 0.000000, 1.358529, 0.000000, -0.031895, 0.000000, 1.000000}, 
{1.391625, 0.000000, -0.018075, 0.000000, 1.391512, 0.000000, 0.009397, 0.000000, 1.000000}, 
{0.000109, 0.000000, 0.001093, 0.000000, 0.001004, 0.000000, -9.992467, 0.000000, 1.000000}, 
{0.000378, 0.000000, 0.003779, 0.000000, 0.001004, 0.000000, -9.992861, 0.000000, 1.000000}, 
{0.002028, 0.000000, 0.020252, 0.000000, 0.002006, 0.000000, -9.988345, 0.000000, 1.000000}, 
{0.004557, 0.000000, 0.045429, 0.000000, 0.004531, 0.000000, -9.983879, 0.000000, 1.000000}, 
{0.008115, 0.000000, 0.080453, 0.000000, 0.008037, 0.000000, -9.953411, 0.000000, 1.000000}, 
{0.012864, 0.000000, 0.125836, 0.000000, 0.012471, 0.000000, -9.943727, 0.000000, 1.000000}, 
{0.018734, 0.000000, 0.179350, 0.000000, 0.017818, 0.000000, -9.908408, 0.000000, 1.000000}, 
{0.026314, 0.000000, 0.243680, 0.000000, 0.024250, 0.000000, -9.821631, 0.000000, 1.000000}, 
{0.035500, 0.000000, 0.313552, 0.000000, 0.031466, 0.000000, -9.782450, 0.000000, 1.000000}, 
{0.047562, 0.000000, 0.394644, 0.000000, 0.040262, 0.000000, -9.845875, 0.000000, 1.000000}, 
{0.062065, 0.000000, 0.476697, 0.000000, 0.049511, 0.000000, -9.755218, 0.000000, 1.000000}, 
{0.079552, 0.000000, 0.557933, 0.000000, 0.059763, 0.000000, -9.615121, 0.000000, 1.000000}, 
{0.099905, 0.000000, 0.632818, 0.000000, 0.071127, 0.000000, -9.408299, 0.000000, 1.000000}, 
{0.123231, 0.000000, 0.699926, 0.000000, 0.083481, 0.000000, -9.120996, 0.000000, 1.000000}, 
{0.149980, 0.000000, 0.760671, 0.000000, 0.096702, 0.000000, -8.764173, 0.000000, 1.000000}, 
{0.179550, 0.000000, 0.812251, 0.000000, 0.110713, 0.000000, -8.341752, 0.000000, 1.000000}, 
{0.211839, 0.000000, 0.855909, 0.000000, 0.125255, 0.000000, -7.876337, 0.000000, 1.000000}, 
{0.246434, 0.000000, 0.892023, 0.000000, 0.140224, 0.000000, -7.386268, 0.000000, 1.000000}, 
{0.282317, 0.000000, 0.919200, 0.000000, 0.155714, 0.000000, -6.886009, 0.000000, 1.000000}, 
{0.319580, 0.000000, 0.940333, 0.000000, 0.171757, 0.000000, -6.400318, 0.000000, 1.000000}, 
{0.360135, 0.000000, 0.962176, 0.000000, 0.187708, 0.000000, -5.937503, 0.000000, 1.000000}, 
{0.397805, 0.000000, 0.969755, 0.000000, 0.204367, 0.000000, -5.489783, 0.000000, 1.000000}, 
{0.437077, 0.000000, 0.976494, 0.000000, 0.221300, 0.000000, -5.072855, 0.000000, 1.000000}, 
{0.474388, 0.000000, 0.975265, 0.000000, 0.238739, 0.000000, -4.684682, 0.000000, 1.000000}, 
{0.513695, 0.000000, 0.975335, 0.000000, 0.256192, 0.000000, -4.326597, 0.000000, 1.000000}, 
{0.551542, 0.000000, 0.970264, 0.000000, 0.274112, 0.000000, -3.999049, 0.000000, 1.000000}, 
{0.587525, 0.000000, 0.960365, 0.000000, 0.292527, 0.000000, -3.696317, 0.000000, 1.000000}, 
{0.621251, 0.000000, 0.945944, 0.000000, 0.311198, 0.000000, -3.414176, 0.000000, 1.000000}, 
{0.654738, 0.000000, 0.930709, 0.000000, 0.330621, 0.000000, -3.160455, 0.000000, 1.000000}, 
{0.685794, 0.000000, 0.911702, 0.000000, 0.349581, 0.000000, -2.921461, 0.000000, 1.000000}, 
{0.717135, 0.000000, 0.892948, 0.000000, 0.369582, 0.000000, -2.707478, 0.000000, 1.000000}, 
{0.740798, 0.000000, 0.865086, 0.000000, 0.391678, 0.000000, -2.510382, 0.000000, 1.000000}, 
{0.770920, 0.000000, 0.845137, 0.000000, 0.411960, 0.000000, -2.329648, 0.000000, 1.000000}, 
{0.792303, 0.000000, 0.815956, 0.000000, 0.434931, 0.000000, -2.163206, 0.000000, 1.000000}, 
{0.818363, 0.000000, 0.792225, 0.000000, 0.456769, 0.000000, -2.008042, 0.000000, 1.000000}, 
{0.837362, 0.000000, 0.762396, 0.000000, 0.481007, 0.000000, -1.867576, 0.000000, 1.000000}, 
{0.862266, 0.000000, 0.738465, 0.000000, 0.503927, 0.000000, -1.735819, 0.000000, 1.000000}, 
{0.880069, 0.000000, 0.708890, 0.000000, 0.528824, 0.000000, -1.614690, 0.000000, 1.000000}, 
{0.896021, 0.000000, 0.678588, 0.000000, 0.555172, 0.000000, -1.503477, 0.000000, 1.000000}, 
{0.920156, 0.000000, 0.654832, 0.000000, 0.578836, 0.000000, -1.395800, 0.000000, 1.000000}, 
{0.934948, 0.000000, 0.624740, 0.000000, 0.606724, 0.000000, -1.299955, 0.000000, 1.000000}, 
{0.949686, 0.000000, 0.595203, 0.000000, 0.635039, 0.000000, -1.208597, 0.000000, 1.000000}, 
{0.970989, 0.000000, 0.570041, 0.000000, 0.661856, 0.000000, -1.122310, 0.000000, 1.000000}, 
{0.985606, 0.000000, 0.541116, 0.000000, 0.691308, 0.000000, -1.042168, 0.000000, 1.000000}, 
{1.000819, 0.000000, 0.512835, 0.000000, 0.721006, 0.000000, -0.966543, 0.000000, 1.000000}, 
{1.012209, 0.000000, 0.483024, 0.000000, 0.752569, 0.000000, -0.895758, 0.000000, 1.000000}, 
{1.035320, 0.000000, 0.459125, 0.000000, 0.782354, 0.000000, -0.825668, 0.000000, 1.000000}, 
{1.052077, 0.000000, 0.432333, 0.000000, 0.814419, 0.000000, -0.760812, 0.000000, 1.000000}, 
{1.070459, 0.000000, 0.406131, 0.000000, 0.849086, 0.000000, -0.699897, 0.000000, 1.000000}, 
{1.088704, 0.000000, 0.379721, 0.000000, 0.882952, 0.000000, -0.640575, 0.000000, 1.000000}, 
{1.103817, 0.000000, 0.352104, 0.000000, 0.916819, 0.000000, -0.583765, 0.000000, 1.000000}, 
{1.131711, 0.000000, 0.328122, 0.000000, 0.954977, 0.000000, -0.528240, 0.000000, 1.000000}, 
{1.156448, 0.000000, 0.302568, 0.000000, 0.994658, 0.000000, -0.473988, 0.000000, 1.000000}, 
{1.181821, 0.000000, 0.276487, 0.000000, 1.036468, 0.000000, -0.422189, 0.000000, 1.000000}, 
{1.211347, 0.000000, 0.250540, 0.000000, 1.082375, 0.000000, -0.372005, 0.000000, 1.000000}, 
{1.243636, 0.000000, 0.224264, 0.000000, 1.128991, 0.000000, -0.324184, 0.000000, 1.000000}, 
{1.283038, 0.000000, 0.198289, 0.000000, 1.176198, 0.000000, -0.278419, 0.000000, 1.000000}, 
{1.316722, 0.000000, 0.170179, 0.000000, 1.216786, 0.000000, -0.235425, 0.000000, 1.000000}, 
{1.342715, 0.000000, 0.140095, 0.000000, 1.253479, 0.000000, -0.195084, 0.000000, 1.000000}, 
{1.363288, 0.000000, 0.108794, 0.000000, 1.287649, 0.000000, -0.155439, 0.000000, 1.000000}, 
{1.380656, 0.000000, 0.076774, 0.000000, 1.320180, 0.000000, -0.114636, 0.000000, 1.000000}, 
{1.394826, 0.000000, 0.044509, 0.000000, 1.354031, 0.000000, -0.072890, 0.000000, 1.000000}, 
{1.408830, 0.000000, 0.011968, 0.000000, 1.387749, 0.000000, -0.031101, 0.000000, 1.000000}, 
{1.422370, 0.000000, -0.020555, 0.000000, 1.422869, 0.000000, 0.011002, 0.000000, 1.000000}, 
{0.000100, 0.000000, 0.001334, 0.000000, 0.001338, 0.000000, -13.342275, 0.000000, 1.000000}, 
{0.000342, 0.000000, 0.004563, 0.000000, 0.001338, 0.000000, -13.342710, 0.000000, 1.000000}, 
{0.002026, 0.000000, 0.027004, 0.000000, 0.002015, 0.000000, -13.331846, 0.000000, 1.000000}, 
{0.004559, 0.000000, 0.060563, 0.000000, 0.004523, 0.000000, -13.314877, 0.000000, 1.000000}, 
{0.008232, 0.000000, 0.108154, 0.000000, 0.007936, 0.000000, -13.222856, 0.000000, 1.000000}, 
{0.013031, 0.000000, 0.167590, 0.000000, 0.012341, 0.000000, -13.153860, 0.000000, 1.000000}, 
{0.019526, 0.000000, 0.242041, 0.000000, 0.017473, 0.000000, -12.986094, 0.000000, 1.000000}, 
{0.026364, 0.000000, 0.309289, 0.000000, 0.025837, 0.000000, -13.247752, 0.000000, 1.000000}, 
{0.037670, 0.000000, 0.409755, 0.000000, 0.028450, 0.000000, -12.368877, 0.000000, 1.000000}, 
{0.051804, 0.000000, 0.512051, 0.000000, 0.039885, 0.000000, -12.981333, 0.000000, 1.000000}, 
{0.068214, 0.000000, 0.601994, 0.000000, 0.049375, 0.000000, -12.704532, 0.000000, 1.000000}, 
{0.088295, 0.000000, 0.686849, 0.000000, 0.059735, 0.000000, -12.316531, 0.000000, 1.000000}, 
{0.111478, 0.000000, 0.758670, 0.000000, 0.071090, 0.000000, -11.793048, 0.000000, 1.000000}, 
{0.138336, 0.000000, 0.821348, 0.000000, 0.083238, 0.000000, -11.157992, 0.000000, 1.000000}, 
{0.168447, 0.000000, 0.873616, 0.000000, 0.095941, 0.000000, -10.447472, 0.000000, 1.000000}, 
{0.201411, 0.000000, 0.916322, 0.000000, 0.109181, 0.000000, -9.696606, 0.000000, 1.000000}, 
{0.237443, 0.000000, 0.953090, 0.000000, 0.122780, 0.000000, -8.949244, 0.000000, 1.000000}, 
{0.274234, 0.000000, 0.977751, 0.000000, 0.136931, 0.000000, -8.225874, 0.000000, 1.000000}, 
{0.314566, 0.000000, 1.003135, 0.000000, 0.151311, 0.000000, -7.547433, 0.000000, 1.000000}, 
{0.353932, 0.000000, 1.016312, 0.000000, 0.166366, 0.000000, -6.910326, 0.000000, 1.000000}, 
{0.393858, 0.000000, 1.024848, 0.000000, 0.181758, 0.000000, -6.324401, 0.000000, 1.000000}, 
{0.433805, 0.000000, 1.028950, 0.000000, 0.197400, 0.000000, -5.790555, 0.000000, 1.000000}, 
{0.475812, 0.000000, 1.034084, 0.000000, 0.213540, 0.000000, -5.312826, 0.000000, 1.000000}, 
{0.513254, 0.000000, 1.026743, 0.000000, 0.229779, 0.000000, -4.866118, 0.000000, 1.000000}, 
{0.549965, 0.000000, 1.016740, 0.000000, 0.246907, 0.000000, -4.468437, 0.000000, 1.000000}, 
{0.590300, 0.000000, 1.012030, 0.000000, 0.263082, 0.000000, -4.105483, 0.000000, 1.000000}, 
{0.626420, 0.000000, 0.998919, 0.000000, 0.280992, 0.000000, -3.780593, 0.000000, 1.000000}, 
{0.658897, 0.000000, 0.979874, 0.000000, 0.299243, 0.000000, -3.482054, 0.000000, 1.000000}, 
{0.687252, 0.000000, 0.955238, 0.000000, 0.318512, 0.000000, -3.211213, 0.000000, 1.000000}, 
{0.718941, 0.000000, 0.935663, 0.000000, 0.337061, 0.000000, -2.962083, 0.000000, 1.000000}, 
{0.749877, 0.000000, 0.915206, 0.000000, 0.356890, 0.000000, -2.741382, 0.000000, 1.000000}, 
{0.772094, 0.000000, 0.884837, 0.000000, 0.378293, 0.000000, -2.536501, 0.000000, 1.000000}, 
{0.799495, 0.000000, 0.861214, 0.000000, 0.398097, 0.000000, -2.347282, 0.000000, 1.000000}, 
{0.820136, 0.000000, 0.830976, 0.000000, 0.421600, 0.000000, -2.179332, 0.000000, 1.000000}, 
{0.846715, 0.000000, 0.807408, 0.000000, 0.441777, 0.000000, -2.018005, 0.000000, 1.000000}, 
{0.865176, 0.000000, 0.776657, 0.000000, 0.466927, 0.000000, -1.877021, 0.000000, 1.000000}, 
{0.881100, 0.000000, 0.744657, 0.000000, 0.490557, 0.000000, -1.743528, 0.000000, 1.000000}, 
{0.907637, 0.000000, 0.722088, 0.000000, 0.515107, 0.000000, -1.621563, 0.000000, 1.000000}, 
{0.922239, 0.000000, 0.690432, 0.000000, 0.540064, 0.000000, -1.506158, 0.000000, 1.000000}, 
{0.936558, 0.000000, 0.659650, 0.000000, 0.567508, 0.000000, -1.403606, 0.000000, 1.000000}, 
{0.950047, 0.000000, 0.629105, 0.000000, 0.595315, 0.000000, -1.304276, 0.000000, 1.000000}, 
{0.961959, 0.000000, 0.598277, 0.000000, 0.624223, 0.000000, -1.213888, 0.000000, 1.000000}, 
{0.987410, 0.000000, 0.576085, 0.000000, 0.651609, 0.000000, -1.125569, 0.000000, 1.000000}, 
{0.999996, 0.000000, 0.546494, 0.000000, 0.682023, 0.000000, -1.045567, 0.000000, 1.000000}, 
{1.014127, 0.000000, 0.518186, 0.000000, 0.712986, 0.000000, -0.970718, 0.000000, 1.000000}, 
{1.036275, 0.000000, 0.494009, 0.000000, 0.745127, 0.000000, -0.897557, 0.000000, 1.000000}, 
{1.049695, 0.000000, 0.465659, 0.000000, 0.778540, 0.000000, -0.830584, 0.000000, 1.000000}, 
{1.064617, 0.000000, 0.438159, 0.000000, 0.811697, 0.000000, -0.766083, 0.000000, 1.000000}, 
{1.077131, 0.000000, 0.409813, 0.000000, 0.846496, 0.000000, -0.705101, 0.000000, 1.000000}, 
{1.101054, 0.000000, 0.385632, 0.000000, 0.882924, 0.000000, -0.644828, 0.000000, 1.000000}, 
{1.122361, 0.000000, 0.360045, 0.000000, 0.921869, 0.000000, -0.587878, 0.000000, 1.000000}, 
{1.147359, 0.000000, 0.335186, 0.000000, 0.962350, 0.000000, -0.532130, 0.000000, 1.000000}, 
{1.169881, 0.000000, 0.309040, 0.000000, 1.003189, 0.000000, -0.478843, 0.000000, 1.000000}, 
{1.200554, 0.000000, 0.284590, 0.000000, 1.051522, 0.000000, -0.426855, 0.000000, 1.000000}, 
{1.232047, 0.000000, 0.259332, 0.000000, 1.100260, 0.000000, -0.376125, 0.000000, 1.000000}, 
{1.275402, 0.000000, 0.235215, 0.000000, 1.151133, 0.000000, -0.326614, 0.000000, 1.000000}, 
{1.306595, 0.000000, 0.207508, 0.000000, 1.196287, 0.000000, -0.281524, 0.000000, 1.000000}, 
{1.334304, 0.000000, 0.178290, 0.000000, 1.238431, 0.000000, -0.238694, 0.000000, 1.000000}, 
{1.364678, 0.000000, 0.148530, 0.000000, 1.277909, 0.000000, -0.198549, 0.000000, 1.000000}, 
{1.387168, 0.000000, 0.117114, 0.000000, 1.314620, 0.000000, -0.158529, 0.000000, 1.000000}, 
{1.408657, 0.000000, 0.084977, 0.000000, 1.350328, 0.000000, -0.118042, 0.000000, 1.000000}, 
{1.426214, 0.000000, 0.052052, 0.000000, 1.386598, 0.000000, -0.076541, 0.000000, 1.000000}, 
{1.444257, 0.000000, 0.018653, 0.000000, 1.424525, 0.000000, -0.034061, 0.000000, 1.000000}, 
{1.460618, 0.000000, -0.015206, 0.000000, 1.461600, 0.000000, 0.008132, 0.000000, 1.000000}, 
{0.000100, 0.000000, 0.002003, 0.000000, 0.002006, 0.000000, -20.032721, 0.000000, 1.000000}, 
{0.000297, 0.000000, 0.005947, 0.000000, 0.002006, 0.000000, -20.033842, 0.000000, 1.000000}, 
{0.002022, 0.000000, 0.040439, 0.000000, 0.002006, 0.000000, -20.032743, 0.000000, 1.000000}, 
{0.004588, 0.000000, 0.090999, 0.000000, 0.004499, 0.000000, -19.910591, 0.000000, 1.000000}, 
{0.008769, 0.000000, 0.169802, 0.000000, 0.007548, 0.000000, -19.572552, 0.000000, 1.000000}, 
{0.013708, 0.000000, 0.253629, 0.000000, 0.011829, 0.000000, -19.145721, 0.000000, 1.000000}, 
{0.020331, 0.000000, 0.349396, 0.000000, 0.017548, 0.000000, -18.591049, 0.000000, 1.000000}, 
{0.030259, 0.000000, 0.468121, 0.000000, 0.022320, 0.000000, -18.331083, 0.000000, 1.000000}, 
{0.045190, 0.000000, 0.611444, 0.000000, 0.024777, 0.000000, -15.807686, 0.000000, 1.000000}, 
{0.058476, 0.000000, 0.676875, 0.000000, 0.036072, 0.000000, -16.947781, 0.000000, 1.000000}, 
{0.079894, 0.000000, 0.781421, 0.000000, 0.049371, 0.000000, -17.512903, 0.000000, 1.000000}, 
{0.103871, 0.000000, 0.855116, 0.000000, 0.059466, 0.000000, -16.290295, 0.000000, 1.000000}, 
{0.131756, 0.000000, 0.915747, 0.000000, 0.070134, 0.000000, -14.956566, 0.000000, 1.000000}, 
{0.163487, 0.000000, 0.966333, 0.000000, 0.081451, 0.000000, -13.608010, 0.000000, 1.000000}, 
{0.198693, 0.000000, 1.008386, 0.000000, 0.092909, 0.000000, -12.299661, 0.000000, 1.000000}, 
{0.236157, 0.000000, 1.039862, 0.000000, 0.105138, 0.000000, -11.088790, 0.000000, 1.000000}, 
{0.274579, 0.000000, 1.059988, 0.000000, 0.117840, 0.000000, -9.983883, 0.000000, 1.000000}, 
{0.317164, 0.000000, 1.084069, 0.000000, 0.130841, 0.000000, -9.008505, 0.000000, 1.000000}, 
{0.357624, 0.000000, 1.092124, 0.000000, 0.144359, 0.000000, -8.127298, 0.000000, 1.000000}, 
{0.399009, 0.000000, 1.097560, 0.000000, 0.158245, 0.000000, -7.347628, 0.000000, 1.000000}, 
{0.441182, 0.000000, 1.100981, 0.000000, 0.172504, 0.000000, -6.658191, 0.000000, 1.000000}, 
{0.481606, 0.000000, 1.097318, 0.000000, 0.187634, 0.000000, -6.047333, 0.000000, 1.000000}, 
{0.524253, 0.000000, 1.096570, 0.000000, 0.202553, 0.000000, -5.505878, 0.000000, 1.000000}, 
{0.564351, 0.000000, 1.088739, 0.000000, 0.217786, 0.000000, -5.018494, 0.000000, 1.000000}, 
{0.600843, 0.000000, 1.073396, 0.000000, 0.233692, 0.000000, -4.580770, 0.000000, 1.000000}, 
{0.635527, 0.000000, 1.055024, 0.000000, 0.250463, 0.000000, -4.194785, 0.000000, 1.000000}, 
{0.672045, 0.000000, 1.039775, 0.000000, 0.267474, 0.000000, -3.847436, 0.000000, 1.000000}, 
{0.698372, 0.000000, 1.009545, 0.000000, 0.285676, 0.000000, -3.532546, 0.000000, 1.000000}, 
{0.729336, 0.000000, 0.987168, 0.000000, 0.303901, 0.000000, -3.248834, 0.000000, 1.000000}, 
{0.761147, 0.000000, 0.966299, 0.000000, 0.322080, 0.000000, -2.994166, 0.000000, 1.000000}, 
{0.782270, 0.000000, 0.932841, 0.000000, 0.342297, 0.000000, -2.762244, 0.000000, 1.000000}, 
{0.811832, 0.000000, 0.910431, 0.000000, 0.361311, 0.000000, -2.549933, 0.000000, 1.000000}, 
{0.832053, 0.000000, 0.878369, 0.000000, 0.383678, 0.000000, -2.363132, 0.000000, 1.000000}, 
{0.849383, 0.000000, 0.844673, 0.000000, 0.405903, 0.000000, -2.189266, 0.000000, 1.000000}, 
{0.866020, 0.000000, 0.811703, 0.000000, 0.429886, 0.000000, -2.031716, 0.000000, 1.000000}, 
{0.893083, 0.000000, 0.789181, 0.000000, 0.451377, 0.000000, -1.884480, 0.000000, 1.000000}, 
{0.909212, 0.000000, 0.757541, 0.000000, 0.475498, 0.000000, -1.750298, 0.000000, 1.000000}, 
{0.923169, 0.000000, 0.725157, 0.000000, 0.501217, 0.000000, -1.627590, 0.000000, 1.000000}, 
{0.937112, 0.000000, 0.693769, 0.000000, 0.528072, 0.000000, -1.514906, 0.000000, 1.000000}, 
{0.961901, 0.000000, 0.670828, 0.000000, 0.553228, 0.000000, -1.406839, 0.000000, 1.000000}, 
{0.975245, 0.000000, 0.640240, 0.000000, 0.580822, 0.000000, -1.307873, 0.000000, 1.000000}, 
{0.989696, 0.000000, 0.611032, 0.000000, 0.610042, 0.000000, -1.216417, 0.000000, 1.000000}, 
{1.002057, 0.000000, 0.581144, 0.000000, 0.640622, 0.000000, -1.132553, 0.000000, 1.000000}, 
{1.014022, 0.000000, 0.551620, 0.000000, 0.671558, 0.000000, -1.051695, 0.000000, 1.000000}, 
{1.025307, 0.000000, 0.522268, 0.000000, 0.705156, 0.000000, -0.977500, 0.000000, 1.000000}, 
{1.052190, 0.000000, 0.500826, 0.000000, 0.736881, 0.000000, -0.904301, 0.000000, 1.000000}, 
{1.064408, 0.000000, 0.472355, 0.000000, 0.771714, 0.000000, -0.837557, 0.000000, 1.000000}, 
{1.077876, 0.000000, 0.444815, 0.000000, 0.807312, 0.000000, -0.773004, 0.000000, 1.000000}, 
{1.088939, 0.000000, 0.416531, 0.000000, 0.845867, 0.000000, -0.713958, 0.000000, 1.000000}, 
{1.118551, 0.000000, 0.395057, 0.000000, 0.884681, 0.000000, -0.652485, 0.000000, 1.000000}, 
{1.134469, 0.000000, 0.368289, 0.000000, 0.923985, 0.000000, -0.596330, 0.000000, 1.000000}, 
{1.162778, 0.000000, 0.345095, 0.000000, 0.969841, 0.000000, -0.539703, 0.000000, 1.000000}, 
{1.185298, 0.000000, 0.319527, 0.000000, 1.014716, 0.000000, -0.486250, 0.000000, 1.000000}, 
{1.208419, 0.000000, 0.293590, 0.000000, 1.060804, 0.000000, -0.434178, 0.000000, 1.000000}, 
{1.261013, 0.000000, 0.273471, 0.000000, 1.119466, 0.000000, -0.382032, 0.000000, 1.000000}, 
{1.297811, 0.000000, 0.248226, 0.000000, 1.173699, 0.000000, -0.334190, 0.000000, 1.000000}, 
{1.326591, 0.000000, 0.220354, 0.000000, 1.219680, 0.000000, -0.289075, 0.000000, 1.000000}, 
{1.357918, 0.000000, 0.191937, 0.000000, 1.264317, 0.000000, -0.246259, 0.000000, 1.000000}, 
{1.387590, 0.000000, 0.162282, 0.000000, 1.307744, 0.000000, -0.205129, 0.000000, 1.000000}, 
{1.415797, 0.000000, 0.131515, 0.000000, 1.347215, 0.000000, -0.165601, 0.000000, 1.000000}, 
{1.440194, 0.000000, 0.099555, 0.000000, 1.386415, 0.000000, -0.125462, 0.000000, 1.000000}, 
{1.465600, 0.000000, 0.066957, 0.000000, 1.427816, 0.000000, -0.084082, 0.000000, 1.000000}, 
{1.487714, 0.000000, 0.033496, 0.000000, 1.468721, 0.000000, -0.041981, 0.000000, 1.000000}, 
{1.509947, 0.000000, -0.000663, 0.000000, 1.511802, 0.000000, 0.000485, 0.000000, 1.000000}, 
{0.000100, 0.000000, 0.004009, 0.000000, 0.004010, 0.000000, -40.087105, 0.000000, 1.000000}, 
{0.000228, 0.000000, 0.009141, 0.000000, 0.004009, 0.000000, -40.074432, 0.000000, 1.000000}, 
{0.001522, 0.000000, 0.060544, 0.000000, 0.003993, 0.000000, -39.918827, 0.000000, 1.000000}, 
{0.004919, 0.000000, 0.188871, 0.000000, 0.004289, 0.000000, -38.873421, 0.000000, 1.000000}, 
{0.009053, 0.000000, 0.320325, 0.000000, 0.008040, 0.000000, -39.715633, 0.000000, 1.000000}, 
{0.015375, 0.000000, 0.471415, 0.000000, 0.012434, 0.000000, -39.162876, 0.000000, 1.000000}, 
{0.029306, 0.000000, 0.735111, 0.000000, 0.011802, 0.000000, -28.083200, 0.000000, 1.000000}, 
{0.043450, 0.000000, 0.859759, 0.000000, 0.015220, 0.000000, -24.599945, 0.000000, 1.000000}, 
{0.079075, 0.000000, 1.220033, 0.000000, 0.013901, 0.000000, -18.507019, 0.000000, 1.000000}, 
{0.090130, 0.000000, 1.091255, 0.000000, 0.020940, 0.000000, -17.961655, 0.000000, 1.000000}, 
{0.098008, 0.000000, 0.945965, 0.000000, 0.054598, 0.000000, -24.478010, 0.000000, 1.000000}, 
{0.138246, 0.000000, 1.084105, 0.000000, 0.052358, 0.000000, -20.003433, 0.000000, 1.000000}, 
{0.174489, 0.000000, 1.133148, 0.000000, 0.070014, 0.000000, -18.550846, 0.000000, 1.000000}, 
{0.207969, 0.000000, 1.138483, 0.000000, 0.075504, 0.000000, -15.923334, 0.000000, 1.000000}, 
{0.249132, 0.000000, 1.168197, 0.000000, 0.086276, 0.000000, -13.940813, 0.000000, 1.000000}, 
{0.291391, 0.000000, 1.187038, 0.000000, 0.097105, 0.000000, -12.263267, 0.000000, 1.000000}, 
{0.332856, 0.000000, 1.192793, 0.000000, 0.108628, 0.000000, -10.822873, 0.000000, 1.000000}, 
{0.377473, 0.000000, 1.202846, 0.000000, 0.120499, 0.000000, -9.618412, 0.000000, 1.000000}, 
{0.422601, 0.000000, 1.208871, 0.000000, 0.132880, 0.000000, -8.591735, 0.000000, 1.000000}, 
{0.465276, 0.000000, 1.204545, 0.000000, 0.145810, 0.000000, -7.692911, 0.000000, 1.000000}, 
{0.504710, 0.000000, 1.190839, 0.000000, 0.159526, 0.000000, -6.915612, 0.000000, 1.000000}, 
{0.544909, 0.000000, 1.178827, 0.000000, 0.173688, 0.000000, -6.242786, 0.000000, 1.000000}, 
{0.582125, 0.000000, 1.160590, 0.000000, 0.188827, 0.000000, -5.651690, 0.000000, 1.000000}, 
{0.620694, 0.000000, 1.145481, 0.000000, 0.203271, 0.000000, -5.123660, 0.000000, 1.000000}, 
{0.659127, 0.000000, 1.130178, 0.000000, 0.218676, 0.000000, -4.669475, 0.000000, 1.000000}, 
{0.684358, 0.000000, 1.093728, 0.000000, 0.235853, 0.000000, -4.258717, 0.000000, 1.000000}, 
{0.719453, 0.000000, 1.074591, 0.000000, 0.252475, 0.000000, -3.901225, 0.000000, 1.000000}, 
{0.751695, 0.000000, 1.051678, 0.000000, 0.269688, 0.000000, -3.576870, 0.000000, 1.000000}, 
{0.775082, 0.000000, 1.017716, 0.000000, 0.288550, 0.000000, -3.287471, 0.000000, 1.000000}, 
{0.796233, 0.000000, 0.982759, 0.000000, 0.307292, 0.000000, -3.023708, 0.000000, 1.000000}, 
{0.827404, 0.000000, 0.961227, 0.000000, 0.325695, 0.000000, -2.787740, 0.000000, 1.000000}, 
{0.848149, 0.000000, 0.928433, 0.000000, 0.345191, 0.000000, -2.570737, 0.000000, 1.000000}, 
{0.864891, 0.000000, 0.892838, 0.000000, 0.367109, 0.000000, -2.379204, 0.000000, 1.000000}, 
{0.880979, 0.000000, 0.858193, 0.000000, 0.389501, 0.000000, -2.204470, 0.000000, 1.000000}, 
{0.910434, 0.000000, 0.837281, 0.000000, 0.410044, 0.000000, -2.041554, 0.000000, 1.000000}, 
{0.925396, 0.000000, 0.803638, 0.000000, 0.433612, 0.000000, -1.893353, 0.000000, 1.000000}, 
{0.942463, 0.000000, 0.772925, 0.000000, 0.457294, 0.000000, -1.757331, 0.000000, 1.000000}, 
{0.955217, 0.000000, 0.739720, 0.000000, 0.482196, 0.000000, -1.633572, 0.000000, 1.000000}, 
{0.968570, 0.000000, 0.708048, 0.000000, 0.509412, 0.000000, -1.520414, 0.000000, 1.000000}, 
{0.981672, 0.000000, 0.677109, 0.000000, 0.535715, 0.000000, -1.412506, 0.000000, 1.000000}, 
{0.992829, 0.000000, 0.645712, 0.000000, 0.565637, 0.000000, -1.317079, 0.000000, 1.000000}, 
{1.021270, 0.000000, 0.625746, 0.000000, 0.594123, 0.000000, -1.222611, 0.000000, 1.000000}, 
{1.031247, 0.000000, 0.594628, 0.000000, 0.624894, 0.000000, -1.137911, 0.000000, 1.000000}, 
{1.043581, 0.000000, 0.565540, 0.000000, 0.657264, 0.000000, -1.058439, 0.000000, 1.000000}, 
{1.055930, 0.000000, 0.536962, 0.000000, 0.691982, 0.000000, -0.984428, 0.000000, 1.000000}, 
{1.066727, 0.000000, 0.508076, 0.000000, 0.725834, 0.000000, -0.912794, 0.000000, 1.000000}, 
{1.081225, 0.000000, 0.481297, 0.000000, 0.762600, 0.000000, -0.845536, 0.000000, 1.000000}, 
{1.088198, 0.000000, 0.451563, 0.000000, 0.800073, 0.000000, -0.782718, 0.000000, 1.000000}, 
{1.123316, 0.000000, 0.433247, 0.000000, 0.842552, 0.000000, -0.721664, 0.000000, 1.000000}, 
{1.133206, 0.000000, 0.404812, 0.000000, 0.883584, 0.000000, -0.662761, 0.000000, 1.000000}, 
{1.152889, 0.000000, 0.379901, 0.000000, 0.927885, 0.000000, -0.606866, 0.000000, 1.000000}, 
{1.188158, 0.000000, 0.359421, 0.000000, 0.979056, 0.000000, -0.550666, 0.000000, 1.000000}, 
{1.217064, 0.000000, 0.336049, 0.000000, 1.029627, 0.000000, -0.496748, 0.000000, 1.000000}, 
{1.257727, 0.000000, 0.314816, 0.000000, 1.088968, 0.000000, -0.443538, 0.000000, 1.000000}, 
{1.286647, 0.000000, 0.289530, 0.000000, 1.142608, 0.000000, -0.394018, 0.000000, 1.000000}, 
{1.308729, 0.000000, 0.262053, 0.000000, 1.192123, 0.000000, -0.346255, 0.000000, 1.000000}, 
{1.351453, 0.000000, 0.237704, 0.000000, 1.248129, 0.000000, -0.300393, 0.000000, 1.000000}, 
{1.380284, 0.000000, 0.209733, 0.000000, 1.296671, 0.000000, -0.256661, 0.000000, 1.000000}, 
{1.414621, 0.000000, 0.181613, 0.000000, 1.343437, 0.000000, -0.215429, 0.000000, 1.000000}, 
{1.453045, 0.000000, 0.152797, 0.000000, 1.391268, 0.000000, -0.177098, 0.000000, 1.000000}, 
{1.481066, 0.000000, 0.121803, 0.000000, 1.435774, 0.000000, -0.137203, 0.000000, 1.000000}, 
{1.514113, 0.000000, 0.090250, 0.000000, 1.482727, 0.000000, -0.096998, 0.000000, 1.000000}, 
{1.547317, 0.000000, 0.057603, 0.000000, 1.531285, 0.000000, -0.055328, 0.000000, 1.000000}, 
{1.577983, 0.000000, 0.023799, 0.000000, 1.579453, 0.000000, -0.013094, 0.000000, 1.000000}, 
{0.000108, 0.000000, 0.124970, 0.000000, 0.124970, 0.000000, -1249.703491, 0.000000, 1.000000}, 
{0.000140, 0.000000, 0.119585, 0.000000, 0.119585, 0.000000, -1195.854370, 0.000000, 1.000000}, 
{0.003995, 0.000000, 0.927433, 0.000000, 0.023245, 0.000000, -232.443573, 0.000000, 1.000000}, 
{0.012013, 0.000000, 1.131580, 0.000000, 0.009822, 0.000000, -98.211105, 0.000000, 1.000000}, 
{0.023892, 0.000000, 1.216018, 0.000000, 0.006722, 0.000000, -67.214500, 0.000000, 1.000000}, 
{0.047506, 0.000000, 1.517865, 0.000000, 0.004242, 0.000000, -42.410069, 0.000000, 1.000000}, 
{0.082523, 0.000000, 1.812564, 0.000000, 0.002444, 0.000000, -24.421545, 0.000000, 1.000000}, 
{0.112452, 0.000000, 1.805072, 0.000000, 0.003007, 0.000000, -18.450365, 0.000000, 1.000000}, 
{0.164460, 0.000000, 2.016784, 0.000000, 0.003523, 0.000000, -14.043465, 0.000000, 1.000000}, 
{0.195870, 0.000000, 1.898199, 0.000000, 0.005938, 0.000000, -13.178202, 0.000000, 1.000000}, 
{0.197797, 0.000000, 1.556158, 0.000000, 0.036536, 0.000000, -30.760096, 0.000000, 1.000000}, 
{0.219540, 0.000000, 1.433455, 0.000000, 0.045004, 0.000000, -25.037956, 0.000000, 1.000000}, 
{0.268696, 0.000000, 1.483235, 0.000000, 0.054131, 0.000000, -20.975695, 0.000000, 1.000000}, 
{0.265968, 0.000000, 1.261051, 0.000000, 0.039888, 0.000000, -12.017023, 0.000000, 1.000000}, 
{0.325369, 0.000000, 1.343349, 0.000000, 0.054509, 0.000000, -12.612406, 0.000000, 1.000000}, 
{0.387968, 0.000000, 1.411606, 0.000000, 0.082403, 0.000000, -13.296940, 0.000000, 1.000000}, 
{0.435543, 0.000000, 1.411236, 0.000000, 0.092952, 0.000000, -11.646996, 0.000000, 1.000000}, 
{0.482729, 0.000000, 1.405722, 0.000000, 0.103975, 0.000000, -10.265131, 0.000000, 1.000000}, 
{0.531742, 0.000000, 1.402782, 0.000000, 0.115888, 0.000000, -9.114828, 0.000000, 1.000000}, 
{0.559383, 0.000000, 1.346165, 0.000000, 0.129235, 0.000000, -8.089214, 0.000000, 1.000000}, 
{0.607851, 0.000000, 1.342407, 0.000000, 0.141521, 0.000000, -7.249064, 0.000000, 1.000000}, 
{0.656928, 0.000000, 1.338238, 0.000000, 0.154489, 0.000000, -6.531094, 0.000000, 1.000000}, 
{0.681212, 0.000000, 1.285692, 0.000000, 0.168829, 0.000000, -5.868711, 0.000000, 1.000000}, 
{0.729238, 0.000000, 1.279951, 0.000000, 0.182868, 0.000000, -5.324553, 0.000000, 1.000000}, 
{0.751172, 0.000000, 1.230045, 0.000000, 0.197926, 0.000000, -4.816513, 0.000000, 1.000000}, 
{0.773107, 0.000000, 1.184288, 0.000000, 0.213406, 0.000000, -4.377203, 0.000000, 1.000000}, 
{0.815726, 0.000000, 1.171653, 0.000000, 0.228634, 0.000000, -3.999965, 0.000000, 1.000000}, 
{0.837886, 0.000000, 1.130636, 0.000000, 0.245586, 0.000000, -3.658493, 0.000000, 1.000000}, 
{0.857674, 0.000000, 1.089071, 0.000000, 0.262794, 0.000000, -3.347930, 0.000000, 1.000000}, 
{0.876120, 0.000000, 1.048303, 0.000000, 0.281151, 0.000000, -3.072666, 0.000000, 1.000000}, 
{0.893935, 0.000000, 1.009040, 0.000000, 0.299658, 0.000000, -2.825165, 0.000000, 1.000000}, 
{0.927998, 0.000000, 0.989064, 0.000000, 0.317463, 0.000000, -2.605520, 0.000000, 1.000000}, 
{0.928445, 0.000000, 0.935017, 0.000000, 0.338904, 0.000000, -2.401481, 0.000000, 1.000000}, 
{0.945279, 0.000000, 0.899993, 0.000000, 0.360164, 0.000000, -2.222282, 0.000000, 1.000000}, 
{0.959378, 0.000000, 0.863854, 0.000000, 0.382702, 0.000000, -2.059342, 0.000000, 1.000000}, 
{0.971761, 0.000000, 0.827684, 0.000000, 0.406081, 0.000000, -1.909314, 0.000000, 1.000000}, 
{0.987812, 0.000000, 0.795878, 0.000000, 0.429344, 0.000000, -1.771094, 0.000000, 1.000000}, 
{1.001958, 0.000000, 0.763540, 0.000000, 0.455172, 0.000000, -1.645968, 0.000000, 1.000000}, 
{1.014357, 0.000000, 0.730897, 0.000000, 0.480344, 0.000000, -1.527438, 0.000000, 1.000000}, 
{1.025946, 0.000000, 0.698675, 0.000000, 0.508149, 0.000000, -1.421337, 0.000000, 1.000000}, 
{1.036435, 0.000000, 0.666662, 0.000000, 0.537799, 0.000000, -1.323677, 0.000000, 1.000000}, 
{1.046807, 0.000000, 0.635466, 0.000000, 0.568603, 0.000000, -1.232678, 0.000000, 1.000000}, 
{1.052974, 0.000000, 0.602660, 0.000000, 0.601126, 0.000000, -1.147675, 0.000000, 1.000000}, 
{1.086089, 0.000000, 0.585364, 0.000000, 0.635066, 0.000000, -1.068352, 0.000000, 1.000000}, 
{1.094660, 0.000000, 0.554784, 0.000000, 0.670529, 0.000000, -0.993445, 0.000000, 1.000000}, 
{1.117131, 0.000000, 0.531500, 0.000000, 0.708185, 0.000000, -0.923758, 0.000000, 1.000000}, 
{1.114009, 0.000000, 0.496581, 0.000000, 0.746276, 0.000000, -0.858381, 0.000000, 1.000000}, 
{1.137328, 0.000000, 0.473914, 0.000000, 0.789410, 0.000000, -0.794980, 0.000000, 1.000000}, 
{1.158671, 0.000000, 0.450127, 0.000000, 0.833926, 0.000000, -0.735697, 0.000000, 1.000000}, 
{1.177878, 0.000000, 0.425306, 0.000000, 0.881842, 0.000000, -0.677498, 0.000000, 1.000000}, 
{1.207510, 0.000000, 0.403797, 0.000000, 0.935549, 0.000000, -0.621762, 0.000000, 1.000000}, 
{1.244496, 0.000000, 0.383812, 0.000000, 0.996595, 0.000000, -0.566190, 0.000000, 1.000000}, 
{1.240412, 0.000000, 0.351080, 0.000000, 1.039591, 0.000000, -0.514288, 0.000000, 1.000000}, 
{1.321257, 0.000000, 0.341200, 0.000000, 1.129773, 0.000000, -0.464621, 0.000000, 1.000000}, 
{1.336512, 0.000000, 0.312710, 0.000000, 1.180308, 0.000000, -0.413228, 0.000000, 1.000000}, 
{1.365047, 0.000000, 0.286935, 0.000000, 1.238898, 0.000000, -0.366092, 0.000000, 1.000000}, 
{1.418984, 0.000000, 0.265184, 0.000000, 1.305635, 0.000000, -0.321528, 0.000000, 1.000000}, 
{1.388864, 0.000000, 0.227750, 0.000000, 1.331061, 0.000000, -0.271827, 0.000000, 1.000000}, 
{1.464383, 0.000000, 0.207168, 0.000000, 1.404122, 0.000000, -0.232838, 0.000000, 1.000000}, 
{1.473125, 0.000000, 0.175770, 0.000000, 1.446581, 0.000000, -0.193289, 0.000000, 1.000000}, 
{1.542908, 0.000000, 0.150424, 0.000000, 1.510808, 0.000000, -0.156153, 0.000000, 1.000000}, 
{1.563005, 0.000000, 0.118748, 0.000000, 1.556367, 0.000000, -0.114866, 0.000000, 1.000000}, 
{1.637048, 0.000000, 0.089604, 0.000000, 1.622043, 0.000000, -0.076804, 0.000000, 1.000000}, 
{1.670777, 0.000000, 0.056398, 0.000000, 1.673946, 0.000000, -0.032691, 0.000000, 1.000000}
].

%% tabMinv() -> %% [size*size] = {
%% [{5000.000000, -0.000000, 0.000000, -0.000000, 5000.000000, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1984.499390, -0.000000, 0.000000, -0.000000, 1984.499390, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {496.124725, -0.000000, 0.000000, -0.000000, 496.124725, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {220.499557, -0.000000, 0.000000, -0.000000, 220.499557, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {124.030708, -0.000000, 0.000000, -0.000000, 124.030708, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {79.378990, -0.000000, 0.000000, -0.000000, 79.378990, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {55.123711, -0.000000, 0.000000, -0.000000, 55.123711, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {40.498146, -0.000000, 0.000000, -0.000000, 40.498146, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {31.005413, -0.000000, 0.000000, -0.000000, 31.005413, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {24.496908, -0.000000, 0.000000, -0.000000, 24.496908, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {19.841249, -0.000000, 0.000000, -0.000000, 19.841249, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {16.396278, -0.000000, 0.000000, -0.000000, 16.396278, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {13.775832, -0.000000, 0.000000, -0.000000, 13.775832, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {11.736287, -0.000000, 0.000000, -0.000000, 11.736287, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {10.117739, -0.000000, 0.000000, -0.000000, 10.117739, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {8.811910, -0.000000, 0.000000, -0.000000, 8.811910, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {7.743124, -0.000000, 0.000000, -0.000000, 7.743124, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {6.857408, -0.000000, 0.000000, -0.000000, 6.857408, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {6.116259, -0.000000, 0.000000, -0.000000, 6.116259, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {5.495361, -0.000000, 0.000000, -0.000000, 5.495361, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {5.012584, -0.000000, 0.000000, -0.000000, 5.012584, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {4.544807, -0.000000, 0.000000, -0.000000, 4.544807, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {4.139287, -0.000000, 0.000000, -0.000000, 4.139287, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {3.786151, -0.000000, 0.000000, -0.000000, 3.786151, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {3.478002, -0.000000, 0.000000, -0.000000, 3.478002, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {3.210497, -0.000000, 0.000000, -0.000000, 3.210497, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.983947, -0.000000, 0.000000, -0.000000, 2.983947, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.779239, -0.000000, 0.000000, -0.000000, 2.779239, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.587681, -0.000000, 0.000000, -0.000000, 2.587681, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.420365, -0.000000, 0.000000, -0.000000, 2.420365, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.277170, -0.000000, 0.000000, -0.000000, 2.277170, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.141149, -0.000000, 0.000000, -0.000000, 2.141149, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {2.019508, -0.000000, 0.000000, -0.000000, 2.019508, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.914519, -0.000000, 0.000000, -0.000000, 1.914519, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.813295, -0.000000, 0.000000, -0.000000, 1.813295, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.725266, -0.000000, 0.000000, -0.000000, 1.725266, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.644049, -0.000000, 0.000000, -0.000000, 1.644049, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.571055, -0.000000, 0.000000, -0.000000, 1.571055, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.504133, -0.000000, 0.000000, -0.000000, 1.504133, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.443942, -0.000000, 0.000000, -0.000000, 1.443942, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.388166, -0.000000, 0.000000, -0.000000, 1.388166, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.338261, -0.000000, 0.000000, -0.000000, 1.338261, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.292063, -0.000000, 0.000000, -0.000000, 1.292063, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.250189, -0.000000, 0.000000, -0.000000, 1.250189, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.212284, -0.000000, 0.000000, -0.000000, 1.212284, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.177361, -0.000000, 0.000000, -0.000000, 1.177361, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.145454, -0.000000, 0.000000, -0.000000, 1.145454, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.116483, -0.000000, 0.000000, -0.000000, 1.116483, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.090282, -0.000000, 0.000000, -0.000000, 1.090282, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.066123, -0.000000, 0.000000, -0.000000, 1.066123, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.043981, -0.000000, 0.000000, -0.000000, 1.043981, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.023818, -0.000000, 0.000000, -0.000000, 1.023818, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {1.005598, -0.000000, 0.000000, -0.000000, 1.005598, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.988918, -0.000000, 0.000000, -0.000000, 0.988918, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.973880, -0.000000, 0.000000, -0.000000, 0.973880, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.959951, -0.000000, 0.000000, -0.000000, 0.959951, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.947277, -0.000000, 0.000000, -0.000000, 0.947277, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.935767, -0.000000, 0.000000, -0.000000, 0.935767, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.925372, -0.000000, 0.000000, -0.000000, 0.925372, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.916056, -0.000000, 0.000000, -0.000000, 0.916056, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.907575, -0.000000, 0.000000, -0.000000, 0.907575, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.899853, -0.000000, 0.000000, -0.000000, 0.899853, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.892837, -0.000000, 0.000000, -0.000000, 0.892837, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {0.886590, -0.000000, 0.000000, -0.000000, 0.886590, -0.000000, 0.000000, -0.000000, 1.000000}, 
%% {4998.183105, -0.000000, -0.024923, -0.000000, 4999.392578, -0.000000, 124.645836, -0.000000, 0.999379}, 
%% {1983.253540, -0.000000, -0.024923, -0.000000, 1984.525879, -0.000000, 49.458832, -0.000000, 0.999379}, 
%% {495.820587, -0.000000, -0.024923, -0.000000, 496.122742, -0.000000, 12.364960, -0.000000, 0.999379}, 
%% {220.361694, -0.000000, -0.024923, -0.000000, 220.500549, -0.000000, 5.495466, -0.000000, 0.999379}, 
%% {123.948830, -0.000000, -0.024923, -0.000000, 124.031944, -0.000000, 3.091082, -0.000000, 0.999379}, 
%% {79.338364, -0.000000, -0.024923, -0.000000, 79.379791, -0.000000, 1.978437, -0.000000, 0.999379}, 
%% {55.091259, -0.000000, -0.024923, -0.000000, 55.120781, -0.000000, 1.373906, -0.000000, 0.999378}, 
%% {40.472393, -0.000000, -0.024923, -0.000000, 40.494312, -0.000000, 1.009283, -0.000000, 0.999379}, 
%% {30.985365, -0.000000, -0.024923, -0.000000, 31.006470, -0.000000, 0.772700, -0.000000, 0.999378}, 
%% {24.485510, -0.000000, -0.024923, -0.000000, 24.498455, -0.000000, 0.610667, -0.000000, 0.999378}, 
%% {19.829260, -0.000000, -0.024923, -0.000000, 19.841013, -0.000000, 0.494476, -0.000000, 0.999379}, 
%% {16.386280, -0.000000, -0.024923, -0.000000, 16.397028, -0.000000, 0.408627, -0.000000, 0.999378}, 
%% {13.767199, -0.000000, -0.024923, -0.000000, 13.775612, -0.000000, 0.343320, -0.000000, 0.999378}, 
%% {11.729187, -0.000000, -0.024922, -0.000000, 11.736534, -0.000000, 0.292509, -0.000000, 0.999379}, 
%% {10.111599, -0.000000, -0.024921, -0.000000, 10.117929, -0.000000, 0.252152, -0.000000, 0.999379}, 
%% {8.806378, -0.000000, -0.024920, -0.000000, 8.812012, -0.000000, 0.219621, -0.000000, 0.999379}, 
%% {7.738563, -0.000000, -0.024915, -0.000000, 7.742913, -0.000000, 0.192986, -0.000000, 0.999379}, 
%% {6.853065, -0.000000, -0.024900, -0.000000, 6.857408, -0.000000, 0.170905, -0.000000, 0.999379}, 
%% {6.112543, -0.000000, -0.024832, -0.000000, 6.116358, -0.000000, 0.152436, -0.000000, 0.999381}, 
%% {5.492513, -0.000000, -0.024301, -0.000000, 5.495852, -0.000000, 0.136894, -0.000000, 0.999394}, 
%% {5.002376, -0.000000, -0.022977, -0.000000, 5.005496, -0.000000, 0.124507, -0.000000, 0.999428}, 
%% {4.542031, -0.000000, -0.024891, -0.000000, 4.544730, -0.000000, 0.113255, -0.000000, 0.999379}, 
%% {4.136748, -0.000000, -0.024860, -0.000000, 4.139301, -0.000000, 0.103142, -0.000000, 0.999380}, 
%% {3.783892, -0.000000, -0.024786, -0.000000, 3.786187, -0.000000, 0.094320, -0.000000, 0.999382}, 
%% {3.475959, -0.000000, -0.024583, -0.000000, 3.478035, -0.000000, 0.086584, -0.000000, 0.999388}, 
%% {3.208820, -0.000000, -0.023975, -0.000000, 3.210796, -0.000000, 0.079811, -0.000000, 0.999404}, 
%% {2.982686, -0.000000, -0.022343, -0.000000, 2.984446, -0.000000, 0.073837, -0.000000, 0.999447}, 
%% {2.777591, -0.000000, -0.024472, -0.000000, 2.779263, -0.000000, 0.069099, -0.000000, 0.999391}, 
%% {2.586194, -0.000000, -0.024005, -0.000000, 2.587850, -0.000000, 0.064199, -0.000000, 0.999404}, 
%% {2.419163, -0.000000, -0.023065, -0.000000, 2.420611, -0.000000, 0.059773, -0.000000, 0.999430}, 
%% {2.275380, -0.000000, -0.022072, -0.000000, 2.276511, -0.000000, 0.055913, -0.000000, 0.999458}, 
%% {2.140113, -0.000000, -0.023281, -0.000000, 2.141114, -0.000000, 0.052757, -0.000000, 0.999426}, 
%% {2.018546, -0.000000, -0.022120, -0.000000, 2.019636, -0.000000, 0.049364, -0.000000, 0.999459}, 
%% {1.912298, -0.000000, -0.021773, -0.000000, 1.913289, -0.000000, 0.046503, -0.000000, 0.999471}, 
%% {1.812560, -0.000000, -0.021790, -0.000000, 1.813526, -0.000000, 0.043893, -0.000000, 0.999472}, 
%% {1.724461, -0.000000, -0.020357, -0.000000, 1.725312, -0.000000, 0.041158, -0.000000, 0.999514}, 
%% {1.643413, -0.000000, -0.020991, -0.000000, 1.644193, -0.000000, 0.039169, -0.000000, 0.999500}, 
%% {1.570400, -0.000000, -0.019437, -0.000000, 1.571167, -0.000000, 0.036632, -0.000000, 0.999547}, 
%% {1.503462, -0.000000, -0.019804, -0.000000, 1.504327, -0.000000, 0.034887, -0.000000, 0.999540}, 
%% {1.443072, -0.000000, -0.018539, -0.000000, 1.443802, -0.000000, 0.032770, -0.000000, 0.999579}, 
%% {1.387667, -0.000000, -0.018235, -0.000000, 1.388255, -0.000000, 0.031013, -0.000000, 0.999593}, 
%% {1.337503, -0.000000, -0.017691, -0.000000, 1.338102, -0.000000, 0.029253, -0.000000, 0.999613}, 
%% {1.291572, -0.000000, -0.016453, -0.000000, 1.292190, -0.000000, 0.027344, -0.000000, 0.999652}, 
%% {1.249833, -0.000000, -0.016246, -0.000000, 1.250329, -0.000000, 0.025755, -0.000000, 0.999665}, 
%% {1.211581, -0.000000, -0.015420, -0.000000, 1.212096, -0.000000, 0.024239, -0.000000, 0.999692}, 
%% {1.176732, -0.000000, -0.014320, -0.000000, 1.177284, -0.000000, 0.022462, -0.000000, 0.999727}, 
%% {1.145131, -0.000000, -0.013575, -0.000000, 1.145601, -0.000000, 0.020946, -0.000000, 0.999752}, 
%% {1.116093, -0.000000, -0.013070, -0.000000, 1.116569, -0.000000, 0.019570, -0.000000, 0.999771}, 
%% {1.089679, -0.000000, -0.012104, -0.000000, 1.090084, -0.000000, 0.018026, -0.000000, 0.999800}, 
%% {1.065614, -0.000000, -0.011124, -0.000000, 1.065957, -0.000000, 0.016529, -0.000000, 0.999827}, 
%% {1.043652, -0.000000, -0.010235, -0.000000, 1.043989, -0.000000, 0.015123, -0.000000, 0.999852}, 
%% {1.023580, -0.000000, -0.009486, -0.000000, 1.023929, -0.000000, 0.013786, -0.000000, 0.999872}, 
%% {1.005289, -0.000000, -0.008707, -0.000000, 1.005609, -0.000000, 0.012442, -0.000000, 0.999892}, 
%% {0.988609, -0.000000, -0.007833, -0.000000, 0.988895, -0.000000, 0.011060, -0.000000, 0.999912}, 
%% {0.973481, -0.000000, -0.006943, -0.000000, 0.973692, -0.000000, 0.009811, -0.000000, 0.999930}, 
%% {0.959706, -0.000000, -0.006077, -0.000000, 0.959799, -0.000000, 0.008565, -0.000000, 0.999946}, 
%% {0.947140, -0.000000, -0.005260, -0.000000, 0.947287, -0.000000, 0.007359, -0.000000, 0.999959}, 
%% {0.935781, -0.000000, -0.004502, -0.000000, 0.935859, -0.000000, 0.006186, -0.000000, 0.999970}, 
%% {0.925383, -0.000000, -0.003655, -0.000000, 0.925427, -0.000000, 0.005076, -0.000000, 0.999980}, 
%% {0.915920, -0.000000, -0.002908, -0.000000, 0.916019, -0.000000, 0.003986, -0.000000, 0.999987}, 
%% {0.907437, -0.000000, -0.002144, -0.000000, 0.907463, -0.000000, 0.002886, -0.000000, 0.999993}, 
%% {0.899745, -0.000000, -0.001397, -0.000000, 0.899731, -0.000000, 0.001881, -0.000000, 0.999997}, 
%% {0.892851, -0.000000, -0.000702, -0.000000, 0.892804, -0.000000, 0.000885, -0.000000, 0.999999}, 
%% {0.886590, -0.000000, 0.000004, -0.000000, 0.886590, -0.000000, -0.000003, -0.000000, 1.000000}, 
%% {4987.830566, -0.000000, -0.049783, -0.000000, 5002.874512, -0.000000, 248.927643, -0.000000, 0.997515}, 
%% {1979.508179, -0.000000, -0.049784, -0.000000, 1984.485596, -0.000000, 98.792633, -0.000000, 0.997515}, 
%% {494.898041, -0.000000, -0.049784, -0.000000, 496.100372, -0.000000, 24.699249, -0.000000, 0.997515}, 
%% {219.953125, -0.000000, -0.049784, -0.000000, 220.505905, -0.000000, 10.977383, -0.000000, 0.997515}, 
%% {123.729889, -0.000000, -0.049784, -0.000000, 124.028008, -0.000000, 6.175080, -0.000000, 0.997515}, 
%% {79.183212, -0.000000, -0.049784, -0.000000, 79.371017, -0.000000, 3.951848, -0.000000, 0.997515}, 
%% {54.988667, -0.000000, -0.049784, -0.000000, 55.120674, -0.000000, 2.744374, -0.000000, 0.997515}, 
%% {40.399559, -0.000000, -0.049784, -0.000000, 40.501385, -0.000000, 2.016239, -0.000000, 0.997515}, 
%% {30.929445, -0.000000, -0.049784, -0.000000, 31.003857, -0.000000, 1.543621, -0.000000, 0.997516}, 
%% {24.436445, -0.000000, -0.049783, -0.000000, 24.494921, -0.000000, 1.219563, -0.000000, 0.997515}, 
%% {19.792650, -0.000000, -0.049783, -0.000000, 19.840876, -0.000000, 0.987788, -0.000000, 0.997515}, 
%% {16.355715, -0.000000, -0.049783, -0.000000, 16.396141, -0.000000, 0.816288, -0.000000, 0.997515}, 
%% {13.741424, -0.000000, -0.049782, -0.000000, 13.776303, -0.000000, 0.685787, -0.000000, 0.997515}, 
%% {11.707375, -0.000000, -0.049782, -0.000000, 11.736228, -0.000000, 0.584280, -0.000000, 0.997516}, 
%% {10.092999, -0.000000, -0.049780, -0.000000, 10.117817, -0.000000, 0.503720, -0.000000, 0.997516}, 
%% {8.790157, -0.000000, -0.049776, -0.000000, 8.811959, -0.000000, 0.438688, -0.000000, 0.997516}, 
%% {7.723980, -0.000000, -0.049766, -0.000000, 7.742883, -0.000000, 0.385478, -0.000000, 0.997516}, 
%% {6.840531, -0.000000, -0.049735, -0.000000, 6.857574, -0.000000, 0.341381, -0.000000, 0.997518}, 
%% {6.101399, -0.000000, -0.049590, -0.000000, 6.116518, -0.000000, 0.304476, -0.000000, 0.997525}, 
%% {5.483913, -0.000000, -0.048401, -0.000000, 5.497400, -0.000000, 0.273532, -0.000000, 0.997586}, 
%% {4.986834, -0.000000, -0.046303, -0.000000, 4.999027, -0.000000, 0.248465, -0.000000, 0.997693}, 
%% {4.533666, -0.000000, -0.049717, -0.000000, 4.544771, -0.000000, 0.226218, -0.000000, 0.997519}, 
%% {4.129148, -0.000000, -0.049653, -0.000000, 4.139321, -0.000000, 0.206016, -0.000000, 0.997523}, 
%% {3.777114, -0.000000, -0.049501, -0.000000, 3.786160, -0.000000, 0.188407, -0.000000, 0.997531}, 
%% {3.469837, -0.000000, -0.049081, -0.000000, 3.478127, -0.000000, 0.172989, -0.000000, 0.997553}, 
%% {3.203677, -0.000000, -0.047816, -0.000000, 3.211405, -0.000000, 0.159444, -0.000000, 0.997620}, 
%% {2.977501, -0.000000, -0.045376, -0.000000, 2.984537, -0.000000, 0.147659, -0.000000, 0.997750}, 
%% {2.772475, -0.000000, -0.048681, -0.000000, 2.779171, -0.000000, 0.138007, -0.000000, 0.997577}, 
%% {2.582066, -0.000000, -0.047907, -0.000000, 2.588146, -0.000000, 0.128264, -0.000000, 0.997620}, 
%% {2.415702, -0.000000, -0.046003, -0.000000, 2.421248, -0.000000, 0.119443, -0.000000, 0.997725}, 
%% {2.270176, -0.000000, -0.044983, -0.000000, 2.275359, -0.000000, 0.111812, -0.000000, 0.997784}, 
%% {2.136706, -0.000000, -0.046455, -0.000000, 2.141633, -0.000000, 0.105397, -0.000000, 0.997708}, 
%% {2.015845, -0.000000, -0.044121, -0.000000, 2.020245, -0.000000, 0.098619, -0.000000, 0.997842}, 
%% {1.908272, -0.000000, -0.043593, -0.000000, 1.912294, -0.000000, 0.092890, -0.000000, 0.997878}, 
%% {1.810172, -0.000000, -0.043469, -0.000000, 1.813973, -0.000000, 0.087754, -0.000000, 0.997893}, 
%% {1.721382, -0.000000, -0.041581, -0.000000, 1.724930, -0.000000, 0.082461, -0.000000, 0.998008}, 
%% {1.641064, -0.000000, -0.041546, -0.000000, 1.644473, -0.000000, 0.078105, -0.000000, 0.998023}, 
%% {1.567769, -0.000000, -0.039697, -0.000000, 1.570865, -0.000000, 0.073491, -0.000000, 0.998139}, 
%% {1.501383, -0.000000, -0.039064, -0.000000, 1.504375, -0.000000, 0.069595, -0.000000, 0.998189}, 
%% {1.440793, -0.000000, -0.037519, -0.000000, 1.443453, -0.000000, 0.065562, -0.000000, 0.998293}, 
%% {1.386024, -0.000000, -0.036386, -0.000000, 1.388582, -0.000000, 0.061893, -0.000000, 0.998375}, 
%% {1.335469, -0.000000, -0.034935, -0.000000, 1.338048, -0.000000, 0.058319, -0.000000, 0.998474}, 
%% {1.289722, -0.000000, -0.033644, -0.000000, 1.292102, -0.000000, 0.054833, -0.000000, 0.998570}, 
%% {1.248072, -0.000000, -0.032017, -0.000000, 1.250311, -0.000000, 0.051434, -0.000000, 0.998681}, 
%% {1.209882, -0.000000, -0.030453, -0.000000, 1.212044, -0.000000, 0.048182, -0.000000, 0.998787}, 
%% {1.175136, -0.000000, -0.029129, -0.000000, 1.177259, -0.000000, 0.045135, -0.000000, 0.998881}, 
%% {1.143543, -0.000000, -0.027436, -0.000000, 1.145473, -0.000000, 0.042045, -0.000000, 0.998991}, 
%% {1.114647, -0.000000, -0.025620, -0.000000, 1.116504, -0.000000, 0.038901, -0.000000, 0.999106}, 
%% {1.088390, -0.000000, -0.023950, -0.000000, 1.090075, -0.000000, 0.035928, -0.000000, 0.999209}, 
%% {1.064299, -0.000000, -0.022468, -0.000000, 1.065900, -0.000000, 0.033145, -0.000000, 0.999300}, 
%% {1.042486, -0.000000, -0.020738, -0.000000, 1.043885, -0.000000, 0.030294, -0.000000, 0.999397}, 
%% {1.022541, -0.000000, -0.018964, -0.000000, 1.023762, -0.000000, 0.027494, -0.000000, 0.999490}, 
%% {1.004352, -0.000000, -0.017227, -0.000000, 1.005452, -0.000000, 0.024821, -0.000000, 0.999574}, 
%% {0.987774, -0.000000, -0.015558, -0.000000, 0.988860, -0.000000, 0.022221, -0.000000, 0.999650}, 
%% {0.972855, -0.000000, -0.013901, -0.000000, 0.973683, -0.000000, 0.019606, -0.000000, 0.999720}, 
%% {0.959127, -0.000000, -0.012169, -0.000000, 0.959821, -0.000000, 0.017110, -0.000000, 0.999783}, 
%% {0.946670, -0.000000, -0.010525, -0.000000, 0.947212, -0.000000, 0.014701, -0.000000, 0.999837}, 
%% {0.935371, -0.000000, -0.008924, -0.000000, 0.935752, -0.000000, 0.012384, -0.000000, 0.999882}, 
%% {0.925109, -0.000000, -0.007367, -0.000000, 0.925348, -0.000000, 0.010121, -0.000000, 0.999919}, 
%% {0.915751, -0.000000, -0.005876, -0.000000, 0.915983, -0.000000, 0.007982, -0.000000, 0.999949}, 
%% {0.907330, -0.000000, -0.004328, -0.000000, 0.907489, -0.000000, 0.005838, -0.000000, 0.999972}, 
%% {0.899617, -0.000000, -0.002749, -0.000000, 0.899750, -0.000000, 0.003751, -0.000000, 0.999988}, 
%% {0.892788, -0.000000, -0.001302, -0.000000, 0.892833, -0.000000, 0.001815, -0.000000, 0.999997}, 
%% {0.886540, -0.000000, 0.000019, -0.000000, 0.886528, -0.000000, -0.000024, -0.000000, 1.000000}, 
%% {4969.166504, -0.000000, -0.074521, -0.000000, 5000.371582, -0.000000, 372.388733, -0.000000, 0.994415}, 
%% {1973.349731, -0.000000, -0.074520, -0.000000, 1984.442505, -0.000000, 147.880890, -0.000000, 0.994416}, 
%% {493.347748, -0.000000, -0.074521, -0.000000, 496.108734, -0.000000, 36.971088, -0.000000, 0.994416}, 
%% {219.263229, -0.000000, -0.074521, -0.000000, 220.492081, -0.000000, 16.431452, -0.000000, 0.994416}, 
%% {123.339607, -0.000000, -0.074521, -0.000000, 124.034065, -0.000000, 9.242965, -0.000000, 0.994416}, 
%% {78.943314, -0.000000, -0.074521, -0.000000, 79.381920, -0.000000, 5.915988, -0.000000, 0.994416}, 
%% {54.817154, -0.000000, -0.074521, -0.000000, 55.122005, -0.000000, 4.107949, -0.000000, 0.994415}, 
%% {40.267220, -0.000000, -0.074520, -0.000000, 40.488701, -0.000000, 3.017642, -0.000000, 0.994415}, 
%% {30.831905, -0.000000, -0.074520, -0.000000, 31.004900, -0.000000, 2.310518, -0.000000, 0.994416}, 
%% {24.359747, -0.000000, -0.074520, -0.000000, 24.495907, -0.000000, 1.825515, -0.000000, 0.994416}, 
%% {19.730806, -0.000000, -0.074520, -0.000000, 19.841276, -0.000000, 1.478626, -0.000000, 0.994416}, 
%% {16.304762, -0.000000, -0.074519, -0.000000, 16.396162, -0.000000, 1.221864, -0.000000, 0.994416}, 
%% {13.698977, -0.000000, -0.074517, -0.000000, 13.775761, -0.000000, 1.026595, -0.000000, 0.994416}, 
%% {11.671096, -0.000000, -0.074515, -0.000000, 11.736732, -0.000000, 0.874619, -0.000000, 0.994416}, 
%% {10.061599, -0.000000, -0.074512, -0.000000, 10.117891, -0.000000, 0.753997, -0.000000, 0.994416}, 
%% {8.762837, -0.000000, -0.074506, -0.000000, 8.811974, -0.000000, 0.656673, -0.000000, 0.994417}, 
%% {7.699904, -0.000000, -0.074490, -0.000000, 7.743028, -0.000000, 0.577006, -0.000000, 0.994418}, 
%% {6.819654, -0.000000, -0.074440, -0.000000, 6.857238, -0.000000, 0.511042, -0.000000, 0.994422}, 
%% {6.082765, -0.000000, -0.074201, -0.000000, 6.116695, -0.000000, 0.455772, -0.000000, 0.994440}, 
%% {5.470142, -0.000000, -0.072052, -0.000000, 5.500529, -0.000000, 0.409631, -0.000000, 0.994604}, 
%% {4.967003, -0.000000, -0.070034, -0.000000, 4.994434, -0.000000, 0.371658, -0.000000, 0.994760}, 
%% {4.519758, -0.000000, -0.074411, -0.000000, 4.544748, -0.000000, 0.338655, -0.000000, 0.994425}, 
%% {4.116577, -0.000000, -0.074312, -0.000000, 4.139183, -0.000000, 0.308390, -0.000000, 0.994433}, 
%% {3.765663, -0.000000, -0.074074, -0.000000, 3.786215, -0.000000, 0.282039, -0.000000, 0.994452}, 
%% {3.459751, -0.000000, -0.073405, -0.000000, 3.478538, -0.000000, 0.258995, -0.000000, 0.994505}, 
%% {3.195393, -0.000000, -0.071389, -0.000000, 3.212633, -0.000000, 0.238751, -0.000000, 0.994666}, 
%% {2.967678, -0.000000, -0.069135, -0.000000, 2.983461, -0.000000, 0.221169, -0.000000, 0.994848}, 
%% {2.762543, -0.000000, -0.071729, -0.000000, 2.777188, -0.000000, 0.206220, -0.000000, 0.994646}, 
%% {2.575017, -0.000000, -0.071606, -0.000000, 2.588631, -0.000000, 0.192031, -0.000000, 0.994660}, 
%% {2.409805, -0.000000, -0.068689, -0.000000, 2.422255, -0.000000, 0.178897, -0.000000, 0.994901}, 
%% {2.262821, -0.000000, -0.067901, -0.000000, 2.274430, -0.000000, 0.167477, -0.000000, 0.994975}, 
%% {2.130552, -0.000000, -0.068738, -0.000000, 2.141381, -0.000000, 0.157590, -0.000000, 0.994916}, 
%% {2.010885, -0.000000, -0.066221, -0.000000, 2.020860, -0.000000, 0.147750, -0.000000, 0.995134}, 
%% {1.902676, -0.000000, -0.065352, -0.000000, 1.911869, -0.000000, 0.139055, -0.000000, 0.995224}, 
%% {1.805724, -0.000000, -0.064535, -0.000000, 1.814402, -0.000000, 0.131199, -0.000000, 0.995311}, 
%% {1.716668, -0.000000, -0.062787, -0.000000, 1.724715, -0.000000, 0.123650, -0.000000, 0.995478}, 
%% {1.636791, -0.000000, -0.061271, -0.000000, 1.644328, -0.000000, 0.116718, -0.000000, 0.995631}, 
%% {1.563687, -0.000000, -0.059925, -0.000000, 1.570861, -0.000000, 0.110250, -0.000000, 0.995775}, 
%% {1.497690, -0.000000, -0.057925, -0.000000, 1.504283, -0.000000, 0.103976, -0.000000, 0.995979}, 
%% {1.437306, -0.000000, -0.056396, -0.000000, 1.443545, -0.000000, 0.098269, -0.000000, 0.996144}, 
%% {1.382389, -0.000000, -0.054372, -0.000000, 1.388230, -0.000000, 0.092603, -0.000000, 0.996358}, 
%% {1.332489, -0.000000, -0.052205, -0.000000, 1.337976, -0.000000, 0.087208, -0.000000, 0.996583}, 
%% {1.286881, -0.000000, -0.050330, -0.000000, 1.292073, -0.000000, 0.082152, -0.000000, 0.996787}, 
%% {1.245138, -0.000000, -0.047990, -0.000000, 1.250153, -0.000000, 0.077103, -0.000000, 0.997028}, 
%% {1.207381, -0.000000, -0.045840, -0.000000, 1.212000, -0.000000, 0.072273, -0.000000, 0.997256}, 
%% {1.172801, -0.000000, -0.043326, -0.000000, 1.177242, -0.000000, 0.067470, -0.000000, 0.997507}, 
%% {1.141209, -0.000000, -0.040916, -0.000000, 1.145272, -0.000000, 0.062859, -0.000000, 0.997746}, 
%% {1.112378, -0.000000, -0.038633, -0.000000, 1.116327, -0.000000, 0.058373, -0.000000, 0.997973}, 
%% {1.086154, -0.000000, -0.036106, -0.000000, 1.089906, -0.000000, 0.053924, -0.000000, 0.998208}, 
%% {1.062336, -0.000000, -0.033472, -0.000000, 1.065752, -0.000000, 0.049580, -0.000000, 0.998438}, 
%% {1.040699, -0.000000, -0.030904, -0.000000, 1.043732, -0.000000, 0.045362, -0.000000, 0.998653}, 
%% {1.021014, -0.000000, -0.028430, -0.000000, 1.023792, -0.000000, 0.041250, -0.000000, 0.998851}, 
%% {1.002969, -0.000000, -0.025851, -0.000000, 1.005421, -0.000000, 0.037170, -0.000000, 0.999042}, 
%% {0.986618, -0.000000, -0.023291, -0.000000, 0.988722, -0.000000, 0.033275, -0.000000, 0.999215}, 
%% {0.971770, -0.000000, -0.020771, -0.000000, 0.973541, -0.000000, 0.029364, -0.000000, 0.999372}, 
%% {0.958164, -0.000000, -0.018309, -0.000000, 0.959699, -0.000000, 0.025698, -0.000000, 0.999509}, 
%% {0.945937, -0.000000, -0.015914, -0.000000, 0.947142, -0.000000, 0.022108, -0.000000, 0.999628}, 
%% {0.934791, -0.000000, -0.013441, -0.000000, 0.935693, -0.000000, 0.018594, -0.000000, 0.999733}, 
%% {0.924661, -0.000000, -0.010988, -0.000000, 0.925293, -0.000000, 0.015169, -0.000000, 0.999820}, 
%% {0.915450, -0.000000, -0.008604, -0.000000, 0.915920, -0.000000, 0.011855, -0.000000, 0.999889}, 
%% {0.907070, -0.000000, -0.006377, -0.000000, 0.907359, -0.000000, 0.008689, -0.000000, 0.999939}, 
%% {0.899469, -0.000000, -0.004273, -0.000000, 0.899671, -0.000000, 0.005742, -0.000000, 0.999973}, 
%% {0.892633, -0.000000, -0.002146, -0.000000, 0.892674, -0.000000, 0.002849, -0.000000, 0.999993}, 
%% {0.886382, -0.000000, 0.000028, -0.000000, 0.886399, -0.000000, 0.000030, -0.000000, 1.000000}, 
%% {4951.878418, -0.000000, -0.099073, -0.000000, 5000.285156, -0.000000, 495.508240, -0.000000, 0.990086}, 
%% {1964.857544, -0.000000, -0.099073, -0.000000, 1984.498413, -0.000000, 196.612823, -0.000000, 0.990086}, 
%% {491.165985, -0.000000, -0.099073, -0.000000, 496.136749, -0.000000, 49.148258, -0.000000, 0.990086}, 
%% {218.319016, -0.000000, -0.099073, -0.000000, 220.498856, -0.000000, 21.845995, -0.000000, 0.990086}, 
%% {122.803062, -0.000000, -0.099073, -0.000000, 124.029968, -0.000000, 12.288221, -0.000000, 0.990086}, 
%% {78.586800, -0.000000, -0.099072, -0.000000, 79.382462, -0.000000, 7.863727, -0.000000, 0.990086}, 
%% {54.576492, -0.000000, -0.099072, -0.000000, 55.125816, -0.000000, 5.461172, -0.000000, 0.990086}, 
%% {40.096973, -0.000000, -0.099072, -0.000000, 40.499237, -0.000000, 4.012331, -0.000000, 0.990086}, 
%% {30.699066, -0.000000, -0.099071, -0.000000, 31.005133, -0.000000, 3.071907, -0.000000, 0.990086}, 
%% {24.255865, -0.000000, -0.099071, -0.000000, 24.497946, -0.000000, 2.427219, -0.000000, 0.990086}, 
%% {19.644371, -0.000000, -0.099070, -0.000000, 19.841166, -0.000000, 1.965704, -0.000000, 0.990087}, 
%% {16.234037, -0.000000, -0.099068, -0.000000, 16.396233, -0.000000, 1.624439, -0.000000, 0.990087}, 
%% {13.639799, -0.000000, -0.099066, -0.000000, 13.776041, -0.000000, 1.364841, -0.000000, 0.990087}, 
%% {11.620030, -0.000000, -0.099062, -0.000000, 11.736495, -0.000000, 1.162739, -0.000000, 0.990088}, 
%% {10.017843, -0.000000, -0.099057, -0.000000, 10.117712, -0.000000, 1.002403, -0.000000, 0.990088}, 
%% {8.724846, -0.000000, -0.099046, -0.000000, 8.811878, -0.000000, 0.873031, -0.000000, 0.990089}, 
%% {7.666684, -0.000000, -0.099023, -0.000000, 7.742918, -0.000000, 0.767142, -0.000000, 0.990092}, 
%% {6.789998, -0.000000, -0.098951, -0.000000, 6.857410, -0.000000, 0.679395, -0.000000, 0.990099}, 
%% {6.057055, -0.000000, -0.098584, -0.000000, 6.117100, -0.000000, 0.606007, -0.000000, 0.990137}, 
%% {5.452123, -0.000000, -0.094926, -0.000000, 5.505884, -0.000000, 0.545078, -0.000000, 0.990510}, 
%% {4.942327, -0.000000, -0.093914, -0.000000, 4.990977, -0.000000, 0.493895, -0.000000, 0.990615}, 
%% {4.500379, -0.000000, -0.098911, -0.000000, 4.544568, -0.000000, 0.450233, -0.000000, 0.990105}, 
%% {4.099027, -0.000000, -0.098771, -0.000000, 4.139102, -0.000000, 0.410031, -0.000000, 0.990120}, 
%% {3.749766, -0.000000, -0.098432, -0.000000, 3.786381, -0.000000, 0.374983, -0.000000, 0.990157}, 
%% {3.445596, -0.000000, -0.097463, -0.000000, 3.479094, -0.000000, 0.344350, -0.000000, 0.990260}, 
%% {3.183735, -0.000000, -0.094551, -0.000000, 3.214283, -0.000000, 0.317572, -0.000000, 0.990569}, 
%% {2.954374, -0.000000, -0.092892, -0.000000, 2.982470, -0.000000, 0.294202, -0.000000, 0.990750}, 
%% {2.749356, -0.000000, -0.094579, -0.000000, 2.775404, -0.000000, 0.273872, -0.000000, 0.990579}, 
%% {2.565428, -0.000000, -0.094997, -0.000000, 2.589362, -0.000000, 0.255410, -0.000000, 0.990542}, 
%% {2.400866, -0.000000, -0.091624, -0.000000, 2.423073, -0.000000, 0.238014, -0.000000, 0.990917}, 
%% {2.253204, -0.000000, -0.090691, -0.000000, 2.273766, -0.000000, 0.222765, -0.000000, 0.991034}, 
%% {2.121796, -0.000000, -0.090353, -0.000000, 2.140915, -0.000000, 0.209265, -0.000000, 0.991089}, 
%% {2.003300, -0.000000, -0.088743, -0.000000, 2.020937, -0.000000, 0.196621, -0.000000, 0.991290}, 
%% {1.895035, -0.000000, -0.086936, -0.000000, 1.911544, -0.000000, 0.184955, -0.000000, 0.991515}, 
%% {1.798768, -0.000000, -0.085334, -0.000000, 1.814073, -0.000000, 0.174353, -0.000000, 0.991729}, 
%% {1.710486, -0.000000, -0.083805, -0.000000, 1.724805, -0.000000, 0.164511, -0.000000, 0.991940}, 
%% {1.630784, -0.000000, -0.081378, -0.000000, 1.644177, -0.000000, 0.155161, -0.000000, 0.992257}, 
%% {1.558584, -0.000000, -0.079836, -0.000000, 1.570996, -0.000000, 0.146742, -0.000000, 0.992483}, 
%% {1.492511, -0.000000, -0.077125, -0.000000, 1.504065, -0.000000, 0.138398, -0.000000, 0.992848}, 
%% {1.432744, -0.000000, -0.074902, -0.000000, 1.443656, -0.000000, 0.130659, -0.000000, 0.993169}, 
%% {1.377995, -0.000000, -0.072215, -0.000000, 1.388091, -0.000000, 0.123171, -0.000000, 0.993545}, 
%% {1.328391, -0.000000, -0.069779, -0.000000, 1.337981, -0.000000, 0.116183, -0.000000, 0.993897}, 
%% {1.283041, -0.000000, -0.066654, -0.000000, 1.291833, -0.000000, 0.109229, -0.000000, 0.994326}, 
%% {1.241649, -0.000000, -0.063891, -0.000000, 1.250008, -0.000000, 0.102596, -0.000000, 0.994721}, 
%% {1.203797, -0.000000, -0.060874, -0.000000, 1.211757, -0.000000, 0.096084, -0.000000, 0.995141}, 
%% {1.169488, -0.000000, -0.057689, -0.000000, 1.176943, -0.000000, 0.089712, -0.000000, 0.995575}, 
%% {1.138197, -0.000000, -0.054620, -0.000000, 1.145235, -0.000000, 0.083635, -0.000000, 0.995987}, 
%% {1.109755, -0.000000, -0.051215, -0.000000, 1.116127, -0.000000, 0.077619, -0.000000, 0.996418}, 
%% {1.083749, -0.000000, -0.047841, -0.000000, 1.089725, -0.000000, 0.071691, -0.000000, 0.996835}, 
%% {1.060084, -0.000000, -0.044624, -0.000000, 1.065547, -0.000000, 0.065987, -0.000000, 0.997222}, 
%% {1.038539, -0.000000, -0.041261, -0.000000, 1.043569, -0.000000, 0.060400, -0.000000, 0.997600}, 
%% {1.018926, -0.000000, -0.037807, -0.000000, 1.023548, -0.000000, 0.054870, -0.000000, 0.997964}, 
%% {1.001146, -0.000000, -0.034408, -0.000000, 1.005173, -0.000000, 0.049460, -0.000000, 0.998300}, 
%% {0.985032, -0.000000, -0.031082, -0.000000, 0.988600, -0.000000, 0.044272, -0.000000, 0.998603}, 
%% {0.970302, -0.000000, -0.027722, -0.000000, 0.973418, -0.000000, 0.039214, -0.000000, 0.998880}, 
%% {0.956995, -0.000000, -0.024323, -0.000000, 0.959578, -0.000000, 0.034186, -0.000000, 0.999131}, 
%% {0.944933, -0.000000, -0.020993, -0.000000, 0.947014, -0.000000, 0.029361, -0.000000, 0.999348}, 
%% {0.934011, -0.000000, -0.017781, -0.000000, 0.935602, -0.000000, 0.024685, -0.000000, 0.999530}, 
%% {0.924023, -0.000000, -0.014725, -0.000000, 0.925245, -0.000000, 0.020232, -0.000000, 0.999678}, 
%% {0.914906, -0.000000, -0.011650, -0.000000, 0.915870, -0.000000, 0.015817, -0.000000, 0.999799}, 
%% {0.906762, -0.000000, -0.008573, -0.000000, 0.907309, -0.000000, 0.011644, -0.000000, 0.999890}, 
%% {0.899230, -0.000000, -0.005575, -0.000000, 0.899578, -0.000000, 0.007595, -0.000000, 0.999953}, 
%% {0.892377, -0.000000, -0.002686, -0.000000, 0.892526, -0.000000, 0.003679, -0.000000, 0.999989}, 
%% {0.886303, -0.000000, 0.000024, -0.000000, 0.886263, -0.000000, -0.000034, -0.000000, 1.000000}, 
%% {4920.587891, -0.000000, -0.123378, -0.000000, 4998.574707, -0.000000, 616.625366, -0.000000, 0.984539}, 
%% {1953.922974, -0.000000, -0.123378, -0.000000, 1984.540894, -0.000000, 244.857361, -0.000000, 0.984539}, 
%% {488.446655, -0.000000, -0.123378, -0.000000, 496.108002, -0.000000, 61.209751, -0.000000, 0.984539}, 
%% {217.095123, -0.000000, -0.123378, -0.000000, 220.491898, -0.000000, 27.205151, -0.000000, 0.984539}, 
%% {122.113304, -0.000000, -0.123378, -0.000000, 124.034790, -0.000000, 15.302706, -0.000000, 0.984539}, 
%% {78.145638, -0.000000, -0.123378, -0.000000, 79.383919, -0.000000, 9.792857, -0.000000, 0.984539}, 
%% {54.271355, -0.000000, -0.123377, -0.000000, 55.125786, -0.000000, 6.801055, -0.000000, 0.984539}, 
%% {39.873734, -0.000000, -0.123377, -0.000000, 40.498901, -0.000000, 4.996818, -0.000000, 0.984539}, 
%% {30.526211, -0.000000, -0.123376, -0.000000, 31.004684, -0.000000, 3.825421, -0.000000, 0.984539}, 
%% {24.119011, -0.000000, -0.123374, -0.000000, 24.497475, -0.000000, 3.022496, -0.000000, 0.984539}, 
%% {19.534611, -0.000000, -0.123372, -0.000000, 19.840874, -0.000000, 2.447989, -0.000000, 0.984540}, 
%% {16.142912, -0.000000, -0.123370, -0.000000, 16.396152, -0.000000, 2.022945, -0.000000, 0.984540}, 
%% {13.563098, -0.000000, -0.123365, -0.000000, 13.776000, -0.000000, 1.699653, -0.000000, 0.984541}, 
%% {11.555212, -0.000000, -0.123359, -0.000000, 11.736173, -0.000000, 1.448025, -0.000000, 0.984541}, 
%% {9.961684, -0.000000, -0.123351, -0.000000, 10.117766, -0.000000, 1.248350, -0.000000, 0.984542}, 
%% {8.676162, -0.000000, -0.123335, -0.000000, 8.811796, -0.000000, 1.087227, -0.000000, 0.984545}, 
%% {7.623999, -0.000000, -0.123303, -0.000000, 7.742939, -0.000000, 0.955373, -0.000000, 0.984549}, 
%% {6.752152, -0.000000, -0.123202, -0.000000, 6.857555, -0.000000, 0.846083, -0.000000, 0.984562}, 
%% {6.024063, -0.000000, -0.122648, -0.000000, 6.117804, -0.000000, 0.754777, -0.000000, 0.984633}, 
%% {5.425199, -0.000000, -0.118309, -0.000000, 5.509078, -0.000000, 0.679256, -0.000000, 0.985187}, 
%% {4.912474, -0.000000, -0.117757, -0.000000, 4.988327, -0.000000, 0.614868, -0.000000, 0.985261}, 
%% {4.472218, -0.000000, -0.122000, -0.000000, 4.541148, -0.000000, 0.560146, -0.000000, 0.984720}, 
%% {4.076538, -0.000000, -0.122964, -0.000000, 4.139080, -0.000000, 0.510656, -0.000000, 0.984597}, 
%% {3.729482, -0.000000, -0.122503, -0.000000, 3.786433, -0.000000, 0.467054, -0.000000, 0.984659}, 
%% {3.427782, -0.000000, -0.121155, -0.000000, 3.479986, -0.000000, 0.428947, -0.000000, 0.984839}, 
%% {3.168284, -0.000000, -0.117569, -0.000000, 3.216013, -0.000000, 0.395727, -0.000000, 0.985315}, 
%% {2.937598, -0.000000, -0.116486, -0.000000, 2.981577, -0.000000, 0.366461, -0.000000, 0.985469}, 
%% {2.733372, -0.000000, -0.117299, -0.000000, 2.773878, -0.000000, 0.340858, -0.000000, 0.985373}, 
%% {2.552737, -0.000000, -0.117790, -0.000000, 2.590222, -0.000000, 0.318129, -0.000000, 0.985321}, 
%% {2.388517, -0.000000, -0.114768, -0.000000, 2.423250, -0.000000, 0.296636, -0.000000, 0.985747}, 
%% {2.241217, -0.000000, -0.113243, -0.000000, 2.273299, -0.000000, 0.277536, -0.000000, 0.985977}, 
%% {2.111097, -0.000000, -0.111636, -0.000000, 2.140838, -0.000000, 0.260457, -0.000000, 0.986227}, 
%% {1.993338, -0.000000, -0.110973, -0.000000, 2.021042, -0.000000, 0.245146, -0.000000, 0.986352}, 
%% {1.885964, -0.000000, -0.108232, -0.000000, 1.911702, -0.000000, 0.230400, -0.000000, 0.986778}, 
%% {1.789690, -0.000000, -0.106179, -0.000000, 1.813677, -0.000000, 0.217167, -0.000000, 0.987116}, 
%% {1.702801, -0.000000, -0.104407, -0.000000, 1.725035, -0.000000, 0.205068, -0.000000, 0.987426}, 
%% {1.623195, -0.000000, -0.101500, -0.000000, 1.643883, -0.000000, 0.193388, -0.000000, 0.987907}, 
%% {1.551537, -0.000000, -0.098953, -0.000000, 1.570816, -0.000000, 0.182648, -0.000000, 0.988351}, 
%% {1.486020, -0.000000, -0.096196, -0.000000, 1.503951, -0.000000, 0.172481, -0.000000, 0.988835}, 
%% {1.426461, -0.000000, -0.093170, -0.000000, 1.443169, -0.000000, 0.162825, -0.000000, 0.989365}, 
%% {1.372638, -0.000000, -0.089956, -0.000000, 1.388011, -0.000000, 0.153524, -0.000000, 0.989939}, 
%% {1.323197, -0.000000, -0.086670, -0.000000, 1.337614, -0.000000, 0.144638, -0.000000, 0.990526}, 
%% {1.278169, -0.000000, -0.083198, -0.000000, 1.291686, -0.000000, 0.136130, -0.000000, 0.991139}, 
%% {1.237318, -0.000000, -0.079599, -0.000000, 1.249860, -0.000000, 0.127825, -0.000000, 0.991777}, 
%% {1.199951, -0.000000, -0.075690, -0.000000, 1.211504, -0.000000, 0.119629, -0.000000, 0.992454}, 
%% {1.166024, -0.000000, -0.071976, -0.000000, 1.176790, -0.000000, 0.111876, -0.000000, 0.993094}, 
%% {1.134970, -0.000000, -0.067932, -0.000000, 1.144873, -0.000000, 0.104193, -0.000000, 0.993764}, 
%% {1.106646, -0.000000, -0.063883, -0.000000, 1.115956, -0.000000, 0.096653, -0.000000, 0.994420}, 
%% {1.081081, -0.000000, -0.059867, -0.000000, 1.089478, -0.000000, 0.089392, -0.000000, 0.995050}, 
%% {1.057509, -0.000000, -0.055594, -0.000000, 1.065471, -0.000000, 0.082186, -0.000000, 0.995679}, 
%% {1.036247, -0.000000, -0.051339, -0.000000, 1.043427, -0.000000, 0.075205, -0.000000, 0.996274}, 
%% {1.016874, -0.000000, -0.047183, -0.000000, 1.023375, -0.000000, 0.068351, -0.000000, 0.996828}, 
%% {0.999267, -0.000000, -0.042934, -0.000000, 1.005134, -0.000000, 0.061712, -0.000000, 0.997348}, 
%% {0.983145, -0.000000, -0.038658, -0.000000, 0.988400, -0.000000, 0.055127, -0.000000, 0.997832}, 
%% {0.968759, -0.000000, -0.034473, -0.000000, 0.973224, -0.000000, 0.048835, -0.000000, 0.998262}, 
%% {0.955568, -0.000000, -0.030409, -0.000000, 0.959534, -0.000000, 0.042639, -0.000000, 0.998643}, 
%% {0.943715, -0.000000, -0.026374, -0.000000, 0.946944, -0.000000, 0.036704, -0.000000, 0.998974}, 
%% {0.933013, -0.000000, -0.022291, -0.000000, 0.935535, -0.000000, 0.030768, -0.000000, 0.999265}, 
%% {0.923246, -0.000000, -0.018301, -0.000000, 0.925114, -0.000000, 0.025195, -0.000000, 0.999501}, 
%% {0.914407, -0.000000, -0.014415, -0.000000, 0.915689, -0.000000, 0.019699, -0.000000, 0.999689}, 
%% {0.906354, -0.000000, -0.010686, -0.000000, 0.907210, -0.000000, 0.014567, -0.000000, 0.999828}, 
%% {0.898933, -0.000000, -0.006997, -0.000000, 0.899427, -0.000000, 0.009449, -0.000000, 0.999926}, 
%% {0.892168, -0.000000, -0.003434, -0.000000, 0.892368, -0.000000, 0.004616, -0.000000, 0.999982}, 
%% {0.886075, -0.000000, 0.000051, -0.000000, 0.886052, -0.000000, -0.000034, -0.000000, 1.000000}, 
%% {4886.126953, -0.000000, -0.147377, -0.000000, 5001.471191, -0.000000, 736.461975, -0.000000, 0.977787}, 
%% {1940.317017, -0.000000, -0.147377, -0.000000, 1984.654907, -0.000000, 292.454498, -0.000000, 0.977787}, 
%% {485.116180, -0.000000, -0.147377, -0.000000, 496.118683, -0.000000, 73.118950, -0.000000, 0.977787}, 
%% {215.594009, -0.000000, -0.147377, -0.000000, 220.483887, -0.000000, 32.495331, -0.000000, 0.977787}, 
%% {121.277847, -0.000000, -0.147377, -0.000000, 124.036758, -0.000000, 18.279606, -0.000000, 0.977787}, 
%% {77.615868, -0.000000, -0.147376, -0.000000, 79.376648, -0.000000, 11.698662, -0.000000, 0.977787}, 
%% {53.899967, -0.000000, -0.147376, -0.000000, 55.120750, -0.000000, 8.124100, -0.000000, 0.977787}, 
%% {39.595844, -0.000000, -0.147375, -0.000000, 40.499393, -0.000000, 5.968058, -0.000000, 0.977787}, 
%% {30.315405, -0.000000, -0.147373, -0.000000, 31.006128, -0.000000, 4.569309, -0.000000, 0.977787}, 
%% {23.956476, -0.000000, -0.147370, -0.000000, 24.500046, -0.000000, 3.610806, -0.000000, 0.977788}, 
%% {19.400717, -0.000000, -0.147367, -0.000000, 19.841331, -0.000000, 2.924171, -0.000000, 0.977788}, 
%% {16.031992, -0.000000, -0.147362, -0.000000, 16.396416, -0.000000, 2.416416, -0.000000, 0.977789}, 
%% {13.470632, -0.000000, -0.147355, -0.000000, 13.775434, -0.000000, 2.030329, -0.000000, 0.977790}, 
%% {11.476031, -0.000000, -0.147346, -0.000000, 11.736260, -0.000000, 1.729720, -0.000000, 0.977791}, 
%% {9.893930, -0.000000, -0.147333, -0.000000, 10.118073, -0.000000, 1.491258, -0.000000, 0.977793}, 
%% {8.617026, -0.000000, -0.147311, -0.000000, 8.811640, -0.000000, 1.298755, -0.000000, 0.977797}, 
%% {7.571855, -0.000000, -0.147267, -0.000000, 7.742770, -0.000000, 1.141199, -0.000000, 0.977805}, 
%% {6.706495, -0.000000, -0.147130, -0.000000, 6.857432, -0.000000, 1.010748, -0.000000, 0.977826}, 
%% {5.984423, -0.000000, -0.146276, -0.000000, 6.118908, -0.000000, 0.901801, -0.000000, 0.977957}, 
%% {5.389524, -0.000000, -0.141902, -0.000000, 5.510278, -0.000000, 0.811661, -0.000000, 0.978630}, 
%% {4.877278, -0.000000, -0.141424, -0.000000, 4.986223, -0.000000, 0.734288, -0.000000, 0.978708}, 
%% {4.437806, -0.000000, -0.144602, -0.000000, 4.536744, -0.000000, 0.668378, -0.000000, 0.978221}, 
%% {4.049234, -0.000000, -0.146823, -0.000000, 4.139143, -0.000000, 0.610050, -0.000000, 0.977880}, 
%% {3.704818, -0.000000, -0.146211, -0.000000, 3.786753, -0.000000, 0.558017, -0.000000, 0.977978}, 
%% {3.406131, -0.000000, -0.144370, -0.000000, 3.481018, -0.000000, 0.512588, -0.000000, 0.978274}, 
%% {3.148022, -0.000000, -0.140900, -0.000000, 3.216560, -0.000000, 0.472961, -0.000000, 0.978831}, 
%% {2.917596, -0.000000, -0.139818, -0.000000, 2.980788, -0.000000, 0.437861, -0.000000, 0.979017}, 
%% {2.714531, -0.000000, -0.139779, -0.000000, 2.772725, -0.000000, 0.406992, -0.000000, 0.979043}, 
%% {2.536437, -0.000000, -0.139329, -0.000000, 2.590280, -0.000000, 0.379842, -0.000000, 0.979135}, 
%% {2.373428, -0.000000, -0.137675, -0.000000, 2.423327, -0.000000, 0.354589, -0.000000, 0.979431}, 
%% {2.227137, -0.000000, -0.135439, -0.000000, 2.273292, -0.000000, 0.331650, -0.000000, 0.979831}, 
%% {2.097867, -0.000000, -0.133132, -0.000000, 2.140523, -0.000000, 0.311154, -0.000000, 0.980254}, 
%% {1.980843, -0.000000, -0.132198, -0.000000, 2.020652, -0.000000, 0.292764, -0.000000, 0.980462}, 
%% {1.875167, -0.000000, -0.129342, -0.000000, 1.911976, -0.000000, 0.275468, -0.000000, 0.980999}, 
%% {1.779058, -0.000000, -0.126790, -0.000000, 1.813295, -0.000000, 0.259498, -0.000000, 0.981506}, 
%% {1.692986, -0.000000, -0.124332, -0.000000, 1.724811, -0.000000, 0.244967, -0.000000, 0.982010}, 
%% {1.614414, -0.000000, -0.121393, -0.000000, 1.643798, -0.000000, 0.231244, -0.000000, 0.982612}, 
%% {1.543053, -0.000000, -0.118100, -0.000000, 1.570436, -0.000000, 0.218285, -0.000000, 0.983293}, 
%% {1.478777, -0.000000, -0.115005, -0.000000, 1.504081, -0.000000, 0.206234, -0.000000, 0.983961}, 
%% {1.419457, -0.000000, -0.111205, -0.000000, 1.443034, -0.000000, 0.194583, -0.000000, 0.984756}, 
%% {1.366235, -0.000000, -0.107682, -0.000000, 1.387907, -0.000000, 0.183627, -0.000000, 0.985527}, 
%% {1.317205, -0.000000, -0.103416, -0.000000, 1.337475, -0.000000, 0.172885, -0.000000, 0.986426}, 
%% {1.272994, -0.000000, -0.099457, -0.000000, 1.291646, -0.000000, 0.162773, -0.000000, 0.987283}, 
%% {1.232360, -0.000000, -0.095007, -0.000000, 1.249462, -0.000000, 0.152724, -0.000000, 0.988226}, 
%% {1.195777, -0.000000, -0.090716, -0.000000, 1.211348, -0.000000, 0.143174, -0.000000, 0.989138}, 
%% {1.162113, -0.000000, -0.085965, -0.000000, 1.176518, -0.000000, 0.133708, -0.000000, 0.990109}, 
%% {1.131574, -0.000000, -0.081208, -0.000000, 1.144695, -0.000000, 0.124584, -0.000000, 0.991059}, 
%% {1.103867, -0.000000, -0.076433, -0.000000, 1.115857, -0.000000, 0.115599, -0.000000, 0.991996}, 
%% {1.078201, -0.000000, -0.071412, -0.000000, 1.089182, -0.000000, 0.106732, -0.000000, 0.992931}, 
%% {1.055042, -0.000000, -0.066447, -0.000000, 1.065159, -0.000000, 0.098165, -0.000000, 0.993818}, 
%% {1.034068, -0.000000, -0.061534, -0.000000, 1.043144, -0.000000, 0.089886, -0.000000, 0.994651}, 
%% {1.014786, -0.000000, -0.056428, -0.000000, 1.023160, -0.000000, 0.081711, -0.000000, 0.995456}, 
%% {0.997247, -0.000000, -0.051361, -0.000000, 1.004860, -0.000000, 0.073687, -0.000000, 0.996205}, 
%% {0.981414, -0.000000, -0.046413, -0.000000, 0.988193, -0.000000, 0.066051, -0.000000, 0.996876}, 
%% {0.966972, -0.000000, -0.041390, -0.000000, 0.973100, -0.000000, 0.058416, -0.000000, 0.997500}, 
%% {0.954076, -0.000000, -0.036380, -0.000000, 0.959335, -0.000000, 0.051040, -0.000000, 0.998054}, 
%% {0.942422, -0.000000, -0.031458, -0.000000, 0.946750, -0.000000, 0.043888, -0.000000, 0.998535}, 
%% {0.931844, -0.000000, -0.026662, -0.000000, 0.935321, -0.000000, 0.036975, -0.000000, 0.998942}, 
%% {0.922400, -0.000000, -0.021964, -0.000000, 0.925048, -0.000000, 0.030229, -0.000000, 0.999280}, 
%% {0.913694, -0.000000, -0.017296, -0.000000, 0.915582, -0.000000, 0.023659, -0.000000, 0.999552}, 
%% {0.905824, -0.000000, -0.012770, -0.000000, 0.906987, -0.000000, 0.017372, -0.000000, 0.999755}, 
%% {0.898528, -0.000000, -0.008391, -0.000000, 0.899265, -0.000000, 0.011368, -0.000000, 0.999894}, 
%% {0.891884, -0.000000, -0.004157, -0.000000, 0.892173, -0.000000, 0.005553, -0.000000, 0.999974}, 
%% {0.885794, -0.000000, 0.000046, -0.000000, 0.885785, -0.000000, -0.000007, -0.000000, 1.000000}, 
%% {4845.128906, -0.000000, -0.171010, -0.000000, 4998.009277, -0.000000, 854.326233, -0.000000, 0.969846}, 
%% {1924.591431, -0.000000, -0.171009, -0.000000, 1984.552856, -0.000000, 339.355896, -0.000000, 0.969847}, 
%% {481.184357, -0.000000, -0.171009, -0.000000, 496.089111, -0.000000, 84.844803, -0.000000, 0.969847}, 
%% {213.857025, -0.000000, -0.171010, -0.000000, 220.499832, -0.000000, 37.708622, -0.000000, 0.969846}, 
%% {120.299774, -0.000000, -0.171009, -0.000000, 124.021439, -0.000000, 21.211926, -0.000000, 0.969847}, 
%% {76.983360, -0.000000, -0.171008, -0.000000, 79.385063, -0.000000, 13.574183, -0.000000, 0.969847}, 
%% {53.462418, -0.000000, -0.171007, -0.000000, 55.122398, -0.000000, 9.426795, -0.000000, 0.969847}, 
%% {39.273529, -0.000000, -0.171006, -0.000000, 40.502380, -0.000000, 6.924934, -0.000000, 0.969847}, 
%% {30.069893, -0.000000, -0.171003, -0.000000, 31.005348, -0.000000, 5.302125, -0.000000, 0.969848}, 
%% {23.758427, -0.000000, -0.170999, -0.000000, 24.495352, -0.000000, 4.189238, -0.000000, 0.969848}, 
%% {19.243355, -0.000000, -0.170993, -0.000000, 19.841084, -0.000000, 3.393091, -0.000000, 0.969850}, 
%% {15.902539, -0.000000, -0.170986, -0.000000, 16.395010, -0.000000, 2.803988, -0.000000, 0.969851}, 
%% {13.361078, -0.000000, -0.170976, -0.000000, 13.775606, -0.000000, 2.355878, -0.000000, 0.969853}, 
%% {11.383277, -0.000000, -0.170963, -0.000000, 11.735950, -0.000000, 2.007117, -0.000000, 0.969856}, 
%% {9.813476, -0.000000, -0.170944, -0.000000, 10.117523, -0.000000, 1.730310, -0.000000, 0.969859}, 
%% {8.547023, -0.000000, -0.170914, -0.000000, 8.811570, -0.000000, 1.506988, -0.000000, 0.969865}, 
%% {7.510661, -0.000000, -0.170854, -0.000000, 7.742676, -0.000000, 1.324220, -0.000000, 0.969876}, 
%% {6.652352, -0.000000, -0.170669, -0.000000, 6.857410, -0.000000, 1.172852, -0.000000, 0.969910}, 
%% {5.938306, -0.000000, -0.169302, -0.000000, 6.121113, -0.000000, 1.046799, -0.000000, 0.970156}, 
%% {5.346894, -0.000000, -0.165295, -0.000000, 5.510950, -0.000000, 0.942051, -0.000000, 0.970877}, 
%% {4.836451, -0.000000, -0.164806, -0.000000, 4.984320, -0.000000, 0.851889, -0.000000, 0.970971}, 
%% {4.398776, -0.000000, -0.167087, -0.000000, 4.532816, -0.000000, 0.774889, -0.000000, 0.970566}, 
%% {4.016975, -0.000000, -0.170284, -0.000000, 4.139015, -0.000000, 0.707943, -0.000000, 0.969990}, 
%% {3.675871, -0.000000, -0.169476, -0.000000, 3.787029, -0.000000, 0.647595, -0.000000, 0.970143}, 
%% {3.381040, -0.000000, -0.166990, -0.000000, 3.482629, -0.000000, 0.595108, -0.000000, 0.970608}, 
%% {3.123587, -0.000000, -0.164024, -0.000000, 3.216794, -0.000000, 0.549052, -0.000000, 0.971169}, 
%% {2.894538, -0.000000, -0.162778, -0.000000, 2.980248, -0.000000, 0.508218, -0.000000, 0.971420}, 
%% {2.693117, -0.000000, -0.161906, -0.000000, 2.772169, -0.000000, 0.472263, -0.000000, 0.971608}, 
%% {2.516452, -0.000000, -0.160818, -0.000000, 2.589560, -0.000000, 0.440587, -0.000000, 0.971844}, 
%% {2.355801, -0.000000, -0.160187, -0.000000, 2.423565, -0.000000, 0.411774, -0.000000, 0.972001}, 
%% {2.210931, -0.000000, -0.157171, -0.000000, 2.273561, -0.000000, 0.385087, -0.000000, 0.972625}, 
%% {2.081924, -0.000000, -0.154577, -0.000000, 2.139989, -0.000000, 0.361187, -0.000000, 0.973183}, 
%% {1.966331, -0.000000, -0.152839, -0.000000, 2.020159, -0.000000, 0.339731, -0.000000, 0.973593}, 
%% {1.862182, -0.000000, -0.150504, -0.000000, 1.912019, -0.000000, 0.319967, -0.000000, 0.974140}, 
%% {1.766854, -0.000000, -0.147051, -0.000000, 1.813153, -0.000000, 0.301344, -0.000000, 0.974920}, 
%% {1.681459, -0.000000, -0.144071, -0.000000, 1.724527, -0.000000, 0.284318, -0.000000, 0.975639}, 
%% {1.604411, -0.000000, -0.140963, -0.000000, 1.643987, -0.000000, 0.268687, -0.000000, 0.976393}, 
%% {1.533450, -0.000000, -0.137008, -0.000000, 1.570160, -0.000000, 0.253453, -0.000000, 0.977355}, 
%% {1.469965, -0.000000, -0.133331, -0.000000, 1.503694, -0.000000, 0.239554, -0.000000, 0.978272}, 
%% {1.411755, -0.000000, -0.129017, -0.000000, 1.442828, -0.000000, 0.226066, -0.000000, 0.979340}, 
%% {1.359062, -0.000000, -0.124739, -0.000000, 1.387717, -0.000000, 0.213314, -0.000000, 0.980421}, 
%% {1.311078, -0.000000, -0.120210, -0.000000, 1.337161, -0.000000, 0.200978, -0.000000, 0.981573}, 
%% {1.267521, -0.000000, -0.115334, -0.000000, 1.291106, -0.000000, 0.189061, -0.000000, 0.982797}, 
%% {1.227688, -0.000000, -0.110346, -0.000000, 1.249352, -0.000000, 0.177464, -0.000000, 0.984049}, 
%% {1.191418, -0.000000, -0.105163, -0.000000, 1.210903, -0.000000, 0.166339, -0.000000, 0.985318}, 
%% {1.158411, -0.000000, -0.099776, -0.000000, 1.176303, -0.000000, 0.155257, -0.000000, 0.986628}, 
%% {1.128191, -0.000000, -0.094438, -0.000000, 1.144348, -0.000000, 0.144522, -0.000000, 0.987902}, 
%% {1.100684, -0.000000, -0.088736, -0.000000, 1.115493, -0.000000, 0.134109, -0.000000, 0.989188}, 
%% {1.075476, -0.000000, -0.083113, -0.000000, 1.089063, -0.000000, 0.124087, -0.000000, 0.990411}, 
%% {1.052589, -0.000000, -0.077348, -0.000000, 1.064978, -0.000000, 0.114053, -0.000000, 0.991619}, 
%% {1.031725, -0.000000, -0.071449, -0.000000, 1.042965, -0.000000, 0.104362, -0.000000, 0.992773}, 
%% {1.012704, -0.000000, -0.065630, -0.000000, 1.022947, -0.000000, 0.094856, -0.000000, 0.993853}, 
%% {0.995475, -0.000000, -0.059808, -0.000000, 1.004726, -0.000000, 0.085617, -0.000000, 0.994856}, 
%% {0.979629, -0.000000, -0.053887, -0.000000, 0.988045, -0.000000, 0.076601, -0.000000, 0.995786}, 
%% {0.965385, -0.000000, -0.048038, -0.000000, 0.972935, -0.000000, 0.067894, -0.000000, 0.996622}, 
%% {0.952531, -0.000000, -0.042357, -0.000000, 0.959076, -0.000000, 0.059398, -0.000000, 0.997359}, 
%% {0.940920, -0.000000, -0.036658, -0.000000, 0.946624, -0.000000, 0.051072, -0.000000, 0.998010}, 
%% {0.930604, -0.000000, -0.031029, -0.000000, 0.935174, -0.000000, 0.042955, -0.000000, 0.998568}, 
%% {0.921363, -0.000000, -0.025521, -0.000000, 0.924855, -0.000000, 0.035114, -0.000000, 0.999027}, 
%% {0.912914, -0.000000, -0.020203, -0.000000, 0.915419, -0.000000, 0.027605, -0.000000, 0.999389}, 
%% {0.905246, -0.000000, -0.014943, -0.000000, 0.906889, -0.000000, 0.020275, -0.000000, 0.999665}, 
%% {0.898110, -0.000000, -0.009741, -0.000000, 0.899082, -0.000000, 0.013245, -0.000000, 0.999856}, 
%% {0.891514, -0.000000, -0.004720, -0.000000, 0.891951, -0.000000, 0.006449, -0.000000, 0.999966}, 
%% {0.885559, -0.000000, 0.000063, -0.000000, 0.885537, -0.000000, -0.000047, -0.000000, 1.000000}, 
%% {4800.114258, -0.000000, -0.194217, -0.000000, 4995.866211, -0.000000, 970.365173, -0.000000, 0.960738}, 
%% {1905.701904, -0.000000, -0.194217, -0.000000, 1984.617676, -0.000000, 385.245361, -0.000000, 0.960738}, 
%% {476.609528, -0.000000, -0.194217, -0.000000, 496.155609, -0.000000, 96.347549, -0.000000, 0.960739}, 
%% {211.828598, -0.000000, -0.194217, -0.000000, 220.502396, -0.000000, 42.821907, -0.000000, 0.960739}, 
%% {119.161346, -0.000000, -0.194216, -0.000000, 124.026733, -0.000000, 24.088821, -0.000000, 0.960739}, 
%% {76.262100, -0.000000, -0.194215, -0.000000, 79.377777, -0.000000, 15.416637, -0.000000, 0.960739}, 
%% {52.961250, -0.000000, -0.194214, -0.000000, 55.122257, -0.000000, 10.706285, -0.000000, 0.960739}, 
%% {38.908764, -0.000000, -0.194211, -0.000000, 40.498310, -0.000000, 7.865522, -0.000000, 0.960740}, 
%% {29.788809, -0.000000, -0.194208, -0.000000, 31.005571, -0.000000, 6.021902, -0.000000, 0.960740}, 
%% {23.534697, -0.000000, -0.194201, -0.000000, 24.496592, -0.000000, 4.757611, -0.000000, 0.960742}, 
%% {19.063534, -0.000000, -0.194193, -0.000000, 19.839878, -0.000000, 3.853709, -0.000000, 0.960744}, 
%% {15.752988, -0.000000, -0.194182, -0.000000, 16.395517, -0.000000, 3.184493, -0.000000, 0.960746}, 
%% {13.236712, -0.000000, -0.194168, -0.000000, 13.774602, -0.000000, 2.675783, -0.000000, 0.960749}, 
%% {11.276688, -0.000000, -0.194149, -0.000000, 11.735827, -0.000000, 2.279545, -0.000000, 0.960753}, 
%% {9.721586, -0.000000, -0.194122, -0.000000, 10.117773, -0.000000, 1.965134, -0.000000, 0.960760}, 
%% {8.467396, -0.000000, -0.194082, -0.000000, 8.811413, -0.000000, 1.711612, -0.000000, 0.960768}, 
%% {7.440494, -0.000000, -0.194004, -0.000000, 7.742658, -0.000000, 1.503998, -0.000000, 0.960785}, 
%% {6.590437, -0.000000, -0.193749, -0.000000, 6.857750, -0.000000, 1.332108, -0.000000, 0.960838}, 
%% {5.886992, -0.000000, -0.191470, -0.000000, 6.125151, -0.000000, 1.189634, -0.000000, 0.961308}, 
%% {5.297441, -0.000000, -0.188335, -0.000000, 5.511017, -0.000000, 1.070062, -0.000000, 0.961957}, 
%% {4.790149, -0.000000, -0.187813, -0.000000, 4.982808, -0.000000, 0.967361, -0.000000, 0.962072}, 
%% {4.355066, -0.000000, -0.189396, -0.000000, 4.529477, -0.000000, 0.879485, -0.000000, 0.961752}, 
%% {3.979723, -0.000000, -0.193108, -0.000000, 4.138595, -0.000000, 0.804026, -0.000000, 0.960986}, 
%% {3.642848, -0.000000, -0.192212, -0.000000, 3.787672, -0.000000, 0.735698, -0.000000, 0.961181}, 
%% {3.352211, -0.000000, -0.189022, -0.000000, 3.484616, -0.000000, 0.676286, -0.000000, 0.961866}, 
%% {3.095376, -0.000000, -0.186770, -0.000000, 3.216883, -0.000000, 0.623814, -0.000000, 0.962360}, 
%% {2.868255, -0.000000, -0.185272, -0.000000, 2.979991, -0.000000, 0.577339, -0.000000, 0.962707}, 
%% {2.668938, -0.000000, -0.183549, -0.000000, 2.771908, -0.000000, 0.536412, -0.000000, 0.963110}, 
%% {2.493245, -0.000000, -0.182220, -0.000000, 2.588384, -0.000000, 0.500271, -0.000000, 0.963437}, 
%% {2.335400, -0.000000, -0.181898, -0.000000, 2.423505, -0.000000, 0.467881, -0.000000, 0.963558}, 
%% {2.192585, -0.000000, -0.178457, -0.000000, 2.274109, -0.000000, 0.437680, -0.000000, 0.964377}, 
%% {2.064139, -0.000000, -0.175702, -0.000000, 2.139693, -0.000000, 0.410431, -0.000000, 0.965064}, 
%% {1.949915, -0.000000, -0.172993, -0.000000, 2.019906, -0.000000, 0.385878, -0.000000, 0.965766}, 
%% {1.846907, -0.000000, -0.170865, -0.000000, 1.911773, -0.000000, 0.363632, -0.000000, 0.966359}, 
%% {1.753344, -0.000000, -0.166985, -0.000000, 1.813180, -0.000000, 0.342585, -0.000000, 0.967373}, 
%% {1.668692, -0.000000, -0.163447, -0.000000, 1.723978, -0.000000, 0.323172, -0.000000, 0.968346}, 
%% {1.592822, -0.000000, -0.159948, -0.000000, 1.643732, -0.000000, 0.305461, -0.000000, 0.969326}, 
%% {1.523091, -0.000000, -0.155552, -0.000000, 1.570060, -0.000000, 0.288351, -0.000000, 0.970551}, 
%% {1.460030, -0.000000, -0.151228, -0.000000, 1.503118, -0.000000, 0.272339, -0.000000, 0.971792}, 
%% {1.403079, -0.000000, -0.146835, -0.000000, 1.442735, -0.000000, 0.257188, -0.000000, 0.973085}, 
%% {1.351114, -0.000000, -0.141551, -0.000000, 1.387068, -0.000000, 0.242521, -0.000000, 0.974592}, 
%% {1.304224, -0.000000, -0.136574, -0.000000, 1.336996, -0.000000, 0.228609, -0.000000, 0.976061}, 
%% {1.261412, -0.000000, -0.130992, -0.000000, 1.290908, -0.000000, 0.215061, -0.000000, 0.977667}, 
%% {1.221961, -0.000000, -0.125529, -0.000000, 1.249133, -0.000000, 0.201853, -0.000000, 0.979264}, 
%% {1.187006, -0.000000, -0.119507, -0.000000, 1.210637, -0.000000, 0.189163, -0.000000, 0.980955}, 
%% {1.154224, -0.000000, -0.113634, -0.000000, 1.175968, -0.000000, 0.176664, -0.000000, 0.982607}, 
%% {1.124796, -0.000000, -0.107264, -0.000000, 1.144261, -0.000000, 0.164540, -0.000000, 0.984309}, 
%% {1.097614, -0.000000, -0.100989, -0.000000, 1.115342, -0.000000, 0.152541, -0.000000, 0.985965}, 
%% {1.072936, -0.000000, -0.094520, -0.000000, 1.088902, -0.000000, 0.140942, -0.000000, 0.987584}, 
%% {1.050359, -0.000000, -0.087905, -0.000000, 1.064598, -0.000000, 0.129633, -0.000000, 0.989151}, 
%% {1.029423, -0.000000, -0.081404, -0.000000, 1.042803, -0.000000, 0.118591, -0.000000, 0.990622}, 
%% {1.010867, -0.000000, -0.074697, -0.000000, 1.022837, -0.000000, 0.107870, -0.000000, 0.992029}, 
%% {0.993533, -0.000000, -0.067993, -0.000000, 1.004483, -0.000000, 0.097428, -0.000000, 0.993333}, 
%% {0.977912, -0.000000, -0.061442, -0.000000, 0.987881, -0.000000, 0.087213, -0.000000, 0.994520}, 
%% {0.963760, -0.000000, -0.054851, -0.000000, 0.972715, -0.000000, 0.077284, -0.000000, 0.995601}, 
%% {0.950935, -0.000000, -0.048232, -0.000000, 0.958995, -0.000000, 0.067526, -0.000000, 0.996575}, 
%% {0.939558, -0.000000, -0.041767, -0.000000, 0.946497, -0.000000, 0.058128, -0.000000, 0.997416}, 
%% {0.929339, -0.000000, -0.035450, -0.000000, 0.935040, -0.000000, 0.048986, -0.000000, 0.998131}, 
%% {0.920089, -0.000000, -0.029148, -0.000000, 0.924589, -0.000000, 0.040111, -0.000000, 0.998729}, 
%% {0.911959, -0.000000, -0.022942, -0.000000, 0.915267, -0.000000, 0.031468, -0.000000, 0.999208}, 
%% {0.904588, -0.000000, -0.016918, -0.000000, 0.906695, -0.000000, 0.023038, -0.000000, 0.999569}, 
%% {0.897663, -0.000000, -0.011183, -0.000000, 0.898810, -0.000000, 0.015111, -0.000000, 0.999812}, 
%% {0.891216, -0.000000, -0.005498, -0.000000, 0.891704, -0.000000, 0.007366, -0.000000, 0.999955}, 
%% {0.885204, -0.000000, 0.000069, -0.000000, 0.885194, -0.000000, -0.000064, -0.000000, 1.000000}, 
%% {4756.022949, -0.000000, -0.216941, -0.000000, 4997.681641, -0.000000, 1085.527100, -0.000000, 0.950485}, 
%% {1886.252197, -0.000000, -0.216941, -0.000000, 1984.506592, -0.000000, 430.523010, -0.000000, 0.950485}, 
%% {471.561707, -0.000000, -0.216942, -0.000000, 496.143921, -0.000000, 107.629875, -0.000000, 0.950485}, 
%% {209.577057, -0.000000, -0.216941, -0.000000, 220.502975, -0.000000, 47.834389, -0.000000, 0.950485}, 
%% {117.895638, -0.000000, -0.216941, -0.000000, 124.028549, -0.000000, 26.908745, -0.000000, 0.950485}, 
%% {75.447891, -0.000000, -0.216939, -0.000000, 79.375359, -0.000000, 17.220392, -0.000000, 0.950485}, 
%% {52.394085, -0.000000, -0.216938, -0.000000, 55.124634, -0.000000, 11.958520, -0.000000, 0.950486}, 
%% {38.493565, -0.000000, -0.216934, -0.000000, 40.499187, -0.000000, 8.785729, -0.000000, 0.950487}, 
%% {29.471231, -0.000000, -0.216927, -0.000000, 31.004967, -0.000000, 6.726592, -0.000000, 0.950488}, 
%% {23.284920, -0.000000, -0.216920, -0.000000, 24.496374, -0.000000, 5.314565, -0.000000, 0.950490}, 
%% {18.859362, -0.000000, -0.216908, -0.000000, 19.840685, -0.000000, 4.304449, -0.000000, 0.950493}, 
%% {15.584422, -0.000000, -0.216894, -0.000000, 16.395594, -0.000000, 3.556954, -0.000000, 0.950497}, 
%% {13.094894, -0.000000, -0.216873, -0.000000, 13.775577, -0.000000, 2.988726, -0.000000, 0.950502}, 
%% {11.156427, -0.000000, -0.216847, -0.000000, 11.735943, -0.000000, 2.546271, -0.000000, 0.950508}, 
%% {9.618301, -0.000000, -0.216811, -0.000000, 10.117262, -0.000000, 2.195178, -0.000000, 0.950517}, 
%% {8.377152, -0.000000, -0.216758, -0.000000, 8.811425, -0.000000, 1.911890, -0.000000, 0.950530}, 
%% {7.361740, -0.000000, -0.216658, -0.000000, 7.742523, -0.000000, 1.680089, -0.000000, 0.950555}, 
%% {6.521036, -0.000000, -0.216301, -0.000000, 6.858025, -0.000000, 1.488135, -0.000000, 0.950639}, 
%% {5.828715, -0.000000, -0.213136, -0.000000, 6.129227, -0.000000, 1.329780, -0.000000, 0.951374}, 
%% {5.241576, -0.000000, -0.210948, -0.000000, 5.510902, -0.000000, 1.195441, -0.000000, 0.951889}, 
%% {4.738537, -0.000000, -0.210368, -0.000000, 4.981302, -0.000000, 1.080435, -0.000000, 0.952034}, 
%% {4.306695, -0.000000, -0.211406, -0.000000, 4.526598, -0.000000, 0.981876, -0.000000, 0.951802}, 
%% {3.935514, -0.000000, -0.214511, -0.000000, 4.135744, -0.000000, 0.897470, -0.000000, 0.951082}, 
%% {3.605841, -0.000000, -0.214322, -0.000000, 3.788457, -0.000000, 0.822081, -0.000000, 0.951138}, 
%% {3.318684, -0.000000, -0.211034, -0.000000, 3.485661, -0.000000, 0.755846, -0.000000, 0.951936}, 
%% {3.063712, -0.000000, -0.209018, -0.000000, 3.216919, -0.000000, 0.697070, -0.000000, 0.952443}, 
%% {2.839001, -0.000000, -0.207206, -0.000000, 2.979809, -0.000000, 0.645172, -0.000000, 0.952912}, 
%% {2.642467, -0.000000, -0.204618, -0.000000, 2.772262, -0.000000, 0.599430, -0.000000, 0.953583}, 
%% {2.467510, -0.000000, -0.203287, -0.000000, 2.587401, -0.000000, 0.558807, -0.000000, 0.953963}, 
%% {2.311938, -0.000000, -0.202456, -0.000000, 2.422878, -0.000000, 0.522635, -0.000000, 0.954233}, 
%% {2.171536, -0.000000, -0.199627, -0.000000, 2.274269, -0.000000, 0.489314, -0.000000, 0.955018}, 
%% {2.044531, -0.000000, -0.196352, -0.000000, 2.139443, -0.000000, 0.458812, -0.000000, 0.955937}, 
%% {1.931543, -0.000000, -0.193035, -0.000000, 2.019390, -0.000000, 0.431291, -0.000000, 0.956898}, 
%% {1.829751, -0.000000, -0.190385, -0.000000, 1.911193, -0.000000, 0.406325, -0.000000, 0.957722}, 
%% {1.737746, -0.000000, -0.186812, -0.000000, 1.813179, -0.000000, 0.383150, -0.000000, 0.958810}, 
%% {1.654127, -0.000000, -0.182341, -0.000000, 1.723626, -0.000000, 0.361346, -0.000000, 0.960167}, 
%% {1.578948, -0.000000, -0.178410, -0.000000, 1.642952, -0.000000, 0.341368, -0.000000, 0.961428}, 
%% {1.510997, -0.000000, -0.174027, -0.000000, 1.569827, -0.000000, 0.322534, -0.000000, 0.962853}, 
%% {1.449200, -0.000000, -0.168735, -0.000000, 1.502765, -0.000000, 0.304562, -0.000000, 0.964539}, 
%% {1.393358, -0.000000, -0.163844, -0.000000, 1.442309, -0.000000, 0.287669, -0.000000, 0.966173}, 
%% {1.342532, -0.000000, -0.158265, -0.000000, 1.386943, -0.000000, 0.271456, -0.000000, 0.967999}, 
%% {1.296584, -0.000000, -0.152486, -0.000000, 1.336458, -0.000000, 0.255811, -0.000000, 0.969915}, 
%% {1.254658, -0.000000, -0.146507, -0.000000, 1.290552, -0.000000, 0.240660, -0.000000, 0.971898}, 
%% {1.216444, -0.000000, -0.140127, -0.000000, 1.248499, -0.000000, 0.225883, -0.000000, 0.973980}, 
%% {1.181587, -0.000000, -0.133682, -0.000000, 1.210503, -0.000000, 0.211566, -0.000000, 0.976064}, 
%% {1.150015, -0.000000, -0.126914, -0.000000, 1.175515, -0.000000, 0.197617, -0.000000, 0.978191}, 
%% {1.120929, -0.000000, -0.120020, -0.000000, 1.143774, -0.000000, 0.183908, -0.000000, 0.980309}, 
%% {1.094484, -0.000000, -0.113025, -0.000000, 1.115035, -0.000000, 0.170694, -0.000000, 0.982373}, 
%% {1.070477, -0.000000, -0.105757, -0.000000, 1.088553, -0.000000, 0.157703, -0.000000, 0.984420}, 
%% {1.048007, -0.000000, -0.098583, -0.000000, 1.064649, -0.000000, 0.145007, -0.000000, 0.986360}, 
%% {1.027544, -0.000000, -0.091112, -0.000000, 1.042561, -0.000000, 0.132606, -0.000000, 0.988242}, 
%% {1.008641, -0.000000, -0.083681, -0.000000, 1.022567, -0.000000, 0.120548, -0.000000, 0.989999}, 
%% {0.991730, -0.000000, -0.076334, -0.000000, 1.004417, -0.000000, 0.108989, -0.000000, 0.991611}, 
%% {0.976169, -0.000000, -0.068837, -0.000000, 0.987779, -0.000000, 0.097492, -0.000000, 0.993125}, 
%% {0.962095, -0.000000, -0.061410, -0.000000, 0.972624, -0.000000, 0.086476, -0.000000, 0.994480}, 
%% {0.949471, -0.000000, -0.054158, -0.000000, 0.958778, -0.000000, 0.075664, -0.000000, 0.995684}, 
%% {0.938134, -0.000000, -0.046829, -0.000000, 0.946267, -0.000000, 0.065161, -0.000000, 0.996747}, 
%% {0.928004, -0.000000, -0.039659, -0.000000, 0.934899, -0.000000, 0.054929, -0.000000, 0.997653}, 
%% {0.919027, -0.000000, -0.032637, -0.000000, 0.924533, -0.000000, 0.044935, -0.000000, 0.998404}, 
%% {0.910977, -0.000000, -0.025834, -0.000000, 0.915047, -0.000000, 0.035318, -0.000000, 0.998998}, 
%% {0.903768, -0.000000, -0.019079, -0.000000, 0.906413, -0.000000, 0.025979, -0.000000, 0.999452}, 
%% {0.897067, -0.000000, -0.012477, -0.000000, 0.898617, -0.000000, 0.016940, -0.000000, 0.999764}, 
%% {0.890731, -0.000000, -0.006095, -0.000000, 0.891390, -0.000000, 0.008252, -0.000000, 0.999943}, 
%% {0.884827, -0.000000, 0.000055, -0.000000, 0.884812, -0.000000, -0.000005, -0.000000, 1.000000}, 
%% {4698.489746, -0.000000, -0.239126, -0.000000, 4999.362793, -0.000000, 1196.378540, -0.000000, 0.939111}, 
%% {1863.748291, -0.000000, -0.239127, -0.000000, 1984.282593, -0.000000, 474.566620, -0.000000, 0.939111}, 
%% {465.912476, -0.000000, -0.239126, -0.000000, 496.141846, -0.000000, 118.635406, -0.000000, 0.939111}, 
%% {207.067383, -0.000000, -0.239125, -0.000000, 220.513367, -0.000000, 52.725647, -0.000000, 0.939111}, 
%% {116.477470, -0.000000, -0.239125, -0.000000, 124.031639, -0.000000, 29.658630, -0.000000, 0.939112}, 
%% {74.546082, -0.000000, -0.239123, -0.000000, 79.380112, -0.000000, 18.981667, -0.000000, 0.939112}, 
%% {51.771275, -0.000000, -0.239120, -0.000000, 55.115673, -0.000000, 13.182592, -0.000000, 0.939112}, 
%% {38.028950, -0.000000, -0.239116, -0.000000, 40.499554, -0.000000, 9.683391, -0.000000, 0.939114}, 
%% {29.119228, -0.000000, -0.239108, -0.000000, 31.005880, -0.000000, 7.414641, -0.000000, 0.939116}, 
%% {23.005892, -0.000000, -0.239097, -0.000000, 24.496319, -0.000000, 5.857946, -0.000000, 0.939119}, 
%% {18.634071, -0.000000, -0.239083, -0.000000, 19.840717, -0.000000, 4.744730, -0.000000, 0.939123}, 
%% {15.398772, -0.000000, -0.239062, -0.000000, 16.395649, -0.000000, 3.920905, -0.000000, 0.939129}, 
%% {12.938627, -0.000000, -0.239034, -0.000000, 13.774725, -0.000000, 3.294450, -0.000000, 0.939137}, 
%% {11.022935, -0.000000, -0.239000, -0.000000, 11.735811, -0.000000, 2.806651, -0.000000, 0.939146}, 
%% {9.503198, -0.000000, -0.238953, -0.000000, 10.117325, -0.000000, 2.419634, -0.000000, 0.939160}, 
%% {8.277235, -0.000000, -0.238885, -0.000000, 8.811238, -0.000000, 2.107434, -0.000000, 0.939179}, 
%% {7.274002, -0.000000, -0.238756, -0.000000, 7.742593, -0.000000, 1.851948, -0.000000, 0.939213}, 
%% {6.444200, -0.000000, -0.238236, -0.000000, 6.858872, -0.000000, 1.640561, -0.000000, 0.939350}, 
%% {5.761613, -0.000000, -0.234808, -0.000000, 6.131126, -0.000000, 1.466363, -0.000000, 0.940240}, 
%% {5.179490, -0.000000, -0.233019, -0.000000, 5.510721, -0.000000, 1.317853, -0.000000, 0.940711}, 
%% {4.681458, -0.000000, -0.232398, -0.000000, 4.979886, -0.000000, 1.190823, -0.000000, 0.940885}, 
%% {4.253937, -0.000000, -0.233014, -0.000000, 4.524267, -0.000000, 1.081878, -0.000000, 0.940739}, 
%% {3.886605, -0.000000, -0.235287, -0.000000, 4.132598, -0.000000, 0.988544, -0.000000, 0.940156}, 
%% {3.565106, -0.000000, -0.235700, -0.000000, 3.789755, -0.000000, 0.906594, -0.000000, 0.940062}, 
%% {3.280674, -0.000000, -0.232681, -0.000000, 3.486125, -0.000000, 0.833486, -0.000000, 0.940885}, 
%% {3.028429, -0.000000, -0.230726, -0.000000, 3.216840, -0.000000, 0.768668, -0.000000, 0.941438}, 
%% {2.806787, -0.000000, -0.228490, -0.000000, 2.979982, -0.000000, 0.711468, -0.000000, 0.942082}, 
%% {2.612601, -0.000000, -0.225562, -0.000000, 2.772145, -0.000000, 0.661002, -0.000000, 0.942932}, 
%% {2.439210, -0.000000, -0.223896, -0.000000, 2.586673, -0.000000, 0.616043, -0.000000, 0.943453}, 
%% {2.286111, -0.000000, -0.222279, -0.000000, 2.422292, -0.000000, 0.576118, -0.000000, 0.943984}, 
%% {2.148224, -0.000000, -0.220351, -0.000000, 2.274337, -0.000000, 0.539899, -0.000000, 0.944621}, 
%% {2.022952, -0.000000, -0.216399, -0.000000, 2.139636, -0.000000, 0.506221, -0.000000, 0.945849}, 
%% {1.910877, -0.000000, -0.212737, -0.000000, 2.019055, -0.000000, 0.475700, -0.000000, 0.947040}, 
%% {1.810982, -0.000000, -0.209278, -0.000000, 1.910769, -0.000000, 0.448165, -0.000000, 0.948210}, 
%% {1.720537, -0.000000, -0.206003, -0.000000, 1.813005, -0.000000, 0.422868, -0.000000, 0.949369}, 
%% {1.638539, -0.000000, -0.201066, -0.000000, 1.723465, -0.000000, 0.398899, -0.000000, 0.951051}, 
%% {1.564997, -0.000000, -0.196307, -0.000000, 1.642687, -0.000000, 0.376803, -0.000000, 0.952735}, 
%% {1.498131, -0.000000, -0.191750, -0.000000, 1.569668, -0.000000, 0.356165, -0.000000, 0.954413}, 
%% {1.437748, -0.000000, -0.186114, -0.000000, 1.502798, -0.000000, 0.336330, -0.000000, 0.956463}, 
%% {1.383270, -0.000000, -0.180390, -0.000000, 1.441755, -0.000000, 0.317655, -0.000000, 0.958575}, 
%% {1.333719, -0.000000, -0.174625, -0.000000, 1.386658, -0.000000, 0.299859, -0.000000, 0.960739}, 
%% {1.288759, -0.000000, -0.168044, -0.000000, 1.336026, -0.000000, 0.282424, -0.000000, 0.963174}, 
%% {1.247939, -0.000000, -0.161658, -0.000000, 1.290018, -0.000000, 0.265767, -0.000000, 0.965572}, 
%% {1.210817, -0.000000, -0.154608, -0.000000, 1.248079, -0.000000, 0.249485, -0.000000, 0.968144}, 
%% {1.176588, -0.000000, -0.147611, -0.000000, 1.210182, -0.000000, 0.233642, -0.000000, 0.970688}, 
%% {1.145663, -0.000000, -0.140104, -0.000000, 1.175220, -0.000000, 0.218216, -0.000000, 0.973314}, 
%% {1.117333, -0.000000, -0.132650, -0.000000, 1.143766, -0.000000, 0.203063, -0.000000, 0.975892}, 
%% {1.091276, -0.000000, -0.124758, -0.000000, 1.114609, -0.000000, 0.188338, -0.000000, 0.978469}, 
%% {1.067458, -0.000000, -0.116979, -0.000000, 1.088459, -0.000000, 0.173904, -0.000000, 0.980942}, 
%% {1.045443, -0.000000, -0.108823, -0.000000, 1.064392, -0.000000, 0.159993, -0.000000, 0.983346}, 
%% {1.025709, -0.000000, -0.100711, -0.000000, 1.042468, -0.000000, 0.146445, -0.000000, 0.985621}, 
%% {1.006969, -0.000000, -0.092604, -0.000000, 1.022517, -0.000000, 0.133238, -0.000000, 0.987747}, 
%% {0.990071, -0.000000, -0.084313, -0.000000, 1.004305, -0.000000, 0.120247, -0.000000, 0.989760}, 
%% {0.974494, -0.000000, -0.076146, -0.000000, 0.987647, -0.000000, 0.107708, -0.000000, 0.991584}, 
%% {0.960654, -0.000000, -0.068011, -0.000000, 0.972500, -0.000000, 0.095525, -0.000000, 0.993237}, 
%% {0.947908, -0.000000, -0.059840, -0.000000, 0.958684, -0.000000, 0.083565, -0.000000, 0.994725}, 
%% {0.936627, -0.000000, -0.051846, -0.000000, 0.946097, -0.000000, 0.072074, -0.000000, 0.996010}, 
%% {0.926600, -0.000000, -0.044034, -0.000000, 0.934729, -0.000000, 0.060799, -0.000000, 0.997111}, 
%% {0.917680, -0.000000, -0.036200, -0.000000, 0.924290, -0.000000, 0.049839, -0.000000, 0.998034}, 
%% {0.909970, -0.000000, -0.028536, -0.000000, 0.914834, -0.000000, 0.039081, -0.000000, 0.998775}, 
%% {0.902914, -0.000000, -0.021121, -0.000000, 0.906263, -0.000000, 0.028712, -0.000000, 0.999328}, 
%% {0.896412, -0.000000, -0.013860, -0.000000, 0.898310, -0.000000, 0.018774, -0.000000, 0.999710}, 
%% {0.890278, -0.000000, -0.006757, -0.000000, 0.891042, -0.000000, 0.009159, -0.000000, 0.999931}, 
%% {0.884333, -0.000000, 0.000092, -0.000000, 0.884361, -0.000000, -0.000021, -0.000000, 1.000000}, 
%% {4634.525391, -0.000000, -0.260717, -0.000000, 4999.282715, -0.000000, 1303.949829, -0.000000, 0.926646}, 
%% {1838.814453, -0.000000, -0.260717, -0.000000, 1984.563843, -0.000000, 517.360046, -0.000000, 0.926646}, 
%% {459.763245, -0.000000, -0.260716, -0.000000, 496.150696, -0.000000, 129.356781, -0.000000, 0.926646}, 
%% {204.341309, -0.000000, -0.260716, -0.000000, 220.488190, -0.000000, 57.492714, -0.000000, 0.926646}, 
%% {114.915451, -0.000000, -0.260715, -0.000000, 124.019135, -0.000000, 32.332031, -0.000000, 0.926646}, 
%% {73.557358, -0.000000, -0.260712, -0.000000, 79.379486, -0.000000, 20.695711, -0.000000, 0.926647}, 
%% {51.075798, -0.000000, -0.260709, -0.000000, 55.128025, -0.000000, 14.370454, -0.000000, 0.926648}, 
%% {37.529716, -0.000000, -0.260703, -0.000000, 40.497692, -0.000000, 10.559114, -0.000000, 0.926651}, 
%% {28.729788, -0.000000, -0.260693, -0.000000, 31.006384, -0.000000, 8.083236, -0.000000, 0.926653}, 
%% {22.699722, -0.000000, -0.260678, -0.000000, 24.497355, -0.000000, 6.386628, -0.000000, 0.926657}, 
%% {18.386368, -0.000000, -0.260659, -0.000000, 19.840252, -0.000000, 5.172996, -0.000000, 0.926664}, 
%% {15.194602, -0.000000, -0.260632, -0.000000, 16.395025, -0.000000, 4.274954, -0.000000, 0.926672}, 
%% {12.766603, -0.000000, -0.260597, -0.000000, 13.775218, -0.000000, 3.591794, -0.000000, 0.926683}, 
%% {10.876300, -0.000000, -0.260552, -0.000000, 11.735199, -0.000000, 3.059894, -0.000000, 0.926697}, 
%% {9.377511, -0.000000, -0.260492, -0.000000, 10.116866, -0.000000, 2.638198, -0.000000, 0.926715}, 
%% {8.167710, -0.000000, -0.260406, -0.000000, 8.811175, -0.000000, 2.297783, -0.000000, 0.926741}, 
%% {7.178084, -0.000000, -0.260239, -0.000000, 7.742525, -0.000000, 2.019300, -0.000000, 0.926791}, 
%% {6.360451, -0.000000, -0.259444, -0.000000, 6.860015, -0.000000, 1.789111, -0.000000, 0.927022}, 
%% {5.686972, -0.000000, -0.256049, -0.000000, 6.132348, -0.000000, 1.599223, -0.000000, 0.927997}, 
%% {5.111248, -0.000000, -0.254496, -0.000000, 5.510628, -0.000000, 1.436960, -0.000000, 0.928452}, 
%% {4.619206, -0.000000, -0.253840, -0.000000, 4.978783, -0.000000, 1.298288, -0.000000, 0.928655}, 
%% {4.196706, -0.000000, -0.254115, -0.000000, 4.522277, -0.000000, 1.179301, -0.000000, 0.928592}, 
%% {3.833700, -0.000000, -0.255567, -0.000000, 4.129874, -0.000000, 1.077184, -0.000000, 0.928191}, 
%% {3.520988, -0.000000, -0.256225, -0.000000, 3.791748, -0.000000, 0.989134, -0.000000, 0.928020}, 
%% {3.239011, -0.000000, -0.253774, -0.000000, 3.486498, -0.000000, 0.909155, -0.000000, 0.928768}, 
%% {2.989972, -0.000000, -0.251758, -0.000000, 3.216900, -0.000000, 0.838443, -0.000000, 0.929402}, 
%% {2.771847, -0.000000, -0.249038, -0.000000, 2.980526, -0.000000, 0.776174, -0.000000, 0.930264}, 
%% {2.579722, -0.000000, -0.246091, -0.000000, 2.771861, -0.000000, 0.721066, -0.000000, 0.931215}, 
%% {2.408545, -0.000000, -0.243962, -0.000000, 2.585854, -0.000000, 0.671891, -0.000000, 0.931944}, 
%% {2.257546, -0.000000, -0.241653, -0.000000, 2.421714, -0.000000, 0.628237, -0.000000, 0.932752}, 
%% {2.121915, -0.000000, -0.239953, -0.000000, 2.274057, -0.000000, 0.588932, -0.000000, 0.933402}, 
%% {1.999430, -0.000000, -0.235952, -0.000000, 2.139816, -0.000000, 0.552465, -0.000000, 0.934804}, 
%% {1.888744, -0.000000, -0.231924, -0.000000, 2.018795, -0.000000, 0.519153, -0.000000, 0.936252}, 
%% {1.790387, -0.000000, -0.227877, -0.000000, 1.910409, -0.000000, 0.489049, -0.000000, 0.937755}, 
%% {1.701969, -0.000000, -0.224101, -0.000000, 1.812463, -0.000000, 0.461533, -0.000000, 0.939229}, 
%% {1.621583, -0.000000, -0.219388, -0.000000, 1.723336, -0.000000, 0.435599, -0.000000, 0.941067}, 
%% {1.549339, -0.000000, -0.213909, -0.000000, 1.642210, -0.000000, 0.411457, -0.000000, 0.943192}, 
%% {1.484580, -0.000000, -0.208680, -0.000000, 1.568980, -0.000000, 0.389039, -0.000000, 0.945315}, 
%% {1.425934, -0.000000, -0.203102, -0.000000, 1.502166, -0.000000, 0.367615, -0.000000, 0.947639}, 
%% {1.372911, -0.000000, -0.196652, -0.000000, 1.441431, -0.000000, 0.347251, -0.000000, 0.950261}, 
%% {1.324620, -0.000000, -0.190370, -0.000000, 1.386116, -0.000000, 0.327730, -0.000000, 0.952900}, 
%% {1.281488, -0.000000, -0.183403, -0.000000, 1.335793, -0.000000, 0.308840, -0.000000, 0.955800}, 
%% {1.241475, -0.000000, -0.176258, -0.000000, 1.289631, -0.000000, 0.290253, -0.000000, 0.958791}, 
%% {1.205188, -0.000000, -0.168863, -0.000000, 1.247718, -0.000000, 0.272635, -0.000000, 0.961800}, 
%% {1.171936, -0.000000, -0.160999, -0.000000, 1.209877, -0.000000, 0.255230, -0.000000, 0.964937}, 
%% {1.141902, -0.000000, -0.153151, -0.000000, 1.174850, -0.000000, 0.238369, -0.000000, 0.968030}, 
%% {1.113898, -0.000000, -0.144790, -0.000000, 1.143300, -0.000000, 0.221529, -0.000000, 0.971205}, 
%% {1.088599, -0.000000, -0.136428, -0.000000, 1.114494, -0.000000, 0.205531, -0.000000, 0.974242}, 
%% {1.064589, -0.000000, -0.127758, -0.000000, 1.088088, -0.000000, 0.190022, -0.000000, 0.977196}, 
%% {1.043106, -0.000000, -0.119018, -0.000000, 1.064071, -0.000000, 0.174685, -0.000000, 0.980069}, 
%% {1.023157, -0.000000, -0.110243, -0.000000, 1.042445, -0.000000, 0.159840, -0.000000, 0.982778}, 
%% {1.005022, -0.000000, -0.101254, -0.000000, 1.022472, -0.000000, 0.145442, -0.000000, 0.985347}, 
%% {0.988366, -0.000000, -0.092406, -0.000000, 1.004142, -0.000000, 0.131480, -0.000000, 0.987707}, 
%% {0.972829, -0.000000, -0.083398, -0.000000, 0.987479, -0.000000, 0.117667, -0.000000, 0.989913}, 
%% {0.959066, -0.000000, -0.074449, -0.000000, 0.972385, -0.000000, 0.104484, -0.000000, 0.991889}, 
%% {0.946392, -0.000000, -0.065656, -0.000000, 0.958599, -0.000000, 0.091495, -0.000000, 0.993652}, 
%% {0.935109, -0.000000, -0.056861, -0.000000, 0.945989, -0.000000, 0.078876, -0.000000, 0.995204}, 
%% {0.925126, -0.000000, -0.048155, -0.000000, 0.934465, -0.000000, 0.066575, -0.000000, 0.996535}, 
%% {0.916410, -0.000000, -0.039684, -0.000000, 0.924107, -0.000000, 0.054555, -0.000000, 0.997638}, 
%% {0.908769, -0.000000, -0.031314, -0.000000, 0.914582, -0.000000, 0.042834, -0.000000, 0.998524}, 
%% {0.902045, -0.000000, -0.023126, -0.000000, 0.905973, -0.000000, 0.031470, -0.000000, 0.999193}, 
%% {0.895701, -0.000000, -0.015166, -0.000000, 0.898040, -0.000000, 0.020555, -0.000000, 0.999652}, 
%% {0.889747, -0.000000, -0.007507, -0.000000, 0.890658, -0.000000, 0.010130, -0.000000, 0.999915}, 
%% {0.883913, -0.000000, 0.000077, -0.000000, 0.883871, -0.000000, -0.000086, -0.000000, 1.000000}, 
%% {4569.099121, -0.000000, -0.281659, -0.000000, 4998.434570, -0.000000, 1409.374634, -0.000000, 0.913120}, 
%% {1812.375610, -0.000000, -0.281659, -0.000000, 1984.300537, -0.000000, 559.041504, -0.000000, 0.913120}, 
%% {453.042511, -0.000000, -0.281659, -0.000000, 496.108398, -0.000000, 139.744522, -0.000000, 0.913120}, 
%% {201.342468, -0.000000, -0.281658, -0.000000, 220.511688, -0.000000, 62.105675, -0.000000, 0.913120}, 
%% {113.243378, -0.000000, -0.281656, -0.000000, 124.052650, -0.000000, 34.930504, -0.000000, 0.913122}, 
%% {72.484123, -0.000000, -0.281654, -0.000000, 79.376740, -0.000000, 22.358278, -0.000000, 0.913122}, 
%% {50.334751, -0.000000, -0.281648, -0.000000, 55.123760, -0.000000, 15.526111, -0.000000, 0.913124}, 
%% {36.980915, -0.000000, -0.281641, -0.000000, 40.498558, -0.000000, 11.407036, -0.000000, 0.913126}, 
%% {28.312231, -0.000000, -0.281628, -0.000000, 31.004860, -0.000000, 8.733065, -0.000000, 0.913130}, 
%% {22.368689, -0.000000, -0.281610, -0.000000, 24.496292, -0.000000, 6.899683, -0.000000, 0.913137}, 
%% {18.118362, -0.000000, -0.281585, -0.000000, 19.840794, -0.000000, 5.588635, -0.000000, 0.913145}, 
%% {14.973516, -0.000000, -0.281551, -0.000000, 16.394733, -0.000000, 4.618548, -0.000000, 0.913156}, 
%% {12.581041, -0.000000, -0.281507, -0.000000, 13.774975, -0.000000, 3.880543, -0.000000, 0.913171}, 
%% {10.718561, -0.000000, -0.281450, -0.000000, 11.735633, -0.000000, 3.306010, -0.000000, 0.913190}, 
%% {9.241011, -0.000000, -0.281374, -0.000000, 10.116872, -0.000000, 2.850195, -0.000000, 0.913216}, 
%% {8.049077, -0.000000, -0.281267, -0.000000, 8.810888, -0.000000, 2.482485, -0.000000, 0.913252}, 
%% {7.073901, -0.000000, -0.281054, -0.000000, 7.742586, -0.000000, 2.181615, -0.000000, 0.913322}, 
%% {6.270868, -0.000000, -0.279742, -0.000000, 6.862442, -0.000000, 1.933716, -0.000000, 0.913737}, 
%% {5.605535, -0.000000, -0.276700, -0.000000, 6.133276, -0.000000, 1.728104, -0.000000, 0.914697}, 
%% {5.037077, -0.000000, -0.275356, -0.000000, 5.509941, -0.000000, 1.552476, -0.000000, 0.915133}, 
%% {4.551649, -0.000000, -0.274630, -0.000000, 4.977703, -0.000000, 1.402511, -0.000000, 0.915378}, 
%% {4.134848, -0.000000, -0.274611, -0.000000, 4.520424, -0.000000, 1.273726, -0.000000, 0.915407}, 
%% {3.776987, -0.000000, -0.275271, -0.000000, 4.127620, -0.000000, 1.163253, -0.000000, 0.915221}, 
%% {3.470846, -0.000000, -0.275769, -0.000000, 3.791516, -0.000000, 1.068679, -0.000000, 0.915091}, 
%% {3.193407, -0.000000, -0.274257, -0.000000, 3.486772, -0.000000, 0.982572, -0.000000, 0.915615}, 
%% {2.948283, -0.000000, -0.272051, -0.000000, 3.217240, -0.000000, 0.906241, -0.000000, 0.916377}, 
%% {2.734239, -0.000000, -0.268792, -0.000000, 2.981269, -0.000000, 0.839153, -0.000000, 0.917506}, 
%% {2.544007, -0.000000, -0.266031, -0.000000, 2.771493, -0.000000, 0.779417, -0.000000, 0.918495}, 
%% {2.375653, -0.000000, -0.263324, -0.000000, 2.585753, -0.000000, 0.726262, -0.000000, 0.919499}, 
%% {2.226684, -0.000000, -0.260660, -0.000000, 2.420916, -0.000000, 0.678930, -0.000000, 0.920523}, 
%% {2.093501, -0.000000, -0.258550, -0.000000, 2.273288, -0.000000, 0.636459, -0.000000, 0.921397}, 
%% {1.973730, -0.000000, -0.255095, -0.000000, 2.139910, -0.000000, 0.597612, -0.000000, 0.922761}, 
%% {1.865132, -0.000000, -0.250460, -0.000000, 2.018603, -0.000000, 0.561599, -0.000000, 0.924586}, 
%% {1.768196, -0.000000, -0.246032, -0.000000, 1.909845, -0.000000, 0.528941, -0.000000, 0.926402}, 
%% {1.682228, -0.000000, -0.241633, -0.000000, 1.811834, -0.000000, 0.499327, -0.000000, 0.928278}, 
%% {1.604277, -0.000000, -0.237070, -0.000000, 1.723107, -0.000000, 0.471772, -0.000000, 0.930285}, 
%% {1.533497, -0.000000, -0.231135, -0.000000, 1.641793, -0.000000, 0.445510, -0.000000, 0.932851}, 
%% {1.470740, -0.000000, -0.225270, -0.000000, 1.568381, -0.000000, 0.421256, -0.000000, 0.935477}, 
%% {1.414104, -0.000000, -0.219383, -0.000000, 1.501876, -0.000000, 0.398154, -0.000000, 0.938231}, 
%% {1.362775, -0.000000, -0.212516, -0.000000, 1.440740, -0.000000, 0.376159, -0.000000, 0.941340}, 
%% {1.316004, -0.000000, -0.205528, -0.000000, 1.385334, -0.000000, 0.354824, -0.000000, 0.944585}, 
%% {1.274154, -0.000000, -0.198492, -0.000000, 1.334990, -0.000000, 0.334505, -0.000000, 0.947890}, 
%% {1.235351, -0.000000, -0.190546, -0.000000, 1.289102, -0.000000, 0.314532, -0.000000, 0.951485}, 
%% {1.200505, -0.000000, -0.182707, -0.000000, 1.247471, -0.000000, 0.295333, -0.000000, 0.955053}, 
%% {1.167648, -0.000000, -0.174279, -0.000000, 1.209638, -0.000000, 0.276339, -0.000000, 0.958755}, 
%% {1.138345, -0.000000, -0.165748, -0.000000, 1.175136, -0.000000, 0.258121, -0.000000, 0.962416}, 
%% {1.110742, -0.000000, -0.156821, -0.000000, 1.143386, -0.000000, 0.240104, -0.000000, 0.966101}, 
%% {1.085729, -0.000000, -0.147808, -0.000000, 1.114484, -0.000000, 0.222506, -0.000000, 0.969709}, 
%% {1.062395, -0.000000, -0.138464, -0.000000, 1.088307, -0.000000, 0.205705, -0.000000, 0.973190}, 
%% {1.040980, -0.000000, -0.129123, -0.000000, 1.064161, -0.000000, 0.189204, -0.000000, 0.976531}, 
%% {1.021135, -0.000000, -0.119484, -0.000000, 1.042023, -0.000000, 0.172918, -0.000000, 0.979767}, 
%% {1.003220, -0.000000, -0.109970, -0.000000, 1.022152, -0.000000, 0.157380, -0.000000, 0.982748}, 
%% {0.986615, -0.000000, -0.100202, -0.000000, 1.003914, -0.000000, 0.142357, -0.000000, 0.985542}, 
%% {0.971497, -0.000000, -0.090508, -0.000000, 0.987474, -0.000000, 0.127625, -0.000000, 0.988110}, 
%% {0.957479, -0.000000, -0.080896, -0.000000, 0.972274, -0.000000, 0.113291, -0.000000, 0.990428}, 
%% {0.944948, -0.000000, -0.071228, -0.000000, 0.958422, -0.000000, 0.099185, -0.000000, 0.992524}, 
%% {0.933688, -0.000000, -0.061724, -0.000000, 0.945879, -0.000000, 0.085640, -0.000000, 0.994338}, 
%% {0.923804, -0.000000, -0.052381, -0.000000, 0.934420, -0.000000, 0.072270, -0.000000, 0.995902}, 
%% {0.915079, -0.000000, -0.043106, -0.000000, 0.923921, -0.000000, 0.059294, -0.000000, 0.997207}, 
%% {0.907644, -0.000000, -0.034007, -0.000000, 0.914376, -0.000000, 0.046576, -0.000000, 0.998255}, 
%% {0.901019, -0.000000, -0.025220, -0.000000, 0.905654, -0.000000, 0.034297, -0.000000, 0.999040}, 
%% {0.894993, -0.000000, -0.016525, -0.000000, 0.897611, -0.000000, 0.022382, -0.000000, 0.999587}, 
%% {0.889110, -0.000000, -0.008063, -0.000000, 0.890195, -0.000000, 0.010892, -0.000000, 0.999901}, 
%% {0.883361, -0.000000, 0.000082, -0.000000, 0.883347, -0.000000, -0.000063, -0.000000, 1.000000}, 
%% {4493.072266, -0.000000, -0.301900, -0.000000, 4998.630859, -0.000000, 1509.585571, -0.000000, 0.898567}, 
%% {1783.309204, -0.000000, -0.301901, -0.000000, 1984.577881, -0.000000, 599.157715, -0.000000, 0.898567}, 
%% {445.816284, -0.000000, -0.301901, -0.000000, 496.097687, -0.000000, 149.785629, -0.000000, 0.898567}, 
%% {198.207748, -0.000000, -0.301901, -0.000000, 220.448517, -0.000000, 66.594330, -0.000000, 0.898567}, 
%% {111.444000, -0.000000, -0.301899, -0.000000, 124.018829, -0.000000, 37.442818, -0.000000, 0.898568}, 
%% {71.326462, -0.000000, -0.301896, -0.000000, 79.380272, -0.000000, 23.964279, -0.000000, 0.898569}, 
%% {49.533020, -0.000000, -0.301889, -0.000000, 55.123371, -0.000000, 16.642094, -0.000000, 0.898571}, 
%% {36.389629, -0.000000, -0.301879, -0.000000, 40.497162, -0.000000, 12.226123, -0.000000, 0.898575}, 
%% {27.861582, -0.000000, -0.301863, -0.000000, 31.005453, -0.000000, 9.360824, -0.000000, 0.898581}, 
%% {22.011271, -0.000000, -0.301840, -0.000000, 24.497763, -0.000000, 7.395206, -0.000000, 0.898590}, 
%% {17.830238, -0.000000, -0.301809, -0.000000, 19.840483, -0.000000, 5.990450, -0.000000, 0.898601}, 
%% {14.733609, -0.000000, -0.301767, -0.000000, 16.395824, -0.000000, 4.950044, -0.000000, 0.898615}, 
%% {12.380187, -0.000000, -0.301712, -0.000000, 13.775068, -0.000000, 4.159273, -0.000000, 0.898636}, 
%% {10.547812, -0.000000, -0.301640, -0.000000, 11.735428, -0.000000, 3.543593, -0.000000, 0.898662}, 
%% {9.094121, -0.000000, -0.301548, -0.000000, 10.116788, -0.000000, 3.055107, -0.000000, 0.898697}, 
%% {7.921205, -0.000000, -0.301416, -0.000000, 8.810952, -0.000000, 2.660974, -0.000000, 0.898745}, 
%% {6.961950, -0.000000, -0.301139, -0.000000, 7.742708, -0.000000, 2.338592, -0.000000, 0.898844}, 
%% {6.175708, -0.000000, -0.298977, -0.000000, 6.866799, -0.000000, 2.074155, -0.000000, 0.899587}, 
%% {5.517373, -0.000000, -0.296756, -0.000000, 6.133516, -0.000000, 1.852628, -0.000000, 0.900355}, 
%% {4.957360, -0.000000, -0.295496, -0.000000, 5.509331, -0.000000, 1.664168, -0.000000, 0.900803}, 
%% {4.479346, -0.000000, -0.294714, -0.000000, 4.976468, -0.000000, 1.503295, -0.000000, 0.901092}, 
%% {4.068900, -0.000000, -0.294428, -0.000000, 4.518735, -0.000000, 1.365135, -0.000000, 0.901218}, 
%% {3.717077, -0.000000, -0.294332, -0.000000, 4.126360, -0.000000, 1.246691, -0.000000, 0.901282}, 
%% {3.415244, -0.000000, -0.294437, -0.000000, 3.789503, -0.000000, 1.145032, -0.000000, 0.901284}, 
%% {3.144497, -0.000000, -0.293983, -0.000000, 3.487013, -0.000000, 1.053686, -0.000000, 0.901490}, 
%% {2.903744, -0.000000, -0.291553, -0.000000, 3.217619, -0.000000, 0.971990, -0.000000, 0.902406}, 
%% {2.693034, -0.000000, -0.288119, -0.000000, 2.981641, -0.000000, 0.900033, -0.000000, 0.903708}, 
%% {2.505665, -0.000000, -0.285256, -0.000000, 2.771510, -0.000000, 0.835888, -0.000000, 0.904839}, 
%% {2.340447, -0.000000, -0.281937, -0.000000, 2.585788, -0.000000, 0.778967, -0.000000, 0.906163}, 
%% {2.193456, -0.000000, -0.279106, -0.000000, 2.420294, -0.000000, 0.728071, -0.000000, 0.907357}, 
%% {2.063151, -0.000000, -0.276311, -0.000000, 2.272830, -0.000000, 0.682595, -0.000000, 0.908582}, 
%% {1.946185, -0.000000, -0.273432, -0.000000, 2.139954, -0.000000, 0.641342, -0.000000, 0.909894}, 
%% {1.840195, -0.000000, -0.268436, -0.000000, 2.018611, -0.000000, 0.602881, -0.000000, 0.912055}, 
%% {1.745209, -0.000000, -0.263522, -0.000000, 1.909611, -0.000000, 0.567873, -0.000000, 0.914253}, 
%% {1.661262, -0.000000, -0.258680, -0.000000, 1.811344, -0.000000, 0.536069, -0.000000, 0.916527}, 
%% {1.586048, -0.000000, -0.253757, -0.000000, 1.722462, -0.000000, 0.506715, -0.000000, 0.918929}, 
%% {1.517896, -0.000000, -0.247779, -0.000000, 1.641190, -0.000000, 0.478930, -0.000000, 0.921820}, 
%% {1.456943, -0.000000, -0.241367, -0.000000, 1.567765, -0.000000, 0.452876, -0.000000, 0.924973}, 
%% {1.402109, -0.000000, -0.235001, -0.000000, 1.500910, -0.000000, 0.428172, -0.000000, 0.928236}, 
%% {1.352844, -0.000000, -0.228125, -0.000000, 1.440240, -0.000000, 0.404576, -0.000000, 0.931778}, 
%% {1.307478, -0.000000, -0.220413, -0.000000, 1.384973, -0.000000, 0.381736, -0.000000, 0.935648}, 
%% {1.266933, -0.000000, -0.212796, -0.000000, 1.334902, -0.000000, 0.359832, -0.000000, 0.939562}, 
%% {1.229095, -0.000000, -0.204570, -0.000000, 1.289233, -0.000000, 0.338583, -0.000000, 0.943646}, 
%% {1.194881, -0.000000, -0.195988, -0.000000, 1.247866, -0.000000, 0.317906, -0.000000, 0.947856}, 
%% {1.163694, -0.000000, -0.187314, -0.000000, 1.210137, -0.000000, 0.297614, -0.000000, 0.952094}, 
%% {1.134211, -0.000000, -0.177953, -0.000000, 1.175247, -0.000000, 0.277704, -0.000000, 0.956429}, 
%% {1.107669, -0.000000, -0.168656, -0.000000, 1.143450, -0.000000, 0.258601, -0.000000, 0.960625}, 
%% {1.082926, -0.000000, -0.158816, -0.000000, 1.114726, -0.000000, 0.239465, -0.000000, 0.964881}, 
%% {1.060281, -0.000000, -0.149048, -0.000000, 1.088493, -0.000000, 0.221125, -0.000000, 0.968916}, 
%% {1.038776, -0.000000, -0.138822, -0.000000, 1.064239, -0.000000, 0.203363, -0.000000, 0.972822}, 
%% {1.019633, -0.000000, -0.128698, -0.000000, 1.042494, -0.000000, 0.186001, -0.000000, 0.976523}, 
%% {1.001109, -0.000000, -0.118295, -0.000000, 1.022426, -0.000000, 0.169039, -0.000000, 0.980026}, 
%% {0.984935, -0.000000, -0.107907, -0.000000, 1.004086, -0.000000, 0.152922, -0.000000, 0.983246}, 
%% {0.969948, -0.000000, -0.097540, -0.000000, 0.987237, -0.000000, 0.137146, -0.000000, 0.986208}, 
%% {0.956041, -0.000000, -0.087061, -0.000000, 0.972290, -0.000000, 0.121715, -0.000000, 0.988916}, 
%% {0.943282, -0.000000, -0.076847, -0.000000, 0.958322, -0.000000, 0.106675, -0.000000, 0.991309}, 
%% {0.932211, -0.000000, -0.066619, -0.000000, 0.945773, -0.000000, 0.092176, -0.000000, 0.993413}, 
%% {0.922230, -0.000000, -0.056477, -0.000000, 0.934280, -0.000000, 0.077899, -0.000000, 0.995229}, 
%% {0.913753, -0.000000, -0.046583, -0.000000, 0.923611, -0.000000, 0.063908, -0.000000, 0.996742}, 
%% {0.906331, -0.000000, -0.036751, -0.000000, 0.914092, -0.000000, 0.050279, -0.000000, 0.997961}, 
%% {0.900042, -0.000000, -0.027092, -0.000000, 0.905398, -0.000000, 0.036931, -0.000000, 0.998888}, 
%% {0.894163, -0.000000, -0.017779, -0.000000, 0.897249, -0.000000, 0.024162, -0.000000, 0.999520}, 
%% {0.888435, -0.000000, -0.008796, -0.000000, 0.889753, -0.000000, 0.011822, -0.000000, 0.999883}, 
%% {0.882714, -0.000000, 0.000083, -0.000000, 0.882719, -0.000000, -0.000040, -0.000000, 1.000000}, 
%% {4409.252441, -0.000000, -0.321393, -0.000000, 5002.882812, -0.000000, 1604.833618, -0.000000, 0.883023}, 
%% {1752.367432, -0.000000, -0.321393, -0.000000, 1984.396729, -0.000000, 637.806824, -0.000000, 0.883023}, 
%% {438.115204, -0.000000, -0.321393, -0.000000, 496.145630, -0.000000, 159.460190, -0.000000, 0.883023}, 
%% {194.712952, -0.000000, -0.321392, -0.000000, 220.478317, -0.000000, 70.869431, -0.000000, 0.883024}, 
%% {109.523949, -0.000000, -0.321390, -0.000000, 124.023865, -0.000000, 39.863014, -0.000000, 0.883025}, 
%% {70.096146, -0.000000, -0.321386, -0.000000, 79.376976, -0.000000, 25.512751, -0.000000, 0.883026}, 
%% {48.676617, -0.000000, -0.321378, -0.000000, 55.123512, -0.000000, 17.716707, -0.000000, 0.883029}, 
%% {35.760796, -0.000000, -0.321365, -0.000000, 40.498306, -0.000000, 13.015736, -0.000000, 0.883034}, 
%% {27.379124, -0.000000, -0.321347, -0.000000, 31.006512, -0.000000, 9.965053, -0.000000, 0.883041}, 
%% {21.633284, -0.000000, -0.321317, -0.000000, 24.493942, -0.000000, 7.873634, -0.000000, 0.883054}, 
%% {17.521872, -0.000000, -0.321279, -0.000000, 19.841288, -0.000000, 6.377234, -0.000000, 0.883068}, 
%% {14.479614, -0.000000, -0.321228, -0.000000, 16.396482, -0.000000, 5.269911, -0.000000, 0.883088}, 
%% {12.167069, -0.000000, -0.321161, -0.000000, 13.774902, -0.000000, 4.428124, -0.000000, 0.883116}, 
%% {10.366197, -0.000000, -0.321075, -0.000000, 11.735257, -0.000000, 3.772617, -0.000000, 0.883150}, 
%% {8.937244, -0.000000, -0.320962, -0.000000, 10.116787, -0.000000, 3.252461, -0.000000, 0.883195}, 
%% {7.784689, -0.000000, -0.320802, -0.000000, 8.810699, -0.000000, 2.832889, -0.000000, 0.883259}, 
%% {6.841974, -0.000000, -0.320432, -0.000000, 7.741934, -0.000000, 2.489568, -0.000000, 0.883406}, 
%% {6.072207, -0.000000, -0.317857, -0.000000, 6.869445, -0.000000, 2.209153, -0.000000, 0.884359}, 
%% {5.423115, -0.000000, -0.316030, -0.000000, 6.133788, -0.000000, 1.972571, -0.000000, 0.885049}, 
%% {4.872310, -0.000000, -0.314862, -0.000000, 5.508963, -0.000000, 1.771779, -0.000000, 0.885503}, 
%% {4.402169, -0.000000, -0.314032, -0.000000, 4.975441, -0.000000, 1.600361, -0.000000, 0.885837}, 
%% {3.998751, -0.000000, -0.313488, -0.000000, 4.517624, -0.000000, 1.453223, -0.000000, 0.886073}, 
%% {3.653634, -0.000000, -0.312549, -0.000000, 4.125733, -0.000000, 1.327205, -0.000000, 0.886465}, 
%% {3.355813, -0.000000, -0.312458, -0.000000, 3.787194, -0.000000, 1.218485, -0.000000, 0.886547}, 
%% {3.092150, -0.000000, -0.312944, -0.000000, 3.487229, -0.000000, 1.122261, -0.000000, 0.886421}, 
%% {2.856256, -0.000000, -0.310149, -0.000000, 3.218414, -0.000000, 1.035439, -0.000000, 0.887566}, 
%% {2.648825, -0.000000, -0.306804, -0.000000, 2.981747, -0.000000, 0.958750, -0.000000, 0.888951}, 
%% {2.464784, -0.000000, -0.303691, -0.000000, 2.771526, -0.000000, 0.890464, -0.000000, 0.890284}, 
%% {2.302807, -0.000000, -0.300041, -0.000000, 2.585730, -0.000000, 0.829877, -0.000000, 0.891872}, 
%% {2.158198, -0.000000, -0.296866, -0.000000, 2.419671, -0.000000, 0.775574, -0.000000, 0.893318}, 
%% {2.030671, -0.000000, -0.293588, -0.000000, 2.271961, -0.000000, 0.727119, -0.000000, 0.894875}, 
%% {1.916775, -0.000000, -0.290503, -0.000000, 2.139123, -0.000000, 0.683485, -0.000000, 0.896412}, 
%% {1.813795, -0.000000, -0.285893, -0.000000, 2.018351, -0.000000, 0.643046, -0.000000, 0.898642}, 
%% {1.721701, -0.000000, -0.280369, -0.000000, 1.909094, -0.000000, 0.605892, -0.000000, 0.901334}, 
%% {1.639994, -0.000000, -0.275100, -0.000000, 1.810677, -0.000000, 0.572026, -0.000000, 0.904046}, 
%% {1.567269, -0.000000, -0.269777, -0.000000, 1.722010, -0.000000, 0.541055, -0.000000, 0.906867}, 
%% {1.502353, -0.000000, -0.264012, -0.000000, 1.640905, -0.000000, 0.511798, -0.000000, 0.910060}, 
%% {1.442774, -0.000000, -0.256971, -0.000000, 1.567143, -0.000000, 0.483742, -0.000000, 0.913841}, 
%% {1.388778, -0.000000, -0.249992, -0.000000, 1.500032, -0.000000, 0.457305, -0.000000, 0.917681}, 
%% {1.341215, -0.000000, -0.242901, -0.000000, 1.439686, -0.000000, 0.432299, -0.000000, 0.921708}, 
%% {1.297299, -0.000000, -0.234870, -0.000000, 1.384748, -0.000000, 0.408151, -0.000000, 0.926106}, 
%% {1.257475, -0.000000, -0.226621, -0.000000, 1.334704, -0.000000, 0.384805, -0.000000, 0.930651}, 
%% {1.222177, -0.000000, -0.218231, -0.000000, 1.289747, -0.000000, 0.362625, -0.000000, 0.935250}, 
%% {1.188729, -0.000000, -0.208986, -0.000000, 1.247842, -0.000000, 0.340444, -0.000000, 0.940148}, 
%% {1.158891, -0.000000, -0.199739, -0.000000, 1.210484, -0.000000, 0.318914, -0.000000, 0.945034}, 
%% {1.130544, -0.000000, -0.189985, -0.000000, 1.176189, -0.000000, 0.297832, -0.000000, 0.949950}, 
%% {1.104777, -0.000000, -0.179973, -0.000000, 1.144560, -0.000000, 0.277208, -0.000000, 0.954842}, 
%% {1.079731, -0.000000, -0.169728, -0.000000, 1.115928, -0.000000, 0.256556, -0.000000, 0.959671}, 
%% {1.057796, -0.000000, -0.159184, -0.000000, 1.088990, -0.000000, 0.236744, -0.000000, 0.964373}, 
%% {1.036793, -0.000000, -0.148481, -0.000000, 1.064556, -0.000000, 0.217421, -0.000000, 0.968863}, 
%% {1.017557, -0.000000, -0.137608, -0.000000, 1.042623, -0.000000, 0.198710, -0.000000, 0.973128}, 
%% {0.999712, -0.000000, -0.126614, -0.000000, 1.022443, -0.000000, 0.180826, -0.000000, 0.977098}, 
%% {0.983329, -0.000000, -0.115593, -0.000000, 1.004087, -0.000000, 0.163342, -0.000000, 0.980799}, 
%% {0.968082, -0.000000, -0.104372, -0.000000, 0.987316, -0.000000, 0.146404, -0.000000, 0.984216}, 
%% {0.954493, -0.000000, -0.093363, -0.000000, 0.972192, -0.000000, 0.130169, -0.000000, 0.987268}, 
%% {0.941916, -0.000000, -0.082257, -0.000000, 0.958377, -0.000000, 0.114148, -0.000000, 0.990031}, 
%% {0.930708, -0.000000, -0.071306, -0.000000, 0.945678, -0.000000, 0.098695, -0.000000, 0.992438}, 
%% {0.920933, -0.000000, -0.060591, -0.000000, 0.934034, -0.000000, 0.083406, -0.000000, 0.994513}, 
%% {0.912213, -0.000000, -0.049856, -0.000000, 0.923465, -0.000000, 0.068405, -0.000000, 0.996261}, 
%% {0.905053, -0.000000, -0.039384, -0.000000, 0.913766, -0.000000, 0.053920, -0.000000, 0.997654}, 
%% {0.898843, -0.000000, -0.029221, -0.000000, 0.904962, -0.000000, 0.039730, -0.000000, 0.998708}, 
%% {0.893271, -0.000000, -0.019099, -0.000000, 0.896770, -0.000000, 0.025901, -0.000000, 0.999446}, 
%% {0.887695, -0.000000, -0.009311, -0.000000, 0.889177, -0.000000, 0.012666, -0.000000, 0.999867}, 
%% {0.882147, -0.000000, 0.000073, -0.000000, 0.882137, -0.000000, -0.000031, -0.000000, 1.000000}, 
%% {4323.800781, -0.000000, -0.340085, -0.000000, 4998.317383, -0.000000, 1696.963501, -0.000000, 0.866527}, 
%% {1719.338989, -0.000000, -0.340086, -0.000000, 1984.547485, -0.000000, 674.787903, -0.000000, 0.866527}, 
%% {429.909393, -0.000000, -0.340085, -0.000000, 496.139038, -0.000000, 168.726273, -0.000000, 0.866527}, 
%% {191.073105, -0.000000, -0.340084, -0.000000, 220.495697, -0.000000, 74.990288, -0.000000, 0.866527}, 
%% {107.471069, -0.000000, -0.340082, -0.000000, 124.027794, -0.000000, 42.178715, -0.000000, 0.866529}, 
%% {68.783669, -0.000000, -0.340076, -0.000000, 79.378685, -0.000000, 26.995428, -0.000000, 0.866531}, 
%% {47.766453, -0.000000, -0.340068, -0.000000, 55.124538, -0.000000, 18.746782, -0.000000, 0.866534}, 
%% {35.094193, -0.000000, -0.340052, -0.000000, 40.498234, -0.000000, 13.773286, -0.000000, 0.866541}, 
%% {26.866663, -0.000000, -0.340028, -0.000000, 31.006247, -0.000000, 10.544227, -0.000000, 0.866551}, 
%% {21.225811, -0.000000, -0.339996, -0.000000, 24.494350, -0.000000, 8.330260, -0.000000, 0.866565}, 
%% {17.194418, -0.000000, -0.339948, -0.000000, 19.841072, -0.000000, 6.748058, -0.000000, 0.866585}, 
%% {14.209738, -0.000000, -0.339887, -0.000000, 16.396170, -0.000000, 5.576575, -0.000000, 0.866612}, 
%% {11.939181, -0.000000, -0.339806, -0.000000, 13.775182, -0.000000, 4.685435, -0.000000, 0.866646}, 
%% {10.172739, -0.000000, -0.339703, -0.000000, 11.735166, -0.000000, 3.992070, -0.000000, 0.866691}, 
%% {8.770800, -0.000000, -0.339568, -0.000000, 10.116592, -0.000000, 3.441767, -0.000000, 0.866750}, 
%% {7.639849, -0.000000, -0.339374, -0.000000, 8.810779, -0.000000, 2.997801, -0.000000, 0.866833}, 
%% {6.716047, -0.000000, -0.338855, -0.000000, 7.743690, -0.000000, 2.635104, -0.000000, 0.867047}, 
%% {5.960783, -0.000000, -0.336141, -0.000000, 6.871110, -0.000000, 2.338313, -0.000000, 0.868138}, 
%% {5.322651, -0.000000, -0.334577, -0.000000, 6.133834, -0.000000, 2.087547, -0.000000, 0.868779}, 
%% {4.782018, -0.000000, -0.333405, -0.000000, 5.508619, -0.000000, 1.875024, -0.000000, 0.869272}, 
%% {4.320424, -0.000000, -0.332533, -0.000000, 4.974621, -0.000000, 1.693509, -0.000000, 0.869655}, 
%% {3.924728, -0.000000, -0.331708, -0.000000, 4.516812, -0.000000, 1.537838, -0.000000, 0.870026}, 
%% {3.586962, -0.000000, -0.330061, -0.000000, 4.125564, -0.000000, 1.404720, -0.000000, 0.870742}, 
%% {3.292853, -0.000000, -0.329890, -0.000000, 3.784809, -0.000000, 1.288893, -0.000000, 0.870874}, 
%% {3.035974, -0.000000, -0.330683, -0.000000, 3.486959, -0.000000, 1.187823, -0.000000, 0.870621}, 
%% {2.806095, -0.000000, -0.327794, -0.000000, 3.219682, -0.000000, 1.096546, -0.000000, 0.871907}, 
%% {2.601964, -0.000000, -0.324686, -0.000000, 2.981958, -0.000000, 1.015203, -0.000000, 0.873318}, 
%% {2.421978, -0.000000, -0.321226, -0.000000, 2.772023, -0.000000, 0.943105, -0.000000, 0.874916}, 
%% {2.262782, -0.000000, -0.317465, -0.000000, 2.585466, -0.000000, 0.878844, -0.000000, 0.876700}, 
%% {2.121617, -0.000000, -0.313815, -0.000000, 2.419410, -0.000000, 0.821488, -0.000000, 0.878491}, 
%% {1.996672, -0.000000, -0.310206, -0.000000, 2.271435, -0.000000, 0.770199, -0.000000, 0.880341}, 
%% {1.886126, -0.000000, -0.306635, -0.000000, 2.138224, -0.000000, 0.724133, -0.000000, 0.882275}, 
%% {1.787197, -0.000000, -0.302593, -0.000000, 2.018183, -0.000000, 0.682200, -0.000000, 0.884496}, 
%% {1.697834, -0.000000, -0.296745, -0.000000, 1.908753, -0.000000, 0.642932, -0.000000, 0.887629}, 
%% {1.617563, -0.000000, -0.290877, -0.000000, 1.809566, -0.000000, 0.606843, -0.000000, 0.890875}, 
%% {1.547127, -0.000000, -0.285111, -0.000000, 1.720434, -0.000000, 0.573753, -0.000000, 0.894266}, 
%% {1.483319, -0.000000, -0.279182, -0.000000, 1.639291, -0.000000, 0.542788, -0.000000, 0.897839}, 
%% {1.426605, -0.000000, -0.272139, -0.000000, 1.565952, -0.000000, 0.513740, -0.000000, 0.901999}, 
%% {1.374636, -0.000000, -0.264558, -0.000000, 1.499474, -0.000000, 0.485931, -0.000000, 0.906479}, 
%% {1.328385, -0.000000, -0.256986, -0.000000, 1.439021, -0.000000, 0.459747, -0.000000, 0.911059}, 
%% {1.286618, -0.000000, -0.248964, -0.000000, 1.384716, -0.000000, 0.434560, -0.000000, 0.915912}, 
%% {1.247876, -0.000000, -0.240056, -0.000000, 1.334834, -0.000000, 0.409817, -0.000000, 0.921163}, 
%% {1.213087, -0.000000, -0.231131, -0.000000, 1.289814, -0.000000, 0.385960, -0.000000, 0.926462}, 
%% {1.180908, -0.000000, -0.221688, -0.000000, 1.248534, -0.000000, 0.362421, -0.000000, 0.931964}, 
%% {1.152121, -0.000000, -0.211741, -0.000000, 1.211083, -0.000000, 0.339900, -0.000000, 0.937532}, 
%% {1.124854, -0.000000, -0.201718, -0.000000, 1.176487, -0.000000, 0.317370, -0.000000, 0.943086}, 
%% {1.100462, -0.000000, -0.191010, -0.000000, 1.145419, -0.000000, 0.295406, -0.000000, 0.948726}, 
%% {1.077399, -0.000000, -0.180303, -0.000000, 1.116741, -0.000000, 0.273775, -0.000000, 0.954184}, 
%% {1.055242, -0.000000, -0.169080, -0.000000, 1.090348, -0.000000, 0.252289, -0.000000, 0.959576}, 
%% {1.035056, -0.000000, -0.157876, -0.000000, 1.065721, -0.000000, 0.231877, -0.000000, 0.964632}, 
%% {1.015541, -0.000000, -0.146319, -0.000000, 1.043476, -0.000000, 0.211632, -0.000000, 0.969508}, 
%% {0.998287, -0.000000, -0.134792, -0.000000, 1.022901, -0.000000, 0.192300, -0.000000, 0.974035}, 
%% {0.981564, -0.000000, -0.122949, -0.000000, 1.004138, -0.000000, 0.173483, -0.000000, 0.978270}, 
%% {0.966803, -0.000000, -0.111269, -0.000000, 0.987331, -0.000000, 0.155583, -0.000000, 0.982094}, 
%% {0.952897, -0.000000, -0.099403, -0.000000, 0.971978, -0.000000, 0.138210, -0.000000, 0.985582}, 
%% {0.940592, -0.000000, -0.087680, -0.000000, 0.958217, -0.000000, 0.121385, -0.000000, 0.988685}, 
%% {0.929303, -0.000000, -0.076043, -0.000000, 0.945490, -0.000000, 0.104923, -0.000000, 0.991414}, 
%% {0.919286, -0.000000, -0.064471, -0.000000, 0.933732, -0.000000, 0.088783, -0.000000, 0.993773}, 
%% {0.910830, -0.000000, -0.053176, -0.000000, 0.923095, -0.000000, 0.072936, -0.000000, 0.995742}, 
%% {0.903628, -0.000000, -0.042043, -0.000000, 0.913436, -0.000000, 0.057453, -0.000000, 0.997327}, 
%% {0.897616, -0.000000, -0.031079, -0.000000, 0.904530, -0.000000, 0.042294, -0.000000, 0.998536}, 
%% {0.892263, -0.000000, -0.020444, -0.000000, 0.896324, -0.000000, 0.027676, -0.000000, 0.999366}, 
%% {0.886911, -0.000000, -0.010008, -0.000000, 0.888618, -0.000000, 0.013554, -0.000000, 0.999847}, 
%% {0.881438, -0.000000, 0.000150, -0.000000, 0.881383, -0.000000, -0.000051, -0.000000, 1.000000}, 
%% {4241.544434, -0.000000, -0.357932, -0.000000, 5002.757812, -0.000000, 1787.955200, -0.000000, 0.849119}, 
%% {1685.483032, -0.000000, -0.357932, -0.000000, 1984.667114, -0.000000, 710.486328, -0.000000, 0.849120}, 
%% {421.265198, -0.000000, -0.357931, -0.000000, 496.127258, -0.000000, 177.577377, -0.000000, 0.849120}, 
%% {187.233063, -0.000000, -0.357931, -0.000000, 220.497040, -0.000000, 78.924973, -0.000000, 0.849120}, 
%% {105.307137, -0.000000, -0.357928, -0.000000, 124.038994, -0.000000, 44.389988, -0.000000, 0.849123}, 
%% {67.400810, -0.000000, -0.357922, -0.000000, 79.383202, -0.000000, 28.411652, -0.000000, 0.849124}, 
%% {46.808109, -0.000000, -0.357911, -0.000000, 55.125710, -0.000000, 19.731079, -0.000000, 0.849129}, 
%% {34.389626, -0.000000, -0.357894, -0.000000, 40.498840, -0.000000, 14.496249, -0.000000, 0.849137}, 
%% {26.328266, -0.000000, -0.357866, -0.000000, 31.006334, -0.000000, 11.098074, -0.000000, 0.849150}, 
%% {20.802313, -0.000000, -0.357825, -0.000000, 24.495945, -0.000000, 8.768680, -0.000000, 0.849168}, 
%% {16.848738, -0.000000, -0.357771, -0.000000, 19.838554, -0.000000, 7.102006, -0.000000, 0.849194}, 
%% {13.924516, -0.000000, -0.357696, -0.000000, 16.395727, -0.000000, 5.869311, -0.000000, 0.849228}, 
%% {11.699525, -0.000000, -0.357602, -0.000000, 13.774757, -0.000000, 4.931330, -0.000000, 0.849272}, 
%% {9.968682, -0.000000, -0.357479, -0.000000, 11.735221, -0.000000, 4.201618, -0.000000, 0.849329}, 
%% {8.595187, -0.000000, -0.357321, -0.000000, 10.116618, -0.000000, 3.622541, -0.000000, 0.849403}, 
%% {7.486977, -0.000000, -0.357086, -0.000000, 8.810658, -0.000000, 3.155284, -0.000000, 0.849511}, 
%% {6.583241, -0.000000, -0.356301, -0.000000, 7.745201, -0.000000, 2.774151, -0.000000, 0.849856}, 
%% {5.842677, -0.000000, -0.353657, -0.000000, 6.872180, -0.000000, 2.461586, -0.000000, 0.851000}, 
%% {5.216916, -0.000000, -0.352232, -0.000000, 6.134075, -0.000000, 2.197460, -0.000000, 0.851634}, 
%% {4.686604, -0.000000, -0.351114, -0.000000, 5.508032, -0.000000, 1.973568, -0.000000, 0.852143}, 
%% {4.234152, -0.000000, -0.350164, -0.000000, 4.973942, -0.000000, 1.782466, -0.000000, 0.852590}, 
%% {3.846886, -0.000000, -0.349015, -0.000000, 4.516316, -0.000000, 1.618749, -0.000000, 0.853136}, 
%% {3.515894, -0.000000, -0.347084, -0.000000, 4.124747, -0.000000, 1.478561, -0.000000, 0.854039}, 
%% {3.226959, -0.000000, -0.346631, -0.000000, 3.782914, -0.000000, 1.356277, -0.000000, 0.854312}, 
%% {2.975559, -0.000000, -0.346953, -0.000000, 3.485358, -0.000000, 1.249929, -0.000000, 0.854257}, 
%% {2.752680, -0.000000, -0.344815, -0.000000, 3.220385, -0.000000, 1.154974, -0.000000, 0.855322}, 
%% {2.552535, -0.000000, -0.341723, -0.000000, 2.982262, -0.000000, 1.069288, -0.000000, 0.856848}, 
%% {2.376991, -0.000000, -0.337864, -0.000000, 2.772337, -0.000000, 0.993596, -0.000000, 0.858771}, 
%% {2.220849, -0.000000, -0.334096, -0.000000, 2.585368, -0.000000, 0.925871, -0.000000, 0.860716}, 
%% {2.083390, -0.000000, -0.329983, -0.000000, 2.419155, -0.000000, 0.865676, -0.000000, 0.862888}, 
%% {1.961460, -0.000000, -0.326109, -0.000000, 2.270603, -0.000000, 0.811723, -0.000000, 0.865044}, 
%% {1.854536, -0.000000, -0.322170, -0.000000, 2.137386, -0.000000, 0.763515, -0.000000, 0.867362}, 
%% {1.758357, -0.000000, -0.317986, -0.000000, 2.016870, -0.000000, 0.719347, -0.000000, 0.869912}, 
%% {1.671210, -0.000000, -0.312360, -0.000000, 1.907278, -0.000000, 0.678159, -0.000000, 0.873248}, 
%% {1.594402, -0.000000, -0.306132, -0.000000, 1.808233, -0.000000, 0.640565, -0.000000, 0.877009}, 
%% {1.525348, -0.000000, -0.299866, -0.000000, 1.719199, -0.000000, 0.605797, -0.000000, 0.880907}, 
%% {1.464417, -0.000000, -0.293499, -0.000000, 1.638724, -0.000000, 0.573711, -0.000000, 0.885017}, 
%% {1.409713, -0.000000, -0.286623, -0.000000, 1.565214, -0.000000, 0.543547, -0.000000, 0.889486}, 
%% {1.359584, -0.000000, -0.278556, -0.000000, 1.499136, -0.000000, 0.514255, -0.000000, 0.894638}, 
%% {1.314794, -0.000000, -0.270474, -0.000000, 1.439137, -0.000000, 0.486725, -0.000000, 0.899873}, 
%% {1.274318, -0.000000, -0.262212, -0.000000, 1.384425, -0.000000, 0.460322, -0.000000, 0.905281}, 
%% {1.237282, -0.000000, -0.253040, -0.000000, 1.334672, -0.000000, 0.434418, -0.000000, 0.911156}, 
%% {1.203904, -0.000000, -0.243526, -0.000000, 1.290127, -0.000000, 0.409443, -0.000000, 0.917178}, 
%% {1.172926, -0.000000, -0.233875, -0.000000, 1.249017, -0.000000, 0.384882, -0.000000, 0.923257}, 
%% {1.144572, -0.000000, -0.223403, -0.000000, 1.211315, -0.000000, 0.360591, -0.000000, 0.929618}, 
%% {1.119098, -0.000000, -0.212843, -0.000000, 1.177387, -0.000000, 0.336773, -0.000000, 0.935949}, 
%% {1.095159, -0.000000, -0.201885, -0.000000, 1.146310, -0.000000, 0.313665, -0.000000, 0.942178}, 
%% {1.073355, -0.000000, -0.190429, -0.000000, 1.117440, -0.000000, 0.290769, -0.000000, 0.948413}, 
%% {1.052441, -0.000000, -0.178918, -0.000000, 1.091167, -0.000000, 0.268188, -0.000000, 0.954407}, 
%% {1.032548, -0.000000, -0.166851, -0.000000, 1.066895, -0.000000, 0.245928, -0.000000, 0.960260}, 
%% {1.013856, -0.000000, -0.154909, -0.000000, 1.044525, -0.000000, 0.224652, -0.000000, 0.965675}, 
%% {0.996563, -0.000000, -0.142540, -0.000000, 1.023800, -0.000000, 0.203675, -0.000000, 0.970868}, 
%% {0.980112, -0.000000, -0.130278, -0.000000, 1.004747, -0.000000, 0.183742, -0.000000, 0.975577}, 
%% {0.965123, -0.000000, -0.117754, -0.000000, 0.987562, -0.000000, 0.164590, -0.000000, 0.979919}, 
%% {0.951385, -0.000000, -0.105357, -0.000000, 0.972335, -0.000000, 0.146301, -0.000000, 0.983799}, 
%% {0.939098, -0.000000, -0.092986, -0.000000, 0.958134, -0.000000, 0.128577, -0.000000, 0.987269}, 
%% {0.927747, -0.000000, -0.080640, -0.000000, 0.945326, -0.000000, 0.111219, -0.000000, 0.990333}, 
%% {0.917695, -0.000000, -0.068579, -0.000000, 0.933604, -0.000000, 0.094123, -0.000000, 0.992966}, 
%% {0.909380, -0.000000, -0.056415, -0.000000, 0.922856, -0.000000, 0.077292, -0.000000, 0.995205}, 
%% {0.902249, -0.000000, -0.044583, -0.000000, 0.913076, -0.000000, 0.061037, -0.000000, 0.996984}, 
%% {0.896364, -0.000000, -0.032997, -0.000000, 0.904171, -0.000000, 0.044951, -0.000000, 0.998345}, 
%% {0.891215, -0.000000, -0.021633, -0.000000, 0.895797, -0.000000, 0.029389, -0.000000, 0.999287}, 
%% {0.886042, -0.000000, -0.010666, -0.000000, 0.887988, -0.000000, 0.014388, -0.000000, 0.999827}, 
%% {0.880673, -0.000000, 0.000093, -0.000000, 0.880710, -0.000000, -0.000055, -0.000000, 1.000000}, 
%% {4154.542480, -0.000000, -0.374890, -0.000000, 4995.390137, -0.000000, 1874.599609, -0.000000, 0.830844}, 
%% {1648.785767, -0.000000, -0.374890, -0.000000, 1984.285889, -0.000000, 743.956360, -0.000000, 0.830844}, 
%% {412.193665, -0.000000, -0.374890, -0.000000, 496.135132, -0.000000, 185.988022, -0.000000, 0.830844}, 
%% {183.202362, -0.000000, -0.374887, -0.000000, 220.499039, -0.000000, 82.663651, -0.000000, 0.830845}, 
%% {103.053131, -0.000000, -0.374885, -0.000000, 124.037270, -0.000000, 46.498528, -0.000000, 0.830849}, 
%% {65.950668, -0.000000, -0.374878, -0.000000, 79.380455, -0.000000, 29.757877, -0.000000, 0.830850}, 
%% {45.801167, -0.000000, -0.374865, -0.000000, 55.122147, -0.000000, 20.666025, -0.000000, 0.830857}, 
%% {33.646561, -0.000000, -0.374842, -0.000000, 40.498035, -0.000000, 15.181688, -0.000000, 0.830867}, 
%% {25.761061, -0.000000, -0.374810, -0.000000, 31.007025, -0.000000, 11.623583, -0.000000, 0.830883}, 
%% {20.357973, -0.000000, -0.374764, -0.000000, 24.496510, -0.000000, 9.185581, -0.000000, 0.830905}, 
%% {16.486593, -0.000000, -0.374699, -0.000000, 19.841057, -0.000000, 7.438668, -0.000000, 0.830938}, 
%% {13.624950, -0.000000, -0.374613, -0.000000, 16.397245, -0.000000, 6.147408, -0.000000, 0.830979}, 
%% {11.448137, -0.000000, -0.374501, -0.000000, 13.774707, -0.000000, 5.165077, -0.000000, 0.831036}, 
%% {9.754471, -0.000000, -0.374358, -0.000000, 11.735221, -0.000000, 4.400770, -0.000000, 0.831107}, 
%% {8.410490, -0.000000, -0.374173, -0.000000, 10.116444, -0.000000, 3.794225, -0.000000, 0.831199}, 
%% {7.326750, -0.000000, -0.373891, -0.000000, 8.810631, -0.000000, 3.305083, -0.000000, 0.831338}, 
%% {6.445047, -0.000000, -0.372574, -0.000000, 7.748719, -0.000000, 2.906980, -0.000000, 0.831954}, 
%% {5.718311, -0.000000, -0.370371, -0.000000, 6.872837, -0.000000, 2.578704, -0.000000, 0.832979}, 
%% {5.105556, -0.000000, -0.369019, -0.000000, 6.133870, -0.000000, 2.301854, -0.000000, 0.833627}, 
%% {4.586341, -0.000000, -0.367933, -0.000000, 5.507392, -0.000000, 2.067162, -0.000000, 0.834165}, 
%% {4.143750, -0.000000, -0.366873, -0.000000, 4.973157, -0.000000, 1.867032, -0.000000, 0.834699}, 
%% {3.765729, -0.000000, -0.365311, -0.000000, 4.516361, -0.000000, 1.695900, -0.000000, 0.835482}, 
%% {3.441091, -0.000000, -0.363348, -0.000000, 4.123737, -0.000000, 1.548705, -0.000000, 0.836471}, 
%% {3.157815, -0.000000, -0.362574, -0.000000, 3.781106, -0.000000, 1.420289, -0.000000, 0.836925}, 
%% {2.912452, -0.000000, -0.362229, -0.000000, 3.483686, -0.000000, 1.308966, -0.000000, 0.837201}, 
%% {2.696351, -0.000000, -0.361020, -0.000000, 3.220930, -0.000000, 1.210592, -0.000000, 0.837911}, 
%% {2.501004, -0.000000, -0.357773, -0.000000, 2.982823, -0.000000, 1.120990, -0.000000, 0.839641}, 
%% {2.329572, -0.000000, -0.353788, -0.000000, 2.772734, -0.000000, 1.041788, -0.000000, 0.841786}, 
%% {2.177660, -0.000000, -0.349829, -0.000000, 2.585340, -0.000000, 0.971075, -0.000000, 0.844002}, 
%% {2.043900, -0.000000, -0.345476, -0.000000, 2.418860, -0.000000, 0.908132, -0.000000, 0.846501}, 
%% {1.925616, -0.000000, -0.341159, -0.000000, 2.269459, -0.000000, 0.851728, -0.000000, 0.849101}, 
%% {1.820066, -0.000000, -0.336876, -0.000000, 2.135923, -0.000000, 0.800756, -0.000000, 0.851788}, 
%% {1.728187, -0.000000, -0.332496, -0.000000, 2.015663, -0.000000, 0.755199, -0.000000, 0.854703}, 
%% {1.644878, -0.000000, -0.327191, -0.000000, 1.906880, -0.000000, 0.712954, -0.000000, 0.858183}, 
%% {1.569807, -0.000000, -0.320617, -0.000000, 1.807639, -0.000000, 0.673421, -0.000000, 0.862461}, 
%% {1.503131, -0.000000, -0.313945, -0.000000, 1.718084, -0.000000, 0.637086, -0.000000, 0.866938}, 
%% {1.443917, -0.000000, -0.307170, -0.000000, 1.637546, -0.000000, 0.603575, -0.000000, 0.871599}, 
%% {1.391337, -0.000000, -0.300128, -0.000000, 1.564637, -0.000000, 0.572459, -0.000000, 0.876514}, 
%% {1.343472, -0.000000, -0.292051, -0.000000, 1.498365, -0.000000, 0.542263, -0.000000, 0.882120}, 
%% {1.299740, -0.000000, -0.283464, -0.000000, 1.438110, -0.000000, 0.512928, -0.000000, 0.888134}, 
%% {1.261259, -0.000000, -0.274746, -0.000000, 1.384091, -0.000000, 0.485600, -0.000000, 0.894220}, 
%% {1.225533, -0.000000, -0.265664, -0.000000, 1.334532, -0.000000, 0.458348, -0.000000, 0.900642}, 
%% {1.193486, -0.000000, -0.255549, -0.000000, 1.289425, -0.000000, 0.432195, -0.000000, 0.907458}, 
%% {1.163966, -0.000000, -0.245389, -0.000000, 1.248886, -0.000000, 0.406438, -0.000000, 0.914314}, 
%% {1.137516, -0.000000, -0.234832, -0.000000, 1.211967, -0.000000, 0.381159, -0.000000, 0.921313}, 
%% {1.112728, -0.000000, -0.223594, -0.000000, 1.178046, -0.000000, 0.356360, -0.000000, 0.928392}, 
%% {1.089230, -0.000000, -0.212332, -0.000000, 1.146644, -0.000000, 0.331271, -0.000000, 0.935423}, 
%% {1.068045, -0.000000, -0.200381, -0.000000, 1.118290, -0.000000, 0.307353, -0.000000, 0.942336}, 
%% {1.048040, -0.000000, -0.188255, -0.000000, 1.092145, -0.000000, 0.283569, -0.000000, 0.949064}, 
%% {1.029790, -0.000000, -0.175840, -0.000000, 1.067972, -0.000000, 0.260271, -0.000000, 0.955558}, 
%% {1.011882, -0.000000, -0.163186, -0.000000, 1.045476, -0.000000, 0.237445, -0.000000, 0.961707}, 
%% {0.994345, -0.000000, -0.150384, -0.000000, 1.024592, -0.000000, 0.215427, -0.000000, 0.967419}, 
%% {0.978742, -0.000000, -0.137374, -0.000000, 1.005638, -0.000000, 0.194038, -0.000000, 0.972765}, 
%% {0.963919, -0.000000, -0.124310, -0.000000, 0.987917, -0.000000, 0.173614, -0.000000, 0.977610}, 
%% {0.949770, -0.000000, -0.111245, -0.000000, 0.972231, -0.000000, 0.154131, -0.000000, 0.981947}, 
%% {0.937325, -0.000000, -0.098117, -0.000000, 0.958162, -0.000000, 0.135318, -0.000000, 0.985835}, 
%% {0.926305, -0.000000, -0.085221, -0.000000, 0.945251, -0.000000, 0.117136, -0.000000, 0.989223}, 
%% {0.916445, -0.000000, -0.072250, -0.000000, 0.933416, -0.000000, 0.099154, -0.000000, 0.992183}, 
%% {0.907926, -0.000000, -0.059623, -0.000000, 0.922634, -0.000000, 0.081682, -0.000000, 0.994636}, 
%% {0.900873, -0.000000, -0.047156, -0.000000, 0.912686, -0.000000, 0.064439, -0.000000, 0.996627}, 
%% {0.895020, -0.000000, -0.034927, -0.000000, 0.903644, -0.000000, 0.047578, -0.000000, 0.998143}, 
%% {0.890084, -0.000000, -0.022955, -0.000000, 0.895248, -0.000000, 0.031117, -0.000000, 0.999198}, 
%% {0.885208, -0.000000, -0.011173, -0.000000, 0.887370, -0.000000, 0.015245, -0.000000, 0.999808}, 
%% {0.879919, -0.000000, 0.000134, -0.000000, 0.879887, -0.000000, -0.000057, -0.000000, 1.000000}, 
%% {4056.339111, -0.000000, -0.390914, -0.000000, 4997.568848, -0.000000, 1953.425537, -0.000000, 0.811746}, 
%% {1610.951294, -0.000000, -0.390915, -0.000000, 1984.518555, -0.000000, 775.789673, -0.000000, 0.811746}, 
%% {402.723358, -0.000000, -0.390914, -0.000000, 496.120178, -0.000000, 193.940430, -0.000000, 0.811747}, 
%% {178.989502, -0.000000, -0.390913, -0.000000, 220.492920, -0.000000, 86.196350, -0.000000, 0.811747}, 
%% {100.704102, -0.000000, -0.390910, -0.000000, 124.009789, -0.000000, 48.495640, -0.000000, 0.811751}, 
%% {64.437943, -0.000000, -0.390901, -0.000000, 79.377007, -0.000000, 31.031479, -0.000000, 0.811753}, 
%% {44.744606, -0.000000, -0.390886, -0.000000, 55.115849, -0.000000, 21.547630, -0.000000, 0.811761}, 
%% {32.875305, -0.000000, -0.390860, -0.000000, 40.503201, -0.000000, 15.831753, -0.000000, 0.811774}, 
%% {25.168509, -0.000000, -0.390824, -0.000000, 31.006086, -0.000000, 12.120228, -0.000000, 0.811794}, 
%% {19.886944, -0.000000, -0.390769, -0.000000, 24.498077, -0.000000, 9.576730, -0.000000, 0.811822}, 
%% {16.107605, -0.000000, -0.390695, -0.000000, 19.840557, -0.000000, 7.756610, -0.000000, 0.811861}, 
%% {13.311891, -0.000000, -0.390595, -0.000000, 16.395845, -0.000000, 6.410170, -0.000000, 0.811914}, 
%% {11.185532, -0.000000, -0.390466, -0.000000, 13.775455, -0.000000, 5.386073, -0.000000, 0.811982}, 
%% {9.530525, -0.000000, -0.390301, -0.000000, 11.735244, -0.000000, 4.588943, -0.000000, 0.812070}, 
%% {8.217670, -0.000000, -0.390085, -0.000000, 10.116491, -0.000000, 3.956556, -0.000000, 0.812186}, 
%% {7.159055, -0.000000, -0.389743, -0.000000, 8.811004, -0.000000, 3.446588, -0.000000, 0.812366}, 
%% {6.300905, -0.000000, -0.387856, -0.000000, 7.752780, -0.000000, 3.032998, -0.000000, 0.813302}, 
%% {5.588403, -0.000000, -0.386110, -0.000000, 6.873835, -0.000000, 2.689523, -0.000000, 0.814177}, 
%% {4.988970, -0.000000, -0.384903, -0.000000, 6.133733, -0.000000, 2.400474, -0.000000, 0.814802}, 
%% {4.481744, -0.000000, -0.383797, -0.000000, 5.506787, -0.000000, 2.155771, -0.000000, 0.815389}, 
%% {4.049456, -0.000000, -0.382607, -0.000000, 4.972813, -0.000000, 1.947098, -0.000000, 0.816031}, 
%% {3.681419, -0.000000, -0.380518, -0.000000, 4.517300, -0.000000, 1.769151, -0.000000, 0.817138}, 
%% {3.363007, -0.000000, -0.378769, -0.000000, 4.123035, -0.000000, 1.615074, -0.000000, 0.818097}, 
%% {3.086291, -0.000000, -0.377658, -0.000000, 3.779922, -0.000000, 1.481082, -0.000000, 0.818765}, 
%% {2.847093, -0.000000, -0.376546, -0.000000, 3.482721, -0.000000, 1.365072, -0.000000, 0.819461}, 
%% {2.636885, -0.000000, -0.376056, -0.000000, 3.220554, -0.000000, 1.263010, -0.000000, 0.819878}, 
%% {2.447494, -0.000000, -0.372816, -0.000000, 2.983380, -0.000000, 1.170225, -0.000000, 0.821745}, 
%% {2.280448, -0.000000, -0.368857, -0.000000, 2.772588, -0.000000, 1.087708, -0.000000, 0.824066}, 
%% {2.133428, -0.000000, -0.364558, -0.000000, 2.585405, -0.000000, 1.014397, -0.000000, 0.826661}, 
%% {2.002280, -0.000000, -0.360141, -0.000000, 2.418322, -0.000000, 0.948451, -0.000000, 0.829406}, 
%% {1.887337, -0.000000, -0.355444, -0.000000, 2.268676, -0.000000, 0.889719, -0.000000, 0.832438}, 
%% {1.785744, -0.000000, -0.350817, -0.000000, 2.134790, -0.000000, 0.836884, -0.000000, 0.835591}, 
%% {1.696346, -0.000000, -0.346136, -0.000000, 2.014485, -0.000000, 0.789580, -0.000000, 0.838888}, 
%% {1.616201, -0.000000, -0.341050, -0.000000, 1.905880, -0.000000, 0.746120, -0.000000, 0.842554}, 
%% {1.544222, -0.000000, -0.334354, -0.000000, 1.806910, -0.000000, 0.705506, -0.000000, 0.847244}, 
%% {1.480290, -0.000000, -0.327289, -0.000000, 1.717377, -0.000000, 0.667947, -0.000000, 0.852318}, 
%% {1.423141, -0.000000, -0.320097, -0.000000, 1.636260, -0.000000, 0.633108, -0.000000, 0.857600}, 
%% {1.372471, -0.000000, -0.312779, -0.000000, 1.563477, -0.000000, 0.600562, -0.000000, 0.863135}, 
%% {1.325560, -0.000000, -0.304906, -0.000000, 1.497532, -0.000000, 0.569155, -0.000000, 0.869083}, 
%% {1.284001, -0.000000, -0.295859, -0.000000, 1.437460, -0.000000, 0.538860, -0.000000, 0.875836}, 
%% {1.247613, -0.000000, -0.286688, -0.000000, 1.382702, -0.000000, 0.510452, -0.000000, 0.882704}, 
%% {1.213653, -0.000000, -0.277344, -0.000000, 1.333997, -0.000000, 0.482180, -0.000000, 0.889812}, 
%% {1.183185, -0.000000, -0.267155, -0.000000, 1.289481, -0.000000, 0.455027, -0.000000, 0.897258}, 
%% {1.155126, -0.000000, -0.256494, -0.000000, 1.249185, -0.000000, 0.427769, -0.000000, 0.905014}, 
%% {1.128941, -0.000000, -0.245614, -0.000000, 1.212191, -0.000000, 0.401060, -0.000000, 0.912745}, 
%% {1.105442, -0.000000, -0.234019, -0.000000, 1.178236, -0.000000, 0.375056, -0.000000, 0.920602}, 
%% {1.083751, -0.000000, -0.222158, -0.000000, 1.147513, -0.000000, 0.349165, -0.000000, 0.928425}, 
%% {1.062847, -0.000000, -0.210075, -0.000000, 1.119488, -0.000000, 0.323753, -0.000000, 0.936009}, 
%% {1.044392, -0.000000, -0.197241, -0.000000, 1.093291, -0.000000, 0.298739, -0.000000, 0.943581}, 
%% {1.026330, -0.000000, -0.184479, -0.000000, 1.069090, -0.000000, 0.274260, -0.000000, 0.950703}, 
%% {1.009590, -0.000000, -0.171168, -0.000000, 1.046473, -0.000000, 0.250356, -0.000000, 0.957554}, 
%% {0.992841, -0.000000, -0.157867, -0.000000, 1.025612, -0.000000, 0.226899, -0.000000, 0.963922}, 
%% {0.976761, -0.000000, -0.144226, -0.000000, 1.005912, -0.000000, 0.203966, -0.000000, 0.969883}, 
%% {0.962334, -0.000000, -0.130657, -0.000000, 0.988251, -0.000000, 0.182349, -0.000000, 0.975242}, 
%% {0.948327, -0.000000, -0.116887, -0.000000, 0.972552, -0.000000, 0.161615, -0.000000, 0.980080}, 
%% {0.935750, -0.000000, -0.103308, -0.000000, 0.958147, -0.000000, 0.142304, -0.000000, 0.984289}, 
%% {0.924817, -0.000000, -0.089577, -0.000000, 0.945248, -0.000000, 0.123157, -0.000000, 0.988071}, 
%% {0.914726, -0.000000, -0.076159, -0.000000, 0.933222, -0.000000, 0.104299, -0.000000, 0.991316}, 
%% {0.906278, -0.000000, -0.062774, -0.000000, 0.922286, -0.000000, 0.085890, -0.000000, 0.994051}, 
%% {0.899258, -0.000000, -0.049642, -0.000000, 0.912319, -0.000000, 0.067833, -0.000000, 0.996255}, 
%% {0.893734, -0.000000, -0.036730, -0.000000, 0.903131, -0.000000, 0.050031, -0.000000, 0.997944}, 
%% {0.888993, -0.000000, -0.024076, -0.000000, 0.894605, -0.000000, 0.032750, -0.000000, 0.999113}, 
%% {0.884202, -0.000000, -0.011946, -0.000000, 0.886659, -0.000000, 0.016053, -0.000000, 0.999783}, 
%% {0.879005, -0.000000, 0.000135, -0.000000, 0.879034, -0.000000, -0.000024, -0.000000, 1.000000}, 
%% {3955.919189, -0.000000, -0.405968, -0.000000, 4998.791016, -0.000000, 2028.081055, -0.000000, 0.791873}, 
%% {1571.879517, -0.000000, -0.405968, -0.000000, 1984.409302, -0.000000, 805.851074, -0.000000, 0.791874}, 
%% {392.875763, -0.000000, -0.405967, -0.000000, 496.122009, -0.000000, 201.414703, -0.000000, 0.791874}, 
%% {174.611954, -0.000000, -0.405966, -0.000000, 220.496140, -0.000000, 89.517860, -0.000000, 0.791875}, 
%% {98.213524, -0.000000, -0.405963, -0.000000, 124.029358, -0.000000, 50.350071, -0.000000, 0.791879}, 
%% {62.859367, -0.000000, -0.405951, -0.000000, 79.379677, -0.000000, 32.225883, -0.000000, 0.791883}, 
%% {43.653069, -0.000000, -0.405934, -0.000000, 55.121342, -0.000000, 22.379402, -0.000000, 0.791892}, 
%% {32.082848, -0.000000, -0.405907, -0.000000, 40.490410, -0.000000, 16.447420, -0.000000, 0.791910}, 
%% {24.550327, -0.000000, -0.405863, -0.000000, 31.003748, -0.000000, 12.585864, -0.000000, 0.791932}, 
%% {19.398443, -0.000000, -0.405802, -0.000000, 24.495056, -0.000000, 9.944596, -0.000000, 0.791966}, 
%% {15.713538, -0.000000, -0.405717, -0.000000, 19.841433, -0.000000, 8.055375, -0.000000, 0.792014}, 
%% {12.986282, -0.000000, -0.405602, -0.000000, 16.395960, -0.000000, 6.657098, -0.000000, 0.792078}, 
%% {10.911797, -0.000000, -0.405454, -0.000000, 13.775459, -0.000000, 5.593463, -0.000000, 0.792161}, 
%% {9.297766, -0.000000, -0.405266, -0.000000, 11.735672, -0.000000, 4.765859, -0.000000, 0.792268}, 
%% {8.016963, -0.000000, -0.405019, -0.000000, 10.116665, -0.000000, 4.109050, -0.000000, 0.792410}, 
%% {6.984653, -0.000000, -0.404591, -0.000000, 8.811695, -0.000000, 3.579632, -0.000000, 0.792648}, 
%% {6.148530, -0.000000, -0.402484, -0.000000, 7.755097, -0.000000, 3.150630, -0.000000, 0.793759}, 
%% {5.452440, -0.000000, -0.400991, -0.000000, 6.874070, -0.000000, 2.793370, -0.000000, 0.794566}, 
%% {4.867531, -0.000000, -0.399791, -0.000000, 6.133638, -0.000000, 2.493099, -0.000000, 0.795231}, 
%% {4.372661, -0.000000, -0.398670, -0.000000, 5.506475, -0.000000, 2.238906, -0.000000, 0.795871}, 
%% {3.951710, -0.000000, -0.397306, -0.000000, 4.972742, -0.000000, 2.022524, -0.000000, 0.796655}, 
%% {3.593059, -0.000000, -0.394990, -0.000000, 4.517533, -0.000000, 1.837867, -0.000000, 0.797961}, 
%% {3.281898, -0.000000, -0.393297, -0.000000, 4.122239, -0.000000, 1.677546, -0.000000, 0.798965}, 
%% {3.011921, -0.000000, -0.391821, -0.000000, 3.778773, -0.000000, 1.538260, -0.000000, 0.799888}, 
%% {2.778768, -0.000000, -0.390197, -0.000000, 3.481260, -0.000000, 1.417703, -0.000000, 0.800925}, 
%% {2.574241, -0.000000, -0.389593, -0.000000, 3.219061, -0.000000, 1.311903, -0.000000, 0.801453}, 
%% {2.392530, -0.000000, -0.386845, -0.000000, 2.984151, -0.000000, 1.217050, -0.000000, 0.803217}, 
%% {2.229864, -0.000000, -0.382974, -0.000000, 2.772767, -0.000000, 1.131418, -0.000000, 0.805681}, 
%% {2.086440, -0.000000, -0.378478, -0.000000, 2.585402, -0.000000, 1.055233, -0.000000, 0.808582}, 
%% {1.959672, -0.000000, -0.373843, -0.000000, 2.417767, -0.000000, 0.987039, -0.000000, 0.811705}, 
%% {1.847928, -0.000000, -0.368956, -0.000000, 2.268206, -0.000000, 0.926049, -0.000000, 0.815105}, 
%% {1.750220, -0.000000, -0.363931, -0.000000, 2.133955, -0.000000, 0.871747, -0.000000, 0.818734}, 
%% {1.663427, -0.000000, -0.358879, -0.000000, 2.013477, -0.000000, 0.822781, -0.000000, 0.822488}, 
%% {1.586646, -0.000000, -0.353614, -0.000000, 1.904865, -0.000000, 0.778198, -0.000000, 0.826564}, 
%% {1.517655, -0.000000, -0.347363, -0.000000, 1.805817, -0.000000, 0.736736, -0.000000, 0.831375}, 
%% {1.454341, -0.000000, -0.339967, -0.000000, 1.716240, -0.000000, 0.697019, -0.000000, 0.837065}, 
%% {1.399341, -0.000000, -0.332436, -0.000000, 1.635193, -0.000000, 0.660869, -0.000000, 0.843000}, 
%% {1.350560, -0.000000, -0.324738, -0.000000, 1.561985, -0.000000, 0.627187, -0.000000, 0.849195}, 
%% {1.306589, -0.000000, -0.316753, -0.000000, 1.496207, -0.000000, 0.594949, -0.000000, 0.855768}, 
%% {1.266652, -0.000000, -0.307771, -0.000000, 1.436791, -0.000000, 0.563515, -0.000000, 0.863077}, 
%% {1.231367, -0.000000, -0.298176, -0.000000, 1.382414, -0.000000, 0.533598, -0.000000, 0.870789}, 
%% {1.199595, -0.000000, -0.288425, -0.000000, 1.333628, -0.000000, 0.504606, -0.000000, 0.878675}, 
%% {1.170541, -0.000000, -0.278362, -0.000000, 1.289081, -0.000000, 0.476175, -0.000000, 0.886763}, 
%% {1.144403, -0.000000, -0.267222, -0.000000, 1.248933, -0.000000, 0.448332, -0.000000, 0.895313}, 
%% {1.120509, -0.000000, -0.255864, -0.000000, 1.212439, -0.000000, 0.420836, -0.000000, 0.903904}, 
%% {1.098251, -0.000000, -0.244235, -0.000000, 1.178976, -0.000000, 0.393772, -0.000000, 0.912431}, 
%% {1.077377, -0.000000, -0.231788, -0.000000, 1.148353, -0.000000, 0.366772, -0.000000, 0.921092}, 
%% {1.057792, -0.000000, -0.219182, -0.000000, 1.120043, -0.000000, 0.340281, -0.000000, 0.929491}, 
%% {1.039725, -0.000000, -0.206150, -0.000000, 1.094402, -0.000000, 0.313924, -0.000000, 0.937757}, 
%% {1.022596, -0.000000, -0.192735, -0.000000, 1.070168, -0.000000, 0.287874, -0.000000, 0.945743}, 
%% {1.006613, -0.000000, -0.179173, -0.000000, 1.047850, -0.000000, 0.262962, -0.000000, 0.953194}, 
%% {0.990776, -0.000000, -0.165107, -0.000000, 1.027107, -0.000000, 0.238139, -0.000000, 0.960316}, 
%% {0.975252, -0.000000, -0.151133, -0.000000, 1.007135, -0.000000, 0.214310, -0.000000, 0.966789}, 
%% {0.960273, -0.000000, -0.136767, -0.000000, 0.989140, -0.000000, 0.191194, -0.000000, 0.972769}, 
%% {0.946961, -0.000000, -0.122590, -0.000000, 0.972770, -0.000000, 0.169445, -0.000000, 0.978064}, 
%% {0.934299, -0.000000, -0.108157, -0.000000, 0.958121, -0.000000, 0.148780, -0.000000, 0.982777}, 
%% {0.923026, -0.000000, -0.094011, -0.000000, 0.945000, -0.000000, 0.128818, -0.000000, 0.986880}, 
%% {0.913286, -0.000000, -0.079781, -0.000000, 0.932867, -0.000000, 0.109236, -0.000000, 0.990458}, 
%% {0.904842, -0.000000, -0.065869, -0.000000, 0.921836, -0.000000, 0.090033, -0.000000, 0.993446}, 
%% {0.897764, -0.000000, -0.052104, -0.000000, 0.911739, -0.000000, 0.071113, -0.000000, 0.995873}, 
%% {0.892268, -0.000000, -0.038569, -0.000000, 0.902524, -0.000000, 0.052530, -0.000000, 0.997729}, 
%% {0.887736, -0.000000, -0.025419, -0.000000, 0.894030, -0.000000, 0.034387, -0.000000, 0.999015}, 
%% {0.883182, -0.000000, -0.012361, -0.000000, 0.885844, -0.000000, 0.016836, -0.000000, 0.999764}, 
%% {0.878001, -0.000000, 0.000116, -0.000000, 0.878032, -0.000000, -0.000006, -0.000000, 1.000000}, 
%% {3855.554199, -0.000000, -0.420012, -0.000000, 4993.562500, -0.000000, 2099.622559, -0.000000, 0.771274}, 
%% {1531.374146, -0.000000, -0.420013, -0.000000, 1983.528687, -0.000000, 833.937561, -0.000000, 0.771275}, 
%% {382.557281, -0.000000, -0.420012, -0.000000, 496.179718, -0.000000, 208.328445, -0.000000, 0.771275}, 
%% {170.061890, -0.000000, -0.420009, -0.000000, 220.502228, -0.000000, 92.610291, -0.000000, 0.771276}, 
%% {95.672134, -0.000000, -0.420006, -0.000000, 124.025146, -0.000000, 52.099106, -0.000000, 0.771282}, 
%% {61.225487, -0.000000, -0.419995, -0.000000, 79.376778, -0.000000, 33.341312, -0.000000, 0.771285}, 
%% {42.516464, -0.000000, -0.419974, -0.000000, 55.123814, -0.000000, 23.152962, -0.000000, 0.771297}, 
%% {31.236443, -0.000000, -0.419943, -0.000000, 40.498417, -0.000000, 17.010117, -0.000000, 0.771316}, 
%% {23.913227, -0.000000, -0.419893, -0.000000, 31.006870, -0.000000, 13.022107, -0.000000, 0.771344}, 
%% {18.895290, -0.000000, -0.419823, -0.000000, 24.497984, -0.000000, 10.289384, -0.000000, 0.771386}, 
%% {15.304123, -0.000000, -0.419727, -0.000000, 19.842646, -0.000000, 8.333583, -0.000000, 0.771445}, 
%% {12.648602, -0.000000, -0.419597, -0.000000, 16.396063, -0.000000, 6.887392, -0.000000, 0.771522}, 
%% {10.628388, -0.000000, -0.419430, -0.000000, 13.775626, -0.000000, 5.787118, -0.000000, 0.771622}, 
%% {9.056004, -0.000000, -0.419216, -0.000000, 11.735576, -0.000000, 4.930684, -0.000000, 0.771751}, 
%% {7.808955, -0.000000, -0.418934, -0.000000, 10.116839, -0.000000, 4.251370, -0.000000, 0.771923}, 
%% {6.804242, -0.000000, -0.418370, -0.000000, 8.812811, -0.000000, 3.704031, -0.000000, 0.772252}, 
%% {5.990857, -0.000000, -0.416168, -0.000000, 7.756664, -0.000000, 3.260663, -0.000000, 0.773491}, 
%% {5.311814, -0.000000, -0.414808, -0.000000, 6.874577, -0.000000, 2.890478, -0.000000, 0.774278}, 
%% {4.741899, -0.000000, -0.413639, -0.000000, 6.133786, -0.000000, 2.579672, -0.000000, 0.774974}, 
%% {4.259838, -0.000000, -0.412509, -0.000000, 5.506175, -0.000000, 2.316618, -0.000000, 0.775666}, 
%% {3.850517, -0.000000, -0.410901, -0.000000, 4.973263, -0.000000, 2.093081, -0.000000, 0.776641}, 
%% {3.501077, -0.000000, -0.408571, -0.000000, 4.517537, -0.000000, 1.901918, -0.000000, 0.778049}, 
%% {3.197896, -0.000000, -0.406798, -0.000000, 4.121720, -0.000000, 1.735934, -0.000000, 0.779175}, 
%% {2.935400, -0.000000, -0.404936, -0.000000, 3.778242, -0.000000, 1.591952, -0.000000, 0.780392}, 
%% {2.708164, -0.000000, -0.403103, -0.000000, 3.479819, -0.000000, 1.467013, -0.000000, 0.781639}, 
%% {2.509412, -0.000000, -0.402018, -0.000000, 3.217340, -0.000000, 1.357584, -0.000000, 0.782510}, 
%% {2.335078, -0.000000, -0.400056, -0.000000, 2.984313, -0.000000, 1.261046, -0.000000, 0.783952}, 
%% {2.176833, -0.000000, -0.395999, -0.000000, 2.773092, -0.000000, 1.172448, -0.000000, 0.786714}, 
%% {2.037622, -0.000000, -0.391476, -0.000000, 2.585506, -0.000000, 1.093675, -0.000000, 0.789879}, 
%% {1.915456, -0.000000, -0.386553, -0.000000, 2.418002, -0.000000, 1.023681, -0.000000, 0.793414}, 
%% {1.807299, -0.000000, -0.381509, -0.000000, 2.267715, -0.000000, 0.960802, -0.000000, 0.797181}, 
%% {1.712675, -0.000000, -0.376238, -0.000000, 2.133060, -0.000000, 0.904831, -0.000000, 0.801228}, 
%% {1.629455, -0.000000, -0.370833, -0.000000, 2.012298, -0.000000, 0.854472, -0.000000, 0.805538}, 
%% {1.554034, -0.000000, -0.365333, -0.000000, 1.903442, -0.000000, 0.807945, -0.000000, 0.810062}, 
%% {1.487752, -0.000000, -0.359304, -0.000000, 1.804904, -0.000000, 0.765559, -0.000000, 0.815111}, 
%% {1.428463, -0.000000, -0.351853, -0.000000, 1.714878, -0.000000, 0.725427, -0.000000, 0.821316}, 
%% {1.375611, -0.000000, -0.343987, -0.000000, 1.634091, -0.000000, 0.688199, -0.000000, 0.827908}, 
%% {1.328957, -0.000000, -0.335989, -0.000000, 1.560996, -0.000000, 0.653185, -0.000000, 0.834861}, 
%% {1.286776, -0.000000, -0.327730, -0.000000, 1.495162, -0.000000, 0.619874, -0.000000, 0.842124}, 
%% {1.249436, -0.000000, -0.319004, -0.000000, 1.435984, -0.000000, 0.588144, -0.000000, 0.849836}, 
%% {1.215615, -0.000000, -0.309079, -0.000000, 1.381799, -0.000000, 0.556806, -0.000000, 0.858428}, 
%% {1.185535, -0.000000, -0.298874, -0.000000, 1.332598, -0.000000, 0.526897, -0.000000, 0.867169}, 
%% {1.158212, -0.000000, -0.288528, -0.000000, 1.289022, -0.000000, 0.497580, -0.000000, 0.876045}, 
%% {1.133045, -0.000000, -0.277482, -0.000000, 1.248390, -0.000000, 0.468516, -0.000000, 0.885261}, 
%% {1.110541, -0.000000, -0.265669, -0.000000, 1.212335, -0.000000, 0.439651, -0.000000, 0.894825}, 
%% {1.089510, -0.000000, -0.253670, -0.000000, 1.179166, -0.000000, 0.411682, -0.000000, 0.904148}, 
%% {1.070842, -0.000000, -0.241146, -0.000000, 1.148820, -0.000000, 0.384115, -0.000000, 0.913500}, 
%% {1.052189, -0.000000, -0.227954, -0.000000, 1.121017, -0.000000, 0.356074, -0.000000, 0.922857}, 
%% {1.035208, -0.000000, -0.214692, -0.000000, 1.095667, -0.000000, 0.328778, -0.000000, 0.931815}, 
%% {1.018569, -0.000000, -0.200755, -0.000000, 1.070936, -0.000000, 0.301803, -0.000000, 0.940516}, 
%% {1.002908, -0.000000, -0.186625, -0.000000, 1.048918, -0.000000, 0.275296, -0.000000, 0.948772}, 
%% {0.988453, -0.000000, -0.172250, -0.000000, 1.028304, -0.000000, 0.249648, -0.000000, 0.956496}, 
%% {0.973683, -0.000000, -0.157556, -0.000000, 1.008237, -0.000000, 0.224250, -0.000000, 0.963713}, 
%% {0.958514, -0.000000, -0.142891, -0.000000, 0.989704, -0.000000, 0.200086, -0.000000, 0.970172}, 
%% {0.945293, -0.000000, -0.127897, -0.000000, 0.973273, -0.000000, 0.176940, -0.000000, 0.976060}, 
%% {0.932642, -0.000000, -0.113108, -0.000000, 0.958155, -0.000000, 0.155268, -0.000000, 0.981170}, 
%% {0.921267, -0.000000, -0.098191, -0.000000, 0.944871, -0.000000, 0.134448, -0.000000, 0.985670}, 
%% {0.911540, -0.000000, -0.083487, -0.000000, 0.932728, -0.000000, 0.114272, -0.000000, 0.989534}, 
%% {0.903029, -0.000000, -0.068867, -0.000000, 0.921686, -0.000000, 0.093993, -0.000000, 0.992832}, 
%% {0.896139, -0.000000, -0.054508, -0.000000, 0.911404, -0.000000, 0.074412, -0.000000, 0.995474}, 
%% {0.890694, -0.000000, -0.040365, -0.000000, 0.901983, -0.000000, 0.054973, -0.000000, 0.997509}, 
%% {0.886512, -0.000000, -0.026465, -0.000000, 0.893310, -0.000000, 0.035977, -0.000000, 0.998926}, 
%% {0.882162, -0.000000, -0.013096, -0.000000, 0.885104, -0.000000, 0.017616, -0.000000, 0.999738}, 
%% {0.877094, -0.000000, 0.000131, -0.000000, 0.877115, -0.000000, -0.000033, -0.000000, 1.000000}, 
%% {3746.017090, -0.000000, -0.433012, -0.000000, 4995.541016, -0.000000, 2162.761719, -0.000000, 0.750001}, 
%% {1488.457886, -0.000000, -0.433012, -0.000000, 1984.281006, -0.000000, 859.357666, -0.000000, 0.750001}, 
%% {372.149323, -0.000000, -0.433012, -0.000000, 496.094452, -0.000000, 214.859406, -0.000000, 0.750002}, 
%% {165.381470, -0.000000, -0.433010, -0.000000, 220.498062, -0.000000, 95.482521, -0.000000, 0.750003}, 
%% {93.027870, -0.000000, -0.433006, -0.000000, 124.024902, -0.000000, 53.708305, -0.000000, 0.750010}, 
%% {59.535332, -0.000000, -0.432991, -0.000000, 79.379280, -0.000000, 34.372433, -0.000000, 0.750014}, 
%% {41.343601, -0.000000, -0.432969, -0.000000, 55.122959, -0.000000, 23.869410, -0.000000, 0.750028}, 
%% {30.373985, -0.000000, -0.432934, -0.000000, 40.495876, -0.000000, 17.536085, -0.000000, 0.750050}, 
%% {23.255714, -0.000000, -0.432878, -0.000000, 31.005991, -0.000000, 13.426271, -0.000000, 0.750085}, 
%% {18.373474, -0.000000, -0.432800, -0.000000, 24.496820, -0.000000, 10.607388, -0.000000, 0.750136}, 
%% {14.884932, -0.000000, -0.432691, -0.000000, 19.840157, -0.000000, 8.593203, -0.000000, 0.750204}, 
%% {12.300001, -0.000000, -0.432546, -0.000000, 16.395880, -0.000000, 7.100638, -0.000000, 0.750296}, 
%% {10.335183, -0.000000, -0.432356, -0.000000, 13.775732, -0.000000, 5.966114, -0.000000, 0.750417}, 
%% {8.806694, -0.000000, -0.432117, -0.000000, 11.735838, -0.000000, 5.083453, -0.000000, 0.750571}, 
%% {7.594002, -0.000000, -0.431797, -0.000000, 10.117234, -0.000000, 4.383081, -0.000000, 0.750777}, 
%% {6.618823, -0.000000, -0.430976, -0.000000, 8.815049, -0.000000, 3.819784, -0.000000, 0.751280}, 
%% {5.826852, -0.000000, -0.428917, -0.000000, 7.757360, -0.000000, 3.362120, -0.000000, 0.752513}, 
%% {5.166539, -0.000000, -0.427614, -0.000000, 6.874791, -0.000000, 2.980431, -0.000000, 0.753321}, 
%% {4.612207, -0.000000, -0.426438, -0.000000, 6.133687, -0.000000, 2.659901, -0.000000, 0.754070}, 
%% {4.143397, -0.000000, -0.425276, -0.000000, 5.506118, -0.000000, 2.388671, -0.000000, 0.754828}, 
%% {3.746640, -0.000000, -0.423307, -0.000000, 4.974451, -0.000000, 2.158840, -0.000000, 0.756088}, 
%% {3.406056, -0.000000, -0.421160, -0.000000, 4.517311, -0.000000, 1.961287, -0.000000, 0.757486}, 
%% {3.111113, -0.000000, -0.419317, -0.000000, 4.120961, -0.000000, 1.790018, -0.000000, 0.758741}, 
%% {2.857178, -0.000000, -0.416949, -0.000000, 3.778404, -0.000000, 1.642167, -0.000000, 0.760358}, 
%% {2.635371, -0.000000, -0.415070, -0.000000, 3.478266, -0.000000, 1.512790, -0.000000, 0.761736}, 
%% {2.443096, -0.000000, -0.413391, -0.000000, 3.215844, -0.000000, 1.400336, -0.000000, 0.763052}, 
%% {2.273978, -0.000000, -0.411875, -0.000000, 2.984035, -0.000000, 1.301144, -0.000000, 0.764330}, 
%% {2.122243, -0.000000, -0.407963, -0.000000, 2.773782, -0.000000, 1.211018, -0.000000, 0.767204}, 
%% {1.987423, -0.000000, -0.403410, -0.000000, 2.585775, -0.000000, 1.129966, -0.000000, 0.770638}, 
%% {1.869092, -0.000000, -0.398415, -0.000000, 2.418032, -0.000000, 1.057957, -0.000000, 0.774486}, 
%% {1.765828, -0.000000, -0.393103, -0.000000, 2.267249, -0.000000, 0.994059, -0.000000, 0.778706}, 
%% {1.673783, -0.000000, -0.387620, -0.000000, 2.132498, -0.000000, 0.936011, -0.000000, 0.783236}, 
%% {1.592523, -0.000000, -0.382016, -0.000000, 2.011141, -0.000000, 0.883712, -0.000000, 0.788014}, 
%% {1.520892, -0.000000, -0.376171, -0.000000, 1.902077, -0.000000, 0.836419, -0.000000, 0.793124}, 
%% {1.457554, -0.000000, -0.370104, -0.000000, 1.803649, -0.000000, 0.793276, -0.000000, 0.798570}, 
%% {1.401051, -0.000000, -0.363011, -0.000000, 1.713716, -0.000000, 0.752532, -0.000000, 0.805019}, 
%% {1.350956, -0.000000, -0.354890, -0.000000, 1.633016, -0.000000, 0.714183, -0.000000, 0.812387}, 
%% {1.306226, -0.000000, -0.346590, -0.000000, 1.560187, -0.000000, 0.677902, -0.000000, 0.820128}, 
%% {1.266695, -0.000000, -0.338045, -0.000000, 1.493891, -0.000000, 0.644146, -0.000000, 0.828096}, 
%% {1.231272, -0.000000, -0.329245, -0.000000, 1.434445, -0.000000, 0.611579, -0.000000, 0.836462}, 
%% {1.199423, -0.000000, -0.319562, -0.000000, 1.381369, -0.000000, 0.579233, -0.000000, 0.845676}, 
%% {1.171069, -0.000000, -0.308962, -0.000000, 1.332189, -0.000000, 0.548668, -0.000000, 0.855246}, 
%% {1.144986, -0.000000, -0.298259, -0.000000, 1.288483, -0.000000, 0.517777, -0.000000, 0.865124}, 
%% {1.121282, -0.000000, -0.287234, -0.000000, 1.248838, -0.000000, 0.487901, -0.000000, 0.875017}, 
%% {1.100264, -0.000000, -0.275152, -0.000000, 1.212113, -0.000000, 0.458626, -0.000000, 0.885307}, 
%% {1.080464, -0.000000, -0.262748, -0.000000, 1.179041, -0.000000, 0.428953, -0.000000, 0.895687}, 
%% {1.062426, -0.000000, -0.250077, -0.000000, 1.148989, -0.000000, 0.400160, -0.000000, 0.905809}, 
%% {1.046472, -0.000000, -0.236535, -0.000000, 1.121614, -0.000000, 0.372027, -0.000000, 0.915910}, 
%% {1.029630, -0.000000, -0.222753, -0.000000, 1.095993, -0.000000, 0.343004, -0.000000, 0.925794}, 
%% {1.014064, -0.000000, -0.208666, -0.000000, 1.072029, -0.000000, 0.315448, -0.000000, 0.935090}, 
%% {0.999654, -0.000000, -0.193913, -0.000000, 1.050082, -0.000000, 0.287681, -0.000000, 0.944196}, 
%% {0.984830, -0.000000, -0.179160, -0.000000, 1.028685, -0.000000, 0.260340, -0.000000, 0.952639}, 
%% {0.971110, -0.000000, -0.163944, -0.000000, 1.009287, -0.000000, 0.234162, -0.000000, 0.960468}, 
%% {0.957150, -0.000000, -0.148693, -0.000000, 0.990935, -0.000000, 0.208790, -0.000000, 0.967564}, 
%% {0.943406, -0.000000, -0.133238, -0.000000, 0.973663, -0.000000, 0.184510, -0.000000, 0.973942}, 
%% {0.930932, -0.000000, -0.117782, -0.000000, 0.958297, -0.000000, 0.161422, -0.000000, 0.979577}, 
%% {0.919878, -0.000000, -0.102330, -0.000000, 0.944657, -0.000000, 0.139698, -0.000000, 0.984460}, 
%% {0.909897, -0.000000, -0.087002, -0.000000, 0.932604, -0.000000, 0.118934, -0.000000, 0.988628}, 
%% {0.901433, -0.000000, -0.071832, -0.000000, 0.921195, -0.000000, 0.098135, -0.000000, 0.992180}, 
%% {0.894472, -0.000000, -0.056882, -0.000000, 0.910824, -0.000000, 0.077604, -0.000000, 0.995065}, 
%% {0.889171, -0.000000, -0.042069, -0.000000, 0.901394, -0.000000, 0.057418, -0.000000, 0.997283}, 
%% {0.885069, -0.000000, -0.027778, -0.000000, 0.892532, -0.000000, 0.037614, -0.000000, 0.998819}, 
%% {0.880996, -0.000000, -0.013529, -0.000000, 0.884141, -0.000000, 0.018360, -0.000000, 0.999718}, 
%% {0.876080, -0.000000, 0.000100, -0.000000, 0.876061, -0.000000, -0.000049, -0.000000, 1.000000}, 
%% {3642.768066, -0.000000, -0.444934, -0.000000, 4994.257812, -0.000000, 2226.043701, -0.000000, 0.728107}, 
%% {1446.203491, -0.000000, -0.444935, -0.000000, 1984.158325, -0.000000, 883.752258, -0.000000, 0.728107}, 
%% {361.209015, -0.000000, -0.444935, -0.000000, 496.119659, -0.000000, 220.729156, -0.000000, 0.728108}, 
%% {160.554276, -0.000000, -0.444932, -0.000000, 220.502243, -0.000000, 98.112045, -0.000000, 0.728109}, 
%% {90.329895, -0.000000, -0.444926, -0.000000, 124.005081, -0.000000, 55.199036, -0.000000, 0.728113}, 
%% {57.782669, -0.000000, -0.444911, -0.000000, 79.388794, -0.000000, 35.310066, -0.000000, 0.728122}, 
%% {40.136265, -0.000000, -0.444888, -0.000000, 55.124920, -0.000000, 24.526390, -0.000000, 0.728139}, 
%% {29.486433, -0.000000, -0.444847, -0.000000, 40.498795, -0.000000, 18.018393, -0.000000, 0.728165}, 
%% {22.576420, -0.000000, -0.444787, -0.000000, 31.005745, -0.000000, 13.795679, -0.000000, 0.728206}, 
%% {17.837910, -0.000000, -0.444698, -0.000000, 24.497404, -0.000000, 10.899940, -0.000000, 0.728265}, 
%% {14.448962, -0.000000, -0.444577, -0.000000, 19.841858, -0.000000, 8.828857, -0.000000, 0.728347}, 
%% {11.941193, -0.000000, -0.444416, -0.000000, 16.396227, -0.000000, 7.296240, -0.000000, 0.728455}, 
%% {10.034008, -0.000000, -0.444207, -0.000000, 13.775596, -0.000000, 6.130603, -0.000000, 0.728598}, 
%% {8.549949, -0.000000, -0.443939, -0.000000, 11.735848, -0.000000, 5.223516, -0.000000, 0.728780}, 
%% {7.373027, -0.000000, -0.443572, -0.000000, 10.117622, -0.000000, 4.504055, -0.000000, 0.729030}, 
%% {6.429397, -0.000000, -0.442243, -0.000000, 8.819755, -0.000000, 3.927064, -0.000000, 0.729879}, 
%% {5.658485, -0.000000, -0.440587, -0.000000, 7.758348, -0.000000, 3.455539, -0.000000, 0.730941}, 
%% {5.016186, -0.000000, -0.439381, -0.000000, 6.874871, -0.000000, 3.062569, -0.000000, 0.731741}, 
%% {4.478469, -0.000000, -0.438206, -0.000000, 6.133249, -0.000000, 2.733429, -0.000000, 0.732541}, 
%% {4.023572, -0.000000, -0.436927, -0.000000, 5.506154, -0.000000, 2.454816, -0.000000, 0.733427}, 
%% {3.639698, -0.000000, -0.434651, -0.000000, 4.975405, -0.000000, 2.219354, -0.000000, 0.734966}, 
%% {3.308352, -0.000000, -0.432695, -0.000000, 4.517138, -0.000000, 2.015920, -0.000000, 0.736340}, 
%% {3.022175, -0.000000, -0.430703, -0.000000, 4.120601, -0.000000, 1.839945, -0.000000, 0.737781}, 
%% {2.776022, -0.000000, -0.428151, -0.000000, 3.777931, -0.000000, 1.688137, -0.000000, 0.739635}, 
%% {2.560808, -0.000000, -0.426042, -0.000000, 3.477342, -0.000000, 1.555155, -0.000000, 0.741269}, 
%% {2.374822, -0.000000, -0.423918, -0.000000, 3.214539, -0.000000, 1.439789, -0.000000, 0.742990}, 
%% {2.210885, -0.000000, -0.422234, -0.000000, 2.982943, -0.000000, 1.337923, -0.000000, 0.744484}, 
%% {2.065368, -0.000000, -0.418978, -0.000000, 2.774451, -0.000000, 1.246549, -0.000000, 0.747127}, 
%% {1.935931, -0.000000, -0.414283, -0.000000, 2.586223, -0.000000, 1.164014, -0.000000, 0.750905}, 
%% {1.822257, -0.000000, -0.409250, -0.000000, 2.417543, -0.000000, 1.090618, -0.000000, 0.755064}, 
%% {1.720926, -0.000000, -0.403840, -0.000000, 2.267028, -0.000000, 1.024065, -0.000000, 0.759688}, 
%% {1.632552, -0.000000, -0.398138, -0.000000, 2.131816, -0.000000, 0.964831, -0.000000, 0.764702}, 
%% {1.555655, -0.000000, -0.392213, -0.000000, 2.009695, -0.000000, 0.912070, -0.000000, 0.770048}, 
%% {1.486808, -0.000000, -0.386144, -0.000000, 1.900453, -0.000000, 0.863598, -0.000000, 0.775712}, 
%% {1.426842, -0.000000, -0.379885, -0.000000, 1.801610, -0.000000, 0.819712, -0.000000, 0.781758}, 
%% {1.373907, -0.000000, -0.373123, -0.000000, 1.712387, -0.000000, 0.779014, -0.000000, 0.788437}, 
%% {1.324869, -0.000000, -0.365005, -0.000000, 1.631275, -0.000000, 0.738973, -0.000000, 0.796411}, 
%% {1.282516, -0.000000, -0.356480, -0.000000, 1.558578, -0.000000, 0.701863, -0.000000, 0.804915}, 
%% {1.244247, -0.000000, -0.347648, -0.000000, 1.493068, -0.000000, 0.666625, -0.000000, 0.813742}, 
%% {1.211031, -0.000000, -0.338643, -0.000000, 1.433854, -0.000000, 0.633117, -0.000000, 0.822960}, 
%% {1.182212, -0.000000, -0.329195, -0.000000, 1.380149, -0.000000, 0.601141, -0.000000, 0.832608}, 
%% {1.155275, -0.000000, -0.318517, -0.000000, 1.331754, -0.000000, 0.568886, -0.000000, 0.843154}, 
%% {1.131884, -0.000000, -0.307465, -0.000000, 1.288019, -0.000000, 0.537968, -0.000000, 0.853867}, 
%% {1.109753, -0.000000, -0.296205, -0.000000, 1.248718, -0.000000, 0.506801, -0.000000, 0.864729}, 
%% {1.089779, -0.000000, -0.284256, -0.000000, 1.212029, -0.000000, 0.476524, -0.000000, 0.875704}, 
%% {1.071309, -0.000000, -0.271420, -0.000000, 1.179981, -0.000000, 0.445908, -0.000000, 0.887028}, 
%% {1.054345, -0.000000, -0.258343, -0.000000, 1.149120, -0.000000, 0.416179, -0.000000, 0.898025}, 
%% {1.038858, -0.000000, -0.244879, -0.000000, 1.121985, -0.000000, 0.386709, -0.000000, 0.908845}, 
%% {1.024392, -0.000000, -0.230541, -0.000000, 1.096927, -0.000000, 0.357355, -0.000000, 0.919577}, 
%% {1.009174, -0.000000, -0.216015, -0.000000, 1.072934, -0.000000, 0.327942, -0.000000, 0.929804}, 
%% {0.995423, -0.000000, -0.201114, -0.000000, 1.051314, -0.000000, 0.299459, -0.000000, 0.939498}, 
%% {0.981709, -0.000000, -0.185675, -0.000000, 1.030085, -0.000000, 0.271279, -0.000000, 0.948692}, 
%% {0.969315, -0.000000, -0.170224, -0.000000, 1.010196, -0.000000, 0.244134, -0.000000, 0.957127}, 
%% {0.955246, -0.000000, -0.154247, -0.000000, 0.992086, -0.000000, 0.217048, -0.000000, 0.964953}, 
%% {0.942398, -0.000000, -0.138406, -0.000000, 0.974535, -0.000000, 0.191855, -0.000000, 0.971823}, 
%% {0.929285, -0.000000, -0.122335, -0.000000, 0.958651, -0.000000, 0.167856, -0.000000, 0.977903}, 
%% {0.918095, -0.000000, -0.106416, -0.000000, 0.944640, -0.000000, 0.145210, -0.000000, 0.983169}, 
%% {0.908308, -0.000000, -0.090502, -0.000000, 0.932100, -0.000000, 0.123444, -0.000000, 0.987700}, 
%% {0.899619, -0.000000, -0.074750, -0.000000, 0.920820, -0.000000, 0.102011, -0.000000, 0.991524}, 
%% {0.892870, -0.000000, -0.059088, -0.000000, 0.910342, -0.000000, 0.080648, -0.000000, 0.994663}, 
%% {0.887547, -0.000000, -0.043871, -0.000000, 0.900732, -0.000000, 0.059734, -0.000000, 0.997047}, 
%% {0.883587, -0.000000, -0.028767, -0.000000, 0.891663, -0.000000, 0.039111, -0.000000, 0.998727}, 
%% {0.879750, -0.000000, -0.014214, -0.000000, 0.883255, -0.000000, 0.019184, -0.000000, 0.999690}, 
%% {0.874920, -0.000000, 0.000150, -0.000000, 0.874878, -0.000000, -0.000067, -0.000000, 1.000000}, 
%% {3526.077637, -0.000000, -0.455752, -0.000000, 4994.544434, -0.000000, 2277.375244, -0.000000, 0.705645}, 
%% {1399.477783, -0.000000, -0.455752, -0.000000, 1985.209351, -0.000000, 903.873901, -0.000000, 0.705646}, 
%% {350.034851, -0.000000, -0.455752, -0.000000, 496.177887, -0.000000, 226.075623, -0.000000, 0.705645}, 
%% {155.589996, -0.000000, -0.455749, -0.000000, 220.514099, -0.000000, 100.490067, -0.000000, 0.705648}, 
%% {87.524437, -0.000000, -0.455743, -0.000000, 124.028389, -0.000000, 56.528847, -0.000000, 0.705652}, 
%% {56.014515, -0.000000, -0.455727, -0.000000, 79.378853, -0.000000, 36.177643, -0.000000, 0.705664}, 
%% {38.899048, -0.000000, -0.455700, -0.000000, 55.121613, -0.000000, 25.123285, -0.000000, 0.705682}, 
%% {28.582998, -0.000000, -0.455655, -0.000000, 40.498363, -0.000000, 18.460403, -0.000000, 0.705714}, 
%% {21.879498, -0.000000, -0.455588, -0.000000, 31.005646, -0.000000, 14.130713, -0.000000, 0.705762}, 
%% {17.288130, -0.000000, -0.455491, -0.000000, 24.496935, -0.000000, 11.165172, -0.000000, 0.705831}, 
%% {14.003430, -0.000000, -0.455358, -0.000000, 19.842213, -0.000000, 9.043530, -0.000000, 0.705926}, 
%% {11.573257, -0.000000, -0.455178, -0.000000, 16.395792, -0.000000, 7.473794, -0.000000, 0.706054}, 
%% {9.724674, -0.000000, -0.454948, -0.000000, 13.775930, -0.000000, 6.279671, -0.000000, 0.706219}, 
%% {8.286699, -0.000000, -0.454651, -0.000000, 11.736012, -0.000000, 5.350684, -0.000000, 0.706434}, 
%% {7.146166, -0.000000, -0.454230, -0.000000, 10.117801, -0.000000, 4.613782, -0.000000, 0.706735}, 
%% {6.233807, -0.000000, -0.452619, -0.000000, 8.822472, -0.000000, 4.024105, -0.000000, 0.707821}, 
%% {5.485222, -0.000000, -0.451199, -0.000000, 7.758743, -0.000000, 3.540141, -0.000000, 0.708798}, 
%% {4.864182, -0.000000, -0.450008, -0.000000, 6.876092, -0.000000, 3.138704, -0.000000, 0.709624}, 
%% {4.341229, -0.000000, -0.448853, -0.000000, 6.132888, -0.000000, 2.800172, -0.000000, 0.710481}, 
%% {3.901278, -0.000000, -0.447413, -0.000000, 5.506346, -0.000000, 2.515308, -0.000000, 0.711535}, 
%% {3.529466, -0.000000, -0.445060, -0.000000, 4.975906, -0.000000, 2.274203, -0.000000, 0.713227}, 
%% {3.208008, -0.000000, -0.443171, -0.000000, 4.516711, -0.000000, 2.065547, -0.000000, 0.714655}, 
%% {2.931534, -0.000000, -0.440917, -0.000000, 4.120781, -0.000000, 1.885725, -0.000000, 0.716378}, 
%% {2.692668, -0.000000, -0.438362, -0.000000, 3.777184, -0.000000, 1.729941, -0.000000, 0.718369}, 
%% {2.485175, -0.000000, -0.435985, -0.000000, 3.476419, -0.000000, 1.594249, -0.000000, 0.720314}, 
%% {2.304008, -0.000000, -0.433517, -0.000000, 3.213385, -0.000000, 1.475363, -0.000000, 0.722399}, 
%% {2.146174, -0.000000, -0.431411, -0.000000, 2.981843, -0.000000, 1.371494, -0.000000, 0.724310}, 
%% {2.007083, -0.000000, -0.428953, -0.000000, 2.774669, -0.000000, 1.279340, -0.000000, 0.726580}, 
%% {1.883214, -0.000000, -0.424191, -0.000000, 2.586187, -0.000000, 1.195708, -0.000000, 0.730669}, 
%% {1.772840, -0.000000, -0.419008, -0.000000, 2.417674, -0.000000, 1.120188, -0.000000, 0.735246}, 
%% {1.676161, -0.000000, -0.413511, -0.000000, 2.266680, -0.000000, 1.052889, -0.000000, 0.740251}, 
%% {1.591495, -0.000000, -0.407688, -0.000000, 2.131268, -0.000000, 0.992496, -0.000000, 0.745755}, 
%% {1.517406, -0.000000, -0.401600, -0.000000, 2.008757, -0.000000, 0.938451, -0.000000, 0.751627}, 
%% {1.452268, -0.000000, -0.395318, -0.000000, 1.899030, -0.000000, 0.889330, -0.000000, 0.757918}, 
%% {1.394395, -0.000000, -0.388883, -0.000000, 1.800533, -0.000000, 0.843976, -0.000000, 0.764624}, 
%% {1.343436, -0.000000, -0.382129, -0.000000, 1.711203, -0.000000, 0.802096, -0.000000, 0.771851}, 
%% {1.298246, -0.000000, -0.374399, -0.000000, 1.630817, -0.000000, 0.762592, -0.000000, 0.780077}, 
%% {1.257506, -0.000000, -0.365703, -0.000000, 1.557353, -0.000000, 0.724324, -0.000000, 0.789355}, 
%% {1.222166, -0.000000, -0.356733, -0.000000, 1.492307, -0.000000, 0.688322, -0.000000, 0.799089}, 
%% {1.191396, -0.000000, -0.347446, -0.000000, 1.432394, -0.000000, 0.654373, -0.000000, 0.809166}, 
%% {1.163297, -0.000000, -0.337924, -0.000000, 1.379515, -0.000000, 0.621062, -0.000000, 0.819588}, 
%% {1.139253, -0.000000, -0.327568, -0.000000, 1.331583, -0.000000, 0.588955, -0.000000, 0.830659}, 
%% {1.116739, -0.000000, -0.316243, -0.000000, 1.287526, -0.000000, 0.556695, -0.000000, 0.842353}, 
%% {1.096929, -0.000000, -0.304653, -0.000000, 1.248109, -0.000000, 0.525131, -0.000000, 0.854154}, 
%% {1.079175, -0.000000, -0.292675, -0.000000, 1.212331, -0.000000, 0.494061, -0.000000, 0.866009}, 
%% {1.062198, -0.000000, -0.279883, -0.000000, 1.179648, -0.000000, 0.462975, -0.000000, 0.878009}, 
%% {1.046166, -0.000000, -0.266325, -0.000000, 1.149841, -0.000000, 0.431646, -0.000000, 0.890115}, 
%% {1.031529, -0.000000, -0.252533, -0.000000, 1.122718, -0.000000, 0.401260, -0.000000, 0.901766}, 
%% {1.017751, -0.000000, -0.238147, -0.000000, 1.097222, -0.000000, 0.370957, -0.000000, 0.913199}, 
%% {1.005047, -0.000000, -0.223054, -0.000000, 1.073935, -0.000000, 0.341057, -0.000000, 0.924308}, 
%% {0.991274, -0.000000, -0.207884, -0.000000, 1.051823, -0.000000, 0.311032, -0.000000, 0.934772}, 
%% {0.978255, -0.000000, -0.192097, -0.000000, 1.031104, -0.000000, 0.281667, -0.000000, 0.944690}, 
%% {0.965829, -0.000000, -0.176034, -0.000000, 1.011461, -0.000000, 0.253199, -0.000000, 0.953851}, 
%% {0.953272, -0.000000, -0.159935, -0.000000, 0.992715, -0.000000, 0.225787, -0.000000, 0.962119}, 
%% {0.939783, -0.000000, -0.143345, -0.000000, 0.975164, -0.000000, 0.199091, -0.000000, 0.969633}, 
%% {0.927969, -0.000000, -0.126954, -0.000000, 0.958959, -0.000000, 0.174037, -0.000000, 0.976190}, 
%% {0.916196, -0.000000, -0.110326, -0.000000, 0.944617, -0.000000, 0.150426, -0.000000, 0.981886}, 
%% {0.906199, -0.000000, -0.093898, -0.000000, 0.931938, -0.000000, 0.127940, -0.000000, 0.986743}, 
%% {0.897961, -0.000000, -0.077468, -0.000000, 0.920399, -0.000000, 0.105658, -0.000000, 0.990885}, 
%% {0.891169, -0.000000, -0.061466, -0.000000, 0.909780, -0.000000, 0.083677, -0.000000, 0.994229}, 
%% {0.885860, -0.000000, -0.045431, -0.000000, 0.900003, -0.000000, 0.061991, -0.000000, 0.996821}, 
%% {0.882135, -0.000000, -0.029991, -0.000000, 0.890948, -0.000000, 0.040689, -0.000000, 0.998617}, 
%% {0.878440, -0.000000, -0.014666, -0.000000, 0.882190, -0.000000, 0.019883, -0.000000, 0.999668}, 
%% {0.873772, -0.000000, 0.000078, -0.000000, 0.873761, -0.000000, -0.000014, -0.000000, 1.000000}, 
%% {3415.362793, -0.000000, -0.465435, -0.000000, 4998.170898, -0.000000, 2328.545410, -0.000000, 0.682673}, 
%% {1354.677612, -0.000000, -0.465435, -0.000000, 1985.626343, -0.000000, 923.598633, -0.000000, 0.682673}, 
%% {338.725281, -0.000000, -0.465436, -0.000000, 496.081116, -0.000000, 230.937042, -0.000000, 0.682674}, 
%% {150.520981, -0.000000, -0.465432, -0.000000, 220.513550, -0.000000, 102.622833, -0.000000, 0.682676}, 
%% {84.678101, -0.000000, -0.465425, -0.000000, 124.033401, -0.000000, 57.732159, -0.000000, 0.682681}, 
%% {54.189747, -0.000000, -0.465408, -0.000000, 79.381065, -0.000000, 36.945530, -0.000000, 0.682694}, 
%% {37.633778, -0.000000, -0.465379, -0.000000, 55.123966, -0.000000, 25.657831, -0.000000, 0.682716}, 
%% {27.650396, -0.000000, -0.465331, -0.000000, 40.498302, -0.000000, 18.851219, -0.000000, 0.682751}, 
%% {21.166809, -0.000000, -0.465255, -0.000000, 31.003788, -0.000000, 14.430679, -0.000000, 0.682808}, 
%% {16.725424, -0.000000, -0.465149, -0.000000, 24.496826, -0.000000, 11.402429, -0.000000, 0.682888}, 
%% {13.547599, -0.000000, -0.465003, -0.000000, 19.841444, -0.000000, 9.235666, -0.000000, 0.682998}, 
%% {11.196703, -0.000000, -0.464807, -0.000000, 16.395889, -0.000000, 7.632656, -0.000000, 0.683147}, 
%% {9.408729, -0.000000, -0.464554, -0.000000, 13.775715, -0.000000, 6.413400, -0.000000, 0.683340}, 
%% {8.017318, -0.000000, -0.464227, -0.000000, 11.736154, -0.000000, 5.464506, -0.000000, 0.683589}, 
%% {6.914463, -0.000000, -0.463732, -0.000000, 10.118423, -0.000000, 4.712269, -0.000000, 0.683963}, 
%% {6.033463, -0.000000, -0.461983, -0.000000, 8.824224, -0.000000, 4.111135, -0.000000, 0.685210}, 
%% {5.308298, -0.000000, -0.460663, -0.000000, 7.759134, -0.000000, 3.616220, -0.000000, 0.686178}, 
%% {4.706053, -0.000000, -0.459486, -0.000000, 6.874770, -0.000000, 3.205044, -0.000000, 0.687069}, 
%% {4.201192, -0.000000, -0.458352, -0.000000, 6.132644, -0.000000, 2.860194, -0.000000, 0.687951}, 
%% {3.776581, -0.000000, -0.456671, -0.000000, 5.507118, -0.000000, 2.569889, -0.000000, 0.689245}, 
%% {3.416563, -0.000000, -0.454427, -0.000000, 4.975857, -0.000000, 2.323408, -0.000000, 0.690971}, 
%% {3.105729, -0.000000, -0.452483, -0.000000, 4.516526, -0.000000, 2.110354, -0.000000, 0.692536}, 
%% {2.839152, -0.000000, -0.449971, -0.000000, 4.121147, -0.000000, 1.927195, -0.000000, 0.694563}, 
%% {2.607898, -0.000000, -0.447476, -0.000000, 3.776538, -0.000000, 1.767911, -0.000000, 0.696653}, 
%% {2.407317, -0.000000, -0.444741, -0.000000, 3.476139, -0.000000, 1.629261, -0.000000, 0.699001}, 
%% {2.232165, -0.000000, -0.442195, -0.000000, 3.212700, -0.000000, 1.507824, -0.000000, 0.701298}, 
%% {2.080144, -0.000000, -0.439680, -0.000000, 2.980490, -0.000000, 1.401856, -0.000000, 0.703690}, 
%% {1.947672, -0.000000, -0.437231, -0.000000, 2.773802, -0.000000, 1.309130, -0.000000, 0.706115}, 
%% {1.827794, -0.000000, -0.433030, -0.000000, 2.586618, -0.000000, 1.223892, -0.000000, 0.710042}, 
%% {1.722464, -0.000000, -0.427759, -0.000000, 2.418012, -0.000000, 1.147599, -0.000000, 0.715003}, 
%% {1.630264, -0.000000, -0.422169, -0.000000, 2.266308, -0.000000, 1.079505, -0.000000, 0.720454}, 
%% {1.549978, -0.000000, -0.416256, -0.000000, 2.129828, -0.000000, 1.018690, -0.000000, 0.726425}, 
%% {1.478465, -0.000000, -0.410066, -0.000000, 2.007906, -0.000000, 0.962994, -0.000000, 0.732905}, 
%% {1.415759, -0.000000, -0.403602, -0.000000, 1.898186, -0.000000, 0.912596, -0.000000, 0.739839}, 
%% {1.361001, -0.000000, -0.397029, -0.000000, 1.799291, -0.000000, 0.866713, -0.000000, 0.747164}, 
%% {1.313265, -0.000000, -0.390154, -0.000000, 1.710066, -0.000000, 0.824484, -0.000000, 0.755057}, 
%% {1.271204, -0.000000, -0.382733, -0.000000, 1.629848, -0.000000, 0.784949, -0.000000, 0.763668}, 
%% {1.232686, -0.000000, -0.374201, -0.000000, 1.557300, -0.000000, 0.745833, -0.000000, 0.773590}, 
%% {1.199748, -0.000000, -0.365120, -0.000000, 1.490941, -0.000000, 0.709251, -0.000000, 0.784153}, 
%% {1.170622, -0.000000, -0.355658, -0.000000, 1.431918, -0.000000, 0.674307, -0.000000, 0.795132}, 
%% {1.145354, -0.000000, -0.345970, -0.000000, 1.378733, -0.000000, 0.640997, -0.000000, 0.806378}, 
%% {1.122728, -0.000000, -0.335802, -0.000000, 1.330920, -0.000000, 0.607700, -0.000000, 0.818240}, 
%% {1.102299, -0.000000, -0.324507, -0.000000, 1.287077, -0.000000, 0.575180, -0.000000, 0.830672}, 
%% {1.083354, -0.000000, -0.312659, -0.000000, 1.247948, -0.000000, 0.542357, -0.000000, 0.843474}, 
%% {1.066919, -0.000000, -0.300448, -0.000000, 1.212096, -0.000000, 0.510450, -0.000000, 0.856255}, 
%% {1.052257, -0.000000, -0.287762, -0.000000, 1.180289, -0.000000, 0.479182, -0.000000, 0.868958}, 
%% {1.037876, -0.000000, -0.274010, -0.000000, 1.150476, -0.000000, 0.447128, -0.000000, 0.881954}, 
%% {1.024472, -0.000000, -0.259860, -0.000000, 1.123384, -0.000000, 0.415448, -0.000000, 0.894621}, 
%% {1.011185, -0.000000, -0.245356, -0.000000, 1.098052, -0.000000, 0.384289, -0.000000, 0.906755}, 
%% {0.999474, -0.000000, -0.230070, -0.000000, 1.074525, -0.000000, 0.353296, -0.000000, 0.918674}, 
%% {0.987014, -0.000000, -0.214325, -0.000000, 1.052995, -0.000000, 0.322364, -0.000000, 0.930000}, 
%% {0.974597, -0.000000, -0.198384, -0.000000, 1.032400, -0.000000, 0.292225, -0.000000, 0.940516}, 
%% {0.962874, -0.000000, -0.181768, -0.000000, 1.012701, -0.000000, 0.262729, -0.000000, 0.950403}, 
%% {0.951082, -0.000000, -0.165120, -0.000000, 0.993879, -0.000000, 0.234005, -0.000000, 0.959374}, 
%% {0.938242, -0.000000, -0.148216, -0.000000, 0.975834, -0.000000, 0.206250, -0.000000, 0.967418}, 
%% {0.925925, -0.000000, -0.131101, -0.000000, 0.959213, -0.000000, 0.179887, -0.000000, 0.974530}, 
%% {0.914938, -0.000000, -0.114197, -0.000000, 0.944692, -0.000000, 0.155384, -0.000000, 0.980606}, 
%% {0.904707, -0.000000, -0.097094, -0.000000, 0.931671, -0.000000, 0.132209, -0.000000, 0.985811}, 
%% {0.896146, -0.000000, -0.080407, -0.000000, 0.919994, -0.000000, 0.109443, -0.000000, 0.990180}, 
%% {0.889166, -0.000000, -0.063516, -0.000000, 0.909076, -0.000000, 0.086659, -0.000000, 0.993810}, 
%% {0.884125, -0.000000, -0.047208, -0.000000, 0.899255, -0.000000, 0.064149, -0.000000, 0.996575}, 
%% {0.880523, -0.000000, -0.030951, -0.000000, 0.890151, -0.000000, 0.042044, -0.000000, 0.998522}, 
%% {0.877073, -0.000000, -0.015285, -0.000000, 0.881137, -0.000000, 0.020637, -0.000000, 0.999640}, 
%% {0.872444, -0.000000, 0.000132, -0.000000, 0.872462, -0.000000, -0.000092, -0.000000, 1.000000}, 
%% {3300.169189, -0.000000, -0.473963, -0.000000, 4995.312988, -0.000000, 2372.653320, -0.000000, 0.659245}, 
%% {1308.286255, -0.000000, -0.473963, -0.000000, 1985.259399, -0.000000, 940.588684, -0.000000, 0.659246}, 
%% {327.049957, -0.000000, -0.473962, -0.000000, 496.150970, -0.000000, 235.131195, -0.000000, 0.659247}, 
%% {145.326553, -0.000000, -0.473960, -0.000000, 220.501617, -0.000000, 104.481941, -0.000000, 0.659249}, 
%% {81.766663, -0.000000, -0.473950, -0.000000, 124.027939, -0.000000, 58.785759, -0.000000, 0.659256}, 
%% {52.329391, -0.000000, -0.473933, -0.000000, 79.382629, -0.000000, 37.621822, -0.000000, 0.659269}, 
%% {36.345043, -0.000000, -0.473899, -0.000000, 55.119247, -0.000000, 26.129807, -0.000000, 0.659296}, 
%% {26.700018, -0.000000, -0.473847, -0.000000, 40.497276, -0.000000, 19.195429, -0.000000, 0.659337}, 
%% {20.440496, -0.000000, -0.473767, -0.000000, 31.007807, -0.000000, 14.695018, -0.000000, 0.659401}, 
%% {16.151997, -0.000000, -0.473650, -0.000000, 24.496820, -0.000000, 11.611612, -0.000000, 0.659494}, 
%% {13.082794, -0.000000, -0.473490, -0.000000, 19.841312, -0.000000, 9.404826, -0.000000, 0.659622}, 
%% {10.812953, -0.000000, -0.473278, -0.000000, 16.395956, -0.000000, 7.772703, -0.000000, 0.659792}, 
%% {9.086383, -0.000000, -0.473001, -0.000000, 13.775408, -0.000000, 6.531129, -0.000000, 0.660015}, 
%% {7.743282, -0.000000, -0.472644, -0.000000, 11.736038, -0.000000, 5.565208, -0.000000, 0.660304}, 
%% {6.678803, -0.000000, -0.472030, -0.000000, 10.119688, -0.000000, 4.799542, -0.000000, 0.660788}, 
%% {5.828424, -0.000000, -0.470230, -0.000000, 8.825468, -0.000000, 4.187622, -0.000000, 0.662148}, 
%% {5.127025, -0.000000, -0.469048, -0.000000, 7.759023, -0.000000, 3.682825, -0.000000, 0.663075}, 
%% {4.545633, -0.000000, -0.467887, -0.000000, 6.874345, -0.000000, 3.264199, -0.000000, 0.664012}, 
%% {4.058523, -0.000000, -0.466672, -0.000000, 6.132326, -0.000000, 2.913280, -0.000000, 0.665014}, 
%% {3.649998, -0.000000, -0.464663, -0.000000, 5.508673, -0.000000, 2.618627, -0.000000, 0.666636}, 
%% {3.301323, -0.000000, -0.462671, -0.000000, 4.975600, -0.000000, 2.366848, -0.000000, 0.668293}, 
%% {3.001533, -0.000000, -0.460640, -0.000000, 4.516645, -0.000000, 2.150092, -0.000000, 0.670030}, 
%% {2.744638, -0.000000, -0.458013, -0.000000, 4.121389, -0.000000, 1.963863, -0.000000, 0.672279}, 
%% {2.521161, -0.000000, -0.455467, -0.000000, 3.776436, -0.000000, 1.801427, -0.000000, 0.674558}, 
%% {2.327810, -0.000000, -0.452539, -0.000000, 3.475906, -0.000000, 1.660348, -0.000000, 0.677219}, 
%% {2.159251, -0.000000, -0.449777, -0.000000, 3.211649, -0.000000, 1.536864, -0.000000, 0.679868}, 
%% {2.013352, -0.000000, -0.447006, -0.000000, 2.979120, -0.000000, 1.429445, -0.000000, 0.682634}, 
%% {1.885084, -0.000000, -0.444282, -0.000000, 2.772862, -0.000000, 1.334560, -0.000000, 0.685468}, 
%% {1.772034, -0.000000, -0.440746, -0.000000, 2.587009, -0.000000, 1.249896, -0.000000, 0.689122}, 
%% {1.671412, -0.000000, -0.435507, -0.000000, 2.417831, -0.000000, 1.172737, -0.000000, 0.694429}, 
%% {1.584200, -0.000000, -0.429876, -0.000000, 2.265345, -0.000000, 1.104399, -0.000000, 0.700319}, 
%% {1.505684, -0.000000, -0.423912, -0.000000, 2.129551, -0.000000, 1.041429, -0.000000, 0.706795}, 
%% {1.437963, -0.000000, -0.417625, -0.000000, 2.006935, -0.000000, 0.985330, -0.000000, 0.713832}, 
%% {1.379155, -0.000000, -0.411032, -0.000000, 1.896817, -0.000000, 0.934812, -0.000000, 0.721396}, 
%% {1.327156, -0.000000, -0.404357, -0.000000, 1.798055, -0.000000, 0.887951, -0.000000, 0.729460}, 
%% {1.282483, -0.000000, -0.397445, -0.000000, 1.708918, -0.000000, 0.845248, -0.000000, 0.738056}, 
%% {1.243211, -0.000000, -0.390083, -0.000000, 1.628298, -0.000000, 0.805351, -0.000000, 0.747305}, 
%% {1.207793, -0.000000, -0.381934, -0.000000, 1.556099, -0.000000, 0.766775, -0.000000, 0.757527}, 
%% {1.177211, -0.000000, -0.372797, -0.000000, 1.490096, -0.000000, 0.729431, -0.000000, 0.769005}, 
%% {1.150120, -0.000000, -0.363227, -0.000000, 1.431134, -0.000000, 0.693803, -0.000000, 0.780886}, 
%% {1.126541, -0.000000, -0.353481, -0.000000, 1.378113, -0.000000, 0.659242, -0.000000, 0.793146}, 
%% {1.105706, -0.000000, -0.343230, -0.000000, 1.330321, -0.000000, 0.625796, -0.000000, 0.805742}, 
%% {1.086885, -0.000000, -0.332354, -0.000000, 1.287223, -0.000000, 0.592730, -0.000000, 0.818752}, 
%% {1.070285, -0.000000, -0.320295, -0.000000, 1.248028, -0.000000, 0.559495, -0.000000, 0.832565}, 
%% {1.054872, -0.000000, -0.307843, -0.000000, 1.212679, -0.000000, 0.526399, -0.000000, 0.846381}, 
%% {1.041260, -0.000000, -0.294970, -0.000000, 1.180430, -0.000000, 0.493906, -0.000000, 0.860086}, 
%% {1.029091, -0.000000, -0.281468, -0.000000, 1.150660, -0.000000, 0.462082, -0.000000, 0.873615}, 
%% {1.016635, -0.000000, -0.266892, -0.000000, 1.123998, -0.000000, 0.429355, -0.000000, 0.887284}, 
%% {1.005007, -0.000000, -0.252025, -0.000000, 1.099015, -0.000000, 0.397035, -0.000000, 0.900436}, 
%% {0.993616, -0.000000, -0.236736, -0.000000, 1.075478, -0.000000, 0.365362, -0.000000, 0.912950}, 
%% {0.983059, -0.000000, -0.220580, -0.000000, 1.054315, -0.000000, 0.333602, -0.000000, 0.925146}, 
%% {0.970908, -0.000000, -0.204171, -0.000000, 1.033098, -0.000000, 0.302184, -0.000000, 0.936454}, 
%% {0.959229, -0.000000, -0.187518, -0.000000, 1.013565, -0.000000, 0.271723, -0.000000, 0.946881}, 
%% {0.947990, -0.000000, -0.170156, -0.000000, 0.994962, -0.000000, 0.241891, -0.000000, 0.956583}, 
%% {0.936920, -0.000000, -0.152879, -0.000000, 0.976965, -0.000000, 0.213390, -0.000000, 0.965181}, 
%% {0.924270, -0.000000, -0.135365, -0.000000, 0.959641, -0.000000, 0.185751, -0.000000, 0.972795}, 
%% {0.912697, -0.000000, -0.117787, -0.000000, 0.944653, -0.000000, 0.160422, -0.000000, 0.979297}, 
%% {0.902494, -0.000000, -0.100434, -0.000000, 0.931583, -0.000000, 0.136383, -0.000000, 0.984823}, 
%% {0.894290, -0.000000, -0.082826, -0.000000, 0.919518, -0.000000, 0.112856, -0.000000, 0.989548}, 
%% {0.887537, -0.000000, -0.065827, -0.000000, 0.908560, -0.000000, 0.089489, -0.000000, 0.993363}, 
%% {0.882250, -0.000000, -0.048711, -0.000000, 0.898405, -0.000000, 0.066380, -0.000000, 0.996335}, 
%% {0.878892, -0.000000, -0.032142, -0.000000, 0.888987, -0.000000, 0.043556, -0.000000, 0.998407}, 
%% {0.875592, -0.000000, -0.015720, -0.000000, 0.879928, -0.000000, 0.021253, -0.000000, 0.999618}, 
%% {0.871127, -0.000000, 0.000109, -0.000000, 0.871135, -0.000000, -0.000042, -0.000000, 1.000000}, 
%% {3186.866943, -0.000000, -0.481311, -0.000000, 4995.561035, -0.000000, 2413.943848, -0.000000, 0.635423}, 
%% {1260.450195, -0.000000, -0.481311, -0.000000, 1984.805054, -0.000000, 954.748779, -0.000000, 0.635423}, 
%% {315.252716, -0.000000, -0.481311, -0.000000, 496.129211, -0.000000, 238.793167, -0.000000, 0.635424}, 
%% {140.102036, -0.000000, -0.481307, -0.000000, 220.504837, -0.000000, 106.122490, -0.000000, 0.635426}, 
%% {78.815948, -0.000000, -0.481298, -0.000000, 124.035187, -0.000000, 59.700264, -0.000000, 0.635434}, 
%% {50.438000, -0.000000, -0.481278, -0.000000, 79.380775, -0.000000, 38.204762, -0.000000, 0.635451}, 
%% {35.027168, -0.000000, -0.481244, -0.000000, 55.125175, -0.000000, 26.531492, -0.000000, 0.635480}, 
%% {25.735954, -0.000000, -0.481186, -0.000000, 40.496941, -0.000000, 19.493601, -0.000000, 0.635527}, 
%% {19.702948, -0.000000, -0.481100, -0.000000, 31.005493, -0.000000, 14.923588, -0.000000, 0.635601}, 
%% {15.568087, -0.000000, -0.480974, -0.000000, 24.497147, -0.000000, 11.791384, -0.000000, 0.635706}, 
%% {12.610654, -0.000000, -0.480801, -0.000000, 19.841423, -0.000000, 9.551003, -0.000000, 0.635853}, 
%% {10.422691, -0.000000, -0.480570, -0.000000, 16.395994, -0.000000, 7.893440, -0.000000, 0.636049}, 
%% {8.758459, -0.000000, -0.480270, -0.000000, 13.775579, -0.000000, 6.632550, -0.000000, 0.636304}, 
%% {7.463882, -0.000000, -0.479880, -0.000000, 11.736167, -0.000000, 5.651613, -0.000000, 0.636638}, 
%% {6.440352, -0.000000, -0.479009, -0.000000, 10.122499, -0.000000, 4.875904, -0.000000, 0.637348}, 
%% {5.619437, -0.000000, -0.477402, -0.000000, 8.825772, -0.000000, 4.253492, -0.000000, 0.638643}, 
%% {4.943452, -0.000000, -0.476224, -0.000000, 7.759153, -0.000000, 3.740853, -0.000000, 0.639627}, 
%% {4.382619, -0.000000, -0.475102, -0.000000, 6.873880, -0.000000, 3.315367, -0.000000, 0.640595}, 
%% {3.913732, -0.000000, -0.473780, -0.000000, 6.132457, -0.000000, 2.959399, -0.000000, 0.641747}, 
%% {3.520617, -0.000000, -0.471655, -0.000000, 5.509541, -0.000000, 2.660584, -0.000000, 0.643563}, 
%% {3.184173, -0.000000, -0.469735, -0.000000, 4.975791, -0.000000, 2.404584, -0.000000, 0.645271}, 
%% {2.895844, -0.000000, -0.467581, -0.000000, 4.517169, -0.000000, 2.184814, -0.000000, 0.647226}, 
%% {2.648676, -0.000000, -0.464947, -0.000000, 4.121367, -0.000000, 1.995914, -0.000000, 0.649638}, 
%% {2.433457, -0.000000, -0.462252, -0.000000, 3.776768, -0.000000, 1.830983, -0.000000, 0.652192}, 
%% {2.247440, -0.000000, -0.459289, -0.000000, 3.475682, -0.000000, 1.687845, -0.000000, 0.655070}, 
%% {2.085931, -0.000000, -0.456222, -0.000000, 3.211450, -0.000000, 1.562917, -0.000000, 0.658168}, 
%% {1.945219, -0.000000, -0.453293, -0.000000, 2.978066, -0.000000, 1.453530, -0.000000, 0.661285}, 
%% {1.822319, -0.000000, -0.450384, -0.000000, 2.771733, -0.000000, 1.357456, -0.000000, 0.664507}, 
%% {1.715352, -0.000000, -0.447144, -0.000000, 2.586318, -0.000000, 1.273001, -0.000000, 0.668164}, 
%% {1.620358, -0.000000, -0.442151, -0.000000, 2.417211, -0.000000, 1.196126, -0.000000, 0.673610}, 
%% {1.535343, -0.000000, -0.436524, -0.000000, 2.265641, -0.000000, 1.125697, -0.000000, 0.679945}, 
%% {1.461718, -0.000000, -0.430552, -0.000000, 2.129094, -0.000000, 1.062910, -0.000000, 0.686918}, 
%% {1.397699, -0.000000, -0.424226, -0.000000, 2.006028, -0.000000, 1.006403, -0.000000, 0.694539}, 
%% {1.342564, -0.000000, -0.417619, -0.000000, 1.895956, -0.000000, 0.955422, -0.000000, 0.702806}, 
%% {1.293494, -0.000000, -0.410809, -0.000000, 1.796708, -0.000000, 0.908258, -0.000000, 0.711541}, 
%% {1.250633, -0.000000, -0.403856, -0.000000, 1.707220, -0.000000, 0.864470, -0.000000, 0.720845}, 
%% {1.213402, -0.000000, -0.396546, -0.000000, 1.627558, -0.000000, 0.823707, -0.000000, 0.730808}, 
%% {1.181422, -0.000000, -0.388755, -0.000000, 1.555361, -0.000000, 0.785427, -0.000000, 0.741550}, 
%% {1.153308, -0.000000, -0.379867, -0.000000, 1.489931, -0.000000, 0.747976, -0.000000, 0.753638}, 
%% {1.128502, -0.000000, -0.370224, -0.000000, 1.431082, -0.000000, 0.711719, -0.000000, 0.766509}, 
%% {1.106686, -0.000000, -0.360320, -0.000000, 1.377188, -0.000000, 0.676833, -0.000000, 0.779633}, 
%% {1.087739, -0.000000, -0.350008, -0.000000, 1.330317, -0.000000, 0.642639, -0.000000, 0.793215}, 
%% {1.071232, -0.000000, -0.339273, -0.000000, 1.286866, -0.000000, 0.609159, -0.000000, 0.807071}, 
%% {1.057001, -0.000000, -0.327521, -0.000000, 1.248392, -0.000000, 0.575815, -0.000000, 0.821579}, 
%% {1.042996, -0.000000, -0.314845, -0.000000, 1.212823, -0.000000, 0.542095, -0.000000, 0.836360}, 
%% {1.030326, -0.000000, -0.301743, -0.000000, 1.180449, -0.000000, 0.508498, -0.000000, 0.851081}, 
%% {1.018957, -0.000000, -0.288155, -0.000000, 1.151043, -0.000000, 0.475752, -0.000000, 0.865460}, 
%% {1.009128, -0.000000, -0.273673, -0.000000, 1.124325, -0.000000, 0.443239, -0.000000, 0.879795}, 
%% {0.997790, -0.000000, -0.258382, -0.000000, 1.099898, -0.000000, 0.409663, -0.000000, 0.893916}, 
%% {0.987451, -0.000000, -0.242793, -0.000000, 1.076483, -0.000000, 0.376529, -0.000000, 0.907420}, 
%% {0.977672, -0.000000, -0.226719, -0.000000, 1.054652, -0.000000, 0.344403, -0.000000, 0.920134}, 
%% {0.967675, -0.000000, -0.209737, -0.000000, 1.034311, -0.000000, 0.312257, -0.000000, 0.932320}, 
%% {0.956234, -0.000000, -0.192667, -0.000000, 1.014638, -0.000000, 0.280676, -0.000000, 0.943448}, 
%% {0.944921, -0.000000, -0.175303, -0.000000, 0.995532, -0.000000, 0.249578, -0.000000, 0.953698}, 
%% {0.934266, -0.000000, -0.157357, -0.000000, 0.977828, -0.000000, 0.220212, -0.000000, 0.962910}, 
%% {0.922648, -0.000000, -0.139513, -0.000000, 0.960433, -0.000000, 0.191931, -0.000000, 0.970978}, 
%% {0.911050, -0.000000, -0.121433, -0.000000, 0.944335, -0.000000, 0.165123, -0.000000, 0.977991}, 
%% {0.900818, -0.000000, -0.103385, -0.000000, 0.931067, -0.000000, 0.140223, -0.000000, 0.983907}, 
%% {0.892307, -0.000000, -0.085587, -0.000000, 0.919073, -0.000000, 0.116199, -0.000000, 0.988855}, 
%% {0.885427, -0.000000, -0.067728, -0.000000, 0.907894, -0.000000, 0.092171, -0.000000, 0.992950}, 
%% {0.880413, -0.000000, -0.050363, -0.000000, 0.897568, -0.000000, 0.068475, -0.000000, 0.996083}, 
%% {0.877248, -0.000000, -0.033113, -0.000000, 0.887940, -0.000000, 0.044959, -0.000000, 0.998303}, 
%% {0.874193, -0.000000, -0.016324, -0.000000, 0.878834, -0.000000, 0.022069, -0.000000, 0.999588}, 
%% {0.869782, -0.000000, 0.000188, -0.000000, 0.869785, -0.000000, -0.000105, -0.000000, 1.000000}, 
%% {3057.007324, -0.000000, -0.487463, -0.000000, 4994.801270, -0.000000, 2437.869873, -0.000000, 0.611263}, 
%% {1212.896973, -0.000000, -0.487463, -0.000000, 1984.514160, -0.000000, 967.247864, -0.000000, 0.611263}, 
%% {303.269104, -0.000000, -0.487463, -0.000000, 496.094391, -0.000000, 241.846954, -0.000000, 0.611265}, 
%% {134.786438, -0.000000, -0.487459, -0.000000, 220.489471, -0.000000, 107.487885, -0.000000, 0.611267}, 
%% {75.808311, -0.000000, -0.487449, -0.000000, 124.034889, -0.000000, 60.454594, -0.000000, 0.611276}, 
%% {48.520329, -0.000000, -0.487429, -0.000000, 79.382729, -0.000000, 38.693138, -0.000000, 0.611294}, 
%% {33.697884, -0.000000, -0.487390, -0.000000, 55.120792, -0.000000, 26.872623, -0.000000, 0.611328}, 
%% {24.756268, -0.000000, -0.487328, -0.000000, 40.496964, -0.000000, 19.741755, -0.000000, 0.611383}, 
%% {18.954643, -0.000000, -0.487236, -0.000000, 31.004946, -0.000000, 15.114923, -0.000000, 0.611466}, 
%% {14.976961, -0.000000, -0.487100, -0.000000, 24.496801, -0.000000, 11.942640, -0.000000, 0.611586}, 
%% {12.131854, -0.000000, -0.486916, -0.000000, 19.841080, -0.000000, 9.673486, -0.000000, 0.611752}, 
%% {10.026867, -0.000000, -0.486666, -0.000000, 16.395966, -0.000000, 7.994549, -0.000000, 0.611975}, 
%% {8.426276, -0.000000, -0.486345, -0.000000, 13.775433, -0.000000, 6.717787, -0.000000, 0.612265}, 
%% {7.181076, -0.000000, -0.485918, -0.000000, 11.736153, -0.000000, 5.724397, -0.000000, 0.612651}, 
%% {6.199826, -0.000000, -0.484695, -0.000000, 10.126461, -0.000000, 4.941361, -0.000000, 0.613690}, 
%% {5.407669, -0.000000, -0.483352, -0.000000, 8.826693, -0.000000, 4.309042, -0.000000, 0.614846}, 
%% {4.757254, -0.000000, -0.482216, -0.000000, 7.759215, -0.000000, 3.789738, -0.000000, 0.615856}, 
%% {4.217257, -0.000000, -0.481108, -0.000000, 6.873584, -0.000000, 3.358335, -0.000000, 0.616878}, 
%% {3.767230, -0.000000, -0.479635, -0.000000, 6.133189, -0.000000, 2.998550, -0.000000, 0.618231}, 
%% {3.389104, -0.000000, -0.477527, -0.000000, 5.510045, -0.000000, 2.695889, -0.000000, 0.620147}, 
%% {3.065338, -0.000000, -0.475661, -0.000000, 4.975503, -0.000000, 2.436435, -0.000000, 0.621929}, 
%% {2.789445, -0.000000, -0.473240, -0.000000, 4.518011, -0.000000, 2.214862, -0.000000, 0.624240}, 
%% {2.550884, -0.000000, -0.470740, -0.000000, 4.121457, -0.000000, 2.022884, -0.000000, 0.626697}, 
%% {2.344782, -0.000000, -0.467886, -0.000000, 3.777006, -0.000000, 1.856427, -0.000000, 0.629562}, 
%% {2.165998, -0.000000, -0.464909, -0.000000, 3.475626, -0.000000, 1.711371, -0.000000, 0.632673}, 
%% {2.011812, -0.000000, -0.461708, -0.000000, 3.210978, -0.000000, 1.585618, -0.000000, 0.636103}, 
%% {1.876033, -0.000000, -0.458515, -0.000000, 2.977624, -0.000000, 1.474181, -0.000000, 0.639700}, 
%% {1.758840, -0.000000, -0.455376, -0.000000, 2.770228, -0.000000, 1.377335, -0.000000, 0.643398}, 
%% {1.657654, -0.000000, -0.452119, -0.000000, 2.585030, -0.000000, 1.292920, -0.000000, 0.647361}, 
%% {1.566702, -0.000000, -0.447833, -0.000000, 2.417880, -0.000000, 1.215529, -0.000000, 0.652547}, 
%% {1.486900, -0.000000, -0.442210, -0.000000, 2.265259, -0.000000, 1.145394, -0.000000, 0.659356}, 
%% {1.417469, -0.000000, -0.436236, -0.000000, 2.128353, -0.000000, 1.082551, -0.000000, 0.666838}, 
%% {1.356853, -0.000000, -0.429914, -0.000000, 2.005213, -0.000000, 1.025631, -0.000000, 0.675033}, 
%% {1.304372, -0.000000, -0.423348, -0.000000, 1.894503, -0.000000, 0.973925, -0.000000, 0.683903}, 
%% {1.258062, -0.000000, -0.416494, -0.000000, 1.795782, -0.000000, 0.925938, -0.000000, 0.693459}, 
%% {1.218782, -0.000000, -0.409458, -0.000000, 1.706745, -0.000000, 0.882167, -0.000000, 0.703630}, 
%% {1.184717, -0.000000, -0.402212, -0.000000, 1.626725, -0.000000, 0.841367, -0.000000, 0.714356}, 
%% {1.155056, -0.000000, -0.394540, -0.000000, 1.554535, -0.000000, 0.802784, -0.000000, 0.725788}, 
%% {1.129267, -0.000000, -0.386245, -0.000000, 1.489549, -0.000000, 0.765611, -0.000000, 0.738137}, 
%% {1.106581, -0.000000, -0.376616, -0.000000, 1.430248, -0.000000, 0.729101, -0.000000, 0.751856}, 
%% {1.086950, -0.000000, -0.366689, -0.000000, 1.377364, -0.000000, 0.693566, -0.000000, 0.766021}, 
%% {1.069843, -0.000000, -0.356302, -0.000000, 1.330113, -0.000000, 0.658611, -0.000000, 0.780655}, 
%% {1.055053, -0.000000, -0.345533, -0.000000, 1.286901, -0.000000, 0.624648, -0.000000, 0.795425}, 
%% {1.042286, -0.000000, -0.334092, -0.000000, 1.248448, -0.000000, 0.590942, -0.000000, 0.810581}, 
%% {1.030884, -0.000000, -0.321512, -0.000000, 1.213219, -0.000000, 0.557340, -0.000000, 0.826177}, 
%% {1.019726, -0.000000, -0.308173, -0.000000, 1.181007, -0.000000, 0.523024, -0.000000, 0.841936}, 
%% {1.009470, -0.000000, -0.294427, -0.000000, 1.152065, -0.000000, 0.489176, -0.000000, 0.857324}, 
%% {1.000080, -0.000000, -0.280073, -0.000000, 1.125559, -0.000000, 0.455593, -0.000000, 0.872411}, 
%% {0.991326, -0.000000, -0.264663, -0.000000, 1.100592, -0.000000, 0.421960, -0.000000, 0.887346}, 
%% {0.981442, -0.000000, -0.248625, -0.000000, 1.077053, -0.000000, 0.387684, -0.000000, 0.901789}, 
%% {0.972390, -0.000000, -0.232303, -0.000000, 1.056113, -0.000000, 0.354871, -0.000000, 0.915222}, 
%% {0.963547, -0.000000, -0.215375, -0.000000, 1.035835, -0.000000, 0.321970, -0.000000, 0.928032}, 
%% {0.953318, -0.000000, -0.197667, -0.000000, 1.015882, -0.000000, 0.289531, -0.000000, 0.939967}, 
%% {0.942656, -0.000000, -0.179943, -0.000000, 0.996628, -0.000000, 0.257353, -0.000000, 0.950874}, 
%% {0.932177, -0.000000, -0.161749, -0.000000, 0.978525, -0.000000, 0.226725, -0.000000, 0.960659}, 
%% {0.920421, -0.000000, -0.143259, -0.000000, 0.960770, -0.000000, 0.197362, -0.000000, 0.969282}, 
%% {0.909108, -0.000000, -0.124977, -0.000000, 0.944847, -0.000000, 0.170036, -0.000000, 0.976625}, 
%% {0.898801, -0.000000, -0.106404, -0.000000, 0.930670, -0.000000, 0.144268, -0.000000, 0.982921}, 
%% {0.890362, -0.000000, -0.088042, -0.000000, 0.918525, -0.000000, 0.119650, -0.000000, 0.988169}, 
%% {0.883386, -0.000000, -0.069832, -0.000000, 0.907027, -0.000000, 0.094897, -0.000000, 0.992498}, 
%% {0.878491, -0.000000, -0.051811, -0.000000, 0.896624, -0.000000, 0.070558, -0.000000, 0.995839}, 
%% {0.875385, -0.000000, -0.034151, -0.000000, 0.886849, -0.000000, 0.046347, -0.000000, 0.998192}, 
%% {0.872517, -0.000000, -0.016777, -0.000000, 0.877485, -0.000000, 0.022676, -0.000000, 0.999564}, 
%% {0.868279, -0.000000, 0.000091, -0.000000, 0.868262, -0.000000, -0.000016, -0.000000, 1.000000}, 
%% {2935.908936, -0.000000, -0.492403, -0.000000, 4999.764648, -0.000000, 2463.509277, -0.000000, 0.586826}, 
%% {1164.342896, -0.000000, -0.492403, -0.000000, 1985.264282, -0.000000, 976.996643, -0.000000, 0.586826}, 
%% {291.138733, -0.000000, -0.492403, -0.000000, 496.129272, -0.000000, 244.292007, -0.000000, 0.586829}, 
%% {129.423630, -0.000000, -0.492398, -0.000000, 220.492676, -0.000000, 108.598648, -0.000000, 0.586831}, 
%% {72.785965, -0.000000, -0.492389, -0.000000, 124.032494, -0.000000, 61.074089, -0.000000, 0.586841}, 
%% {46.582447, -0.000000, -0.492366, -0.000000, 79.380074, -0.000000, 39.086731, -0.000000, 0.586862}, 
%% {32.349461, -0.000000, -0.492326, -0.000000, 55.122009, -0.000000, 27.143738, -0.000000, 0.586900}, 
%% {23.766792, -0.000000, -0.492260, -0.000000, 40.498627, -0.000000, 19.941906, -0.000000, 0.586961}, 
%% {18.197121, -0.000000, -0.492160, -0.000000, 31.005045, -0.000000, 15.268209, -0.000000, 0.587055}, 
%% {14.378917, -0.000000, -0.492016, -0.000000, 24.496088, -0.000000, 12.064107, -0.000000, 0.587192}, 
%% {11.647704, -0.000000, -0.491816, -0.000000, 19.840799, -0.000000, 9.772102, -0.000000, 0.587380}, 
%% {9.626849, -0.000000, -0.491552, -0.000000, 16.395811, -0.000000, 8.076082, -0.000000, 0.587631}, 
%% {8.090121, -0.000000, -0.491208, -0.000000, 13.775431, -0.000000, 6.786244, -0.000000, 0.587959}, 
%% {6.894865, -0.000000, -0.490739, -0.000000, 11.736477, -0.000000, 5.782887, -0.000000, 0.588406}, 
%% {5.954560, -0.000000, -0.489360, -0.000000, 10.128643, -0.000000, 4.993300, -0.000000, 0.589639}, 
%% {5.192880, -0.000000, -0.488169, -0.000000, 8.826698, -0.000000, 4.353541, -0.000000, 0.590735}, 
%% {4.568166, -0.000000, -0.487063, -0.000000, 7.758862, -0.000000, 3.828636, -0.000000, 0.591786}, 
%% {4.050565, -0.000000, -0.485890, -0.000000, 6.873575, -0.000000, 3.393491, -0.000000, 0.592930}, 
%% {3.619736, -0.000000, -0.484174, -0.000000, 6.134974, -0.000000, 3.030972, -0.000000, 0.594579}, 
%% {3.256043, -0.000000, -0.482245, -0.000000, 5.510066, -0.000000, 2.724594, -0.000000, 0.596467}, 
%% {2.945501, -0.000000, -0.480337, -0.000000, 4.975689, -0.000000, 2.462653, -0.000000, 0.598403}, 
%% {2.680853, -0.000000, -0.477874, -0.000000, 4.518323, -0.000000, 2.238910, -0.000000, 0.600904}, 
%% {2.451836, -0.000000, -0.475410, -0.000000, 4.121396, -0.000000, 2.044812, -0.000000, 0.603512}, 
%% {2.254616, -0.000000, -0.472461, -0.000000, 3.777102, -0.000000, 1.877072, -0.000000, 0.606654}, 
%% {2.084117, -0.000000, -0.469397, -0.000000, 3.475532, -0.000000, 1.731333, -0.000000, 0.610059}, 
%% {1.935383, -0.000000, -0.466110, -0.000000, 3.210705, -0.000000, 1.603483, -0.000000, 0.613824}, 
%% {1.806750, -0.000000, -0.462714, -0.000000, 2.976846, -0.000000, 1.492092, -0.000000, 0.617871}, 
%% {1.695724, -0.000000, -0.459350, -0.000000, 2.769143, -0.000000, 1.395173, -0.000000, 0.622065}, 
%% {1.598034, -0.000000, -0.455958, -0.000000, 2.584327, -0.000000, 1.309043, -0.000000, 0.626498}, 
%% {1.513251, -0.000000, -0.452185, -0.000000, 2.417418, -0.000000, 1.232978, -0.000000, 0.631565}, 
%% {1.438062, -0.000000, -0.446821, -0.000000, 2.265213, -0.000000, 1.163033, -0.000000, 0.638633}, 
%% {1.371887, -0.000000, -0.440938, -0.000000, 2.128607, -0.000000, 1.099285, -0.000000, 0.646679}, 
%% {1.315451, -0.000000, -0.434652, -0.000000, 2.004923, -0.000000, 1.042773, -0.000000, 0.655446}, 
%% {1.265600, -0.000000, -0.428192, -0.000000, 1.894190, -0.000000, 0.990306, -0.000000, 0.664948}, 
%% {1.223564, -0.000000, -0.421433, -0.000000, 1.795044, -0.000000, 0.942951, -0.000000, 0.675219}, 
%% {1.187142, -0.000000, -0.414368, -0.000000, 1.705857, -0.000000, 0.899079, -0.000000, 0.686179}, 
%% {1.155012, -0.000000, -0.407130, -0.000000, 1.625807, -0.000000, 0.857644, -0.000000, 0.697689}, 
%% {1.127993, -0.000000, -0.399488, -0.000000, 1.553744, -0.000000, 0.819003, -0.000000, 0.709943}, 
%% {1.104732, -0.000000, -0.391542, -0.000000, 1.488794, -0.000000, 0.781625, -0.000000, 0.722975}, 
%% {1.084424, -0.000000, -0.382437, -0.000000, 1.430106, -0.000000, 0.745072, -0.000000, 0.737240}, 
%% {1.067411, -0.000000, -0.372520, -0.000000, 1.377601, -0.000000, 0.709440, -0.000000, 0.752410}, 
%% {1.052389, -0.000000, -0.362133, -0.000000, 1.330217, -0.000000, 0.674227, -0.000000, 0.767995}, 
%% {1.039006, -0.000000, -0.351318, -0.000000, 1.287613, -0.000000, 0.639492, -0.000000, 0.783769}, 
%% {1.027115, -0.000000, -0.339878, -0.000000, 1.248824, -0.000000, 0.605186, -0.000000, 0.799741}, 
%% {1.017479, -0.000000, -0.327743, -0.000000, 1.213157, -0.000000, 0.571365, -0.000000, 0.815956}, 
%% {1.008484, -0.000000, -0.314317, -0.000000, 1.181318, -0.000000, 0.536690, -0.000000, 0.832729}, 
%% {0.999790, -0.000000, -0.300347, -0.000000, 1.152750, -0.000000, 0.501950, -0.000000, 0.849209}, 
%% {0.991391, -0.000000, -0.285846, -0.000000, 1.126358, -0.000000, 0.467251, -0.000000, 0.865279}, 
%% {0.984021, -0.000000, -0.270691, -0.000000, 1.101645, -0.000000, 0.433389, -0.000000, 0.880781}, 
%% {0.975582, -0.000000, -0.254335, -0.000000, 1.078547, -0.000000, 0.399267, -0.000000, 0.895911}, 
%% {0.966887, -0.000000, -0.237580, -0.000000, 1.056875, -0.000000, 0.364654, -0.000000, 0.910398}, 
%% {0.958372, -0.000000, -0.220501, -0.000000, 1.036198, -0.000000, 0.330916, -0.000000, 0.923863}, 
%% {0.949261, -0.000000, -0.202689, -0.000000, 1.017121, -0.000000, 0.297601, -0.000000, 0.936455}, 
%% {0.939749, -0.000000, -0.184338, -0.000000, 0.998023, -0.000000, 0.264973, -0.000000, 0.948024}, 
%% {0.929757, -0.000000, -0.165930, -0.000000, 0.979257, -0.000000, 0.233533, -0.000000, 0.958322}, 
%% {0.918102, -0.000000, -0.147163, -0.000000, 0.961304, -0.000000, 0.202888, -0.000000, 0.967479}, 
%% {0.906932, -0.000000, -0.128157, -0.000000, 0.944880, -0.000000, 0.174363, -0.000000, 0.975361}, 
%% {0.896801, -0.000000, -0.109387, -0.000000, 0.930613, -0.000000, 0.147993, -0.000000, 0.981949}, 
%% {0.888220, -0.000000, -0.090371, -0.000000, 0.917798, -0.000000, 0.122777, -0.000000, 0.987508}, 
%% {0.881412, -0.000000, -0.071814, -0.000000, 0.906299, -0.000000, 0.097554, -0.000000, 0.992052}, 
%% {0.876504, -0.000000, -0.053266, -0.000000, 0.895519, -0.000000, 0.072462, -0.000000, 0.995596}, 
%% {0.873614, -0.000000, -0.035125, -0.000000, 0.885703, -0.000000, 0.047617, -0.000000, 0.998085}, 
%% {0.870757, -0.000000, -0.017335, -0.000000, 0.876126, -0.000000, 0.023456, -0.000000, 0.999533}, 
%% {0.866662, -0.000000, 0.000177, -0.000000, 0.866647, -0.000000, -0.000106, -0.000000, 1.000000}, 
%% {2820.871338, -0.000000, -0.496120, -0.000000, 4989.695801, -0.000000, 2489.420654, -0.000000, 0.562174}, 
%% {1115.485962, -0.000000, -0.496119, -0.000000, 1983.716797, -0.000000, 984.420715, -0.000000, 0.562173}, 
%% {278.906555, -0.000000, -0.496119, -0.000000, 496.172760, -0.000000, 246.134430, -0.000000, 0.562176}, 
%% {123.947845, -0.000000, -0.496114, -0.000000, 220.532394, -0.000000, 109.383888, -0.000000, 0.562180}, 
%% {69.729118, -0.000000, -0.496103, -0.000000, 124.026428, -0.000000, 61.535694, -0.000000, 0.562191}, 
%% {44.627190, -0.000000, -0.496079, -0.000000, 79.377129, -0.000000, 39.383133, -0.000000, 0.562214}, 
%% {30.992508, -0.000000, -0.496037, -0.000000, 55.119987, -0.000000, 27.350294, -0.000000, 0.562257}, 
%% {22.769808, -0.000000, -0.495967, -0.000000, 40.497128, -0.000000, 20.093578, -0.000000, 0.562326}, 
%% {17.433109, -0.000000, -0.495860, -0.000000, 31.004826, -0.000000, 15.383715, -0.000000, 0.562432}, 
%% {13.774650, -0.000000, -0.495708, -0.000000, 24.496580, -0.000000, 12.154855, -0.000000, 0.562584}, 
%% {11.158676, -0.000000, -0.495494, -0.000000, 19.840496, -0.000000, 9.846017, -0.000000, 0.562793}, 
%% {9.222801, -0.000000, -0.495216, -0.000000, 16.395847, -0.000000, 8.137158, -0.000000, 0.563078}, 
%% {7.751132, -0.000000, -0.494850, -0.000000, 13.775875, -0.000000, 6.837970, -0.000000, 0.563448}, 
%% {6.606708, -0.000000, -0.494322, -0.000000, 11.736980, -0.000000, 5.827559, -0.000000, 0.563975}, 
%% {5.706757, -0.000000, -0.492881, -0.000000, 10.129965, -0.000000, 5.032697, -0.000000, 0.565336}, 
%% {4.976617, -0.000000, -0.491713, -0.000000, 8.827678, -0.000000, 4.387668, -0.000000, 0.566478}, 
%% {4.377506, -0.000000, -0.490676, -0.000000, 7.758569, -0.000000, 3.858163, -0.000000, 0.567538}, 
%% {3.882285, -0.000000, -0.489426, -0.000000, 6.873947, -0.000000, 3.420225, -0.000000, 0.568824}, 
%% {3.470510, -0.000000, -0.487582, -0.000000, 6.136164, -0.000000, 3.055728, -0.000000, 0.570692}, 
%% {3.121286, -0.000000, -0.485815, -0.000000, 5.510012, -0.000000, 2.746243, -0.000000, 0.572559}, 
%% {2.824723, -0.000000, -0.483780, -0.000000, 4.976309, -0.000000, 2.483030, -0.000000, 0.574741}, 
%% {2.571040, -0.000000, -0.481378, -0.000000, 4.518661, -0.000000, 2.257325, -0.000000, 0.577359}, 
%% {2.352378, -0.000000, -0.478803, -0.000000, 4.122107, -0.000000, 2.062253, -0.000000, 0.580249}, 
%% {2.164106, -0.000000, -0.475922, -0.000000, 3.777131, -0.000000, 1.893653, -0.000000, 0.583555}, 
%% {2.000895, -0.000000, -0.472722, -0.000000, 3.475923, -0.000000, 1.746735, -0.000000, 0.587324}, 
%% {1.859573, -0.000000, -0.469375, -0.000000, 3.210942, -0.000000, 1.618661, -0.000000, 0.591434}, 
%% {1.737339, -0.000000, -0.465941, -0.000000, 2.976248, -0.000000, 1.506968, -0.000000, 0.595843}, 
%% {1.630464, -0.000000, -0.462379, -0.000000, 2.768673, -0.000000, 1.408530, -0.000000, 0.600559}, 
%% {1.538769, -0.000000, -0.458840, -0.000000, 2.583039, -0.000000, 1.322917, -0.000000, 0.605524}, 
%% {1.459408, -0.000000, -0.455163, -0.000000, 2.416198, -0.000000, 1.247552, -0.000000, 0.610911}, 
%% {1.388175, -0.000000, -0.450463, -0.000000, 2.265847, -0.000000, 1.177662, -0.000000, 0.617848}, 
%% {1.326243, -0.000000, -0.444683, -0.000000, 2.128711, -0.000000, 1.114333, -0.000000, 0.626370}, 
%% {1.273801, -0.000000, -0.438514, -0.000000, 2.004766, -0.000000, 1.057963, -0.000000, 0.635790}, 
%% {1.228525, -0.000000, -0.432092, -0.000000, 1.893305, -0.000000, 1.006492, -0.000000, 0.646001}, 
%% {1.187650, -0.000000, -0.425466, -0.000000, 1.794998, -0.000000, 0.957510, -0.000000, 0.656980}, 
%% {1.153984, -0.000000, -0.418481, -0.000000, 1.705435, -0.000000, 0.913548, -0.000000, 0.668711}, 
%% {1.125337, -0.000000, -0.411325, -0.000000, 1.625232, -0.000000, 0.872584, -0.000000, 0.681060}, 
%% {1.100892, -0.000000, -0.403831, -0.000000, 1.553309, -0.000000, 0.833533, -0.000000, 0.694242}, 
%% {1.079717, -0.000000, -0.396024, -0.000000, 1.488939, -0.000000, 0.796100, -0.000000, 0.708003}, 
%% {1.061960, -0.000000, -0.387514, -0.000000, 1.430759, -0.000000, 0.759940, -0.000000, 0.722695}, 
%% {1.046636, -0.000000, -0.377826, -0.000000, 1.377809, -0.000000, 0.723798, -0.000000, 0.738716}, 
%% {1.033811, -0.000000, -0.367413, -0.000000, 1.329836, -0.000000, 0.688664, -0.000000, 0.755251}, 
%% {1.022764, -0.000000, -0.356601, -0.000000, 1.287614, -0.000000, 0.653474, -0.000000, 0.772157}, 
%% {1.012905, -0.000000, -0.345171, -0.000000, 1.248876, -0.000000, 0.618900, -0.000000, 0.789095}, 
%% {1.004131, -0.000000, -0.333137, -0.000000, 1.214772, -0.000000, 0.584281, -0.000000, 0.806155}, 
%% {0.997151, -0.000000, -0.320139, -0.000000, 1.182434, -0.000000, 0.549938, -0.000000, 0.823440}, 
%% {0.989995, -0.000000, -0.305924, -0.000000, 1.153422, -0.000000, 0.514498, -0.000000, 0.841012}, 
%% {0.982703, -0.000000, -0.291242, -0.000000, 1.127249, -0.000000, 0.479073, -0.000000, 0.858018}, 
%% {0.975931, -0.000000, -0.275899, -0.000000, 1.102468, -0.000000, 0.444361, -0.000000, 0.874378}, 
%% {0.969690, -0.000000, -0.259884, -0.000000, 1.079714, -0.000000, 0.409796, -0.000000, 0.890172}, 
%% {0.961978, -0.000000, -0.242735, -0.000000, 1.058215, -0.000000, 0.374543, -0.000000, 0.905492}, 
%% {0.953494, -0.000000, -0.225218, -0.000000, 1.037377, -0.000000, 0.339854, -0.000000, 0.919726}, 
%% {0.945899, -0.000000, -0.207349, -0.000000, 1.017771, -0.000000, 0.305610, -0.000000, 0.933008}, 
%% {0.936203, -0.000000, -0.188727, -0.000000, 0.998873, -0.000000, 0.272253, -0.000000, 0.945117}, 
%% {0.926448, -0.000000, -0.169814, -0.000000, 0.980181, -0.000000, 0.239656, -0.000000, 0.956072}, 
%% {0.916654, -0.000000, -0.150798, -0.000000, 0.962067, -0.000000, 0.208742, -0.000000, 0.965660}, 
%% {0.905156, -0.000000, -0.131397, -0.000000, 0.944728, -0.000000, 0.178713, -0.000000, 0.974057}, 
%% {0.894592, -0.000000, -0.112002, -0.000000, 0.930024, -0.000000, 0.151703, -0.000000, 0.981007}, 
%% {0.885873, -0.000000, -0.092947, -0.000000, 0.917346, -0.000000, 0.125990, -0.000000, 0.986781}, 
%% {0.879155, -0.000000, -0.073518, -0.000000, 0.905360, -0.000000, 0.100049, -0.000000, 0.991634}, 
%% {0.874339, -0.000000, -0.054724, -0.000000, 0.894722, -0.000000, 0.074462, -0.000000, 0.995340}, 
%% {0.871509, -0.000000, -0.036059, -0.000000, 0.884413, -0.000000, 0.048967, -0.000000, 0.997974}, 
%% {0.869032, -0.000000, -0.017757, -0.000000, 0.874681, -0.000000, 0.024032, -0.000000, 0.999509}, 
%% {0.865000, -0.000000, 0.000084, -0.000000, 0.864956, -0.000000, -0.000040, -0.000000, 1.000000}, 
%% {2690.174805, -0.000000, -0.498602, -0.000000, 4995.273926, -0.000000, 2496.098389, -0.000000, 0.537368}, 
%% {1066.438477, -0.000000, -0.498602, -0.000000, 1984.392700, -0.000000, 989.504272, -0.000000, 0.537367}, 
%% {266.568878, -0.000000, -0.498601, -0.000000, 496.119629, -0.000000, 247.337280, -0.000000, 0.537370}, 
%% {118.486626, -0.000000, -0.498594, -0.000000, 220.489380, -0.000000, 109.939835, -0.000000, 0.537371}, 
%% {66.652344, -0.000000, -0.498584, -0.000000, 124.029060, -0.000000, 61.843689, -0.000000, 0.537386}, 
%% {42.673195, -0.000000, -0.498559, -0.000000, 79.369949, -0.000000, 39.594345, -0.000000, 0.537412}, 
%% {29.624750, -0.000000, -0.498515, -0.000000, 55.123375, -0.000000, 27.487007, -0.000000, 0.537459}, 
%% {21.764833, -0.000000, -0.498440, -0.000000, 40.498215, -0.000000, 20.193811, -0.000000, 0.537538}, 
%% {16.664732, -0.000000, -0.498328, -0.000000, 31.004614, -0.000000, 15.461394, -0.000000, 0.537655}, 
%% {13.167280, -0.000000, -0.498167, -0.000000, 24.496881, -0.000000, 12.215961, -0.000000, 0.537825}, 
%% {10.667262, -0.000000, -0.497945, -0.000000, 19.839138, -0.000000, 9.895915, -0.000000, 0.538061}, 
%% {8.816343, -0.000000, -0.497648, -0.000000, 16.395039, -0.000000, 8.178125, -0.000000, 0.538377}, 
%% {7.409781, -0.000000, -0.497260, -0.000000, 13.775126, -0.000000, 6.872605, -0.000000, 0.538789}, 
%% {6.317311, -0.000000, -0.496620, -0.000000, 11.738427, -0.000000, 5.858405, -0.000000, 0.539456}, 
%% {5.456858, -0.000000, -0.495192, -0.000000, 10.131258, -0.000000, 5.059297, -0.000000, 0.540886}, 
%% {4.758111, -0.000000, -0.494132, -0.000000, 8.827376, -0.000000, 4.410218, -0.000000, 0.541997}, 
%% {4.186193, -0.000000, -0.493037, -0.000000, 7.758951, -0.000000, 3.878700, -0.000000, 0.543178}, 
%% {3.713005, -0.000000, -0.491754, -0.000000, 6.874314, -0.000000, 3.438627, -0.000000, 0.544584}, 
%% {3.319788, -0.000000, -0.489885, -0.000000, 6.136633, -0.000000, 3.072564, -0.000000, 0.546597}, 
%% {2.986095, -0.000000, -0.488138, -0.000000, 5.510201, -0.000000, 2.761546, -0.000000, 0.548569}, 
%% {2.703361, -0.000000, -0.485964, -0.000000, 4.977631, -0.000000, 2.497557, -0.000000, 0.551032}, 
%% {2.460648, -0.000000, -0.483676, -0.000000, 4.518935, -0.000000, 2.270417, -0.000000, 0.553717}, 
%% {2.252604, -0.000000, -0.481013, -0.000000, 4.122883, -0.000000, 2.075095, -0.000000, 0.556891}, 
%% {2.072990, -0.000000, -0.478159, -0.000000, 3.777764, -0.000000, 1.905740, -0.000000, 0.560419}, 
%% {1.917258, -0.000000, -0.474981, -0.000000, 3.475935, -0.000000, 1.758141, -0.000000, 0.564438}, 
%% {1.783222, -0.000000, -0.471569, -0.000000, 3.211034, -0.000000, 1.630116, -0.000000, 0.568919}, 
%% {1.666601, -0.000000, -0.468033, -0.000000, 2.976420, -0.000000, 1.517786, -0.000000, 0.573759}, 
%% {1.566396, -0.000000, -0.464402, -0.000000, 2.768147, -0.000000, 1.420072, -0.000000, 0.578980}, 
%% {1.479990, -0.000000, -0.460701, -0.000000, 2.581748, -0.000000, 1.334830, -0.000000, 0.584485}, 
%% {1.403747, -0.000000, -0.457029, -0.000000, 2.415764, -0.000000, 1.258093, -0.000000, 0.590392}, 
%% {1.338444, -0.000000, -0.452908, -0.000000, 2.265990, -0.000000, 1.190325, -0.000000, 0.597214}, 
%% {1.281408, -0.000000, -0.447451, -0.000000, 2.128295, -0.000000, 1.128144, -0.000000, 0.606067}, 
%% {1.230857, -0.000000, -0.441493, -0.000000, 2.004830, -0.000000, 1.070482, -0.000000, 0.616032}, 
%% {1.188971, -0.000000, -0.435214, -0.000000, 1.894034, -0.000000, 1.019120, -0.000000, 0.626959}, 
%% {1.152313, -0.000000, -0.428713, -0.000000, 1.794205, -0.000000, 0.971334, -0.000000, 0.638620}, 
%% {1.121552, -0.000000, -0.421854, -0.000000, 1.704975, -0.000000, 0.927341, -0.000000, 0.651196}, 
%% {1.095584, -0.000000, -0.414827, -0.000000, 1.624693, -0.000000, 0.886208, -0.000000, 0.664450}, 
%% {1.073863, -0.000000, -0.407439, -0.000000, 1.552757, -0.000000, 0.847405, -0.000000, 0.678482}, 
%% {1.054957, -0.000000, -0.399799, -0.000000, 1.488367, -0.000000, 0.809747, -0.000000, 0.693129}, 
%% {1.039394, -0.000000, -0.391569, -0.000000, 1.430803, -0.000000, 0.773660, -0.000000, 0.708540}, 
%% {1.026170, -0.000000, -0.382601, -0.000000, 1.378078, -0.000000, 0.737609, -0.000000, 0.724987}, 
%% {1.015342, -0.000000, -0.372274, -0.000000, 1.331167, -0.000000, 0.702369, -0.000000, 0.742477}, 
%% {1.005961, -0.000000, -0.361496, -0.000000, 1.288110, -0.000000, 0.666633, -0.000000, 0.760443}, 
%% {0.998922, -0.000000, -0.350109, -0.000000, 1.249236, -0.000000, 0.632209, -0.000000, 0.778419}, 
%% {0.991478, -0.000000, -0.338035, -0.000000, 1.215275, -0.000000, 0.597028, -0.000000, 0.796449}, 
%% {0.985279, -0.000000, -0.325314, -0.000000, 1.183322, -0.000000, 0.562121, -0.000000, 0.814402}, 
%% {0.979578, -0.000000, -0.311363, -0.000000, 1.154420, -0.000000, 0.526671, -0.000000, 0.832596}, 
%% {0.973647, -0.000000, -0.296403, -0.000000, 1.127779, -0.000000, 0.490523, -0.000000, 0.850672}, 
%% {0.968103, -0.000000, -0.280866, -0.000000, 1.103526, -0.000000, 0.454664, -0.000000, 0.868093}, 
%% {0.962471, -0.000000, -0.264782, -0.000000, 1.080744, -0.000000, 0.419276, -0.000000, 0.884655}, 
%% {0.955884, -0.000000, -0.247843, -0.000000, 1.058825, -0.000000, 0.383528, -0.000000, 0.900558}, 
%% {0.949211, -0.000000, -0.229826, -0.000000, 1.038115, -0.000000, 0.348442, -0.000000, 0.915634}, 
%% {0.942177, -0.000000, -0.211590, -0.000000, 1.019040, -0.000000, 0.313636, -0.000000, 0.929565}, 
%% {0.933263, -0.000000, -0.193033, -0.000000, 0.999873, -0.000000, 0.279240, -0.000000, 0.942243}, 
%% {0.923196, -0.000000, -0.173646, -0.000000, 0.980656, -0.000000, 0.245743, -0.000000, 0.953778}, 
%% {0.913768, -0.000000, -0.154095, -0.000000, 0.962117, -0.000000, 0.213578, -0.000000, 0.963983}, 
%% {0.902552, -0.000000, -0.134630, -0.000000, 0.945014, -0.000000, 0.183391, -0.000000, 0.972644}, 
%% {0.892581, -0.000000, -0.114775, -0.000000, 0.929719, -0.000000, 0.155236, -0.000000, 0.980039}, 
%% {0.884011, -0.000000, -0.094889, -0.000000, 0.916587, -0.000000, 0.128651, -0.000000, 0.986191}, 
%% {0.877004, -0.000000, -0.075600, -0.000000, 0.904565, -0.000000, 0.102513, -0.000000, 0.991163}, 
%% {0.872124, -0.000000, -0.055965, -0.000000, 0.893400, -0.000000, 0.076213, -0.000000, 0.995109}, 
%% {0.869462, -0.000000, -0.036978, -0.000000, 0.883129, -0.000000, 0.050197, -0.000000, 0.997865}, 
%% {0.867184, -0.000000, -0.018220, -0.000000, 0.873153, -0.000000, 0.024639, -0.000000, 0.999482}, 
%% {0.863255, -0.000000, 0.000136, -0.000000, 0.863167, -0.000000, -0.000091, -0.000000, 1.000000}, 
%% {2562.766602, -0.000000, -0.499845, -0.000000, 4998.934570, -0.000000, 2499.634521, -0.000000, 0.512468}, 
%% {1017.151184, -0.000000, -0.499846, -0.000000, 1984.413696, -0.000000, 992.093445, -0.000000, 0.512468}, 
%% {254.296921, -0.000000, -0.499844, -0.000000, 496.011688, -0.000000, 248.031479, -0.000000, 0.512471}, 
%% {113.001472, -0.000000, -0.499838, -0.000000, 220.495575, -0.000000, 110.218208, -0.000000, 0.512473}, 
%% {63.564983, -0.000000, -0.499826, -0.000000, 124.028336, -0.000000, 61.998875, -0.000000, 0.512489}, 
%% {40.684803, -0.000000, -0.499800, -0.000000, 79.381332, -0.000000, 39.682182, -0.000000, 0.512517}, 
%% {28.247860, -0.000000, -0.499754, -0.000000, 55.126713, -0.000000, 27.551279, -0.000000, 0.512570}, 
%% {20.756201, -0.000000, -0.499676, -0.000000, 40.499310, -0.000000, 20.243956, -0.000000, 0.512655}, 
%% {15.892515, -0.000000, -0.499558, -0.000000, 31.003958, -0.000000, 15.499787, -0.000000, 0.512787}, 
%% {12.556694, -0.000000, -0.499388, -0.000000, 24.498104, -0.000000, 12.245837, -0.000000, 0.512975}, 
%% {10.172862, -0.000000, -0.499154, -0.000000, 19.840443, -0.000000, 9.920302, -0.000000, 0.513239}, 
%% {8.408839, -0.000000, -0.498843, -0.000000, 16.395702, -0.000000, 8.199277, -0.000000, 0.513589}, 
%% {7.067338, -0.000000, -0.498434, -0.000000, 13.775210, -0.000000, 6.890310, -0.000000, 0.514051}, 
%% {6.028542, -0.000000, -0.497526, -0.000000, 11.743303, -0.000000, 5.876481, -0.000000, 0.515023}, 
%% {5.205636, -0.000000, -0.496329, -0.000000, 10.131906, -0.000000, 5.073098, -0.000000, 0.516308}, 
%% {4.539128, -0.000000, -0.495301, -0.000000, 8.827377, -0.000000, 4.422204, -0.000000, 0.517458}, 
%% {3.993721, -0.000000, -0.494187, -0.000000, 7.759238, -0.000000, 3.889294, -0.000000, 0.518735}, 
%% {3.543516, -0.000000, -0.492799, -0.000000, 6.875320, -0.000000, 3.449052, -0.000000, 0.520338}, 
%% {3.168145, -0.000000, -0.491018, -0.000000, 6.136949, -0.000000, 3.081604, -0.000000, 0.522395}, 
%% {2.850176, -0.000000, -0.489265, -0.000000, 5.510548, -0.000000, 2.769959, -0.000000, 0.524505}, 
%% {2.581279, -0.000000, -0.487015, -0.000000, 4.978701, -0.000000, 2.505867, -0.000000, 0.527213}, 
%% {2.350295, -0.000000, -0.484753, -0.000000, 4.519710, -0.000000, 2.278488, -0.000000, 0.530057}, 
%% {2.152443, -0.000000, -0.482088, -0.000000, 4.123621, -0.000000, 2.083010, -0.000000, 0.533463}, 
%% {1.981505, -0.000000, -0.479181, -0.000000, 3.778742, -0.000000, 1.913355, -0.000000, 0.537299}, 
%% {1.833999, -0.000000, -0.476036, -0.000000, 3.476994, -0.000000, 1.766153, -0.000000, 0.541574}, 
%% {1.706844, -0.000000, -0.472641, -0.000000, 3.211067, -0.000000, 1.638096, -0.000000, 0.546396}, 
%% {1.596250, -0.000000, -0.469111, -0.000000, 2.976256, -0.000000, 1.525745, -0.000000, 0.551609}, 
%% {1.502207, -0.000000, -0.465408, -0.000000, 2.767164, -0.000000, 1.428790, -0.000000, 0.557337}, 
%% {1.419764, -0.000000, -0.461646, -0.000000, 2.581228, -0.000000, 1.342706, -0.000000, 0.563410}, 
%% {1.349452, -0.000000, -0.457946, -0.000000, 2.414001, -0.000000, 1.267564, -0.000000, 0.569843}, 
%% {1.288384, -0.000000, -0.454009, -0.000000, 2.265344, -0.000000, 1.200091, -0.000000, 0.577104}, 
%% {1.235190, -0.000000, -0.449214, -0.000000, 2.129058, -0.000000, 1.138721, -0.000000, 0.585869}, 
%% {1.189125, -0.000000, -0.443499, -0.000000, 2.004962, -0.000000, 1.082099, -0.000000, 0.596418}, 
%% {1.150607, -0.000000, -0.437414, -0.000000, 1.893689, -0.000000, 1.031225, -0.000000, 0.607971}, 
%% {1.118369, -0.000000, -0.431182, -0.000000, 1.793539, -0.000000, 0.984529, -0.000000, 0.620420}, 
%% {1.089139, -0.000000, -0.424523, -0.000000, 1.705020, -0.000000, 0.939618, -0.000000, 0.633757}, 
%% {1.065907, -0.000000, -0.417664, -0.000000, 1.624650, -0.000000, 0.898715, -0.000000, 0.647848}, 
%% {1.046209, -0.000000, -0.410460, -0.000000, 1.552491, -0.000000, 0.859517, -0.000000, 0.662785}, 
%% {1.029947, -0.000000, -0.402908, -0.000000, 1.488286, -0.000000, 0.822243, -0.000000, 0.678344}, 
%% {1.016749, -0.000000, -0.394929, -0.000000, 1.430527, -0.000000, 0.786250, -0.000000, 0.694602}, 
%% {1.005806, -0.000000, -0.386334, -0.000000, 1.378956, -0.000000, 0.751003, -0.000000, 0.711537}, 
%% {0.996624, -0.000000, -0.376669, -0.000000, 1.331368, -0.000000, 0.715080, -0.000000, 0.729739}, 
%% {0.989173, -0.000000, -0.365852, -0.000000, 1.288387, -0.000000, 0.679517, -0.000000, 0.748677}, 
%% {0.982837, -0.000000, -0.354516, -0.000000, 1.249988, -0.000000, 0.644124, -0.000000, 0.767660}, 
%% {0.978318, -0.000000, -0.342500, -0.000000, 1.215477, -0.000000, 0.609183, -0.000000, 0.786731}, 
%% {0.973097, -0.000000, -0.329822, -0.000000, 1.184461, -0.000000, 0.573334, -0.000000, 0.805674}, 
%% {0.968926, -0.000000, -0.316284, -0.000000, 1.155304, -0.000000, 0.537759, -0.000000, 0.824461}, 
%% {0.965432, -0.000000, -0.301407, -0.000000, 1.129207, -0.000000, 0.501633, -0.000000, 0.843391}, 
%% {0.960573, -0.000000, -0.285649, -0.000000, 1.104833, -0.000000, 0.465018, -0.000000, 0.861716}, 
%% {0.955154, -0.000000, -0.269289, -0.000000, 1.082054, -0.000000, 0.428540, -0.000000, 0.879181}, 
%% {0.950250, -0.000000, -0.252411, -0.000000, 1.059911, -0.000000, 0.392502, -0.000000, 0.895742}, 
%% {0.944248, -0.000000, -0.234487, -0.000000, 1.039690, -0.000000, 0.356292, -0.000000, 0.911521}, 
%% {0.937853, -0.000000, -0.215690, -0.000000, 1.019800, -0.000000, 0.321073, -0.000000, 0.926159}, 
%% {0.929464, -0.000000, -0.196718, -0.000000, 1.000644, -0.000000, 0.286112, -0.000000, 0.939445}, 
%% {0.920697, -0.000000, -0.177441, -0.000000, 0.981370, -0.000000, 0.251689, -0.000000, 0.951493}, 
%% {0.911483, -0.000000, -0.157437, -0.000000, 0.963400, -0.000000, 0.218973, -0.000000, 0.962178}, 
%% {0.899974, -0.000000, -0.137372, -0.000000, 0.944631, -0.000000, 0.187484, -0.000000, 0.971382}, 
%% {0.890018, -0.000000, -0.117421, -0.000000, 0.929253, -0.000000, 0.158638, -0.000000, 0.979071}, 
%% {0.881023, -0.000000, -0.097222, -0.000000, 0.915724, -0.000000, 0.131707, -0.000000, 0.985466}, 
%% {0.874665, -0.000000, -0.077083, -0.000000, 0.903571, -0.000000, 0.104674, -0.000000, 0.990775}, 
%% {0.870059, -0.000000, -0.057484, -0.000000, 0.892263, -0.000000, 0.078068, -0.000000, 0.994842}, 
%% {0.867382, -0.000000, -0.037743, -0.000000, 0.881588, -0.000000, 0.051395, -0.000000, 0.997764}, 
%% {0.865174, -0.000000, -0.018682, -0.000000, 0.871668, -0.000000, 0.025211, -0.000000, 0.999456}, 
%% {0.861422, -0.000000, 0.000095, -0.000000, 0.861349, -0.000000, -0.000030, -0.000000, 1.000000}, 
%% {2430.332275, -0.000000, -0.499845, -0.000000, 4994.853027, -0.000000, 2491.681152, -0.000000, 0.487537}, 
%% {968.020630, -0.000000, -0.499846, -0.000000, 1983.211182, -0.000000, 992.450378, -0.000000, 0.487540}, 
%% {241.910660, -0.000000, -0.499845, -0.000000, 496.101044, -0.000000, 248.015793, -0.000000, 0.487541}, 
%% {107.498352, -0.000000, -0.499835, -0.000000, 220.496140, -0.000000, 110.213203, -0.000000, 0.487542}, 
%% {60.465393, -0.000000, -0.499826, -0.000000, 124.035896, -0.000000, 61.991314, -0.000000, 0.487560}, 
%% {38.697868, -0.000000, -0.499799, -0.000000, 79.387169, -0.000000, 39.674061, -0.000000, 0.487593}, 
%% {26.877274, -0.000000, -0.499749, -0.000000, 55.124283, -0.000000, 27.554983, -0.000000, 0.487649}, 
%% {19.746855, -0.000000, -0.499669, -0.000000, 40.497417, -0.000000, 20.244272, -0.000000, 0.487745}, 
%% {15.120335, -0.000000, -0.499546, -0.000000, 31.005312, -0.000000, 15.500643, -0.000000, 0.487890}, 
%% {11.948077, -0.000000, -0.499370, -0.000000, 24.501167, -0.000000, 12.247850, -0.000000, 0.488101}, 
%% {9.678677, -0.000000, -0.499125, -0.000000, 19.840372, -0.000000, 9.920808, -0.000000, 0.488388}, 
%% {8.000386, -0.000000, -0.498800, -0.000000, 16.395533, -0.000000, 8.199662, -0.000000, 0.488776}, 
%% {6.724576, -0.000000, -0.498367, -0.000000, 13.775453, -0.000000, 6.891079, -0.000000, 0.489293}, 
%% {5.738425, -0.000000, -0.497295, -0.000000, 11.746628, -0.000000, 5.879333, -0.000000, 0.490494}, 
%% {4.954414, -0.000000, -0.496232, -0.000000, 10.133047, -0.000000, 5.074697, -0.000000, 0.491721}, 
%% {4.320072, -0.000000, -0.495200, -0.000000, 8.828068, -0.000000, 4.423497, -0.000000, 0.492944}, 
%% {3.801014, -0.000000, -0.494140, -0.000000, 7.759095, -0.000000, 3.890293, -0.000000, 0.494253}, 
%% {3.374056, -0.000000, -0.492562, -0.000000, 6.877335, -0.000000, 3.451338, -0.000000, 0.496156}, 
%% {3.016307, -0.000000, -0.490940, -0.000000, 6.137150, -0.000000, 3.083121, -0.000000, 0.498186}, 
%% {2.714655, -0.000000, -0.489104, -0.000000, 5.511579, -0.000000, 2.772205, -0.000000, 0.500527}, 
%% {2.458936, -0.000000, -0.486923, -0.000000, 4.979216, -0.000000, 2.508031, -0.000000, 0.503355}, 
%% {2.239771, -0.000000, -0.484594, -0.000000, 4.521091, -0.000000, 2.281036, -0.000000, 0.506478}, 
%% {2.051766, -0.000000, -0.482007, -0.000000, 4.124364, -0.000000, 2.085659, -0.000000, 0.510031}, 
%% {1.890173, -0.000000, -0.479110, -0.000000, 3.779700, -0.000000, 1.916771, -0.000000, 0.514148}, 
%% {1.751043, -0.000000, -0.475968, -0.000000, 3.477703, -0.000000, 1.770429, -0.000000, 0.518763}, 
%% {1.629928, -0.000000, -0.472612, -0.000000, 3.211962, -0.000000, 1.641972, -0.000000, 0.523896}, 
%% {1.526513, -0.000000, -0.469071, -0.000000, 2.976187, -0.000000, 1.531023, -0.000000, 0.529543}, 
%% {1.437194, -0.000000, -0.465388, -0.000000, 2.767006, -0.000000, 1.433793, -0.000000, 0.535714}, 
%% {1.360710, -0.000000, -0.461608, -0.000000, 2.579911, -0.000000, 1.348945, -0.000000, 0.542383}, 
%% {1.294827, -0.000000, -0.457894, -0.000000, 2.413116, -0.000000, 1.274028, -0.000000, 0.549461}, 
%% {1.238431, -0.000000, -0.454083, -0.000000, 2.263144, -0.000000, 1.207785, -0.000000, 0.557154}, 
%% {1.189631, -0.000000, -0.449934, -0.000000, 2.128870, -0.000000, 1.147700, -0.000000, 0.565925}, 
%% {1.148636, -0.000000, -0.444675, -0.000000, 2.005098, -0.000000, 1.093035, -0.000000, 0.576850}, 
%% {1.111096, -0.000000, -0.438857, -0.000000, 1.894806, -0.000000, 1.040368, -0.000000, 0.589079}, 
%% {1.081762, -0.000000, -0.432850, -0.000000, 1.794565, -0.000000, 0.994038, -0.000000, 0.602251}, 
%% {1.057062, -0.000000, -0.426460, -0.000000, 1.705123, -0.000000, 0.950831, -0.000000, 0.616398}, 
%% {1.035855, -0.000000, -0.419816, -0.000000, 1.624098, -0.000000, 0.909658, -0.000000, 0.631329}, 
%% {1.019363, -0.000000, -0.412898, -0.000000, 1.553007, -0.000000, 0.870940, -0.000000, 0.647221}, 
%% {1.005067, -0.000000, -0.405538, -0.000000, 1.489221, -0.000000, 0.833461, -0.000000, 0.663704}, 
%% {0.994156, -0.000000, -0.397766, -0.000000, 1.430591, -0.000000, 0.797671, -0.000000, 0.680849}, 
%% {0.984625, -0.000000, -0.389455, -0.000000, 1.379417, -0.000000, 0.761641, -0.000000, 0.698743}, 
%% {0.977913, -0.000000, -0.380404, -0.000000, 1.332071, -0.000000, 0.726814, -0.000000, 0.717272}, 
%% {0.972854, -0.000000, -0.369941, -0.000000, 1.289142, -0.000000, 0.691787, -0.000000, 0.736939}, 
%% {0.967864, -0.000000, -0.358684, -0.000000, 1.251363, -0.000000, 0.655405, -0.000000, 0.757111}, 
%% {0.964310, -0.000000, -0.346678, -0.000000, 1.217044, -0.000000, 0.619595, -0.000000, 0.777250}, 
%% {0.961912, -0.000000, -0.333904, -0.000000, 1.185132, -0.000000, 0.584447, -0.000000, 0.797124}, 
%% {0.958157, -0.000000, -0.320479, -0.000000, 1.156649, -0.000000, 0.548007, -0.000000, 0.816706}, 
%% {0.956324, -0.000000, -0.306094, -0.000000, 1.130353, -0.000000, 0.512129, -0.000000, 0.836081}, 
%% {0.952352, -0.000000, -0.290199, -0.000000, 1.105829, -0.000000, 0.474628, -0.000000, 0.855372}, 
%% {0.949317, -0.000000, -0.273637, -0.000000, 1.082855, -0.000000, 0.437805, -0.000000, 0.873805}, 
%% {0.945168, -0.000000, -0.256435, -0.000000, 1.061216, -0.000000, 0.401255, -0.000000, 0.891135}, 
%% {0.938954, -0.000000, -0.238639, -0.000000, 1.041059, -0.000000, 0.364112, -0.000000, 0.907460}, 
%% {0.933023, -0.000000, -0.219875, -0.000000, 1.020607, -0.000000, 0.328134, -0.000000, 0.922672}, 
%% {0.926047, -0.000000, -0.200325, -0.000000, 1.001945, -0.000000, 0.292393, -0.000000, 0.936749}, 
%% {0.917145, -0.000000, -0.180684, -0.000000, 0.982157, -0.000000, 0.257169, -0.000000, 0.949336}, 
%% {0.909133, -0.000000, -0.160806, -0.000000, 0.963652, -0.000000, 0.224076, -0.000000, 0.960366}, 
%% {0.898419, -0.000000, -0.140206, -0.000000, 0.944971, -0.000000, 0.191200, -0.000000, 0.970162}, 
%% {0.888066, -0.000000, -0.119686, -0.000000, 0.928702, -0.000000, 0.161755, -0.000000, 0.978200}, 
%% {0.878833, -0.000000, -0.099371, -0.000000, 0.915014, -0.000000, 0.134344, -0.000000, 0.984810}, 
%% {0.872219, -0.000000, -0.078858, -0.000000, 0.902611, -0.000000, 0.107105, -0.000000, 0.990317}, 
%% {0.867444, -0.000000, -0.058533, -0.000000, 0.890843, -0.000000, 0.079708, -0.000000, 0.994622}, 
%% {0.865131, -0.000000, -0.038800, -0.000000, 0.880101, -0.000000, 0.052582, -0.000000, 0.997642}, 
%% {0.863133, -0.000000, -0.018987, -0.000000, 0.869810, -0.000000, 0.025824, -0.000000, 0.999432}, 
%% {0.859396, -0.000000, 0.000104, -0.000000, 0.859361, -0.000000, 0.000003, -0.000000, 1.000000}, 
%% {2308.387207, -0.000000, -0.498603, -0.000000, 4999.052734, -0.000000, 2487.833252, -0.000000, 0.462637}, 
%% {918.489990, -0.000000, -0.498603, -0.000000, 1984.101929, -0.000000, 989.886414, -0.000000, 0.462639}, 
%% {229.491165, -0.000000, -0.498602, -0.000000, 496.232849, -0.000000, 247.329269, -0.000000, 0.462642}, 
%% {102.025078, -0.000000, -0.498592, -0.000000, 220.489639, -0.000000, 109.957413, -0.000000, 0.462643}, 
%% {57.361820, -0.000000, -0.498582, -0.000000, 124.088257, -0.000000, 61.820667, -0.000000, 0.462662}, 
%% {36.723515, -0.000000, -0.498553, -0.000000, 79.369690, -0.000000, 39.577927, -0.000000, 0.462696}, 
%% {25.503803, -0.000000, -0.498504, -0.000000, 55.118893, -0.000000, 27.485495, -0.000000, 0.462761}, 
%% {18.737976, -0.000000, -0.498420, -0.000000, 40.497589, -0.000000, 20.193455, -0.000000, 0.462866}, 
%% {14.347777, -0.000000, -0.498291, -0.000000, 31.005165, -0.000000, 15.461621, -0.000000, 0.463026}, 
%% {11.337095, -0.000000, -0.498106, -0.000000, 24.498989, -0.000000, 12.216565, -0.000000, 0.463253}, 
%% {9.185066, -0.000000, -0.497856, -0.000000, 19.840046, -0.000000, 9.896663, -0.000000, 0.463574}, 
%% {7.592433, -0.000000, -0.497518, -0.000000, 16.395767, -0.000000, 8.179696, -0.000000, 0.464000}, 
%% {6.382160, -0.000000, -0.497056, -0.000000, 13.776030, -0.000000, 6.874724, -0.000000, 0.464582}, 
%% {5.447767, -0.000000, -0.495910, -0.000000, 11.748669, -0.000000, 5.866901, -0.000000, 0.465936}, 
%% {4.702502, -0.000000, -0.494941, -0.000000, 10.133073, -0.000000, 5.062861, -0.000000, 0.467131}, 
%% {4.100620, -0.000000, -0.493942, -0.000000, 8.827829, -0.000000, 4.413207, -0.000000, 0.468405}, 
%% {3.608607, -0.000000, -0.492840, -0.000000, 7.759583, -0.000000, 3.881824, -0.000000, 0.469846}, 
%% {3.204178, -0.000000, -0.491218, -0.000000, 6.878587, -0.000000, 3.444589, -0.000000, 0.471925}, 
%% {2.864599, -0.000000, -0.489649, -0.000000, 6.138093, -0.000000, 3.077076, -0.000000, 0.474033}, 
%% {2.579374, -0.000000, -0.487716, -0.000000, 5.513338, -0.000000, 2.767832, -0.000000, 0.476650}, 
%% {2.336657, -0.000000, -0.485650, -0.000000, 4.980156, -0.000000, 2.504156, -0.000000, 0.479537}, 
%% {2.129708, -0.000000, -0.483313, -0.000000, 4.521687, -0.000000, 2.278604, -0.000000, 0.482897}, 
%% {1.951499, -0.000000, -0.480739, -0.000000, 4.125630, -0.000000, 2.083651, -0.000000, 0.486706}, 
%% {1.799075, -0.000000, -0.477905, -0.000000, 3.780927, -0.000000, 1.915878, -0.000000, 0.491067}, 
%% {1.667053, -0.000000, -0.474853, -0.000000, 3.478493, -0.000000, 1.769596, -0.000000, 0.495938}, 
%% {1.553788, -0.000000, -0.471499, -0.000000, 3.212234, -0.000000, 1.642911, -0.000000, 0.501456}, 
%% {1.456485, -0.000000, -0.468012, -0.000000, 2.976638, -0.000000, 1.532650, -0.000000, 0.507513}, 
%% {1.373135, -0.000000, -0.464395, -0.000000, 2.766911, -0.000000, 1.436510, -0.000000, 0.514172}, 
%% {1.301966, -0.000000, -0.460656, -0.000000, 2.579373, -0.000000, 1.352747, -0.000000, 0.521377}, 
%% {1.240881, -0.000000, -0.456912, -0.000000, 2.412430, -0.000000, 1.278725, -0.000000, 0.529154}, 
%% {1.188867, -0.000000, -0.453256, -0.000000, 2.262526, -0.000000, 1.213184, -0.000000, 0.537473}, 
%% {1.143919, -0.000000, -0.449369, -0.000000, 2.128147, -0.000000, 1.153977, -0.000000, 0.546680}, 
%% {1.105601, -0.000000, -0.444903, -0.000000, 2.006007, -0.000000, 1.099842, -0.000000, 0.557415}, 
%% {1.073023, -0.000000, -0.439452, -0.000000, 1.895253, -0.000000, 1.049131, -0.000000, 0.570333}, 
%% {1.046840, -0.000000, -0.433759, -0.000000, 1.794406, -0.000000, 1.003527, -0.000000, 0.584188}, 
%% {1.024595, -0.000000, -0.427704, -0.000000, 1.705554, -0.000000, 0.960239, -0.000000, 0.599160}, 
%% {1.006904, -0.000000, -0.421409, -0.000000, 1.624937, -0.000000, 0.919850, -0.000000, 0.615025}, 
%% {0.991827, -0.000000, -0.414678, -0.000000, 1.553144, -0.000000, 0.880879, -0.000000, 0.631709}, 
%% {0.980350, -0.000000, -0.407573, -0.000000, 1.488937, -0.000000, 0.843814, -0.000000, 0.649191}, 
%% {0.971501, -0.000000, -0.400011, -0.000000, 1.431317, -0.000000, 0.808087, -0.000000, 0.667274}, 
%% {0.965005, -0.000000, -0.391939, -0.000000, 1.380105, -0.000000, 0.772836, -0.000000, 0.686111}, 
%% {0.959214, -0.000000, -0.383225, -0.000000, 1.333139, -0.000000, 0.737414, -0.000000, 0.705389}, 
%% {0.955711, -0.000000, -0.373613, -0.000000, 1.290920, -0.000000, 0.702280, -0.000000, 0.725460}, 
%% {0.953488, -0.000000, -0.362431, -0.000000, 1.252463, -0.000000, 0.666917, -0.000000, 0.746498}, 
%% {0.951426, -0.000000, -0.350489, -0.000000, 1.217851, -0.000000, 0.630977, -0.000000, 0.767559}, 
%% {0.949801, -0.000000, -0.337755, -0.000000, 1.187075, -0.000000, 0.594506, -0.000000, 0.788590}, 
%% {0.948214, -0.000000, -0.324278, -0.000000, 1.157900, -0.000000, 0.558160, -0.000000, 0.809116}, 
%% {0.946294, -0.000000, -0.309953, -0.000000, 1.131614, -0.000000, 0.521266, -0.000000, 0.829262}, 
%% {0.945028, -0.000000, -0.294640, -0.000000, 1.107425, -0.000000, 0.484510, -0.000000, 0.848940}, 
%% {0.941902, -0.000000, -0.277809, -0.000000, 1.083821, -0.000000, 0.446674, -0.000000, 0.868256}, 
%% {0.938600, -0.000000, -0.260305, -0.000000, 1.062705, -0.000000, 0.409016, -0.000000, 0.886567}, 
%% {0.934312, -0.000000, -0.242304, -0.000000, 1.042152, -0.000000, 0.371857, -0.000000, 0.903563}, 
%% {0.928809, -0.000000, -0.223691, -0.000000, 1.022065, -0.000000, 0.335116, -0.000000, 0.919292}, 
%% {0.922447, -0.000000, -0.204131, -0.000000, 1.002269, -0.000000, 0.298472, -0.000000, 0.933950}, 
%% {0.913871, -0.000000, -0.183863, -0.000000, 0.982866, -0.000000, 0.262634, -0.000000, 0.947160}, 
%% {0.905591, -0.000000, -0.163541, -0.000000, 0.963760, -0.000000, 0.228376, -0.000000, 0.958758}, 
%% {0.895655, -0.000000, -0.143134, -0.000000, 0.945180, -0.000000, 0.195648, -0.000000, 0.968734}, 
%% {0.885895, -0.000000, -0.122051, -0.000000, 0.928398, -0.000000, 0.164974, -0.000000, 0.977271}, 
%% {0.876570, -0.000000, -0.101110, -0.000000, 0.913993, -0.000000, 0.136762, -0.000000, 0.984225}, 
%% {0.870007, -0.000000, -0.080547, -0.000000, 0.901369, -0.000000, 0.109254, -0.000000, 0.989885}, 
%% {0.865289, -0.000000, -0.059836, -0.000000, 0.889468, -0.000000, 0.081325, -0.000000, 0.994376}, 
%% {0.862888, -0.000000, -0.039400, -0.000000, 0.878454, -0.000000, 0.053605, -0.000000, 0.997552}, 
%% {0.861008, -0.000000, -0.019561, -0.000000, 0.867958, -0.000000, 0.026390, -0.000000, 0.999401}, 
%% {0.857275, -0.000000, 0.000198, -0.000000, 0.857329, -0.000000, -0.000103, -0.000000, 1.000000}, 
%% {2173.374268, -0.000000, -0.496121, -0.000000, 5015.014160, -0.000000, 2462.711914, -0.000000, 0.437831}, 
%% {868.498230, -0.000000, -0.496121, -0.000000, 1983.527100, -0.000000, 984.115601, -0.000000, 0.437834}, 
%% {217.211380, -0.000000, -0.496120, -0.000000, 495.975739, -0.000000, 246.127304, -0.000000, 0.437834}, 
%% {96.551628, -0.000000, -0.496109, -0.000000, 220.479401, -0.000000, 109.406937, -0.000000, 0.437837}, 
%% {54.404099, -0.000000, -0.496096, -0.000000, 123.296043, -0.000000, 61.647358, -0.000000, 0.437855}, 
%% {34.753880, -0.000000, -0.496071, -0.000000, 79.387451, -0.000000, 39.379955, -0.000000, 0.437897}, 
%% {24.134027, -0.000000, -0.496018, -0.000000, 55.128025, -0.000000, 27.346100, -0.000000, 0.437965}, 
%% {17.734491, -0.000000, -0.495932, -0.000000, 40.497169, -0.000000, 20.094250, -0.000000, 0.438079}, 
%% {13.579977, -0.000000, -0.495800, -0.000000, 31.002962, -0.000000, 15.386214, -0.000000, 0.438255}, 
%% {10.730293, -0.000000, -0.495611, -0.000000, 24.497438, -0.000000, 12.156669, -0.000000, 0.438508}, 
%% {8.693534, -0.000000, -0.495350, -0.000000, 19.840897, -0.000000, 9.848241, -0.000000, 0.438856}, 
%% {7.186315, -0.000000, -0.495001, -0.000000, 16.395733, -0.000000, 8.139783, -0.000000, 0.439323}, 
%% {6.041426, -0.000000, -0.494491, -0.000000, 13.777444, -0.000000, 6.841797, -0.000000, 0.439998}, 
%% {5.157413, -0.000000, -0.493345, -0.000000, 11.750236, -0.000000, 5.839232, -0.000000, 0.441434}, 
%% {4.452248, -0.000000, -0.492390, -0.000000, 10.134440, -0.000000, 5.039252, -0.000000, 0.442691}, 
%% {3.882272, -0.000000, -0.491455, -0.000000, 8.827855, -0.000000, 4.392337, -0.000000, 0.443976}, 
%% {3.417596, -0.000000, -0.490269, -0.000000, 7.760546, -0.000000, 3.864561, -0.000000, 0.445612}, 
%% {3.034808, -0.000000, -0.488693, -0.000000, 6.879304, -0.000000, 3.429341, -0.000000, 0.447776}, 
%% {2.713555, -0.000000, -0.487145, -0.000000, 6.138950, -0.000000, 3.063648, -0.000000, 0.450005}, 
%% {2.444059, -0.000000, -0.485211, -0.000000, 5.514582, -0.000000, 2.756259, -0.000000, 0.452809}, 
%% {2.214939, -0.000000, -0.483163, -0.000000, 4.981479, -0.000000, 2.494366, -0.000000, 0.455883}, 
%% {2.019269, -0.000000, -0.480870, -0.000000, 4.523149, -0.000000, 2.269924, -0.000000, 0.459438}, 
%% {1.851734, -0.000000, -0.478306, -0.000000, 4.127285, -0.000000, 2.076894, -0.000000, 0.463535}, 
%% {1.708330, -0.000000, -0.475478, -0.000000, 3.782592, -0.000000, 1.910680, -0.000000, 0.468202}, 
%% {1.584114, -0.000000, -0.472557, -0.000000, 3.479750, -0.000000, 1.765540, -0.000000, 0.473322}, 
%% {1.478318, -0.000000, -0.469309, -0.000000, 3.212967, -0.000000, 1.640612, -0.000000, 0.479169}, 
%% {1.387254, -0.000000, -0.465913, -0.000000, 2.977593, -0.000000, 1.531391, -0.000000, 0.485678}, 
%% {1.309608, -0.000000, -0.462375, -0.000000, 2.766338, -0.000000, 1.436579, -0.000000, 0.492796}, 
%% {1.243468, -0.000000, -0.458778, -0.000000, 2.578579, -0.000000, 1.353692, -0.000000, 0.500555}, 
%% {1.186908, -0.000000, -0.455134, -0.000000, 2.410789, -0.000000, 1.280609, -0.000000, 0.508935}, 
%% {1.138436, -0.000000, -0.451543, -0.000000, 2.261684, -0.000000, 1.215322, -0.000000, 0.517961}, 
%% {1.098142, -0.000000, -0.447903, -0.000000, 2.127142, -0.000000, 1.157885, -0.000000, 0.527730}, 
%% {1.064183, -0.000000, -0.444087, -0.000000, 2.006149, -0.000000, 1.105573, -0.000000, 0.538641}, 
%% {1.035447, -0.000000, -0.439230, -0.000000, 1.895251, -0.000000, 1.056709, -0.000000, 0.551751}, 
%% {1.010718, -0.000000, -0.433946, -0.000000, 1.796021, -0.000000, 1.010005, -0.000000, 0.566360}, 
%% {0.991383, -0.000000, -0.428227, -0.000000, 1.706383, -0.000000, 0.967580, -0.000000, 0.582055}, 
%% {0.976212, -0.000000, -0.422257, -0.000000, 1.626114, -0.000000, 0.927634, -0.000000, 0.598755}, 
%% {0.964107, -0.000000, -0.415856, -0.000000, 1.554332, -0.000000, 0.889356, -0.000000, 0.616387}, 
%% {0.954701, -0.000000, -0.409064, -0.000000, 1.490322, -0.000000, 0.852160, -0.000000, 0.634872}, 
%% {0.949133, -0.000000, -0.401820, -0.000000, 1.431520, -0.000000, 0.817512, -0.000000, 0.653902}, 
%% {0.944292, -0.000000, -0.393991, -0.000000, 1.380344, -0.000000, 0.782147, -0.000000, 0.673661}, 
%% {0.940723, -0.000000, -0.385554, -0.000000, 1.334781, -0.000000, 0.746805, -0.000000, 0.693923}, 
%% {0.938802, -0.000000, -0.376367, -0.000000, 1.292550, -0.000000, 0.711681, -0.000000, 0.714686}, 
%% {0.937670, -0.000000, -0.365854, -0.000000, 1.253856, -0.000000, 0.676973, -0.000000, 0.735863}, 
%% {0.937547, -0.000000, -0.354095, -0.000000, 1.220243, -0.000000, 0.640081, -0.000000, 0.758253}, 
%% {0.937705, -0.000000, -0.341360, -0.000000, 1.188208, -0.000000, 0.603883, -0.000000, 0.780164}, 
%% {0.937817, -0.000000, -0.327761, -0.000000, 1.159163, -0.000000, 0.567827, -0.000000, 0.801548}, 
%% {0.937100, -0.000000, -0.313459, -0.000000, 1.133220, -0.000000, 0.530012, -0.000000, 0.822712}, 
%% {0.936575, -0.000000, -0.298238, -0.000000, 1.108873, -0.000000, 0.492768, -0.000000, 0.843086}, 
%% {0.934747, -0.000000, -0.281984, -0.000000, 1.085721, -0.000000, 0.454777, -0.000000, 0.862808}, 
%% {0.932438, -0.000000, -0.264158, -0.000000, 1.063761, -0.000000, 0.416564, -0.000000, 0.881988}, 
%% {0.929393, -0.000000, -0.245767, -0.000000, 1.043221, -0.000000, 0.379231, -0.000000, 0.899717}, 
%% {0.924324, -0.000000, -0.226887, -0.000000, 1.023197, -0.000000, 0.341516, -0.000000, 0.916170}, 
%% {0.919314, -0.000000, -0.207471, -0.000000, 1.003371, -0.000000, 0.304869, -0.000000, 0.931197}, 
%% {0.911210, -0.000000, -0.187164, -0.000000, 0.983707, -0.000000, 0.268158, -0.000000, 0.944920}, 
%% {0.902197, -0.000000, -0.166284, -0.000000, 0.963741, -0.000000, 0.232493, -0.000000, 0.957149}, 
%% {0.892935, -0.000000, -0.145411, -0.000000, 0.944845, -0.000000, 0.199431, -0.000000, 0.967523}, 
%% {0.882988, -0.000000, -0.124537, -0.000000, 0.927889, -0.000000, 0.168246, -0.000000, 0.976271}, 
%% {0.873756, -0.000000, -0.103073, -0.000000, 0.913076, -0.000000, 0.139198, -0.000000, 0.983580}, 
%% {0.867002, -0.000000, -0.081825, -0.000000, 0.899972, -0.000000, 0.111182, -0.000000, 0.989507}, 
%% {0.862447, -0.000000, -0.061088, -0.000000, 0.888056, -0.000000, 0.083038, -0.000000, 0.994118}, 
%% {0.860349, -0.000000, -0.040310, -0.000000, 0.876813, -0.000000, 0.054822, -0.000000, 0.997432}, 
%% {0.858710, -0.000000, -0.019743, -0.000000, 0.866025, -0.000000, 0.026821, -0.000000, 0.999383}, 
%% {0.855020, -0.000000, 0.000107, -0.000000, 0.855079, -0.000000, -0.000020, -0.000000, 1.000000}, 
%% {2043.595093, -0.000000, -0.492405, -0.000000, 5021.035156, -0.000000, 2435.437500, -0.000000, 0.413180}, 
%% {820.414490, -0.000000, -0.492406, -0.000000, 1985.020996, -0.000000, 977.721008, -0.000000, 0.413180}, 
%% {205.097000, -0.000000, -0.492407, -0.000000, 495.926270, -0.000000, 244.420227, -0.000000, 0.413184}, 
%% {91.101578, -0.000000, -0.492395, -0.000000, 220.633759, -0.000000, 108.570839, -0.000000, 0.413186}, 
%% {51.195999, -0.000000, -0.492380, -0.000000, 124.152794, -0.000000, 61.012962, -0.000000, 0.413205}, 
%% {32.798054, -0.000000, -0.492353, -0.000000, 79.379280, -0.000000, 39.086319, -0.000000, 0.413250}, 
%% {22.778809, -0.000000, -0.492299, -0.000000, 55.125027, -0.000000, 27.145575, -0.000000, 0.413325}, 
%% {16.736238, -0.000000, -0.492211, -0.000000, 40.497890, -0.000000, 19.943943, -0.000000, 0.413450}, 
%% {12.815057, -0.000000, -0.492076, -0.000000, 31.005009, -0.000000, 15.270478, -0.000000, 0.413640}, 
%% {10.126527, -0.000000, -0.491882, -0.000000, 24.495752, -0.000000, 12.065912, -0.000000, 0.413915}, 
%% {8.204487, -0.000000, -0.491615, -0.000000, 19.839943, -0.000000, 9.774734, -0.000000, 0.414295}, 
%% {6.782261, -0.000000, -0.491256, -0.000000, 16.396091, -0.000000, 8.079169, -0.000000, 0.414806}, 
%% {5.704311, -0.000000, -0.490620, -0.000000, 13.780697, -0.000000, 6.793746, -0.000000, 0.415679}, 
%% {4.868640, -0.000000, -0.489585, -0.000000, 11.751335, -0.000000, 5.796914, -0.000000, 0.417068}, 
%% {4.202570, -0.000000, -0.488689, -0.000000, 10.134126, -0.000000, 5.002134, -0.000000, 0.418336}, 
%% {3.665192, -0.000000, -0.487731, -0.000000, 8.828368, -0.000000, 4.360550, -0.000000, 0.419737}, 
%% {3.228251, -0.000000, -0.486399, -0.000000, 7.763611, -0.000000, 3.838454, -0.000000, 0.421662}, 
%% {2.866282, -0.000000, -0.484967, -0.000000, 6.880583, -0.000000, 3.405503, -0.000000, 0.423798}, 
%% {2.563888, -0.000000, -0.483407, -0.000000, 6.140338, -0.000000, 3.043264, -0.000000, 0.426209}, 
%% {2.309678, -0.000000, -0.481523, -0.000000, 5.516063, -0.000000, 2.738157, -0.000000, 0.429148}, 
%% {2.094630, -0.000000, -0.479425, -0.000000, 4.983524, -0.000000, 2.479357, -0.000000, 0.432517}, 
%% {1.909832, -0.000000, -0.477260, -0.000000, 4.524782, -0.000000, 2.256241, -0.000000, 0.436173}, 
%% {1.752857, -0.000000, -0.474763, -0.000000, 4.128784, -0.000000, 2.065704, -0.000000, 0.440502}, 
%% {1.617731, -0.000000, -0.472022, -0.000000, 3.784109, -0.000000, 1.900603, -0.000000, 0.445441}, 
%% {1.502462, -0.000000, -0.469154, -0.000000, 3.480684, -0.000000, 1.758498, -0.000000, 0.450897}, 
%% {1.402816, -0.000000, -0.466050, -0.000000, 3.214609, -0.000000, 1.634116, -0.000000, 0.457106}, 
%% {1.319001, -0.000000, -0.462788, -0.000000, 2.977309, -0.000000, 1.527662, -0.000000, 0.464001}, 
%% {1.246871, -0.000000, -0.459386, -0.000000, 2.766399, -0.000000, 1.434117, -0.000000, 0.471627}, 
%% {1.185969, -0.000000, -0.455920, -0.000000, 2.577915, -0.000000, 1.352838, -0.000000, 0.479931}, 
%% {1.133353, -0.000000, -0.452469, -0.000000, 2.410737, -0.000000, 1.280185, -0.000000, 0.488911}, 
%% {1.090229, -0.000000, -0.449038, -0.000000, 2.260300, -0.000000, 1.217170, -0.000000, 0.498678}, 
%% {1.053551, -0.000000, -0.445666, -0.000000, 2.126304, -0.000000, 1.160353, -0.000000, 0.509155}, 
%% {1.022125, -0.000000, -0.442195, -0.000000, 2.006099, -0.000000, 1.108247, -0.000000, 0.520546}, 
%% {0.997621, -0.000000, -0.438216, -0.000000, 1.896292, -0.000000, 1.062059, -0.000000, 0.533479}, 
%% {0.976717, -0.000000, -0.433468, -0.000000, 1.796726, -0.000000, 1.016646, -0.000000, 0.548812}, 
%% {0.960311, -0.000000, -0.428176, -0.000000, 1.707205, -0.000000, 0.974915, -0.000000, 0.565313}, 
%% {0.947766, -0.000000, -0.422606, -0.000000, 1.626889, -0.000000, 0.935684, -0.000000, 0.582782}, 
%% {0.937891, -0.000000, -0.416562, -0.000000, 1.555010, -0.000000, 0.897817, -0.000000, 0.601237}, 
%% {0.931432, -0.000000, -0.410108, -0.000000, 1.491066, -0.000000, 0.861427, -0.000000, 0.620715}, 
%% {0.926079, -0.000000, -0.403139, -0.000000, 1.433789, -0.000000, 0.825308, -0.000000, 0.640729}, 
%% {0.922922, -0.000000, -0.395593, -0.000000, 1.382141, -0.000000, 0.789956, -0.000000, 0.661401}, 
%% {0.922490, -0.000000, -0.387327, -0.000000, 1.334882, -0.000000, 0.756143, -0.000000, 0.682517}, 
%% {0.922118, -0.000000, -0.378489, -0.000000, 1.294330, -0.000000, 0.720594, -0.000000, 0.704228}, 
%% {0.922955, -0.000000, -0.368619, -0.000000, 1.255997, -0.000000, 0.685723, -0.000000, 0.726129}, 
%% {0.924803, -0.000000, -0.357327, -0.000000, 1.221229, -0.000000, 0.650377, -0.000000, 0.748706}, 
%% {0.925084, -0.000000, -0.344707, -0.000000, 1.190090, -0.000000, 0.612762, -0.000000, 0.771671}, 
%% {0.927080, -0.000000, -0.331132, -0.000000, 1.160989, -0.000000, 0.576069, -0.000000, 0.794241}, 
%% {0.927689, -0.000000, -0.316767, -0.000000, 1.134629, -0.000000, 0.538281, -0.000000, 0.816200}, 
%% {0.927714, -0.000000, -0.301529, -0.000000, 1.110581, -0.000000, 0.500064, -0.000000, 0.837467}, 
%% {0.927654, -0.000000, -0.285293, -0.000000, 1.087502, -0.000000, 0.462520, -0.000000, 0.857755}, 
%% {0.925733, -0.000000, -0.268053, -0.000000, 1.065678, -0.000000, 0.423968, -0.000000, 0.877237}, 
%% {0.923972, -0.000000, -0.249287, -0.000000, 1.044075, -0.000000, 0.385939, -0.000000, 0.895874}, 
%% {0.919637, -0.000000, -0.230011, -0.000000, 1.023852, -0.000000, 0.347190, -0.000000, 0.913164}, 
%% {0.915338, -0.000000, -0.210309, -0.000000, 1.004262, -0.000000, 0.310387, -0.000000, 0.928685}, 
%% {0.908169, -0.000000, -0.190148, -0.000000, 0.984377, -0.000000, 0.273467, -0.000000, 0.942743}, 
%% {0.899920, -0.000000, -0.169220, -0.000000, 0.964031, -0.000000, 0.237134, -0.000000, 0.955410}, 
%% {0.890571, -0.000000, -0.147723, -0.000000, 0.944457, -0.000000, 0.202980, -0.000000, 0.966331}, 
%% {0.880608, -0.000000, -0.126312, -0.000000, 0.927218, -0.000000, 0.170893, -0.000000, 0.975488}, 
%% {0.871402, -0.000000, -0.105068, -0.000000, 0.911832, -0.000000, 0.141608, -0.000000, 0.982926}, 
%% {0.864176, -0.000000, -0.083452, -0.000000, 0.898640, -0.000000, 0.113024, -0.000000, 0.989086}, 
%% {0.859889, -0.000000, -0.061946, -0.000000, 0.886500, -0.000000, 0.084319, -0.000000, 0.993926}, 
%% {0.857758, -0.000000, -0.041076, -0.000000, 0.875020, -0.000000, 0.055716, -0.000000, 0.997332}, 
%% {0.856276, -0.000000, -0.020328, -0.000000, 0.863942, -0.000000, 0.027371, -0.000000, 0.999350}, 
%% {0.852678, -0.000000, 0.000236, -0.000000, 0.852736, -0.000000, -0.000094, -0.000000, 1.000000}, 
%% {1942.397339, -0.000000, -0.487465, -0.000000, 4987.955566, -0.000000, 2435.671143, -0.000000, 0.388743}, 
%% {771.046448, -0.000000, -0.487467, -0.000000, 1984.649902, -0.000000, 966.845825, -0.000000, 0.388746}, 
%% {192.897980, -0.000000, -0.487469, -0.000000, 495.997284, -0.000000, 241.880020, -0.000000, 0.388749}, 
%% {85.715736, -0.000000, -0.487458, -0.000000, 220.510880, -0.000000, 107.483101, -0.000000, 0.388753}, 
%% {48.222561, -0.000000, -0.487443, -0.000000, 124.026955, -0.000000, 60.468262, -0.000000, 0.388775}, 
%% {30.887884, -0.000000, -0.487411, -0.000000, 79.334694, -0.000000, 38.731369, -0.000000, 0.388818}, 
%% {21.440338, -0.000000, -0.487359, -0.000000, 55.096420, -0.000000, 26.883883, -0.000000, 0.388904}, 
%% {15.744785, -0.000000, -0.487268, -0.000000, 40.497288, -0.000000, 19.741640, -0.000000, 0.389038}, 
%% {12.057285, -0.000000, -0.487130, -0.000000, 31.004887, -0.000000, 15.117249, -0.000000, 0.389244}, 
%% {9.528114, -0.000000, -0.486932, -0.000000, 24.497026, -0.000000, 11.945236, -0.000000, 0.389541}, 
%% {7.719697, -0.000000, -0.486659, -0.000000, 19.840698, -0.000000, 9.676930, -0.000000, 0.389955}, 
%% {6.382185, -0.000000, -0.486291, -0.000000, 16.396450, -0.000000, 7.999023, -0.000000, 0.390514}, 
%% {5.370436, -0.000000, -0.485496, -0.000000, 13.786822, -0.000000, 6.729503, -0.000000, 0.391642}, 
%% {4.582683, -0.000000, -0.484596, -0.000000, 11.753360, -0.000000, 5.740714, -0.000000, 0.392949}, 
%% {3.955672, -0.000000, -0.483761, -0.000000, 10.134423, -0.000000, 4.953362, -0.000000, 0.394226}, 
%% {3.450506, -0.000000, -0.482769, -0.000000, 8.829981, -0.000000, 4.318620, -0.000000, 0.395771}, 
%% {3.039919, -0.000000, -0.481407, -0.000000, 7.767029, -0.000000, 3.802229, -0.000000, 0.397872}, 
%% {2.699223, -0.000000, -0.480074, -0.000000, 6.881458, -0.000000, 3.373337, -0.000000, 0.400030}, 
%% {2.415727, -0.000000, -0.478431, -0.000000, 6.142947, -0.000000, 3.015849, -0.000000, 0.402715}, 
%% {2.176478, -0.000000, -0.476679, -0.000000, 5.517835, -0.000000, 2.713505, -0.000000, 0.405705}, 
%% {1.974553, -0.000000, -0.474636, -0.000000, 4.985538, -0.000000, 2.457520, -0.000000, 0.409270}, 
%% {1.801761, -0.000000, -0.472475, -0.000000, 4.527461, -0.000000, 2.237638, -0.000000, 0.413225}, 
%% {1.654464, -0.000000, -0.470090, -0.000000, 4.131062, -0.000000, 2.049236, -0.000000, 0.417742}, 
%% {1.528521, -0.000000, -0.467464, -0.000000, 3.785507, -0.000000, 1.886920, -0.000000, 0.422927}, 
%% {1.420640, -0.000000, -0.464701, -0.000000, 3.482770, -0.000000, 1.746380, -0.000000, 0.428747}, 
%% {1.329486, -0.000000, -0.461731, -0.000000, 3.215533, -0.000000, 1.625957, -0.000000, 0.435305}, 
%% {1.250748, -0.000000, -0.458648, -0.000000, 2.978036, -0.000000, 1.520116, -0.000000, 0.442575}, 
%% {1.184791, -0.000000, -0.455459, -0.000000, 2.765794, -0.000000, 1.429094, -0.000000, 0.450625}, 
%% {1.127953, -0.000000, -0.452145, -0.000000, 2.578120, -0.000000, 1.348326, -0.000000, 0.459517}, 
%% {1.081259, -0.000000, -0.448983, -0.000000, 2.409699, -0.000000, 1.278362, -0.000000, 0.469172}, 
%% {1.040801, -0.000000, -0.445749, -0.000000, 2.260130, -0.000000, 1.215015, -0.000000, 0.479640}, 
%% {1.009168, -0.000000, -0.442594, -0.000000, 2.124944, -0.000000, 1.160948, -0.000000, 0.490840}, 
%% {0.982410, -0.000000, -0.439479, -0.000000, 2.004937, -0.000000, 1.111095, -0.000000, 0.502953}, 
%% {0.960266, -0.000000, -0.436107, -0.000000, 1.896332, -0.000000, 1.065225, -0.000000, 0.516226}, 
%% {0.942233, -0.000000, -0.432187, -0.000000, 1.797681, -0.000000, 1.021504, -0.000000, 0.531452}, 
%% {0.929005, -0.000000, -0.427396, -0.000000, 1.708889, -0.000000, 0.980846, -0.000000, 0.548754}, 
%% {0.918737, -0.000000, -0.422309, -0.000000, 1.628307, -0.000000, 0.941801, -0.000000, 0.567090}, 
%% {0.911380, -0.000000, -0.416738, -0.000000, 1.556011, -0.000000, 0.904546, -0.000000, 0.586387}, 
%% {0.907200, -0.000000, -0.410659, -0.000000, 1.492091, -0.000000, 0.868787, -0.000000, 0.606730}, 
%% {0.904619, -0.000000, -0.404040, -0.000000, 1.435478, -0.000000, 0.833461, -0.000000, 0.627742}, 
%% {0.903488, -0.000000, -0.396741, -0.000000, 1.383418, -0.000000, 0.798540, -0.000000, 0.649344}, 
%% {0.903218, -0.000000, -0.388771, -0.000000, 1.337454, -0.000000, 0.763157, -0.000000, 0.671515}, 
%% {0.905973, -0.000000, -0.380166, -0.000000, 1.295848, -0.000000, 0.729114, -0.000000, 0.694048}, 
%% {0.907541, -0.000000, -0.370611, -0.000000, 1.258119, -0.000000, 0.693548, -0.000000, 0.716777}, 
%% {0.910403, -0.000000, -0.359966, -0.000000, 1.223362, -0.000000, 0.657825, -0.000000, 0.739901}, 
%% {0.913617, -0.000000, -0.347813, -0.000000, 1.191956, -0.000000, 0.621794, -0.000000, 0.763284}, 
%% {0.916350, -0.000000, -0.334316, -0.000000, 1.163111, -0.000000, 0.583930, -0.000000, 0.786962}, 
%% {0.918691, -0.000000, -0.319789, -0.000000, 1.136874, -0.000000, 0.546234, -0.000000, 0.809860}, 
%% {0.919524, -0.000000, -0.304443, -0.000000, 1.111577, -0.000000, 0.507865, -0.000000, 0.831852}, 
%% {0.920815, -0.000000, -0.288184, -0.000000, 1.088739, -0.000000, 0.469689, -0.000000, 0.853003}, 
%% {0.919868, -0.000000, -0.271071, -0.000000, 1.066543, -0.000000, 0.431121, -0.000000, 0.872955}, 
%% {0.918189, -0.000000, -0.252833, -0.000000, 1.045547, -0.000000, 0.391812, -0.000000, 0.892110}, 
%% {0.914676, -0.000000, -0.233194, -0.000000, 1.024943, -0.000000, 0.352950, -0.000000, 0.910016}, 
%% {0.909981, -0.000000, -0.213034, -0.000000, 1.004814, -0.000000, 0.314627, -0.000000, 0.926343}, 
%% {0.904002, -0.000000, -0.192589, -0.000000, 0.984708, -0.000000, 0.277313, -0.000000, 0.940921}, 
%% {0.896499, -0.000000, -0.171784, -0.000000, 0.964494, -0.000000, 0.241217, -0.000000, 0.953779}, 
%% {0.887936, -0.000000, -0.150303, -0.000000, 0.944577, -0.000000, 0.206153, -0.000000, 0.965104}, 
%% {0.878091, -0.000000, -0.128268, -0.000000, 0.926365, -0.000000, 0.173709, -0.000000, 0.974625}, 
%% {0.868764, -0.000000, -0.106461, -0.000000, 0.910961, -0.000000, 0.143583, -0.000000, 0.982405}, 
%% {0.862100, -0.000000, -0.084910, -0.000000, 0.897224, -0.000000, 0.114901, -0.000000, 0.988683}, 
%% {0.857379, -0.000000, -0.063198, -0.000000, 0.884659, -0.000000, 0.085962, -0.000000, 0.993664}, 
%% {0.855156, -0.000000, -0.041569, -0.000000, 0.872898, -0.000000, 0.056582, -0.000000, 0.997250}, 
%% {0.853764, -0.000000, -0.020669, -0.000000, 0.861773, -0.000000, 0.027953, -0.000000, 0.999323}, 
%% {0.850260, -0.000000, 0.000009, -0.000000, 0.850296, -0.000000, 0.000047, -0.000000, 1.000000}, 
%% {1802.627808, -0.000000, -0.481313, -0.000000, 5015.344727, -0.000000, 2379.772949, -0.000000, 0.364586}, 
%% {723.554077, -0.000000, -0.481315, -0.000000, 1983.548096, -0.000000, 955.212646, -0.000000, 0.364584}, 
%% {180.949249, -0.000000, -0.481319, -0.000000, 495.823151, -0.000000, 238.878799, -0.000000, 0.364590}, 
%% {80.386261, -0.000000, -0.481308, -0.000000, 220.592514, -0.000000, 106.122787, -0.000000, 0.364596}, 
%% {45.218300, -0.000000, -0.481291, -0.000000, 124.053024, -0.000000, 59.695484, -0.000000, 0.364617}, 
%% {28.942085, -0.000000, -0.481260, -0.000000, 79.354477, -0.000000, 38.207829, -0.000000, 0.364666}, 
%% {20.103104, -0.000000, -0.481202, -0.000000, 55.107391, -0.000000, 26.538656, -0.000000, 0.364752}, 
%% {14.768594, -0.000000, -0.481113, -0.000000, 40.494709, -0.000000, 19.495440, -0.000000, 0.364902}, 
%% {11.307508, -0.000000, -0.480975, -0.000000, 31.006365, -0.000000, 14.925641, -0.000000, 0.365125}, 
%% {8.936440, -0.000000, -0.480773, -0.000000, 24.496405, -0.000000, 11.794859, -0.000000, 0.365446}, 
%% {7.240606, -0.000000, -0.480497, -0.000000, 19.841179, -0.000000, 9.555364, -0.000000, 0.365893}, 
%% {5.986403, -0.000000, -0.480119, -0.000000, 16.397009, -0.000000, 7.898808, -0.000000, 0.366503}, 
%% {5.039139, -0.000000, -0.479267, -0.000000, 13.789630, -0.000000, 6.647321, -0.000000, 0.367781}, 
%% {4.299073, -0.000000, -0.478468, -0.000000, 11.753246, -0.000000, 5.669253, -0.000000, 0.369038}, 
%% {3.711475, -0.000000, -0.477611, -0.000000, 10.135847, -0.000000, 4.892302, -0.000000, 0.370434}, 
%% {3.238020, -0.000000, -0.476643, -0.000000, 8.831033, -0.000000, 4.265847, -0.000000, 0.372058}, 
%% {2.853408, -0.000000, -0.475307, -0.000000, 7.767453, -0.000000, 3.756469, -0.000000, 0.374266}, 
%% {2.534334, -0.000000, -0.473969, -0.000000, 6.883615, -0.000000, 3.333344, -0.000000, 0.376600}, 
%% {2.268517, -0.000000, -0.472396, -0.000000, 6.144737, -0.000000, 2.980226, -0.000000, 0.379398}, 
%% {2.045036, -0.000000, -0.470668, -0.000000, 5.519547, -0.000000, 2.682662, -0.000000, 0.382581}, 
%% {1.855934, -0.000000, -0.468694, -0.000000, 4.987518, -0.000000, 2.430055, -0.000000, 0.386319}, 
%% {1.694852, -0.000000, -0.466585, -0.000000, 4.529711, -0.000000, 2.213896, -0.000000, 0.390525}, 
%% {1.557643, -0.000000, -0.464281, -0.000000, 4.133394, -0.000000, 2.028634, -0.000000, 0.395333}, 
%% {1.440180, -0.000000, -0.461827, -0.000000, 3.787590, -0.000000, 1.868739, -0.000000, 0.400746}, 
%% {1.340580, -0.000000, -0.459187, -0.000000, 3.484475, -0.000000, 1.731527, -0.000000, 0.406903}, 
%% {1.255523, -0.000000, -0.456421, -0.000000, 3.216929, -0.000000, 1.612561, -0.000000, 0.413784}, 
%% {1.184274, -0.000000, -0.453533, -0.000000, 2.979029, -0.000000, 1.510515, -0.000000, 0.421529}, 
%% {1.122857, -0.000000, -0.450609, -0.000000, 2.767680, -0.000000, 1.420264, -0.000000, 0.430040}, 
%% {1.072216, -0.000000, -0.447602, -0.000000, 2.578552, -0.000000, 1.342612, -0.000000, 0.439520}, 
%% {1.029165, -0.000000, -0.444668, -0.000000, 2.409697, -0.000000, 1.273504, -0.000000, 0.449761}, 
%% {0.994324, -0.000000, -0.441683, -0.000000, 2.258943, -0.000000, 1.213759, -0.000000, 0.460843}, 
%% {0.965406, -0.000000, -0.438903, -0.000000, 2.124466, -0.000000, 1.159426, -0.000000, 0.472889}, 
%% {0.941185, -0.000000, -0.436087, -0.000000, 2.004474, -0.000000, 1.109984, -0.000000, 0.485703}, 
%% {0.922849, -0.000000, -0.433208, -0.000000, 1.897042, -0.000000, 1.065926, -0.000000, 0.499628}, 
%% {0.908371, -0.000000, -0.430138, -0.000000, 1.799313, -0.000000, 1.024520, -0.000000, 0.514863}, 
%% {0.897723, -0.000000, -0.426088, -0.000000, 1.709912, -0.000000, 0.985075, -0.000000, 0.532452}, 
%% {0.889945, -0.000000, -0.421476, -0.000000, 1.630788, -0.000000, 0.946548, -0.000000, 0.551717}, 
%% {0.884842, -0.000000, -0.416456, -0.000000, 1.558650, -0.000000, 0.909592, -0.000000, 0.571896}, 
%% {0.882098, -0.000000, -0.410771, -0.000000, 1.494495, -0.000000, 0.873888, -0.000000, 0.593052}, 
%% {0.882231, -0.000000, -0.404527, -0.000000, 1.437356, -0.000000, 0.839515, -0.000000, 0.615059}, 
%% {0.883843, -0.000000, -0.397644, -0.000000, 1.385981, -0.000000, 0.805354, -0.000000, 0.637668}, 
%% {0.886003, -0.000000, -0.389965, -0.000000, 1.339711, -0.000000, 0.770597, -0.000000, 0.660830}, 
%% {0.888549, -0.000000, -0.381488, -0.000000, 1.297900, -0.000000, 0.735406, -0.000000, 0.684262}, 
%% {0.893222, -0.000000, -0.372207, -0.000000, 1.260102, -0.000000, 0.700936, -0.000000, 0.707919}, 
%% {0.897463, -0.000000, -0.361813, -0.000000, 1.225431, -0.000000, 0.665813, -0.000000, 0.731577}, 
%% {0.901520, -0.000000, -0.350433, -0.000000, 1.194343, -0.000000, 0.629080, -0.000000, 0.755468}, 
%% {0.905275, -0.000000, -0.337281, -0.000000, 1.165744, -0.000000, 0.591453, -0.000000, 0.779640}, 
%% {0.909002, -0.000000, -0.322717, -0.000000, 1.138516, -0.000000, 0.553996, -0.000000, 0.803318}, 
%% {0.911300, -0.000000, -0.307192, -0.000000, 1.113466, -0.000000, 0.515135, -0.000000, 0.826352}, 
%% {0.913625, -0.000000, -0.290871, -0.000000, 1.089846, -0.000000, 0.476508, -0.000000, 0.848294}, 
%% {0.913450, -0.000000, -0.273674, -0.000000, 1.067942, -0.000000, 0.436765, -0.000000, 0.869143}, 
%% {0.912586, -0.000000, -0.255586, -0.000000, 1.046112, -0.000000, 0.398184, -0.000000, 0.888481}, 
%% {0.910020, -0.000000, -0.236444, -0.000000, 1.026375, -0.000000, 0.358920, -0.000000, 0.906744}, 
%% {0.905866, -0.000000, -0.215880, -0.000000, 1.005983, -0.000000, 0.319812, -0.000000, 0.923785}, 
%% {0.900496, -0.000000, -0.194963, -0.000000, 0.985067, -0.000000, 0.281678, -0.000000, 0.939015}, 
%% {0.892708, -0.000000, -0.173805, -0.000000, 0.964415, -0.000000, 0.244691, -0.000000, 0.952360}, 
%% {0.884453, -0.000000, -0.152382, -0.000000, 0.944349, -0.000000, 0.209312, -0.000000, 0.963938}, 
%% {0.874356, -0.000000, -0.130510, -0.000000, 0.925481, -0.000000, 0.176273, -0.000000, 0.973689}, 
%% {0.865615, -0.000000, -0.108041, -0.000000, 0.909503, -0.000000, 0.145768, -0.000000, 0.981806}, 
%% {0.858743, -0.000000, -0.085935, -0.000000, 0.895712, -0.000000, 0.116459, -0.000000, 0.988346}, 
%% {0.854043, -0.000000, -0.064186, -0.000000, 0.882860, -0.000000, 0.087235, -0.000000, 0.993444}, 
%% {0.852270, -0.000000, -0.042556, -0.000000, 0.870865, -0.000000, 0.057555, -0.000000, 0.997126}, 
%% {0.851055, -0.000000, -0.020818, -0.000000, 0.859493, -0.000000, 0.028268, -0.000000, 0.999308}, 
%% {0.847626, -0.000000, 0.000159, -0.000000, 0.847664, -0.000000, -0.000012, -0.000000, 1.000000}, 
%% {1687.421021, -0.000000, -0.473967, -0.000000, 5009.231445, -0.000000, 2347.000000, -0.000000, 0.340769}, 
%% {675.398987, -0.000000, -0.473963, -0.000000, 1989.025146, -0.000000, 939.414795, -0.000000, 0.340763}, 
%% {169.137299, -0.000000, -0.473973, -0.000000, 495.885010, -0.000000, 235.246796, -0.000000, 0.340769}, 
%% {75.146896, -0.000000, -0.473958, -0.000000, 220.590759, -0.000000, 104.521797, -0.000000, 0.340772}, 
%% {42.266644, -0.000000, -0.473943, -0.000000, 124.030647, -0.000000, 58.788273, -0.000000, 0.340797}, 
%% {27.055510, -0.000000, -0.473911, -0.000000, 79.330948, -0.000000, 37.630867, -0.000000, 0.340848}, 
%% {18.788244, -0.000000, -0.473856, -0.000000, 55.111828, -0.000000, 26.131298, -0.000000, 0.340945}, 
%% {13.803668, -0.000000, -0.473764, -0.000000, 40.499016, -0.000000, 19.197716, -0.000000, 0.341104}, 
%% {10.569510, -0.000000, -0.473624, -0.000000, 31.006226, -0.000000, 14.698747, -0.000000, 0.341344}, 
%% {8.353544, -0.000000, -0.473421, -0.000000, 24.496752, -0.000000, 11.615925, -0.000000, 0.341690}, 
%% {6.768255, -0.000000, -0.473143, -0.000000, 19.841547, -0.000000, 9.410192, -0.000000, 0.342170}, 
%% {5.596749, -0.000000, -0.472748, -0.000000, 16.397943, -0.000000, 7.779840, -0.000000, 0.342850}, 
%% {4.711792, -0.000000, -0.471896, -0.000000, 13.791606, -0.000000, 6.547952, -0.000000, 0.344208}, 
%% {4.019844, -0.000000, -0.471135, -0.000000, 11.754961, -0.000000, 5.584369, -0.000000, 0.345498}, 
%% {3.470298, -0.000000, -0.470334, -0.000000, 10.135903, -0.000000, 4.818676, -0.000000, 0.346918}, 
%% {3.029408, -0.000000, -0.469274, -0.000000, 8.833785, -0.000000, 4.203885, -0.000000, 0.348792}, 
%% {2.669223, -0.000000, -0.468053, -0.000000, 7.768222, -0.000000, 3.701174, -0.000000, 0.350992}, 
%% {2.371746, -0.000000, -0.466718, -0.000000, 6.885600, -0.000000, 3.285318, -0.000000, 0.353507}, 
%% {2.123569, -0.000000, -0.465202, -0.000000, 6.146842, -0.000000, 2.937761, -0.000000, 0.356437}, 
%% {1.915368, -0.000000, -0.463486, -0.000000, 5.522325, -0.000000, 2.645406, -0.000000, 0.359857}, 
%% {1.739341, -0.000000, -0.461617, -0.000000, 4.990346, -0.000000, 2.397267, -0.000000, 0.363771}, 
%% {1.589008, -0.000000, -0.459627, -0.000000, 4.532220, -0.000000, 2.184393, -0.000000, 0.368156}, 
%% {1.462462, -0.000000, -0.457423, -0.000000, 4.136230, -0.000000, 2.003815, -0.000000, 0.373254}, 
%% {1.353528, -0.000000, -0.455138, -0.000000, 3.790114, -0.000000, 1.847012, -0.000000, 0.378923}, 
%% {1.261313, -0.000000, -0.452641, -0.000000, 3.486634, -0.000000, 1.712559, -0.000000, 0.385422}, 
%% {1.183813, -0.000000, -0.450113, -0.000000, 3.217416, -0.000000, 1.597453, -0.000000, 0.392612}, 
%% {1.117990, -0.000000, -0.447478, -0.000000, 2.979808, -0.000000, 1.497082, -0.000000, 0.400789}, 
%% {1.063155, -0.000000, -0.444848, -0.000000, 2.766640, -0.000000, 1.410565, -0.000000, 0.409788}, 
%% {1.016550, -0.000000, -0.442192, -0.000000, 2.578963, -0.000000, 1.333857, -0.000000, 0.419781}, 
%% {0.979515, -0.000000, -0.439564, -0.000000, 2.409079, -0.000000, 1.268673, -0.000000, 0.430674}, 
%% {0.947099, -0.000000, -0.437017, -0.000000, 2.260016, -0.000000, 1.208094, -0.000000, 0.442553}, 
%% {0.922469, -0.000000, -0.434577, -0.000000, 2.124653, -0.000000, 1.156223, -0.000000, 0.455301}, 
%% {0.902287, -0.000000, -0.432132, -0.000000, 2.004830, -0.000000, 1.108810, -0.000000, 0.468957}, 
%% {0.887598, -0.000000, -0.429684, -0.000000, 1.896284, -0.000000, 1.066653, -0.000000, 0.483636}, 
%% {0.875057, -0.000000, -0.427137, -0.000000, 1.800074, -0.000000, 1.025586, -0.000000, 0.499386}, 
%% {0.867123, -0.000000, -0.424183, -0.000000, 1.712856, -0.000000, 0.987924, -0.000000, 0.516723}, 
%% {0.861685, -0.000000, -0.420102, -0.000000, 1.632940, -0.000000, 0.950472, -0.000000, 0.536612}, 
%% {0.859626, -0.000000, -0.415614, -0.000000, 1.561077, -0.000000, 0.914955, -0.000000, 0.557635}, 
%% {0.858534, -0.000000, -0.410462, -0.000000, 1.497516, -0.000000, 0.879222, -0.000000, 0.579647}, 
%% {0.859975, -0.000000, -0.404612, -0.000000, 1.440679, -0.000000, 0.844656, -0.000000, 0.602596}, 
%% {0.862845, -0.000000, -0.398115, -0.000000, 1.388433, -0.000000, 0.810330, -0.000000, 0.626116}, 
%% {0.868771, -0.000000, -0.390795, -0.000000, 1.342330, -0.000000, 0.777368, -0.000000, 0.650320}, 
%% {0.873036, -0.000000, -0.382551, -0.000000, 1.300294, -0.000000, 0.742407, -0.000000, 0.674689}, 
%% {0.878554, -0.000000, -0.373449, -0.000000, 1.262505, -0.000000, 0.707488, -0.000000, 0.699266}, 
%% {0.883952, -0.000000, -0.363330, -0.000000, 1.228389, -0.000000, 0.671806, -0.000000, 0.723868}, 
%% {0.889069, -0.000000, -0.352113, -0.000000, 1.196574, -0.000000, 0.635608, -0.000000, 0.748269}, 
%% {0.895020, -0.000000, -0.339783, -0.000000, 1.168167, -0.000000, 0.599011, -0.000000, 0.772593}, 
%% {0.899033, -0.000000, -0.325655, -0.000000, 1.141006, -0.000000, 0.560039, -0.000000, 0.797139}, 
%% {0.903576, -0.000000, -0.309988, -0.000000, 1.115658, -0.000000, 0.522047, -0.000000, 0.820902}, 
%% {0.905730, -0.000000, -0.293440, -0.000000, 1.091402, -0.000000, 0.482684, -0.000000, 0.843619}, 
%% {0.907109, -0.000000, -0.276076, -0.000000, 1.069365, -0.000000, 0.442809, -0.000000, 0.865232}, 
%% {0.907229, -0.000000, -0.257852, -0.000000, 1.047867, -0.000000, 0.403613, -0.000000, 0.885286}, 
%% {0.906072, -0.000000, -0.238789, -0.000000, 1.027431, -0.000000, 0.364444, -0.000000, 0.903953}, 
%% {0.902010, -0.000000, -0.218837, -0.000000, 1.006733, -0.000000, 0.325202, -0.000000, 0.921102}, 
%% {0.897479, -0.000000, -0.197504, -0.000000, 0.985745, -0.000000, 0.286267, -0.000000, 0.937003}, 
%% {0.889694, -0.000000, -0.175785, -0.000000, 0.964966, -0.000000, 0.248320, -0.000000, 0.950937}, 
%% {0.881299, -0.000000, -0.154033, -0.000000, 0.944062, -0.000000, 0.212490, -0.000000, 0.962861}, 
%% {0.871671, -0.000000, -0.132142, -0.000000, 0.924396, -0.000000, 0.178617, -0.000000, 0.972923}, 
%% {0.862562, -0.000000, -0.109957, -0.000000, 0.908063, -0.000000, 0.147852, -0.000000, 0.981152}, 
%% {0.855609, -0.000000, -0.087199, -0.000000, 0.893947, -0.000000, 0.118073, -0.000000, 0.987967}, 
%% {0.851222, -0.000000, -0.064902, -0.000000, 0.880865, -0.000000, 0.088362, -0.000000, 0.993263}, 
%% {0.849473, -0.000000, -0.043035, -0.000000, 0.868587, -0.000000, 0.058445, -0.000000, 0.997039}, 
%% {0.848103, -0.000000, -0.021503, -0.000000, 0.856859, -0.000000, 0.028967, -0.000000, 0.999266}, 
%% {0.844919, -0.000000, 0.000173, -0.000000, 0.844969, -0.000000, -0.000093, -0.000000, 1.000000}, 
%% {1580.479614, -0.000000, -0.465438, -0.000000, 5005.341309, -0.000000, 2318.123291, -0.000000, 0.317332}, 
%% {628.811401, -0.000000, -0.465434, -0.000000, 1982.755127, -0.000000, 922.300842, -0.000000, 0.317331}, 
%% {157.382172, -0.000000, -0.465443, -0.000000, 496.191772, -0.000000, 230.830536, -0.000000, 0.317340}, 
%% {69.940941, -0.000000, -0.465441, -0.000000, 220.337128, -0.000000, 102.580093, -0.000000, 0.317353}, 
%% {39.349358, -0.000000, -0.465418, -0.000000, 124.070168, -0.000000, 57.713482, -0.000000, 0.317374}, 
%% {25.184483, -0.000000, -0.465376, -0.000000, 79.382111, -0.000000, 36.938599, -0.000000, 0.317423}, 
%% {17.494654, -0.000000, -0.465329, -0.000000, 55.127068, -0.000000, 25.658281, -0.000000, 0.317532}, 
%% {12.855007, -0.000000, -0.465237, -0.000000, 40.497932, -0.000000, 18.852661, -0.000000, 0.317701}, 
%% {9.843623, -0.000000, -0.465097, -0.000000, 31.006193, -0.000000, 14.435177, -0.000000, 0.317958}, 
%% {7.778563, -0.000000, -0.464895, -0.000000, 24.498880, -0.000000, 11.405619, -0.000000, 0.318330}, 
%% {6.303895, -0.000000, -0.464617, -0.000000, 19.841656, -0.000000, 9.241854, -0.000000, 0.318847}, 
%% {5.214032, -0.000000, -0.464166, -0.000000, 16.401854, -0.000000, 7.642406, -0.000000, 0.319654}, 
%% {4.389508, -0.000000, -0.463368, -0.000000, 13.793684, -0.000000, 6.431951, -0.000000, 0.321026}, 
%% {3.744866, -0.000000, -0.462657, -0.000000, 11.755573, -0.000000, 5.485159, -0.000000, 0.322339}, 
%% {3.233280, -0.000000, -0.461884, -0.000000, 10.136534, -0.000000, 4.733381, -0.000000, 0.323822}, 
%% {2.823727, -0.000000, -0.460786, -0.000000, 8.836859, -0.000000, 4.131005, -0.000000, 0.325888}, 
%% {2.487969, -0.000000, -0.459677, -0.000000, 7.769849, -0.000000, 3.636589, -0.000000, 0.328104}, 
%% {2.212142, -0.000000, -0.458294, -0.000000, 6.888931, -0.000000, 3.229829, -0.000000, 0.330870}, 
%% {1.981400, -0.000000, -0.456868, -0.000000, 6.149535, -0.000000, 2.888772, -0.000000, 0.333912}, 
%% {1.787684, -0.000000, -0.455249, -0.000000, 5.525425, -0.000000, 2.601579, -0.000000, 0.337486}, 
%% {1.624595, -0.000000, -0.453448, -0.000000, 4.992967, -0.000000, 2.358909, -0.000000, 0.341595}, 
%% {1.485765, -0.000000, -0.451569, -0.000000, 4.535440, -0.000000, 2.151062, -0.000000, 0.346228}, 
%% {1.368237, -0.000000, -0.449489, -0.000000, 4.139169, -0.000000, 1.973775, -0.000000, 0.351581}, 
%% {1.268283, -0.000000, -0.447394, -0.000000, 3.792600, -0.000000, 1.821288, -0.000000, 0.357530}, 
%% {1.184137, -0.000000, -0.445110, -0.000000, 3.489436, -0.000000, 1.690923, -0.000000, 0.364392}, 
%% {1.112902, -0.000000, -0.442850, -0.000000, 3.219450, -0.000000, 1.578372, -0.000000, 0.371928}, 
%% {1.054066, -0.000000, -0.440509, -0.000000, 2.980834, -0.000000, 1.482407, -0.000000, 0.380482}, 
%% {1.003833, -0.000000, -0.438200, -0.000000, 2.768584, -0.000000, 1.397470, -0.000000, 0.389967}, 
%% {0.963687, -0.000000, -0.435940, -0.000000, 2.577574, -0.000000, 1.325305, -0.000000, 0.400477}, 
%% {0.928937, -0.000000, -0.433737, -0.000000, 2.410717, -0.000000, 1.259323, -0.000000, 0.412000}, 
%% {0.902185, -0.000000, -0.431621, -0.000000, 2.259231, -0.000000, 1.202724, -0.000000, 0.424596}, 
%% {0.880606, -0.000000, -0.429581, -0.000000, 2.125102, -0.000000, 1.151992, -0.000000, 0.438030}, 
%% {0.863740, -0.000000, -0.427607, -0.000000, 2.004949, -0.000000, 1.105783, -0.000000, 0.452566}, 
%% {0.851456, -0.000000, -0.425595, -0.000000, 1.897817, -0.000000, 1.064229, -0.000000, 0.468051}, 
%% {0.842232, -0.000000, -0.423511, -0.000000, 1.801393, -0.000000, 1.025106, -0.000000, 0.484532}, 
%% {0.836923, -0.000000, -0.421281, -0.000000, 1.714880, -0.000000, 0.988751, -0.000000, 0.502294}, 
%% {0.833992, -0.000000, -0.418349, -0.000000, 1.636515, -0.000000, 0.952959, -0.000000, 0.521974}, 
%% {0.833734, -0.000000, -0.414313, -0.000000, 1.564836, -0.000000, 0.918164, -0.000000, 0.543731}, 
%% {0.835645, -0.000000, -0.409733, -0.000000, 1.501107, -0.000000, 0.883930, -0.000000, 0.566592}, 
%% {0.839611, -0.000000, -0.404336, -0.000000, 1.443229, -0.000000, 0.850429, -0.000000, 0.590455}, 
%% {0.844217, -0.000000, -0.398320, -0.000000, 1.391572, -0.000000, 0.815924, -0.000000, 0.615029}, 
%% {0.850452, -0.000000, -0.391322, -0.000000, 1.345406, -0.000000, 0.782314, -0.000000, 0.640031}, 
%% {0.857209, -0.000000, -0.383313, -0.000000, 1.303052, -0.000000, 0.748419, -0.000000, 0.665334}, 
%% {0.863495, -0.000000, -0.374412, -0.000000, 1.265089, -0.000000, 0.713076, -0.000000, 0.690809}, 
%% {0.871243, -0.000000, -0.364518, -0.000000, 1.230687, -0.000000, 0.678044, -0.000000, 0.716314}, 
%% {0.877818, -0.000000, -0.353501, -0.000000, 1.199261, -0.000000, 0.641552, -0.000000, 0.741644}, 
%% {0.885158, -0.000000, -0.341346, -0.000000, 1.170058, -0.000000, 0.605481, -0.000000, 0.766507}, 
%% {0.890613, -0.000000, -0.327972, -0.000000, 1.143070, -0.000000, 0.567492, -0.000000, 0.791018}, 
%% {0.895139, -0.000000, -0.312700, -0.000000, 1.118221, -0.000000, 0.528250, -0.000000, 0.815466}, 
%% {0.898214, -0.000000, -0.296062, -0.000000, 1.094354, -0.000000, 0.487922, -0.000000, 0.839175}, 
%% {0.900437, -0.000000, -0.278440, -0.000000, 1.071348, -0.000000, 0.448194, -0.000000, 0.861406}, 
%% {0.901686, -0.000000, -0.259965, -0.000000, 1.049268, -0.000000, 0.408316, -0.000000, 0.882279}, 
%% {0.900750, -0.000000, -0.240719, -0.000000, 1.028106, -0.000000, 0.368840, -0.000000, 0.901430}, 
%% {0.897504, -0.000000, -0.220800, -0.000000, 1.007010, -0.000000, 0.329702, -0.000000, 0.918888}, 
%% {0.894184, -0.000000, -0.200098, -0.000000, 0.986556, -0.000000, 0.290762, -0.000000, 0.934934}, 
%% {0.886862, -0.000000, -0.178115, -0.000000, 0.964914, -0.000000, 0.252260, -0.000000, 0.949337}, 
%% {0.878959, -0.000000, -0.155762, -0.000000, 0.943694, -0.000000, 0.215466, -0.000000, 0.961817}, 
%% {0.869098, -0.000000, -0.133434, -0.000000, 0.923896, -0.000000, 0.181023, -0.000000, 0.972207}, 
%% {0.860441, -0.000000, -0.111061, -0.000000, 0.906837, -0.000000, 0.149379, -0.000000, 0.980719}, 
%% {0.852905, -0.000000, -0.088746, -0.000000, 0.892111, -0.000000, 0.119805, -0.000000, 0.987534}, 
%% {0.848247, -0.000000, -0.065904, -0.000000, 0.878600, -0.000000, 0.089570, -0.000000, 0.993041}, 
%% {0.846406, -0.000000, -0.043499, -0.000000, 0.866282, -0.000000, 0.059162, -0.000000, 0.996959}, 
%% {0.845224, -0.000000, -0.021462, -0.000000, 0.854200, -0.000000, 0.029187, -0.000000, 0.999259}, 
%% {0.842026, -0.000000, -0.000027, -0.000000, 0.842078, -0.000000, -0.000030, -0.000000, 1.000000}, 
%% {1457.779785, -0.000000, -0.455754, -0.000000, 5029.836426, -0.000000, 2257.067139, -0.000000, 0.294360}, 
%% {584.081665, -0.000000, -0.455754, -0.000000, 1984.658569, -0.000000, 904.327332, -0.000000, 0.294361}, 
%% {146.063034, -0.000000, -0.455759, -0.000000, 496.085693, -0.000000, 226.143539, -0.000000, 0.294367}, 
%% {64.936600, -0.000000, -0.455762, -0.000000, 220.415741, -0.000000, 100.535912, -0.000000, 0.294382}, 
%% {36.499931, -0.000000, -0.455732, -0.000000, 124.054848, -0.000000, 56.511887, -0.000000, 0.294402}, 
%% {23.369791, -0.000000, -0.455702, -0.000000, 79.370262, -0.000000, 36.182159, -0.000000, 0.294462}, 
%% {16.228870, -0.000000, -0.455646, -0.000000, 55.125347, -0.000000, 25.125402, -0.000000, 0.294572}, 
%% {11.922604, -0.000000, -0.455554, -0.000000, 40.494705, -0.000000, 18.457491, -0.000000, 0.294752}, 
%% {9.132368, -0.000000, -0.455415, -0.000000, 31.006226, -0.000000, 14.136714, -0.000000, 0.295028}, 
%% {7.216820, -0.000000, -0.455215, -0.000000, 24.496227, -0.000000, 11.170083, -0.000000, 0.295425}, 
%% {5.848193, -0.000000, -0.454937, -0.000000, 19.843037, -0.000000, 9.050154, -0.000000, 0.295979}, 
%% {4.840539, -0.000000, -0.454377, -0.000000, 16.409056, -0.000000, 7.488962, -0.000000, 0.297018}, 
%% {4.073507, -0.000000, -0.453706, -0.000000, 13.795560, -0.000000, 6.300163, -0.000000, 0.298289}, 
%% {3.475091, -0.000000, -0.453051, -0.000000, 11.756066, -0.000000, 5.372275, -0.000000, 0.299611}, 
%% {3.001410, -0.000000, -0.452265, -0.000000, 10.138925, -0.000000, 4.637296, -0.000000, 0.301233}, 
%% {2.621505, -0.000000, -0.451204, -0.000000, 8.839016, -0.000000, 4.047290, -0.000000, 0.303395}, 
%% {2.310650, -0.000000, -0.450136, -0.000000, 7.772457, -0.000000, 3.563901, -0.000000, 0.305719}, 
%% {2.054829, -0.000000, -0.448837, -0.000000, 6.891259, -0.000000, 3.165387, -0.000000, 0.308583}, 
%% {1.841608, -0.000000, -0.447426, -0.000000, 6.153536, -0.000000, 2.832397, -0.000000, 0.311858}, 
%% {1.662766, -0.000000, -0.445911, -0.000000, 5.528611, -0.000000, 2.552168, -0.000000, 0.315573}, 
%% {1.512087, -0.000000, -0.444214, -0.000000, 4.997096, -0.000000, 2.314936, -0.000000, 0.319928}, 
%% {1.384448, -0.000000, -0.442496, -0.000000, 4.538482, -0.000000, 2.112713, -0.000000, 0.324737}, 
%% {1.276675, -0.000000, -0.440566, -0.000000, 4.142691, -0.000000, 1.940451, -0.000000, 0.330373}, 
%% {1.185010, -0.000000, -0.438663, -0.000000, 3.795982, -0.000000, 1.792087, -0.000000, 0.336612}, 
%% {1.107746, -0.000000, -0.436641, -0.000000, 3.492142, -0.000000, 1.664894, -0.000000, 0.343747}, 
%% {1.044494, -0.000000, -0.434653, -0.000000, 3.220814, -0.000000, 1.557824, -0.000000, 0.351732}, 
%% {0.990759, -0.000000, -0.432716, -0.000000, 2.982660, -0.000000, 1.463839, -0.000000, 0.360665}, 
%% {0.946567, -0.000000, -0.430785, -0.000000, 2.769137, -0.000000, 1.382871, -0.000000, 0.370652}, 
%% {0.909979, -0.000000, -0.428944, -0.000000, 2.579227, -0.000000, 1.311784, -0.000000, 0.381654}, 
%% {0.881404, -0.000000, -0.427229, -0.000000, 2.409166, -0.000000, 1.250590, -0.000000, 0.393821}, 
%% {0.857893, -0.000000, -0.425533, -0.000000, 2.259369, -0.000000, 1.195393, -0.000000, 0.407061}, 
%% {0.839716, -0.000000, -0.424049, -0.000000, 2.125269, -0.000000, 1.145904, -0.000000, 0.421328}, 
%% {0.826246, -0.000000, -0.422536, -0.000000, 2.005011, -0.000000, 1.101579, -0.000000, 0.436661}, 
%% {0.816996, -0.000000, -0.421075, -0.000000, 1.898399, -0.000000, 1.061390, -0.000000, 0.452965}, 
%% {0.810316, -0.000000, -0.419549, -0.000000, 1.802923, -0.000000, 1.022993, -0.000000, 0.470335}, 
%% {0.807166, -0.000000, -0.417788, -0.000000, 1.717028, -0.000000, 0.987797, -0.000000, 0.488718}, 
%% {0.807285, -0.000000, -0.415708, -0.000000, 1.639228, -0.000000, 0.954470, -0.000000, 0.508500}, 
%% {0.808785, -0.000000, -0.412623, -0.000000, 1.568291, -0.000000, 0.920813, -0.000000, 0.530222}, 
%% {0.812301, -0.000000, -0.408666, -0.000000, 1.504668, -0.000000, 0.886628, -0.000000, 0.553940}, 
%% {0.818186, -0.000000, -0.403805, -0.000000, 1.446622, -0.000000, 0.853747, -0.000000, 0.578644}, 
%% {0.825431, -0.000000, -0.398165, -0.000000, 1.395671, -0.000000, 0.820679, -0.000000, 0.604128}, 
%% {0.832592, -0.000000, -0.391578, -0.000000, 1.348198, -0.000000, 0.786591, -0.000000, 0.630057}, 
%% {0.841351, -0.000000, -0.384003, -0.000000, 1.306979, -0.000000, 0.752854, -0.000000, 0.656388}, 
%% {0.849954, -0.000000, -0.375248, -0.000000, 1.269286, -0.000000, 0.718383, -0.000000, 0.682840}, 
%% {0.858090, -0.000000, -0.365498, -0.000000, 1.233789, -0.000000, 0.683000, -0.000000, 0.709080}, 
%% {0.865778, -0.000000, -0.354564, -0.000000, 1.202200, -0.000000, 0.646663, -0.000000, 0.735171}, 
%% {0.873947, -0.000000, -0.342576, -0.000000, 1.172424, -0.000000, 0.610037, -0.000000, 0.760873}, 
%% {0.880255, -0.000000, -0.329417, -0.000000, 1.146258, -0.000000, 0.571795, -0.000000, 0.786018}, 
%% {0.886864, -0.000000, -0.314968, -0.000000, 1.120002, -0.000000, 0.533744, -0.000000, 0.810442}, 
%% {0.890689, -0.000000, -0.298593, -0.000000, 1.095668, -0.000000, 0.493906, -0.000000, 0.834424}, 
%% {0.894519, -0.000000, -0.280825, -0.000000, 1.073062, -0.000000, 0.453707, -0.000000, 0.857564}, 
%% {0.895202, -0.000000, -0.262063, -0.000000, 1.050626, -0.000000, 0.413008, -0.000000, 0.879095}, 
%% {0.895728, -0.000000, -0.242689, -0.000000, 1.029204, -0.000000, 0.372651, -0.000000, 0.899034}, 
%% {0.892855, -0.000000, -0.222412, -0.000000, 1.007756, -0.000000, 0.332550, -0.000000, 0.917161}, 
%% {0.888898, -0.000000, -0.201690, -0.000000, 0.986182, -0.000000, 0.293586, -0.000000, 0.933386}, 
%% {0.882493, -0.000000, -0.180319, -0.000000, 0.964514, -0.000000, 0.255029, -0.000000, 0.947890}, 
%% {0.874168, -0.000000, -0.157840, -0.000000, 0.942870, -0.000000, 0.217734, -0.000000, 0.960686}, 
%% {0.864814, -0.000000, -0.134900, -0.000000, 0.922656, -0.000000, 0.182924, -0.000000, 0.971466}, 
%% {0.855758, -0.000000, -0.112044, -0.000000, 0.905064, -0.000000, 0.151046, -0.000000, 0.980224}, 
%% {0.849011, -0.000000, -0.089374, -0.000000, 0.890149, -0.000000, 0.120853, -0.000000, 0.987278}, 
%% {0.844682, -0.000000, -0.066955, -0.000000, 0.876306, -0.000000, 0.090763, -0.000000, 0.992805}, 
%% {0.842987, -0.000000, -0.044297, -0.000000, 0.863550, -0.000000, 0.060064, -0.000000, 0.996844}, 
%% {0.842122, -0.000000, -0.021680, -0.000000, 0.851464, -0.000000, 0.029490, -0.000000, 0.999241}, 
%% {0.838891, -0.000000, 0.000266, -0.000000, 0.838902, -0.000000, -0.000127, -0.000000, 1.000000}, 
%% {1331.128418, -0.000000, -0.444938, -0.000000, 5214.386719, -0.000000, 2178.274902, -0.000000, 0.271898}, 
%% {539.463074, -0.000000, -0.444938, -0.000000, 1984.907349, -0.000000, 882.782837, -0.000000, 0.271899}, 
%% {134.909393, -0.000000, -0.444941, -0.000000, 496.189911, -0.000000, 220.763901, -0.000000, 0.271904}, 
%% {59.988804, -0.000000, -0.444950, -0.000000, 220.402557, -0.000000, 98.160271, -0.000000, 0.271924}, 
%% {33.730957, -0.000000, -0.444920, -0.000000, 124.024368, -0.000000, 55.196526, -0.000000, 0.271944}, 
%% {21.582294, -0.000000, -0.444884, -0.000000, 79.384094, -0.000000, 35.316605, -0.000000, 0.272006}, 
%% {14.990254, -0.000000, -0.444831, -0.000000, 55.122562, -0.000000, 24.528547, -0.000000, 0.272124}, 
%% {11.014498, -0.000000, -0.444741, -0.000000, 40.499443, -0.000000, 18.021872, -0.000000, 0.272316}, 
%% {8.435223, -0.000000, -0.444605, -0.000000, 31.005482, -0.000000, 13.800347, -0.000000, 0.272609}, 
%% {6.666737, -0.000000, -0.444408, -0.000000, 24.499104, -0.000000, 10.905514, -0.000000, 0.273034}, 
%% {5.402866, -0.000000, -0.444130, -0.000000, 19.843098, -0.000000, 8.836357, -0.000000, 0.273628}, 
%% {4.473391, -0.000000, -0.443538, -0.000000, 16.413191, -0.000000, 7.314206, -0.000000, 0.274794}, 
%% {3.764036, -0.000000, -0.442950, -0.000000, 13.796722, -0.000000, 6.152078, -0.000000, 0.276027}, 
%% {3.211510, -0.000000, -0.442305, -0.000000, 11.758360, -0.000000, 5.246432, -0.000000, 0.277436}, 
%% {2.775232, -0.000000, -0.441486, -0.000000, 10.143391, -0.000000, 4.530762, -0.000000, 0.279243}, 
%% {2.424174, -0.000000, -0.440524, -0.000000, 8.841785, -0.000000, 3.954318, -0.000000, 0.281415}, 
%% {2.137440, -0.000000, -0.439482, -0.000000, 7.775751, -0.000000, 3.482813, -0.000000, 0.283894}, 
%% {1.901154, -0.000000, -0.438296, -0.000000, 6.894230, -0.000000, 3.093484, -0.000000, 0.286822}, 
%% {1.705220, -0.000000, -0.436944, -0.000000, 6.156977, -0.000000, 2.769732, -0.000000, 0.290287}, 
%% {1.540347, -0.000000, -0.435534, -0.000000, 5.532449, -0.000000, 2.496270, -0.000000, 0.294178}, 
%% {1.402422, -0.000000, -0.433951, -0.000000, 5.000858, -0.000000, 2.266314, -0.000000, 0.298735}, 
%% {1.285171, -0.000000, -0.432366, -0.000000, 4.542863, -0.000000, 2.069402, -0.000000, 0.303798}, 
%% {1.186608, -0.000000, -0.430657, -0.000000, 4.145981, -0.000000, 1.902189, -0.000000, 0.309637}, 
%% {1.103796, -0.000000, -0.428984, -0.000000, 3.799346, -0.000000, 1.759363, -0.000000, 0.316234}, 
%% {1.034777, -0.000000, -0.427271, -0.000000, 3.493379, -0.000000, 1.638012, -0.000000, 0.323646}, 
%% {0.977046, -0.000000, -0.425636, -0.000000, 3.223624, -0.000000, 1.533320, -0.000000, 0.332031}, 
%% {0.929606, -0.000000, -0.424068, -0.000000, 2.983096, -0.000000, 1.443805, -0.000000, 0.341364}, 
%% {0.890907, -0.000000, -0.422580, -0.000000, 2.769757, -0.000000, 1.366466, -0.000000, 0.351851}, 
%% {0.859216, -0.000000, -0.421289, -0.000000, 2.579167, -0.000000, 1.298356, -0.000000, 0.363393}, 
%% {0.833735, -0.000000, -0.420058, -0.000000, 2.410941, -0.000000, 1.238217, -0.000000, 0.376153}, 
%% {0.814896, -0.000000, -0.419007, -0.000000, 2.260054, -0.000000, 1.186176, -0.000000, 0.390086}, 
%% {0.800125, -0.000000, -0.418067, -0.000000, 2.126444, -0.000000, 1.138534, -0.000000, 0.405114}, 
%% {0.789657, -0.000000, -0.417033, -0.000000, 2.006622, -0.000000, 1.095919, -0.000000, 0.421224}, 
%% {0.783007, -0.000000, -0.416113, -0.000000, 1.900318, -0.000000, 1.056700, -0.000000, 0.438438}, 
%% {0.780232, -0.000000, -0.415066, -0.000000, 1.804237, -0.000000, 1.021560, -0.000000, 0.456553}, 
%% {0.779445, -0.000000, -0.413928, -0.000000, 1.719430, -0.000000, 0.986996, -0.000000, 0.475851}, 
%% {0.780937, -0.000000, -0.412380, -0.000000, 1.641523, -0.000000, 0.954077, -0.000000, 0.496192}, 
%% {0.784857, -0.000000, -0.410285, -0.000000, 1.572030, -0.000000, 0.922256, -0.000000, 0.517890}, 
%% {0.790767, -0.000000, -0.407265, -0.000000, 1.509296, -0.000000, 0.889674, -0.000000, 0.541795}, 
%% {0.797792, -0.000000, -0.402900, -0.000000, 1.451492, -0.000000, 0.857064, -0.000000, 0.567166}, 
%% {0.806196, -0.000000, -0.397671, -0.000000, 1.399399, -0.000000, 0.824271, -0.000000, 0.593414}, 
%% {0.815497, -0.000000, -0.391465, -0.000000, 1.352591, -0.000000, 0.791220, -0.000000, 0.620189}, 
%% {0.824786, -0.000000, -0.384339, -0.000000, 1.310933, -0.000000, 0.756393, -0.000000, 0.647532}, 
%% {0.835784, -0.000000, -0.375870, -0.000000, 1.272509, -0.000000, 0.722860, -0.000000, 0.674915}, 
%% {0.845037, -0.000000, -0.366290, -0.000000, 1.238330, -0.000000, 0.687020, -0.000000, 0.702204}, 
%% {0.855157, -0.000000, -0.355582, -0.000000, 1.204982, -0.000000, 0.651364, -0.000000, 0.729158}, 
%% {0.863693, -0.000000, -0.343625, -0.000000, 1.175277, -0.000000, 0.614309, -0.000000, 0.755594}, 
%% {0.871732, -0.000000, -0.330422, -0.000000, 1.147923, -0.000000, 0.576844, -0.000000, 0.781353}, 
%% {0.878289, -0.000000, -0.316226, -0.000000, 1.122957, -0.000000, 0.537743, -0.000000, 0.806386}, 
%% {0.883937, -0.000000, -0.300634, -0.000000, 1.098026, -0.000000, 0.498867, -0.000000, 0.830332}, 
%% {0.888315, -0.000000, -0.283264, -0.000000, 1.075132, -0.000000, 0.458820, -0.000000, 0.853693}, 
%% {0.889817, -0.000000, -0.264391, -0.000000, 1.053267, -0.000000, 0.417628, -0.000000, 0.875910}, 
%% {0.890386, -0.000000, -0.244554, -0.000000, 1.030591, -0.000000, 0.376704, -0.000000, 0.896534}, 
%% {0.888600, -0.000000, -0.224135, -0.000000, 1.008621, -0.000000, 0.336171, -0.000000, 0.915206}, 
%% {0.885273, -0.000000, -0.202965, -0.000000, 0.986654, -0.000000, 0.296717, -0.000000, 0.931972}, 
%% {0.878269, -0.000000, -0.181505, -0.000000, 0.964129, -0.000000, 0.257628, -0.000000, 0.946758}, 
%% {0.870381, -0.000000, -0.159568, -0.000000, 0.941797, -0.000000, 0.220193, -0.000000, 0.959632}, 
%% {0.861565, -0.000000, -0.136814, -0.000000, 0.920957, -0.000000, 0.185228, -0.000000, 0.970586}, 
%% {0.852646, -0.000000, -0.113414, -0.000000, 0.902948, -0.000000, 0.152541, -0.000000, 0.979710}, 
%% {0.845333, -0.000000, -0.090147, -0.000000, 0.887807, -0.000000, 0.122200, -0.000000, 0.986969}, 
%% {0.841268, -0.000000, -0.067261, -0.000000, 0.873781, -0.000000, 0.091418, -0.000000, 0.992691}, 
%% {0.839663, -0.000000, -0.044767, -0.000000, 0.860894, -0.000000, 0.060631, -0.000000, 0.996767}, 
%% {0.838668, -0.000000, -0.022498, -0.000000, 0.848273, -0.000000, 0.030052, -0.000000, 0.999194}, 
%% {0.835598, -0.000000, 0.000189, -0.000000, 0.835626, -0.000000, -0.000051, -0.000000, 1.000000}, 
%% {1250.200073, -0.000000, -0.433015, -0.000000, 5000.035645, -0.000000, 2165.389404, -0.000000, 0.250004}, 
%% {496.196198, -0.000000, -0.433014, -0.000000, 1984.075073, -0.000000, 859.430603, -0.000000, 0.250004}, 
%% {123.990837, -0.000000, -0.433017, -0.000000, 496.390961, -0.000000, 214.753571, -0.000000, 0.250009}, 
%% {55.097988, -0.000000, -0.433020, -0.000000, 220.683792, -0.000000, 95.427628, -0.000000, 0.250025}, 
%% {31.010303, -0.000000, -0.432995, -0.000000, 123.991592, -0.000000, 53.709824, -0.000000, 0.250052}, 
%% {19.866323, -0.000000, -0.432958, -0.000000, 79.367111, -0.000000, 34.408558, -0.000000, 0.250116}, 
%% {13.784342, -0.000000, -0.432910, -0.000000, 55.125599, -0.000000, 23.873110, -0.000000, 0.250243}, 
%% {10.128436, -0.000000, -0.432823, -0.000000, 40.499294, -0.000000, 17.540167, -0.000000, 0.250448}, 
%% {7.756955, -0.000000, -0.432688, -0.000000, 31.004631, -0.000000, 13.431938, -0.000000, 0.250757}, 
%% {6.130963, -0.000000, -0.432497, -0.000000, 24.498688, -0.000000, 10.614686, -0.000000, 0.251207}, 
%% {4.968941, -0.000000, -0.432219, -0.000000, 19.845121, -0.000000, 8.600962, -0.000000, 0.251853}, 
%% {4.114857, -0.000000, -0.431637, -0.000000, 16.416298, -0.000000, 7.120417, -0.000000, 0.253089}, 
%% {3.462414, -0.000000, -0.431092, -0.000000, 13.798878, -0.000000, 5.988926, -0.000000, 0.254342}, 
%% {2.954546, -0.000000, -0.430495, -0.000000, 11.758992, -0.000000, 5.107664, -0.000000, 0.255784}, 
%% {2.554330, -0.000000, -0.429667, -0.000000, 10.147230, -0.000000, 4.412583, -0.000000, 0.257755}, 
%% {2.231072, -0.000000, -0.428808, -0.000000, 8.843626, -0.000000, 3.850505, -0.000000, 0.259939}, 
%% {1.968737, -0.000000, -0.427767, -0.000000, 7.780309, -0.000000, 3.393608, -0.000000, 0.262638}, 
%% {1.751803, -0.000000, -0.426661, -0.000000, 6.898132, -0.000000, 3.015016, -0.000000, 0.265676}, 
%% {1.572077, -0.000000, -0.425422, -0.000000, 6.161008, -0.000000, 2.700261, -0.000000, 0.269278}, 
%% {1.421417, -0.000000, -0.424136, -0.000000, 5.536670, -0.000000, 2.435273, -0.000000, 0.273340}, 
%% {1.295317, -0.000000, -0.422712, -0.000000, 5.005318, -0.000000, 2.212175, -0.000000, 0.278082}, 
%% {1.188778, -0.000000, -0.421296, -0.000000, 4.546689, -0.000000, 2.022060, -0.000000, 0.283395}, 
%% {1.100076, -0.000000, -0.419828, -0.000000, 4.148564, -0.000000, 1.861760, -0.000000, 0.289486}, 
%% {1.024837, -0.000000, -0.418407, -0.000000, 3.802104, -0.000000, 1.723540, -0.000000, 0.296337}, 
%% {0.962996, -0.000000, -0.417044, -0.000000, 3.495965, -0.000000, 1.606796, -0.000000, 0.304145}, 
%% {0.912359, -0.000000, -0.415799, -0.000000, 3.224932, -0.000000, 1.507685, -0.000000, 0.312886}, 
%% {0.869964, -0.000000, -0.414672, -0.000000, 2.985308, -0.000000, 1.421023, -0.000000, 0.322662}, 
%% {0.836272, -0.000000, -0.413697, -0.000000, 2.772186, -0.000000, 1.346978, -0.000000, 0.333660}, 
%% {0.809281, -0.000000, -0.412986, -0.000000, 2.581395, -0.000000, 1.282096, -0.000000, 0.345730}, 
%% {0.788806, -0.000000, -0.412357, -0.000000, 2.412431, -0.000000, 1.225959, -0.000000, 0.359117}, 
%% {0.772878, -0.000000, -0.411845, -0.000000, 2.262378, -0.000000, 1.175396, -0.000000, 0.373664}, 
%% {0.761669, -0.000000, -0.411476, -0.000000, 2.128189, -0.000000, 1.130337, -0.000000, 0.389359}, 
%% {0.754303, -0.000000, -0.411174, -0.000000, 2.009303, -0.000000, 1.089060, -0.000000, 0.406348}, 
%% {0.750551, -0.000000, -0.410740, -0.000000, 1.902526, -0.000000, 1.051844, -0.000000, 0.424378}, 
%% {0.750027, -0.000000, -0.410351, -0.000000, 1.806394, -0.000000, 1.017210, -0.000000, 0.443469}, 
%% {0.751723, -0.000000, -0.409774, -0.000000, 1.722409, -0.000000, 0.983920, -0.000000, 0.463653}, 
%% {0.755803, -0.000000, -0.408778, -0.000000, 1.645744, -0.000000, 0.952650, -0.000000, 0.484757}, 
%% {0.761903, -0.000000, -0.407284, -0.000000, 1.576581, -0.000000, 0.922386, -0.000000, 0.506928}, 
%% {0.768730, -0.000000, -0.405210, -0.000000, 1.514226, -0.000000, 0.890627, -0.000000, 0.530537}, 
%% {0.778369, -0.000000, -0.401772, -0.000000, 1.456210, -0.000000, 0.859782, -0.000000, 0.556205}, 
%% {0.787782, -0.000000, -0.397080, -0.000000, 1.404358, -0.000000, 0.826839, -0.000000, 0.583234}, 
%% {0.799020, -0.000000, -0.391267, -0.000000, 1.357228, -0.000000, 0.794592, -0.000000, 0.610902}, 
%% {0.810294, -0.000000, -0.384518, -0.000000, 1.316280, -0.000000, 0.760552, -0.000000, 0.639087}, 
%% {0.821710, -0.000000, -0.376425, -0.000000, 1.277310, -0.000000, 0.726140, -0.000000, 0.667356}, 
%% {0.833230, -0.000000, -0.366908, -0.000000, 1.241549, -0.000000, 0.691764, -0.000000, 0.695385}, 
%% {0.843490, -0.000000, -0.356367, -0.000000, 1.208628, -0.000000, 0.654970, -0.000000, 0.723281}, 
%% {0.853588, -0.000000, -0.344498, -0.000000, 1.178523, -0.000000, 0.618217, -0.000000, 0.750495}, 
%% {0.863259, -0.000000, -0.331335, -0.000000, 1.150831, -0.000000, 0.581242, -0.000000, 0.776908}, 
%% {0.870293, -0.000000, -0.317004, -0.000000, 1.124982, -0.000000, 0.542192, -0.000000, 0.802507}, 
%% {0.877204, -0.000000, -0.301647, -0.000000, 1.099956, -0.000000, 0.502904, -0.000000, 0.827065}, 
%% {0.881748, -0.000000, -0.284986, -0.000000, 1.076639, -0.000000, 0.462998, -0.000000, 0.850357}, 
%% {0.884212, -0.000000, -0.266777, -0.000000, 1.053809, -0.000000, 0.422282, -0.000000, 0.872593}, 
%% {0.885134, -0.000000, -0.246682, -0.000000, 1.031325, -0.000000, 0.381160, -0.000000, 0.893773}, 
%% {0.883691, -0.000000, -0.225863, -0.000000, 1.008923, -0.000000, 0.339763, -0.000000, 0.913160}, 
%% {0.881093, -0.000000, -0.204448, -0.000000, 0.986594, -0.000000, 0.300041, -0.000000, 0.930379}, 
%% {0.874725, -0.000000, -0.182523, -0.000000, 0.964050, -0.000000, 0.260066, -0.000000, 0.945734}, 
%% {0.867242, -0.000000, -0.160384, -0.000000, 0.941011, -0.000000, 0.222210, -0.000000, 0.958906}, 
%% {0.858697, -0.000000, -0.137970, -0.000000, 0.919594, -0.000000, 0.186946, -0.000000, 0.969963}, 
%% {0.849828, -0.000000, -0.115078, -0.000000, 0.901363, -0.000000, 0.154219, -0.000000, 0.979117}, 
%% {0.842390, -0.000000, -0.091368, -0.000000, 0.885387, -0.000000, 0.123309, -0.000000, 0.986626}, 
%% {0.837989, -0.000000, -0.067884, -0.000000, 0.871252, -0.000000, 0.092279, -0.000000, 0.992525}, 
%% {0.836300, -0.000000, -0.044917, -0.000000, 0.857962, -0.000000, 0.061094, -0.000000, 0.996719}, 
%% {0.835312, -0.000000, -0.022240, -0.000000, 0.845182, -0.000000, 0.030179, -0.000000, 0.999197}, 
%% {0.832170, -0.000000, -0.000145, -0.000000, 0.832124, -0.000000, 0.000082, -0.000000, 1.000000}, 
%% {1168.034302, -0.000000, -0.420015, -0.000000, 4782.577148, -0.000000, 2144.849121, -0.000000, 0.228730}, 
%% {453.875183, -0.000000, -0.420014, -0.000000, 1983.529419, -0.000000, 833.448975, -0.000000, 0.228730}, 
%% {113.322220, -0.000000, -0.420022, -0.000000, 496.996155, -0.000000, 208.087067, -0.000000, 0.228738}, 
%% {50.457741, -0.000000, -0.420021, -0.000000, 220.493958, -0.000000, 92.651031, -0.000000, 0.228754}, 
%% {28.369425, -0.000000, -0.419995, -0.000000, 124.034737, -0.000000, 52.093544, -0.000000, 0.228781}, 
%% {18.167402, -0.000000, -0.419958, -0.000000, 79.211021, -0.000000, 33.360050, -0.000000, 0.228848}, 
%% {12.610630, -0.000000, -0.419915, -0.000000, 55.127869, -0.000000, 23.154671, -0.000000, 0.228984}, 
%% {9.267448, -0.000000, -0.419829, -0.000000, 40.503712, -0.000000, 17.014927, -0.000000, 0.229199}, 
%% {7.096401, -0.000000, -0.419700, -0.000000, 31.008314, -0.000000, 13.027345, -0.000000, 0.229528}, 
%% {5.610042, -0.000000, -0.419513, -0.000000, 24.503868, -0.000000, 10.296971, -0.000000, 0.230004}, 
%% {4.547873, -0.000000, -0.419213, -0.000000, 19.848188, -0.000000, 8.345228, -0.000000, 0.230754}, 
%% {3.766452, -0.000000, -0.418681, -0.000000, 16.418720, -0.000000, 6.909012, -0.000000, 0.231991}, 
%% {3.169078, -0.000000, -0.418186, -0.000000, 13.800138, -0.000000, 5.810501, -0.000000, 0.233257}, 
%% {2.704911, -0.000000, -0.417618, -0.000000, 11.760697, -0.000000, 4.956357, -0.000000, 0.234775}, 
%% {2.339128, -0.000000, -0.416834, -0.000000, 10.149791, -0.000000, 4.282664, -0.000000, 0.236826}, 
%% {2.044006, -0.000000, -0.416019, -0.000000, 8.847115, -0.000000, 3.738355, -0.000000, 0.239128}, 
%% {1.804255, -0.000000, -0.415055, -0.000000, 7.783978, -0.000000, 3.295367, -0.000000, 0.241925}, 
%% {1.606508, -0.000000, -0.414026, -0.000000, 6.902849, -0.000000, 2.929033, -0.000000, 0.245135}, 
%% {1.442787, -0.000000, -0.412891, -0.000000, 6.166462, -0.000000, 2.624608, -0.000000, 0.248900}, 
%% {1.305876, -0.000000, -0.411736, -0.000000, 5.542311, -0.000000, 2.368740, -0.000000, 0.253148}, 
%% {1.191544, -0.000000, -0.410495, -0.000000, 5.010624, -0.000000, 2.153608, -0.000000, 0.258067}, 
%% {1.095423, -0.000000, -0.409301, -0.000000, 4.551242, -0.000000, 1.970758, -0.000000, 0.263634}, 
%% {1.015374, -0.000000, -0.408076, -0.000000, 4.154460, -0.000000, 1.816407, -0.000000, 0.269992}, 
%% {0.948352, -0.000000, -0.406972, -0.000000, 3.805923, -0.000000, 1.684469, -0.000000, 0.277133}, 
%% {0.894124, -0.000000, -0.405984, -0.000000, 3.498606, -0.000000, 1.574106, -0.000000, 0.285266}, 
%% {0.849013, -0.000000, -0.405165, -0.000000, 3.227036, -0.000000, 1.478629, -0.000000, 0.294371}, 
%% {0.812598, -0.000000, -0.404579, -0.000000, 2.986828, -0.000000, 1.396708, -0.000000, 0.304602}, 
%% {0.784079, -0.000000, -0.404196, -0.000000, 2.773201, -0.000000, 1.326769, -0.000000, 0.316045}, 
%% {0.761505, -0.000000, -0.404071, -0.000000, 2.582530, -0.000000, 1.265191, -0.000000, 0.328663}, 
%% {0.744346, -0.000000, -0.404070, -0.000000, 2.413782, -0.000000, 1.211043, -0.000000, 0.342582}, 
%% {0.731971, -0.000000, -0.404222, -0.000000, 2.264486, -0.000000, 1.162796, -0.000000, 0.357860}, 
%% {0.723763, -0.000000, -0.404616, -0.000000, 2.130879, -0.000000, 1.119155, -0.000000, 0.374342}, 
%% {0.720079, -0.000000, -0.404937, -0.000000, 2.012036, -0.000000, 1.081054, -0.000000, 0.392069}, 
%% {0.719124, -0.000000, -0.405150, -0.000000, 1.905852, -0.000000, 1.045432, -0.000000, 0.411010}, 
%% {0.720637, -0.000000, -0.405423, -0.000000, 1.811504, -0.000000, 1.011284, -0.000000, 0.431061}, 
%% {0.724127, -0.000000, -0.405248, -0.000000, 1.726465, -0.000000, 0.979332, -0.000000, 0.451931}, 
%% {0.730730, -0.000000, -0.404933, -0.000000, 1.650830, -0.000000, 0.949042, -0.000000, 0.474090}, 
%% {0.738867, -0.000000, -0.403997, -0.000000, 1.581360, -0.000000, 0.919847, -0.000000, 0.497047}, 
%% {0.748314, -0.000000, -0.402515, -0.000000, 1.519375, -0.000000, 0.890472, -0.000000, 0.521019}, 
%% {0.758496, -0.000000, -0.400031, -0.000000, 1.462617, -0.000000, 0.860534, -0.000000, 0.546154}, 
%% {0.770681, -0.000000, -0.396239, -0.000000, 1.410482, -0.000000, 0.829642, -0.000000, 0.573447}, 
%% {0.782931, -0.000000, -0.390958, -0.000000, 1.362872, -0.000000, 0.797049, -0.000000, 0.601992}, 
%% {0.795966, -0.000000, -0.384438, -0.000000, 1.320437, -0.000000, 0.764327, -0.000000, 0.630844}, 
%% {0.807634, -0.000000, -0.376685, -0.000000, 1.281374, -0.000000, 0.729317, -0.000000, 0.659842}, 
%% {0.821062, -0.000000, -0.367521, -0.000000, 1.245525, -0.000000, 0.695016, -0.000000, 0.688899}, 
%% {0.831623, -0.000000, -0.356983, -0.000000, 1.213069, -0.000000, 0.658164, -0.000000, 0.717476}, 
%% {0.843068, -0.000000, -0.345219, -0.000000, 1.182815, -0.000000, 0.621446, -0.000000, 0.745531}, 
%% {0.853322, -0.000000, -0.332201, -0.000000, 1.154389, -0.000000, 0.583597, -0.000000, 0.772804}, 
%% {0.862640, -0.000000, -0.317748, -0.000000, 1.127198, -0.000000, 0.545784, -0.000000, 0.798964}, 
%% {0.870091, -0.000000, -0.302240, -0.000000, 1.102748, -0.000000, 0.506166, -0.000000, 0.824175}, 
%% {0.874571, -0.000000, -0.285740, -0.000000, 1.078515, -0.000000, 0.465539, -0.000000, 0.847899}, 
%% {0.878414, -0.000000, -0.267892, -0.000000, 1.054990, -0.000000, 0.425298, -0.000000, 0.870295}, 
%% {0.879934, -0.000000, -0.248859, -0.000000, 1.032179, -0.000000, 0.384870, -0.000000, 0.891153}, 
%% {0.879684, -0.000000, -0.227912, -0.000000, 1.009160, -0.000000, 0.343741, -0.000000, 0.910942}, 
%% {0.876296, -0.000000, -0.206139, -0.000000, 0.986174, -0.000000, 0.302672, -0.000000, 0.928800}, 
%% {0.871120, -0.000000, -0.183845, -0.000000, 0.963336, -0.000000, 0.262517, -0.000000, 0.944597}, 
%% {0.863534, -0.000000, -0.161220, -0.000000, 0.940292, -0.000000, 0.224267, -0.000000, 0.958130}, 
%% {0.855110, -0.000000, -0.138442, -0.000000, 0.918257, -0.000000, 0.188401, -0.000000, 0.969498}, 
%% {0.845545, -0.000000, -0.115505, -0.000000, 0.898976, -0.000000, 0.155460, -0.000000, 0.978764}, 
%% {0.838320, -0.000000, -0.092574, -0.000000, 0.882843, -0.000000, 0.124508, -0.000000, 0.986251}, 
%% {0.833728, -0.000000, -0.069115, -0.000000, 0.868315, -0.000000, 0.093481, -0.000000, 0.992251}, 
%% {0.832459, -0.000000, -0.045414, -0.000000, 0.854805, -0.000000, 0.061735, -0.000000, 0.996632}, 
%% {0.831510, -0.000000, -0.022238, -0.000000, 0.841708, -0.000000, 0.030372, -0.000000, 0.999188}, 
%% {0.828442, -0.000000, 0.000330, -0.000000, 0.828470, -0.000000, -0.000166, -0.000000, 1.000000}, 
%% {1088.676514, -0.000000, -0.405971, -0.000000, 4562.145996, -0.000000, 2123.519287, -0.000000, 0.208132}, 
%% {413.111267, -0.000000, -0.405971, -0.000000, 1984.001709, -0.000000, 805.794800, -0.000000, 0.208132}, 
%% {103.270828, -0.000000, -0.405975, -0.000000, 496.076843, -0.000000, 201.431580, -0.000000, 0.208138}, 
%% {45.890404, -0.000000, -0.405977, -0.000000, 220.497238, -0.000000, 89.507935, -0.000000, 0.208154}, 
%% {25.815386, -0.000000, -0.405952, -0.000000, 124.029633, -0.000000, 50.353348, -0.000000, 0.208184}, 
%% {16.411552, -0.000000, -0.406014, -0.000000, 79.214554, -0.000000, 32.001122, -0.000000, 0.208307}, 
%% {11.476702, -0.000000, -0.405876, -0.000000, 55.123512, -0.000000, 22.383579, -0.000000, 0.208400}, 
%% {8.432583, -0.000000, -0.405795, -0.000000, 40.503418, -0.000000, 16.445082, -0.000000, 0.208626}, 
%% {6.457528, -0.000000, -0.405672, -0.000000, 31.005575, -0.000000, 12.591645, -0.000000, 0.208974}, 
%% {5.105010, -0.000000, -0.405492, -0.000000, 24.501812, -0.000000, 9.952409, -0.000000, 0.209477}, 
%% {4.140710, -0.000000, -0.405132, -0.000000, 19.863596, -0.000000, 8.070128, -0.000000, 0.210410}, 
%% {3.428821, -0.000000, -0.404690, -0.000000, 16.422445, -0.000000, 6.680184, -0.000000, 0.211565}, 
%% {2.885234, -0.000000, -0.404256, -0.000000, 13.800937, -0.000000, 5.618139, -0.000000, 0.212832}, 
%% {2.464066, -0.000000, -0.403660, -0.000000, 11.767628, -0.000000, 4.794714, -0.000000, 0.214536}, 
%% {2.130837, -0.000000, -0.402988, -0.000000, 10.152556, -0.000000, 4.142457, -0.000000, 0.216571}, 
%% {1.863096, -0.000000, -0.402212, -0.000000, 8.852435, -0.000000, 3.617593, -0.000000, 0.219021}, 
%% {1.645085, -0.000000, -0.401348, -0.000000, 7.789119, -0.000000, 3.189370, -0.000000, 0.221895}, 
%% {1.465867, -0.000000, -0.400430, -0.000000, 6.907283, -0.000000, 2.836293, -0.000000, 0.225211}, 
%% {1.317602, -0.000000, -0.399426, -0.000000, 6.171072, -0.000000, 2.542942, -0.000000, 0.229118}, 
%% {1.193884, -0.000000, -0.398403, -0.000000, 5.547686, -0.000000, 2.296722, -0.000000, 0.233576}, 
%% {1.091136, -0.000000, -0.397359, -0.000000, 5.015746, -0.000000, 2.090494, -0.000000, 0.238705}, 
%% {1.004724, -0.000000, -0.396393, -0.000000, 4.556921, -0.000000, 1.914973, -0.000000, 0.244487}, 
%% {0.933854, -0.000000, -0.395498, -0.000000, 4.157512, -0.000000, 1.768367, -0.000000, 0.251076}, 
%% {0.876006, -0.000000, -0.394736, -0.000000, 3.806842, -0.000000, 1.645390, -0.000000, 0.258573}, 
%% {0.827293, -0.000000, -0.394195, -0.000000, 3.500803, -0.000000, 1.538261, -0.000000, 0.267037}, 
%% {0.788639, -0.000000, -0.393862, -0.000000, 3.228342, -0.000000, 1.448661, -0.000000, 0.276510}, 
%% {0.757643, -0.000000, -0.393870, -0.000000, 2.988241, -0.000000, 1.371050, -0.000000, 0.287243}, 
%% {0.733356, -0.000000, -0.394086, -0.000000, 2.773715, -0.000000, 1.304296, -0.000000, 0.299107}, 
%% {0.715137, -0.000000, -0.394614, -0.000000, 2.585624, -0.000000, 1.246257, -0.000000, 0.312312}, 
%% {0.702420, -0.000000, -0.395428, -0.000000, 2.416798, -0.000000, 1.195722, -0.000000, 0.326868}, 
%% {0.693572, -0.000000, -0.396262, -0.000000, 2.266643, -0.000000, 1.150405, -0.000000, 0.342735}, 
%% {0.688314, -0.000000, -0.397314, -0.000000, 2.134235, -0.000000, 1.108893, -0.000000, 0.359917}, 
%% {0.686421, -0.000000, -0.398477, -0.000000, 2.016442, -0.000000, 1.070640, -0.000000, 0.378478}, 
%% {0.687701, -0.000000, -0.399286, -0.000000, 1.910919, -0.000000, 1.036543, -0.000000, 0.398173}, 
%% {0.692558, -0.000000, -0.400110, -0.000000, 1.815628, -0.000000, 1.005553, -0.000000, 0.419063}, 
%% {0.699245, -0.000000, -0.400668, -0.000000, 1.731687, -0.000000, 0.975600, -0.000000, 0.440981}, 
%% {0.706879, -0.000000, -0.400761, -0.000000, 1.655223, -0.000000, 0.945707, -0.000000, 0.463837}, 
%% {0.716263, -0.000000, -0.400382, -0.000000, 1.587582, -0.000000, 0.916297, -0.000000, 0.487801}, 
%% {0.727252, -0.000000, -0.399415, -0.000000, 1.525026, -0.000000, 0.887630, -0.000000, 0.512504}, 
%% {0.740219, -0.000000, -0.397638, -0.000000, 1.468084, -0.000000, 0.859919, -0.000000, 0.538061}, 
%% {0.753269, -0.000000, -0.394839, -0.000000, 1.416975, -0.000000, 0.830174, -0.000000, 0.564850}, 
%% {0.766906, -0.000000, -0.390348, -0.000000, 1.369414, -0.000000, 0.799145, -0.000000, 0.593242}, 
%% {0.781428, -0.000000, -0.384196, -0.000000, 1.326266, -0.000000, 0.767041, -0.000000, 0.622878}, 
%% {0.794942, -0.000000, -0.376877, -0.000000, 1.288006, -0.000000, 0.732353, -0.000000, 0.652797}, 
%% {0.808810, -0.000000, -0.367993, -0.000000, 1.251286, -0.000000, 0.697806, -0.000000, 0.682512}, 
%% {0.821662, -0.000000, -0.357769, -0.000000, 1.217709, -0.000000, 0.661192, -0.000000, 0.712103}, 
%% {0.833540, -0.000000, -0.345911, -0.000000, 1.187058, -0.000000, 0.624681, -0.000000, 0.740763}, 
%% {0.843874, -0.000000, -0.332885, -0.000000, 1.158349, -0.000000, 0.586296, -0.000000, 0.768723}, 
%% {0.853544, -0.000000, -0.318576, -0.000000, 1.131079, -0.000000, 0.547212, -0.000000, 0.795759}, 
%% {0.862043, -0.000000, -0.302876, -0.000000, 1.105326, -0.000000, 0.508337, -0.000000, 0.821397}, 
%% {0.867610, -0.000000, -0.286146, -0.000000, 1.080085, -0.000000, 0.467921, -0.000000, 0.845676}, 
%% {0.871580, -0.000000, -0.268361, -0.000000, 1.056621, -0.000000, 0.427146, -0.000000, 0.868481}, 
%% {0.874185, -0.000000, -0.249485, -0.000000, 1.032764, -0.000000, 0.387004, -0.000000, 0.889552}, 
%% {0.873835, -0.000000, -0.229628, -0.000000, 1.010150, -0.000000, 0.345961, -0.000000, 0.909088}, 
%% {0.871007, -0.000000, -0.208167, -0.000000, 0.985726, -0.000000, 0.305032, -0.000000, 0.927099}, 
%% {0.865904, -0.000000, -0.185561, -0.000000, 0.962205, -0.000000, 0.264253, -0.000000, 0.943371}, 
%% {0.858155, -0.000000, -0.162443, -0.000000, 0.938045, -0.000000, 0.225425, -0.000000, 0.957329}, 
%% {0.849481, -0.000000, -0.139181, -0.000000, 0.915735, -0.000000, 0.189501, -0.000000, 0.968952}, 
%% {0.840757, -0.000000, -0.115847, -0.000000, 0.896258, -0.000000, 0.156088, -0.000000, 0.978493}, 
%% {0.833858, -0.000000, -0.092631, -0.000000, 0.880233, -0.000000, 0.125116, -0.000000, 0.986101}, 
%% {0.829670, -0.000000, -0.069647, -0.000000, 0.865296, -0.000000, 0.094132, -0.000000, 0.992098}, 
%% {0.828218, -0.000000, -0.046500, -0.000000, 0.851421, -0.000000, 0.062492, -0.000000, 0.996491}, 
%% {0.827601, -0.000000, -0.022912, -0.000000, 0.837989, -0.000000, 0.030801, -0.000000, 0.999147}, 
%% {0.824389, -0.000000, 0.000298, -0.000000, 0.824338, -0.000000, -0.000241, -0.000000, 1.000000}, 
%% {1008.151123, -0.000000, -0.390918, -0.000000, 4338.874023, -0.000000, 2093.425537, -0.000000, 0.188258}, 
%% {373.187347, -0.000000, -0.390918, -0.000000, 1983.350830, -0.000000, 774.923096, -0.000000, 0.188259}, 
%% {93.478218, -0.000000, -0.390913, -0.000000, 495.996948, -0.000000, 194.109711, -0.000000, 0.188260}, 
%% {41.478168, -0.000000, -0.390917, -0.000000, 220.571640, -0.000000, 86.127464, -0.000000, 0.188279}, 
%% {23.356005, -0.000000, -0.390907, -0.000000, 124.062996, -0.000000, 48.496643, -0.000000, 0.188318}, 
%% {14.935571, -0.000000, -0.390874, -0.000000, 79.401978, -0.000000, 31.012047, -0.000000, 0.188394}, 
%% {10.383014, -0.000000, -0.390827, -0.000000, 55.112610, -0.000000, 21.557886, -0.000000, 0.188539}, 
%% {7.622106, -0.000000, -0.390753, -0.000000, 40.513927, -0.000000, 15.823830, -0.000000, 0.188779}, 
%% {5.842702, -0.000000, -0.390635, -0.000000, 31.009596, -0.000000, 12.127952, -0.000000, 0.189143}, 
%% {4.618832, -0.000000, -0.390466, -0.000000, 24.501785, -0.000000, 9.585324, -0.000000, 0.189677}, 
%% {3.748687, -0.000000, -0.390095, -0.000000, 19.865486, -0.000000, 7.777109, -0.000000, 0.190701}, 
%% {3.102649, -0.000000, -0.389732, -0.000000, 16.423502, -0.000000, 6.433990, -0.000000, 0.191810}, 
%% {2.611357, -0.000000, -0.389315, -0.000000, 13.805322, -0.000000, 5.411925, -0.000000, 0.193162}, 
%% {2.231456, -0.000000, -0.388750, -0.000000, 11.773058, -0.000000, 4.620906, -0.000000, 0.194974}, 
%% {1.929817, -0.000000, -0.388155, -0.000000, 10.157097, -0.000000, 3.992111, -0.000000, 0.197043}, 
%% {1.688205, -0.000000, -0.387451, -0.000000, 8.856880, -0.000000, 3.487572, -0.000000, 0.199585}, 
%% {1.491718, -0.000000, -0.386679, -0.000000, 7.794961, -0.000000, 3.076203, -0.000000, 0.202596}, 
%% {1.330564, -0.000000, -0.385850, -0.000000, 6.914401, -0.000000, 2.737725, -0.000000, 0.206088}, 
%% {1.197120, -0.000000, -0.385015, -0.000000, 6.177982, -0.000000, 2.456003, -0.000000, 0.210106}, 
%% {1.086435, -0.000000, -0.384198, -0.000000, 5.554076, -0.000000, 2.220619, -0.000000, 0.214719}, 
%% {0.994979, -0.000000, -0.383369, -0.000000, 5.021650, -0.000000, 2.024230, -0.000000, 0.220058}, 
%% {0.918748, -0.000000, -0.382669, -0.000000, 4.561943, -0.000000, 1.858047, -0.000000, 0.226103}, 
%% {0.856149, -0.000000, -0.382166, -0.000000, 4.161524, -0.000000, 1.718428, -0.000000, 0.232932}, 
%% {0.804997, -0.000000, -0.381793, -0.000000, 3.811767, -0.000000, 1.600816, -0.000000, 0.240767}, 
%% {0.763791, -0.000000, -0.381750, -0.000000, 3.501949, -0.000000, 1.501510, -0.000000, 0.249532}, 
%% {0.730699, -0.000000, -0.382002, -0.000000, 3.230014, -0.000000, 1.416610, -0.000000, 0.259410}, 
%% {0.704946, -0.000000, -0.382613, -0.000000, 2.990338, -0.000000, 1.343889, -0.000000, 0.270598}, 
%% {0.685038, -0.000000, -0.383555, -0.000000, 2.776664, -0.000000, 1.280648, -0.000000, 0.282961}, 
%% {0.671315, -0.000000, -0.384780, -0.000000, 2.586412, -0.000000, 1.227128, -0.000000, 0.296642}, 
%% {0.661257, -0.000000, -0.386274, -0.000000, 2.420452, -0.000000, 1.178130, -0.000000, 0.311793}, 
%% {0.655615, -0.000000, -0.388022, -0.000000, 2.272379, -0.000000, 1.134795, -0.000000, 0.328379}, 
%% {0.653814, -0.000000, -0.389839, -0.000000, 2.139811, -0.000000, 1.096330, -0.000000, 0.346310}, 
%% {0.655377, -0.000000, -0.391656, -0.000000, 2.021369, -0.000000, 1.061753, -0.000000, 0.365493}, 
%% {0.659250, -0.000000, -0.393302, -0.000000, 1.915851, -0.000000, 1.029029, -0.000000, 0.386091}, 
%% {0.665463, -0.000000, -0.394711, -0.000000, 1.822206, -0.000000, 0.998405, -0.000000, 0.407808}, 
%% {0.673029, -0.000000, -0.395906, -0.000000, 1.739224, -0.000000, 0.967902, -0.000000, 0.430637}, 
%% {0.683582, -0.000000, -0.396573, -0.000000, 1.661580, -0.000000, 0.940435, -0.000000, 0.454416}, 
%% {0.695770, -0.000000, -0.396720, -0.000000, 1.593802, -0.000000, 0.913356, -0.000000, 0.479215}, 
%% {0.708136, -0.000000, -0.396145, -0.000000, 1.531472, -0.000000, 0.885215, -0.000000, 0.504793}, 
%% {0.722362, -0.000000, -0.394821, -0.000000, 1.475195, -0.000000, 0.858050, -0.000000, 0.531016}, 
%% {0.736726, -0.000000, -0.392634, -0.000000, 1.424412, -0.000000, 0.829195, -0.000000, 0.558086}, 
%% {0.751259, -0.000000, -0.389138, -0.000000, 1.377451, -0.000000, 0.799210, -0.000000, 0.586024}, 
%% {0.766686, -0.000000, -0.383898, -0.000000, 1.333306, -0.000000, 0.768337, -0.000000, 0.615275}, 
%% {0.782413, -0.000000, -0.376829, -0.000000, 1.292843, -0.000000, 0.735320, -0.000000, 0.645852}, 
%% {0.796796, -0.000000, -0.368381, -0.000000, 1.256996, -0.000000, 0.699810, -0.000000, 0.676459}, 
%% {0.810669, -0.000000, -0.358257, -0.000000, 1.223536, -0.000000, 0.664100, -0.000000, 0.706515}, 
%% {0.824793, -0.000000, -0.346658, -0.000000, 1.190835, -0.000000, 0.628168, -0.000000, 0.735983}, 
%% {0.835826, -0.000000, -0.333555, -0.000000, 1.161504, -0.000000, 0.589550, -0.000000, 0.764727}, 
%% {0.846231, -0.000000, -0.319226, -0.000000, 1.133868, -0.000000, 0.550230, -0.000000, 0.792435}, 
%% {0.854790, -0.000000, -0.303528, -0.000000, 1.107352, -0.000000, 0.510970, -0.000000, 0.818559}, 
%% {0.861149, -0.000000, -0.286562, -0.000000, 1.082198, -0.000000, 0.470113, -0.000000, 0.843562}, 
%% {0.866110, -0.000000, -0.268622, -0.000000, 1.058097, -0.000000, 0.429297, -0.000000, 0.866855}, 
%% {0.868575, -0.000000, -0.249625, -0.000000, 1.034278, -0.000000, 0.389145, -0.000000, 0.888162}, 
%% {0.868835, -0.000000, -0.229878, -0.000000, 1.010143, -0.000000, 0.347960, -0.000000, 0.907936}, 
%% {0.866399, -0.000000, -0.209204, -0.000000, 0.986272, -0.000000, 0.306781, -0.000000, 0.925923}, 
%% {0.861710, -0.000000, -0.187426, -0.000000, 0.961645, -0.000000, 0.266968, -0.000000, 0.941933}, 
%% {0.854411, -0.000000, -0.164166, -0.000000, 0.936678, -0.000000, 0.227527, -0.000000, 0.956283}, 
%% {0.845959, -0.000000, -0.140408, -0.000000, 0.913671, -0.000000, 0.191044, -0.000000, 0.968292}, 
%% {0.837009, -0.000000, -0.116490, -0.000000, 0.893716, -0.000000, 0.157157, -0.000000, 0.978128}, 
%% {0.829942, -0.000000, -0.092879, -0.000000, 0.876945, -0.000000, 0.125588, -0.000000, 0.985946}, 
%% {0.825872, -0.000000, -0.069355, -0.000000, 0.861852, -0.000000, 0.094428, -0.000000, 0.992070}, 
%% {0.824292, -0.000000, -0.046234, -0.000000, 0.847674, -0.000000, 0.062715, -0.000000, 0.996482}, 
%% {0.823442, -0.000000, -0.023360, -0.000000, 0.834208, -0.000000, 0.031073, -0.000000, 0.999118}, 
%% {0.820197, -0.000000, -0.000438, -0.000000, 0.820170, -0.000000, 0.000063, -0.000000, 1.000000}, 
%% {928.351440, -0.000000, -0.374894, -0.000000, 4112.912598, -0.000000, 2057.413086, -0.000000, 0.169161}, 
%% {335.616547, -0.000000, -0.374894, -0.000000, 1984.154175, -0.000000, 743.792847, -0.000000, 0.169161}, 
%% {83.882385, -0.000000, -0.374894, -0.000000, 496.527954, -0.000000, 185.899307, -0.000000, 0.169165}, 
%% {37.297993, -0.000000, -0.374895, -0.000000, 220.548553, -0.000000, 82.657196, -0.000000, 0.169183}, 
%% {20.980968, -0.000000, -0.374877, -0.000000, 124.046013, -0.000000, 46.496861, -0.000000, 0.169218}, 
%% {13.578001, -0.000000, -0.374799, -0.000000, 78.553253, -0.000000, 30.094927, -0.000000, 0.169278}, 
%% {9.332950, -0.000000, -0.374803, -0.000000, 55.075886, -0.000000, 20.681419, -0.000000, 0.169452}, 
%% {6.854582, -0.000000, -0.374740, -0.000000, 40.502182, -0.000000, 15.187384, -0.000000, 0.169706}, 
%% {5.250422, -0.000000, -0.374631, -0.000000, 31.009718, -0.000000, 11.631174, -0.000000, 0.170087}, 
%% {4.151496, -0.000000, -0.374468, -0.000000, 24.504240, -0.000000, 9.194381, -0.000000, 0.170659}, 
%% {3.370310, -0.000000, -0.374119, -0.000000, 19.870489, -0.000000, 7.461546, -0.000000, 0.171736}, 
%% {2.789488, -0.000000, -0.373798, -0.000000, 16.426624, -0.000000, 6.172600, -0.000000, 0.172858}, 
%% {2.348042, -0.000000, -0.373427, -0.000000, 13.807893, -0.000000, 5.192232, -0.000000, 0.174239}, 
%% {2.007098, -0.000000, -0.372921, -0.000000, 11.775651, -0.000000, 4.434276, -0.000000, 0.176107}, 
%% {1.737050, -0.000000, -0.372368, -0.000000, 10.164235, -0.000000, 3.833073, -0.000000, 0.178312}, 
%% {1.520087, -0.000000, -0.371772, -0.000000, 8.863171, -0.000000, 3.349105, -0.000000, 0.180900}, 
%% {1.344278, -0.000000, -0.371111, -0.000000, 7.800463, -0.000000, 2.955769, -0.000000, 0.184009}, 
%% {1.200115, -0.000000, -0.370427, -0.000000, 6.921257, -0.000000, 2.631962, -0.000000, 0.187619}, 
%% {1.081282, -0.000000, -0.369734, -0.000000, 6.184636, -0.000000, 2.363530, -0.000000, 0.191815}, 
%% {0.982727, -0.000000, -0.369104, -0.000000, 5.561043, -0.000000, 2.138989, -0.000000, 0.196614}, 
%% {0.902113, -0.000000, -0.368571, -0.000000, 5.027927, -0.000000, 1.952856, -0.000000, 0.202133}, 
%% {0.835591, -0.000000, -0.368218, -0.000000, 4.567096, -0.000000, 1.796334, -0.000000, 0.208413}, 
%% {0.781262, -0.000000, -0.368082, -0.000000, 4.165853, -0.000000, 1.665045, -0.000000, 0.215534}, 
%% {0.737450, -0.000000, -0.368138, -0.000000, 3.815070, -0.000000, 1.555130, -0.000000, 0.223674}, 
%% {0.702961, -0.000000, -0.368736, -0.000000, 3.504335, -0.000000, 1.462570, -0.000000, 0.232813}, 
%% {0.675403, -0.000000, -0.369618, -0.000000, 3.232338, -0.000000, 1.383085, -0.000000, 0.243099}, 
%% {0.654702, -0.000000, -0.370875, -0.000000, 2.991558, -0.000000, 1.315635, -0.000000, 0.254720}, 
%% {0.639087, -0.000000, -0.372608, -0.000000, 2.779744, -0.000000, 1.256191, -0.000000, 0.267602}, 
%% {0.628815, -0.000000, -0.374653, -0.000000, 2.591517, -0.000000, 1.205382, -0.000000, 0.281823}, 
%% {0.622925, -0.000000, -0.376933, -0.000000, 2.424605, -0.000000, 1.160840, -0.000000, 0.297573}, 
%% {0.619471, -0.000000, -0.379402, -0.000000, 2.277518, -0.000000, 1.118942, -0.000000, 0.314691}, 
%% {0.620590, -0.000000, -0.381943, -0.000000, 2.144912, -0.000000, 1.083452, -0.000000, 0.333188}, 
%% {0.624451, -0.000000, -0.384680, -0.000000, 2.029132, -0.000000, 1.049788, -0.000000, 0.353301}, 
%% {0.630897, -0.000000, -0.387147, -0.000000, 1.924409, -0.000000, 1.019049, -0.000000, 0.374666}, 
%% {0.640053, -0.000000, -0.389324, -0.000000, 1.830295, -0.000000, 0.990804, -0.000000, 0.397326}, 
%% {0.650580, -0.000000, -0.391074, -0.000000, 1.745692, -0.000000, 0.963149, -0.000000, 0.421036}, 
%% {0.661989, -0.000000, -0.392454, -0.000000, 1.670887, -0.000000, 0.934785, -0.000000, 0.445822}, 
%% {0.675268, -0.000000, -0.392988, -0.000000, 1.601090, -0.000000, 0.908323, -0.000000, 0.471381}, 
%% {0.690419, -0.000000, -0.392823, -0.000000, 1.539015, -0.000000, 0.882659, -0.000000, 0.497800}, 
%% {0.705229, -0.000000, -0.391855, -0.000000, 1.483247, -0.000000, 0.855053, -0.000000, 0.524897}, 
%% {0.721303, -0.000000, -0.390177, -0.000000, 1.432053, -0.000000, 0.826820, -0.000000, 0.552745}, 
%% {0.737016, -0.000000, -0.387133, -0.000000, 1.384736, -0.000000, 0.797894, -0.000000, 0.580889}, 
%% {0.753492, -0.000000, -0.382764, -0.000000, 1.341082, -0.000000, 0.768545, -0.000000, 0.609589}, 
%% {0.769484, -0.000000, -0.376829, -0.000000, 1.301682, -0.000000, 0.736343, -0.000000, 0.639401}, 
%% {0.785285, -0.000000, -0.368569, -0.000000, 1.262355, -0.000000, 0.702207, -0.000000, 0.670423}, 
%% {0.801304, -0.000000, -0.358678, -0.000000, 1.226939, -0.000000, 0.667836, -0.000000, 0.701065}, 
%% {0.815034, -0.000000, -0.347305, -0.000000, 1.195901, -0.000000, 0.630519, -0.000000, 0.731321}, 
%% {0.827462, -0.000000, -0.334315, -0.000000, 1.165332, -0.000000, 0.592477, -0.000000, 0.760625}, 
%% {0.838621, -0.000000, -0.319895, -0.000000, 1.137345, -0.000000, 0.553083, -0.000000, 0.789024}, 
%% {0.847626, -0.000000, -0.304214, -0.000000, 1.110460, -0.000000, 0.512499, -0.000000, 0.816064}, 
%% {0.854776, -0.000000, -0.287190, -0.000000, 1.084270, -0.000000, 0.472123, -0.000000, 0.841375}, 
%% {0.860506, -0.000000, -0.268936, -0.000000, 1.058992, -0.000000, 0.431622, -0.000000, 0.865104}, 
%% {0.862817, -0.000000, -0.249744, -0.000000, 1.034662, -0.000000, 0.390021, -0.000000, 0.887108}, 
%% {0.864498, -0.000000, -0.229744, -0.000000, 1.010232, -0.000000, 0.349557, -0.000000, 0.907104}, 
%% {0.861777, -0.000000, -0.209042, -0.000000, 0.985470, -0.000000, 0.308038, -0.000000, 0.925279}, 
%% {0.857713, -0.000000, -0.187565, -0.000000, 0.960518, -0.000000, 0.268064, -0.000000, 0.941380}, 
%% {0.850531, -0.000000, -0.165399, -0.000000, 0.935273, -0.000000, 0.229164, -0.000000, 0.955436}, 
%% {0.842637, -0.000000, -0.142235, -0.000000, 0.911707, -0.000000, 0.192615, -0.000000, 0.967487}, 
%% {0.833754, -0.000000, -0.118019, -0.000000, 0.891108, -0.000000, 0.158302, -0.000000, 0.977592}, 
%% {0.826281, -0.000000, -0.093638, -0.000000, 0.873831, -0.000000, 0.126232, -0.000000, 0.985695}, 
%% {0.821962, -0.000000, -0.069703, -0.000000, 0.858248, -0.000000, 0.094846, -0.000000, 0.991957}, 
%% {0.820123, -0.000000, -0.045942, -0.000000, 0.843855, -0.000000, 0.062734, -0.000000, 0.996486}, 
%% {0.818937, -0.000000, -0.022712, -0.000000, 0.829859, -0.000000, 0.030928, -0.000000, 0.999142}, 
%% {0.815759, -0.000000, 0.000041, -0.000000, 0.815699, -0.000000, -0.000130, -0.000000, 1.000000}, 
%% {848.103882, -0.000000, -0.357936, -0.000000, 3884.386230, -0.000000, 2011.916870, -0.000000, 0.150885}, 
%% {299.427094, -0.000000, -0.357937, -0.000000, 1984.701782, -0.000000, 710.315430, -0.000000, 0.150885}, 
%% {74.857574, -0.000000, -0.357943, -0.000000, 496.088989, -0.000000, 177.576172, -0.000000, 0.150892}, 
%% {33.306316, -0.000000, -0.357920, -0.000000, 220.055756, -0.000000, 79.013184, -0.000000, 0.150899}, 
%% {18.680128, -0.000000, -0.357934, -0.000000, 124.043381, -0.000000, 44.310841, -0.000000, 0.150951}, 
%% {11.951658, -0.000000, -0.357893, -0.000000, 79.524536, -0.000000, 28.350863, -0.000000, 0.151031}, 
%% {8.322553, -0.000000, -0.357860, -0.000000, 55.126354, -0.000000, 19.740278, -0.000000, 0.151192}, 
%% {6.114530, -0.000000, -0.357796, -0.000000, 40.505249, -0.000000, 14.501192, -0.000000, 0.151454}, 
%% {4.683779, -0.000000, -0.357698, -0.000000, 31.010336, -0.000000, 11.105802, -0.000000, 0.151854}, 
%% {3.705776, -0.000000, -0.357511, -0.000000, 24.514641, -0.000000, 8.784277, -0.000000, 0.152545}, 
%% {3.007402, -0.000000, -0.357236, -0.000000, 19.872244, -0.000000, 7.125860, -0.000000, 0.153550}, 
%% {2.489453, -0.000000, -0.356964, -0.000000, 16.428402, -0.000000, 5.895210, -0.000000, 0.154683}, 
%% {2.097196, -0.000000, -0.356595, -0.000000, 13.816349, -0.000000, 4.962422, -0.000000, 0.156219}, 
%% {1.792447, -0.000000, -0.356190, -0.000000, 11.780900, -0.000000, 4.236890, -0.000000, 0.158056}, 
%% {1.552287, -0.000000, -0.355701, -0.000000, 10.170300, -0.000000, 3.664199, -0.000000, 0.160361}, 
%% {1.359516, -0.000000, -0.355178, -0.000000, 8.872328, -0.000000, 3.203434, -0.000000, 0.163093}, 
%% {1.203425, -0.000000, -0.354654, -0.000000, 7.809768, -0.000000, 2.829009, -0.000000, 0.166281}, 
%% {1.075515, -0.000000, -0.354125, -0.000000, 6.930161, -0.000000, 2.520774, -0.000000, 0.170009}, 
%% {0.970771, -0.000000, -0.353650, -0.000000, 6.193275, -0.000000, 2.266434, -0.000000, 0.174342}, 
%% {0.884559, -0.000000, -0.353271, -0.000000, 5.569030, -0.000000, 2.054940, -0.000000, 0.179308}, 
%% {0.814095, -0.000000, -0.353005, -0.000000, 5.035123, -0.000000, 1.879377, -0.000000, 0.185072}, 
%% {0.756327, -0.000000, -0.353049, -0.000000, 4.572693, -0.000000, 1.731974, -0.000000, 0.191525}, 
%% {0.710260, -0.000000, -0.353361, -0.000000, 4.170510, -0.000000, 1.610134, -0.000000, 0.198944}, 
%% {0.673038, -0.000000, -0.353988, -0.000000, 3.817752, -0.000000, 1.506981, -0.000000, 0.207394}, 
%% {0.644489, -0.000000, -0.355179, -0.000000, 3.508114, -0.000000, 1.420975, -0.000000, 0.216899}, 
%% {0.623238, -0.000000, -0.356786, -0.000000, 3.233384, -0.000000, 1.349203, -0.000000, 0.227621}, 
%% {0.605911, -0.000000, -0.358753, -0.000000, 2.995492, -0.000000, 1.284221, -0.000000, 0.239628}, 
%% {0.596221, -0.000000, -0.361325, -0.000000, 2.782205, -0.000000, 1.232545, -0.000000, 0.253045}, 
%% {0.587840, -0.000000, -0.364268, -0.000000, 2.597646, -0.000000, 1.181522, -0.000000, 0.267844}, 
%% {0.585345, -0.000000, -0.367352, -0.000000, 2.430783, -0.000000, 1.140779, -0.000000, 0.284067}, 
%% {0.586589, -0.000000, -0.370767, -0.000000, 2.283793, -0.000000, 1.104366, -0.000000, 0.301961}, 
%% {0.590196, -0.000000, -0.374203, -0.000000, 2.151459, -0.000000, 1.070658, -0.000000, 0.321168}, 
%% {0.596360, -0.000000, -0.377638, -0.000000, 2.036360, -0.000000, 1.039286, -0.000000, 0.341883}, 
%% {0.604565, -0.000000, -0.380881, -0.000000, 1.932017, -0.000000, 1.009444, -0.000000, 0.364042}, 
%% {0.614510, -0.000000, -0.383792, -0.000000, 1.840169, -0.000000, 0.980770, -0.000000, 0.387460}, 
%% {0.627100, -0.000000, -0.386136, -0.000000, 1.755486, -0.000000, 0.954805, -0.000000, 0.412080}, 
%% {0.641716, -0.000000, -0.388070, -0.000000, 1.678792, -0.000000, 0.929832, -0.000000, 0.437695}, 
%% {0.656109, -0.000000, -0.389270, -0.000000, 1.611480, -0.000000, 0.902971, -0.000000, 0.464267}, 
%% {0.672008, -0.000000, -0.389514, -0.000000, 1.547980, -0.000000, 0.877170, -0.000000, 0.491568}, 
%% {0.688908, -0.000000, -0.388870, -0.000000, 1.491720, -0.000000, 0.851179, -0.000000, 0.519533}, 
%% {0.705733, -0.000000, -0.387297, -0.000000, 1.440856, -0.000000, 0.823626, -0.000000, 0.548005}, 
%% {0.723760, -0.000000, -0.384617, -0.000000, 1.392032, -0.000000, 0.796523, -0.000000, 0.576716}, 
%% {0.741070, -0.000000, -0.380746, -0.000000, 1.347397, -0.000000, 0.767115, -0.000000, 0.605874}, 
%% {0.758106, -0.000000, -0.375389, -0.000000, 1.306847, -0.000000, 0.736563, -0.000000, 0.635278}, 
%% {0.774689, -0.000000, -0.368512, -0.000000, 1.269289, -0.000000, 0.704069, -0.000000, 0.665081}, 
%% {0.790903, -0.000000, -0.359148, -0.000000, 1.233350, -0.000000, 0.669658, -0.000000, 0.695909}, 
%% {0.805444, -0.000000, -0.347982, -0.000000, 1.201297, -0.000000, 0.632541, -0.000000, 0.726718}, 
%% {0.818703, -0.000000, -0.335108, -0.000000, 1.169825, -0.000000, 0.594713, -0.000000, 0.756574}, 
%% {0.831913, -0.000000, -0.320801, -0.000000, 1.140374, -0.000000, 0.556206, -0.000000, 0.785517}, 
%% {0.840861, -0.000000, -0.304900, -0.000000, 1.112904, -0.000000, 0.515400, -0.000000, 0.813114}, 
%% {0.848782, -0.000000, -0.287836, -0.000000, 1.086169, -0.000000, 0.474501, -0.000000, 0.839089}, 
%% {0.854662, -0.000000, -0.269522, -0.000000, 1.059870, -0.000000, 0.433200, -0.000000, 0.863389}, 
%% {0.858194, -0.000000, -0.250084, -0.000000, 1.034348, -0.000000, 0.392138, -0.000000, 0.885728}, 
%% {0.859321, -0.000000, -0.229771, -0.000000, 1.009872, -0.000000, 0.350424, -0.000000, 0.906301}, 
%% {0.857515, -0.000000, -0.208673, -0.000000, 0.984560, -0.000000, 0.309556, -0.000000, 0.924671}, 
%% {0.853520, -0.000000, -0.187096, -0.000000, 0.959185, -0.000000, 0.269351, -0.000000, 0.940957}, 
%% {0.846373, -0.000000, -0.165039, -0.000000, 0.933231, -0.000000, 0.229995, -0.000000, 0.955152}, 
%% {0.838093, -0.000000, -0.142390, -0.000000, 0.909444, -0.000000, 0.193350, -0.000000, 0.967150}, 
%% {0.828444, -0.000000, -0.119263, -0.000000, 0.887843, -0.000000, 0.159182, -0.000000, 0.977084}, 
%% {0.820935, -0.000000, -0.095371, -0.000000, 0.870338, -0.000000, 0.127379, -0.000000, 0.985202}, 
%% {0.816339, -0.000000, -0.070740, -0.000000, 0.854127, -0.000000, 0.095570, -0.000000, 0.991718}, 
%% {0.814890, -0.000000, -0.046413, -0.000000, 0.839369, -0.000000, 0.063113, -0.000000, 0.996405}, 
%% {0.814110, -0.000000, -0.022700, -0.000000, 0.825223, -0.000000, 0.031011, -0.000000, 0.999135}, 
%% {0.810837, -0.000000, 0.000674, -0.000000, 0.810872, -0.000000, -0.000375, -0.000000, 1.000000}, 
%% {769.351807, -0.000000, -0.340090, -0.000000, 3653.455566, -0.000000, 1960.248047, -0.000000, 0.133478}, 
%% {264.969360, -0.000000, -0.340090, -0.000000, 1984.155640, -0.000000, 675.120422, -0.000000, 0.133478}, 
%% {66.268501, -0.000000, -0.340098, -0.000000, 496.002411, -0.000000, 168.841827, -0.000000, 0.133484}, 
%% {29.521378, -0.000000, -0.340121, -0.000000, 219.619873, -0.000000, 75.208267, -0.000000, 0.133511}, 
%% {16.570454, -0.000000, -0.340089, -0.000000, 124.007545, -0.000000, 42.216957, -0.000000, 0.133546}, 
%% {10.617379, -0.000000, -0.340060, -0.000000, 79.320259, -0.000000, 27.049744, -0.000000, 0.133633}, 
%% {7.399593, -0.000000, -0.339999, -0.000000, 54.923164, -0.000000, 18.851845, -0.000000, 0.133788}, 
%% {5.409702, -0.000000, -0.339966, -0.000000, 40.504978, -0.000000, 13.779092, -0.000000, 0.134070}, 
%% {4.144316, -0.000000, -0.339880, -0.000000, 31.014153, -0.000000, 10.553592, -0.000000, 0.134488}, 
%% {3.280699, -0.000000, -0.339684, -0.000000, 24.523880, -0.000000, 8.351622, -0.000000, 0.135272}, 
%% {2.661760, -0.000000, -0.339473, -0.000000, 19.876669, -0.000000, 6.772683, -0.000000, 0.136231}, 
%% {2.203960, -0.000000, -0.339236, -0.000000, 16.433208, -0.000000, 5.604107, -0.000000, 0.137410}, 
%% {1.857782, -0.000000, -0.338909, -0.000000, 13.822602, -0.000000, 4.719618, -0.000000, 0.139016}, 
%% {1.588550, -0.000000, -0.338574, -0.000000, 11.788119, -0.000000, 4.030757, -0.000000, 0.140909}, 
%% {1.376181, -0.000000, -0.338196, -0.000000, 10.176617, -0.000000, 3.486344, -0.000000, 0.143233}, 
%% {1.206620, -0.000000, -0.337783, -0.000000, 8.878912, -0.000000, 3.050419, -0.000000, 0.146061}, 
%% {1.069087, -0.000000, -0.337395, -0.000000, 7.818233, -0.000000, 2.695423, -0.000000, 0.149348}, 
%% {0.957539, -0.000000, -0.337035, -0.000000, 6.938656, -0.000000, 2.405701, -0.000000, 0.153241}, 
%% {0.865790, -0.000000, -0.336786, -0.000000, 6.202254, -0.000000, 2.165334, -0.000000, 0.157701}, 
%% {0.791167, -0.000000, -0.336696, -0.000000, 5.576408, -0.000000, 1.967197, -0.000000, 0.162821}, 
%% {0.730381, -0.000000, -0.336773, -0.000000, 5.041522, -0.000000, 1.802706, -0.000000, 0.168785}, 
%% {0.681776, -0.000000, -0.337253, -0.000000, 4.576575, -0.000000, 1.666789, -0.000000, 0.175492}, 
%% {0.642979, -0.000000, -0.338136, -0.000000, 4.173745, -0.000000, 1.553141, -0.000000, 0.183221}, 
%% {0.613005, -0.000000, -0.339417, -0.000000, 3.820763, -0.000000, 1.459326, -0.000000, 0.191981}, 
%% {0.589731, -0.000000, -0.341292, -0.000000, 3.511161, -0.000000, 1.379101, -0.000000, 0.201881}, 
%% {0.573010, -0.000000, -0.343638, -0.000000, 3.237340, -0.000000, 1.312340, -0.000000, 0.212982}, 
%% {0.561046, -0.000000, -0.346510, -0.000000, 3.000422, -0.000000, 1.254026, -0.000000, 0.225495}, 
%% {0.553916, -0.000000, -0.349871, -0.000000, 2.789754, -0.000000, 1.204175, -0.000000, 0.239405}, 
%% {0.549960, -0.000000, -0.353669, -0.000000, 2.604596, -0.000000, 1.158929, -0.000000, 0.254714}, 
%% {0.550417, -0.000000, -0.357754, -0.000000, 2.439472, -0.000000, 1.120716, -0.000000, 0.271569}, 
%% {0.553287, -0.000000, -0.361954, -0.000000, 2.293636, -0.000000, 1.085325, -0.000000, 0.289993}, 
%% {0.559576, -0.000000, -0.366338, -0.000000, 2.163810, -0.000000, 1.054018, -0.000000, 0.309965}, 
%% {0.567441, -0.000000, -0.370567, -0.000000, 2.047239, -0.000000, 1.023958, -0.000000, 0.331303}, 
%% {0.578968, -0.000000, -0.374589, -0.000000, 1.943155, -0.000000, 0.998169, -0.000000, 0.354191}, 
%% {0.592145, -0.000000, -0.378298, -0.000000, 1.848993, -0.000000, 0.972905, -0.000000, 0.378450}, 
%% {0.606010, -0.000000, -0.381237, -0.000000, 1.765416, -0.000000, 0.947758, -0.000000, 0.403772}, 
%% {0.621032, -0.000000, -0.383712, -0.000000, 1.690868, -0.000000, 0.921993, -0.000000, 0.430336}, 
%% {0.638916, -0.000000, -0.385445, -0.000000, 1.620882, -0.000000, 0.898784, -0.000000, 0.457782}, 
%% {0.654588, -0.000000, -0.386127, -0.000000, 1.558611, -0.000000, 0.871564, -0.000000, 0.485883}, 
%% {0.673921, -0.000000, -0.385984, -0.000000, 1.501707, -0.000000, 0.846981, -0.000000, 0.514896}, 
%% {0.691782, -0.000000, -0.384585, -0.000000, 1.449594, -0.000000, 0.819962, -0.000000, 0.544156}, 
%% {0.710155, -0.000000, -0.382058, -0.000000, 1.401042, -0.000000, 0.792490, -0.000000, 0.573646}, 
%% {0.728264, -0.000000, -0.378403, -0.000000, 1.357042, -0.000000, 0.763491, -0.000000, 0.603293}, 
%% {0.746977, -0.000000, -0.373374, -0.000000, 1.315150, -0.000000, 0.734230, -0.000000, 0.632997}, 
%% {0.764314, -0.000000, -0.366810, -0.000000, 1.277167, -0.000000, 0.703147, -0.000000, 0.662545}, 
%% {0.780896, -0.000000, -0.358770, -0.000000, 1.240033, -0.000000, 0.670087, -0.000000, 0.692139}, 
%% {0.796363, -0.000000, -0.348622, -0.000000, 1.206894, -0.000000, 0.634474, -0.000000, 0.722248}, 
%% {0.811483, -0.000000, -0.336009, -0.000000, 1.175225, -0.000000, 0.597383, -0.000000, 0.752643}, 
%% {0.822975, -0.000000, -0.321710, -0.000000, 1.144352, -0.000000, 0.557659, -0.000000, 0.782005}, 
%% {0.833863, -0.000000, -0.305997, -0.000000, 1.115596, -0.000000, 0.517393, -0.000000, 0.810136}, 
%% {0.842639, -0.000000, -0.288690, -0.000000, 1.087935, -0.000000, 0.476771, -0.000000, 0.836657}, 
%% {0.848228, -0.000000, -0.270242, -0.000000, 1.061251, -0.000000, 0.435214, -0.000000, 0.861342}, 
%% {0.852026, -0.000000, -0.250702, -0.000000, 1.034608, -0.000000, 0.393272, -0.000000, 0.884283}, 
%% {0.853557, -0.000000, -0.230120, -0.000000, 1.009347, -0.000000, 0.351527, -0.000000, 0.905228}, 
%% {0.850272, -0.000000, -0.208834, -0.000000, 0.982318, -0.000000, 0.308837, -0.000000, 0.924147}, 
%% {0.846595, -0.000000, -0.186749, -0.000000, 0.956411, -0.000000, 0.268518, -0.000000, 0.940768}, 
%% {0.838737, -0.000000, -0.164399, -0.000000, 0.929406, -0.000000, 0.229153, -0.000000, 0.955084}, 
%% {0.830736, -0.000000, -0.141564, -0.000000, 0.905203, -0.000000, 0.192704, -0.000000, 0.967162}, 
%% {0.822987, -0.000000, -0.118679, -0.000000, 0.884008, -0.000000, 0.158826, -0.000000, 0.977096}, 
%% {0.815589, -0.000000, -0.095379, -0.000000, 0.865842, -0.000000, 0.127328, -0.000000, 0.985110}, 
%% {0.811187, -0.000000, -0.072075, -0.000000, 0.849799, -0.000000, 0.096267, -0.000000, 0.991446}, 
%% {0.809713, -0.000000, -0.048081, -0.000000, 0.834708, -0.000000, 0.063962, -0.000000, 0.996202}, 
%% {0.808940, -0.000000, -0.023576, -0.000000, 0.820367, -0.000000, 0.031488, -0.000000, 0.999082}, 
%% {0.805569, -0.000000, 0.000386, -0.000000, 0.805660, -0.000000, -0.000170, -0.000000, 1.000000}, 
%% {691.520325, -0.000000, -0.321397, -0.000000, 3420.246338, -0.000000, 1899.908447, -0.000000, 0.116981}, 
%% {232.179443, -0.000000, -0.321398, -0.000000, 1984.492065, -0.000000, 637.896790, -0.000000, 0.116981}, 
%% {58.049793, -0.000000, -0.321406, -0.000000, 496.143646, -0.000000, 159.482468, -0.000000, 0.116988}, 
%% {25.760920, -0.000000, -0.321423, -0.000000, 220.449814, -0.000000, 70.768463, -0.000000, 0.117012}, 
%% {14.514050, -0.000000, -0.321385, -0.000000, 123.804192, -0.000000, 39.875038, -0.000000, 0.117047}, 
%% {9.338439, -0.000000, -0.321345, -0.000000, 79.053604, -0.000000, 25.656532, -0.000000, 0.117132}, 
%% {6.453730, -0.000000, -0.321342, -0.000000, 55.134861, -0.000000, 17.727585, -0.000000, 0.117314}, 
%% {4.739985, -0.000000, -0.321295, -0.000000, 40.513348, -0.000000, 13.017878, -0.000000, 0.117597}, 
%% {3.632995, -0.000000, -0.321214, -0.000000, 31.016392, -0.000000, 9.975224, -0.000000, 0.118033}, 
%% {2.877248, -0.000000, -0.321043, -0.000000, 24.533247, -0.000000, 7.896883, -0.000000, 0.118866}, 
%% {2.334257, -0.000000, -0.320872, -0.000000, 19.881872, -0.000000, 6.403059, -0.000000, 0.119822}, 
%% {1.933426, -0.000000, -0.320678, -0.000000, 16.439644, -0.000000, 5.299424, -0.000000, 0.121038}, 
%% {1.630258, -0.000000, -0.320424, -0.000000, 13.827012, -0.000000, 4.463737, -0.000000, 0.122661}, 
%% {1.395344, -0.000000, -0.320148, -0.000000, 11.796659, -0.000000, 3.815114, -0.000000, 0.124661}, 
%% {1.209805, -0.000000, -0.319867, -0.000000, 10.186893, -0.000000, 3.301662, -0.000000, 0.127055}, 
%% {1.061681, -0.000000, -0.319587, -0.000000, 8.889977, -0.000000, 2.890342, -0.000000, 0.129949}, 
%% {0.942101, -0.000000, -0.319369, -0.000000, 7.828002, -0.000000, 2.556567, -0.000000, 0.133332}, 
%% {0.845392, -0.000000, -0.319211, -0.000000, 6.950410, -0.000000, 2.284664, -0.000000, 0.137335}, 
%% {0.766753, -0.000000, -0.319237, -0.000000, 6.210790, -0.000000, 2.060951, -0.000000, 0.141924}, 
%% {0.703203, -0.000000, -0.319454, -0.000000, 5.584640, -0.000000, 1.877120, -0.000000, 0.147255}, 
%% {0.652475, -0.000000, -0.320006, -0.000000, 5.045791, -0.000000, 1.726181, -0.000000, 0.153395}, 
%% {0.611891, -0.000000, -0.320993, -0.000000, 4.580692, -0.000000, 1.600528, -0.000000, 0.160377}, 
%% {0.580378, -0.000000, -0.322433, -0.000000, 4.174947, -0.000000, 1.496929, -0.000000, 0.168370}, 
%% {0.556073, -0.000000, -0.324478, -0.000000, 3.822892, -0.000000, 1.409622, -0.000000, 0.177463}, 
%% {0.539151, -0.000000, -0.327110, -0.000000, 3.513168, -0.000000, 1.338721, -0.000000, 0.187779}, 
%% {0.526072, -0.000000, -0.330294, -0.000000, 3.242654, -0.000000, 1.275310, -0.000000, 0.199297}, 
%% {0.518252, -0.000000, -0.334125, -0.000000, 3.006590, -0.000000, 1.221811, -0.000000, 0.212280}, 
%% {0.514444, -0.000000, -0.338327, -0.000000, 2.796488, -0.000000, 1.175933, -0.000000, 0.226640}, 
%% {0.515397, -0.000000, -0.343059, -0.000000, 2.609703, -0.000000, 1.137967, -0.000000, 0.242546}, 
%% {0.516556, -0.000000, -0.348039, -0.000000, 2.450304, -0.000000, 1.098426, -0.000000, 0.259917}, 
%% {0.522627, -0.000000, -0.353301, -0.000000, 2.306567, -0.000000, 1.066521, -0.000000, 0.279022}, 
%% {0.531396, -0.000000, -0.358445, -0.000000, 2.174559, -0.000000, 1.038336, -0.000000, 0.299605}, 
%% {0.543487, -0.000000, -0.363545, -0.000000, 2.058213, -0.000000, 1.014090, -0.000000, 0.321662}, 
%% {0.555428, -0.000000, -0.368337, -0.000000, 1.955426, -0.000000, 0.987419, -0.000000, 0.345184}, 
%% {0.569017, -0.000000, -0.372716, -0.000000, 1.863569, -0.000000, 0.961584, -0.000000, 0.370146}, 
%% {0.584590, -0.000000, -0.376446, -0.000000, 1.778989, -0.000000, 0.937406, -0.000000, 0.396358}, 
%% {0.602116, -0.000000, -0.379351, -0.000000, 1.702245, -0.000000, 0.914905, -0.000000, 0.423583}, 
%% {0.620472, -0.000000, -0.381534, -0.000000, 1.633465, -0.000000, 0.891418, -0.000000, 0.451859}, 
%% {0.639474, -0.000000, -0.382820, -0.000000, 1.570274, -0.000000, 0.866969, -0.000000, 0.480990}, 
%% {0.657933, -0.000000, -0.382766, -0.000000, 1.510570, -0.000000, 0.841420, -0.000000, 0.510486}, 
%% {0.677948, -0.000000, -0.381815, -0.000000, 1.459140, -0.000000, 0.815413, -0.000000, 0.540765}, 
%% {0.697775, -0.000000, -0.379415, -0.000000, 1.410970, -0.000000, 0.788722, -0.000000, 0.571133}, 
%% {0.717261, -0.000000, -0.375858, -0.000000, 1.365352, -0.000000, 0.760485, -0.000000, 0.601492}, 
%% {0.735851, -0.000000, -0.370916, -0.000000, 1.322475, -0.000000, 0.730757, -0.000000, 0.631652}, 
%% {0.754152, -0.000000, -0.364570, -0.000000, 1.282969, -0.000000, 0.700310, -0.000000, 0.661458}, 
%% {0.770774, -0.000000, -0.356703, -0.000000, 1.246909, -0.000000, 0.667520, -0.000000, 0.691081}, 
%% {0.788028, -0.000000, -0.347476, -0.000000, 1.212955, -0.000000, 0.633806, -0.000000, 0.720528}, 
%% {0.802641, -0.000000, -0.336410, -0.000000, 1.180188, -0.000000, 0.598133, -0.000000, 0.749305}, 
%% {0.815066, -0.000000, -0.322848, -0.000000, 1.148509, -0.000000, 0.558998, -0.000000, 0.778581}, 
%% {0.826353, -0.000000, -0.307191, -0.000000, 1.119650, -0.000000, 0.518911, -0.000000, 0.807099}, 
%% {0.836021, -0.000000, -0.290001, -0.000000, 1.091215, -0.000000, 0.478311, -0.000000, 0.834083}, 
%% {0.841919, -0.000000, -0.271427, -0.000000, 1.063009, -0.000000, 0.436064, -0.000000, 0.859417}, 
%% {0.845622, -0.000000, -0.251626, -0.000000, 1.035985, -0.000000, 0.394219, -0.000000, 0.882695}, 
%% {0.847095, -0.000000, -0.230951, -0.000000, 1.008734, -0.000000, 0.351967, -0.000000, 0.904040}, 
%% {0.845168, -0.000000, -0.209317, -0.000000, 0.981464, -0.000000, 0.309993, -0.000000, 0.923226}, 
%% {0.841356, -0.000000, -0.186999, -0.000000, 0.954043, -0.000000, 0.268710, -0.000000, 0.940277}, 
%% {0.833372, -0.000000, -0.164118, -0.000000, 0.926502, -0.000000, 0.229421, -0.000000, 0.954819}, 
%% {0.826024, -0.000000, -0.140901, -0.000000, 0.902002, -0.000000, 0.192717, -0.000000, 0.967127}, 
%% {0.818020, -0.000000, -0.117695, -0.000000, 0.880034, -0.000000, 0.158655, -0.000000, 0.977173}, 
%% {0.810995, -0.000000, -0.094357, -0.000000, 0.861632, -0.000000, 0.127103, -0.000000, 0.985212}, 
%% {0.806238, -0.000000, -0.071137, -0.000000, 0.845011, -0.000000, 0.095929, -0.000000, 0.991536}, 
%% {0.804569, -0.000000, -0.047798, -0.000000, 0.829772, -0.000000, 0.063871, -0.000000, 0.996206}, 
%% {0.803373, -0.000000, -0.024666, -0.000000, 0.815181, -0.000000, 0.032049, -0.000000, 0.999016}, 
%% {0.800176, -0.000000, -0.001216, -0.000000, 0.800031, -0.000000, 0.000608, -0.000000, 0.999999}, 
%% {617.227356, -0.000000, -0.301906, -0.000000, 3184.913086, -0.000000, 1837.054199, -0.000000, 0.101437}, 
%% {200.995544, -0.000000, -0.301907, -0.000000, 1987.327026, -0.000000, 598.220276, -0.000000, 0.101438}, 
%% {50.319653, -0.000000, -0.301914, -0.000000, 496.107422, -0.000000, 149.761185, -0.000000, 0.101444}, 
%% {22.333885, -0.000000, -0.301942, -0.000000, 220.471603, -0.000000, 66.461891, -0.000000, 0.101471}, 
%% {12.586696, -0.000000, -0.301897, -0.000000, 124.056053, -0.000000, 37.460140, -0.000000, 0.101504}, 
%% {8.056556, -0.000000, -0.301887, -0.000000, 79.355690, -0.000000, 23.975834, -0.000000, 0.101604}, 
%% {5.605017, -0.000000, -0.301919, -0.000000, 55.080162, -0.000000, 16.674746, -0.000000, 0.101800}, 
%% {4.112597, -0.000000, -0.301823, -0.000000, 40.509563, -0.000000, 12.235019, -0.000000, 0.102074}, 
%% {3.151222, -0.000000, -0.301755, -0.000000, 31.014111, -0.000000, 9.371964, -0.000000, 0.102558}, 
%% {2.496116, -0.000000, -0.301617, -0.000000, 24.536598, -0.000000, 7.420205, -0.000000, 0.103385}, 
%% {2.025368, -0.000000, -0.301498, -0.000000, 19.883894, -0.000000, 6.016835, -0.000000, 0.104329}, 
%% {1.679118, -0.000000, -0.301327, -0.000000, 16.451010, -0.000000, 4.983676, -0.000000, 0.105650}, 
%% {1.416051, -0.000000, -0.301157, -0.000000, 13.837006, -0.000000, 4.197700, -0.000000, 0.107258}, 
%% {1.212647, -0.000000, -0.300970, -0.000000, 11.806269, -0.000000, 3.588752, -0.000000, 0.109297}, 
%% {1.052668, -0.000000, -0.300798, -0.000000, 10.197992, -0.000000, 3.108404, -0.000000, 0.111780}, 
%% {0.925091, -0.000000, -0.300671, -0.000000, 8.901864, -0.000000, 2.723720, -0.000000, 0.114744}, 
%% {0.822591, -0.000000, -0.300627, -0.000000, 7.840497, -0.000000, 2.412736, -0.000000, 0.118234}, 
%% {0.740399, -0.000000, -0.300718, -0.000000, 6.961002, -0.000000, 2.160842, -0.000000, 0.122360}, 
%% {0.673751, -0.000000, -0.301054, -0.000000, 6.220374, -0.000000, 1.953560, -0.000000, 0.127084}, 
%% {0.620497, -0.000000, -0.301692, -0.000000, 5.592794, -0.000000, 1.784014, -0.000000, 0.132596}, 
%% {0.578947, -0.000000, -0.302746, -0.000000, 5.051692, -0.000000, 1.646622, -0.000000, 0.138940}, 
%% {0.545908, -0.000000, -0.304317, -0.000000, 4.585639, -0.000000, 1.531627, -0.000000, 0.146192}, 
%% {0.520994, -0.000000, -0.306483, -0.000000, 4.179955, -0.000000, 1.437276, -0.000000, 0.154499}, 
%% {0.503134, -0.000000, -0.309345, -0.000000, 3.827225, -0.000000, 1.359808, -0.000000, 0.163940}, 
%% {0.491265, -0.000000, -0.312818, -0.000000, 3.517801, -0.000000, 1.296196, -0.000000, 0.174634}, 
%% {0.482161, -0.000000, -0.316891, -0.000000, 3.248208, -0.000000, 1.237636, -0.000000, 0.186589}, 
%% {0.477370, -0.000000, -0.321553, -0.000000, 3.013987, -0.000000, 1.187739, -0.000000, 0.199948}, 
%% {0.477121, -0.000000, -0.326812, -0.000000, 2.807611, -0.000000, 1.146264, -0.000000, 0.214848}, 
%% {0.480774, -0.000000, -0.332499, -0.000000, 2.622992, -0.000000, 1.111460, -0.000000, 0.231324}, 
%% {0.486862, -0.000000, -0.338534, -0.000000, 2.461427, -0.000000, 1.079535, -0.000000, 0.249360}, 
%% {0.494894, -0.000000, -0.344629, -0.000000, 2.316846, -0.000000, 1.049811, -0.000000, 0.268944}, 
%% {0.505190, -0.000000, -0.350696, -0.000000, 2.189857, -0.000000, 1.022585, -0.000000, 0.290135}, 
%% {0.517250, -0.000000, -0.356467, -0.000000, 2.073406, -0.000000, 0.997122, -0.000000, 0.312826}, 
%% {0.532126, -0.000000, -0.362154, -0.000000, 1.970731, -0.000000, 0.974033, -0.000000, 0.337093}, 
%% {0.548971, -0.000000, -0.367310, -0.000000, 1.876597, -0.000000, 0.952429, -0.000000, 0.362742}, 
%% {0.565951, -0.000000, -0.371645, -0.000000, 1.792993, -0.000000, 0.929471, -0.000000, 0.389641}, 
%% {0.583915, -0.000000, -0.375352, -0.000000, 1.717723, -0.000000, 0.905503, -0.000000, 0.417925}, 
%% {0.603604, -0.000000, -0.377949, -0.000000, 1.648183, -0.000000, 0.883281, -0.000000, 0.446930}, 
%% {0.624048, -0.000000, -0.379607, -0.000000, 1.583560, -0.000000, 0.860032, -0.000000, 0.476844}, 
%% {0.644327, -0.000000, -0.379843, -0.000000, 1.523399, -0.000000, 0.836099, -0.000000, 0.507104}, 
%% {0.666115, -0.000000, -0.379190, -0.000000, 1.470761, -0.000000, 0.811215, -0.000000, 0.538211}, 
%% {0.685290, -0.000000, -0.376947, -0.000000, 1.423105, -0.000000, 0.783113, -0.000000, 0.569245}, 
%% {0.705893, -0.000000, -0.373285, -0.000000, 1.375140, -0.000000, 0.755840, -0.000000, 0.600303}, 
%% {0.725828, -0.000000, -0.368342, -0.000000, 1.331664, -0.000000, 0.726758, -0.000000, 0.631186}, 
%% {0.744685, -0.000000, -0.362014, -0.000000, 1.291937, -0.000000, 0.696270, -0.000000, 0.661521}, 
%% {0.761897, -0.000000, -0.354214, -0.000000, 1.254063, -0.000000, 0.663767, -0.000000, 0.691408}, 
%% {0.779349, -0.000000, -0.345050, -0.000000, 1.218551, -0.000000, 0.630696, -0.000000, 0.720765}, 
%% {0.794561, -0.000000, -0.334333, -0.000000, 1.184900, -0.000000, 0.595950, -0.000000, 0.749238}, 
%% {0.807830, -0.000000, -0.322197, -0.000000, 1.153637, -0.000000, 0.558788, -0.000000, 0.777132}, 
%% {0.819650, -0.000000, -0.308161, -0.000000, 1.122648, -0.000000, 0.521026, -0.000000, 0.804112}, 
%% {0.829351, -0.000000, -0.291491, -0.000000, 1.093572, -0.000000, 0.479936, -0.000000, 0.831317}, 
%% {0.835687, -0.000000, -0.272936, -0.000000, 1.064354, -0.000000, 0.438254, -0.000000, 0.856865}, 
%% {0.839920, -0.000000, -0.253148, -0.000000, 1.036942, -0.000000, 0.395941, -0.000000, 0.880665}, 
%% {0.841695, -0.000000, -0.232169, -0.000000, 1.008648, -0.000000, 0.353470, -0.000000, 0.902501}, 
%% {0.840678, -0.000000, -0.210338, -0.000000, 0.980560, -0.000000, 0.311668, -0.000000, 0.922021}, 
%% {0.836641, -0.000000, -0.187804, -0.000000, 0.952927, -0.000000, 0.270121, -0.000000, 0.939365}, 
%% {0.829170, -0.000000, -0.164667, -0.000000, 0.923956, -0.000000, 0.230280, -0.000000, 0.954268}, 
%% {0.821230, -0.000000, -0.141092, -0.000000, 0.898044, -0.000000, 0.192948, -0.000000, 0.966850}, 
%% {0.813037, -0.000000, -0.117314, -0.000000, 0.876016, -0.000000, 0.158848, -0.000000, 0.977080}, 
%% {0.805886, -0.000000, -0.093441, -0.000000, 0.856889, -0.000000, 0.126778, -0.000000, 0.985300}, 
%% {0.801481, -0.000000, -0.069841, -0.000000, 0.840246, -0.000000, 0.095250, -0.000000, 0.991700}, 
%% {0.799517, -0.000000, -0.046447, -0.000000, 0.824482, -0.000000, 0.063327, -0.000000, 0.996321}, 
%% {0.797627, -0.000000, -0.023286, -0.000000, 0.809348, -0.000000, 0.031407, -0.000000, 0.999083}, 
%% {0.794243, -0.000000, -0.000332, -0.000000, 0.794149, -0.000000, 0.000244, -0.000000, 1.000000}, 
%% {546.398743, -0.000000, -0.281664, -0.000000, 2947.597900, -0.000000, 1771.350830, -0.000000, 0.086883}, 
%% {172.121582, -0.000000, -0.281665, -0.000000, 1986.506592, -0.000000, 557.991943, -0.000000, 0.086884}, 
%% {43.106506, -0.000000, -0.281674, -0.000000, 496.099152, -0.000000, 139.739166, -0.000000, 0.086891}, 
%% {19.156675, -0.000000, -0.281711, -0.000000, 220.567261, -0.000000, 62.090546, -0.000000, 0.086921}, 
%% {10.777329, -0.000000, -0.281657, -0.000000, 124.048401, -0.000000, 34.936787, -0.000000, 0.086954}, 
%% {6.924936, -0.000000, -0.281681, -0.000000, 79.148308, -0.000000, 22.443922, -0.000000, 0.087065}, 
%% {4.790178, -0.000000, -0.281636, -0.000000, 55.139343, -0.000000, 15.524605, -0.000000, 0.087240}, 
%% {3.523330, -0.000000, -0.281605, -0.000000, 40.508759, -0.000000, 11.416297, -0.000000, 0.087543}, 
%% {2.702876, -0.000000, -0.281531, -0.000000, 31.041807, -0.000000, 8.754599, -0.000000, 0.088122}, 
%% {2.139489, -0.000000, -0.281455, -0.000000, 24.541700, -0.000000, 6.925914, -0.000000, 0.088880}, 
%% {1.736752, -0.000000, -0.281374, -0.000000, 19.891438, -0.000000, 5.617758, -0.000000, 0.089856}, 
%% {1.440450, -0.000000, -0.281262, -0.000000, 16.460304, -0.000000, 4.654313, -0.000000, 0.091198}, 
%% {1.216053, -0.000000, -0.281158, -0.000000, 13.849089, -0.000000, 3.923425, -0.000000, 0.092883}, 
%% {1.042272, -0.000000, -0.281077, -0.000000, 11.819723, -0.000000, 3.356057, -0.000000, 0.094947}, 
%% {0.906049, -0.000000, -0.281029, -0.000000, 10.211316, -0.000000, 2.909728, -0.000000, 0.097491}, 
%% {0.797531, -0.000000, -0.281078, -0.000000, 8.915293, -0.000000, 2.552234, -0.000000, 0.100503}, 
%% {0.711050, -0.000000, -0.281257, -0.000000, 7.854657, -0.000000, 2.264928, -0.000000, 0.104105}, 
%% {0.642120, -0.000000, -0.281651, -0.000000, 6.972515, -0.000000, 2.032932, -0.000000, 0.108302}, 
%% {0.587422, -0.000000, -0.282350, -0.000000, 6.230418, -0.000000, 1.844936, -0.000000, 0.113214}, 
%% {0.544091, -0.000000, -0.283465, -0.000000, 5.597650, -0.000000, 1.691247, -0.000000, 0.118882}, 
%% {0.510479, -0.000000, -0.285093, -0.000000, 5.057550, -0.000000, 1.565937, -0.000000, 0.125451}, 
%% {0.485369, -0.000000, -0.287382, -0.000000, 4.588317, -0.000000, 1.464325, -0.000000, 0.132988}, 
%% {0.466498, -0.000000, -0.290356, -0.000000, 4.182677, -0.000000, 1.379174, -0.000000, 0.141580}, 
%% {0.453690, -0.000000, -0.294129, -0.000000, 3.830859, -0.000000, 1.308949, -0.000000, 0.151404}, 
%% {0.446407, -0.000000, -0.298486, -0.000000, 3.523997, -0.000000, 1.252602, -0.000000, 0.162460}, 
%% {0.441351, -0.000000, -0.303538, -0.000000, 3.259694, -0.000000, 1.199741, -0.000000, 0.174881}, 
%% {0.441980, -0.000000, -0.309343, -0.000000, 3.022479, -0.000000, 1.159023, -0.000000, 0.188797}, 
%% {0.443619, -0.000000, -0.315506, -0.000000, 2.819805, -0.000000, 1.119020, -0.000000, 0.204143}, 
%% {0.448820, -0.000000, -0.322134, -0.000000, 2.638306, -0.000000, 1.085241, -0.000000, 0.221086}, 
%% {0.456991, -0.000000, -0.329014, -0.000000, 2.478395, -0.000000, 1.056080, -0.000000, 0.239669}, 
%% {0.467411, -0.000000, -0.336128, -0.000000, 2.336080, -0.000000, 1.029185, -0.000000, 0.259885}, 
%% {0.479864, -0.000000, -0.343140, -0.000000, 2.207581, -0.000000, 1.004513, -0.000000, 0.281695}, 
%% {0.494392, -0.000000, -0.349819, -0.000000, 2.094188, -0.000000, 0.982152, -0.000000, 0.305055}, 
%% {0.511865, -0.000000, -0.356146, -0.000000, 1.986912, -0.000000, 0.962960, -0.000000, 0.329991}, 
%% {0.528287, -0.000000, -0.362042, -0.000000, 1.897054, -0.000000, 0.939250, -0.000000, 0.356320}, 
%% {0.548272, -0.000000, -0.367133, -0.000000, 1.811016, -0.000000, 0.920002, -0.000000, 0.383949}, 
%% {0.567175, -0.000000, -0.371346, -0.000000, 1.734292, -0.000000, 0.896796, -0.000000, 0.412842}, 
%% {0.589098, -0.000000, -0.374506, -0.000000, 1.665171, -0.000000, 0.876443, -0.000000, 0.442822}, 
%% {0.609636, -0.000000, -0.376355, -0.000000, 1.598576, -0.000000, 0.853264, -0.000000, 0.473243}, 
%% {0.631163, -0.000000, -0.377235, -0.000000, 1.540836, -0.000000, 0.828840, -0.000000, 0.504617}, 
%% {0.652347, -0.000000, -0.376463, -0.000000, 1.485365, -0.000000, 0.803898, -0.000000, 0.536078}, 
%% {0.674503, -0.000000, -0.374461, -0.000000, 1.433821, -0.000000, 0.778319, -0.000000, 0.567905}, 
%% {0.695899, -0.000000, -0.370903, -0.000000, 1.385700, -0.000000, 0.751291, -0.000000, 0.599574}, 
%% {0.715855, -0.000000, -0.365754, -0.000000, 1.341530, -0.000000, 0.722213, -0.000000, 0.630997}, 
%% {0.735638, -0.000000, -0.359227, -0.000000, 1.299732, -0.000000, 0.692089, -0.000000, 0.662038}, 
%% {0.753374, -0.000000, -0.351377, -0.000000, 1.260723, -0.000000, 0.659694, -0.000000, 0.692316}, 
%% {0.771098, -0.000000, -0.342076, -0.000000, 1.223720, -0.000000, 0.627003, -0.000000, 0.721847}, 
%% {0.786230, -0.000000, -0.331421, -0.000000, 1.190004, -0.000000, 0.591435, -0.000000, 0.750691}, 
%% {0.800286, -0.000000, -0.319232, -0.000000, 1.157044, -0.000000, 0.555967, -0.000000, 0.778226}, 
%% {0.812666, -0.000000, -0.305808, -0.000000, 1.125040, -0.000000, 0.519107, -0.000000, 0.804659}, 
%% {0.822609, -0.000000, -0.290894, -0.000000, 1.095662, -0.000000, 0.480261, -0.000000, 0.830169}, 
%% {0.829820, -0.000000, -0.274367, -0.000000, 1.065886, -0.000000, 0.440200, -0.000000, 0.854455}, 
%% {0.834391, -0.000000, -0.255071, -0.000000, 1.037674, -0.000000, 0.398161, -0.000000, 0.878283}, 
%% {0.836410, -0.000000, -0.234126, -0.000000, 1.007871, -0.000000, 0.355766, -0.000000, 0.900415}, 
%% {0.835439, -0.000000, -0.212161, -0.000000, 0.978926, -0.000000, 0.313428, -0.000000, 0.920405}, 
%% {0.832196, -0.000000, -0.189359, -0.000000, 0.950800, -0.000000, 0.272019, -0.000000, 0.938105}, 
%% {0.824446, -0.000000, -0.165932, -0.000000, 0.920756, -0.000000, 0.231597, -0.000000, 0.953388}, 
%% {0.816778, -0.000000, -0.142073, -0.000000, 0.894609, -0.000000, 0.193941, -0.000000, 0.966265}, 
%% {0.808318, -0.000000, -0.117901, -0.000000, 0.871606, -0.000000, 0.158991, -0.000000, 0.976810}, 
%% {0.800682, -0.000000, -0.093600, -0.000000, 0.852259, -0.000000, 0.126835, -0.000000, 0.985173}, 
%% {0.794235, -0.000000, -0.069501, -0.000000, 0.834347, -0.000000, 0.094898, -0.000000, 0.991696}, 
%% {0.792490, -0.000000, -0.045452, -0.000000, 0.818480, -0.000000, 0.062680, -0.000000, 0.996405}, 
%% {0.791041, -0.000000, -0.021979, -0.000000, 0.803009, -0.000000, 0.030758, -0.000000, 0.999145}, 
%% {0.787482, -0.000000, 0.001048, -0.000000, 0.787431, -0.000000, -0.000438, -0.000000, 0.999999}, 
%% {475.030273, -0.000000, -0.260722, -0.000000, 2708.458008, -0.000000, 1688.322144, -0.000000, 0.073357}, 
%% {145.070770, -0.000000, -0.260723, -0.000000, 1987.124634, -0.000000, 515.600830, -0.000000, 0.073358}, 
%% {36.434685, -0.000000, -0.260735, -0.000000, 496.131622, -0.000000, 129.486572, -0.000000, 0.073365}, 
%% {16.152534, -0.000000, -0.260787, -0.000000, 220.588440, -0.000000, 57.391506, -0.000000, 0.073398}, 
%% {9.099452, -0.000000, -0.260720, -0.000000, 124.005196, -0.000000, 32.338490, -0.000000, 0.073430}, 
%% {5.842721, -0.000000, -0.260685, -0.000000, 79.499329, -0.000000, 20.765028, -0.000000, 0.073526}, 
%% {4.058788, -0.000000, -0.260932, -0.000000, 55.124737, -0.000000, 14.407223, -0.000000, 0.073788}, 
%% {2.974960, -0.000000, -0.260687, -0.000000, 40.485615, -0.000000, 10.567076, -0.000000, 0.074037}, 
%% {2.283594, -0.000000, -0.260637, -0.000000, 31.054794, -0.000000, 8.107539, -0.000000, 0.074651}, 
%% {1.807792, -0.000000, -0.260600, -0.000000, 24.549297, -0.000000, 6.414013, -0.000000, 0.075394}, 
%% {1.468746, -0.000000, -0.260555, -0.000000, 19.905684, -0.000000, 5.206177, -0.000000, 0.076427}, 
%% {1.218480, -0.000000, -0.260527, -0.000000, 16.468582, -0.000000, 4.313346, -0.000000, 0.077751}, 
%% {1.029742, -0.000000, -0.260502, -0.000000, 13.860728, -0.000000, 3.638797, -0.000000, 0.079466}, 
%% {0.883645, -0.000000, -0.260545, -0.000000, 11.835199, -0.000000, 3.114829, -0.000000, 0.081586}, 
%% {0.769573, -0.000000, -0.260645, -0.000000, 10.229486, -0.000000, 2.704015, -0.000000, 0.084184}, 
%% {0.679378, -0.000000, -0.260893, -0.000000, 8.931966, -0.000000, 2.376792, -0.000000, 0.087270}, 
%% {0.607828, -0.000000, -0.261342, -0.000000, 7.868796, -0.000000, 2.114224, -0.000000, 0.090968}, 
%% {0.551751, -0.000000, -0.262095, -0.000000, 6.984596, -0.000000, 1.904568, -0.000000, 0.095284}, 
%% {0.507597, -0.000000, -0.263247, -0.000000, 6.238138, -0.000000, 1.734764, -0.000000, 0.100327}, 
%% {0.473795, -0.000000, -0.264992, -0.000000, 5.604198, -0.000000, 1.598068, -0.000000, 0.106204}, 
%% {0.448515, -0.000000, -0.267365, -0.000000, 5.061581, -0.000000, 1.487930, -0.000000, 0.113030}, 
%% {0.429719, -0.000000, -0.270419, -0.000000, 4.591521, -0.000000, 1.397090, -0.000000, 0.120822}, 
%% {0.416674, -0.000000, -0.274329, -0.000000, 4.188806, -0.000000, 1.321783, -0.000000, 0.129766}, 
%% {0.408211, -0.000000, -0.278994, -0.000000, 3.839346, -0.000000, 1.258443, -0.000000, 0.139911}, 
%% {0.405298, -0.000000, -0.284387, -0.000000, 3.532611, -0.000000, 1.209399, -0.000000, 0.151396}, 
%% {0.403724, -0.000000, -0.290546, -0.000000, 3.273569, -0.000000, 1.161210, -0.000000, 0.164319}, 
%% {0.407250, -0.000000, -0.297245, -0.000000, 3.038595, -0.000000, 1.125347, -0.000000, 0.178630}, 
%% {0.412174, -0.000000, -0.304471, -0.000000, 2.835836, -0.000000, 1.090444, -0.000000, 0.194494}, 
%% {0.420013, -0.000000, -0.312127, -0.000000, 2.656288, -0.000000, 1.060398, -0.000000, 0.211980}, 
%% {0.430299, -0.000000, -0.320003, -0.000000, 2.499307, -0.000000, 1.033889, -0.000000, 0.231121}, 
%% {0.442406, -0.000000, -0.327902, -0.000000, 2.359043, -0.000000, 1.009320, -0.000000, 0.251911}, 
%% {0.458485, -0.000000, -0.335770, -0.000000, 2.227042, -0.000000, 0.990969, -0.000000, 0.274267}, 
%% {0.473686, -0.000000, -0.343343, -0.000000, 2.115268, -0.000000, 0.968154, -0.000000, 0.298252}, 
%% {0.491096, -0.000000, -0.350365, -0.000000, 2.010383, -0.000000, 0.947879, -0.000000, 0.323750}, 
%% {0.511182, -0.000000, -0.357081, -0.000000, 1.918258, -0.000000, 0.929152, -0.000000, 0.350951}, 
%% {0.529736, -0.000000, -0.362589, -0.000000, 1.831612, -0.000000, 0.907209, -0.000000, 0.379042}, 
%% {0.552323, -0.000000, -0.367285, -0.000000, 1.751537, -0.000000, 0.889619, -0.000000, 0.408418}, 
%% {0.574003, -0.000000, -0.370991, -0.000000, 1.681642, -0.000000, 0.867910, -0.000000, 0.439050}, 
%% {0.595886, -0.000000, -0.373259, -0.000000, 1.615281, -0.000000, 0.845582, -0.000000, 0.470333}, 
%% {0.620115, -0.000000, -0.374239, -0.000000, 1.554095, -0.000000, 0.824825, -0.000000, 0.502220}, 
%% {0.641174, -0.000000, -0.373762, -0.000000, 1.497839, -0.000000, 0.798812, -0.000000, 0.534345}, 
%% {0.663497, -0.000000, -0.371836, -0.000000, 1.445409, -0.000000, 0.773002, -0.000000, 0.566795}, 
%% {0.685962, -0.000000, -0.368564, -0.000000, 1.399424, -0.000000, 0.745389, -0.000000, 0.599507}, 
%% {0.706502, -0.000000, -0.363328, -0.000000, 1.350809, -0.000000, 0.717119, -0.000000, 0.631212}, 
%% {0.727063, -0.000000, -0.356739, -0.000000, 1.308597, -0.000000, 0.687030, -0.000000, 0.662904}, 
%% {0.745270, -0.000000, -0.348489, -0.000000, 1.269335, -0.000000, 0.654901, -0.000000, 0.693768}, 
%% {0.763282, -0.000000, -0.338930, -0.000000, 1.230482, -0.000000, 0.622346, -0.000000, 0.723651}, 
%% {0.779020, -0.000000, -0.328088, -0.000000, 1.195363, -0.000000, 0.587290, -0.000000, 0.752660}, 
%% {0.792925, -0.000000, -0.315773, -0.000000, 1.159570, -0.000000, 0.551506, -0.000000, 0.780370}, 
%% {0.805209, -0.000000, -0.302177, -0.000000, 1.127932, -0.000000, 0.514372, -0.000000, 0.806967}, 
%% {0.815978, -0.000000, -0.287354, -0.000000, 1.096815, -0.000000, 0.476979, -0.000000, 0.832028}, 
%% {0.823158, -0.000000, -0.271355, -0.000000, 1.066177, -0.000000, 0.437640, -0.000000, 0.855731}, 
%% {0.828214, -0.000000, -0.254100, -0.000000, 1.036329, -0.000000, 0.397981, -0.000000, 0.877898}, 
%% {0.831273, -0.000000, -0.235537, -0.000000, 1.007090, -0.000000, 0.357507, -0.000000, 0.898702}, 
%% {0.830517, -0.000000, -0.214745, -0.000000, 0.977020, -0.000000, 0.315826, -0.000000, 0.918337}, 
%% {0.826489, -0.000000, -0.191866, -0.000000, 0.945932, -0.000000, 0.273631, -0.000000, 0.936478}, 
%% {0.819547, -0.000000, -0.168208, -0.000000, 0.916302, -0.000000, 0.232784, -0.000000, 0.952222}, 
%% {0.809648, -0.000000, -0.144062, -0.000000, 0.888638, -0.000000, 0.194281, -0.000000, 0.965431}, 
%% {0.799512, -0.000000, -0.119553, -0.000000, 0.865089, -0.000000, 0.158904, -0.000000, 0.976239}, 
%% {0.791539, -0.000000, -0.095021, -0.000000, 0.845073, -0.000000, 0.126736, -0.000000, 0.984786}, 
%% {0.787211, -0.000000, -0.070488, -0.000000, 0.827851, -0.000000, 0.095332, -0.000000, 0.991464}, 
%% {0.785666, -0.000000, -0.046034, -0.000000, 0.811825, -0.000000, 0.062773, -0.000000, 0.996322}, 
%% {0.784053, -0.000000, -0.021962, -0.000000, 0.796114, -0.000000, 0.030608, -0.000000, 0.999143}, 
%% {0.780279, -0.000000, 0.001818, -0.000000, 0.780346, -0.000000, -0.000982, -0.000000, 0.999998}, 
%% {407.721893, -0.000000, -0.239133, -0.000000, 2467.635254, -0.000000, 1601.182251, -0.000000, 0.060892}, 
%% {120.042587, -0.000000, -0.239132, -0.000000, 1988.596313, -0.000000, 471.425171, -0.000000, 0.060892}, 
%% {30.234524, -0.000000, -0.239150, -0.000000, 495.932434, -0.000000, 118.725571, -0.000000, 0.060901}, 
%% {13.392463, -0.000000, -0.239134, -0.000000, 221.561417, -0.000000, 52.592564, -0.000000, 0.060916}, 
%% {7.562334, -0.000000, -0.239210, -0.000000, 123.834846, -0.000000, 29.685841, -0.000000, 0.060986}, 
%% {4.903214, -0.000000, -0.239025, -0.000000, 78.098007, -0.000000, 19.261158, -0.000000, 0.061046}, 
%% {3.404422, -0.000000, -0.239574, -0.000000, 54.720295, -0.000000, 13.338058, -0.000000, 0.061381}, 
%% {2.467712, -0.000000, -0.239113, -0.000000, 40.616497, -0.000000, 9.684508, -0.000000, 0.061605}, 
%% {1.896621, -0.000000, -0.239113, -0.000000, 31.062563, -0.000000, 7.438349, -0.000000, 0.062223}, 
%% {1.501909, -0.000000, -0.239111, -0.000000, 24.558338, -0.000000, 5.885772, -0.000000, 0.062956}, 
%% {1.221456, -0.000000, -0.239115, -0.000000, 19.918470, -0.000000, 4.781195, -0.000000, 0.064024}, 
%% {1.014306, -0.000000, -0.239157, -0.000000, 16.488132, -0.000000, 3.963861, -0.000000, 0.065387}, 
%% {0.858086, -0.000000, -0.239245, -0.000000, 13.880658, -0.000000, 3.345896, -0.000000, 0.067124}, 
%% {0.737891, -0.000000, -0.239414, -0.000000, 11.855424, -0.000000, 2.868518, -0.000000, 0.069288}, 
%% {0.644067, -0.000000, -0.239705, -0.000000, 10.249611, -0.000000, 2.493684, -0.000000, 0.071915}, 
%% {0.571152, -0.000000, -0.240187, -0.000000, 8.949483, -0.000000, 2.199379, -0.000000, 0.075094}, 
%% {0.513475, -0.000000, -0.240989, -0.000000, 7.884631, -0.000000, 1.962679, -0.000000, 0.078856}, 
%% {0.469316, -0.000000, -0.242181, -0.000000, 6.997030, -0.000000, 1.776440, -0.000000, 0.083306}, 
%% {0.435149, -0.000000, -0.243938, -0.000000, 6.245539, -0.000000, 1.625977, -0.000000, 0.088502}, 
%% {0.410201, -0.000000, -0.246370, -0.000000, 5.605827, -0.000000, 1.507509, -0.000000, 0.094580}, 
%% {0.392198, -0.000000, -0.249554, -0.000000, 5.059460, -0.000000, 1.411837, -0.000000, 0.101653}, 
%% {0.379447, -0.000000, -0.253589, -0.000000, 4.595575, -0.000000, 1.332068, -0.000000, 0.109763}, 
%% {0.371363, -0.000000, -0.258463, -0.000000, 4.193475, -0.000000, 1.265804, -0.000000, 0.119018}, 
%% {0.366917, -0.000000, -0.264125, -0.000000, 3.850239, -0.000000, 1.209238, -0.000000, 0.129533}, 
%% {0.367212, -0.000000, -0.270662, -0.000000, 3.547985, -0.000000, 1.164796, -0.000000, 0.141460}, 
%% {0.369222, -0.000000, -0.277809, -0.000000, 3.289741, -0.000000, 1.123330, -0.000000, 0.154785}, 
%% {0.375245, -0.000000, -0.285629, -0.000000, 3.060160, -0.000000, 1.090878, -0.000000, 0.169647}, 
%% {0.383571, -0.000000, -0.293879, -0.000000, 2.857840, -0.000000, 1.062437, -0.000000, 0.185997}, 
%% {0.393515, -0.000000, -0.302454, -0.000000, 2.680567, -0.000000, 1.035705, -0.000000, 0.203961}, 
%% {0.406700, -0.000000, -0.311403, -0.000000, 2.523688, -0.000000, 1.013850, -0.000000, 0.223712}, 
%% {0.420529, -0.000000, -0.320106, -0.000000, 2.381546, -0.000000, 0.991879, -0.000000, 0.244985}, 
%% {0.436011, -0.000000, -0.328680, -0.000000, 2.252149, -0.000000, 0.971160, -0.000000, 0.267907}, 
%% {0.453979, -0.000000, -0.337243, -0.000000, 2.139400, -0.000000, 0.952242, -0.000000, 0.292618}, 
%% {0.473047, -0.000000, -0.344990, -0.000000, 2.036989, -0.000000, 0.934230, -0.000000, 0.318672}, 
%% {0.492429, -0.000000, -0.352007, -0.000000, 1.941819, -0.000000, 0.914742, -0.000000, 0.346107}, 
%% {0.514338, -0.000000, -0.358377, -0.000000, 1.856468, -0.000000, 0.896801, -0.000000, 0.375133}, 
%% {0.536600, -0.000000, -0.363489, -0.000000, 1.775282, -0.000000, 0.878203, -0.000000, 0.405111}, 
%% {0.559492, -0.000000, -0.367596, -0.000000, 1.702983, -0.000000, 0.858172, -0.000000, 0.436166}, 
%% {0.584569, -0.000000, -0.370232, -0.000000, 1.633047, -0.000000, 0.840080, -0.000000, 0.467942}, 
%% {0.606665, -0.000000, -0.371564, -0.000000, 1.571447, -0.000000, 0.815522, -0.000000, 0.500517}, 
%% {0.629451, -0.000000, -0.371302, -0.000000, 1.514761, -0.000000, 0.790866, -0.000000, 0.533482}, 
%% {0.653989, -0.000000, -0.369406, -0.000000, 1.459702, -0.000000, 0.767742, -0.000000, 0.566341}, 
%% {0.676183, -0.000000, -0.366056, -0.000000, 1.408865, -0.000000, 0.740233, -0.000000, 0.599270}, 
%% {0.697429, -0.000000, -0.360817, -0.000000, 1.360634, -0.000000, 0.712149, -0.000000, 0.631568}, 
%% {0.718010, -0.000000, -0.354209, -0.000000, 1.318251, -0.000000, 0.681349, -0.000000, 0.663877}, 
%% {0.736971, -0.000000, -0.345910, -0.000000, 1.276006, -0.000000, 0.649316, -0.000000, 0.695233}, 
%% {0.755556, -0.000000, -0.336029, -0.000000, 1.235966, -0.000000, 0.616895, -0.000000, 0.725639}, 
%% {0.772082, -0.000000, -0.324655, -0.000000, 1.199029, -0.000000, 0.582616, -0.000000, 0.755014}, 
%% {0.785818, -0.000000, -0.312088, -0.000000, 1.164264, -0.000000, 0.546078, -0.000000, 0.783125}, 
%% {0.798436, -0.000000, -0.298203, -0.000000, 1.129044, -0.000000, 0.509758, -0.000000, 0.809614}, 
%% {0.808924, -0.000000, -0.283111, -0.000000, 1.096925, -0.000000, 0.472440, -0.000000, 0.834653}, 
%% {0.816178, -0.000000, -0.266940, -0.000000, 1.065145, -0.000000, 0.432582, -0.000000, 0.858519}, 
%% {0.821345, -0.000000, -0.249799, -0.000000, 1.033939, -0.000000, 0.393785, -0.000000, 0.880237}, 
%% {0.823821, -0.000000, -0.231463, -0.000000, 1.002835, -0.000000, 0.354047, -0.000000, 0.900526}, 
%% {0.823019, -0.000000, -0.212439, -0.000000, 0.972861, -0.000000, 0.313611, -0.000000, 0.919050}, 
%% {0.818092, -0.000000, -0.192551, -0.000000, 0.940838, -0.000000, 0.272748, -0.000000, 0.935805}, 
%% {0.809062, -0.000000, -0.171214, -0.000000, 0.910254, -0.000000, 0.232587, -0.000000, 0.950780}, 
%% {0.800989, -0.000000, -0.147431, -0.000000, 0.882961, -0.000000, 0.194881, -0.000000, 0.964130}, 
%% {0.792567, -0.000000, -0.122701, -0.000000, 0.859085, -0.000000, 0.159960, -0.000000, 0.975236}, 
%% {0.785337, -0.000000, -0.097785, -0.000000, 0.838731, -0.000000, 0.127437, -0.000000, 0.984132}, 
%% {0.780296, -0.000000, -0.072867, -0.000000, 0.820897, -0.000000, 0.095863, -0.000000, 0.991048}, 
%% {0.778441, -0.000000, -0.048084, -0.000000, 0.804663, -0.000000, 0.063552, -0.000000, 0.996074}, 
%% {0.776580, -0.000000, -0.023544, -0.000000, 0.788681, -0.000000, 0.031383, -0.000000, 0.999049}, 
%% {0.772513, -0.000000, 0.000745, -0.000000, 0.772672, -0.000000, -0.000351, -0.000000, 1.000000}, 
%% {344.092712, -0.000000, -0.216948, -0.000000, 2225.277344, -0.000000, 1507.520508, -0.000000, 0.049518}, 
%% {98.257721, -0.000000, -0.216948, -0.000000, 1985.383423, -0.000000, 430.481934, -0.000000, 0.049518}, 
%% {24.560455, -0.000000, -0.216969, -0.000000, 496.241821, -0.000000, 107.591675, -0.000000, 0.049528}, 
%% {10.922836, -0.000000, -0.216971, -0.000000, 220.460281, -0.000000, 47.848038, -0.000000, 0.049547}, 
%% {6.066390, -0.000000, -0.216927, -0.000000, 124.743614, -0.000000, 26.578356, -0.000000, 0.049589}, 
%% {3.940259, -0.000000, -0.216850, -0.000000, 79.242592, -0.000000, 17.267754, -0.000000, 0.049679}, 
%% {2.741782, -0.000000, -0.216928, -0.000000, 55.125290, -0.000000, 12.008499, -0.000000, 0.049895}, 
%% {2.007827, -0.000000, -0.216979, -0.000000, 40.589417, -0.000000, 8.788004, -0.000000, 0.050310}, 
%% {1.542971, -0.000000, -0.216989, -0.000000, 31.096390, -0.000000, 6.749176, -0.000000, 0.050860}, 
%% {1.223782, -0.000000, -0.217037, -0.000000, 24.578289, -0.000000, 5.347384, -0.000000, 0.051643}, 
%% {0.995484, -0.000000, -0.217110, -0.000000, 19.936281, -0.000000, 4.343584, -0.000000, 0.052689}, 
%% {0.827851, -0.000000, -0.217234, -0.000000, 16.507404, -0.000000, 3.604783, -0.000000, 0.054081}, 
%% {0.701802, -0.000000, -0.217442, -0.000000, 13.900422, -0.000000, 3.047313, -0.000000, 0.055841}, 
%% {0.604788, -0.000000, -0.217768, -0.000000, 11.879177, -0.000000, 2.616030, -0.000000, 0.058036}, 
%% {0.530155, -0.000000, -0.218289, -0.000000, 10.269553, -0.000000, 2.281230, -0.000000, 0.060711}, 
%% {0.472504, -0.000000, -0.219113, -0.000000, 8.970000, -0.000000, 2.018534, -0.000000, 0.063953}, 
%% {0.428478, -0.000000, -0.220328, -0.000000, 7.898524, -0.000000, 1.812827, -0.000000, 0.067825}, 
%% {0.394861, -0.000000, -0.222114, -0.000000, 7.002269, -0.000000, 1.649039, -0.000000, 0.072397}, 
%% {0.370452, -0.000000, -0.224609, -0.000000, 6.247381, -0.000000, 1.521036, -0.000000, 0.077780}, 
%% {0.352166, -0.000000, -0.227836, -0.000000, 5.611843, -0.000000, 1.415743, -0.000000, 0.084075}, 
%% {0.340408, -0.000000, -0.232013, -0.000000, 5.068693, -0.000000, 1.333070, -0.000000, 0.091414}, 
%% {0.332659, -0.000000, -0.237006, -0.000000, 4.606267, -0.000000, 1.263519, -0.000000, 0.099796}, 
%% {0.329716, -0.000000, -0.243043, -0.000000, 4.206614, -0.000000, 1.208141, -0.000000, 0.109443}, 
%% {0.329452, -0.000000, -0.249776, -0.000000, 3.865443, -0.000000, 1.160285, -0.000000, 0.120323}, 
%% {0.332388, -0.000000, -0.257389, -0.000000, 3.570416, -0.000000, 1.120090, -0.000000, 0.132643}, 
%% {0.337895, -0.000000, -0.265725, -0.000000, 3.315606, -0.000000, 1.085347, -0.000000, 0.146471}, 
%% {0.346418, -0.000000, -0.274492, -0.000000, 3.088365, -0.000000, 1.057863, -0.000000, 0.161778}, 
%% {0.356749, -0.000000, -0.283762, -0.000000, 2.887626, -0.000000, 1.032620, -0.000000, 0.178644}, 
%% {0.369268, -0.000000, -0.293426, -0.000000, 2.711187, -0.000000, 1.010302, -0.000000, 0.197197}, 
%% {0.383453, -0.000000, -0.303192, -0.000000, 2.555401, -0.000000, 0.989752, -0.000000, 0.217413}, 
%% {0.398732, -0.000000, -0.312779, -0.000000, 2.413519, -0.000000, 0.969843, -0.000000, 0.239223}, 
%% {0.416701, -0.000000, -0.322268, -0.000000, 2.286139, -0.000000, 0.953258, -0.000000, 0.262771}, 
%% {0.435604, -0.000000, -0.331204, -0.000000, 2.170401, -0.000000, 0.936628, -0.000000, 0.287850}, 
%% {0.455823, -0.000000, -0.339784, -0.000000, 2.065381, -0.000000, 0.919516, -0.000000, 0.314565}, 
%% {0.477658, -0.000000, -0.347502, -0.000000, 1.968301, -0.000000, 0.903586, -0.000000, 0.342631}, 
%% {0.500114, -0.000000, -0.354269, -0.000000, 1.880229, -0.000000, 0.886542, -0.000000, 0.371994}, 
%% {0.522547, -0.000000, -0.359843, -0.000000, 1.798562, -0.000000, 0.867752, -0.000000, 0.402438}, 
%% {0.547103, -0.000000, -0.364333, -0.000000, 1.724794, -0.000000, 0.849741, -0.000000, 0.434131}, 
%% {0.571335, -0.000000, -0.367394, -0.000000, 1.656231, -0.000000, 0.829624, -0.000000, 0.466515}, 
%% {0.595420, -0.000000, -0.369111, -0.000000, 1.592444, -0.000000, 0.807118, -0.000000, 0.499654}, 
%% {0.619974, -0.000000, -0.368837, -0.000000, 1.530879, -0.000000, 0.785650, -0.000000, 0.532598}, 
%% {0.643723, -0.000000, -0.367143, -0.000000, 1.475547, -0.000000, 0.760688, -0.000000, 0.566147}, 
%% {0.667051, -0.000000, -0.363526, -0.000000, 1.421543, -0.000000, 0.735150, -0.000000, 0.599362}, 
%% {0.688788, -0.000000, -0.358573, -0.000000, 1.373806, -0.000000, 0.705831, -0.000000, 0.632555}, 
%% {0.709424, -0.000000, -0.351906, -0.000000, 1.328808, -0.000000, 0.675168, -0.000000, 0.665087}, 
%% {0.729048, -0.000000, -0.343389, -0.000000, 1.284023, -0.000000, 0.644022, -0.000000, 0.696659}, 
%% {0.747634, -0.000000, -0.333230, -0.000000, 1.242271, -0.000000, 0.611571, -0.000000, 0.727415}, 
%% {0.763930, -0.000000, -0.321768, -0.000000, 1.204846, -0.000000, 0.576344, -0.000000, 0.757244}, 
%% {0.778613, -0.000000, -0.308677, -0.000000, 1.167650, -0.000000, 0.540761, -0.000000, 0.785619}, 
%% {0.790252, -0.000000, -0.294260, -0.000000, 1.131665, -0.000000, 0.503595, -0.000000, 0.812480}, 
%% {0.801271, -0.000000, -0.278758, -0.000000, 1.097638, -0.000000, 0.465951, -0.000000, 0.837898}, 
%% {0.808295, -0.000000, -0.262218, -0.000000, 1.064800, -0.000000, 0.426548, -0.000000, 0.861624}, 
%% {0.812403, -0.000000, -0.244680, -0.000000, 1.032116, -0.000000, 0.386932, -0.000000, 0.883463}, 
%% {0.814050, -0.000000, -0.226197, -0.000000, 0.999977, -0.000000, 0.347113, -0.000000, 0.903549}, 
%% {0.812528, -0.000000, -0.207072, -0.000000, 0.967708, -0.000000, 0.306991, -0.000000, 0.921764}, 
%% {0.807992, -0.000000, -0.187255, -0.000000, 0.935397, -0.000000, 0.267235, -0.000000, 0.938067}, 
%% {0.801320, -0.000000, -0.166653, -0.000000, 0.904422, -0.000000, 0.229188, -0.000000, 0.952335}, 
%% {0.794226, -0.000000, -0.145680, -0.000000, 0.876597, -0.000000, 0.193473, -0.000000, 0.964512}, 
%% {0.786361, -0.000000, -0.124223, -0.000000, 0.852615, -0.000000, 0.160171, -0.000000, 0.974698}, 
%% {0.778489, -0.000000, -0.101676, -0.000000, 0.831627, -0.000000, 0.128618, -0.000000, 0.983202}, 
%% {0.773453, -0.000000, -0.077077, -0.000000, 0.813610, -0.000000, 0.097507, -0.000000, 0.990283}, 
%% {0.770511, -0.000000, -0.051904, -0.000000, 0.796720, -0.000000, 0.065332, -0.000000, 0.995599}, 
%% {0.768418, -0.000000, -0.026914, -0.000000, 0.780540, -0.000000, 0.032878, -0.000000, 0.998848}, 
%% {0.764332, -0.000000, -0.002250, -0.000000, 0.764303, -0.000000, 0.001058, -0.000000, 0.999997}, 
%% {285.381989, -0.000000, -0.194223, -0.000000, 1981.522949, -0.000000, 1411.657959, -0.000000, 0.039264}, 
%% {78.118370, -0.000000, -0.194224, -0.000000, 1981.531738, -0.000000, 386.415009, -0.000000, 0.039265}, 
%% {19.476377, -0.000000, -0.194231, -0.000000, 496.415955, -0.000000, 96.336227, -0.000000, 0.039271}, 
%% {8.656323, -0.000000, -0.194246, -0.000000, 220.581558, -0.000000, 42.812645, -0.000000, 0.039293}, 
%% {4.876388, -0.000000, -0.194255, -0.000000, 123.962616, -0.000000, 24.115253, -0.000000, 0.039347}, 
%% {3.124324, -0.000000, -0.194244, -0.000000, 79.337814, -0.000000, 15.449913, -0.000000, 0.039454}, 
%% {2.167980, -0.000000, -0.194271, -0.000000, 55.154583, -0.000000, 10.716967, -0.000000, 0.039661}, 
%% {1.598395, -0.000000, -0.194339, -0.000000, 40.599155, -0.000000, 7.895061, -0.000000, 0.040086}, 
%% {1.225492, -0.000000, -0.194357, -0.000000, 31.074318, -0.000000, 6.049273, -0.000000, 0.040615}, 
%% {0.972363, -0.000000, -0.194445, -0.000000, 24.596067, -0.000000, 4.793595, -0.000000, 0.041419}, 
%% {0.792243, -0.000000, -0.194593, -0.000000, 19.961590, -0.000000, 3.898297, -0.000000, 0.042486}, 
%% {0.659871, -0.000000, -0.194821, -0.000000, 16.533377, -0.000000, 3.238450, -0.000000, 0.043878}, 
%% {0.560834, -0.000000, -0.195173, -0.000000, 13.934646, -0.000000, 2.742281, -0.000000, 0.045671}, 
%% {0.485456, -0.000000, -0.195720, -0.000000, 11.907145, -0.000000, 2.361586, -0.000000, 0.047885}, 
%% {0.428087, -0.000000, -0.196537, -0.000000, 10.296268, -0.000000, 2.067904, -0.000000, 0.050613}, 
%% {0.384848, -0.000000, -0.197776, -0.000000, 8.987118, -0.000000, 1.840932, -0.000000, 0.053932}, 
%% {0.352635, -0.000000, -0.199575, -0.000000, 7.905436, -0.000000, 1.664623, -0.000000, 0.057902}, 
%% {0.328703, -0.000000, -0.202106, -0.000000, 7.009260, -0.000000, 1.524550, -0.000000, 0.062618}, 
%% {0.312086, -0.000000, -0.205448, -0.000000, 6.253786, -0.000000, 1.415455, -0.000000, 0.068200}, 
%% {0.301279, -0.000000, -0.209730, -0.000000, 5.615780, -0.000000, 1.329136, -0.000000, 0.074745}, 
%% {0.294716, -0.000000, -0.214962, -0.000000, 5.079284, -0.000000, 1.258105, -0.000000, 0.082354}, 
%% {0.291956, -0.000000, -0.221167, -0.000000, 4.621799, -0.000000, 1.199825, -0.000000, 0.091091}, 
%% {0.291905, -0.000000, -0.228231, -0.000000, 4.231432, -0.000000, 1.149749, -0.000000, 0.101050}, 
%% {0.296274, -0.000000, -0.236302, -0.000000, 3.891986, -0.000000, 1.112846, -0.000000, 0.112417}, 
%% {0.301568, -0.000000, -0.244974, -0.000000, 3.602678, -0.000000, 1.076978, -0.000000, 0.125134}, 
%% {0.309709, -0.000000, -0.254308, -0.000000, 3.348549, -0.000000, 1.048124, -0.000000, 0.139366}, 
%% {0.320178, -0.000000, -0.264168, -0.000000, 3.126051, -0.000000, 1.023954, -0.000000, 0.155170}, 
%% {0.332680, -0.000000, -0.274370, -0.000000, 2.926522, -0.000000, 1.003298, -0.000000, 0.172553}, 
%% {0.346782, -0.000000, -0.284954, -0.000000, 2.750860, -0.000000, 0.983781, -0.000000, 0.191618}, 
%% {0.361553, -0.000000, -0.295561, -0.000000, 2.597811, -0.000000, 0.963537, -0.000000, 0.212330}, 
%% {0.380250, -0.000000, -0.305889, -0.000000, 2.450826, -0.000000, 0.951469, -0.000000, 0.234599}, 
%% {0.399024, -0.000000, -0.316052, -0.000000, 2.321846, -0.000000, 0.936050, -0.000000, 0.258589}, 
%% {0.418848, -0.000000, -0.325777, -0.000000, 2.205122, -0.000000, 0.920272, -0.000000, 0.284220}, 
%% {0.440363, -0.000000, -0.334885, -0.000000, 2.098780, -0.000000, 0.905404, -0.000000, 0.311462}, 
%% {0.462190, -0.000000, -0.343195, -0.000000, 2.003996, -0.000000, 0.888701, -0.000000, 0.340103}, 
%% {0.486268, -0.000000, -0.350357, -0.000000, 1.910070, -0.000000, 0.874594, -0.000000, 0.369852}, 
%% {0.510954, -0.000000, -0.356502, -0.000000, 1.828783, -0.000000, 0.858711, -0.000000, 0.400861}, 
%% {0.533829, -0.000000, -0.361421, -0.000000, 1.753792, -0.000000, 0.837547, -0.000000, 0.432951}, 
%% {0.559738, -0.000000, -0.364658, -0.000000, 1.680011, -0.000000, 0.820294, -0.000000, 0.465595}, 
%% {0.583935, -0.000000, -0.366347, -0.000000, 1.612052, -0.000000, 0.798735, -0.000000, 0.498893}, 
%% {0.610256, -0.000000, -0.366456, -0.000000, 1.550475, -0.000000, 0.778469, -0.000000, 0.532533}, 
%% {0.633190, -0.000000, -0.364905, -0.000000, 1.491335, -0.000000, 0.752634, -0.000000, 0.566259}, 
%% {0.657182, -0.000000, -0.361698, -0.000000, 1.438283, -0.000000, 0.726615, -0.000000, 0.600088}, 
%% {0.679497, -0.000000, -0.356491, -0.000000, 1.386676, -0.000000, 0.698940, -0.000000, 0.633308}, 
%% {0.701478, -0.000000, -0.349618, -0.000000, 1.340045, -0.000000, 0.669506, -0.000000, 0.666317}, 
%% {0.720831, -0.000000, -0.341111, -0.000000, 1.294431, -0.000000, 0.637258, -0.000000, 0.698437}, 
%% {0.740205, -0.000000, -0.330935, -0.000000, 1.251195, -0.000000, 0.605314, -0.000000, 0.729372}, 
%% {0.755785, -0.000000, -0.319239, -0.000000, 1.208974, -0.000000, 0.569329, -0.000000, 0.759519}, 
%% {0.770832, -0.000000, -0.305810, -0.000000, 1.170937, -0.000000, 0.534480, -0.000000, 0.787958}, 
%% {0.782537, -0.000000, -0.290989, -0.000000, 1.133697, -0.000000, 0.497496, -0.000000, 0.815004}, 
%% {0.793100, -0.000000, -0.275022, -0.000000, 1.097882, -0.000000, 0.459608, -0.000000, 0.840622}, 
%% {0.800223, -0.000000, -0.257946, -0.000000, 1.063335, -0.000000, 0.420152, -0.000000, 0.864567}, 
%% {0.804631, -0.000000, -0.239763, -0.000000, 1.029844, -0.000000, 0.381213, -0.000000, 0.886407}, 
%% {0.805980, -0.000000, -0.220886, -0.000000, 0.994583, -0.000000, 0.340889, -0.000000, 0.906576}, 
%% {0.805064, -0.000000, -0.201229, -0.000000, 0.962351, -0.000000, 0.301584, -0.000000, 0.924618}, 
%% {0.800941, -0.000000, -0.181003, -0.000000, 0.929382, -0.000000, 0.262188, -0.000000, 0.940749}, 
%% {0.793539, -0.000000, -0.160241, -0.000000, 0.897736, -0.000000, 0.224963, -0.000000, 0.954573}, 
%% {0.786176, -0.000000, -0.139063, -0.000000, 0.869419, -0.000000, 0.189541, -0.000000, 0.966473}, 
%% {0.778375, -0.000000, -0.117710, -0.000000, 0.845161, -0.000000, 0.156853, -0.000000, 0.976280}, 
%% {0.771614, -0.000000, -0.095897, -0.000000, 0.824489, -0.000000, 0.125670, -0.000000, 0.984382}, 
%% {0.766243, -0.000000, -0.074419, -0.000000, 0.805699, -0.000000, 0.095774, -0.000000, 0.990698}, 
%% {0.762369, -0.000000, -0.052557, -0.000000, 0.788206, -0.000000, 0.065199, -0.000000, 0.995505}, 
%% {0.759414, -0.000000, -0.030439, -0.000000, 0.771510, -0.000000, 0.034361, -0.000000, 0.998623}, 
%% {0.755241, -0.000000, -0.007494, -0.000000, 0.755161, -0.000000, 0.003578, -0.000000, 0.999964}, 
%% {229.425781, -0.000000, -0.171016, -0.000000, 1736.543457, -0.000000, 1301.090820, -0.000000, 0.030156}, 
%% {63.790726, -0.000000, -0.171020, -0.000000, 1736.580811, -0.000000, 361.753906, -0.000000, 0.030157}, 
%% {14.923076, -0.000000, -0.171041, -0.000000, 491.838196, -0.000000, 84.616486, -0.000000, 0.030165}, 
%% {6.647823, -0.000000, -0.171037, -0.000000, 220.605118, -0.000000, 37.694466, -0.000000, 0.030184}, 
%% {3.740511, -0.000000, -0.171113, -0.000000, 124.130707, -0.000000, 21.198645, -0.000000, 0.030250}, 
%% {2.394938, -0.000000, -0.171062, -0.000000, 79.440666, -0.000000, 13.575459, -0.000000, 0.030352}, 
%% {1.666592, -0.000000, -0.171114, -0.000000, 55.239914, -0.000000, 9.441664, -0.000000, 0.030596}, 
%% {1.226190, -0.000000, -0.171397, -0.000000, 40.836105, -0.000000, 6.932148, -0.000000, 0.031021}, 
%% {0.942784, -0.000000, -0.171321, -0.000000, 31.212563, -0.000000, 5.329397, -0.000000, 0.031554}, 
%% {0.749461, -0.000000, -0.171400, -0.000000, 24.627115, -0.000000, 4.231215, -0.000000, 0.032331}, 
%% {0.611582, -0.000000, -0.171639, -0.000000, 19.995642, -0.000000, 3.444155, -0.000000, 0.033406}, 
%% {0.511107, -0.000000, -0.172000, -0.000000, 16.571472, -0.000000, 2.868109, -0.000000, 0.034814}, 
%% {0.436078, -0.000000, -0.172544, -0.000000, 13.969938, -0.000000, 2.434819, -0.000000, 0.036612}, 
%% {0.380073, -0.000000, -0.173376, -0.000000, 11.940063, -0.000000, 2.106994, -0.000000, 0.038866}, 
%% {0.338560, -0.000000, -0.174618, -0.000000, 10.316135, -0.000000, 1.858113, -0.000000, 0.041650}, 
%% {0.308252, -0.000000, -0.176415, -0.000000, 8.996798, -0.000000, 1.668603, -0.000000, 0.045044}, 
%% {0.286062, -0.000000, -0.178992, -0.000000, 7.910730, -0.000000, 1.519665, -0.000000, 0.049131}, 
%% {0.270710, -0.000000, -0.182418, -0.000000, 7.012027, -0.000000, 1.403838, -0.000000, 0.054020}, 
%% {0.261055, -0.000000, -0.186891, -0.000000, 6.259755, -0.000000, 1.313260, -0.000000, 0.059831}, 
%% {0.255887, -0.000000, -0.192308, -0.000000, 5.629277, -0.000000, 1.241943, -0.000000, 0.066638}, 
%% {0.254068, -0.000000, -0.198759, -0.000000, 5.103542, -0.000000, 1.182974, -0.000000, 0.074549}, 
%% {0.255729, -0.000000, -0.206202, -0.000000, 4.650814, -0.000000, 1.136452, -0.000000, 0.083643}, 
%% {0.259739, -0.000000, -0.214497, -0.000000, 4.264505, -0.000000, 1.097097, -0.000000, 0.093998}, 
%% {0.266216, -0.000000, -0.223627, -0.000000, 3.933172, -0.000000, 1.064587, -0.000000, 0.105727}, 
%% {0.273786, -0.000000, -0.233385, -0.000000, 3.647132, -0.000000, 1.033664, -0.000000, 0.118870}, 
%% {0.284678, -0.000000, -0.243864, -0.000000, 3.396051, -0.000000, 1.011408, -0.000000, 0.133596}, 
%% {0.297077, -0.000000, -0.254634, -0.000000, 3.171361, -0.000000, 0.991890, -0.000000, 0.149822}, 
%% {0.310606, -0.000000, -0.265849, -0.000000, 2.979298, -0.000000, 0.972367, -0.000000, 0.167748}, 
%% {0.325416, -0.000000, -0.277113, -0.000000, 2.801074, -0.000000, 0.954424, -0.000000, 0.187246}, 
%% {0.343508, -0.000000, -0.288484, -0.000000, 2.641768, -0.000000, 0.942544, -0.000000, 0.208435}, 
%% {0.362146, -0.000000, -0.299679, -0.000000, 2.499093, -0.000000, 0.928947, -0.000000, 0.231289}, 
%% {0.381585, -0.000000, -0.310669, -0.000000, 2.372241, -0.000000, 0.913977, -0.000000, 0.255882}, 
%% {0.404531, -0.000000, -0.320859, -0.000000, 2.245908, -0.000000, 0.905434, -0.000000, 0.281844}, 
%% {0.426157, -0.000000, -0.330396, -0.000000, 2.137351, -0.000000, 0.890781, -0.000000, 0.309386}, 
%% {0.448733, -0.000000, -0.339133, -0.000000, 2.040318, -0.000000, 0.875403, -0.000000, 0.338407}, 
%% {0.475128, -0.000000, -0.346760, -0.000000, 1.945295, -0.000000, 0.865009, -0.000000, 0.368695}, 
%% {0.498116, -0.000000, -0.353119, -0.000000, 1.859463, -0.000000, 0.846395, -0.000000, 0.399983}, 
%% {0.522044, -0.000000, -0.358374, -0.000000, 1.781837, -0.000000, 0.826817, -0.000000, 0.432405}, 
%% {0.548935, -0.000000, -0.361837, -0.000000, 1.703819, -0.000000, 0.811377, -0.000000, 0.465171}, 
%% {0.576418, -0.000000, -0.363749, -0.000000, 1.632978, -0.000000, 0.794590, -0.000000, 0.498574}, 
%% {0.600644, -0.000000, -0.364345, -0.000000, 1.571671, -0.000000, 0.770102, -0.000000, 0.532864}, 
%% {0.625243, -0.000000, -0.362718, -0.000000, 1.509330, -0.000000, 0.746942, -0.000000, 0.566681}, 
%% {0.647984, -0.000000, -0.359524, -0.000000, 1.454324, -0.000000, 0.719492, -0.000000, 0.600801}, 
%% {0.671920, -0.000000, -0.354493, -0.000000, 1.398913, -0.000000, 0.693418, -0.000000, 0.634164}, 
%% {0.692456, -0.000000, -0.347781, -0.000000, 1.349582, -0.000000, 0.662485, -0.000000, 0.667272}, 
%% {0.713776, -0.000000, -0.339047, -0.000000, 1.301000, -0.000000, 0.633088, -0.000000, 0.699280}, 
%% {0.732455, -0.000000, -0.328737, -0.000000, 1.256682, -0.000000, 0.599885, -0.000000, 0.730763}, 
%% {0.748608, -0.000000, -0.316694, -0.000000, 1.214143, -0.000000, 0.565118, -0.000000, 0.760930}, 
%% {0.762585, -0.000000, -0.303232, -0.000000, 1.174029, -0.000000, 0.529010, -0.000000, 0.789646}, 
%% {0.775679, -0.000000, -0.288378, -0.000000, 1.134265, -0.000000, 0.492453, -0.000000, 0.816918}, 
%% {0.785672, -0.000000, -0.272135, -0.000000, 1.096949, -0.000000, 0.454569, -0.000000, 0.842550}, 
%% {0.792479, -0.000000, -0.254617, -0.000000, 1.060610, -0.000000, 0.415529, -0.000000, 0.866494}, 
%% {0.796831, -0.000000, -0.235943, -0.000000, 1.025995, -0.000000, 0.376151, -0.000000, 0.888621}, 
%% {0.798578, -0.000000, -0.216433, -0.000000, 0.990631, -0.000000, 0.336740, -0.000000, 0.908736}, 
%% {0.796304, -0.000000, -0.196183, -0.000000, 0.956539, -0.000000, 0.296196, -0.000000, 0.927027}, 
%% {0.791499, -0.000000, -0.175249, -0.000000, 0.921679, -0.000000, 0.257269, -0.000000, 0.943037}, 
%% {0.784151, -0.000000, -0.153872, -0.000000, 0.889483, -0.000000, 0.219832, -0.000000, 0.956863}, 
%% {0.777647, -0.000000, -0.132193, -0.000000, 0.861799, -0.000000, 0.185156, -0.000000, 0.968525}, 
%% {0.769819, -0.000000, -0.110326, -0.000000, 0.837006, -0.000000, 0.152336, -0.000000, 0.978168}, 
%% {0.763001, -0.000000, -0.088417, -0.000000, 0.815951, -0.000000, 0.121744, -0.000000, 0.985892}, 
%% {0.757761, -0.000000, -0.066544, -0.000000, 0.796730, -0.000000, 0.091346, -0.000000, 0.991978}, 
%% {0.754191, -0.000000, -0.044724, -0.000000, 0.779008, -0.000000, 0.060964, -0.000000, 0.996385}, 
%% {0.749766, -0.000000, -0.023177, -0.000000, 0.761588, -0.000000, 0.030690, -0.000000, 0.999051}, 
%% {0.744692, -0.000000, -0.001618, -0.000000, 0.744388, -0.000000, 0.000882, -0.000000, 0.999998}, 
%% {177.566650, -0.000000, -0.147385, -0.000000, 1490.497314, -0.000000, 1178.017578, -0.000000, 0.022216}, 
%% {50.199921, -0.000000, -0.147389, -0.000000, 1490.540161, -0.000000, 333.027893, -0.000000, 0.022217}, 
%% {11.022495, -0.000000, -0.147411, -0.000000, 496.363800, -0.000000, 73.112305, -0.000000, 0.022224}, 
%% {4.898969, -0.000000, -0.147407, -0.000000, 220.575928, -0.000000, 32.495136, -0.000000, 0.022243}, 
%% {2.757865, -0.000000, -0.147542, -0.000000, 124.291954, -0.000000, 18.274899, -0.000000, 0.022317}, 
%% {1.763451, -0.000000, -0.147442, -0.000000, 79.019791, -0.000000, 11.692266, -0.000000, 0.022414}, 
%% {1.228583, -0.000000, -0.147749, -0.000000, 55.552650, -0.000000, 8.126480, -0.000000, 0.022711}, 
%% {0.919122, -0.000000, -0.148007, -0.000000, 41.061001, -0.000000, 6.066525, -0.000000, 0.023102}, 
%% {0.696222, -0.000000, -0.147711, -0.000000, 31.204380, -0.000000, 4.602160, -0.000000, 0.023600}, 
%% {0.554867, -0.000000, -0.147961, -0.000000, 24.663849, -0.000000, 3.658576, -0.000000, 0.024402}, 
%% {0.454177, -0.000000, -0.148326, -0.000000, 20.045017, -0.000000, 2.984004, -0.000000, 0.025477}, 
%% {0.381376, -0.000000, -0.148867, -0.000000, 16.624817, -0.000000, 2.492946, -0.000000, 0.026898}, 
%% {0.328167, -0.000000, -0.149697, -0.000000, 14.015350, -0.000000, 2.129256, -0.000000, 0.028714}, 
%% {0.289354, -0.000000, -0.150930, -0.000000, 11.969115, -0.000000, 1.857712, -0.000000, 0.031001}, 
%% {0.261511, -0.000000, -0.152781, -0.000000, 10.336433, -0.000000, 1.653721, -0.000000, 0.033855}, 
%% {0.242124, -0.000000, -0.155427, -0.000000, 9.003683, -0.000000, 1.499622, -0.000000, 0.037346}, 
%% {0.229524, -0.000000, -0.159021, -0.000000, 7.913671, -0.000000, 1.383320, -0.000000, 0.041596}, 
%% {0.221597, -0.000000, -0.163636, -0.000000, 7.020412, -0.000000, 1.290975, -0.000000, 0.046693}, 
%% {0.217768, -0.000000, -0.169292, -0.000000, 6.277827, -0.000000, 1.218503, -0.000000, 0.052739}, 
%% {0.217273, -0.000000, -0.175987, -0.000000, 5.658374, -0.000000, 1.160741, -0.000000, 0.059823}, 
%% {0.219744, -0.000000, -0.183704, -0.000000, 5.136938, -0.000000, 1.114780, -0.000000, 0.068054}, 
%% {0.224225, -0.000000, -0.192402, -0.000000, 4.701043, -0.000000, 1.075061, -0.000000, 0.077515}, 
%% {0.230933, -0.000000, -0.201864, -0.000000, 4.320782, -0.000000, 1.043049, -0.000000, 0.088247}, 
%% {0.239070, -0.000000, -0.212087, -0.000000, 3.995569, -0.000000, 1.014077, -0.000000, 0.100378}, 
%% {0.250278, -0.000000, -0.223047, -0.000000, 3.709030, -0.000000, 0.994134, -0.000000, 0.114029}, 
%% {0.262043, -0.000000, -0.234288, -0.000000, 3.455806, -0.000000, 0.974086, -0.000000, 0.129087}, 
%% {0.276058, -0.000000, -0.246042, -0.000000, 3.232247, -0.000000, 0.958396, -0.000000, 0.145810}, 
%% {0.291443, -0.000000, -0.258136, -0.000000, 3.037655, -0.000000, 0.943621, -0.000000, 0.164217}, 
%% {0.309081, -0.000000, -0.270211, -0.000000, 2.855209, -0.000000, 0.933134, -0.000000, 0.184216}, 
%% {0.327114, -0.000000, -0.282238, -0.000000, 2.698207, -0.000000, 0.920357, -0.000000, 0.205903}, 
%% {0.346730, -0.000000, -0.294071, -0.000000, 2.551381, -0.000000, 0.908796, -0.000000, 0.229227}, 
%% {0.368138, -0.000000, -0.305480, -0.000000, 2.418447, -0.000000, 0.898856, -0.000000, 0.254131}, 
%% {0.389362, -0.000000, -0.316284, -0.000000, 2.299546, -0.000000, 0.885655, -0.000000, 0.280570}, 
%% {0.413697, -0.000000, -0.326284, -0.000000, 2.182998, -0.000000, 0.876799, -0.000000, 0.308465}, 
%% {0.437804, -0.000000, -0.335416, -0.000000, 2.080785, -0.000000, 0.864392, -0.000000, 0.337761}, 
%% {0.461124, -0.000000, -0.343411, -0.000000, 1.985642, -0.000000, 0.848230, -0.000000, 0.368302}, 
%% {0.487713, -0.000000, -0.350208, -0.000000, 1.897101, -0.000000, 0.835571, -0.000000, 0.400008}, 
%% {0.512526, -0.000000, -0.355679, -0.000000, 1.817137, -0.000000, 0.817382, -0.000000, 0.432760}, 
%% {0.539539, -0.000000, -0.359196, -0.000000, 1.733408, -0.000000, 0.802570, -0.000000, 0.465691}, 
%% {0.567073, -0.000000, -0.361227, -0.000000, 1.659579, -0.000000, 0.786374, -0.000000, 0.499078}, 
%% {0.590035, -0.000000, -0.362121, -0.000000, 1.595610, -0.000000, 0.760043, -0.000000, 0.533540}, 
%% {0.616266, -0.000000, -0.360649, -0.000000, 1.530291, -0.000000, 0.739424, -0.000000, 0.567277}, 
%% {0.639038, -0.000000, -0.357608, -0.000000, 1.470010, -0.000000, 0.712500, -0.000000, 0.601283}, 
%% {0.663519, -0.000000, -0.352725, -0.000000, 1.413637, -0.000000, 0.686579, -0.000000, 0.635017}, 
%% {0.686555, -0.000000, -0.345738, -0.000000, 1.358908, -0.000000, 0.659719, -0.000000, 0.667777}, 
%% {0.704047, -0.000000, -0.337107, -0.000000, 1.309291, -0.000000, 0.626451, -0.000000, 0.700047}, 
%% {0.725215, -0.000000, -0.327030, -0.000000, 1.263834, -0.000000, 0.595280, -0.000000, 0.731563}, 
%% {0.740468, -0.000000, -0.315081, -0.000000, 1.218231, -0.000000, 0.560039, -0.000000, 0.761694}, 
%% {0.755856, -0.000000, -0.301569, -0.000000, 1.177007, -0.000000, 0.524504, -0.000000, 0.790735}, 
%% {0.766377, -0.000000, -0.286362, -0.000000, 1.134861, -0.000000, 0.487381, -0.000000, 0.817887}, 
%% {0.778351, -0.000000, -0.269821, -0.000000, 1.096512, -0.000000, 0.450535, -0.000000, 0.843819}, 
%% {0.784303, -0.000000, -0.252069, -0.000000, 1.059176, -0.000000, 0.410631, -0.000000, 0.868026}, 
%% {0.788773, -0.000000, -0.233298, -0.000000, 1.021355, -0.000000, 0.371627, -0.000000, 0.890083}, 
%% {0.790786, -0.000000, -0.213535, -0.000000, 0.985412, -0.000000, 0.332366, -0.000000, 0.910252}, 
%% {0.787821, -0.000000, -0.192871, -0.000000, 0.948714, -0.000000, 0.291947, -0.000000, 0.928527}, 
%% {0.782628, -0.000000, -0.171416, -0.000000, 0.913245, -0.000000, 0.253349, -0.000000, 0.944510}, 
%% {0.775481, -0.000000, -0.149375, -0.000000, 0.880757, -0.000000, 0.215629, -0.000000, 0.958465}, 
%% {0.768046, -0.000000, -0.126982, -0.000000, 0.851947, -0.000000, 0.181062, -0.000000, 0.970065}, 
%% {0.759993, -0.000000, -0.104490, -0.000000, 0.827161, -0.000000, 0.148495, -0.000000, 0.979584}, 
%% {0.753192, -0.000000, -0.081860, -0.000000, 0.805152, -0.000000, 0.117828, -0.000000, 0.987194}, 
%% {0.744221, -0.000000, -0.059322, -0.000000, 0.784613, -0.000000, 0.087146, -0.000000, 0.993054}, 
%% {0.741471, -0.000000, -0.037034, -0.000000, 0.767124, -0.000000, 0.056763, -0.000000, 0.997165}, 
%% {0.737646, -0.000000, -0.014954, -0.000000, 0.749506, -0.000000, 0.026249, -0.000000, 0.999468}, 
%% {0.732301, -0.000000, 0.006715, -0.000000, 0.732278, -0.000000, -0.003494, -0.000000, 0.999968}, 
%% {131.962097, -0.000000, -0.123387, -0.000000, 1243.524292, -0.000000, 1052.957764, -0.000000, 0.015463}, 
%% {37.673248, -0.000000, -0.123384, -0.000000, 1243.496826, -0.000000, 300.610748, -0.000000, 0.015463}, 
%% {7.702147, -0.000000, -0.123418, -0.000000, 495.730865, -0.000000, 61.441235, -0.000000, 0.015472}, 
%% {3.411936, -0.000000, -0.123432, -0.000000, 220.603760, -0.000000, 27.214041, -0.000000, 0.015493}, 
%% {1.919652, -0.000000, -0.123595, -0.000000, 124.522087, -0.000000, 15.290004, -0.000000, 0.015567}, 
%% {1.235019, -0.000000, -0.123483, -0.000000, 79.640892, -0.000000, 9.844766, -0.000000, 0.015678}, 
%% {0.862508, -0.000000, -0.124193, -0.000000, 55.750744, -0.000000, 6.833753, -0.000000, 0.016003}, 
%% {0.644005, -0.000000, -0.123675, -0.000000, 39.883022, -0.000000, 5.122399, -0.000000, 0.016295}, 
%% {0.478341, -0.000000, -0.124102, -0.000000, 31.701601, -0.000000, 3.789354, -0.000000, 0.016884}, 
%% {0.390106, -0.000000, -0.124198, -0.000000, 24.707275, -0.000000, 3.085583, -0.000000, 0.017643}, 
%% {0.320890, -0.000000, -0.124769, -0.000000, 20.115494, -0.000000, 2.523705, -0.000000, 0.018730}, 
%% {0.272040, -0.000000, -0.125592, -0.000000, 16.684750, -0.000000, 2.122410, -0.000000, 0.020153}, 
%% {0.237691, -0.000000, -0.126866, -0.000000, 14.053575, -0.000000, 1.832349, -0.000000, 0.021995}, 
%% {0.213964, -0.000000, -0.128786, -0.000000, 11.981468, -0.000000, 1.620946, -0.000000, 0.024345}, 
%% {0.198016, -0.000000, -0.131563, -0.000000, 10.331924, -0.000000, 1.464033, -0.000000, 0.027284}, 
%% {0.187625, -0.000000, -0.135314, -0.000000, 9.009661, -0.000000, 1.343724, -0.000000, 0.030915}, 
%% {0.182313, -0.000000, -0.140170, -0.000000, 7.923396, -0.000000, 1.254680, -0.000000, 0.035349}, 
%% {0.180340, -0.000000, -0.146135, -0.000000, 7.048873, -0.000000, 1.183858, -0.000000, 0.040682}, 
%% {0.181242, -0.000000, -0.153167, -0.000000, 6.324645, -0.000000, 1.127684, -0.000000, 0.046998}, 
%% {0.184689, -0.000000, -0.161206, -0.000000, 5.716555, -0.000000, 1.083355, -0.000000, 0.054394}, 
%% {0.190083, -0.000000, -0.170154, -0.000000, 5.203673, -0.000000, 1.046798, -0.000000, 0.062948}, 
%% {0.197240, -0.000000, -0.180052, -0.000000, 4.775815, -0.000000, 1.015737, -0.000000, 0.072774}, 
%% {0.205991, -0.000000, -0.190611, -0.000000, 4.400987, -0.000000, 0.990026, -0.000000, 0.083891}, 
%% {0.217005, -0.000000, -0.202022, -0.000000, 4.077891, -0.000000, 0.970505, -0.000000, 0.096503}, 
%% {0.229233, -0.000000, -0.213778, -0.000000, 3.787211, -0.000000, 0.953809, -0.000000, 0.110500}, 
%% {0.242707, -0.000000, -0.226093, -0.000000, 3.541072, -0.000000, 0.938112, -0.000000, 0.126104}, 
%% {0.257534, -0.000000, -0.238619, -0.000000, 3.319053, -0.000000, 0.924663, -0.000000, 0.143250}, 
%% {0.274522, -0.000000, -0.251418, -0.000000, 3.116484, -0.000000, 0.914913, -0.000000, 0.162086}, 
%% {0.293206, -0.000000, -0.264256, -0.000000, 2.932838, -0.000000, 0.906962, -0.000000, 0.182586}, 
%% {0.311415, -0.000000, -0.276769, -0.000000, 2.773220, -0.000000, 0.894958, -0.000000, 0.204609}, 
%% {0.333037, -0.000000, -0.289298, -0.000000, 2.623234, -0.000000, 0.888122, -0.000000, 0.228518}, 
%% {0.352840, -0.000000, -0.301026, -0.000000, 2.488163, -0.000000, 0.874696, -0.000000, 0.253751}, 
%% {0.377665, -0.000000, -0.312015, -0.000000, 2.351355, -0.000000, 0.871083, -0.000000, 0.280338}, 
%% {0.400970, -0.000000, -0.322755, -0.000000, 2.241754, -0.000000, 0.858608, -0.000000, 0.308875}, 
%% {0.426670, -0.000000, -0.331852, -0.000000, 2.126560, -0.000000, 0.851064, -0.000000, 0.338067}, 
%% {0.450518, -0.000000, -0.340356, -0.000000, 2.030777, -0.000000, 0.835238, -0.000000, 0.368997}, 
%% {0.478335, -0.000000, -0.347305, -0.000000, 1.937199, -0.000000, 0.825409, -0.000000, 0.400693}, 
%% {0.503012, -0.000000, -0.352825, -0.000000, 1.850181, -0.000000, 0.807990, -0.000000, 0.433257}, 
%% {0.529633, -0.000000, -0.356769, -0.000000, 1.767471, -0.000000, 0.792041, -0.000000, 0.466469}, 
%% {0.553860, -0.000000, -0.359181, -0.000000, 1.692441, -0.000000, 0.770509, -0.000000, 0.500321}, 
%% {0.580524, -0.000000, -0.359716, -0.000000, 1.620864, -0.000000, 0.751625, -0.000000, 0.534263}, 
%% {0.607264, -0.000000, -0.358435, -0.000000, 1.551296, -0.000000, 0.731461, -0.000000, 0.568259}, 
%% {0.629503, -0.000000, -0.355634, -0.000000, 1.489697, -0.000000, 0.704181, -0.000000, 0.602177}, 
%% {0.653664, -0.000000, -0.350914, -0.000000, 1.430126, -0.000000, 0.678714, -0.000000, 0.635638}, 
%% {0.677552, -0.000000, -0.344210, -0.000000, 1.371015, -0.000000, 0.653027, -0.000000, 0.668249}, 
%% {0.696406, -0.000000, -0.335954, -0.000000, 1.319785, -0.000000, 0.620488, -0.000000, 0.700669}, 
%% {0.716271, -0.000000, -0.325982, -0.000000, 1.272016, -0.000000, 0.588012, -0.000000, 0.732390}, 
%% {0.734134, -0.000000, -0.313806, -0.000000, 1.223030, -0.000000, 0.556882, -0.000000, 0.761961}, 
%% {0.746680, -0.000000, -0.300314, -0.000000, 1.177786, -0.000000, 0.519783, -0.000000, 0.790944}, 
%% {0.760187, -0.000000, -0.285189, -0.000000, 1.135257, -0.000000, 0.483993, -0.000000, 0.818427}, 
%% {0.768897, -0.000000, -0.268788, -0.000000, 1.092702, -0.000000, 0.445920, -0.000000, 0.844117}, 
%% {0.777443, -0.000000, -0.251079, -0.000000, 1.053595, -0.000000, 0.408266, -0.000000, 0.868148}, 
%% {0.780805, -0.000000, -0.232216, -0.000000, 1.015030, -0.000000, 0.368118, -0.000000, 0.890519}, 
%% {0.780792, -0.000000, -0.212208, -0.000000, 0.975870, -0.000000, 0.328302, -0.000000, 0.910772}, 
%% {0.779006, -0.000000, -0.191216, -0.000000, 0.938411, -0.000000, 0.289104, -0.000000, 0.929036}, 
%% {0.772719, -0.000000, -0.169544, -0.000000, 0.901521, -0.000000, 0.249279, -0.000000, 0.945305}, 
%% {0.764345, -0.000000, -0.147259, -0.000000, 0.866860, -0.000000, 0.212161, -0.000000, 0.959125}, 
%% {0.754987, -0.000000, -0.124699, -0.000000, 0.836991, -0.000000, 0.176982, -0.000000, 0.970768}, 
%% {0.741440, -0.000000, -0.101752, -0.000000, 0.811018, -0.000000, 0.144314, -0.000000, 0.980195}, 
%% {0.735978, -0.000000, -0.078654, -0.000000, 0.790893, -0.000000, 0.114077, -0.000000, 0.987808}, 
%% {0.732105, -0.000000, -0.055464, -0.000000, 0.771309, -0.000000, 0.083934, -0.000000, 0.993641}, 
%% {0.729411, -0.000000, -0.032298, -0.000000, 0.754103, -0.000000, 0.053432, -0.000000, 0.997634}, 
%% {0.724703, -0.000000, -0.009422, -0.000000, 0.736090, -0.000000, 0.023114, -0.000000, 0.999700}, 
%% {0.718497, -0.000000, 0.012987, -0.000000, 0.718643, -0.000000, -0.006752, -0.000000, 0.999878}, 
%% {90.688080, -0.000000, -0.099083, -0.000000, 995.780212, -0.000000, 906.197571, -0.000000, 0.009915}, 
%% {26.218592, -0.000000, -0.099079, -0.000000, 995.741028, -0.000000, 261.998718, -0.000000, 0.009915}, 
%% {4.894561, -0.000000, -0.099123, -0.000000, 498.447540, -0.000000, 48.888561, -0.000000, 0.009924}, 
%% {2.182871, -0.000000, -0.099165, -0.000000, 220.683304, -0.000000, 21.793524, -0.000000, 0.009948}, 
%% {1.236251, -0.000000, -0.099460, -0.000000, 124.425339, -0.000000, 12.304916, -0.000000, 0.010032}, 
%% {0.791051, -0.000000, -0.099543, -0.000000, 80.186966, -0.000000, 7.865993, -0.000000, 0.010176}, 
%% {0.556854, -0.000000, -0.099872, -0.000000, 56.124207, -0.000000, 5.517536, -0.000000, 0.010432}, 
%% {0.413283, -0.000000, -0.100709, -0.000000, 41.236729, -0.000000, 4.059115, -0.000000, 0.010875}, 
%% {0.322289, -0.000000, -0.101054, -0.000000, 31.780340, -0.000000, 3.152776, -0.000000, 0.011441}, 
%% {0.254247, -0.000000, -0.100337, -0.000000, 24.837547, -0.000000, 2.503286, -0.000000, 0.012093}, 
%% {0.212209, -0.000000, -0.101159, -0.000000, 20.197458, -0.000000, 2.070140, -0.000000, 0.013171}, 
%% {0.183684, -0.000000, -0.102483, -0.000000, 16.732689, -0.000000, 1.766139, -0.000000, 0.014612}, 
%% {0.165190, -0.000000, -0.104535, -0.000000, 14.059273, -0.000000, 1.554155, -0.000000, 0.016503}, 
%% {0.153675, -0.000000, -0.107561, -0.000000, 11.978742, -0.000000, 1.401665, -0.000000, 0.018938}, 
%% {0.146700, -0.000000, -0.111590, -0.000000, 10.341089, -0.000000, 1.285704, -0.000000, 0.022002}, 
%% {0.143778, -0.000000, -0.116784, -0.000000, 9.032367, -0.000000, 1.199364, -0.000000, 0.025815}, 
%% {0.143817, -0.000000, -0.123095, -0.000000, 7.983728, -0.000000, 1.132754, -0.000000, 0.030466}, 
%% {0.146302, -0.000000, -0.130505, -0.000000, 7.131451, -0.000000, 1.080629, -0.000000, 0.036054}, 
%% {0.151242, -0.000000, -0.139021, -0.000000, 6.422025, -0.000000, 1.041451, -0.000000, 0.042698}, 
%% {0.157778, -0.000000, -0.148364, -0.000000, 5.822183, -0.000000, 1.009830, -0.000000, 0.050423}, 
%% {0.164662, -0.000000, -0.158434, -0.000000, 5.327432, -0.000000, 0.977679, -0.000000, 0.059300}, 
%% {0.174778, -0.000000, -0.169492, -0.000000, 4.893161, -0.000000, 0.959492, -0.000000, 0.069527}, 
%% {0.185505, -0.000000, -0.181145, -0.000000, 4.518745, -0.000000, 0.941040, -0.000000, 0.081080}, 
%% {0.198287, -0.000000, -0.193382, -0.000000, 4.188668, -0.000000, 0.928911, -0.000000, 0.094065}, 
%% {0.211257, -0.000000, -0.206046, -0.000000, 3.903322, -0.000000, 0.914023, -0.000000, 0.108521}, 
%% {0.225648, -0.000000, -0.218938, -0.000000, 3.648144, -0.000000, 0.902379, -0.000000, 0.124454}, 
%% {0.241701, -0.000000, -0.232121, -0.000000, 3.418493, -0.000000, 0.893404, -0.000000, 0.142005}, 
%% {0.259681, -0.000000, -0.245644, -0.000000, 3.213392, -0.000000, 0.886598, -0.000000, 0.161327}, 
%% {0.278071, -0.000000, -0.258803, -0.000000, 3.024607, -0.000000, 0.878832, -0.000000, 0.182064}, 
%% {0.298570, -0.000000, -0.272207, -0.000000, 2.860570, -0.000000, 0.872262, -0.000000, 0.204758}, 
%% {0.319002, -0.000000, -0.284853, -0.000000, 2.705761, -0.000000, 0.863692, -0.000000, 0.228768}, 
%% {0.343348, -0.000000, -0.297026, -0.000000, 2.553120, -0.000000, 0.861936, -0.000000, 0.254352}, 
%% {0.364991, -0.000000, -0.308468, -0.000000, 2.427418, -0.000000, 0.850301, -0.000000, 0.281379}, 
%% {0.391024, -0.000000, -0.319059, -0.000000, 2.299216, -0.000000, 0.845866, -0.000000, 0.309810}, 
%% {0.415078, -0.000000, -0.328835, -0.000000, 2.189293, -0.000000, 0.833494, -0.000000, 0.339685}, 
%% {0.442244, -0.000000, -0.337165, -0.000000, 2.078970, -0.000000, 0.825924, -0.000000, 0.370318}, 
%% {0.466394, -0.000000, -0.344416, -0.000000, 1.984415, -0.000000, 0.809576, -0.000000, 0.402156}, 
%% {0.493899, -0.000000, -0.350120, -0.000000, 1.890990, -0.000000, 0.797493, -0.000000, 0.434665}, 
%% {0.521849, -0.000000, -0.354120, -0.000000, 1.801243, -0.000000, 0.784588, -0.000000, 0.467588}, 
%% {0.545205, -0.000000, -0.357018, -0.000000, 1.727604, -0.000000, 0.760997, -0.000000, 0.501674}, 
%% {0.572383, -0.000000, -0.357591, -0.000000, 1.648195, -0.000000, 0.744072, -0.000000, 0.535148}, 
%% {0.599144, -0.000000, -0.356613, -0.000000, 1.574706, -0.000000, 0.724124, -0.000000, 0.568999}, 
%% {0.620828, -0.000000, -0.353898, -0.000000, 1.510902, -0.000000, 0.696761, -0.000000, 0.602817}, 
%% {0.645353, -0.000000, -0.349211, -0.000000, 1.446532, -0.000000, 0.672566, -0.000000, 0.636064}, 
%% {0.668228, -0.000000, -0.342691, -0.000000, 1.386951, -0.000000, 0.645871, -0.000000, 0.668775}, 
%% {0.692098, -0.000000, -0.334300, -0.000000, 1.328782, -0.000000, 0.619952, -0.000000, 0.700548}, 
%% {0.707011, -0.000000, -0.324607, -0.000000, 1.278193, -0.000000, 0.583756, -0.000000, 0.731983}, 
%% {0.724112, -0.000000, -0.313058, -0.000000, 1.227869, -0.000000, 0.550913, -0.000000, 0.761822}, 
%% {0.738165, -0.000000, -0.299792, -0.000000, 1.177737, -0.000000, 0.516640, -0.000000, 0.790176}, 
%% {0.750782, -0.000000, -0.285088, -0.000000, 1.132564, -0.000000, 0.480932, -0.000000, 0.817380}, 
%% {0.763730, -0.000000, -0.268912, -0.000000, 1.090728, -0.000000, 0.445839, -0.000000, 0.843018}, 
%% {0.766261, -0.000000, -0.251427, -0.000000, 1.047145, -0.000000, 0.404770, -0.000000, 0.867186}, 
%% {0.769313, -0.000000, -0.232769, -0.000000, 1.005371, -0.000000, 0.364645, -0.000000, 0.889670}, 
%% {0.770089, -0.000000, -0.212919, -0.000000, 0.964815, -0.000000, 0.325123, -0.000000, 0.910108}, 
%% {0.766548, -0.000000, -0.192051, -0.000000, 0.923894, -0.000000, 0.285159, -0.000000, 0.928556}, 
%% {0.759683, -0.000000, -0.170370, -0.000000, 0.885746, -0.000000, 0.246277, -0.000000, 0.944769}, 
%% {0.747247, -0.000000, -0.148171, -0.000000, 0.850197, -0.000000, 0.208048, -0.000000, 0.958746}, 
%% {0.737036, -0.000000, -0.125428, -0.000000, 0.821837, -0.000000, 0.173516, -0.000000, 0.970471}, 
%% {0.729903, -0.000000, -0.102256, -0.000000, 0.797780, -0.000000, 0.142392, -0.000000, 0.980052}, 
%% {0.724533, -0.000000, -0.078825, -0.000000, 0.776609, -0.000000, 0.112621, -0.000000, 0.987748}, 
%% {0.719705, -0.000000, -0.055254, -0.000000, 0.757472, -0.000000, 0.082504, -0.000000, 0.993666}, 
%% {0.715271, -0.000000, -0.031836, -0.000000, 0.738536, -0.000000, 0.052136, -0.000000, 0.997679}, 
%% {0.709621, -0.000000, -0.008493, -0.000000, 0.720591, -0.000000, 0.022070, -0.000000, 0.999736}, 
%% {0.702940, -0.000000, 0.014449, -0.000000, 0.702805, -0.000000, -0.007734, -0.000000, 0.999841}, 
%% {55.860836, -0.000000, -0.074531, -0.000000, 747.401184, -0.000000, 745.310669, -0.000000, 0.005586}, 
%% {16.332254, -0.000000, -0.074529, -0.000000, 747.376831, -0.000000, 217.916519, -0.000000, 0.005586}, 
%% {2.762110, -0.000000, -0.074589, -0.000000, 496.200134, -0.000000, 36.824028, -0.000000, 0.005595}, 
%% {1.233127, -0.000000, -0.074682, -0.000000, 221.089066, -0.000000, 16.418934, -0.000000, 0.005622}, 
%% {0.695246, -0.000000, -0.075194, -0.000000, 126.000847, -0.000000, 9.193133, -0.000000, 0.005723}, 
%% {0.450961, -0.000000, -0.075577, -0.000000, 81.027817, -0.000000, 5.931876, -0.000000, 0.005876}, 
%% {0.316187, -0.000000, -0.076530, -0.000000, 57.230389, -0.000000, 4.106029, -0.000000, 0.006174}, 
%% {0.242498, -0.000000, -0.075002, -0.000000, 38.704819, -0.000000, 3.212551, -0.000000, 0.006393}, 
%% {0.195852, -0.000000, -0.080252, -0.000000, 35.148865, -0.000000, 2.422474, -0.000000, 0.007378}, 
%% {0.149278, -0.000000, -0.076438, -0.000000, 25.071924, -0.000000, 1.937828, -0.000000, 0.007733}, 
%% {0.129596, -0.000000, -0.078016, -0.000000, 20.253227, -0.000000, 1.646461, -0.000000, 0.008840}, 
%% {0.116988, -0.000000, -0.080353, -0.000000, 16.740734, -0.000000, 1.440884, -0.000000, 0.010329}, 
%% {0.110393, -0.000000, -0.083752, -0.000000, 14.066588, -0.000000, 1.301874, -0.000000, 0.012306}, 
%% {0.107493, -0.000000, -0.088289, -0.000000, 12.013800, -0.000000, 1.199406, -0.000000, 0.014870}, 
%% {0.107579, -0.000000, -0.093982, -0.000000, 10.423096, -0.000000, 1.123924, -0.000000, 0.018121}, 
%% {0.110052, -0.000000, -0.100843, -0.000000, 9.159135, -0.000000, 1.067129, -0.000000, 0.022166}, 
%% {0.114066, -0.000000, -0.108715, -0.000000, 8.144646, -0.000000, 1.020802, -0.000000, 0.027084}, 
%% {0.120234, -0.000000, -0.117559, -0.000000, 7.302924, -0.000000, 0.989033, -0.000000, 0.032972}, 
%% {0.126812, -0.000000, -0.127210, -0.000000, 6.608921, -0.000000, 0.957109, -0.000000, 0.039891}, 
%% {0.135557, -0.000000, -0.137768, -0.000000, 6.010836, -0.000000, 0.936742, -0.000000, 0.047978}, 
%% {0.145446, -0.000000, -0.149060, -0.000000, 5.501826, -0.000000, 0.919858, -0.000000, 0.057285}, 
%% {0.156446, -0.000000, -0.160975, -0.000000, 5.065858, -0.000000, 0.905907, -0.000000, 0.067867}, 
%% {0.167512, -0.000000, -0.173222, -0.000000, 4.682960, -0.000000, 0.889962, -0.000000, 0.079704}, 
%% {0.181504, -0.000000, -0.186358, -0.000000, 4.351999, -0.000000, 0.883222, -0.000000, 0.093158}, 
%% {0.196340, -0.000000, -0.199627, -0.000000, 4.050103, -0.000000, 0.877333, -0.000000, 0.107980}, 
%% {0.210740, -0.000000, -0.213276, -0.000000, 3.801100, -0.000000, 0.865191, -0.000000, 0.124400}, 
%% {0.227122, -0.000000, -0.226876, -0.000000, 3.558823, -0.000000, 0.858655, -0.000000, 0.142274}, 
%% {0.245648, -0.000000, -0.240704, -0.000000, 3.341764, -0.000000, 0.855359, -0.000000, 0.161857}, 
%% {0.266331, -0.000000, -0.254410, -0.000000, 3.139598, -0.000000, 0.855246, -0.000000, 0.183037}, 
%% {0.286496, -0.000000, -0.268063, -0.000000, 2.966824, -0.000000, 0.848625, -0.000000, 0.205974}, 
%% {0.306861, -0.000000, -0.280841, -0.000000, 2.801986, -0.000000, 0.841223, -0.000000, 0.230108}, 
%% {0.331512, -0.000000, -0.293334, -0.000000, 2.643453, -0.000000, 0.840880, -0.000000, 0.255958}, 
%% {0.354483, -0.000000, -0.305286, -0.000000, 2.511949, -0.000000, 0.832073, -0.000000, 0.283408}, 
%% {0.380068, -0.000000, -0.315827, -0.000000, 2.371919, -0.000000, 0.828294, -0.000000, 0.311707}, 
%% {0.403866, -0.000000, -0.326085, -0.000000, 2.263584, -0.000000, 0.815004, -0.000000, 0.341959}, 
%% {0.430482, -0.000000, -0.334337, -0.000000, 2.141662, -0.000000, 0.808024, -0.000000, 0.372443}, 
%% {0.458835, -0.000000, -0.341675, -0.000000, 2.038497, -0.000000, 0.799993, -0.000000, 0.404280}, 
%% {0.481105, -0.000000, -0.347400, -0.000000, 1.941343, -0.000000, 0.780142, -0.000000, 0.436668}, 
%% {0.509648, -0.000000, -0.351877, -0.000000, 1.851633, -0.000000, 0.767610, -0.000000, 0.470017}, 
%% {0.536928, -0.000000, -0.354185, -0.000000, 1.762088, -0.000000, 0.753636, -0.000000, 0.502864}, 
%% {0.564789, -0.000000, -0.355311, -0.000000, 1.679783, -0.000000, 0.736641, -0.000000, 0.536576}, 
%% {0.592347, -0.000000, -0.354388, -0.000000, 1.601993, -0.000000, 0.719042, -0.000000, 0.569813}, 
%% {0.611310, -0.000000, -0.352166, -0.000000, 1.534662, -0.000000, 0.688071, -0.000000, 0.603613}, 
%% {0.636378, -0.000000, -0.347777, -0.000000, 1.466227, -0.000000, 0.665376, -0.000000, 0.636376}, 
%% {0.659135, -0.000000, -0.341555, -0.000000, 1.402552, -0.000000, 0.639834, -0.000000, 0.668447}, 
%% {0.675823, -0.000000, -0.333863, -0.000000, 1.342052, -0.000000, 0.606590, -0.000000, 0.700339}, 
%% {0.696154, -0.000000, -0.324170, -0.000000, 1.284455, -0.000000, 0.578214, -0.000000, 0.730749}, 
%% {0.714141, -0.000000, -0.312907, -0.000000, 1.231986, -0.000000, 0.547092, -0.000000, 0.760287}, 
%% {0.732016, -0.000000, -0.299990, -0.000000, 1.181341, -0.000000, 0.516145, -0.000000, 0.788477}, 
%% {0.740894, -0.000000, -0.285713, -0.000000, 1.132600, -0.000000, 0.477750, -0.000000, 0.815765}, 
%% {0.749612, -0.000000, -0.269894, -0.000000, 1.084753, -0.000000, 0.440680, -0.000000, 0.841335}, 
%% {0.754306, -0.000000, -0.252833, -0.000000, 1.039123, -0.000000, 0.401389, -0.000000, 0.865460}, 
%% {0.758805, -0.000000, -0.234501, -0.000000, 0.996821, -0.000000, 0.363349, -0.000000, 0.887711}, 
%% {0.756411, -0.000000, -0.215267, -0.000000, 0.951003, -0.000000, 0.322878, -0.000000, 0.908112}, 
%% {0.752113, -0.000000, -0.195047, -0.000000, 0.908876, -0.000000, 0.282888, -0.000000, 0.926638}, 
%% {0.739521, -0.000000, -0.173946, -0.000000, 0.868709, -0.000000, 0.241538, -0.000000, 0.943187}, 
%% {0.732594, -0.000000, -0.152019, -0.000000, 0.835920, -0.000000, 0.206243, -0.000000, 0.957203}, 
%% {0.726290, -0.000000, -0.129490, -0.000000, 0.807474, -0.000000, 0.173361, -0.000000, 0.969092}, 
%% {0.717274, -0.000000, -0.106537, -0.000000, 0.782528, -0.000000, 0.142414, -0.000000, 0.978847}, 
%% {0.711372, -0.000000, -0.083312, -0.000000, 0.760676, -0.000000, 0.112773, -0.000000, 0.986793}, 
%% {0.704877, -0.000000, -0.059898, -0.000000, 0.740561, -0.000000, 0.083205, -0.000000, 0.992929}, 
%% {0.699204, -0.000000, -0.036395, -0.000000, 0.721189, -0.000000, 0.053518, -0.000000, 0.997214}, 
%% {0.692093, -0.000000, -0.012909, -0.000000, 0.701988, -0.000000, 0.023573, -0.000000, 0.999560}, 
%% {0.684584, -0.000000, 0.010410, -0.000000, 0.684182, -0.000000, -0.005567, -0.000000, 0.999915}, 
%% {24.856462, -0.000000, -0.049794, -0.000000, 498.562653, -0.000000, 497.942566, -0.000000, 0.002485}, 
%% {8.372101, -0.000000, -0.049791, -0.000000, 498.534790, -0.000000, 167.725327, -0.000000, 0.002486}, 
%% {1.231342, -0.000000, -0.049794, -0.000000, 498.561951, -0.000000, 24.667166, -0.000000, 0.002490}, 
%% {0.550530, -0.000000, -0.050098, -0.000000, 222.249466, -0.000000, 10.961385, -0.000000, 0.002526}, 
%% {0.300099, -0.000000, -0.050958, -0.000000, 132.492371, -0.000000, 5.873706, -0.000000, 0.002631}, 
%% {0.205355, -0.000000, -0.052084, -0.000000, 84.538155, -0.000000, 3.931666, -0.000000, 0.002815}, 
%% {0.153469, -0.000000, -0.053621, -0.000000, 56.986389, -0.000000, 2.853153, -0.000000, 0.003120}, 
%% {0.116125, -0.000000, -0.054360, -0.000000, 44.802338, -0.000000, 2.128692, -0.000000, 0.003514}, 
%% {0.102979, -0.000000, -0.062966, -0.000000, 40.359444, -0.000000, 1.627862, -0.000000, 0.004654}, 
%% {0.086730, -0.000000, -0.058706, -0.000000, 27.722115, -0.000000, 1.469884, -0.000000, 0.005072}, 
%% {0.072649, -0.000000, -0.056769, -0.000000, 20.254988, -0.000000, 1.272293, -0.000000, 0.005804}, 
%% {0.071256, -0.000000, -0.060932, -0.000000, 16.816322, -0.000000, 1.160777, -0.000000, 0.007401}, 
%% {0.072316, -0.000000, -0.066223, -0.000000, 14.258371, -0.000000, 1.081600, -0.000000, 0.009528}, 
%% {0.075113, -0.000000, -0.072584, -0.000000, 12.277282, -0.000000, 1.022132, -0.000000, 0.012280}, 
%% {0.079356, -0.000000, -0.080021, -0.000000, 10.763168, -0.000000, 0.976048, -0.000000, 0.015767}, 
%% {0.084984, -0.000000, -0.088371, -0.000000, 9.511303, -0.000000, 0.942366, -0.000000, 0.020069}, 
%% {0.092103, -0.000000, -0.097628, -0.000000, 8.486104, -0.000000, 0.919549, -0.000000, 0.025290}, 
%% {0.099177, -0.000000, -0.107514, -0.000000, 7.642861, -0.000000, 0.893434, -0.000000, 0.031455}, 
%% {0.108300, -0.000000, -0.118277, -0.000000, 6.927166, -0.000000, 0.880183, -0.000000, 0.038731}, 
%% {0.118155, -0.000000, -0.129682, -0.000000, 6.319333, -0.000000, 0.868158, -0.000000, 0.047145}, 
%% {0.128672, -0.000000, -0.141665, -0.000000, 5.796970, -0.000000, 0.856720, -0.000000, 0.056768}, 
%% {0.140500, -0.000000, -0.154173, -0.000000, 5.329531, -0.000000, 0.849648, -0.000000, 0.067665}, 
%% {0.152396, -0.000000, -0.167113, -0.000000, 4.936972, -0.000000, 0.839076, -0.000000, 0.079894}, 
%% {0.165888, -0.000000, -0.180608, -0.000000, 4.591659, -0.000000, 0.832506, -0.000000, 0.093619}, 
%% {0.181231, -0.000000, -0.194533, -0.000000, 4.279143, -0.000000, 0.830177, -0.000000, 0.108891}, 
%% {0.197585, -0.000000, -0.208456, -0.000000, 3.992601, -0.000000, 0.828825, -0.000000, 0.125570}, 
%% {0.214018, -0.000000, -0.222530, -0.000000, 3.738682, -0.000000, 0.823419, -0.000000, 0.143829}, 
%% {0.234487, -0.000000, -0.236725, -0.000000, 3.500464, -0.000000, 0.828335, -0.000000, 0.163759}, 
%% {0.254034, -0.000000, -0.250774, -0.000000, 3.290546, -0.000000, 0.825314, -0.000000, 0.185276}, 
%% {0.273642, -0.000000, -0.264420, -0.000000, 3.104815, -0.000000, 0.819330, -0.000000, 0.208282}, 
%% {0.297707, -0.000000, -0.277714, -0.000000, 2.921440, -0.000000, 0.822340, -0.000000, 0.232888}, 
%% {0.319145, -0.000000, -0.290560, -0.000000, 2.767699, -0.000000, 0.813799, -0.000000, 0.259092}, 
%% {0.343908, -0.000000, -0.302078, -0.000000, 2.606352, -0.000000, 0.812700, -0.000000, 0.286149}, 
%% {0.370563, -0.000000, -0.313004, -0.000000, 2.463644, -0.000000, 0.811261, -0.000000, 0.314750}, 
%% {0.397587, -0.000000, -0.322723, -0.000000, 2.326199, -0.000000, 0.807785, -0.000000, 0.344318}, 
%% {0.420119, -0.000000, -0.331550, -0.000000, 2.215445, -0.000000, 0.791705, -0.000000, 0.375201}, 
%% {0.447400, -0.000000, -0.338924, -0.000000, 2.103057, -0.000000, 0.783084, -0.000000, 0.406782}, 
%% {0.475415, -0.000000, -0.344750, -0.000000, 1.995144, -0.000000, 0.773780, -0.000000, 0.438888}, 
%% {0.502991, -0.000000, -0.348960, -0.000000, 1.893682, -0.000000, 0.761984, -0.000000, 0.471359}, 
%% {0.524756, -0.000000, -0.352021, -0.000000, 1.807574, -0.000000, 0.738247, -0.000000, 0.504763}, 
%% {0.551694, -0.000000, -0.353217, -0.000000, 1.721699, -0.000000, 0.721546, -0.000000, 0.538037}, 
%% {0.577045, -0.000000, -0.352593, -0.000000, 1.639230, -0.000000, 0.701928, -0.000000, 0.571099}, 
%% {0.602325, -0.000000, -0.350038, -0.000000, 1.560983, -0.000000, 0.682165, -0.000000, 0.603564}, 
%% {0.627290, -0.000000, -0.346026, -0.000000, 1.489075, -0.000000, 0.659718, -0.000000, 0.636086}, 
%% {0.651116, -0.000000, -0.340057, -0.000000, 1.418126, -0.000000, 0.636466, -0.000000, 0.667594}, 
%% {0.664413, -0.000000, -0.332755, -0.000000, 1.357072, -0.000000, 0.600829, -0.000000, 0.699089}, 
%% {0.684917, -0.000000, -0.323524, -0.000000, 1.295817, -0.000000, 0.573657, -0.000000, 0.729031}, 
%% {0.703373, -0.000000, -0.312871, -0.000000, 1.238679, -0.000000, 0.543710, -0.000000, 0.758149}, 
%% {0.721332, -0.000000, -0.300457, -0.000000, 1.182219, -0.000000, 0.515001, -0.000000, 0.785487}, 
%% {0.726575, -0.000000, -0.287039, -0.000000, 1.130350, -0.000000, 0.474079, -0.000000, 0.812712}, 
%% {0.738503, -0.000000, -0.271982, -0.000000, 1.082269, -0.000000, 0.440391, -0.000000, 0.837809}, 
%% {0.741275, -0.000000, -0.255810, -0.000000, 1.031097, -0.000000, 0.400068, -0.000000, 0.861938}, 
%% {0.745897, -0.000000, -0.238334, -0.000000, 0.985497, -0.000000, 0.362692, -0.000000, 0.884110}, 
%% {0.748565, -0.000000, -0.219771, -0.000000, 0.942681, -0.000000, 0.325011, -0.000000, 0.904580}, 
%% {0.732339, -0.000000, -0.200274, -0.000000, 0.893283, -0.000000, 0.279777, -0.000000, 0.923489}, 
%% {0.724236, -0.000000, -0.179774, -0.000000, 0.852007, -0.000000, 0.242032, -0.000000, 0.939921}, 
%% {0.719275, -0.000000, -0.158495, -0.000000, 0.819887, -0.000000, 0.207924, -0.000000, 0.954183}, 
%% {0.711651, -0.000000, -0.136592, -0.000000, 0.790941, -0.000000, 0.175250, -0.000000, 0.966363}, 
%% {0.703790, -0.000000, -0.114213, -0.000000, 0.764676, -0.000000, 0.144368, -0.000000, 0.976572}, 
%% {0.695615, -0.000000, -0.091484, -0.000000, 0.742272, -0.000000, 0.115195, -0.000000, 0.984850}, 
%% {0.688381, -0.000000, -0.068531, -0.000000, 0.721285, -0.000000, 0.086366, -0.000000, 0.991402}, 
%% {0.679704, -0.000000, -0.045511, -0.000000, 0.700370, -0.000000, 0.057151, -0.000000, 0.996173}, 
%% {0.671538, -0.000000, -0.022494, -0.000000, 0.680865, -0.000000, 0.028192, -0.000000, 0.999056}, 
%% {0.662275, -0.000000, 0.000439, -0.000000, 0.661462, -0.000000, -0.000321, -0.000000, 1.000000}, 
%% {6.218999, -0.000000, -0.024930, -0.000000, 249.379211, -0.000000, 249.301666, -0.000000, 0.000622}, 
%% {2.728265, -0.000000, -0.024938, -0.000000, 249.458069, -0.000000, 109.333679, -0.000000, 0.000622}, 
%% {0.413505, -0.000000, -0.025035, -0.000000, 250.429810, -0.000000, 16.506636, -0.000000, 0.000629}, 
%% {0.136111, -0.000000, -0.025707, -0.000000, 233.135498, -0.000000, 5.291085, -0.000000, 0.000670}, 
%% {0.078549, -0.000000, -0.025161, -0.000000, 124.382385, -0.000000, 3.119614, -0.000000, 0.000711}, 
%% {0.054120, -0.000000, -0.025513, -0.000000, 80.423157, -0.000000, 2.119509, -0.000000, 0.000832}, 
%% {0.048371, -0.000000, -0.035558, -0.000000, 84.728729, -0.000000, 1.358411, -0.000000, 0.001418}, 
%% {0.047184, -0.000000, -0.040567, -0.000000, 65.704071, -0.000000, 1.160732, -0.000000, 0.002050}, 
%% {0.044134, -0.000000, -0.053845, -0.000000, 71.936081, -0.000000, 0.816789, -0.000000, 0.003490}, 
%% {0.050785, -0.000000, -0.055419, -0.000000, 47.755737, -0.000000, 0.912181, -0.000000, 0.004577}, 
%% {0.043005, -0.000000, -0.040681, -0.000000, 18.315706, -0.000000, 1.052666, -0.000000, 0.004215}, 
%% {0.045821, -0.000000, -0.049675, -0.000000, 19.099375, -0.000000, 0.916576, -0.000000, 0.006335}, 
%% {0.047180, -0.000000, -0.053462, -0.000000, 14.282916, -0.000000, 0.875232, -0.000000, 0.008232}, 
%% {0.054536, -0.000000, -0.062089, -0.000000, 13.244393, -0.000000, 0.868399, -0.000000, 0.011342}, 
%% {0.060479, -0.000000, -0.070651, -0.000000, 11.590711, -0.000000, 0.843122, -0.000000, 0.015067}, 
%% {0.067348, -0.000000, -0.079944, -0.000000, 10.298179, -0.000000, 0.825901, -0.000000, 0.019624}, 
%% {0.075516, -0.000000, -0.090074, -0.000000, 9.205719, -0.000000, 0.817295, -0.000000, 0.025136}, 
%% {0.083703, -0.000000, -0.100682, -0.000000, 8.298816, -0.000000, 0.805094, -0.000000, 0.031596}, 
%% {0.092516, -0.000000, -0.111840, -0.000000, 7.525598, -0.000000, 0.794876, -0.000000, 0.039097}, 
%% {0.102757, -0.000000, -0.123775, -0.000000, 6.858263, -0.000000, 0.790498, -0.000000, 0.047810}, 
%% {0.114415, -0.000000, -0.136250, -0.000000, 6.268561, -0.000000, 0.791252, -0.000000, 0.057747}, 
%% {0.126517, -0.000000, -0.149142, -0.000000, 5.757449, -0.000000, 0.789819, -0.000000, 0.068940}, 
%% {0.140028, -0.000000, -0.162515, -0.000000, 5.295862, -0.000000, 0.791396, -0.000000, 0.081514}, 
%% {0.154089, -0.000000, -0.176506, -0.000000, 4.919530, -0.000000, 0.789500, -0.000000, 0.095642}, 
%% {0.168450, -0.000000, -0.190379, -0.000000, 4.572982, -0.000000, 0.786575, -0.000000, 0.111030}, 
%% {0.187188, -0.000000, -0.204732, -0.000000, 4.239923, -0.000000, 0.797179, -0.000000, 0.128103}, 
%% {0.203597, -0.000000, -0.218783, -0.000000, 3.960788, -0.000000, 0.794276, -0.000000, 0.146478}, 
%% {0.221562, -0.000000, -0.233012, -0.000000, 3.707991, -0.000000, 0.792498, -0.000000, 0.166547}, 
%% {0.242672, -0.000000, -0.246971, -0.000000, 3.465606, -0.000000, 0.797776, -0.000000, 0.188090}, 
%% {0.265406, -0.000000, -0.260830, -0.000000, 3.254231, -0.000000, 0.802511, -0.000000, 0.211325}, 
%% {0.285139, -0.000000, -0.274084, -0.000000, 3.070359, -0.000000, 0.794895, -0.000000, 0.235926}, 
%% {0.309128, -0.000000, -0.287005, -0.000000, 2.896944, -0.000000, 0.794687, -0.000000, 0.262187}, 
%% {0.334545, -0.000000, -0.298694, -0.000000, 2.723984, -0.000000, 0.795951, -0.000000, 0.289345}, 
%% {0.360641, -0.000000, -0.309500, -0.000000, 2.567385, -0.000000, 0.795023, -0.000000, 0.317717}, 
%% {0.381710, -0.000000, -0.319599, -0.000000, 2.438760, -0.000000, 0.779282, -0.000000, 0.347522}, 
%% {0.408669, -0.000000, -0.328422, -0.000000, 2.306207, -0.000000, 0.773755, -0.000000, 0.378181}, 
%% {0.434641, -0.000000, -0.335945, -0.000000, 2.186775, -0.000000, 0.763809, -0.000000, 0.409633}, 
%% {0.462192, -0.000000, -0.341893, -0.000000, 2.073844, -0.000000, 0.755024, -0.000000, 0.441494}, 
%% {0.488974, -0.000000, -0.346217, -0.000000, 1.963048, -0.000000, 0.743444, -0.000000, 0.473606}, 
%% {0.515971, -0.000000, -0.349369, -0.000000, 1.866663, -0.000000, 0.728813, -0.000000, 0.506515}, 
%% {0.542510, -0.000000, -0.350305, -0.000000, 1.767920, -0.000000, 0.714529, -0.000000, 0.538620}, 
%% {0.559812, -0.000000, -0.350300, -0.000000, 1.683154, -0.000000, 0.684432, -0.000000, 0.571719}, 
%% {0.585521, -0.000000, -0.348167, -0.000000, 1.600271, -0.000000, 0.666271, -0.000000, 0.603817}, 
%% {0.608950, -0.000000, -0.344386, -0.000000, 1.521459, -0.000000, 0.644537, -0.000000, 0.635489}, 
%% {0.631102, -0.000000, -0.338878, -0.000000, 1.445124, -0.000000, 0.621274, -0.000000, 0.666399}, 
%% {0.653383, -0.000000, -0.331968, -0.000000, 1.377725, -0.000000, 0.596404, -0.000000, 0.696981}, 
%% {0.671962, -0.000000, -0.323414, -0.000000, 1.311303, -0.000000, 0.568168, -0.000000, 0.726542}, 
%% {0.693652, -0.000000, -0.313228, -0.000000, 1.249885, -0.000000, 0.542934, -0.000000, 0.754831}, 
%% {0.696391, -0.000000, -0.301709, -0.000000, 1.186870, -0.000000, 0.502560, -0.000000, 0.782267}, 
%% {0.713521, -0.000000, -0.288842, -0.000000, 1.131754, -0.000000, 0.472894, -0.000000, 0.808567}, 
%% {0.722837, -0.000000, -0.274607, -0.000000, 1.077719, -0.000000, 0.438665, -0.000000, 0.833350}, 
%% {0.721460, -0.000000, -0.259308, -0.000000, 1.021393, -0.000000, 0.397283, -0.000000, 0.857208}, 
%% {0.722545, -0.000000, -0.242811, -0.000000, 0.971225, -0.000000, 0.358923, -0.000000, 0.879384}, 
%% {0.715635, -0.000000, -0.225294, -0.000000, 0.918301, -0.000000, 0.317412, -0.000000, 0.900074}, 
%% {0.713915, -0.000000, -0.206700, -0.000000, 0.875191, -0.000000, 0.281295, -0.000000, 0.918557}, 
%% {0.714558, -0.000000, -0.187252, -0.000000, 0.838840, -0.000000, 0.247419, -0.000000, 0.935163}, 
%% {0.702811, -0.000000, -0.167061, -0.000000, 0.801199, -0.000000, 0.211120, -0.000000, 0.949816}, 
%% {0.697294, -0.000000, -0.146246, -0.000000, 0.771206, -0.000000, 0.178968, -0.000000, 0.962464}, 
%% {0.687878, -0.000000, -0.124928, -0.000000, 0.744360, -0.000000, 0.148189, -0.000000, 0.973087}, 
%% {0.675628, -0.000000, -0.103234, -0.000000, 0.718769, -0.000000, 0.119652, -0.000000, 0.981718}, 
%% {0.667656, -0.000000, -0.081323, -0.000000, 0.696489, -0.000000, 0.091604, -0.000000, 0.988842}, 
%% {0.656656, -0.000000, -0.059263, -0.000000, 0.674433, -0.000000, 0.063694, -0.000000, 0.994252}, 
%% {0.644952, -0.000000, -0.037151, -0.000000, 0.653046, -0.000000, 0.035684, -0.000000, 0.997945}, 
%% {0.633595, -0.000000, -0.015079, -0.000000, 0.633131, -0.000000, 0.008296, -0.000000, 0.999803}, 
%% {0.006403, -0.000000, -0.000800, -0.000000, 8.001896, -0.000000, 8.001893, -0.000000, 0.000001}, 
%% {0.006993, -0.000000, -0.000836, -0.000000, 8.362220, -0.000000, 8.362216, -0.000000, 0.000001}, 
%% {0.004639, -0.000000, -0.004302, -0.000000, 43.020798, -0.000000, 1.078224, -0.000000, 0.000019}, 
%% {0.008997, -0.000000, -0.010181, -0.000000, 101.816216, -0.000000, 0.883624, -0.000000, 0.000108}, 
%% {0.012231, -0.000000, -0.014873, -0.000000, 148.762665, -0.000000, 0.822116, -0.000000, 0.000292}, 
%% {0.015523, -0.000000, -0.023562, -0.000000, 235.734589, -0.000000, 0.658334, -0.000000, 0.000737}, 
%% {0.022549, -0.000000, -0.040871, -0.000000, 409.135956, -0.000000, 0.550678, -0.000000, 0.001861}, 
%% {0.029925, -0.000000, -0.054017, -0.000000, 332.525818, -0.000000, 0.552130, -0.000000, 0.003365}, 
%% {0.035104, -0.000000, -0.070796, -0.000000, 283.825836, -0.000000, 0.492976, -0.000000, 0.005773}, 
%% {0.039666, -0.000000, -0.075293, -0.000000, 168.402710, -0.000000, 0.522722, -0.000000, 0.007769}, 
%% {0.020805, -0.000000, -0.032376, -0.000000, 27.370174, -0.000000, 0.639964, -0.000000, 0.004115}, 
%% {0.027693, -0.000000, -0.039697, -0.000000, 22.220295, -0.000000, 0.693374, -0.000000, 0.006080}, 
%% {0.031867, -0.000000, -0.047266, -0.000000, 18.473730, -0.000000, 0.668429, -0.000000, 0.008563}, 
%% {0.064851, -0.000000, -0.081780, -0.000000, 25.070009, -0.000000, 0.779311, -0.000000, 0.017248}, 
%% {0.057910, -0.000000, -0.077793, -0.000000, 18.345633, -0.000000, 0.730382, -0.000000, 0.018842}, 
%% {0.052197, -0.000000, -0.073682, -0.000000, 12.135530, -0.000000, 0.694067, -0.000000, 0.020251}, 
%% {0.059269, -0.000000, -0.083643, -0.000000, 10.758264, -0.000000, 0.690307, -0.000000, 0.025814}, 
%% {0.067057, -0.000000, -0.094264, -0.000000, 9.617655, -0.000000, 0.688351, -0.000000, 0.032370}, 
%% {0.075087, -0.000000, -0.105331, -0.000000, 8.629006, -0.000000, 0.684407, -0.000000, 0.039927}, 
%% {0.087345, -0.000000, -0.117581, -0.000000, 7.737841, -0.000000, 0.706556, -0.000000, 0.048860}, 
%% {0.096721, -0.000000, -0.129839, -0.000000, 7.066104, -0.000000, 0.701135, -0.000000, 0.058792}, 
%% {0.106416, -0.000000, -0.142410, -0.000000, 6.472957, -0.000000, 0.695013, -0.000000, 0.069908}, 
%% {0.121557, -0.000000, -0.156285, -0.000000, 5.923167, -0.000000, 0.713385, -0.000000, 0.082806}, 
%% {0.132549, -0.000000, -0.169656, -0.000000, 5.468420, -0.000000, 0.705762, -0.000000, 0.096659}, 
%% {0.149797, -0.000000, -0.184257, -0.000000, 5.052396, -0.000000, 0.721500, -0.000000, 0.112523}, 
%% {0.167870, -0.000000, -0.198807, -0.000000, 4.685905, -0.000000, 0.734803, -0.000000, 0.129782}, 
%% {0.181742, -0.000000, -0.212939, -0.000000, 4.373809, -0.000000, 0.726963, -0.000000, 0.148252}, 
%% {0.201033, -0.000000, -0.227295, -0.000000, 4.071901, -0.000000, 0.735477, -0.000000, 0.168443}, 
%% {0.222034, -0.000000, -0.241811, -0.000000, 3.805261, -0.000000, 0.743356, -0.000000, 0.190433}, 
%% {0.244069, -0.000000, -0.255858, -0.000000, 3.556805, -0.000000, 0.749942, -0.000000, 0.213834}, 
%% {0.267048, -0.000000, -0.269463, -0.000000, 3.337135, -0.000000, 0.754456, -0.000000, 0.238724}, 
%% {0.285305, -0.000000, -0.282185, -0.000000, 3.149977, -0.000000, 0.743367, -0.000000, 0.264762}, 
%% {0.315073, -0.000000, -0.294598, -0.000000, 2.950691, -0.000000, 0.756641, -0.000000, 0.292528}, 
%% {0.339522, -0.000000, -0.305567, -0.000000, 2.776516, -0.000000, 0.754514, -0.000000, 0.320943}, 
%% {0.365184, -0.000000, -0.315465, -0.000000, 2.613002, -0.000000, 0.752038, -0.000000, 0.350349}, 
%% {0.391839, -0.000000, -0.324319, -0.000000, 2.462561, -0.000000, 0.748143, -0.000000, 0.380774}, 
%% {0.417121, -0.000000, -0.331977, -0.000000, 2.329137, -0.000000, 0.738760, -0.000000, 0.412037}, 
%% {0.442729, -0.000000, -0.338041, -0.000000, 2.196972, -0.000000, 0.728717, -0.000000, 0.443595}, 
%% {0.469317, -0.000000, -0.343022, -0.000000, 2.081842, -0.000000, 0.716852, -0.000000, 0.476055}, 
%% {0.495295, -0.000000, -0.346050, -0.000000, 1.967926, -0.000000, 0.703981, -0.000000, 0.508146}, 
%% {0.521137, -0.000000, -0.347422, -0.000000, 1.859431, -0.000000, 0.689818, -0.000000, 0.540125}, 
%% {0.546409, -0.000000, -0.347224, -0.000000, 1.758696, -0.000000, 0.673546, -0.000000, 0.571984}, 
%% {0.573187, -0.000000, -0.345437, -0.000000, 1.663544, -0.000000, 0.657833, -0.000000, 0.603551}, 
%% {0.584295, -0.000000, -0.342025, -0.000000, 1.574639, -0.000000, 0.624233, -0.000000, 0.634597}, 
%% {0.607605, -0.000000, -0.337089, -0.000000, 1.491360, -0.000000, 0.603621, -0.000000, 0.665121}, 
%% {0.621849, -0.000000, -0.330513, -0.000000, 1.412060, -0.000000, 0.574438, -0.000000, 0.694686}, 
%% {0.649239, -0.000000, -0.322400, -0.000000, 1.339986, -0.000000, 0.557294, -0.000000, 0.723258}, 
%% {0.660467, -0.000000, -0.313005, -0.000000, 1.266769, -0.000000, 0.525058, -0.000000, 0.751167}, 
%% {0.671218, -0.000000, -0.302134, -0.000000, 1.199147, -0.000000, 0.493813, -0.000000, 0.777721}, 
%% {0.682118, -0.000000, -0.290109, -0.000000, 1.133990, -0.000000, 0.462134, -0.000000, 0.803452}, 
%% {0.685600, -0.000000, -0.276843, -0.000000, 1.068891, -0.000000, 0.426280, -0.000000, 0.827869}, 
%% {0.684085, -0.000000, -0.262560, -0.000000, 1.003417, -0.000000, 0.387322, -0.000000, 0.851341}, 
%% {0.703745, -0.000000, -0.247071, -0.000000, 0.961917, -0.000000, 0.361928, -0.000000, 0.872934}, 
%% {0.675774, -0.000000, -0.230574, -0.000000, 0.885134, -0.000000, 0.313978, -0.000000, 0.892871}, 
%% {0.682253, -0.000000, -0.213347, -0.000000, 0.847237, -0.000000, 0.281926, -0.000000, 0.911839}, 
%% {0.680230, -0.000000, -0.195182, -0.000000, 0.807169, -0.000000, 0.249027, -0.000000, 0.928546}, 
%% {0.664784, -0.000000, -0.176290, -0.000000, 0.765911, -0.000000, 0.213747, -0.000000, 0.943318}, 
%% {0.689288, -0.000000, -0.156986, -0.000000, 0.751280, -0.000000, 0.187367, -0.000000, 0.957327}, 
%% {0.661105, -0.000000, -0.136960, -0.000000, 0.712189, -0.000000, 0.153931, -0.000000, 0.968111}, 
%% {0.663526, -0.000000, -0.116628, -0.000000, 0.691285, -0.000000, 0.128252, -0.000000, 0.977457}, 
%% {0.638408, -0.000000, -0.096032, -0.000000, 0.661897, -0.000000, 0.099689, -0.000000, 0.985004}, 
%% {0.634258, -0.000000, -0.075317, -0.000000, 0.642522, -0.000000, 0.072855, -0.000000, 0.991349}, 
%% {0.608298, -0.000000, -0.054506, -0.000000, 0.616506, -0.000000, 0.046720, -0.000000, 0.995814}, 
%% {0.597864, -0.000000, -0.033718, -0.000000, 0.597391, -0.000000, 0.019545, -0.000000, 0.998898}
%% ].

tabAmplitude() -> %% [size*size] = {
[1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999995, 
0.999990, 
0.999971, 
0.999937, 
0.999853, 
0.999670, 
0.999138, 
0.996746, 
0.979578, 
0.979309, 
0.978836, 
0.977972, 
0.976223, 
0.972205, 
0.962466, 
0.953919, 
0.949829, 
0.942492, 
0.929870, 
0.921319, 
0.911112, 
0.896015, 
0.885105, 
0.869971, 
0.855017, 
0.838328, 
0.821241, 
0.802352, 
0.783873, 
0.763309, 
0.743058, 
0.721929, 
0.699755, 
0.677721, 
0.655456, 
0.632681, 
0.609629, 
0.586831, 
0.564287, 
0.541772, 
0.519428, 
0.497353, 
0.475624, 
0.454606, 
0.434099, 
0.414085, 
0.394605, 
0.375698, 
0.357386, 
0.339871, 
0.323085, 
0.306905, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999999, 
0.999998, 
0.999995, 
0.999990, 
0.999980, 
0.999959, 
0.999923, 
0.999842, 
0.999660, 
0.999119, 
0.996613, 
0.981824, 
0.979298, 
0.978826, 
0.977957, 
0.976184, 
0.972091, 
0.962188, 
0.953875, 
0.949746, 
0.942335, 
0.930166, 
0.921211, 
0.910927, 
0.896979, 
0.884940, 
0.869864, 
0.854835, 
0.838200, 
0.821049, 
0.802552, 
0.783659, 
0.763512, 
0.742927, 
0.721715, 
0.699938, 
0.677775, 
0.655246, 
0.632555, 
0.609805, 
0.586996, 
0.564225, 
0.541606, 
0.519346, 
0.497419, 
0.475863, 
0.454738, 
0.434099, 
0.414003, 
0.394547, 
0.375747, 
0.357564, 
0.340012, 
0.323099, 
0.306861, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999995, 
0.999991, 
0.999979, 
0.999959, 
0.999917, 
0.999839, 
0.999648, 
0.999074, 
0.996168, 
0.983770, 
0.979279, 
0.978800, 
0.977905, 
0.976058, 
0.971727, 
0.962120, 
0.953901, 
0.949485, 
0.941859, 
0.930911, 
0.920853, 
0.910394, 
0.897600, 
0.884427, 
0.870101, 
0.854522, 
0.838325, 
0.820754, 
0.802707, 
0.783223, 
0.763605, 
0.742872, 
0.721565, 
0.699935, 
0.677726, 
0.655242, 
0.632580, 
0.609766, 
0.586946, 
0.564275, 
0.541759, 
0.519467, 
0.497478, 
0.475886, 
0.454794, 
0.434233, 
0.414207, 
0.394751, 
0.375892, 
0.357683, 
0.340146, 
0.323287, 
0.307095, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999999, 
0.999998, 
0.999996, 
0.999992, 
0.999987, 
0.999975, 
0.999953, 
0.999913, 
0.999830, 
0.999630, 
0.998993, 
0.995279, 
0.985142, 
0.979252, 
0.978754, 
0.977821, 
0.975838, 
0.971088, 
0.962563, 
0.954785, 
0.949048, 
0.941052, 
0.931420, 
0.920812, 
0.909750, 
0.897867, 
0.883856, 
0.870091, 
0.854353, 
0.838166, 
0.820661, 
0.802465, 
0.783308, 
0.763346, 
0.742734, 
0.721608, 
0.699747, 
0.677626, 
0.655245, 
0.632547, 
0.609793, 
0.587044, 
0.564340, 
0.541779, 
0.519529, 
0.497633, 
0.476114, 
0.455030, 
0.434430, 
0.414406, 
0.394974, 
0.376154, 
0.357979, 
0.340443, 
0.323572, 
0.307379, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999998, 
0.999998, 
0.999996, 
0.999991, 
0.999984, 
0.999970, 
0.999946, 
0.999905, 
0.999815, 
0.999599, 
0.998856, 
0.993704, 
0.986135, 
0.979212, 
0.978690, 
0.977691, 
0.975504, 
0.970133, 
0.962951, 
0.955649, 
0.948405, 
0.940418, 
0.931660, 
0.920881, 
0.909376, 
0.897785, 
0.883844, 
0.869756, 
0.854326, 
0.837732, 
0.820617, 
0.802053, 
0.783195, 
0.763119, 
0.742610, 
0.721344, 
0.699709, 
0.677624, 
0.655114, 
0.632523, 
0.609812, 
0.587052, 
0.564417, 
0.541966, 
0.519751, 
0.497824, 
0.476309, 
0.455271, 
0.434735, 
0.414736, 
0.395317, 
0.376524, 
0.358364, 
0.340852, 
0.323988, 
0.307786, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999999, 
0.999997, 
0.999996, 
0.999994, 
0.999989, 
0.999980, 
0.999965, 
0.999940, 
0.999895, 
0.999796, 
0.999559, 
0.998638, 
0.992774, 
0.986878, 
0.980297, 
0.978602, 
0.977514, 
0.975026, 
0.969169, 
0.963214, 
0.956267, 
0.947689, 
0.940054, 
0.931637, 
0.920678, 
0.908990, 
0.897349, 
0.883905, 
0.869139, 
0.854177, 
0.837476, 
0.820295, 
0.801977, 
0.782798, 
0.762978, 
0.742418, 
0.721193, 
0.699560, 
0.677402, 
0.655108, 
0.632543, 
0.609804, 
0.587158, 
0.564557, 
0.542096, 
0.519908, 
0.498088, 
0.476632, 
0.455623, 
0.435104, 
0.415161, 
0.395783, 
0.377005, 
0.358843, 
0.341345, 
0.324529, 
0.308355, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999999, 
0.999998, 
0.999997, 
0.999992, 
0.999991, 
0.999985, 
0.999977, 
0.999959, 
0.999935, 
0.999878, 
0.999773, 
0.999505, 
0.998284, 
0.992353, 
0.987457, 
0.981665, 
0.978492, 
0.977277, 
0.974360, 
0.968716, 
0.963373, 
0.956629, 
0.947397, 
0.939657, 
0.931339, 
0.920588, 
0.908975, 
0.896712, 
0.883763, 
0.868890, 
0.853731, 
0.837333, 
0.819702, 
0.801738, 
0.782454, 
0.762712, 
0.742024, 
0.721037, 
0.699325, 
0.677359, 
0.655030, 
0.632439, 
0.609869, 
0.587221, 
0.564663, 
0.542328, 
0.520220, 
0.498400, 
0.476997, 
0.456053, 
0.435593, 
0.415658, 
0.396300, 
0.377577, 
0.359473, 
0.342004, 
0.325170, 
0.308997, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999998, 
0.999996, 
0.999993, 
0.999988, 
0.999981, 
0.999971, 
0.999951, 
0.999921, 
0.999863, 
0.999748, 
0.999433, 
0.997681, 
0.992120, 
0.987920, 
0.982864, 
0.978353, 
0.976961, 
0.973451, 
0.968396, 
0.963400, 
0.956680, 
0.947529, 
0.939151, 
0.930747, 
0.920511, 
0.908867, 
0.896142, 
0.883335, 
0.868764, 
0.853025, 
0.837015, 
0.819452, 
0.801249, 
0.782176, 
0.762345, 
0.741843, 
0.720721, 
0.699135, 
0.677194, 
0.654889, 
0.632487, 
0.609902, 
0.587328, 
0.564891, 
0.542567, 
0.520501, 
0.498793, 
0.477442, 
0.456528, 
0.436131, 
0.416273, 
0.396980, 
0.378276, 
0.360176, 
0.342738, 
0.325950, 
0.309803, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999999, 
0.999997, 
0.999995, 
0.999991, 
0.999985, 
0.999978, 
0.999963, 
0.999942, 
0.999907, 
0.999844, 
0.999715, 
0.999332, 
0.996612, 
0.991974, 
0.988297, 
0.983843, 
0.978349, 
0.976540, 
0.972351, 
0.968109, 
0.963280, 
0.956464, 
0.947779, 
0.938754, 
0.929952, 
0.920253, 
0.908530, 
0.895785, 
0.882679, 
0.868456, 
0.852669, 
0.836406, 
0.819138, 
0.800708, 
0.781803, 
0.761855, 
0.741534, 
0.720405, 
0.698959, 
0.676964, 
0.654827, 
0.632411, 
0.609922, 
0.587477, 
0.565051, 
0.542829, 
0.520889, 
0.499225, 
0.477951, 
0.457148, 
0.436792, 
0.416963, 
0.397723, 
0.379068, 
0.361025, 
0.343608, 
0.326842, 
0.310718, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999995, 
0.999994, 
0.999990, 
0.999983, 
0.999971, 
0.999954, 
0.999932, 
0.999892, 
0.999820, 
0.999675, 
0.999190, 
0.995492, 
0.991911, 
0.988610, 
0.984662, 
0.979221, 
0.975975, 
0.971671, 
0.967788, 
0.963002, 
0.955938, 
0.947965, 
0.938692, 
0.929309, 
0.919781, 
0.908268, 
0.895518, 
0.882022, 
0.867884, 
0.852346, 
0.835746, 
0.818607, 
0.800261, 
0.781335, 
0.761539, 
0.741063, 
0.720116, 
0.698617, 
0.676815, 
0.654700, 
0.632389, 
0.610037, 
0.587591, 
0.565328, 
0.543205, 
0.521293, 
0.499745, 
0.478562, 
0.457776, 
0.437515, 
0.417776, 
0.398586, 
0.379963, 
0.361984, 
0.344616, 
0.327857, 
0.311751, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999997, 
0.999996, 
0.999992, 
0.999986, 
0.999977, 
0.999965, 
0.999947, 
0.999916, 
0.999873, 
0.999794, 
0.999628, 
0.998966, 
0.994914, 
0.991849, 
0.988873, 
0.985288, 
0.980170, 
0.975207, 
0.971156, 
0.967476, 
0.962538, 
0.955601, 
0.947978, 
0.938542, 
0.928618, 
0.919056, 
0.907890, 
0.895098, 
0.881352, 
0.867263, 
0.851806, 
0.835168, 
0.818003, 
0.799785, 
0.780633, 
0.761080, 
0.740618, 
0.719795, 
0.698332, 
0.676629, 
0.654544, 
0.632411, 
0.610042, 
0.587805, 
0.565593, 
0.543549, 
0.521793, 
0.500309, 
0.479195, 
0.458546, 
0.438353, 
0.418669, 
0.399557, 
0.381012, 
0.363049, 
0.345710, 
0.329006, 
0.312948, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999997, 
0.999993, 
0.999990, 
0.999984, 
0.999972, 
0.999960, 
0.999939, 
0.999906, 
0.999853, 
0.999765, 
0.999567, 
0.998603, 
0.994519, 
0.991794, 
0.989089, 
0.985781, 
0.980956, 
0.974161, 
0.970688, 
0.967064, 
0.961890, 
0.955292, 
0.947848, 
0.938359, 
0.928226, 
0.918214, 
0.907361, 
0.894702, 
0.880834, 
0.866500, 
0.851209, 
0.834627, 
0.817211, 
0.799250, 
0.780131, 
0.760512, 
0.740218, 
0.719264, 
0.698063, 
0.676325, 
0.654450, 
0.632316, 
0.610170, 
0.587988, 
0.565891, 
0.544013, 
0.522305, 
0.500958, 
0.479971, 
0.459376, 
0.439271, 
0.419699, 
0.400620, 
0.382126, 
0.364246, 
0.346967, 
0.330273, 
0.314236, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999996, 
0.999994, 
0.999988, 
0.999979, 
0.999967, 
0.999952, 
0.999924, 
0.999888, 
0.999833, 
0.999733, 
0.999490, 
0.997946, 
0.994192, 
0.991812, 
0.989274, 
0.986224, 
0.981547, 
0.974000, 
0.970269, 
0.966545, 
0.961031, 
0.954921, 
0.947416, 
0.938226, 
0.928003, 
0.917390, 
0.906553, 
0.894191, 
0.880329, 
0.865540, 
0.850476, 
0.834058, 
0.816467, 
0.798509, 
0.779561, 
0.759828, 
0.739738, 
0.718878, 
0.697718, 
0.676138, 
0.654342, 
0.632317, 
0.610292, 
0.588207, 
0.566289, 
0.544443, 
0.522927, 
0.501674, 
0.480765, 
0.460314, 
0.440304, 
0.420782, 
0.401824, 
0.383410, 
0.365538, 
0.348312, 
0.331692, 
0.315688, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999996, 
0.999993, 
0.999985, 
0.999976, 
0.999961, 
0.999943, 
0.999913, 
0.999872, 
0.999807, 
0.999691, 
0.999390, 
0.996859, 
0.994003, 
0.991808, 
0.989423, 
0.986523, 
0.981783, 
0.974511, 
0.969791, 
0.965933, 
0.960377, 
0.954434, 
0.946803, 
0.938026, 
0.927620, 
0.916545, 
0.905639, 
0.893489, 
0.879820, 
0.864852, 
0.849513, 
0.833311, 
0.815878, 
0.797621, 
0.778938, 
0.759253, 
0.739142, 
0.718479, 
0.697274, 
0.675902, 
0.654135, 
0.632357, 
0.610364, 
0.588497, 
0.566631, 
0.545012, 
0.523579, 
0.502429, 
0.481680, 
0.461304, 
0.441425, 
0.422039, 
0.403135, 
0.384779, 
0.366976, 
0.349796, 
0.333231, 
0.317277, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999996, 
0.999991, 
0.999983, 
0.999974, 
0.999956, 
0.999932, 
0.999901, 
0.999852, 
0.999780, 
0.999646, 
0.999248, 
0.996193, 
0.993784, 
0.991782, 
0.989539, 
0.986694, 
0.981765, 
0.975135, 
0.969309, 
0.965128, 
0.959788, 
0.953831, 
0.946255, 
0.937664, 
0.927351, 
0.916044, 
0.904715, 
0.892528, 
0.879111, 
0.864256, 
0.848452, 
0.832434, 
0.815129, 
0.796806, 
0.778118, 
0.758668, 
0.738466, 
0.718024, 
0.696958, 
0.675642, 
0.654067, 
0.632325, 
0.610546, 
0.588786, 
0.567123, 
0.545617, 
0.524312, 
0.503348, 
0.482637, 
0.462418, 
0.442657, 
0.423338, 
0.404564, 
0.386277, 
0.368545, 
0.351448, 
0.334906, 
0.318961, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999999, 
0.999998, 
0.999994, 
0.999989, 
0.999979, 
0.999968, 
0.999949, 
0.999921, 
0.999886, 
0.999833, 
0.999747, 
0.999596, 
0.999029, 
0.995749, 
0.993677, 
0.991724, 
0.989620, 
0.986723, 
0.981515, 
0.975767, 
0.969056, 
0.964124, 
0.959142, 
0.953036, 
0.945650, 
0.937022, 
0.926971, 
0.915515, 
0.903584, 
0.891603, 
0.878212, 
0.863472, 
0.847652, 
0.831398, 
0.814299, 
0.796105, 
0.777231, 
0.757977, 
0.737895, 
0.717415, 
0.696595, 
0.675317, 
0.653980, 
0.632343, 
0.610735, 
0.589076, 
0.567620, 
0.546251, 
0.525165, 
0.504255, 
0.483759, 
0.463666, 
0.443987, 
0.424783, 
0.406042, 
0.387891, 
0.370293, 
0.353221, 
0.336715, 
0.320806, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999998, 
0.999993, 
0.999987, 
0.999977, 
0.999964, 
0.999943, 
0.999911, 
0.999867, 
0.999807, 
0.999714, 
0.999531, 
0.998645, 
0.995399, 
0.993512, 
0.991717, 
0.989661, 
0.986652, 
0.981559, 
0.976183, 
0.969411, 
0.963317, 
0.958457, 
0.952091, 
0.944951, 
0.936307, 
0.926454, 
0.915043, 
0.902668, 
0.890462, 
0.877245, 
0.862672, 
0.846823, 
0.830201, 
0.813293, 
0.795306, 
0.776393, 
0.757199, 
0.737324, 
0.716808, 
0.696187, 
0.675094, 
0.653814, 
0.632453, 
0.610885, 
0.589483, 
0.568099, 
0.546975, 
0.525953, 
0.505268, 
0.484936, 
0.464988, 
0.445458, 
0.426314, 
0.407750, 
0.389670, 
0.372098, 
0.355105, 
0.338682, 
0.322825, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999996, 
0.999992, 
0.999983, 
0.999976, 
0.999959, 
0.999933, 
0.999898, 
0.999849, 
0.999780, 
0.999676, 
0.999454, 
0.997884, 
0.995166, 
0.993394, 
0.991723, 
0.989654, 
0.986389, 
0.981632, 
0.976607, 
0.969701, 
0.962555, 
0.957605, 
0.951232, 
0.944099, 
0.935556, 
0.925699, 
0.914492, 
0.902027, 
0.889116, 
0.876093, 
0.861649, 
0.845956, 
0.829238, 
0.812220, 
0.794420, 
0.775657, 
0.756265, 
0.736673, 
0.716372, 
0.695669, 
0.674886, 
0.653728, 
0.632568, 
0.611217, 
0.589929, 
0.568783, 
0.547752, 
0.526931, 
0.506425, 
0.486238, 
0.466425, 
0.446945, 
0.428026, 
0.409536, 
0.391551, 
0.374087, 
0.357155, 
0.340787, 
0.324974, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999998, 
0.999996, 
0.999990, 
0.999984, 
0.999970, 
0.999952, 
0.999925, 
0.999886, 
0.999831, 
0.999757, 
0.999633, 
0.999356, 
0.997017, 
0.994868, 
0.993337, 
0.991710, 
0.989580, 
0.985848, 
0.981640, 
0.976711, 
0.969755, 
0.962166, 
0.956609, 
0.950365, 
0.943026, 
0.934693, 
0.924880, 
0.913729, 
0.901350, 
0.887966, 
0.874726, 
0.860474, 
0.844905, 
0.828269, 
0.810905, 
0.793364, 
0.774812, 
0.755478, 
0.735886, 
0.715847, 
0.695231, 
0.674537, 
0.653667, 
0.632527, 
0.611475, 
0.590363, 
0.569462, 
0.548571, 
0.527976, 
0.507634, 
0.487632, 
0.467901, 
0.448680, 
0.429833, 
0.411467, 
0.393568, 
0.376197, 
0.359374, 
0.343034, 
0.327273, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999993, 
0.999989, 
0.999980, 
0.999965, 
0.999945, 
0.999913, 
0.999869, 
0.999810, 
0.999723, 
0.999583, 
0.999213, 
0.996540, 
0.994740, 
0.993244, 
0.991671, 
0.989411, 
0.985533, 
0.981616, 
0.976847, 
0.969968, 
0.962315, 
0.955468, 
0.949420, 
0.942016, 
0.933617, 
0.923949, 
0.912899, 
0.900495, 
0.887022, 
0.873283, 
0.859153, 
0.843830, 
0.827325, 
0.809888, 
0.792172, 
0.773832, 
0.754686, 
0.735035, 
0.715297, 
0.694955, 
0.674242, 
0.653660, 
0.632752, 
0.611804, 
0.590993, 
0.570154, 
0.549539, 
0.529087, 
0.508974, 
0.489030, 
0.469599, 
0.450466, 
0.431761, 
0.413508, 
0.395761, 
0.378480, 
0.361679, 
0.345465, 
0.329752, 
1.000000, 
1.000000, 
1.000000, 
1.000000, 
0.999997, 
0.999994, 
0.999987, 
0.999978, 
0.999961, 
0.999936, 
0.999903, 
0.999855, 
0.999786, 
0.999689, 
0.999527, 
0.998988, 
0.996137, 
0.994527, 
0.993108, 
0.991599, 
0.989084, 
0.985308, 
0.981527, 
0.976677, 
0.970079, 
0.962535, 
0.954490, 
0.948271, 
0.940942, 
0.932422, 
0.922836, 
0.911896, 
0.899632, 
0.886118, 
0.871864, 
0.857719, 
0.842536, 
0.826163, 
0.808849, 
0.790860, 
0.772802, 
0.753860, 
0.734335, 
0.714582, 
0.694543, 
0.674071, 
0.653544, 
0.632922, 
0.612153, 
0.591573, 
0.570951, 
0.550520, 
0.530352, 
0.510311, 
0.490707, 
0.471359, 
0.452396, 
0.433837, 
0.415736, 
0.398052, 
0.380874, 
0.364232, 
0.348023, 
0.332368, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999994, 
0.999988, 
0.999976, 
0.999957, 
0.999928, 
0.999891, 
0.999837, 
0.999759, 
0.999650, 
0.999463, 
0.998551, 
0.995879, 
0.994366, 
0.992964, 
0.991479, 
0.988521, 
0.985101, 
0.981482, 
0.976168, 
0.970242, 
0.962585, 
0.953950, 
0.946973, 
0.939686, 
0.931248, 
0.921614, 
0.910765, 
0.898617, 
0.885183, 
0.870772, 
0.856138, 
0.841120, 
0.824962, 
0.807732, 
0.789813, 
0.771638, 
0.753008, 
0.733686, 
0.713927, 
0.694082, 
0.673967, 
0.653549, 
0.633135, 
0.612702, 
0.592200, 
0.571904, 
0.551679, 
0.531678, 
0.511898, 
0.492437, 
0.473239, 
0.454451, 
0.436067, 
0.418054, 
0.400542, 
0.383486, 
0.366848, 
0.350781, 
0.335182, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999997, 
0.999993, 
0.999985, 
0.999972, 
0.999951, 
0.999919, 
0.999877, 
0.999817, 
0.999733, 
0.999608, 
0.999380, 
0.997685, 
0.995603, 
0.994264, 
0.992911, 
0.991287, 
0.987923, 
0.984871, 
0.981239, 
0.975933, 
0.970149, 
0.962511, 
0.953824, 
0.945699, 
0.938285, 
0.929907, 
0.920343, 
0.909537, 
0.897435, 
0.884056, 
0.869626, 
0.854490, 
0.839459, 
0.823511, 
0.806511, 
0.788752, 
0.770440, 
0.751995, 
0.732962, 
0.713424, 
0.693525, 
0.673798, 
0.653622, 
0.633301, 
0.613224, 
0.592938, 
0.572833, 
0.552904, 
0.533030, 
0.513556, 
0.494215, 
0.475279, 
0.456673, 
0.438411, 
0.420583, 
0.403178, 
0.386178, 
0.369728, 
0.353688, 
0.338147, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999997, 
0.999991, 
0.999984, 
0.999967, 
0.999944, 
0.999912, 
0.999863, 
0.999796, 
0.999703, 
0.999563, 
0.999279, 
0.997104, 
0.995394, 
0.994111, 
0.992825, 
0.990979, 
0.987529, 
0.984661, 
0.980774, 
0.975758, 
0.969866, 
0.962465, 
0.953678, 
0.944489, 
0.936886, 
0.928356, 
0.918820, 
0.908073, 
0.896092, 
0.882833, 
0.868463, 
0.853212, 
0.837744, 
0.822048, 
0.805333, 
0.787643, 
0.769414, 
0.750830, 
0.732178, 
0.712972, 
0.693227, 
0.673569, 
0.653744, 
0.633739, 
0.613735, 
0.593822, 
0.573916, 
0.554158, 
0.534652, 
0.515248, 
0.496233, 
0.477436, 
0.459009, 
0.440929, 
0.423259, 
0.405951, 
0.389136, 
0.372690, 
0.356789, 
0.341329, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999996, 
0.999991, 
0.999981, 
0.999966, 
0.999939, 
0.999903, 
0.999847, 
0.999771, 
0.999666, 
0.999510, 
0.999131, 
0.996690, 
0.995147, 
0.993882, 
0.992696, 
0.990474, 
0.987227, 
0.984334, 
0.980153, 
0.975438, 
0.969406, 
0.962238, 
0.953598, 
0.943868, 
0.935356, 
0.926721, 
0.917122, 
0.906430, 
0.894550, 
0.881354, 
0.867131, 
0.851954, 
0.835972, 
0.820331, 
0.803911, 
0.786452, 
0.768420, 
0.749821, 
0.731298, 
0.712393, 
0.692979, 
0.673418, 
0.653859, 
0.634232, 
0.614327, 
0.594732, 
0.575131, 
0.555584, 
0.536346, 
0.517175, 
0.498323, 
0.479744, 
0.461485, 
0.443645, 
0.426061, 
0.408969, 
0.392155, 
0.375921, 
0.360060, 
0.344677, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999997, 
0.999991, 
0.999979, 
0.999960, 
0.999931, 
0.999891, 
0.999832, 
0.999748, 
0.999629, 
0.999449, 
0.998880, 
0.996305, 
0.995024, 
0.993812, 
0.992508, 
0.989721, 
0.986936, 
0.983936, 
0.979629, 
0.974979, 
0.968928, 
0.961970, 
0.953291, 
0.943458, 
0.933644, 
0.925007, 
0.915388, 
0.904755, 
0.892932, 
0.879831, 
0.865794, 
0.850672, 
0.834591, 
0.818398, 
0.802304, 
0.785151, 
0.767450, 
0.748987, 
0.730325, 
0.711758, 
0.692761, 
0.673417, 
0.653908, 
0.634686, 
0.615168, 
0.595707, 
0.576393, 
0.557198, 
0.538018, 
0.519253, 
0.500555, 
0.482220, 
0.464197, 
0.446414, 
0.429106, 
0.412035, 
0.395508, 
0.379284, 
0.363538, 
0.348220, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999995, 
0.999989, 
0.999977, 
0.999955, 
0.999924, 
0.999879, 
0.999813, 
0.999722, 
0.999590, 
0.999381, 
0.998335, 
0.996088, 
0.994814, 
0.993709, 
0.992220, 
0.989209, 
0.986575, 
0.983383, 
0.979084, 
0.974272, 
0.968359, 
0.961275, 
0.953025, 
0.943098, 
0.932434, 
0.923101, 
0.913477, 
0.902861, 
0.891059, 
0.878072, 
0.864118, 
0.849188, 
0.833281, 
0.816808, 
0.800596, 
0.783745, 
0.766331, 
0.748123, 
0.729686, 
0.711078, 
0.692527, 
0.673491, 
0.654296, 
0.635113, 
0.616048, 
0.596847, 
0.577720, 
0.558879, 
0.540028, 
0.521371, 
0.502996, 
0.484858, 
0.466997, 
0.449477, 
0.432217, 
0.415426, 
0.398924, 
0.382890, 
0.367206, 
0.351955, 
1.000000, 
1.000000, 
1.000000, 
0.999998, 
0.999996, 
0.999988, 
0.999974, 
0.999953, 
0.999918, 
0.999865, 
0.999791, 
0.999690, 
0.999542, 
0.999293, 
0.997535, 
0.995790, 
0.994609, 
0.993557, 
0.991766, 
0.988767, 
0.986255, 
0.982544, 
0.978541, 
0.973528, 
0.967700, 
0.960596, 
0.952299, 
0.942684, 
0.931653, 
0.921211, 
0.911489, 
0.900818, 
0.889018, 
0.876245, 
0.862406, 
0.847517, 
0.831852, 
0.815367, 
0.798719, 
0.782224, 
0.765167, 
0.747304, 
0.729133, 
0.710485, 
0.692196, 
0.673589, 
0.654770, 
0.635717, 
0.616986, 
0.598119, 
0.579298, 
0.560560, 
0.542163, 
0.523669, 
0.505564, 
0.487642, 
0.469991, 
0.452658, 
0.435620, 
0.418937, 
0.402612, 
0.386633, 
0.371091, 
0.355949, 
1.000000, 
1.000000, 
0.999999, 
0.999998, 
0.999995, 
0.999986, 
0.999973, 
0.999948, 
0.999909, 
0.999852, 
0.999769, 
0.999656, 
0.999490, 
0.999186, 
0.997059, 
0.995624, 
0.994510, 
0.993327, 
0.991020, 
0.988379, 
0.985771, 
0.981971, 
0.978051, 
0.972892, 
0.967020, 
0.959965, 
0.951625, 
0.941902, 
0.930951, 
0.919370, 
0.909285, 
0.898562, 
0.886809, 
0.874251, 
0.860597, 
0.845808, 
0.830365, 
0.813972, 
0.797260, 
0.780597, 
0.763854, 
0.746401, 
0.728519, 
0.710203, 
0.691882, 
0.673687, 
0.655275, 
0.636621, 
0.617909, 
0.599473, 
0.581032, 
0.562560, 
0.544295, 
0.526228, 
0.508293, 
0.490652, 
0.473242, 
0.456004, 
0.439212, 
0.422663, 
0.406476, 
0.390647, 
0.375204, 
0.360129, 
1.000000, 
1.000000, 
1.000000, 
0.999999, 
0.999994, 
0.999984, 
0.999969, 
0.999940, 
0.999898, 
0.999837, 
0.999746, 
0.999617, 
0.999438, 
0.999016, 
0.996703, 
0.995302, 
0.994356, 
0.992993, 
0.990390, 
0.988072, 
0.985152, 
0.981447, 
0.977273, 
0.972234, 
0.966113, 
0.959033, 
0.950869, 
0.941217, 
0.930175, 
0.918279, 
0.906941, 
0.896201, 
0.884509, 
0.871920, 
0.858420, 
0.843906, 
0.828730, 
0.812524, 
0.795978, 
0.778979, 
0.762450, 
0.745459, 
0.727966, 
0.710046, 
0.691808, 
0.673739, 
0.655756, 
0.637574, 
0.619153, 
0.600887, 
0.582796, 
0.564748, 
0.546636, 
0.528904, 
0.511252, 
0.493791, 
0.476563, 
0.459695, 
0.442942, 
0.426632, 
0.410558, 
0.394895, 
0.379517, 
0.364560, 
1.000000, 
1.000000, 
1.000000, 
0.999998, 
0.999994, 
0.999984, 
0.999966, 
0.999934, 
0.999887, 
0.999819, 
0.999720, 
0.999578, 
0.999367, 
0.998696, 
0.996353, 
0.995201, 
0.994115, 
0.992665, 
0.989948, 
0.987633, 
0.984331, 
0.980827, 
0.976390, 
0.971327, 
0.965201, 
0.957977, 
0.949712, 
0.940128, 
0.929187, 
0.917237, 
0.904645, 
0.893711, 
0.882112, 
0.869516, 
0.856236, 
0.841929, 
0.826924, 
0.810991, 
0.794686, 
0.777761, 
0.760980, 
0.744384, 
0.727314, 
0.709877, 
0.691988, 
0.674098, 
0.656243, 
0.638603, 
0.620606, 
0.602574, 
0.584694, 
0.567018, 
0.549311, 
0.531673, 
0.514403, 
0.497148, 
0.480177, 
0.463439, 
0.446998, 
0.430743, 
0.414943, 
0.399304, 
0.384121, 
0.369251, 
1.000000, 
1.000000, 
1.000000, 
0.999997, 
0.999992, 
0.999981, 
0.999962, 
0.999927, 
0.999874, 
0.999798, 
0.999691, 
0.999533, 
0.999291, 
0.997909, 
0.996117, 
0.995029, 
0.993880, 
0.992142, 
0.989576, 
0.987185, 
0.983587, 
0.980055, 
0.975487, 
0.970172, 
0.963998, 
0.956738, 
0.948637, 
0.939083, 
0.928169, 
0.916144, 
0.903147, 
0.890916, 
0.879389, 
0.866895, 
0.853826, 
0.839729, 
0.824957, 
0.809472, 
0.793341, 
0.776743, 
0.759808, 
0.743277, 
0.726643, 
0.709685, 
0.692249, 
0.674639, 
0.657008, 
0.639576, 
0.622114, 
0.604471, 
0.586851, 
0.569340, 
0.552135, 
0.534806, 
0.517599, 
0.500765, 
0.484035, 
0.467440, 
0.451212, 
0.435240, 
0.419399, 
0.404083, 
0.388944, 
0.374182, 
1.000000, 
1.000000, 
1.000000, 
0.999998, 
0.999993, 
0.999979, 
0.999958, 
0.999919, 
0.999861, 
0.999774, 
0.999656, 
0.999482, 
0.999195, 
0.997307, 
0.995837, 
0.994722, 
0.993707, 
0.991391, 
0.989169, 
0.986461, 
0.982904, 
0.979062, 
0.974536, 
0.969035, 
0.962653, 
0.955486, 
0.947243, 
0.937747, 
0.926861, 
0.914936, 
0.901835, 
0.888472, 
0.876571, 
0.864223, 
0.851252, 
0.837374, 
0.822985, 
0.807788, 
0.791927, 
0.775702, 
0.758928, 
0.742347, 
0.725914, 
0.709495, 
0.692569, 
0.675363, 
0.658085, 
0.640639, 
0.623698, 
0.606505, 
0.589267, 
0.572008, 
0.554939, 
0.538132, 
0.521211, 
0.504487, 
0.488048, 
0.471807, 
0.455651, 
0.439858, 
0.424332, 
0.408983, 
0.394071, 
0.379402, 
1.000000, 
1.000000, 
1.000000, 
0.999997, 
0.999992, 
0.999978, 
0.999954, 
0.999913, 
0.999844, 
0.999753, 
0.999618, 
0.999424, 
0.999067, 
0.996875, 
0.995659, 
0.994603, 
0.993420, 
0.990874, 
0.988713, 
0.985585, 
0.982193, 
0.978145, 
0.973416, 
0.967801, 
0.961483, 
0.954069, 
0.945704, 
0.936138, 
0.925374, 
0.913395, 
0.900339, 
0.886675, 
0.873512, 
0.861326, 
0.848513, 
0.834956, 
0.820820, 
0.805943, 
0.790574, 
0.774677, 
0.758279, 
0.741807, 
0.725271, 
0.709231, 
0.692874, 
0.676189, 
0.659352, 
0.642296, 
0.625250, 
0.608700, 
0.591823, 
0.575012, 
0.558143, 
0.541491, 
0.525075, 
0.508558, 
0.492277, 
0.476270, 
0.460459, 
0.444740, 
0.429400, 
0.414309, 
0.399421, 
0.384907, 
1.000000, 
1.000000, 
1.000000, 
0.999997, 
0.999990, 
0.999977, 
0.999947, 
0.999902, 
0.999832, 
0.999730, 
0.999577, 
0.999359, 
0.998845, 
0.996554, 
0.995328, 
0.994442, 
0.992919, 
0.990393, 
0.988170, 
0.984855, 
0.981312, 
0.977149, 
0.972137, 
0.966207, 
0.959967, 
0.952454, 
0.943873, 
0.934434, 
0.923813, 
0.911942, 
0.898928, 
0.885120, 
0.871043, 
0.858248, 
0.845666, 
0.832346, 
0.818482, 
0.804029, 
0.788982, 
0.773571, 
0.757700, 
0.741484, 
0.725186, 
0.708915, 
0.693244, 
0.677028, 
0.660656, 
0.644079, 
0.627377, 
0.610804, 
0.594542, 
0.578112, 
0.561650, 
0.545163, 
0.528962, 
0.512926, 
0.496893, 
0.481007, 
0.465397, 
0.450042, 
0.434740, 
0.419831, 
0.405156, 
0.390692, 
1.000000, 
1.000000, 
0.999999, 
0.999997, 
0.999989, 
0.999973, 
0.999942, 
0.999891, 
0.999813, 
0.999698, 
0.999532, 
0.999285, 
0.998286, 
0.996295, 
0.995215, 
0.994182, 
0.992032, 
0.989855, 
0.987415, 
0.984047, 
0.980050, 
0.976017, 
0.970845, 
0.964767, 
0.958269, 
0.950600, 
0.942033, 
0.932501, 
0.921807, 
0.910017, 
0.897149, 
0.883414, 
0.869182, 
0.855055, 
0.842687, 
0.829548, 
0.816162, 
0.802072, 
0.787436, 
0.772533, 
0.757043, 
0.741263, 
0.725330, 
0.709262, 
0.693497, 
0.678038, 
0.662128, 
0.646068, 
0.629824, 
0.613437, 
0.597334, 
0.581401, 
0.565372, 
0.549288, 
0.533182, 
0.517405, 
0.501765, 
0.486143, 
0.470675, 
0.455465, 
0.440532, 
0.425630, 
0.411113, 
0.396887, 
1.000000, 
1.000000, 
0.999999, 
0.999996, 
0.999989, 
0.999970, 
0.999934, 
0.999879, 
0.999793, 
0.999665, 
0.999481, 
0.999192, 
0.997506, 
0.995926, 
0.995009, 
0.993736, 
0.991298, 
0.989326, 
0.986371, 
0.983199, 
0.979032, 
0.974596, 
0.969364, 
0.963198, 
0.956385, 
0.948509, 
0.939993, 
0.930421, 
0.919590, 
0.908140, 
0.895349, 
0.881699, 
0.867456, 
0.852784, 
0.839500, 
0.826629, 
0.813602, 
0.799983, 
0.785873, 
0.771340, 
0.756480, 
0.741190, 
0.725687, 
0.709997, 
0.694192, 
0.678975, 
0.663673, 
0.648135, 
0.632442, 
0.616477, 
0.600565, 
0.584772, 
0.569202, 
0.553595, 
0.537881, 
0.522193, 
0.506784, 
0.491554, 
0.476349, 
0.461278, 
0.446419, 
0.431913, 
0.417443, 
0.403271, 
1.000000, 
1.000000, 
0.999999, 
0.999995, 
0.999986, 
0.999966, 
0.999927, 
0.999867, 
0.999772, 
0.999629, 
0.999423, 
0.999075, 
0.997024, 
0.995773, 
0.994651, 
0.993353, 
0.990822, 
0.988569, 
0.985596, 
0.982182, 
0.977871, 
0.973140, 
0.967584, 
0.961408, 
0.954294, 
0.946398, 
0.937603, 
0.927937, 
0.917305, 
0.905833, 
0.893138, 
0.879770, 
0.865720, 
0.851023, 
0.836801, 
0.823784, 
0.810909, 
0.797886, 
0.784177, 
0.770243, 
0.755925, 
0.741144, 
0.726214, 
0.710971, 
0.695563, 
0.680212, 
0.665304, 
0.650297, 
0.635168, 
0.619796, 
0.604217, 
0.588692, 
0.573254, 
0.557998, 
0.542839, 
0.527470, 
0.512162, 
0.497115, 
0.482296, 
0.467477, 
0.452812, 
0.438310, 
0.424184, 
0.410163, 
1.000000, 
1.000000, 
0.999999, 
0.999996, 
0.999984, 
0.999962, 
0.999920, 
0.999852, 
0.999745, 
0.999586, 
0.999354, 
0.998894, 
0.996686, 
0.995485, 
0.994493, 
0.992573, 
0.990323, 
0.987772, 
0.984692, 
0.980887, 
0.976446, 
0.971625, 
0.965717, 
0.959421, 
0.951975, 
0.944086, 
0.935066, 
0.925403, 
0.914814, 
0.903208, 
0.890958, 
0.877817, 
0.863828, 
0.849289, 
0.834872, 
0.820889, 
0.808183, 
0.795660, 
0.782556, 
0.769066, 
0.755386, 
0.741229, 
0.726726, 
0.712170, 
0.697209, 
0.682170, 
0.667203, 
0.652689, 
0.637938, 
0.623262, 
0.608190, 
0.593002, 
0.577817, 
0.562737, 
0.547836, 
0.533036, 
0.518052, 
0.503135, 
0.488422, 
0.473986, 
0.459552, 
0.445282, 
0.431149, 
0.417407, 
1.000000, 
1.000000, 
0.999999, 
0.999994, 
0.999983, 
0.999957, 
0.999914, 
0.999835, 
0.999718, 
0.999538, 
0.999275, 
0.998454, 
0.996341, 
0.995246, 
0.994222, 
0.991844, 
0.989829, 
0.986688, 
0.983562, 
0.979638, 
0.974932, 
0.969827, 
0.963621, 
0.957146, 
0.949365, 
0.941398, 
0.932245, 
0.922556, 
0.911949, 
0.900627, 
0.888440, 
0.875544, 
0.862005, 
0.847810, 
0.833372, 
0.819134, 
0.805508, 
0.793339, 
0.780916, 
0.767837, 
0.754858, 
0.741307, 
0.727496, 
0.713386, 
0.699131, 
0.684542, 
0.669878, 
0.655261, 
0.641035, 
0.626685, 
0.612377, 
0.597625, 
0.582805, 
0.568030, 
0.553204, 
0.538684, 
0.524269, 
0.509662, 
0.495119, 
0.480735, 
0.466634, 
0.452593, 
0.438748, 
0.424915, 
1.000000, 
1.000000, 
0.999998, 
0.999994, 
0.999982, 
0.999956, 
0.999901, 
0.999818, 
0.999683, 
0.999487, 
0.999185, 
0.997584, 
0.996004, 
0.995050, 
0.993715, 
0.991212, 
0.989057, 
0.985879, 
0.982243, 
0.978206, 
0.973119, 
0.967919, 
0.961343, 
0.954603, 
0.946712, 
0.938378, 
0.929266, 
0.919443, 
0.908911, 
0.897725, 
0.885589, 
0.873254, 
0.859889, 
0.846123, 
0.832094, 
0.817898, 
0.803866, 
0.791061, 
0.779235, 
0.766885, 
0.754292, 
0.741565, 
0.728331, 
0.714861, 
0.701179, 
0.687166, 
0.673012, 
0.658716, 
0.644442, 
0.630472, 
0.616519, 
0.602514, 
0.588172, 
0.573689, 
0.559281, 
0.544768, 
0.530543, 
0.516485, 
0.502303, 
0.488100, 
0.474095, 
0.460245, 
0.446598, 
0.433169, 
1.000000, 
1.000000, 
0.999997, 
0.999993, 
0.999980, 
0.999947, 
0.999891, 
0.999794, 
0.999647, 
0.999425, 
0.999062, 
0.997049, 
0.995778, 
0.994652, 
0.992778, 
0.990482, 
0.988004, 
0.984893, 
0.980881, 
0.976605, 
0.971199, 
0.965610, 
0.958925, 
0.951746, 
0.943791, 
0.935200, 
0.926018, 
0.916028, 
0.905724, 
0.894528, 
0.882914, 
0.870740, 
0.857802, 
0.844552, 
0.830857, 
0.816921, 
0.803102, 
0.789625, 
0.777480, 
0.765891, 
0.753908, 
0.741795, 
0.729390, 
0.716440, 
0.703411, 
0.690068, 
0.676438, 
0.662586, 
0.648697, 
0.634732, 
0.620997, 
0.607451, 
0.593765, 
0.579748, 
0.565661, 
0.551594, 
0.537396, 
0.523433, 
0.509708, 
0.495972, 
0.482082, 
0.468427, 
0.454890, 
0.441623, 
1.000000, 
1.000000, 
0.999999, 
0.999991, 
0.999977, 
0.999940, 
0.999875, 
0.999769, 
0.999605, 
0.999352, 
0.998882, 
0.996665, 
0.995459, 
0.994380, 
0.992014, 
0.989912, 
0.986796, 
0.983537, 
0.979326, 
0.974792, 
0.969140, 
0.963160, 
0.956222, 
0.948807, 
0.940518, 
0.931755, 
0.922452, 
0.912319, 
0.902227, 
0.891142, 
0.879838, 
0.868047, 
0.855745, 
0.842718, 
0.829827, 
0.816398, 
0.802786, 
0.789396, 
0.776581, 
0.764901, 
0.753710, 
0.742102, 
0.730448, 
0.718337, 
0.705768, 
0.693172, 
0.680153, 
0.666882, 
0.653401, 
0.639837, 
0.626152, 
0.612676, 
0.599435, 
0.586109, 
0.572473, 
0.558715, 
0.544964, 
0.531112, 
0.517416, 
0.503992, 
0.490653, 
0.477162, 
0.463832, 
0.450645, 
1.000000, 
1.000000, 
0.999999, 
0.999992, 
0.999973, 
0.999933, 
0.999861, 
0.999741, 
0.999554, 
0.999267, 
0.998411, 
0.996303, 
0.995191, 
0.993945, 
0.991406, 
0.989019, 
0.985720, 
0.982057, 
0.977501, 
0.972605, 
0.966697, 
0.960340, 
0.953031, 
0.945347, 
0.936866, 
0.927917, 
0.918562, 
0.908598, 
0.898486, 
0.887794, 
0.876545, 
0.865379, 
0.853428, 
0.841167, 
0.828649, 
0.815967, 
0.802957, 
0.789865, 
0.777077, 
0.764695, 
0.753544, 
0.742694, 
0.731571, 
0.720304, 
0.708490, 
0.696351, 
0.684134, 
0.671470, 
0.658541, 
0.645376, 
0.632209, 
0.618776, 
0.605511, 
0.592527, 
0.579546, 
0.566310, 
0.552860, 
0.539492, 
0.526005, 
0.512564, 
0.499340, 
0.486360, 
0.473357, 
0.460306, 
1.000000, 
1.000000, 
0.999998, 
0.999991, 
0.999970, 
0.999926, 
0.999842, 
0.999710, 
0.999498, 
0.999164, 
0.997464, 
0.995870, 
0.994917, 
0.992911, 
0.990682, 
0.987816, 
0.984410, 
0.980551, 
0.975693, 
0.970263, 
0.963946, 
0.957248, 
0.949765, 
0.941571, 
0.932941, 
0.923873, 
0.914332, 
0.904560, 
0.894394, 
0.884127, 
0.873294, 
0.862503, 
0.851335, 
0.839566, 
0.827776, 
0.815708, 
0.803370, 
0.790821, 
0.778386, 
0.766121, 
0.754193, 
0.743420, 
0.732975, 
0.722326, 
0.711376, 
0.699992, 
0.688180, 
0.676354, 
0.664004, 
0.651449, 
0.638600, 
0.625776, 
0.612660, 
0.599603, 
0.586719, 
0.574078, 
0.561273, 
0.548129, 
0.535155, 
0.522015, 
0.508851, 
0.495837, 
0.483190, 
0.470624, 
1.000000, 
1.000000, 
0.999998, 
0.999988, 
0.999965, 
0.999916, 
0.999823, 
0.999669, 
0.999425, 
0.999025, 
0.996874, 
0.995670, 
0.994415, 
0.991991, 
0.989766, 
0.986646, 
0.982812, 
0.978356, 
0.973317, 
0.967612, 
0.960820, 
0.953603, 
0.945969, 
0.937323, 
0.928661, 
0.919507, 
0.909833, 
0.900245, 
0.890390, 
0.880252, 
0.870000, 
0.859518, 
0.849163, 
0.838101, 
0.826960, 
0.815688, 
0.804126, 
0.792234, 
0.780356, 
0.768474, 
0.756678, 
0.745159, 
0.734601, 
0.724624, 
0.714339, 
0.703751, 
0.692766, 
0.681267, 
0.669799, 
0.657871, 
0.645577, 
0.633102, 
0.620560, 
0.607737, 
0.594890, 
0.582143, 
0.569779, 
0.557360, 
0.544651, 
0.531942, 
0.519228, 
0.506467, 
0.493710, 
0.481143, 
1.000000, 
1.000000, 
0.999998, 
0.999988, 
0.999961, 
0.999902, 
0.999798, 
0.999622, 
0.999341, 
0.998801, 
0.996397, 
0.995225, 
0.993927, 
0.991338, 
0.988500, 
0.985327, 
0.981195, 
0.976383, 
0.970726, 
0.964471, 
0.957386, 
0.949813, 
0.941694, 
0.932681, 
0.923974, 
0.914755, 
0.905026, 
0.895649, 
0.886178, 
0.876277, 
0.866629, 
0.856890, 
0.846934, 
0.836887, 
0.826373, 
0.815885, 
0.805169, 
0.794133, 
0.782812, 
0.771547, 
0.760175, 
0.748896, 
0.737687, 
0.727152, 
0.717601, 
0.707670, 
0.697425, 
0.686788, 
0.675664, 
0.664513, 
0.652962, 
0.640965, 
0.628851, 
0.616551, 
0.604168, 
0.591559, 
0.579009, 
0.566648, 
0.554597, 
0.542382, 
0.529999, 
0.517655, 
0.505254, 
0.492894, 
1.000000, 
1.000000, 
0.999997, 
0.999986, 
0.999956, 
0.999889, 
0.999766, 
0.999562, 
0.999240, 
0.997952, 
0.996094, 
0.994979, 
0.992773, 
0.990536, 
0.987214, 
0.983322, 
0.978938, 
0.973714, 
0.967681, 
0.960981, 
0.953144, 
0.945475, 
0.936909, 
0.927734, 
0.918826, 
0.909590, 
0.900085, 
0.890867, 
0.881801, 
0.872565, 
0.863236, 
0.854239, 
0.845060, 
0.835686, 
0.826251, 
0.816284, 
0.806586, 
0.796419, 
0.785914, 
0.775210, 
0.764461, 
0.753599, 
0.742805, 
0.731872, 
0.721370, 
0.711898, 
0.702337, 
0.692383, 
0.682137, 
0.671365, 
0.660479, 
0.649314, 
0.637685, 
0.625899, 
0.613898, 
0.601865, 
0.589582, 
0.577285, 
0.565013, 
0.553106, 
0.541280, 
0.529367, 
0.517320, 
0.505411, 
1.000000, 
1.000000, 
0.999997, 
0.999983, 
0.999948, 
0.999869, 
0.999732, 
0.999499, 
0.999111, 
0.997167, 
0.995720, 
0.994349, 
0.991727, 
0.989197, 
0.985883, 
0.981483, 
0.976618, 
0.970597, 
0.964122, 
0.956994, 
0.948639, 
0.940500, 
0.931606, 
0.922385, 
0.913291, 
0.904205, 
0.894938, 
0.885890, 
0.877334, 
0.868754, 
0.860053, 
0.851683, 
0.843447, 
0.834889, 
0.826304, 
0.817441, 
0.808285, 
0.799141, 
0.789570, 
0.779600, 
0.769510, 
0.759155, 
0.748882, 
0.738346, 
0.727629, 
0.717273, 
0.707467, 
0.698283, 
0.688609, 
0.678748, 
0.668371, 
0.657739, 
0.646951, 
0.635765, 
0.624254, 
0.612647, 
0.600900, 
0.589061, 
0.576998, 
0.564991, 
0.553102, 
0.541517, 
0.530027, 
0.518495, 
1.000000, 
1.000000, 
0.999997, 
0.999983, 
0.999939, 
0.999851, 
0.999684, 
0.999412, 
0.998925, 
0.996597, 
0.995207, 
0.993603, 
0.990903, 
0.987594, 
0.983814, 
0.979016, 
0.973647, 
0.967048, 
0.960109, 
0.952123, 
0.943560, 
0.934900, 
0.925747, 
0.916566, 
0.907305, 
0.898441, 
0.889629, 
0.881042, 
0.872874, 
0.865064, 
0.857225, 
0.849446, 
0.842063, 
0.834561, 
0.826814, 
0.818875, 
0.810748, 
0.802316, 
0.793699, 
0.784704, 
0.775198, 
0.765643, 
0.755735, 
0.745873, 
0.735526, 
0.725229, 
0.714892, 
0.704807, 
0.695502, 
0.686241, 
0.676633, 
0.666688, 
0.656384, 
0.645871, 
0.635174, 
0.624113, 
0.612788, 
0.601426, 
0.589925, 
0.578399, 
0.566612, 
0.554931, 
0.543383, 
0.532065, 
1.000000, 
1.000000, 
0.999996, 
0.999977, 
0.999928, 
0.999824, 
0.999633, 
0.999306, 
0.998429, 
0.996133, 
0.994890, 
0.992316, 
0.989752, 
0.986095, 
0.981564, 
0.976234, 
0.970081, 
0.962779, 
0.955232, 
0.946702, 
0.937716, 
0.928604, 
0.919281, 
0.910167, 
0.901046, 
0.892446, 
0.884183, 
0.876253, 
0.868619, 
0.861545, 
0.854673, 
0.847885, 
0.841074, 
0.834610, 
0.827984, 
0.820945, 
0.813648, 
0.806232, 
0.798444, 
0.790232, 
0.781853, 
0.772897, 
0.763648, 
0.754227, 
0.744542, 
0.734689, 
0.724526, 
0.714204, 
0.704152, 
0.694222, 
0.685143, 
0.675860, 
0.666319, 
0.656415, 
0.646273, 
0.635902, 
0.625399, 
0.614563, 
0.603490, 
0.592413, 
0.581217, 
0.570000, 
0.558608, 
0.547242, 
1.000000, 
0.999999, 
0.999995, 
0.999972, 
0.999915, 
0.999790, 
0.999562, 
0.999168, 
0.997237, 
0.995672, 
0.994074, 
0.991220, 
0.987792, 
0.983822, 
0.978599, 
0.972804, 
0.965718, 
0.958053, 
0.949460, 
0.940503, 
0.931011, 
0.921608, 
0.912409, 
0.903378, 
0.894606, 
0.886369, 
0.878756, 
0.871573, 
0.864862, 
0.858421, 
0.852541, 
0.846802, 
0.841027, 
0.835206, 
0.829628, 
0.823730, 
0.817415, 
0.810655, 
0.803873, 
0.796659, 
0.788887, 
0.780940, 
0.772537, 
0.763507, 
0.754487, 
0.745163, 
0.735572, 
0.725687, 
0.715611, 
0.705398, 
0.695418, 
0.685592, 
0.676518, 
0.667304, 
0.657875, 
0.648182, 
0.638235, 
0.628062, 
0.617813, 
0.607283, 
0.596552, 
0.585770, 
0.575033, 
0.564153, 
1.000000, 
1.000000, 
0.999995, 
0.999970, 
0.999898, 
0.999748, 
0.999472, 
0.998969, 
0.996528, 
0.995102, 
0.992701, 
0.989963, 
0.985981, 
0.981194, 
0.975183, 
0.968501, 
0.960502, 
0.952012, 
0.942861, 
0.933376, 
0.923506, 
0.914042, 
0.904921, 
0.896282, 
0.887987, 
0.880341, 
0.873536, 
0.867293, 
0.861556, 
0.856148, 
0.850987, 
0.846352, 
0.841684, 
0.836880, 
0.832036, 
0.827091, 
0.821900, 
0.816206, 
0.810042, 
0.803629, 
0.796918, 
0.789653, 
0.781915, 
0.774014, 
0.765530, 
0.756526, 
0.747669, 
0.738342, 
0.728770, 
0.718942, 
0.708942, 
0.698855, 
0.688933, 
0.679131, 
0.669855, 
0.660811, 
0.651549, 
0.642127, 
0.632454, 
0.622651, 
0.612709, 
0.602606, 
0.592344, 
0.581877, 
1.000000, 
0.999999, 
0.999993, 
0.999963, 
0.999874, 
0.999691, 
0.999350, 
0.998431, 
0.995873, 
0.994456, 
0.991327, 
0.987798, 
0.983232, 
0.977500, 
0.970828, 
0.962815, 
0.954228, 
0.944752, 
0.935126, 
0.925179, 
0.915102, 
0.905763, 
0.897087, 
0.888933, 
0.881452, 
0.874687, 
0.868716, 
0.863585, 
0.858931, 
0.854662, 
0.850569, 
0.846719, 
0.843151, 
0.839426, 
0.835588, 
0.831443, 
0.827004, 
0.822395, 
0.817254, 
0.811630, 
0.805464, 
0.799124, 
0.792382, 
0.785091, 
0.777315, 
0.769360, 
0.760908, 
0.751957, 
0.743128, 
0.733917, 
0.724340, 
0.714713, 
0.704721, 
0.694835, 
0.684862, 
0.675099, 
0.665570, 
0.656644, 
0.647651, 
0.638581, 
0.629337, 
0.619926, 
0.610358, 
0.600707, 
1.000000, 
1.000000, 
0.999990, 
0.999953, 
0.999843, 
0.999613, 
0.999186, 
0.997025, 
0.995317, 
0.992850, 
0.989760, 
0.985270, 
0.979807, 
0.973049, 
0.965228, 
0.956248, 
0.946394, 
0.936324, 
0.926124, 
0.915808, 
0.905942, 
0.897060, 
0.889001, 
0.881755, 
0.875351, 
0.869688, 
0.864736, 
0.860745, 
0.857305, 
0.854190, 
0.851261, 
0.848484, 
0.845642, 
0.842948, 
0.840060, 
0.836901, 
0.833379, 
0.829393, 
0.825103, 
0.820431, 
0.815288, 
0.809575, 
0.803326, 
0.796949, 
0.790174, 
0.782873, 
0.775048, 
0.767139, 
0.758772, 
0.750019, 
0.741120, 
0.732127, 
0.722743, 
0.713225, 
0.703637, 
0.693768, 
0.684016, 
0.674277, 
0.664703, 
0.655328, 
0.646550, 
0.637812, 
0.629036, 
0.620129, 
1.000000, 
1.000000, 
0.999988, 
0.999933, 
0.999800, 
0.999508, 
0.998917, 
0.996236, 
0.994617, 
0.991176, 
0.987089, 
0.981880, 
0.974966, 
0.967156, 
0.957914, 
0.947585, 
0.936937, 
0.926318, 
0.915662, 
0.905567, 
0.896223, 
0.888166, 
0.881117, 
0.875079, 
0.869981, 
0.865675, 
0.862091, 
0.859183, 
0.856981, 
0.855065, 
0.853273, 
0.851572, 
0.849782, 
0.847768, 
0.845668, 
0.843345, 
0.840703, 
0.837646, 
0.834094, 
0.830030, 
0.825631, 
0.820873, 
0.815619, 
0.809856, 
0.803578, 
0.797096, 
0.790359, 
0.783152, 
0.775507, 
0.767504, 
0.759411, 
0.750982, 
0.742208, 
0.733383, 
0.724445, 
0.715190, 
0.705827, 
0.696440, 
0.686773, 
0.677242, 
0.667735, 
0.658471, 
0.649236, 
0.640305, 
1.000000, 
0.999999, 
0.999984, 
0.999918, 
0.999737, 
0.999350, 
0.997576, 
0.995476, 
0.992614, 
0.988817, 
0.983601, 
0.976880, 
0.968694, 
0.959092, 
0.948297, 
0.936831, 
0.925592, 
0.914494, 
0.904159, 
0.894643, 
0.886417, 
0.879620, 
0.874023, 
0.869533, 
0.865967, 
0.863238, 
0.861113, 
0.859527, 
0.858367, 
0.857594, 
0.856882, 
0.856172, 
0.855316, 
0.854197, 
0.852818, 
0.851062, 
0.849046, 
0.846747, 
0.844043, 
0.840842, 
0.837164, 
0.832985, 
0.828344, 
0.823544, 
0.818276, 
0.812543, 
0.806374, 
0.799838, 
0.793170, 
0.786246, 
0.778956, 
0.771297, 
0.763278, 
0.755252, 
0.746984, 
0.738445, 
0.729688, 
0.721045, 
0.712189, 
0.703099, 
0.694045, 
0.684930, 
0.675601, 
0.666480, 
1.000000, 
0.999999, 
0.999978, 
0.999888, 
0.999639, 
0.999093, 
0.996310, 
0.994405, 
0.990527, 
0.985186, 
0.978518, 
0.969748, 
0.959597, 
0.948104, 
0.935724, 
0.923704, 
0.912023, 
0.901356, 
0.891850, 
0.883847, 
0.877280, 
0.872289, 
0.868583, 
0.865913, 
0.864098, 
0.862993, 
0.862356, 
0.862125, 
0.862107, 
0.862168, 
0.862359, 
0.862490, 
0.862430, 
0.862063, 
0.861431, 
0.860386, 
0.858950, 
0.857090, 
0.854848, 
0.852381, 
0.849503, 
0.846167, 
0.842399, 
0.838194, 
0.833566, 
0.828579, 
0.823464, 
0.817951, 
0.812079, 
0.805873, 
0.799320, 
0.792533, 
0.785715, 
0.778636, 
0.771260, 
0.763618, 
0.755719, 
0.747815, 
0.739825, 
0.731602, 
0.723212, 
0.714845, 
0.706465, 
0.697933, 
1.000000, 
0.999998, 
0.999969, 
0.999836, 
0.999475, 
0.997943, 
0.995219, 
0.991760, 
0.986663, 
0.979592, 
0.970218, 
0.959155, 
0.946575, 
0.933047, 
0.920022, 
0.907749, 
0.896801, 
0.887506, 
0.880077, 
0.874322, 
0.870126, 
0.867481, 
0.865949, 
0.865293, 
0.865287, 
0.865746, 
0.866502, 
0.867439, 
0.868442, 
0.869382, 
0.870161, 
0.870782, 
0.871303, 
0.871511, 
0.871427, 
0.870978, 
0.870136, 
0.868892, 
0.867248, 
0.865209, 
0.862775, 
0.859944, 
0.857004, 
0.853671, 
0.849984, 
0.845927, 
0.841518, 
0.836774, 
0.831750, 
0.826407, 
0.821001, 
0.815333, 
0.809412, 
0.803238, 
0.796802, 
0.790204, 
0.783457, 
0.776713, 
0.769749, 
0.762596, 
0.755239, 
0.747690, 
0.740127, 
0.732595, 
1.000000, 
0.999997, 
0.999950, 
0.999744, 
0.999162, 
0.996124, 
0.992844, 
0.987757, 
0.980062, 
0.969642, 
0.957087, 
0.942735, 
0.927747, 
0.913622, 
0.900889, 
0.890115, 
0.881584, 
0.875288, 
0.870926, 
0.868307, 
0.867033, 
0.866972, 
0.867692, 
0.868950, 
0.870549, 
0.872320, 
0.874144, 
0.875947, 
0.877674, 
0.879192, 
0.880478, 
0.881539, 
0.882307, 
0.882739, 
0.882902, 
0.882847, 
0.882461, 
0.881725, 
0.880636, 
0.879197, 
0.877422, 
0.875296, 
0.872849, 
0.870076, 
0.866988, 
0.863637, 
0.860159, 
0.856475, 
0.852525, 
0.848328, 
0.843883, 
0.839198, 
0.834322, 
0.829221, 
0.823907, 
0.818461, 
0.812972, 
0.807316, 
0.801474, 
0.795459, 
0.789276, 
0.783025, 
0.776615, 
0.770223, 
0.999999, 
0.999994, 
0.999909, 
0.999536, 
0.997195, 
0.994123, 
0.988168, 
0.979344, 
0.967003, 
0.951763, 
0.934724, 
0.917948, 
0.902918, 
0.890432, 
0.880902, 
0.874401, 
0.870394, 
0.868503, 
0.868209, 
0.869062, 
0.870725, 
0.873006, 
0.875558, 
0.878230, 
0.880893, 
0.883445, 
0.885832, 
0.888059, 
0.890058, 
0.891782, 
0.893247, 
0.894460, 
0.895397, 
0.896023, 
0.896380, 
0.896433, 
0.896198, 
0.895673, 
0.894865, 
0.893908, 
0.892700, 
0.891224, 
0.889501, 
0.887539, 
0.885336, 
0.882903, 
0.880244, 
0.877373, 
0.874296, 
0.871019, 
0.867549, 
0.863933, 
0.860153, 
0.856355, 
0.852395, 
0.848277, 
0.844006, 
0.839587, 
0.835045, 
0.830378, 
0.825579, 
0.820649, 
0.815592, 
0.810432, 
0.999998, 
0.999988, 
0.999795, 
0.998892, 
0.994635, 
0.987290, 
0.975397, 
0.958508, 
0.938352, 
0.917733, 
0.899800, 
0.885878, 
0.876516, 
0.871200, 
0.869099, 
0.869317, 
0.871112, 
0.873870, 
0.877160, 
0.880682, 
0.884228, 
0.887737, 
0.891076, 
0.894161, 
0.896981, 
0.899543, 
0.901847, 
0.903882, 
0.905672, 
0.907188, 
0.908451, 
0.909480, 
0.910289, 
0.910878, 
0.911259, 
0.911430, 
0.911396, 
0.911154, 
0.910712, 
0.910081, 
0.909266, 
0.908264, 
0.907094, 
0.905752, 
0.904244, 
0.902577, 
0.900799, 
0.898931, 
0.896923, 
0.894782, 
0.892513, 
0.890117, 
0.887600, 
0.884968, 
0.882222, 
0.879369, 
0.876408, 
0.873345, 
0.870183, 
0.866926, 
0.863575, 
0.860160, 
0.856672, 
0.853098, 
0.999991, 
0.999947, 
0.999158, 
0.992842, 
0.980107, 
0.957230, 
0.928231, 
0.901539, 
0.882688, 
0.872588, 
0.869394, 
0.870671, 
0.874458, 
0.879378, 
0.884639, 
0.889770, 
0.894601, 
0.898972, 
0.902930, 
0.906456, 
0.909568, 
0.912329, 
0.914750, 
0.916893, 
0.918774, 
0.920429, 
0.921868, 
0.923110, 
0.924185, 
0.925089, 
0.925842, 
0.926457, 
0.926934, 
0.927285, 
0.927522, 
0.927639, 
0.927650, 
0.927553, 
0.927356, 
0.927061, 
0.926671, 
0.926187, 
0.925617, 
0.924962, 
0.924224, 
0.923409, 
0.922519, 
0.921555, 
0.920521, 
0.919419, 
0.918252, 
0.917021, 
0.915729, 
0.914377, 
0.912967, 
0.911503, 
0.909984, 
0.908414, 
0.906791, 
0.905122, 
0.903401, 
0.901637, 
0.899826, 
0.897972, 
0.987461, 
0.940121, 
0.871507, 
0.898572, 
0.916705, 
0.926425, 
0.931922, 
0.935265, 
0.937431, 
0.938899, 
0.939950, 
0.940717, 
0.941301, 
0.941754, 
0.942111, 
0.942397, 
0.942631, 
0.942823, 
0.942983, 
0.943117, 
0.943231, 
0.943329, 
0.943412, 
0.943484, 
0.943545, 
0.943599, 
0.943644, 
0.943682, 
0.943716, 
0.943744, 
0.943766, 
0.943785, 
0.943799, 
0.943808, 
0.943815, 
0.943818, 
0.943818, 
0.943814, 
0.943807, 
0.943797, 
0.943784, 
0.943769, 
0.943751, 
0.943730, 
0.943707, 
0.943681, 
0.943652, 
0.943623, 
0.943589, 
0.943554, 
0.943518, 
0.943479, 
0.943438, 
0.943396, 
0.943351, 
0.943305, 
0.943257, 
0.943207, 
0.943156, 
0.943104, 
0.943049, 
0.942993, 
0.942936, 
0.942877
].
