/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.awt.Rectangle;
import java.util.HashMap;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceLayoutNode;

public abstract class BaseBorderLayout
extends BaseSurfaceLayoutNode {
    protected static final int FIELD_HORIZONTAL_ALIGN = 4;
    protected static final int FIELD_VERTICAL_ALIGN = 5;
    protected static final int FIELD_HORIZONTAL_FRACTION = 6;
    protected static final int FIELD_VERTICAL_FRACTION = 7;
    protected static final int LAST_BORDER_LAYOUT_INDEX = 7;
    protected static final int NUM_FIELDS = 8;
    protected static final String LEFT = "LEFT";
    protected static final String RIGHT = "RIGHT";
    protected static final String CENTER = "CENTER";
    protected static final String TOP = "TOP";
    protected static final String BOTTOM = "BOTTOM";
    protected static final int LEFT_ALIGN = 1;
    protected static final int RIGHT_ALIGN = 2;
    protected static final int CENTER_ALIGN = 3;
    protected static final int TOP_ALIGN = 4;
    protected static final int BOTTOM_ALIGN = 5;
    private static final String BAD_ALIGN_MSG = "The alignment value provided is unknown: ";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected static HashMap alignmentMap;
    protected static HashSet allowedHorizontalValues;
    protected static HashSet allowedVerticalValues;
    protected String vfHorizontalAlign;
    protected String vfVerticalAlign;
    protected float vfHorizontalFraction;
    protected float vfVerticalFraction;

    protected BaseBorderLayout() {
        super("BorderLayout");
        this.hasChanged = new boolean[8];
        this.vfHorizontalAlign = LEFT;
        this.vfVerticalAlign = TOP;
        this.vfHorizontalFraction = 0.0f;
        this.vfVerticalFraction = 0.0f;
    }

    protected BaseBorderLayout(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSurfaceLayoutNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("horizontalAlign");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHorizontalAlign = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("verticalAlign");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVerticalAlign = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("horizontalFraction");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHorizontalFraction = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("verticalFraction");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVerticalFraction = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f) {
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            f = f > (float)rectangle.width ? f : (float)rectangle.width;
            f2 = f2 > (float)rectangle.height ? f2 : (float)rectangle.height;
        }
        if (this.vfBboxSize[0] == -1.0f) {
            this.screenBounds.width = (int)f;
        }
        if (this.vfBboxSize[1] == -1.0f) {
            this.screenBounds.height = (int)f2;
        }
        this.updateManagedNodes();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfHorizontalAlign;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfVerticalAlign;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfHorizontalFraction;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfVerticalFraction;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfHorizontalAlign);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfVerticalAlign);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfHorizontalFraction);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfVerticalFraction);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.vfHorizontalFraction = f;
                break;
            }
            case 7: {
                this.vfVerticalFraction = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
        if (!this.inSetup) {
            this.updateManagedNodes();
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 4: {
                if (allowedHorizontalValues.contains(string)) {
                    this.vfHorizontalAlign = string;
                    break;
                }
                throw new InvalidFieldValueException(BAD_ALIGN_MSG + string);
            }
            case 5: {
                if (allowedVerticalValues.contains(string)) {
                    this.vfVerticalAlign = string;
                    break;
                }
                throw new InvalidFieldValueException(BAD_ALIGN_MSG + string);
            }
            default: {
                super.setValue(n, string);
            }
        }
        if (!this.inSetup) {
            this.updateManagedNodes();
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public void setLocation(int n, int n2) {
        int n3 = n - (int)this.screenLocation[0];
        int n4 = n2 - (int)this.screenLocation[1];
        super.setLocation(n, n2);
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            int n5 = rectangle.x + n3;
            int n6 = rectangle.y + n4;
            vRMLSurfaceChildNodeType.setLocation(n5, n6);
        }
    }

    protected void updateManagedNodes() {
        int n = this.screenBounds.x + (int)((float)this.screenBounds.width * this.vfHorizontalFraction);
        int n2 = this.screenBounds.y + (int)((float)this.screenBounds.height * this.vfVerticalFraction);
        for (int i = 0; i < this.vfChildren.length; ++i) {
            Object object;
            VRMLNodeType vRMLNodeType = this.vfChildren[i];
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = null;
            if (vRMLNodeType == null) continue;
            if (vRMLNodeType instanceof VRMLSurfaceChildNodeType) {
                vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)vRMLNodeType;
            } else {
                object = (VRMLProtoInstance)vRMLNodeType;
                vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)object.getImplementationNode();
            }
            object = vRMLSurfaceChildNodeType.getBboxSize();
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            int n3 = object[0] == -1.0f ? rectangle.width : (int)object[0];
            int n4 = object[1] == -1.0f ? rectangle.height : (int)object[1];
            int n5 = 0;
            int n6 = 0;
            Integer n7 = (Integer)alignmentMap.get(this.vfHorizontalAlign);
            switch (n7) {
                case 1: {
                    n6 = n;
                    break;
                }
                case 2: {
                    n6 = n - n3;
                    break;
                }
                case 3: {
                    n6 = n - (n3 >> 1);
                }
            }
            n7 = (Integer)alignmentMap.get(this.vfVerticalAlign);
            switch (n7) {
                case 4: {
                    n5 = n2;
                    break;
                }
                case 5: {
                    n5 = n2 - n4;
                    break;
                }
                case 3: {
                    n5 = n2 - (n4 >> 1);
                }
            }
            vRMLSurfaceChildNodeType.setLocation(n6, n5);
        }
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(24);
        BaseBorderLayout.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseBorderLayout.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseBorderLayout.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec2f", "bboxSize");
        BaseBorderLayout.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseBorderLayout.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFString", "horizontalAlign");
        BaseBorderLayout.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFString", "verticalAlign");
        BaseBorderLayout.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "horizontalFraction");
        BaseBorderLayout.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "verticalFraction");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(3);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(4);
        fieldMap.put("horizontalAlign", n);
        fieldMap.put("set_horizontalAlign", n);
        fieldMap.put("horizontalAlign_changed", n);
        n = new Integer(6);
        fieldMap.put("horizontalFraction", n);
        fieldMap.put("set_horizontalFraction", n);
        fieldMap.put("horizontalFraction_changed", n);
        n = new Integer(5);
        fieldMap.put("verticalAlign", n);
        fieldMap.put("set_verticalAlign", n);
        fieldMap.put("verticalAlign_changed", n);
        n = new Integer(7);
        fieldMap.put("verticalFraction", n);
        fieldMap.put("set_verticalFraction", n);
        fieldMap.put("verticalFraction_changed", n);
        fieldMap.put("bboxSize", new Integer(2));
        alignmentMap = new HashMap();
        alignmentMap.put(LEFT, new Integer(1));
        alignmentMap.put(RIGHT, new Integer(2));
        alignmentMap.put(CENTER, new Integer(3));
        alignmentMap.put(TOP, new Integer(4));
        alignmentMap.put(BOTTOM, new Integer(5));
        allowedHorizontalValues = new HashSet(3);
        allowedHorizontalValues.add(LEFT);
        allowedHorizontalValues.add(RIGHT);
        allowedHorizontalValues.add(CENTER);
        allowedVerticalValues = new HashSet(3);
        allowedVerticalValues.add(TOP);
        allowedVerticalValues.add(BOTTOM);
        allowedVerticalValues.add(CENTER);
    }
}

