// Copyright 2002 - 2008, 2010, 2011 National Technology Engineering
// Solutions of Sandia, LLC (NTESS). Under the terms of Contract
// DE-NA0003525 with NTESS, the U.S. Government retains certain rights
// in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// 
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
// 
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
// 
//     * Neither the name of NTESS nor the names of its contributors
//       may be used to endorse or promote products derived from this
//       software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

#include <stk_util/diag/StringUtil.hpp>  // for demangle
#include <gtest/gtest.h>
#include <string>                       // for operator==, string, etc
#include <typeinfo>                     // for type_info
#include <vector>                       // for vector


bool
utest_demangle()
{
  return true;
}

TEST(UnitTestDemangle, UnitTest)
{
#if defined(__PGI)
  {
    std::string linux_name("ThisIsJunk");
    std::string demangled_name = stk::demangle(linux_name.c_str());
    ASSERT_EQ(linux_name, demangled_name);
  }

  {
    std::string linux_name("bool ()");
    std::string demangled_name = stk::demangle(typeid(utest_demangle).name());
    ASSERT_EQ(linux_name, demangled_name);
  }

  {
    std::vector<double> double_vector;

    std::string linux_name("std::vector<double, std::allocator<double>>");
    std::string demangled_name = stk::demangle(typeid(double_vector).name());
    ASSERT_EQ(linux_name, demangled_name);
  }

#elif defined(__xlC__)
  {
    std::string linux_name("ThisIsJunk");
    std::string demangled_name = stk::demangle(linux_name.c_str());
//    ASSERT_EQ((linux_name == demangled_name), true);
  }

  {
    std::string linux_name("bool ()()");
    std::string demangled_name = stk::demangle(typeid(utest_demangle).name());
//    ASSERT_EQ(linux_name, demangled_name);
  }

  {
    std::vector<double> double_vector;

    std::string linux_name("std::vector<double, std::allocator<double> >");
    std::string demangled_name = stk::demangle(typeid(double_vector).name());
//    ASSERT_EQ((linux_name == demangled_name), true);
  }
#elif defined(__linux__)
  {
    std::string linux_name("ThisIsJunk");
    std::string demangled_name = sierra::demangle(linux_name.c_str());
    ASSERT_EQ((linux_name == demangled_name), true);
  }

  {
    std::vector<double> double_vector;

#ifdef _GLIBCXX_DEBUG
    std::string linux_name("__gnu_debug_def::vector<double, std::allocator<double> >");
#else
    std::string linux_name("std::vector<double, std::allocator<double> >");
#endif
    std::string demangled_name = sierra::demangle(typeid(double_vector).name());
    ASSERT_EQ((linux_name == demangled_name), true);
  }
#endif
}
