---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, titres, chapitre, sectionnement, 
              apparence des titres de chapitres, format des titres de chapitres,
              chapitre sans titre, retirer le mot chapitre
---

# Comment modifier le style des titres de chapitre ?

Cette question complète les éléments plus généraux (concernant aussi 
les chapitres) présentés dans la question 
"[](/3_composition/texte/titres/modifier_le_style_des_titres)".


## Avec l'extension <ctanpkg:fncychap>

L'extension <ctanpkg:fncychap> fournit une intéressante collection de styles 
de chapitre prédéfinis, portant tous un nom : `Sonny`, `Glenn`, `Conny`, 
`Rejne` et `Bjarne`. Voici un exemple d'utilisation :

```
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[Lenny]{fncychap}

\begin{document}
\chapter{Introduction}
De tout temps, les hommes\dots
\end{document}
```


## Avec l'extension <ctanpkg:anonchap>

L'extension <ctanpkg:anonchap> fournit un moyen simple de présenter 
des chapitres au même format que des sections (c'est-à-dire 
sans le mot "Chapitre"). Sa commande `\simplechapter[⟨Nom⟩]` 
remplace le mot "Chapitre" par le mot `⟨Nom⟩` (qui est un argument
facultatif, comme le montre l'exemple suivant). La commande 
`\simplechapterdelim` définit le séparateur entre la numérotation
du chapitre et son titre. En voici un exemple :

```
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{anonchap}
  
  \simplechapter
  \renewcommand{\simplechapterdelim}{ --}

\begin{document}
\chapter{Introduction}
De tout temps, les hommes\dots
\end{document}
```


## Avec l'extension <ctanpkg:tocbibind>

L'extension <ctanpkg:tocbibind> fournit les mêmes commandes 
que l'extension <ctanpkg:anonchap> mais pour répondre à l'origine 
à d'autres besoins. L'exemple ci-dessus est donc une variante 
du précédent :

```
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tocbibind}
  
  \simplechapter[Thème]
  \renewcommand{\simplechapterdelim}{.}

\begin{document}
\chapter{Introduction}
De tout temps, les hommes\dots
\end{document}
```


## Avec des modifications manuelles

Pour les chapitres, il faut modifier la commande `\@makechapterhead`, 
ou `\@makeschapterhead` selon que vous vous intéressez à `\chapter`
ou à `\chapter*`. Voici un exemple de ce type de modification.

```
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Des redéfinitions des chapitres
  \makeatletter
  \def\@makechapterhead#1{%
    \vspace*{50\p@}%
    {\parindent \z@ \raggedright \normalfont
      \interlinepenalty\@M
      \ifnum \c@secnumdepth >\m@ne
          \Huge\bfseries \thechapter\quad
      \fi
      \Huge \bfseries #1\par\nobreak
      \vskip 40\p@
    }}

  \def\@makeschapterhead#1{%
    \vspace*{50\p@}%
    {\parindent \z@ \raggedright
      \normalfont
      \interlinepenalty\@M
      \Huge \bfseries  #1\par\nobreak
      \vskip 40\p@
    }}
  \makeatother

\begin{document}
\chapter{Introduction}
De tout temps, les hommes\dots
\end{document}
```

Dans ce cadre, Vincent Zoonekynd propose des exemples illustrés 
montrant comment obtenir différents 
[styles de chapitre](http://zoonek.free.fr/LaTeX/LaTeX_samples_chapter/0.html).