package salamander.icon.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.io.File;
import java.util.Arrays;
import java.util.List;

import javax.swing.JButton;

import com.kitfox.svg.app.beans.SVGIcon;

/**
 *
 * @author Ernie Rael <err at raelity.com>
 */
public class IconGrid extends javax.swing.JFrame
{
    boolean overridePaint_buttonNotInIcon = true;

    public class IconGridPanel extends javax.swing.JPanel
    {
        /** Creates new form IconGridPanel */
        public IconGridPanel() {
            setLayout(new java.awt.GridLayout(1, 2));
            ((GridLayout)getLayout()).setHgap(10);
            ((GridLayout)getLayout()).setVgap(10);

            for(String svg : getFileNames())
                add(getButton(svg));

        }

        final SVGIcon createIcon(String svg) {
            File f = new File(svg);
            SVGIcon icon = new SVGIcon();
            icon.setPreferredSize(new Dimension(0, 0)); // AVOID NPE
            icon.setSvgResourcePath(svg);

            // maintain proportion of width/height from svg file.
            int w0 = icon.getIconWidth(); int h0 = icon.getIconHeight();
            double ratio = 50. / w0;
            int w1 = (int)(w0 * ratio); int h1 = (int)(h0 * ratio);

            // Any autosize will adjust after initial draw
            icon.setAutosize(SVGIcon.AUTOSIZE_BESTFIT);
            icon.setClipToViewbox(false);
            icon.setPreferredSize(new Dimension(w1, h1));
            icon.setAntiAlias(true);
            icon.setInterpolation(SVGIcon.INTERP_BICUBIC);
            return icon;
        }

        int idx;
        SVGIcon[] icons = new SVGIcon[getFileNames().size()];

        final JButton getButton(String svg) {
            if(overridePaint_buttonNotInIcon) {
                icons[idx++] = createIcon(svg);
                return new JButton();
            } else
                return new JButton(createIcon(svg));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if(overridePaint_buttonNotInIcon)
                paintIcons(g);
        }

        private void paintIcons(Graphics gg) {
            Graphics2D g = (Graphics2D)gg.create();
            int off = 60;
            for(int i = 0; i < getFileNames().size(); i++) {
                Rectangle b = getComponent(i).getBounds();
                SVGIcon icon = icons[i];
                if(icon != null) {
                    Dimension sz = icon.getPreferredSize();
                    g.setClip(b.x, b.y, b.width, b.height); // grid element
                    g.setColor(Color.white);
                    g.fillRect(b.x + off, b.y + off, sz.width, sz.height);

                    icon.paintIcon(null, g, b.x+off, b.y+off);
                }
            }
            g.dispose();
        }
    }

    static final List<String> getFileNames() {
        String fnames[];
        fnames = new String[] {
            "/salamander/icon/grid/Square-symbol.svg",
            "/salamander/icon/grid/Libra.svg",
        };
        return Arrays.asList(fnames);
    }

    public IconGrid() {
        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        pack();
        setSize(350, 200);
        add(new IconGridPanel());
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for(javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager
                    .getInstalledLookAndFeels()) {
                if("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch(Exception ex) {
        }

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable()
        {
            public void run() {
                new IconGrid().setVisible(true);
            }
        });
    }

}
