use ui;
use graphics;
use core:geometry;
use core:lang;
use lang:bs:macro;

/**
 * Data for global variables.
 */
class Globals extends Composite {
	init(GlobalVar[] globals) {
		init(null) {}

		Global[] g;

		for (v in globals) {
			g << Global(v.name, fromValue(v.type), unsafe:RawPtr:fromGlobal(v));
		}

		// Make the order consistent.
		g.sort((a, b) => a.name < b.name);

		// Add them.
		for (v in g) {
			parts << Part(v.name, 0, GlobalPtr(v.type, v.src), false);
		}
	}

	// Copy.
	init(Globals original) {
		init(original) {}
	}

	// Source data for globals.
	private value Global {
		Str name;
		TypeInfo type;
		unsafe:RawPtr src;

		init(Str name, TypeInfo type, unsafe:RawPtr src) {
			init {
				name = name;
				type = type;
				src = src;
			}
		}
	}

	// Update.
	void update(World:Traversal t, unsafe:RawPtr object, Nat offset) : override {
		for (i, p in parts) {
			p.value.update(t, unsafe:RawPtr(), 0);
		}
	}

	// Traverse.
	void traverse(World:Traversal t, unsafe:RawPtr object, Nat offset) : override {
		for (i, p in parts) {
			p.value.traverse(t, unsafe:RawPtr(), 0);
		}
	}

	// Title.
	Str title(World world) : override {
		"Globals";
	}

	// Copy.
	protected Data copyObject() : override {
		Globals(this);
	}
}

/**
 * Pointer to a global object.
 */
class GlobalPtr extends Pointer {
	init(TypeInfo type, unsafe:RawPtr globalData) {
		init(type.type) {
			data = globalData;
		}
	}

	// Copy.
	init(GlobalPtr original) {
		init(original) {
			data = original.data;
		}
	}

	// Pointer to the data in the global variable.
	private unsafe:RawPtr data;

	void traverse(World:Traversal t, unsafe:RawPtr object, Nat offset) : override {
		traverse(t, data);
	}

	// Copy.
	protected Data copyObject() : override {
		GlobalPtr(this);
	}
}
