/***************************************************************************
 *   copyright           : (C) 2005 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VERSIT_H
#define VERSIT_H

#include <helper.h>
#include <inttypes.h>
#include <stdio.h>

extern char* encoding_string[4];
enum encoding_value {
  ENC_SEVENBIT = 0,
  ENC_EIGHTBIT,
  ENC_QUOTEDPRINTABLE,
  ENC_BASE64
};

unsigned char* encode_chars (enum encoding_value enc,
			     unsigned char* input);
int is_eightbit (uint8_t* s);

enum vcard_version {
  VCARD_VERSION_21 = 2, /* version 2.1 */
  VCARD_VERSION_30 = 3 /* version 3.0 */
};

#define VERSIT_LINE_END "\r\n"

/** create a new handle
 * This creates a new handle. You have to make sure yourself
 * that the FILE* is not used twice.
 * You must use versit_out_close() to close the handle!
 * 
 * @param fp where to write the data
 * @param cset the default character set
 * @param enc the default encoding
 * @param version the vCard version
 * 
 * @return a handle
 */
void* versit_out_open (FILE* fp,
		       char* cset,
		       enum encoding_value enc,
		       enum vcard_version version);

/** finish a handle
 * This writes the END property if needed and cleans
 * up the handle.
 * It does _not_ close the underlying FILE handle.
 * 
 * @param h the handle to act on
 */
void versit_out_close (void* h);

#define VERSIT_NUMBER_HOME 0x0001
#define VERSIT_NUMBER_WORK 0x0002
#define VERSIT_NUMBER_CELL 0x0004
#define VERSIT_NUMBER_FAX  0x0008
/** print a versit number field
 * 
 * @param h the handle to act on
 * @param num the number
 * @param type the type bitfield (VERSIT_NUMBER_*)
 */
void versit_out_number(void* h,
		       struct gsm_number* num,
		       uint32_t type);


/** print a name field 
 * 
 * @param h the handle to act on
 * @param first first name / given name
 * @param last  last name / family name
 */
void versit_out_name (void* h,
		      ucs4char_t* first,
		      ucs4char_t* last);

/** print an address field
 * 
 * @param h the handle to act on
 * @param street the street name (including house number)
 * @param city the city name
 * @param country the country (not region)
 * @param postal the postal code
 */
void versit_out_address (void* h,
			 ucs4char_t* street, ucs4char_t* city,
			 ucs4char_t* country,ucs4char_t* postal);

/** print an organisation field
 * 
 * @param h the handle to act on
 * @param org the organisation name
 */
void versit_out_org (void* h, ucs4char_t* org);

/** print an e-mail field
 * 
 * @param h the handle to act on
 * @param email the electronic mail address
 */
void versit_out_email (void* h, ucs4char_t* email);

/** print an URL field
 * 
 * @param h the handle to act on
 * @param url the uniform resouce location string
 */
void versit_out_url (void* h, ucs4char_t* url);

/** print a revision field
 * 
 * @param h the handle to act on
 * @param rev the revision string
 */
void versit_out_revision (void* h, ucs4char_t* rev);

/** print a birthday field
 * 
 * @param h the handle to act on
 * @param year the birthday year (4 digits)
 * @param month the birthday month (2 digits: 1-12)
 * @param day the day (2 digits: 1-31)
 */
void versit_out_birthday (void* h, uint16_t year,
			  uint16_t month, uint16_t day);

#endif
