# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class AuthTokenPromotionTestCase(IntegrationTestCase):

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.accounts.v1.auth_token_promotion().update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://accounts.twilio.com/v1/AuthTokens/Promote',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "auth_token": "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
                "date_created": "2015-07-31T04:00:00Z",
                "date_updated": "2015-07-31T04:00:00Z",
                "url": "https://accounts.twilio.com/v1/AuthTokens/Promote"
            }
            '''
        ))

        actual = self.client.accounts.v1.auth_token_promotion().update()

        self.assertIsNotNone(actual)
