#pragma once

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Wire.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshData_Shape.hxx>
#include <IMeshData_Face.hxx>
#include <IMeshData_Wire.hxx>
#include <IMeshData_Edge.hxx>
#include <IMeshData_Curve.hxx>
#include <IMeshData_PCurve.hxx>
#include <IMeshData_Model.hxx>
#include <BRepMesh_VertexInspector.hxx>
#include <BRepMesh_CircleInspector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IMeshData_Curve.hxx>
#include <IMeshData_Edge.hxx>
#include <IMeshData_Face.hxx>
#include <IMeshData_Model.hxx>
#include <IMeshData_PCurve.hxx>
#include <IMeshData_ParametersList.hxx>
#include <IMeshData_ParametersListArrayAdaptor.hxx>
#include <IMeshData_Shape.hxx>
#include <IMeshData_Status.hxx>
#include <IMeshData_StatusOwner.hxx>
#include <IMeshData_TessellatedShape.hxx>
#include <IMeshData_Types.hxx>
#include <IMeshData_Wire.hxx>

// user-defined pre
#include "OCP_specific.inc"

// Class template handling functions

template <typename ParametersListPtrType>
void preregister_template_IMeshData_ParametersListArrayAdaptor(py::object &m, const char *name){
    py::class_<IMeshData_ParametersListArrayAdaptor<ParametersListPtrType> , opencascade::handle<IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>> , Standard_Transient >(m,name,R"#(Auxiliary tool representing adaptor interface for child classes of IMeshData_ParametersList to be used in tools working on NCollection_Array structure.)#");
}

template <typename ParametersListPtrType>
void register_template_IMeshData_ParametersListArrayAdaptor(py::object &m, const char *name){
    static_cast<py::class_<IMeshData_ParametersListArrayAdaptor<ParametersListPtrType> , opencascade::handle<IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>> , Standard_Transient >>(m.attr(name))
        .def(py::init< const ParametersListPtrType & >() ,py::arg("theParameters") )
        .def("Lower",
             (Standard_Integer (IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>::*)() const) &IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>::Lower,
             R"#(Returns lower index in parameters array.)#" )
        .def("Upper",
             (Standard_Integer (IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>::*)() const) &IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>::Upper,
             R"#(Returns upper index in parameters array.)#" )
        .def("Value",
             (Standard_Real (IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>::*)( const Standard_Integer  ) const) &IMeshData_ParametersListArrayAdaptor<ParametersListPtrType>::Value,
             R"#(Returns value of the given index.)#" ,py::arg("theIndex"))
    ;
};


// user-defined post

