/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.BasicPixelProcessor;
import com.sixlegs.png.ConvertIndexedDestination;
import com.sixlegs.png.Defilterer;
import com.sixlegs.png.Destination;
import com.sixlegs.png.GammaPixelProcessor;
import com.sixlegs.png.PixelProcessor;
import com.sixlegs.png.PngConfig;
import com.sixlegs.png.PngException;
import com.sixlegs.png.PngImage;
import com.sixlegs.png.ProgressUpdater;
import com.sixlegs.png.ProgressivePixelProcessor;
import com.sixlegs.png.RasterDestination;
import com.sixlegs.png.SourceRegionDestination;
import com.sixlegs.png.SubsamplingDestination;
import com.sixlegs.png.TransGammaPixelProcessor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class ImageFactory {
    private static short[] GAMMA_TABLE_45455 = PngImage.createGammaTable(0.45455f, 2.2f, false);
    private static short[] GAMMA_TABLE_100000 = PngImage.createGammaTable(1.0f, 2.2f, false);
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$B;

    ImageFactory() {
    }

    public static BufferedImage createImage(PngImage png, InputStream in) throws IOException {
        return ImageFactory.createImage(png, in, new Dimension(png.getWidth(), png.getHeight()));
    }

    public static BufferedImage createImage(PngImage png, InputStream in, Dimension size) throws IOException {
        Destination dst;
        PngConfig config = png.getConfig();
        int width = size.width;
        int height = size.height;
        int bitDepth = png.getBitDepth();
        int samples = png.getSamples();
        boolean interlaced = png.isInterlaced();
        boolean indexed = ImageFactory.isIndexed(png);
        boolean convertIndexed = indexed && config.getConvertIndexed();
        short[] gammaTable = config.getGammaCorrect() ? ImageFactory.getGammaTable(png) : null;
        ColorModel dstColorModel = ImageFactory.createColorModel(png, gammaTable, convertIndexed);
        int dstWidth = width;
        int dstHeight = height;
        Rectangle sourceRegion = config.getSourceRegion();
        if (sourceRegion != null) {
            if (!new Rectangle(dstWidth, dstHeight).contains(sourceRegion)) {
                throw new IllegalStateException("Source region " + sourceRegion + " falls outside of " + width + "x" + height + " image");
            }
            dstWidth = sourceRegion.width;
            dstHeight = sourceRegion.height;
        }
        int xsub = config.getSourceXSubsampling();
        int ysub = config.getSourceYSubsampling();
        if (xsub != 1 || ysub != 1) {
            int xoff = config.getSubsamplingXOffset();
            int yoff = config.getSubsamplingYOffset();
            int subw = ImageFactory.calcSubsamplingSize(dstWidth, xsub, xoff, 'X');
            int subh = ImageFactory.calcSubsamplingSize(dstHeight, ysub, yoff, 'Y');
            WritableRaster raster = dstColorModel.createCompatibleWritableRaster(subw, subh);
            dst = new SubsamplingDestination(raster, width, xsub, ysub, xoff, yoff);
        } else {
            dst = new RasterDestination(dstColorModel.createCompatibleWritableRaster(dstWidth, dstHeight), width);
        }
        if (sourceRegion != null) {
            dst = new SourceRegionDestination(dst, sourceRegion);
        }
        BufferedImage image = new BufferedImage(dstColorModel, dst.getRaster(), false, null);
        PixelProcessor pp = null;
        if (!indexed) {
            int shift;
            int[] trans = (int[])png.getProperty("transparency", array$I == null ? (array$I = ImageFactory.class$("[I")) : array$I, false);
            int n = shift = bitDepth == 16 && config.getReduce16() ? 8 : 0;
            if (shift != 0 || trans != null || gammaTable != null) {
                if (gammaTable == null) {
                    gammaTable = ImageFactory.getIdentityTable(bitDepth - shift);
                }
                pp = trans != null ? new TransGammaPixelProcessor(dst, gammaTable, trans, shift) : new GammaPixelProcessor(dst, gammaTable, shift);
            }
        }
        if (convertIndexed) {
            IndexColorModel srcColorModel = (IndexColorModel)ImageFactory.createColorModel(png, gammaTable, false);
            dst = new ConvertIndexedDestination(dst, width, srcColorModel, (ComponentColorModel)dstColorModel);
        }
        if (pp == null) {
            pp = new BasicPixelProcessor(dst, samples);
        }
        if (config.getProgressive() && interlaced && !convertIndexed) {
            pp = new ProgressivePixelProcessor(dst, pp, width, height);
        }
        pp = new ProgressUpdater(png, image, pp);
        InflaterInputStream inflate = new InflaterInputStream(in, new Inflater(), 4096);
        Defilterer d = new Defilterer(inflate, bitDepth, samples, width, pp);
        if (interlaced) {
            boolean complete = d.defilter(0, 0, 8, 8, (width + 7) / 8, (height + 7) / 8) && png.handlePass(image, 0) && d.defilter(4, 0, 8, 8, (width + 3) / 8, (height + 7) / 8) && png.handlePass(image, 1) && d.defilter(0, 4, 4, 8, (width + 3) / 4, (height + 3) / 8) && png.handlePass(image, 2) && d.defilter(2, 0, 4, 4, (width + 1) / 4, (height + 3) / 4) && png.handlePass(image, 3) && d.defilter(0, 2, 2, 4, (width + 1) / 2, (height + 1) / 4) && png.handlePass(image, 4) && d.defilter(1, 0, 2, 2, width / 2, (height + 1) / 2) && png.handlePass(image, 5) && d.defilter(0, 1, 1, 2, width, height / 2) && png.handlePass(image, 6);
        } else {
            boolean complete = d.defilter(0, 0, 1, 1, width, height) && png.handlePass(image, 0);
        }
        dst.done();
        return image;
    }

    private static short[] getGammaTable(PngImage png) {
        PngConfig config = png.getConfig();
        if ((png.getBitDepth() != 16 || config.getReduce16()) && config.getDisplayExponent() == 2.2f) {
            float gamma = png.getGamma();
            if (gamma == 0.45455f) {
                return GAMMA_TABLE_45455;
            }
            if (gamma == 1.0f) {
                return GAMMA_TABLE_100000;
            }
        }
        return png.getGammaTable();
    }

    private static int calcSubsamplingSize(int len, int sub, int off, char desc) {
        int size = (len - off + sub - 1) / sub;
        if (size == 0) {
            throw new IllegalStateException("Source " + desc + " subsampling " + sub + ", offset " + off + " is invalid for image dimension " + len);
        }
        return size;
    }

    private static boolean isIndexed(PngImage png) {
        int colorType = png.getColorType();
        return colorType == 3 || colorType == 0 && png.getBitDepth() < 16;
    }

    private static ColorModel createColorModel(PngImage png, short[] gammaTable, boolean convertIndexed) throws PngException {
        int outputDepth;
        Map props = png.getProperties();
        int colorType = png.getColorType();
        int bitDepth = png.getBitDepth();
        int n = outputDepth = bitDepth == 16 && png.getConfig().getReduce16() ? 8 : bitDepth;
        if (ImageFactory.isIndexed(png) && !convertIndexed) {
            byte[] b;
            byte[] g;
            byte[] r;
            if (colorType == 3) {
                byte[] palette = (byte[])png.getProperty("palette", array$B == null ? (array$B = ImageFactory.class$("[B")) : array$B, true);
                int paletteSize = palette.length / 3;
                r = new byte[paletteSize];
                g = new byte[paletteSize];
                b = new byte[paletteSize];
                int p = 0;
                for (int i = 0; i < paletteSize; ++i) {
                    r[i] = palette[p++];
                    g[i] = palette[p++];
                    b[i] = palette[p++];
                }
                ImageFactory.applyGamma(r, gammaTable);
                ImageFactory.applyGamma(g, gammaTable);
                ImageFactory.applyGamma(b, gammaTable);
            } else {
                int paletteSize = 1 << bitDepth;
                g = b = new byte[paletteSize];
                r = b;
                for (int i = 0; i < paletteSize; ++i) {
                    r[i] = (byte)(i * 255 / (paletteSize - 1));
                }
                ImageFactory.applyGamma(r, gammaTable);
            }
            if (props.containsKey("palette_alpha")) {
                byte[] trans = (byte[])png.getProperty("palette_alpha", array$B == null ? (array$B = ImageFactory.class$("[B")) : array$B, true);
                byte[] a = new byte[r.length];
                Arrays.fill(a, trans.length, r.length, (byte)-1);
                System.arraycopy(trans, 0, a, 0, trans.length);
                return new IndexColorModel(outputDepth, r.length, r, g, b, a);
            }
            int trans = -1;
            if (props.containsKey("transparency")) {
                trans = ((int[])png.getProperty("transparency", array$I == null ? (array$I = ImageFactory.class$("[I")) : array$I, true))[0];
            }
            return new IndexColorModel(outputDepth, r.length, r, g, b, trans);
        }
        int dataType = outputDepth == 16 ? 1 : 0;
        int colorSpace = colorType == 0 || colorType == 4 ? 1003 : 1000;
        int transparency = png.getTransparency();
        return new ComponentColorModel(ColorSpace.getInstance(colorSpace), null, transparency != 1, false, transparency, dataType);
    }

    private static void applyGamma(byte[] palette, short[] gammaTable) {
        if (gammaTable != null) {
            for (int i = 0; i < palette.length; ++i) {
                palette[i] = (byte)gammaTable[0xFF & palette[i]];
            }
        }
    }

    private static short[] getIdentityTable(int bitDepth) {
        int size = 1 << bitDepth;
        short[] table = new short[size];
        for (int i = 0; i < size; ++i) {
            table[i] = (short)i;
        }
        return table;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

