/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

class Chunk_cHRM
extends Chunk {
    protected long xwlong;
    protected long ywlong;
    protected long xrlong;
    protected long yrlong;
    protected long xglong;
    protected long yglong;
    protected long xblong;
    protected long yblong;
    protected double xw;
    protected double yw;
    protected double xr;
    protected double yr;
    protected double xg;
    protected double yg;
    protected double xb;
    protected double yb;
    protected double Xw;
    protected double Yw;
    protected double Zw;
    protected double Xr;
    protected double Yr;
    protected double Zr;
    protected double Xg;
    protected double Yg;
    protected double Zg;
    protected double Xb;
    protected double Yb;
    protected double Zb;

    Chunk_cHRM() {
        super(Chunk.cHRM);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void calc() {
        double d = 1.0 - (this.xr + this.yr);
        double d2 = 1.0 - (this.xg + this.yg);
        double d3 = 1.0 - (this.xb + this.yb);
        double d4 = 1.0 - (this.xw + this.yw);
        this.Xw = this.xw / this.yw;
        this.Yw = 1.0;
        this.Zw = d4 / this.yw;
        double d5 = this.xr * (this.yg * d3 - d2 * this.yb) - this.xg * (this.yr * d3 - d * this.yb) + this.xb * (this.yr * d2 - d * this.yg);
        double d6 = (this.Xw * (this.yg * d3 - d2 * this.yb) - this.xg * (d3 - this.Zw * this.yb) + this.xb * (d2 - this.Zw * this.yg)) / d5;
        double d7 = (this.xr * (d3 - this.Zw * this.yb) - this.Xw * (this.yr * d3 - d * this.yb) + this.xb * (this.yr * this.Zw - d)) / d5;
        double d8 = (this.xr * (this.yg * this.Zw - d2) - this.xg * (this.yr * this.Zw - d) + this.Xw * (this.yr * d2 - d * this.yg)) / d5;
        this.Xr = d6 * this.xr;
        this.Yr = d6 * this.yr;
        this.Zr = d6 * d;
        this.Xg = d7 * this.xg;
        this.Yg = d7 * this.yg;
        this.Zg = d7 * d2;
        this.Xb = d8 * this.xb;
        this.Yb = d8 * this.yb;
        this.Zb = d8 * d3;
        if (this.img.getChunk(Chunk.sRGB) == null) {
            this.img.data.properties.put("chromaticity xy", new long[][]{{this.xwlong, this.ywlong}, {this.xrlong, this.yrlong}, {this.xglong, this.yglong}, {this.xblong, this.yblong}});
            this.img.data.properties.put("chromaticity xyz", new double[][]{{this.Xw, this.Yw, this.Zw}, {this.Xr, this.Yr, this.Zr}, {this.Xg, this.Yg, this.Zg}, {this.Xb, this.Yb, this.Zb}});
        }
    }

    protected void readData() throws IOException {
        if (this.img.data.palette != null) {
            throw new PngException("cHRM chunk must precede PLTE chunk");
        }
        if (this.length != 32) {
            this.badLength(32);
        }
        this.xwlong = this.in_data.readUnsignedInt();
        this.xw = (double)this.xwlong / 100000.0;
        this.checkRange(this.xw, "white");
        this.ywlong = this.in_data.readUnsignedInt();
        this.yw = (double)this.ywlong / 100000.0;
        this.checkRange(this.yw, "white");
        this.xrlong = this.in_data.readUnsignedInt();
        this.xr = (double)this.xrlong / 100000.0;
        this.checkRange(this.xr, "red");
        this.yrlong = this.in_data.readUnsignedInt();
        this.yr = (double)this.yrlong / 100000.0;
        this.checkRange(this.yr, "red");
        this.xglong = this.in_data.readUnsignedInt();
        this.xg = (double)this.xglong / 100000.0;
        this.checkRange(this.xg, "green");
        this.yglong = this.in_data.readUnsignedInt();
        this.yg = (double)this.yglong / 100000.0;
        this.checkRange(this.yg, "green");
        this.xblong = this.in_data.readUnsignedInt();
        this.xb = (double)this.xblong / 100000.0;
        this.checkRange(this.xb, "blue");
        this.yblong = this.in_data.readUnsignedInt();
        this.yb = (double)this.yblong / 100000.0;
        this.checkRange(this.yb, "blue");
        this.calc();
    }

    private void checkRange(double d, String string) throws PngException {
        if (d < 0.0 || d > 0.8) {
            throw new PngExceptionSoft("Invalid cHRM " + string + " point");
        }
    }
}

