<?php
/**
 * The exception marker for the Kolab_Storage system.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_Storage
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */

/**
 * This class provides the standard error class for Kolab Storage exceptions.
 *
 * Copyright 2009-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Kolab
 * @package  Kolab_Storage
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */
class Horde_Kolab_Storage_Exception extends Horde_Exception_Wrapped
{
    /**
     * Constants to define the error type.
     */

    /**
     * The specified folder already exists.
     */
    const FOLDER_EXISTS = 10;

    /**
     * The name of the folder has not been specified.
     */
    const FOLDER_NAME_UNSET = 50;

}
