unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus,
  ImgList, SynEdit, SynEditHighlighter, SynHighlighterNyquist,
  ActnList, StdActns, ComCtrls, ShellAPI, MRUFList;
  
const
  interval = 0.3;

type
  TMainForm = class(TForm)
    StatusLine: TStatusBar;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    PrintDialog: TPrintDialog;
    PrintSetupDialog: TPrinterSetupDialog;
    MainMenu: TMainMenu;
    FileMenuItem: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    FileN1: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    FileN2: TMenuItem;
    FilePageSetupItem: TMenuItem;
    FilePrintItem: TMenuItem;
    FileN3: TMenuItem;
    FileExitItem: TMenuItem;
    EditMenuItem: TMenuItem;
    EditUndoItem: TMenuItem;
    EditRedoItem: TMenuItem;
    EditN1: TMenuItem;
    EditCutItem: TMenuItem;
    EditCopyItem: TMenuItem;
    EditPasteItem: TMenuItem;
    EditDeleteItem: TMenuItem;
    EditN2: TMenuItem;
    EditFindItem: TMenuItem;
    EditReplaceItem: TMenuItem;
    EditGoToItem: TMenuItem;
    WindowMenuItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowArrageAllItem: TMenuItem;
    ControlBar: TControlBar;
    FileSpeedBar: TPanel;
    SpeedButtonNew: TSpeedButton;
    SpeedButtonOpen: TSpeedButton;
    SpeedButtonSave: TSpeedButton;
    HelpMenuItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    HelpIndexItem: TMenuItem;
    HelpContentsItem: TMenuItem;
    HelpN1: TMenuItem;
    SynEditCommand: TSynEdit;
    FindDialog: TFindDialog;
    WindowOutputItem: TMenuItem;
    LeftDockPanel: TPanel;
    LeftVSplitter: TSplitter;
    BottomDockPanel: TPanel;
    BottomHSplitter: TSplitter;
    WindowMinimizeAllItem: TMenuItem;
    WindowTileVerticallyItem: TMenuItem;
    ActionList: TActionList;
    EditCopy: TEditCopy;
    EditCut: TEditCut;
    EditPaste: TEditPaste;
    EditSelectAll: TEditSelectAll;
    EditUndo: TEditUndo;
    HelpContents: THelpContents;
    HelpTopicSearch: THelpTopicSearch;
    WindowArrange: TWindowArrange;
    WindowCascade: TWindowCascade;
    WindowClose: TWindowClose;
    WindowMinimizeAll: TWindowMinimizeAll;
    WindowTileHorizontal: TWindowTileHorizontal;
    WindowTileVertical: TWindowTileVertical;
    MenuImageList: TImageList;
    EditN3: TMenuItem;
    EditSelectAllItem: TMenuItem;
    RightDockPanel: TPanel;
    RightVSplitter: TSplitter;
    EditDelete: TEditDelete;
    ReplaceDialog: TReplaceDialog;
    TopHSplitter: TSplitter;
    TopDockPanel: TPanel;
    LoadSpeedBar: TPanel;
    SpeedButtonLoad: TSpeedButton;
    SpeedButtonSound: TSpeedButton;
    SpeedButtonInfo: TSpeedButton;
    ProcessSpeedBar: TPanel;
    SpeedButtonBreak: TSpeedButton;
    SpeedButtonTop: TSpeedButton;
    SpeedButtonUp: TSpeedButton;
    SpeedButtonContinue: TSpeedButton;
    ProcessMenuItem: TMenuItem;
    ProcessLoadItem: TMenuItem;
    ProcessN1: TMenuItem;
    ProcessBreakItem: TMenuItem;
    ProcessContinueItem: TMenuItem;
    ProcessTopItem: TMenuItem;
    WindowN1: TMenuItem;
    ProcessUpItem: TMenuItem;
    ProcessReplayItem: TMenuItem;
    ProcessInfoItem: TMenuItem;
    PopupMenu: TPopupMenu;
    PopupTopicSearchItem: TMenuItem;
    PopupN1: TMenuItem;
    PopupLoadSelectedItem: TMenuItem;
    PopupN2: TMenuItem;
    PopupCopyItem: TMenuItem;
    PopupPasteItem: TMenuItem;
    PopupCutItem: TMenuItem;
    SynNyquistSyn: TSynNyquistSyn;
    FileCloseAllItem: TMenuItem;
    MRUFileList: TdfsMRUFileList;
    PopupSelectItem: TMenuItem;
    N1: TMenuItem;
    ParenMatchingItem: TMenuItem;
    HelpTipsItem: TMenuItem;
    SpeedButtonPlot: TSpeedButton;
    ProcessSPlotItem: TMenuItem;
    TimerPlot: TTimer;
    ProcessFuncKeysItem: TMenuItem;
    KeysF2Item: TMenuItem;
    KeysF3Item: TMenuItem;
    KeysF5Item: TMenuItem;
    KeysF4Item: TMenuItem;
    KeysF9Item: TMenuItem;
    KeysF8Item: TMenuItem;
    KeysF7Item: TMenuItem;
    KeysF6Item: TMenuItem;
    KeysF10Item: TMenuItem;
    KeysF11Item: TMenuItem;
    KeysF12Item: TMenuItem;
    FuncKeysSpeedBar: TPanel;
    SpeedButtonF2: TSpeedButton;
    SpeedButtonF3: TSpeedButton;
    SpeedButtonF4: TSpeedButton;
    SpeedButtonF5: TSpeedButton;
    SpeedButtonF6: TSpeedButton;
    SpeedButtonF7: TSpeedButton;
    SpeedButtonF8: TSpeedButton;
    SpeedButtonF9: TSpeedButton;
    SpeedButtonF10: TSpeedButton;
    SpeedButtonF11: TSpeedButton;
    SpeedButtonF12: TSpeedButton;
    procedure CreateMDIChild(const Name: string);    
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileNew(Sender: TObject);
    procedure FileOpen(Sender: TObject);
    procedure FileSave(Sender: TObject);
    procedure FileSaveAs(Sender: TObject);
    procedure FilePrint(Sender: TObject);
    procedure FilePrintSetup(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure HelpAbout(Sender: TObject);
    procedure EditFind(Sender: TObject);
    procedure WindowOutputItemClick(Sender: TObject);
    procedure LeftDockPanelDockOver(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean);
    procedure BottomDockPanelDockOver(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean);
    procedure LeftDockPanelUnDock(Sender: TObject; Client: TControl;
      NewTarget: TWinControl; var Allow: Boolean);
    procedure ShowDockPanel(APanel: TPanel; MakeVisible: Boolean; Client: TControl);
    procedure LeftDockPanelDockDrop(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer);
    procedure BottomDockPanelDockDrop(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer);
    procedure RightDockPanelDockOver(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean);
    procedure SetFileName(const FileName: String);
    function  GetModified: Boolean;
    procedure SetModified(Value: Boolean);
    procedure EditReplaceItemClick(Sender: TObject);
    procedure TopDockPanelDockOver(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean);
    procedure EditRedoItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SynEditCommandKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditMenuItemClick(Sender: TObject);
    //procedure FileItemMeasureItem(Sender: TObject; ACanvas: TCanvas;
    //  var Width, Height: Integer);
    procedure LoadFile(Sender: TObject);
    procedure SpeedButtonUpClick(Sender: TObject);
    procedure SpeedButtonTopClick(Sender: TObject);
    procedure SpeedButtonInfoClick(Sender: TObject);
    procedure SpeedButtonSoundClick(Sender: TObject);
    procedure SpeedButtonBreakClick(Sender: TObject);
    procedure SpeedButtonContinueClick(Sender: TObject);
    Procedure ShowOutput();
    procedure FindDialogFind(Sender: TObject);
    procedure ReplaceDialogFind(Sender: TObject);
    procedure EditGoToItemClick(Sender: TObject);
    Procedure GotoLine(LineNumber: Integer);
    procedure PopupLoadSelectedItemClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure HelpContentsItemClick(Sender: TObject);
    procedure HelpIndexItemClick(Sender: TObject);
    procedure OpenDialogClose(Sender: TObject);
    procedure MRUFileListMRUItemClick(Sender: TObject; AFilename: String);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FileCloseAllItemClick(Sender: TObject);
    procedure SynEditCommandEnter(Sender: TObject);
    procedure SynEditCommandDblClick(Sender: TObject);
    procedure PopupSelectItemClick(Sender: TObject);
    procedure ParenMatchingItemClick(Sender: TObject);
    procedure HelpTipsItemClick(Sender: TObject);
    procedure SpeedButtonPlotClick(Sender: TObject);
    procedure CreatePlotChild(const Name: string);
    procedure TimerPlotTimer(Sender: TObject);
    procedure MenuEnabled(bValue: Boolean);
    procedure FuncKeysItemClick(Sender: TObject);
    procedure ChangeDirectory(sDir: String);
  end;

var
  MainForm: TMainForm;
  OutputView, WorkspaceView: boolean;
  RemNow: Integer;
  RemStrings, CommandStr, OutputStr: TStringList;
  OriDir, CurDir: String;
  PlotNow: Integer;
  PlotDataFile: String;
  PlotDataPts: Integer;
  AllowInput: Boolean;
implementation

uses PlotWin, Output, ChildWin, About, GotoLN, PlotDlg;

resourcestring
  sSaveChanges = 'Save changes to %s?';
  sOverWrite = 'OK to overwrite %s';
  sUntitled = 'Untitled%d';
  csUntitled = 'Untitled';
  sModified = 'Modified';
  sPlotWindow = 'Plot Window %d';
  sColRowInfo = 'Line: %3d   Col: %3d';

{$R *.DFM}

Procedure TMainForm.ShowOutput();
var i: Integer;
begin
  if {Output.AllowInput and }(OutputStr.Count>0) then
    with OutputForm.OutputMemo.Lines do
     begin
      if pos('> ', Strings[Count-1]) = length(Strings[Count-1])-1 then
        Strings[Count-1] := Strings[Count-1] + OutputStr.Strings[0]
      else Add(OutputStr.Strings[0]);
      for i:= 2 to OutputStr.Count do
        Add(OutputStr.Strings[i-1]);
      OutputStr.Clear;
      Output.Newline := true;
     end;
end;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  if FileExists(Name) then Child.SynEdit.Lines.LoadFromFile(Name);
  Child.BringToFront;
  FileCloseItem.Enabled := true;
  FileCloseAllItem.Enabled := true;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  OriDir := GetCurrentDir;
  WindowOutputItemClick(Sender);
  RemNow := 0;
  RemStrings := TStringList.Create;
  CommandStr := TStringList.Create;
  OutputStr := TStringList.Create;
  AboutBox := TAboutBox.Create(Self);
  GotoBox := TGotoBox.Create(Self);
  PlotDataDlg := TPlotDataDlg.Create(Self);
  //PlotChild := TPlotChild.Create(Self);
  CurDir := GetCurrentDir;
  PlotNow := 0;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.Panels[0].Text := application.Hint;
end;

procedure TMainForm.FileNew(Sender: TObject);
begin
  { Add code to create a new file }
  CreateMDIChild(format(sUntitled, [MDIChildCount + 1]));
  SetModified(False);
end;

procedure TMainForm.FileOpen(Sender: TObject);
var bFind: Boolean;
    i: Integer;
begin
  if OpenDialog.Execute then
  begin
    { Add code to open OpenDialog.FileName }
    i := MDIChildCount;
    bFind := false;
    repeat
      i := i - 1;
      if MDIChildren[i].Caption = OpenDialog.FileName then bFind := true;
    until (i <= 0) or bFind;
    if bFind then MainForm.MDIChildren[i].BringToFront
    else
    begin
      CreateMDIChild(OpenDialog.FileName);
    end;
  end;
end;

procedure TMainForm.FileSave(Sender: TObject);
begin
   { Add code to save current file under current name }
 try
  if (ActiveMDIChild <>nil) and (ActiveMDIChild is TMDIChild) then
  begin
    if pos(csUntitled, ActiveMDIChild.Caption) = 1 then
      FileSaveAs(Sender)
    else if GetModified then
      begin
        (ActiveMDIChild as TMDIChild).SynEdit.Lines.SaveToFile(ActiveMDIChild.Caption);
        SetModified(False);
        ChangeDirectory(ExtractFileDir(ActiveMDIChild.Caption));
      end;
  end;
 except
   on E: Exception do
     MessageDlg(E.Message + #13 + 'The file is still opened by Nyquist process, please use (Top) to close the file(exit the error state).', mtError, [mbOK], E.HelpContext);
 end;
end;

procedure TMainForm.FileSaveAs(Sender: TObject);
var bFind: Boolean;
    i: Integer;
begin
  if (ActiveMDIChild <>nil) and (ActiveMDIChild is TMDIChild) and SaveDialog.Execute then
  begin
    { Add code to save current file under SaveDialog.FileName }
    if FileExists(SaveDialog.FileName) then
    begin
      i := MDIChildCount;
      bFind := false;
      repeat
        i := i - 1;
        if (MDIChildren[i] <> ActiveMDIChild) and (MDIChildren[i].Caption = SaveDialog.FileName) then bFind := true;
      until (i <= 0) or bFind;
      if bFind then
      begin
        MessageDlg(SaveDialog.FileName + #13 + 'This file is open for editing and cannot be overwritten.' + #13 + 'Please use a different name.', mtWarning, [mbOk], 0);
        Exit;
      end;
      if MessageDlg(Format(sOverWrite, [SaveDialog.FileName]),
        mtConfirmation, mbYesNoCancel, 0) <> idYes then Exit;
    end;
    if pos('.', SaveDialog.FileName) = 0 then SaveDialog.FileName := SaveDialog.Filename + '.lsp';
    (ActiveMDIChild as TMDIChild).SynEdit.Lines.SaveToFile(SaveDialog.FileName);
    SetFileName(SaveDialog.FileName);
    SetModified(False);
    ChangeDirectory(ExtractFileDir(SaveDialog.FileName));
  end;
end;

procedure TMainForm.FilePrint(Sender: TObject);
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) and PrintDialog.Execute then
  begin
    { Add code to print current file }
  (ActiveMDIChild as TMDIChild).Print;
  end;
end;

procedure TMainForm.FilePrintSetup(Sender: TObject);
begin
  PrintSetupDialog.Execute;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.HelpAbout(Sender: TObject);
begin
  { Add code to show program's About Box }
  AboutBox.Show;
end;

procedure TMainForm.EditFind(Sender: TObject);
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
    FindDialog.Execute;
end;

procedure TMainForm.WindowOutputItemClick(Sender: TObject);
begin
  if OutputForm = nil then
  //Judge whether the form is already exist, otherwise re-create it
  begin
    OutputForm:=TOutputForm.Create(Self);
    OutputForm.Parent:=Self;
  end;
  OutputForm.WindowState:=wsNormal;
  OutputForm.Show;
  OutputForm.BringToFront;
  OutputForm.ManualDock(LeftDockPanel, nil, alNone);
  WindowOutputItem.Checked := true;
end;

procedure TMainForm.LeftDockPanelDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
var
  ARect: TRect;
begin
//  Accept := Source.Control is TDockableForm;
//  if Accept then
//  begin
    //Modify the DockRect to preview dock area.
    ARect.TopLeft := LeftDockPanel.ClientToScreen(Point(0, 0));
    ARect.BottomRight := LeftDockPanel.ClientToScreen(
      Point(Self.ClientWidth div 3, LeftDockPanel.Height));
    Source.DockRect := ARect;
//  end;
end;

procedure TMainForm.BottomDockPanelDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
var
  ARect: TRect;
begin
//  Accept := Source.Control is TDockableForm;
//  if Accept then
//  begin
    //Modify the DockRect to preview dock area.
    ARect.TopLeft := BottomDockPanel.ClientToScreen(
      Point(0, -Self.ClientHeight div 3));
    ARect.BottomRight := BottomDockPanel.ClientToScreen(
      Point(BottomDockPanel.Width, BottomDockPanel.Height));
    Source.DockRect := ARect;
//  end;
end;

procedure TMainForm.LeftDockPanelUnDock(Sender: TObject; Client: TControl;
  NewTarget: TWinControl; var Allow: Boolean);
begin
  //OnUnDock gets called BEFORE the client is undocked, in order to optionally
  //disallow the undock. DockClientCount is never 0 when called from this event.
  if (Sender as TPanel).DockClientCount = 1 then
    ShowDockPanel(Sender as TPanel, False, nil);
end;

procedure TMainForm.ShowDockPanel(APanel: TPanel; MakeVisible: Boolean; Client: TControl);
begin
  //Client - the docked client to show if we are re-showing the panel.
  //Client is ignored if hiding the panel.

  //Since docking to a non-visible docksite isn't allowed, instead of setting
  //Visible for the panels we set the width to zero. The default InfluenceRect
  //for a control extends a few pixels beyond it's boundaries, so it is possible
  //to dock to zero width controls.

  //Don't try to hide a panel which has visible dock clients.
  if not MakeVisible and (APanel.VisibleDockClientCount > 1) then
    Exit;

  if APanel = LeftDockPanel then
    LeftVSplitter.Visible := MakeVisible
  else if APanel = RightDockPanel then
    RightVSplitter.Visible := MakeVisible
  else if APanel = TopDockPanel then
    TopHSplitter.Visible := MakeVisible
  else
    BottomHSplitter.Visible := MakeVisible;

    if MakeVisible then
      if APanel = LeftDockPanel then
      begin
        APanel.Width := ClientWidth div 3;
        //LeftVSplitter.Left := APanel.Width;
      end
      else if APanel = RightDockPanel then
      begin
        APanel.Width := ClientWidth div 3;
        //RightVSplitter.Left := ClientWidth - APanel.Width - RightVSplitter.Width;
      end
      else if APanel = TopDockPanel then
      begin
        APanel.Height := ClientHeight div 3;
        //TopHSplitter.top := APanel.Height;
      end
      else begin
        APanel.Height := ClientHeight div 3;
        //BottomHSplitter.Top := ClientHeight - APanel.Height - BottomHSplitter.Width;
      end
    else
      if (APanel = LeftDockPanel) or (APanel = RightDockPanel) then
        APanel.Width := 0
      else
        APanel.Height := 0;
  if MakeVisible and (Client <> nil) then Client.Show;
end;

procedure TMainForm.LeftDockPanelDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  //OnDockDrop gets called AFTER the client has actually docked,
  //so we check for DockClientCount = 1 before making the dock panel visible.
  if (Sender as TPanel).DockClientCount = 1 then
    ShowDockPanel(Sender as TPanel, True, nil);
  (Sender as TPanel).DockManager.ResetBounds(True);
  //Make DockManager repaints it's clients.
end;

procedure TMainForm.BottomDockPanelDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  //OnDockDrop gets called AFTER the client has actually docked,
  //so we check for DockClientCount = 1 before making the dock panel visible.
  if (Sender as TPanel).DockClientCount = 1 then
    ShowDockPanel(Sender as TPanel, True, nil);
  (Sender as TPanel).DockManager.ResetBounds(True);
  BottomDockPanel.Top := BottomDockPanel.Top - StatusLine.top;
//  BottomHSplitter.Height := 3;
//  BottomHSplitter.Top := ClientHeight - StatusLine.Height - BottomDockPanel.Height - BottomHSplitter.Height;
  BottomHSplitter.Top := 0;
  //Make DockManager repaints it's clients.
end;

procedure TMainForm.RightDockPanelDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
var
  ARect: TRect;
begin
//  Accept := Source.Control is TDockableForm;
//  if Accept then
//  begin
    //Modify the DockRect to preview dock area.
    ARect.TopLeft := RightDockPanel.ClientToScreen(Point((2 * Self.ClientWidth) div 3, 0));
    ARect.BottomRight := RightDockPanel.ClientToScreen(
      Point(Self.ClientWidth, RightDockPanel.Height));
    Source.DockRect := ARect;
//  end;

end;

{
procedure TMainForm.FileItemMeasureItem(Sender: TObject;
  ACanvas: TCanvas; var Width, Height: Integer);
begin
  if Self.MDIChildCount>0 then (Sender as TMenuItem).Enabled := true
  else (Sender as TMenuItem).Enabled := false;
end;
}

procedure TMainForm.SetFileName(const FileName: String);
begin
  ActiveMDIChild.Caption := FileName;
//  Caption := Format('%s - %s', [ExtractFileName(FileName), Application.Title]);
end;

function TMainForm.GetModified: Boolean;
begin
  if (StatusLine.Panels[2].Text = sModified) then
    GetModified := true
  else GetModified := false;
end;

procedure TMainForm.SetModified(Value: Boolean);
begin
  if Value then StatusLine.Panels[2].Text := sModified
  else
    begin
      StatusLine.Panels[2].Text := '';
      if (ActiveMDIChild is TMDIChild) then
        (ActiveMDIchild as TMDIChild).SynEdit.Modified := false;
    end;
end;

procedure TMainForm.EditReplaceItemClick(Sender: TObject);
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
    ReplaceDialog.Execute;
end;

procedure TMainForm.TopDockPanelDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
var
  ARect: TRect;
begin
//  Accept := Source.Control is TDockableForm;
//  if Accept then
//  begin
    //Modify the DockRect to preview dock area.
    ARect.TopLeft := TopDockPanel.ClientToScreen(Point(0,0));
    ARect.BottomRight := TopDockPanel.ClientToScreen(
      Point(TopDockPanel.Width, Self.ClientHeight div 3));
    Source.DockRect := ARect;
//  end;
end;

procedure TMainForm.EditRedoItemClick(Sender: TObject);
begin
  if SynEditCommand.Focused then
    SynEditCommand.redo
  else if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) and (ActiveMDIChild as TMDIChild).SynEdit.Focused then
    (ActiveMDIChild as TMDIChild).SynEdit.redo;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  OutputForm.Destroy;
end;

{function InString:Boolean;
var x: Integer;
    nowstring: Boolean;
begin
  x := 0;
  nowstring := false;
  repeat
    x := x + 1;
    if SynEditCommand.text[x] = """" then nowstring := not nowstring;

  until nowstring = false;
end;

 }
procedure TMainForm.SynEditCommandKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);

  procedure RoundClose();
  var
    findx, findy, round, oldx, oldy: integer;
    find, insert: boolean;
    starttime, fractime: double;
    Token: string;
    Attri: TSynHighlighterAttributes;
  begin
    with SynEditCommand do
      begin
        if (GetHighlighterAttriAtRowCol(Point(CaretX-1,CaretY), Token, Attri)) and (Attri.Name = 'Symbol') then
          begin
            findx := CaretX - 1;
            findy := CaretY;
            find := false;
            round := 0;
            repeat
              findx := findx - 1;
              if findx <= 0 then
                begin
                  findy:= findy-1;
                  if findy>0 then findx := length(Lines[findy - 1]);
                end;
              if (findy>0) and (findx>0) then
                begin
                  if (Lines[findy - 1][findx] = ')') and (GetHighlighterAttriAtRowCol(Point(findx,findy), Token, Attri)) and (Attri.Name = 'Symbol')
                    then round := round + 1;
                  if (Lines[findy - 1][findx] = '(') and (GetHighlighterAttriAtRowCol(Point(findx,findy), Token, Attri)) and (Attri.Name = 'Symbol')
                    then if round>0 then round := round -1
                         else find := true;
                end;
            until find or (findy <= 0);
            if find then
              begin
                oldx := CaretX;
                oldy := CaretY;
                CaretX := findx;
                CaretY := findy;
                insert := InsertMode;
                InsertMode := false;
                SynEditCommand.Repaint;
                starttime := now;
                fractime := interval/(60*60*24);
                repeat
                until now-starttime >=fractime;
                CaretX := oldx;
                CaretY := oldy;
                InsertMode := insert;
              end;
          end;
      end;
  end;
begin
  if {Output.AllowInput and } (key = 13) and (Shift = []) then
    begin
      OutputStr.Text := Trim(SynEditCommand.Lines.Text);          //new version 2002
      {         //old version 2001
      with OutputStr do
        begin
//          Strings[Count-1]:= Strings[Count-1] + SynEditCommand.Lines.Strings[0] + #0;
          for i := 1 to SynEditCommand.Lines.Count do
            Add(SynEditCommand.Lines.Strings[i-1]);
        end;
      }
      ShowOutput;
      Output.Newline := true;
      OutputForm.WriteToPipe(SynEditCommand.Lines);
      RemStrings.Add(SynEditCommand.Lines.Text);
      RemNow := RemStrings.Count;
//      SynEditCommand.SelectAll;
      SynEditCommand.ClearAll;
    end
  else if (Shift = [ssAlt]) and (Key in [38,40]) then
    begin
      case Key of
      38 : if RemNow > 0 then RemNow := RemNow - 1;
      40 : if RemNow < RemStrings.Count - 1 then RemNow := RemNow + 1;
      end;
      if RemNow < RemStrings.Count then
        SynEditCommand.Lines.Text := RemStrings.Strings[RemNow];
    end
  else if (ParenMatchingItem.Checked = true) and (Shift = [ssShift]) and (Key = 48) then
    RoundClose();
end;

procedure TMainForm.EditMenuItemClick(Sender: TObject);
begin
  if SynEditCommand.Focused then
    EditRedoItem.Enabled := SynEditCommand.CanRedo
  else if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) and (ActiveMDIChild as TMDIChild).SynEdit.Focused then
    EditRedoItem.Enabled := (ActiveMDIChild as TMDIChild).SynEdit.CanRedo;
end;

procedure RunCommand(str: String);
begin
   with OutputStr do
     Add(str);
//     Strings[Count-1]:= Strings[Count-1] + str;
//  Output.Newline := true;
  MainForm.ShowOutput;
  CommandStr.Text := str;
  OutputForm.WriteToPipe(CommandStr);
end;

procedure TMainForm.LoadFile(Sender: TObject);
var
    signpos: Integer;
    tempstr, cutstr: string;
begin
 // if Output.AllowInput and (Self.ActiveMDIChild <>nil) then
  if (ActiveMDIChild <>nil) and (ActiveMDIChild is TMDIChild) then
  begin
    FileSave(Sender);
    if (not GetModified) and (pos(csUntitled, ActiveMDIChild.Caption) <> 1) then
      begin
        tempstr := '(load "' + ActiveMDIChild.Caption +'")';
//        CommandStr.Text := '(load "' + ActiveMDIChild.Caption +'")';
        signpos := pos('\', tempstr);
        cutstr := '';
        while (signpos<>0) do
          begin
            cutstr := cutstr + copy(tempstr, 1, signpos) + '\';
            tempstr := copy(tempstr, signpos+1, length(tempstr)-signpos);
            signpos := pos('\', tempstr);
          end;
        cutstr:= cutstr + tempstr;
        RunCommand(cutstr);
      end;
  end;
end;

procedure TMainForm.SpeedButtonUpClick(Sender: TObject);
begin
//  if Output.AllowInput then
//    RunCommand(concat(#$07,#0));     // control-g = up level
    RunCommand('(up)');
end;

procedure TMainForm.SpeedButtonTopClick(Sender: TObject);
begin
    RunCommand(concat(#13,#0));
    OutputForm.ConsoleKeyboardInput(#$03);
  //if OutputForm.ConsoleKeyboardInput(#$03)<>0 then
  //RunCommand(concat(#$03,#0));     // control-c  = abort
//  RunCommand('(top)');
end;

procedure TMainForm.SpeedButtonInfoClick(Sender: TObject);
begin
//  if Output.AllowInput then
//    RunCommand(concat(#$18,#0));     // control-t
  RunCommand('(info)');
end;

procedure TMainForm.SpeedButtonSoundClick(Sender: TObject);
begin
//  if Output.AllowInput then
    RunCommand('(r)');
end;

procedure TMainForm.SpeedButtonBreakClick(Sender: TObject);
begin
    RunCommand(concat(#13,#0));
  OutputForm.ConsoleKeyboardInput(#$07);   //BREAK_CHAR = $07
end;

procedure TMainForm.SpeedButtonContinueClick(Sender: TObject);
begin
  RunCommand('(continue)');
end;

procedure TMainForm.FindDialogFind(Sender: TObject);
var SearchOptions: TSynSearchOptions;
    FindResult: Integer;
    InfoText: String;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
  begin
    SearchOptions := [];
    if frMatchCase in FindDialog.Options then
      SearchOptions := SearchOptions + [ssoMatchCase];
    if frWholeWord in FindDialog.Options then
      SearchOptions := SearchOptions + [ssoWholeWord];
    if not (frDown in FindDialog.Options) then
      SearchOptions := SearchOptions + [ssoBackwards];
    FindResult := (ActiveMDIChild as TMDIChild).SynEdit.SearchReplace(FindDialog.FindText, '', SearchOptions);
    InfoText := 'Search String ''' + FindDialog.FindText + ''' not found';
    if FindResult <=0 then Application.MessageBox(PChar(InfoText),
                                          'Information', MB_OK+MB_ICONINFORMATION);
  end;
end;

procedure TMainForm.ReplaceDialogFind(Sender: TObject);
var SearchOptions: TSynSearchOptions;
    FindResult: Integer;
    InfoText: String;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
  begin
    SearchOptions := [];
    if frMatchCase in ReplaceDialog.Options then
      SearchOptions := SearchOptions + [ssoMatchCase];
    if frWholeWord in ReplaceDialog.Options then
      SearchOptions := SearchOptions + [ssoWholeWord];
    if frReplace in ReplaceDialog.Options then
      SearchOptions := SearchOptions + [ssoReplace];
    if frReplaceAll in ReplaceDialog.Options then
      SearchOptions := SearchOptions + [ssoReplaceAll];
    FindResult := (ActiveMDIChild as TMDIChild).SynEdit.SearchReplace(ReplaceDialog.FindText, ReplaceDialog.ReplaceText, SearchOptions);
    InfoText := 'Search String ''' + ReplaceDialog.FindText + ''' not found';
    if FindResult <=0 then Application.MessageBox(PChar(InfoText),
                                          'Information', MB_OK+MB_ICONINFORMATION);
  end;
end;

procedure TMainForm.EditGoToItemClick(Sender: TObject);
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
  begin
    GotoBox.ComboBox.Text := IntToStr((ActiveMDIChild as TMDIChild).SynEdit.CaretY);
    GotoBox.Show;
  end;
end;

Procedure TMainForm.GotoLine(LineNumber: Integer);
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
  begin
    (ActiveMDIChild as TMDIChild).SynEdit.CaretY := LineNumber;
  end;
end;
procedure TMainForm.PopupLoadSelectedItemClick(Sender: TObject);
begin
  if SynEditCommand.Focused then
    RunCommand(SynEditCommand.SelText)
  else if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) and (ActiveMDIChild as TMDIChild).SynEdit.Focused then
    RunCommand((ActiveMDIChild as TMDIChild).SynEdit.SelText);
end;

procedure TMainForm.PopupMenuPopup(Sender: TObject);
begin
  if SynEditCommand.Focused then
   begin
    if SynEditCommand.SelText = '' then
      begin
        PopupSelectItem.Enabled := true;
        PopupLoadSelectedItem.Enabled := false;
      end
    else
      begin
        PopupSelectItem.Enabled := false;
        PopupLoadSelectedItem.Enabled := true;
      end;
   end
  else if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) and (ActiveMDIChild as TMDIChild).SynEdit.Focused then
   begin
    if (ActiveMDIChild as TMDIChild).SynEdit.SelText = '' then
      begin
        PopupSelectItem.Enabled := true;
        PopupLoadSelectedItem.Enabled := false;
      end
    else
      begin
        PopupSelectItem.Enabled := false;
        PopupLoadSelectedItem.Enabled := true;
      end;
   end;
end;

procedure TMainForm.HelpContentsItemClick(Sender: TObject);
begin
  if ShellExecute( Application.Handle, 'open', PChar(OriDir + '\doc\home.html'), nil, nil, SW_SHOWNORMAL ) <= 32 then
    if ShellExecute( Application.Handle, 'open', PChar('http://www.cs.cmu.edu/~rbd/doc/nyquist/root.html'), nil, nil, SW_SHOWNORMAL ) <= 32 then
      MessageDlg('Can not find the Help Contents file!', mtError, [mbOK], 0);
end;

procedure TMainForm.HelpIndexItemClick(Sender: TObject);
begin
  if ShellExecute( Application.Handle, 'open', PChar(OriDir + '\doc\indx.html'), nil, nil, SW_SHOWNORMAL ) <= 32 then
    if ShellExecute( Application.Handle, 'open', PChar('http://www.cs.cmu.edu/~rbd/doc/nyquist/indx.html'), nil, nil, SW_SHOWNORMAL ) <= 32 then
      MessageDlg('Can not find the Help Index file!', mtError, [mbOK], 0);
end;

procedure TMainForm.HelpTipsItemClick(Sender: TObject);
begin
  if ShellExecute( Application.Handle, 'open', PChar(OriDir + '\doc\Tips.htm'), nil, nil, SW_SHOWNORMAL ) <= 32 then
//    if ShellExecute( Application.Handle, 'open', PChar('http://www.cs.cmu.edu/~rbd/doc/nyquist/indx.html'), nil, nil, SW_SHOWNORMAL ) <= 32 then
      MessageDlg('Can not find the NyqIDE Tips file!', mtError, [mbOK], 0);
end;

procedure TMainForm.OpenDialogClose(Sender: TObject);
begin
  ChangeDirectory(GetCurrentDir);
end;

procedure TMainForm.MRUFileListMRUItemClick(Sender: TObject;
  AFilename: String);
begin
  ChangeDirectory(ExtractFileDir(AFilename));
  CreateMDIChild(AFileName);
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  try
    CanClose := true;
    if AllowInput = false then
      case Application.MessageBox('Calculate session in progress. Terminate?', 'Information', MB_OKCANCEL+MB_ICONINFORMATION) of
        IDOK: SpeedButtonBreakClick(Sender);
        IDCancel: Abort;
      end;
    //FileCloseAllItemClick(Sender);
    MRUFileList.Save;
  except
    CanClose := False;
  end;
end;

procedure TMainForm.FileCloseAllItemClick(Sender: TObject);
var i: Integer;
begin
  for i := Self.MDIChildCount-1 downto 0 do
    if Self.MDIChildren[i] is TMDIChild then
    begin
      if (Self.MDIChildren[i] As TMDIChild).CloseQuery then
        (Self.MDIChildren[i] As TMDIChild).Close
      else Exit;
    end
    else (Self.MDIChildren[i] As TPlotChild).Close;
end;

procedure TMainForm.SynEditCommandEnter(Sender: TObject);
begin
  with SynEditCommand do
    if CaretX-1 > length(Lines[CaretY-1]) then CaretX := length(Lines[CaretY-1])+1;
end;

procedure TMainForm.SynEditCommandDblClick(Sender: TObject);
var OldX, OldY, findx, findy, round: integer;
begin
  with SynEditCommand do
    if (CaretY<=Lines.Count) and (CaretX<=length(Lines[CaretY-1])) and (Lines[CaretY-1][CaretX] = '(') then
      begin
        OldX := CaretX;
        OldY := CaretY;
        findx := CaretX;
        findy := CaretY-1;
        BlockBegin := CaretXY;
        round := 1;
        repeat
          if findy<Lines.Count then
            begin
              findx := findx + 1;
              if (findx<=length(Lines[findy])) then
               begin
                case Lines[findy][findx] of
                  '(': round := round + 1;
                  ')': round := round - 1;
                end;
               end
              else
                begin
                  findx := 0;
                  findy := findy + 1;
                end;
            end;
        until (round = 0) or (findy >= Lines.Count);
        if round = 0 then
         begin
          CaretX := findx + 1;
          CaretY := findy + 1;
         end;
        BlockEnd := CaretXY;
        CaretX := OldX;
        CaretY := OldY;
      end;
end;

procedure TMainForm.PopupSelectItemClick(Sender: TObject);
begin
  if SynEditCommand.Focused then
    SynEditCommandDblClick(Sender)
  else if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) and (ActiveMDIChild as TMDIChild).SynEdit.Focused then
    (ActiveMDIChild as TMDIChild).SynEditDblClick(Sender);
end;

procedure TMainForm.ParenMatchingItemClick(Sender: TObject);
begin
  ParenMatchingItem.Checked := not ParenMatchingItem.Checked;
end;

procedure TMainForm.SpeedButtonPlotClick(Sender: TObject);
begin
  if PlotDataDlg.ShowModal = mrOK then
    begin
      RunCommand(PlotDataDlg.LabelPlot.Caption);
    end;
end;

procedure TMainForm.CreatePlotChild(const Name: string);
var
  Child: TPlotChild;
  fData: TextFile;
  dx, dy:array of Double;
  i: Integer;
begin
  if FileExists(Name) then
    begin
      { create a new MDI child window }
      Child := TPlotChild.Create(Application);
      Child.Caption := format(sPlotWindow, [MDIChildCount]) + ' - ' + Name;
      SetLength(dx, PlotDataPts);
      SetLength(dy, PlotDataPts);
      AssignFile(fData, Name);
      Reset(fData);
      i := 0;
      with Child.QLine do
        while not Eof(fData) do
          begin
            readln(fData, dx[i], dy[i]);
            i := i + 1;
          end;
      CloseFile(fData);
      Child.QLine.AddXYArrays(dx, dy, PlotDataPts);
      Child.BringToFront;
    end
  else
    MessageDlg('Can not find the file ' + Name + #13 + 'Please make sure it is correctly generated.', mtError, [mbOK], 0);
end;

procedure TMainForm.TimerPlotTimer(Sender: TObject);
begin
 if (PlotNow = 2) and AllowInput then
   begin
    PlotNow := 0;
    CreatePlotChild(PlotDataFile);
   end;
end;

procedure TMainForm.MenuEnabled(bValue: Boolean);
var bLoadEnabled: Boolean;
begin
  bLoadEnabled := bValue;
  if bValue and not AllowInput then bLoadEnabled := false;
  SpeedButtonLoad.Enabled := bLoadEnabled;
  SpeedButtonSave.Enabled := bValue;
  ProcessLoadItem.Enabled := bLoadEnabled;

  FileSaveItem.Enabled := bValue;
  FileSaveAsItem.Enabled := bValue;
  FilePrintItem.Enabled := bValue;
  EditFindItem.Enabled := bValue;
  EditReplaceItem.Enabled := bValue;
  EditGotoItem.Enabled := bValue;
end;

procedure TMainForm.FuncKeysItemClick(Sender: TObject);
var sTemp:String;
begin
  if Sender is TMenuItem then sTemp := ShortCutToText((Sender as TMenuItem).ShortCut)
  else sTemp := (Sender as TSpeedButton).Caption; 
  RunCommand('(' + sTemp + ')');
end;

procedure TMainForm.ChangeDirectory(sDir: String);
var cDir: String;
    cpos: Integer;
begin
  if CurDir<> sDir then
    begin
      CurDir := sDir;
      cDir := '';
      cpos := Pos('\', sDir);
      while cpos<>0 do
        begin
          cDir := cDir + Copy(sDir, 1, cpos) + '\';
          Delete(sDir, 1, cpos);
          cpos := Pos('\', sDir);
        end;
      cDir := cDir + sDir;
      RunCommand('(setdir "' + cDir + '")');
    end;
end;
end.
