/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.PermissionsAction;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.MailArchiveChannel;
import org.chefproject.core.MailArchiveChannelEdit;
import org.chefproject.core.MailArchiveMessage;
import org.chefproject.core.MessageEdit;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.ContentTypeImageService;
import org.chefproject.service.MailArchiveService;
import org.chefproject.service.PortalService;
import org.chefproject.service.SiteService;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;

public class MailboxAction
extends VelocityPortletPaneledAction {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final String PARAM_CHANNEL = "channel";
    private static final String PARAM_SITE = "site";
    private static final String PARAM_PAGESIZE = "pagesize";
    private static final String FORM_CHANNEL = "channel";
    private static final String FORM_PAGESIZE = "pagesize";
    private static final String FORM_OPEN = "open";
    private static final String VIEW_ID = "view-id";
    private static final String STATE_CHANNEL_REF = "channelId";
    private static final String STATE_ASCENDING = "ascending";
    private static final String STATE_SORT = "sort";
    private static final String STATE_VIEW_ID = "view-id";
    private static final String STATE_VIEW_HEADERS = "view-headers";
    private static final String STATE_TOP_PAGE_MESSAGE = "msg-top";
    private static final String STATE_PAGESIZE = "page-size";
    private static final String STATE_NUM_MESSAGES = "num-messages";
    private static final String STATE_NEXT_PAGE_EXISTS = "msg-next-page";
    private static final String STATE_PREV_PAGE_EXISTS = "msg-prev-page";
    private static final String STATE_GO_NEXT_PAGE = "msg-go-next-page";
    private static final String STATE_GO_PREV_PAGE = "msg-go-prev-page";
    private static final String STATE_GO_NEXT = "msg-go-next";
    private static final String STATE_GO_PREV = "msg-go-prev";
    private static final String STATE_NEXT_EXISTS = "msg-next";
    private static final String STATE_PREV_EXISTS = "msg-prev";
    private static final String STATE_GO_FIRST_PAGE = "msg-go-first-page";
    private static final String STATE_GO_LAST_PAGE = "msg-go-last-page";
    private static final String CHANNEL_MISSING = "This mailbox is not available.";
    private static final String CHANNEL_PERMISSION = "You do not have permission to view this mailbox.";
    private static final String MESSAGE_MISSING = "This email message is not available.";
    private static final String MESSAGE_PERMISSION = "You do not have permission to view this email message.";
    private static final int SORT_FROM = 0;
    private static final int SORT_DATE = 1;
    private static final int SORT_SUBJECT = 2;

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute(STATE_CHANNEL_REF) == null) {
            PortletConfig config = portlet.getPortletConfig();
            state.setAttribute("mode", (Object)"list");
            String channel = StringUtil.trimToNull(config.getInitParameter("channel"));
            if (channel == null) {
                channel = MailArchiveService.channelReference(PortalService.getCurrentSiteId(), "main");
            }
            state.setAttribute(STATE_CHANNEL_REF, (Object)channel);
            if (state.getAttribute(STATE_ASCENDING) == null) {
                state.setAttribute(STATE_ASCENDING, (Object)new Boolean(true));
            }
            if (state.getAttribute(STATE_SORT) == null) {
                state.setAttribute(STATE_SORT, (Object)new Integer(1));
            }
            if (state.getAttribute(STATE_VIEW_HEADERS) == null) {
                state.setAttribute(STATE_VIEW_HEADERS, (Object)new Boolean(false));
            }
            if (state.getAttribute(STATE_PAGESIZE) == null) {
                try {
                    Integer size = new Integer(config.getInitParameter("pagesize"));
                    if (size <= 0) {
                        size = new Integer(20);
                        Log.warn("chef", "MailboxAction.initState: size parameter invalid: " + config.getInitParameter("pagesize"));
                    }
                    state.setAttribute(STATE_PAGESIZE, (Object)size);
                }
                catch (Exception any) {
                    Log.warn("chef", "MailboxAction.initState: size parameter invalid: " + any.toString());
                    state.setAttribute(STATE_PAGESIZE, (Object)new Integer(20));
                }
            }
            if (state.getAttribute("obsever") == null) {
                String deliveryId = this.clientWindowId(state, portlet.getID());
                String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
                Reference r = new Reference(channel);
                String pattern = MailArchiveService.messageReference(r.getContext(), r.getId(), "");
                state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
            }
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        String channel = (String)state.getAttribute(STATE_CHANNEL_REF);
        Reference r = new Reference(channel);
        String pattern = MailArchiveService.messageReference(r.getContext(), r.getId(), "");
        observer.setResourcePattern(pattern);
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String helperMode = (String)state.getAttribute("pemissions.mode");
        if (helperMode != null) {
            String template = PermissionsAction.buildHelperContext(portlet, context, rundata, state);
            if (template == null) {
                this.addAlert(state, "There is a problem setting Permissions at this time.");
            } else {
                return template;
            }
        }
        String mode = (String)state.getAttribute("mode");
        context.put("action", state.getAttribute("action"));
        if ("list".equals(mode)) {
            return this.buildListModeContext(portlet, context, rundata, state);
        }
        if ("confirm-remove".equals(mode)) {
            return this.buildConfirmModeContext(portlet, context, rundata, state);
        }
        if ("view".equals(mode)) {
            return this.buildViewModeContext(portlet, context, rundata, state);
        }
        if ("options".equals(mode)) {
            return this.buildOptionsPanelContext(portlet, context, rundata, state);
        }
        Log.warn("chef", (Object)((Object)this) + ".buildMainPanelContext: invalid mode: " + mode);
        return null;
    }

    private String buildViewModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        boolean allowDelete = false;
        this.prepPage(state);
        MailArchiveMessage message = null;
        try {
            MailArchiveChannel channel = MailArchiveService.getMailArchiveChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            message = channel.getMailArchiveMessage((String)state.getAttribute("view-id"));
            context.put("email", message);
            allowDelete = channel.allowRemoveMessage(message);
        }
        catch (IdUnusedException e) {
        }
        catch (PermissionException e) {
            // empty catch block
        }
        if (message == null) {
            context.put("message", MESSAGE_MISSING);
        }
        context.put("viewheaders", state.getAttribute(STATE_VIEW_HEADERS));
        ContentTypeImageService imageService = (ContentTypeImageService)((Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME));
        context.put("contentTypeImageService", imageService);
        Menu bar = new Menu((Portlet)portlet, rundata, (String)state.getAttribute("action"));
        bar.add(new MenuEntry("List All", "doList"));
        bar.add(new MenuEntry("Previous Email", state.getAttribute(STATE_PREV_EXISTS) != null, "doView_prev"));
        bar.add(new MenuEntry("Next Email", state.getAttribute(STATE_NEXT_EXISTS) != null, "doView_next"));
        if (((Boolean)state.getAttribute(STATE_VIEW_HEADERS)).booleanValue()) {
            bar.add(new MenuEntry("Hide Headers", "doHide_headers"));
        } else {
            bar.add(new MenuEntry("View Headers", "doView_headers"));
        }
        if (allowDelete) {
            bar.add(new MenuEntry("Remove", "doRemove"));
        }
        context.put("menu", bar);
        return (String)this.getContext(rundata).get("template") + "-view";
    }

    private String buildConfirmModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        MailArchiveMessage message = null;
        try {
            MailArchiveChannel channel = MailArchiveService.getMailArchiveChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            message = channel.getMailArchiveMessage((String)state.getAttribute("view-id"));
            context.put("email", message);
        }
        catch (IdUnusedException e) {
        }
        catch (PermissionException e) {
            // empty catch block
        }
        if (message == null) {
            context.put("message", MESSAGE_MISSING);
        }
        context.put("viewheaders", state.getAttribute(STATE_VIEW_HEADERS));
        ContentTypeImageService imageService = (ContentTypeImageService)((Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME));
        return (String)this.getContext(rundata).get("template") + "-confirm_remove";
    }

    private String buildListModeContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        List messages = this.prepPage(state);
        context.put("messages", messages);
        Menu bar = new Menu((Portlet)portlet, rundata, (String)state.getAttribute("action"));
        bar.add(new MenuEntry("First Page", state.getAttribute(STATE_PREV_PAGE_EXISTS) != null, "doList_first"));
        bar.add(new MenuEntry("Previous Page", state.getAttribute(STATE_PREV_PAGE_EXISTS) != null, "doList_prev"));
        bar.add(new MenuEntry("Next Page", state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null, "doList_next"));
        bar.add(new MenuEntry("Last Page", state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null, "doList_last"));
        this.addOptionsMenu(bar, (JetspeedRunData)rundata);
        if (SiteService.allowUpdateSite(PortalService.getCurrentSiteId())) {
            bar.add(new MenuEntry("Permissions...", "doPermissions"));
        }
        context.put("menu", bar);
        if (state.getAttribute(STATE_NUM_MESSAGES) != null) {
            context.put(STATE_NUM_MESSAGES, state.getAttribute(STATE_NUM_MESSAGES));
        }
        context.put("view-id", "view-id");
        context.put("action", state.getAttribute("action"));
        context.put("sort-by", state.getAttribute(STATE_SORT));
        context.put("sort-order", state.getAttribute(STATE_ASCENDING));
        ((EventObservingCourier)state.getAttribute("obsever")).justDelivered();
        return (String)this.getContext(rundata).get("template") + "-List";
    }

    private List prepPage(SessionState state) {
        int posEnd;
        Vector rv = new Vector();
        int pageSize = (Integer)state.getAttribute(STATE_PAGESIZE);
        state.removeAttribute(STATE_NUM_MESSAGES);
        boolean goNextPage = state.getAttribute(STATE_GO_NEXT_PAGE) != null;
        boolean goPrevPage = state.getAttribute(STATE_GO_PREV_PAGE) != null;
        boolean goFirstPage = state.getAttribute(STATE_GO_FIRST_PAGE) != null;
        boolean goLastPage = state.getAttribute(STATE_GO_LAST_PAGE) != null;
        state.removeAttribute(STATE_GO_NEXT_PAGE);
        state.removeAttribute(STATE_GO_PREV_PAGE);
        state.removeAttribute(STATE_GO_FIRST_PAGE);
        state.removeAttribute(STATE_GO_LAST_PAGE);
        boolean goNext = state.getAttribute(STATE_GO_NEXT) != null;
        boolean goPrev = state.getAttribute(STATE_GO_PREV) != null;
        state.removeAttribute(STATE_GO_NEXT);
        state.removeAttribute(STATE_GO_PREV);
        List allMessages = null;
        try {
            MailArchiveChannel channel = MailArchiveService.getMailArchiveChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            allMessages = channel.getMessages(null, true);
        }
        catch (PermissionException e) {
        }
        catch (IdUnusedException e) {
            // empty catch block
        }
        if (allMessages == null) {
            return rv;
        }
        boolean pinToTop = state.getAttribute(STATE_TOP_PAGE_MESSAGE) != null && state.getAttribute(STATE_PREV_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage;
        boolean pinToBottom = state.getAttribute(STATE_TOP_PAGE_MESSAGE) != null && state.getAttribute(STATE_NEXT_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage;
        int numMessages = allMessages.size();
        if (numMessages == 0) {
            return rv;
        }
        state.setAttribute(STATE_NUM_MESSAGES, (Object)new Integer(numMessages));
        boolean ascending = (Boolean)state.getAttribute(STATE_ASCENDING);
        int sort = (Integer)state.getAttribute(STATE_SORT);
        if (!ascending || sort != 1) {
            Collections.sort(allMessages, new MyComparator(sort, ascending));
        }
        int posStart = 0;
        String messageIdAtTheTopOfThePage = (String)state.getAttribute(STATE_TOP_PAGE_MESSAGE);
        if (messageIdAtTheTopOfThePage != null && (posStart = this.findMessageInList(allMessages, messageIdAtTheTopOfThePage)) == -1) {
            posStart = 0;
        }
        if (goNextPage) {
            posStart += pageSize;
        } else if (goPrevPage) {
            if ((posStart -= pageSize) < 0) {
                posStart = 0;
            }
        } else if (goFirstPage) {
            posStart = 0;
        } else if (goLastPage && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if (pinToTop) {
            posStart = 0;
        } else if (pinToBottom && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if (posStart + pageSize > numMessages && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if ((posEnd = posStart + (pageSize - 1)) >= numMessages) {
            posEnd = numMessages - 1;
        }
        int numMessagesOnThisPage = posEnd - posStart + 1;
        int i = posStart;
        while (i <= posEnd) {
            rv.add(allMessages.get(i));
            ++i;
        }
        MailArchiveMessage messageAtTheTopOfThePage = (MailArchiveMessage)allMessages.get(posStart);
        state.setAttribute(STATE_TOP_PAGE_MESSAGE, (Object)messageAtTheTopOfThePage.getId());
        int next = posStart + pageSize;
        if (next < numMessages) {
            state.setAttribute(STATE_NEXT_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_NEXT_PAGE_EXISTS);
        }
        int prev = posStart - 1;
        if (prev >= 0) {
            state.setAttribute(STATE_PREV_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_PREV_PAGE_EXISTS);
        }
        if (state.getAttribute("view-id") != null) {
            int viewPos = this.findMessageInList(allMessages, (String)state.getAttribute("view-id"));
            if (goNext && ++viewPos >= numMessages) {
                viewPos = numMessages - 1;
            }
            if (goPrev && --viewPos < 0) {
                viewPos = 0;
            }
            state.setAttribute("view-id", (Object)((MailArchiveMessage)allMessages.get(viewPos)).getId());
            if (viewPos < posStart) {
                state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
            } else if (viewPos > posEnd) {
                state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
            }
            if (viewPos > 0) {
                state.setAttribute(STATE_PREV_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_PREV_EXISTS);
            }
            if (viewPos < numMessages - 1) {
                state.setAttribute(STATE_NEXT_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_NEXT_EXISTS);
            }
        }
        return rv;
    }

    public void doView(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute("mode", (Object)"view");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
        state.setAttribute("view-id", (Object)runData.getParameters().getString("view-id"));
    }

    public void doList(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute("mode", (Object)"list");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
        state.removeAttribute("view-id");
    }

    public void doView_next(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT, (Object)"");
    }

    public void doList_first(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_FIRST_PAGE, (Object)"");
    }

    public void doList_last(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_LAST_PAGE, (Object)"");
    }

    public void doList_next(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
        this.doList(runData, context);
    }

    public void doView_prev(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV, (Object)"");
    }

    public void doList_prev(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
        this.doList(runData, context);
    }

    public void doView_headers(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_VIEW_HEADERS, (Object)new Boolean(true));
    }

    public void doHide_headers(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_VIEW_HEADERS, (Object)new Boolean(false));
    }

    public void doSort_from(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.removeAttribute(STATE_TOP_PAGE_MESSAGE);
        if ((Integer)state.getAttribute(STATE_SORT) == 0) {
            boolean order = (Boolean)state.getAttribute(STATE_ASCENDING) == false;
            state.setAttribute(STATE_ASCENDING, (Object)new Boolean(order));
        } else {
            state.setAttribute(STATE_SORT, (Object)new Integer(0));
        }
    }

    public void doSort_date(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.removeAttribute(STATE_TOP_PAGE_MESSAGE);
        if ((Integer)state.getAttribute(STATE_SORT) == 1) {
            boolean order = (Boolean)state.getAttribute(STATE_ASCENDING) == false;
            state.setAttribute(STATE_ASCENDING, (Object)new Boolean(order));
        } else {
            state.setAttribute(STATE_SORT, (Object)new Integer(1));
        }
    }

    public void doSort_subject(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.removeAttribute(STATE_TOP_PAGE_MESSAGE);
        if ((Integer)state.getAttribute(STATE_SORT) == 2) {
            boolean order = (Boolean)state.getAttribute(STATE_ASCENDING) == false;
            state.setAttribute(STATE_ASCENDING, (Object)new Boolean(order));
        } else {
            state.setAttribute(STATE_SORT, (Object)new Integer(2));
        }
    }

    public void doRemove(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        state.setAttribute("mode", (Object)"confirm-remove");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
    }

    public void doRemove_confirmed(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        try {
            MailArchiveChannel channel = MailArchiveService.getMailArchiveChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            MessageEdit edit = channel.editMessage((String)state.getAttribute("view-id"));
            channel.removeMessage(edit);
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to remove this message.");
        }
        catch (InUseException e) {
            this.addAlert(state, "Someone else is editing this message.");
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "This message has already been removed.");
        }
        this.doList(data, context);
    }

    public void doRemove_cancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        state.setAttribute("mode", (Object)"view");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
    }

    public void doOptions(RunData runData, Context context) {
        super.doOptions(runData, context);
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        if (!"options".equals(state.getAttribute("mode"))) {
            return;
        }
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("pagesize", ((Integer)state.getAttribute(STATE_PAGESIZE)).toString());
        context.put("form-pagesize", "pagesize");
        context.put("form-open", FORM_OPEN);
        context.put("form-submit", "eventSubmit_doUpdate");
        context.put("form-cancel", "eventSubmit_doCancel");
        try {
            MailArchiveChannel channel = MailArchiveService.getMailArchiveChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            context.put("channel", channel);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String template = (String)this.getContext(rundata).get("template");
        return template + "-customize";
    }

    public void doUpdate(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        try {
            int size = Integer.parseInt(data.getParameters().getString("pagesize"));
            if (size != (Integer)state.getAttribute(STATE_PAGESIZE) && size > 0) {
                state.setAttribute(STATE_PAGESIZE, (Object)new Integer(size));
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", (Object)((Object)this) + ".doUpdate(): page size: " + size);
                }
                ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
                tool.getPropertiesEdit().addProperty("pagesize", Integer.toString(size));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.saveOptions();
        try {
            String open = data.getParameters().getString(FORM_OPEN);
            boolean ss = new Boolean(open);
            MailArchiveChannel channel = MailArchiveService.getMailArchiveChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            if (channel.getOpen() != ss) {
                MailArchiveChannelEdit edit = (MailArchiveChannelEdit)MailArchiveService.editChannel(channel.getReference());
                edit.setOpen(ss);
                MailArchiveService.commitChannel(edit);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        state.setAttribute("mode", (Object)"list");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doCancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        this.cancelOptions();
        state.setAttribute("mode", (Object)"list");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    private int findMessageInList(List messages, String id) {
        int i = 0;
        while (i < messages.size()) {
            if (((MailArchiveMessage)messages.get(i)).getId().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void doPermissions(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String channelRefStr = (String)state.getAttribute(STATE_CHANNEL_REF);
        Reference channelRef = new Reference(channelRefStr);
        String siteRef = SiteService.siteReference(channelRef.getContext());
        state.setAttribute("permission.realmId", (Object)siteRef);
        state.setAttribute("permission.realmRolesId", (Object)siteRef);
        state.setAttribute("permission.description", (Object)("Set permissions for Email Archive in worksite " + SiteService.getSiteDisplay(channelRef.getContext())));
        state.setAttribute("permission.prefix", (Object)"mail.");
        state.setAttribute("pemissions.mode", (Object)"main");
    }

    static {
        DEFAULT_PAGE_SIZE = 20;
        PARAM_CHANNEL = "channel";
        PARAM_SITE = PARAM_SITE;
        PARAM_PAGESIZE = "pagesize";
        FORM_CHANNEL = "channel";
        FORM_PAGESIZE = "pagesize";
        FORM_OPEN = FORM_OPEN;
        VIEW_ID = "view-id";
        STATE_CHANNEL_REF = STATE_CHANNEL_REF;
        STATE_ASCENDING = STATE_ASCENDING;
        STATE_SORT = STATE_SORT;
        STATE_VIEW_ID = "view-id";
        STATE_VIEW_HEADERS = STATE_VIEW_HEADERS;
        STATE_TOP_PAGE_MESSAGE = STATE_TOP_PAGE_MESSAGE;
        STATE_PAGESIZE = STATE_PAGESIZE;
        STATE_NUM_MESSAGES = STATE_NUM_MESSAGES;
        STATE_NEXT_PAGE_EXISTS = STATE_NEXT_PAGE_EXISTS;
        STATE_PREV_PAGE_EXISTS = STATE_PREV_PAGE_EXISTS;
        STATE_GO_NEXT_PAGE = STATE_GO_NEXT_PAGE;
        STATE_GO_PREV_PAGE = STATE_GO_PREV_PAGE;
        STATE_GO_NEXT = STATE_GO_NEXT;
        STATE_GO_PREV = STATE_GO_PREV;
        STATE_NEXT_EXISTS = STATE_NEXT_EXISTS;
        STATE_PREV_EXISTS = STATE_PREV_EXISTS;
        STATE_GO_FIRST_PAGE = STATE_GO_FIRST_PAGE;
        STATE_GO_LAST_PAGE = STATE_GO_LAST_PAGE;
        CHANNEL_MISSING = CHANNEL_MISSING;
        CHANNEL_PERMISSION = CHANNEL_PERMISSION;
        MESSAGE_MISSING = MESSAGE_MISSING;
        MESSAGE_PERMISSION = MESSAGE_PERMISSION;
        SORT_FROM = 0;
        SORT_DATE = 1;
        SORT_SUBJECT = 2;
    }

    private class MyComparator
    implements Comparator {
        private int m_criteria = 1;
        private boolean m_asc = true;

        public MyComparator(int criteria, boolean asc) {
            this.m_criteria = criteria;
            this.m_asc = asc;
        }

        public int compare(Object o1, Object o2) {
            MailArchiveMessage m1 = (MailArchiveMessage)o1;
            MailArchiveMessage m2 = (MailArchiveMessage)o2;
            if (m1 == m2) {
                return 0;
            }
            int orderFactor = this.m_asc ? 1 : -1;
            switch (this.m_criteria) {
                case 0: {
                    return orderFactor * m1.getMailArchiveHeader().getFromAddress().compareTo(m2.getMailArchiveHeader().getFromAddress());
                }
                case 1: {
                    return orderFactor * m1.getMailArchiveHeader().getDateSent().compareTo(m2.getMailArchiveHeader().getDateSent());
                }
                case 2: {
                    return orderFactor * m1.getMailArchiveHeader().getSubject().compareToIgnoreCase(m2.getMailArchiveHeader().getSubject());
                }
            }
            Log.warn("chef", "MailboxAction.MyComparator - invalid sort: " + this.m_criteria);
            return 0;
        }
    }
}

