/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.sql;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.turbine.torque.engine.sql.Token;

public class SQLScanner {
    private static final String white = "\f\r\t\n ";
    private static final String alfa = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String numer = "0123456789";
    private static final String alfanum = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String special = ";(),'";
    private static final char commentPound = '#';
    private static final char commentSlash = '/';
    private static final char commentStar = '*';
    private static final char commentDash = '-';
    private Reader in;
    private int chr;
    private String token;
    private Vector tokens;
    private int line;
    private int col;

    public void setInput(Reader input) {
        this.in = input;
    }

    private void readChar() throws IOException {
        this.chr = this.in.read();
        if ((char)this.chr == '\n' || (char)this.chr == '\r' || (char)this.chr == '\f') {
            this.col = 0;
            ++this.line;
        } else {
            ++this.col;
        }
    }

    private void scanIdentifier() throws IOException {
        this.token = "";
        char c = (char)this.chr;
        while (this.chr != -1 && white.indexOf(c) == -1 && special.indexOf(c) == -1) {
            this.token = this.token + (char)this.chr;
            this.readChar();
            c = (char)this.chr;
        }
        this.tokens.addElement(new Token(this.token, this.line, this.col));
    }

    public Vector scan() throws IOException {
        this.line = 1;
        this.col = 0;
        boolean inComment = false;
        boolean inCommentSlashStar = false;
        boolean inCommentDash = false;
        this.tokens = new Vector();
        this.readChar();
        while (this.chr != -1) {
            char c = (char)this.chr;
            if (c == '-') {
                this.readChar();
                if ((char)this.chr == '-') {
                    inCommentDash = true;
                }
            }
            if (inCommentDash) {
                if (c == '\n' || c == '\r') {
                    inCommentDash = false;
                }
                this.readChar();
                continue;
            }
            if (c == '#') {
                inComment = true;
                this.readChar();
                continue;
            }
            if (c == '/') {
                this.readChar();
                if ((char)this.chr != '*') continue;
                inCommentSlashStar = true;
                continue;
            }
            if (inComment || inCommentSlashStar) {
                if (c == '*') {
                    this.readChar();
                    if ((char)this.chr == '/') {
                        inCommentSlashStar = false;
                    }
                } else if (c == '\n' || c == '\r') {
                    inComment = false;
                }
                this.readChar();
                continue;
            }
            if (alfanum.indexOf(c) >= 0) {
                this.scanIdentifier();
                continue;
            }
            if (special.indexOf(c) >= 0) {
                this.tokens.addElement(new Token("" + c, this.line, this.col));
                this.readChar();
                continue;
            }
            this.readChar();
        }
        return this.tokens;
    }

    public SQLScanner() {
        this(null);
    }

    public SQLScanner(Reader input) {
        this.setInput(input);
    }
}

