/* print_c_code.c - Output the C code that used to be provided in openssl dhparam -C 
 * Reads full output from openssl in stdin, prints C code to stdout.
 * 
 * Sample output from openssl 3:

[root@localhost nrpe]# openssl dhparam -text 2048
Generating DH parameters, 2048 bit long safe prime
................................................................................                                                                  ................................................................................                                                                  ..............................................................+.......+.........                                                                  .................................................+..............................                                                                  ................................................................................                                                                  ................................................................................                                                                  ...............................................+.....+..........................                                                                  .................................+.............................................+                                                                  .............................................+..................................                                                                  .................................................+..............................                                                                  ................................................................................                                                                  ................................................................................                                                                  ...................+............................................................                                                                  ......................................................................+.........                                                                  ................................................................+...............                                                                  ................................................................................                                                                  ..................+...........................+...............................+.                                                                  ........................................................+.......................                                                                  ................................................................................                                                                  ................................................................................                                                                  .............................+..................................................                                                                  ................................................................................                                                                  ..........+.....................................................................                                                                  ................................................................................                                                                  ...............+................................................................                                                                  .......................................................................+....+...                                                                  ................................................................................                                                                  .............................................................+..+...............                                                                  ................................................................................                                                                  ........+.......................................................................                                                                  ............................................................+...................                                                                  ..............+........................................................+........                                                                  ...................................................+............................                                                                  .+..............+.................+...........................................+.                                                                  ................................................................................                                                                  ......................................................+.........................                                                                  ................................................................................                                                                  ................................................................................                                                                  ......+................................................................+........                                                                  ...............................................+..............+.................                                                                  ....................................+..............................+............                                                                  ................................................................................                                                                  .........................................+............................+.........                                                                  ................................................................................                                                                  .............................................................+..................                                                                  .............................................+..................................                                                                  .......++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*+                                                                  +*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*++*                                                                  ++*++*++*++*++*++*++*++*++*++*++*++*++*
    DH Parameters: (2048 bit)
    P:
        00:d4:81:57:06:2e:dc:2c:c0:0e:7f:20:5c:07:6a:
        22:06:b5:fc:f1:83:bb:99:31:38:03:a7:ef:98:b6:
        75:32:33:e2:55:08:d4:46:a3:f1:94:85:de:da:2f:
        e7:49:8d:69:f8:28:73:57:7a:58:99:61:f5:37:76:
        f0:45:68:9e:cc:67:77:b4:4d:08:ec:3b:71:a2:62:
        e6:26:d8:2c:2d:61:1e:45:20:5b:1b:bc:19:de:ee:
        99:a0:c5:ad:2a:59:bf:e8:26:95:56:71:0e:f0:d8:
        3b:3b:6d:91:5a:c8:f4:3d:1a:02:75:76:42:cf:63:
        c7:3c:07:3b:0c:c0:98:e9:a9:ab:bc:d6:a3:a1:cb:
        85:79:ff:37:3c:f8:3a:a0:84:b3:a7:68:cd:3d:f4:
        a6:d8:c7:7b:d5:f4:11:33:8f:ba:2c:67:15:65:38:
        23:10:67:2d:fc:4c:c0:bc:b5:43:70:67:86:b9:83:
        5a:42:a7:18:11:7f:32:4c:3d:e2:08:2f:0d:59:ae:
        1f:8c:73:72:16:00:d3:e1:e7:38:a3:24:b5:e0:25:
        0e:c2:41:b8:09:82:8d:05:c8:9c:61:d8:61:f5:19:
        93:f7:b1:02:44:20:bc:7e:2f:3f:e0:c8:d2:5a:50:
        cc:7f:b5:96:8b:83:b7:5b:03:8a:52:a1:69:4e:b4:
        8a:5f
    G:    2 (0x2)
-----BEGIN DH PARAMETERS-----
MIIBCAKCAQEA1IFXBi7cLMAOfyBcB2oiBrX88YO7mTE4A6fvmLZ1MjPiVQjURqPx
lIXe2i/nSY1p+ChzV3pYmWH1N3bwRWiezGd3tE0I7DtxomLmJtgsLWEeRSBbG7wZ
3u6ZoMWtKlm/6CaVVnEO8Ng7O22RWsj0PRoCdXZCz2PHPAc7DMCY6amrvNajocuF
ef83PPg6oISzp2jNPfSm2Md71fQRM4+6LGcVZTgjEGct/EzAvLVDcGeGuYNaQqcY
EX8yTD3iCC8NWa4fjHNyFgDT4ec4oyS14CUOwkG4CYKNBcicYdhh9RmT97ECRCC8
fi8/4MjSWlDMf7WWi4O3WwOKUqFpTrSKXwIBAg==
-----END DH PARAMETERS-----
[root@localhost nrpe]#

 *********
 * Correct C output will look like

#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0x84,0xC5,0x67,0x9B,0x9E,0xAD,0x8C,0x80,0xAF,0x35,0x81,0x83,
		0xD7,0x46,0x08,0x8B,0x5E,0xF2,0x90,0xBC,0xF3,0xC2,0x48,0x13,
		0x48,0x47,0xA4,0x2D,0x6E,0x2F,0x5C,0xF4,0x75,0x11,0xE9,0x3F,
		0x5E,0x2E,0x17,0x41,0x9A,0xC9,0x26,0x48,0xE9,0xDA,0x27,0x28,
		0xBD,0x31,0x9F,0xB3,0x02,0xD6,0x7A,0x3D,0x64,0x4F,0x0F,0x56,
		0x24,0xE5,0x8B,0xC6,0x83,0x35,0x3B,0x0D,0x24,0x3E,0xF4,0x60,
		0x72,0x3A,0xE4,0xD1,0x7F,0x32,0xDC,0x26,0xB7,0x5C,0x1D,0x4D,
		0x60,0x57,0x64,0x26,0xC3,0xC6,0x7B,0xE9,0x02,0xAF,0xDA,0x63,
		0xE9,0x48,0x89,0x30,0xBA,0x70,0xF2,0x42,0xF9,0x77,0x69,0x84,
		0xCE,0x0B,0x72,0x7E,0x86,0xC7,0xC5,0x63,0xC0,0xD7,0x3E,0x9D,
		0x0C,0x88,0x88,0x91,0x66,0x9B,0xD3,0x62,0x16,0xC2,0x46,0x2B,
		0x08,0xBF,0x3B,0xA9,0xAA,0x4C,0xBF,0x2D,0xB5,0xC0,0xC5,0x26,
		0xF6,0xDB,0x83,0xDD,0x42,0x8E,0x57,0x68,0xE7,0x93,0x0E,0x3F,
		0xAB,0x95,0x45,0x03,0x15,0x87,0x02,0x2F,0x18,0xBB,0x71,0xB9,
		0x8E,0x3C,0x67,0xCE,0x63,0x85,0x04,0xE1,0x55,0xA8,0x06,0x30,
		0x52,0x03,0x33,0x4F,0x4A,0x34,0x61,0x0F,0x4F,0xE5,0x93,0xD0,
		0x83,0x33,0x9B,0xF1,0x9A,0x87,0xEC,0x9A,0xC4,0xB5,0x51,0x7B,
		0x2F,0x7D,0xBB,0x95,0x33,0x46,0xF7,0x2D,0xBD,0x90,0x93,0x7A,
		0xA0,0x99,0x24,0xE1,0x5B,0x24,0x2D,0x91,0x9B,0x58,0xA4,0xE1,
		0xF6,0xB2,0x76,0x20,0x1B,0xB7,0x00,0x0C,0x8D,0xF0,0x8C,0x90,
		0x44,0xFF,0x35,0x40,0xFE,0x0F,0xCC,0x34,0x74,0x82,0xCB,0x38,
		0x52,0x09,0x83,0x63,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main() {
	char line[1024];
	int result;
	unsigned int term = 0;
	FILE *fp = fdopen(0, "r");
	if (fp == NULL) {
		return 1;
	}

	int found_dh_parameters = 0;
	int found_primes = 0;
	while (!found_primes) {
		fgets(line, 1023, fp);

		if (!found_dh_parameters) {
			// Didn't find DH Parameters section header yet
			// See if this line is the "DH Parameters line"
			char *forward = strchr(line, 'D');
			if (forward == NULL) {
				forward = strchr(line, 'd');
			}
			if (forward == NULL) {
				continue;
			}

			// Note: fgets always NULL-terminates its string.
			found_dh_parameters = !strncasecmp("DH Parameters:", forward, strlen("DH Parameters"));
			continue;
		}

		// Otherwise, see if this is the prime/polynomial header.		
		char *forward = strchr(line, 'P');
		if (forward == NULL) {
			forward = strchr(line, 'p');
		}
		if (forward == NULL) {
			continue;
		}
		found_primes = strchr(forward, ':') != NULL;
	}

	// Print the first part of the C code:

	printf("DH *get_dh2048()\n"
		"{\n"
		"\tstatic unsigned char dh2048_p[]={");

	int terms_written = 0;
	while (1) {
		result = fscanf(fp, " %x : ", &term);
		if (result == 0) {
			// All done
			break;
		}
		if (term == 0 && terms_written == 0) {
			continue;
		}
		if (terms_written % 15 == 0) {
			printf("\n\t\t");
		}
		printf("0x%02X,", term);
		terms_written += 1;
	}

	printf("\n\t};\n"
		"\tstatic unsigned char dh2048_g[]={\n"
		"\t\t0x02,\n"
		"\t};\n"
		"\tDH *dh;\n"
		"\n"
		"\tif ((dh=DH_new()) == NULL) return(NULL);\n"
		"\tBIGNUM *p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);\n"
		"\tBIGNUM *g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);\n"
		"\tif ((p == NULL) || (g == NULL))\n"
		"\t\t{ DH_free(dh); return(NULL); }\n"
		"\tint result = DH_set0_pqg(dh, p, NULL, g);\n"
		"\tif (result == 0)"
		"\t\t{ DH_free(dh); return(NULL); }\n"
		"\treturn(dh);\n"
		"}\n");
	return 0;
}
