Limnoria is a multipurpose Python IRC bot, designed for flexibility and robustness,
while being easy to install, set up, and maintain.

It aims to be an adequate replacement for most existing IRC bots.
It includes a very flexible and powerful
[ACL system](https://docs.limnoria.net/use/capabilities.html)
for controlling access to commands,
an equality powerful
[configuration system](https://docs.limnoria.net/use/configuration.html)
to customize your bot,
as well as more than 60 builtin [plugins](https://limnoria.net/plugins.xhtml)
providing around 400 actual commands.

There are also dozens of third-party [plugins](https://limnoria.net/plugins.xhtml)
written by dozens of independent developers,
and it is very easy to
[write your own](https://docs.limnoria.net/develop/plugin_tutorial.html)
with only basic knowledge of Python.

It is the successor of
[Supybot](https://sourceforge.net/projects/supybot/)
since 2010 and provides many new features, but keeps full compatibility
with existing configurations and plugins.

# Build status

Master branch: [![Build Status (master branch)](https://travis-ci.org/ProgVal/Limnoria.png?branch=master)](https://travis-ci.org/ProgVal/Limnoria)

Testing branch: [![Build Status (testing branch)](https://travis-ci.org/ProgVal/Limnoria.png?branch=testing)](https://travis-ci.org/ProgVal/Limnoria)

Limnoria supports CPython 3.4 to 3.9, CPython nightly, and Pypy 3.

# Support

## Documentation

If this is your first install, there is an [install guide](https://docs.limnoria.net/en/latest/use/install.html).
You will probably be pointed to it if you ask on IRC how to install
Limnoria.
TL;DR version:

```
sudo apt-get install python3 python3-pip python3-wheel
pip3 install --user limnoria
# You might need to add $HOME/.local/bin to your PATH
supybot-wizard
```

There is extensive documentation at [docs.limnoria.net] and at
[Gribble wiki]. We took the time to write it; you should take the time to
read it.

[docs.limnoria.net]:https://docs.limnoria.net/
[Gribble wiki]:https://sourceforge.net/p/gribble/wiki/Main_Page/

## IRC channels

### In English

If you have any trouble, feel free to swing by [#limnoria](ircs://irc.libera.chat:6697/#limnoria) on
[Libera.Chat](https://libera.chat/) and ask questions.  We'll be happy to help
wherever we can.  And by all means, if you find anything hard to
understand or think you know of a better way to do something,
*please* post it on the [issue tracker] so we can improve the bot!

[issue tracker]:https://github.com/ProgVal/Limnoria/issues

### In Other languages

Only in French at the moment, located at [#limnoria-fr on Libera.Chat](ircs://irc.libera.chat:6697/#libera-fr).

