//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccountListResult.
func (a AccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountListResult.
func (a *AccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountResource.
func (a AccountResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountResource.
func (a *AccountResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountResourceProperties.
func (a AccountResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessLevel", a.AccessLevel)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sku", a.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountResourceProperties.
func (a *AccountResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessLevel":
			err = unpopulate(val, "AccessLevel", &a.AccessLevel)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountSKU.
func (a AccountSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", a.Capabilities)
	populate(objectMap, "locations", a.Locations)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "resourceType", a.ResourceType)
	populate(objectMap, "tier", a.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountSKU.
func (a *AccountSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &a.Capabilities)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &a.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &a.ResourceType)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &a.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountSKUCapability.
func (a AccountSKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountSKUCapability.
func (a *AccountSKUCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountSKUListResult.
func (a AccountSKUListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountSKUListResult.
func (a *AccountSKUListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateParameterProperties.
func (a AccountUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sku", a.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUpdateParameterProperties.
func (a *AccountUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateParameters.
func (a AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUpdateParameters.
func (a *AccountUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUsageData.
func (a AccountUsageData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", a.CurrentValue)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "limit", a.Limit)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "unit", a.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUsageData.
func (a *AccountUsageData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &a.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &a.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &a.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUsageDataList.
func (a AccountUsageDataList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUsageDataList.
func (a *AccountUsageDataList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountUsageName.
func (a AccountUsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", a.LocalizedValue)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountUsageName.
func (a *AccountUsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &a.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisResultListResult.
func (a AnalysisResultListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisResultListResult.
func (a *AnalysisResultListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisResultSingletonResource.
func (a AnalysisResultSingletonResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisResultSingletonResource.
func (a *AnalysisResultSingletonResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAnalysisResultSingletonResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisResultSingletonResourceProperties.
func (a AnalysisResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = a.AnalysisResultType
	populate(objectMap, "grade", a.Grade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisResultSingletonResourceProperties.
func (a *AnalysisResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &a.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &a.Grade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableOSListResult.
func (a AvailableOSListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableOSListResult.
func (a *AvailableOSListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableOSProperties.
func (a AvailableOSProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "insiderChannel", a.InsiderChannel)
	populate(objectMap, "osId", a.OSID)
	populate(objectMap, "osName", a.OSName)
	populate(objectMap, "osPlatform", a.OSPlatform)
	populate(objectMap, "osUpdateType", a.OSUpdateType)
	populate(objectMap, "osVersion", a.OSVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableOSProperties.
func (a *AvailableOSProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "insiderChannel":
			err = unpopulate(val, "InsiderChannel", &a.InsiderChannel)
			delete(rawMsg, key)
		case "osId":
			err = unpopulate(val, "OSID", &a.OSID)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &a.OSName)
			delete(rawMsg, key)
		case "osPlatform":
			err = unpopulate(val, "OSPlatform", &a.OSPlatform)
			delete(rawMsg, key)
		case "osUpdateType":
			err = unpopulate(val, "OSUpdateType", &a.OSUpdateType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &a.OSVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableOSResource.
func (a AvailableOSResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableOSResource.
func (a *AvailableOSResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CPURegressionResultSingletonResourceProperties.
func (c CPURegressionResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeCPURegression
	populate(objectMap, "cpuRegressionResults", c.CPURegressionResults)
	populate(objectMap, "grade", c.Grade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CPURegressionResultSingletonResourceProperties.
func (c *CPURegressionResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &c.AnalysisResultType)
			delete(rawMsg, key)
		case "cpuRegressionResults":
			err = unpopulate(val, "CPURegressionResults", &c.CPURegressionResults)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &c.Grade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CPUUtilizationResultSingletonResourceProperties.
func (c CPUUtilizationResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeCPUUtilization
	populate(objectMap, "cpuUtilizationResults", c.CPUUtilizationResults)
	populate(objectMap, "grade", c.Grade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CPUUtilizationResultSingletonResourceProperties.
func (c *CPUUtilizationResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &c.AnalysisResultType)
			delete(rawMsg, key)
		case "cpuUtilizationResults":
			err = unpopulate(val, "CPUUtilizationResults", &c.CPUUtilizationResults)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &c.Grade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResult.
func (c CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResult.
func (c *CheckNameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Command.
func (c Command) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "alwaysRun", c.AlwaysRun)
	populate(objectMap, "applyUpdateBefore", c.ApplyUpdateBefore)
	populate(objectMap, "content", c.Content)
	populate(objectMap, "contentType", c.ContentType)
	populate(objectMap, "maxRunTime", c.MaxRunTime)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "restartAfter", c.RestartAfter)
	populate(objectMap, "runAsInteractive", c.RunAsInteractive)
	populate(objectMap, "runElevated", c.RunElevated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Command.
func (c *Command) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "alwaysRun":
			err = unpopulate(val, "AlwaysRun", &c.AlwaysRun)
			delete(rawMsg, key)
		case "applyUpdateBefore":
			err = unpopulate(val, "ApplyUpdateBefore", &c.ApplyUpdateBefore)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &c.ContentType)
			delete(rawMsg, key)
		case "maxRunTime":
			err = unpopulate(val, "MaxRunTime", &c.MaxRunTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "restartAfter":
			err = unpopulate(val, "RestartAfter", &c.RestartAfter)
			delete(rawMsg, key)
		case "runAsInteractive":
			err = unpopulate(val, "RunAsInteractive", &c.RunAsInteractive)
			delete(rawMsg, key)
		case "runElevated":
			err = unpopulate(val, "RunElevated", &c.RunElevated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerEventListResult.
func (c CustomerEventListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerEventListResult.
func (c *CustomerEventListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerEventProperties.
func (c CustomerEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventName", c.EventName)
	populate(objectMap, "receivers", c.Receivers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerEventProperties.
func (c *CustomerEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventName":
			err = unpopulate(val, "EventName", &c.EventName)
			delete(rawMsg, key)
		case "receivers":
			err = unpopulate(val, "Receivers", &c.Receivers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerEventResource.
func (c CustomerEventResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerEventResource.
func (c *CustomerEventResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DistributionGroupListReceiverValue.
func (d DistributionGroupListReceiverValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "distributionGroups", d.DistributionGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DistributionGroupListReceiverValue.
func (d *DistributionGroupListReceiverValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributionGroups":
			err = unpopulate(val, "DistributionGroups", &d.DistributionGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DownloadURLResponse.
func (d DownloadURLResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "downloadUrl", d.DownloadURL)
	populateDateTimeRFC3339(objectMap, "expirationTime", d.ExpirationTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURLResponse.
func (d *DownloadURLResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadUrl":
			err = unpopulate(val, "DownloadURL", &d.DownloadURL)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &d.ExpirationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailEventListResult.
func (e EmailEventListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailEventListResult.
func (e *EmailEventListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailEventProperties.
func (e EmailEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "eventId", e.EventID)
	populate(objectMap, "eventName", e.EventName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailEventProperties.
func (e *EmailEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "eventId":
			err = unpopulate(val, "EventID", &e.EventID)
			delete(rawMsg, key)
		case "eventName":
			err = unpopulate(val, "EventName", &e.EventName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailEventResource.
func (e EmailEventResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailEventResource.
func (e *EmailEventResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinition.
func (e ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinition.
func (e *ErrorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FavoriteProcessListResult.
func (f FavoriteProcessListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FavoriteProcessListResult.
func (f *FavoriteProcessListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FavoriteProcessProperties.
func (f FavoriteProcessProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actualProcessName", f.ActualProcessName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FavoriteProcessProperties.
func (f *FavoriteProcessProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actualProcessName":
			err = unpopulate(val, "ActualProcessName", &f.ActualProcessName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FavoriteProcessResource.
func (f FavoriteProcessResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FavoriteProcessResource.
func (f *FavoriteProcessResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileUploadURLResponse.
func (f FileUploadURLResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobPath", f.BlobPath)
	populate(objectMap, "uploadUrl", f.UploadURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileUploadURLResponse.
func (f *FileUploadURLResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobPath":
			err = unpopulate(val, "BlobPath", &f.BlobPath)
			delete(rawMsg, key)
		case "uploadUrl":
			err = unpopulate(val, "UploadURL", &f.UploadURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlightingRingListResult.
func (f FlightingRingListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlightingRingListResult.
func (f *FlightingRingListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlightingRingProperties.
func (f FlightingRingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actualFlightingRingName", f.ActualFlightingRingName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlightingRingProperties.
func (f *FlightingRingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actualFlightingRingName":
			err = unpopulate(val, "ActualFlightingRingName", &f.ActualFlightingRingName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlightingRingResource.
func (f FlightingRingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlightingRingResource.
func (f *FlightingRingResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetFileUploadURLParameters.
func (g GetFileUploadURLParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobName", g.BlobName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetFileUploadURLParameters.
func (g *GetFileUploadURLParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobName":
			err = unpopulate(val, "BlobName", &g.BlobName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentifiedFailure.
func (i IdentifiedFailure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "failureId", i.FailureID)
	populate(objectMap, "guidance", i.Guidance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentifiedFailure.
func (i *IdentifiedFailure) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "failureId":
			err = unpopulate(val, "FailureID", &i.FailureID)
			delete(rawMsg, key)
		case "guidance":
			err = unpopulate(val, "Guidance", &i.Guidance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MemoryRegressionResultSingletonResourceProperties.
func (m MemoryRegressionResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeMemoryRegression
	populate(objectMap, "grade", m.Grade)
	populate(objectMap, "memoryRegressionResults", m.MemoryRegressionResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MemoryRegressionResultSingletonResourceProperties.
func (m *MemoryRegressionResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &m.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &m.Grade)
			delete(rawMsg, key)
		case "memoryRegressionResults":
			err = unpopulate(val, "MemoryRegressionResults", &m.MemoryRegressionResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MemoryUtilizationResultSingletonResourceProperties.
func (m MemoryUtilizationResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeMemoryUtilization
	populate(objectMap, "grade", m.Grade)
	populate(objectMap, "memoryUtilizationResults", m.MemoryUtilizationResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MemoryUtilizationResultSingletonResourceProperties.
func (m *MemoryUtilizationResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &m.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &m.Grade)
			delete(rawMsg, key)
		case "memoryUtilizationResults":
			err = unpopulate(val, "MemoryUtilizationResults", &m.MemoryUtilizationResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationEventReceiver.
func (n NotificationEventReceiver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "receiverType", n.ReceiverType)
	populate(objectMap, "receiverValue", n.ReceiverValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationEventReceiver.
func (n *NotificationEventReceiver) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "receiverType":
			err = unpopulate(val, "ReceiverType", &n.ReceiverType)
			delete(rawMsg, key)
		case "receiverValue":
			err = unpopulate(val, "ReceiverValue", &n.ReceiverValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationReceiverValue.
func (n NotificationReceiverValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "distributionGroupListReceiverValue", n.DistributionGroupListReceiverValue)
	populate(objectMap, "subscriptionReceiverValue", n.SubscriptionReceiverValue)
	populate(objectMap, "userObjectReceiverValue", n.UserObjectReceiverValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationReceiverValue.
func (n *NotificationReceiverValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributionGroupListReceiverValue":
			err = unpopulate(val, "DistributionGroupListReceiverValue", &n.DistributionGroupListReceiverValue)
			delete(rawMsg, key)
		case "subscriptionReceiverValue":
			err = unpopulate(val, "SubscriptionReceiverValue", &n.SubscriptionReceiverValue)
			delete(rawMsg, key)
		case "userObjectReceiverValue":
			err = unpopulate(val, "UserObjectReceiverValue", &n.UserObjectReceiverValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdateListResult.
func (o OSUpdateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdateListResult.
func (o *OSUpdateListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdateProperties.
func (o OSUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "buildRevision", o.BuildRevision)
	populate(objectMap, "buildVersion", o.BuildVersion)
	populate(objectMap, "flightingRing", o.FlightingRing)
	populate(objectMap, "osName", o.OSName)
	populate(objectMap, "release", o.Release)
	populateDateTimeRFC3339(objectMap, "releaseVersionDate", o.ReleaseVersionDate)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdateProperties.
func (o *OSUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buildRevision":
			err = unpopulate(val, "BuildRevision", &o.BuildRevision)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &o.BuildVersion)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &o.FlightingRing)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &o.OSName)
			delete(rawMsg, key)
		case "release":
			err = unpopulate(val, "Release", &o.Release)
			delete(rawMsg, key)
		case "releaseVersionDate":
			err = unpopulateDateTimeRFC3339(val, "ReleaseVersionDate", &o.ReleaseVersionDate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdateResource.
func (o OSUpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdateResource.
func (o *OSUpdateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdateTestSummary.
func (o OSUpdateTestSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "buildRevision", o.BuildRevision)
	populate(objectMap, "buildVersion", o.BuildVersion)
	populate(objectMap, "executionStatus", o.ExecutionStatus)
	populate(objectMap, "flightingRing", o.FlightingRing)
	populate(objectMap, "grade", o.Grade)
	populate(objectMap, "osName", o.OSName)
	populate(objectMap, "releaseName", o.ReleaseName)
	populateDateTimeRFC3339(objectMap, "releaseVersionDate", o.ReleaseVersionDate)
	populate(objectMap, "testRunTime", o.TestRunTime)
	populate(objectMap, "testStatus", o.TestStatus)
	populate(objectMap, "testType", o.TestType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdateTestSummary.
func (o *OSUpdateTestSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buildRevision":
			err = unpopulate(val, "BuildRevision", &o.BuildRevision)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &o.BuildVersion)
			delete(rawMsg, key)
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &o.ExecutionStatus)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &o.FlightingRing)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &o.Grade)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &o.OSName)
			delete(rawMsg, key)
		case "releaseName":
			err = unpopulate(val, "ReleaseName", &o.ReleaseName)
			delete(rawMsg, key)
		case "releaseVersionDate":
			err = unpopulateDateTimeRFC3339(val, "ReleaseVersionDate", &o.ReleaseVersionDate)
			delete(rawMsg, key)
		case "testRunTime":
			err = unpopulate(val, "TestRunTime", &o.TestRunTime)
			delete(rawMsg, key)
		case "testStatus":
			err = unpopulate(val, "TestStatus", &o.TestStatus)
			delete(rawMsg, key)
		case "testType":
			err = unpopulate(val, "TestType", &o.TestType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdatesTestSummary.
func (o OSUpdatesTestSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "executionStatus", o.ExecutionStatus)
	populate(objectMap, "grade", o.Grade)
	populate(objectMap, "osUpdateTestSummaries", o.OSUpdateTestSummaries)
	populate(objectMap, "testRunTime", o.TestRunTime)
	populate(objectMap, "testStatus", o.TestStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdatesTestSummary.
func (o *OSUpdatesTestSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &o.ExecutionStatus)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &o.Grade)
			delete(rawMsg, key)
		case "osUpdateTestSummaries":
			err = unpopulate(val, "OSUpdateTestSummaries", &o.OSUpdateTestSummaries)
			delete(rawMsg, key)
		case "testRunTime":
			err = unpopulate(val, "TestRunTime", &o.TestRunTime)
			delete(rawMsg, key)
		case "testStatus":
			err = unpopulate(val, "TestStatus", &o.TestStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageCheckNameAvailabilityParameters.
func (p PackageCheckNameAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", p.ApplicationName)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageCheckNameAvailabilityParameters.
func (p *PackageCheckNameAvailabilityParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &p.ApplicationName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageListResult.
func (p PackageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageListResult.
func (p *PackageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageProperties.
func (p PackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", p.ApplicationName)
	populate(objectMap, "blobPath", p.BlobPath)
	populate(objectMap, "flightingRing", p.FlightingRing)
	populate(objectMap, "isEnabled", p.IsEnabled)
	populateDateTimeRFC3339(objectMap, "lastModifiedTime", p.LastModifiedTime)
	populate(objectMap, "packageStatus", p.PackageStatus)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "targetOSList", p.TargetOSList)
	populate(objectMap, "testTypes", p.TestTypes)
	populate(objectMap, "tests", p.Tests)
	populate(objectMap, "validationResults", p.ValidationResults)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageProperties.
func (p *PackageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &p.ApplicationName)
			delete(rawMsg, key)
		case "blobPath":
			err = unpopulate(val, "BlobPath", &p.BlobPath)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &p.FlightingRing)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &p.IsEnabled)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTime", &p.LastModifiedTime)
			delete(rawMsg, key)
		case "packageStatus":
			err = unpopulate(val, "PackageStatus", &p.PackageStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "targetOSList":
			err = unpopulate(val, "TargetOSList", &p.TargetOSList)
			delete(rawMsg, key)
		case "testTypes":
			err = unpopulate(val, "TestTypes", &p.TestTypes)
			delete(rawMsg, key)
		case "tests":
			err = unpopulate(val, "Tests", &p.Tests)
			delete(rawMsg, key)
		case "validationResults":
			err = unpopulate(val, "ValidationResults", &p.ValidationResults)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageResource.
func (p PackageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageResource.
func (p *PackageResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageUpdateParameterProperties.
func (p PackageUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobPath", p.BlobPath)
	populate(objectMap, "flightingRing", p.FlightingRing)
	populate(objectMap, "isEnabled", p.IsEnabled)
	populate(objectMap, "targetOSList", p.TargetOSList)
	populate(objectMap, "tests", p.Tests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageUpdateParameterProperties.
func (p *PackageUpdateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobPath":
			err = unpopulate(val, "BlobPath", &p.BlobPath)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &p.FlightingRing)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &p.IsEnabled)
			delete(rawMsg, key)
		case "targetOSList":
			err = unpopulate(val, "TargetOSList", &p.TargetOSList)
			delete(rawMsg, key)
		case "tests":
			err = unpopulate(val, "Tests", &p.Tests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageUpdateParameters.
func (p PackageUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageUpdateParameters.
func (p *PackageUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageValidationResult.
func (p PackageValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", p.Errors)
	populate(objectMap, "isValid", p.IsValid)
	populate(objectMap, "validationName", p.ValidationName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageValidationResult.
func (p *PackageValidationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &p.Errors)
			delete(rawMsg, key)
		case "isValid":
			err = unpopulate(val, "IsValid", &p.IsValid)
			delete(rawMsg, key)
		case "validationName":
			err = unpopulate(val, "ValidationName", &p.ValidationName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegressionResult.
func (r RegressionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", r.Details)
	populate(objectMap, "diff", r.Diff)
	populate(objectMap, "fileName", r.FileName)
	populate(objectMap, "grade", r.Grade)
	populate(objectMap, "isRegressed", r.IsRegressed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegressionResult.
func (r *RegressionResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &r.Details)
			delete(rawMsg, key)
		case "diff":
			err = unpopulate(val, "Diff", &r.Diff)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &r.FileName)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &r.Grade)
			delete(rawMsg, key)
		case "isRegressed":
			err = unpopulate(val, "IsRegressed", &r.IsRegressed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegressionTestDetails.
func (r RegressionTestDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diff", r.Diff)
	populate(objectMap, "isRegressed", r.IsRegressed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegressionTestDetails.
func (r *RegressionTestDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diff":
			err = unpopulate(val, "Diff", &r.Diff)
			delete(rawMsg, key)
		case "isRegressed":
			err = unpopulate(val, "IsRegressed", &r.IsRegressed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReliabilityResult.
func (r ReliabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crashCount", r.CrashCount)
	populate(objectMap, "crashRegressionGrade", r.CrashRegressionGrade)
	populate(objectMap, "crashRegressionTestDetails", r.CrashRegressionTestDetails)
	populate(objectMap, "fileName", r.FileName)
	populate(objectMap, "hangCount", r.HangCount)
	populate(objectMap, "hangRegressionGrade", r.HangRegressionGrade)
	populate(objectMap, "hangRegressionTestDetails", r.HangRegressionTestDetails)
	populate(objectMap, "launchCount", r.LaunchCount)
	populate(objectMap, "regressionGrade", r.RegressionGrade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReliabilityResult.
func (r *ReliabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crashCount":
			err = unpopulate(val, "CrashCount", &r.CrashCount)
			delete(rawMsg, key)
		case "crashRegressionGrade":
			err = unpopulate(val, "CrashRegressionGrade", &r.CrashRegressionGrade)
			delete(rawMsg, key)
		case "crashRegressionTestDetails":
			err = unpopulate(val, "CrashRegressionTestDetails", &r.CrashRegressionTestDetails)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &r.FileName)
			delete(rawMsg, key)
		case "hangCount":
			err = unpopulate(val, "HangCount", &r.HangCount)
			delete(rawMsg, key)
		case "hangRegressionGrade":
			err = unpopulate(val, "HangRegressionGrade", &r.HangRegressionGrade)
			delete(rawMsg, key)
		case "hangRegressionTestDetails":
			err = unpopulate(val, "HangRegressionTestDetails", &r.HangRegressionTestDetails)
			delete(rawMsg, key)
		case "launchCount":
			err = unpopulate(val, "LaunchCount", &r.LaunchCount)
			delete(rawMsg, key)
		case "regressionGrade":
			err = unpopulate(val, "RegressionGrade", &r.RegressionGrade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReliabilityResultSingletonResourceProperties.
func (r ReliabilityResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeReliability
	populate(objectMap, "grade", r.Grade)
	populate(objectMap, "reliabilityResults", r.ReliabilityResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReliabilityResultSingletonResourceProperties.
func (r *ReliabilityResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &r.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &r.Grade)
			delete(rawMsg, key)
		case "reliabilityResults":
			err = unpopulate(val, "ReliabilityResults", &r.ReliabilityResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptExecutionResult.
func (s ScriptExecutionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "exitCode", s.ExitCode)
	populate(objectMap, "scriptName", s.ScriptName)
	populateDateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "timedOut", s.TimedOut)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptExecutionResult.
func (s *ScriptExecutionResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "exitCode":
			err = unpopulate(val, "ExitCode", &s.ExitCode)
			delete(rawMsg, key)
		case "scriptName":
			err = unpopulate(val, "ScriptName", &s.ScriptName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "timedOut":
			err = unpopulate(val, "TimedOut", &s.TimedOut)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptExecutionResultSingletonResourceProperties.
func (s ScriptExecutionResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeScriptExecution
	populate(objectMap, "grade", s.Grade)
	populate(objectMap, "scriptExecutionResults", s.ScriptExecutionResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptExecutionResultSingletonResourceProperties.
func (s *ScriptExecutionResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &s.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &s.Grade)
			delete(rawMsg, key)
		case "scriptExecutionResults":
			err = unpopulate(val, "ScriptExecutionResults", &s.ScriptExecutionResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionReceiverValue.
func (s SubscriptionReceiverValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "role", s.Role)
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	populate(objectMap, "subscriptionName", s.SubscriptionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionReceiverValue.
func (s *SubscriptionReceiverValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "role":
			err = unpopulate(val, "Role", &s.Role)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &s.SubscriptionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetOSInfo.
func (t TargetOSInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osUpdateType", t.OSUpdateType)
	populate(objectMap, "targetOSs", t.TargetOSs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetOSInfo.
func (t *TargetOSInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osUpdateType":
			err = unpopulate(val, "OSUpdateType", &t.OSUpdateType)
			delete(rawMsg, key)
		case "targetOSs":
			err = unpopulate(val, "TargetOSs", &t.TargetOSs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Test.
func (t Test) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commands", t.Commands)
	populate(objectMap, "isActive", t.IsActive)
	populate(objectMap, "testType", t.TestType)
	populate(objectMap, "validationRunStatus", t.ValidationRunStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Test.
func (t *Test) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commands":
			err = unpopulate(val, "Commands", &t.Commands)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &t.IsActive)
			delete(rawMsg, key)
		case "testType":
			err = unpopulate(val, "TestType", &t.TestType)
			delete(rawMsg, key)
		case "validationRunStatus":
			err = unpopulate(val, "ValidationRunStatus", &t.ValidationRunStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestAnalysisResult.
func (t TestAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobData", t.BlobData)
	populate(objectMap, "identifiedFailures", t.IdentifiedFailures)
	populate(objectMap, "testAnalysisStatus", t.TestAnalysisStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestAnalysisResult.
func (t *TestAnalysisResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobData":
			err = unpopulate(val, "BlobData", &t.BlobData)
			delete(rawMsg, key)
		case "identifiedFailures":
			err = unpopulate(val, "IdentifiedFailures", &t.IdentifiedFailures)
			delete(rawMsg, key)
		case "testAnalysisStatus":
			err = unpopulate(val, "TestAnalysisStatus", &t.TestAnalysisStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestAnalysisResultSingletonResourceProperties.
func (t TestAnalysisResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["analysisResultType"] = AnalysisResultTypeTestAnalysis
	populate(objectMap, "grade", t.Grade)
	populate(objectMap, "testAnalysisResult", t.TestAnalysisResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestAnalysisResultSingletonResourceProperties.
func (t *TestAnalysisResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &t.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &t.Grade)
			delete(rawMsg, key)
		case "testAnalysisResult":
			err = unpopulate(val, "TestAnalysisResult", &t.TestAnalysisResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestResultAnalysisSummary.
func (t TestResultAnalysisSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "analysisStatus", t.AnalysisStatus)
	populate(objectMap, "grade", t.Grade)
	populate(objectMap, "name", t.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestResultAnalysisSummary.
func (t *TestResultAnalysisSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisStatus":
			err = unpopulate(val, "AnalysisStatus", &t.AnalysisStatus)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &t.Grade)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestResultListResult.
func (t TestResultListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestResultListResult.
func (t *TestResultListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestResultProperties.
func (t TestResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "analysisSummaries", t.AnalysisSummaries)
	populate(objectMap, "applicationName", t.ApplicationName)
	populate(objectMap, "applicationVersion", t.ApplicationVersion)
	populate(objectMap, "baselineTestResultId", t.BaselineTestResultID)
	populate(objectMap, "buildRevision", t.BuildRevision)
	populate(objectMap, "buildVersion", t.BuildVersion)
	populate(objectMap, "executionStatus", t.ExecutionStatus)
	populate(objectMap, "flightingRing", t.FlightingRing)
	populate(objectMap, "grade", t.Grade)
	populate(objectMap, "isDownloadDataAvailable", t.IsDownloadDataAvailable)
	populate(objectMap, "isVideoAvailable", t.IsVideoAvailable)
	populate(objectMap, "kbNumber", t.KbNumber)
	populate(objectMap, "osName", t.OSName)
	populate(objectMap, "packageId", t.PackageID)
	populate(objectMap, "packageVersion", t.PackageVersion)
	populate(objectMap, "releaseName", t.ReleaseName)
	populateDateTimeRFC3339(objectMap, "releaseVersionDate", t.ReleaseVersionDate)
	populate(objectMap, "testRunTime", t.TestRunTime)
	populate(objectMap, "testStatus", t.TestStatus)
	populate(objectMap, "testType", t.TestType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestResultProperties.
func (t *TestResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisSummaries":
			err = unpopulate(val, "AnalysisSummaries", &t.AnalysisSummaries)
			delete(rawMsg, key)
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &t.ApplicationName)
			delete(rawMsg, key)
		case "applicationVersion":
			err = unpopulate(val, "ApplicationVersion", &t.ApplicationVersion)
			delete(rawMsg, key)
		case "baselineTestResultId":
			err = unpopulate(val, "BaselineTestResultID", &t.BaselineTestResultID)
			delete(rawMsg, key)
		case "buildRevision":
			err = unpopulate(val, "BuildRevision", &t.BuildRevision)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &t.BuildVersion)
			delete(rawMsg, key)
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &t.ExecutionStatus)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &t.FlightingRing)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &t.Grade)
			delete(rawMsg, key)
		case "isDownloadDataAvailable":
			err = unpopulate(val, "IsDownloadDataAvailable", &t.IsDownloadDataAvailable)
			delete(rawMsg, key)
		case "isVideoAvailable":
			err = unpopulate(val, "IsVideoAvailable", &t.IsVideoAvailable)
			delete(rawMsg, key)
		case "kbNumber":
			err = unpopulate(val, "KbNumber", &t.KbNumber)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &t.OSName)
			delete(rawMsg, key)
		case "packageId":
			err = unpopulate(val, "PackageID", &t.PackageID)
			delete(rawMsg, key)
		case "packageVersion":
			err = unpopulate(val, "PackageVersion", &t.PackageVersion)
			delete(rawMsg, key)
		case "releaseName":
			err = unpopulate(val, "ReleaseName", &t.ReleaseName)
			delete(rawMsg, key)
		case "releaseVersionDate":
			err = unpopulateDateTimeRFC3339(val, "ReleaseVersionDate", &t.ReleaseVersionDate)
			delete(rawMsg, key)
		case "testRunTime":
			err = unpopulate(val, "TestRunTime", &t.TestRunTime)
			delete(rawMsg, key)
		case "testStatus":
			err = unpopulate(val, "TestStatus", &t.TestStatus)
			delete(rawMsg, key)
		case "testType":
			err = unpopulate(val, "TestType", &t.TestType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestResultResource.
func (t TestResultResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestResultResource.
func (t *TestResultResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestSummaryListResult.
func (t TestSummaryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestSummaryListResult.
func (t *TestSummaryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestSummaryProperties.
func (t TestSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", t.ApplicationName)
	populate(objectMap, "applicationVersion", t.ApplicationVersion)
	populate(objectMap, "executionStatus", t.ExecutionStatus)
	populate(objectMap, "featureUpdatesTestSummary", t.FeatureUpdatesTestSummary)
	populate(objectMap, "grade", t.Grade)
	populate(objectMap, "packageId", t.PackageID)
	populate(objectMap, "securityUpdatesTestSummary", t.SecurityUpdatesTestSummary)
	populate(objectMap, "testRunTime", t.TestRunTime)
	populate(objectMap, "testStatus", t.TestStatus)
	populate(objectMap, "testSummaryId", t.TestSummaryID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestSummaryProperties.
func (t *TestSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &t.ApplicationName)
			delete(rawMsg, key)
		case "applicationVersion":
			err = unpopulate(val, "ApplicationVersion", &t.ApplicationVersion)
			delete(rawMsg, key)
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &t.ExecutionStatus)
			delete(rawMsg, key)
		case "featureUpdatesTestSummary":
			err = unpopulate(val, "FeatureUpdatesTestSummary", &t.FeatureUpdatesTestSummary)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &t.Grade)
			delete(rawMsg, key)
		case "packageId":
			err = unpopulate(val, "PackageID", &t.PackageID)
			delete(rawMsg, key)
		case "securityUpdatesTestSummary":
			err = unpopulate(val, "SecurityUpdatesTestSummary", &t.SecurityUpdatesTestSummary)
			delete(rawMsg, key)
		case "testRunTime":
			err = unpopulate(val, "TestRunTime", &t.TestRunTime)
			delete(rawMsg, key)
		case "testStatus":
			err = unpopulate(val, "TestStatus", &t.TestStatus)
			delete(rawMsg, key)
		case "testSummaryId":
			err = unpopulate(val, "TestSummaryID", &t.TestSummaryID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestSummaryResource.
func (t TestSummaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestSummaryResource.
func (t *TestSummaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestTypeListResult.
func (t TestTypeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestTypeListResult.
func (t *TestTypeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestTypeProperties.
func (t TestTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actualTestTypeName", t.ActualTestTypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestTypeProperties.
func (t *TestTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actualTestTypeName":
			err = unpopulate(val, "ActualTestTypeName", &t.ActualTestTypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestTypeResource.
func (t TestTypeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestTypeResource.
func (t *TestTypeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserObjectReceiverValue.
func (u UserObjectReceiverValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userObjectIds", u.UserObjectIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserObjectReceiverValue.
func (u *UserObjectReceiverValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userObjectIds":
			err = unpopulate(val, "UserObjectIDs", &u.UserObjectIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UtilizationBound.
func (u UtilizationBound) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "percentile", u.Percentile)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UtilizationBound.
func (u *UtilizationBound) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "percentile":
			err = unpopulate(val, "Percentile", &u.Percentile)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UtilizationEntry.
func (u UtilizationEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "timestamp", u.Timestamp)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UtilizationEntry.
func (u *UtilizationEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &u.Timestamp)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UtilizationResult.
func (u UtilizationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lowerBound", u.LowerBound)
	populate(objectMap, "process", u.Process)
	populate(objectMap, "upperBound", u.UpperBound)
	populate(objectMap, "utilization", u.Utilization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UtilizationResult.
func (u *UtilizationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lowerBound":
			err = unpopulate(val, "LowerBound", &u.LowerBound)
			delete(rawMsg, key)
		case "process":
			err = unpopulate(val, "Process", &u.Process)
			delete(rawMsg, key)
		case "upperBound":
			err = unpopulate(val, "UpperBound", &u.UpperBound)
			delete(rawMsg, key)
		case "utilization":
			err = unpopulate(val, "Utilization", &u.Utilization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
