//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetricDefinitions.json
func ExampleMetricDefinitionsClient_NewListAtSubscriptionScopePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMetricDefinitionsClient().NewListAtSubscriptionScopePager("westus2", &armmonitor.MetricDefinitionsClientListAtSubscriptionScopeOptions{Metricnamespace: to.Ptr("microsoft.compute/virtualmachines")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionScopeMetricDefinitionCollection = armmonitor.SubscriptionScopeMetricDefinitionCollection{
		// 	Value: []*armmonitor.SubscriptionScopeMetricDefinition{
		// 		{
		// 			Name: &armmonitor.LocalizableString{
		// 				LocalizedValue: to.Ptr("Percentage CPU"),
		// 				Value: to.Ptr("Percentage CPU"),
		// 			},
		// 			Dimensions: []*armmonitor.LocalizableString{
		// 				{
		// 					LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 					Value: to.Ptr("Microsoft.ResourceId"),
		// 				},
		// 				{
		// 					LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 					Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 			}},
		// 			DisplayDescription: to.Ptr("The percentage of allocated compute units that are currently in use by the Virtual Machine(s)"),
		// 			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Percentage CPU"),
		// 			IsDimensionRequired: to.Ptr(false),
		// 			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT5M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT15M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT30M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT6H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT12H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 			PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 			SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 				to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 				to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 				to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 				to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 				to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 				to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 				Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 			},
		// 			{
		// 				Name: &armmonitor.LocalizableString{
		// 					LocalizedValue: to.Ptr("Network In Billable (Deprecated)"),
		// 					Value: to.Ptr("Network In"),
		// 				},
		// 				Dimensions: []*armmonitor.LocalizableString{
		// 					{
		// 						LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 						Value: to.Ptr("Microsoft.ResourceId"),
		// 					},
		// 					{
		// 						LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 						Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 				}},
		// 				DisplayDescription: to.Ptr("The number of billable bytes received on all network interfaces by the Virtual Machine(s) (Incoming Traffic) (Deprecated)"),
		// 				ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Network In"),
		// 				IsDimensionRequired: to.Ptr(false),
		// 				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT5M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT15M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT30M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT6H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT12H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("P1D"),
		// 				}},
		// 				Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 				PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 				ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 				SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 					to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 					to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 					to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 					to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 					to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 					to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 					Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 				},
		// 				{
		// 					Name: &armmonitor.LocalizableString{
		// 						LocalizedValue: to.Ptr("Network Out Billable (Deprecated)"),
		// 						Value: to.Ptr("Network Out"),
		// 					},
		// 					Dimensions: []*armmonitor.LocalizableString{
		// 						{
		// 							LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 							Value: to.Ptr("Microsoft.ResourceId"),
		// 						},
		// 						{
		// 							LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 							Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 					}},
		// 					DisplayDescription: to.Ptr("The number of billable bytes out on all network interfaces by the Virtual Machine(s) (Outgoing Traffic) (Deprecated)"),
		// 					ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Network Out"),
		// 					IsDimensionRequired: to.Ptr(false),
		// 					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT5M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT15M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT30M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT6H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT12H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("P1D"),
		// 					}},
		// 					Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 					PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 					ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 					SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 						to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 						to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 						to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 						to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 						to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 						to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 						Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 					},
		// 					{
		// 						Name: &armmonitor.LocalizableString{
		// 							LocalizedValue: to.Ptr("Disk Read Bytes"),
		// 							Value: to.Ptr("Disk Read Bytes"),
		// 						},
		// 						Dimensions: []*armmonitor.LocalizableString{
		// 							{
		// 								LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 								Value: to.Ptr("Microsoft.ResourceId"),
		// 							},
		// 							{
		// 								LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 								Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 						}},
		// 						DisplayDescription: to.Ptr("Bytes read from disk during monitoring period"),
		// 						ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Disk Read Bytes"),
		// 						IsDimensionRequired: to.Ptr(false),
		// 						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT5M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT15M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT30M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT6H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT12H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("P1D"),
		// 						}},
		// 						Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 						PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 						ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 						SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 							to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 							to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 							to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 							to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 							to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 							to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 							Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 						},
		// 						{
		// 							Name: &armmonitor.LocalizableString{
		// 								LocalizedValue: to.Ptr("Disk Write Bytes"),
		// 								Value: to.Ptr("Disk Write Bytes"),
		// 							},
		// 							Dimensions: []*armmonitor.LocalizableString{
		// 								{
		// 									LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 									Value: to.Ptr("Microsoft.ResourceId"),
		// 								},
		// 								{
		// 									LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 									Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 							}},
		// 							DisplayDescription: to.Ptr("Bytes written to disk during monitoring period"),
		// 							ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Disk Write Bytes"),
		// 							IsDimensionRequired: to.Ptr(false),
		// 							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT5M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT15M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT30M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT6H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT12H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 							PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 							ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 							SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 								to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 								to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 								to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 								to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 								to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 								to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 								Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 							},
		// 							{
		// 								Name: &armmonitor.LocalizableString{
		// 									LocalizedValue: to.Ptr("Disk Read Operations/Sec"),
		// 									Value: to.Ptr("Disk Read Operations/Sec"),
		// 								},
		// 								Dimensions: []*armmonitor.LocalizableString{
		// 									{
		// 										LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 										Value: to.Ptr("Microsoft.ResourceId"),
		// 									},
		// 									{
		// 										LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 										Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 								}},
		// 								DisplayDescription: to.Ptr("Disk Read IOPS"),
		// 								ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Disk Read Operations/Sec"),
		// 								IsDimensionRequired: to.Ptr(false),
		// 								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT5M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT15M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT30M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT6H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT12H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("P1D"),
		// 								}},
		// 								Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 								PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 								ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 								SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 									to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 									to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 									to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 									to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 									to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 									to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 									Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 								},
		// 								{
		// 									Name: &armmonitor.LocalizableString{
		// 										LocalizedValue: to.Ptr("Disk Write Operations/Sec"),
		// 										Value: to.Ptr("Disk Write Operations/Sec"),
		// 									},
		// 									Dimensions: []*armmonitor.LocalizableString{
		// 										{
		// 											LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 											Value: to.Ptr("Microsoft.ResourceId"),
		// 										},
		// 										{
		// 											LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 											Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 									}},
		// 									DisplayDescription: to.Ptr("Disk Write IOPS"),
		// 									ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Disk Write Operations/Sec"),
		// 									IsDimensionRequired: to.Ptr(false),
		// 									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT5M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT15M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT30M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT6H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT12H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("P1D"),
		// 									}},
		// 									Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 									PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 									ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 									SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 										to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 										to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 										to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 										to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 										to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 										to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 										Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 									},
		// 									{
		// 										Name: &armmonitor.LocalizableString{
		// 											LocalizedValue: to.Ptr("CPU Credits Remaining"),
		// 											Value: to.Ptr("CPU Credits Remaining"),
		// 										},
		// 										Dimensions: []*armmonitor.LocalizableString{
		// 											{
		// 												LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 												Value: to.Ptr("Microsoft.ResourceId"),
		// 											},
		// 											{
		// 												LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 												Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 										}},
		// 										DisplayDescription: to.Ptr("Total number of credits available to burst. Only available on B-series burstable VMs"),
		// 										ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/CPU Credits Remaining"),
		// 										IsDimensionRequired: to.Ptr(false),
		// 										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT5M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT15M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT30M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT6H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT12H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("P1D"),
		// 										}},
		// 										Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 										PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 										ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 										SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 											to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 											to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 											to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 											to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 											to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 											to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 											Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 										},
		// 										{
		// 											Name: &armmonitor.LocalizableString{
		// 												LocalizedValue: to.Ptr("CPU Credits Consumed"),
		// 												Value: to.Ptr("CPU Credits Consumed"),
		// 											},
		// 											Dimensions: []*armmonitor.LocalizableString{
		// 												{
		// 													LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 													Value: to.Ptr("Microsoft.ResourceId"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 													Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 											}},
		// 											DisplayDescription: to.Ptr("Total number of credits consumed by the Virtual Machine. Only available on B-series burstable VMs"),
		// 											ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/CPU Credits Consumed"),
		// 											IsDimensionRequired: to.Ptr(false),
		// 											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT5M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT15M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT30M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT6H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT12H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("P1D"),
		// 											}},
		// 											Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 											PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 											ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 											SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 												to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 												to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 												to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 												to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 												to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 												to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 												Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 											},
		// 											{
		// 												Name: &armmonitor.LocalizableString{
		// 													LocalizedValue: to.Ptr("Data Disk Read Bytes/Sec"),
		// 													Value: to.Ptr("Data Disk Read Bytes/sec"),
		// 												},
		// 												Dimensions: []*armmonitor.LocalizableString{
		// 													{
		// 														LocalizedValue: to.Ptr("LUN"),
		// 														Value: to.Ptr("LUN"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 														Value: to.Ptr("Microsoft.ResourceId"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 														Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 												}},
		// 												DisplayDescription: to.Ptr("Bytes/Sec read from a single disk during monitoring period"),
		// 												ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Read Bytes/sec"),
		// 												IsDimensionRequired: to.Ptr(false),
		// 												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT5M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT15M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT30M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT6H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT12H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("P1D"),
		// 												}},
		// 												Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 												PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 												ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 												SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 													to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 													to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 													to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 													to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 													to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 													to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 													Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 												},
		// 												{
		// 													Name: &armmonitor.LocalizableString{
		// 														LocalizedValue: to.Ptr("Data Disk Write Bytes/Sec"),
		// 														Value: to.Ptr("Data Disk Write Bytes/sec"),
		// 													},
		// 													Dimensions: []*armmonitor.LocalizableString{
		// 														{
		// 															LocalizedValue: to.Ptr("LUN"),
		// 															Value: to.Ptr("LUN"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 															Value: to.Ptr("Microsoft.ResourceId"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 															Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 													}},
		// 													DisplayDescription: to.Ptr("Bytes/Sec written to a single disk during monitoring period"),
		// 													ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Write Bytes/sec"),
		// 													IsDimensionRequired: to.Ptr(false),
		// 													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT5M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT15M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT30M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT6H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT12H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("P1D"),
		// 													}},
		// 													Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 													PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 													ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 													SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 														to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 														to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 														to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 														to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 														to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 														to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 														Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 													},
		// 													{
		// 														Name: &armmonitor.LocalizableString{
		// 															LocalizedValue: to.Ptr("Data Disk Read Operations/Sec"),
		// 															Value: to.Ptr("Data Disk Read Operations/Sec"),
		// 														},
		// 														Dimensions: []*armmonitor.LocalizableString{
		// 															{
		// 																LocalizedValue: to.Ptr("LUN"),
		// 																Value: to.Ptr("LUN"),
		// 															},
		// 															{
		// 																LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																Value: to.Ptr("Microsoft.ResourceId"),
		// 															},
		// 															{
		// 																LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 														}},
		// 														DisplayDescription: to.Ptr("Read IOPS from a single disk during monitoring period"),
		// 														ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Read Operations/Sec"),
		// 														IsDimensionRequired: to.Ptr(false),
		// 														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT5M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT15M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT30M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT6H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT12H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("P1D"),
		// 														}},
		// 														Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 														PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 														ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 														SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 															to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 															to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 															to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 															to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 															to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 															to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 															Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 														},
		// 														{
		// 															Name: &armmonitor.LocalizableString{
		// 																LocalizedValue: to.Ptr("Data Disk Write Operations/Sec"),
		// 																Value: to.Ptr("Data Disk Write Operations/Sec"),
		// 															},
		// 															Dimensions: []*armmonitor.LocalizableString{
		// 																{
		// 																	LocalizedValue: to.Ptr("LUN"),
		// 																	Value: to.Ptr("LUN"),
		// 																},
		// 																{
		// 																	LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																	Value: to.Ptr("Microsoft.ResourceId"),
		// 																},
		// 																{
		// 																	LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																	Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 															}},
		// 															DisplayDescription: to.Ptr("Write IOPS from a single disk during monitoring period"),
		// 															ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Write Operations/Sec"),
		// 															IsDimensionRequired: to.Ptr(false),
		// 															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT5M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT15M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT30M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT6H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT12H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("P1D"),
		// 															}},
		// 															Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 															PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 															ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 															SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 															},
		// 															{
		// 																Name: &armmonitor.LocalizableString{
		// 																	LocalizedValue: to.Ptr("Data Disk Queue Depth"),
		// 																	Value: to.Ptr("Data Disk Queue Depth"),
		// 																},
		// 																Dimensions: []*armmonitor.LocalizableString{
		// 																	{
		// 																		LocalizedValue: to.Ptr("LUN"),
		// 																		Value: to.Ptr("LUN"),
		// 																	},
		// 																	{
		// 																		LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																		Value: to.Ptr("Microsoft.ResourceId"),
		// 																	},
		// 																	{
		// 																		LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																		Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																}},
		// 																DisplayDescription: to.Ptr("Data Disk Queue Depth(or Queue Length)"),
		// 																ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Queue Depth"),
		// 																IsDimensionRequired: to.Ptr(false),
		// 																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT5M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT15M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT30M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT6H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT12H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("P1D"),
		// 																}},
		// 																Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																	to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																	to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																	to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																	to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																	to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																	to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																	Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																},
		// 																{
		// 																	Name: &armmonitor.LocalizableString{
		// 																		LocalizedValue: to.Ptr("Data Disk Bandwidth Consumed Percentage"),
		// 																		Value: to.Ptr("Data Disk Bandwidth Consumed Percentage"),
		// 																	},
		// 																	Dimensions: []*armmonitor.LocalizableString{
		// 																		{
		// 																			LocalizedValue: to.Ptr("LUN"),
		// 																			Value: to.Ptr("LUN"),
		// 																		},
		// 																		{
		// 																			LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																			Value: to.Ptr("Microsoft.ResourceId"),
		// 																		},
		// 																		{
		// 																			LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																			Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																	}},
		// 																	DisplayDescription: to.Ptr("Percentage of data disk bandwidth consumed per minute"),
		// 																	ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Bandwidth Consumed Percentage"),
		// 																	IsDimensionRequired: to.Ptr(false),
		// 																	MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT5M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT15M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT30M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT6H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT12H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("P1D"),
		// 																	}},
		// 																	Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																	PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																	ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																	SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																		to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																		to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																		to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																		to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																		to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																		to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																		Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																	},
		// 																	{
		// 																		Name: &armmonitor.LocalizableString{
		// 																			LocalizedValue: to.Ptr("Data Disk IOPS Consumed Percentage"),
		// 																			Value: to.Ptr("Data Disk IOPS Consumed Percentage"),
		// 																		},
		// 																		Dimensions: []*armmonitor.LocalizableString{
		// 																			{
		// 																				LocalizedValue: to.Ptr("LUN"),
		// 																				Value: to.Ptr("LUN"),
		// 																			},
		// 																			{
		// 																				LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																				Value: to.Ptr("Microsoft.ResourceId"),
		// 																			},
		// 																			{
		// 																				LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																				Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																		}},
		// 																		DisplayDescription: to.Ptr("Percentage of data disk I/Os consumed per minute"),
		// 																		ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk IOPS Consumed Percentage"),
		// 																		IsDimensionRequired: to.Ptr(false),
		// 																		MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT5M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT15M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT30M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT6H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT12H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("P1D"),
		// 																		}},
		// 																		Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																		PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																		ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																		SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																			to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																			to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																			to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																			to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																			to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																			to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																			Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																		},
		// 																		{
		// 																			Name: &armmonitor.LocalizableString{
		// 																				LocalizedValue: to.Ptr("Data Disk Target Bandwidth"),
		// 																				Value: to.Ptr("Data Disk Target Bandwidth"),
		// 																			},
		// 																			Dimensions: []*armmonitor.LocalizableString{
		// 																				{
		// 																					LocalizedValue: to.Ptr("LUN"),
		// 																					Value: to.Ptr("LUN"),
		// 																				},
		// 																				{
		// 																					LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																					Value: to.Ptr("Microsoft.ResourceId"),
		// 																				},
		// 																				{
		// 																					LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																					Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																			}},
		// 																			DisplayDescription: to.Ptr("Baseline bytes per second throughput Data Disk can achieve without bursting"),
		// 																			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Target Bandwidth"),
		// 																			IsDimensionRequired: to.Ptr(false),
		// 																			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT1M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT5M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT15M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT30M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT1H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT6H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT12H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("P1D"),
		// 																			}},
		// 																			Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																			PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																			ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																			SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																				to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																				to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																				to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																				to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																				to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																				to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																				Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																			},
		// 																			{
		// 																				Name: &armmonitor.LocalizableString{
		// 																					LocalizedValue: to.Ptr("Data Disk Target IOPS"),
		// 																					Value: to.Ptr("Data Disk Target IOPS"),
		// 																				},
		// 																				Dimensions: []*armmonitor.LocalizableString{
		// 																					{
		// 																						LocalizedValue: to.Ptr("LUN"),
		// 																						Value: to.Ptr("LUN"),
		// 																					},
		// 																					{
		// 																						LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																						Value: to.Ptr("Microsoft.ResourceId"),
		// 																					},
		// 																					{
		// 																						LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																						Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																				}},
		// 																				DisplayDescription: to.Ptr("Baseline IOPS Data Disk can achieve without bursting"),
		// 																				ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Target IOPS"),
		// 																				IsDimensionRequired: to.Ptr(false),
		// 																				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT1M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT5M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT15M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT30M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT1H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT6H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT12H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("P1D"),
		// 																				}},
		// 																				Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																				PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																				ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																				SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																					to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																					to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																					to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																					to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																					to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																					to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																					Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																				},
		// 																				{
		// 																					Name: &armmonitor.LocalizableString{
		// 																						LocalizedValue: to.Ptr("Data Disk Max Burst Bandwidth"),
		// 																						Value: to.Ptr("Data Disk Max Burst Bandwidth"),
		// 																					},
		// 																					Dimensions: []*armmonitor.LocalizableString{
		// 																						{
		// 																							LocalizedValue: to.Ptr("LUN"),
		// 																							Value: to.Ptr("LUN"),
		// 																						},
		// 																						{
		// 																							LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																							Value: to.Ptr("Microsoft.ResourceId"),
		// 																						},
		// 																						{
		// 																							LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																							Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																					}},
		// 																					DisplayDescription: to.Ptr("Maximum bytes per second throughput Data Disk can achieve with bursting"),
		// 																					ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Max Burst Bandwidth"),
		// 																					IsDimensionRequired: to.Ptr(false),
		// 																					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT1M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT5M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT15M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT30M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT1H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT6H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT12H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("P1D"),
		// 																					}},
		// 																					Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																					PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																					ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																					SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																						to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																						to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																						to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																						to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																						to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																						to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																						Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																					},
		// 																					{
		// 																						Name: &armmonitor.LocalizableString{
		// 																							LocalizedValue: to.Ptr("Data Disk Max Burst IOPS"),
		// 																							Value: to.Ptr("Data Disk Max Burst IOPS"),
		// 																						},
		// 																						Dimensions: []*armmonitor.LocalizableString{
		// 																							{
		// 																								LocalizedValue: to.Ptr("LUN"),
		// 																								Value: to.Ptr("LUN"),
		// 																							},
		// 																							{
		// 																								LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																								Value: to.Ptr("Microsoft.ResourceId"),
		// 																							},
		// 																							{
		// 																								LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																								Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																						}},
		// 																						DisplayDescription: to.Ptr("Maximum IOPS Data Disk can achieve with bursting"),
		// 																						ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Max Burst IOPS"),
		// 																						IsDimensionRequired: to.Ptr(false),
		// 																						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT1M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT5M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT15M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT30M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT1H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT6H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT12H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("P1D"),
		// 																						}},
		// 																						Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																						PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																						ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																						SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																							to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																							to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																							to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																							to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																							to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																							to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																							Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																						},
		// 																						{
		// 																							Name: &armmonitor.LocalizableString{
		// 																								LocalizedValue: to.Ptr("Data Disk Used Burst BPS Credits Percentage"),
		// 																								Value: to.Ptr("Data Disk Used Burst BPS Credits Percentage"),
		// 																							},
		// 																							Dimensions: []*armmonitor.LocalizableString{
		// 																								{
		// 																									LocalizedValue: to.Ptr("LUN"),
		// 																									Value: to.Ptr("LUN"),
		// 																								},
		// 																								{
		// 																									LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																									Value: to.Ptr("Microsoft.ResourceId"),
		// 																								},
		// 																								{
		// 																									LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																									Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																							}},
		// 																							DisplayDescription: to.Ptr("Percentage of Data Disk burst bandwidth credits used so far"),
		// 																							ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Used Burst BPS Credits Percentage"),
		// 																							IsDimensionRequired: to.Ptr(false),
		// 																							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT1M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT5M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT15M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT30M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT1H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT6H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT12H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("P1D"),
		// 																							}},
		// 																							Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																							PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																							ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																							SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																								to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																								to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																								to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																								to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																								to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																								to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																								Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																							},
		// 																							{
		// 																								Name: &armmonitor.LocalizableString{
		// 																									LocalizedValue: to.Ptr("Data Disk Used Burst IO Credits Percentage"),
		// 																									Value: to.Ptr("Data Disk Used Burst IO Credits Percentage"),
		// 																								},
		// 																								Dimensions: []*armmonitor.LocalizableString{
		// 																									{
		// 																										LocalizedValue: to.Ptr("LUN"),
		// 																										Value: to.Ptr("LUN"),
		// 																									},
		// 																									{
		// 																										LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																										Value: to.Ptr("Microsoft.ResourceId"),
		// 																									},
		// 																									{
		// 																										LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																										Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																								}},
		// 																								DisplayDescription: to.Ptr("Percentage of Data Disk burst I/O credits used so far"),
		// 																								ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Data Disk Used Burst IO Credits Percentage"),
		// 																								IsDimensionRequired: to.Ptr(false),
		// 																								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT1M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT5M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT15M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT30M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT1H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT6H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT12H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("P1D"),
		// 																								}},
		// 																								Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																								PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																								ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																								SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																									to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																									to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																									to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																									to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																									to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																									to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																									Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																								},
		// 																								{
		// 																									Name: &armmonitor.LocalizableString{
		// 																										LocalizedValue: to.Ptr("OS Disk Read Bytes/Sec"),
		// 																										Value: to.Ptr("OS Disk Read Bytes/sec"),
		// 																									},
		// 																									Dimensions: []*armmonitor.LocalizableString{
		// 																										{
		// 																											LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																											Value: to.Ptr("Microsoft.ResourceId"),
		// 																										},
		// 																										{
		// 																											LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																											Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																									}},
		// 																									DisplayDescription: to.Ptr("Bytes/Sec read from a single disk during monitoring period for OS disk"),
		// 																									ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Read Bytes/sec"),
		// 																									IsDimensionRequired: to.Ptr(false),
		// 																									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT1M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT5M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT15M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT30M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT1H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT6H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT12H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("P1D"),
		// 																									}},
		// 																									Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																									PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																									ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																									SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																										to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																										to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																										to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																										to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																										to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																										to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																										Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																									},
		// 																									{
		// 																										Name: &armmonitor.LocalizableString{
		// 																											LocalizedValue: to.Ptr("OS Disk Write Bytes/Sec"),
		// 																											Value: to.Ptr("OS Disk Write Bytes/sec"),
		// 																										},
		// 																										Dimensions: []*armmonitor.LocalizableString{
		// 																											{
		// 																												LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																												Value: to.Ptr("Microsoft.ResourceId"),
		// 																											},
		// 																											{
		// 																												LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																												Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																										}},
		// 																										DisplayDescription: to.Ptr("Bytes/Sec written to a single disk during monitoring period for OS disk"),
		// 																										ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Write Bytes/sec"),
		// 																										IsDimensionRequired: to.Ptr(false),
		// 																										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT1M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT5M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT15M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT30M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT1H"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT6H"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT12H"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("P1D"),
		// 																										}},
		// 																										Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																										PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																										ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																										SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																											to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																											to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																											to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																											to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																											to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																											to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																											Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																										},
		// 																										{
		// 																											Name: &armmonitor.LocalizableString{
		// 																												LocalizedValue: to.Ptr("OS Disk Read Operations/Sec"),
		// 																												Value: to.Ptr("OS Disk Read Operations/Sec"),
		// 																											},
		// 																											Dimensions: []*armmonitor.LocalizableString{
		// 																												{
		// 																													LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																													Value: to.Ptr("Microsoft.ResourceId"),
		// 																												},
		// 																												{
		// 																													LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																													Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																											}},
		// 																											DisplayDescription: to.Ptr("Read IOPS from a single disk during monitoring period for OS disk"),
		// 																											ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Read Operations/Sec"),
		// 																											IsDimensionRequired: to.Ptr(false),
		// 																											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT1M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT5M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT15M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT30M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT1H"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT6H"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT12H"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("P1D"),
		// 																											}},
		// 																											Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																											PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																											ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																											SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																												to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																												to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																												to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																												to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																												to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																												to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																												Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																											},
		// 																											{
		// 																												Name: &armmonitor.LocalizableString{
		// 																													LocalizedValue: to.Ptr("OS Disk Write Operations/Sec"),
		// 																													Value: to.Ptr("OS Disk Write Operations/Sec"),
		// 																												},
		// 																												Dimensions: []*armmonitor.LocalizableString{
		// 																													{
		// 																														LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																														Value: to.Ptr("Microsoft.ResourceId"),
		// 																													},
		// 																													{
		// 																														LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																														Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																												}},
		// 																												DisplayDescription: to.Ptr("Write IOPS from a single disk during monitoring period for OS disk"),
		// 																												ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Write Operations/Sec"),
		// 																												IsDimensionRequired: to.Ptr(false),
		// 																												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT1M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT5M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT15M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT30M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT1H"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT6H"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT12H"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("P1D"),
		// 																												}},
		// 																												Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																												PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																												ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																												SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																													to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																													to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																													to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																													to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																													to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																													to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																													Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																												},
		// 																												{
		// 																													Name: &armmonitor.LocalizableString{
		// 																														LocalizedValue: to.Ptr("OS Disk Queue Depth"),
		// 																														Value: to.Ptr("OS Disk Queue Depth"),
		// 																													},
		// 																													Dimensions: []*armmonitor.LocalizableString{
		// 																														{
		// 																															LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																															Value: to.Ptr("Microsoft.ResourceId"),
		// 																														},
		// 																														{
		// 																															LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																															Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																													}},
		// 																													DisplayDescription: to.Ptr("OS Disk Queue Depth(or Queue Length)"),
		// 																													ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Queue Depth"),
		// 																													IsDimensionRequired: to.Ptr(false),
		// 																													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT1M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT5M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT15M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT30M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT1H"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT6H"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT12H"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("P1D"),
		// 																													}},
		// 																													Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																													PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																													ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																													SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																														to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																														to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																														to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																														to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																														to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																														to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																														Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																													},
		// 																													{
		// 																														Name: &armmonitor.LocalizableString{
		// 																															LocalizedValue: to.Ptr("OS Disk Bandwidth Consumed Percentage"),
		// 																															Value: to.Ptr("OS Disk Bandwidth Consumed Percentage"),
		// 																														},
		// 																														Dimensions: []*armmonitor.LocalizableString{
		// 																															{
		// 																																LocalizedValue: to.Ptr("LUN"),
		// 																																Value: to.Ptr("LUN"),
		// 																															},
		// 																															{
		// 																																LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																Value: to.Ptr("Microsoft.ResourceId"),
		// 																															},
		// 																															{
		// 																																LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																														}},
		// 																														DisplayDescription: to.Ptr("Percentage of operating system disk bandwidth consumed per minute"),
		// 																														ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Bandwidth Consumed Percentage"),
		// 																														IsDimensionRequired: to.Ptr(false),
		// 																														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT1M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT5M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT15M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT30M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT1H"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT6H"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT12H"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("P1D"),
		// 																														}},
		// 																														Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																														PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																														ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																														SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																															to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																															to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																															to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																															to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																															to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																															to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																															Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																														},
		// 																														{
		// 																															Name: &armmonitor.LocalizableString{
		// 																																LocalizedValue: to.Ptr("OS Disk IOPS Consumed Percentage"),
		// 																																Value: to.Ptr("OS Disk IOPS Consumed Percentage"),
		// 																															},
		// 																															Dimensions: []*armmonitor.LocalizableString{
		// 																																{
		// 																																	LocalizedValue: to.Ptr("LUN"),
		// 																																	Value: to.Ptr("LUN"),
		// 																																},
		// 																																{
		// 																																	LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																	Value: to.Ptr("Microsoft.ResourceId"),
		// 																																},
		// 																																{
		// 																																	LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																	Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																															}},
		// 																															DisplayDescription: to.Ptr("Percentage of operating system disk I/Os consumed per minute"),
		// 																															ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk IOPS Consumed Percentage"),
		// 																															IsDimensionRequired: to.Ptr(false),
		// 																															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT1M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT5M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT15M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT30M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT1H"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT6H"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT12H"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("P1D"),
		// 																															}},
		// 																															Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																															PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																															ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																															SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																															},
		// 																															{
		// 																																Name: &armmonitor.LocalizableString{
		// 																																	LocalizedValue: to.Ptr("OS Disk Target Bandwidth"),
		// 																																	Value: to.Ptr("OS Disk Target Bandwidth"),
		// 																																},
		// 																																Dimensions: []*armmonitor.LocalizableString{
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("LUN"),
		// 																																		Value: to.Ptr("LUN"),
		// 																																	},
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																		Value: to.Ptr("Microsoft.ResourceId"),
		// 																																	},
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																		Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																}},
		// 																																DisplayDescription: to.Ptr("Baseline bytes per second throughput OS Disk can achieve without bursting"),
		// 																																ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Target Bandwidth"),
		// 																																IsDimensionRequired: to.Ptr(false),
		// 																																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT1M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT5M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT15M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT30M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT1H"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT6H"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT12H"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("P1D"),
		// 																																}},
		// 																																Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																	to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																	to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																	to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																	to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																	to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																	to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																	Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																																},
		// 																																{
		// 																																	Name: &armmonitor.LocalizableString{
		// 																																		LocalizedValue: to.Ptr("OS Disk Target IOPS"),
		// 																																		Value: to.Ptr("OS Disk Target IOPS"),
		// 																																	},
		// 																																	Dimensions: []*armmonitor.LocalizableString{
		// 																																		{
		// 																																			LocalizedValue: to.Ptr("LUN"),
		// 																																			Value: to.Ptr("LUN"),
		// 																																		},
		// 																																		{
		// 																																			LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																			Value: to.Ptr("Microsoft.ResourceId"),
		// 																																		},
		// 																																		{
		// 																																			LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																			Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																	}},
		// 																																	DisplayDescription: to.Ptr("Baseline IOPS OS Disk can achieve without bursting"),
		// 																																	ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Target IOPS"),
		// 																																	IsDimensionRequired: to.Ptr(false),
		// 																																	MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT1M"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT5M"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT15M"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT30M"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT1H"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT6H"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("PT12H"),
		// 																																		},
		// 																																		{
		// 																																			Retention: to.Ptr("P93D"),
		// 																																			TimeGrain: to.Ptr("P1D"),
		// 																																	}},
		// 																																	Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																	PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																	ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																	SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																		to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																		to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																		to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																		to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																		to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																		to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																		Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																																	},
		// 																																	{
		// 																																		Name: &armmonitor.LocalizableString{
		// 																																			LocalizedValue: to.Ptr("OS Disk Max Burst Bandwidth"),
		// 																																			Value: to.Ptr("OS Disk Max Burst Bandwidth"),
		// 																																		},
		// 																																		Dimensions: []*armmonitor.LocalizableString{
		// 																																			{
		// 																																				LocalizedValue: to.Ptr("LUN"),
		// 																																				Value: to.Ptr("LUN"),
		// 																																			},
		// 																																			{
		// 																																				LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																				Value: to.Ptr("Microsoft.ResourceId"),
		// 																																			},
		// 																																			{
		// 																																				LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																				Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																		}},
		// 																																		DisplayDescription: to.Ptr("Maximum bytes per second throughput OS Disk can achieve with bursting"),
		// 																																		ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Max Burst Bandwidth"),
		// 																																		IsDimensionRequired: to.Ptr(false),
		// 																																		MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT1M"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT5M"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT15M"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT30M"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT1H"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT6H"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("PT12H"),
		// 																																			},
		// 																																			{
		// 																																				Retention: to.Ptr("P93D"),
		// 																																				TimeGrain: to.Ptr("P1D"),
		// 																																		}},
		// 																																		Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																		PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																		ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																		SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																			to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																			to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																			to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																			to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																			to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																			to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																			Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																																		},
		// 																																		{
		// 																																			Name: &armmonitor.LocalizableString{
		// 																																				LocalizedValue: to.Ptr("OS Disk Max Burst IOPS"),
		// 																																				Value: to.Ptr("OS Disk Max Burst IOPS"),
		// 																																			},
		// 																																			Dimensions: []*armmonitor.LocalizableString{
		// 																																				{
		// 																																					LocalizedValue: to.Ptr("LUN"),
		// 																																					Value: to.Ptr("LUN"),
		// 																																				},
		// 																																				{
		// 																																					LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																					Value: to.Ptr("Microsoft.ResourceId"),
		// 																																				},
		// 																																				{
		// 																																					LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																					Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																			}},
		// 																																			DisplayDescription: to.Ptr("Maximum IOPS OS Disk can achieve with bursting"),
		// 																																			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Max Burst IOPS"),
		// 																																			IsDimensionRequired: to.Ptr(false),
		// 																																			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT1M"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT5M"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT15M"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT30M"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT1H"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT6H"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("PT12H"),
		// 																																				},
		// 																																				{
		// 																																					Retention: to.Ptr("P93D"),
		// 																																					TimeGrain: to.Ptr("P1D"),
		// 																																			}},
		// 																																			Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																			PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																			ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																			SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																				to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																				to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																				to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																				to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																				to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																				to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																				Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																																			},
		// 																																			{
		// 																																				Name: &armmonitor.LocalizableString{
		// 																																					LocalizedValue: to.Ptr("OS Disk Used Burst BPS Credits Percentage"),
		// 																																					Value: to.Ptr("OS Disk Used Burst BPS Credits Percentage"),
		// 																																				},
		// 																																				Dimensions: []*armmonitor.LocalizableString{
		// 																																					{
		// 																																						LocalizedValue: to.Ptr("LUN"),
		// 																																						Value: to.Ptr("LUN"),
		// 																																					},
		// 																																					{
		// 																																						LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																						Value: to.Ptr("Microsoft.ResourceId"),
		// 																																					},
		// 																																					{
		// 																																						LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																						Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																				}},
		// 																																				DisplayDescription: to.Ptr("Percentage of OS Disk burst bandwidth credits used so far"),
		// 																																				ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Used Burst BPS Credits Percentage"),
		// 																																				IsDimensionRequired: to.Ptr(false),
		// 																																				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT1M"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT5M"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT15M"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT30M"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT1H"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT6H"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("PT12H"),
		// 																																					},
		// 																																					{
		// 																																						Retention: to.Ptr("P93D"),
		// 																																						TimeGrain: to.Ptr("P1D"),
		// 																																				}},
		// 																																				Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																				PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																				ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																				SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																					to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																					to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																					to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																					to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																					to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																					to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																					Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																				},
		// 																																				{
		// 																																					Name: &armmonitor.LocalizableString{
		// 																																						LocalizedValue: to.Ptr("OS Disk Used Burst IO Credits Percentage"),
		// 																																						Value: to.Ptr("OS Disk Used Burst IO Credits Percentage"),
		// 																																					},
		// 																																					Dimensions: []*armmonitor.LocalizableString{
		// 																																						{
		// 																																							LocalizedValue: to.Ptr("LUN"),
		// 																																							Value: to.Ptr("LUN"),
		// 																																						},
		// 																																						{
		// 																																							LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																							Value: to.Ptr("Microsoft.ResourceId"),
		// 																																						},
		// 																																						{
		// 																																							LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																							Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																					}},
		// 																																					DisplayDescription: to.Ptr("Percentage of OS Disk burst I/O credits used so far"),
		// 																																					ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/OS Disk Used Burst IO Credits Percentage"),
		// 																																					IsDimensionRequired: to.Ptr(false),
		// 																																					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT1M"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT5M"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT15M"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT30M"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT1H"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT6H"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("PT12H"),
		// 																																						},
		// 																																						{
		// 																																							Retention: to.Ptr("P93D"),
		// 																																							TimeGrain: to.Ptr("P1D"),
		// 																																					}},
		// 																																					Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																					PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																					ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																					SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																						to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																						to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																						to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																						to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																						to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																						to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																						Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																					},
		// 																																					{
		// 																																						Name: &armmonitor.LocalizableString{
		// 																																							LocalizedValue: to.Ptr("Inbound Flows"),
		// 																																							Value: to.Ptr("Inbound Flows"),
		// 																																						},
		// 																																						Dimensions: []*armmonitor.LocalizableString{
		// 																																							{
		// 																																								LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																								Value: to.Ptr("Microsoft.ResourceId"),
		// 																																							},
		// 																																							{
		// 																																								LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																								Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																						}},
		// 																																						DisplayDescription: to.Ptr("Inbound Flows are number of current flows in the inbound direction (traffic going into the VM)"),
		// 																																						ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Inbound Flows"),
		// 																																						IsDimensionRequired: to.Ptr(false),
		// 																																						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT1M"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT5M"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT15M"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT30M"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT1H"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT6H"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("PT12H"),
		// 																																							},
		// 																																							{
		// 																																								Retention: to.Ptr("P93D"),
		// 																																								TimeGrain: to.Ptr("P1D"),
		// 																																						}},
		// 																																						Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																						PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																						ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																						SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																							to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																							to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																							to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																							to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																							to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																							to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																							Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																																						},
		// 																																						{
		// 																																							Name: &armmonitor.LocalizableString{
		// 																																								LocalizedValue: to.Ptr("Outbound Flows"),
		// 																																								Value: to.Ptr("Outbound Flows"),
		// 																																							},
		// 																																							Dimensions: []*armmonitor.LocalizableString{
		// 																																								{
		// 																																									LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																									Value: to.Ptr("Microsoft.ResourceId"),
		// 																																								},
		// 																																								{
		// 																																									LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																									Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																							}},
		// 																																							DisplayDescription: to.Ptr("Outbound Flows are number of current flows in the outbound direction (traffic going out of the VM)"),
		// 																																							ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Outbound Flows"),
		// 																																							IsDimensionRequired: to.Ptr(false),
		// 																																							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT1M"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT5M"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT15M"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT30M"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT1H"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT6H"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("PT12H"),
		// 																																								},
		// 																																								{
		// 																																									Retention: to.Ptr("P93D"),
		// 																																									TimeGrain: to.Ptr("P1D"),
		// 																																							}},
		// 																																							Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																							PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																							ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																							SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																								to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																								to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																								to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																								to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																								to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																								to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																								Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																																							},
		// 																																							{
		// 																																								Name: &armmonitor.LocalizableString{
		// 																																									LocalizedValue: to.Ptr("Inbound Flows Maximum Creation Rate"),
		// 																																									Value: to.Ptr("Inbound Flows Maximum Creation Rate"),
		// 																																								},
		// 																																								Dimensions: []*armmonitor.LocalizableString{
		// 																																									{
		// 																																										LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																										Value: to.Ptr("Microsoft.ResourceId"),
		// 																																									},
		// 																																									{
		// 																																										LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																										Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																								}},
		// 																																								DisplayDescription: to.Ptr("The maximum creation rate of inbound flows (traffic going into the VM)"),
		// 																																								ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Inbound Flows Maximum Creation Rate"),
		// 																																								IsDimensionRequired: to.Ptr(false),
		// 																																								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT1M"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT5M"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT15M"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT30M"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT1H"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT6H"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("PT12H"),
		// 																																									},
		// 																																									{
		// 																																										Retention: to.Ptr("P93D"),
		// 																																										TimeGrain: to.Ptr("P1D"),
		// 																																								}},
		// 																																								Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																								PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																								ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																								SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																									to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																									to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																									to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																									to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																									to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																									to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																									Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																																								},
		// 																																								{
		// 																																									Name: &armmonitor.LocalizableString{
		// 																																										LocalizedValue: to.Ptr("Outbound Flows Maximum Creation Rate"),
		// 																																										Value: to.Ptr("Outbound Flows Maximum Creation Rate"),
		// 																																									},
		// 																																									Dimensions: []*armmonitor.LocalizableString{
		// 																																										{
		// 																																											LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																											Value: to.Ptr("Microsoft.ResourceId"),
		// 																																										},
		// 																																										{
		// 																																											LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																											Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																									}},
		// 																																									DisplayDescription: to.Ptr("The maximum creation rate of outbound flows (traffic going out of the VM)"),
		// 																																									ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Outbound Flows Maximum Creation Rate"),
		// 																																									IsDimensionRequired: to.Ptr(false),
		// 																																									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT1M"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT5M"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT15M"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT30M"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT1H"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT6H"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("PT12H"),
		// 																																										},
		// 																																										{
		// 																																											Retention: to.Ptr("P93D"),
		// 																																											TimeGrain: to.Ptr("P1D"),
		// 																																									}},
		// 																																									Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																									PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																									ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																									SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																										to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																										to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																										to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																										to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																										to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																										to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																										Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																																									},
		// 																																									{
		// 																																										Name: &armmonitor.LocalizableString{
		// 																																											LocalizedValue: to.Ptr("Premium Data Disk Cache Read Hit"),
		// 																																											Value: to.Ptr("Premium Data Disk Cache Read Hit"),
		// 																																										},
		// 																																										Dimensions: []*armmonitor.LocalizableString{
		// 																																											{
		// 																																												LocalizedValue: to.Ptr("LUN"),
		// 																																												Value: to.Ptr("LUN"),
		// 																																											},
		// 																																											{
		// 																																												LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																												Value: to.Ptr("Microsoft.ResourceId"),
		// 																																											},
		// 																																											{
		// 																																												LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																												Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																										}},
		// 																																										DisplayDescription: to.Ptr("Premium Data Disk Cache Read Hit"),
		// 																																										ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Premium Data Disk Cache Read Hit"),
		// 																																										IsDimensionRequired: to.Ptr(false),
		// 																																										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT1M"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT5M"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT15M"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT30M"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT1H"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT6H"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("PT12H"),
		// 																																											},
		// 																																											{
		// 																																												Retention: to.Ptr("P93D"),
		// 																																												TimeGrain: to.Ptr("P1D"),
		// 																																										}},
		// 																																										Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																										PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																										ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																										SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																											to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																											to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																											to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																											to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																											to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																											to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																											Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																										},
		// 																																										{
		// 																																											Name: &armmonitor.LocalizableString{
		// 																																												LocalizedValue: to.Ptr("Premium Data Disk Cache Read Miss"),
		// 																																												Value: to.Ptr("Premium Data Disk Cache Read Miss"),
		// 																																											},
		// 																																											Dimensions: []*armmonitor.LocalizableString{
		// 																																												{
		// 																																													LocalizedValue: to.Ptr("LUN"),
		// 																																													Value: to.Ptr("LUN"),
		// 																																												},
		// 																																												{
		// 																																													LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																													Value: to.Ptr("Microsoft.ResourceId"),
		// 																																												},
		// 																																												{
		// 																																													LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																													Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																											}},
		// 																																											DisplayDescription: to.Ptr("Premium Data Disk Cache Read Miss"),
		// 																																											ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Premium Data Disk Cache Read Miss"),
		// 																																											IsDimensionRequired: to.Ptr(false),
		// 																																											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT1M"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT5M"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT15M"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT30M"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT1H"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT6H"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("PT12H"),
		// 																																												},
		// 																																												{
		// 																																													Retention: to.Ptr("P93D"),
		// 																																													TimeGrain: to.Ptr("P1D"),
		// 																																											}},
		// 																																											Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																											PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																											ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																											SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																												to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																												to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																												to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																												to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																												to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																												to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																												Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																											},
		// 																																											{
		// 																																												Name: &armmonitor.LocalizableString{
		// 																																													LocalizedValue: to.Ptr("Premium OS Disk Cache Read Hit"),
		// 																																													Value: to.Ptr("Premium OS Disk Cache Read Hit"),
		// 																																												},
		// 																																												Dimensions: []*armmonitor.LocalizableString{
		// 																																													{
		// 																																														LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																														Value: to.Ptr("Microsoft.ResourceId"),
		// 																																													},
		// 																																													{
		// 																																														LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																														Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																												}},
		// 																																												DisplayDescription: to.Ptr("Premium OS Disk Cache Read Hit"),
		// 																																												ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Premium OS Disk Cache Read Hit"),
		// 																																												IsDimensionRequired: to.Ptr(false),
		// 																																												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT1M"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT5M"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT15M"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT30M"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT1H"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT6H"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("PT12H"),
		// 																																													},
		// 																																													{
		// 																																														Retention: to.Ptr("P93D"),
		// 																																														TimeGrain: to.Ptr("P1D"),
		// 																																												}},
		// 																																												Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																												PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																												ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																												SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																													to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																													to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																													to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																													to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																													to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																													to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																													Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																												},
		// 																																												{
		// 																																													Name: &armmonitor.LocalizableString{
		// 																																														LocalizedValue: to.Ptr("Premium OS Disk Cache Read Miss"),
		// 																																														Value: to.Ptr("Premium OS Disk Cache Read Miss"),
		// 																																													},
		// 																																													Dimensions: []*armmonitor.LocalizableString{
		// 																																														{
		// 																																															LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																															Value: to.Ptr("Microsoft.ResourceId"),
		// 																																														},
		// 																																														{
		// 																																															LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																															Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																													}},
		// 																																													DisplayDescription: to.Ptr("Premium OS Disk Cache Read Miss"),
		// 																																													ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Premium OS Disk Cache Read Miss"),
		// 																																													IsDimensionRequired: to.Ptr(false),
		// 																																													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT1M"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT5M"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT15M"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT30M"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT1H"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT6H"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("PT12H"),
		// 																																														},
		// 																																														{
		// 																																															Retention: to.Ptr("P93D"),
		// 																																															TimeGrain: to.Ptr("P1D"),
		// 																																													}},
		// 																																													Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																													PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																													ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																													SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																														to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																														to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																														to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																														to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																														to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																														to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																														Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																													},
		// 																																													{
		// 																																														Name: &armmonitor.LocalizableString{
		// 																																															LocalizedValue: to.Ptr("VM Cached Bandwidth Consumed Percentage"),
		// 																																															Value: to.Ptr("VM Cached Bandwidth Consumed Percentage"),
		// 																																														},
		// 																																														Dimensions: []*armmonitor.LocalizableString{
		// 																																															{
		// 																																																LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																																Value: to.Ptr("Microsoft.ResourceId"),
		// 																																															},
		// 																																															{
		// 																																																LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																														}},
		// 																																														DisplayDescription: to.Ptr("Percentage of cached disk bandwidth consumed by the VM"),
		// 																																														ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/VM Cached Bandwidth Consumed Percentage"),
		// 																																														IsDimensionRequired: to.Ptr(false),
		// 																																														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT1M"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT5M"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT15M"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT30M"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT1H"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT6H"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("PT12H"),
		// 																																															},
		// 																																															{
		// 																																																Retention: to.Ptr("P93D"),
		// 																																																TimeGrain: to.Ptr("P1D"),
		// 																																														}},
		// 																																														Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																														PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																														ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																														SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																															to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																															to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																															to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																															to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																															to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																															to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																															Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																														},
		// 																																														{
		// 																																															Name: &armmonitor.LocalizableString{
		// 																																																LocalizedValue: to.Ptr("VM Cached IOPS Consumed Percentage"),
		// 																																																Value: to.Ptr("VM Cached IOPS Consumed Percentage"),
		// 																																															},
		// 																																															Dimensions: []*armmonitor.LocalizableString{
		// 																																																{
		// 																																																	LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																																	Value: to.Ptr("Microsoft.ResourceId"),
		// 																																																},
		// 																																																{
		// 																																																	LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																	Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																															}},
		// 																																															DisplayDescription: to.Ptr("Percentage of cached disk IOPS consumed by the VM"),
		// 																																															ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/VM Cached IOPS Consumed Percentage"),
		// 																																															IsDimensionRequired: to.Ptr(false),
		// 																																															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT1M"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT5M"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT15M"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT30M"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT1H"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT6H"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("PT12H"),
		// 																																																},
		// 																																																{
		// 																																																	Retention: to.Ptr("P93D"),
		// 																																																	TimeGrain: to.Ptr("P1D"),
		// 																																															}},
		// 																																															Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																															PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																															ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																															SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																																to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																																to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																																to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																																to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																																Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																															},
		// 																																															{
		// 																																																Name: &armmonitor.LocalizableString{
		// 																																																	LocalizedValue: to.Ptr("VM Uncached Bandwidth Consumed Percentage"),
		// 																																																	Value: to.Ptr("VM Uncached Bandwidth Consumed Percentage"),
		// 																																																},
		// 																																																Dimensions: []*armmonitor.LocalizableString{
		// 																																																	{
		// 																																																		LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																																		Value: to.Ptr("Microsoft.ResourceId"),
		// 																																																	},
		// 																																																	{
		// 																																																		LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																		Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																}},
		// 																																																DisplayDescription: to.Ptr("Percentage of uncached disk bandwidth consumed by the VM"),
		// 																																																ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/VM Uncached Bandwidth Consumed Percentage"),
		// 																																																IsDimensionRequired: to.Ptr(false),
		// 																																																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT1M"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT5M"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT15M"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT30M"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT1H"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT6H"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("PT12H"),
		// 																																																	},
		// 																																																	{
		// 																																																		Retention: to.Ptr("P93D"),
		// 																																																		TimeGrain: to.Ptr("P1D"),
		// 																																																}},
		// 																																																Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																																PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																																SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																																	to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																																	to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																	to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																																	to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																																	to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																	to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																																	Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																																},
		// 																																																{
		// 																																																	Name: &armmonitor.LocalizableString{
		// 																																																		LocalizedValue: to.Ptr("VM Uncached IOPS Consumed Percentage"),
		// 																																																		Value: to.Ptr("VM Uncached IOPS Consumed Percentage"),
		// 																																																	},
		// 																																																	Dimensions: []*armmonitor.LocalizableString{
		// 																																																		{
		// 																																																			LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																																			Value: to.Ptr("Microsoft.ResourceId"),
		// 																																																		},
		// 																																																		{
		// 																																																			LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																			Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																	}},
		// 																																																	DisplayDescription: to.Ptr("Percentage of uncached disk IOPS consumed by the VM"),
		// 																																																	ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/VM Uncached IOPS Consumed Percentage"),
		// 																																																	IsDimensionRequired: to.Ptr(false),
		// 																																																	MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT1M"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT5M"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT15M"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT30M"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT1H"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT6H"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("PT12H"),
		// 																																																		},
		// 																																																		{
		// 																																																			Retention: to.Ptr("P93D"),
		// 																																																			TimeGrain: to.Ptr("P1D"),
		// 																																																	}},
		// 																																																	Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																																	PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																	ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																																	SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																																		to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																																		to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																		to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																																		to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																																		to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																		to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																																		Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																																																	},
		// 																																																	{
		// 																																																		Name: &armmonitor.LocalizableString{
		// 																																																			LocalizedValue: to.Ptr("Network In Total"),
		// 																																																			Value: to.Ptr("Network In Total"),
		// 																																																		},
		// 																																																		Dimensions: []*armmonitor.LocalizableString{
		// 																																																			{
		// 																																																				LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																																				Value: to.Ptr("Microsoft.ResourceId"),
		// 																																																			},
		// 																																																			{
		// 																																																				LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																				Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																		}},
		// 																																																		DisplayDescription: to.Ptr("The number of bytes received on all network interfaces by the Virtual Machine(s) (Incoming Traffic)"),
		// 																																																		ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Network In Total"),
		// 																																																		IsDimensionRequired: to.Ptr(false),
		// 																																																		MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT1M"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT5M"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT15M"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT30M"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT1H"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT6H"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("PT12H"),
		// 																																																			},
		// 																																																			{
		// 																																																				Retention: to.Ptr("P93D"),
		// 																																																				TimeGrain: to.Ptr("P1D"),
		// 																																																		}},
		// 																																																		Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																																		PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																		ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																																		SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																																			to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																																			to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																			to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																																			to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																																			to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																			to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																																			Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 																																																		},
		// 																																																		{
		// 																																																			Name: &armmonitor.LocalizableString{
		// 																																																				LocalizedValue: to.Ptr("Network Out Total"),
		// 																																																				Value: to.Ptr("Network Out Total"),
		// 																																																			},
		// 																																																			Dimensions: []*armmonitor.LocalizableString{
		// 																																																				{
		// 																																																					LocalizedValue: to.Ptr("Microsoft.ResourceId"),
		// 																																																					Value: to.Ptr("Microsoft.ResourceId"),
		// 																																																				},
		// 																																																				{
		// 																																																					LocalizedValue: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																					Value: to.Ptr("Microsoft.ResourceGroupName"),
		// 																																																			}},
		// 																																																			DisplayDescription: to.Ptr("The number of bytes out on all network interfaces by the Virtual Machine(s) (Outgoing Traffic)"),
		// 																																																			ID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5/providers/microsoft.insights/metricdefinitions/Network Out Total"),
		// 																																																			IsDimensionRequired: to.Ptr(false),
		// 																																																			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT1M"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT5M"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT15M"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT30M"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT1H"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT6H"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("PT12H"),
		// 																																																				},
		// 																																																				{
		// 																																																					Retention: to.Ptr("P93D"),
		// 																																																					TimeGrain: to.Ptr("P1D"),
		// 																																																			}},
		// 																																																			Namespace: to.Ptr("microsoft.compute/virtualmachines"),
		// 																																																			PrimaryAggregationType: to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																			ResourceID: to.Ptr("subscriptions/92d2a2d8-b514-432d-8cc9-a5f9272630d5"),
		// 																																																			SupportedAggregationTypes: []*armmonitor.MetricAggregationType{
		// 																																																				to.Ptr(armmonitor.MetricAggregationTypeNone),
		// 																																																				to.Ptr(armmonitor.MetricAggregationTypeAverage),
		// 																																																				to.Ptr(armmonitor.MetricAggregationTypeMinimum),
		// 																																																				to.Ptr(armmonitor.MetricAggregationTypeMaximum),
		// 																																																				to.Ptr(armmonitor.MetricAggregationTypeTotal),
		// 																																																				to.Ptr(armmonitor.MetricAggregationTypeCount)},
		// 																																																				Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 																																																		}},
		// 																																																	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMetricDefinitionsApplicationInsights.json
func ExampleMetricDefinitionsClient_NewListPager_getApplicationInsightsMetricDefinitionsWithoutFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMetricDefinitionsClient().NewListPager("subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions", &armmonitor.MetricDefinitionsClientListOptions{Metricnamespace: to.Ptr("microsoft.insights/components")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionCollection = armmonitor.MetricDefinitionCollection{
		// 	Value: []*armmonitor.MetricDefinition{
		// 		{
		// 			Name: &armmonitor.LocalizableString{
		// 				LocalizedValue: to.Ptr("Availability"),
		// 				Value: to.Ptr("availabilityResults/availabilityPercentage"),
		// 			},
		// 			Category: to.Ptr("Availability"),
		// 			Dimensions: []*armmonitor.LocalizableString{
		// 				{
		// 					LocalizedValue: to.Ptr("Test name"),
		// 					Value: to.Ptr("availabilityResult/name"),
		// 				},
		// 				{
		// 					LocalizedValue: to.Ptr("Run location"),
		// 					Value: to.Ptr("availabilityResult/location"),
		// 			}},
		// 			DisplayDescription: to.Ptr("Percentage of successfully completed availability tests"),
		// 			ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/availabilityResults/availabilityPercentage"),
		// 			IsDimensionRequired: to.Ptr(false),
		// 			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT5M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT15M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT30M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT6H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT12H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			Namespace: to.Ptr("microsoft.insights/components"),
		// 			PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 			SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 				to.Ptr(armmonitor.AggregationTypeAverage)},
		// 				Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 			},
		// 			{
		// 				Name: &armmonitor.LocalizableString{
		// 					LocalizedValue: to.Ptr("Availability tests"),
		// 					Value: to.Ptr("availabilityResults/count"),
		// 				},
		// 				Category: to.Ptr("Availability"),
		// 				Dimensions: []*armmonitor.LocalizableString{
		// 					{
		// 						LocalizedValue: to.Ptr("Test name"),
		// 						Value: to.Ptr("availabilityResult/name"),
		// 					},
		// 					{
		// 						LocalizedValue: to.Ptr("Run location"),
		// 						Value: to.Ptr("availabilityResult/location"),
		// 					},
		// 					{
		// 						LocalizedValue: to.Ptr("Test result"),
		// 						Value: to.Ptr("availabilityResult/success"),
		// 				}},
		// 				DisplayDescription: to.Ptr("Count of availability tests"),
		// 				ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/availabilityResults/count"),
		// 				IsDimensionRequired: to.Ptr(false),
		// 				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT5M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT15M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT30M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT6H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT12H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("P1D"),
		// 				}},
		// 				Namespace: to.Ptr("microsoft.insights/components"),
		// 				PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 				ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 				SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 					to.Ptr(armmonitor.AggregationTypeCount)},
		// 					Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 				},
		// 				{
		// 					Name: &armmonitor.LocalizableString{
		// 						LocalizedValue: to.Ptr("Availability test duration"),
		// 						Value: to.Ptr("availabilityResults/duration"),
		// 					},
		// 					Category: to.Ptr("Availability"),
		// 					Dimensions: []*armmonitor.LocalizableString{
		// 						{
		// 							LocalizedValue: to.Ptr("Test name"),
		// 							Value: to.Ptr("availabilityResult/name"),
		// 						},
		// 						{
		// 							LocalizedValue: to.Ptr("Run location"),
		// 							Value: to.Ptr("availabilityResult/location"),
		// 						},
		// 						{
		// 							LocalizedValue: to.Ptr("Test result"),
		// 							Value: to.Ptr("availabilityResult/success"),
		// 					}},
		// 					DisplayDescription: to.Ptr("Availability test duration"),
		// 					ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/availabilityResults/duration"),
		// 					IsDimensionRequired: to.Ptr(false),
		// 					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT5M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT15M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT30M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT6H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT12H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("P1D"),
		// 					}},
		// 					Namespace: to.Ptr("microsoft.insights/components"),
		// 					PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 					ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 					SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 						to.Ptr(armmonitor.AggregationTypeAverage),
		// 						to.Ptr(armmonitor.AggregationTypeMaximum),
		// 						to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 						Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 					},
		// 					{
		// 						Name: &armmonitor.LocalizableString{
		// 							LocalizedValue: to.Ptr("Page load network connect time"),
		// 							Value: to.Ptr("browserTimings/networkDuration"),
		// 						},
		// 						Category: to.Ptr("Browser"),
		// 						DisplayDescription: to.Ptr("Time between user request and network connection. Includes DNS lookup and transport connection."),
		// 						ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/browserTimings/networkDuration"),
		// 						IsDimensionRequired: to.Ptr(false),
		// 						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT5M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT15M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT30M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT6H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT12H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("P1D"),
		// 						}},
		// 						Namespace: to.Ptr("microsoft.insights/components"),
		// 						PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 						ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 						SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 							to.Ptr(armmonitor.AggregationTypeAverage),
		// 							to.Ptr(armmonitor.AggregationTypeMaximum),
		// 							to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 							Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 						},
		// 						{
		// 							Name: &armmonitor.LocalizableString{
		// 								LocalizedValue: to.Ptr("Client processing time"),
		// 								Value: to.Ptr("browserTimings/processingDuration"),
		// 							},
		// 							Category: to.Ptr("Browser"),
		// 							DisplayDescription: to.Ptr("Time between receiving the last byte of a document until the DOM is loaded. Async requests may still be processing."),
		// 							ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/browserTimings/processingDuration"),
		// 							IsDimensionRequired: to.Ptr(false),
		// 							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT5M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT15M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT30M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT6H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT12H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Namespace: to.Ptr("microsoft.insights/components"),
		// 							PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 							ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 							SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 								to.Ptr(armmonitor.AggregationTypeAverage),
		// 								to.Ptr(armmonitor.AggregationTypeMaximum),
		// 								to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 								Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 							},
		// 							{
		// 								Name: &armmonitor.LocalizableString{
		// 									LocalizedValue: to.Ptr("Receiving response time"),
		// 									Value: to.Ptr("browserTimings/receiveDuration"),
		// 								},
		// 								Category: to.Ptr("Browser"),
		// 								DisplayDescription: to.Ptr("Time between the first and last bytes, or until disconnection."),
		// 								ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/browserTimings/receiveDuration"),
		// 								IsDimensionRequired: to.Ptr(false),
		// 								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT5M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT15M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT30M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT6H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT12H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("P1D"),
		// 								}},
		// 								Namespace: to.Ptr("microsoft.insights/components"),
		// 								PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 								ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 								SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 									to.Ptr(armmonitor.AggregationTypeAverage),
		// 									to.Ptr(armmonitor.AggregationTypeMaximum),
		// 									to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 									Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 								},
		// 								{
		// 									Name: &armmonitor.LocalizableString{
		// 										LocalizedValue: to.Ptr("Send request time"),
		// 										Value: to.Ptr("browserTimings/sendDuration"),
		// 									},
		// 									Category: to.Ptr("Browser"),
		// 									DisplayDescription: to.Ptr("Time between network connection and receiving the first byte."),
		// 									ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/browserTimings/sendDuration"),
		// 									IsDimensionRequired: to.Ptr(false),
		// 									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT5M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT15M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT30M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT6H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT12H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("P1D"),
		// 									}},
		// 									Namespace: to.Ptr("microsoft.insights/components"),
		// 									PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 									ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 									SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 										to.Ptr(armmonitor.AggregationTypeAverage),
		// 										to.Ptr(armmonitor.AggregationTypeMaximum),
		// 										to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 										Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 									},
		// 									{
		// 										Name: &armmonitor.LocalizableString{
		// 											LocalizedValue: to.Ptr("Browser page load time"),
		// 											Value: to.Ptr("browserTimings/totalDuration"),
		// 										},
		// 										Category: to.Ptr("Browser"),
		// 										DisplayDescription: to.Ptr("Time from user request until DOM, stylesheets, scripts and images are loaded."),
		// 										ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/browserTimings/totalDuration"),
		// 										IsDimensionRequired: to.Ptr(false),
		// 										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT5M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT15M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT30M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT6H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT12H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("P1D"),
		// 										}},
		// 										Namespace: to.Ptr("microsoft.insights/components"),
		// 										PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 										ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 										SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 											to.Ptr(armmonitor.AggregationTypeAverage),
		// 											to.Ptr(armmonitor.AggregationTypeMaximum),
		// 											to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 											Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 										},
		// 										{
		// 											Name: &armmonitor.LocalizableString{
		// 												LocalizedValue: to.Ptr("Dependency calls"),
		// 												Value: to.Ptr("dependencies/count"),
		// 											},
		// 											Category: to.Ptr("Server"),
		// 											Dimensions: []*armmonitor.LocalizableString{
		// 												{
		// 													LocalizedValue: to.Ptr("Dependency type"),
		// 													Value: to.Ptr("dependency/type"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Dependency performance"),
		// 													Value: to.Ptr("dependency/performanceBucket"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Successful call"),
		// 													Value: to.Ptr("dependency/success"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Target of a dependency call"),
		// 													Value: to.Ptr("dependency/target"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Result code"),
		// 													Value: to.Ptr("dependency/resultCode"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 													Value: to.Ptr("operation/synthetic"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Cloud role instance"),
		// 													Value: to.Ptr("cloud/roleInstance"),
		// 												},
		// 												{
		// 													LocalizedValue: to.Ptr("Cloud role name"),
		// 													Value: to.Ptr("cloud/roleName"),
		// 											}},
		// 											DisplayDescription: to.Ptr("Count of calls made by the application to external resources."),
		// 											ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/dependencies/count"),
		// 											IsDimensionRequired: to.Ptr(false),
		// 											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT5M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT15M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT30M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT6H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT12H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("P1D"),
		// 											}},
		// 											Namespace: to.Ptr("microsoft.insights/components"),
		// 											PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 											ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 											SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 												to.Ptr(armmonitor.AggregationTypeCount)},
		// 												Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 											},
		// 											{
		// 												Name: &armmonitor.LocalizableString{
		// 													LocalizedValue: to.Ptr("Dependency duration"),
		// 													Value: to.Ptr("dependencies/duration"),
		// 												},
		// 												Category: to.Ptr("Server"),
		// 												Dimensions: []*armmonitor.LocalizableString{
		// 													{
		// 														LocalizedValue: to.Ptr("Dependency type"),
		// 														Value: to.Ptr("dependency/type"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Dependency performance"),
		// 														Value: to.Ptr("dependency/performanceBucket"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Successful call"),
		// 														Value: to.Ptr("dependency/success"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Target of a dependency call"),
		// 														Value: to.Ptr("dependency/target"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Result code"),
		// 														Value: to.Ptr("dependency/resultCode"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 														Value: to.Ptr("operation/synthetic"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Cloud role instance"),
		// 														Value: to.Ptr("cloud/roleInstance"),
		// 													},
		// 													{
		// 														LocalizedValue: to.Ptr("Cloud role name"),
		// 														Value: to.Ptr("cloud/roleName"),
		// 												}},
		// 												DisplayDescription: to.Ptr("Duration of calls made by the application to external resources."),
		// 												ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/dependencies/duration"),
		// 												IsDimensionRequired: to.Ptr(false),
		// 												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT5M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT15M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT30M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT6H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT12H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("P1D"),
		// 												}},
		// 												Namespace: to.Ptr("microsoft.insights/components"),
		// 												PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 												ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 												SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 													to.Ptr(armmonitor.AggregationTypeAverage),
		// 													to.Ptr(armmonitor.AggregationTypeMaximum),
		// 													to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 													Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 												},
		// 												{
		// 													Name: &armmonitor.LocalizableString{
		// 														LocalizedValue: to.Ptr("Dependency call failures"),
		// 														Value: to.Ptr("dependencies/failed"),
		// 													},
		// 													Category: to.Ptr("Failures"),
		// 													Dimensions: []*armmonitor.LocalizableString{
		// 														{
		// 															LocalizedValue: to.Ptr("Dependency type"),
		// 															Value: to.Ptr("dependency/type"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Dependency performance"),
		// 															Value: to.Ptr("dependency/performanceBucket"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Target of a dependency call"),
		// 															Value: to.Ptr("dependency/target"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Result code"),
		// 															Value: to.Ptr("dependency/resultCode"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 															Value: to.Ptr("operation/synthetic"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Cloud role instance"),
		// 															Value: to.Ptr("cloud/roleInstance"),
		// 														},
		// 														{
		// 															LocalizedValue: to.Ptr("Cloud role name"),
		// 															Value: to.Ptr("cloud/roleName"),
		// 													}},
		// 													DisplayDescription: to.Ptr("Count of failed dependency calls made by the application to external resources."),
		// 													ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/dependencies/failed"),
		// 													IsDimensionRequired: to.Ptr(false),
		// 													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT5M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT15M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT30M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT6H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT12H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("P1D"),
		// 													}},
		// 													Namespace: to.Ptr("microsoft.insights/components"),
		// 													PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 													ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 													SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 														to.Ptr(armmonitor.AggregationTypeCount)},
		// 														Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 													},
		// 													{
		// 														Name: &armmonitor.LocalizableString{
		// 															LocalizedValue: to.Ptr("Page views"),
		// 															Value: to.Ptr("pageViews/count"),
		// 														},
		// 														Category: to.Ptr("Usage"),
		// 														Dimensions: []*armmonitor.LocalizableString{
		// 															{
		// 																LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																Value: to.Ptr("operation/synthetic"),
		// 															},
		// 															{
		// 																LocalizedValue: to.Ptr("Cloud role name"),
		// 																Value: to.Ptr("cloud/roleName"),
		// 														}},
		// 														DisplayDescription: to.Ptr("Count of page views."),
		// 														ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/pageViews/count"),
		// 														IsDimensionRequired: to.Ptr(false),
		// 														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT5M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT15M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT30M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT6H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT12H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("P1D"),
		// 														}},
		// 														Namespace: to.Ptr("microsoft.insights/components"),
		// 														PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 														ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 														SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 															to.Ptr(armmonitor.AggregationTypeCount)},
		// 															Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 														},
		// 														{
		// 															Name: &armmonitor.LocalizableString{
		// 																LocalizedValue: to.Ptr("Page view load time"),
		// 																Value: to.Ptr("pageViews/duration"),
		// 															},
		// 															Category: to.Ptr("Usage"),
		// 															Dimensions: []*armmonitor.LocalizableString{
		// 																{
		// 																	LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																	Value: to.Ptr("operation/synthetic"),
		// 																},
		// 																{
		// 																	LocalizedValue: to.Ptr("Cloud role name"),
		// 																	Value: to.Ptr("cloud/roleName"),
		// 															}},
		// 															DisplayDescription: to.Ptr("Page view load time"),
		// 															ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/pageViews/duration"),
		// 															IsDimensionRequired: to.Ptr(false),
		// 															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT5M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT15M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT30M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT6H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT12H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("P1D"),
		// 															}},
		// 															Namespace: to.Ptr("microsoft.insights/components"),
		// 															PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 															ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 															SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																to.Ptr(armmonitor.AggregationTypeAverage),
		// 																to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 															},
		// 															{
		// 																Name: &armmonitor.LocalizableString{
		// 																	LocalizedValue: to.Ptr("HTTP request execution time"),
		// 																	Value: to.Ptr("performanceCounters/requestExecutionTime"),
		// 																},
		// 																Category: to.Ptr("Performance counters"),
		// 																Dimensions: []*armmonitor.LocalizableString{
		// 																	{
		// 																		LocalizedValue: to.Ptr("Cloud role instance"),
		// 																		Value: to.Ptr("cloud/roleInstance"),
		// 																}},
		// 																DisplayDescription: to.Ptr("Execution time of the most recent request."),
		// 																ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/requestExecutionTime"),
		// 																IsDimensionRequired: to.Ptr(false),
		// 																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT5M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT15M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT30M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT6H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT12H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("P1D"),
		// 																}},
		// 																Namespace: to.Ptr("microsoft.insights/components"),
		// 																PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																	to.Ptr(armmonitor.AggregationTypeAverage),
		// 																	to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																	to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																	Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 																},
		// 																{
		// 																	Name: &armmonitor.LocalizableString{
		// 																		LocalizedValue: to.Ptr("HTTP requests in application queue"),
		// 																		Value: to.Ptr("performanceCounters/requestsInQueue"),
		// 																	},
		// 																	Category: to.Ptr("Performance counters"),
		// 																	Dimensions: []*armmonitor.LocalizableString{
		// 																		{
		// 																			LocalizedValue: to.Ptr("Cloud role instance"),
		// 																			Value: to.Ptr("cloud/roleInstance"),
		// 																	}},
		// 																	DisplayDescription: to.Ptr("Length of the application request queue."),
		// 																	ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/requestsInQueue"),
		// 																	IsDimensionRequired: to.Ptr(false),
		// 																	MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT5M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT15M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT30M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT6H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT12H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("P1D"),
		// 																	}},
		// 																	Namespace: to.Ptr("microsoft.insights/components"),
		// 																	PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																	ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																	SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																		to.Ptr(armmonitor.AggregationTypeAverage),
		// 																		to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																		to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																		Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																	},
		// 																	{
		// 																		Name: &armmonitor.LocalizableString{
		// 																			LocalizedValue: to.Ptr("HTTP request rate"),
		// 																			Value: to.Ptr("performanceCounters/requestsPerSecond"),
		// 																		},
		// 																		Category: to.Ptr("Performance counters"),
		// 																		Dimensions: []*armmonitor.LocalizableString{
		// 																			{
		// 																				LocalizedValue: to.Ptr("Cloud role instance"),
		// 																				Value: to.Ptr("cloud/roleInstance"),
		// 																		}},
		// 																		DisplayDescription: to.Ptr("Rate of all requests to the application per second from ASP.NET."),
		// 																		ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/requestsPerSecond"),
		// 																		IsDimensionRequired: to.Ptr(false),
		// 																		MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT5M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT15M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT30M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT6H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT12H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("P1D"),
		// 																		}},
		// 																		Namespace: to.Ptr("microsoft.insights/components"),
		// 																		PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																		ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																		SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																			to.Ptr(armmonitor.AggregationTypeAverage),
		// 																			to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																			to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																			Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																		},
		// 																		{
		// 																			Name: &armmonitor.LocalizableString{
		// 																				LocalizedValue: to.Ptr("Exception rate"),
		// 																				Value: to.Ptr("performanceCounters/exceptionsPerSecond"),
		// 																			},
		// 																			Category: to.Ptr("Performance counters"),
		// 																			Dimensions: []*armmonitor.LocalizableString{
		// 																				{
		// 																					LocalizedValue: to.Ptr("Cloud role instance"),
		// 																					Value: to.Ptr("cloud/roleInstance"),
		// 																			}},
		// 																			DisplayDescription: to.Ptr("Count of handled and unhandled exceptions reported to windows, including .NET exceptions and unmanaged exceptions that are converted into .NET exceptions."),
		// 																			ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/exceptionsPerSecond"),
		// 																			IsDimensionRequired: to.Ptr(false),
		// 																			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT1M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT5M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT15M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT30M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT1H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT6H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT12H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("P1D"),
		// 																			}},
		// 																			Namespace: to.Ptr("microsoft.insights/components"),
		// 																			PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																			ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																			SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																				to.Ptr(armmonitor.AggregationTypeAverage),
		// 																				to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																				to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																				Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																			},
		// 																			{
		// 																				Name: &armmonitor.LocalizableString{
		// 																					LocalizedValue: to.Ptr("Process IO rate"),
		// 																					Value: to.Ptr("performanceCounters/processIOBytesPerSecond"),
		// 																				},
		// 																				Category: to.Ptr("Performance counters"),
		// 																				Dimensions: []*armmonitor.LocalizableString{
		// 																					{
		// 																						LocalizedValue: to.Ptr("Cloud role instance"),
		// 																						Value: to.Ptr("cloud/roleInstance"),
		// 																				}},
		// 																				DisplayDescription: to.Ptr("Total bytes per second read and written to files, network and devices."),
		// 																				ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/processIOBytesPerSecond"),
		// 																				IsDimensionRequired: to.Ptr(false),
		// 																				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT1M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT5M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT15M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT30M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT1H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT6H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT12H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("P1D"),
		// 																				}},
		// 																				Namespace: to.Ptr("microsoft.insights/components"),
		// 																				PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																				ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																				SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																					to.Ptr(armmonitor.AggregationTypeAverage),
		// 																					to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																					to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																					Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																				},
		// 																				{
		// 																					Name: &armmonitor.LocalizableString{
		// 																						LocalizedValue: to.Ptr("Process CPU"),
		// 																						Value: to.Ptr("performanceCounters/processCpuPercentage"),
		// 																					},
		// 																					Category: to.Ptr("Performance counters"),
		// 																					Dimensions: []*armmonitor.LocalizableString{
		// 																						{
		// 																							LocalizedValue: to.Ptr("Cloud role instance"),
		// 																							Value: to.Ptr("cloud/roleInstance"),
		// 																					}},
		// 																					DisplayDescription: to.Ptr("The percentage of elapsed time that all process threads used the processor to execute instructions. This can vary between 0 to 100. This metric indicates the performance of w3wp process alone."),
		// 																					ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/processCpuPercentage"),
		// 																					IsDimensionRequired: to.Ptr(false),
		// 																					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT1M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT5M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT15M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT30M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT1H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT6H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT12H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("P1D"),
		// 																					}},
		// 																					Namespace: to.Ptr("microsoft.insights/components"),
		// 																					PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																					ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																					SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																						to.Ptr(armmonitor.AggregationTypeAverage),
		// 																						to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																						to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																						Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																					},
		// 																					{
		// 																						Name: &armmonitor.LocalizableString{
		// 																							LocalizedValue: to.Ptr("Processor time"),
		// 																							Value: to.Ptr("performanceCounters/processorCpuPercentage"),
		// 																						},
		// 																						Category: to.Ptr("Performance counters"),
		// 																						Dimensions: []*armmonitor.LocalizableString{
		// 																							{
		// 																								LocalizedValue: to.Ptr("Cloud role instance"),
		// 																								Value: to.Ptr("cloud/roleInstance"),
		// 																						}},
		// 																						DisplayDescription: to.Ptr("The percentage of time that the processor spends in non-idle threads."),
		// 																						ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/processorCpuPercentage"),
		// 																						IsDimensionRequired: to.Ptr(false),
		// 																						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT1M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT5M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT15M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT30M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT1H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT6H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT12H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("P1D"),
		// 																						}},
		// 																						Namespace: to.Ptr("microsoft.insights/components"),
		// 																						PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																						ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																						SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																							to.Ptr(armmonitor.AggregationTypeAverage),
		// 																							to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																							to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																							Unit: to.Ptr(armmonitor.MetricUnitPercent),
		// 																						},
		// 																						{
		// 																							Name: &armmonitor.LocalizableString{
		// 																								LocalizedValue: to.Ptr("Available memory"),
		// 																								Value: to.Ptr("performanceCounters/memoryAvailableBytes"),
		// 																							},
		// 																							Category: to.Ptr("Performance counters"),
		// 																							Dimensions: []*armmonitor.LocalizableString{
		// 																								{
		// 																									LocalizedValue: to.Ptr("Cloud role instance"),
		// 																									Value: to.Ptr("cloud/roleInstance"),
		// 																							}},
		// 																							DisplayDescription: to.Ptr("Physical memory immediately available for allocation to a process or for system use."),
		// 																							ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/memoryAvailableBytes"),
		// 																							IsDimensionRequired: to.Ptr(false),
		// 																							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT1M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT5M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT15M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT30M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT1H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT6H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT12H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("P1D"),
		// 																							}},
		// 																							Namespace: to.Ptr("microsoft.insights/components"),
		// 																							PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																							ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																							SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																								to.Ptr(armmonitor.AggregationTypeAverage),
		// 																								to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																								to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																								Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 																							},
		// 																							{
		// 																								Name: &armmonitor.LocalizableString{
		// 																									LocalizedValue: to.Ptr("Process private bytes"),
		// 																									Value: to.Ptr("performanceCounters/processPrivateBytes"),
		// 																								},
		// 																								Category: to.Ptr("Performance counters"),
		// 																								Dimensions: []*armmonitor.LocalizableString{
		// 																									{
		// 																										LocalizedValue: to.Ptr("Cloud role instance"),
		// 																										Value: to.Ptr("cloud/roleInstance"),
		// 																								}},
		// 																								DisplayDescription: to.Ptr("Memory exclusively assigned to the monitored application's processes."),
		// 																								ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/performanceCounters/processPrivateBytes"),
		// 																								IsDimensionRequired: to.Ptr(false),
		// 																								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT1M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT5M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT15M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT30M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT1H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT6H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT12H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("P1D"),
		// 																								}},
		// 																								Namespace: to.Ptr("microsoft.insights/components"),
		// 																								PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																								ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																								SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																									to.Ptr(armmonitor.AggregationTypeAverage),
		// 																									to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																									to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																									Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 																								},
		// 																								{
		// 																									Name: &armmonitor.LocalizableString{
		// 																										LocalizedValue: to.Ptr("Server response time"),
		// 																										Value: to.Ptr("requests/duration"),
		// 																									},
		// 																									Category: to.Ptr("Server"),
		// 																									Dimensions: []*armmonitor.LocalizableString{
		// 																										{
		// 																											LocalizedValue: to.Ptr("Request performance"),
		// 																											Value: to.Ptr("request/performanceBucket"),
		// 																										},
		// 																										{
		// 																											LocalizedValue: to.Ptr("Result code"),
		// 																											Value: to.Ptr("request/resultCode"),
		// 																										},
		// 																										{
		// 																											LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																											Value: to.Ptr("operation/synthetic"),
		// 																										},
		// 																										{
		// 																											LocalizedValue: to.Ptr("Cloud role instance"),
		// 																											Value: to.Ptr("cloud/roleInstance"),
		// 																										},
		// 																										{
		// 																											LocalizedValue: to.Ptr("Successful request"),
		// 																											Value: to.Ptr("request/success"),
		// 																										},
		// 																										{
		// 																											LocalizedValue: to.Ptr("Cloud role name"),
		// 																											Value: to.Ptr("cloud/roleName"),
		// 																									}},
		// 																									DisplayDescription: to.Ptr("Time between receiving an HTTP request and finishing sending the response."),
		// 																									ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/requests/duration"),
		// 																									IsDimensionRequired: to.Ptr(false),
		// 																									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT1M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT5M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT15M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT30M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT1H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT6H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT12H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("P1D"),
		// 																									}},
		// 																									Namespace: to.Ptr("microsoft.insights/components"),
		// 																									PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																									ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																									SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																										to.Ptr(armmonitor.AggregationTypeAverage),
		// 																										to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																										to.Ptr(armmonitor.AggregationTypeMinimum)},
		// 																										Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 																									},
		// 																									{
		// 																										Name: &armmonitor.LocalizableString{
		// 																											LocalizedValue: to.Ptr("Server requests"),
		// 																											Value: to.Ptr("requests/count"),
		// 																										},
		// 																										Category: to.Ptr("Server"),
		// 																										Dimensions: []*armmonitor.LocalizableString{
		// 																											{
		// 																												LocalizedValue: to.Ptr("Request performance"),
		// 																												Value: to.Ptr("request/performanceBucket"),
		// 																											},
		// 																											{
		// 																												LocalizedValue: to.Ptr("Result code"),
		// 																												Value: to.Ptr("request/resultCode"),
		// 																											},
		// 																											{
		// 																												LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																												Value: to.Ptr("operation/synthetic"),
		// 																											},
		// 																											{
		// 																												LocalizedValue: to.Ptr("Cloud role instance"),
		// 																												Value: to.Ptr("cloud/roleInstance"),
		// 																											},
		// 																											{
		// 																												LocalizedValue: to.Ptr("Successful request"),
		// 																												Value: to.Ptr("request/success"),
		// 																											},
		// 																											{
		// 																												LocalizedValue: to.Ptr("Cloud role name"),
		// 																												Value: to.Ptr("cloud/roleName"),
		// 																										}},
		// 																										DisplayDescription: to.Ptr("Count of HTTP requests completed."),
		// 																										ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/requests/count"),
		// 																										IsDimensionRequired: to.Ptr(false),
		// 																										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT1M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT5M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT15M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT30M"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT1H"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT6H"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("PT12H"),
		// 																											},
		// 																											{
		// 																												Retention: to.Ptr("P93D"),
		// 																												TimeGrain: to.Ptr("P1D"),
		// 																										}},
		// 																										Namespace: to.Ptr("microsoft.insights/components"),
		// 																										PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 																										ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																										SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																											to.Ptr(armmonitor.AggregationTypeCount)},
		// 																											Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																										},
		// 																										{
		// 																											Name: &armmonitor.LocalizableString{
		// 																												LocalizedValue: to.Ptr("Failed requests"),
		// 																												Value: to.Ptr("requests/failed"),
		// 																											},
		// 																											Category: to.Ptr("Failures"),
		// 																											Dimensions: []*armmonitor.LocalizableString{
		// 																												{
		// 																													LocalizedValue: to.Ptr("Request performance"),
		// 																													Value: to.Ptr("request/performanceBucket"),
		// 																												},
		// 																												{
		// 																													LocalizedValue: to.Ptr("Result code"),
		// 																													Value: to.Ptr("request/resultCode"),
		// 																												},
		// 																												{
		// 																													LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																													Value: to.Ptr("operation/synthetic"),
		// 																												},
		// 																												{
		// 																													LocalizedValue: to.Ptr("Cloud role instance"),
		// 																													Value: to.Ptr("cloud/roleInstance"),
		// 																												},
		// 																												{
		// 																													LocalizedValue: to.Ptr("Cloud role name"),
		// 																													Value: to.Ptr("cloud/roleName"),
		// 																											}},
		// 																											DisplayDescription: to.Ptr("Count of HTTP requests marked as failed. In most cases these are requests with a response code >= 400 and not equal to 401."),
		// 																											ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/requests/failed"),
		// 																											IsDimensionRequired: to.Ptr(false),
		// 																											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT1M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT5M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT15M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT30M"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT1H"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT6H"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("PT12H"),
		// 																												},
		// 																												{
		// 																													Retention: to.Ptr("P93D"),
		// 																													TimeGrain: to.Ptr("P1D"),
		// 																											}},
		// 																											Namespace: to.Ptr("microsoft.insights/components"),
		// 																											PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 																											ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																											SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																												to.Ptr(armmonitor.AggregationTypeCount)},
		// 																												Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																											},
		// 																											{
		// 																												Name: &armmonitor.LocalizableString{
		// 																													LocalizedValue: to.Ptr("Server request rate"),
		// 																													Value: to.Ptr("requests/rate"),
		// 																												},
		// 																												Category: to.Ptr("Server"),
		// 																												Dimensions: []*armmonitor.LocalizableString{
		// 																													{
		// 																														LocalizedValue: to.Ptr("Request performance"),
		// 																														Value: to.Ptr("request/performanceBucket"),
		// 																													},
		// 																													{
		// 																														LocalizedValue: to.Ptr("Result code"),
		// 																														Value: to.Ptr("request/resultCode"),
		// 																													},
		// 																													{
		// 																														LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																														Value: to.Ptr("operation/synthetic"),
		// 																													},
		// 																													{
		// 																														LocalizedValue: to.Ptr("Cloud role instance"),
		// 																														Value: to.Ptr("cloud/roleInstance"),
		// 																													},
		// 																													{
		// 																														LocalizedValue: to.Ptr("Successful request"),
		// 																														Value: to.Ptr("request/success"),
		// 																													},
		// 																													{
		// 																														LocalizedValue: to.Ptr("Cloud role name"),
		// 																														Value: to.Ptr("cloud/roleName"),
		// 																												}},
		// 																												DisplayDescription: to.Ptr("Rate of server requests per second"),
		// 																												ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/requests/rate"),
		// 																												IsDimensionRequired: to.Ptr(false),
		// 																												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT1M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT5M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT15M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT30M"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT1H"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT6H"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("PT12H"),
		// 																													},
		// 																													{
		// 																														Retention: to.Ptr("P93D"),
		// 																														TimeGrain: to.Ptr("P1D"),
		// 																												}},
		// 																												Namespace: to.Ptr("microsoft.insights/components"),
		// 																												PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																												ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																												SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																													to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																													Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																												},
		// 																												{
		// 																													Name: &armmonitor.LocalizableString{
		// 																														LocalizedValue: to.Ptr("Exceptions"),
		// 																														Value: to.Ptr("exceptions/count"),
		// 																													},
		// 																													Category: to.Ptr("Failures"),
		// 																													Dimensions: []*armmonitor.LocalizableString{
		// 																														{
		// 																															LocalizedValue: to.Ptr("Cloud role name"),
		// 																															Value: to.Ptr("cloud/roleName"),
		// 																														},
		// 																														{
		// 																															LocalizedValue: to.Ptr("Cloud role instance"),
		// 																															Value: to.Ptr("cloud/roleInstance"),
		// 																														},
		// 																														{
		// 																															LocalizedValue: to.Ptr("Device type"),
		// 																															Value: to.Ptr("client/type"),
		// 																													}},
		// 																													DisplayDescription: to.Ptr("Combined count of all uncaught exceptions."),
		// 																													ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/exceptions/count"),
		// 																													IsDimensionRequired: to.Ptr(false),
		// 																													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT1M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT5M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT15M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT30M"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT1H"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT6H"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("PT12H"),
		// 																														},
		// 																														{
		// 																															Retention: to.Ptr("P93D"),
		// 																															TimeGrain: to.Ptr("P1D"),
		// 																													}},
		// 																													Namespace: to.Ptr("microsoft.insights/components"),
		// 																													PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 																													ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																													SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																														to.Ptr(armmonitor.AggregationTypeCount)},
		// 																														Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																													},
		// 																													{
		// 																														Name: &armmonitor.LocalizableString{
		// 																															LocalizedValue: to.Ptr("Browser exceptions"),
		// 																															Value: to.Ptr("exceptions/browser"),
		// 																														},
		// 																														Category: to.Ptr("Failures"),
		// 																														Dimensions: []*armmonitor.LocalizableString{
		// 																															{
		// 																																LocalizedValue: to.Ptr("Cloud role name"),
		// 																																Value: to.Ptr("cloud/roleName"),
		// 																														}},
		// 																														DisplayDescription: to.Ptr("Count of uncaught exceptions thrown in the browser."),
		// 																														ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/exceptions/browser"),
		// 																														IsDimensionRequired: to.Ptr(false),
		// 																														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT1M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT5M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT15M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT30M"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT1H"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT6H"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("PT12H"),
		// 																															},
		// 																															{
		// 																																Retention: to.Ptr("P93D"),
		// 																																TimeGrain: to.Ptr("P1D"),
		// 																														}},
		// 																														Namespace: to.Ptr("microsoft.insights/components"),
		// 																														PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 																														ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																														SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																															to.Ptr(armmonitor.AggregationTypeCount)},
		// 																															Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																														},
		// 																														{
		// 																															Name: &armmonitor.LocalizableString{
		// 																																LocalizedValue: to.Ptr("Server exceptions"),
		// 																																Value: to.Ptr("exceptions/server"),
		// 																															},
		// 																															Category: to.Ptr("Failures"),
		// 																															Dimensions: []*armmonitor.LocalizableString{
		// 																																{
		// 																																	LocalizedValue: to.Ptr("Cloud role name"),
		// 																																	Value: to.Ptr("cloud/roleName"),
		// 																																},
		// 																																{
		// 																																	LocalizedValue: to.Ptr("Cloud role instance"),
		// 																																	Value: to.Ptr("cloud/roleInstance"),
		// 																															}},
		// 																															DisplayDescription: to.Ptr("Count of uncaught exceptions thrown in the server application."),
		// 																															ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/exceptions/server"),
		// 																															IsDimensionRequired: to.Ptr(false),
		// 																															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT1M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT5M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT15M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT30M"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT1H"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT6H"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("PT12H"),
		// 																																},
		// 																																{
		// 																																	Retention: to.Ptr("P93D"),
		// 																																	TimeGrain: to.Ptr("P1D"),
		// 																															}},
		// 																															Namespace: to.Ptr("microsoft.insights/components"),
		// 																															PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 																															ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																															SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																																to.Ptr(armmonitor.AggregationTypeCount)},
		// 																																Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																															},
		// 																															{
		// 																																Name: &armmonitor.LocalizableString{
		// 																																	LocalizedValue: to.Ptr("Traces"),
		// 																																	Value: to.Ptr("traces/count"),
		// 																																},
		// 																																Category: to.Ptr("Usage"),
		// 																																Dimensions: []*armmonitor.LocalizableString{
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("Severity level"),
		// 																																		Value: to.Ptr("trace/severityLevel"),
		// 																																	},
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("Is traffic synthetic"),
		// 																																		Value: to.Ptr("operation/synthetic"),
		// 																																	},
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("Cloud role name"),
		// 																																		Value: to.Ptr("cloud/roleName"),
		// 																																	},
		// 																																	{
		// 																																		LocalizedValue: to.Ptr("Cloud role instance"),
		// 																																		Value: to.Ptr("cloud/roleInstance"),
		// 																																}},
		// 																																DisplayDescription: to.Ptr("Trace document count"),
		// 																																ID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill/providers/microsoft.insights/metricdefinitions/traces/count"),
		// 																																IsDimensionRequired: to.Ptr(false),
		// 																																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT1M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT5M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT15M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT30M"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT1H"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT6H"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("PT12H"),
		// 																																	},
		// 																																	{
		// 																																		Retention: to.Ptr("P93D"),
		// 																																		TimeGrain: to.Ptr("P1D"),
		// 																																}},
		// 																																Namespace: to.Ptr("microsoft.insights/components"),
		// 																																PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeCount),
		// 																																ResourceID: to.Ptr("/subscriptions/182c901a-129a-4f5d-86e4-cc6b294590a2/resourceGroups/hyr-log/providers/microsoft.insights/components/f1-bill"),
		// 																																SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																																	to.Ptr(armmonitor.AggregationTypeCount)},
		// 																																	Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 																															}},
		// 																														}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMetricDefinitions.json
func ExampleMetricDefinitionsClient_NewListPager_getMetricDefinitionsWithoutFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMetricDefinitionsClient().NewListPager("subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricDefinitions", &armmonitor.MetricDefinitionsClientListOptions{Metricnamespace: to.Ptr("Microsoft.Web/sites")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionCollection = armmonitor.MetricDefinitionCollection{
		// 	Value: []*armmonitor.MetricDefinition{
		// 		{
		// 			Name: &armmonitor.LocalizableString{
		// 				LocalizedValue: to.Ptr("CPU Time"),
		// 				Value: to.Ptr("CpuTime"),
		// 			},
		// 			Dimensions: []*armmonitor.LocalizableString{
		// 				{
		// 					LocalizedValue: to.Ptr("Instance"),
		// 					Value: to.Ptr("Instance"),
		// 			}},
		// 			ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/CpuTime"),
		// 			IsDimensionRequired: to.Ptr(false),
		// 			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT5M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT15M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT30M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT6H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT12H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			Namespace: to.Ptr("Microsoft.Web/sites"),
		// 			PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 			ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 			SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 				to.Ptr(armmonitor.AggregationTypeNone),
		// 				to.Ptr(armmonitor.AggregationTypeAverage),
		// 				to.Ptr(armmonitor.AggregationTypeMinimum),
		// 				to.Ptr(armmonitor.AggregationTypeMaximum),
		// 				to.Ptr(armmonitor.AggregationTypeTotal),
		// 				to.Ptr(armmonitor.AggregationTypeCount)},
		// 				Unit: to.Ptr(armmonitor.MetricUnitSeconds),
		// 			},
		// 			{
		// 				Name: &armmonitor.LocalizableString{
		// 					LocalizedValue: to.Ptr("Requests"),
		// 					Value: to.Ptr("Requests"),
		// 				},
		// 				Dimensions: []*armmonitor.LocalizableString{
		// 					{
		// 						LocalizedValue: to.Ptr("Instance"),
		// 						Value: to.Ptr("Instance"),
		// 				}},
		// 				ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Requests"),
		// 				IsDimensionRequired: to.Ptr(false),
		// 				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT5M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT15M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT30M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT6H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT12H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("P1D"),
		// 				}},
		// 				Namespace: to.Ptr("Microsoft.Web/sites"),
		// 				PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 				ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 				SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 					to.Ptr(armmonitor.AggregationTypeNone),
		// 					to.Ptr(armmonitor.AggregationTypeAverage),
		// 					to.Ptr(armmonitor.AggregationTypeMinimum),
		// 					to.Ptr(armmonitor.AggregationTypeMaximum),
		// 					to.Ptr(armmonitor.AggregationTypeTotal),
		// 					to.Ptr(armmonitor.AggregationTypeCount)},
		// 					Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 				},
		// 				{
		// 					Name: &armmonitor.LocalizableString{
		// 						LocalizedValue: to.Ptr("Data In"),
		// 						Value: to.Ptr("BytesReceived"),
		// 					},
		// 					Dimensions: []*armmonitor.LocalizableString{
		// 						{
		// 							LocalizedValue: to.Ptr("Instance"),
		// 							Value: to.Ptr("Instance"),
		// 					}},
		// 					ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/BytesReceived"),
		// 					IsDimensionRequired: to.Ptr(false),
		// 					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT5M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT15M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT30M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT6H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT12H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("P1D"),
		// 					}},
		// 					Namespace: to.Ptr("Microsoft.Web/sites"),
		// 					PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 					ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 					SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 						to.Ptr(armmonitor.AggregationTypeNone),
		// 						to.Ptr(armmonitor.AggregationTypeAverage),
		// 						to.Ptr(armmonitor.AggregationTypeMinimum),
		// 						to.Ptr(armmonitor.AggregationTypeMaximum),
		// 						to.Ptr(armmonitor.AggregationTypeTotal),
		// 						to.Ptr(armmonitor.AggregationTypeCount)},
		// 						Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 					},
		// 					{
		// 						Name: &armmonitor.LocalizableString{
		// 							LocalizedValue: to.Ptr("Data Out"),
		// 							Value: to.Ptr("BytesSent"),
		// 						},
		// 						Dimensions: []*armmonitor.LocalizableString{
		// 							{
		// 								LocalizedValue: to.Ptr("Instance"),
		// 								Value: to.Ptr("Instance"),
		// 						}},
		// 						ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/BytesSent"),
		// 						IsDimensionRequired: to.Ptr(false),
		// 						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT5M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT15M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT30M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT6H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT12H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("P1D"),
		// 						}},
		// 						Namespace: to.Ptr("Microsoft.Web/sites"),
		// 						PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 						ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 						SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 							to.Ptr(armmonitor.AggregationTypeNone),
		// 							to.Ptr(armmonitor.AggregationTypeAverage),
		// 							to.Ptr(armmonitor.AggregationTypeMinimum),
		// 							to.Ptr(armmonitor.AggregationTypeMaximum),
		// 							to.Ptr(armmonitor.AggregationTypeTotal),
		// 							to.Ptr(armmonitor.AggregationTypeCount)},
		// 							Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 						},
		// 						{
		// 							Name: &armmonitor.LocalizableString{
		// 								LocalizedValue: to.Ptr("Http 101"),
		// 								Value: to.Ptr("Http101"),
		// 							},
		// 							Dimensions: []*armmonitor.LocalizableString{
		// 								{
		// 									LocalizedValue: to.Ptr("Instance"),
		// 									Value: to.Ptr("Instance"),
		// 							}},
		// 							ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http101"),
		// 							IsDimensionRequired: to.Ptr(false),
		// 							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT5M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT15M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT30M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT6H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT12H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							Namespace: to.Ptr("Microsoft.Web/sites"),
		// 							PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 							ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 							SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 								to.Ptr(armmonitor.AggregationTypeNone),
		// 								to.Ptr(armmonitor.AggregationTypeAverage),
		// 								to.Ptr(armmonitor.AggregationTypeMinimum),
		// 								to.Ptr(armmonitor.AggregationTypeMaximum),
		// 								to.Ptr(armmonitor.AggregationTypeTotal),
		// 								to.Ptr(armmonitor.AggregationTypeCount)},
		// 								Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 							},
		// 							{
		// 								Name: &armmonitor.LocalizableString{
		// 									LocalizedValue: to.Ptr("Http 2xx"),
		// 									Value: to.Ptr("Http2xx"),
		// 								},
		// 								Dimensions: []*armmonitor.LocalizableString{
		// 									{
		// 										LocalizedValue: to.Ptr("Instance"),
		// 										Value: to.Ptr("Instance"),
		// 								}},
		// 								ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http2xx"),
		// 								IsDimensionRequired: to.Ptr(false),
		// 								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT5M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT15M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT30M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT6H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT12H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("P1D"),
		// 								}},
		// 								Namespace: to.Ptr("Microsoft.Web/sites"),
		// 								PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 								ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 								SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 									to.Ptr(armmonitor.AggregationTypeNone),
		// 									to.Ptr(armmonitor.AggregationTypeAverage),
		// 									to.Ptr(armmonitor.AggregationTypeMinimum),
		// 									to.Ptr(armmonitor.AggregationTypeMaximum),
		// 									to.Ptr(armmonitor.AggregationTypeTotal),
		// 									to.Ptr(armmonitor.AggregationTypeCount)},
		// 									Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 								},
		// 								{
		// 									Name: &armmonitor.LocalizableString{
		// 										LocalizedValue: to.Ptr("Http 3xx"),
		// 										Value: to.Ptr("Http3xx"),
		// 									},
		// 									Dimensions: []*armmonitor.LocalizableString{
		// 										{
		// 											LocalizedValue: to.Ptr("Instance"),
		// 											Value: to.Ptr("Instance"),
		// 									}},
		// 									ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http3xx"),
		// 									IsDimensionRequired: to.Ptr(false),
		// 									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT5M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT15M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT30M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT6H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT12H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("P1D"),
		// 									}},
		// 									Namespace: to.Ptr("Microsoft.Web/sites"),
		// 									PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 									ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 									SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 										to.Ptr(armmonitor.AggregationTypeNone),
		// 										to.Ptr(armmonitor.AggregationTypeAverage),
		// 										to.Ptr(armmonitor.AggregationTypeMinimum),
		// 										to.Ptr(armmonitor.AggregationTypeMaximum),
		// 										to.Ptr(armmonitor.AggregationTypeTotal),
		// 										to.Ptr(armmonitor.AggregationTypeCount)},
		// 										Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 									},
		// 									{
		// 										Name: &armmonitor.LocalizableString{
		// 											LocalizedValue: to.Ptr("Http 401"),
		// 											Value: to.Ptr("Http401"),
		// 										},
		// 										Dimensions: []*armmonitor.LocalizableString{
		// 											{
		// 												LocalizedValue: to.Ptr("Instance"),
		// 												Value: to.Ptr("Instance"),
		// 										}},
		// 										ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http401"),
		// 										IsDimensionRequired: to.Ptr(false),
		// 										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT5M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT15M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT30M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT6H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT12H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("P1D"),
		// 										}},
		// 										Namespace: to.Ptr("Microsoft.Web/sites"),
		// 										PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 										ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 										SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 											to.Ptr(armmonitor.AggregationTypeNone),
		// 											to.Ptr(armmonitor.AggregationTypeAverage),
		// 											to.Ptr(armmonitor.AggregationTypeMinimum),
		// 											to.Ptr(armmonitor.AggregationTypeMaximum),
		// 											to.Ptr(armmonitor.AggregationTypeTotal),
		// 											to.Ptr(armmonitor.AggregationTypeCount)},
		// 											Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 										},
		// 										{
		// 											Name: &armmonitor.LocalizableString{
		// 												LocalizedValue: to.Ptr("Http 403"),
		// 												Value: to.Ptr("Http403"),
		// 											},
		// 											Dimensions: []*armmonitor.LocalizableString{
		// 												{
		// 													LocalizedValue: to.Ptr("Instance"),
		// 													Value: to.Ptr("Instance"),
		// 											}},
		// 											ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http403"),
		// 											IsDimensionRequired: to.Ptr(false),
		// 											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT5M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT15M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT30M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT6H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT12H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("P1D"),
		// 											}},
		// 											Namespace: to.Ptr("Microsoft.Web/sites"),
		// 											PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 											ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 											SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 												to.Ptr(armmonitor.AggregationTypeNone),
		// 												to.Ptr(armmonitor.AggregationTypeAverage),
		// 												to.Ptr(armmonitor.AggregationTypeMinimum),
		// 												to.Ptr(armmonitor.AggregationTypeMaximum),
		// 												to.Ptr(armmonitor.AggregationTypeTotal),
		// 												to.Ptr(armmonitor.AggregationTypeCount)},
		// 												Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 											},
		// 											{
		// 												Name: &armmonitor.LocalizableString{
		// 													LocalizedValue: to.Ptr("Http 404"),
		// 													Value: to.Ptr("Http404"),
		// 												},
		// 												Dimensions: []*armmonitor.LocalizableString{
		// 													{
		// 														LocalizedValue: to.Ptr("Instance"),
		// 														Value: to.Ptr("Instance"),
		// 												}},
		// 												ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http404"),
		// 												IsDimensionRequired: to.Ptr(false),
		// 												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT5M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT15M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT30M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT6H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT12H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("P1D"),
		// 												}},
		// 												Namespace: to.Ptr("Microsoft.Web/sites"),
		// 												PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 												ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 												SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 													to.Ptr(armmonitor.AggregationTypeNone),
		// 													to.Ptr(armmonitor.AggregationTypeAverage),
		// 													to.Ptr(armmonitor.AggregationTypeMinimum),
		// 													to.Ptr(armmonitor.AggregationTypeMaximum),
		// 													to.Ptr(armmonitor.AggregationTypeTotal),
		// 													to.Ptr(armmonitor.AggregationTypeCount)},
		// 													Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 												},
		// 												{
		// 													Name: &armmonitor.LocalizableString{
		// 														LocalizedValue: to.Ptr("Http 406"),
		// 														Value: to.Ptr("Http406"),
		// 													},
		// 													Dimensions: []*armmonitor.LocalizableString{
		// 														{
		// 															LocalizedValue: to.Ptr("Instance"),
		// 															Value: to.Ptr("Instance"),
		// 													}},
		// 													ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http406"),
		// 													IsDimensionRequired: to.Ptr(false),
		// 													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT5M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT15M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT30M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT6H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT12H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("P1D"),
		// 													}},
		// 													Namespace: to.Ptr("Microsoft.Web/sites"),
		// 													PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 													ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 													SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 														to.Ptr(armmonitor.AggregationTypeNone),
		// 														to.Ptr(armmonitor.AggregationTypeAverage),
		// 														to.Ptr(armmonitor.AggregationTypeMinimum),
		// 														to.Ptr(armmonitor.AggregationTypeMaximum),
		// 														to.Ptr(armmonitor.AggregationTypeTotal),
		// 														to.Ptr(armmonitor.AggregationTypeCount)},
		// 														Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 													},
		// 													{
		// 														Name: &armmonitor.LocalizableString{
		// 															LocalizedValue: to.Ptr("Http 4xx"),
		// 															Value: to.Ptr("Http4xx"),
		// 														},
		// 														Dimensions: []*armmonitor.LocalizableString{
		// 															{
		// 																LocalizedValue: to.Ptr("Instance"),
		// 																Value: to.Ptr("Instance"),
		// 														}},
		// 														ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http4xx"),
		// 														IsDimensionRequired: to.Ptr(false),
		// 														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT5M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT15M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT30M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT6H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT12H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("P1D"),
		// 														}},
		// 														Namespace: to.Ptr("Microsoft.Web/sites"),
		// 														PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 														ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 														SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 															to.Ptr(armmonitor.AggregationTypeNone),
		// 															to.Ptr(armmonitor.AggregationTypeAverage),
		// 															to.Ptr(armmonitor.AggregationTypeMinimum),
		// 															to.Ptr(armmonitor.AggregationTypeMaximum),
		// 															to.Ptr(armmonitor.AggregationTypeTotal),
		// 															to.Ptr(armmonitor.AggregationTypeCount)},
		// 															Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 														},
		// 														{
		// 															Name: &armmonitor.LocalizableString{
		// 																LocalizedValue: to.Ptr("Http Server Errors"),
		// 																Value: to.Ptr("Http5xx"),
		// 															},
		// 															Dimensions: []*armmonitor.LocalizableString{
		// 																{
		// 																	LocalizedValue: to.Ptr("Instance"),
		// 																	Value: to.Ptr("Instance"),
		// 															}},
		// 															ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/Http5xx"),
		// 															IsDimensionRequired: to.Ptr(false),
		// 															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT5M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT15M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT30M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT6H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT12H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("P1D"),
		// 															}},
		// 															Namespace: to.Ptr("Microsoft.Web/sites"),
		// 															PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeTotal),
		// 															ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 															SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																to.Ptr(armmonitor.AggregationTypeNone),
		// 																to.Ptr(armmonitor.AggregationTypeAverage),
		// 																to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																to.Ptr(armmonitor.AggregationTypeTotal),
		// 																to.Ptr(armmonitor.AggregationTypeCount)},
		// 																Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 															},
		// 															{
		// 																Name: &armmonitor.LocalizableString{
		// 																	LocalizedValue: to.Ptr("Memory working set"),
		// 																	Value: to.Ptr("MemoryWorkingSet"),
		// 																},
		// 																Dimensions: []*armmonitor.LocalizableString{
		// 																	{
		// 																		LocalizedValue: to.Ptr("Instance"),
		// 																		Value: to.Ptr("Instance"),
		// 																}},
		// 																ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/MemoryWorkingSet"),
		// 																IsDimensionRequired: to.Ptr(false),
		// 																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT5M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT15M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT30M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT6H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT12H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("P1D"),
		// 																}},
		// 																Namespace: to.Ptr("Microsoft.Web/sites"),
		// 																PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 																SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																	to.Ptr(armmonitor.AggregationTypeNone),
		// 																	to.Ptr(armmonitor.AggregationTypeAverage),
		// 																	to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																	to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																	to.Ptr(armmonitor.AggregationTypeTotal),
		// 																	to.Ptr(armmonitor.AggregationTypeCount)},
		// 																	Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 																},
		// 																{
		// 																	Name: &armmonitor.LocalizableString{
		// 																		LocalizedValue: to.Ptr("Average memory working set"),
		// 																		Value: to.Ptr("AverageMemoryWorkingSet"),
		// 																	},
		// 																	Dimensions: []*armmonitor.LocalizableString{
		// 																		{
		// 																			LocalizedValue: to.Ptr("Instance"),
		// 																			Value: to.Ptr("Instance"),
		// 																	}},
		// 																	ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/AverageMemoryWorkingSet"),
		// 																	IsDimensionRequired: to.Ptr(false),
		// 																	MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT5M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT15M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT30M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT6H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT12H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("P1D"),
		// 																	}},
		// 																	Namespace: to.Ptr("Microsoft.Web/sites"),
		// 																	PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																	ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 																	SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																		to.Ptr(armmonitor.AggregationTypeNone),
		// 																		to.Ptr(armmonitor.AggregationTypeAverage),
		// 																		to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																		to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																		to.Ptr(armmonitor.AggregationTypeTotal),
		// 																		to.Ptr(armmonitor.AggregationTypeCount)},
		// 																		Unit: to.Ptr(armmonitor.MetricUnitBytes),
		// 																	},
		// 																	{
		// 																		Name: &armmonitor.LocalizableString{
		// 																			LocalizedValue: to.Ptr("Average Response Time"),
		// 																			Value: to.Ptr("AverageResponseTime"),
		// 																		},
		// 																		Dimensions: []*armmonitor.LocalizableString{
		// 																			{
		// 																				LocalizedValue: to.Ptr("Instance"),
		// 																				Value: to.Ptr("Instance"),
		// 																		}},
		// 																		ID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest/providers/microsoft.insights/metricdefinitions/AverageResponseTime"),
		// 																		IsDimensionRequired: to.Ptr(false),
		// 																		MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT5M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT15M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT30M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT6H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT12H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("P1D"),
		// 																		}},
		// 																		Namespace: to.Ptr("Microsoft.Web/sites"),
		// 																		PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																		ResourceID: to.Ptr("/subscriptions/07c0b09d-9f69-4e6e-8d05-f59f67299cb2/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/alertruleTest"),
		// 																		SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																			to.Ptr(armmonitor.AggregationTypeNone),
		// 																			to.Ptr(armmonitor.AggregationTypeAverage),
		// 																			to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																			to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																			to.Ptr(armmonitor.AggregationTypeTotal),
		// 																			to.Ptr(armmonitor.AggregationTypeCount)},
		// 																			Unit: to.Ptr(armmonitor.MetricUnitSeconds),
		// 																	}},
		// 																}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMetricDefinitionsMetricClass.json
func ExampleMetricDefinitionsClient_NewListPager_getStorageCacheMetricDefinitionsWithMetricClass() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMetricDefinitionsClient().NewListPager("subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache", &armmonitor.MetricDefinitionsClientListOptions{Metricnamespace: to.Ptr("microsoft.storagecache/caches")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionCollection = armmonitor.MetricDefinitionCollection{
		// 	Value: []*armmonitor.MetricDefinition{
		// 		{
		// 			Name: &armmonitor.LocalizableString{
		// 				LocalizedValue: to.Ptr("Total Client IOPS"),
		// 				Value: to.Ptr("ClientIOPS"),
		// 			},
		// 			DisplayDescription: to.Ptr("The rate of client file operations processed by the Cache."),
		// 			ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientIOPS"),
		// 			IsDimensionRequired: to.Ptr(false),
		// 			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT5M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT15M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT30M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT6H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("PT12H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P93D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 			Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 			PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 			SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 				to.Ptr(armmonitor.AggregationTypeMinimum),
		// 				to.Ptr(armmonitor.AggregationTypeMaximum),
		// 				to.Ptr(armmonitor.AggregationTypeAverage)},
		// 				Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 			},
		// 			{
		// 				Name: &armmonitor.LocalizableString{
		// 					LocalizedValue: to.Ptr("Average Client Latency"),
		// 					Value: to.Ptr("ClientLatency"),
		// 				},
		// 				DisplayDescription: to.Ptr("Average latency of client file operations to the Cache."),
		// 				ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientLatency"),
		// 				IsDimensionRequired: to.Ptr(false),
		// 				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT5M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT15M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT30M"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT1H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT6H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("PT12H"),
		// 					},
		// 					{
		// 						Retention: to.Ptr("P93D"),
		// 						TimeGrain: to.Ptr("P1D"),
		// 				}},
		// 				MetricClass: to.Ptr(armmonitor.MetricClassLatency),
		// 				Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 				PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 				ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 				SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 					to.Ptr(armmonitor.AggregationTypeMinimum),
		// 					to.Ptr(armmonitor.AggregationTypeMaximum),
		// 					to.Ptr(armmonitor.AggregationTypeAverage)},
		// 					Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 				},
		// 				{
		// 					Name: &armmonitor.LocalizableString{
		// 						LocalizedValue: to.Ptr("Client Read IOPS"),
		// 						Value: to.Ptr("ClientReadIOPS"),
		// 					},
		// 					DisplayDescription: to.Ptr("Client read operations per second."),
		// 					ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientReadIOPS"),
		// 					IsDimensionRequired: to.Ptr(false),
		// 					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT5M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT15M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT30M"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT1H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT6H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("PT12H"),
		// 						},
		// 						{
		// 							Retention: to.Ptr("P93D"),
		// 							TimeGrain: to.Ptr("P1D"),
		// 					}},
		// 					MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 					Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 					PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 					ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 					SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 						to.Ptr(armmonitor.AggregationTypeMinimum),
		// 						to.Ptr(armmonitor.AggregationTypeMaximum),
		// 						to.Ptr(armmonitor.AggregationTypeAverage)},
		// 						Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 					},
		// 					{
		// 						Name: &armmonitor.LocalizableString{
		// 							LocalizedValue: to.Ptr("Average Cache Read Throughput"),
		// 							Value: to.Ptr("ClientReadThroughput"),
		// 						},
		// 						DisplayDescription: to.Ptr("Client read data transfer rate."),
		// 						ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientReadThroughput"),
		// 						IsDimensionRequired: to.Ptr(false),
		// 						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT5M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT15M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT30M"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT1H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT6H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("PT12H"),
		// 							},
		// 							{
		// 								Retention: to.Ptr("P93D"),
		// 								TimeGrain: to.Ptr("P1D"),
		// 						}},
		// 						MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 						Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 						PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 						ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 						SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 							to.Ptr(armmonitor.AggregationTypeMinimum),
		// 							to.Ptr(armmonitor.AggregationTypeMaximum),
		// 							to.Ptr(armmonitor.AggregationTypeAverage)},
		// 							Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 						},
		// 						{
		// 							Name: &armmonitor.LocalizableString{
		// 								LocalizedValue: to.Ptr("Client Write IOPS"),
		// 								Value: to.Ptr("ClientWriteIOPS"),
		// 							},
		// 							DisplayDescription: to.Ptr("Client write operations per second."),
		// 							ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientWriteIOPS"),
		// 							IsDimensionRequired: to.Ptr(false),
		// 							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT5M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT15M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT30M"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT6H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("PT12H"),
		// 								},
		// 								{
		// 									Retention: to.Ptr("P93D"),
		// 									TimeGrain: to.Ptr("P1D"),
		// 							}},
		// 							MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 							Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 							PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 							ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 							SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 								to.Ptr(armmonitor.AggregationTypeMinimum),
		// 								to.Ptr(armmonitor.AggregationTypeMaximum),
		// 								to.Ptr(armmonitor.AggregationTypeAverage)},
		// 								Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 							},
		// 							{
		// 								Name: &armmonitor.LocalizableString{
		// 									LocalizedValue: to.Ptr("Average Cache Write Throughput"),
		// 									Value: to.Ptr("ClientWriteThroughput"),
		// 								},
		// 								DisplayDescription: to.Ptr("Client write data transfer rate."),
		// 								ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientWriteThroughput"),
		// 								IsDimensionRequired: to.Ptr(false),
		// 								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT5M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT15M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT30M"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT1H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT6H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("PT12H"),
		// 									},
		// 									{
		// 										Retention: to.Ptr("P93D"),
		// 										TimeGrain: to.Ptr("P1D"),
		// 								}},
		// 								MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 								Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 								PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 								ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 								SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 									to.Ptr(armmonitor.AggregationTypeMinimum),
		// 									to.Ptr(armmonitor.AggregationTypeMaximum),
		// 									to.Ptr(armmonitor.AggregationTypeAverage)},
		// 									Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 								},
		// 								{
		// 									Name: &armmonitor.LocalizableString{
		// 										LocalizedValue: to.Ptr("Client Metadata Read IOPS"),
		// 										Value: to.Ptr("ClientMetadataReadIOPS"),
		// 									},
		// 									DisplayDescription: to.Ptr("The rate of client file operations sent to the Cache, excluding data reads, that do not modify persistent state."),
		// 									ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientMetadataReadIOPS"),
		// 									IsDimensionRequired: to.Ptr(false),
		// 									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT5M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT15M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT30M"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT1H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT6H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("PT12H"),
		// 										},
		// 										{
		// 											Retention: to.Ptr("P93D"),
		// 											TimeGrain: to.Ptr("P1D"),
		// 									}},
		// 									MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 									Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 									PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 									ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 									SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 										to.Ptr(armmonitor.AggregationTypeMinimum),
		// 										to.Ptr(armmonitor.AggregationTypeMaximum),
		// 										to.Ptr(armmonitor.AggregationTypeAverage)},
		// 										Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 									},
		// 									{
		// 										Name: &armmonitor.LocalizableString{
		// 											LocalizedValue: to.Ptr("Client Metadata Write IOPS"),
		// 											Value: to.Ptr("ClientMetadataWriteIOPS"),
		// 										},
		// 										DisplayDescription: to.Ptr("The rate of client file operations sent to the Cache, excluding data writes, that modify persistent state."),
		// 										ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientMetadataWriteIOPS"),
		// 										IsDimensionRequired: to.Ptr(false),
		// 										MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT5M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT15M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT30M"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT1H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT6H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("PT12H"),
		// 											},
		// 											{
		// 												Retention: to.Ptr("P93D"),
		// 												TimeGrain: to.Ptr("P1D"),
		// 										}},
		// 										MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 										Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 										PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 										ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 										SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 											to.Ptr(armmonitor.AggregationTypeMinimum),
		// 											to.Ptr(armmonitor.AggregationTypeMaximum),
		// 											to.Ptr(armmonitor.AggregationTypeAverage)},
		// 											Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 										},
		// 										{
		// 											Name: &armmonitor.LocalizableString{
		// 												LocalizedValue: to.Ptr("Client Lock IOPS"),
		// 												Value: to.Ptr("ClientLockIOPS"),
		// 											},
		// 											DisplayDescription: to.Ptr("Client file locking operations per second."),
		// 											ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/ClientLockIOPS"),
		// 											IsDimensionRequired: to.Ptr(false),
		// 											MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT5M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT15M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT30M"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT1H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT6H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("PT12H"),
		// 												},
		// 												{
		// 													Retention: to.Ptr("P93D"),
		// 													TimeGrain: to.Ptr("P1D"),
		// 											}},
		// 											MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 											Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 											PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 											ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 											SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 												to.Ptr(armmonitor.AggregationTypeMinimum),
		// 												to.Ptr(armmonitor.AggregationTypeMaximum),
		// 												to.Ptr(armmonitor.AggregationTypeAverage)},
		// 												Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 											},
		// 											{
		// 												Name: &armmonitor.LocalizableString{
		// 													LocalizedValue: to.Ptr("Storage Target Health"),
		// 													Value: to.Ptr("StorageTargetHealth"),
		// 												},
		// 												DisplayDescription: to.Ptr("Boolean results of connectivity test between the Cache and Storage Targets."),
		// 												ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetHealth"),
		// 												IsDimensionRequired: to.Ptr(false),
		// 												MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT5M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT15M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT30M"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT1H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT6H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("PT12H"),
		// 													},
		// 													{
		// 														Retention: to.Ptr("P93D"),
		// 														TimeGrain: to.Ptr("P1D"),
		// 												}},
		// 												MetricClass: to.Ptr(armmonitor.MetricClassErrors),
		// 												Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 												PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 												ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 												SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 													to.Ptr(armmonitor.AggregationTypeMinimum),
		// 													to.Ptr(armmonitor.AggregationTypeMaximum),
		// 													to.Ptr(armmonitor.AggregationTypeAverage)},
		// 													Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 												},
		// 												{
		// 													Name: &armmonitor.LocalizableString{
		// 														LocalizedValue: to.Ptr("Uptime"),
		// 														Value: to.Ptr("Uptime"),
		// 													},
		// 													DisplayDescription: to.Ptr("Boolean results of connectivity test between the Cache and monitoring system."),
		// 													ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/Uptime"),
		// 													IsDimensionRequired: to.Ptr(false),
		// 													MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT5M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT15M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT30M"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT1H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT6H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("PT12H"),
		// 														},
		// 														{
		// 															Retention: to.Ptr("P93D"),
		// 															TimeGrain: to.Ptr("P1D"),
		// 													}},
		// 													MetricClass: to.Ptr(armmonitor.MetricClassAvailability),
		// 													Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 													PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 													ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 													SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 														to.Ptr(armmonitor.AggregationTypeMinimum),
		// 														to.Ptr(armmonitor.AggregationTypeMaximum),
		// 														to.Ptr(armmonitor.AggregationTypeAverage)},
		// 														Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 													},
		// 													{
		// 														Name: &armmonitor.LocalizableString{
		// 															LocalizedValue: to.Ptr("Total StorageTarget IOPS"),
		// 															Value: to.Ptr("StorageTargetIOPS"),
		// 														},
		// 														Dimensions: []*armmonitor.LocalizableString{
		// 															{
		// 																LocalizedValue: to.Ptr("StorageTarget"),
		// 																Value: to.Ptr("StorageTarget"),
		// 														}},
		// 														DisplayDescription: to.Ptr("The rate of all file operations the Cache sends to a particular StorageTarget."),
		// 														ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetIOPS"),
		// 														IsDimensionRequired: to.Ptr(false),
		// 														MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT5M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT15M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT30M"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT1H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT6H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("PT12H"),
		// 															},
		// 															{
		// 																Retention: to.Ptr("P93D"),
		// 																TimeGrain: to.Ptr("P1D"),
		// 														}},
		// 														MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 														Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 														PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 														ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 														SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 															to.Ptr(armmonitor.AggregationTypeMinimum),
		// 															to.Ptr(armmonitor.AggregationTypeMaximum),
		// 															to.Ptr(armmonitor.AggregationTypeAverage)},
		// 															Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 														},
		// 														{
		// 															Name: &armmonitor.LocalizableString{
		// 																LocalizedValue: to.Ptr("StorageTarget Write IOPS"),
		// 																Value: to.Ptr("StorageTargetWriteIOPS"),
		// 															},
		// 															Dimensions: []*armmonitor.LocalizableString{
		// 																{
		// 																	LocalizedValue: to.Ptr("StorageTarget"),
		// 																	Value: to.Ptr("StorageTarget"),
		// 															}},
		// 															DisplayDescription: to.Ptr("The rate of the file write operations the Cache sends to a particular StorageTarget."),
		// 															ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetWriteIOPS"),
		// 															IsDimensionRequired: to.Ptr(false),
		// 															MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT5M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT15M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT30M"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT1H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT6H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("PT12H"),
		// 																},
		// 																{
		// 																	Retention: to.Ptr("P93D"),
		// 																	TimeGrain: to.Ptr("P1D"),
		// 															}},
		// 															MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 															Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 															PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 															ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 															SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																Unit: to.Ptr(armmonitor.MetricUnitCount),
		// 															},
		// 															{
		// 																Name: &armmonitor.LocalizableString{
		// 																	LocalizedValue: to.Ptr("StorageTarget Asynchronous Write Throughput"),
		// 																	Value: to.Ptr("StorageTargetAsyncWriteThroughput"),
		// 																},
		// 																Dimensions: []*armmonitor.LocalizableString{
		// 																	{
		// 																		LocalizedValue: to.Ptr("StorageTarget"),
		// 																		Value: to.Ptr("StorageTarget"),
		// 																}},
		// 																DisplayDescription: to.Ptr("The rate the Cache asynchronously writes data to a particular StorageTarget. These are opportunistic writes that do not cause clients to block."),
		// 																ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetAsyncWriteThroughput"),
		// 																IsDimensionRequired: to.Ptr(false),
		// 																MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT5M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT15M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT30M"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT1H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT6H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("PT12H"),
		// 																	},
		// 																	{
		// 																		Retention: to.Ptr("P93D"),
		// 																		TimeGrain: to.Ptr("P1D"),
		// 																}},
		// 																MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																	to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																	to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																	to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																	Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																},
		// 																{
		// 																	Name: &armmonitor.LocalizableString{
		// 																		LocalizedValue: to.Ptr("StorageTarget Synchronous Write Throughput"),
		// 																		Value: to.Ptr("StorageTargetSyncWriteThroughput"),
		// 																	},
		// 																	Dimensions: []*armmonitor.LocalizableString{
		// 																		{
		// 																			LocalizedValue: to.Ptr("StorageTarget"),
		// 																			Value: to.Ptr("StorageTarget"),
		// 																	}},
		// 																	DisplayDescription: to.Ptr("The rate the Cache synchronously writes data to a particular StorageTarget. These are writes that do cause clients to block."),
		// 																	ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetSyncWriteThroughput"),
		// 																	IsDimensionRequired: to.Ptr(false),
		// 																	MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT5M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT15M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT30M"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT1H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT6H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("PT12H"),
		// 																		},
		// 																		{
		// 																			Retention: to.Ptr("P93D"),
		// 																			TimeGrain: to.Ptr("P1D"),
		// 																	}},
		// 																	MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																	Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																	PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																	ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																	SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																		to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																		to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																		to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																		Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																	},
		// 																	{
		// 																		Name: &armmonitor.LocalizableString{
		// 																			LocalizedValue: to.Ptr("StorageTarget Total Write Throughput"),
		// 																			Value: to.Ptr("StorageTargetTotalWriteThroughput"),
		// 																		},
		// 																		Dimensions: []*armmonitor.LocalizableString{
		// 																			{
		// 																				LocalizedValue: to.Ptr("StorageTarget"),
		// 																				Value: to.Ptr("StorageTarget"),
		// 																		}},
		// 																		DisplayDescription: to.Ptr("The total rate that the Cache writes data to a particular StorageTarget."),
		// 																		ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetTotalWriteThroughput"),
		// 																		IsDimensionRequired: to.Ptr(false),
		// 																		MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT5M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT15M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT30M"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT1H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT6H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("PT12H"),
		// 																			},
		// 																			{
		// 																				Retention: to.Ptr("P93D"),
		// 																				TimeGrain: to.Ptr("P1D"),
		// 																		}},
		// 																		MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																		Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																		PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																		ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																		SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																			to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																			to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																			to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																			Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																		},
		// 																		{
		// 																			Name: &armmonitor.LocalizableString{
		// 																				LocalizedValue: to.Ptr("StorageTarget Latency"),
		// 																				Value: to.Ptr("StorageTargetLatency"),
		// 																			},
		// 																			Dimensions: []*armmonitor.LocalizableString{
		// 																				{
		// 																					LocalizedValue: to.Ptr("StorageTarget"),
		// 																					Value: to.Ptr("StorageTarget"),
		// 																			}},
		// 																			DisplayDescription: to.Ptr("The average round trip latency of all the file operations the Cache sends to a partricular StorageTarget."),
		// 																			ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetLatency"),
		// 																			IsDimensionRequired: to.Ptr(false),
		// 																			MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT1M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT5M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT15M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT30M"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT1H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT6H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("PT12H"),
		// 																				},
		// 																				{
		// 																					Retention: to.Ptr("P93D"),
		// 																					TimeGrain: to.Ptr("P1D"),
		// 																			}},
		// 																			MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																			Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																			PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																			ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																			SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																				to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																				to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																				to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																				Unit: to.Ptr(armmonitor.MetricUnitMilliSeconds),
		// 																			},
		// 																			{
		// 																				Name: &armmonitor.LocalizableString{
		// 																					LocalizedValue: to.Ptr("StorageTarget Metadata Read IOPS"),
		// 																					Value: to.Ptr("StorageTargetMetadataReadIOPS"),
		// 																				},
		// 																				Dimensions: []*armmonitor.LocalizableString{
		// 																					{
		// 																						LocalizedValue: to.Ptr("StorageTarget"),
		// 																						Value: to.Ptr("StorageTarget"),
		// 																				}},
		// 																				DisplayDescription: to.Ptr("The rate of file operations that do not modify persistent state, and excluding the read operation, that the Cache sends to a particular StorageTarget."),
		// 																				ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetMetadataReadIOPS"),
		// 																				IsDimensionRequired: to.Ptr(false),
		// 																				MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT1M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT5M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT15M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT30M"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT1H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT6H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("PT12H"),
		// 																					},
		// 																					{
		// 																						Retention: to.Ptr("P93D"),
		// 																						TimeGrain: to.Ptr("P1D"),
		// 																				}},
		// 																				MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																				Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																				PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																				ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																				SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																					to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																					to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																					to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																					Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																				},
		// 																				{
		// 																					Name: &armmonitor.LocalizableString{
		// 																						LocalizedValue: to.Ptr("StorageTarget Metadata Write IOPS"),
		// 																						Value: to.Ptr("StorageTargetMetadataWriteIOPS"),
		// 																					},
		// 																					Dimensions: []*armmonitor.LocalizableString{
		// 																						{
		// 																							LocalizedValue: to.Ptr("StorageTarget"),
		// 																							Value: to.Ptr("StorageTarget"),
		// 																					}},
		// 																					DisplayDescription: to.Ptr("The rate of file operations that do modify persistent state and excluding the write operation, that the Cache sends to a particular StorageTarget."),
		// 																					ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetMetadataWriteIOPS"),
		// 																					IsDimensionRequired: to.Ptr(false),
		// 																					MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT1M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT5M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT15M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT30M"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT1H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT6H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("PT12H"),
		// 																						},
		// 																						{
		// 																							Retention: to.Ptr("P93D"),
		// 																							TimeGrain: to.Ptr("P1D"),
		// 																					}},
		// 																					MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																					Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																					PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																					ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																					SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																						to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																						to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																						to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																						Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																					},
		// 																					{
		// 																						Name: &armmonitor.LocalizableString{
		// 																							LocalizedValue: to.Ptr("StorageTarget Read IOPS"),
		// 																							Value: to.Ptr("StorageTargetReadIOPS"),
		// 																						},
		// 																						Dimensions: []*armmonitor.LocalizableString{
		// 																							{
		// 																								LocalizedValue: to.Ptr("StorageTarget"),
		// 																								Value: to.Ptr("StorageTarget"),
		// 																						}},
		// 																						DisplayDescription: to.Ptr("The rate of file read operations the Cache sends to a particular StorageTarget."),
		// 																						ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetReadIOPS"),
		// 																						IsDimensionRequired: to.Ptr(false),
		// 																						MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT1M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT5M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT15M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT30M"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT1H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT6H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("PT12H"),
		// 																							},
		// 																							{
		// 																								Retention: to.Ptr("P93D"),
		// 																								TimeGrain: to.Ptr("P1D"),
		// 																						}},
		// 																						MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																						Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																						PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																						ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																						SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																							to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																							to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																							to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																							Unit: to.Ptr(armmonitor.MetricUnitCountPerSecond),
		// 																						},
		// 																						{
		// 																							Name: &armmonitor.LocalizableString{
		// 																								LocalizedValue: to.Ptr("StorageTarget Read Ahead Throughput"),
		// 																								Value: to.Ptr("StorageTargetReadAheadThroughput"),
		// 																							},
		// 																							Dimensions: []*armmonitor.LocalizableString{
		// 																								{
		// 																									LocalizedValue: to.Ptr("StorageTarget"),
		// 																									Value: to.Ptr("StorageTarget"),
		// 																							}},
		// 																							DisplayDescription: to.Ptr("The rate the Cache opportunisticly reads data from the StorageTarget."),
		// 																							ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetReadAheadThroughput"),
		// 																							IsDimensionRequired: to.Ptr(false),
		// 																							MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT1M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT5M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT15M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT30M"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT1H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT6H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("PT12H"),
		// 																								},
		// 																								{
		// 																									Retention: to.Ptr("P93D"),
		// 																									TimeGrain: to.Ptr("P1D"),
		// 																							}},
		// 																							MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																							Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																							PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																							ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																							SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																								to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																								to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																								to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																								Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																							},
		// 																							{
		// 																								Name: &armmonitor.LocalizableString{
		// 																									LocalizedValue: to.Ptr("StorageTarget Fill Throughput"),
		// 																									Value: to.Ptr("StorageTargetFillThroughput"),
		// 																								},
		// 																								Dimensions: []*armmonitor.LocalizableString{
		// 																									{
		// 																										LocalizedValue: to.Ptr("StorageTarget"),
		// 																										Value: to.Ptr("StorageTarget"),
		// 																								}},
		// 																								DisplayDescription: to.Ptr("The rate the Cache reads data from the StorageTarget to handle a cache miss."),
		// 																								ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetFillThroughput"),
		// 																								IsDimensionRequired: to.Ptr(false),
		// 																								MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT1M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT5M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT15M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT30M"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT1H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT6H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("PT12H"),
		// 																									},
		// 																									{
		// 																										Retention: to.Ptr("P93D"),
		// 																										TimeGrain: to.Ptr("P1D"),
		// 																								}},
		// 																								MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																								Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																								PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																								ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																								SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																									to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																									to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																									to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																									Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																								},
		// 																								{
		// 																									Name: &armmonitor.LocalizableString{
		// 																										LocalizedValue: to.Ptr("StorageTarget Total Read Throughput"),
		// 																										Value: to.Ptr("StorageTargetTotalReadThroughput"),
		// 																									},
		// 																									Dimensions: []*armmonitor.LocalizableString{
		// 																										{
		// 																											LocalizedValue: to.Ptr("StorageTarget"),
		// 																											Value: to.Ptr("StorageTarget"),
		// 																									}},
		// 																									DisplayDescription: to.Ptr("The total rate that the Cache reads data from a particular StorageTarget."),
		// 																									ID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache/providers/microsoft.insights/metricdefinitions/StorageTargetTotalReadThroughput"),
		// 																									IsDimensionRequired: to.Ptr(false),
		// 																									MetricAvailabilities: []*armmonitor.MetricAvailability{
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT1M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT5M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT15M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT30M"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT1H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT6H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("PT12H"),
		// 																										},
		// 																										{
		// 																											Retention: to.Ptr("P93D"),
		// 																											TimeGrain: to.Ptr("P1D"),
		// 																									}},
		// 																									MetricClass: to.Ptr(armmonitor.MetricClassTransactions),
		// 																									Namespace: to.Ptr("microsoft.storagecache/caches"),
		// 																									PrimaryAggregationType: to.Ptr(armmonitor.AggregationTypeAverage),
		// 																									ResourceID: to.Ptr("/subscriptions/46841c0e-69c8-4b17-af46-6626ecb15fc2/resourceGroups/adgarntptestrg/providers/Microsoft.StorageCache/caches/adgarntptestcache"),
		// 																									SupportedAggregationTypes: []*armmonitor.AggregationType{
		// 																										to.Ptr(armmonitor.AggregationTypeMinimum),
		// 																										to.Ptr(armmonitor.AggregationTypeMaximum),
		// 																										to.Ptr(armmonitor.AggregationTypeAverage)},
		// 																										Unit: to.Ptr(armmonitor.MetricUnitBytesPerSecond),
		// 																								}},
		// 																							}
	}
}
