//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AcsChatChannel.
func (a AcsChatChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "AcsChatChannel"
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AcsChatChannel.
func (a *AcsChatChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &a.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlexaChannel.
func (a AlexaChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "AlexaChannel"
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlexaChannel.
func (a *AlexaChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &a.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlexaChannelProperties.
func (a AlexaChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alexaSkillId", a.AlexaSkillID)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "serviceEndpointUri", a.ServiceEndpointURI)
	populate(objectMap, "urlFragment", a.URLFragment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlexaChannelProperties.
func (a *AlexaChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alexaSkillId":
			err = unpopulate(val, "AlexaSkillID", &a.AlexaSkillID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "serviceEndpointUri":
			err = unpopulate(val, "ServiceEndpointURI", &a.ServiceEndpointURI)
			delete(rawMsg, key)
		case "urlFragment":
			err = unpopulate(val, "URLFragment", &a.URLFragment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Bot.
func (b Bot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	populate(objectMap, "zones", b.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Bot.
func (b *Bot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &b.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BotChannel.
func (b BotChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	populate(objectMap, "zones", b.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BotChannel.
func (b *BotChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalChannelClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &b.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BotProperties.
func (b BotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allSettings", b.AllSettings)
	populate(objectMap, "appPasswordHint", b.AppPasswordHint)
	populate(objectMap, "cmekEncryptionStatus", b.CmekEncryptionStatus)
	populate(objectMap, "cmekKeyVaultUrl", b.CmekKeyVaultURL)
	populate(objectMap, "configuredChannels", b.ConfiguredChannels)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "developerAppInsightKey", b.DeveloperAppInsightKey)
	populate(objectMap, "developerAppInsightsApiKey", b.DeveloperAppInsightsAPIKey)
	populate(objectMap, "developerAppInsightsApplicationId", b.DeveloperAppInsightsApplicationID)
	populate(objectMap, "disableLocalAuth", b.DisableLocalAuth)
	populate(objectMap, "displayName", b.DisplayName)
	populate(objectMap, "enabledChannels", b.EnabledChannels)
	populate(objectMap, "endpoint", b.Endpoint)
	populate(objectMap, "endpointVersion", b.EndpointVersion)
	populate(objectMap, "iconUrl", b.IconURL)
	populate(objectMap, "isCmekEnabled", b.IsCmekEnabled)
	populate(objectMap, "isDeveloperAppInsightsApiKeySet", b.IsDeveloperAppInsightsAPIKeySet)
	populate(objectMap, "isStreamingSupported", b.IsStreamingSupported)
	populate(objectMap, "luisAppIds", b.LuisAppIDs)
	populate(objectMap, "luisKey", b.LuisKey)
	populate(objectMap, "manifestUrl", b.ManifestURL)
	populate(objectMap, "migrationToken", b.MigrationToken)
	populate(objectMap, "msaAppId", b.MsaAppID)
	populate(objectMap, "msaAppMSIResourceId", b.MsaAppMSIResourceID)
	populate(objectMap, "msaAppTenantId", b.MsaAppTenantID)
	populate(objectMap, "msaAppType", b.MsaAppType)
	populate(objectMap, "openWithHint", b.OpenWithHint)
	populate(objectMap, "parameters", b.Parameters)
	populate(objectMap, "privateEndpointConnections", b.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", b.PublicNetworkAccess)
	populate(objectMap, "publishingCredentials", b.PublishingCredentials)
	populate(objectMap, "schemaTransformationVersion", b.SchemaTransformationVersion)
	populate(objectMap, "storageResourceId", b.StorageResourceID)
	populate(objectMap, "tenantId", b.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BotProperties.
func (b *BotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allSettings":
			err = unpopulate(val, "AllSettings", &b.AllSettings)
			delete(rawMsg, key)
		case "appPasswordHint":
			err = unpopulate(val, "AppPasswordHint", &b.AppPasswordHint)
			delete(rawMsg, key)
		case "cmekEncryptionStatus":
			err = unpopulate(val, "CmekEncryptionStatus", &b.CmekEncryptionStatus)
			delete(rawMsg, key)
		case "cmekKeyVaultUrl":
			err = unpopulate(val, "CmekKeyVaultURL", &b.CmekKeyVaultURL)
			delete(rawMsg, key)
		case "configuredChannels":
			err = unpopulate(val, "ConfiguredChannels", &b.ConfiguredChannels)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "developerAppInsightKey":
			err = unpopulate(val, "DeveloperAppInsightKey", &b.DeveloperAppInsightKey)
			delete(rawMsg, key)
		case "developerAppInsightsApiKey":
			err = unpopulate(val, "DeveloperAppInsightsAPIKey", &b.DeveloperAppInsightsAPIKey)
			delete(rawMsg, key)
		case "developerAppInsightsApplicationId":
			err = unpopulate(val, "DeveloperAppInsightsApplicationID", &b.DeveloperAppInsightsApplicationID)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &b.DisableLocalAuth)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &b.DisplayName)
			delete(rawMsg, key)
		case "enabledChannels":
			err = unpopulate(val, "EnabledChannels", &b.EnabledChannels)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &b.Endpoint)
			delete(rawMsg, key)
		case "endpointVersion":
			err = unpopulate(val, "EndpointVersion", &b.EndpointVersion)
			delete(rawMsg, key)
		case "iconUrl":
			err = unpopulate(val, "IconURL", &b.IconURL)
			delete(rawMsg, key)
		case "isCmekEnabled":
			err = unpopulate(val, "IsCmekEnabled", &b.IsCmekEnabled)
			delete(rawMsg, key)
		case "isDeveloperAppInsightsApiKeySet":
			err = unpopulate(val, "IsDeveloperAppInsightsAPIKeySet", &b.IsDeveloperAppInsightsAPIKeySet)
			delete(rawMsg, key)
		case "isStreamingSupported":
			err = unpopulate(val, "IsStreamingSupported", &b.IsStreamingSupported)
			delete(rawMsg, key)
		case "luisAppIds":
			err = unpopulate(val, "LuisAppIDs", &b.LuisAppIDs)
			delete(rawMsg, key)
		case "luisKey":
			err = unpopulate(val, "LuisKey", &b.LuisKey)
			delete(rawMsg, key)
		case "manifestUrl":
			err = unpopulate(val, "ManifestURL", &b.ManifestURL)
			delete(rawMsg, key)
		case "migrationToken":
			err = unpopulate(val, "MigrationToken", &b.MigrationToken)
			delete(rawMsg, key)
		case "msaAppId":
			err = unpopulate(val, "MsaAppID", &b.MsaAppID)
			delete(rawMsg, key)
		case "msaAppMSIResourceId":
			err = unpopulate(val, "MsaAppMSIResourceID", &b.MsaAppMSIResourceID)
			delete(rawMsg, key)
		case "msaAppTenantId":
			err = unpopulate(val, "MsaAppTenantID", &b.MsaAppTenantID)
			delete(rawMsg, key)
		case "msaAppType":
			err = unpopulate(val, "MsaAppType", &b.MsaAppType)
			delete(rawMsg, key)
		case "openWithHint":
			err = unpopulate(val, "OpenWithHint", &b.OpenWithHint)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &b.Parameters)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &b.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &b.PublicNetworkAccess)
			delete(rawMsg, key)
		case "publishingCredentials":
			err = unpopulate(val, "PublishingCredentials", &b.PublishingCredentials)
			delete(rawMsg, key)
		case "schemaTransformationVersion":
			err = unpopulate(val, "SchemaTransformationVersion", &b.SchemaTransformationVersion)
			delete(rawMsg, key)
		case "storageResourceId":
			err = unpopulate(val, "StorageResourceID", &b.StorageResourceID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &b.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BotResponseList.
func (b BotResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BotResponseList.
func (b *BotResponseList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Channel.
func (c Channel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = c.ChannelName
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Channel.
func (c *Channel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &c.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChannelResponseList.
func (c ChannelResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChannelResponseList.
func (c *ChannelResponseList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChannelSettings.
func (c ChannelSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "botId", c.BotID)
	populate(objectMap, "botIconUrl", c.BotIconURL)
	populate(objectMap, "channelDisplayName", c.ChannelDisplayName)
	populate(objectMap, "channelId", c.ChannelID)
	populate(objectMap, "disableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "extensionKey1", c.ExtensionKey1)
	populate(objectMap, "extensionKey2", c.ExtensionKey2)
	populate(objectMap, "isEnabled", c.IsEnabled)
	populate(objectMap, "requireTermsAgreement", c.RequireTermsAgreement)
	populate(objectMap, "sites", c.Sites)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChannelSettings.
func (c *ChannelSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "botId":
			err = unpopulate(val, "BotID", &c.BotID)
			delete(rawMsg, key)
		case "botIconUrl":
			err = unpopulate(val, "BotIconURL", &c.BotIconURL)
			delete(rawMsg, key)
		case "channelDisplayName":
			err = unpopulate(val, "ChannelDisplayName", &c.ChannelDisplayName)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &c.ChannelID)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &c.DisableLocalAuth)
			delete(rawMsg, key)
		case "extensionKey1":
			err = unpopulate(val, "ExtensionKey1", &c.ExtensionKey1)
			delete(rawMsg, key)
		case "extensionKey2":
			err = unpopulate(val, "ExtensionKey2", &c.ExtensionKey2)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &c.IsEnabled)
			delete(rawMsg, key)
		case "requireTermsAgreement":
			err = unpopulate(val, "RequireTermsAgreement", &c.RequireTermsAgreement)
			delete(rawMsg, key)
		case "sites":
			err = unpopulate(val, "Sites", &c.Sites)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequestBody.
func (c CheckNameAvailabilityRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequestBody.
func (c *CheckNameAvailabilityRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResponseBody.
func (c CheckNameAvailabilityResponseBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "absCode", c.AbsCode)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "valid", c.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResponseBody.
func (c *CheckNameAvailabilityResponseBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "absCode":
			err = unpopulate(val, "AbsCode", &c.AbsCode)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &c.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionItemName.
func (c ConnectionItemName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionItemName.
func (c *ConnectionItemName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSetting.
func (c ConnectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionSetting.
func (c *ConnectionSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSettingParameter.
func (c ConnectionSettingParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", c.Key)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionSettingParameter.
func (c *ConnectionSettingParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &c.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSettingProperties.
func (c ConnectionSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "clientSecret", c.ClientSecret)
	populate(objectMap, "parameters", c.Parameters)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "scopes", c.Scopes)
	populate(objectMap, "serviceProviderDisplayName", c.ServiceProviderDisplayName)
	populate(objectMap, "serviceProviderId", c.ServiceProviderID)
	populate(objectMap, "settingId", c.SettingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionSettingProperties.
func (c *ConnectionSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &c.ClientSecret)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &c.Scopes)
			delete(rawMsg, key)
		case "serviceProviderDisplayName":
			err = unpopulate(val, "ServiceProviderDisplayName", &c.ServiceProviderDisplayName)
			delete(rawMsg, key)
		case "serviceProviderId":
			err = unpopulate(val, "ServiceProviderID", &c.ServiceProviderID)
			delete(rawMsg, key)
		case "settingId":
			err = unpopulate(val, "SettingID", &c.SettingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSettingResponseList.
func (c ConnectionSettingResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionSettingResponseList.
func (c *ConnectionSettingResponseList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateEmailSignInURLResponse.
func (c CreateEmailSignInURLResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateEmailSignInURLResponse.
func (c *CreateEmailSignInURLResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateEmailSignInURLResponseProperties.
func (c CreateEmailSignInURLResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "url", c.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateEmailSignInURLResponseProperties.
func (c *CreateEmailSignInURLResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "url":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineChannel.
func (d DirectLineChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "DirectLineChannel"
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineChannel.
func (d *DirectLineChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &d.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineChannelProperties.
func (d DirectLineChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "DirectLineEmbedCode", d.DirectLineEmbedCode)
	populate(objectMap, "extensionKey1", d.ExtensionKey1)
	populate(objectMap, "extensionKey2", d.ExtensionKey2)
	populate(objectMap, "sites", d.Sites)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineChannelProperties.
func (d *DirectLineChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "DirectLineEmbedCode":
			err = unpopulate(val, "DirectLineEmbedCode", &d.DirectLineEmbedCode)
			delete(rawMsg, key)
		case "extensionKey1":
			err = unpopulate(val, "ExtensionKey1", &d.ExtensionKey1)
			delete(rawMsg, key)
		case "extensionKey2":
			err = unpopulate(val, "ExtensionKey2", &d.ExtensionKey2)
			delete(rawMsg, key)
		case "sites":
			err = unpopulate(val, "Sites", &d.Sites)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineSite.
func (d DirectLineSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", d.AppID)
	populate(objectMap, "eTag", d.ETag)
	populate(objectMap, "isBlockUserUploadEnabled", d.IsBlockUserUploadEnabled)
	populate(objectMap, "isDetailedLoggingEnabled", d.IsDetailedLoggingEnabled)
	populate(objectMap, "isEnabled", d.IsEnabled)
	populate(objectMap, "isEndpointParametersEnabled", d.IsEndpointParametersEnabled)
	populate(objectMap, "isNoStorageEnabled", d.IsNoStorageEnabled)
	populate(objectMap, "isSecureSiteEnabled", d.IsSecureSiteEnabled)
	populate(objectMap, "isTokenEnabled", d.IsTokenEnabled)
	populate(objectMap, "isV1Enabled", d.IsV1Enabled)
	populate(objectMap, "isV3Enabled", d.IsV3Enabled)
	populate(objectMap, "isWebChatSpeechEnabled", d.IsWebChatSpeechEnabled)
	populate(objectMap, "isWebchatPreviewEnabled", d.IsWebchatPreviewEnabled)
	populate(objectMap, "key", d.Key)
	populate(objectMap, "key2", d.Key2)
	populate(objectMap, "siteId", d.SiteID)
	populate(objectMap, "siteName", d.SiteName)
	populate(objectMap, "tenantId", d.TenantID)
	populate(objectMap, "trustedOrigins", d.TrustedOrigins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineSite.
func (d *DirectLineSite) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &d.AppID)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &d.ETag)
			delete(rawMsg, key)
		case "isBlockUserUploadEnabled":
			err = unpopulate(val, "IsBlockUserUploadEnabled", &d.IsBlockUserUploadEnabled)
			delete(rawMsg, key)
		case "isDetailedLoggingEnabled":
			err = unpopulate(val, "IsDetailedLoggingEnabled", &d.IsDetailedLoggingEnabled)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &d.IsEnabled)
			delete(rawMsg, key)
		case "isEndpointParametersEnabled":
			err = unpopulate(val, "IsEndpointParametersEnabled", &d.IsEndpointParametersEnabled)
			delete(rawMsg, key)
		case "isNoStorageEnabled":
			err = unpopulate(val, "IsNoStorageEnabled", &d.IsNoStorageEnabled)
			delete(rawMsg, key)
		case "isSecureSiteEnabled":
			err = unpopulate(val, "IsSecureSiteEnabled", &d.IsSecureSiteEnabled)
			delete(rawMsg, key)
		case "isTokenEnabled":
			err = unpopulate(val, "IsTokenEnabled", &d.IsTokenEnabled)
			delete(rawMsg, key)
		case "isV1Enabled":
			err = unpopulate(val, "IsV1Enabled", &d.IsV1Enabled)
			delete(rawMsg, key)
		case "isV3Enabled":
			err = unpopulate(val, "IsV3Enabled", &d.IsV3Enabled)
			delete(rawMsg, key)
		case "isWebChatSpeechEnabled":
			err = unpopulate(val, "IsWebChatSpeechEnabled", &d.IsWebChatSpeechEnabled)
			delete(rawMsg, key)
		case "isWebchatPreviewEnabled":
			err = unpopulate(val, "IsWebchatPreviewEnabled", &d.IsWebchatPreviewEnabled)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &d.Key)
			delete(rawMsg, key)
		case "key2":
			err = unpopulate(val, "Key2", &d.Key2)
			delete(rawMsg, key)
		case "siteId":
			err = unpopulate(val, "SiteID", &d.SiteID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &d.SiteName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &d.TenantID)
			delete(rawMsg, key)
		case "trustedOrigins":
			err = unpopulate(val, "TrustedOrigins", &d.TrustedOrigins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineSpeechChannel.
func (d DirectLineSpeechChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "DirectLineSpeechChannel"
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineSpeechChannel.
func (d *DirectLineSpeechChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &d.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineSpeechChannelProperties.
func (d DirectLineSpeechChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cognitiveServiceRegion", d.CognitiveServiceRegion)
	populate(objectMap, "cognitiveServiceResourceId", d.CognitiveServiceResourceID)
	populate(objectMap, "cognitiveServiceSubscriptionKey", d.CognitiveServiceSubscriptionKey)
	populate(objectMap, "customSpeechModelId", d.CustomSpeechModelID)
	populate(objectMap, "customVoiceDeploymentId", d.CustomVoiceDeploymentID)
	populate(objectMap, "isDefaultBotForCogSvcAccount", d.IsDefaultBotForCogSvcAccount)
	populate(objectMap, "isEnabled", d.IsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineSpeechChannelProperties.
func (d *DirectLineSpeechChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cognitiveServiceRegion":
			err = unpopulate(val, "CognitiveServiceRegion", &d.CognitiveServiceRegion)
			delete(rawMsg, key)
		case "cognitiveServiceResourceId":
			err = unpopulate(val, "CognitiveServiceResourceID", &d.CognitiveServiceResourceID)
			delete(rawMsg, key)
		case "cognitiveServiceSubscriptionKey":
			err = unpopulate(val, "CognitiveServiceSubscriptionKey", &d.CognitiveServiceSubscriptionKey)
			delete(rawMsg, key)
		case "customSpeechModelId":
			err = unpopulate(val, "CustomSpeechModelID", &d.CustomSpeechModelID)
			delete(rawMsg, key)
		case "customVoiceDeploymentId":
			err = unpopulate(val, "CustomVoiceDeploymentID", &d.CustomVoiceDeploymentID)
			delete(rawMsg, key)
		case "isDefaultBotForCogSvcAccount":
			err = unpopulate(val, "IsDefaultBotForCogSvcAccount", &d.IsDefaultBotForCogSvcAccount)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &d.IsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailChannel.
func (e EmailChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "EmailChannel"
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailChannel.
func (e *EmailChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &e.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailChannelProperties.
func (e EmailChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authMethod", e.AuthMethod)
	populate(objectMap, "emailAddress", e.EmailAddress)
	populate(objectMap, "isEnabled", e.IsEnabled)
	populate(objectMap, "magicCode", e.MagicCode)
	populate(objectMap, "password", e.Password)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailChannelProperties.
func (e *EmailChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authMethod":
			err = unpopulate(val, "AuthMethod", &e.AuthMethod)
			delete(rawMsg, key)
		case "emailAddress":
			err = unpopulate(val, "EmailAddress", &e.EmailAddress)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &e.IsEnabled)
			delete(rawMsg, key)
		case "magicCode":
			err = unpopulate(val, "MagicCode", &e.MagicCode)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &e.Password)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorBody.
func (e ErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorBody.
func (e *ErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FacebookChannel.
func (f FacebookChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "FacebookChannel"
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FacebookChannel.
func (f *FacebookChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &f.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FacebookChannelProperties.
func (f FacebookChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", f.AppID)
	populate(objectMap, "appSecret", f.AppSecret)
	populate(objectMap, "callbackUrl", f.CallbackURL)
	populate(objectMap, "isEnabled", f.IsEnabled)
	populate(objectMap, "pages", f.Pages)
	populate(objectMap, "verifyToken", f.VerifyToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FacebookChannelProperties.
func (f *FacebookChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &f.AppID)
			delete(rawMsg, key)
		case "appSecret":
			err = unpopulate(val, "AppSecret", &f.AppSecret)
			delete(rawMsg, key)
		case "callbackUrl":
			err = unpopulate(val, "CallbackURL", &f.CallbackURL)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &f.IsEnabled)
			delete(rawMsg, key)
		case "pages":
			err = unpopulate(val, "Pages", &f.Pages)
			delete(rawMsg, key)
		case "verifyToken":
			err = unpopulate(val, "VerifyToken", &f.VerifyToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FacebookPage.
func (f FacebookPage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", f.AccessToken)
	populate(objectMap, "id", f.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FacebookPage.
func (f *FacebookPage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &f.AccessToken)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostSettingsResponse.
func (h HostSettingsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "BotOpenIdMetadata", h.BotOpenIDMetadata)
	populate(objectMap, "OAuthUrl", h.OAuthURL)
	populate(objectMap, "ToBotFromChannelOpenIdMetadataUrl", h.ToBotFromChannelOpenIDMetadataURL)
	populate(objectMap, "ToBotFromChannelTokenIssuer", h.ToBotFromChannelTokenIssuer)
	populate(objectMap, "ToBotFromEmulatorOpenIdMetadataUrl", h.ToBotFromEmulatorOpenIDMetadataURL)
	populate(objectMap, "ToChannelFromBotLoginUrl", h.ToChannelFromBotLoginURL)
	populate(objectMap, "ToChannelFromBotOAuthScope", h.ToChannelFromBotOAuthScope)
	populate(objectMap, "ValidateAuthority", h.ValidateAuthority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostSettingsResponse.
func (h *HostSettingsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "BotOpenIdMetadata":
			err = unpopulate(val, "BotOpenIDMetadata", &h.BotOpenIDMetadata)
			delete(rawMsg, key)
		case "OAuthUrl":
			err = unpopulate(val, "OAuthURL", &h.OAuthURL)
			delete(rawMsg, key)
		case "ToBotFromChannelOpenIdMetadataUrl":
			err = unpopulate(val, "ToBotFromChannelOpenIDMetadataURL", &h.ToBotFromChannelOpenIDMetadataURL)
			delete(rawMsg, key)
		case "ToBotFromChannelTokenIssuer":
			err = unpopulate(val, "ToBotFromChannelTokenIssuer", &h.ToBotFromChannelTokenIssuer)
			delete(rawMsg, key)
		case "ToBotFromEmulatorOpenIdMetadataUrl":
			err = unpopulate(val, "ToBotFromEmulatorOpenIDMetadataURL", &h.ToBotFromEmulatorOpenIDMetadataURL)
			delete(rawMsg, key)
		case "ToChannelFromBotLoginUrl":
			err = unpopulate(val, "ToChannelFromBotLoginURL", &h.ToChannelFromBotLoginURL)
			delete(rawMsg, key)
		case "ToChannelFromBotOAuthScope":
			err = unpopulate(val, "ToChannelFromBotOAuthScope", &h.ToChannelFromBotOAuthScope)
			delete(rawMsg, key)
		case "ValidateAuthority":
			err = unpopulate(val, "ValidateAuthority", &h.ValidateAuthority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KikChannel.
func (k KikChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "KikChannel"
	populate(objectMap, "etag", k.Etag)
	populate(objectMap, "location", k.Location)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KikChannel.
func (k *KikChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &k.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &k.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &k.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KikChannelProperties.
func (k KikChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiKey", k.APIKey)
	populate(objectMap, "isEnabled", k.IsEnabled)
	populate(objectMap, "isValidated", k.IsValidated)
	populate(objectMap, "userName", k.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KikChannelProperties.
func (k *KikChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiKey":
			err = unpopulate(val, "APIKey", &k.APIKey)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &k.IsEnabled)
			delete(rawMsg, key)
		case "isValidated":
			err = unpopulate(val, "IsValidated", &k.IsValidated)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &k.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LineChannel.
func (l LineChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "LineChannel"
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LineChannel.
func (l *LineChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &l.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LineChannelProperties.
func (l LineChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "callbackUrl", l.CallbackURL)
	populate(objectMap, "isValidated", l.IsValidated)
	populate(objectMap, "lineRegistrations", l.LineRegistrations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LineChannelProperties.
func (l *LineChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "callbackUrl":
			err = unpopulate(val, "CallbackURL", &l.CallbackURL)
			delete(rawMsg, key)
		case "isValidated":
			err = unpopulate(val, "IsValidated", &l.IsValidated)
			delete(rawMsg, key)
		case "lineRegistrations":
			err = unpopulate(val, "LineRegistrations", &l.LineRegistrations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LineRegistration.
func (l LineRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelAccessToken", l.ChannelAccessToken)
	populate(objectMap, "channelSecret", l.ChannelSecret)
	populate(objectMap, "generatedId", l.GeneratedID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LineRegistration.
func (l *LineRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelAccessToken":
			err = unpopulate(val, "ChannelAccessToken", &l.ChannelAccessToken)
			delete(rawMsg, key)
		case "channelSecret":
			err = unpopulate(val, "ChannelSecret", &l.ChannelSecret)
			delete(rawMsg, key)
		case "generatedId":
			err = unpopulate(val, "GeneratedID", &l.GeneratedID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListChannelWithKeysResponse.
func (l ListChannelWithKeysResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "changedTime", l.ChangedTime)
	populate(objectMap, "entityTag", l.EntityTag)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "kind", l.Kind)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resource", l.Resource)
	populate(objectMap, "sku", l.SKU)
	populate(objectMap, "setting", l.Setting)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	populate(objectMap, "zones", l.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListChannelWithKeysResponse.
func (l *ListChannelWithKeysResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulate(val, "ChangedTime", &l.ChangedTime)
			delete(rawMsg, key)
		case "entityTag":
			err = unpopulate(val, "EntityTag", &l.EntityTag)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			l.Properties, err = unmarshalChannelClassification(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resource":
			l.Resource, err = unmarshalChannelClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "setting":
			err = unpopulate(val, "Setting", &l.Setting)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &l.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type M365Extensions.
func (m M365Extensions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "M365Extensions"
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type M365Extensions.
func (m *M365Extensions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &m.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MsTeamsChannel.
func (m MsTeamsChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "MsTeamsChannel"
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MsTeamsChannel.
func (m *MsTeamsChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &m.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MsTeamsChannelProperties.
func (m MsTeamsChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceptedTerms", m.AcceptedTerms)
	populate(objectMap, "callingWebhook", m.CallingWebhook)
	populate(objectMap, "deploymentEnvironment", m.DeploymentEnvironment)
	populate(objectMap, "enableCalling", m.EnableCalling)
	populate(objectMap, "incomingCallRoute", m.IncomingCallRoute)
	populate(objectMap, "isEnabled", m.IsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MsTeamsChannelProperties.
func (m *MsTeamsChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceptedTerms":
			err = unpopulate(val, "AcceptedTerms", &m.AcceptedTerms)
			delete(rawMsg, key)
		case "callingWebhook":
			err = unpopulate(val, "CallingWebhook", &m.CallingWebhook)
			delete(rawMsg, key)
		case "deploymentEnvironment":
			err = unpopulate(val, "DeploymentEnvironment", &m.DeploymentEnvironment)
			delete(rawMsg, key)
		case "enableCalling":
			err = unpopulate(val, "EnableCalling", &m.EnableCalling)
			delete(rawMsg, key)
		case "incomingCallRoute":
			err = unpopulate(val, "IncomingCallRoute", &m.IncomingCallRoute)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &m.IsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Omnichannel.
func (o Omnichannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "Omnichannel"
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Omnichannel.
func (o *Omnichannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &o.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplayInfo.
func (o OperationDisplayInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplayInfo.
func (o *OperationDisplayInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntity.
func (o OperationEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntity.
func (o *OperationEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntityListResult.
func (o OperationEntityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntityListResult.
func (o *OperationEntityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultsDescription.
func (o OperationResultsDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultsDescription.
func (o *OperationResultsDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutlookChannel.
func (o OutlookChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "OutlookChannel"
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutlookChannel.
func (o *OutlookChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &o.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &p.GroupIDs)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceBase.
func (p PrivateLinkResourceBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceBase.
func (p *PrivateLinkResourceBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QnAMakerEndpointKeysRequestBody.
func (q QnAMakerEndpointKeysRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authkey", q.Authkey)
	populate(objectMap, "hostname", q.Hostname)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QnAMakerEndpointKeysRequestBody.
func (q *QnAMakerEndpointKeysRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authkey":
			err = unpopulate(val, "Authkey", &q.Authkey)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &q.Hostname)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QnAMakerEndpointKeysResponse.
func (q QnAMakerEndpointKeysResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "installedVersion", q.InstalledVersion)
	populate(objectMap, "lastStableVersion", q.LastStableVersion)
	populate(objectMap, "primaryEndpointKey", q.PrimaryEndpointKey)
	populate(objectMap, "secondaryEndpointKey", q.SecondaryEndpointKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QnAMakerEndpointKeysResponse.
func (q *QnAMakerEndpointKeysResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "installedVersion":
			err = unpopulate(val, "InstalledVersion", &q.InstalledVersion)
			delete(rawMsg, key)
		case "lastStableVersion":
			err = unpopulate(val, "LastStableVersion", &q.LastStableVersion)
			delete(rawMsg, key)
		case "primaryEndpointKey":
			err = unpopulate(val, "PrimaryEndpointKey", &q.PrimaryEndpointKey)
			delete(rawMsg, key)
		case "secondaryEndpointKey":
			err = unpopulate(val, "SecondaryEndpointKey", &q.SecondaryEndpointKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &r.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SearchAssistant.
func (s SearchAssistant) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "SearchAssistant"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SearchAssistant.
func (s *SearchAssistant) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProvider.
func (s ServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProvider.
func (s *ServiceProvider) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProviderParameter.
func (s ServiceProviderParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "helpUrl", s.HelpURL)
	populate(objectMap, "metadata", s.Metadata)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProviderParameter.
func (s *ServiceProviderParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "helpUrl":
			err = unpopulate(val, "HelpURL", &s.HelpURL)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &s.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProviderParameterMetadata.
func (s ServiceProviderParameterMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "constraints", s.Constraints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProviderParameterMetadata.
func (s *ServiceProviderParameterMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "constraints":
			err = unpopulate(val, "Constraints", &s.Constraints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProviderParameterMetadataConstraints.
func (s ServiceProviderParameterMetadataConstraints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "required", s.Required)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProviderParameterMetadataConstraints.
func (s *ServiceProviderParameterMetadataConstraints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "required":
			err = unpopulate(val, "Required", &s.Required)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProviderProperties.
func (s ServiceProviderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "devPortalUrl", s.DevPortalURL)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "iconUrl", s.IconURL)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "serviceProviderName", s.ServiceProviderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProviderProperties.
func (s *ServiceProviderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "devPortalUrl":
			err = unpopulate(val, "DevPortalURL", &s.DevPortalURL)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "iconUrl":
			err = unpopulate(val, "IconURL", &s.IconURL)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "serviceProviderName":
			err = unpopulate(val, "ServiceProviderName", &s.ServiceProviderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProviderResponseList.
func (s ServiceProviderResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProviderResponseList.
func (s *ServiceProviderResponseList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", s.AppID)
	populate(objectMap, "eTag", s.ETag)
	populate(objectMap, "isBlockUserUploadEnabled", s.IsBlockUserUploadEnabled)
	populate(objectMap, "isDetailedLoggingEnabled", s.IsDetailedLoggingEnabled)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populate(objectMap, "isEndpointParametersEnabled", s.IsEndpointParametersEnabled)
	populate(objectMap, "isNoStorageEnabled", s.IsNoStorageEnabled)
	populate(objectMap, "isSecureSiteEnabled", s.IsSecureSiteEnabled)
	populate(objectMap, "isTokenEnabled", s.IsTokenEnabled)
	populate(objectMap, "isV1Enabled", s.IsV1Enabled)
	populate(objectMap, "isV3Enabled", s.IsV3Enabled)
	populate(objectMap, "isWebChatSpeechEnabled", s.IsWebChatSpeechEnabled)
	populate(objectMap, "isWebchatPreviewEnabled", s.IsWebchatPreviewEnabled)
	populate(objectMap, "key", s.Key)
	populate(objectMap, "key2", s.Key2)
	populate(objectMap, "siteId", s.SiteID)
	populate(objectMap, "siteName", s.SiteName)
	populate(objectMap, "tenantId", s.TenantID)
	populate(objectMap, "trustedOrigins", s.TrustedOrigins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Site.
func (s *Site) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &s.AppID)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &s.ETag)
			delete(rawMsg, key)
		case "isBlockUserUploadEnabled":
			err = unpopulate(val, "IsBlockUserUploadEnabled", &s.IsBlockUserUploadEnabled)
			delete(rawMsg, key)
		case "isDetailedLoggingEnabled":
			err = unpopulate(val, "IsDetailedLoggingEnabled", &s.IsDetailedLoggingEnabled)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		case "isEndpointParametersEnabled":
			err = unpopulate(val, "IsEndpointParametersEnabled", &s.IsEndpointParametersEnabled)
			delete(rawMsg, key)
		case "isNoStorageEnabled":
			err = unpopulate(val, "IsNoStorageEnabled", &s.IsNoStorageEnabled)
			delete(rawMsg, key)
		case "isSecureSiteEnabled":
			err = unpopulate(val, "IsSecureSiteEnabled", &s.IsSecureSiteEnabled)
			delete(rawMsg, key)
		case "isTokenEnabled":
			err = unpopulate(val, "IsTokenEnabled", &s.IsTokenEnabled)
			delete(rawMsg, key)
		case "isV1Enabled":
			err = unpopulate(val, "IsV1Enabled", &s.IsV1Enabled)
			delete(rawMsg, key)
		case "isV3Enabled":
			err = unpopulate(val, "IsV3Enabled", &s.IsV3Enabled)
			delete(rawMsg, key)
		case "isWebChatSpeechEnabled":
			err = unpopulate(val, "IsWebChatSpeechEnabled", &s.IsWebChatSpeechEnabled)
			delete(rawMsg, key)
		case "isWebchatPreviewEnabled":
			err = unpopulate(val, "IsWebchatPreviewEnabled", &s.IsWebchatPreviewEnabled)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "key2":
			err = unpopulate(val, "Key2", &s.Key2)
			delete(rawMsg, key)
		case "siteId":
			err = unpopulate(val, "SiteID", &s.SiteID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &s.SiteName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		case "trustedOrigins":
			err = unpopulate(val, "TrustedOrigins", &s.TrustedOrigins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteInfo.
func (s SiteInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", s.Key)
	populate(objectMap, "siteName", s.SiteName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteInfo.
func (s *SiteInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &s.SiteName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SkypeChannel.
func (s SkypeChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "SkypeChannel"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SkypeChannel.
func (s *SkypeChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SkypeChannelProperties.
func (s SkypeChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "callingWebHook", s.CallingWebHook)
	populate(objectMap, "enableCalling", s.EnableCalling)
	populate(objectMap, "enableGroups", s.EnableGroups)
	populate(objectMap, "enableMediaCards", s.EnableMediaCards)
	populate(objectMap, "enableMessaging", s.EnableMessaging)
	populate(objectMap, "enableScreenSharing", s.EnableScreenSharing)
	populate(objectMap, "enableVideo", s.EnableVideo)
	populate(objectMap, "groupsMode", s.GroupsMode)
	populate(objectMap, "incomingCallRoute", s.IncomingCallRoute)
	populate(objectMap, "isEnabled", s.IsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SkypeChannelProperties.
func (s *SkypeChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "callingWebHook":
			err = unpopulate(val, "CallingWebHook", &s.CallingWebHook)
			delete(rawMsg, key)
		case "enableCalling":
			err = unpopulate(val, "EnableCalling", &s.EnableCalling)
			delete(rawMsg, key)
		case "enableGroups":
			err = unpopulate(val, "EnableGroups", &s.EnableGroups)
			delete(rawMsg, key)
		case "enableMediaCards":
			err = unpopulate(val, "EnableMediaCards", &s.EnableMediaCards)
			delete(rawMsg, key)
		case "enableMessaging":
			err = unpopulate(val, "EnableMessaging", &s.EnableMessaging)
			delete(rawMsg, key)
		case "enableScreenSharing":
			err = unpopulate(val, "EnableScreenSharing", &s.EnableScreenSharing)
			delete(rawMsg, key)
		case "enableVideo":
			err = unpopulate(val, "EnableVideo", &s.EnableVideo)
			delete(rawMsg, key)
		case "groupsMode":
			err = unpopulate(val, "GroupsMode", &s.GroupsMode)
			delete(rawMsg, key)
		case "incomingCallRoute":
			err = unpopulate(val, "IncomingCallRoute", &s.IncomingCallRoute)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlackChannel.
func (s SlackChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "SlackChannel"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlackChannel.
func (s *SlackChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlackChannelProperties.
func (s SlackChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "clientSecret", s.ClientSecret)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populate(objectMap, "IsValidated", s.IsValidated)
	populate(objectMap, "landingPageUrl", s.LandingPageURL)
	populate(objectMap, "lastSubmissionId", s.LastSubmissionID)
	populate(objectMap, "redirectAction", s.RedirectAction)
	populate(objectMap, "registerBeforeOAuthFlow", s.RegisterBeforeOAuthFlow)
	populate(objectMap, "scopes", s.Scopes)
	populate(objectMap, "signingSecret", s.SigningSecret)
	populate(objectMap, "verificationToken", s.VerificationToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlackChannelProperties.
func (s *SlackChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &s.ClientSecret)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		case "IsValidated":
			err = unpopulate(val, "IsValidated", &s.IsValidated)
			delete(rawMsg, key)
		case "landingPageUrl":
			err = unpopulate(val, "LandingPageURL", &s.LandingPageURL)
			delete(rawMsg, key)
		case "lastSubmissionId":
			err = unpopulate(val, "LastSubmissionID", &s.LastSubmissionID)
			delete(rawMsg, key)
		case "redirectAction":
			err = unpopulate(val, "RedirectAction", &s.RedirectAction)
			delete(rawMsg, key)
		case "registerBeforeOAuthFlow":
			err = unpopulate(val, "RegisterBeforeOAuthFlow", &s.RegisterBeforeOAuthFlow)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &s.Scopes)
			delete(rawMsg, key)
		case "signingSecret":
			err = unpopulate(val, "SigningSecret", &s.SigningSecret)
			delete(rawMsg, key)
		case "verificationToken":
			err = unpopulate(val, "VerificationToken", &s.VerificationToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SmsChannel.
func (s SmsChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "SmsChannel"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SmsChannel.
func (s *SmsChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SmsChannelProperties.
func (s SmsChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountSID", s.AccountSID)
	populate(objectMap, "authToken", s.AuthToken)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populate(objectMap, "isValidated", s.IsValidated)
	populate(objectMap, "phone", s.Phone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SmsChannelProperties.
func (s *SmsChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountSID":
			err = unpopulate(val, "AccountSID", &s.AccountSID)
			delete(rawMsg, key)
		case "authToken":
			err = unpopulate(val, "AuthToken", &s.AuthToken)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		case "isValidated":
			err = unpopulate(val, "IsValidated", &s.IsValidated)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &s.Phone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelegramChannel.
func (t TelegramChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "TelegramChannel"
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelegramChannel.
func (t *TelegramChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &t.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelegramChannelProperties.
func (t TelegramChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", t.AccessToken)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "isValidated", t.IsValidated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelegramChannelProperties.
func (t *TelegramChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &t.AccessToken)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "isValidated":
			err = unpopulate(val, "IsValidated", &t.IsValidated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelephonyChannel.
func (t TelephonyChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "TelephonyChannel"
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelephonyChannel.
func (t *TelephonyChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &t.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelephonyChannelProperties.
func (t TelephonyChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiConfigurations", t.APIConfigurations)
	populate(objectMap, "cognitiveServiceRegion", t.CognitiveServiceRegion)
	populate(objectMap, "cognitiveServiceSubscriptionKey", t.CognitiveServiceSubscriptionKey)
	populate(objectMap, "defaultLocale", t.DefaultLocale)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "phoneNumbers", t.PhoneNumbers)
	populate(objectMap, "premiumSKU", t.PremiumSKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelephonyChannelProperties.
func (t *TelephonyChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiConfigurations":
			err = unpopulate(val, "APIConfigurations", &t.APIConfigurations)
			delete(rawMsg, key)
		case "cognitiveServiceRegion":
			err = unpopulate(val, "CognitiveServiceRegion", &t.CognitiveServiceRegion)
			delete(rawMsg, key)
		case "cognitiveServiceSubscriptionKey":
			err = unpopulate(val, "CognitiveServiceSubscriptionKey", &t.CognitiveServiceSubscriptionKey)
			delete(rawMsg, key)
		case "defaultLocale":
			err = unpopulate(val, "DefaultLocale", &t.DefaultLocale)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "phoneNumbers":
			err = unpopulate(val, "PhoneNumbers", &t.PhoneNumbers)
			delete(rawMsg, key)
		case "premiumSKU":
			err = unpopulate(val, "PremiumSKU", &t.PremiumSKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelephonyChannelResourceAPIConfiguration.
func (t TelephonyChannelResourceAPIConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cognitiveServiceRegion", t.CognitiveServiceRegion)
	populate(objectMap, "cognitiveServiceResourceId", t.CognitiveServiceResourceID)
	populate(objectMap, "cognitiveServiceSubscriptionKey", t.CognitiveServiceSubscriptionKey)
	populate(objectMap, "defaultLocale", t.DefaultLocale)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "providerName", t.ProviderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelephonyChannelResourceAPIConfiguration.
func (t *TelephonyChannelResourceAPIConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cognitiveServiceRegion":
			err = unpopulate(val, "CognitiveServiceRegion", &t.CognitiveServiceRegion)
			delete(rawMsg, key)
		case "cognitiveServiceResourceId":
			err = unpopulate(val, "CognitiveServiceResourceID", &t.CognitiveServiceResourceID)
			delete(rawMsg, key)
		case "cognitiveServiceSubscriptionKey":
			err = unpopulate(val, "CognitiveServiceSubscriptionKey", &t.CognitiveServiceSubscriptionKey)
			delete(rawMsg, key)
		case "defaultLocale":
			err = unpopulate(val, "DefaultLocale", &t.DefaultLocale)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &t.ProviderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelephonyPhoneNumbers.
func (t TelephonyPhoneNumbers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acsEndpoint", t.AcsEndpoint)
	populate(objectMap, "acsResourceId", t.AcsResourceID)
	populate(objectMap, "acsSecret", t.AcsSecret)
	populate(objectMap, "cognitiveServiceRegion", t.CognitiveServiceRegion)
	populate(objectMap, "cognitiveServiceResourceId", t.CognitiveServiceResourceID)
	populate(objectMap, "cognitiveServiceSubscriptionKey", t.CognitiveServiceSubscriptionKey)
	populate(objectMap, "defaultLocale", t.DefaultLocale)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "offerType", t.OfferType)
	populate(objectMap, "phoneNumber", t.PhoneNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelephonyPhoneNumbers.
func (t *TelephonyPhoneNumbers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acsEndpoint":
			err = unpopulate(val, "AcsEndpoint", &t.AcsEndpoint)
			delete(rawMsg, key)
		case "acsResourceId":
			err = unpopulate(val, "AcsResourceID", &t.AcsResourceID)
			delete(rawMsg, key)
		case "acsSecret":
			err = unpopulate(val, "AcsSecret", &t.AcsSecret)
			delete(rawMsg, key)
		case "cognitiveServiceRegion":
			err = unpopulate(val, "CognitiveServiceRegion", &t.CognitiveServiceRegion)
			delete(rawMsg, key)
		case "cognitiveServiceResourceId":
			err = unpopulate(val, "CognitiveServiceResourceID", &t.CognitiveServiceResourceID)
			delete(rawMsg, key)
		case "cognitiveServiceSubscriptionKey":
			err = unpopulate(val, "CognitiveServiceSubscriptionKey", &t.CognitiveServiceSubscriptionKey)
			delete(rawMsg, key)
		case "defaultLocale":
			err = unpopulate(val, "DefaultLocale", &t.DefaultLocale)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "offerType":
			err = unpopulate(val, "OfferType", &t.OfferType)
			delete(rawMsg, key)
		case "phoneNumber":
			err = unpopulate(val, "PhoneNumber", &t.PhoneNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebChatChannel.
func (w WebChatChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["channelName"] = "WebChatChannel"
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebChatChannel.
func (w *WebChatChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &w.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebChatChannelProperties.
func (w WebChatChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sites", w.Sites)
	populate(objectMap, "webChatEmbedCode", w.WebChatEmbedCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebChatChannelProperties.
func (w *WebChatChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sites":
			err = unpopulate(val, "Sites", &w.Sites)
			delete(rawMsg, key)
		case "webChatEmbedCode":
			err = unpopulate(val, "WebChatEmbedCode", &w.WebChatEmbedCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebChatSite.
func (w WebChatSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", w.AppID)
	populate(objectMap, "eTag", w.ETag)
	populate(objectMap, "isBlockUserUploadEnabled", w.IsBlockUserUploadEnabled)
	populate(objectMap, "isDetailedLoggingEnabled", w.IsDetailedLoggingEnabled)
	populate(objectMap, "isEnabled", w.IsEnabled)
	populate(objectMap, "isEndpointParametersEnabled", w.IsEndpointParametersEnabled)
	populate(objectMap, "isNoStorageEnabled", w.IsNoStorageEnabled)
	populate(objectMap, "isSecureSiteEnabled", w.IsSecureSiteEnabled)
	populate(objectMap, "isTokenEnabled", w.IsTokenEnabled)
	populate(objectMap, "isV1Enabled", w.IsV1Enabled)
	populate(objectMap, "isV3Enabled", w.IsV3Enabled)
	populate(objectMap, "isWebChatSpeechEnabled", w.IsWebChatSpeechEnabled)
	populate(objectMap, "isWebchatPreviewEnabled", w.IsWebchatPreviewEnabled)
	populate(objectMap, "key", w.Key)
	populate(objectMap, "key2", w.Key2)
	populate(objectMap, "siteId", w.SiteID)
	populate(objectMap, "siteName", w.SiteName)
	populate(objectMap, "tenantId", w.TenantID)
	populate(objectMap, "trustedOrigins", w.TrustedOrigins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebChatSite.
func (w *WebChatSite) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &w.AppID)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &w.ETag)
			delete(rawMsg, key)
		case "isBlockUserUploadEnabled":
			err = unpopulate(val, "IsBlockUserUploadEnabled", &w.IsBlockUserUploadEnabled)
			delete(rawMsg, key)
		case "isDetailedLoggingEnabled":
			err = unpopulate(val, "IsDetailedLoggingEnabled", &w.IsDetailedLoggingEnabled)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &w.IsEnabled)
			delete(rawMsg, key)
		case "isEndpointParametersEnabled":
			err = unpopulate(val, "IsEndpointParametersEnabled", &w.IsEndpointParametersEnabled)
			delete(rawMsg, key)
		case "isNoStorageEnabled":
			err = unpopulate(val, "IsNoStorageEnabled", &w.IsNoStorageEnabled)
			delete(rawMsg, key)
		case "isSecureSiteEnabled":
			err = unpopulate(val, "IsSecureSiteEnabled", &w.IsSecureSiteEnabled)
			delete(rawMsg, key)
		case "isTokenEnabled":
			err = unpopulate(val, "IsTokenEnabled", &w.IsTokenEnabled)
			delete(rawMsg, key)
		case "isV1Enabled":
			err = unpopulate(val, "IsV1Enabled", &w.IsV1Enabled)
			delete(rawMsg, key)
		case "isV3Enabled":
			err = unpopulate(val, "IsV3Enabled", &w.IsV3Enabled)
			delete(rawMsg, key)
		case "isWebChatSpeechEnabled":
			err = unpopulate(val, "IsWebChatSpeechEnabled", &w.IsWebChatSpeechEnabled)
			delete(rawMsg, key)
		case "isWebchatPreviewEnabled":
			err = unpopulate(val, "IsWebchatPreviewEnabled", &w.IsWebchatPreviewEnabled)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &w.Key)
			delete(rawMsg, key)
		case "key2":
			err = unpopulate(val, "Key2", &w.Key2)
			delete(rawMsg, key)
		case "siteId":
			err = unpopulate(val, "SiteID", &w.SiteID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &w.SiteName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &w.TenantID)
			delete(rawMsg, key)
		case "trustedOrigins":
			err = unpopulate(val, "TrustedOrigins", &w.TrustedOrigins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
