// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchCreateVariable = "BatchCreateVariable"

// BatchCreateVariableRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateVariable for more information on using the BatchCreateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateVariableRequest method.
//	req, resp := client.BatchCreateVariableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable
func (c *FraudDetector) BatchCreateVariableRequest(input *BatchCreateVariableInput) (req *request.Request, output *BatchCreateVariableOutput) {
	op := &request.Operation{
		Name:       opBatchCreateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCreateVariableInput{}
	}

	output = &BatchCreateVariableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateVariable API operation for Amazon Fraud Detector.
//
// Creates a batch of variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation BatchCreateVariable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable
func (c *FraudDetector) BatchCreateVariable(input *BatchCreateVariableInput) (*BatchCreateVariableOutput, error) {
	req, out := c.BatchCreateVariableRequest(input)
	return out, req.Send()
}

// BatchCreateVariableWithContext is the same as BatchCreateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) BatchCreateVariableWithContext(ctx aws.Context, input *BatchCreateVariableInput, opts ...request.Option) (*BatchCreateVariableOutput, error) {
	req, out := c.BatchCreateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetVariable = "BatchGetVariable"

// BatchGetVariableRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetVariable for more information on using the BatchGetVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetVariableRequest method.
//	req, resp := client.BatchGetVariableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *FraudDetector) BatchGetVariableRequest(input *BatchGetVariableInput) (req *request.Request, output *BatchGetVariableOutput) {
	op := &request.Operation{
		Name:       opBatchGetVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetVariableInput{}
	}

	output = &BatchGetVariableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetVariable API operation for Amazon Fraud Detector.
//
// Gets a batch of variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation BatchGetVariable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *FraudDetector) BatchGetVariable(input *BatchGetVariableInput) (*BatchGetVariableOutput, error) {
	req, out := c.BatchGetVariableRequest(input)
	return out, req.Send()
}

// BatchGetVariableWithContext is the same as BatchGetVariable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) BatchGetVariableWithContext(ctx aws.Context, input *BatchGetVariableInput, opts ...request.Option) (*BatchGetVariableOutput, error) {
	req, out := c.BatchGetVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelBatchImportJob = "CancelBatchImportJob"

// CancelBatchImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelBatchImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelBatchImportJob for more information on using the CancelBatchImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelBatchImportJobRequest method.
//	req, resp := client.CancelBatchImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchImportJob
func (c *FraudDetector) CancelBatchImportJobRequest(input *CancelBatchImportJobInput) (req *request.Request, output *CancelBatchImportJobOutput) {
	op := &request.Operation{
		Name:       opCancelBatchImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBatchImportJobInput{}
	}

	output = &CancelBatchImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelBatchImportJob API operation for Amazon Fraud Detector.
//
// Cancels an in-progress batch import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CancelBatchImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchImportJob
func (c *FraudDetector) CancelBatchImportJob(input *CancelBatchImportJobInput) (*CancelBatchImportJobOutput, error) {
	req, out := c.CancelBatchImportJobRequest(input)
	return out, req.Send()
}

// CancelBatchImportJobWithContext is the same as CancelBatchImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelBatchImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CancelBatchImportJobWithContext(ctx aws.Context, input *CancelBatchImportJobInput, opts ...request.Option) (*CancelBatchImportJobOutput, error) {
	req, out := c.CancelBatchImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelBatchPredictionJob = "CancelBatchPredictionJob"

// CancelBatchPredictionJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelBatchPredictionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelBatchPredictionJob for more information on using the CancelBatchPredictionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelBatchPredictionJobRequest method.
//	req, resp := client.CancelBatchPredictionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchPredictionJob
func (c *FraudDetector) CancelBatchPredictionJobRequest(input *CancelBatchPredictionJobInput) (req *request.Request, output *CancelBatchPredictionJobOutput) {
	op := &request.Operation{
		Name:       opCancelBatchPredictionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBatchPredictionJobInput{}
	}

	output = &CancelBatchPredictionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelBatchPredictionJob API operation for Amazon Fraud Detector.
//
// Cancels the specified batch prediction job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CancelBatchPredictionJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchPredictionJob
func (c *FraudDetector) CancelBatchPredictionJob(input *CancelBatchPredictionJobInput) (*CancelBatchPredictionJobOutput, error) {
	req, out := c.CancelBatchPredictionJobRequest(input)
	return out, req.Send()
}

// CancelBatchPredictionJobWithContext is the same as CancelBatchPredictionJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelBatchPredictionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CancelBatchPredictionJobWithContext(ctx aws.Context, input *CancelBatchPredictionJobInput, opts ...request.Option) (*CancelBatchPredictionJobOutput, error) {
	req, out := c.CancelBatchPredictionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBatchImportJob = "CreateBatchImportJob"

// CreateBatchImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateBatchImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBatchImportJob for more information on using the CreateBatchImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBatchImportJobRequest method.
//	req, resp := client.CreateBatchImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchImportJob
func (c *FraudDetector) CreateBatchImportJobRequest(input *CreateBatchImportJobInput) (req *request.Request, output *CreateBatchImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateBatchImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchImportJobInput{}
	}

	output = &CreateBatchImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateBatchImportJob API operation for Amazon Fraud Detector.
//
// Creates a batch import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateBatchImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchImportJob
func (c *FraudDetector) CreateBatchImportJob(input *CreateBatchImportJobInput) (*CreateBatchImportJobOutput, error) {
	req, out := c.CreateBatchImportJobRequest(input)
	return out, req.Send()
}

// CreateBatchImportJobWithContext is the same as CreateBatchImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBatchImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateBatchImportJobWithContext(ctx aws.Context, input *CreateBatchImportJobInput, opts ...request.Option) (*CreateBatchImportJobOutput, error) {
	req, out := c.CreateBatchImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBatchPredictionJob = "CreateBatchPredictionJob"

// CreateBatchPredictionJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateBatchPredictionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBatchPredictionJob for more information on using the CreateBatchPredictionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBatchPredictionJobRequest method.
//	req, resp := client.CreateBatchPredictionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchPredictionJob
func (c *FraudDetector) CreateBatchPredictionJobRequest(input *CreateBatchPredictionJobInput) (req *request.Request, output *CreateBatchPredictionJobOutput) {
	op := &request.Operation{
		Name:       opCreateBatchPredictionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchPredictionJobInput{}
	}

	output = &CreateBatchPredictionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateBatchPredictionJob API operation for Amazon Fraud Detector.
//
// Creates a batch prediction job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateBatchPredictionJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchPredictionJob
func (c *FraudDetector) CreateBatchPredictionJob(input *CreateBatchPredictionJobInput) (*CreateBatchPredictionJobOutput, error) {
	req, out := c.CreateBatchPredictionJobRequest(input)
	return out, req.Send()
}

// CreateBatchPredictionJobWithContext is the same as CreateBatchPredictionJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBatchPredictionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateBatchPredictionJobWithContext(ctx aws.Context, input *CreateBatchPredictionJobInput, opts ...request.Option) (*CreateBatchPredictionJobOutput, error) {
	req, out := c.CreateBatchPredictionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDetectorVersion = "CreateDetectorVersion"

// CreateDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDetectorVersion for more information on using the CreateDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDetectorVersionRequest method.
//	req, resp := client.CreateDetectorVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *FraudDetector) CreateDetectorVersionRequest(input *CreateDetectorVersionInput) (req *request.Request, output *CreateDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opCreateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDetectorVersionInput{}
	}

	output = &CreateDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDetectorVersion API operation for Amazon Fraud Detector.
//
// Creates a detector version. The detector version starts in a DRAFT status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateDetectorVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *FraudDetector) CreateDetectorVersion(input *CreateDetectorVersionInput) (*CreateDetectorVersionOutput, error) {
	req, out := c.CreateDetectorVersionRequest(input)
	return out, req.Send()
}

// CreateDetectorVersionWithContext is the same as CreateDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateDetectorVersionWithContext(ctx aws.Context, input *CreateDetectorVersionInput, opts ...request.Option) (*CreateDetectorVersionOutput, error) {
	req, out := c.CreateDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateList = "CreateList"

// CreateListRequest generates a "aws/request.Request" representing the
// client's request for the CreateList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateList for more information on using the CreateList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateListRequest method.
//	req, resp := client.CreateListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateList
func (c *FraudDetector) CreateListRequest(input *CreateListInput) (req *request.Request, output *CreateListOutput) {
	op := &request.Operation{
		Name:       opCreateList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateListInput{}
	}

	output = &CreateListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateList API operation for Amazon Fraud Detector.
//
// Creates a list.
//
// List is a set of input data for a variable in your event dataset. You use
// the input data in a rule that's associated with your detector. For more information,
// see Lists (https://docs.aws.amazon.com/frauddetector/latest/ug/lists.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateList for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateList
func (c *FraudDetector) CreateList(input *CreateListInput) (*CreateListOutput, error) {
	req, out := c.CreateListRequest(input)
	return out, req.Send()
}

// CreateListWithContext is the same as CreateList with the addition of
// the ability to pass a context and additional request options.
//
// See CreateList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateListWithContext(ctx aws.Context, input *CreateListInput, opts ...request.Option) (*CreateListOutput, error) {
	req, out := c.CreateListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateModelRequest method.
//	req, resp := client.CreateModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel
func (c *FraudDetector) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateModel API operation for Amazon Fraud Detector.
//
// Creates a model using the specified model type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel
func (c *FraudDetector) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelVersion = "CreateModelVersion"

// CreateModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelVersion for more information on using the CreateModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateModelVersionRequest method.
//	req, resp := client.CreateModelVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion
func (c *FraudDetector) CreateModelVersionRequest(input *CreateModelVersionInput) (req *request.Request, output *CreateModelVersionOutput) {
	op := &request.Operation{
		Name:       opCreateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelVersionInput{}
	}

	output = &CreateModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelVersion API operation for Amazon Fraud Detector.
//
// Creates a version of the model using the specified model type and model id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateModelVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion
func (c *FraudDetector) CreateModelVersion(input *CreateModelVersionInput) (*CreateModelVersionOutput, error) {
	req, out := c.CreateModelVersionRequest(input)
	return out, req.Send()
}

// CreateModelVersionWithContext is the same as CreateModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateModelVersionWithContext(ctx aws.Context, input *CreateModelVersionInput, opts ...request.Option) (*CreateModelVersionOutput, error) {
	req, out := c.CreateModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRuleRequest method.
//	req, resp := client.CreateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *FraudDetector) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for Amazon Fraud Detector.
//
// Creates a rule for use with the specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *FraudDetector) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVariable = "CreateVariable"

// CreateVariableRequest generates a "aws/request.Request" representing the
// client's request for the CreateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVariable for more information on using the CreateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVariableRequest method.
//	req, resp := client.CreateVariableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable
func (c *FraudDetector) CreateVariableRequest(input *CreateVariableInput) (req *request.Request, output *CreateVariableOutput) {
	op := &request.Operation{
		Name:       opCreateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVariableInput{}
	}

	output = &CreateVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVariable API operation for Amazon Fraud Detector.
//
// Creates a variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateVariable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable
func (c *FraudDetector) CreateVariable(input *CreateVariableInput) (*CreateVariableOutput, error) {
	req, out := c.CreateVariableRequest(input)
	return out, req.Send()
}

// CreateVariableWithContext is the same as CreateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateVariableWithContext(ctx aws.Context, input *CreateVariableInput, opts ...request.Option) (*CreateVariableOutput, error) {
	req, out := c.CreateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBatchImportJob = "DeleteBatchImportJob"

// DeleteBatchImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBatchImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBatchImportJob for more information on using the DeleteBatchImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBatchImportJobRequest method.
//	req, resp := client.DeleteBatchImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchImportJob
func (c *FraudDetector) DeleteBatchImportJobRequest(input *DeleteBatchImportJobInput) (req *request.Request, output *DeleteBatchImportJobOutput) {
	op := &request.Operation{
		Name:       opDeleteBatchImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBatchImportJobInput{}
	}

	output = &DeleteBatchImportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBatchImportJob API operation for Amazon Fraud Detector.
//
// Deletes the specified batch import job ID record. This action does not delete
// the data that was batch imported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteBatchImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchImportJob
func (c *FraudDetector) DeleteBatchImportJob(input *DeleteBatchImportJobInput) (*DeleteBatchImportJobOutput, error) {
	req, out := c.DeleteBatchImportJobRequest(input)
	return out, req.Send()
}

// DeleteBatchImportJobWithContext is the same as DeleteBatchImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBatchImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteBatchImportJobWithContext(ctx aws.Context, input *DeleteBatchImportJobInput, opts ...request.Option) (*DeleteBatchImportJobOutput, error) {
	req, out := c.DeleteBatchImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBatchPredictionJob = "DeleteBatchPredictionJob"

// DeleteBatchPredictionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBatchPredictionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBatchPredictionJob for more information on using the DeleteBatchPredictionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBatchPredictionJobRequest method.
//	req, resp := client.DeleteBatchPredictionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchPredictionJob
func (c *FraudDetector) DeleteBatchPredictionJobRequest(input *DeleteBatchPredictionJobInput) (req *request.Request, output *DeleteBatchPredictionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteBatchPredictionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBatchPredictionJobInput{}
	}

	output = &DeleteBatchPredictionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBatchPredictionJob API operation for Amazon Fraud Detector.
//
// Deletes a batch prediction job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteBatchPredictionJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchPredictionJob
func (c *FraudDetector) DeleteBatchPredictionJob(input *DeleteBatchPredictionJobInput) (*DeleteBatchPredictionJobOutput, error) {
	req, out := c.DeleteBatchPredictionJobRequest(input)
	return out, req.Send()
}

// DeleteBatchPredictionJobWithContext is the same as DeleteBatchPredictionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBatchPredictionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteBatchPredictionJobWithContext(ctx aws.Context, input *DeleteBatchPredictionJobInput, opts ...request.Option) (*DeleteBatchPredictionJobOutput, error) {
	req, out := c.DeleteBatchPredictionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetector = "DeleteDetector"

// DeleteDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetector for more information on using the DeleteDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDetectorRequest method.
//	req, resp := client.DeleteDetectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector
func (c *FraudDetector) DeleteDetectorRequest(input *DeleteDetectorInput) (req *request.Request, output *DeleteDetectorOutput) {
	op := &request.Operation{
		Name:       opDeleteDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDetectorInput{}
	}

	output = &DeleteDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetector API operation for Amazon Fraud Detector.
//
// Deletes the detector. Before deleting a detector, you must first delete all
// detector versions and rule versions associated with the detector.
//
// When you delete a detector, Amazon Fraud Detector permanently deletes the
// detector and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteDetector for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector
func (c *FraudDetector) DeleteDetector(input *DeleteDetectorInput) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	return out, req.Send()
}

// DeleteDetectorWithContext is the same as DeleteDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteDetectorWithContext(ctx aws.Context, input *DeleteDetectorInput, opts ...request.Option) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetectorVersion = "DeleteDetectorVersion"

// DeleteDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetectorVersion for more information on using the DeleteDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDetectorVersionRequest method.
//	req, resp := client.DeleteDetectorVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion
func (c *FraudDetector) DeleteDetectorVersionRequest(input *DeleteDetectorVersionInput) (req *request.Request, output *DeleteDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDetectorVersionInput{}
	}

	output = &DeleteDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetectorVersion API operation for Amazon Fraud Detector.
//
// Deletes the detector version. You cannot delete detector versions that are
// in ACTIVE status.
//
// When you delete a detector version, Amazon Fraud Detector permanently deletes
// the detector and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteDetectorVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion
func (c *FraudDetector) DeleteDetectorVersion(input *DeleteDetectorVersionInput) (*DeleteDetectorVersionOutput, error) {
	req, out := c.DeleteDetectorVersionRequest(input)
	return out, req.Send()
}

// DeleteDetectorVersionWithContext is the same as DeleteDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteDetectorVersionWithContext(ctx aws.Context, input *DeleteDetectorVersionInput, opts ...request.Option) (*DeleteDetectorVersionOutput, error) {
	req, out := c.DeleteDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEntityType = "DeleteEntityType"

// DeleteEntityTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEntityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEntityType for more information on using the DeleteEntityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEntityTypeRequest method.
//	req, resp := client.DeleteEntityTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType
func (c *FraudDetector) DeleteEntityTypeRequest(input *DeleteEntityTypeInput) (req *request.Request, output *DeleteEntityTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteEntityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEntityTypeInput{}
	}

	output = &DeleteEntityTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEntityType API operation for Amazon Fraud Detector.
//
// Deletes an entity type.
//
// You cannot delete an entity type that is included in an event type.
//
// When you delete an entity type, Amazon Fraud Detector permanently deletes
// that entity type and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteEntityType for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType
func (c *FraudDetector) DeleteEntityType(input *DeleteEntityTypeInput) (*DeleteEntityTypeOutput, error) {
	req, out := c.DeleteEntityTypeRequest(input)
	return out, req.Send()
}

// DeleteEntityTypeWithContext is the same as DeleteEntityType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEntityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteEntityTypeWithContext(ctx aws.Context, input *DeleteEntityTypeInput, opts ...request.Option) (*DeleteEntityTypeOutput, error) {
	req, out := c.DeleteEntityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvent = "DeleteEvent"

// DeleteEventRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvent for more information on using the DeleteEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventRequest method.
//	req, resp := client.DeleteEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *FraudDetector) DeleteEventRequest(input *DeleteEventInput) (req *request.Request, output *DeleteEventOutput) {
	op := &request.Operation{
		Name:       opDeleteEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventInput{}
	}

	output = &DeleteEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEvent API operation for Amazon Fraud Detector.
//
// Deletes the specified event.
//
// When you delete an event, Amazon Fraud Detector permanently deletes that
// event and the event data is no longer stored in Amazon Fraud Detector. If
// deleteAuditHistory is True, event data is available through search for up
// to 30 seconds after the delete operation is completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteEvent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *FraudDetector) DeleteEvent(input *DeleteEventInput) (*DeleteEventOutput, error) {
	req, out := c.DeleteEventRequest(input)
	return out, req.Send()
}

// DeleteEventWithContext is the same as DeleteEvent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteEventWithContext(ctx aws.Context, input *DeleteEventInput, opts ...request.Option) (*DeleteEventOutput, error) {
	req, out := c.DeleteEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventType = "DeleteEventType"

// DeleteEventTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventType for more information on using the DeleteEventType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventTypeRequest method.
//	req, resp := client.DeleteEventTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType
func (c *FraudDetector) DeleteEventTypeRequest(input *DeleteEventTypeInput) (req *request.Request, output *DeleteEventTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteEventType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventTypeInput{}
	}

	output = &DeleteEventTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventType API operation for Amazon Fraud Detector.
//
// Deletes an event type.
//
// You cannot delete an event type that is used in a detector or a model.
//
// When you delete an event type, Amazon Fraud Detector permanently deletes
// that event type and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteEventType for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType
func (c *FraudDetector) DeleteEventType(input *DeleteEventTypeInput) (*DeleteEventTypeOutput, error) {
	req, out := c.DeleteEventTypeRequest(input)
	return out, req.Send()
}

// DeleteEventTypeWithContext is the same as DeleteEventType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteEventTypeWithContext(ctx aws.Context, input *DeleteEventTypeInput, opts ...request.Option) (*DeleteEventTypeOutput, error) {
	req, out := c.DeleteEventTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventsByEventType = "DeleteEventsByEventType"

// DeleteEventsByEventTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventsByEventType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventsByEventType for more information on using the DeleteEventsByEventType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventsByEventTypeRequest method.
//	req, resp := client.DeleteEventsByEventTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventsByEventType
func (c *FraudDetector) DeleteEventsByEventTypeRequest(input *DeleteEventsByEventTypeInput) (req *request.Request, output *DeleteEventsByEventTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteEventsByEventType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventsByEventTypeInput{}
	}

	output = &DeleteEventsByEventTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventsByEventType API operation for Amazon Fraud Detector.
//
// Deletes all events of a particular event type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteEventsByEventType for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventsByEventType
func (c *FraudDetector) DeleteEventsByEventType(input *DeleteEventsByEventTypeInput) (*DeleteEventsByEventTypeOutput, error) {
	req, out := c.DeleteEventsByEventTypeRequest(input)
	return out, req.Send()
}

// DeleteEventsByEventTypeWithContext is the same as DeleteEventsByEventType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventsByEventType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteEventsByEventTypeWithContext(ctx aws.Context, input *DeleteEventsByEventTypeInput, opts ...request.Option) (*DeleteEventsByEventTypeOutput, error) {
	req, out := c.DeleteEventsByEventTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExternalModel = "DeleteExternalModel"

// DeleteExternalModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExternalModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExternalModel for more information on using the DeleteExternalModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExternalModelRequest method.
//	req, resp := client.DeleteExternalModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel
func (c *FraudDetector) DeleteExternalModelRequest(input *DeleteExternalModelInput) (req *request.Request, output *DeleteExternalModelOutput) {
	op := &request.Operation{
		Name:       opDeleteExternalModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExternalModelInput{}
	}

	output = &DeleteExternalModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteExternalModel API operation for Amazon Fraud Detector.
//
// Removes a SageMaker model from Amazon Fraud Detector.
//
// You can remove an Amazon SageMaker model if it is not associated with a detector
// version. Removing a SageMaker model disconnects it from Amazon Fraud Detector,
// but the model remains available in SageMaker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteExternalModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel
func (c *FraudDetector) DeleteExternalModel(input *DeleteExternalModelInput) (*DeleteExternalModelOutput, error) {
	req, out := c.DeleteExternalModelRequest(input)
	return out, req.Send()
}

// DeleteExternalModelWithContext is the same as DeleteExternalModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExternalModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteExternalModelWithContext(ctx aws.Context, input *DeleteExternalModelInput, opts ...request.Option) (*DeleteExternalModelOutput, error) {
	req, out := c.DeleteExternalModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLabel = "DeleteLabel"

// DeleteLabelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLabel for more information on using the DeleteLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLabelRequest method.
//	req, resp := client.DeleteLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel
func (c *FraudDetector) DeleteLabelRequest(input *DeleteLabelInput) (req *request.Request, output *DeleteLabelOutput) {
	op := &request.Operation{
		Name:       opDeleteLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLabelInput{}
	}

	output = &DeleteLabelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLabel API operation for Amazon Fraud Detector.
//
// Deletes a label.
//
// You cannot delete labels that are included in an event type in Amazon Fraud
// Detector.
//
// You cannot delete a label assigned to an event ID. You must first delete
// the relevant event ID.
//
// When you delete a label, Amazon Fraud Detector permanently deletes that label
// and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteLabel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel
func (c *FraudDetector) DeleteLabel(input *DeleteLabelInput) (*DeleteLabelOutput, error) {
	req, out := c.DeleteLabelRequest(input)
	return out, req.Send()
}

// DeleteLabelWithContext is the same as DeleteLabel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteLabelWithContext(ctx aws.Context, input *DeleteLabelInput, opts ...request.Option) (*DeleteLabelOutput, error) {
	req, out := c.DeleteLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteList = "DeleteList"

// DeleteListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteList for more information on using the DeleteList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteListRequest method.
//	req, resp := client.DeleteListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteList
func (c *FraudDetector) DeleteListRequest(input *DeleteListInput) (req *request.Request, output *DeleteListOutput) {
	op := &request.Operation{
		Name:       opDeleteList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteListInput{}
	}

	output = &DeleteListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteList API operation for Amazon Fraud Detector.
//
// Deletes the list, provided it is not used in a rule.
//
// When you delete a list, Amazon Fraud Detector permanently deletes that list
// and the elements in the list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteList for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteList
func (c *FraudDetector) DeleteList(input *DeleteListInput) (*DeleteListOutput, error) {
	req, out := c.DeleteListRequest(input)
	return out, req.Send()
}

// DeleteListWithContext is the same as DeleteList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteListWithContext(ctx aws.Context, input *DeleteListInput, opts ...request.Option) (*DeleteListOutput, error) {
	req, out := c.DeleteListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteModelRequest method.
//	req, resp := client.DeleteModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel
func (c *FraudDetector) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for Amazon Fraud Detector.
//
// Deletes a model.
//
// You can delete models and model versions in Amazon Fraud Detector, provided
// that they are not associated with a detector version.
//
// When you delete a model, Amazon Fraud Detector permanently deletes that model
// and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteModel for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel
func (c *FraudDetector) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelVersion = "DeleteModelVersion"

// DeleteModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelVersion for more information on using the DeleteModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteModelVersionRequest method.
//	req, resp := client.DeleteModelVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion
func (c *FraudDetector) DeleteModelVersionRequest(input *DeleteModelVersionInput) (req *request.Request, output *DeleteModelVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelVersionInput{}
	}

	output = &DeleteModelVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelVersion API operation for Amazon Fraud Detector.
//
// Deletes a model version.
//
// You can delete models and model versions in Amazon Fraud Detector, provided
// that they are not associated with a detector version.
//
// When you delete a model version, Amazon Fraud Detector permanently deletes
// that model version and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteModelVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion
func (c *FraudDetector) DeleteModelVersion(input *DeleteModelVersionInput) (*DeleteModelVersionOutput, error) {
	req, out := c.DeleteModelVersionRequest(input)
	return out, req.Send()
}

// DeleteModelVersionWithContext is the same as DeleteModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteModelVersionWithContext(ctx aws.Context, input *DeleteModelVersionInput, opts ...request.Option) (*DeleteModelVersionOutput, error) {
	req, out := c.DeleteModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOutcome = "DeleteOutcome"

// DeleteOutcomeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOutcome operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOutcome for more information on using the DeleteOutcome
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOutcomeRequest method.
//	req, resp := client.DeleteOutcomeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome
func (c *FraudDetector) DeleteOutcomeRequest(input *DeleteOutcomeInput) (req *request.Request, output *DeleteOutcomeOutput) {
	op := &request.Operation{
		Name:       opDeleteOutcome,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOutcomeInput{}
	}

	output = &DeleteOutcomeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOutcome API operation for Amazon Fraud Detector.
//
// Deletes an outcome.
//
// You cannot delete an outcome that is used in a rule version.
//
// When you delete an outcome, Amazon Fraud Detector permanently deletes that
// outcome and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteOutcome for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome
func (c *FraudDetector) DeleteOutcome(input *DeleteOutcomeInput) (*DeleteOutcomeOutput, error) {
	req, out := c.DeleteOutcomeRequest(input)
	return out, req.Send()
}

// DeleteOutcomeWithContext is the same as DeleteOutcome with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOutcome for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteOutcomeWithContext(ctx aws.Context, input *DeleteOutcomeInput, opts ...request.Option) (*DeleteOutcomeOutput, error) {
	req, out := c.DeleteOutcomeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleRequest method.
//	req, resp := client.DeleteRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule
func (c *FraudDetector) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon Fraud Detector.
//
// Deletes the rule. You cannot delete a rule if it is used by an ACTIVE or
// INACTIVE detector version.
//
// When you delete a rule, Amazon Fraud Detector permanently deletes that rule
// and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule
func (c *FraudDetector) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVariable = "DeleteVariable"

// DeleteVariableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVariable for more information on using the DeleteVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVariableRequest method.
//	req, resp := client.DeleteVariableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable
func (c *FraudDetector) DeleteVariableRequest(input *DeleteVariableInput) (req *request.Request, output *DeleteVariableOutput) {
	op := &request.Operation{
		Name:       opDeleteVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVariableInput{}
	}

	output = &DeleteVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVariable API operation for Amazon Fraud Detector.
//
// Deletes a variable.
//
// You can't delete variables that are included in an event type in Amazon Fraud
// Detector.
//
// Amazon Fraud Detector automatically deletes model output variables and SageMaker
// model output variables when you delete the model. You can't delete these
// variables manually.
//
// When you delete a variable, Amazon Fraud Detector permanently deletes that
// variable and the data is no longer stored in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteVariable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable
func (c *FraudDetector) DeleteVariable(input *DeleteVariableInput) (*DeleteVariableOutput, error) {
	req, out := c.DeleteVariableRequest(input)
	return out, req.Send()
}

// DeleteVariableWithContext is the same as DeleteVariable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteVariableWithContext(ctx aws.Context, input *DeleteVariableInput, opts ...request.Option) (*DeleteVariableOutput, error) {
	req, out := c.DeleteVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDetector = "DescribeDetector"

// DescribeDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDetector for more information on using the DescribeDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDetectorRequest method.
//	req, resp := client.DescribeDetectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *FraudDetector) DescribeDetectorRequest(input *DescribeDetectorInput) (req *request.Request, output *DescribeDetectorOutput) {
	op := &request.Operation{
		Name:       opDescribeDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDetectorInput{}
	}

	output = &DescribeDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDetector API operation for Amazon Fraud Detector.
//
// Gets all versions for a specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DescribeDetector for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *FraudDetector) DescribeDetector(input *DescribeDetectorInput) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	return out, req.Send()
}

// DescribeDetectorWithContext is the same as DescribeDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeDetectorWithContext(ctx aws.Context, input *DescribeDetectorInput, opts ...request.Option) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelVersions = "DescribeModelVersions"

// DescribeModelVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelVersions for more information on using the DescribeModelVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeModelVersionsRequest method.
//	req, resp := client.DescribeModelVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *FraudDetector) DescribeModelVersionsRequest(input *DescribeModelVersionsInput) (req *request.Request, output *DescribeModelVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeModelVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeModelVersionsInput{}
	}

	output = &DescribeModelVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelVersions API operation for Amazon Fraud Detector.
//
// Gets all of the model versions for the specified model type or for the specified
// model type and model ID. You can also get details for a single, specified
// model version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DescribeModelVersions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *FraudDetector) DescribeModelVersions(input *DescribeModelVersionsInput) (*DescribeModelVersionsOutput, error) {
	req, out := c.DescribeModelVersionsRequest(input)
	return out, req.Send()
}

// DescribeModelVersionsWithContext is the same as DescribeModelVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeModelVersionsWithContext(ctx aws.Context, input *DescribeModelVersionsInput, opts ...request.Option) (*DescribeModelVersionsOutput, error) {
	req, out := c.DescribeModelVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeModelVersionsPages iterates over the pages of a DescribeModelVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeModelVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeModelVersions operation.
//	pageNum := 0
//	err := client.DescribeModelVersionsPages(params,
//	    func(page *frauddetector.DescribeModelVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) DescribeModelVersionsPages(input *DescribeModelVersionsInput, fn func(*DescribeModelVersionsOutput, bool) bool) error {
	return c.DescribeModelVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeModelVersionsPagesWithContext same as DescribeModelVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeModelVersionsPagesWithContext(ctx aws.Context, input *DescribeModelVersionsInput, fn func(*DescribeModelVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeModelVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeModelVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeModelVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBatchImportJobs = "GetBatchImportJobs"

// GetBatchImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetBatchImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBatchImportJobs for more information on using the GetBatchImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBatchImportJobsRequest method.
//	req, resp := client.GetBatchImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs
func (c *FraudDetector) GetBatchImportJobsRequest(input *GetBatchImportJobsInput) (req *request.Request, output *GetBatchImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetBatchImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBatchImportJobsInput{}
	}

	output = &GetBatchImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBatchImportJobs API operation for Amazon Fraud Detector.
//
// Gets all batch import jobs or a specific job of the specified ID. This is
// a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 50 records per page. If you provide a maxResults, the value
// must be between 1 and 50. To get the next page results, provide the pagination
// token from the GetBatchImportJobsResponse as part of your request. A null
// pagination token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetBatchImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs
func (c *FraudDetector) GetBatchImportJobs(input *GetBatchImportJobsInput) (*GetBatchImportJobsOutput, error) {
	req, out := c.GetBatchImportJobsRequest(input)
	return out, req.Send()
}

// GetBatchImportJobsWithContext is the same as GetBatchImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetBatchImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetBatchImportJobsWithContext(ctx aws.Context, input *GetBatchImportJobsInput, opts ...request.Option) (*GetBatchImportJobsOutput, error) {
	req, out := c.GetBatchImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBatchImportJobsPages iterates over the pages of a GetBatchImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBatchImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetBatchImportJobs operation.
//	pageNum := 0
//	err := client.GetBatchImportJobsPages(params,
//	    func(page *frauddetector.GetBatchImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetBatchImportJobsPages(input *GetBatchImportJobsInput, fn func(*GetBatchImportJobsOutput, bool) bool) error {
	return c.GetBatchImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBatchImportJobsPagesWithContext same as GetBatchImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetBatchImportJobsPagesWithContext(ctx aws.Context, input *GetBatchImportJobsInput, fn func(*GetBatchImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBatchImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBatchImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBatchImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetBatchPredictionJobs = "GetBatchPredictionJobs"

// GetBatchPredictionJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetBatchPredictionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBatchPredictionJobs for more information on using the GetBatchPredictionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBatchPredictionJobsRequest method.
//	req, resp := client.GetBatchPredictionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs
func (c *FraudDetector) GetBatchPredictionJobsRequest(input *GetBatchPredictionJobsInput) (req *request.Request, output *GetBatchPredictionJobsOutput) {
	op := &request.Operation{
		Name:       opGetBatchPredictionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBatchPredictionJobsInput{}
	}

	output = &GetBatchPredictionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBatchPredictionJobs API operation for Amazon Fraud Detector.
//
// Gets all batch prediction jobs or a specific job if you specify a job ID.
// This is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 50 records per page. If you provide a maxResults, the value
// must be between 1 and 50. To get the next page results, provide the pagination
// token from the GetBatchPredictionJobsResponse as part of your request. A
// null pagination token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetBatchPredictionJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs
func (c *FraudDetector) GetBatchPredictionJobs(input *GetBatchPredictionJobsInput) (*GetBatchPredictionJobsOutput, error) {
	req, out := c.GetBatchPredictionJobsRequest(input)
	return out, req.Send()
}

// GetBatchPredictionJobsWithContext is the same as GetBatchPredictionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetBatchPredictionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetBatchPredictionJobsWithContext(ctx aws.Context, input *GetBatchPredictionJobsInput, opts ...request.Option) (*GetBatchPredictionJobsOutput, error) {
	req, out := c.GetBatchPredictionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBatchPredictionJobsPages iterates over the pages of a GetBatchPredictionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBatchPredictionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetBatchPredictionJobs operation.
//	pageNum := 0
//	err := client.GetBatchPredictionJobsPages(params,
//	    func(page *frauddetector.GetBatchPredictionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetBatchPredictionJobsPages(input *GetBatchPredictionJobsInput, fn func(*GetBatchPredictionJobsOutput, bool) bool) error {
	return c.GetBatchPredictionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBatchPredictionJobsPagesWithContext same as GetBatchPredictionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetBatchPredictionJobsPagesWithContext(ctx aws.Context, input *GetBatchPredictionJobsInput, fn func(*GetBatchPredictionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBatchPredictionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBatchPredictionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBatchPredictionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDeleteEventsByEventTypeStatus = "GetDeleteEventsByEventTypeStatus"

// GetDeleteEventsByEventTypeStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetDeleteEventsByEventTypeStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeleteEventsByEventTypeStatus for more information on using the GetDeleteEventsByEventTypeStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeleteEventsByEventTypeStatusRequest method.
//	req, resp := client.GetDeleteEventsByEventTypeStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDeleteEventsByEventTypeStatus
func (c *FraudDetector) GetDeleteEventsByEventTypeStatusRequest(input *GetDeleteEventsByEventTypeStatusInput) (req *request.Request, output *GetDeleteEventsByEventTypeStatusOutput) {
	op := &request.Operation{
		Name:       opGetDeleteEventsByEventTypeStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeleteEventsByEventTypeStatusInput{}
	}

	output = &GetDeleteEventsByEventTypeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeleteEventsByEventTypeStatus API operation for Amazon Fraud Detector.
//
// Retrieves the status of a DeleteEventsByEventType action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDeleteEventsByEventTypeStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDeleteEventsByEventTypeStatus
func (c *FraudDetector) GetDeleteEventsByEventTypeStatus(input *GetDeleteEventsByEventTypeStatusInput) (*GetDeleteEventsByEventTypeStatusOutput, error) {
	req, out := c.GetDeleteEventsByEventTypeStatusRequest(input)
	return out, req.Send()
}

// GetDeleteEventsByEventTypeStatusWithContext is the same as GetDeleteEventsByEventTypeStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeleteEventsByEventTypeStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDeleteEventsByEventTypeStatusWithContext(ctx aws.Context, input *GetDeleteEventsByEventTypeStatusInput, opts ...request.Option) (*GetDeleteEventsByEventTypeStatusOutput, error) {
	req, out := c.GetDeleteEventsByEventTypeStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDetectorVersion = "GetDetectorVersion"

// GetDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetectorVersion for more information on using the GetDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDetectorVersionRequest method.
//	req, resp := client.GetDetectorVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion
func (c *FraudDetector) GetDetectorVersionRequest(input *GetDetectorVersionInput) (req *request.Request, output *GetDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opGetDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDetectorVersionInput{}
	}

	output = &GetDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetectorVersion API operation for Amazon Fraud Detector.
//
// Gets a particular detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDetectorVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion
func (c *FraudDetector) GetDetectorVersion(input *GetDetectorVersionInput) (*GetDetectorVersionOutput, error) {
	req, out := c.GetDetectorVersionRequest(input)
	return out, req.Send()
}

// GetDetectorVersionWithContext is the same as GetDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorVersionWithContext(ctx aws.Context, input *GetDetectorVersionInput, opts ...request.Option) (*GetDetectorVersionOutput, error) {
	req, out := c.GetDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDetectors = "GetDetectors"

// GetDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetectors for more information on using the GetDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDetectorsRequest method.
//	req, resp := client.GetDetectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *FraudDetector) GetDetectorsRequest(input *GetDetectorsInput) (req *request.Request, output *GetDetectorsOutput) {
	op := &request.Operation{
		Name:       opGetDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDetectorsInput{}
	}

	output = &GetDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetectors API operation for Amazon Fraud Detector.
//
// Gets all detectors or a single detector if a detectorId is specified. This
// is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetDetectorsResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDetectors for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *FraudDetector) GetDetectors(input *GetDetectorsInput) (*GetDetectorsOutput, error) {
	req, out := c.GetDetectorsRequest(input)
	return out, req.Send()
}

// GetDetectorsWithContext is the same as GetDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorsWithContext(ctx aws.Context, input *GetDetectorsInput, opts ...request.Option) (*GetDetectorsOutput, error) {
	req, out := c.GetDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDetectorsPages iterates over the pages of a GetDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetDetectors operation.
//	pageNum := 0
//	err := client.GetDetectorsPages(params,
//	    func(page *frauddetector.GetDetectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetDetectorsPages(input *GetDetectorsInput, fn func(*GetDetectorsOutput, bool) bool) error {
	return c.GetDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDetectorsPagesWithContext same as GetDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorsPagesWithContext(ctx aws.Context, input *GetDetectorsInput, fn func(*GetDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDetectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEntityTypes = "GetEntityTypes"

// GetEntityTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetEntityTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEntityTypes for more information on using the GetEntityTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEntityTypesRequest method.
//	req, resp := client.GetEntityTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes
func (c *FraudDetector) GetEntityTypesRequest(input *GetEntityTypesInput) (req *request.Request, output *GetEntityTypesOutput) {
	op := &request.Operation{
		Name:       opGetEntityTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEntityTypesInput{}
	}

	output = &GetEntityTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEntityTypes API operation for Amazon Fraud Detector.
//
// Gets all entity types or a specific entity type if a name is specified. This
// is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetEntityTypesResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEntityTypes for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes
func (c *FraudDetector) GetEntityTypes(input *GetEntityTypesInput) (*GetEntityTypesOutput, error) {
	req, out := c.GetEntityTypesRequest(input)
	return out, req.Send()
}

// GetEntityTypesWithContext is the same as GetEntityTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetEntityTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEntityTypesWithContext(ctx aws.Context, input *GetEntityTypesInput, opts ...request.Option) (*GetEntityTypesOutput, error) {
	req, out := c.GetEntityTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEntityTypesPages iterates over the pages of a GetEntityTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEntityTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetEntityTypes operation.
//	pageNum := 0
//	err := client.GetEntityTypesPages(params,
//	    func(page *frauddetector.GetEntityTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetEntityTypesPages(input *GetEntityTypesInput, fn func(*GetEntityTypesOutput, bool) bool) error {
	return c.GetEntityTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEntityTypesPagesWithContext same as GetEntityTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEntityTypesPagesWithContext(ctx aws.Context, input *GetEntityTypesInput, fn func(*GetEntityTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEntityTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEntityTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEntityTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEvent = "GetEvent"

// GetEventRequest generates a "aws/request.Request" representing the
// client's request for the GetEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvent for more information on using the GetEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventRequest method.
//	req, resp := client.GetEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEvent
func (c *FraudDetector) GetEventRequest(input *GetEventInput) (req *request.Request, output *GetEventOutput) {
	op := &request.Operation{
		Name:       opGetEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventInput{}
	}

	output = &GetEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvent API operation for Amazon Fraud Detector.
//
// Retrieves details of events stored with Amazon Fraud Detector. This action
// does not retrieve prediction results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEvent for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEvent
func (c *FraudDetector) GetEvent(input *GetEventInput) (*GetEventOutput, error) {
	req, out := c.GetEventRequest(input)
	return out, req.Send()
}

// GetEventWithContext is the same as GetEvent with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventWithContext(ctx aws.Context, input *GetEventInput, opts ...request.Option) (*GetEventOutput, error) {
	req, out := c.GetEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventPrediction = "GetEventPrediction"

// GetEventPredictionRequest generates a "aws/request.Request" representing the
// client's request for the GetEventPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventPrediction for more information on using the GetEventPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventPredictionRequest method.
//	req, resp := client.GetEventPredictionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction
func (c *FraudDetector) GetEventPredictionRequest(input *GetEventPredictionInput) (req *request.Request, output *GetEventPredictionOutput) {
	op := &request.Operation{
		Name:       opGetEventPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventPredictionInput{}
	}

	output = &GetEventPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventPrediction API operation for Amazon Fraud Detector.
//
// Evaluates an event against a detector version. If a version ID is not provided,
// the detector’s (ACTIVE) version is used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEventPrediction for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ResourceUnavailableException
//     An exception indicating that the attached customer-owned (external) model
//     threw an exception when Amazon Fraud Detector invoked the model.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction
func (c *FraudDetector) GetEventPrediction(input *GetEventPredictionInput) (*GetEventPredictionOutput, error) {
	req, out := c.GetEventPredictionRequest(input)
	return out, req.Send()
}

// GetEventPredictionWithContext is the same as GetEventPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventPredictionWithContext(ctx aws.Context, input *GetEventPredictionInput, opts ...request.Option) (*GetEventPredictionOutput, error) {
	req, out := c.GetEventPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventPredictionMetadata = "GetEventPredictionMetadata"

// GetEventPredictionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetEventPredictionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventPredictionMetadata for more information on using the GetEventPredictionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventPredictionMetadataRequest method.
//	req, resp := client.GetEventPredictionMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPredictionMetadata
func (c *FraudDetector) GetEventPredictionMetadataRequest(input *GetEventPredictionMetadataInput) (req *request.Request, output *GetEventPredictionMetadataOutput) {
	op := &request.Operation{
		Name:       opGetEventPredictionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventPredictionMetadataInput{}
	}

	output = &GetEventPredictionMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventPredictionMetadata API operation for Amazon Fraud Detector.
//
// Gets details of the past fraud predictions for the specified event ID, event
// type, detector ID, and detector version ID that was generated in the specified
// time period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEventPredictionMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPredictionMetadata
func (c *FraudDetector) GetEventPredictionMetadata(input *GetEventPredictionMetadataInput) (*GetEventPredictionMetadataOutput, error) {
	req, out := c.GetEventPredictionMetadataRequest(input)
	return out, req.Send()
}

// GetEventPredictionMetadataWithContext is the same as GetEventPredictionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventPredictionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventPredictionMetadataWithContext(ctx aws.Context, input *GetEventPredictionMetadataInput, opts ...request.Option) (*GetEventPredictionMetadataOutput, error) {
	req, out := c.GetEventPredictionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventTypes = "GetEventTypes"

// GetEventTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetEventTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventTypes for more information on using the GetEventTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventTypesRequest method.
//	req, resp := client.GetEventTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes
func (c *FraudDetector) GetEventTypesRequest(input *GetEventTypesInput) (req *request.Request, output *GetEventTypesOutput) {
	op := &request.Operation{
		Name:       opGetEventTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEventTypesInput{}
	}

	output = &GetEventTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventTypes API operation for Amazon Fraud Detector.
//
// Gets all event types or a specific event type if name is provided. This is
// a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetEventTypesResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEventTypes for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes
func (c *FraudDetector) GetEventTypes(input *GetEventTypesInput) (*GetEventTypesOutput, error) {
	req, out := c.GetEventTypesRequest(input)
	return out, req.Send()
}

// GetEventTypesWithContext is the same as GetEventTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventTypesWithContext(ctx aws.Context, input *GetEventTypesInput, opts ...request.Option) (*GetEventTypesOutput, error) {
	req, out := c.GetEventTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEventTypesPages iterates over the pages of a GetEventTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEventTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetEventTypes operation.
//	pageNum := 0
//	err := client.GetEventTypesPages(params,
//	    func(page *frauddetector.GetEventTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetEventTypesPages(input *GetEventTypesInput, fn func(*GetEventTypesOutput, bool) bool) error {
	return c.GetEventTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEventTypesPagesWithContext same as GetEventTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventTypesPagesWithContext(ctx aws.Context, input *GetEventTypesInput, fn func(*GetEventTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEventTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEventTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEventTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetExternalModels = "GetExternalModels"

// GetExternalModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetExternalModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExternalModels for more information on using the GetExternalModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExternalModelsRequest method.
//	req, resp := client.GetExternalModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *FraudDetector) GetExternalModelsRequest(input *GetExternalModelsInput) (req *request.Request, output *GetExternalModelsOutput) {
	op := &request.Operation{
		Name:       opGetExternalModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExternalModelsInput{}
	}

	output = &GetExternalModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExternalModels API operation for Amazon Fraud Detector.
//
// Gets the details for one or more Amazon SageMaker models that have been imported
// into the service. This is a paginated API. If you provide a null maxResults,
// this actions retrieves a maximum of 10 records per page. If you provide a
// maxResults, the value must be between 5 and 10. To get the next page results,
// provide the pagination token from the GetExternalModelsResult as part of
// your request. A null pagination token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetExternalModels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *FraudDetector) GetExternalModels(input *GetExternalModelsInput) (*GetExternalModelsOutput, error) {
	req, out := c.GetExternalModelsRequest(input)
	return out, req.Send()
}

// GetExternalModelsWithContext is the same as GetExternalModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetExternalModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetExternalModelsWithContext(ctx aws.Context, input *GetExternalModelsInput, opts ...request.Option) (*GetExternalModelsOutput, error) {
	req, out := c.GetExternalModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetExternalModelsPages iterates over the pages of a GetExternalModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetExternalModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetExternalModels operation.
//	pageNum := 0
//	err := client.GetExternalModelsPages(params,
//	    func(page *frauddetector.GetExternalModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetExternalModelsPages(input *GetExternalModelsInput, fn func(*GetExternalModelsOutput, bool) bool) error {
	return c.GetExternalModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetExternalModelsPagesWithContext same as GetExternalModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetExternalModelsPagesWithContext(ctx aws.Context, input *GetExternalModelsInput, fn func(*GetExternalModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetExternalModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetExternalModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetExternalModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetKMSEncryptionKey = "GetKMSEncryptionKey"

// GetKMSEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetKMSEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKMSEncryptionKey for more information on using the GetKMSEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKMSEncryptionKeyRequest method.
//	req, resp := client.GetKMSEncryptionKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey
func (c *FraudDetector) GetKMSEncryptionKeyRequest(input *GetKMSEncryptionKeyInput) (req *request.Request, output *GetKMSEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opGetKMSEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKMSEncryptionKeyInput{}
	}

	output = &GetKMSEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKMSEncryptionKey API operation for Amazon Fraud Detector.
//
// Gets the encryption key if a KMS key has been specified to be used to encrypt
// content in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetKMSEncryptionKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey
func (c *FraudDetector) GetKMSEncryptionKey(input *GetKMSEncryptionKeyInput) (*GetKMSEncryptionKeyOutput, error) {
	req, out := c.GetKMSEncryptionKeyRequest(input)
	return out, req.Send()
}

// GetKMSEncryptionKeyWithContext is the same as GetKMSEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetKMSEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetKMSEncryptionKeyWithContext(ctx aws.Context, input *GetKMSEncryptionKeyInput, opts ...request.Option) (*GetKMSEncryptionKeyOutput, error) {
	req, out := c.GetKMSEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLabels = "GetLabels"

// GetLabelsRequest generates a "aws/request.Request" representing the
// client's request for the GetLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLabels for more information on using the GetLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLabelsRequest method.
//	req, resp := client.GetLabelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels
func (c *FraudDetector) GetLabelsRequest(input *GetLabelsInput) (req *request.Request, output *GetLabelsOutput) {
	op := &request.Operation{
		Name:       opGetLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLabelsInput{}
	}

	output = &GetLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLabels API operation for Amazon Fraud Detector.
//
// Gets all labels or a specific label if name is provided. This is a paginated
// API. If you provide a null maxResults, this action retrieves a maximum of
// 50 records per page. If you provide a maxResults, the value must be between
// 10 and 50. To get the next page results, provide the pagination token from
// the GetGetLabelsResponse as part of your request. A null pagination token
// fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetLabels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels
func (c *FraudDetector) GetLabels(input *GetLabelsInput) (*GetLabelsOutput, error) {
	req, out := c.GetLabelsRequest(input)
	return out, req.Send()
}

// GetLabelsWithContext is the same as GetLabels with the addition of
// the ability to pass a context and additional request options.
//
// See GetLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetLabelsWithContext(ctx aws.Context, input *GetLabelsInput, opts ...request.Option) (*GetLabelsOutput, error) {
	req, out := c.GetLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetLabelsPages iterates over the pages of a GetLabels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetLabels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetLabels operation.
//	pageNum := 0
//	err := client.GetLabelsPages(params,
//	    func(page *frauddetector.GetLabelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetLabelsPages(input *GetLabelsInput, fn func(*GetLabelsOutput, bool) bool) error {
	return c.GetLabelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetLabelsPagesWithContext same as GetLabelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetLabelsPagesWithContext(ctx aws.Context, input *GetLabelsInput, fn func(*GetLabelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetLabelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetLabelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetLabelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetListElements = "GetListElements"

// GetListElementsRequest generates a "aws/request.Request" representing the
// client's request for the GetListElements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetListElements for more information on using the GetListElements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetListElementsRequest method.
//	req, resp := client.GetListElementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListElements
func (c *FraudDetector) GetListElementsRequest(input *GetListElementsInput) (req *request.Request, output *GetListElementsOutput) {
	op := &request.Operation{
		Name:       opGetListElements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetListElementsInput{}
	}

	output = &GetListElementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetListElements API operation for Amazon Fraud Detector.
//
// Gets all the elements in the specified list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetListElements for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListElements
func (c *FraudDetector) GetListElements(input *GetListElementsInput) (*GetListElementsOutput, error) {
	req, out := c.GetListElementsRequest(input)
	return out, req.Send()
}

// GetListElementsWithContext is the same as GetListElements with the addition of
// the ability to pass a context and additional request options.
//
// See GetListElements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetListElementsWithContext(ctx aws.Context, input *GetListElementsInput, opts ...request.Option) (*GetListElementsOutput, error) {
	req, out := c.GetListElementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetListElementsPages iterates over the pages of a GetListElements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetListElements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetListElements operation.
//	pageNum := 0
//	err := client.GetListElementsPages(params,
//	    func(page *frauddetector.GetListElementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetListElementsPages(input *GetListElementsInput, fn func(*GetListElementsOutput, bool) bool) error {
	return c.GetListElementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetListElementsPagesWithContext same as GetListElementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetListElementsPagesWithContext(ctx aws.Context, input *GetListElementsInput, fn func(*GetListElementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetListElementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetListElementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetListElementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetListsMetadata = "GetListsMetadata"

// GetListsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetListsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetListsMetadata for more information on using the GetListsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetListsMetadataRequest method.
//	req, resp := client.GetListsMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListsMetadata
func (c *FraudDetector) GetListsMetadataRequest(input *GetListsMetadataInput) (req *request.Request, output *GetListsMetadataOutput) {
	op := &request.Operation{
		Name:       opGetListsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetListsMetadataInput{}
	}

	output = &GetListsMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetListsMetadata API operation for Amazon Fraud Detector.
//
// Gets the metadata of either all the lists under the account or the specified
// list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetListsMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListsMetadata
func (c *FraudDetector) GetListsMetadata(input *GetListsMetadataInput) (*GetListsMetadataOutput, error) {
	req, out := c.GetListsMetadataRequest(input)
	return out, req.Send()
}

// GetListsMetadataWithContext is the same as GetListsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetListsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetListsMetadataWithContext(ctx aws.Context, input *GetListsMetadataInput, opts ...request.Option) (*GetListsMetadataOutput, error) {
	req, out := c.GetListsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetListsMetadataPages iterates over the pages of a GetListsMetadata operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetListsMetadata method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetListsMetadata operation.
//	pageNum := 0
//	err := client.GetListsMetadataPages(params,
//	    func(page *frauddetector.GetListsMetadataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetListsMetadataPages(input *GetListsMetadataInput, fn func(*GetListsMetadataOutput, bool) bool) error {
	return c.GetListsMetadataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetListsMetadataPagesWithContext same as GetListsMetadataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetListsMetadataPagesWithContext(ctx aws.Context, input *GetListsMetadataInput, fn func(*GetListsMetadataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetListsMetadataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetListsMetadataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetListsMetadataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetModelVersion = "GetModelVersion"

// GetModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelVersion for more information on using the GetModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelVersionRequest method.
//	req, resp := client.GetModelVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *FraudDetector) GetModelVersionRequest(input *GetModelVersionInput) (req *request.Request, output *GetModelVersionOutput) {
	op := &request.Operation{
		Name:       opGetModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetModelVersionInput{}
	}

	output = &GetModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelVersion API operation for Amazon Fraud Detector.
//
// Gets the details of the specified model version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetModelVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *FraudDetector) GetModelVersion(input *GetModelVersionInput) (*GetModelVersionOutput, error) {
	req, out := c.GetModelVersionRequest(input)
	return out, req.Send()
}

// GetModelVersionWithContext is the same as GetModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelVersionWithContext(ctx aws.Context, input *GetModelVersionInput, opts ...request.Option) (*GetModelVersionOutput, error) {
	req, out := c.GetModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModels = "GetModels"

// GetModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModels for more information on using the GetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelsRequest method.
//	req, resp := client.GetModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *FraudDetector) GetModelsRequest(input *GetModelsInput) (req *request.Request, output *GetModelsOutput) {
	op := &request.Operation{
		Name:       opGetModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	output = &GetModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModels API operation for Amazon Fraud Detector.
//
// Gets one or more models. Gets all models for the Amazon Web Services account
// if no model type and no model id provided. Gets all models for the Amazon
// Web Services account and model type, if the model type is specified but model
// id is not provided. Gets a specific model if (model type, model id) tuple
// is specified.
//
// This is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 1 and 10. To get the next page results, provide the pagination
// token from the response as part of your request. A null pagination token
// fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetModels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *FraudDetector) GetModels(input *GetModelsInput) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	return out, req.Send()
}

// GetModelsWithContext is the same as GetModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelsWithContext(ctx aws.Context, input *GetModelsInput, opts ...request.Option) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetModelsPages iterates over the pages of a GetModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetModels operation.
//	pageNum := 0
//	err := client.GetModelsPages(params,
//	    func(page *frauddetector.GetModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetModelsPages(input *GetModelsInput, fn func(*GetModelsOutput, bool) bool) error {
	return c.GetModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetModelsPagesWithContext same as GetModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelsPagesWithContext(ctx aws.Context, input *GetModelsInput, fn func(*GetModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOutcomes = "GetOutcomes"

// GetOutcomesRequest generates a "aws/request.Request" representing the
// client's request for the GetOutcomes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutcomes for more information on using the GetOutcomes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOutcomesRequest method.
//	req, resp := client.GetOutcomesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes
func (c *FraudDetector) GetOutcomesRequest(input *GetOutcomesInput) (req *request.Request, output *GetOutcomesOutput) {
	op := &request.Operation{
		Name:       opGetOutcomes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOutcomesInput{}
	}

	output = &GetOutcomesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutcomes API operation for Amazon Fraud Detector.
//
// Gets one or more outcomes. This is a paginated API. If you provide a null
// maxResults, this actions retrieves a maximum of 100 records per page. If
// you provide a maxResults, the value must be between 50 and 100. To get the
// next page results, provide the pagination token from the GetOutcomesResult
// as part of your request. A null pagination token fetches the records from
// the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetOutcomes for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes
func (c *FraudDetector) GetOutcomes(input *GetOutcomesInput) (*GetOutcomesOutput, error) {
	req, out := c.GetOutcomesRequest(input)
	return out, req.Send()
}

// GetOutcomesWithContext is the same as GetOutcomes with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutcomes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetOutcomesWithContext(ctx aws.Context, input *GetOutcomesInput, opts ...request.Option) (*GetOutcomesOutput, error) {
	req, out := c.GetOutcomesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOutcomesPages iterates over the pages of a GetOutcomes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOutcomes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetOutcomes operation.
//	pageNum := 0
//	err := client.GetOutcomesPages(params,
//	    func(page *frauddetector.GetOutcomesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetOutcomesPages(input *GetOutcomesInput, fn func(*GetOutcomesOutput, bool) bool) error {
	return c.GetOutcomesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOutcomesPagesWithContext same as GetOutcomesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetOutcomesPagesWithContext(ctx aws.Context, input *GetOutcomesInput, fn func(*GetOutcomesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOutcomesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOutcomesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOutcomesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetRules = "GetRules"

// GetRulesRequest generates a "aws/request.Request" representing the
// client's request for the GetRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRules for more information on using the GetRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRulesRequest method.
//	req, resp := client.GetRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules
func (c *FraudDetector) GetRulesRequest(input *GetRulesInput) (req *request.Request, output *GetRulesOutput) {
	op := &request.Operation{
		Name:       opGetRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetRulesInput{}
	}

	output = &GetRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRules API operation for Amazon Fraud Detector.
//
// Get all rules for a detector (paginated) if ruleId and ruleVersion are not
// specified. Gets all rules for the detector and the ruleId if present (paginated).
// Gets a specific rule if both the ruleId and the ruleVersion are specified.
//
// This is a paginated API. Providing null maxResults results in retrieving
// maximum of 100 records per page. If you provide maxResults the value must
// be between 50 and 100. To get the next page result, a provide a pagination
// token from GetRulesResult as part of your request. Null pagination token
// fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetRules for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules
func (c *FraudDetector) GetRules(input *GetRulesInput) (*GetRulesOutput, error) {
	req, out := c.GetRulesRequest(input)
	return out, req.Send()
}

// GetRulesWithContext is the same as GetRules with the addition of
// the ability to pass a context and additional request options.
//
// See GetRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetRulesWithContext(ctx aws.Context, input *GetRulesInput, opts ...request.Option) (*GetRulesOutput, error) {
	req, out := c.GetRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetRulesPages iterates over the pages of a GetRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetRules operation.
//	pageNum := 0
//	err := client.GetRulesPages(params,
//	    func(page *frauddetector.GetRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetRulesPages(input *GetRulesInput, fn func(*GetRulesOutput, bool) bool) error {
	return c.GetRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetRulesPagesWithContext same as GetRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetRulesPagesWithContext(ctx aws.Context, input *GetRulesInput, fn func(*GetRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetVariables = "GetVariables"

// GetVariablesRequest generates a "aws/request.Request" representing the
// client's request for the GetVariables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVariables for more information on using the GetVariables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVariablesRequest method.
//	req, resp := client.GetVariablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *FraudDetector) GetVariablesRequest(input *GetVariablesInput) (req *request.Request, output *GetVariablesOutput) {
	op := &request.Operation{
		Name:       opGetVariables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetVariablesInput{}
	}

	output = &GetVariablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVariables API operation for Amazon Fraud Detector.
//
// Gets all of the variables or the specific variable. This is a paginated API.
// Providing null maxSizePerPage results in retrieving maximum of 100 records
// per page. If you provide maxSizePerPage the value must be between 50 and
// 100. To get the next page result, a provide a pagination token from GetVariablesResult
// as part of your request. Null pagination token fetches the records from the
// beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetVariables for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *FraudDetector) GetVariables(input *GetVariablesInput) (*GetVariablesOutput, error) {
	req, out := c.GetVariablesRequest(input)
	return out, req.Send()
}

// GetVariablesWithContext is the same as GetVariables with the addition of
// the ability to pass a context and additional request options.
//
// See GetVariables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetVariablesWithContext(ctx aws.Context, input *GetVariablesInput, opts ...request.Option) (*GetVariablesOutput, error) {
	req, out := c.GetVariablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetVariablesPages iterates over the pages of a GetVariables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetVariables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetVariables operation.
//	pageNum := 0
//	err := client.GetVariablesPages(params,
//	    func(page *frauddetector.GetVariablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) GetVariablesPages(input *GetVariablesInput, fn func(*GetVariablesOutput, bool) bool) error {
	return c.GetVariablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetVariablesPagesWithContext same as GetVariablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetVariablesPagesWithContext(ctx aws.Context, input *GetVariablesInput, fn func(*GetVariablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetVariablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVariablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetVariablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventPredictions = "ListEventPredictions"

// ListEventPredictionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventPredictions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventPredictions for more information on using the ListEventPredictions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventPredictionsRequest method.
//	req, resp := client.ListEventPredictionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions
func (c *FraudDetector) ListEventPredictionsRequest(input *ListEventPredictionsInput) (req *request.Request, output *ListEventPredictionsOutput) {
	op := &request.Operation{
		Name:       opListEventPredictions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventPredictionsInput{}
	}

	output = &ListEventPredictionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventPredictions API operation for Amazon Fraud Detector.
//
// Gets a list of past predictions. The list can be filtered by detector ID,
// detector version ID, event ID, event type, or by specifying a time period.
// If filter is not specified, the most recent prediction is returned.
//
// For example, the following filter lists all past predictions for xyz event
// type - { "eventType":{ "value": "xyz" }” }
//
// This is a paginated API. If you provide a null maxResults, this action will
// retrieve a maximum of 10 records per page. If you provide a maxResults, the
// value must be between 50 and 100. To get the next page results, provide the
// nextToken from the response as part of your request. A null nextToken fetches
// the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation ListEventPredictions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions
func (c *FraudDetector) ListEventPredictions(input *ListEventPredictionsInput) (*ListEventPredictionsOutput, error) {
	req, out := c.ListEventPredictionsRequest(input)
	return out, req.Send()
}

// ListEventPredictionsWithContext is the same as ListEventPredictions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventPredictions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) ListEventPredictionsWithContext(ctx aws.Context, input *ListEventPredictionsInput, opts ...request.Option) (*ListEventPredictionsOutput, error) {
	req, out := c.ListEventPredictionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventPredictionsPages iterates over the pages of a ListEventPredictions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventPredictions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventPredictions operation.
//	pageNum := 0
//	err := client.ListEventPredictionsPages(params,
//	    func(page *frauddetector.ListEventPredictionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) ListEventPredictionsPages(input *ListEventPredictionsInput, fn func(*ListEventPredictionsOutput, bool) bool) error {
	return c.ListEventPredictionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventPredictionsPagesWithContext same as ListEventPredictionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) ListEventPredictionsPagesWithContext(ctx aws.Context, input *ListEventPredictionsInput, fn func(*ListEventPredictionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventPredictionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventPredictionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventPredictionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource
func (c *FraudDetector) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Fraud Detector.
//
// Lists all tags associated with the resource. This is a paginated API. To
// get the next page results, provide the pagination token from the response
// as part of your request. A null pagination token fetches the records from
// the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource
func (c *FraudDetector) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *frauddetector.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *FraudDetector) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDetector = "PutDetector"

// PutDetectorRequest generates a "aws/request.Request" representing the
// client's request for the PutDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDetector for more information on using the PutDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDetectorRequest method.
//	req, resp := client.PutDetectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector
func (c *FraudDetector) PutDetectorRequest(input *PutDetectorInput) (req *request.Request, output *PutDetectorOutput) {
	op := &request.Operation{
		Name:       opPutDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDetectorInput{}
	}

	output = &PutDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDetector API operation for Amazon Fraud Detector.
//
// Creates or updates a detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutDetector for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector
func (c *FraudDetector) PutDetector(input *PutDetectorInput) (*PutDetectorOutput, error) {
	req, out := c.PutDetectorRequest(input)
	return out, req.Send()
}

// PutDetectorWithContext is the same as PutDetector with the addition of
// the ability to pass a context and additional request options.
//
// See PutDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutDetectorWithContext(ctx aws.Context, input *PutDetectorInput, opts ...request.Option) (*PutDetectorOutput, error) {
	req, out := c.PutDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEntityType = "PutEntityType"

// PutEntityTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutEntityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEntityType for more information on using the PutEntityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutEntityTypeRequest method.
//	req, resp := client.PutEntityTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType
func (c *FraudDetector) PutEntityTypeRequest(input *PutEntityTypeInput) (req *request.Request, output *PutEntityTypeOutput) {
	op := &request.Operation{
		Name:       opPutEntityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEntityTypeInput{}
	}

	output = &PutEntityTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEntityType API operation for Amazon Fraud Detector.
//
// Creates or updates an entity type. An entity represents who is performing
// the event. As part of a fraud prediction, you pass the entity ID to indicate
// the specific entity who performed the event. An entity type classifies the
// entity. Example classifications include customer, merchant, or account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutEntityType for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType
func (c *FraudDetector) PutEntityType(input *PutEntityTypeInput) (*PutEntityTypeOutput, error) {
	req, out := c.PutEntityTypeRequest(input)
	return out, req.Send()
}

// PutEntityTypeWithContext is the same as PutEntityType with the addition of
// the ability to pass a context and additional request options.
//
// See PutEntityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutEntityTypeWithContext(ctx aws.Context, input *PutEntityTypeInput, opts ...request.Option) (*PutEntityTypeOutput, error) {
	req, out := c.PutEntityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventType = "PutEventType"

// PutEventTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutEventType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventType for more information on using the PutEventType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutEventTypeRequest method.
//	req, resp := client.PutEventTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType
func (c *FraudDetector) PutEventTypeRequest(input *PutEventTypeInput) (req *request.Request, output *PutEventTypeOutput) {
	op := &request.Operation{
		Name:       opPutEventType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventTypeInput{}
	}

	output = &PutEventTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEventType API operation for Amazon Fraud Detector.
//
// Creates or updates an event type. An event is a business activity that is
// evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud
// predictions for events. An event type defines the structure for an event
// sent to Amazon Fraud Detector. This includes the variables sent as part of
// the event, the entity performing the event (such as a customer), and the
// labels that classify the event. Example event types include online payment
// transactions, account registrations, and authentications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutEventType for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType
func (c *FraudDetector) PutEventType(input *PutEventTypeInput) (*PutEventTypeOutput, error) {
	req, out := c.PutEventTypeRequest(input)
	return out, req.Send()
}

// PutEventTypeWithContext is the same as PutEventType with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutEventTypeWithContext(ctx aws.Context, input *PutEventTypeInput, opts ...request.Option) (*PutEventTypeOutput, error) {
	req, out := c.PutEventTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutExternalModel = "PutExternalModel"

// PutExternalModelRequest generates a "aws/request.Request" representing the
// client's request for the PutExternalModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutExternalModel for more information on using the PutExternalModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutExternalModelRequest method.
//	req, resp := client.PutExternalModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel
func (c *FraudDetector) PutExternalModelRequest(input *PutExternalModelInput) (req *request.Request, output *PutExternalModelOutput) {
	op := &request.Operation{
		Name:       opPutExternalModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutExternalModelInput{}
	}

	output = &PutExternalModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutExternalModel API operation for Amazon Fraud Detector.
//
// Creates or updates an Amazon SageMaker model endpoint. You can also use this
// action to update the configuration of the model endpoint, including the IAM
// role and/or the mapped variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutExternalModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel
func (c *FraudDetector) PutExternalModel(input *PutExternalModelInput) (*PutExternalModelOutput, error) {
	req, out := c.PutExternalModelRequest(input)
	return out, req.Send()
}

// PutExternalModelWithContext is the same as PutExternalModel with the addition of
// the ability to pass a context and additional request options.
//
// See PutExternalModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutExternalModelWithContext(ctx aws.Context, input *PutExternalModelInput, opts ...request.Option) (*PutExternalModelOutput, error) {
	req, out := c.PutExternalModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutKMSEncryptionKey = "PutKMSEncryptionKey"

// PutKMSEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the PutKMSEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutKMSEncryptionKey for more information on using the PutKMSEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutKMSEncryptionKeyRequest method.
//	req, resp := client.PutKMSEncryptionKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey
func (c *FraudDetector) PutKMSEncryptionKeyRequest(input *PutKMSEncryptionKeyInput) (req *request.Request, output *PutKMSEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opPutKMSEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKMSEncryptionKeyInput{}
	}

	output = &PutKMSEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutKMSEncryptionKey API operation for Amazon Fraud Detector.
//
// Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutKMSEncryptionKey for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey
func (c *FraudDetector) PutKMSEncryptionKey(input *PutKMSEncryptionKeyInput) (*PutKMSEncryptionKeyOutput, error) {
	req, out := c.PutKMSEncryptionKeyRequest(input)
	return out, req.Send()
}

// PutKMSEncryptionKeyWithContext is the same as PutKMSEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See PutKMSEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutKMSEncryptionKeyWithContext(ctx aws.Context, input *PutKMSEncryptionKeyInput, opts ...request.Option) (*PutKMSEncryptionKeyOutput, error) {
	req, out := c.PutKMSEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLabel = "PutLabel"

// PutLabelRequest generates a "aws/request.Request" representing the
// client's request for the PutLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLabel for more information on using the PutLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutLabelRequest method.
//	req, resp := client.PutLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel
func (c *FraudDetector) PutLabelRequest(input *PutLabelInput) (req *request.Request, output *PutLabelOutput) {
	op := &request.Operation{
		Name:       opPutLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLabelInput{}
	}

	output = &PutLabelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLabel API operation for Amazon Fraud Detector.
//
// Creates or updates label. A label classifies an event as fraudulent or legitimate.
// Labels are associated with event types and used to train supervised machine
// learning models in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutLabel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel
func (c *FraudDetector) PutLabel(input *PutLabelInput) (*PutLabelOutput, error) {
	req, out := c.PutLabelRequest(input)
	return out, req.Send()
}

// PutLabelWithContext is the same as PutLabel with the addition of
// the ability to pass a context and additional request options.
//
// See PutLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutLabelWithContext(ctx aws.Context, input *PutLabelInput, opts ...request.Option) (*PutLabelOutput, error) {
	req, out := c.PutLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOutcome = "PutOutcome"

// PutOutcomeRequest generates a "aws/request.Request" representing the
// client's request for the PutOutcome operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOutcome for more information on using the PutOutcome
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutOutcomeRequest method.
//	req, resp := client.PutOutcomeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *FraudDetector) PutOutcomeRequest(input *PutOutcomeInput) (req *request.Request, output *PutOutcomeOutput) {
	op := &request.Operation{
		Name:       opPutOutcome,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOutcomeInput{}
	}

	output = &PutOutcomeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutOutcome API operation for Amazon Fraud Detector.
//
// Creates or updates an outcome.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutOutcome for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *FraudDetector) PutOutcome(input *PutOutcomeInput) (*PutOutcomeOutput, error) {
	req, out := c.PutOutcomeRequest(input)
	return out, req.Send()
}

// PutOutcomeWithContext is the same as PutOutcome with the addition of
// the ability to pass a context and additional request options.
//
// See PutOutcome for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutOutcomeWithContext(ctx aws.Context, input *PutOutcomeInput, opts ...request.Option) (*PutOutcomeOutput, error) {
	req, out := c.PutOutcomeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendEvent = "SendEvent"

// SendEventRequest generates a "aws/request.Request" representing the
// client's request for the SendEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEvent for more information on using the SendEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendEventRequest method.
//	req, resp := client.SendEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/SendEvent
func (c *FraudDetector) SendEventRequest(input *SendEventInput) (req *request.Request, output *SendEventOutput) {
	op := &request.Operation{
		Name:       opSendEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendEventInput{}
	}

	output = &SendEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendEvent API operation for Amazon Fraud Detector.
//
// Stores events in Amazon Fraud Detector without generating fraud predictions
// for those events. For example, you can use SendEvent to upload a historical
// dataset, which you can then later use to train a model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation SendEvent for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/SendEvent
func (c *FraudDetector) SendEvent(input *SendEventInput) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	return out, req.Send()
}

// SendEventWithContext is the same as SendEvent with the addition of
// the ability to pass a context and additional request options.
//
// See SendEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) SendEventWithContext(ctx aws.Context, input *SendEventInput, opts ...request.Option) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource
func (c *FraudDetector) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Fraud Detector.
//
// Assigns tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource
func (c *FraudDetector) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource
func (c *FraudDetector) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Fraud Detector.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource
func (c *FraudDetector) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersion = "UpdateDetectorVersion"

// UpdateDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersion for more information on using the UpdateDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDetectorVersionRequest method.
//	req, resp := client.UpdateDetectorVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion
func (c *FraudDetector) UpdateDetectorVersionRequest(input *UpdateDetectorVersionInput) (req *request.Request, output *UpdateDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionInput{}
	}

	output = &UpdateDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersion API operation for Amazon Fraud Detector.
//
// Updates a detector version. The detector version attributes that you can
// update include models, external model endpoints, rules, rule execution mode,
// and description. You can only update a DRAFT detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion
func (c *FraudDetector) UpdateDetectorVersion(input *UpdateDetectorVersionInput) (*UpdateDetectorVersionOutput, error) {
	req, out := c.UpdateDetectorVersionRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionWithContext is the same as UpdateDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionWithContext(ctx aws.Context, input *UpdateDetectorVersionInput, opts ...request.Option) (*UpdateDetectorVersionOutput, error) {
	req, out := c.UpdateDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersionMetadata = "UpdateDetectorVersionMetadata"

// UpdateDetectorVersionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersionMetadata for more information on using the UpdateDetectorVersionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDetectorVersionMetadataRequest method.
//	req, resp := client.UpdateDetectorVersionMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *FraudDetector) UpdateDetectorVersionMetadataRequest(input *UpdateDetectorVersionMetadataInput) (req *request.Request, output *UpdateDetectorVersionMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionMetadataInput{}
	}

	output = &UpdateDetectorVersionMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersionMetadata API operation for Amazon Fraud Detector.
//
// Updates the detector version's description. You can update the metadata for
// any detector version (DRAFT, ACTIVE, or INACTIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersionMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *FraudDetector) UpdateDetectorVersionMetadata(input *UpdateDetectorVersionMetadataInput) (*UpdateDetectorVersionMetadataOutput, error) {
	req, out := c.UpdateDetectorVersionMetadataRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionMetadataWithContext is the same as UpdateDetectorVersionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionMetadataWithContext(ctx aws.Context, input *UpdateDetectorVersionMetadataInput, opts ...request.Option) (*UpdateDetectorVersionMetadataOutput, error) {
	req, out := c.UpdateDetectorVersionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersionStatus = "UpdateDetectorVersionStatus"

// UpdateDetectorVersionStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersionStatus for more information on using the UpdateDetectorVersionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDetectorVersionStatusRequest method.
//	req, resp := client.UpdateDetectorVersionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *FraudDetector) UpdateDetectorVersionStatusRequest(input *UpdateDetectorVersionStatusInput) (req *request.Request, output *UpdateDetectorVersionStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionStatusInput{}
	}

	output = &UpdateDetectorVersionStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersionStatus API operation for Amazon Fraud Detector.
//
// Updates the detector version’s status. You can perform the following promotions
// or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to
// INACTIVE, and INACTIVE to ACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *FraudDetector) UpdateDetectorVersionStatus(input *UpdateDetectorVersionStatusInput) (*UpdateDetectorVersionStatusOutput, error) {
	req, out := c.UpdateDetectorVersionStatusRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionStatusWithContext is the same as UpdateDetectorVersionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionStatusWithContext(ctx aws.Context, input *UpdateDetectorVersionStatusInput, opts ...request.Option) (*UpdateDetectorVersionStatusOutput, error) {
	req, out := c.UpdateDetectorVersionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventLabel = "UpdateEventLabel"

// UpdateEventLabelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventLabel for more information on using the UpdateEventLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEventLabelRequest method.
//	req, resp := client.UpdateEventLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateEventLabel
func (c *FraudDetector) UpdateEventLabelRequest(input *UpdateEventLabelInput) (req *request.Request, output *UpdateEventLabelOutput) {
	op := &request.Operation{
		Name:       opUpdateEventLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEventLabelInput{}
	}

	output = &UpdateEventLabelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEventLabel API operation for Amazon Fraud Detector.
//
// Updates the specified event with a new label.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateEventLabel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateEventLabel
func (c *FraudDetector) UpdateEventLabel(input *UpdateEventLabelInput) (*UpdateEventLabelOutput, error) {
	req, out := c.UpdateEventLabelRequest(input)
	return out, req.Send()
}

// UpdateEventLabelWithContext is the same as UpdateEventLabel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateEventLabelWithContext(ctx aws.Context, input *UpdateEventLabelInput, opts ...request.Option) (*UpdateEventLabelOutput, error) {
	req, out := c.UpdateEventLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateList = "UpdateList"

// UpdateListRequest generates a "aws/request.Request" representing the
// client's request for the UpdateList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateList for more information on using the UpdateList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateListRequest method.
//	req, resp := client.UpdateListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateList
func (c *FraudDetector) UpdateListRequest(input *UpdateListInput) (req *request.Request, output *UpdateListOutput) {
	op := &request.Operation{
		Name:       opUpdateList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateListInput{}
	}

	output = &UpdateListOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateList API operation for Amazon Fraud Detector.
//
// Updates a list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateList for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateList
func (c *FraudDetector) UpdateList(input *UpdateListInput) (*UpdateListOutput, error) {
	req, out := c.UpdateListRequest(input)
	return out, req.Send()
}

// UpdateListWithContext is the same as UpdateList with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateListWithContext(ctx aws.Context, input *UpdateListInput, opts ...request.Option) (*UpdateListOutput, error) {
	req, out := c.UpdateListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModel for more information on using the UpdateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateModelRequest method.
//	req, resp := client.UpdateModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel
func (c *FraudDetector) UpdateModelRequest(input *UpdateModelInput) (req *request.Request, output *UpdateModelOutput) {
	op := &request.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	output = &UpdateModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateModel API operation for Amazon Fraud Detector.
//
// Updates model description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel
func (c *FraudDetector) UpdateModel(input *UpdateModelInput) (*UpdateModelOutput, error) {
	req, out := c.UpdateModelRequest(input)
	return out, req.Send()
}

// UpdateModelWithContext is the same as UpdateModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelWithContext(ctx aws.Context, input *UpdateModelInput, opts ...request.Option) (*UpdateModelOutput, error) {
	req, out := c.UpdateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelVersion = "UpdateModelVersion"

// UpdateModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelVersion for more information on using the UpdateModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateModelVersionRequest method.
//	req, resp := client.UpdateModelVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *FraudDetector) UpdateModelVersionRequest(input *UpdateModelVersionInput) (req *request.Request, output *UpdateModelVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionInput{}
	}

	output = &UpdateModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateModelVersion API operation for Amazon Fraud Detector.
//
// Updates a model version. Updating a model version retrains an existing model
// version using updated training data and produces a new minor version of the
// model. You can update the training data set location and data access role
// attributes using this action. This action creates and trains a new minor
// version of the model, for example version 1.01, 1.02, 1.03.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModelVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *FraudDetector) UpdateModelVersion(input *UpdateModelVersionInput) (*UpdateModelVersionOutput, error) {
	req, out := c.UpdateModelVersionRequest(input)
	return out, req.Send()
}

// UpdateModelVersionWithContext is the same as UpdateModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelVersionWithContext(ctx aws.Context, input *UpdateModelVersionInput, opts ...request.Option) (*UpdateModelVersionOutput, error) {
	req, out := c.UpdateModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelVersionStatus = "UpdateModelVersionStatus"

// UpdateModelVersionStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelVersionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelVersionStatus for more information on using the UpdateModelVersionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateModelVersionStatusRequest method.
//	req, resp := client.UpdateModelVersionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus
func (c *FraudDetector) UpdateModelVersionStatusRequest(input *UpdateModelVersionStatusInput) (req *request.Request, output *UpdateModelVersionStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateModelVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionStatusInput{}
	}

	output = &UpdateModelVersionStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateModelVersionStatus API operation for Amazon Fraud Detector.
//
// Updates the status of a model version.
//
// You can perform the following status updates:
//
// Change the TRAINING_IN_PROGRESS status to TRAINING_CANCELLED.
//
// Change the TRAINING_COMPLETE status to ACTIVE.
//
// Change ACTIVE to INACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModelVersionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus
func (c *FraudDetector) UpdateModelVersionStatus(input *UpdateModelVersionStatusInput) (*UpdateModelVersionStatusOutput, error) {
	req, out := c.UpdateModelVersionStatusRequest(input)
	return out, req.Send()
}

// UpdateModelVersionStatusWithContext is the same as UpdateModelVersionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelVersionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelVersionStatusWithContext(ctx aws.Context, input *UpdateModelVersionStatusInput, opts ...request.Option) (*UpdateModelVersionStatusOutput, error) {
	req, out := c.UpdateModelVersionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleMetadata = "UpdateRuleMetadata"

// UpdateRuleMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleMetadata for more information on using the UpdateRuleMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuleMetadataRequest method.
//	req, resp := client.UpdateRuleMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *FraudDetector) UpdateRuleMetadataRequest(input *UpdateRuleMetadataInput) (req *request.Request, output *UpdateRuleMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleMetadataInput{}
	}

	output = &UpdateRuleMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRuleMetadata API operation for Amazon Fraud Detector.
//
// Updates a rule's metadata. The description attribute can be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateRuleMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *FraudDetector) UpdateRuleMetadata(input *UpdateRuleMetadataInput) (*UpdateRuleMetadataOutput, error) {
	req, out := c.UpdateRuleMetadataRequest(input)
	return out, req.Send()
}

// UpdateRuleMetadataWithContext is the same as UpdateRuleMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateRuleMetadataWithContext(ctx aws.Context, input *UpdateRuleMetadataInput, opts ...request.Option) (*UpdateRuleMetadataOutput, error) {
	req, out := c.UpdateRuleMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleVersion = "UpdateRuleVersion"

// UpdateRuleVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleVersion for more information on using the UpdateRuleVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuleVersionRequest method.
//	req, resp := client.UpdateRuleVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *FraudDetector) UpdateRuleVersionRequest(input *UpdateRuleVersionInput) (req *request.Request, output *UpdateRuleVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleVersionInput{}
	}

	output = &UpdateRuleVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleVersion API operation for Amazon Fraud Detector.
//
// Updates a rule version resulting in a new rule version. Updates a rule version
// resulting in a new rule version (version 1, 2, 3 ...).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateRuleVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *FraudDetector) UpdateRuleVersion(input *UpdateRuleVersionInput) (*UpdateRuleVersionOutput, error) {
	req, out := c.UpdateRuleVersionRequest(input)
	return out, req.Send()
}

// UpdateRuleVersionWithContext is the same as UpdateRuleVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateRuleVersionWithContext(ctx aws.Context, input *UpdateRuleVersionInput, opts ...request.Option) (*UpdateRuleVersionOutput, error) {
	req, out := c.UpdateRuleVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVariable = "UpdateVariable"

// UpdateVariableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVariable for more information on using the UpdateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVariableRequest method.
//	req, resp := client.UpdateVariableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable
func (c *FraudDetector) UpdateVariableRequest(input *UpdateVariableInput) (req *request.Request, output *UpdateVariableOutput) {
	op := &request.Operation{
		Name:       opUpdateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVariableInput{}
	}

	output = &UpdateVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateVariable API operation for Amazon Fraud Detector.
//
// Updates a variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateVariable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception indicating a specified value is not allowed.
//
//   - ResourceNotFoundException
//     An exception indicating the specified resource was not found.
//
//   - InternalServerException
//     An exception indicating an internal server error.
//
//   - ThrottlingException
//     An exception indicating a throttling error.
//
//   - AccessDeniedException
//     An exception indicating Amazon Fraud Detector does not have the needed permissions.
//     This can occur if you submit a request, such as PutExternalModel, that specifies
//     a role that is not in your account.
//
//   - ConflictException
//     An exception indicating there was a conflict during a delete operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable
func (c *FraudDetector) UpdateVariable(input *UpdateVariableInput) (*UpdateVariableOutput, error) {
	req, out := c.UpdateVariableRequest(input)
	return out, req.Send()
}

// UpdateVariableWithContext is the same as UpdateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateVariableWithContext(ctx aws.Context, input *UpdateVariableInput, opts ...request.Option) (*UpdateVariableOutput, error) {
	req, out := c.UpdateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The Account Takeover Insights (ATI) model performance metrics data points.
type ATIMetricDataPoint struct {
	_ struct{} `type:"structure"`

	// The anomaly discovery rate. This metric quantifies the percentage of anomalies
	// that can be detected by the model at the selected score threshold. A lower
	// score threshold increases the percentage of anomalies captured by the model,
	// but would also require challenging a larger percentage of login events, leading
	// to a higher customer friction.
	Adr *float64 `locationName:"adr" type:"float"`

	// The account takeover discovery rate. This metric quantifies the percentage
	// of account compromise events that can be detected by the model at the selected
	// score threshold. This metric is only available if 50 or more entities with
	// at-least one labeled account takeover event is present in the ingested dataset.
	Atodr *float64 `locationName:"atodr" type:"float"`

	// The challenge rate. This indicates the percentage of login events that the
	// model recommends to challenge such as one-time password, multi-factor authentication,
	// and investigations.
	Cr *float64 `locationName:"cr" type:"float"`

	// The model's threshold that specifies an acceptable fraud capture rate. For
	// example, a threshold of 500 means any model score 500 or above is labeled
	// as fraud.
	Threshold *float64 `locationName:"threshold" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ATIMetricDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ATIMetricDataPoint) GoString() string {
	return s.String()
}

// SetAdr sets the Adr field's value.
func (s *ATIMetricDataPoint) SetAdr(v float64) *ATIMetricDataPoint {
	s.Adr = &v
	return s
}

// SetAtodr sets the Atodr field's value.
func (s *ATIMetricDataPoint) SetAtodr(v float64) *ATIMetricDataPoint {
	s.Atodr = &v
	return s
}

// SetCr sets the Cr field's value.
func (s *ATIMetricDataPoint) SetCr(v float64) *ATIMetricDataPoint {
	s.Cr = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *ATIMetricDataPoint) SetThreshold(v float64) *ATIMetricDataPoint {
	s.Threshold = &v
	return s
}

// The Account Takeover Insights (ATI) model performance score.
type ATIModelPerformance struct {
	_ struct{} `type:"structure"`

	// The anomaly separation index (ASI) score. This metric summarizes the overall
	// ability of the model to separate anomalous activities from the normal behavior.
	// Depending on the business, a large fraction of these anomalous activities
	// can be malicious and correspond to the account takeover attacks. A model
	// with no separability power will have the lowest possible ASI score of 0.5,
	// whereas the a model with a high separability power will have the highest
	// possible ASI score of 1.0
	Asi *float64 `locationName:"asi" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ATIModelPerformance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ATIModelPerformance) GoString() string {
	return s.String()
}

// SetAsi sets the Asi field's value.
func (s *ATIModelPerformance) SetAsi(v float64) *ATIModelPerformance {
	s.Asi = &v
	return s
}

// The Account Takeover Insights (ATI) model training metric details.
type ATITrainingMetricsValue struct {
	_ struct{} `type:"structure"`

	// The model's performance metrics data points.
	MetricDataPoints []*ATIMetricDataPoint `locationName:"metricDataPoints" type:"list"`

	// The model's overall performance scores.
	ModelPerformance *ATIModelPerformance `locationName:"modelPerformance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ATITrainingMetricsValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ATITrainingMetricsValue) GoString() string {
	return s.String()
}

// SetMetricDataPoints sets the MetricDataPoints field's value.
func (s *ATITrainingMetricsValue) SetMetricDataPoints(v []*ATIMetricDataPoint) *ATITrainingMetricsValue {
	s.MetricDataPoints = v
	return s
}

// SetModelPerformance sets the ModelPerformance field's value.
func (s *ATITrainingMetricsValue) SetModelPerformance(v *ATIModelPerformance) *ATITrainingMetricsValue {
	s.ModelPerformance = v
	return s
}

// An exception indicating Amazon Fraud Detector does not have the needed permissions.
// This can occur if you submit a request, such as PutExternalModel, that specifies
// a role that is not in your account.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The log odds metric details.
//
// Account Takeover Insights (ATI) model uses event variables from the login
// data you provide to continuously calculate a set of variables (aggregated
// variables) based on historical events. For example, your ATI model might
// calculate the number of times an user has logged in using the same IP address.
// In this case, event variables used to derive the aggregated variables are
// IP address and user.
type AggregatedLogOddsMetric struct {
	_ struct{} `type:"structure"`

	// The relative importance of the variables in the list to the other event variable.
	//
	// AggregatedVariablesImportance is a required field
	AggregatedVariablesImportance *float64 `locationName:"aggregatedVariablesImportance" type:"float" required:"true"`

	// The names of all the variables.
	//
	// VariableNames is a required field
	VariableNames []*string `locationName:"variableNames" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedLogOddsMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedLogOddsMetric) GoString() string {
	return s.String()
}

// SetAggregatedVariablesImportance sets the AggregatedVariablesImportance field's value.
func (s *AggregatedLogOddsMetric) SetAggregatedVariablesImportance(v float64) *AggregatedLogOddsMetric {
	s.AggregatedVariablesImportance = &v
	return s
}

// SetVariableNames sets the VariableNames field's value.
func (s *AggregatedLogOddsMetric) SetVariableNames(v []*string) *AggregatedLogOddsMetric {
	s.VariableNames = v
	return s
}

// The details of the impact of aggregated variables on the prediction score.
//
// Account Takeover Insights (ATI) model uses the login data you provide to
// continuously calculate a set of variables (aggregated variables) based on
// historical events. For example, the model might calculate the number of times
// an user has logged in using the same IP address. In this case, event variables
// used to derive the aggregated variables are IP address and user.
type AggregatedVariablesImpactExplanation struct {
	_ struct{} `type:"structure"`

	// The names of all the event variables that were used to derive the aggregated
	// variables.
	EventVariableNames []*string `locationName:"eventVariableNames" type:"list"`

	// The raw, uninterpreted value represented as log-odds of the fraud. These
	// values are usually between -10 to +10, but range from -infinity to +infinity.
	//
	//    * A positive value indicates that the variables drove the risk score up.
	//
	//    * A negative value indicates that the variables drove the risk score down.
	LogOddsImpact *float64 `locationName:"logOddsImpact" type:"float"`

	// The relative impact of the aggregated variables in terms of magnitude on
	// the prediction scores.
	RelativeImpact *string `locationName:"relativeImpact" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedVariablesImpactExplanation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedVariablesImpactExplanation) GoString() string {
	return s.String()
}

// SetEventVariableNames sets the EventVariableNames field's value.
func (s *AggregatedVariablesImpactExplanation) SetEventVariableNames(v []*string) *AggregatedVariablesImpactExplanation {
	s.EventVariableNames = v
	return s
}

// SetLogOddsImpact sets the LogOddsImpact field's value.
func (s *AggregatedVariablesImpactExplanation) SetLogOddsImpact(v float64) *AggregatedVariablesImpactExplanation {
	s.LogOddsImpact = &v
	return s
}

// SetRelativeImpact sets the RelativeImpact field's value.
func (s *AggregatedVariablesImpactExplanation) SetRelativeImpact(v string) *AggregatedVariablesImpactExplanation {
	s.RelativeImpact = &v
	return s
}

// The details of the relative importance of the aggregated variables.
//
// Account Takeover Insights (ATI) model uses event variables from the login
// data you provide to continuously calculate a set of variables (aggregated
// variables) based on historical events. For example, your ATI model might
// calculate the number of times an user has logged in using the same IP address.
// In this case, event variables used to derive the aggregated variables are
// IP address and user.
type AggregatedVariablesImportanceMetrics struct {
	_ struct{} `type:"structure"`

	// List of variables' metrics.
	LogOddsMetrics []*AggregatedLogOddsMetric `locationName:"logOddsMetrics" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedVariablesImportanceMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedVariablesImportanceMetrics) GoString() string {
	return s.String()
}

// SetLogOddsMetrics sets the LogOddsMetrics field's value.
func (s *AggregatedVariablesImportanceMetrics) SetLogOddsMetrics(v []*AggregatedLogOddsMetric) *AggregatedVariablesImportanceMetrics {
	s.LogOddsMetrics = v
	return s
}

// The metadata of a list.
type AllowDenyList struct {
	_ struct{} `type:"structure"`

	// The ARN of the list.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time the list was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The description of the list.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the list.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The time the list was last updated.
	UpdatedTime *string `locationName:"updatedTime" min:"11" type:"string"`

	// The variable type of the list.
	VariableType *string `locationName:"variableType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowDenyList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowDenyList) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AllowDenyList) SetArn(v string) *AllowDenyList {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AllowDenyList) SetCreatedTime(v string) *AllowDenyList {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AllowDenyList) SetDescription(v string) *AllowDenyList {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AllowDenyList) SetName(v string) *AllowDenyList {
	s.Name = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *AllowDenyList) SetUpdatedTime(v string) *AllowDenyList {
	s.UpdatedTime = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *AllowDenyList) SetVariableType(v string) *AllowDenyList {
	s.VariableType = &v
	return s
}

// Provides the error of the batch create variable API.
type BatchCreateVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVariableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVariableError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchCreateVariableError) SetCode(v int64) *BatchCreateVariableError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchCreateVariableError) SetMessage(v string) *BatchCreateVariableError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchCreateVariableError) SetName(v string) *BatchCreateVariableError {
	s.Name = &v
	return s
}

type BatchCreateVariableInput struct {
	_ struct{} `type:"structure"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The list of variables for the batch create variable request.
	//
	// VariableEntries is a required field
	VariableEntries []*VariableEntry `locationName:"variableEntries" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateVariableInput"}
	if s.VariableEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("VariableEntries"))
	}
	if s.VariableEntries != nil && len(s.VariableEntries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VariableEntries", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *BatchCreateVariableInput) SetTags(v []*Tag) *BatchCreateVariableInput {
	s.Tags = v
	return s
}

// SetVariableEntries sets the VariableEntries field's value.
func (s *BatchCreateVariableInput) SetVariableEntries(v []*VariableEntry) *BatchCreateVariableInput {
	s.VariableEntries = v
	return s
}

type BatchCreateVariableOutput struct {
	_ struct{} `type:"structure"`

	// Provides the errors for the BatchCreateVariable request.
	Errors []*BatchCreateVariableError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateVariableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateVariableOutput) SetErrors(v []*BatchCreateVariableError) *BatchCreateVariableOutput {
	s.Errors = v
	return s
}

// Provides the error of the batch get variable API.
type BatchGetVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The error name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVariableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVariableError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchGetVariableError) SetCode(v int64) *BatchGetVariableError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetVariableError) SetMessage(v string) *BatchGetVariableError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchGetVariableError) SetName(v string) *BatchGetVariableError {
	s.Name = &v
	return s
}

type BatchGetVariableInput struct {
	_ struct{} `type:"structure"`

	// The list of variable names to get.
	//
	// Names is a required field
	Names []*string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetVariableInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *BatchGetVariableInput) SetNames(v []*string) *BatchGetVariableInput {
	s.Names = v
	return s
}

type BatchGetVariableOutput struct {
	_ struct{} `type:"structure"`

	// The errors from the request.
	Errors []*BatchGetVariableError `locationName:"errors" type:"list"`

	// The returned variables.
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVariableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetVariableOutput) SetErrors(v []*BatchGetVariableError) *BatchGetVariableOutput {
	s.Errors = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *BatchGetVariableOutput) SetVariables(v []*Variable) *BatchGetVariableOutput {
	s.Variables = v
	return s
}

// The batch import job details.
type BatchImport struct {
	_ struct{} `type:"structure"`

	// The ARN of the batch import job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when batch import job completed.
	CompletionTime *string `locationName:"completionTime" min:"11" type:"string"`

	// The name of the event type.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The number of records that failed to import.
	FailedRecordsCount *int64 `locationName:"failedRecordsCount" type:"integer"`

	// The reason batch import job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the IAM role to use for this job request.
	IamRoleArn *string `locationName:"iamRoleArn" min:"1" type:"string"`

	// The Amazon S3 location of your data file for batch import.
	InputPath *string `locationName:"inputPath" min:"1" type:"string"`

	// The ID of the batch import job.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The Amazon S3 location of your output file.
	OutputPath *string `locationName:"outputPath" min:"1" type:"string"`

	// The number of records processed by batch import job.
	ProcessedRecordsCount *int64 `locationName:"processedRecordsCount" type:"integer"`

	// Timestamp of when the batch import job started.
	StartTime *string `locationName:"startTime" min:"11" type:"string"`

	// The status of the batch import job.
	Status *string `locationName:"status" type:"string" enum:"AsyncJobStatus"`

	// The total number of records in the batch import job.
	TotalRecordsCount *int64 `locationName:"totalRecordsCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchImport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchImport) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchImport) SetArn(v string) *BatchImport {
	s.Arn = &v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *BatchImport) SetCompletionTime(v string) *BatchImport {
	s.CompletionTime = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *BatchImport) SetEventTypeName(v string) *BatchImport {
	s.EventTypeName = &v
	return s
}

// SetFailedRecordsCount sets the FailedRecordsCount field's value.
func (s *BatchImport) SetFailedRecordsCount(v int64) *BatchImport {
	s.FailedRecordsCount = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BatchImport) SetFailureReason(v string) *BatchImport {
	s.FailureReason = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *BatchImport) SetIamRoleArn(v string) *BatchImport {
	s.IamRoleArn = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *BatchImport) SetInputPath(v string) *BatchImport {
	s.InputPath = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *BatchImport) SetJobId(v string) *BatchImport {
	s.JobId = &v
	return s
}

// SetOutputPath sets the OutputPath field's value.
func (s *BatchImport) SetOutputPath(v string) *BatchImport {
	s.OutputPath = &v
	return s
}

// SetProcessedRecordsCount sets the ProcessedRecordsCount field's value.
func (s *BatchImport) SetProcessedRecordsCount(v int64) *BatchImport {
	s.ProcessedRecordsCount = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BatchImport) SetStartTime(v string) *BatchImport {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchImport) SetStatus(v string) *BatchImport {
	s.Status = &v
	return s
}

// SetTotalRecordsCount sets the TotalRecordsCount field's value.
func (s *BatchImport) SetTotalRecordsCount(v int64) *BatchImport {
	s.TotalRecordsCount = &v
	return s
}

// The batch prediction details.
type BatchPrediction struct {
	_ struct{} `type:"structure"`

	// The ARN of batch prediction job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the batch prediction job completed.
	CompletionTime *string `locationName:"completionTime" min:"11" type:"string"`

	// The name of the detector.
	DetectorName *string `locationName:"detectorName" min:"1" type:"string"`

	// The detector version.
	DetectorVersion *string `locationName:"detectorVersion" min:"3" type:"string"`

	// The name of the event type.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The reason a batch prediction job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the IAM role to use for this job request.
	IamRoleArn *string `locationName:"iamRoleArn" min:"1" type:"string"`

	// The Amazon S3 location of your training file.
	InputPath *string `locationName:"inputPath" min:"1" type:"string"`

	// The job ID for the batch prediction.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// Timestamp of most recent heartbeat indicating the batch prediction job was
	// making progress.
	LastHeartbeatTime *string `locationName:"lastHeartbeatTime" min:"11" type:"string"`

	// The Amazon S3 location of your output file.
	OutputPath *string `locationName:"outputPath" min:"1" type:"string"`

	// The number of records processed by the batch prediction job.
	ProcessedRecordsCount *int64 `locationName:"processedRecordsCount" type:"integer"`

	// Timestamp of when the batch prediction job started.
	StartTime *string `locationName:"startTime" min:"11" type:"string"`

	// The batch prediction status.
	Status *string `locationName:"status" type:"string" enum:"AsyncJobStatus"`

	// The total number of records in the batch prediction job.
	TotalRecordsCount *int64 `locationName:"totalRecordsCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPrediction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPrediction) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchPrediction) SetArn(v string) *BatchPrediction {
	s.Arn = &v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *BatchPrediction) SetCompletionTime(v string) *BatchPrediction {
	s.CompletionTime = &v
	return s
}

// SetDetectorName sets the DetectorName field's value.
func (s *BatchPrediction) SetDetectorName(v string) *BatchPrediction {
	s.DetectorName = &v
	return s
}

// SetDetectorVersion sets the DetectorVersion field's value.
func (s *BatchPrediction) SetDetectorVersion(v string) *BatchPrediction {
	s.DetectorVersion = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *BatchPrediction) SetEventTypeName(v string) *BatchPrediction {
	s.EventTypeName = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BatchPrediction) SetFailureReason(v string) *BatchPrediction {
	s.FailureReason = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *BatchPrediction) SetIamRoleArn(v string) *BatchPrediction {
	s.IamRoleArn = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *BatchPrediction) SetInputPath(v string) *BatchPrediction {
	s.InputPath = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *BatchPrediction) SetJobId(v string) *BatchPrediction {
	s.JobId = &v
	return s
}

// SetLastHeartbeatTime sets the LastHeartbeatTime field's value.
func (s *BatchPrediction) SetLastHeartbeatTime(v string) *BatchPrediction {
	s.LastHeartbeatTime = &v
	return s
}

// SetOutputPath sets the OutputPath field's value.
func (s *BatchPrediction) SetOutputPath(v string) *BatchPrediction {
	s.OutputPath = &v
	return s
}

// SetProcessedRecordsCount sets the ProcessedRecordsCount field's value.
func (s *BatchPrediction) SetProcessedRecordsCount(v int64) *BatchPrediction {
	s.ProcessedRecordsCount = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BatchPrediction) SetStartTime(v string) *BatchPrediction {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchPrediction) SetStatus(v string) *BatchPrediction {
	s.Status = &v
	return s
}

// SetTotalRecordsCount sets the TotalRecordsCount field's value.
func (s *BatchPrediction) SetTotalRecordsCount(v int64) *BatchPrediction {
	s.TotalRecordsCount = &v
	return s
}

type CancelBatchImportJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of an in-progress batch import job to cancel.
	//
	// Amazon Fraud Detector will throw an error if the batch import job is in FAILED,
	// CANCELED, or COMPLETED state.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelBatchImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelBatchImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelBatchImportJobInput) SetJobId(v string) *CancelBatchImportJobInput {
	s.JobId = &v
	return s
}

type CancelBatchImportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchImportJobOutput) GoString() string {
	return s.String()
}

type CancelBatchPredictionJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch prediction job to cancel.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchPredictionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchPredictionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelBatchPredictionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelBatchPredictionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelBatchPredictionJobInput) SetJobId(v string) *CancelBatchPredictionJobInput {
	s.JobId = &v
	return s
}

type CancelBatchPredictionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchPredictionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchPredictionJobOutput) GoString() string {
	return s.String()
}

// An exception indicating there was a conflict during a delete operation.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateBatchImportJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role created for Amazon S3 bucket that holds your data
	// file.
	//
	// The IAM role must have read permissions to your input S3 bucket and write
	// permissions to your output S3 bucket. For more information about bucket permissions,
	// see User policy examples (https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html)
	// in the Amazon S3 User Guide.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `locationName:"iamRoleArn" min:"1" type:"string" required:"true"`

	// The URI that points to the Amazon S3 location of your data file.
	//
	// InputPath is a required field
	InputPath *string `locationName:"inputPath" min:"1" type:"string" required:"true"`

	// The ID of the batch import job. The ID cannot be of a past job, unless the
	// job exists in CREATE_FAILED state.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// The URI that points to the Amazon S3 location for storing your results.
	//
	// OutputPath is a required field
	OutputPath *string `locationName:"outputPath" min:"1" type:"string" required:"true"`

	// A collection of key-value pairs associated with this request.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBatchImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBatchImportJobInput"}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 1))
	}
	if s.InputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("InputPath"))
	}
	if s.InputPath != nil && len(*s.InputPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputPath", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputPath"))
	}
	if s.OutputPath != nil && len(*s.OutputPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputPath", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *CreateBatchImportJobInput) SetEventTypeName(v string) *CreateBatchImportJobInput {
	s.EventTypeName = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateBatchImportJobInput) SetIamRoleArn(v string) *CreateBatchImportJobInput {
	s.IamRoleArn = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *CreateBatchImportJobInput) SetInputPath(v string) *CreateBatchImportJobInput {
	s.InputPath = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBatchImportJobInput) SetJobId(v string) *CreateBatchImportJobInput {
	s.JobId = &v
	return s
}

// SetOutputPath sets the OutputPath field's value.
func (s *CreateBatchImportJobInput) SetOutputPath(v string) *CreateBatchImportJobInput {
	s.OutputPath = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBatchImportJobInput) SetTags(v []*Tag) *CreateBatchImportJobInput {
	s.Tags = v
	return s
}

type CreateBatchImportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchImportJobOutput) GoString() string {
	return s.String()
}

type CreateBatchPredictionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector.
	//
	// DetectorName is a required field
	DetectorName *string `locationName:"detectorName" min:"1" type:"string" required:"true"`

	// The detector version.
	DetectorVersion *string `locationName:"detectorVersion" min:"1" type:"string"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role to use for this job request.
	//
	// The IAM Role must have read permissions to your input S3 bucket and write
	// permissions to your output S3 bucket. For more information about bucket permissions,
	// see User policy examples (https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html)
	// in the Amazon S3 User Guide.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `locationName:"iamRoleArn" min:"1" type:"string" required:"true"`

	// The Amazon S3 location of your training file.
	//
	// InputPath is a required field
	InputPath *string `locationName:"inputPath" min:"1" type:"string" required:"true"`

	// The ID of the batch prediction job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// The Amazon S3 location of your output file.
	//
	// OutputPath is a required field
	OutputPath *string `locationName:"outputPath" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchPredictionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchPredictionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBatchPredictionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBatchPredictionJobInput"}
	if s.DetectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorName"))
	}
	if s.DetectorName != nil && len(*s.DetectorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorName", 1))
	}
	if s.DetectorVersion != nil && len(*s.DetectorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersion", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 1))
	}
	if s.InputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("InputPath"))
	}
	if s.InputPath != nil && len(*s.InputPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputPath", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputPath"))
	}
	if s.OutputPath != nil && len(*s.OutputPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputPath", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorName sets the DetectorName field's value.
func (s *CreateBatchPredictionJobInput) SetDetectorName(v string) *CreateBatchPredictionJobInput {
	s.DetectorName = &v
	return s
}

// SetDetectorVersion sets the DetectorVersion field's value.
func (s *CreateBatchPredictionJobInput) SetDetectorVersion(v string) *CreateBatchPredictionJobInput {
	s.DetectorVersion = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *CreateBatchPredictionJobInput) SetEventTypeName(v string) *CreateBatchPredictionJobInput {
	s.EventTypeName = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateBatchPredictionJobInput) SetIamRoleArn(v string) *CreateBatchPredictionJobInput {
	s.IamRoleArn = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *CreateBatchPredictionJobInput) SetInputPath(v string) *CreateBatchPredictionJobInput {
	s.InputPath = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBatchPredictionJobInput) SetJobId(v string) *CreateBatchPredictionJobInput {
	s.JobId = &v
	return s
}

// SetOutputPath sets the OutputPath field's value.
func (s *CreateBatchPredictionJobInput) SetOutputPath(v string) *CreateBatchPredictionJobInput {
	s.OutputPath = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBatchPredictionJobInput) SetTags(v []*Tag) *CreateBatchPredictionJobInput {
	s.Tags = v
	return s
}

type CreateBatchPredictionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchPredictionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchPredictionJobOutput) GoString() string {
	return s.String()
}

type CreateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the detector under which you want to create a new version.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The Amazon Sagemaker model endpoints to include in the detector version.
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list"`

	// The model versions to include in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rule execution mode for the rules included in the detector version.
	//
	// You can define and edit the rule mode at the detector version level, when
	// it is in draft status.
	//
	// If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules.
	//
	// The default behavior is FIRST_MATCHED.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDetectorVersionInput) SetDescription(v string) *CreateDetectorVersionInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorVersionInput) SetDetectorId(v string) *CreateDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *CreateDetectorVersionInput) SetExternalModelEndpoints(v []*string) *CreateDetectorVersionInput {
	s.ExternalModelEndpoints = v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *CreateDetectorVersionInput) SetModelVersions(v []*ModelVersion) *CreateDetectorVersionInput {
	s.ModelVersions = v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *CreateDetectorVersionInput) SetRuleExecutionMode(v string) *CreateDetectorVersionInput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateDetectorVersionInput) SetRules(v []*Rule) *CreateDetectorVersionInput {
	s.Rules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDetectorVersionInput) SetTags(v []*Tag) *CreateDetectorVersionInput {
	s.Tags = v
	return s
}

type CreateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the created version's parent detector.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The ID for the created detector.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The status of the detector version.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDetectorVersionOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorVersionOutput) SetDetectorId(v string) *CreateDetectorVersionOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *CreateDetectorVersionOutput) SetDetectorVersionId(v string) *CreateDetectorVersionOutput {
	s.DetectorVersionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDetectorVersionOutput) SetStatus(v string) *CreateDetectorVersionOutput {
	s.Status = &v
	return s
}

type CreateListInput struct {
	_ struct{} `type:"structure"`

	// The description of the list.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The names of the elements, if providing. You can also create an empty list
	// and add elements later using the UpdateList (https://docs.aws.amazon.com/frauddetector/latest/api/API_Updatelist.html)
	// API.
	Elements []*string `locationName:"elements" type:"list"`

	// The name of the list.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of the key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The variable type of the list. You can only assign the variable type with
	// String data type. For more information, see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	VariableType *string `locationName:"variableType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateListInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VariableType != nil && len(*s.VariableType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VariableType", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateListInput) SetDescription(v string) *CreateListInput {
	s.Description = &v
	return s
}

// SetElements sets the Elements field's value.
func (s *CreateListInput) SetElements(v []*string) *CreateListInput {
	s.Elements = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateListInput) SetName(v string) *CreateListInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateListInput) SetTags(v []*Tag) *CreateListInput {
	s.Tags = v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *CreateListInput) SetVariableType(v string) *CreateListInput {
	s.VariableType = &v
	return s
}

type CreateListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListOutput) GoString() string {
	return s.String()
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateModelInput) SetDescription(v string) *CreateModelInput {
	s.Description = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *CreateModelInput) SetEventTypeName(v string) *CreateModelInput {
	s.EventTypeName = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelInput) SetModelId(v string) *CreateModelInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelInput) SetModelType(v string) *CreateModelInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelInput) SetTags(v []*Tag) *CreateModelInput {
	s.Tags = v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelOutput) GoString() string {
	return s.String()
}

type CreateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// Details of the external events data used for model version training. Required
	// if trainingDataSource is EXTERNAL_EVENTS.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// Details of the ingested events data used for model version training. Required
	// if trainingDataSource is INGESTED_EVENTS.
	IngestedEventsDetail *IngestedEventsDetail `locationName:"ingestedEventsDetail" type:"structure"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The training data schema.
	//
	// TrainingDataSchema is a required field
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure" required:"true"`

	// The training data source location in Amazon S3.
	//
	// TrainingDataSource is a required field
	TrainingDataSource *string `locationName:"trainingDataSource" type:"string" required:"true" enum:"TrainingDataSourceEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelVersionInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.TrainingDataSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataSchema"))
	}
	if s.TrainingDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataSource"))
	}
	if s.ExternalEventsDetail != nil {
		if err := s.ExternalEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("ExternalEventsDetail", err.(request.ErrInvalidParams))
		}
	}
	if s.IngestedEventsDetail != nil {
		if err := s.IngestedEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("IngestedEventsDetail", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrainingDataSchema != nil {
		if err := s.TrainingDataSchema.Validate(); err != nil {
			invalidParams.AddNested("TrainingDataSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *CreateModelVersionInput) SetExternalEventsDetail(v *ExternalEventsDetail) *CreateModelVersionInput {
	s.ExternalEventsDetail = v
	return s
}

// SetIngestedEventsDetail sets the IngestedEventsDetail field's value.
func (s *CreateModelVersionInput) SetIngestedEventsDetail(v *IngestedEventsDetail) *CreateModelVersionInput {
	s.IngestedEventsDetail = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelVersionInput) SetModelId(v string) *CreateModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelVersionInput) SetModelType(v string) *CreateModelVersionInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelVersionInput) SetTags(v []*Tag) *CreateModelVersionInput {
	s.Tags = v
	return s
}

// SetTrainingDataSchema sets the TrainingDataSchema field's value.
func (s *CreateModelVersionInput) SetTrainingDataSchema(v *TrainingDataSchema) *CreateModelVersionInput {
	s.TrainingDataSchema = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *CreateModelVersionInput) SetTrainingDataSource(v string) *CreateModelVersionInput {
	s.TrainingDataSource = &v
	return s
}

type CreateModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number of the model version created.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The model version status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelVersionOutput) GoString() string {
	return s.String()
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelVersionOutput) SetModelId(v string) *CreateModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelVersionOutput) SetModelType(v string) *CreateModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *CreateModelVersionOutput) SetModelVersionNumber(v string) *CreateModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateModelVersionOutput) SetStatus(v string) *CreateModelVersionOutput {
	s.Status = &v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID for the rule's parent detector.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule expression.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateRuleInput's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true" sensitive:"true"`

	// The language of the rule.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"Language"`

	// The outcome or outcomes returned when the rule expression matches.
	//
	// Outcomes is a required field
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Outcomes == nil {
		invalidParams.Add(request.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outcomes", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRuleInput) SetDescription(v string) *CreateRuleInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateRuleInput) SetDetectorId(v string) *CreateRuleInput {
	s.DetectorId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CreateRuleInput) SetExpression(v string) *CreateRuleInput {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateRuleInput) SetLanguage(v string) *CreateRuleInput {
	s.Language = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *CreateRuleInput) SetOutcomes(v []*string) *CreateRuleInput {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *CreateRuleInput) SetRuleId(v string) *CreateRuleInput {
	s.RuleId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleInput) SetTags(v []*Tag) *CreateRuleInput {
	s.Tags = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The created rule.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *CreateRuleOutput) SetRule(v *Rule) *CreateRuleOutput {
	s.Rule = v
	return s
}

type CreateVariableInput struct {
	_ struct{} `type:"structure"`

	// The source of the data.
	//
	// DataSource is a required field
	DataSource *string `locationName:"dataSource" type:"string" required:"true" enum:"DataSource"`

	// The data type of the variable.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"DataType"`

	// The default value for the variable when no value is received.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The variable type. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	//
	// Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 |
	// BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE
	// | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS |
	// FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID
	// | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1
	// | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME
	// | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVariableInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DefaultValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultValue"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreateVariableInput) SetDataSource(v string) *CreateVariableInput {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *CreateVariableInput) SetDataType(v string) *CreateVariableInput {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CreateVariableInput) SetDefaultValue(v string) *CreateVariableInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateVariableInput) SetDescription(v string) *CreateVariableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVariableInput) SetName(v string) *CreateVariableInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVariableInput) SetTags(v []*Tag) *CreateVariableInput {
	s.Tags = v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *CreateVariableInput) SetVariableType(v string) *CreateVariableInput {
	s.VariableType = &v
	return s
}

type CreateVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVariableOutput) GoString() string {
	return s.String()
}

// The model training data validation metrics.
type DataValidationMetrics struct {
	_ struct{} `type:"structure"`

	// The field-specific model training validation messages.
	FieldLevelMessages []*FieldValidationMessage `locationName:"fieldLevelMessages" type:"list"`

	// The file-specific model training data validation messages.
	FileLevelMessages []*FileValidationMessage `locationName:"fileLevelMessages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataValidationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataValidationMetrics) GoString() string {
	return s.String()
}

// SetFieldLevelMessages sets the FieldLevelMessages field's value.
func (s *DataValidationMetrics) SetFieldLevelMessages(v []*FieldValidationMessage) *DataValidationMetrics {
	s.FieldLevelMessages = v
	return s
}

// SetFileLevelMessages sets the FileLevelMessages field's value.
func (s *DataValidationMetrics) SetFileLevelMessages(v []*FileValidationMessage) *DataValidationMetrics {
	s.FileLevelMessages = v
	return s
}

type DeleteBatchImportJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch import job to delete.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBatchImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBatchImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DeleteBatchImportJobInput) SetJobId(v string) *DeleteBatchImportJobInput {
	s.JobId = &v
	return s
}

type DeleteBatchImportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchImportJobOutput) GoString() string {
	return s.String()
}

type DeleteBatchPredictionJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch prediction job to delete.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchPredictionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchPredictionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBatchPredictionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBatchPredictionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DeleteBatchPredictionJobInput) SetJobId(v string) *DeleteBatchPredictionJobInput {
	s.JobId = &v
	return s
}

type DeleteBatchPredictionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchPredictionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBatchPredictionJobOutput) GoString() string {
	return s.String()
}

type DeleteDetectorInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector to delete.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorInput) SetDetectorId(v string) *DeleteDetectorInput {
	s.DetectorId = &v
	return s
}

type DeleteDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorOutput) GoString() string {
	return s.String()
}

type DeleteDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent detector for the detector version to delete.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The ID of the detector version to delete.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorVersionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorVersionInput) SetDetectorId(v string) *DeleteDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *DeleteDetectorVersionInput) SetDetectorVersionId(v string) *DeleteDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

type DeleteDetectorVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDetectorVersionOutput) GoString() string {
	return s.String()
}

type DeleteEntityTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the entity type to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEntityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEntityTypeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEntityTypeInput) SetName(v string) *DeleteEntityTypeInput {
	s.Name = &v
	return s
}

type DeleteEntityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityTypeOutput) GoString() string {
	return s.String()
}

type DeleteEventInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether or not to delete any predictions associated with the event.
	// If set to True,
	DeleteAuditHistory *bool `locationName:"deleteAuditHistory" type:"boolean"`

	// The ID of the event to delete.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" min:"1" type:"string" required:"true"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteAuditHistory sets the DeleteAuditHistory field's value.
func (s *DeleteEventInput) SetDeleteAuditHistory(v bool) *DeleteEventInput {
	s.DeleteAuditHistory = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *DeleteEventInput) SetEventId(v string) *DeleteEventInput {
	s.EventId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *DeleteEventInput) SetEventTypeName(v string) *DeleteEventInput {
	s.EventTypeName = &v
	return s
}

type DeleteEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventOutput) GoString() string {
	return s.String()
}

type DeleteEventTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the event type to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventTypeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEventTypeInput) SetName(v string) *DeleteEventTypeInput {
	s.Name = &v
	return s
}

type DeleteEventTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTypeOutput) GoString() string {
	return s.String()
}

type DeleteEventsByEventTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventsByEventTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventsByEventTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventsByEventTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventsByEventTypeInput"}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *DeleteEventsByEventTypeInput) SetEventTypeName(v string) *DeleteEventsByEventTypeInput {
	s.EventTypeName = &v
	return s
}

type DeleteEventsByEventTypeOutput struct {
	_ struct{} `type:"structure"`

	// Name of event type for which to delete the events.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The status of the delete request.
	EventsDeletionStatus *string `locationName:"eventsDeletionStatus" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventsByEventTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventsByEventTypeOutput) GoString() string {
	return s.String()
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *DeleteEventsByEventTypeOutput) SetEventTypeName(v string) *DeleteEventsByEventTypeOutput {
	s.EventTypeName = &v
	return s
}

// SetEventsDeletionStatus sets the EventsDeletionStatus field's value.
func (s *DeleteEventsByEventTypeOutput) SetEventsDeletionStatus(v string) *DeleteEventsByEventTypeOutput {
	s.EventsDeletionStatus = &v
	return s
}

type DeleteExternalModelInput struct {
	_ struct{} `type:"structure"`

	// The endpoint of the Amazon Sagemaker model to delete.
	//
	// ModelEndpoint is a required field
	ModelEndpoint *string `locationName:"modelEndpoint" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExternalModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExternalModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExternalModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExternalModelInput"}
	if s.ModelEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpoint"))
	}
	if s.ModelEndpoint != nil && len(*s.ModelEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelEndpoint", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *DeleteExternalModelInput) SetModelEndpoint(v string) *DeleteExternalModelInput {
	s.ModelEndpoint = &v
	return s
}

type DeleteExternalModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExternalModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExternalModelOutput) GoString() string {
	return s.String()
}

type DeleteLabelInput struct {
	_ struct{} `type:"structure"`

	// The name of the label to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLabelInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteLabelInput) SetName(v string) *DeleteLabelInput {
	s.Name = &v
	return s
}

type DeleteLabelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelOutput) GoString() string {
	return s.String()
}

type DeleteListInput struct {
	_ struct{} `type:"structure"`

	// The name of the list to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteListInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteListInput) SetName(v string) *DeleteListInput {
	s.Name = &v
	return s
}

type DeleteListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListOutput) GoString() string {
	return s.String()
}

type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// The model ID of the model to delete.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type of the model to delete.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *DeleteModelInput) SetModelId(v string) *DeleteModelInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *DeleteModelInput) SetModelType(v string) *DeleteModelInput {
	s.ModelType = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

type DeleteModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model ID of the model version to delete.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type of the model version to delete.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number of the model version to delete.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelVersionInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *DeleteModelVersionInput) SetModelId(v string) *DeleteModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *DeleteModelVersionInput) SetModelType(v string) *DeleteModelVersionInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *DeleteModelVersionInput) SetModelVersionNumber(v string) *DeleteModelVersionInput {
	s.ModelVersionNumber = &v
	return s
}

type DeleteModelVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelVersionOutput) GoString() string {
	return s.String()
}

type DeleteOutcomeInput struct {
	_ struct{} `type:"structure"`

	// The name of the outcome to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutcomeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutcomeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutcomeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOutcomeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteOutcomeInput) SetName(v string) *DeleteOutcomeInput {
	s.Name = &v
	return s
}

type DeleteOutcomeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutcomeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutcomeOutput) GoString() string {
	return s.String()
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// A rule.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *DeleteRuleInput) SetRule(v *Rule) *DeleteRuleInput {
	s.Rule = v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type DeleteVariableInput struct {
	_ struct{} `type:"structure"`

	// The name of the variable to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVariableInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteVariableInput) SetName(v string) *DeleteVariableInput {
	s.Name = &v
	return s
}

type DeleteVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVariableOutput) GoString() string {
	return s.String()
}

type DescribeDetectorInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1000" type:"integer"`

	// The next token from the previous response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeDetectorInput) SetDetectorId(v string) *DescribeDetectorInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDetectorInput) SetMaxResults(v int64) *DescribeDetectorInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDetectorInput) SetNextToken(v string) *DescribeDetectorInput {
	s.NextToken = &v
	return s
}

type DescribeDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The detector ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The status and description for each detector version.
	DetectorVersionSummaries []*DetectorVersionSummary `locationName:"detectorVersionSummaries" type:"list"`

	// The next token to be used for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDetectorOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeDetectorOutput) SetArn(v string) *DescribeDetectorOutput {
	s.Arn = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeDetectorOutput) SetDetectorId(v string) *DescribeDetectorOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionSummaries sets the DetectorVersionSummaries field's value.
func (s *DescribeDetectorOutput) SetDetectorVersionSummaries(v []*DetectorVersionSummary) *DescribeDetectorOutput {
	s.DetectorVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDetectorOutput) SetNextToken(v string) *DescribeDetectorOutput {
	s.NextToken = &v
	return s
}

type DescribeModelVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The next token from the previous results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeModelVersionsInput) SetMaxResults(v int64) *DescribeModelVersionsInput {
	s.MaxResults = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *DescribeModelVersionsInput) SetModelId(v string) *DescribeModelVersionsInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *DescribeModelVersionsInput) SetModelType(v string) *DescribeModelVersionsInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *DescribeModelVersionsInput) SetModelVersionNumber(v string) *DescribeModelVersionsInput {
	s.ModelVersionNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeModelVersionsInput) SetNextToken(v string) *DescribeModelVersionsInput {
	s.NextToken = &v
	return s
}

type DescribeModelVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The model version details.
	ModelVersionDetails []*ModelVersionDetail `locationName:"modelVersionDetails" type:"list"`

	// The next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelVersionsOutput) GoString() string {
	return s.String()
}

// SetModelVersionDetails sets the ModelVersionDetails field's value.
func (s *DescribeModelVersionsOutput) SetModelVersionDetails(v []*ModelVersionDetail) *DescribeModelVersionsOutput {
	s.ModelVersionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeModelVersionsOutput) SetNextToken(v string) *DescribeModelVersionsOutput {
	s.NextToken = &v
	return s
}

// The detector.
type Detector struct {
	_ struct{} `type:"structure"`

	// The detector ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the detector was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The detector description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The name of the event type.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// Timestamp of when the detector was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Detector) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Detector) SetArn(v string) *Detector {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Detector) SetCreatedTime(v string) *Detector {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Detector) SetDescription(v string) *Detector {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Detector) SetDetectorId(v string) *Detector {
	s.DetectorId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *Detector) SetEventTypeName(v string) *Detector {
	s.EventTypeName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Detector) SetLastUpdatedTime(v string) *Detector {
	s.LastUpdatedTime = &v
	return s
}

// The summary of the detector version.
type DetectorVersionSummary struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// Timestamp of when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The detector version status.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectorVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectorVersionSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DetectorVersionSummary) SetDescription(v string) *DetectorVersionSummary {
	s.Description = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *DetectorVersionSummary) SetDetectorVersionId(v string) *DetectorVersionSummary {
	s.DetectorVersionId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DetectorVersionSummary) SetLastUpdatedTime(v string) *DetectorVersionSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DetectorVersionSummary) SetStatus(v string) *DetectorVersionSummary {
	s.Status = &v
	return s
}

// The entity details.
type Entity struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The entity ID. If you do not know the entityId, you can pass unknown, which
	// is areserved string literal.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// The entity type.
	//
	// EntityType is a required field
	EntityType *string `locationName:"entityType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Entity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Entity"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *Entity) SetEntityId(v string) *Entity {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *Entity) SetEntityType(v string) *Entity {
	s.EntityType = &v
	return s
}

// The entity type details.
type EntityType struct {
	_ struct{} `type:"structure"`

	// The entity type ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the entity type was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The entity type description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Timestamp of when the entity type was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The entity type name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityType) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EntityType) SetArn(v string) *EntityType {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *EntityType) SetCreatedTime(v string) *EntityType {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EntityType) SetDescription(v string) *EntityType {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *EntityType) SetLastUpdatedTime(v string) *EntityType {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EntityType) SetName(v string) *EntityType {
	s.Name = &v
	return s
}

// The details of the external (Amazon Sagemaker) model evaluated for generating
// predictions.
type EvaluatedExternalModel struct {
	_ struct{} `type:"structure"`

	// Input variables use for generating predictions.
	//
	// InputVariables is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EvaluatedExternalModel's
	// String and GoString methods.
	InputVariables map[string]*string `locationName:"inputVariables" type:"map" sensitive:"true"`

	// The endpoint of the external (Amazon Sagemaker) model.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// Output variables.
	//
	// OutputVariables is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EvaluatedExternalModel's
	// String and GoString methods.
	OutputVariables map[string]*string `locationName:"outputVariables" type:"map" sensitive:"true"`

	// Indicates whether event variables were used to generate predictions.
	UseEventVariables *bool `locationName:"useEventVariables" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluatedExternalModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluatedExternalModel) GoString() string {
	return s.String()
}

// SetInputVariables sets the InputVariables field's value.
func (s *EvaluatedExternalModel) SetInputVariables(v map[string]*string) *EvaluatedExternalModel {
	s.InputVariables = v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *EvaluatedExternalModel) SetModelEndpoint(v string) *EvaluatedExternalModel {
	s.ModelEndpoint = &v
	return s
}

// SetOutputVariables sets the OutputVariables field's value.
func (s *EvaluatedExternalModel) SetOutputVariables(v map[string]*string) *EvaluatedExternalModel {
	s.OutputVariables = v
	return s
}

// SetUseEventVariables sets the UseEventVariables field's value.
func (s *EvaluatedExternalModel) SetUseEventVariables(v bool) *EvaluatedExternalModel {
	s.UseEventVariables = &v
	return s
}

// The model version evaluated for generating prediction.
type EvaluatedModelVersion struct {
	_ struct{} `type:"structure"`

	// Evaluations generated for the model version.
	Evaluations []*ModelVersionEvaluation `locationName:"evaluations" type:"list"`

	// The model ID.
	ModelId *string `locationName:"modelId" type:"string"`

	// The model type.
	//
	// Valid values: ONLINE_FRAUD_INSIGHTS | TRANSACTION_FRAUD_INSIGHTS
	ModelType *string `locationName:"modelType" type:"string"`

	// The model version.
	ModelVersion *string `locationName:"modelVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluatedModelVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluatedModelVersion) GoString() string {
	return s.String()
}

// SetEvaluations sets the Evaluations field's value.
func (s *EvaluatedModelVersion) SetEvaluations(v []*ModelVersionEvaluation) *EvaluatedModelVersion {
	s.Evaluations = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *EvaluatedModelVersion) SetModelId(v string) *EvaluatedModelVersion {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *EvaluatedModelVersion) SetModelType(v string) *EvaluatedModelVersion {
	s.ModelType = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *EvaluatedModelVersion) SetModelVersion(v string) *EvaluatedModelVersion {
	s.ModelVersion = &v
	return s
}

// The details of the rule used for evaluating variable values.
type EvaluatedRule struct {
	_ struct{} `type:"structure"`

	// Indicates whether the rule was evaluated.
	Evaluated *bool `locationName:"evaluated" type:"boolean"`

	// The rule expression.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EvaluatedRule's
	// String and GoString methods.
	Expression *string `locationName:"expression" type:"string" sensitive:"true"`

	// The rule expression value.
	//
	// ExpressionWithValues is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EvaluatedRule's
	// String and GoString methods.
	ExpressionWithValues *string `locationName:"expressionWithValues" type:"string" sensitive:"true"`

	// Indicates whether the rule matched.
	Matched *bool `locationName:"matched" type:"boolean"`

	// The rule outcome.
	Outcomes []*string `locationName:"outcomes" type:"list"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluatedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluatedRule) GoString() string {
	return s.String()
}

// SetEvaluated sets the Evaluated field's value.
func (s *EvaluatedRule) SetEvaluated(v bool) *EvaluatedRule {
	s.Evaluated = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *EvaluatedRule) SetExpression(v string) *EvaluatedRule {
	s.Expression = &v
	return s
}

// SetExpressionWithValues sets the ExpressionWithValues field's value.
func (s *EvaluatedRule) SetExpressionWithValues(v string) *EvaluatedRule {
	s.ExpressionWithValues = &v
	return s
}

// SetMatched sets the Matched field's value.
func (s *EvaluatedRule) SetMatched(v bool) *EvaluatedRule {
	s.Matched = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *EvaluatedRule) SetOutcomes(v []*string) *EvaluatedRule {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *EvaluatedRule) SetRuleId(v string) *EvaluatedRule {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *EvaluatedRule) SetRuleVersion(v string) *EvaluatedRule {
	s.RuleVersion = &v
	return s
}

// The event details.
type Event struct {
	_ struct{} `type:"structure"`

	// The label associated with the event.
	CurrentLabel *string `locationName:"currentLabel" type:"string"`

	// The event entities.
	Entities []*Entity `locationName:"entities" type:"list"`

	// The event ID.
	EventId *string `locationName:"eventId" type:"string"`

	// The timestamp that defines when the event under evaluation occurred. The
	// timestamp must be specified using ISO 8601 standard in UTC.
	EventTimestamp *string `locationName:"eventTimestamp" type:"string"`

	// The event type.
	EventTypeName *string `locationName:"eventTypeName" type:"string"`

	// Names of the event type's variables you defined in Amazon Fraud Detector
	// to represent data elements and their corresponding values for the event you
	// are sending for evaluation.
	EventVariables map[string]*string `locationName:"eventVariables" type:"map"`

	// The timestamp associated with the label to update. The timestamp must be
	// specified using ISO 8601 standard in UTC.
	LabelTimestamp *string `locationName:"labelTimestamp" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetCurrentLabel sets the CurrentLabel field's value.
func (s *Event) SetCurrentLabel(v string) *Event {
	s.CurrentLabel = &v
	return s
}

// SetEntities sets the Entities field's value.
func (s *Event) SetEntities(v []*Entity) *Event {
	s.Entities = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *Event) SetEventTimestamp(v string) *Event {
	s.EventTimestamp = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *Event) SetEventTypeName(v string) *Event {
	s.EventTypeName = &v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *Event) SetEventVariables(v map[string]*string) *Event {
	s.EventVariables = v
	return s
}

// SetLabelTimestamp sets the LabelTimestamp field's value.
func (s *Event) SetLabelTimestamp(v string) *Event {
	s.LabelTimestamp = &v
	return s
}

// The event orchestration status.
type EventOrchestration struct {
	_ struct{} `type:"structure"`

	// Specifies if event orchestration is enabled through Amazon EventBridge.
	//
	// EventBridgeEnabled is a required field
	EventBridgeEnabled *bool `locationName:"eventBridgeEnabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventOrchestration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventOrchestration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventOrchestration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventOrchestration"}
	if s.EventBridgeEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBridgeEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBridgeEnabled sets the EventBridgeEnabled field's value.
func (s *EventOrchestration) SetEventBridgeEnabled(v bool) *EventOrchestration {
	s.EventBridgeEnabled = &v
	return s
}

// Information about the summary of an event prediction.
type EventPredictionSummary struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The event ID.
	EventId *string `locationName:"eventId" min:"1" type:"string"`

	// The timestamp of the event.
	EventTimestamp *string `locationName:"eventTimestamp" min:"11" type:"string"`

	// The event type.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The timestamp when the prediction was generated.
	PredictionTimestamp *string `locationName:"predictionTimestamp" min:"11" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventPredictionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventPredictionSummary) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *EventPredictionSummary) SetDetectorId(v string) *EventPredictionSummary {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *EventPredictionSummary) SetDetectorVersionId(v string) *EventPredictionSummary {
	s.DetectorVersionId = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *EventPredictionSummary) SetEventId(v string) *EventPredictionSummary {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *EventPredictionSummary) SetEventTimestamp(v string) *EventPredictionSummary {
	s.EventTimestamp = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *EventPredictionSummary) SetEventTypeName(v string) *EventPredictionSummary {
	s.EventTypeName = &v
	return s
}

// SetPredictionTimestamp sets the PredictionTimestamp field's value.
func (s *EventPredictionSummary) SetPredictionTimestamp(v string) *EventPredictionSummary {
	s.PredictionTimestamp = &v
	return s
}

// The event type details.
type EventType struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The entity type ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the event type was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The event type description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The event type entity types.
	EntityTypes []*string `locationName:"entityTypes" min:"1" type:"list"`

	// If Enabled, Amazon Fraud Detector stores event data when you generate a prediction
	// and uses that data to update calculated variables in near real-time. Amazon
	// Fraud Detector uses this data, known as INGESTED_EVENTS, to train your model
	// and improve fraud predictions.
	EventIngestion *string `locationName:"eventIngestion" type:"string" enum:"EventIngestion"`

	// The event orchestration status.
	EventOrchestration *EventOrchestration `locationName:"eventOrchestration" type:"structure"`

	// The event type event variables.
	EventVariables []*string `locationName:"eventVariables" type:"list"`

	// Data about the stored events.
	IngestedEventStatistics *IngestedEventStatistics `locationName:"ingestedEventStatistics" type:"structure"`

	// The event type labels.
	Labels []*string `locationName:"labels" type:"list"`

	// Timestamp of when the event type was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The event type name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventType) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventType) SetArn(v string) *EventType {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *EventType) SetCreatedTime(v string) *EventType {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EventType) SetDescription(v string) *EventType {
	s.Description = &v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EventType) SetEntityTypes(v []*string) *EventType {
	s.EntityTypes = v
	return s
}

// SetEventIngestion sets the EventIngestion field's value.
func (s *EventType) SetEventIngestion(v string) *EventType {
	s.EventIngestion = &v
	return s
}

// SetEventOrchestration sets the EventOrchestration field's value.
func (s *EventType) SetEventOrchestration(v *EventOrchestration) *EventType {
	s.EventOrchestration = v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *EventType) SetEventVariables(v []*string) *EventType {
	s.EventVariables = v
	return s
}

// SetIngestedEventStatistics sets the IngestedEventStatistics field's value.
func (s *EventType) SetIngestedEventStatistics(v *IngestedEventStatistics) *EventType {
	s.IngestedEventStatistics = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *EventType) SetLabels(v []*string) *EventType {
	s.Labels = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *EventType) SetLastUpdatedTime(v string) *EventType {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventType) SetName(v string) *EventType {
	s.Name = &v
	return s
}

// Information about the summary of an event variable that was evaluated for
// generating prediction.
type EventVariableSummary struct {
	_ struct{} `type:"structure"`

	// The event variable name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EventVariableSummary's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The event variable source.
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EventVariableSummary's
	// String and GoString methods.
	Source *string `locationName:"source" type:"string" sensitive:"true"`

	// The value of the event variable.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EventVariableSummary's
	// String and GoString methods.
	Value *string `locationName:"value" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventVariableSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventVariableSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EventVariableSummary) SetName(v string) *EventVariableSummary {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *EventVariableSummary) SetSource(v string) *EventVariableSummary {
	s.Source = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EventVariableSummary) SetValue(v string) *EventVariableSummary {
	s.Value = &v
	return s
}

// Details for the external events data used for model version training.
type ExternalEventsDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the role that provides Amazon Fraud Detector access to the data
	// location.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"1" type:"string" required:"true"`

	// The Amazon S3 bucket location for the data.
	//
	// DataLocation is a required field
	DataLocation *string `locationName:"dataLocation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalEventsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalEventsDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalEventsDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalEventsDetail"}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 1))
	}
	if s.DataLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLocation"))
	}
	if s.DataLocation != nil && len(*s.DataLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataLocation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ExternalEventsDetail) SetDataAccessRoleArn(v string) *ExternalEventsDetail {
	s.DataAccessRoleArn = &v
	return s
}

// SetDataLocation sets the DataLocation field's value.
func (s *ExternalEventsDetail) SetDataLocation(v string) *ExternalEventsDetail {
	s.DataLocation = &v
	return s
}

// The Amazon SageMaker model.
type ExternalModel struct {
	_ struct{} `type:"structure"`

	// The model ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the model was last created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The input configuration.
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure"`

	// The role used to invoke the model.
	InvokeModelEndpointRoleArn *string `locationName:"invokeModelEndpointRoleArn" type:"string"`

	// Timestamp of when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The Amazon SageMaker model endpoints.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The Amazon Fraud Detector status for the external model endpoint
	ModelEndpointStatus *string `locationName:"modelEndpointStatus" type:"string" enum:"ModelEndpointStatus"`

	// The source of the model.
	ModelSource *string `locationName:"modelSource" type:"string" enum:"ModelSource"`

	// The output configuration.
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalModel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExternalModel) SetArn(v string) *ExternalModel {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ExternalModel) SetCreatedTime(v string) *ExternalModel {
	s.CreatedTime = &v
	return s
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *ExternalModel) SetInputConfiguration(v *ModelInputConfiguration) *ExternalModel {
	s.InputConfiguration = v
	return s
}

// SetInvokeModelEndpointRoleArn sets the InvokeModelEndpointRoleArn field's value.
func (s *ExternalModel) SetInvokeModelEndpointRoleArn(v string) *ExternalModel {
	s.InvokeModelEndpointRoleArn = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ExternalModel) SetLastUpdatedTime(v string) *ExternalModel {
	s.LastUpdatedTime = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *ExternalModel) SetModelEndpoint(v string) *ExternalModel {
	s.ModelEndpoint = &v
	return s
}

// SetModelEndpointStatus sets the ModelEndpointStatus field's value.
func (s *ExternalModel) SetModelEndpointStatus(v string) *ExternalModel {
	s.ModelEndpointStatus = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *ExternalModel) SetModelSource(v string) *ExternalModel {
	s.ModelSource = &v
	return s
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *ExternalModel) SetOutputConfiguration(v *ModelOutputConfiguration) *ExternalModel {
	s.OutputConfiguration = v
	return s
}

// The fraud prediction scores from Amazon SageMaker model.
type ExternalModelOutputs struct {
	_ struct{} `type:"structure"`

	// The Amazon SageMaker model.
	ExternalModel *ExternalModelSummary `locationName:"externalModel" type:"structure"`

	// The fraud prediction scores from Amazon SageMaker model.
	Outputs map[string]*string `locationName:"outputs" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalModelOutputs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalModelOutputs) GoString() string {
	return s.String()
}

// SetExternalModel sets the ExternalModel field's value.
func (s *ExternalModelOutputs) SetExternalModel(v *ExternalModelSummary) *ExternalModelOutputs {
	s.ExternalModel = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ExternalModelOutputs) SetOutputs(v map[string]*string) *ExternalModelOutputs {
	s.Outputs = v
	return s
}

// The Amazon SageMaker model.
type ExternalModelSummary struct {
	_ struct{} `type:"structure"`

	// The endpoint of the Amazon SageMaker model.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The source of the model.
	ModelSource *string `locationName:"modelSource" type:"string" enum:"ModelSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalModelSummary) GoString() string {
	return s.String()
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *ExternalModelSummary) SetModelEndpoint(v string) *ExternalModelSummary {
	s.ModelEndpoint = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *ExternalModelSummary) SetModelSource(v string) *ExternalModelSummary {
	s.ModelSource = &v
	return s
}

// The message details.
type FieldValidationMessage struct {
	_ struct{} `type:"structure"`

	// The message content.
	Content *string `locationName:"content" type:"string"`

	// The field name.
	FieldName *string `locationName:"fieldName" type:"string"`

	// The message ID.
	Identifier *string `locationName:"identifier" type:"string"`

	// The message title.
	Title *string `locationName:"title" type:"string"`

	// The message type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldValidationMessage) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *FieldValidationMessage) SetContent(v string) *FieldValidationMessage {
	s.Content = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *FieldValidationMessage) SetFieldName(v string) *FieldValidationMessage {
	s.FieldName = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *FieldValidationMessage) SetIdentifier(v string) *FieldValidationMessage {
	s.Identifier = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *FieldValidationMessage) SetTitle(v string) *FieldValidationMessage {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *FieldValidationMessage) SetType(v string) *FieldValidationMessage {
	s.Type = &v
	return s
}

// The message details.
type FileValidationMessage struct {
	_ struct{} `type:"structure"`

	// The message content.
	Content *string `locationName:"content" type:"string"`

	// The message title.
	Title *string `locationName:"title" type:"string"`

	// The message type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileValidationMessage) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *FileValidationMessage) SetContent(v string) *FileValidationMessage {
	s.Content = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *FileValidationMessage) SetTitle(v string) *FileValidationMessage {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *FileValidationMessage) SetType(v string) *FileValidationMessage {
	s.Type = &v
	return s
}

// A conditional statement for filtering a list of past predictions.
type FilterCondition struct {
	_ struct{} `type:"structure"`

	// A statement containing a resource property and a value to specify filter
	// condition.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterCondition"}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *FilterCondition) SetValue(v string) *FilterCondition {
	s.Value = &v
	return s
}

type GetBatchImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch import job to get.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The maximum number of objects to return for request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The next token from the previous request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBatchImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBatchImportJobsInput"}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetBatchImportJobsInput) SetJobId(v string) *GetBatchImportJobsInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBatchImportJobsInput) SetMaxResults(v int64) *GetBatchImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBatchImportJobsInput) SetNextToken(v string) *GetBatchImportJobsInput {
	s.NextToken = &v
	return s
}

type GetBatchImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the details of each batch import job.
	BatchImports []*BatchImport `locationName:"batchImports" type:"list"`

	// The next token for the subsequent resquest.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchImportJobsOutput) GoString() string {
	return s.String()
}

// SetBatchImports sets the BatchImports field's value.
func (s *GetBatchImportJobsOutput) SetBatchImports(v []*BatchImport) *GetBatchImportJobsOutput {
	s.BatchImports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBatchImportJobsOutput) SetNextToken(v string) *GetBatchImportJobsOutput {
	s.NextToken = &v
	return s
}

type GetBatchPredictionJobsInput struct {
	_ struct{} `type:"structure"`

	// The batch prediction job for which to get the details.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The next token from the previous request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchPredictionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchPredictionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBatchPredictionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBatchPredictionJobsInput"}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetBatchPredictionJobsInput) SetJobId(v string) *GetBatchPredictionJobsInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetBatchPredictionJobsInput) SetMaxResults(v int64) *GetBatchPredictionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBatchPredictionJobsInput) SetNextToken(v string) *GetBatchPredictionJobsInput {
	s.NextToken = &v
	return s
}

type GetBatchPredictionJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the details of each batch prediction job.
	BatchPredictions []*BatchPrediction `locationName:"batchPredictions" type:"list"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchPredictionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchPredictionJobsOutput) GoString() string {
	return s.String()
}

// SetBatchPredictions sets the BatchPredictions field's value.
func (s *GetBatchPredictionJobsOutput) SetBatchPredictions(v []*BatchPrediction) *GetBatchPredictionJobsOutput {
	s.BatchPredictions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetBatchPredictionJobsOutput) SetNextToken(v string) *GetBatchPredictionJobsOutput {
	s.NextToken = &v
	return s
}

type GetDeleteEventsByEventTypeStatusInput struct {
	_ struct{} `type:"structure"`

	// Name of event type for which to get the deletion status.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeleteEventsByEventTypeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeleteEventsByEventTypeStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeleteEventsByEventTypeStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeleteEventsByEventTypeStatusInput"}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetDeleteEventsByEventTypeStatusInput) SetEventTypeName(v string) *GetDeleteEventsByEventTypeStatusInput {
	s.EventTypeName = &v
	return s
}

type GetDeleteEventsByEventTypeStatusOutput struct {
	_ struct{} `type:"structure"`

	// The event type name.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The deletion status.
	EventsDeletionStatus *string `locationName:"eventsDeletionStatus" type:"string" enum:"AsyncJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeleteEventsByEventTypeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeleteEventsByEventTypeStatusOutput) GoString() string {
	return s.String()
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetDeleteEventsByEventTypeStatusOutput) SetEventTypeName(v string) *GetDeleteEventsByEventTypeStatusOutput {
	s.EventTypeName = &v
	return s
}

// SetEventsDeletionStatus sets the EventsDeletionStatus field's value.
func (s *GetDeleteEventsByEventTypeStatusOutput) SetEventsDeletionStatus(v string) *GetDeleteEventsByEventTypeStatusOutput {
	s.EventsDeletionStatus = &v
	return s
}

type GetDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorVersionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorVersionInput) SetDetectorId(v string) *GetDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetDetectorVersionInput) SetDetectorVersionId(v string) *GetDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

type GetDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The detector version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp when the detector version was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The Amazon SageMaker model endpoints included in the detector version.
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list"`

	// The timestamp when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The model versions included in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The execution mode of the rule in the dectector
	//
	// FIRST_MATCHED indicates that Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// ALL_MATCHED indicates that Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules. You can define and edit the rule
	// mode at the detector version level, when it is in draft status.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// The rules included in the detector version.
	Rules []*Rule `locationName:"rules" type:"list"`

	// The status of the detector version.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDetectorVersionOutput) SetArn(v string) *GetDetectorVersionOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetDetectorVersionOutput) SetCreatedTime(v string) *GetDetectorVersionOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDetectorVersionOutput) SetDescription(v string) *GetDetectorVersionOutput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorVersionOutput) SetDetectorId(v string) *GetDetectorVersionOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetDetectorVersionOutput) SetDetectorVersionId(v string) *GetDetectorVersionOutput {
	s.DetectorVersionId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *GetDetectorVersionOutput) SetExternalModelEndpoints(v []*string) *GetDetectorVersionOutput {
	s.ExternalModelEndpoints = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetDetectorVersionOutput) SetLastUpdatedTime(v string) *GetDetectorVersionOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *GetDetectorVersionOutput) SetModelVersions(v []*ModelVersion) *GetDetectorVersionOutput {
	s.ModelVersions = v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *GetDetectorVersionOutput) SetRuleExecutionMode(v string) *GetDetectorVersionOutput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetDetectorVersionOutput) SetRules(v []*Rule) *GetDetectorVersionOutput {
	s.Rules = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDetectorVersionOutput) SetStatus(v string) *GetDetectorVersionOutput {
	s.Status = &v
	return s
}

type GetDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorsInput"}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorsInput) SetDetectorId(v string) *GetDetectorsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDetectorsInput) SetMaxResults(v int64) *GetDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDetectorsInput) SetNextToken(v string) *GetDetectorsInput {
	s.NextToken = &v
	return s
}

type GetDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// The detectors.
	Detectors []*Detector `locationName:"detectors" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectors sets the Detectors field's value.
func (s *GetDetectorsOutput) SetDetectors(v []*Detector) *GetDetectorsOutput {
	s.Detectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDetectorsOutput) SetNextToken(v string) *GetDetectorsOutput {
	s.NextToken = &v
	return s
}

type GetEntityTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEntityTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEntityTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEntityTypesInput) SetMaxResults(v int64) *GetEntityTypesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEntityTypesInput) SetName(v string) *GetEntityTypesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEntityTypesInput) SetNextToken(v string) *GetEntityTypesInput {
	s.NextToken = &v
	return s
}

type GetEntityTypesOutput struct {
	_ struct{} `type:"structure"`

	// An array of entity types.
	EntityTypes []*EntityType `locationName:"entityTypes" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityTypesOutput) GoString() string {
	return s.String()
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *GetEntityTypesOutput) SetEntityTypes(v []*EntityType) *GetEntityTypesOutput {
	s.EntityTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEntityTypesOutput) SetNextToken(v string) *GetEntityTypesOutput {
	s.NextToken = &v
	return s
}

type GetEventInput struct {
	_ struct{} `type:"structure"`

	// The ID of the event to retrieve.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// The event type of the event to retrieve.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *GetEventInput) SetEventId(v string) *GetEventInput {
	s.EventId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetEventInput) SetEventTypeName(v string) *GetEventInput {
	s.EventTypeName = &v
	return s
}

type GetEventOutput struct {
	_ struct{} `type:"structure"`

	// The details of the event.
	Event *Event `locationName:"event" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventOutput) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *GetEventOutput) SetEvent(v *Event) *GetEventOutput {
	s.Event = v
	return s
}

type GetEventPredictionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" type:"string" required:"true"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The entity type (associated with the detector's event type) and specific
	// entity ID representing who performed the event. If an entity id is not available,
	// use "UNKNOWN."
	//
	// Entities is a required field
	Entities []*Entity `locationName:"entities" type:"list" required:"true"`

	// The unique ID used to identify the event.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// Timestamp that defines when the event under evaluation occurred. The timestamp
	// must be specified using ISO 8601 standard in UTC.
	//
	// EventTimestamp is a required field
	EventTimestamp *string `locationName:"eventTimestamp" min:"10" type:"string" required:"true"`

	// The event type associated with the detector specified for the prediction.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" type:"string" required:"true"`

	// Names of the event type's variables you defined in Amazon Fraud Detector
	// to represent data elements and their corresponding values for the event you
	// are sending for evaluation.
	//
	// You must provide at least one eventVariable
	//
	// To ensure most accurate fraud prediction and to simplify your data preparation,
	// Amazon Fraud Detector will replace all missing variables or values as follows:
	//
	// For Amazon Fraud Detector trained models:
	//
	// If a null value is provided explicitly for a variable or if a variable is
	// missing, model will replace the null value or the missing variable (no variable
	// name in the eventVariables map) with calculated default mean/medians for
	// numeric variables and with special values for categorical variables.
	//
	// For imported SageMaker models:
	//
	// If a null value is provided explicitly for a variable, the model and rules
	// will use “null” as the value. If a variable is not provided (no variable
	// name in the eventVariables map), model and rules will use the default value
	// that is provided for the variable.
	//
	// EventVariables is a required field
	EventVariables map[string]*string `locationName:"eventVariables" min:"1" type:"map" required:"true"`

	// The Amazon SageMaker model endpoint input data blobs.
	//
	// ExternalModelEndpointDataBlobs is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetEventPredictionInput's
	// String and GoString methods.
	ExternalModelEndpointDataBlobs map[string]*ModelEndpointDataBlob `locationName:"externalModelEndpointDataBlobs" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventPredictionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.Entities == nil {
		invalidParams.Add(request.NewErrParamRequired("Entities"))
	}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTimestamp"))
	}
	if s.EventTimestamp != nil && len(*s.EventTimestamp) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("EventTimestamp", 10))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("EventVariables"))
	}
	if s.EventVariables != nil && len(s.EventVariables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventVariables", 1))
	}
	if s.Entities != nil {
		for i, v := range s.Entities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entities", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ExternalModelEndpointDataBlobs != nil {
		for i, v := range s.ExternalModelEndpointDataBlobs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExternalModelEndpointDataBlobs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetEventPredictionInput) SetDetectorId(v string) *GetEventPredictionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetEventPredictionInput) SetDetectorVersionId(v string) *GetEventPredictionInput {
	s.DetectorVersionId = &v
	return s
}

// SetEntities sets the Entities field's value.
func (s *GetEventPredictionInput) SetEntities(v []*Entity) *GetEventPredictionInput {
	s.Entities = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *GetEventPredictionInput) SetEventId(v string) *GetEventPredictionInput {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *GetEventPredictionInput) SetEventTimestamp(v string) *GetEventPredictionInput {
	s.EventTimestamp = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetEventPredictionInput) SetEventTypeName(v string) *GetEventPredictionInput {
	s.EventTypeName = &v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *GetEventPredictionInput) SetEventVariables(v map[string]*string) *GetEventPredictionInput {
	s.EventVariables = v
	return s
}

// SetExternalModelEndpointDataBlobs sets the ExternalModelEndpointDataBlobs field's value.
func (s *GetEventPredictionInput) SetExternalModelEndpointDataBlobs(v map[string]*ModelEndpointDataBlob) *GetEventPredictionInput {
	s.ExternalModelEndpointDataBlobs = v
	return s
}

type GetEventPredictionMetadataInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The event ID.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" min:"1" type:"string" required:"true"`

	// The event type associated with the detector specified for the prediction.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// The timestamp that defines when the prediction was generated. The timestamp
	// must be specified using ISO 8601 standard in UTC.
	//
	// We recommend calling ListEventPredictions (https://docs.aws.amazon.com/frauddetector/latest/api/API_ListEventPredictions.html)
	// first, and using the predictionTimestamp value in the response to provide
	// an accurate prediction timestamp value.
	//
	// PredictionTimestamp is a required field
	PredictionTimestamp *string `locationName:"predictionTimestamp" min:"11" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventPredictionMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventPredictionMetadataInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.PredictionTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictionTimestamp"))
	}
	if s.PredictionTimestamp != nil && len(*s.PredictionTimestamp) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("PredictionTimestamp", 11))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetEventPredictionMetadataInput) SetDetectorId(v string) *GetEventPredictionMetadataInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetEventPredictionMetadataInput) SetDetectorVersionId(v string) *GetEventPredictionMetadataInput {
	s.DetectorVersionId = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *GetEventPredictionMetadataInput) SetEventId(v string) *GetEventPredictionMetadataInput {
	s.EventId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetEventPredictionMetadataInput) SetEventTypeName(v string) *GetEventPredictionMetadataInput {
	s.EventTypeName = &v
	return s
}

// SetPredictionTimestamp sets the PredictionTimestamp field's value.
func (s *GetEventPredictionMetadataInput) SetPredictionTimestamp(v string) *GetEventPredictionMetadataInput {
	s.PredictionTimestamp = &v
	return s
}

type GetEventPredictionMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The status of the detector version.
	DetectorVersionStatus *string `locationName:"detectorVersionStatus" type:"string"`

	// The entity ID.
	EntityId *string `locationName:"entityId" type:"string"`

	// The entity type.
	EntityType *string `locationName:"entityType" type:"string"`

	// External (Amazon SageMaker) models that were evaluated for generating predictions.
	EvaluatedExternalModels []*EvaluatedExternalModel `locationName:"evaluatedExternalModels" type:"list"`

	// Model versions that were evaluated for generating predictions.
	EvaluatedModelVersions []*EvaluatedModelVersion `locationName:"evaluatedModelVersions" type:"list"`

	// The event ID.
	EventId *string `locationName:"eventId" min:"1" type:"string"`

	// The timestamp for when the prediction was generated for the associated event
	// ID.
	EventTimestamp *string `locationName:"eventTimestamp" min:"11" type:"string"`

	// The event type associated with the detector specified for this prediction.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// A list of event variables that influenced the prediction scores.
	EventVariables []*EventVariableSummary `locationName:"eventVariables" type:"list"`

	// The outcomes of the matched rule, based on the rule execution mode.
	Outcomes []*string `locationName:"outcomes" type:"list"`

	// The timestamp that defines when the prediction was generated.
	PredictionTimestamp *string `locationName:"predictionTimestamp" min:"11" type:"string"`

	// The execution mode of the rule used for evaluating variable values.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// List of rules associated with the detector version that were used for evaluating
	// variable values.
	Rules []*EvaluatedRule `locationName:"rules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionMetadataOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetEventPredictionMetadataOutput) SetDetectorId(v string) *GetEventPredictionMetadataOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetEventPredictionMetadataOutput) SetDetectorVersionId(v string) *GetEventPredictionMetadataOutput {
	s.DetectorVersionId = &v
	return s
}

// SetDetectorVersionStatus sets the DetectorVersionStatus field's value.
func (s *GetEventPredictionMetadataOutput) SetDetectorVersionStatus(v string) *GetEventPredictionMetadataOutput {
	s.DetectorVersionStatus = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *GetEventPredictionMetadataOutput) SetEntityId(v string) *GetEventPredictionMetadataOutput {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *GetEventPredictionMetadataOutput) SetEntityType(v string) *GetEventPredictionMetadataOutput {
	s.EntityType = &v
	return s
}

// SetEvaluatedExternalModels sets the EvaluatedExternalModels field's value.
func (s *GetEventPredictionMetadataOutput) SetEvaluatedExternalModels(v []*EvaluatedExternalModel) *GetEventPredictionMetadataOutput {
	s.EvaluatedExternalModels = v
	return s
}

// SetEvaluatedModelVersions sets the EvaluatedModelVersions field's value.
func (s *GetEventPredictionMetadataOutput) SetEvaluatedModelVersions(v []*EvaluatedModelVersion) *GetEventPredictionMetadataOutput {
	s.EvaluatedModelVersions = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *GetEventPredictionMetadataOutput) SetEventId(v string) *GetEventPredictionMetadataOutput {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *GetEventPredictionMetadataOutput) SetEventTimestamp(v string) *GetEventPredictionMetadataOutput {
	s.EventTimestamp = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetEventPredictionMetadataOutput) SetEventTypeName(v string) *GetEventPredictionMetadataOutput {
	s.EventTypeName = &v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *GetEventPredictionMetadataOutput) SetEventVariables(v []*EventVariableSummary) *GetEventPredictionMetadataOutput {
	s.EventVariables = v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *GetEventPredictionMetadataOutput) SetOutcomes(v []*string) *GetEventPredictionMetadataOutput {
	s.Outcomes = v
	return s
}

// SetPredictionTimestamp sets the PredictionTimestamp field's value.
func (s *GetEventPredictionMetadataOutput) SetPredictionTimestamp(v string) *GetEventPredictionMetadataOutput {
	s.PredictionTimestamp = &v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *GetEventPredictionMetadataOutput) SetRuleExecutionMode(v string) *GetEventPredictionMetadataOutput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetEventPredictionMetadataOutput) SetRules(v []*EvaluatedRule) *GetEventPredictionMetadataOutput {
	s.Rules = v
	return s
}

type GetEventPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The model scores for Amazon SageMaker models.
	ExternalModelOutputs []*ExternalModelOutputs `locationName:"externalModelOutputs" type:"list"`

	// The model scores. Amazon Fraud Detector generates model scores between 0
	// and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores
	// are directly related to the false positive rate (FPR). For example, a score
	// of 600 corresponds to an estimated 10% false positive rate whereas a score
	// of 900 corresponds to an estimated 2% false positive rate.
	ModelScores []*ModelScores `locationName:"modelScores" type:"list"`

	// The results from the rules.
	RuleResults []*RuleResult `locationName:"ruleResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventPredictionOutput) GoString() string {
	return s.String()
}

// SetExternalModelOutputs sets the ExternalModelOutputs field's value.
func (s *GetEventPredictionOutput) SetExternalModelOutputs(v []*ExternalModelOutputs) *GetEventPredictionOutput {
	s.ExternalModelOutputs = v
	return s
}

// SetModelScores sets the ModelScores field's value.
func (s *GetEventPredictionOutput) SetModelScores(v []*ModelScores) *GetEventPredictionOutput {
	s.ModelScores = v
	return s
}

// SetRuleResults sets the RuleResults field's value.
func (s *GetEventPredictionOutput) SetRuleResults(v []*RuleResult) *GetEventPredictionOutput {
	s.RuleResults = v
	return s
}

type GetEventTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEventTypesInput) SetMaxResults(v int64) *GetEventTypesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEventTypesInput) SetName(v string) *GetEventTypesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEventTypesInput) SetNextToken(v string) *GetEventTypesInput {
	s.NextToken = &v
	return s
}

type GetEventTypesOutput struct {
	_ struct{} `type:"structure"`

	// An array of event types.
	EventTypes []*EventType `locationName:"eventTypes" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventTypesOutput) GoString() string {
	return s.String()
}

// SetEventTypes sets the EventTypes field's value.
func (s *GetEventTypesOutput) SetEventTypes(v []*EventType) *GetEventTypesOutput {
	s.EventTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEventTypesOutput) SetNextToken(v string) *GetEventTypesOutput {
	s.NextToken = &v
	return s
}

type GetExternalModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The Amazon SageMaker model endpoint.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExternalModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExternalModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExternalModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExternalModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExternalModelsInput) SetMaxResults(v int64) *GetExternalModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *GetExternalModelsInput) SetModelEndpoint(v string) *GetExternalModelsInput {
	s.ModelEndpoint = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExternalModelsInput) SetNextToken(v string) *GetExternalModelsInput {
	s.NextToken = &v
	return s
}

type GetExternalModelsOutput struct {
	_ struct{} `type:"structure"`

	// Gets the Amazon SageMaker models.
	ExternalModels []*ExternalModel `locationName:"externalModels" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExternalModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExternalModelsOutput) GoString() string {
	return s.String()
}

// SetExternalModels sets the ExternalModels field's value.
func (s *GetExternalModelsOutput) SetExternalModels(v []*ExternalModel) *GetExternalModelsOutput {
	s.ExternalModels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExternalModelsOutput) SetNextToken(v string) *GetExternalModelsOutput {
	s.NextToken = &v
	return s
}

type GetKMSEncryptionKeyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKMSEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKMSEncryptionKeyInput) GoString() string {
	return s.String()
}

type GetKMSEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// The KMS encryption key.
	KmsKey *KMSKey `locationName:"kmsKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKMSEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKMSEncryptionKeyOutput) GoString() string {
	return s.String()
}

// SetKmsKey sets the KmsKey field's value.
func (s *GetKMSEncryptionKeyOutput) SetKmsKey(v *KMSKey) *GetKMSEncryptionKeyOutput {
	s.KmsKey = v
	return s
}

type GetLabelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// The name of the label or labels to get.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLabelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetLabelsInput) SetMaxResults(v int64) *GetLabelsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetLabelsInput) SetName(v string) *GetLabelsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLabelsInput) SetNextToken(v string) *GetLabelsInput {
	s.NextToken = &v
	return s
}

type GetLabelsOutput struct {
	_ struct{} `type:"structure"`

	// An array of labels.
	Labels []*Label `locationName:"labels" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelsOutput) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *GetLabelsOutput) SetLabels(v []*Label) *GetLabelsOutput {
	s.Labels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLabelsOutput) SetNextToken(v string) *GetLabelsOutput {
	s.NextToken = &v
	return s
}

type GetListElementsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"500" type:"integer"`

	// The name of the list.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListElementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListElementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetListElementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetListElementsInput"}
	if s.MaxResults != nil && *s.MaxResults < 500 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 500))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetListElementsInput) SetMaxResults(v int64) *GetListElementsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetListElementsInput) SetName(v string) *GetListElementsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetListElementsInput) SetNextToken(v string) *GetListElementsInput {
	s.NextToken = &v
	return s
}

type GetListElementsOutput struct {
	_ struct{} `type:"structure"`

	// The list elements.
	Elements []*string `locationName:"elements" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListElementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListElementsOutput) GoString() string {
	return s.String()
}

// SetElements sets the Elements field's value.
func (s *GetListElementsOutput) SetElements(v []*string) *GetListElementsOutput {
	s.Elements = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetListElementsOutput) SetNextToken(v string) *GetListElementsOutput {
	s.NextToken = &v
	return s
}

type GetListsMetadataInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name of the list.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListsMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListsMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetListsMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetListsMetadataInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetListsMetadataInput) SetMaxResults(v int64) *GetListsMetadataInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetListsMetadataInput) SetName(v string) *GetListsMetadataInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetListsMetadataInput) SetNextToken(v string) *GetListsMetadataInput {
	s.NextToken = &v
	return s
}

type GetListsMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The metadata of the specified list or all lists under the account.
	Lists []*AllowDenyList `locationName:"lists" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListsMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetListsMetadataOutput) GoString() string {
	return s.String()
}

// SetLists sets the Lists field's value.
func (s *GetListsMetadataOutput) SetLists(v []*AllowDenyList) *GetListsMetadataOutput {
	s.Lists = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetListsMetadataOutput) SetNextToken(v string) *GetListsMetadataOutput {
	s.NextToken = &v
	return s
}

type GetModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelVersionInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *GetModelVersionInput) SetModelId(v string) *GetModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelVersionInput) SetModelType(v string) *GetModelVersionInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *GetModelVersionInput) SetModelVersionNumber(v string) *GetModelVersionInput {
	s.ModelVersionNumber = &v
	return s
}

type GetModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The details of the external events data used for training the model version.
	// This will be populated if the trainingDataSource is EXTERNAL_EVENTS
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The details of the ingested events data used for training the model version.
	// This will be populated if the trainingDataSource is INGESTED_EVENTS.
	IngestedEventsDetail *IngestedEventsDetail `locationName:"ingestedEventsDetail" type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The model version status.
	//
	// Possible values are:
	//
	//    * TRAINING_IN_PROGRESS
	//
	//    * TRAINING_COMPLETE
	//
	//    * ACTIVATE_REQUESTED
	//
	//    * ACTIVATE_IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * INACTIVATE_REQUESTED
	//
	//    * INACTIVATE_IN_PROGRESS
	//
	//    * INACTIVE
	//
	//    * ERROR
	Status *string `locationName:"status" type:"string"`

	// The training data schema.
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure"`

	// The training data source.
	TrainingDataSource *string `locationName:"trainingDataSource" type:"string" enum:"TrainingDataSourceEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetModelVersionOutput) SetArn(v string) *GetModelVersionOutput {
	s.Arn = &v
	return s
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *GetModelVersionOutput) SetExternalEventsDetail(v *ExternalEventsDetail) *GetModelVersionOutput {
	s.ExternalEventsDetail = v
	return s
}

// SetIngestedEventsDetail sets the IngestedEventsDetail field's value.
func (s *GetModelVersionOutput) SetIngestedEventsDetail(v *IngestedEventsDetail) *GetModelVersionOutput {
	s.IngestedEventsDetail = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelVersionOutput) SetModelId(v string) *GetModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelVersionOutput) SetModelType(v string) *GetModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *GetModelVersionOutput) SetModelVersionNumber(v string) *GetModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetModelVersionOutput) SetStatus(v string) *GetModelVersionOutput {
	s.Status = &v
	return s
}

// SetTrainingDataSchema sets the TrainingDataSchema field's value.
func (s *GetModelVersionOutput) SetTrainingDataSchema(v *TrainingDataSchema) *GetModelVersionOutput {
	s.TrainingDataSchema = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *GetModelVersionOutput) SetTrainingDataSource(v string) *GetModelVersionOutput {
	s.TrainingDataSource = &v
	return s
}

type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetModelsInput) SetMaxResults(v int64) *GetModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelsInput) SetModelId(v string) *GetModelsInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelsInput) SetModelType(v string) *GetModelsInput {
	s.ModelType = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsInput) SetNextToken(v string) *GetModelsInput {
	s.NextToken = &v
	return s
}

type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	// The array of models.
	Models []*Model `locationName:"models" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *GetModelsOutput) SetModels(v []*Model) *GetModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsOutput) SetNextToken(v string) *GetModelsOutput {
	s.NextToken = &v
	return s
}

type GetOutcomesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the outcome or outcomes to get.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutcomesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutcomesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutcomesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutcomesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetOutcomesInput) SetMaxResults(v int64) *GetOutcomesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetOutcomesInput) SetName(v string) *GetOutcomesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutcomesInput) SetNextToken(v string) *GetOutcomesInput {
	s.NextToken = &v
	return s
}

type GetOutcomesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The outcomes.
	Outcomes []*Outcome `locationName:"outcomes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutcomesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutcomesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutcomesOutput) SetNextToken(v string) *GetOutcomesOutput {
	s.NextToken = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *GetOutcomesOutput) SetOutcomes(v []*Outcome) *GetOutcomesOutput {
	s.Outcomes = v
	return s
}

type GetRulesInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of rules to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRulesInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetRulesInput) SetDetectorId(v string) *GetRulesInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRulesInput) SetMaxResults(v int64) *GetRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRulesInput) SetNextToken(v string) *GetRulesInput {
	s.NextToken = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetRulesInput) SetRuleId(v string) *GetRulesInput {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *GetRulesInput) SetRuleVersion(v string) *GetRulesInput {
	s.RuleVersion = &v
	return s
}

type GetRulesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The details of the requested rule.
	RuleDetails []*RuleDetail `locationName:"ruleDetails" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetRulesOutput) SetNextToken(v string) *GetRulesOutput {
	s.NextToken = &v
	return s
}

// SetRuleDetails sets the RuleDetails field's value.
func (s *GetRulesOutput) SetRuleDetails(v []*RuleDetail) *GetRulesOutput {
	s.RuleDetails = v
	return s
}

type GetVariablesInput struct {
	_ struct{} `type:"structure"`

	// The max size per page determined for the get variable request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The next page token of the get variable request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVariablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVariablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetVariablesInput) SetMaxResults(v int64) *GetVariablesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetVariablesInput) SetName(v string) *GetVariablesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVariablesInput) SetNextToken(v string) *GetVariablesInput {
	s.NextToken = &v
	return s
}

type GetVariablesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The names of the variables returned.
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVariablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetVariablesOutput) SetNextToken(v string) *GetVariablesOutput {
	s.NextToken = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *GetVariablesOutput) SetVariables(v []*Variable) *GetVariablesOutput {
	s.Variables = v
	return s
}

// Data about the stored events.
type IngestedEventStatistics struct {
	_ struct{} `type:"structure"`

	// The total size of the stored events.
	EventDataSizeInBytes *int64 `locationName:"eventDataSizeInBytes" type:"long"`

	// Timestamp of when the stored event was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The oldest stored event.
	LeastRecentEvent *string `locationName:"leastRecentEvent" min:"11" type:"string"`

	// The newest stored event.
	MostRecentEvent *string `locationName:"mostRecentEvent" min:"11" type:"string"`

	// The number of stored events.
	NumberOfEvents *int64 `locationName:"numberOfEvents" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedEventStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedEventStatistics) GoString() string {
	return s.String()
}

// SetEventDataSizeInBytes sets the EventDataSizeInBytes field's value.
func (s *IngestedEventStatistics) SetEventDataSizeInBytes(v int64) *IngestedEventStatistics {
	s.EventDataSizeInBytes = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *IngestedEventStatistics) SetLastUpdatedTime(v string) *IngestedEventStatistics {
	s.LastUpdatedTime = &v
	return s
}

// SetLeastRecentEvent sets the LeastRecentEvent field's value.
func (s *IngestedEventStatistics) SetLeastRecentEvent(v string) *IngestedEventStatistics {
	s.LeastRecentEvent = &v
	return s
}

// SetMostRecentEvent sets the MostRecentEvent field's value.
func (s *IngestedEventStatistics) SetMostRecentEvent(v string) *IngestedEventStatistics {
	s.MostRecentEvent = &v
	return s
}

// SetNumberOfEvents sets the NumberOfEvents field's value.
func (s *IngestedEventStatistics) SetNumberOfEvents(v int64) *IngestedEventStatistics {
	s.NumberOfEvents = &v
	return s
}

// The details of the ingested event.
type IngestedEventsDetail struct {
	_ struct{} `type:"structure"`

	// The start and stop time of the ingested events.
	//
	// IngestedEventsTimeWindow is a required field
	IngestedEventsTimeWindow *IngestedEventsTimeWindow `locationName:"ingestedEventsTimeWindow" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedEventsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedEventsDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestedEventsDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestedEventsDetail"}
	if s.IngestedEventsTimeWindow == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestedEventsTimeWindow"))
	}
	if s.IngestedEventsTimeWindow != nil {
		if err := s.IngestedEventsTimeWindow.Validate(); err != nil {
			invalidParams.AddNested("IngestedEventsTimeWindow", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIngestedEventsTimeWindow sets the IngestedEventsTimeWindow field's value.
func (s *IngestedEventsDetail) SetIngestedEventsTimeWindow(v *IngestedEventsTimeWindow) *IngestedEventsDetail {
	s.IngestedEventsTimeWindow = v
	return s
}

// The start and stop time of the ingested events.
type IngestedEventsTimeWindow struct {
	_ struct{} `type:"structure"`

	// Timestamp of the final ingested event.
	//
	// EndTime is a required field
	EndTime *string `locationName:"endTime" min:"11" type:"string" required:"true"`

	// Timestamp of the first ingensted event.
	//
	// StartTime is a required field
	StartTime *string `locationName:"startTime" min:"11" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedEventsTimeWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedEventsTimeWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestedEventsTimeWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestedEventsTimeWindow"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.EndTime != nil && len(*s.EndTime) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("EndTime", 11))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StartTime != nil && len(*s.StartTime) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("StartTime", 11))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *IngestedEventsTimeWindow) SetEndTime(v string) *IngestedEventsTimeWindow {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *IngestedEventsTimeWindow) SetStartTime(v string) *IngestedEventsTimeWindow {
	s.StartTime = &v
	return s
}

// An exception indicating an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The KMS key details.
type KMSKey struct {
	_ struct{} `type:"structure"`

	// The encryption key ARN.
	KmsEncryptionKeyArn *string `locationName:"kmsEncryptionKeyArn" min:"7" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSKey) GoString() string {
	return s.String()
}

// SetKmsEncryptionKeyArn sets the KmsEncryptionKeyArn field's value.
func (s *KMSKey) SetKmsEncryptionKeyArn(v string) *KMSKey {
	s.KmsEncryptionKeyArn = &v
	return s
}

// The label details.
type Label struct {
	_ struct{} `type:"structure"`

	// The label ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the event type was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The label description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Timestamp of when the label was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The label name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Label) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Label) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Label) SetArn(v string) *Label {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Label) SetCreatedTime(v string) *Label {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Label) SetDescription(v string) *Label {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Label) SetLastUpdatedTime(v string) *Label {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Label) SetName(v string) *Label {
	s.Name = &v
	return s
}

// The label schema.
type LabelSchema struct {
	_ struct{} `type:"structure"`

	// The label mapper maps the Amazon Fraud Detector supported model classification
	// labels (FRAUD, LEGIT) to the appropriate event type labels. For example,
	// if "FRAUD" and "LEGIT" are Amazon Fraud Detector supported labels, this mapper
	// could be: {"FRAUD" => ["0"], "LEGIT" => ["1"]} or {"FRAUD" => ["false"],
	// "LEGIT" => ["true"]} or {"FRAUD" => ["fraud", "abuse"], "LEGIT" => ["legit",
	// "safe"]}. The value part of the mapper is a list, because you may have multiple
	// label variants from your event type for a single Amazon Fraud Detector label.
	LabelMapper map[string][]*string `locationName:"labelMapper" type:"map"`

	// The action to take for unlabeled events.
	//
	//    * Use IGNORE if you want the unlabeled events to be ignored. This is recommended
	//    when the majority of the events in the dataset are labeled.
	//
	//    * Use FRAUD if you want to categorize all unlabeled events as “Fraud”.
	//    This is recommended when most of the events in your dataset are fraudulent.
	//
	//    * Use LEGIT if you want to categorize all unlabeled events as “Legit”.
	//    This is recommended when most of the events in your dataset are legitimate.
	//
	//    * Use AUTO if you want Amazon Fraud Detector to decide how to use the
	//    unlabeled data. This is recommended when there is significant unlabeled
	//    events in the dataset.
	//
	// By default, Amazon Fraud Detector ignores the unlabeled data.
	UnlabeledEventsTreatment *string `locationName:"unlabeledEventsTreatment" type:"string" enum:"UnlabeledEventsTreatment"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelSchema) GoString() string {
	return s.String()
}

// SetLabelMapper sets the LabelMapper field's value.
func (s *LabelSchema) SetLabelMapper(v map[string][]*string) *LabelSchema {
	s.LabelMapper = v
	return s
}

// SetUnlabeledEventsTreatment sets the UnlabeledEventsTreatment field's value.
func (s *LabelSchema) SetUnlabeledEventsTreatment(v string) *LabelSchema {
	s.UnlabeledEventsTreatment = &v
	return s
}

type ListEventPredictionsInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *FilterCondition `locationName:"detectorId" type:"structure"`

	// The detector version ID.
	DetectorVersionId *FilterCondition `locationName:"detectorVersionId" type:"structure"`

	// The event ID.
	EventId *FilterCondition `locationName:"eventId" type:"structure"`

	// The event type associated with the detector.
	EventType *FilterCondition `locationName:"eventType" type:"structure"`

	// The maximum number of predictions to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// Identifies the next page of results to return. Use the token to make the
	// call again to retrieve the next page. Keep all other arguments unchanged.
	// Each pagination token expires after 24 hours.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The time period for when the predictions were generated.
	PredictionTimeRange *PredictionTimeRange `locationName:"predictionTimeRange" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventPredictionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventPredictionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventPredictionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventPredictionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.DetectorId != nil {
		if err := s.DetectorId.Validate(); err != nil {
			invalidParams.AddNested("DetectorId", err.(request.ErrInvalidParams))
		}
	}
	if s.DetectorVersionId != nil {
		if err := s.DetectorVersionId.Validate(); err != nil {
			invalidParams.AddNested("DetectorVersionId", err.(request.ErrInvalidParams))
		}
	}
	if s.EventId != nil {
		if err := s.EventId.Validate(); err != nil {
			invalidParams.AddNested("EventId", err.(request.ErrInvalidParams))
		}
	}
	if s.EventType != nil {
		if err := s.EventType.Validate(); err != nil {
			invalidParams.AddNested("EventType", err.(request.ErrInvalidParams))
		}
	}
	if s.PredictionTimeRange != nil {
		if err := s.PredictionTimeRange.Validate(); err != nil {
			invalidParams.AddNested("PredictionTimeRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListEventPredictionsInput) SetDetectorId(v *FilterCondition) *ListEventPredictionsInput {
	s.DetectorId = v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *ListEventPredictionsInput) SetDetectorVersionId(v *FilterCondition) *ListEventPredictionsInput {
	s.DetectorVersionId = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *ListEventPredictionsInput) SetEventId(v *FilterCondition) *ListEventPredictionsInput {
	s.EventId = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *ListEventPredictionsInput) SetEventType(v *FilterCondition) *ListEventPredictionsInput {
	s.EventType = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventPredictionsInput) SetMaxResults(v int64) *ListEventPredictionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventPredictionsInput) SetNextToken(v string) *ListEventPredictionsInput {
	s.NextToken = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ListEventPredictionsInput) SetPredictionTimeRange(v *PredictionTimeRange) *ListEventPredictionsInput {
	s.PredictionTimeRange = v
	return s
}

type ListEventPredictionsOutput struct {
	_ struct{} `type:"structure"`

	// The summary of the past predictions.
	EventPredictionSummaries []*EventPredictionSummary `locationName:"eventPredictionSummaries" type:"list"`

	// Identifies the next page of results to return. Use the token to make the
	// call again to retrieve the next page. Keep all other arguments unchanged.
	// Each pagination token expires after 24 hours.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventPredictionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventPredictionsOutput) GoString() string {
	return s.String()
}

// SetEventPredictionSummaries sets the EventPredictionSummaries field's value.
func (s *ListEventPredictionsOutput) SetEventPredictionSummaries(v []*EventPredictionSummary) *ListEventPredictionsOutput {
	s.EventPredictionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventPredictionsOutput) SetNextToken(v string) *ListEventPredictionsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The next token from the previous results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN that specifies the resource whose tags you want to list.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The next token for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The log odds metric details.
type LogOddsMetric struct {
	_ struct{} `type:"structure"`

	// The relative importance of the variable. For more information, see Model
	// variable importance (https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html).
	//
	// VariableImportance is a required field
	VariableImportance *float64 `locationName:"variableImportance" type:"float" required:"true"`

	// The name of the variable.
	//
	// VariableName is a required field
	VariableName *string `locationName:"variableName" type:"string" required:"true"`

	// The type of variable.
	//
	// VariableType is a required field
	VariableType *string `locationName:"variableType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogOddsMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogOddsMetric) GoString() string {
	return s.String()
}

// SetVariableImportance sets the VariableImportance field's value.
func (s *LogOddsMetric) SetVariableImportance(v float64) *LogOddsMetric {
	s.VariableImportance = &v
	return s
}

// SetVariableName sets the VariableName field's value.
func (s *LogOddsMetric) SetVariableName(v string) *LogOddsMetric {
	s.VariableName = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *LogOddsMetric) SetVariableType(v string) *LogOddsMetric {
	s.VariableType = &v
	return s
}

// Model performance metrics data points.
type MetricDataPoint struct {
	_ struct{} `type:"structure"`

	// The false positive rate. This is the percentage of total legitimate events
	// that are incorrectly predicted as fraud.
	Fpr *float64 `locationName:"fpr" type:"float"`

	// The percentage of fraud events correctly predicted as fraudulent as compared
	// to all events predicted as fraudulent.
	Precision *float64 `locationName:"precision" type:"float"`

	// The model threshold that specifies an acceptable fraud capture rate. For
	// example, a threshold of 500 means any model score 500 or above is labeled
	// as fraud.
	Threshold *float64 `locationName:"threshold" type:"float"`

	// The true positive rate. This is the percentage of total fraud the model detects.
	// Also known as capture rate.
	Tpr *float64 `locationName:"tpr" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataPoint) GoString() string {
	return s.String()
}

// SetFpr sets the Fpr field's value.
func (s *MetricDataPoint) SetFpr(v float64) *MetricDataPoint {
	s.Fpr = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *MetricDataPoint) SetPrecision(v float64) *MetricDataPoint {
	s.Precision = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *MetricDataPoint) SetThreshold(v float64) *MetricDataPoint {
	s.Threshold = &v
	return s
}

// SetTpr sets the Tpr field's value.
func (s *MetricDataPoint) SetTpr(v float64) *MetricDataPoint {
	s.Tpr = &v
	return s
}

// The model.
type Model struct {
	_ struct{} `type:"structure"`

	// The ARN of the model.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the model was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the event type.
	EventTypeName *string `locationName:"eventTypeName" type:"string"`

	// Timestamp of last time the model was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Model) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Model) SetArn(v string) *Model {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Model) SetCreatedTime(v string) *Model {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Model) SetDescription(v string) *Model {
	s.Description = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *Model) SetEventTypeName(v string) *Model {
	s.EventTypeName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Model) SetLastUpdatedTime(v string) *Model {
	s.LastUpdatedTime = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *Model) SetModelId(v string) *Model {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *Model) SetModelType(v string) *Model {
	s.ModelType = &v
	return s
}

// A pre-formed Amazon SageMaker model input you can include if your detector
// version includes an imported Amazon SageMaker model endpoint with pass-through
// input configuration.
type ModelEndpointDataBlob struct {
	_ struct{} `type:"structure"`

	// The byte buffer of the Amazon SageMaker model endpoint input data blob.
	// ByteBuffer is automatically base64 encoded/decoded by the SDK.
	ByteBuffer []byte `locationName:"byteBuffer" type:"blob"`

	// The content type of the Amazon SageMaker model endpoint input data blob.
	ContentType *string `locationName:"contentType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelEndpointDataBlob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelEndpointDataBlob) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelEndpointDataBlob) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelEndpointDataBlob"}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteBuffer sets the ByteBuffer field's value.
func (s *ModelEndpointDataBlob) SetByteBuffer(v []byte) *ModelEndpointDataBlob {
	s.ByteBuffer = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ModelEndpointDataBlob) SetContentType(v string) *ModelEndpointDataBlob {
	s.ContentType = &v
	return s
}

// The Amazon SageMaker model input configuration.
type ModelInputConfiguration struct {
	_ struct{} `type:"structure"`

	// Template for constructing the CSV input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable-names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	CsvInputTemplate *string `locationName:"csvInputTemplate" min:"1" type:"string"`

	// The event type name.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The format of the model input configuration. The format differs depending
	// on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.
	Format *string `locationName:"format" type:"string" enum:"ModelInputDataFormat"`

	// Template for constructing the JSON input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	JsonInputTemplate *string `locationName:"jsonInputTemplate" min:"1" type:"string"`

	// The event variables.
	//
	// UseEventVariables is a required field
	UseEventVariables *bool `locationName:"useEventVariables" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelInputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelInputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelInputConfiguration"}
	if s.CsvInputTemplate != nil && len(*s.CsvInputTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CsvInputTemplate", 1))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.JsonInputTemplate != nil && len(*s.JsonInputTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JsonInputTemplate", 1))
	}
	if s.UseEventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("UseEventVariables"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvInputTemplate sets the CsvInputTemplate field's value.
func (s *ModelInputConfiguration) SetCsvInputTemplate(v string) *ModelInputConfiguration {
	s.CsvInputTemplate = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *ModelInputConfiguration) SetEventTypeName(v string) *ModelInputConfiguration {
	s.EventTypeName = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ModelInputConfiguration) SetFormat(v string) *ModelInputConfiguration {
	s.Format = &v
	return s
}

// SetJsonInputTemplate sets the JsonInputTemplate field's value.
func (s *ModelInputConfiguration) SetJsonInputTemplate(v string) *ModelInputConfiguration {
	s.JsonInputTemplate = &v
	return s
}

// SetUseEventVariables sets the UseEventVariables field's value.
func (s *ModelInputConfiguration) SetUseEventVariables(v bool) *ModelInputConfiguration {
	s.UseEventVariables = &v
	return s
}

// Provides the Amazon Sagemaker model output configuration.
type ModelOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// A map of CSV index values in the SageMaker response to the Amazon Fraud Detector
	// variables.
	CsvIndexToVariableMap map[string]*string `locationName:"csvIndexToVariableMap" type:"map"`

	// The format of the model output configuration.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"ModelOutputDataFormat"`

	// A map of JSON keys in response from SageMaker to the Amazon Fraud Detector
	// variables.
	JsonKeyToVariableMap map[string]*string `locationName:"jsonKeyToVariableMap" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelOutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelOutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelOutputConfiguration"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvIndexToVariableMap sets the CsvIndexToVariableMap field's value.
func (s *ModelOutputConfiguration) SetCsvIndexToVariableMap(v map[string]*string) *ModelOutputConfiguration {
	s.CsvIndexToVariableMap = v
	return s
}

// SetFormat sets the Format field's value.
func (s *ModelOutputConfiguration) SetFormat(v string) *ModelOutputConfiguration {
	s.Format = &v
	return s
}

// SetJsonKeyToVariableMap sets the JsonKeyToVariableMap field's value.
func (s *ModelOutputConfiguration) SetJsonKeyToVariableMap(v map[string]*string) *ModelOutputConfiguration {
	s.JsonKeyToVariableMap = v
	return s
}

// The fraud prediction scores.
type ModelScores struct {
	_ struct{} `type:"structure"`

	// The model version.
	ModelVersion *ModelVersion `locationName:"modelVersion" type:"structure"`

	// The model's fraud prediction scores.
	Scores map[string]*float64 `locationName:"scores" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelScores) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelScores) GoString() string {
	return s.String()
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ModelScores) SetModelVersion(v *ModelVersion) *ModelScores {
	s.ModelVersion = v
	return s
}

// SetScores sets the Scores field's value.
func (s *ModelScores) SetScores(v map[string]*float64) *ModelScores {
	s.Scores = v
	return s
}

// The model version.
type ModelVersion struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelVersion"}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ModelVersion) SetArn(v string) *ModelVersion {
	s.Arn = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *ModelVersion) SetModelId(v string) *ModelVersion {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *ModelVersion) SetModelType(v string) *ModelVersion {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *ModelVersion) SetModelVersionNumber(v string) *ModelVersion {
	s.ModelVersionNumber = &v
	return s
}

// The details of the model version.
type ModelVersionDetail struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp when the model was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The external events data details. This will be populated if the trainingDataSource
	// for the model version is specified as EXTERNAL_EVENTS.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The ingested events data details. This will be populated if the trainingDataSource
	// for the model version is specified as INGESTED_EVENTS.
	IngestedEventsDetail *IngestedEventsDetail `locationName:"ingestedEventsDetail" type:"structure"`

	// The timestamp when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The status of the model version.
	Status *string `locationName:"status" type:"string"`

	// The training data schema.
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure"`

	// The model version training data source.
	TrainingDataSource *string `locationName:"trainingDataSource" type:"string" enum:"TrainingDataSourceEnum"`

	// The training results.
	TrainingResult *TrainingResult `locationName:"trainingResult" type:"structure"`

	// The training result details. The details include the relative importance
	// of the variables.
	TrainingResultV2 *TrainingResultV2 `locationName:"trainingResultV2" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelVersionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelVersionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ModelVersionDetail) SetArn(v string) *ModelVersionDetail {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ModelVersionDetail) SetCreatedTime(v string) *ModelVersionDetail {
	s.CreatedTime = &v
	return s
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *ModelVersionDetail) SetExternalEventsDetail(v *ExternalEventsDetail) *ModelVersionDetail {
	s.ExternalEventsDetail = v
	return s
}

// SetIngestedEventsDetail sets the IngestedEventsDetail field's value.
func (s *ModelVersionDetail) SetIngestedEventsDetail(v *IngestedEventsDetail) *ModelVersionDetail {
	s.IngestedEventsDetail = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ModelVersionDetail) SetLastUpdatedTime(v string) *ModelVersionDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *ModelVersionDetail) SetModelId(v string) *ModelVersionDetail {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *ModelVersionDetail) SetModelType(v string) *ModelVersionDetail {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *ModelVersionDetail) SetModelVersionNumber(v string) *ModelVersionDetail {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelVersionDetail) SetStatus(v string) *ModelVersionDetail {
	s.Status = &v
	return s
}

// SetTrainingDataSchema sets the TrainingDataSchema field's value.
func (s *ModelVersionDetail) SetTrainingDataSchema(v *TrainingDataSchema) *ModelVersionDetail {
	s.TrainingDataSchema = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *ModelVersionDetail) SetTrainingDataSource(v string) *ModelVersionDetail {
	s.TrainingDataSource = &v
	return s
}

// SetTrainingResult sets the TrainingResult field's value.
func (s *ModelVersionDetail) SetTrainingResult(v *TrainingResult) *ModelVersionDetail {
	s.TrainingResult = v
	return s
}

// SetTrainingResultV2 sets the TrainingResultV2 field's value.
func (s *ModelVersionDetail) SetTrainingResultV2(v *TrainingResultV2) *ModelVersionDetail {
	s.TrainingResultV2 = v
	return s
}

// The model version evalutions.
type ModelVersionEvaluation struct {
	_ struct{} `type:"structure"`

	// The evaluation score generated for the model version.
	EvaluationScore *string `locationName:"evaluationScore" type:"string"`

	// The output variable name.
	OutputVariableName *string `locationName:"outputVariableName" type:"string"`

	// The prediction explanations generated for the model version.
	PredictionExplanations *PredictionExplanations `locationName:"predictionExplanations" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelVersionEvaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelVersionEvaluation) GoString() string {
	return s.String()
}

// SetEvaluationScore sets the EvaluationScore field's value.
func (s *ModelVersionEvaluation) SetEvaluationScore(v string) *ModelVersionEvaluation {
	s.EvaluationScore = &v
	return s
}

// SetOutputVariableName sets the OutputVariableName field's value.
func (s *ModelVersionEvaluation) SetOutputVariableName(v string) *ModelVersionEvaluation {
	s.OutputVariableName = &v
	return s
}

// SetPredictionExplanations sets the PredictionExplanations field's value.
func (s *ModelVersionEvaluation) SetPredictionExplanations(v *PredictionExplanations) *ModelVersionEvaluation {
	s.PredictionExplanations = v
	return s
}

// The Online Fraud Insights (OFI) model performance metrics data points.
type OFIMetricDataPoint struct {
	_ struct{} `type:"structure"`

	// The false positive rate. This is the percentage of total legitimate events
	// that are incorrectly predicted as fraud.
	Fpr *float64 `locationName:"fpr" type:"float"`

	// The percentage of fraud events correctly predicted as fraudulent as compared
	// to all events predicted as fraudulent.
	Precision *float64 `locationName:"precision" type:"float"`

	// The model threshold that specifies an acceptable fraud capture rate. For
	// example, a threshold of 500 means any model score 500 or above is labeled
	// as fraud.
	Threshold *float64 `locationName:"threshold" type:"float"`

	// The true positive rate. This is the percentage of total fraud the model detects.
	// Also known as capture rate.
	Tpr *float64 `locationName:"tpr" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OFIMetricDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OFIMetricDataPoint) GoString() string {
	return s.String()
}

// SetFpr sets the Fpr field's value.
func (s *OFIMetricDataPoint) SetFpr(v float64) *OFIMetricDataPoint {
	s.Fpr = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *OFIMetricDataPoint) SetPrecision(v float64) *OFIMetricDataPoint {
	s.Precision = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *OFIMetricDataPoint) SetThreshold(v float64) *OFIMetricDataPoint {
	s.Threshold = &v
	return s
}

// SetTpr sets the Tpr field's value.
func (s *OFIMetricDataPoint) SetTpr(v float64) *OFIMetricDataPoint {
	s.Tpr = &v
	return s
}

// The Online Fraud Insights (OFI) model performance score.
type OFIModelPerformance struct {
	_ struct{} `type:"structure"`

	// The area under the curve (auc). This summarizes the total positive rate (tpr)
	// and false positive rate (FPR) across all possible model score thresholds.
	Auc *float64 `locationName:"auc" type:"float"`

	// Indicates the range of area under curve (auc) expected from the OFI model.
	// A range greater than 0.1 indicates higher model uncertainity.
	UncertaintyRange *UncertaintyRange `locationName:"uncertaintyRange" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OFIModelPerformance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OFIModelPerformance) GoString() string {
	return s.String()
}

// SetAuc sets the Auc field's value.
func (s *OFIModelPerformance) SetAuc(v float64) *OFIModelPerformance {
	s.Auc = &v
	return s
}

// SetUncertaintyRange sets the UncertaintyRange field's value.
func (s *OFIModelPerformance) SetUncertaintyRange(v *UncertaintyRange) *OFIModelPerformance {
	s.UncertaintyRange = v
	return s
}

// The Online Fraud Insights (OFI) model training metric details.
type OFITrainingMetricsValue struct {
	_ struct{} `type:"structure"`

	// The model's performance metrics data points.
	MetricDataPoints []*OFIMetricDataPoint `locationName:"metricDataPoints" type:"list"`

	// The model's overall performance score.
	ModelPerformance *OFIModelPerformance `locationName:"modelPerformance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OFITrainingMetricsValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OFITrainingMetricsValue) GoString() string {
	return s.String()
}

// SetMetricDataPoints sets the MetricDataPoints field's value.
func (s *OFITrainingMetricsValue) SetMetricDataPoints(v []*OFIMetricDataPoint) *OFITrainingMetricsValue {
	s.MetricDataPoints = v
	return s
}

// SetModelPerformance sets the ModelPerformance field's value.
func (s *OFITrainingMetricsValue) SetModelPerformance(v *OFIModelPerformance) *OFITrainingMetricsValue {
	s.ModelPerformance = v
	return s
}

// The outcome.
type Outcome struct {
	_ struct{} `type:"structure"`

	// The outcome ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp when the outcome was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The timestamp when the outcome was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The outcome name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Outcome) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Outcome) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Outcome) SetArn(v string) *Outcome {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Outcome) SetCreatedTime(v string) *Outcome {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Outcome) SetDescription(v string) *Outcome {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Outcome) SetLastUpdatedTime(v string) *Outcome {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Outcome) SetName(v string) *Outcome {
	s.Name = &v
	return s
}

// The prediction explanations that provide insight into how each event variable
// impacted the model version's fraud prediction score.
type PredictionExplanations struct {
	_ struct{} `type:"structure"`

	// The details of the aggregated variables impact on the prediction score.
	//
	// Account Takeover Insights (ATI) model uses event variables from the login
	// data you provide to continuously calculate a set of variables (aggregated
	// variables) based on historical events. For example, your ATI model might
	// calculate the number of times an user has logged in using the same IP address.
	// In this case, event variables used to derive the aggregated variables are
	// IP address and user.
	AggregatedVariablesImpactExplanations []*AggregatedVariablesImpactExplanation `locationName:"aggregatedVariablesImpactExplanations" type:"list"`

	// The details of the event variable's impact on the prediction score.
	VariableImpactExplanations []*VariableImpactExplanation `locationName:"variableImpactExplanations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictionExplanations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictionExplanations) GoString() string {
	return s.String()
}

// SetAggregatedVariablesImpactExplanations sets the AggregatedVariablesImpactExplanations field's value.
func (s *PredictionExplanations) SetAggregatedVariablesImpactExplanations(v []*AggregatedVariablesImpactExplanation) *PredictionExplanations {
	s.AggregatedVariablesImpactExplanations = v
	return s
}

// SetVariableImpactExplanations sets the VariableImpactExplanations field's value.
func (s *PredictionExplanations) SetVariableImpactExplanations(v []*VariableImpactExplanation) *PredictionExplanations {
	s.VariableImpactExplanations = v
	return s
}

// The time period for when the predictions were generated.
type PredictionTimeRange struct {
	_ struct{} `type:"structure"`

	// The end time of the time period for when the predictions were generated.
	//
	// EndTime is a required field
	EndTime *string `locationName:"endTime" min:"11" type:"string" required:"true"`

	// The start time of the time period for when the predictions were generated.
	//
	// StartTime is a required field
	StartTime *string `locationName:"startTime" min:"11" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictionTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictionTimeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictionTimeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictionTimeRange"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.EndTime != nil && len(*s.EndTime) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("EndTime", 11))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StartTime != nil && len(*s.StartTime) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("StartTime", 11))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *PredictionTimeRange) SetEndTime(v string) *PredictionTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PredictionTimeRange) SetStartTime(v string) *PredictionTimeRange {
	s.StartTime = &v
	return s
}

type PutDetectorInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDetectorInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutDetectorInput) SetDescription(v string) *PutDetectorInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *PutDetectorInput) SetDetectorId(v string) *PutDetectorInput {
	s.DetectorId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *PutDetectorInput) SetEventTypeName(v string) *PutDetectorInput {
	s.EventTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutDetectorInput) SetTags(v []*Tag) *PutDetectorInput {
	s.Tags = v
	return s
}

type PutDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDetectorOutput) GoString() string {
	return s.String()
}

type PutEntityTypeInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the entity type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEntityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEntityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEntityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEntityTypeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutEntityTypeInput) SetDescription(v string) *PutEntityTypeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutEntityTypeInput) SetName(v string) *PutEntityTypeInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutEntityTypeInput) SetTags(v []*Tag) *PutEntityTypeInput {
	s.Tags = v
	return s
}

type PutEntityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEntityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEntityTypeOutput) GoString() string {
	return s.String()
}

type PutEventTypeInput struct {
	_ struct{} `type:"structure"`

	// The description of the event type.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The entity type for the event type. Example entity types: customer, merchant,
	// account.
	//
	// EntityTypes is a required field
	EntityTypes []*string `locationName:"entityTypes" min:"1" type:"list" required:"true"`

	// Specifies if ingestion is enabled or disabled.
	EventIngestion *string `locationName:"eventIngestion" type:"string" enum:"EventIngestion"`

	// Enables or disables event orchestration. If enabled, you can send event predictions
	// to select AWS services for downstream processing of the events.
	EventOrchestration *EventOrchestration `locationName:"eventOrchestration" type:"structure"`

	// The event type variables.
	//
	// EventVariables is a required field
	EventVariables []*string `locationName:"eventVariables" min:"1" type:"list" required:"true"`

	// The event type labels.
	Labels []*string `locationName:"labels" type:"list"`

	// The name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventTypeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.EntityTypes != nil && len(s.EntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityTypes", 1))
	}
	if s.EventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("EventVariables"))
	}
	if s.EventVariables != nil && len(s.EventVariables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventVariables", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.EventOrchestration != nil {
		if err := s.EventOrchestration.Validate(); err != nil {
			invalidParams.AddNested("EventOrchestration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutEventTypeInput) SetDescription(v string) *PutEventTypeInput {
	s.Description = &v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *PutEventTypeInput) SetEntityTypes(v []*string) *PutEventTypeInput {
	s.EntityTypes = v
	return s
}

// SetEventIngestion sets the EventIngestion field's value.
func (s *PutEventTypeInput) SetEventIngestion(v string) *PutEventTypeInput {
	s.EventIngestion = &v
	return s
}

// SetEventOrchestration sets the EventOrchestration field's value.
func (s *PutEventTypeInput) SetEventOrchestration(v *EventOrchestration) *PutEventTypeInput {
	s.EventOrchestration = v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *PutEventTypeInput) SetEventVariables(v []*string) *PutEventTypeInput {
	s.EventVariables = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *PutEventTypeInput) SetLabels(v []*string) *PutEventTypeInput {
	s.Labels = v
	return s
}

// SetName sets the Name field's value.
func (s *PutEventTypeInput) SetName(v string) *PutEventTypeInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutEventTypeInput) SetTags(v []*Tag) *PutEventTypeInput {
	s.Tags = v
	return s
}

type PutEventTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventTypeOutput) GoString() string {
	return s.String()
}

type PutExternalModelInput struct {
	_ struct{} `type:"structure"`

	// The model endpoint input configuration.
	//
	// InputConfiguration is a required field
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure" required:"true"`

	// The IAM role used to invoke the model endpoint.
	//
	// InvokeModelEndpointRoleArn is a required field
	InvokeModelEndpointRoleArn *string `locationName:"invokeModelEndpointRoleArn" type:"string" required:"true"`

	// The model endpoints name.
	//
	// ModelEndpoint is a required field
	ModelEndpoint *string `locationName:"modelEndpoint" min:"1" type:"string" required:"true"`

	// The model endpoint’s status in Amazon Fraud Detector.
	//
	// ModelEndpointStatus is a required field
	ModelEndpointStatus *string `locationName:"modelEndpointStatus" type:"string" required:"true" enum:"ModelEndpointStatus"`

	// The source of the model.
	//
	// ModelSource is a required field
	ModelSource *string `locationName:"modelSource" type:"string" required:"true" enum:"ModelSource"`

	// The model endpoint output configuration.
	//
	// OutputConfiguration is a required field
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutExternalModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutExternalModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutExternalModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutExternalModelInput"}
	if s.InputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfiguration"))
	}
	if s.InvokeModelEndpointRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InvokeModelEndpointRoleArn"))
	}
	if s.ModelEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpoint"))
	}
	if s.ModelEndpoint != nil && len(*s.ModelEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelEndpoint", 1))
	}
	if s.ModelEndpointStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpointStatus"))
	}
	if s.ModelSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelSource"))
	}
	if s.OutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfiguration"))
	}
	if s.InputConfiguration != nil {
		if err := s.InputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfiguration != nil {
		if err := s.OutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OutputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *PutExternalModelInput) SetInputConfiguration(v *ModelInputConfiguration) *PutExternalModelInput {
	s.InputConfiguration = v
	return s
}

// SetInvokeModelEndpointRoleArn sets the InvokeModelEndpointRoleArn field's value.
func (s *PutExternalModelInput) SetInvokeModelEndpointRoleArn(v string) *PutExternalModelInput {
	s.InvokeModelEndpointRoleArn = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *PutExternalModelInput) SetModelEndpoint(v string) *PutExternalModelInput {
	s.ModelEndpoint = &v
	return s
}

// SetModelEndpointStatus sets the ModelEndpointStatus field's value.
func (s *PutExternalModelInput) SetModelEndpointStatus(v string) *PutExternalModelInput {
	s.ModelEndpointStatus = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *PutExternalModelInput) SetModelSource(v string) *PutExternalModelInput {
	s.ModelSource = &v
	return s
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *PutExternalModelInput) SetOutputConfiguration(v *ModelOutputConfiguration) *PutExternalModelInput {
	s.OutputConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutExternalModelInput) SetTags(v []*Tag) *PutExternalModelInput {
	s.Tags = v
	return s
}

type PutExternalModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutExternalModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutExternalModelOutput) GoString() string {
	return s.String()
}

type PutKMSEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The KMS encryption key ARN.
	//
	// The KMS key must be single-Region key. Amazon Fraud Detector does not support
	// multi-Region KMS key.
	//
	// KmsEncryptionKeyArn is a required field
	KmsEncryptionKeyArn *string `locationName:"kmsEncryptionKeyArn" min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKMSEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKMSEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKMSEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKMSEncryptionKeyInput"}
	if s.KmsEncryptionKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsEncryptionKeyArn"))
	}
	if s.KmsEncryptionKeyArn != nil && len(*s.KmsEncryptionKeyArn) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KmsEncryptionKeyArn", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsEncryptionKeyArn sets the KmsEncryptionKeyArn field's value.
func (s *PutKMSEncryptionKeyInput) SetKmsEncryptionKeyArn(v string) *PutKMSEncryptionKeyInput {
	s.KmsEncryptionKeyArn = &v
	return s
}

type PutKMSEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKMSEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKMSEncryptionKeyOutput) GoString() string {
	return s.String()
}

type PutLabelInput struct {
	_ struct{} `type:"structure"`

	// The label description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The label name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLabelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutLabelInput) SetDescription(v string) *PutLabelInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutLabelInput) SetName(v string) *PutLabelInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutLabelInput) SetTags(v []*Tag) *PutLabelInput {
	s.Tags = v
	return s
}

type PutLabelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLabelOutput) GoString() string {
	return s.String()
}

type PutOutcomeInput struct {
	_ struct{} `type:"structure"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the outcome.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOutcomeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOutcomeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOutcomeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOutcomeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutOutcomeInput) SetDescription(v string) *PutOutcomeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutOutcomeInput) SetName(v string) *PutOutcomeInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutOutcomeInput) SetTags(v []*Tag) *PutOutcomeInput {
	s.Tags = v
	return s
}

type PutOutcomeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOutcomeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOutcomeOutput) GoString() string {
	return s.String()
}

// An exception indicating the specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception indicating that the attached customer-owned (external) model
// threw an exception when Amazon Fraud Detector invoked the model.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// The detector for which the rule is associated.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// The rule version.
	//
	// RuleVersion is a required field
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *Rule) SetDetectorId(v string) *Rule {
	s.DetectorId = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *Rule) SetRuleId(v string) *Rule {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *Rule) SetRuleVersion(v string) *Rule {
	s.RuleVersion = &v
	return s
}

// The details of the rule.
type RuleDetail struct {
	_ struct{} `type:"structure"`

	// The rule ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp of when the rule was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector for which the rule is associated.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The rule expression.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RuleDetail's
	// String and GoString methods.
	Expression *string `locationName:"expression" min:"1" type:"string" sensitive:"true"`

	// The rule language.
	Language *string `locationName:"language" type:"string" enum:"Language"`

	// Timestamp of the last time the rule was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The rule outcomes.
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RuleDetail) SetArn(v string) *RuleDetail {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RuleDetail) SetCreatedTime(v string) *RuleDetail {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuleDetail) SetDescription(v string) *RuleDetail {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *RuleDetail) SetDetectorId(v string) *RuleDetail {
	s.DetectorId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *RuleDetail) SetExpression(v string) *RuleDetail {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *RuleDetail) SetLanguage(v string) *RuleDetail {
	s.Language = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *RuleDetail) SetLastUpdatedTime(v string) *RuleDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *RuleDetail) SetOutcomes(v []*string) *RuleDetail {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleDetail) SetRuleId(v string) *RuleDetail {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *RuleDetail) SetRuleVersion(v string) *RuleDetail {
	s.RuleVersion = &v
	return s
}

// The rule results.
type RuleResult struct {
	_ struct{} `type:"structure"`

	// The outcomes of the matched rule, based on the rule execution mode.
	Outcomes []*string `locationName:"outcomes" type:"list"`

	// The rule ID that was matched, based on the rule execution mode.
	RuleId *string `locationName:"ruleId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleResult) GoString() string {
	return s.String()
}

// SetOutcomes sets the Outcomes field's value.
func (s *RuleResult) SetOutcomes(v []*string) *RuleResult {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleResult) SetRuleId(v string) *RuleResult {
	s.RuleId = &v
	return s
}

type SendEventInput struct {
	_ struct{} `type:"structure"`

	// The label to associate with the event. Required if specifying labelTimestamp.
	AssignedLabel *string `locationName:"assignedLabel" min:"1" type:"string"`

	// An array of entities.
	//
	// Entities is a required field
	Entities []*Entity `locationName:"entities" type:"list" required:"true"`

	// The event ID to upload.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" min:"1" type:"string" required:"true"`

	// The timestamp that defines when the event under evaluation occurred. The
	// timestamp must be specified using ISO 8601 standard in UTC.
	//
	// EventTimestamp is a required field
	EventTimestamp *string `locationName:"eventTimestamp" min:"10" type:"string" required:"true"`

	// The event type name of the event.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// Names of the event type's variables you defined in Amazon Fraud Detector
	// to represent data elements and their corresponding values for the event you
	// are sending for evaluation.
	//
	// EventVariables is a required field
	EventVariables map[string]*string `locationName:"eventVariables" min:"1" type:"map" required:"true"`

	// The timestamp associated with the label. Required if specifying assignedLabel.
	LabelTimestamp *string `locationName:"labelTimestamp" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEventInput"}
	if s.AssignedLabel != nil && len(*s.AssignedLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignedLabel", 1))
	}
	if s.Entities == nil {
		invalidParams.Add(request.NewErrParamRequired("Entities"))
	}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.EventTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTimestamp"))
	}
	if s.EventTimestamp != nil && len(*s.EventTimestamp) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("EventTimestamp", 10))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.EventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("EventVariables"))
	}
	if s.EventVariables != nil && len(s.EventVariables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventVariables", 1))
	}
	if s.LabelTimestamp != nil && len(*s.LabelTimestamp) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("LabelTimestamp", 10))
	}
	if s.Entities != nil {
		for i, v := range s.Entities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entities", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignedLabel sets the AssignedLabel field's value.
func (s *SendEventInput) SetAssignedLabel(v string) *SendEventInput {
	s.AssignedLabel = &v
	return s
}

// SetEntities sets the Entities field's value.
func (s *SendEventInput) SetEntities(v []*Entity) *SendEventInput {
	s.Entities = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *SendEventInput) SetEventId(v string) *SendEventInput {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *SendEventInput) SetEventTimestamp(v string) *SendEventInput {
	s.EventTimestamp = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *SendEventInput) SetEventTypeName(v string) *SendEventInput {
	s.EventTypeName = &v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *SendEventInput) SetEventVariables(v map[string]*string) *SendEventInput {
	s.EventVariables = v
	return s
}

// SetLabelTimestamp sets the LabelTimestamp field's value.
func (s *SendEventInput) SetLabelTimestamp(v string) *SendEventInput {
	s.LabelTimestamp = &v
	return s
}

type SendEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEventOutput) GoString() string {
	return s.String()
}

// The performance metrics data points for Transaction Fraud Insights (TFI)
// model.
type TFIMetricDataPoint struct {
	_ struct{} `type:"structure"`

	// The false positive rate. This is the percentage of total legitimate events
	// that are incorrectly predicted as fraud.
	Fpr *float64 `locationName:"fpr" type:"float"`

	// The percentage of fraud events correctly predicted as fraudulent as compared
	// to all events predicted as fraudulent.
	Precision *float64 `locationName:"precision" type:"float"`

	// The model threshold that specifies an acceptable fraud capture rate. For
	// example, a threshold of 500 means any model score 500 or above is labeled
	// as fraud.
	Threshold *float64 `locationName:"threshold" type:"float"`

	// The true positive rate. This is the percentage of total fraud the model detects.
	// Also known as capture rate.
	Tpr *float64 `locationName:"tpr" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TFIMetricDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TFIMetricDataPoint) GoString() string {
	return s.String()
}

// SetFpr sets the Fpr field's value.
func (s *TFIMetricDataPoint) SetFpr(v float64) *TFIMetricDataPoint {
	s.Fpr = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *TFIMetricDataPoint) SetPrecision(v float64) *TFIMetricDataPoint {
	s.Precision = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *TFIMetricDataPoint) SetThreshold(v float64) *TFIMetricDataPoint {
	s.Threshold = &v
	return s
}

// SetTpr sets the Tpr field's value.
func (s *TFIMetricDataPoint) SetTpr(v float64) *TFIMetricDataPoint {
	s.Tpr = &v
	return s
}

// The Transaction Fraud Insights (TFI) model performance score.
type TFIModelPerformance struct {
	_ struct{} `type:"structure"`

	// The area under the curve (auc). This summarizes the total positive rate (tpr)
	// and false positive rate (FPR) across all possible model score thresholds.
	Auc *float64 `locationName:"auc" type:"float"`

	// Indicates the range of area under curve (auc) expected from the TFI model.
	// A range greater than 0.1 indicates higher model uncertainity.
	UncertaintyRange *UncertaintyRange `locationName:"uncertaintyRange" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TFIModelPerformance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TFIModelPerformance) GoString() string {
	return s.String()
}

// SetAuc sets the Auc field's value.
func (s *TFIModelPerformance) SetAuc(v float64) *TFIModelPerformance {
	s.Auc = &v
	return s
}

// SetUncertaintyRange sets the UncertaintyRange field's value.
func (s *TFIModelPerformance) SetUncertaintyRange(v *UncertaintyRange) *TFIModelPerformance {
	s.UncertaintyRange = v
	return s
}

// The Transaction Fraud Insights (TFI) model training metric details.
type TFITrainingMetricsValue struct {
	_ struct{} `type:"structure"`

	// The model's performance metrics data points.
	MetricDataPoints []*TFIMetricDataPoint `locationName:"metricDataPoints" type:"list"`

	// The model performance score.
	ModelPerformance *TFIModelPerformance `locationName:"modelPerformance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TFITrainingMetricsValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TFITrainingMetricsValue) GoString() string {
	return s.String()
}

// SetMetricDataPoints sets the MetricDataPoints field's value.
func (s *TFITrainingMetricsValue) SetMetricDataPoints(v []*TFIMetricDataPoint) *TFITrainingMetricsValue {
	s.MetricDataPoints = v
	return s
}

// SetModelPerformance sets the ModelPerformance field's value.
func (s *TFITrainingMetricsValue) SetModelPerformance(v *TFIModelPerformance) *TFITrainingMetricsValue {
	s.ModelPerformance = v
	return s
}

// A key and value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// A value assigned to a tag key.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// The tags to assign to the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An exception indicating a throttling error.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The training data schema.
type TrainingDataSchema struct {
	_ struct{} `type:"structure"`

	// The label schema.
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure"`

	// The training data schema variables.
	//
	// ModelVariables is a required field
	ModelVariables []*string `locationName:"modelVariables" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingDataSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrainingDataSchema"}
	if s.ModelVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVariables"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelSchema sets the LabelSchema field's value.
func (s *TrainingDataSchema) SetLabelSchema(v *LabelSchema) *TrainingDataSchema {
	s.LabelSchema = v
	return s
}

// SetModelVariables sets the ModelVariables field's value.
func (s *TrainingDataSchema) SetModelVariables(v []*string) *TrainingDataSchema {
	s.ModelVariables = v
	return s
}

// The training metric details.
type TrainingMetrics struct {
	_ struct{} `type:"structure"`

	// The area under the curve. This summarizes true positive rate (TPR) and false
	// positive rate (FPR) across all possible model score thresholds. A model with
	// no predictive power has an AUC of 0.5, whereas a perfect model has a score
	// of 1.0.
	Auc *float64 `locationName:"auc" type:"float"`

	// The data points details.
	MetricDataPoints []*MetricDataPoint `locationName:"metricDataPoints" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetrics) GoString() string {
	return s.String()
}

// SetAuc sets the Auc field's value.
func (s *TrainingMetrics) SetAuc(v float64) *TrainingMetrics {
	s.Auc = &v
	return s
}

// SetMetricDataPoints sets the MetricDataPoints field's value.
func (s *TrainingMetrics) SetMetricDataPoints(v []*MetricDataPoint) *TrainingMetrics {
	s.MetricDataPoints = v
	return s
}

// The training metrics details.
type TrainingMetricsV2 struct {
	_ struct{} `type:"structure"`

	// The Account Takeover Insights (ATI) model training metric details.
	Ati *ATITrainingMetricsValue `locationName:"ati" type:"structure"`

	// The Online Fraud Insights (OFI) model training metric details.
	Ofi *OFITrainingMetricsValue `locationName:"ofi" type:"structure"`

	// The Transaction Fraud Insights (TFI) model training metric details.
	Tfi *TFITrainingMetricsValue `locationName:"tfi" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetricsV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetricsV2) GoString() string {
	return s.String()
}

// SetAti sets the Ati field's value.
func (s *TrainingMetricsV2) SetAti(v *ATITrainingMetricsValue) *TrainingMetricsV2 {
	s.Ati = v
	return s
}

// SetOfi sets the Ofi field's value.
func (s *TrainingMetricsV2) SetOfi(v *OFITrainingMetricsValue) *TrainingMetricsV2 {
	s.Ofi = v
	return s
}

// SetTfi sets the Tfi field's value.
func (s *TrainingMetricsV2) SetTfi(v *TFITrainingMetricsValue) *TrainingMetricsV2 {
	s.Tfi = v
	return s
}

// The training result details.
type TrainingResult struct {
	_ struct{} `type:"structure"`

	// The validation metrics.
	DataValidationMetrics *DataValidationMetrics `locationName:"dataValidationMetrics" type:"structure"`

	// The training metric details.
	TrainingMetrics *TrainingMetrics `locationName:"trainingMetrics" type:"structure"`

	// The variable importance metrics.
	VariableImportanceMetrics *VariableImportanceMetrics `locationName:"variableImportanceMetrics" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingResult) GoString() string {
	return s.String()
}

// SetDataValidationMetrics sets the DataValidationMetrics field's value.
func (s *TrainingResult) SetDataValidationMetrics(v *DataValidationMetrics) *TrainingResult {
	s.DataValidationMetrics = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *TrainingResult) SetTrainingMetrics(v *TrainingMetrics) *TrainingResult {
	s.TrainingMetrics = v
	return s
}

// SetVariableImportanceMetrics sets the VariableImportanceMetrics field's value.
func (s *TrainingResult) SetVariableImportanceMetrics(v *VariableImportanceMetrics) *TrainingResult {
	s.VariableImportanceMetrics = v
	return s
}

// The training result details.
type TrainingResultV2 struct {
	_ struct{} `type:"structure"`

	// The variable importance metrics of the aggregated variables.
	//
	// Account Takeover Insights (ATI) model uses event variables from the login
	// data you provide to continuously calculate a set of variables (aggregated
	// variables) based on historical events. For example, your ATI model might
	// calculate the number of times an user has logged in using the same IP address.
	// In this case, event variables used to derive the aggregated variables are
	// IP address and user.
	AggregatedVariablesImportanceMetrics *AggregatedVariablesImportanceMetrics `locationName:"aggregatedVariablesImportanceMetrics" type:"structure"`

	// The model training data validation metrics.
	DataValidationMetrics *DataValidationMetrics `locationName:"dataValidationMetrics" type:"structure"`

	// The training metric details.
	TrainingMetricsV2 *TrainingMetricsV2 `locationName:"trainingMetricsV2" type:"structure"`

	// The variable importance metrics details.
	VariableImportanceMetrics *VariableImportanceMetrics `locationName:"variableImportanceMetrics" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingResultV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingResultV2) GoString() string {
	return s.String()
}

// SetAggregatedVariablesImportanceMetrics sets the AggregatedVariablesImportanceMetrics field's value.
func (s *TrainingResultV2) SetAggregatedVariablesImportanceMetrics(v *AggregatedVariablesImportanceMetrics) *TrainingResultV2 {
	s.AggregatedVariablesImportanceMetrics = v
	return s
}

// SetDataValidationMetrics sets the DataValidationMetrics field's value.
func (s *TrainingResultV2) SetDataValidationMetrics(v *DataValidationMetrics) *TrainingResultV2 {
	s.DataValidationMetrics = v
	return s
}

// SetTrainingMetricsV2 sets the TrainingMetricsV2 field's value.
func (s *TrainingResultV2) SetTrainingMetricsV2(v *TrainingMetricsV2) *TrainingResultV2 {
	s.TrainingMetricsV2 = v
	return s
}

// SetVariableImportanceMetrics sets the VariableImportanceMetrics field's value.
func (s *TrainingResultV2) SetVariableImportanceMetrics(v *VariableImportanceMetrics) *TrainingResultV2 {
	s.VariableImportanceMetrics = v
	return s
}

// Range of area under curve (auc) expected from the model. A range greater
// than 0.1 indicates higher model uncertainity. A range is the difference between
// upper and lower bound of auc.
type UncertaintyRange struct {
	_ struct{} `type:"structure"`

	// The lower bound value of the area under curve (auc).
	//
	// LowerBoundValue is a required field
	LowerBoundValue *float64 `locationName:"lowerBoundValue" type:"float" required:"true"`

	// The upper bound value of the area under curve (auc).
	//
	// UpperBoundValue is a required field
	UpperBoundValue *float64 `locationName:"upperBoundValue" type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UncertaintyRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UncertaintyRange) GoString() string {
	return s.String()
}

// SetLowerBoundValue sets the LowerBoundValue field's value.
func (s *UncertaintyRange) SetLowerBoundValue(v float64) *UncertaintyRange {
	s.LowerBoundValue = &v
	return s
}

// SetUpperBoundValue sets the UpperBoundValue field's value.
func (s *UncertaintyRange) SetUpperBoundValue(v float64) *UncertaintyRange {
	s.UpperBoundValue = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which to remove the tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// The resource ARN.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The parent detector ID for the detector version you want to update.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The Amazon SageMaker model endpoints to include in the detector version.
	//
	// ExternalModelEndpoints is a required field
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list" required:"true"`

	// The model versions to include in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rule execution mode to add to the detector.
	//
	// If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules. You can define and edit the rule
	// mode at the detector version level, when it is in draft status.
	//
	// The default behavior is FIRST_MATCHED.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.ExternalModelEndpoints == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalModelEndpoints"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDetectorVersionInput) SetDescription(v string) *UpdateDetectorVersionInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionInput) SetDetectorId(v string) *UpdateDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionInput) SetDetectorVersionId(v string) *UpdateDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *UpdateDetectorVersionInput) SetExternalModelEndpoints(v []*string) *UpdateDetectorVersionInput {
	s.ExternalModelEndpoints = v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *UpdateDetectorVersionInput) SetModelVersions(v []*ModelVersion) *UpdateDetectorVersionInput {
	s.ModelVersions = v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *UpdateDetectorVersionInput) SetRuleExecutionMode(v string) *UpdateDetectorVersionInput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateDetectorVersionInput) SetRules(v []*Rule) *UpdateDetectorVersionInput {
	s.Rules = v
	return s
}

type UpdateDetectorVersionMetadataInput struct {
	_ struct{} `type:"structure"`

	// The description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionMetadataInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDescription(v string) *UpdateDetectorVersionMetadataInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDetectorId(v string) *UpdateDetectorVersionMetadataInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDetectorVersionId(v string) *UpdateDetectorVersionMetadataInput {
	s.DetectorVersionId = &v
	return s
}

type UpdateDetectorVersionMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionMetadataOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The new status.
	//
	// The only supported values are ACTIVE and INACTIVE
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DetectorVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionStatusInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionStatusInput) SetDetectorId(v string) *UpdateDetectorVersionStatusInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionStatusInput) SetDetectorVersionId(v string) *UpdateDetectorVersionStatusInput {
	s.DetectorVersionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDetectorVersionStatusInput) SetStatus(v string) *UpdateDetectorVersionStatusInput {
	s.Status = &v
	return s
}

type UpdateDetectorVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDetectorVersionStatusOutput) GoString() string {
	return s.String()
}

type UpdateEventLabelInput struct {
	_ struct{} `type:"structure"`

	// The new label to assign to the event.
	//
	// AssignedLabel is a required field
	AssignedLabel *string `locationName:"assignedLabel" min:"1" type:"string" required:"true"`

	// The ID of the event associated with the label to update.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" min:"1" type:"string" required:"true"`

	// The event type of the event associated with the label to update.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// The timestamp associated with the label. The timestamp must be specified
	// using ISO 8601 standard in UTC.
	//
	// LabelTimestamp is a required field
	LabelTimestamp *string `locationName:"labelTimestamp" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventLabelInput"}
	if s.AssignedLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignedLabel"))
	}
	if s.AssignedLabel != nil && len(*s.AssignedLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignedLabel", 1))
	}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.LabelTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelTimestamp"))
	}
	if s.LabelTimestamp != nil && len(*s.LabelTimestamp) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("LabelTimestamp", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignedLabel sets the AssignedLabel field's value.
func (s *UpdateEventLabelInput) SetAssignedLabel(v string) *UpdateEventLabelInput {
	s.AssignedLabel = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *UpdateEventLabelInput) SetEventId(v string) *UpdateEventLabelInput {
	s.EventId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *UpdateEventLabelInput) SetEventTypeName(v string) *UpdateEventLabelInput {
	s.EventTypeName = &v
	return s
}

// SetLabelTimestamp sets the LabelTimestamp field's value.
func (s *UpdateEventLabelInput) SetLabelTimestamp(v string) *UpdateEventLabelInput {
	s.LabelTimestamp = &v
	return s
}

type UpdateEventLabelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventLabelOutput) GoString() string {
	return s.String()
}

type UpdateListInput struct {
	_ struct{} `type:"structure"`

	// The new description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// One or more list elements to add or replace. If you are providing the elements,
	// make sure to specify the updateMode to use.
	//
	// If you are deleting all elements from the list, use REPLACE for the updateMode
	// and provide an empty list (0 elements).
	Elements []*string `locationName:"elements" type:"list"`

	// The name of the list to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The update mode (type).
	//
	//    * Use APPEND if you are adding elements to the list.
	//
	//    * Use REPLACE if you replacing existing elements in the list.
	//
	//    * Use REMOVE if you are removing elements from the list.
	UpdateMode *string `locationName:"updateMode" type:"string" enum:"ListUpdateMode"`

	// The variable type you want to assign to the list.
	//
	// You cannot update a variable type of a list that already has a variable type
	// assigned to it. You can assign a variable type to a list only if the list
	// does not already have a variable type.
	VariableType *string `locationName:"variableType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateListInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VariableType != nil && len(*s.VariableType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VariableType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateListInput) SetDescription(v string) *UpdateListInput {
	s.Description = &v
	return s
}

// SetElements sets the Elements field's value.
func (s *UpdateListInput) SetElements(v []*string) *UpdateListInput {
	s.Elements = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateListInput) SetName(v string) *UpdateListInput {
	s.Name = &v
	return s
}

// SetUpdateMode sets the UpdateMode field's value.
func (s *UpdateListInput) SetUpdateMode(v string) *UpdateListInput {
	s.UpdateMode = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *UpdateListInput) SetVariableType(v string) *UpdateListInput {
	s.VariableType = &v
	return s
}

type UpdateListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateListOutput) GoString() string {
	return s.String()
}

type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// The new model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateModelInput) SetDescription(v string) *UpdateModelInput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelInput) SetModelId(v string) *UpdateModelInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelInput) SetModelType(v string) *UpdateModelInput {
	s.ModelType = &v
	return s
}

type UpdateModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelOutput) GoString() string {
	return s.String()
}

type UpdateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The details of the external events data used for training the model version.
	// Required if trainingDataSource is EXTERNAL_EVENTS.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The details of the ingested event used for training the model version. Required
	// if your trainingDataSource is INGESTED_EVENTS.
	IngestedEventsDetail *IngestedEventsDetail `locationName:"ingestedEventsDetail" type:"structure"`

	// The major version number.
	//
	// MajorVersionNumber is a required field
	MajorVersionNumber *string `locationName:"majorVersionNumber" min:"1" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelVersionInput"}
	if s.MajorVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersionNumber"))
	}
	if s.MajorVersionNumber != nil && len(*s.MajorVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersionNumber", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ExternalEventsDetail != nil {
		if err := s.ExternalEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("ExternalEventsDetail", err.(request.ErrInvalidParams))
		}
	}
	if s.IngestedEventsDetail != nil {
		if err := s.IngestedEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("IngestedEventsDetail", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *UpdateModelVersionInput) SetExternalEventsDetail(v *ExternalEventsDetail) *UpdateModelVersionInput {
	s.ExternalEventsDetail = v
	return s
}

// SetIngestedEventsDetail sets the IngestedEventsDetail field's value.
func (s *UpdateModelVersionInput) SetIngestedEventsDetail(v *IngestedEventsDetail) *UpdateModelVersionInput {
	s.IngestedEventsDetail = v
	return s
}

// SetMajorVersionNumber sets the MajorVersionNumber field's value.
func (s *UpdateModelVersionInput) SetMajorVersionNumber(v string) *UpdateModelVersionInput {
	s.MajorVersionNumber = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionInput) SetModelId(v string) *UpdateModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionInput) SetModelType(v string) *UpdateModelVersionInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateModelVersionInput) SetTags(v []*Tag) *UpdateModelVersionInput {
	s.Tags = v
	return s
}

type UpdateModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number of the model version updated.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The status of the updated model version.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionOutput) GoString() string {
	return s.String()
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionOutput) SetModelId(v string) *UpdateModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionOutput) SetModelType(v string) *UpdateModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *UpdateModelVersionOutput) SetModelVersionNumber(v string) *UpdateModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateModelVersionOutput) SetStatus(v string) *UpdateModelVersionOutput {
	s.Status = &v
	return s
}

type UpdateModelVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The model ID of the model version to update.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string" required:"true"`

	// The model version status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ModelVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelVersionStatusInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionStatusInput) SetModelId(v string) *UpdateModelVersionStatusInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionStatusInput) SetModelType(v string) *UpdateModelVersionStatusInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *UpdateModelVersionStatusInput) SetModelVersionNumber(v string) *UpdateModelVersionStatusInput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateModelVersionStatusInput) SetStatus(v string) *UpdateModelVersionStatusInput {
	s.Status = &v
	return s
}

type UpdateModelVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelVersionStatusOutput) GoString() string {
	return s.String()
}

type UpdateRuleMetadataInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleMetadataInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleMetadataInput) SetDescription(v string) *UpdateRuleMetadataInput {
	s.Description = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleMetadataInput) SetRule(v *Rule) *UpdateRuleMetadataInput {
	s.Rule = v
	return s
}

type UpdateRuleMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleMetadataOutput) GoString() string {
	return s.String()
}

type UpdateRuleVersionInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The rule expression.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateRuleVersionInput's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true" sensitive:"true"`

	// The language.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"Language"`

	// The outcomes.
	//
	// Outcomes is a required field
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`

	// The tags to assign to the rule version.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Outcomes == nil {
		invalidParams.Add(request.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outcomes", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleVersionInput) SetDescription(v string) *UpdateRuleVersionInput {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *UpdateRuleVersionInput) SetExpression(v string) *UpdateRuleVersionInput {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *UpdateRuleVersionInput) SetLanguage(v string) *UpdateRuleVersionInput {
	s.Language = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *UpdateRuleVersionInput) SetOutcomes(v []*string) *UpdateRuleVersionInput {
	s.Outcomes = v
	return s
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleVersionInput) SetRule(v *Rule) *UpdateRuleVersionInput {
	s.Rule = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRuleVersionInput) SetTags(v []*Tag) *UpdateRuleVersionInput {
	s.Tags = v
	return s
}

type UpdateRuleVersionOutput struct {
	_ struct{} `type:"structure"`

	// The new rule version that was created.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleVersionOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleVersionOutput) SetRule(v *Rule) *UpdateRuleVersionOutput {
	s.Rule = v
	return s
}

type UpdateVariableInput struct {
	_ struct{} `type:"structure"`

	// The new default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The new description.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The variable type. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVariableInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *UpdateVariableInput) SetDefaultValue(v string) *UpdateVariableInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateVariableInput) SetDescription(v string) *UpdateVariableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVariableInput) SetName(v string) *UpdateVariableInput {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *UpdateVariableInput) SetVariableType(v string) *UpdateVariableInput {
	s.VariableType = &v
	return s
}

type UpdateVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVariableOutput) GoString() string {
	return s.String()
}

// An exception indicating a specified value is not allowed.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The ARN of the variable.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time when the variable was created.
	CreatedTime *string `locationName:"createdTime" min:"11" type:"string"`

	// The data source of the variable.
	DataSource *string `locationName:"dataSource" type:"string" enum:"DataSource"`

	// The data type of the variable. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	DataType *string `locationName:"dataType" type:"string" enum:"DataType"`

	// The default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable.
	Description *string `locationName:"description" type:"string"`

	// The time when variable was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" min:"11" type:"string"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The variable type of the variable.
	//
	// Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 |
	// BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE
	// | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS |
	// FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID
	// | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1
	// | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME
	// | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Variable) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Variable) SetArn(v string) *Variable {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Variable) SetCreatedTime(v string) *Variable {
	s.CreatedTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *Variable) SetDataSource(v string) *Variable {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Variable) SetDataType(v string) *Variable {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *Variable) SetDefaultValue(v string) *Variable {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Variable) SetDescription(v string) *Variable {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Variable) SetLastUpdatedTime(v string) *Variable {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Variable) SetName(v string) *Variable {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *Variable) SetVariableType(v string) *Variable {
	s.VariableType = &v
	return s
}

// A variable in the list of variables for the batch create variable request.
type VariableEntry struct {
	_ struct{} `type:"structure"`

	// The data source of the variable.
	DataSource *string `locationName:"dataSource" type:"string"`

	// The data type of the variable.
	DataType *string `locationName:"dataType" type:"string"`

	// The default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The type of the variable. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	//
	// Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 |
	// BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE
	// | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS |
	// FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID
	// | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1
	// | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME
	// | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableEntry) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *VariableEntry) SetDataSource(v string) *VariableEntry {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *VariableEntry) SetDataType(v string) *VariableEntry {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *VariableEntry) SetDefaultValue(v string) *VariableEntry {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *VariableEntry) SetDescription(v string) *VariableEntry {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *VariableEntry) SetName(v string) *VariableEntry {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *VariableEntry) SetVariableType(v string) *VariableEntry {
	s.VariableType = &v
	return s
}

// The details of the event variable's impact on the prediction score.
type VariableImpactExplanation struct {
	_ struct{} `type:"structure"`

	// The event variable name.
	EventVariableName *string `locationName:"eventVariableName" type:"string"`

	// The raw, uninterpreted value represented as log-odds of the fraud. These
	// values are usually between -10 to +10, but range from - infinity to + infinity.
	//
	//    * A positive value indicates that the variable drove the risk score up.
	//
	//    * A negative value indicates that the variable drove the risk score down.
	LogOddsImpact *float64 `locationName:"logOddsImpact" type:"float"`

	// The event variable's relative impact in terms of magnitude on the prediction
	// scores. The relative impact values consist of a numerical rating (0-5, 5
	// being the highest) and direction (increased/decreased) impact of the fraud
	// risk.
	RelativeImpact *string `locationName:"relativeImpact" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableImpactExplanation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableImpactExplanation) GoString() string {
	return s.String()
}

// SetEventVariableName sets the EventVariableName field's value.
func (s *VariableImpactExplanation) SetEventVariableName(v string) *VariableImpactExplanation {
	s.EventVariableName = &v
	return s
}

// SetLogOddsImpact sets the LogOddsImpact field's value.
func (s *VariableImpactExplanation) SetLogOddsImpact(v float64) *VariableImpactExplanation {
	s.LogOddsImpact = &v
	return s
}

// SetRelativeImpact sets the RelativeImpact field's value.
func (s *VariableImpactExplanation) SetRelativeImpact(v string) *VariableImpactExplanation {
	s.RelativeImpact = &v
	return s
}

// The variable importance metrics details.
type VariableImportanceMetrics struct {
	_ struct{} `type:"structure"`

	// List of variable metrics.
	LogOddsMetrics []*LogOddsMetric `locationName:"logOddsMetrics" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableImportanceMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableImportanceMetrics) GoString() string {
	return s.String()
}

// SetLogOddsMetrics sets the LogOddsMetrics field's value.
func (s *VariableImportanceMetrics) SetLogOddsMetrics(v []*LogOddsMetric) *VariableImportanceMetrics {
	s.LogOddsMetrics = v
	return s
}

const (
	// AsyncJobStatusInProgressInitializing is a AsyncJobStatus enum value
	AsyncJobStatusInProgressInitializing = "IN_PROGRESS_INITIALIZING"

	// AsyncJobStatusInProgress is a AsyncJobStatus enum value
	AsyncJobStatusInProgress = "IN_PROGRESS"

	// AsyncJobStatusCancelInProgress is a AsyncJobStatus enum value
	AsyncJobStatusCancelInProgress = "CANCEL_IN_PROGRESS"

	// AsyncJobStatusCanceled is a AsyncJobStatus enum value
	AsyncJobStatusCanceled = "CANCELED"

	// AsyncJobStatusComplete is a AsyncJobStatus enum value
	AsyncJobStatusComplete = "COMPLETE"

	// AsyncJobStatusFailed is a AsyncJobStatus enum value
	AsyncJobStatusFailed = "FAILED"
)

// AsyncJobStatus_Values returns all elements of the AsyncJobStatus enum
func AsyncJobStatus_Values() []string {
	return []string{
		AsyncJobStatusInProgressInitializing,
		AsyncJobStatusInProgress,
		AsyncJobStatusCancelInProgress,
		AsyncJobStatusCanceled,
		AsyncJobStatusComplete,
		AsyncJobStatusFailed,
	}
}

const (
	// DataSourceEvent is a DataSource enum value
	DataSourceEvent = "EVENT"

	// DataSourceModelScore is a DataSource enum value
	DataSourceModelScore = "MODEL_SCORE"

	// DataSourceExternalModelScore is a DataSource enum value
	DataSourceExternalModelScore = "EXTERNAL_MODEL_SCORE"
)

// DataSource_Values returns all elements of the DataSource enum
func DataSource_Values() []string {
	return []string{
		DataSourceEvent,
		DataSourceModelScore,
		DataSourceExternalModelScore,
	}
}

const (
	// DataTypeString is a DataType enum value
	DataTypeString = "STRING"

	// DataTypeInteger is a DataType enum value
	DataTypeInteger = "INTEGER"

	// DataTypeFloat is a DataType enum value
	DataTypeFloat = "FLOAT"

	// DataTypeBoolean is a DataType enum value
	DataTypeBoolean = "BOOLEAN"

	// DataTypeDatetime is a DataType enum value
	DataTypeDatetime = "DATETIME"
)

// DataType_Values returns all elements of the DataType enum
func DataType_Values() []string {
	return []string{
		DataTypeString,
		DataTypeInteger,
		DataTypeFloat,
		DataTypeBoolean,
		DataTypeDatetime,
	}
}

const (
	// DetectorVersionStatusDraft is a DetectorVersionStatus enum value
	DetectorVersionStatusDraft = "DRAFT"

	// DetectorVersionStatusActive is a DetectorVersionStatus enum value
	DetectorVersionStatusActive = "ACTIVE"

	// DetectorVersionStatusInactive is a DetectorVersionStatus enum value
	DetectorVersionStatusInactive = "INACTIVE"
)

// DetectorVersionStatus_Values returns all elements of the DetectorVersionStatus enum
func DetectorVersionStatus_Values() []string {
	return []string{
		DetectorVersionStatusDraft,
		DetectorVersionStatusActive,
		DetectorVersionStatusInactive,
	}
}

const (
	// EventIngestionEnabled is a EventIngestion enum value
	EventIngestionEnabled = "ENABLED"

	// EventIngestionDisabled is a EventIngestion enum value
	EventIngestionDisabled = "DISABLED"
)

// EventIngestion_Values returns all elements of the EventIngestion enum
func EventIngestion_Values() []string {
	return []string{
		EventIngestionEnabled,
		EventIngestionDisabled,
	}
}

const (
	// LanguageDetectorpl is a Language enum value
	LanguageDetectorpl = "DETECTORPL"
)

// Language_Values returns all elements of the Language enum
func Language_Values() []string {
	return []string{
		LanguageDetectorpl,
	}
}

const (
	// ListUpdateModeReplace is a ListUpdateMode enum value
	ListUpdateModeReplace = "REPLACE"

	// ListUpdateModeAppend is a ListUpdateMode enum value
	ListUpdateModeAppend = "APPEND"

	// ListUpdateModeRemove is a ListUpdateMode enum value
	ListUpdateModeRemove = "REMOVE"
)

// ListUpdateMode_Values returns all elements of the ListUpdateMode enum
func ListUpdateMode_Values() []string {
	return []string{
		ListUpdateModeReplace,
		ListUpdateModeAppend,
		ListUpdateModeRemove,
	}
}

const (
	// ModelEndpointStatusAssociated is a ModelEndpointStatus enum value
	ModelEndpointStatusAssociated = "ASSOCIATED"

	// ModelEndpointStatusDissociated is a ModelEndpointStatus enum value
	ModelEndpointStatusDissociated = "DISSOCIATED"
)

// ModelEndpointStatus_Values returns all elements of the ModelEndpointStatus enum
func ModelEndpointStatus_Values() []string {
	return []string{
		ModelEndpointStatusAssociated,
		ModelEndpointStatusDissociated,
	}
}

const (
	// ModelInputDataFormatTextCsv is a ModelInputDataFormat enum value
	ModelInputDataFormatTextCsv = "TEXT_CSV"

	// ModelInputDataFormatApplicationJson is a ModelInputDataFormat enum value
	ModelInputDataFormatApplicationJson = "APPLICATION_JSON"
)

// ModelInputDataFormat_Values returns all elements of the ModelInputDataFormat enum
func ModelInputDataFormat_Values() []string {
	return []string{
		ModelInputDataFormatTextCsv,
		ModelInputDataFormatApplicationJson,
	}
}

const (
	// ModelOutputDataFormatTextCsv is a ModelOutputDataFormat enum value
	ModelOutputDataFormatTextCsv = "TEXT_CSV"

	// ModelOutputDataFormatApplicationJsonlines is a ModelOutputDataFormat enum value
	ModelOutputDataFormatApplicationJsonlines = "APPLICATION_JSONLINES"
)

// ModelOutputDataFormat_Values returns all elements of the ModelOutputDataFormat enum
func ModelOutputDataFormat_Values() []string {
	return []string{
		ModelOutputDataFormatTextCsv,
		ModelOutputDataFormatApplicationJsonlines,
	}
}

const (
	// ModelSourceSagemaker is a ModelSource enum value
	ModelSourceSagemaker = "SAGEMAKER"
)

// ModelSource_Values returns all elements of the ModelSource enum
func ModelSource_Values() []string {
	return []string{
		ModelSourceSagemaker,
	}
}

const (
	// ModelTypeEnumOnlineFraudInsights is a ModelTypeEnum enum value
	ModelTypeEnumOnlineFraudInsights = "ONLINE_FRAUD_INSIGHTS"

	// ModelTypeEnumTransactionFraudInsights is a ModelTypeEnum enum value
	ModelTypeEnumTransactionFraudInsights = "TRANSACTION_FRAUD_INSIGHTS"

	// ModelTypeEnumAccountTakeoverInsights is a ModelTypeEnum enum value
	ModelTypeEnumAccountTakeoverInsights = "ACCOUNT_TAKEOVER_INSIGHTS"
)

// ModelTypeEnum_Values returns all elements of the ModelTypeEnum enum
func ModelTypeEnum_Values() []string {
	return []string{
		ModelTypeEnumOnlineFraudInsights,
		ModelTypeEnumTransactionFraudInsights,
		ModelTypeEnumAccountTakeoverInsights,
	}
}

const (
	// ModelVersionStatusActive is a ModelVersionStatus enum value
	ModelVersionStatusActive = "ACTIVE"

	// ModelVersionStatusInactive is a ModelVersionStatus enum value
	ModelVersionStatusInactive = "INACTIVE"

	// ModelVersionStatusTrainingCancelled is a ModelVersionStatus enum value
	ModelVersionStatusTrainingCancelled = "TRAINING_CANCELLED"
)

// ModelVersionStatus_Values returns all elements of the ModelVersionStatus enum
func ModelVersionStatus_Values() []string {
	return []string{
		ModelVersionStatusActive,
		ModelVersionStatusInactive,
		ModelVersionStatusTrainingCancelled,
	}
}

const (
	// RuleExecutionModeAllMatched is a RuleExecutionMode enum value
	RuleExecutionModeAllMatched = "ALL_MATCHED"

	// RuleExecutionModeFirstMatched is a RuleExecutionMode enum value
	RuleExecutionModeFirstMatched = "FIRST_MATCHED"
)

// RuleExecutionMode_Values returns all elements of the RuleExecutionMode enum
func RuleExecutionMode_Values() []string {
	return []string{
		RuleExecutionModeAllMatched,
		RuleExecutionModeFirstMatched,
	}
}

const (
	// TrainingDataSourceEnumExternalEvents is a TrainingDataSourceEnum enum value
	TrainingDataSourceEnumExternalEvents = "EXTERNAL_EVENTS"

	// TrainingDataSourceEnumIngestedEvents is a TrainingDataSourceEnum enum value
	TrainingDataSourceEnumIngestedEvents = "INGESTED_EVENTS"
)

// TrainingDataSourceEnum_Values returns all elements of the TrainingDataSourceEnum enum
func TrainingDataSourceEnum_Values() []string {
	return []string{
		TrainingDataSourceEnumExternalEvents,
		TrainingDataSourceEnumIngestedEvents,
	}
}

const (
	// UnlabeledEventsTreatmentIgnore is a UnlabeledEventsTreatment enum value
	UnlabeledEventsTreatmentIgnore = "IGNORE"

	// UnlabeledEventsTreatmentFraud is a UnlabeledEventsTreatment enum value
	UnlabeledEventsTreatmentFraud = "FRAUD"

	// UnlabeledEventsTreatmentLegit is a UnlabeledEventsTreatment enum value
	UnlabeledEventsTreatmentLegit = "LEGIT"

	// UnlabeledEventsTreatmentAuto is a UnlabeledEventsTreatment enum value
	UnlabeledEventsTreatmentAuto = "AUTO"
)

// UnlabeledEventsTreatment_Values returns all elements of the UnlabeledEventsTreatment enum
func UnlabeledEventsTreatment_Values() []string {
	return []string{
		UnlabeledEventsTreatmentIgnore,
		UnlabeledEventsTreatmentFraud,
		UnlabeledEventsTreatmentLegit,
		UnlabeledEventsTreatmentAuto,
	}
}
