// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns all of the properties of a subscription.
func (c *Client) GetSubscriptionAttributes(ctx context.Context, params *GetSubscriptionAttributesInput, optFns ...func(*Options)) (*GetSubscriptionAttributesOutput, error) {
	if params == nil {
		params = &GetSubscriptionAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSubscriptionAttributes", params, optFns, c.addOperationGetSubscriptionAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSubscriptionAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input for GetSubscriptionAttributes.
type GetSubscriptionAttributesInput struct {

	// The ARN of the subscription whose properties you want to get.
	//
	// This member is required.
	SubscriptionArn *string

	noSmithyDocumentSerde
}

// Response for GetSubscriptionAttributes action.
type GetSubscriptionAttributesOutput struct {

	// A map of the subscription's attributes. Attributes in this map include the
	// following:
	//
	//   - ConfirmationWasAuthenticated – true if the subscription confirmation request
	//   was authenticated.
	//
	//   - DeliveryPolicy – The JSON serialization of the subscription's delivery
	//   policy.
	//
	//   - EffectiveDeliveryPolicy – The JSON serialization of the effective delivery
	//   policy that takes into account the topic delivery policy and account system
	//   defaults.
	//
	//   - FilterPolicy – The filter policy JSON that is assigned to the subscription.
	//   For more information, see [Amazon SNS Message Filtering]in the Amazon SNS Developer Guide.
	//
	//   - FilterPolicyScope – This attribute lets you choose the filtering scope by
	//   using one of the following string value types:
	//
	//   - MessageAttributes (default) – The filter is applied on the message
	//   attributes.
	//
	//   - MessageBody – The filter is applied on the message body.
	//
	//   - Owner – The Amazon Web Services account ID of the subscription's owner.
	//
	//   - PendingConfirmation – true if the subscription hasn't been confirmed. To
	//   confirm a pending subscription, call the ConfirmSubscription action with a
	//   confirmation token.
	//
	//   - RawMessageDelivery – true if raw message delivery is enabled for the
	//   subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S
	//   and Amazon SQS endpoints.
	//
	//   - RedrivePolicy – When specified, sends undeliverable messages to the
	//   specified Amazon SQS dead-letter queue. Messages that can't be delivered due to
	//   client errors (for example, when the subscribed endpoint is unreachable) or
	//   server errors (for example, when the service that powers the subscribed endpoint
	//   becomes unavailable) are held in the dead-letter queue for further analysis or
	//   reprocessing.
	//
	//   - SubscriptionArn – The subscription's ARN.
	//
	//   - TopicArn – The topic ARN that the subscription is associated with.
	//
	// The following attribute applies only to Amazon Kinesis Data Firehose delivery
	// stream subscriptions:
	//
	//   - SubscriptionRoleArn – The ARN of the IAM role that has the following:
	//
	//   - Permission to write to the Kinesis Data Firehose delivery stream
	//
	//   - Amazon SNS listed as a trusted entity
	//
	// Specifying a valid ARN for this attribute is required for Kinesis Data Firehose
	//   delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams]in the Amazon SNS
	//   Developer Guide.
	//
	// [Fanout to Kinesis Data Firehose delivery streams]: https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html
	// [Amazon SNS Message Filtering]: https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html
	Attributes map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSubscriptionAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetSubscriptionAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetSubscriptionAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSubscriptionAttributes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetSubscriptionAttributesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSubscriptionAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSubscriptionAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSubscriptionAttributes",
	}
}
