// Code generated by smithy-go-codegen DO NOT EDIT.

package route53recoverycluster

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53recoverycluster/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Set the state of the routing control to reroute traffic. You can set the value
// to ON or OFF. When the state is ON, traffic flows to a cell. When the state is
// OFF, traffic does not flow.
//
// With Route 53 ARC, you can add safety rules for routing controls, which are
// safeguards for routing control state updates that help prevent unexpected
// outcomes, like fail open traffic routing. However, there are scenarios when you
// might want to bypass the routing control safeguards that are enforced with
// safety rules that you've configured. For example, you might want to fail over
// quickly for disaster recovery, and one or more safety rules might be
// unexpectedly preventing you from updating a routing control state to reroute
// traffic. In a "break glass" scenario like this, you can override one or more
// safety rules to change a routing control state and fail over your application.
//
// The SafetyRulesToOverride property enables you override one or more safety
// rules and update routing control states. For more information, see [Override safety rules to reroute traffic]in the
// Amazon Route 53 Application Recovery Controller Developer Guide.
//
// You must specify Regional endpoints when you work with API cluster operations
// to get or update routing control states in Route 53 ARC.
//
// To see a code example for getting a routing control state, including accessing
// Regional cluster endpoints in sequence, see [API examples]in the Amazon Route 53 Application
// Recovery Controller Developer Guide.
//
// [Viewing and updating routing control states]
//
// [Working with routing controls overall]
//
// [API examples]: https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html
// [Viewing and updating routing control states]: https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html
// [Override safety rules to reroute traffic]: https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html
// [Working with routing controls overall]: https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html
func (c *Client) UpdateRoutingControlState(ctx context.Context, params *UpdateRoutingControlStateInput, optFns ...func(*Options)) (*UpdateRoutingControlStateOutput, error) {
	if params == nil {
		params = &UpdateRoutingControlStateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRoutingControlState", params, optFns, c.addOperationUpdateRoutingControlStateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRoutingControlStateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRoutingControlStateInput struct {

	// The Amazon Resource Name (ARN) for the routing control that you want to update
	// the state for.
	//
	// This member is required.
	RoutingControlArn *string

	// The state of the routing control. You can set the value to ON or OFF.
	//
	// This member is required.
	RoutingControlState types.RoutingControlState

	// The Amazon Resource Names (ARNs) for the safety rules that you want to override
	// when you're updating the state of a routing control. You can override one safety
	// rule or multiple safety rules by including one or more ARNs, separated by
	// commas.
	//
	// For more information, see [Override safety rules to reroute traffic] in the Amazon Route 53 Application Recovery
	// Controller Developer Guide.
	//
	// [Override safety rules to reroute traffic]: https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html
	SafetyRulesToOverride []string

	noSmithyDocumentSerde
}

type UpdateRoutingControlStateOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRoutingControlStateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateRoutingControlState{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateRoutingControlState{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRoutingControlState"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateRoutingControlStateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRoutingControlState(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRoutingControlState(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRoutingControlState",
	}
}
