// Code generated by smithy-go-codegen DO NOT EDIT.

package eks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an access entry.
//
// An access entry allows an IAM principal to access your cluster. Access entries
// can replace the need to maintain entries in the aws-auth ConfigMap for
// authentication. You have the following options for authorizing an IAM principal
// to access Kubernetes objects on your cluster: Kubernetes role-based access
// control (RBAC), Amazon EKS, or both. Kubernetes RBAC authorization requires you
// to create and manage Kubernetes Role , ClusterRole , RoleBinding , and
// ClusterRoleBinding objects, in addition to managing access entries. If you use
// Amazon EKS authorization exclusively, you don't need to create and manage
// Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects.
//
// For more information about access entries, see [Access entries] in the Amazon EKS User Guide.
//
// [Access entries]: https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
func (c *Client) CreateAccessEntry(ctx context.Context, params *CreateAccessEntryInput, optFns ...func(*Options)) (*CreateAccessEntryOutput, error) {
	if params == nil {
		params = &CreateAccessEntryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAccessEntry", params, optFns, c.addOperationCreateAccessEntryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAccessEntryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAccessEntryInput struct {

	// The name of your cluster.
	//
	// This member is required.
	ClusterName *string

	// The ARN of the IAM principal for the AccessEntry . You can specify one ARN for
	// each access entry. You can't specify the same ARN in more than one access entry.
	// This value can't be changed after access entry creation.
	//
	// The valid principals differ depending on the type of the access entry in the
	// type field. The only valid ARN is IAM roles for the types of access entries for
	// nodes: . You can use every IAM principal type for STANDARD access entries. You
	// can't use the STS session principal type with access entries because this is a
	// temporary principal for each session and not a permanent identity that can be
	// assigned permissions.
	//
	// [IAM best practices]recommend using IAM roles with temporary credentials, rather than IAM users
	// with long-term credentials.
	//
	// [IAM best practices]: https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#bp-users-federation-idp
	//
	// This member is required.
	PrincipalArn *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string

	// The value for name that you've specified for kind: Group as a subject in a
	// Kubernetes RoleBinding or ClusterRoleBinding object. Amazon EKS doesn't confirm
	// that the value for name exists in any bindings on your cluster. You can specify
	// one or more names.
	//
	// Kubernetes authorizes the principalArn of the access entry to access any
	// cluster objects that you've specified in a Kubernetes Role or ClusterRole
	// object that is also specified in a binding's roleRef . For more information
	// about creating Kubernetes RoleBinding , ClusterRoleBinding , Role , or
	// ClusterRole objects, see [Using RBAC Authorization in the Kubernetes documentation].
	//
	// If you want Amazon EKS to authorize the principalArn (instead of, or in
	// addition to Kubernetes authorizing the principalArn ), you can associate one or
	// more access policies to the access entry using AssociateAccessPolicy . If you
	// associate any access policies, the principalARN has all permissions assigned in
	// the associated access policies and all permissions in any Kubernetes Role or
	// ClusterRole objects that the group names are bound to.
	//
	// [Using RBAC Authorization in the Kubernetes documentation]: https://kubernetes.io/docs/reference/access-authn-authz/rbac/
	KubernetesGroups []string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The type of the new access entry. Valid values are Standard , FARGATE_LINUX ,
	// EC2_LINUX , and EC2_WINDOWS .
	//
	// If the principalArn is for an IAM role that's used for self-managed Amazon EC2
	// nodes, specify EC2_LINUX or EC2_WINDOWS . Amazon EKS grants the necessary
	// permissions to the node for you. If the principalArn is for any other purpose,
	// specify STANDARD . If you don't specify a value, Amazon EKS sets the value to
	// STANDARD . It's unnecessary to create access entries for IAM roles used with
	// Fargate profiles or managed Amazon EC2 nodes, because Amazon EKS creates entries
	// in the aws-auth ConfigMap for the roles. You can't change this value once
	// you've created the access entry.
	//
	// If you set the value to EC2_LINUX or EC2_WINDOWS , you can't specify values for
	// kubernetesGroups , or associate an AccessPolicy to the access entry.
	Type *string

	// The username to authenticate to Kubernetes with. We recommend not specifying a
	// username and letting Amazon EKS specify it for you. For more information about
	// the value Amazon EKS specifies for you, or constraints before specifying your
	// own username, see [Creating access entries]in the Amazon EKS User Guide.
	//
	// [Creating access entries]: https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries
	Username *string

	noSmithyDocumentSerde
}

type CreateAccessEntryOutput struct {

	// An access entry allows an IAM principal (user or role) to access your cluster.
	// Access entries can replace the need to maintain the aws-auth ConfigMap for
	// authentication. For more information about access entries, see [Access entries]in the Amazon
	// EKS User Guide.
	//
	// [Access entries]: https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
	AccessEntry *types.AccessEntry

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAccessEntryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAccessEntry{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAccessEntry{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAccessEntry"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAccessEntryMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAccessEntryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAccessEntry(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAccessEntry struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAccessEntry) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAccessEntry) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAccessEntryInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAccessEntryInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAccessEntryMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAccessEntry{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAccessEntry(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAccessEntry",
	}
}
