// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents a CloudWatch alarm associated with a scaling policy.
type Alarm struct {

	// The Amazon Resource Name (ARN) of the alarm.
	//
	// This member is required.
	AlarmARN *string

	// The name of the alarm.
	//
	// This member is required.
	AlarmName *string

	noSmithyDocumentSerde
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Application Auto Scaling.
//
// For information about the available metrics for a service, see [Amazon Web Services services that publish CloudWatch metrics] in the Amazon
// CloudWatch User Guide.
//
// To create your customized metric specification:
//
//   - Add values for each required parameter from CloudWatch. You can use an
//     existing metric, or a new metric that you create. To use your own metric, you
//     must first publish the metric to CloudWatch. For more information, see [Publish custom metrics]in the
//     Amazon CloudWatch User Guide.
//
//   - Choose a metric that changes proportionally with capacity. The value of the
//     metric should increase or decrease in inverse proportion to the number of
//     capacity units. That is, the value of the metric should decrease when capacity
//     increases, and increase when capacity decreases.
//
// For more information about the CloudWatch terminology below, see [Amazon CloudWatch concepts] in the Amazon
// CloudWatch User Guide.
//
// [Amazon Web Services services that publish CloudWatch metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html
// [Amazon CloudWatch concepts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html
// [Publish custom metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html
type CustomizedMetricSpecification struct {

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify the
	// same dimensions in your scaling policy.
	Dimensions []MetricDimension

	// The name of the metric. To get the exact metric name, namespace, and
	// dimensions, inspect the [Metric]object that's returned by a call to [ListMetrics].
	//
	// [ListMetrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html
	// [Metric]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html
	MetricName *string

	// The metrics to include in the target tracking scaling policy, as a metric data
	// query. This can include both raw metric and metric math expressions.
	Metrics []TargetTrackingMetricDataQuery

	// The namespace of the metric.
	Namespace *string

	// The statistic of the metric.
	Statistic MetricStatistic

	// The unit of the metric. For a complete list of the units that CloudWatch
	// supports, see the [MetricDatum]data type in the Amazon CloudWatch API Reference.
	//
	// [MetricDatum]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html
	Unit *string

	noSmithyDocumentSerde
}

// Describes the dimension names and values associated with a metric.
type MetricDimension struct {

	// The name of the dimension.
	//
	// This member is required.
	Name *string

	// The value of the dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes the reason for an activity that isn't scaled (not scaled activity),
// in machine-readable format. For help interpreting the not scaled reason details,
// see [Scaling activities for Application Auto Scaling].
//
// [Scaling activities for Application Auto Scaling]: https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html
type NotScaledReason struct {

	// A code that represents the reason for not scaling.
	//
	// Valid values:
	//
	//   - AutoScalingAnticipatedFlapping
	//
	//   - TargetServicePutResourceAsUnscalable
	//
	//   - AlreadyAtMaxCapacity
	//
	//   - AlreadyAtMinCapacity
	//
	//   - AlreadyAtDesiredCapacity
	//
	// This member is required.
	Code *string

	// The current capacity.
	CurrentCapacity *int32

	// The maximum capacity.
	MaxCapacity *int32

	// The minimum capacity.
	MinCapacity *int32

	noSmithyDocumentSerde
}

// Represents a predefined metric for a target tracking scaling policy to use with
// Application Auto Scaling.
//
// Only the Amazon Web Services that you're using send metrics to Amazon
// CloudWatch. To determine whether a desired metric already exists by looking up
// its namespace and dimension using the CloudWatch metrics dashboard in the
// console, follow the procedure in [Monitor your resources using CloudWatch]in the Application Auto Scaling User Guide.
//
// [Monitor your resources using CloudWatch]: https://docs.aws.amazon.com/autoscaling/application/userguide/monitoring-cloudwatch.html
type PredefinedMetricSpecification struct {

	// The metric type. The ALBRequestCountPerTarget metric type applies only to Spot
	// Fleets and ECS services.
	//
	// This member is required.
	PredefinedMetricType MetricType

	// Identifies the resource associated with the metric type. You can't specify a
	// resource label unless the metric type is ALBRequestCountPerTarget and there is
	// a target group attached to the Spot Fleet or ECS service.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single value,
	// separated by a forward slash (/). The format of the resource label is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff .
	//
	// Where:
	//
	//   - app// is the final portion of the load balancer ARN
	//
	//   - targetgroup// is the final portion of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers] API operation. To
	// find the ARN for the target group, use the [DescribeTargetGroups]API operation.
	//
	// [DescribeTargetGroups]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Represents a scalable target.
type ScalableTarget struct {

	// The Unix timestamp for when the scalable target was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The maximum value to scale to in response to a scale-out activity.
	//
	// This member is required.
	MaxCapacity *int32

	// The minimum value to scale to in response to a scale-in activity.
	//
	// This member is required.
	MinCapacity *int32

	// The identifier of the resource associated with the scalable target. This string
	// consists of the resource type and unique identifier.
	//
	//   - ECS service - The resource type is service and the unique identifier is the
	//   cluster name and service name. Example: service/default/sample-webapp .
	//
	//   - Spot Fleet - The resource type is spot-fleet-request and the unique
	//   identifier is the Spot Fleet request ID. Example:
	//   spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE .
	//
	//   - EMR cluster - The resource type is instancegroup and the unique identifier
	//   is the cluster ID and instance group ID. Example:
	//   instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0 .
	//
	//   - AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//   is the fleet name. Example: fleet/sample-fleet .
	//
	//   - DynamoDB table - The resource type is table and the unique identifier is the
	//   table name. Example: table/my-table .
	//
	//   - DynamoDB global secondary index - The resource type is index and the unique
	//   identifier is the index name. Example: table/my-table/index/my-table-index .
	//
	//   - Aurora DB cluster - The resource type is cluster and the unique identifier
	//   is the cluster name. Example: cluster:my-db-cluster .
	//
	//   - SageMaker endpoint variant - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - Custom resources are not supported with a resource type. This parameter
	//   must specify the OutputValue from the CloudFormation template stack used to
	//   access the resources. The unique identifier is defined by the service provider.
	//   More information is available in our [GitHub repository].
	//
	//   - Amazon Comprehend document classification endpoint - The resource type and
	//   unique identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE
	//   .
	//
	//   - Amazon Comprehend entity recognizer endpoint - The resource type and unique
	//   identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE .
	//
	//   - Lambda provisioned concurrency - The resource type is function and the
	//   unique identifier is the function name with a function version or alias name
	//   suffix that is not $LATEST . Example: function:my-function:prod or
	//   function:my-function:1 .
	//
	//   - Amazon Keyspaces table - The resource type is table and the unique
	//   identifier is the table name. Example: keyspace/mykeyspace/table/mytable .
	//
	//   - Amazon MSK cluster - The resource type and unique identifier are specified
	//   using the cluster ARN. Example:
	//   arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5
	//   .
	//
	//   - Amazon ElastiCache replication group - The resource type is
	//   replication-group and the unique identifier is the replication group name.
	//   Example: replication-group/mycluster .
	//
	//   - Neptune cluster - The resource type is cluster and the unique identifier is
	//   the cluster name. Example: cluster:mycluster .
	//
	//   - SageMaker Serverless endpoint - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - SageMaker inference component - The resource type is inference-component and
	//   the unique identifier is the resource ID. Example:
	//   inference-component/my-inference-component .
	//
	// [GitHub repository]: https://github.com/aws/aws-auto-scaling-custom-resource
	//
	// This member is required.
	ResourceId *string

	// The ARN of an IAM role that allows Application Auto Scaling to modify the
	// scalable target on your behalf.
	//
	// This member is required.
	RoleARN *string

	// The scalable dimension associated with the scalable target. This string
	// consists of the service namespace, resource type, and scaling property.
	//
	//   - ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//   - elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
	//   Instance Group.
	//
	//   - ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
	//
	//   - appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0
	//   fleet.
	//
	//   - dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB global secondary index.
	//
	//   - dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB global secondary index.
	//
	//   - rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB
	//   cluster. Available for Aurora MySQL-compatible edition and Aurora
	//   PostgreSQL-compatible edition.
	//
	//   - sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a
	//   SageMaker model endpoint variant.
	//
	//   - custom-resource:ResourceType:Property - The scalable dimension for a custom
	//   resource provided by your own application or service.
	//
	//   - comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number
	//   of inference units for an Amazon Comprehend document classification endpoint.
	//
	//   - comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of
	//   inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//   - lambda:function:ProvisionedConcurrency - The provisioned concurrency for a
	//   Lambda function.
	//
	//   - cassandra:table:ReadCapacityUnits - The provisioned read capacity for an
	//   Amazon Keyspaces table.
	//
	//   - cassandra:table:WriteCapacityUnits - The provisioned write capacity for an
	//   Amazon Keyspaces table.
	//
	//   - kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for
	//   brokers in an Amazon MSK cluster.
	//
	//   - elasticache:replication-group:NodeGroups - The number of node groups for an
	//   Amazon ElastiCache replication group.
	//
	//   - elasticache:replication-group:Replicas - The number of replicas per node
	//   group for an Amazon ElastiCache replication group.
	//
	//   - neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon
	//   Neptune DB cluster.
	//
	//   - sagemaker:variant:DesiredProvisionedConcurrency - The provisioned
	//   concurrency for a SageMaker Serverless endpoint.
	//
	//   - sagemaker:inference-component:DesiredCopyCount - The number of copies across
	//   an endpoint for a SageMaker inference component.
	//
	// This member is required.
	ScalableDimension ScalableDimension

	// The namespace of the Amazon Web Services service that provides the resource, or
	// a custom-resource .
	//
	// This member is required.
	ServiceNamespace ServiceNamespace

	// The ARN of the scalable target.
	ScalableTargetARN *string

	// Specifies whether the scaling activities for a scalable target are in a
	// suspended state.
	SuspendedState *SuspendedState

	noSmithyDocumentSerde
}

// Represents the minimum and maximum capacity for a scheduled action.
type ScalableTargetAction struct {

	// The maximum capacity.
	//
	// Although you can specify a large maximum capacity, note that service quotas may
	// impose lower limits. Each service has its own default quotas for the maximum
	// capacity of the resource. If you want to specify a higher limit, you can request
	// an increase. For more information, consult the documentation for that service.
	// For information about the default quotas for each service, see [Service endpoints and quotas]in the Amazon
	// Web Services General Reference.
	//
	// [Service endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html
	MaxCapacity *int32

	// The minimum capacity.
	//
	// When the scheduled action runs, the resource will have at least this much
	// capacity, but it might have more depending on other settings, such as the target
	// utilization level of a target tracking scaling policy.
	MinCapacity *int32

	noSmithyDocumentSerde
}

// Represents a scaling activity.
type ScalingActivity struct {

	// The unique identifier of the scaling activity.
	//
	// This member is required.
	ActivityId *string

	// A simple description of what caused the scaling activity to happen.
	//
	// This member is required.
	Cause *string

	// A simple description of what action the scaling activity intends to accomplish.
	//
	// This member is required.
	Description *string

	// The identifier of the resource associated with the scaling activity. This
	// string consists of the resource type and unique identifier.
	//
	//   - ECS service - The resource type is service and the unique identifier is the
	//   cluster name and service name. Example: service/default/sample-webapp .
	//
	//   - Spot Fleet - The resource type is spot-fleet-request and the unique
	//   identifier is the Spot Fleet request ID. Example:
	//   spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE .
	//
	//   - EMR cluster - The resource type is instancegroup and the unique identifier
	//   is the cluster ID and instance group ID. Example:
	//   instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0 .
	//
	//   - AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//   is the fleet name. Example: fleet/sample-fleet .
	//
	//   - DynamoDB table - The resource type is table and the unique identifier is the
	//   table name. Example: table/my-table .
	//
	//   - DynamoDB global secondary index - The resource type is index and the unique
	//   identifier is the index name. Example: table/my-table/index/my-table-index .
	//
	//   - Aurora DB cluster - The resource type is cluster and the unique identifier
	//   is the cluster name. Example: cluster:my-db-cluster .
	//
	//   - SageMaker endpoint variant - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - Custom resources are not supported with a resource type. This parameter
	//   must specify the OutputValue from the CloudFormation template stack used to
	//   access the resources. The unique identifier is defined by the service provider.
	//   More information is available in our [GitHub repository].
	//
	//   - Amazon Comprehend document classification endpoint - The resource type and
	//   unique identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE
	//   .
	//
	//   - Amazon Comprehend entity recognizer endpoint - The resource type and unique
	//   identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE .
	//
	//   - Lambda provisioned concurrency - The resource type is function and the
	//   unique identifier is the function name with a function version or alias name
	//   suffix that is not $LATEST . Example: function:my-function:prod or
	//   function:my-function:1 .
	//
	//   - Amazon Keyspaces table - The resource type is table and the unique
	//   identifier is the table name. Example: keyspace/mykeyspace/table/mytable .
	//
	//   - Amazon MSK cluster - The resource type and unique identifier are specified
	//   using the cluster ARN. Example:
	//   arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5
	//   .
	//
	//   - Amazon ElastiCache replication group - The resource type is
	//   replication-group and the unique identifier is the replication group name.
	//   Example: replication-group/mycluster .
	//
	//   - Neptune cluster - The resource type is cluster and the unique identifier is
	//   the cluster name. Example: cluster:mycluster .
	//
	//   - SageMaker Serverless endpoint - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - SageMaker inference component - The resource type is inference-component and
	//   the unique identifier is the resource ID. Example:
	//   inference-component/my-inference-component .
	//
	// [GitHub repository]: https://github.com/aws/aws-auto-scaling-custom-resource
	//
	// This member is required.
	ResourceId *string

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//   - ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//   - elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
	//   Instance Group.
	//
	//   - ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
	//
	//   - appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0
	//   fleet.
	//
	//   - dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB global secondary index.
	//
	//   - dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB global secondary index.
	//
	//   - rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB
	//   cluster. Available for Aurora MySQL-compatible edition and Aurora
	//   PostgreSQL-compatible edition.
	//
	//   - sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a
	//   SageMaker model endpoint variant.
	//
	//   - custom-resource:ResourceType:Property - The scalable dimension for a custom
	//   resource provided by your own application or service.
	//
	//   - comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number
	//   of inference units for an Amazon Comprehend document classification endpoint.
	//
	//   - comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of
	//   inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//   - lambda:function:ProvisionedConcurrency - The provisioned concurrency for a
	//   Lambda function.
	//
	//   - cassandra:table:ReadCapacityUnits - The provisioned read capacity for an
	//   Amazon Keyspaces table.
	//
	//   - cassandra:table:WriteCapacityUnits - The provisioned write capacity for an
	//   Amazon Keyspaces table.
	//
	//   - kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for
	//   brokers in an Amazon MSK cluster.
	//
	//   - elasticache:replication-group:NodeGroups - The number of node groups for an
	//   Amazon ElastiCache replication group.
	//
	//   - elasticache:replication-group:Replicas - The number of replicas per node
	//   group for an Amazon ElastiCache replication group.
	//
	//   - neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon
	//   Neptune DB cluster.
	//
	//   - sagemaker:variant:DesiredProvisionedConcurrency - The provisioned
	//   concurrency for a SageMaker Serverless endpoint.
	//
	//   - sagemaker:inference-component:DesiredCopyCount - The number of copies across
	//   an endpoint for a SageMaker inference component.
	//
	// This member is required.
	ScalableDimension ScalableDimension

	// The namespace of the Amazon Web Services service that provides the resource, or
	// a custom-resource .
	//
	// This member is required.
	ServiceNamespace ServiceNamespace

	// The Unix timestamp for when the scaling activity began.
	//
	// This member is required.
	StartTime *time.Time

	// Indicates the status of the scaling activity.
	//
	// This member is required.
	StatusCode ScalingActivityStatusCode

	// The details about the scaling activity.
	Details *string

	// The Unix timestamp for when the scaling activity ended.
	EndTime *time.Time

	// Machine-readable data that describes the reason for a not scaled activity. Only
	// available when [DescribeScalingActivities]includes not scaled activities.
	//
	// [DescribeScalingActivities]: https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html
	NotScaledReasons []NotScaledReason

	// A simple message about the current status of the scaling activity.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Represents a scaling policy to use with Application Auto Scaling.
//
// For more information about configuring scaling policies for a specific service,
// see [Amazon Web Services services that you can use with Application Auto Scaling]in the Application Auto Scaling User Guide.
//
// [Amazon Web Services services that you can use with Application Auto Scaling]: https://docs.aws.amazon.com/autoscaling/application/userguide/integrated-services-list.html
type ScalingPolicy struct {

	// The Unix timestamp for when the scaling policy was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the scaling policy.
	//
	// This member is required.
	PolicyARN *string

	// The name of the scaling policy.
	//
	// This member is required.
	PolicyName *string

	// The scaling policy type.
	//
	// The following policy types are supported:
	//
	// TargetTrackingScaling —Not supported for Amazon EMR
	//
	// StepScaling —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon
	// Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
	//
	// This member is required.
	PolicyType PolicyType

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//   - ECS service - The resource type is service and the unique identifier is the
	//   cluster name and service name. Example: service/default/sample-webapp .
	//
	//   - Spot Fleet - The resource type is spot-fleet-request and the unique
	//   identifier is the Spot Fleet request ID. Example:
	//   spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE .
	//
	//   - EMR cluster - The resource type is instancegroup and the unique identifier
	//   is the cluster ID and instance group ID. Example:
	//   instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0 .
	//
	//   - AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//   is the fleet name. Example: fleet/sample-fleet .
	//
	//   - DynamoDB table - The resource type is table and the unique identifier is the
	//   table name. Example: table/my-table .
	//
	//   - DynamoDB global secondary index - The resource type is index and the unique
	//   identifier is the index name. Example: table/my-table/index/my-table-index .
	//
	//   - Aurora DB cluster - The resource type is cluster and the unique identifier
	//   is the cluster name. Example: cluster:my-db-cluster .
	//
	//   - SageMaker endpoint variant - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - Custom resources are not supported with a resource type. This parameter
	//   must specify the OutputValue from the CloudFormation template stack used to
	//   access the resources. The unique identifier is defined by the service provider.
	//   More information is available in our [GitHub repository].
	//
	//   - Amazon Comprehend document classification endpoint - The resource type and
	//   unique identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE
	//   .
	//
	//   - Amazon Comprehend entity recognizer endpoint - The resource type and unique
	//   identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE .
	//
	//   - Lambda provisioned concurrency - The resource type is function and the
	//   unique identifier is the function name with a function version or alias name
	//   suffix that is not $LATEST . Example: function:my-function:prod or
	//   function:my-function:1 .
	//
	//   - Amazon Keyspaces table - The resource type is table and the unique
	//   identifier is the table name. Example: keyspace/mykeyspace/table/mytable .
	//
	//   - Amazon MSK cluster - The resource type and unique identifier are specified
	//   using the cluster ARN. Example:
	//   arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5
	//   .
	//
	//   - Amazon ElastiCache replication group - The resource type is
	//   replication-group and the unique identifier is the replication group name.
	//   Example: replication-group/mycluster .
	//
	//   - Neptune cluster - The resource type is cluster and the unique identifier is
	//   the cluster name. Example: cluster:mycluster .
	//
	//   - SageMaker Serverless endpoint - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - SageMaker inference component - The resource type is inference-component and
	//   the unique identifier is the resource ID. Example:
	//   inference-component/my-inference-component .
	//
	// [GitHub repository]: https://github.com/aws/aws-auto-scaling-custom-resource
	//
	// This member is required.
	ResourceId *string

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//   - ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//   - elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
	//   Instance Group.
	//
	//   - ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
	//
	//   - appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0
	//   fleet.
	//
	//   - dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB global secondary index.
	//
	//   - dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB global secondary index.
	//
	//   - rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB
	//   cluster. Available for Aurora MySQL-compatible edition and Aurora
	//   PostgreSQL-compatible edition.
	//
	//   - sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a
	//   SageMaker model endpoint variant.
	//
	//   - custom-resource:ResourceType:Property - The scalable dimension for a custom
	//   resource provided by your own application or service.
	//
	//   - comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number
	//   of inference units for an Amazon Comprehend document classification endpoint.
	//
	//   - comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of
	//   inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//   - lambda:function:ProvisionedConcurrency - The provisioned concurrency for a
	//   Lambda function.
	//
	//   - cassandra:table:ReadCapacityUnits - The provisioned read capacity for an
	//   Amazon Keyspaces table.
	//
	//   - cassandra:table:WriteCapacityUnits - The provisioned write capacity for an
	//   Amazon Keyspaces table.
	//
	//   - kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for
	//   brokers in an Amazon MSK cluster.
	//
	//   - elasticache:replication-group:NodeGroups - The number of node groups for an
	//   Amazon ElastiCache replication group.
	//
	//   - elasticache:replication-group:Replicas - The number of replicas per node
	//   group for an Amazon ElastiCache replication group.
	//
	//   - neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon
	//   Neptune DB cluster.
	//
	//   - sagemaker:variant:DesiredProvisionedConcurrency - The provisioned
	//   concurrency for a SageMaker Serverless endpoint.
	//
	//   - sagemaker:inference-component:DesiredCopyCount - The number of copies across
	//   an endpoint for a SageMaker inference component.
	//
	// This member is required.
	ScalableDimension ScalableDimension

	// The namespace of the Amazon Web Services service that provides the resource, or
	// a custom-resource .
	//
	// This member is required.
	ServiceNamespace ServiceNamespace

	// The CloudWatch alarms associated with the scaling policy.
	Alarms []Alarm

	// A step scaling policy.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration

	// A target tracking scaling policy.
	TargetTrackingScalingPolicyConfiguration *TargetTrackingScalingPolicyConfiguration

	noSmithyDocumentSerde
}

// Represents a scheduled action.
type ScheduledAction struct {

	// The date and time that the scheduled action was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//   - ECS service - The resource type is service and the unique identifier is the
	//   cluster name and service name. Example: service/default/sample-webapp .
	//
	//   - Spot Fleet - The resource type is spot-fleet-request and the unique
	//   identifier is the Spot Fleet request ID. Example:
	//   spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE .
	//
	//   - EMR cluster - The resource type is instancegroup and the unique identifier
	//   is the cluster ID and instance group ID. Example:
	//   instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0 .
	//
	//   - AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//   is the fleet name. Example: fleet/sample-fleet .
	//
	//   - DynamoDB table - The resource type is table and the unique identifier is the
	//   table name. Example: table/my-table .
	//
	//   - DynamoDB global secondary index - The resource type is index and the unique
	//   identifier is the index name. Example: table/my-table/index/my-table-index .
	//
	//   - Aurora DB cluster - The resource type is cluster and the unique identifier
	//   is the cluster name. Example: cluster:my-db-cluster .
	//
	//   - SageMaker endpoint variant - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - Custom resources are not supported with a resource type. This parameter
	//   must specify the OutputValue from the CloudFormation template stack used to
	//   access the resources. The unique identifier is defined by the service provider.
	//   More information is available in our [GitHub repository].
	//
	//   - Amazon Comprehend document classification endpoint - The resource type and
	//   unique identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE
	//   .
	//
	//   - Amazon Comprehend entity recognizer endpoint - The resource type and unique
	//   identifier are specified using the endpoint ARN. Example:
	//   arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE .
	//
	//   - Lambda provisioned concurrency - The resource type is function and the
	//   unique identifier is the function name with a function version or alias name
	//   suffix that is not $LATEST . Example: function:my-function:prod or
	//   function:my-function:1 .
	//
	//   - Amazon Keyspaces table - The resource type is table and the unique
	//   identifier is the table name. Example: keyspace/mykeyspace/table/mytable .
	//
	//   - Amazon MSK cluster - The resource type and unique identifier are specified
	//   using the cluster ARN. Example:
	//   arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5
	//   .
	//
	//   - Amazon ElastiCache replication group - The resource type is
	//   replication-group and the unique identifier is the replication group name.
	//   Example: replication-group/mycluster .
	//
	//   - Neptune cluster - The resource type is cluster and the unique identifier is
	//   the cluster name. Example: cluster:mycluster .
	//
	//   - SageMaker Serverless endpoint - The resource type is variant and the unique
	//   identifier is the resource ID. Example:
	//   endpoint/my-end-point/variant/KMeansClustering .
	//
	//   - SageMaker inference component - The resource type is inference-component and
	//   the unique identifier is the resource ID. Example:
	//   inference-component/my-inference-component .
	//
	// [GitHub repository]: https://github.com/aws/aws-auto-scaling-custom-resource
	//
	// This member is required.
	ResourceId *string

	// The schedule for this action. The following formats are supported:
	//
	//   - At expressions - " at(yyyy-mm-ddThh:mm:ss) "
	//
	//   - Rate expressions - " rate(value unit) "
	//
	//   - Cron expressions - " cron(fields) "
	//
	// At expressions are useful for one-time schedules. Cron expressions are useful
	// for scheduled actions that run periodically at a specified date and time, and
	// rate expressions are useful for scheduled actions that run at a regular
	// interval.
	//
	// At and cron expressions use Universal Coordinated Time (UTC) by default.
	//
	// The cron format consists of six fields separated by white spaces: [Minutes]
	// [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
	//
	// For rate expressions, value is a positive integer and unit is minute | minutes
	// | hour | hours | day | days .
	//
	// For more information and examples, see [Example scheduled actions for Application Auto Scaling] in the Application Auto Scaling User
	// Guide.
	//
	// [Example scheduled actions for Application Auto Scaling]: https://docs.aws.amazon.com/autoscaling/application/userguide/examples-scheduled-actions.html
	//
	// This member is required.
	Schedule *string

	// The Amazon Resource Name (ARN) of the scheduled action.
	//
	// This member is required.
	ScheduledActionARN *string

	// The name of the scheduled action.
	//
	// This member is required.
	ScheduledActionName *string

	// The namespace of the Amazon Web Services service that provides the resource, or
	// a custom-resource .
	//
	// This member is required.
	ServiceNamespace ServiceNamespace

	// The date and time that the action is scheduled to end, in UTC.
	EndTime *time.Time

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//   - ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//   - elasticmapreduce:instancegroup:InstanceCount - The instance count of an EMR
	//   Instance Group.
	//
	//   - ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet.
	//
	//   - appstream:fleet:DesiredCapacity - The desired capacity of an AppStream 2.0
	//   fleet.
	//
	//   - dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB table.
	//
	//   - dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a
	//   DynamoDB global secondary index.
	//
	//   - dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a
	//   DynamoDB global secondary index.
	//
	//   - rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB
	//   cluster. Available for Aurora MySQL-compatible edition and Aurora
	//   PostgreSQL-compatible edition.
	//
	//   - sagemaker:variant:DesiredInstanceCount - The number of EC2 instances for a
	//   SageMaker model endpoint variant.
	//
	//   - custom-resource:ResourceType:Property - The scalable dimension for a custom
	//   resource provided by your own application or service.
	//
	//   - comprehend:document-classifier-endpoint:DesiredInferenceUnits - The number
	//   of inference units for an Amazon Comprehend document classification endpoint.
	//
	//   - comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number of
	//   inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//   - lambda:function:ProvisionedConcurrency - The provisioned concurrency for a
	//   Lambda function.
	//
	//   - cassandra:table:ReadCapacityUnits - The provisioned read capacity for an
	//   Amazon Keyspaces table.
	//
	//   - cassandra:table:WriteCapacityUnits - The provisioned write capacity for an
	//   Amazon Keyspaces table.
	//
	//   - kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB) for
	//   brokers in an Amazon MSK cluster.
	//
	//   - elasticache:replication-group:NodeGroups - The number of node groups for an
	//   Amazon ElastiCache replication group.
	//
	//   - elasticache:replication-group:Replicas - The number of replicas per node
	//   group for an Amazon ElastiCache replication group.
	//
	//   - neptune:cluster:ReadReplicaCount - The count of read replicas in an Amazon
	//   Neptune DB cluster.
	//
	//   - sagemaker:variant:DesiredProvisionedConcurrency - The provisioned
	//   concurrency for a SageMaker Serverless endpoint.
	//
	//   - sagemaker:inference-component:DesiredCopyCount - The number of copies across
	//   an endpoint for a SageMaker inference component.
	ScalableDimension ScalableDimension

	// The new minimum and maximum capacity. You can set both values or just one. At
	// the scheduled time, if the current capacity is below the minimum capacity,
	// Application Auto Scaling scales out to the minimum capacity. If the current
	// capacity is above the maximum capacity, Application Auto Scaling scales in to
	// the maximum capacity.
	ScalableTargetAction *ScalableTargetAction

	// The date and time that the action is scheduled to begin, in UTC.
	StartTime *time.Time

	// The time zone used when referring to the date and time of a scheduled action,
	// when the scheduled action uses an at or cron expression.
	Timezone *string

	noSmithyDocumentSerde
}

// Represents a step adjustment for a [StepScalingPolicyConfiguration]. Describes an adjustment based on the
// difference between the value of the aggregated CloudWatch metric and the breach
// threshold that you've defined for the alarm.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//   - To initiate the adjustment when the metric is greater than or equal to 50
//     and less than 60, specify a lower bound of 0 and an upper bound of 10 .
//
//   - To initiate the adjustment when the metric is greater than 40 and less than
//     or equal to 50, specify a lower bound of -10 and an upper bound of 0 .
//
// There are a few rules for the step adjustments for your step policy:
//
//   - The ranges of your step adjustments can't overlap or have a gap.
//
//   - At most one step adjustment can have a null lower bound. If one step
//     adjustment has a negative lower bound, then there must be a step adjustment with
//     a null lower bound.
//
//   - At most one step adjustment can have a null upper bound. If one step
//     adjustment has a positive upper bound, then there must be a step adjustment with
//     a null upper bound.
//
//   - The upper and lower bound can't be null in the same step adjustment.
//
// [StepScalingPolicyConfiguration]: https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html
type StepAdjustment struct {

	// The amount by which to scale, based on the specified adjustment type. A
	// positive value adds to the current capacity while a negative number removes from
	// the current capacity. For exact capacity, you must specify a non-negative value.
	//
	// This member is required.
	ScalingAdjustment *int32

	// The lower bound for the difference between the alarm threshold and the
	// CloudWatch metric. If the metric value is above the breach threshold, the lower
	// bound is inclusive (the metric must be greater than or equal to the threshold
	// plus the lower bound). Otherwise, it's exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64

	// The upper bound for the difference between the alarm threshold and the
	// CloudWatch metric. If the metric value is above the breach threshold, the upper
	// bound is exclusive (the metric must be less than the threshold plus the upper
	// bound). Otherwise, it's inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64

	noSmithyDocumentSerde
}

// Represents a step scaling policy configuration to use with Application Auto
// Scaling.
//
// For more information, see [Step scaling policies] in the Application Auto Scaling User Guide.
//
// [Step scaling policies]: https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html
type StepScalingPolicyConfiguration struct {

	// Specifies how the ScalingAdjustment value in a [StepAdjustment] is interpreted (for example, an
	// absolute number or a percentage). The valid values are ChangeInCapacity ,
	// ExactCapacity , and PercentChangeInCapacity .
	//
	// AdjustmentType is required if you are adding a new step scaling policy
	// configuration.
	//
	// [StepAdjustment]: https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html
	AdjustmentType AdjustmentType

	// The amount of time, in seconds, to wait for a previous scaling activity to take
	// effect. If not specified, the default value is 300. For more information, see [Cooldown period]
	// in the Application Auto Scaling User Guide.
	//
	// [Cooldown period]: https://docs.aws.amazon.com/autoscaling/application/userguide/step-scaling-policy-overview.html#step-scaling-cooldown
	Cooldown *int32

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum ,
	// Maximum , and Average . If the aggregation type is null, the value is treated as
	// Average .
	MetricAggregationType MetricAggregationType

	// The minimum value to scale by when the adjustment type is
	// PercentChangeInCapacity . For example, suppose that you create a step scaling
	// policy to scale out an Amazon ECS service by 25 percent and you specify a
	// MinAdjustmentMagnitude of 2. If the service has 4 tasks and the scaling policy
	// is performed, 25 percent of 4 is 1. However, because you specified a
	// MinAdjustmentMagnitude of 2, Application Auto Scaling scales out the service by
	// 2 tasks.
	MinAdjustmentMagnitude *int32

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	//
	// At least one step adjustment is required if you are adding a new step scaling
	// policy configuration.
	StepAdjustments []StepAdjustment

	noSmithyDocumentSerde
}

// Specifies whether the scaling activities for a scalable target are in a
// suspended state.
type SuspendedState struct {

	// Whether scale in by a target tracking scaling policy or a step scaling policy
	// is suspended. Set the value to true if you don't want Application Auto Scaling
	// to remove capacity when a scaling policy is triggered. The default is false .
	DynamicScalingInSuspended *bool

	// Whether scale out by a target tracking scaling policy or a step scaling policy
	// is suspended. Set the value to true if you don't want Application Auto Scaling
	// to add capacity when a scaling policy is triggered. The default is false .
	DynamicScalingOutSuspended *bool

	// Whether scheduled scaling is suspended. Set the value to true if you don't want
	// Application Auto Scaling to add or remove capacity by initiating scheduled
	// actions. The default is false .
	ScheduledScalingSuspended *bool

	noSmithyDocumentSerde
}

// Represents a specific metric.
//
// Metric is a property of the TargetTrackingMetricStat object.
type TargetTrackingMetric struct {

	// The dimensions for the metric. For the list of available dimensions, see the
	// Amazon Web Services documentation available from the table in [Amazon Web Services services that publish CloudWatch metrics]in the Amazon
	// CloudWatch User Guide.
	//
	// Conditional: If you published your metric with dimensions, you must specify the
	// same dimensions in your scaling policy.
	//
	// [Amazon Web Services services that publish CloudWatch metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html
	Dimensions []TargetTrackingMetricDimension

	// The name of the metric.
	MetricName *string

	// The namespace of the metric. For more information, see the table in [Amazon Web Services services that publish CloudWatch metrics] in the
	// Amazon CloudWatch User Guide.
	//
	// [Amazon Web Services services that publish CloudWatch metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html
	Namespace *string

	noSmithyDocumentSerde
}

// The metric data to return. Also defines whether this call is returning data for
// one metric only, or whether it is performing a math expression on the values of
// returned metric statistics to create a new time series. A time series is a
// series of data points, each of which is associated with a timestamp.
//
// For more information and examples, see [Create a target tracking scaling policy for Application Auto Scaling using metric math] in the Application Auto Scaling User
// Guide.
//
// [Create a target tracking scaling policy for Application Auto Scaling using metric math]: https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking-metric-math.html
type TargetTrackingMetricDataQuery struct {

	// A short name that identifies the object's results in the response. This name
	// must be unique among all MetricDataQuery objects specified for a single scaling
	// policy. If you are performing math expressions on this set of data, this name
	// represents that data and can serve as a variable in the mathematical expression.
	// The valid characters are letters, numbers, and underscores. The first character
	// must be a lowercase letter.
	//
	// This member is required.
	Id *string

	// The math expression to perform on the returned data, if this object is
	// performing a math expression. This expression can use the Id of the other
	// metrics to refer to those metrics, and can also use the Id of other expressions
	// to use the result of those expressions.
	//
	// Conditional: Within each TargetTrackingMetricDataQuery object, you must specify
	// either Expression or MetricStat , but not both.
	Expression *string

	// A human-readable label for this metric or expression. This is especially useful
	// if this is a math expression, so that you know what the value represents.
	Label *string

	// Information about the metric data to return.
	//
	// Conditional: Within each MetricDataQuery object, you must specify either
	// Expression or MetricStat , but not both.
	MetricStat *TargetTrackingMetricStat

	// Indicates whether to return the timestamps and raw data values of this metric.
	//
	// If you use any math expressions, specify true for this value for only the final
	// math expression that the metric specification is based on. You must specify
	// false for ReturnData for all the other metrics and expressions used in the
	// metric specification.
	//
	// If you are only retrieving metrics and not performing any math expressions, do
	// not specify anything for ReturnData . This sets it to its default ( true ).
	ReturnData *bool

	noSmithyDocumentSerde
}

// Describes the dimension of a metric.
type TargetTrackingMetricDimension struct {

	// The name of the dimension.
	//
	// This member is required.
	Name *string

	// The value of the dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// This structure defines the CloudWatch metric to return, along with the
// statistic, period, and unit.
//
// For more information about the CloudWatch terminology below, see [Amazon CloudWatch concepts] in the Amazon
// CloudWatch User Guide.
//
// [Amazon CloudWatch concepts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html
type TargetTrackingMetricStat struct {

	// The CloudWatch metric to return, including the metric name, namespace, and
	// dimensions. To get the exact metric name, namespace, and dimensions, inspect the
	// [Metric]object that is returned by a call to [ListMetrics].
	//
	// [ListMetrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html
	// [Metric]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html
	//
	// This member is required.
	Metric *TargetTrackingMetric

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic. For a list of valid values, see the table in [Statistics]in the Amazon
	// CloudWatch User Guide.
	//
	// The most commonly used metric for scaling is Average .
	//
	// [Statistics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic
	//
	// This member is required.
	Stat *string

	// The unit to use for the returned data points. For a complete list of the units
	// that CloudWatch supports, see the [MetricDatum]data type in the Amazon CloudWatch API
	// Reference.
	//
	// [MetricDatum]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html
	Unit *string

	noSmithyDocumentSerde
}

// Represents a target tracking scaling policy configuration to use with
// Application Auto Scaling.
//
// For more information, see [Target tracking scaling policies] in the Application Auto Scaling User Guide.
//
// [Target tracking scaling policies]: https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html
type TargetTrackingScalingPolicyConfiguration struct {

	// The target value for the metric. Although this property accepts numbers of type
	// Double, it won't accept values that are either too small or too large. Values
	// must be in the range of -2^360 to 2^360. The value must be a valid number based
	// on the choice of metric. For example, if the metric is CPU utilization, then the
	// target value is a percent value that represents how much of the CPU can be used
	// before scaling out.
	//
	// If the scaling policy specifies the ALBRequestCountPerTarget predefined metric,
	// specify the target utilization as the optimal average request count per target
	// during any one-minute interval.
	//
	// This member is required.
	TargetValue *float64

	// A customized metric. You can specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification

	// Indicates whether scale in by the target tracking scaling policy is disabled.
	// If the value is true , scale in is disabled and the target tracking scaling
	// policy won't remove capacity from the scalable target. Otherwise, scale in is
	// enabled and the target tracking scaling policy can remove capacity from the
	// scalable target. The default value is false .
	DisableScaleIn *bool

	// A predefined metric. You can specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification

	// The amount of time, in seconds, after a scale-in activity completes before
	// another scale-in activity can start. For more information and for default
	// values, see [Define cooldown periods]in the Application Auto Scaling User Guide.
	//
	// [Define cooldown periods]: https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown
	ScaleInCooldown *int32

	// The amount of time, in seconds, to wait for a previous scale-out activity to
	// take effect. For more information and for default values, see [Define cooldown periods]in the
	// Application Auto Scaling User Guide.
	//
	// [Define cooldown periods]: https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown
	ScaleOutCooldown *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
