//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLPoolVulnerabilityAssessmentRuleBaselinesClient contains the methods for the SQLPoolVulnerabilityAssessmentRuleBaselines group.
// Don't use this type directly, use NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient() instead.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient creates a new instance of SQLPoolVulnerabilityAssessmentRuleBaselinesClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLPoolVulnerabilityAssessmentRuleBaselinesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SQLPoolVulnerabilityAssessmentRuleBaselinesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a Sql pool's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// workspaceName - The name of the workspace.
// sqlPoolName - SQL pool name
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule
// and master for workspace level rule).
// parameters - The requested rule baseline resource.
// options - SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters for the
// SQLPoolVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate method.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters SQLPoolVulnerabilityAssessmentRuleBaseline, options *SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleID, baselineName, parameters, options)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters SQLPoolVulnerabilityAssessmentRuleBaseline, options *SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateHandleResponse(resp *http.Response) (SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	result := SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLPoolVulnerabilityAssessmentRuleBaseline); err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// workspaceName - The name of the workspace.
// sqlPoolName - SQL pool name
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule
// and master for workspace level rule).
// options - SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Delete
// method.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a SqlPool's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// workspaceName - The name of the workspace.
// sqlPoolName - SQL pool name
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// ruleID - The vulnerability assessment rule ID.
// baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule
// and master for server level rule).
// options - SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Get
// method.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetOptions) (SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) getCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if sqlPoolName == "" {
		return nil, errors.New("parameter sqlPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlPoolName}", url.PathEscape(sqlPoolName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLPoolVulnerabilityAssessmentRuleBaselinesClient) getHandleResponse(resp *http.Response) (SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	result := SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLPoolVulnerabilityAssessmentRuleBaseline); err != nil {
		return SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	return result, nil
}
