//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicyinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PolicyRestrictionsClient contains the methods for the PolicyRestrictions group.
// Don't use this type directly, use NewPolicyRestrictionsClient() instead.
type PolicyRestrictionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewPolicyRestrictionsClient creates a new instance of PolicyRestrictionsClient with the specified values.
// subscriptionID - Microsoft Azure subscription ID.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPolicyRestrictionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PolicyRestrictionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PolicyRestrictionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CheckAtManagementGroupScope - Checks what restrictions Azure Policy will place on resources within a management group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// managementGroupID - Management group ID.
// parameters - The check policy restrictions parameters.
// options - PolicyRestrictionsClientCheckAtManagementGroupScopeOptions contains the optional parameters for the PolicyRestrictionsClient.CheckAtManagementGroupScope
// method.
func (client *PolicyRestrictionsClient) CheckAtManagementGroupScope(ctx context.Context, managementGroupID string, parameters CheckManagementGroupRestrictionsRequest, options *PolicyRestrictionsClientCheckAtManagementGroupScopeOptions) (PolicyRestrictionsClientCheckAtManagementGroupScopeResponse, error) {
	req, err := client.checkAtManagementGroupScopeCreateRequest(ctx, managementGroupID, parameters, options)
	if err != nil {
		return PolicyRestrictionsClientCheckAtManagementGroupScopeResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PolicyRestrictionsClientCheckAtManagementGroupScopeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PolicyRestrictionsClientCheckAtManagementGroupScopeResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkAtManagementGroupScopeHandleResponse(resp)
}

// checkAtManagementGroupScopeCreateRequest creates the CheckAtManagementGroupScope request.
func (client *PolicyRestrictionsClient) checkAtManagementGroupScopeCreateRequest(ctx context.Context, managementGroupID string, parameters CheckManagementGroupRestrictionsRequest, options *PolicyRestrictionsClientCheckAtManagementGroupScopeOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// checkAtManagementGroupScopeHandleResponse handles the CheckAtManagementGroupScope response.
func (client *PolicyRestrictionsClient) checkAtManagementGroupScopeHandleResponse(resp *http.Response) (PolicyRestrictionsClientCheckAtManagementGroupScopeResponse, error) {
	result := PolicyRestrictionsClientCheckAtManagementGroupScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckRestrictionsResult); err != nil {
		return PolicyRestrictionsClientCheckAtManagementGroupScopeResponse{}, err
	}
	return result, nil
}

// CheckAtResourceGroupScope - Checks what restrictions Azure Policy will place on a resource within a resource group. Use
// this when the resource group the resource will be created in is already known.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// parameters - The check policy restrictions parameters.
// options - PolicyRestrictionsClientCheckAtResourceGroupScopeOptions contains the optional parameters for the PolicyRestrictionsClient.CheckAtResourceGroupScope
// method.
func (client *PolicyRestrictionsClient) CheckAtResourceGroupScope(ctx context.Context, resourceGroupName string, parameters CheckRestrictionsRequest, options *PolicyRestrictionsClientCheckAtResourceGroupScopeOptions) (PolicyRestrictionsClientCheckAtResourceGroupScopeResponse, error) {
	req, err := client.checkAtResourceGroupScopeCreateRequest(ctx, resourceGroupName, parameters, options)
	if err != nil {
		return PolicyRestrictionsClientCheckAtResourceGroupScopeResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PolicyRestrictionsClientCheckAtResourceGroupScopeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PolicyRestrictionsClientCheckAtResourceGroupScopeResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkAtResourceGroupScopeHandleResponse(resp)
}

// checkAtResourceGroupScopeCreateRequest creates the CheckAtResourceGroupScope request.
func (client *PolicyRestrictionsClient) checkAtResourceGroupScopeCreateRequest(ctx context.Context, resourceGroupName string, parameters CheckRestrictionsRequest, options *PolicyRestrictionsClientCheckAtResourceGroupScopeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// checkAtResourceGroupScopeHandleResponse handles the CheckAtResourceGroupScope response.
func (client *PolicyRestrictionsClient) checkAtResourceGroupScopeHandleResponse(resp *http.Response) (PolicyRestrictionsClientCheckAtResourceGroupScopeResponse, error) {
	result := PolicyRestrictionsClientCheckAtResourceGroupScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckRestrictionsResult); err != nil {
		return PolicyRestrictionsClientCheckAtResourceGroupScopeResponse{}, err
	}
	return result, nil
}

// CheckAtSubscriptionScope - Checks what restrictions Azure Policy will place on a resource within a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// parameters - The check policy restrictions parameters.
// options - PolicyRestrictionsClientCheckAtSubscriptionScopeOptions contains the optional parameters for the PolicyRestrictionsClient.CheckAtSubscriptionScope
// method.
func (client *PolicyRestrictionsClient) CheckAtSubscriptionScope(ctx context.Context, parameters CheckRestrictionsRequest, options *PolicyRestrictionsClientCheckAtSubscriptionScopeOptions) (PolicyRestrictionsClientCheckAtSubscriptionScopeResponse, error) {
	req, err := client.checkAtSubscriptionScopeCreateRequest(ctx, parameters, options)
	if err != nil {
		return PolicyRestrictionsClientCheckAtSubscriptionScopeResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PolicyRestrictionsClientCheckAtSubscriptionScopeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PolicyRestrictionsClientCheckAtSubscriptionScopeResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkAtSubscriptionScopeHandleResponse(resp)
}

// checkAtSubscriptionScopeCreateRequest creates the CheckAtSubscriptionScope request.
func (client *PolicyRestrictionsClient) checkAtSubscriptionScopeCreateRequest(ctx context.Context, parameters CheckRestrictionsRequest, options *PolicyRestrictionsClientCheckAtSubscriptionScopeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// checkAtSubscriptionScopeHandleResponse handles the CheckAtSubscriptionScope response.
func (client *PolicyRestrictionsClient) checkAtSubscriptionScopeHandleResponse(resp *http.Response) (PolicyRestrictionsClientCheckAtSubscriptionScopeResponse, error) {
	result := PolicyRestrictionsClientCheckAtSubscriptionScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckRestrictionsResult); err != nil {
		return PolicyRestrictionsClientCheckAtSubscriptionScopeResponse{}, err
	}
	return result, nil
}
