//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices

import "time"

// AacAudio - Describes Advanced Audio Codec (AAC) audio encoding settings.
type AacAudio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32 `json:"bitrate,omitempty"`

	// The number of channels in the audio.
	Channels *int32 `json:"channels,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// The encoding profile to be used when encoding audio with AAC.
	Profile *AacAudioProfile `json:"profile,omitempty"`

	// The sampling rate to use for encoding in hertz.
	SamplingRate *int32 `json:"samplingRate,omitempty"`
}

// GetAudio implements the AudioClassification interface for type AacAudio.
func (a *AacAudio) GetAudio() *Audio {
	return &Audio{
		Channels:     a.Channels,
		SamplingRate: a.SamplingRate,
		Bitrate:      a.Bitrate,
		ODataType:    a.ODataType,
		Label:        a.Label,
	}
}

// GetCodec implements the CodecClassification interface for type AacAudio.
func (a *AacAudio) GetCodec() *Codec {
	return &Codec{
		ODataType: a.ODataType,
		Label:     a.Label,
	}
}

// AbsoluteClipTime - Specifies the clip time as an absolute time position in the media file. The absolute time can point
// to a different position depending on whether the media file starts from a timestamp of zero or not.
type AbsoluteClipTime struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S
	// for 30 seconds.
	Time *string `json:"time,omitempty"`
}

// GetClipTime implements the ClipTimeClassification interface for type AbsoluteClipTime.
func (a *AbsoluteClipTime) GetClipTime() *ClipTime {
	return &ClipTime{
		ODataType: a.ODataType,
	}
}

type AccessControl struct {
	// The behavior for IP access control in Key Delivery.
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be
	// empty.
	IPAllowList []*string `json:"ipAllowList,omitempty"`
}

type AccountEncryption struct {
	// REQUIRED; The type of key used to encrypt the Account Key.
	Type *AccountEncryptionKeyType `json:"type,omitempty"`

	// The Key Vault identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The properties of the key used to encrypt the account.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// READ-ONLY; The current status of the Key Vault mapping.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// AccountFilter - An Account Filter.
type AccountFilter struct {
	// The Media Filter properties.
	Properties *MediaFilterProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountFilterCollection - A collection of AccountFilter items.
type AccountFilterCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of AccountFilter items.
	Value []*AccountFilter `json:"value,omitempty"`
}

// AccountFiltersClientCreateOrUpdateOptions contains the optional parameters for the AccountFiltersClient.CreateOrUpdate
// method.
type AccountFiltersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccountFiltersClientDeleteOptions contains the optional parameters for the AccountFiltersClient.Delete method.
type AccountFiltersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountFiltersClientGetOptions contains the optional parameters for the AccountFiltersClient.Get method.
type AccountFiltersClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountFiltersClientListOptions contains the optional parameters for the AccountFiltersClient.List method.
type AccountFiltersClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountFiltersClientUpdateOptions contains the optional parameters for the AccountFiltersClient.Update method.
type AccountFiltersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AkamaiAccessControl - Akamai access control
type AkamaiAccessControl struct {
	// authentication key list
	AkamaiSignatureHeaderAuthenticationKeyList []*AkamaiSignatureHeaderAuthenticationKey `json:"akamaiSignatureHeaderAuthenticationKeyList,omitempty"`
}

// AkamaiSignatureHeaderAuthenticationKey - Akamai Signature Header authentication key.
type AkamaiSignatureHeaderAuthenticationKey struct {
	// authentication key
	Base64Key *string `json:"base64Key,omitempty"`

	// The expiration time of the authentication key.
	Expiration *time.Time `json:"expiration,omitempty"`

	// identifier of the key
	Identifier *string `json:"identifier,omitempty"`
}

// ArmStreamingEndpointCapacity - The streaming endpoint sku capacity.
type ArmStreamingEndpointCapacity struct {
	// The streaming endpoint default capacity.
	Default *int32 `json:"default,omitempty"`

	// The streaming endpoint maximum capacity.
	Maximum *int32 `json:"maximum,omitempty"`

	// The streaming endpoint minimum capacity.
	Minimum *int32 `json:"minimum,omitempty"`

	// READ-ONLY
	ScaleType *string `json:"scaleType,omitempty" azure:"ro"`
}

// ArmStreamingEndpointCurrentSKU - The streaming endpoint current sku.
type ArmStreamingEndpointCurrentSKU struct {
	// The streaming endpoint sku capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// READ-ONLY; The streaming endpoint sku name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// ArmStreamingEndpointSKU - The streaming endpoint sku.
type ArmStreamingEndpointSKU struct {
	// READ-ONLY; The streaming endpoint sku name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

type ArmStreamingEndpointSKUInfo struct {
	// The streaming endpoint sku capacity.
	Capacity     *ArmStreamingEndpointCapacity `json:"capacity,omitempty"`
	ResourceType *string                       `json:"resourceType,omitempty"`

	// The streaming endpoint sku.
	SKU *ArmStreamingEndpointSKU `json:"sku,omitempty"`
}

// Asset - An Asset.
type Asset struct {
	// The resource properties.
	Properties *AssetProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssetCollection - A collection of Asset items.
type AssetCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of Asset items.
	Value []*Asset `json:"value,omitempty"`
}

// AssetContainerSas - The Asset Storage container SAS URLs.
type AssetContainerSas struct {
	// The list of Asset container SAS URLs.
	AssetContainerSasUrls []*string `json:"assetContainerSasUrls,omitempty"`
}

// AssetFileEncryptionMetadata - The Asset File Storage encryption metadata.
type AssetFileEncryptionMetadata struct {
	// REQUIRED; The Asset File Id.
	AssetFileID *string `json:"assetFileId,omitempty"`

	// The Asset File name.
	AssetFileName *string `json:"assetFileName,omitempty"`

	// The Asset File initialization vector.
	InitializationVector *string `json:"initializationVector,omitempty"`
}

// AssetFilter - An Asset Filter.
type AssetFilter struct {
	// The Media Filter properties.
	Properties *MediaFilterProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssetFilterCollection - A collection of AssetFilter items.
type AssetFilterCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of AssetFilter items.
	Value []*AssetFilter `json:"value,omitempty"`
}

// AssetFiltersClientCreateOrUpdateOptions contains the optional parameters for the AssetFiltersClient.CreateOrUpdate method.
type AssetFiltersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AssetFiltersClientDeleteOptions contains the optional parameters for the AssetFiltersClient.Delete method.
type AssetFiltersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssetFiltersClientGetOptions contains the optional parameters for the AssetFiltersClient.Get method.
type AssetFiltersClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssetFiltersClientListOptions contains the optional parameters for the AssetFiltersClient.List method.
type AssetFiltersClientListOptions struct {
	// placeholder for future optional parameters
}

// AssetFiltersClientUpdateOptions contains the optional parameters for the AssetFiltersClient.Update method.
type AssetFiltersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AssetProperties - The Asset properties.
type AssetProperties struct {
	// The alternate ID of the Asset.
	AlternateID *string `json:"alternateId,omitempty"`

	// The name of the asset blob container.
	Container *string `json:"container,omitempty"`

	// The Asset description.
	Description *string `json:"description,omitempty"`

	// The name of the storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// READ-ONLY; The Asset ID.
	AssetID *string `json:"assetId,omitempty" azure:"ro"`

	// READ-ONLY; The creation date of the Asset.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The last modified date of the Asset.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The Asset encryption format. One of None or MediaStorageEncryption.
	StorageEncryptionFormat *AssetStorageEncryptionFormat `json:"storageEncryptionFormat,omitempty" azure:"ro"`
}

// AssetStreamingLocator - Properties of the Streaming Locator.
type AssetStreamingLocator struct {
	// READ-ONLY; Asset Name.
	AssetName *string `json:"assetName,omitempty" azure:"ro"`

	// READ-ONLY; The creation time of the Streaming Locator.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Name of the default ContentKeyPolicy used by this Streaming Locator.
	DefaultContentKeyPolicyName *string `json:"defaultContentKeyPolicyName,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the Streaming Locator.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Streaming Locator name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the Streaming Locator.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; StreamingLocatorId of the Streaming Locator.
	StreamingLocatorID *string `json:"streamingLocatorId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the Streaming Policy used by this Streaming Locator.
	StreamingPolicyName *string `json:"streamingPolicyName,omitempty" azure:"ro"`
}

// AssetTrack - An Asset Track resource.
type AssetTrack struct {
	// The resource properties.
	Properties *AssetTrackProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssetTrackCollection - A collection of AssetTrack items.
type AssetTrackCollection struct {
	// A collection of AssetTrack items.
	Value []*AssetTrack `json:"value,omitempty"`
}

// AssetTrackOperationResultsClientGetOptions contains the optional parameters for the AssetTrackOperationResultsClient.Get
// method.
type AssetTrackOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssetTrackOperationStatus - Status of asset track operation.
type AssetTrackOperationStatus struct {
	// REQUIRED; Operation identifier.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Operation status.
	Status *string `json:"status,omitempty"`

	// Operation end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error detail.
	Error *ErrorDetail `json:"error,omitempty"`

	// Operation resource ID.
	ID *string `json:"id,omitempty"`

	// Operation start time.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// AssetTrackOperationStatusesClientGetOptions contains the optional parameters for the AssetTrackOperationStatusesClient.Get
// method.
type AssetTrackOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssetTrackProperties - Properties of a video, audio or text track in the asset.
type AssetTrackProperties struct {
	// Detailed information about a track in the asset.
	Track TrackBaseClassification `json:"track,omitempty"`

	// READ-ONLY; Provisioning state of the asset track.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AssetsClientCreateOrUpdateOptions contains the optional parameters for the AssetsClient.CreateOrUpdate method.
type AssetsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AssetsClientDeleteOptions contains the optional parameters for the AssetsClient.Delete method.
type AssetsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssetsClientGetEncryptionKeyOptions contains the optional parameters for the AssetsClient.GetEncryptionKey method.
type AssetsClientGetEncryptionKeyOptions struct {
	// placeholder for future optional parameters
}

// AssetsClientGetOptions contains the optional parameters for the AssetsClient.Get method.
type AssetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssetsClientListContainerSasOptions contains the optional parameters for the AssetsClient.ListContainerSas method.
type AssetsClientListContainerSasOptions struct {
	// placeholder for future optional parameters
}

// AssetsClientListOptions contains the optional parameters for the AssetsClient.List method.
type AssetsClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies the key by which the result collection should be ordered.
	Orderby *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// AssetsClientListStreamingLocatorsOptions contains the optional parameters for the AssetsClient.ListStreamingLocators method.
type AssetsClientListStreamingLocatorsOptions struct {
	// placeholder for future optional parameters
}

// AssetsClientUpdateOptions contains the optional parameters for the AssetsClient.Update method.
type AssetsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AsyncOperationResult - The status of an async operation.
type AsyncOperationResult struct {
	// The error object
	Error *ErrorDetail `json:"error,omitempty"`

	// Operation Id of the async operation.
	Name *string `json:"name,omitempty"`

	// Operation status of the async operation.
	Status *AsyncOperationStatus `json:"status,omitempty"`
}

// AudioClassification provides polymorphic access to related types.
// Call the interface's GetAudio() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AacAudio, *Audio
type AudioClassification interface {
	CodecClassification
	// GetAudio returns the Audio content of the underlying type.
	GetAudio() *Audio
}

// Audio - Defines the common properties for all audio codecs.
type Audio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32 `json:"bitrate,omitempty"`

	// The number of channels in the audio.
	Channels *int32 `json:"channels,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// The sampling rate to use for encoding in hertz.
	SamplingRate *int32 `json:"samplingRate,omitempty"`
}

// GetAudio implements the AudioClassification interface for type Audio.
func (a *Audio) GetAudio() *Audio { return a }

// GetCodec implements the CodecClassification interface for type Audio.
func (a *Audio) GetCodec() *Codec {
	return &Codec{
		ODataType: a.ODataType,
		Label:     a.Label,
	}
}

// AudioAnalyzerPresetClassification provides polymorphic access to related types.
// Call the interface's GetAudioAnalyzerPreset() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioAnalyzerPreset, *VideoAnalyzerPreset
type AudioAnalyzerPresetClassification interface {
	PresetClassification
	// GetAudioAnalyzerPreset returns the AudioAnalyzerPreset content of the underlying type.
	GetAudioAnalyzerPreset() *AudioAnalyzerPreset
}

// AudioAnalyzerPreset - The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech
// transcription. Currently, the preset supports processing of content with a single audio track.
type AudioAnalyzerPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). If you
	// know the language of your content, it is recommended that you specify it. The
	// language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included
	// in basic mode. If the language isn't specified or set to null, automatic language
	// detection will choose the first language detected and process with the selected language for the duration of the file.
	// It does not currently support dynamically switching between languages after the
	// first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If
	// automatic detection fails to find the language, transcription would fallback to
	// 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
	AudioLanguage *string `json:"audioLanguage,omitempty"`

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string `json:"experimentalOptions,omitempty"`

	// Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be
	// chosen.
	Mode *AudioAnalysisMode `json:"mode,omitempty"`
}

// GetAudioAnalyzerPreset implements the AudioAnalyzerPresetClassification interface for type AudioAnalyzerPreset.
func (a *AudioAnalyzerPreset) GetAudioAnalyzerPreset() *AudioAnalyzerPreset { return a }

// GetPreset implements the PresetClassification interface for type AudioAnalyzerPreset.
func (a *AudioAnalyzerPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: a.ODataType,
	}
}

// AudioOverlay - Describes the properties of an audio overlay.
type AudioOverlay struct {
	// REQUIRED; The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can
	// specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV,
	// MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video
	// file formats.
	InputLabel *string `json:"inputLabel,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64 `json:"audioGainLevel,omitempty"`

	// The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format.
	// For example, PT30S to end the overlay at 30 seconds into the input video. If not
	// specified or the value is greater than the input video duration, the overlay will be applied until the end of the input
	// video if the overlay media duration is greater than the input video duration,
	// else the overlay will last as long as the overlay media duration.
	End *string `json:"end,omitempty"`

	// The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If
	// not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string `json:"fadeInDuration,omitempty"`

	// The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not
	// specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string `json:"fadeOutDuration,omitempty"`

	// The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format.
	// For example, PT05S to start the overlay at 5 seconds into the input video.
	// If not specified the overlay starts from the beginning of the input video.
	Start *string `json:"start,omitempty"`
}

// GetOverlay implements the OverlayClassification interface for type AudioOverlay.
func (a *AudioOverlay) GetOverlay() *Overlay {
	return &Overlay{
		ODataType:       a.ODataType,
		InputLabel:      a.InputLabel,
		Start:           a.Start,
		End:             a.End,
		FadeInDuration:  a.FadeInDuration,
		FadeOutDuration: a.FadeOutDuration,
		AudioGainLevel:  a.AudioGainLevel,
	}
}

// AudioTrack - Represents an audio track in the asset.
type AudioTrack struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The DASH specific setting for the audio track.
	DashSettings *DashSettings `json:"dashSettings,omitempty"`

	// The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
	DisplayName *string `json:"displayName,omitempty"`

	// The file name to the source file. This file is located in the storage container of the asset.
	FileName *string `json:"fileName,omitempty"`

	// The HLS specific setting for the audio track.
	HlsSettings *HlsSettings `json:"hlsSettings,omitempty"`

	// The RFC5646 language code for the audio track.
	LanguageCode *string `json:"languageCode,omitempty"`

	// The MPEG-4 audio track ID for the audio track.
	Mpeg4TrackID *int32 `json:"mpeg4TrackId,omitempty"`

	// READ-ONLY; The stream bit rate for the audio track.
	BitRate *int32 `json:"bitRate,omitempty" azure:"ro"`
}

// GetTrackBase implements the TrackBaseClassification interface for type AudioTrack.
func (a *AudioTrack) GetTrackBase() *TrackBase {
	return &TrackBase{
		ODataType: a.ODataType,
	}
}

// AudioTrackDescriptorClassification provides polymorphic access to related types.
// Call the interface's GetAudioTrackDescriptor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioTrackDescriptor, *SelectAudioTrackByAttribute, *SelectAudioTrackByID
type AudioTrackDescriptorClassification interface {
	TrackDescriptorClassification
	// GetAudioTrackDescriptor returns the AudioTrackDescriptor content of the underlying type.
	GetAudioTrackDescriptor() *AudioTrackDescriptor
}

// AudioTrackDescriptor - A TrackSelection to select audio tracks.
type AudioTrackDescriptor struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or multi-channel audio
	// tracks.
	ChannelMapping *ChannelMapping `json:"channelMapping,omitempty"`
}

// GetAudioTrackDescriptor implements the AudioTrackDescriptorClassification interface for type AudioTrackDescriptor.
func (a *AudioTrackDescriptor) GetAudioTrackDescriptor() *AudioTrackDescriptor { return a }

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type AudioTrackDescriptor.
func (a *AudioTrackDescriptor) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: a.ODataType,
	}
}

// BuiltInStandardEncoderPreset - Describes a built-in preset for encoding the input video with the Standard Encoder.
type BuiltInStandardEncoderPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The built-in preset to be used for encoding videos.
	PresetName *EncoderNamedPreset `json:"presetName,omitempty"`

	// Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding
	// BuiltInStandardEncoderPreset.
	Configurations *PresetConfigurations `json:"configurations,omitempty"`
}

// GetPreset implements the PresetClassification interface for type BuiltInStandardEncoderPreset.
func (b *BuiltInStandardEncoderPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: b.ODataType,
	}
}

// CbcsDrmConfiguration - Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
type CbcsDrmConfiguration struct {
	// FairPlay configurations
	FairPlay *StreamingPolicyFairPlayConfiguration `json:"fairPlay,omitempty"`

	// PlayReady configurations
	PlayReady *StreamingPolicyPlayReadyConfiguration `json:"playReady,omitempty"`

	// Widevine configurations
	Widevine *StreamingPolicyWidevineConfiguration `json:"widevine,omitempty"`
}

// CencDrmConfiguration - Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
type CencDrmConfiguration struct {
	// PlayReady configurations
	PlayReady *StreamingPolicyPlayReadyConfiguration `json:"playReady,omitempty"`

	// Widevine configurations
	Widevine *StreamingPolicyWidevineConfiguration `json:"widevine,omitempty"`
}

// CheckNameAvailabilityInput - The input to the check name availability request.
type CheckNameAvailabilityInput struct {
	// The account name.
	Name *string `json:"name,omitempty"`

	// The account type. For a Media Services account, this should be 'MediaServices'.
	Type *string `json:"type,omitempty"`
}

// ClearKeyEncryptionConfiguration - Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
type ClearKeyEncryptionConfiguration struct {
	// Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that
	// the service will update at runtime with the value specific to the request. The currently supported token value is {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId.
	CustomKeysAcquisitionURLTemplate *string `json:"customKeysAcquisitionUrlTemplate,omitempty"`
}

// ClientBeginCreateOrUpdateOptions contains the optional parameters for the Client.BeginCreateOrUpdate method.
type ClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginUpdateOptions contains the optional parameters for the Client.BeginUpdate method.
type ClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientDeleteOptions contains the optional parameters for the Client.Delete method.
type ClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListBySubscriptionOptions contains the optional parameters for the Client.ListBySubscription method.
type ClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ClientListEdgePoliciesOptions contains the optional parameters for the Client.ListEdgePolicies method.
type ClientListEdgePoliciesOptions struct {
	// placeholder for future optional parameters
}

// ClientListOptions contains the optional parameters for the Client.List method.
type ClientListOptions struct {
	// placeholder for future optional parameters
}

// ClientSyncStorageKeysOptions contains the optional parameters for the Client.SyncStorageKeys method.
type ClientSyncStorageKeysOptions struct {
	// placeholder for future optional parameters
}

// ClipTimeClassification provides polymorphic access to related types.
// Call the interface's GetClipTime() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AbsoluteClipTime, *ClipTime, *UTCClipTime
type ClipTimeClassification interface {
	// GetClipTime returns the ClipTime content of the underlying type.
	GetClipTime() *ClipTime
}

// ClipTime - Base class for specifying a clip time. Use sub classes of this class to specify the time position in the media.
type ClipTime struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetClipTime implements the ClipTimeClassification interface for type ClipTime.
func (c *ClipTime) GetClipTime() *ClipTime { return c }

// CodecClassification provides polymorphic access to related types.
// Call the interface's GetCodec() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AacAudio, *Audio, *Codec, *CopyAudio, *CopyVideo, *H264Video, *H265Video, *Image, *JpgImage, *PNGImage, *Video
type CodecClassification interface {
	// GetCodec returns the Codec content of the underlying type.
	GetCodec() *Codec
}

// Codec - Describes the basic properties of all codecs.
type Codec struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
}

// GetCodec implements the CodecClassification interface for type Codec.
func (c *Codec) GetCodec() *Codec { return c }

// CommonEncryptionCbcs - Class for CommonEncryptionCbcs encryption scheme
type CommonEncryptionCbcs struct {
	// Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
	ClearKeyEncryptionConfiguration *ClearKeyEncryptionConfiguration `json:"clearKeyEncryptionConfiguration,omitempty"`

	// Representing which tracks should not be encrypted
	ClearTracks []*TrackSelection `json:"clearTracks,omitempty"`

	// Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys `json:"contentKeys,omitempty"`

	// Configuration of DRMs for current encryption scheme
	Drm *CbcsDrmConfiguration `json:"drm,omitempty"`

	// Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
}

// CommonEncryptionCenc - Class for envelope encryption scheme
type CommonEncryptionCenc struct {
	// Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
	ClearKeyEncryptionConfiguration *ClearKeyEncryptionConfiguration `json:"clearKeyEncryptionConfiguration,omitempty"`

	// Representing which tracks should not be encrypted
	ClearTracks []*TrackSelection `json:"clearTracks,omitempty"`

	// Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys `json:"contentKeys,omitempty"`

	// Configuration of DRMs for CommonEncryptionCenc encryption scheme
	Drm *CencDrmConfiguration `json:"drm,omitempty"`

	// Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
}

// ContentKeyPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ContentKeyPoliciesClient.CreateOrUpdate
// method.
type ContentKeyPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ContentKeyPoliciesClientDeleteOptions contains the optional parameters for the ContentKeyPoliciesClient.Delete method.
type ContentKeyPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContentKeyPoliciesClientGetOptions contains the optional parameters for the ContentKeyPoliciesClient.Get method.
type ContentKeyPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContentKeyPoliciesClientGetPolicyPropertiesWithSecretsOptions contains the optional parameters for the ContentKeyPoliciesClient.GetPolicyPropertiesWithSecrets
// method.
type ContentKeyPoliciesClientGetPolicyPropertiesWithSecretsOptions struct {
	// placeholder for future optional parameters
}

// ContentKeyPoliciesClientListOptions contains the optional parameters for the ContentKeyPoliciesClient.List method.
type ContentKeyPoliciesClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies the key by which the result collection should be ordered.
	Orderby *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// ContentKeyPoliciesClientUpdateOptions contains the optional parameters for the ContentKeyPoliciesClient.Update method.
type ContentKeyPoliciesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ContentKeyPolicy - A Content Key Policy resource.
type ContentKeyPolicy struct {
	// The properties of the Content Key Policy.
	Properties *ContentKeyPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContentKeyPolicyClearKeyConfiguration - Represents a configuration for non-DRM keys.
type ContentKeyPolicyClearKeyConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyClearKeyConfiguration.
func (c *ContentKeyPolicyClearKeyConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyCollection - A collection of ContentKeyPolicy items.
type ContentKeyPolicyCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of ContentKeyPolicy items.
	Value []*ContentKeyPolicy `json:"value,omitempty"`
}

// ContentKeyPolicyConfigurationClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyConfiguration() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyClearKeyConfiguration, *ContentKeyPolicyConfiguration, *ContentKeyPolicyFairPlayConfiguration, *ContentKeyPolicyPlayReadyConfiguration,
// - *ContentKeyPolicyUnknownConfiguration, *ContentKeyPolicyWidevineConfiguration
type ContentKeyPolicyConfigurationClassification interface {
	// GetContentKeyPolicyConfiguration returns the ContentKeyPolicyConfiguration content of the underlying type.
	GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration
}

// ContentKeyPolicyConfiguration - Base class for Content Key Policy configuration. A derived class must be used to create
// a configuration.
type ContentKeyPolicyConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyConfiguration.
func (c *ContentKeyPolicyConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return c
}

// ContentKeyPolicyFairPlayConfiguration - Specifies a configuration for FairPlay licenses.
type ContentKeyPolicyFairPlayConfiguration struct {
	// REQUIRED; The key that must be used as FairPlay Application Secret key.
	Ask []byte `json:"ask,omitempty"`

	// REQUIRED; The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
	FairPlayPfx *string `json:"fairPlayPfx,omitempty"`

	// REQUIRED; The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
	FairPlayPfxPassword *string `json:"fairPlayPfxPassword,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The rental and lease key type.
	RentalAndLeaseKeyType *ContentKeyPolicyFairPlayRentalAndLeaseKeyType `json:"rentalAndLeaseKeyType,omitempty"`

	// REQUIRED; The rental duration. Must be greater than or equal to 0.
	RentalDuration *int64 `json:"rentalDuration,omitempty"`

	// Offline rental policy
	OfflineRentalConfiguration *ContentKeyPolicyFairPlayOfflineRentalConfiguration `json:"offlineRentalConfiguration,omitempty"`
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyFairPlayConfiguration.
func (c *ContentKeyPolicyFairPlayConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

type ContentKeyPolicyFairPlayOfflineRentalConfiguration struct {
	// REQUIRED; Playback duration
	PlaybackDurationSeconds *int64 `json:"playbackDurationSeconds,omitempty"`

	// REQUIRED; Storage duration
	StorageDurationSeconds *int64 `json:"storageDurationSeconds,omitempty"`
}

// ContentKeyPolicyOpenRestriction - Represents an open restriction. License or key will be delivered on every request.
type ContentKeyPolicyOpenRestriction struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyOpenRestriction.
func (c *ContentKeyPolicyOpenRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return &ContentKeyPolicyRestriction{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyOption - Represents a policy option.
type ContentKeyPolicyOption struct {
	// REQUIRED; The key delivery configuration.
	Configuration ContentKeyPolicyConfigurationClassification `json:"configuration,omitempty"`

	// REQUIRED; The requirements that must be met to deliver keys with this configuration
	Restriction ContentKeyPolicyRestrictionClassification `json:"restriction,omitempty"`

	// The Policy Option description.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The legacy Policy Option ID.
	PolicyOptionID *string `json:"policyOptionId,omitempty" azure:"ro"`
}

// ContentKeyPolicyPlayReadyConfiguration - Specifies a configuration for PlayReady licenses.
type ContentKeyPolicyPlayReadyConfiguration struct {
	// REQUIRED; The PlayReady licenses.
	Licenses []*ContentKeyPolicyPlayReadyLicense `json:"licenses,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The custom response data.
	ResponseCustomData *string `json:"responseCustomData,omitempty"`
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyPlayReadyConfiguration.
func (c *ContentKeyPolicyPlayReadyConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader - Specifies that the content key ID is in the PlayReady header.
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyPlayReadyContentKeyLocation implements the ContentKeyPolicyPlayReadyContentKeyLocationClassification
// interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (c *ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation {
	return &ContentKeyPolicyPlayReadyContentKeyLocation{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier - Specifies that the content key ID is specified in the
// PlayReady configuration.
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier struct {
	// REQUIRED; The content key ID.
	KeyID *string `json:"keyId,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyPlayReadyContentKeyLocation implements the ContentKeyPolicyPlayReadyContentKeyLocationClassification
// interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (c *ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation {
	return &ContentKeyPolicyPlayReadyContentKeyLocation{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyPlayReadyContentKeyLocationClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyPlayReadyContentKeyLocation() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, *ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier,
// - *ContentKeyPolicyPlayReadyContentKeyLocation
type ContentKeyPolicyPlayReadyContentKeyLocationClassification interface {
	// GetContentKeyPolicyPlayReadyContentKeyLocation returns the ContentKeyPolicyPlayReadyContentKeyLocation content of the underlying type.
	GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation
}

// ContentKeyPolicyPlayReadyContentKeyLocation - Base class for content key ID location. A derived class must be used to represent
// the location.
type ContentKeyPolicyPlayReadyContentKeyLocation struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyPlayReadyContentKeyLocation implements the ContentKeyPolicyPlayReadyContentKeyLocationClassification
// interface for type ContentKeyPolicyPlayReadyContentKeyLocation.
func (c *ContentKeyPolicyPlayReadyContentKeyLocation) GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation {
	return c
}

// ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction - Configures the Explicit Analog Television Output Restriction
// control bits. For further details see the PlayReady Compliance Rules.
type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction struct {
	// REQUIRED; Indicates whether this restriction is enforced on a Best Effort basis.
	BestEffort *bool `json:"bestEffort,omitempty"`

	// REQUIRED; Configures the restriction control bits. Must be between 0 and 3 inclusive.
	ConfigurationData *int32 `json:"configurationData,omitempty"`
}

// ContentKeyPolicyPlayReadyLicense - The PlayReady license
type ContentKeyPolicyPlayReadyLicense struct {
	// REQUIRED; A flag indicating whether test devices can use the license.
	AllowTestDevices *bool `json:"allowTestDevices,omitempty"`

	// REQUIRED; The content key location.
	ContentKeyLocation ContentKeyPolicyPlayReadyContentKeyLocationClassification `json:"contentKeyLocation,omitempty"`

	// REQUIRED; The PlayReady content type.
	ContentType *ContentKeyPolicyPlayReadyContentType `json:"contentType,omitempty"`

	// REQUIRED; The license type.
	LicenseType *ContentKeyPolicyPlayReadyLicenseType `json:"licenseType,omitempty"`

	// The begin date of license
	BeginDate *time.Time `json:"beginDate,omitempty"`

	// The expiration date of license.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// The grace period of license.
	GracePeriod *string `json:"gracePeriod,omitempty"`

	// The license PlayRight
	PlayRight *ContentKeyPolicyPlayReadyPlayRight `json:"playRight,omitempty"`

	// The relative begin date of license.
	RelativeBeginDate *string `json:"relativeBeginDate,omitempty"`

	// The relative expiration date of license.
	RelativeExpirationDate *string `json:"relativeExpirationDate,omitempty"`

	// The security level.
	SecurityLevel *SecurityLevel `json:"securityLevel,omitempty"`
}

// ContentKeyPolicyPlayReadyPlayRight - Configures the Play Right in the PlayReady license.
type ContentKeyPolicyPlayReadyPlayRight struct {
	// REQUIRED; Configures Unknown output handling settings of the license.
	AllowPassingVideoContentToUnknownOutput *ContentKeyPolicyPlayReadyUnknownOutputPassingOption `json:"allowPassingVideoContentToUnknownOutput,omitempty"`

	// REQUIRED; Enables the Image Constraint For Analog Component Video Restriction in the license.
	DigitalVideoOnlyContentRestriction *bool `json:"digitalVideoOnlyContentRestriction,omitempty"`

	// REQUIRED; Enables the Image Constraint For Analog Component Video Restriction in the license.
	ImageConstraintForAnalogComponentVideoRestriction *bool `json:"imageConstraintForAnalogComponentVideoRestriction,omitempty"`

	// REQUIRED; Enables the Image Constraint For Analog Component Video Restriction in the license.
	ImageConstraintForAnalogComputerMonitorRestriction *bool `json:"imageConstraintForAnalogComputerMonitorRestriction,omitempty"`

	// Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
	AgcAndColorStripeRestriction *int32 `json:"agcAndColorStripeRestriction,omitempty"`

	// Specifies the output protection level for compressed digital audio.
	AnalogVideoOpl *int32 `json:"analogVideoOpl,omitempty"`

	// Specifies the output protection level for compressed digital audio.
	CompressedDigitalAudioOpl *int32 `json:"compressedDigitalAudioOpl,omitempty"`

	// Specifies the output protection level for compressed digital video.
	CompressedDigitalVideoOpl *int32 `json:"compressedDigitalVideoOpl,omitempty"`

	// Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3
	// inclusive.
	ExplicitAnalogTelevisionOutputRestriction *ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction `json:"explicitAnalogTelevisionOutputRestriction,omitempty"`

	// The amount of time that the license is valid after the license is first used to play content.
	FirstPlayExpiration *string `json:"firstPlayExpiration,omitempty"`

	// Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
	ScmsRestriction *int32 `json:"scmsRestriction,omitempty"`

	// Specifies the output protection level for uncompressed digital audio.
	UncompressedDigitalAudioOpl *int32 `json:"uncompressedDigitalAudioOpl,omitempty"`

	// Specifies the output protection level for uncompressed digital video.
	UncompressedDigitalVideoOpl *int32 `json:"uncompressedDigitalVideoOpl,omitempty"`
}

// ContentKeyPolicyProperties - The properties of the Content Key Policy.
type ContentKeyPolicyProperties struct {
	// REQUIRED; The Key Policy options.
	Options []*ContentKeyPolicyOption `json:"options,omitempty"`

	// A description for the Policy.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The creation date of the Policy
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The last modified date of the Policy
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The legacy Policy ID.
	PolicyID *string `json:"policyId,omitempty" azure:"ro"`
}

// ContentKeyPolicyRestrictionClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyRestriction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyOpenRestriction, *ContentKeyPolicyRestriction, *ContentKeyPolicyTokenRestriction, *ContentKeyPolicyUnknownRestriction
type ContentKeyPolicyRestrictionClassification interface {
	// GetContentKeyPolicyRestriction returns the ContentKeyPolicyRestriction content of the underlying type.
	GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction
}

// ContentKeyPolicyRestriction - Base class for Content Key Policy restrictions. A derived class must be used to create a
// restriction.
type ContentKeyPolicyRestriction struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyRestriction.
func (c *ContentKeyPolicyRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return c
}

// ContentKeyPolicyRestrictionTokenKeyClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyRestrictionTokenKey() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyRestrictionTokenKey, *ContentKeyPolicyRsaTokenKey, *ContentKeyPolicySymmetricTokenKey, *ContentKeyPolicyX509CertificateTokenKey
type ContentKeyPolicyRestrictionTokenKeyClassification interface {
	// GetContentKeyPolicyRestrictionTokenKey returns the ContentKeyPolicyRestrictionTokenKey content of the underlying type.
	GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey
}

// ContentKeyPolicyRestrictionTokenKey - Base class for Content Key Policy key for token validation. A derived class must
// be used to create a token key.
type ContentKeyPolicyRestrictionTokenKey struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicyRestrictionTokenKey.
func (c *ContentKeyPolicyRestrictionTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return c
}

// ContentKeyPolicyRsaTokenKey - Specifies a RSA key for token validation
type ContentKeyPolicyRsaTokenKey struct {
	// REQUIRED; The RSA Parameter exponent
	Exponent []byte `json:"exponent,omitempty"`

	// REQUIRED; The RSA Parameter modulus
	Modulus []byte `json:"modulus,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicyRsaTokenKey.
func (c *ContentKeyPolicyRsaTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return &ContentKeyPolicyRestrictionTokenKey{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicySymmetricTokenKey - Specifies a symmetric key for token validation.
type ContentKeyPolicySymmetricTokenKey struct {
	// REQUIRED; The key value of the key
	KeyValue []byte `json:"keyValue,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicySymmetricTokenKey.
func (c *ContentKeyPolicySymmetricTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return &ContentKeyPolicyRestrictionTokenKey{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyTokenClaim - Represents a token claim.
type ContentKeyPolicyTokenClaim struct {
	// Token claim type.
	ClaimType *string `json:"claimType,omitempty"`

	// Token claim value.
	ClaimValue *string `json:"claimValue,omitempty"`
}

// ContentKeyPolicyTokenRestriction - Represents a token restriction. Provided token must match these requirements for successful
// license or key delivery.
type ContentKeyPolicyTokenRestriction struct {
	// REQUIRED; The audience for the token.
	Audience *string `json:"audience,omitempty"`

	// REQUIRED; The token issuer.
	Issuer *string `json:"issuer,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The primary verification key.
	PrimaryVerificationKey ContentKeyPolicyRestrictionTokenKeyClassification `json:"primaryVerificationKey,omitempty"`

	// REQUIRED; The type of token.
	RestrictionTokenType *ContentKeyPolicyRestrictionTokenType `json:"restrictionTokenType,omitempty"`

	// A list of alternative verification keys.
	AlternateVerificationKeys []ContentKeyPolicyRestrictionTokenKeyClassification `json:"alternateVerificationKeys,omitempty"`

	// The OpenID connect discovery document.
	OpenIDConnectDiscoveryDocument *string `json:"openIdConnectDiscoveryDocument,omitempty"`

	// A list of required token claims.
	RequiredClaims []*ContentKeyPolicyTokenClaim `json:"requiredClaims,omitempty"`
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyTokenRestriction.
func (c *ContentKeyPolicyTokenRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return &ContentKeyPolicyRestriction{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyUnknownConfiguration - Represents a ContentKeyPolicyConfiguration that is unavailable in the current API
// version.
type ContentKeyPolicyUnknownConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyUnknownConfiguration.
func (c *ContentKeyPolicyUnknownConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyUnknownRestriction - Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
type ContentKeyPolicyUnknownRestriction struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyUnknownRestriction.
func (c *ContentKeyPolicyUnknownRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return &ContentKeyPolicyRestriction{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyWidevineConfiguration - Specifies a configuration for Widevine licenses.
type ContentKeyPolicyWidevineConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The Widevine template.
	WidevineTemplate *string `json:"widevineTemplate,omitempty"`
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyWidevineConfiguration.
func (c *ContentKeyPolicyWidevineConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyX509CertificateTokenKey - Specifies a certificate for token validation.
type ContentKeyPolicyX509CertificateTokenKey struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
	RawBody []byte `json:"rawBody,omitempty"`
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicyX509CertificateTokenKey.
func (c *ContentKeyPolicyX509CertificateTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return &ContentKeyPolicyRestrictionTokenKey{
		ODataType: c.ODataType,
	}
}

// CopyAudio - A codec flag, which tells the encoder to copy the input audio bitstream.
type CopyAudio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
}

// GetCodec implements the CodecClassification interface for type CopyAudio.
func (c *CopyAudio) GetCodec() *Codec {
	return &Codec{
		ODataType: c.ODataType,
		Label:     c.Label,
	}
}

// CopyVideo - A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
type CopyVideo struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
}

// GetCodec implements the CodecClassification interface for type CopyVideo.
func (c *CopyVideo) GetCodec() *Codec {
	return &Codec{
		ODataType: c.ODataType,
		Label:     c.Label,
	}
}

// CrossSiteAccessPolicies - The client access policy.
type CrossSiteAccessPolicies struct {
	// The content of clientaccesspolicy.xml used by Silverlight.
	ClientAccessPolicy *string `json:"clientAccessPolicy,omitempty"`

	// The content of crossdomain.xml used by Silverlight.
	CrossDomainPolicy *string `json:"crossDomainPolicy,omitempty"`
}

// DashSettings - The DASH setting for a track.
type DashSettings struct {
	// The role for the DASH setting.
	Role *string `json:"role,omitempty"`
}

// DefaultKey - Class to specify properties of default content key for each encryption scheme
type DefaultKey struct {
	// Label can be used to specify Content Key when creating a Streaming Locator
	Label *string `json:"label,omitempty"`

	// Policy used by Default Key
	PolicyName *string `json:"policyName,omitempty"`
}

// Deinterlace - Describes the de-interlacing settings.
type Deinterlace struct {
	// The deinterlacing mode. Defaults to AutoPixelAdaptive.
	Mode *DeinterlaceMode `json:"mode,omitempty"`

	// The field parity for de-interlacing, defaults to Auto.
	Parity *DeinterlaceParity `json:"parity,omitempty"`
}

type EdgePolicies struct {
	UsageDataCollectionPolicy *EdgeUsageDataCollectionPolicy `json:"usageDataCollectionPolicy,omitempty"`
}

type EdgeUsageDataCollectionPolicy struct {
	// Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H.
	DataCollectionFrequency *string `json:"dataCollectionFrequency,omitempty"`

	// Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H.
	DataReportingFrequency *string `json:"dataReportingFrequency,omitempty"`

	// Details of Event Hub where the usage will be reported.
	EventHubDetails *EdgeUsageDataEventHub `json:"eventHubDetails,omitempty"`

	// Maximum time for which the functionality of the device will not be hampered for not reporting the usage data.
	MaxAllowedUnreportedUsageDuration *string `json:"maxAllowedUnreportedUsageDuration,omitempty"`
}

type EdgeUsageDataEventHub struct {
	// Name of the Event Hub where usage will be reported.
	Name *string `json:"name,omitempty"`

	// Namespace of the Event Hub where usage will be reported.
	Namespace *string `json:"namespace,omitempty"`

	// SAS token needed to interact with Event Hub.
	Token *string `json:"token,omitempty"`
}

// EnabledProtocols - Class to specify which protocols are enabled
type EnabledProtocols struct {
	// REQUIRED; Enable DASH protocol or not
	Dash *bool `json:"dash,omitempty"`

	// REQUIRED; Enable Download protocol or not
	Download *bool `json:"download,omitempty"`

	// REQUIRED; Enable HLS protocol or not
	Hls *bool `json:"hls,omitempty"`

	// REQUIRED; Enable SmoothStreaming protocol or not
	SmoothStreaming *bool `json:"smoothStreaming,omitempty"`
}

// EntityNameAvailabilityCheckOutput - The response from the check name availability request.
type EntityNameAvailabilityCheckOutput struct {
	// REQUIRED; Specifies if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Specifies the detailed reason if the name is not available.
	Message *string `json:"message,omitempty"`

	// Specifies the reason if the name is not available.
	Reason *string `json:"reason,omitempty"`
}

// EnvelopeEncryption - Class for EnvelopeEncryption encryption scheme
type EnvelopeEncryption struct {
	// Representing which tracks should not be encrypted
	ClearTracks []*TrackSelection `json:"clearTracks,omitempty"`

	// Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys `json:"contentKeys,omitempty"`

	// Template for the URL of the custom service delivering keys to end user players. Not required when using Azure Media Services
	// for issuing keys. The template supports replaceable tokens that the service
	// will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of StreamingLocatorId.AlternativeMediaId,
	// and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
	CustomKeyAcquisitionURLTemplate *string `json:"customKeyAcquisitionUrlTemplate,omitempty"`

	// Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FaceDetectorPreset - Describes all the settings to be used when analyzing a video in order to detect (and optionally redact)
// all the faces present.
type FaceDetectorPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Blur type
	BlurType *BlurType `json:"blurType,omitempty"`

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string `json:"experimentalOptions,omitempty"`

	// This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates
	// a metadata JSON file marking appearances of faces throughout the
	// video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs)
	// detected faces. 3) Redact - This enables a 2-pass process, allowing for
	// selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the
	// source video, and a user-selected subset of IDs that require redaction.
	Mode *FaceRedactorMode `json:"mode,omitempty"`

	// Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will
	// keep the input video at its original resolution when analyzed. Using
	// "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It
	// will only resize if the video is of higher resolution. For example, a 1920x1080
	// input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to
	// process high resolution video. It may also reduce the cost of using this
	// component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces
	// that end up being too small in the resized video may not be detected.
	Resolution *AnalysisResolution `json:"resolution,omitempty"`
}

// GetPreset implements the PresetClassification interface for type FaceDetectorPreset.
func (f *FaceDetectorPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: f.ODataType,
	}
}

// FilterTrackPropertyCondition - The class to specify one track property condition.
type FilterTrackPropertyCondition struct {
	// REQUIRED; The track property condition operation.
	Operation *FilterTrackPropertyCompareOperation `json:"operation,omitempty"`

	// REQUIRED; The track property type.
	Property *FilterTrackPropertyType `json:"property,omitempty"`

	// REQUIRED; The track property value.
	Value *string `json:"value,omitempty"`
}

// FilterTrackSelection - Representing a list of FilterTrackPropertyConditions to select a track. The filters are combined
// using a logical AND operation.
type FilterTrackSelection struct {
	// REQUIRED; The track selections.
	TrackSelections []*FilterTrackPropertyCondition `json:"trackSelections,omitempty"`
}

// Filters - Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input
// media before encoding.
type Filters struct {
	// The parameters for the rectangular window with which to crop the input video.
	Crop *Rectangle `json:"crop,omitempty"`

	// The de-interlacing settings.
	Deinterlace *Deinterlace `json:"deinterlace,omitempty"`

	// The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
	Overlays []OverlayClassification `json:"overlays,omitempty"`

	// The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
	Rotation *Rotation `json:"rotation,omitempty"`
}

// FirstQuality - Filter First Quality
type FirstQuality struct {
	// REQUIRED; The first quality bitrate.
	Bitrate *int32 `json:"bitrate,omitempty"`
}

// FormatClassification provides polymorphic access to related types.
// Call the interface's GetFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Format, *ImageFormat, *JpgFormat, *Mp4Format, *MultiBitrateFormat, *PNGFormat, *TransportStreamFormat
type FormatClassification interface {
	// GetFormat returns the Format content of the underlying type.
	GetFormat() *Format
}

// Format - Base class for output.
type Format struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetFormat implements the FormatClassification interface for type Format.
func (f *Format) GetFormat() *Format { return f }

// FromAllInputFile - An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks
// property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to
// allow selection of a single track across a set of input files.
type FromAllInputFile struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification `json:"includedTracks,omitempty"`
}

// GetInputDefinition implements the InputDefinitionClassification interface for type FromAllInputFile.
func (f *FromAllInputFile) GetInputDefinition() *InputDefinition {
	return &InputDefinition{
		ODataType:      f.ODataType,
		IncludedTracks: f.IncludedTracks,
	}
}

// FromEachInputFile - An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks
// property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select
// tracks from each file given.
type FromEachInputFile struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification `json:"includedTracks,omitempty"`
}

// GetInputDefinition implements the InputDefinitionClassification interface for type FromEachInputFile.
func (f *FromEachInputFile) GetInputDefinition() *InputDefinition {
	return &InputDefinition{
		ODataType:      f.ODataType,
		IncludedTracks: f.IncludedTracks,
	}
}

// H264Layer - Describes the settings to be used when encoding the input video into a desired output bitrate layer with the
// H.264 video codec.
type H264Layer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. This is
	// a required field.
	Bitrate *int32 `json:"bitrate,omitempty"`

	// Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on
	// whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`

	// The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds.
	// The default is 5 seconds (for example, PT5S).
	BufferWindow *string `json:"bufferWindow,omitempty"`

	// The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is
	// set at CRF mode. The range of CRF value is between 0 and 51, where lower values
	// would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point
	// quality degradation will be noticed. Default value is 23.
	Crf *float32 `json:"crf,omitempty"`

	// The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the
	// profile and level.
	EntropyMode *EntropyMode `json:"entropyMode,omitempty"`

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified,
	// the default is Auto, which lets the encoder choose the Level that is
	// appropriate for this layer.
	Level *string `json:"level,omitempty"`

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`

	// We currently support Baseline, Main, High, High422, High444. Default is Auto.
	Profile *H264VideoProfile `json:"profile,omitempty"`

	// The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate
	// number based on the encoder complexity setting.
	ReferenceFrames *int32 `json:"referenceFrames,omitempty"`

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

// H264Video - Describes all the properties for encoding a video with the H.264 codec.
type H264Video struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Tells the encoder how to choose its encoding settings. The default value is Balanced.
	Complexity *H264Complexity `json:"complexity,omitempty"`

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// The collection of output H.264 layers to be produced by the encoder.
	Layers []*H264Layer `json:"layers,omitempty"`

	// The video rate control mode
	RateControlMode *H264RateControlMode `json:"rateControlMode,omitempty"`

	// Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag
	// should be set to true only when the encoder is being configured to produce a
	// single output video.
	SceneChangeDetection *bool `json:"sceneChangeDetection,omitempty"`

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode `json:"stretchMode,omitempty"`

	// The Video Sync Mode
	SyncMode *VideoSyncMode `json:"syncMode,omitempty"`
}

// GetCodec implements the CodecClassification interface for type H264Video.
func (h *H264Video) GetCodec() *Codec {
	return &Codec{
		ODataType: h.ODataType,
		Label:     h.Label,
	}
}

// GetVideo implements the VideoClassification interface for type H264Video.
func (h *H264Video) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: h.KeyFrameInterval,
		StretchMode:      h.StretchMode,
		SyncMode:         h.SyncMode,
		ODataType:        h.ODataType,
		Label:            h.Label,
	}
}

// H265Layer - Describes the settings to be used when encoding the input video into a desired output bitrate layer with the
// H.265 video codec.
type H265Layer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. For example:
	// a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a
	// required field.
	Bitrate *int32 `json:"bitrate,omitempty"`

	// Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will
	// turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`

	// The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds.
	// The default is 5 seconds (for example, PT5S).
	BufferWindow *string `json:"bufferWindow,omitempty"`

	// The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is
	// set at CRF mode. The range of CRF value is between 0 and 51, where lower values
	// would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point
	// quality degradation will be noticed. Default value is 28.
	Crf *float32 `json:"crf,omitempty"`

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified,
	// the default is Auto, which lets the encoder choose the Level that is
	// appropriate for this layer.
	Level *string `json:"level,omitempty"`

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`

	// We currently support Main. Default is Auto.
	Profile *H265VideoProfile `json:"profile,omitempty"`

	// The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate
	// number based on the encoder complexity setting.
	ReferenceFrames *int32 `json:"referenceFrames,omitempty"`

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

// H265Video - Describes all the properties for encoding a video with the H.265 codec.
type H265Video struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Tells the encoder how to choose its encoding settings. Quality will provide for a higher compression ratio but at a higher
	// cost and longer compute time. Speed will produce a relatively larger file but
	// is faster and more economical. The default value is Balanced.
	Complexity *H265Complexity `json:"complexity,omitempty"`

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// The collection of output H.265 layers to be produced by the encoder.
	Layers []*H265Layer `json:"layers,omitempty"`

	// Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false.
	// This flag should be set to true only when the encoder is being configured to
	// produce a single output video.
	SceneChangeDetection *bool `json:"sceneChangeDetection,omitempty"`

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode `json:"stretchMode,omitempty"`

	// The Video Sync Mode
	SyncMode *VideoSyncMode `json:"syncMode,omitempty"`
}

// GetCodec implements the CodecClassification interface for type H265Video.
func (h *H265Video) GetCodec() *Codec {
	return &Codec{
		ODataType: h.ODataType,
		Label:     h.Label,
	}
}

// GetVideo implements the VideoClassification interface for type H265Video.
func (h *H265Video) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: h.KeyFrameInterval,
		StretchMode:      h.StretchMode,
		SyncMode:         h.SyncMode,
		ODataType:        h.ODataType,
		Label:            h.Label,
	}
}

// H265VideoLayer - Describes the settings to be used when encoding the input video into a desired output bitrate layer.
type H265VideoLayer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. For example:
	// a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a
	// required field.
	Bitrate *int32 `json:"bitrate,omitempty"`

	// Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will
	// turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

// Hls - HTTP Live Streaming (HLS) packing setting for the live output.
type Hls struct {
	// The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not
	// affect the packing ratio for HLS CMAF output.
	FragmentsPerTsSegment *int32 `json:"fragmentsPerTsSegment,omitempty"`
}

// HlsSettings - The HLS setting for a track.
type HlsSettings struct {
	// The characteristics for the HLS setting.
	Characteristics *string `json:"characteristics,omitempty"`

	// The default for the HLS setting.
	Default *bool `json:"default,omitempty"`

	// The forced for the HLS setting.
	Forced *bool `json:"forced,omitempty"`
}

// IPAccessControl - The IP access control.
type IPAccessControl struct {
	// The IP allow list.
	Allow []*IPRange `json:"allow,omitempty"`
}

// IPRange - The IP address range in the CIDR scheme.
type IPRange struct {
	// The IP address.
	Address *string `json:"address,omitempty"`

	// The friendly name for the IP address range.
	Name *string `json:"name,omitempty"`

	// The subnet mask prefix length (see CIDR notation).
	SubnetPrefixLength *int32 `json:"subnetPrefixLength,omitempty"`
}

// ImageClassification provides polymorphic access to related types.
// Call the interface's GetImage() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Image, *JpgImage, *PNGImage
type ImageClassification interface {
	VideoClassification
	// GetImage returns the Image content of the underlying type.
	GetImage() *Image
}

// Image - Describes the basic properties for generating thumbnails from the input video
type Image struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format
	// (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at
	// the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports
	// a macro {Best}, which tells the encoder to select the best thumbnail from
	// the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and
	// Range. The default value is macro {Best}.
	Start *string `json:"start,omitempty"`

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value
	// can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30
	// seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If
	// this value is 1, it means only producing one thumbnail at start time), or a
	// relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default
	// value is 100%, which means to stop at the end of the stream.
	Range *string `json:"range,omitempty"`

	// The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image
	// every 5 seconds), or a frame count (For example, 30 for one image every 30
	// frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step
	// value will affect the first generated thumbnail, which may not be exactly the
	// one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between
	// start time and Step position from start time as the first output. As the
	// default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one
	// specified at start time. Try to select reasonable value for Step if the first
	// thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string `json:"step,omitempty"`

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode `json:"stretchMode,omitempty"`

	// The Video Sync Mode
	SyncMode *VideoSyncMode `json:"syncMode,omitempty"`
}

// GetCodec implements the CodecClassification interface for type Image.
func (i *Image) GetCodec() *Codec {
	return &Codec{
		ODataType: i.ODataType,
		Label:     i.Label,
	}
}

// GetImage implements the ImageClassification interface for type Image.
func (i *Image) GetImage() *Image { return i }

// GetVideo implements the VideoClassification interface for type Image.
func (i *Image) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: i.KeyFrameInterval,
		StretchMode:      i.StretchMode,
		SyncMode:         i.SyncMode,
		ODataType:        i.ODataType,
		Label:            i.Label,
	}
}

// ImageFormatClassification provides polymorphic access to related types.
// Call the interface's GetImageFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ImageFormat, *JpgFormat, *PNGFormat
type ImageFormatClassification interface {
	FormatClassification
	// GetImageFormat returns the ImageFormat content of the underlying type.
	GetImageFormat() *ImageFormat
}

// ImageFormat - Describes the properties for an output image file.
type ImageFormat struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetFormat implements the FormatClassification interface for type ImageFormat.
func (i *ImageFormat) GetFormat() *Format {
	return &Format{
		ODataType:       i.ODataType,
		FilenamePattern: i.FilenamePattern,
	}
}

// GetImageFormat implements the ImageFormatClassification interface for type ImageFormat.
func (i *ImageFormat) GetImageFormat() *ImageFormat { return i }

// InputDefinitionClassification provides polymorphic access to related types.
// Call the interface's GetInputDefinition() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FromAllInputFile, *FromEachInputFile, *InputDefinition, *InputFile
type InputDefinitionClassification interface {
	// GetInputDefinition returns the InputDefinition content of the underlying type.
	GetInputDefinition() *InputDefinition
}

// InputDefinition - Base class for defining an input. Use sub classes of this class to specify tracks selections and related
// metadata.
type InputDefinition struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification `json:"includedTracks,omitempty"`
}

// GetInputDefinition implements the InputDefinitionClassification interface for type InputDefinition.
func (i *InputDefinition) GetInputDefinition() *InputDefinition { return i }

// InputFile - An InputDefinition for a single file. TrackSelections are scoped to the file specified.
type InputFile struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Name of the file that this input definition applies to.
	Filename *string `json:"filename,omitempty"`

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification `json:"includedTracks,omitempty"`
}

// GetInputDefinition implements the InputDefinitionClassification interface for type InputFile.
func (i *InputFile) GetInputDefinition() *InputDefinition {
	return &InputDefinition{
		ODataType:      i.ODataType,
		IncludedTracks: i.IncludedTracks,
	}
}

// Job - A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
type Job struct {
	// The resource properties.
	Properties *JobProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobCollection - A collection of Job items.
type JobCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of Job items.
	Value []*Job `json:"value,omitempty"`
}

// JobError - Details of JobOutput errors.
type JobError struct {
	// READ-ONLY; Helps with categorization of errors.
	Category *JobErrorCategory `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Error code describing the error.
	Code *JobErrorCode `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; An array of details about specific errors that led to this reported error.
	Details []*JobErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; A human-readable language-dependent representation of the error.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via
	// Azure Portal.
	Retry *JobRetry `json:"retry,omitempty" azure:"ro"`
}

// JobErrorDetail - Details of JobOutput errors.
type JobErrorDetail struct {
	// READ-ONLY; Code describing the error detail.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; A human-readable representation of the error.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// JobInputClassification provides polymorphic access to related types.
// Call the interface's GetJobInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JobInput, *JobInputAsset, *JobInputClip, *JobInputHTTP, *JobInputSequence, *JobInputs
type JobInputClassification interface {
	// GetJobInput returns the JobInput content of the underlying type.
	GetJobInput() *JobInput
}

// JobInput - Base class for inputs to a Job.
type JobInput struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetJobInput implements the JobInputClassification interface for type JobInput.
func (j *JobInput) GetJobInput() *JobInput { return j }

// JobInputAsset - Represents an Asset for input into a Job.
type JobInputAsset struct {
	// REQUIRED; The name of the input Asset.
	AssetName *string `json:"assetName,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End ClipTimeClassification `json:"end,omitempty"`

	// List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service
	// responses to prevent sensitive data exposure.
	Files []*string `json:"files,omitempty"`

	// Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions []InputDefinitionClassification `json:"inputDefinitions,omitempty"`

	// A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform
	// can be authored so as to take an image file with the label 'xyz' and
	// apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should
	// be the image file, and it should have the label 'xyz'.
	Label *string `json:"label,omitempty"`

	// Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input
	// media.
	Start ClipTimeClassification `json:"start,omitempty"`
}

// GetJobInput implements the JobInputClassification interface for type JobInputAsset.
func (j *JobInputAsset) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// GetJobInputClip implements the JobInputClipClassification interface for type JobInputAsset.
func (j *JobInputAsset) GetJobInputClip() *JobInputClip {
	return &JobInputClip{
		Files:            j.Files,
		Start:            j.Start,
		End:              j.End,
		Label:            j.Label,
		InputDefinitions: j.InputDefinitions,
		ODataType:        j.ODataType,
	}
}

// JobInputClipClassification provides polymorphic access to related types.
// Call the interface's GetJobInputClip() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JobInputAsset, *JobInputClip, *JobInputHTTP
type JobInputClipClassification interface {
	JobInputClassification
	// GetJobInputClip returns the JobInputClip content of the underlying type.
	GetJobInputClip() *JobInputClip
}

// JobInputClip - Represents input files for a Job.
type JobInputClip struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End ClipTimeClassification `json:"end,omitempty"`

	// List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service
	// responses to prevent sensitive data exposure.
	Files []*string `json:"files,omitempty"`

	// Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions []InputDefinitionClassification `json:"inputDefinitions,omitempty"`

	// A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform
	// can be authored so as to take an image file with the label 'xyz' and
	// apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should
	// be the image file, and it should have the label 'xyz'.
	Label *string `json:"label,omitempty"`

	// Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input
	// media.
	Start ClipTimeClassification `json:"start,omitempty"`
}

// GetJobInput implements the JobInputClassification interface for type JobInputClip.
func (j *JobInputClip) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// GetJobInputClip implements the JobInputClipClassification interface for type JobInputClip.
func (j *JobInputClip) GetJobInputClip() *JobInputClip { return j }

// JobInputHTTP - Represents HTTPS job input.
type JobInputHTTP struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided
	// file list is assumed to be fully qualified uris. Maximum length of 4000
	// characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
	BaseURI *string `json:"baseUri,omitempty"`

	// Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End ClipTimeClassification `json:"end,omitempty"`

	// List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service
	// responses to prevent sensitive data exposure.
	Files []*string `json:"files,omitempty"`

	// Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions []InputDefinitionClassification `json:"inputDefinitions,omitempty"`

	// A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform
	// can be authored so as to take an image file with the label 'xyz' and
	// apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should
	// be the image file, and it should have the label 'xyz'.
	Label *string `json:"label,omitempty"`

	// Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input
	// media.
	Start ClipTimeClassification `json:"start,omitempty"`
}

// GetJobInput implements the JobInputClassification interface for type JobInputHTTP.
func (j *JobInputHTTP) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// GetJobInputClip implements the JobInputClipClassification interface for type JobInputHTTP.
func (j *JobInputHTTP) GetJobInputClip() *JobInputClip {
	return &JobInputClip{
		Files:            j.Files,
		Start:            j.Start,
		End:              j.End,
		Label:            j.Label,
		InputDefinitions: j.InputDefinitions,
		ODataType:        j.ODataType,
	}
}

// JobInputSequence - A Sequence contains an ordered list of Clips where each clip is a JobInput. The Sequence will be treated
// as a single input.
type JobInputSequence struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// JobInputs that make up the timeline.
	Inputs []JobInputClipClassification `json:"inputs,omitempty"`
}

// GetJobInput implements the JobInputClassification interface for type JobInputSequence.
func (j *JobInputSequence) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// JobInputs - Describes a list of inputs to a Job.
type JobInputs struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// List of inputs to a Job.
	Inputs []JobInputClassification `json:"inputs,omitempty"`
}

// GetJobInput implements the JobInputClassification interface for type JobInputs.
func (j *JobInputs) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// JobOutputClassification provides polymorphic access to related types.
// Call the interface's GetJobOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JobOutput, *JobOutputAsset
type JobOutputClassification interface {
	// GetJobOutput returns the JobOutput content of the underlying type.
	GetJobOutput() *JobOutput
}

// JobOutput - Describes all the properties of a JobOutput.
type JobOutput struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more
	// than one TransformOutput, whereby your Job has more than one JobOutput. In
	// such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the
	// Transform. Subsequently, when you retrieve the Job, either through events or on a
	// GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}'
	// will be used, where the preset name is the name of the
	// preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the
	// Job. Note that this index is the same as the relative index of the corresponding
	// TransformOutput within its Transform.
	Label *string `json:"label,omitempty"`

	// A preset used to override the preset in the corresponding transform output.
	PresetOverride PresetClassification `json:"presetOverride,omitempty"`

	// READ-ONLY; The UTC date and time at which this Job Output finished processing.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; If the JobOutput is in the Error state, it contains the details of the error.
	Error *JobError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate
	// and not intended to be used to predict Job completion times. To determine if the
	// JobOutput is complete, use the State property.
	Progress *int32 `json:"progress,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time at which this Job Output began processing.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Describes the state of the JobOutput.
	State *JobState `json:"state,omitempty" azure:"ro"`
}

// GetJobOutput implements the JobOutputClassification interface for type JobOutput.
func (j *JobOutput) GetJobOutput() *JobOutput { return j }

// JobOutputAsset - Represents an Asset used as a JobOutput.
type JobOutputAsset struct {
	// REQUIRED; The name of the output Asset.
	AssetName *string `json:"assetName,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more
	// than one TransformOutput, whereby your Job has more than one JobOutput. In
	// such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the
	// Transform. Subsequently, when you retrieve the Job, either through events or on a
	// GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}'
	// will be used, where the preset name is the name of the
	// preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the
	// Job. Note that this index is the same as the relative index of the corresponding
	// TransformOutput within its Transform.
	Label *string `json:"label,omitempty"`

	// A preset used to override the preset in the corresponding transform output.
	PresetOverride PresetClassification `json:"presetOverride,omitempty"`

	// READ-ONLY; The UTC date and time at which this Job Output finished processing.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; If the JobOutput is in the Error state, it contains the details of the error.
	Error *JobError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate
	// and not intended to be used to predict Job completion times. To determine if the
	// JobOutput is complete, use the State property.
	Progress *int32 `json:"progress,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time at which this Job Output began processing.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Describes the state of the JobOutput.
	State *JobState `json:"state,omitempty" azure:"ro"`
}

// GetJobOutput implements the JobOutputClassification interface for type JobOutputAsset.
func (j *JobOutputAsset) GetJobOutput() *JobOutput {
	return &JobOutput{
		ODataType:      j.ODataType,
		Error:          j.Error,
		PresetOverride: j.PresetOverride,
		State:          j.State,
		Progress:       j.Progress,
		Label:          j.Label,
		StartTime:      j.StartTime,
		EndTime:        j.EndTime,
	}
}

// JobProperties - Properties of the Job.
type JobProperties struct {
	// REQUIRED; The inputs for the Job.
	Input JobInputClassification `json:"input,omitempty"`

	// REQUIRED; The outputs for the Job.
	Outputs []JobOutputClassification `json:"outputs,omitempty"`

	// Customer provided key, value pairs that will be returned in Job and JobOutput state events.
	CorrelationData map[string]*string `json:"correlationData,omitempty"`

	// Optional customer supplied description of the Job.
	Description *string `json:"description,omitempty"`

	// Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not
	// set, the default is normal.
	Priority *Priority `json:"priority,omitempty"`

	// READ-ONLY; The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time at which this Job finished processing.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time at which this Job began processing.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the job.
	State *JobState `json:"state,omitempty" azure:"ro"`
}

// JobsClientCancelJobOptions contains the optional parameters for the JobsClient.CancelJob method.
type JobsClientCancelJobOptions struct {
	// placeholder for future optional parameters
}

// JobsClientCreateOptions contains the optional parameters for the JobsClient.Create method.
type JobsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// JobsClientDeleteOptions contains the optional parameters for the JobsClient.Delete method.
type JobsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListOptions contains the optional parameters for the JobsClient.List method.
type JobsClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies the key by which the result collection should be ordered.
	Orderby *string
}

// JobsClientUpdateOptions contains the optional parameters for the JobsClient.Update method.
type JobsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// JpgFormat - Describes the settings for producing JPEG thumbnails.
type JpgFormat struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetFormat implements the FormatClassification interface for type JpgFormat.
func (j *JpgFormat) GetFormat() *Format {
	return &Format{
		ODataType:       j.ODataType,
		FilenamePattern: j.FilenamePattern,
	}
}

// GetImageFormat implements the ImageFormatClassification interface for type JpgFormat.
func (j *JpgFormat) GetImageFormat() *ImageFormat {
	return &ImageFormat{
		ODataType:       j.ODataType,
		FilenamePattern: j.FilenamePattern,
	}
}

// JpgImage - Describes the properties for producing a series of JPEG images from the input video.
type JpgImage struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format
	// (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at
	// the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports
	// a macro {Best}, which tells the encoder to select the best thumbnail from
	// the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and
	// Range. The default value is macro {Best}.
	Start *string `json:"start,omitempty"`

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// A collection of output JPEG image layers to be produced by the encoder.
	Layers []*JpgLayer `json:"layers,omitempty"`

	// The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value
	// can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30
	// seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If
	// this value is 1, it means only producing one thumbnail at start time), or a
	// relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default
	// value is 100%, which means to stop at the end of the stream.
	Range *string `json:"range,omitempty"`

	// Sets the number of columns used in thumbnail sprite image. The number of rows are automatically calculated and a VTT file
	// is generated with the coordinate mappings for each thumbnail in the sprite.
	// Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will
	// not go beyond JPEG maximum pixel resolution limit 65535x65535.
	SpriteColumn *int32 `json:"spriteColumn,omitempty"`

	// The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image
	// every 5 seconds), or a frame count (For example, 30 for one image every 30
	// frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step
	// value will affect the first generated thumbnail, which may not be exactly the
	// one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between
	// start time and Step position from start time as the first output. As the
	// default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one
	// specified at start time. Try to select reasonable value for Step if the first
	// thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string `json:"step,omitempty"`

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode `json:"stretchMode,omitempty"`

	// The Video Sync Mode
	SyncMode *VideoSyncMode `json:"syncMode,omitempty"`
}

// GetCodec implements the CodecClassification interface for type JpgImage.
func (j *JpgImage) GetCodec() *Codec {
	return &Codec{
		ODataType: j.ODataType,
		Label:     j.Label,
	}
}

// GetImage implements the ImageClassification interface for type JpgImage.
func (j *JpgImage) GetImage() *Image {
	return &Image{
		Start:            j.Start,
		Step:             j.Step,
		Range:            j.Range,
		KeyFrameInterval: j.KeyFrameInterval,
		StretchMode:      j.StretchMode,
		SyncMode:         j.SyncMode,
		ODataType:        j.ODataType,
		Label:            j.Label,
	}
}

// GetVideo implements the VideoClassification interface for type JpgImage.
func (j *JpgImage) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: j.KeyFrameInterval,
		StretchMode:      j.StretchMode,
		SyncMode:         j.SyncMode,
		ODataType:        j.ODataType,
		Label:            j.Label,
	}
}

// JpgLayer - Describes the settings to produce a JPEG image from the input video.
type JpgLayer struct {
	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
	Quality *int32 `json:"quality,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

type KeyDelivery struct {
	// The access control properties for Key Delivery.
	AccessControl *AccessControl `json:"accessControl,omitempty"`
}

type KeyVaultProperties struct {
	// The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1)
	// or reference a key without a version (for example
	// https://vault/keys/mykey).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// READ-ONLY; The current key used to encrypt the Media Services account, including the key version.
	CurrentKeyIdentifier *string `json:"currentKeyIdentifier,omitempty" azure:"ro"`
}

// Layer - The encoder can be configured to produce video and/or images (thumbnails) at different resolutions, by specifying
// a layer for each desired resolution. A layer represents the properties for the video
// or image at a resolution.
type Layer struct {
	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

// ListContainerSasInput - The parameters to the list SAS request.
type ListContainerSasInput struct {
	// The SAS URL expiration time. This must be less than 24 hours from the current time.
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// The permissions to set on the SAS URL.
	Permissions *AssetContainerPermission `json:"permissions,omitempty"`
}

// ListContentKeysResponse - Class of response for listContentKeys action
type ListContentKeysResponse struct {
	// ContentKeys used by current Streaming Locator
	ContentKeys []*StreamingLocatorContentKey `json:"contentKeys,omitempty"`
}

type ListEdgePoliciesInput struct {
	// Unique identifier of the edge device.
	DeviceID *string `json:"deviceId,omitempty"`
}

// ListPathsResponse - Class of response for listPaths action
type ListPathsResponse struct {
	// Download Paths supported by current Streaming Locator
	DownloadPaths []*string `json:"downloadPaths,omitempty"`

	// Streaming Paths supported by current Streaming Locator
	StreamingPaths []*StreamingPath `json:"streamingPaths,omitempty"`
}

// ListStreamingLocatorsResponse - The Streaming Locators associated with this Asset.
type ListStreamingLocatorsResponse struct {
	// READ-ONLY; The list of Streaming Locators.
	StreamingLocators []*AssetStreamingLocator `json:"streamingLocators,omitempty" azure:"ro"`
}

// LiveEvent - The live event.
type LiveEvent struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The live event properties.
	Properties *LiveEventProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LiveEventActionInput - The LiveEvent action input parameter definition.
type LiveEventActionInput struct {
	// The flag indicates whether live outputs are automatically deleted when live event is being stopped. Deleting live outputs
	// do not delete the underlying assets.
	RemoveOutputsOnStop *bool `json:"removeOutputsOnStop,omitempty"`
}

// LiveEventEncoding - Specifies the live event type and optional encoding settings for encoding live events.
type LiveEventEncoding struct {
	// Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through
	// the incoming video and audio layer(s) to the output. When encodingType is set to
	// Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101
	// for more information. This property cannot
	// be modified after the live event is created.
	EncodingType *LiveEventEncodingType `json:"encodingType,omitempty"`

	// Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks
	// of an encoding live event. For example, use PT2S to indicate 2 seconds. For
	// the video track it also defines the key frame interval, or the length of a GoP (group of pictures). If this value is not
	// set for an encoding live event, the fragment duration defaults to 2 seconds.
	// The value cannot be set for pass-through live events.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot
	// be updated. If the encodingType is set to Standard, then the default preset
	// name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
	PresetName *string `json:"presetName,omitempty"`

	// Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
	StretchMode *StretchMode `json:"stretchMode,omitempty"`
}

// LiveEventEndpoint - The live event endpoint.
type LiveEventEndpoint struct {
	// The endpoint protocol.
	Protocol *string `json:"protocol,omitempty"`

	// The endpoint URL.
	URL *string `json:"url,omitempty"`
}

// LiveEventInput - The live event input.
type LiveEventInput struct {
	// REQUIRED; The input protocol for the live event. This is specified at creation time and cannot be updated.
	StreamingProtocol *LiveEventInputProtocol `json:"streamingProtocol,omitempty"`

	// Access control for live event input.
	AccessControl *LiveEventInputAccessControl `json:"accessControl,omitempty"`

	// A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If
	// omitted, the service will generate a unique value.
	AccessToken *string `json:"accessToken,omitempty"`

	// The input endpoints for the live event.
	Endpoints []*LiveEventEndpoint `json:"endpoints,omitempty"`

	// ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property
	// in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the
	// value empty for encoding live events.
	KeyFrameIntervalDuration *string `json:"keyFrameIntervalDuration,omitempty"`
}

// LiveEventInputAccessControl - The IP access control for live event input.
type LiveEventInputAccessControl struct {
	// The IP access control properties.
	IP *IPAccessControl `json:"ip,omitempty"`
}

// LiveEventInputTrackSelection - A track selection condition. This property is reserved for future use, any value set on
// this property will be ignored.
type LiveEventInputTrackSelection struct {
	// Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
	Operation *string `json:"operation,omitempty"`

	// Property name to select. This property is reserved for future use, any value set on this property will be ignored.
	Property *string `json:"property,omitempty"`

	// Property value to select. This property is reserved for future use, any value set on this property will be ignored.
	Value *string `json:"value,omitempty"`
}

// LiveEventListResult - The LiveEvent list result.
type LiveEventListResult struct {
	// The number of result.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// The link to the next set of results. Not empty if value contains incomplete list of live outputs.
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// The result of the List Live Event operation.
	Value []*LiveEvent `json:"value,omitempty"`
}

// LiveEventOutputTranscriptionTrack - Describes a transcription track in the output of a live event, generated using speech-to-text
// transcription. This property is reserved for future use, any value set on this property will be ignored.
type LiveEventOutputTranscriptionTrack struct {
	// REQUIRED; The output track name. This property is reserved for future use, any value set on this property will be ignored.
	TrackName *string `json:"trackName,omitempty"`
}

// LiveEventPreview - Live event preview settings.
type LiveEventPreview struct {
	// The access control for live event preview.
	AccessControl *LiveEventPreviewAccessControl `json:"accessControl,omitempty"`

	// An alternative media identifier associated with the streaming locator created for the preview. This value is specified
	// at creation time and cannot be updated. The identifier can be used in the
	// CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName
	// field.
	AlternativeMediaID *string `json:"alternativeMediaId,omitempty"`

	// The endpoints for preview. Do not share the preview URL with the live event audience.
	Endpoints []*LiveEventEndpoint `json:"endpoints,omitempty"`

	// The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview
	// locator url before the event is created. If omitted, the service will
	// generate a random identifier. This value cannot be updated once the live event is created.
	PreviewLocator *string `json:"previewLocator,omitempty"`

	// The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
	StreamingPolicyName *string `json:"streamingPolicyName,omitempty"`
}

// LiveEventPreviewAccessControl - The IP access control for the live event preview endpoint.
type LiveEventPreviewAccessControl struct {
	// The IP access control properties.
	IP *IPAccessControl `json:"ip,omitempty"`
}

// LiveEventProperties - The live event properties.
type LiveEventProperties struct {
	// REQUIRED; Live event input settings. It defines how the live event receives input from a contribution encoder.
	Input *LiveEventInput `json:"input,omitempty"`

	// Live event cross site access policies.
	CrossSiteAccessPolicies *CrossSiteAccessPolicies `json:"crossSiteAccessPolicies,omitempty"`

	// A description for the live event.
	Description *string `json:"description,omitempty"`

	// Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for
	// the live encoder if it is used.
	Encoding *LiveEventEncoding `json:"encoding,omitempty"`

	// When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live
	// event preview and ingest endpoints. The final hostname would be a combination of
	// this prefix, the media service account name and a short code for the Azure Media Services data center.
	HostnamePrefix *string `json:"hostnamePrefix,omitempty"`

	// Live event preview settings. Preview allows live event producers to preview the live streaming content without creating
	// any live output.
	Preview *LiveEventPreview `json:"preview,omitempty"`

	// The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values
	// for the array entry values are 'Default' and 'LowLatency'.
	StreamOptions []*StreamOptionsFlag `json:"streamOptions,omitempty"`

	// Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information
	// about the live transcription feature.
	Transcriptions []*LiveEventTranscription `json:"transcriptions,omitempty"`

	// Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only
	// be updated if the live event is in Standby state
	UseStaticHostname *bool `json:"useStaticHostname,omitempty"`

	// READ-ONLY; The creation time for the live event
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The last modified time of the live event.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the live event.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
	ResourceState *LiveEventResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// LiveEventTranscription - Describes the transcription tracks in the output of a live event, generated using speech-to-text
// transcription. This property is reserved for future use, any value set on this property will be
// ignored.
type LiveEventTranscription struct {
	// Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied.
	// This property is reserved for future use, any value set on this property will
	// be ignored.
	InputTrackSelection []*LiveEventInputTrackSelection `json:"inputTrackSelection,omitempty"`

	// Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the
	// audio track. The value should be in BCP-47 format (e.g: 'en-US'). See
	// https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list
	// of supported languages.
	Language *string `json:"language,omitempty"`

	// Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property
	// is reserved for future use, any value set on this property will be ignored.
	OutputTranscriptionTrack *LiveEventOutputTranscriptionTrack `json:"outputTranscriptionTrack,omitempty"`
}

// LiveEventsClientAsyncOperationOptions contains the optional parameters for the LiveEventsClient.AsyncOperation method.
type LiveEventsClientAsyncOperationOptions struct {
	// placeholder for future optional parameters
}

// LiveEventsClientBeginAllocateOptions contains the optional parameters for the LiveEventsClient.BeginAllocate method.
type LiveEventsClientBeginAllocateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientBeginCreateOptions contains the optional parameters for the LiveEventsClient.BeginCreate method.
type LiveEventsClientBeginCreateOptions struct {
	// The flag indicates if the resource should be automatically started on creation.
	AutoStart *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientBeginDeleteOptions contains the optional parameters for the LiveEventsClient.BeginDelete method.
type LiveEventsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientBeginResetOptions contains the optional parameters for the LiveEventsClient.BeginReset method.
type LiveEventsClientBeginResetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientBeginStartOptions contains the optional parameters for the LiveEventsClient.BeginStart method.
type LiveEventsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientBeginStopOptions contains the optional parameters for the LiveEventsClient.BeginStop method.
type LiveEventsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientBeginUpdateOptions contains the optional parameters for the LiveEventsClient.BeginUpdate method.
type LiveEventsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveEventsClientGetOptions contains the optional parameters for the LiveEventsClient.Get method.
type LiveEventsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LiveEventsClientListOptions contains the optional parameters for the LiveEventsClient.List method.
type LiveEventsClientListOptions struct {
	// placeholder for future optional parameters
}

// LiveEventsClientOperationLocationOptions contains the optional parameters for the LiveEventsClient.OperationLocation method.
type LiveEventsClientOperationLocationOptions struct {
	// placeholder for future optional parameters
}

// LiveOutput - The Live Output.
type LiveOutput struct {
	// Live output properties.
	Properties *LiveOutputProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LiveOutputListResult - The LiveOutput list result.
type LiveOutputListResult struct {
	// The number of result.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// The link to the next set of results. Not empty if value contains incomplete list of live outputs.
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// The result of the List LiveOutput operation.
	Value []*LiveOutput `json:"value,omitempty"`
}

// LiveOutputProperties - The JSON object that contains the properties required to create a live output.
type LiveOutputProperties struct {
	// REQUIRED; ISO 8601 time between 1 minute to 25 hours to indicate the maximum content length that can be archived in the
	// asset for this live output. This also sets the maximum content length for the rewind
	// window. For example, use PT1H30M to indicate 1 hour and 30 minutes of archive window.
	ArchiveWindowLength *string `json:"archiveWindowLength,omitempty"`

	// REQUIRED; The asset that the live output will write to.
	AssetName *string `json:"assetName,omitempty"`

	// The description of the live output.
	Description *string `json:"description,omitempty"`

	// HTTP Live Streaming (HLS) packing setting for the live output.
	Hls *Hls `json:"hls,omitempty"`

	// The manifest file name. If not provided, the service will generate one automatically.
	ManifestName *string `json:"manifestName,omitempty"`

	// The initial timestamp that the live output will start at, any content before this value will not be archived.
	OutputSnapTime *int64 `json:"outputSnapTime,omitempty"`

	// ISO 8601 time between 1 minute to the duration of archiveWindowLength to control seek-able window length during Live. The
	// service won't use this property once LiveOutput stops. The archived VOD will
	// have full content with original ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind
	// window length. Service will use implicit default value 30m only if Live Event
	// enables LL.
	RewindWindowLength *string `json:"rewindWindowLength,omitempty"`

	// READ-ONLY; The creation time the live output.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The time the live output was last modified.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the live output.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource state of the live output.
	ResourceState *LiveOutputResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// LiveOutputsClientAsyncOperationOptions contains the optional parameters for the LiveOutputsClient.AsyncOperation method.
type LiveOutputsClientAsyncOperationOptions struct {
	// placeholder for future optional parameters
}

// LiveOutputsClientBeginCreateOptions contains the optional parameters for the LiveOutputsClient.BeginCreate method.
type LiveOutputsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveOutputsClientBeginDeleteOptions contains the optional parameters for the LiveOutputsClient.BeginDelete method.
type LiveOutputsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LiveOutputsClientGetOptions contains the optional parameters for the LiveOutputsClient.Get method.
type LiveOutputsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LiveOutputsClientListOptions contains the optional parameters for the LiveOutputsClient.List method.
type LiveOutputsClientListOptions struct {
	// placeholder for future optional parameters
}

// LiveOutputsClientOperationLocationOptions contains the optional parameters for the LiveOutputsClient.OperationLocation
// method.
type LiveOutputsClientOperationLocationOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientCheckNameAvailabilityOptions contains the optional parameters for the LocationsClient.CheckNameAvailability
// method.
type LocationsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// LogSpecification - A diagnostic log emitted by service.
type LogSpecification struct {
	// READ-ONLY; The time range for requests in each blob.
	BlobDuration *string `json:"blobDuration,omitempty" azure:"ro"`

	// READ-ONLY; The diagnostic log category display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The diagnostic log category name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// MediaFilterProperties - The Media Filter properties.
type MediaFilterProperties struct {
	// The first quality.
	FirstQuality *FirstQuality `json:"firstQuality,omitempty"`

	// The presentation time range.
	PresentationTimeRange *PresentationTimeRange `json:"presentationTimeRange,omitempty"`

	// The tracks selection conditions.
	Tracks []*FilterTrackSelection `json:"tracks,omitempty"`
}

// MediaService - A Media Services account.
type MediaService struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The Managed Identity for the Media Services account.
	Identity *MediaServiceIdentity `json:"identity,omitempty"`

	// The resource properties.
	Properties *MediaServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MediaServiceCollection - A collection of MediaService items.
type MediaServiceCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of MediaService items.
	Value []*MediaService `json:"value,omitempty"`
}

type MediaServiceIdentity struct {
	// REQUIRED; The identity type.
	Type *string `json:"type,omitempty"`

	// The user assigned managed identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The Principal ID of the identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The Tenant ID of the identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MediaServiceOperationStatus - Status of media service operation.
type MediaServiceOperationStatus struct {
	// REQUIRED; Operation identifier.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Operation status.
	Status *string `json:"status,omitempty"`

	// Operation end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error detail.
	Error *ErrorDetail `json:"error,omitempty"`

	// Operation resource ID.
	ID *string `json:"id,omitempty"`

	// Operation start time.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// MediaServiceProperties - Properties of the Media Services account.
type MediaServiceProperties struct {
	// The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`

	// The Key Delivery properties for Media Services account.
	KeyDelivery *KeyDelivery `json:"keyDelivery,omitempty"`

	// Whether or not public network access is allowed for resources under the Media Services account.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// The storage accounts for this resource.
	StorageAccounts       []*StorageAccount      `json:"storageAccounts,omitempty"`
	StorageAuthentication *StorageAuthentication `json:"storageAuthentication,omitempty"`

	// READ-ONLY; The Media Services account ID.
	MediaServiceID *string `json:"mediaServiceId,omitempty" azure:"ro"`

	// READ-ONLY; The Private Endpoint Connections created for the Media Service account.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Media Services account.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MediaServiceUpdate - A Media Services account update.
type MediaServiceUpdate struct {
	// The Managed Identity for the Media Services account.
	Identity *MediaServiceIdentity `json:"identity,omitempty"`

	// The resource properties.
	Properties *MediaServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MetricDimension - A metric dimension.
type MetricDimension struct {
	// READ-ONLY; The display name for the dimension.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The metric dimension name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Whether to export metric to shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty" azure:"ro"`
}

// MetricSpecification - A metric emitted by service.
type MetricSpecification struct {
	// Supported aggregation types.
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// READ-ONLY; The metric aggregation type
	AggregationType *MetricAggregationType `json:"aggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The metric dimensions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty" azure:"ro"`

	// READ-ONLY; The metric display description.
	DisplayDescription *string `json:"displayDescription,omitempty" azure:"ro"`

	// READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether regional MDM account is enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty" azure:"ro"`

	// READ-ONLY; The metric lock aggregation type
	LockAggregationType *MetricAggregationType `json:"lockAggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The metric name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty" azure:"ro"`

	// READ-ONLY; The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty" azure:"ro"`

	// READ-ONLY; The supported time grain types.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty" azure:"ro"`

	// READ-ONLY; The metric unit
	Unit *MetricUnit `json:"unit,omitempty" azure:"ro"`
}

// Mp4Format - Describes the properties for an output ISO MP4 file.
type Mp4Format struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The list of output files to produce. Each entry in the list is a set of audio and video layer labels to be muxed together
	// .
	OutputFiles []*OutputFile `json:"outputFiles,omitempty"`
}

// GetFormat implements the FormatClassification interface for type Mp4Format.
func (m *Mp4Format) GetFormat() *Format {
	return &Format{
		ODataType:       m.ODataType,
		FilenamePattern: m.FilenamePattern,
	}
}

// GetMultiBitrateFormat implements the MultiBitrateFormatClassification interface for type Mp4Format.
func (m *Mp4Format) GetMultiBitrateFormat() *MultiBitrateFormat {
	return &MultiBitrateFormat{
		OutputFiles:     m.OutputFiles,
		ODataType:       m.ODataType,
		FilenamePattern: m.FilenamePattern,
	}
}

// MultiBitrateFormatClassification provides polymorphic access to related types.
// Call the interface's GetMultiBitrateFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Mp4Format, *MultiBitrateFormat, *TransportStreamFormat
type MultiBitrateFormatClassification interface {
	FormatClassification
	// GetMultiBitrateFormat returns the MultiBitrateFormat content of the underlying type.
	GetMultiBitrateFormat() *MultiBitrateFormat
}

// MultiBitrateFormat - Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default
// behavior is to produce one output file for each video layer which is muxed together with all the
// audios. The exact output files produced can be controlled by specifying the outputFiles collection.
type MultiBitrateFormat struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The list of output files to produce. Each entry in the list is a set of audio and video layer labels to be muxed together
	// .
	OutputFiles []*OutputFile `json:"outputFiles,omitempty"`
}

// GetFormat implements the FormatClassification interface for type MultiBitrateFormat.
func (m *MultiBitrateFormat) GetFormat() *Format {
	return &Format{
		ODataType:       m.ODataType,
		FilenamePattern: m.FilenamePattern,
	}
}

// GetMultiBitrateFormat implements the MultiBitrateFormatClassification interface for type MultiBitrateFormat.
func (m *MultiBitrateFormat) GetMultiBitrateFormat() *MultiBitrateFormat { return m }

// NoEncryption - Class for NoEncryption scheme
type NoEncryption struct {
	// Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
}

// Operation - An operation.
type Operation struct {
	// REQUIRED; The operation name.
	Name *string `json:"name,omitempty"`

	// Indicates the action type.
	ActionType *ActionType `json:"actionType,omitempty"`

	// The operation display name.
	Display *OperationDisplay `json:"display,omitempty"`

	// Whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Operation properties format.
	Properties *Properties `json:"properties,omitempty"`
}

// OperationCollection - A collection of Operation items.
type OperationCollection struct {
	// A collection of Operation items.
	Value []*Operation `json:"value,omitempty"`
}

// OperationDisplay - Operation details.
type OperationDisplay struct {
	// The operation description.
	Description *string `json:"description,omitempty"`

	// The operation type.
	Operation *string `json:"operation,omitempty"`

	// The service provider.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationResultsClientGetOptions contains the optional parameters for the OperationResultsClient.Get method.
type OperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationStatusesClientGetOptions contains the optional parameters for the OperationStatusesClient.Get method.
type OperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutputFile - Represents an output file produced.
type OutputFile struct {
	// REQUIRED; The list of labels that describe how the encoder should multiplex video and audio into an output file. For example,
	// if the encoder is producing two video layers with labels v1 and v2, and one audio
	// layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented
	// by v1 and the audio track represented by a1.
	Labels []*string `json:"labels,omitempty"`
}

// OverlayClassification provides polymorphic access to related types.
// Call the interface's GetOverlay() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioOverlay, *Overlay, *VideoOverlay
type OverlayClassification interface {
	// GetOverlay returns the Overlay content of the underlying type.
	GetOverlay() *Overlay
}

// Overlay - Base type for all overlays - image, audio or video.
type Overlay struct {
	// REQUIRED; The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can
	// specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV,
	// MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video
	// file formats.
	InputLabel *string `json:"inputLabel,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64 `json:"audioGainLevel,omitempty"`

	// The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format.
	// For example, PT30S to end the overlay at 30 seconds into the input video. If not
	// specified or the value is greater than the input video duration, the overlay will be applied until the end of the input
	// video if the overlay media duration is greater than the input video duration,
	// else the overlay will last as long as the overlay media duration.
	End *string `json:"end,omitempty"`

	// The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If
	// not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string `json:"fadeInDuration,omitempty"`

	// The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not
	// specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string `json:"fadeOutDuration,omitempty"`

	// The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format.
	// For example, PT05S to start the overlay at 5 seconds into the input video.
	// If not specified the overlay starts from the beginning of the input video.
	Start *string `json:"start,omitempty"`
}

// GetOverlay implements the OverlayClassification interface for type Overlay.
func (o *Overlay) GetOverlay() *Overlay { return o }

// PNGFormat - Describes the settings for producing PNG thumbnails.
type PNGFormat struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetFormat implements the FormatClassification interface for type PNGFormat.
func (p *PNGFormat) GetFormat() *Format {
	return &Format{
		ODataType:       p.ODataType,
		FilenamePattern: p.FilenamePattern,
	}
}

// GetImageFormat implements the ImageFormatClassification interface for type PNGFormat.
func (p *PNGFormat) GetImageFormat() *ImageFormat {
	return &ImageFormat{
		ODataType:       p.ODataType,
		FilenamePattern: p.FilenamePattern,
	}
}

// PNGImage - Describes the properties for producing a series of PNG images from the input video.
type PNGImage struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format
	// (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at
	// the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports
	// a macro {Best}, which tells the encoder to select the best thumbnail from
	// the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and
	// Range. The default value is macro {Best}.
	Start *string `json:"start,omitempty"`

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// A collection of output PNG image layers to be produced by the encoder.
	Layers []*PNGLayer `json:"layers,omitempty"`

	// The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value
	// can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30
	// seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If
	// this value is 1, it means only producing one thumbnail at start time), or a
	// relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default
	// value is 100%, which means to stop at the end of the stream.
	Range *string `json:"range,omitempty"`

	// The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image
	// every 5 seconds), or a frame count (For example, 30 for one image every 30
	// frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step
	// value will affect the first generated thumbnail, which may not be exactly the
	// one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between
	// start time and Step position from start time as the first output. As the
	// default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one
	// specified at start time. Try to select reasonable value for Step if the first
	// thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string `json:"step,omitempty"`

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode `json:"stretchMode,omitempty"`

	// The Video Sync Mode
	SyncMode *VideoSyncMode `json:"syncMode,omitempty"`
}

// GetCodec implements the CodecClassification interface for type PNGImage.
func (p *PNGImage) GetCodec() *Codec {
	return &Codec{
		ODataType: p.ODataType,
		Label:     p.Label,
	}
}

// GetImage implements the ImageClassification interface for type PNGImage.
func (p *PNGImage) GetImage() *Image {
	return &Image{
		Start:            p.Start,
		Step:             p.Step,
		Range:            p.Range,
		KeyFrameInterval: p.KeyFrameInterval,
		StretchMode:      p.StretchMode,
		SyncMode:         p.SyncMode,
		ODataType:        p.ODataType,
		Label:            p.Label,
	}
}

// GetVideo implements the VideoClassification interface for type PNGImage.
func (p *PNGImage) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: p.KeyFrameInterval,
		StretchMode:      p.StretchMode,
		SyncMode:         p.SyncMode,
		ODataType:        p.ODataType,
		Label:            p.Label,
	}
}

// PNGLayer - Describes the settings to produce a PNG image from the input video.
type PNGLayer struct {
	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

// PresentationTimeRange - The presentation time range, this is asset related and not recommended for Account Filter.
type PresentationTimeRange struct {
	// The absolute end time boundary.
	EndTimestamp *int64 `json:"endTimestamp,omitempty"`

	// The indicator of forcing existing of end time stamp.
	ForceEndTimestamp *bool `json:"forceEndTimestamp,omitempty"`

	// The relative to end right edge.
	LiveBackoffDuration *int64 `json:"liveBackoffDuration,omitempty"`

	// The relative to end sliding window.
	PresentationWindowDuration *int64 `json:"presentationWindowDuration,omitempty"`

	// The absolute start time boundary.
	StartTimestamp *int64 `json:"startTimestamp,omitempty"`

	// The time scale of time stamps.
	Timescale *int64 `json:"timescale,omitempty"`
}

// PresetClassification provides polymorphic access to related types.
// Call the interface's GetPreset() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioAnalyzerPreset, *BuiltInStandardEncoderPreset, *FaceDetectorPreset, *Preset, *StandardEncoderPreset, *VideoAnalyzerPreset
type PresetClassification interface {
	// GetPreset returns the Preset content of the underlying type.
	GetPreset() *Preset
}

// Preset - Base type for all Presets, which define the recipe or instructions on how the input media files should be processed.
type Preset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetPreset implements the PresetClassification interface for type Preset.
func (p *Preset) GetPreset() *Preset { return p }

// PresetConfigurations - An object of optional configuration settings for encoder.
type PresetConfigurations struct {
	// Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity
	// as Speed for faster encoding but less compression efficiency.
	Complexity *Complexity `json:"complexity,omitempty"`

	// Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set
	// InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only
	// outputs in separate MP4 files.
	InterleaveOutput *InterleaveOutput `json:"interleaveOutput,omitempty"`

	// The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some
	// players.
	KeyFrameIntervalInSeconds *float32 `json:"keyFrameIntervalInSeconds,omitempty"`

	// The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid
	// producing very high bitrate outputs for contents with high complexity.
	MaxBitrateBps *int32 `json:"maxBitrateBps,omitempty"`

	// The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the
	// input is 4K.
	MaxHeight *int32 `json:"maxHeight,omitempty"`

	// The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced
	// to control the overall cost of the encoding job.
	MaxLayers *int32 `json:"maxLayers,omitempty"`

	// The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to
	// have a bottom layer that covers users with low network bandwidth.
	MinBitrateBps *int32 `json:"minBitrateBps,omitempty"`

	// The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions
	// like 180P.
	MinHeight *int32 `json:"minHeight,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Delete
// method.
type PrivateEndpointConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Properties - The service specification property.
type Properties struct {
	// READ-ONLY; The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Rectangle - Describes the properties of a rectangular window applied to the input media before processing it.
type Rectangle struct {
	// The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of
	// the video (For example, 50%).
	Height *string `json:"height,omitempty"`

	// The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video
	// (For example, 50%).
	Left *string `json:"left,omitempty"`

	// The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video
	// (For example, 50%).
	Top *string `json:"top,omitempty"`

	// The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the
	// video (For example, 50%).
	Width *string `json:"width,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ResourceIdentity struct {
	// REQUIRED; Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
	UseSystemAssignedIdentity *bool `json:"useSystemAssignedIdentity,omitempty"`

	// The user assigned managed identity's ARM ID to use when accessing a resource.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// SelectAudioTrackByAttribute - Select audio tracks from the input by specifying an attribute and an attribute filter.
type SelectAudioTrackByAttribute struct {
	// REQUIRED; The TrackAttribute to filter the tracks by.
	Attribute *TrackAttribute `json:"attribute,omitempty"`

	// REQUIRED; The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
	Filter *AttributeFilter `json:"filter,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or multi-channel audio
	// tracks.
	ChannelMapping *ChannelMapping `json:"channelMapping,omitempty"`

	// The value to filter the tracks by. Only used when AttributeFilter.ValueEquals is specified for the Filter property.
	FilterValue *string `json:"filterValue,omitempty"`
}

// GetAudioTrackDescriptor implements the AudioTrackDescriptorClassification interface for type SelectAudioTrackByAttribute.
func (s *SelectAudioTrackByAttribute) GetAudioTrackDescriptor() *AudioTrackDescriptor {
	return &AudioTrackDescriptor{
		ChannelMapping: s.ChannelMapping,
		ODataType:      s.ODataType,
	}
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectAudioTrackByAttribute.
func (s *SelectAudioTrackByAttribute) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// SelectAudioTrackByID - Select audio tracks from the input by specifying a track identifier.
type SelectAudioTrackByID struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; Track identifier to select
	TrackID *int64 `json:"trackId,omitempty"`

	// Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or multi-channel audio
	// tracks.
	ChannelMapping *ChannelMapping `json:"channelMapping,omitempty"`
}

// GetAudioTrackDescriptor implements the AudioTrackDescriptorClassification interface for type SelectAudioTrackByID.
func (s *SelectAudioTrackByID) GetAudioTrackDescriptor() *AudioTrackDescriptor {
	return &AudioTrackDescriptor{
		ChannelMapping: s.ChannelMapping,
		ODataType:      s.ODataType,
	}
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectAudioTrackByID.
func (s *SelectAudioTrackByID) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// SelectVideoTrackByAttribute - Select video tracks from the input by specifying an attribute and an attribute filter.
type SelectVideoTrackByAttribute struct {
	// REQUIRED; The TrackAttribute to filter the tracks by.
	Attribute *TrackAttribute `json:"attribute,omitempty"`

	// REQUIRED; The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
	Filter *AttributeFilter `json:"filter,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The value to filter the tracks by. Only used when AttributeFilter.ValueEquals is specified for the Filter property. For
	// TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g:
	// '1500000'). The TrackAttribute.Language is not supported for video tracks.
	FilterValue *string `json:"filterValue,omitempty"`
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectVideoTrackByAttribute.
func (s *SelectVideoTrackByAttribute) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// GetVideoTrackDescriptor implements the VideoTrackDescriptorClassification interface for type SelectVideoTrackByAttribute.
func (s *SelectVideoTrackByAttribute) GetVideoTrackDescriptor() *VideoTrackDescriptor {
	return &VideoTrackDescriptor{
		ODataType: s.ODataType,
	}
}

// SelectVideoTrackByID - Select video tracks from the input by specifying a track identifier.
type SelectVideoTrackByID struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; Track identifier to select
	TrackID *int64 `json:"trackId,omitempty"`
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectVideoTrackByID.
func (s *SelectVideoTrackByID) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// GetVideoTrackDescriptor implements the VideoTrackDescriptorClassification interface for type SelectVideoTrackByID.
func (s *SelectVideoTrackByID) GetVideoTrackDescriptor() *VideoTrackDescriptor {
	return &VideoTrackDescriptor{
		ODataType: s.ODataType,
	}
}

// ServiceSpecification - The service metric specifications.
type ServiceSpecification struct {
	// READ-ONLY; List of log specifications.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty" azure:"ro"`

	// READ-ONLY; List of metric specifications.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty" azure:"ro"`
}

// StandardEncoderPreset - Describes all the settings to be used when encoding the input video with the Standard Encoder.
type StandardEncoderPreset struct {
	// REQUIRED; The list of codecs to be used when encoding the input video.
	Codecs []CodecClassification `json:"codecs,omitempty"`

	// REQUIRED; The list of outputs to be produced by the encoder.
	Formats []FormatClassification `json:"formats,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// One or more filtering operations that are applied to the input media before encoding.
	Filters *Filters `json:"filters,omitempty"`
}

// GetPreset implements the PresetClassification interface for type StandardEncoderPreset.
func (s *StandardEncoderPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: s.ODataType,
	}
}

// StorageAccount - The storage account details.
type StorageAccount struct {
	// REQUIRED; The type of the storage account.
	Type *StorageAccountType `json:"type,omitempty"`

	// The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage
	// account must be a Standard Storage account (either Microsoft.ClassicStorage
	// or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
	ID *string `json:"id,omitempty"`

	// The storage account identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// READ-ONLY; The current status of the storage account mapping.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// StorageEncryptedAssetDecryptionData - Data needed to decrypt asset files encrypted with legacy storage encryption.
type StorageEncryptedAssetDecryptionData struct {
	// Asset File encryption metadata.
	AssetFileEncryptionMetadata []*AssetFileEncryptionMetadata `json:"assetFileEncryptionMetadata,omitempty"`

	// The Asset File storage encryption key.
	Key []byte `json:"key,omitempty"`
}

// StreamingEndpoint - The streaming endpoint.
type StreamingEndpoint struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The streaming endpoint properties.
	Properties *StreamingEndpointProperties `json:"properties,omitempty"`

	// The streaming endpoint sku.
	SKU *ArmStreamingEndpointCurrentSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StreamingEndpointAccessControl - Streaming endpoint access control definition.
type StreamingEndpointAccessControl struct {
	// The access control of Akamai
	Akamai *AkamaiAccessControl `json:"akamai,omitempty"`

	// The IP access control of the streaming endpoint.
	IP *IPAccessControl `json:"ip,omitempty"`
}

// StreamingEndpointListResult - The streaming endpoint list result.
type StreamingEndpointListResult struct {
	// The number of result.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// The link to the next set of results. Not empty if value contains incomplete list of streaming endpoints.
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// The result of the List StreamingEndpoint operation.
	Value []*StreamingEndpoint `json:"value,omitempty"`
}

// StreamingEndpointProperties - The streaming endpoint properties.
type StreamingEndpointProperties struct {
	// REQUIRED; The number of scale units. Use the Scale operation to adjust this value.
	ScaleUnits *int32 `json:"scaleUnits,omitempty"`

	// The access control definition of the streaming endpoint.
	AccessControl *StreamingEndpointAccessControl `json:"accessControl,omitempty"`

	// This feature is deprecated, do not set a value for this property.
	AvailabilitySetName *string `json:"availabilitySetName,omitempty"`

	// The CDN enabled flag.
	CdnEnabled *bool `json:"cdnEnabled,omitempty"`

	// The CDN profile name.
	CdnProfile *string `json:"cdnProfile,omitempty"`

	// The CDN provider name.
	CdnProvider *string `json:"cdnProvider,omitempty"`

	// The streaming endpoint access policies.
	CrossSiteAccessPolicies *CrossSiteAccessPolicies `json:"crossSiteAccessPolicies,omitempty"`

	// The custom host names of the streaming endpoint
	CustomHostNames []*string `json:"customHostNames,omitempty"`

	// The streaming endpoint description.
	Description *string `json:"description,omitempty"`

	// Max cache age
	MaxCacheAge *int64 `json:"maxCacheAge,omitempty"`

	// READ-ONLY; The exact time the streaming endpoint was created.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The free trial expiration time.
	FreeTrialEndTime *time.Time `json:"freeTrialEndTime,omitempty" azure:"ro"`

	// READ-ONLY; The streaming endpoint host name.
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the streaming endpoint was last modified.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the streaming endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource state of the streaming endpoint.
	ResourceState *StreamingEndpointResourceState `json:"resourceState,omitempty" azure:"ro"`
}

type StreamingEndpointSKUInfoListResult struct {
	// The result of the List StreamingEndpoint skus.
	Value []*ArmStreamingEndpointSKUInfo `json:"value,omitempty"`
}

// StreamingEndpointsClientAsyncOperationOptions contains the optional parameters for the StreamingEndpointsClient.AsyncOperation
// method.
type StreamingEndpointsClientAsyncOperationOptions struct {
	// placeholder for future optional parameters
}

// StreamingEndpointsClientBeginCreateOptions contains the optional parameters for the StreamingEndpointsClient.BeginCreate
// method.
type StreamingEndpointsClientBeginCreateOptions struct {
	// The flag indicates if the resource should be automatically started on creation.
	AutoStart *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingEndpointsClientBeginDeleteOptions contains the optional parameters for the StreamingEndpointsClient.BeginDelete
// method.
type StreamingEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingEndpointsClientBeginScaleOptions contains the optional parameters for the StreamingEndpointsClient.BeginScale
// method.
type StreamingEndpointsClientBeginScaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingEndpointsClientBeginStartOptions contains the optional parameters for the StreamingEndpointsClient.BeginStart
// method.
type StreamingEndpointsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingEndpointsClientBeginStopOptions contains the optional parameters for the StreamingEndpointsClient.BeginStop method.
type StreamingEndpointsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingEndpointsClientBeginUpdateOptions contains the optional parameters for the StreamingEndpointsClient.BeginUpdate
// method.
type StreamingEndpointsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingEndpointsClientGetOptions contains the optional parameters for the StreamingEndpointsClient.Get method.
type StreamingEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StreamingEndpointsClientListOptions contains the optional parameters for the StreamingEndpointsClient.List method.
type StreamingEndpointsClientListOptions struct {
	// placeholder for future optional parameters
}

// StreamingEndpointsClientOperationLocationOptions contains the optional parameters for the StreamingEndpointsClient.OperationLocation
// method.
type StreamingEndpointsClientOperationLocationOptions struct {
	// placeholder for future optional parameters
}

// StreamingEndpointsClientSKUsOptions contains the optional parameters for the StreamingEndpointsClient.SKUs method.
type StreamingEndpointsClientSKUsOptions struct {
	// placeholder for future optional parameters
}

// StreamingEntityScaleUnit - scale units definition
type StreamingEntityScaleUnit struct {
	// The scale unit number of the streaming endpoint.
	ScaleUnit *int32 `json:"scaleUnit,omitempty"`
}

// StreamingLocator - A Streaming Locator resource
type StreamingLocator struct {
	// Properties of the Streaming Locator.
	Properties *StreamingLocatorProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StreamingLocatorCollection - A collection of StreamingLocator items.
type StreamingLocatorCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of StreamingLocator items.
	Value []*StreamingLocator `json:"value,omitempty"`
}

// StreamingLocatorContentKey - Class for content key in Streaming Locator
type StreamingLocatorContentKey struct {
	// REQUIRED; ID of Content Key
	ID *string `json:"id,omitempty"`

	// Label of Content Key as specified in the Streaming Policy
	LabelReferenceInStreamingPolicy *string `json:"labelReferenceInStreamingPolicy,omitempty"`

	// Value of Content Key
	Value *string `json:"value,omitempty"`

	// READ-ONLY; ContentKeyPolicy used by Content Key
	PolicyName *string `json:"policyName,omitempty" azure:"ro"`

	// READ-ONLY; Tracks which use this Content Key
	Tracks []*TrackSelection `json:"tracks,omitempty" azure:"ro"`

	// READ-ONLY; Encryption type of Content Key
	Type *StreamingLocatorContentKeyType `json:"type,omitempty" azure:"ro"`
}

// StreamingLocatorProperties - Properties of the Streaming Locator.
type StreamingLocatorProperties struct {
	// REQUIRED; Asset Name
	AssetName *string `json:"assetName,omitempty"`

	// REQUIRED; Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you
	// created or use one of the predefined Streaming Policies. The predefined Streaming Policies
	// available are: 'PredefinedDownloadOnly', 'PredefinedClearStreamingOnly', 'PredefinedDownloadAndClearStreaming', 'PredefinedClearKey',
	// 'PredefinedMultiDrmCencStreaming' and 'Predefined
	// MultiDrmStreaming'
	StreamingPolicyName *string `json:"streamingPolicyName,omitempty"`

	// Alternative Media ID of this Streaming Locator
	AlternativeMediaID *string `json:"alternativeMediaId,omitempty"`

	// The ContentKeys used by this Streaming Locator.
	ContentKeys []*StreamingLocatorContentKey `json:"contentKeys,omitempty"`

	// Name of the default ContentKeyPolicy used by this Streaming Locator.
	DefaultContentKeyPolicyName *string `json:"defaultContentKeyPolicyName,omitempty"`

	// The end time of the Streaming Locator.
	EndTime *time.Time `json:"endTime,omitempty"`

	// A list of asset or account filters which apply to this streaming locator
	Filters []*string `json:"filters,omitempty"`

	// The start time of the Streaming Locator.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The StreamingLocatorId of the Streaming Locator.
	StreamingLocatorID *string `json:"streamingLocatorId,omitempty"`

	// READ-ONLY; The creation time of the Streaming Locator.
	Created *time.Time `json:"created,omitempty" azure:"ro"`
}

// StreamingLocatorsClientCreateOptions contains the optional parameters for the StreamingLocatorsClient.Create method.
type StreamingLocatorsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// StreamingLocatorsClientDeleteOptions contains the optional parameters for the StreamingLocatorsClient.Delete method.
type StreamingLocatorsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StreamingLocatorsClientGetOptions contains the optional parameters for the StreamingLocatorsClient.Get method.
type StreamingLocatorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StreamingLocatorsClientListContentKeysOptions contains the optional parameters for the StreamingLocatorsClient.ListContentKeys
// method.
type StreamingLocatorsClientListContentKeysOptions struct {
	// placeholder for future optional parameters
}

// StreamingLocatorsClientListOptions contains the optional parameters for the StreamingLocatorsClient.List method.
type StreamingLocatorsClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies the key by which the result collection should be ordered.
	Orderby *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// StreamingLocatorsClientListPathsOptions contains the optional parameters for the StreamingLocatorsClient.ListPaths method.
type StreamingLocatorsClientListPathsOptions struct {
	// placeholder for future optional parameters
}

// StreamingPath - Class of paths for streaming
type StreamingPath struct {
	// REQUIRED; Encryption scheme
	EncryptionScheme *EncryptionScheme `json:"encryptionScheme,omitempty"`

	// REQUIRED; Streaming protocol
	StreamingProtocol *StreamingPolicyStreamingProtocol `json:"streamingProtocol,omitempty"`

	// Streaming paths for each protocol and encryptionScheme pair
	Paths []*string `json:"paths,omitempty"`
}

// StreamingPoliciesClientCreateOptions contains the optional parameters for the StreamingPoliciesClient.Create method.
type StreamingPoliciesClientCreateOptions struct {
	// placeholder for future optional parameters
}

// StreamingPoliciesClientDeleteOptions contains the optional parameters for the StreamingPoliciesClient.Delete method.
type StreamingPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StreamingPoliciesClientGetOptions contains the optional parameters for the StreamingPoliciesClient.Get method.
type StreamingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// StreamingPoliciesClientListOptions contains the optional parameters for the StreamingPoliciesClient.List method.
type StreamingPoliciesClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies the key by which the result collection should be ordered.
	Orderby *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// StreamingPolicy - A Streaming Policy resource
type StreamingPolicy struct {
	// Class to specify properties of Streaming Policy
	Properties *StreamingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StreamingPolicyCollection - A collection of StreamingPolicy items.
type StreamingPolicyCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of StreamingPolicy items.
	Value []*StreamingPolicy `json:"value,omitempty"`
}

// StreamingPolicyContentKey - Class to specify properties of content key
type StreamingPolicyContentKey struct {
	// Label can be used to specify Content Key when creating a Streaming Locator
	Label *string `json:"label,omitempty"`

	// Policy used by Content Key
	PolicyName *string `json:"policyName,omitempty"`

	// Tracks which use this content key
	Tracks []*TrackSelection `json:"tracks,omitempty"`
}

// StreamingPolicyContentKeys - Class to specify properties of all content keys in Streaming Policy
type StreamingPolicyContentKeys struct {
	// Default content key for an encryption scheme
	DefaultKey *DefaultKey `json:"defaultKey,omitempty"`

	// Representing tracks needs separate content key
	KeyToTrackMappings []*StreamingPolicyContentKey `json:"keyToTrackMappings,omitempty"`
}

// StreamingPolicyFairPlayConfiguration - Class to specify configurations of FairPlay in Streaming Policy
type StreamingPolicyFairPlayConfiguration struct {
	// REQUIRED; All license to be persistent or not
	AllowPersistentLicense *bool `json:"allowPersistentLicense,omitempty"`

	// Template for the URL of the custom service delivering licenses to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that the
	// service will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being
	// requested.
	CustomLicenseAcquisitionURLTemplate *string `json:"customLicenseAcquisitionUrlTemplate,omitempty"`
}

// StreamingPolicyPlayReadyConfiguration - Class to specify configurations of PlayReady in Streaming Policy
type StreamingPolicyPlayReadyConfiguration struct {
	// Template for the URL of the custom service delivering licenses to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that the
	// service will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being
	// requested.
	CustomLicenseAcquisitionURLTemplate *string `json:"customLicenseAcquisitionUrlTemplate,omitempty"`

	// Custom attributes for PlayReady
	PlayReadyCustomAttributes *string `json:"playReadyCustomAttributes,omitempty"`
}

// StreamingPolicyProperties - Class to specify properties of Streaming Policy
type StreamingPolicyProperties struct {
	// Configuration of CommonEncryptionCbcs
	CommonEncryptionCbcs *CommonEncryptionCbcs `json:"commonEncryptionCbcs,omitempty"`

	// Configuration of CommonEncryptionCenc
	CommonEncryptionCenc *CommonEncryptionCenc `json:"commonEncryptionCenc,omitempty"`

	// Default ContentKey used by current Streaming Policy
	DefaultContentKeyPolicyName *string `json:"defaultContentKeyPolicyName,omitempty"`

	// Configuration of EnvelopeEncryption
	EnvelopeEncryption *EnvelopeEncryption `json:"envelopeEncryption,omitempty"`

	// Configurations of NoEncryption
	NoEncryption *NoEncryption `json:"noEncryption,omitempty"`

	// READ-ONLY; Creation time of Streaming Policy
	Created *time.Time `json:"created,omitempty" azure:"ro"`
}

// StreamingPolicyWidevineConfiguration - Class to specify configurations of Widevine in Streaming Policy
type StreamingPolicyWidevineConfiguration struct {
	// Template for the URL of the custom service delivering licenses to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that the
	// service will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being
	// requested.
	CustomLicenseAcquisitionURLTemplate *string `json:"customLicenseAcquisitionUrlTemplate,omitempty"`
}

// SyncStorageKeysInput - The input to the sync storage keys request.
type SyncStorageKeysInput struct {
	// The ID of the storage account resource.
	ID *string `json:"id,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TextTrack - Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video
// tracks.
type TextTrack struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
	DisplayName *string `json:"displayName,omitempty"`

	// The file name to the source file. This file is located in the storage container of the asset.
	FileName *string `json:"fileName,omitempty"`

	// The HLS specific setting for the text track.
	HlsSettings *HlsSettings `json:"hlsSettings,omitempty"`

	// When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested
	// by a client. When the PlayerVisibility is set to "Hidden", the text will
	// not be available to the client. The default value is "Visible".
	PlayerVisibility *Visibility `json:"playerVisibility,omitempty"`

	// READ-ONLY; The RFC5646 language code for the text track.
	LanguageCode *string `json:"languageCode,omitempty" azure:"ro"`
}

// GetTrackBase implements the TrackBaseClassification interface for type TextTrack.
func (t *TextTrack) GetTrackBase() *TrackBase {
	return &TrackBase{
		ODataType: t.ODataType,
	}
}

// TrackBaseClassification provides polymorphic access to related types.
// Call the interface's GetTrackBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioTrack, *TextTrack, *TrackBase, *VideoTrack
type TrackBaseClassification interface {
	// GetTrackBase returns the TrackBase content of the underlying type.
	GetTrackBase() *TrackBase
}

// TrackBase - Base type for concrete track types. A derived type must be used to represent the Track.
type TrackBase struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetTrackBase implements the TrackBaseClassification interface for type TrackBase.
func (t *TrackBase) GetTrackBase() *TrackBase { return t }

// TrackDescriptorClassification provides polymorphic access to related types.
// Call the interface's GetTrackDescriptor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioTrackDescriptor, *SelectAudioTrackByAttribute, *SelectAudioTrackByID, *SelectVideoTrackByAttribute, *SelectVideoTrackByID,
// - *TrackDescriptor, *VideoTrackDescriptor
type TrackDescriptorClassification interface {
	// GetTrackDescriptor returns the TrackDescriptor content of the underlying type.
	GetTrackDescriptor() *TrackDescriptor
}

// TrackDescriptor - Base type for all TrackDescriptor types, which define the metadata and selection for tracks that should
// be processed by a Job
type TrackDescriptor struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type TrackDescriptor.
func (t *TrackDescriptor) GetTrackDescriptor() *TrackDescriptor { return t }

// TrackPropertyCondition - Class to specify one track property condition
type TrackPropertyCondition struct {
	// REQUIRED; Track property condition operation
	Operation *TrackPropertyCompareOperation `json:"operation,omitempty"`

	// REQUIRED; Track property type
	Property *TrackPropertyType `json:"property,omitempty"`

	// Track property value
	Value *string `json:"value,omitempty"`
}

// TrackSelection - Class to select a track
type TrackSelection struct {
	// TrackSelections is a track property condition list which can specify track(s)
	TrackSelections []*TrackPropertyCondition `json:"trackSelections,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TracksClientBeginCreateOrUpdateOptions contains the optional parameters for the TracksClient.BeginCreateOrUpdate method.
type TracksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TracksClientBeginDeleteOptions contains the optional parameters for the TracksClient.BeginDelete method.
type TracksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TracksClientBeginUpdateOptions contains the optional parameters for the TracksClient.BeginUpdate method.
type TracksClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TracksClientBeginUpdateTrackDataOptions contains the optional parameters for the TracksClient.BeginUpdateTrackData method.
type TracksClientBeginUpdateTrackDataOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TracksClientGetOptions contains the optional parameters for the TracksClient.Get method.
type TracksClientGetOptions struct {
	// placeholder for future optional parameters
}

// TracksClientListOptions contains the optional parameters for the TracksClient.List method.
type TracksClientListOptions struct {
	// placeholder for future optional parameters
}

// Transform - A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as
// by transcoding or by extracting insights. After the Transform is created, it can be applied
// to input media by creating Jobs.
type Transform struct {
	// The resource properties.
	Properties *TransformProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransformCollection - A collection of Transform items.
type TransformCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A collection of Transform items.
	Value []*Transform `json:"value,omitempty"`
}

// TransformOutput - Describes the properties of a TransformOutput, which are the rules to be applied while generating the
// desired output.
type TransformOutput struct {
	// REQUIRED; Preset that describes the operations that will be used to modify, transcode, or extract insights from the source
	// file to generate the output.
	Preset PresetClassification `json:"preset,omitempty"`

	// A Transform can define more than one outputs. This property defines what the service should do when one output fails -
	// either continue to produce other outputs, or, stop the other outputs. The overall
	// Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
	OnError *OnErrorType `json:"onError,omitempty"`

	// Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for
	// processing TransformOutputs. The default priority is Normal.
	RelativePriority *Priority `json:"relativePriority,omitempty"`
}

// TransformProperties - A Transform.
type TransformProperties struct {
	// REQUIRED; An array of one or more TransformOutputs that the Transform should generate.
	Outputs []*TransformOutput `json:"outputs,omitempty"`

	// An optional verbose description of the Transform.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The UTC date and time when the Transform was created, in 'YYYY-MM-DDThh:mm:ssZ' format.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The UTC date and time when the Transform was last updated, in 'YYYY-MM-DDThh:mm:ssZ' format.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`
}

// TransformsClientCreateOrUpdateOptions contains the optional parameters for the TransformsClient.CreateOrUpdate method.
type TransformsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TransformsClientDeleteOptions contains the optional parameters for the TransformsClient.Delete method.
type TransformsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TransformsClientGetOptions contains the optional parameters for the TransformsClient.Get method.
type TransformsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TransformsClientListOptions contains the optional parameters for the TransformsClient.List method.
type TransformsClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies the key by which the result collection should be ordered.
	Orderby *string
}

// TransformsClientUpdateOptions contains the optional parameters for the TransformsClient.Update method.
type TransformsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// TransportStreamFormat - Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video
// file(s).
type TransportStreamFormat struct {
	// REQUIRED; The pattern of the file names for the generated output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec.
	// {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The list of output files to produce. Each entry in the list is a set of audio and video layer labels to be muxed together
	// .
	OutputFiles []*OutputFile `json:"outputFiles,omitempty"`
}

// GetFormat implements the FormatClassification interface for type TransportStreamFormat.
func (t *TransportStreamFormat) GetFormat() *Format {
	return &Format{
		ODataType:       t.ODataType,
		FilenamePattern: t.FilenamePattern,
	}
}

// GetMultiBitrateFormat implements the MultiBitrateFormatClassification interface for type TransportStreamFormat.
func (t *TransportStreamFormat) GetMultiBitrateFormat() *MultiBitrateFormat {
	return &MultiBitrateFormat{
		OutputFiles:     t.OutputFiles,
		ODataType:       t.ODataType,
		FilenamePattern: t.FilenamePattern,
	}
}

// UTCClipTime - Specifies the clip time as a Utc time position in the media file. The Utc time can point to a different position
// depending on whether the media file starts from a timestamp of zero or not.
type UTCClipTime struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// REQUIRED; The time position on the timeline of the input media based on Utc time.
	Time *time.Time `json:"time,omitempty"`
}

// GetClipTime implements the ClipTimeClassification interface for type UTCClipTime.
func (u *UTCClipTime) GetClipTime() *ClipTime {
	return &ClipTime{
		ODataType: u.ODataType,
	}
}

type UserAssignedManagedIdentity struct {
	// READ-ONLY; The client ID.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VideoClassification provides polymorphic access to related types.
// Call the interface's GetVideo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *H264Video, *H265Video, *Image, *JpgImage, *PNGImage, *Video
type VideoClassification interface {
	CodecClassification
	// GetVideo returns the Video content of the underlying type.
	GetVideo() *Video
}

// Video - Describes the basic properties for encoding the input video.
type Video struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode `json:"stretchMode,omitempty"`

	// The Video Sync Mode
	SyncMode *VideoSyncMode `json:"syncMode,omitempty"`
}

// GetCodec implements the CodecClassification interface for type Video.
func (v *Video) GetCodec() *Codec {
	return &Codec{
		ODataType: v.ODataType,
		Label:     v.Label,
	}
}

// GetVideo implements the VideoClassification interface for type Video.
func (v *Video) GetVideo() *Video { return v }

// VideoAnalyzerPreset - A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs
// a JSON format file.
type VideoAnalyzerPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). If you
	// know the language of your content, it is recommended that you specify it. The
	// language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included
	// in basic mode. If the language isn't specified or set to null, automatic language
	// detection will choose the first language detected and process with the selected language for the duration of the file.
	// It does not currently support dynamically switching between languages after the
	// first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If
	// automatic detection fails to find the language, transcription would fallback to
	// 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
	AudioLanguage *string `json:"audioLanguage,omitempty"`

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string `json:"experimentalOptions,omitempty"`

	// Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly',
	// and 'AllInsights'. The default is AllInsights. If you set this to
	// AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only,
	// then only video insights are generated. It is recommended that you not use
	// AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your
	// inputs to be audio only. Your Jobs in such conditions would error out.
	InsightsToExtract *InsightsType `json:"insightsToExtract,omitempty"`

	// Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be
	// chosen.
	Mode *AudioAnalysisMode `json:"mode,omitempty"`
}

// GetAudioAnalyzerPreset implements the AudioAnalyzerPresetClassification interface for type VideoAnalyzerPreset.
func (v *VideoAnalyzerPreset) GetAudioAnalyzerPreset() *AudioAnalyzerPreset {
	return &AudioAnalyzerPreset{
		AudioLanguage:       v.AudioLanguage,
		Mode:                v.Mode,
		ExperimentalOptions: v.ExperimentalOptions,
		ODataType:           v.ODataType,
	}
}

// GetPreset implements the PresetClassification interface for type VideoAnalyzerPreset.
func (v *VideoAnalyzerPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: v.ODataType,
	}
}

// VideoLayer - Describes the settings to be used when encoding the input video into a desired output bitrate layer.
type VideoLayer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. This is
	// a required field.
	Bitrate *int32 `json:"bitrate,omitempty"`

	// Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on
	// whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string `json:"label,omitempty"`

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
}

// VideoOverlay - Describes the properties of a video overlay.
type VideoOverlay struct {
	// REQUIRED; The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can
	// specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV,
	// MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video
	// file formats.
	InputLabel *string `json:"inputLabel,omitempty"`

	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`

	// The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64 `json:"audioGainLevel,omitempty"`

	// An optional rectangular window used to crop the overlay image or video.
	CropRectangle *Rectangle `json:"cropRectangle,omitempty"`

	// The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format.
	// For example, PT30S to end the overlay at 30 seconds into the input video. If not
	// specified or the value is greater than the input video duration, the overlay will be applied until the end of the input
	// video if the overlay media duration is greater than the input video duration,
	// else the overlay will last as long as the overlay media duration.
	End *string `json:"end,omitempty"`

	// The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If
	// not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string `json:"fadeInDuration,omitempty"`

	// The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not
	// specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string `json:"fadeOutDuration,omitempty"`

	// The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
	Opacity *float64 `json:"opacity,omitempty"`

	// The location in the input video where the overlay is applied.
	Position *Rectangle `json:"position,omitempty"`

	// The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format.
	// For example, PT05S to start the overlay at 5 seconds into the input video.
	// If not specified the overlay starts from the beginning of the input video.
	Start *string `json:"start,omitempty"`
}

// GetOverlay implements the OverlayClassification interface for type VideoOverlay.
func (v *VideoOverlay) GetOverlay() *Overlay {
	return &Overlay{
		ODataType:       v.ODataType,
		InputLabel:      v.InputLabel,
		Start:           v.Start,
		End:             v.End,
		FadeInDuration:  v.FadeInDuration,
		FadeOutDuration: v.FadeOutDuration,
		AudioGainLevel:  v.AudioGainLevel,
	}
}

// VideoTrack - Represents a video track in the asset.
type VideoTrack struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetTrackBase implements the TrackBaseClassification interface for type VideoTrack.
func (v *VideoTrack) GetTrackBase() *TrackBase {
	return &TrackBase{
		ODataType: v.ODataType,
	}
}

// VideoTrackDescriptorClassification provides polymorphic access to related types.
// Call the interface's GetVideoTrackDescriptor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SelectVideoTrackByAttribute, *SelectVideoTrackByID, *VideoTrackDescriptor
type VideoTrackDescriptorClassification interface {
	TrackDescriptorClassification
	// GetVideoTrackDescriptor returns the VideoTrackDescriptor content of the underlying type.
	GetVideoTrackDescriptor() *VideoTrackDescriptor
}

// VideoTrackDescriptor - A TrackSelection to select video tracks.
type VideoTrackDescriptor struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string `json:"@odata.type,omitempty"`
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type VideoTrackDescriptor.
func (v *VideoTrackDescriptor) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: v.ODataType,
	}
}

// GetVideoTrackDescriptor implements the VideoTrackDescriptorClassification interface for type VideoTrackDescriptor.
func (v *VideoTrackDescriptor) GetVideoTrackDescriptor() *VideoTrackDescriptor { return v }
