//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatabox

import "time"

type APIError struct {
	// REQUIRED
	Error *ErrorDetail `json:"error,omitempty"`
}

// AccountCopyLogDetails - Copy log details for a storage account of a DataBox job
type AccountCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`

	// READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy logs.
	CopyLogLink *string `json:"copyLogLink,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy verbose logs. This will be set only when LogCollectionLevel is set to Verbose.
	CopyVerboseLogLink *string `json:"copyVerboseLogLink,omitempty" azure:"ro"`
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type AccountCopyLogDetails.
func (a *AccountCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: a.CopyLogDetailsType,
	}
}

// AccountCredentialDetails - Credential details of the account.
type AccountCredentialDetails struct {
	// READ-ONLY; Connection string of the account endpoint to use the account as a storage endpoint on the device.
	AccountConnectionString *string `json:"accountConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; Name of the account.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Type of the account.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty" azure:"ro"`

	// READ-ONLY; Per share level unencrypted access credentials.
	ShareCredentialDetails []*ShareCredentialDetails `json:"shareCredentialDetails,omitempty" azure:"ro"`
}

// AdditionalErrorInfo - This class represents additional info which Resource Providers pass when an error occurs.
type AdditionalErrorInfo struct {
	// Additional information of the type of error.
	Info interface{} `json:"info,omitempty"`

	// Type of error (e.g. CustomerIntervention, PolicyViolation, SecurityViolation).
	Type *string `json:"type,omitempty"`
}

// AddressValidationOutput - Output of the address validation api.
type AddressValidationOutput struct {
	// READ-ONLY; The address validation properties.
	Properties *AddressValidationProperties `json:"properties,omitempty" azure:"ro"`
}

// AddressValidationProperties - The address validation output.
type AddressValidationProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; List of alternate addresses.
	AlternateAddresses []*ShippingAddress `json:"alternateAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The address validation status.
	ValidationStatus *AddressValidationStatus `json:"validationStatus,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type AddressValidationProperties.
func (a *AddressValidationProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		ValidationType: a.ValidationType,
		Error:          a.Error,
	}
}

// ApplianceNetworkConfiguration - The Network Adapter configuration of a DataBox.
type ApplianceNetworkConfiguration struct {
	// READ-ONLY; Mac Address.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Name of the network.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// ArmBaseObject - Base class for all objects under resource.
type ArmBaseObject struct {
	// READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AvailableSKURequest - The filters for showing the available skus.
type AvailableSKURequest struct {
	// REQUIRED; ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO3166-1alpha-2#Officiallyassignedcode_elements
	Country *string `json:"country,omitempty"`

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`

	// REQUIRED; Type of the transfer.
	TransferType *TransferType `json:"transferType,omitempty"`

	// Sku Names to filter for available skus
	SKUNames []*SKUName `json:"skuNames,omitempty"`
}

// AvailableSKUsResult - The available skus operation response.
type AvailableSKUsResult struct {
	// Link for the next set of skus.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of available skus.
	Value []*SKUInformation `json:"value,omitempty" azure:"ro"`
}

// AzureFileFilterDetails - Filter details to transfer Azure files
type AzureFileFilterDetails struct {
	// List of full path of the files to be transferred.
	FilePathList []*string `json:"filePathList,omitempty"`

	// Prefix list of the Azure files to be transferred.
	FilePrefixList []*string `json:"filePrefixList,omitempty"`

	// List of file shares to be transferred.
	FileShareList []*string `json:"fileShareList,omitempty"`
}

// BlobFilterDetails - Filter details to transfer Azure Blobs
type BlobFilterDetails struct {
	// List of full path of the blobs to be transferred.
	BlobPathList []*string `json:"blobPathList,omitempty"`

	// Prefix list of the Azure blobs to be transferred.
	BlobPrefixList []*string `json:"blobPrefixList,omitempty"`

	// List of blob containers to be transferred.
	ContainerList []*string `json:"containerList,omitempty"`
}

// CancellationReason - Reason for cancellation.
type CancellationReason struct {
	// REQUIRED; Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// CloudError - Provides additional information about an http error response.
type CloudError struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// The error message parsed from the body of the http error response.
	Message *string `json:"message,omitempty"`

	// Gets or sets the target of the error.
	Target *string `json:"target,omitempty"`

	// READ-ONLY; Gets or sets additional error info.
	AdditionalInfo []*AdditionalErrorInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets details for the error.
	Details []*CloudError `json:"details,omitempty" azure:"ro"`
}

// CommonJobDetailsClassification provides polymorphic access to related types.
// Call the interface's GetCommonJobDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CommonJobDetails, *CustomerDiskJobDetails, *DiskJobDetails, *HeavyJobDetails, *JobDetails
type CommonJobDetailsClassification interface {
	// GetCommonJobDetails returns the CommonJobDetails content of the underlying type.
	GetCommonJobDetails() *CommonJobDetails
}

// CommonJobDetails - Job details.
type CommonJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator `json:"jobDetailsType,omitempty"`

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails `json:"dataExportDetails,omitempty"`

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails `json:"dataImportDetails,omitempty"`

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`

	// Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty" azure:"ro"`

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification `json:"copyLogDetails,omitempty" azure:"ro"`

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode `json:"dataCenterCode,omitempty" azure:"ro"`

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification `json:"datacenterAddress,omitempty" azure:"ro"`

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty" azure:"ro"`

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails `json:"deviceErasureDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages `json:"jobStages,omitempty" azure:"ro"`

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob `json:"lastMitigationActionOnJob,omitempty" azure:"ro"`

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty" azure:"ro"`
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type CommonJobDetails.
func (c *CommonJobDetails) GetCommonJobDetails() *CommonJobDetails { return c }

// CommonJobSecretsClassification provides polymorphic access to related types.
// Call the interface's GetCommonJobSecrets() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CommonJobSecrets, *CustomerDiskJobSecrets, *DiskJobSecrets, *HeavyJobSecrets, *JobSecrets
type CommonJobSecretsClassification interface {
	// GetCommonJobSecrets returns the CommonJobSecrets content of the underlying type.
	GetCommonJobSecrets() *CommonJobSecrets
}

// CommonJobSecrets - The base class for the secrets
type CommonJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator `json:"jobSecretsType,omitempty"`

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty" azure:"ro"`

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty" azure:"ro"`
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type CommonJobSecrets.
func (c *CommonJobSecrets) GetCommonJobSecrets() *CommonJobSecrets { return c }

// CommonScheduleAvailabilityRequestClassification provides polymorphic access to related types.
// Call the interface's GetCommonScheduleAvailabilityRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CommonScheduleAvailabilityRequest, *DiskScheduleAvailabilityRequest, *HeavyScheduleAvailabilityRequest, *ScheduleAvailabilityRequest
type CommonScheduleAvailabilityRequestClassification interface {
	// GetCommonScheduleAvailabilityRequest returns the CommonScheduleAvailabilityRequest content of the underlying type.
	GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest
}

// CommonScheduleAvailabilityRequest - Request body to get the availability for scheduling orders.
type CommonScheduleAvailabilityRequest struct {
	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName `json:"skuName,omitempty"`

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`

	// Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// CommonScheduleAvailabilityRequest.
func (c *CommonScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return c
}

// ContactDetails - Contact Details.
type ContactDetails struct {
	// REQUIRED; Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`

	// REQUIRED; List of Email-ids to be notified about job progress.
	EmailList []*string `json:"emailList,omitempty"`

	// REQUIRED; Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`

	// Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`

	// Notification preference for a job stage.
	NotificationPreference []*NotificationPreference `json:"notificationPreference,omitempty"`

	// Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
}

// CopyLogDetailsClassification provides polymorphic access to related types.
// Call the interface's GetCopyLogDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AccountCopyLogDetails, *CopyLogDetails, *CustomerDiskCopyLogDetails, *DiskCopyLogDetails, *HeavyAccountCopyLogDetails
type CopyLogDetailsClassification interface {
	// GetCopyLogDetails returns the CopyLogDetails content of the underlying type.
	GetCopyLogDetails() *CopyLogDetails
}

// CopyLogDetails - Details for log generated during copy.
type CopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type CopyLogDetails.
func (c *CopyLogDetails) GetCopyLogDetails() *CopyLogDetails { return c }

// CopyProgress - Copy progress.
type CopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64 `json:"bytesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64 `json:"directoriesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64 `json:"filesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files processed
	FilesProcessed *int64 `json:"filesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64 `json:"invalidDirectoriesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64 `json:"invalidFileBytesUploaded,omitempty" azure:"ro"`

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64 `json:"invalidFilesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool `json:"isEnumerationInProgress,omitempty" azure:"ro"`

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64 `json:"renamedContainerCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Transfer type of data
	TransferType *TransferType `json:"transferType,omitempty" azure:"ro"`
}

// CreateJobValidations - It does all pre-job creation validations.
type CreateJobValidations struct {
	// REQUIRED; List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails []ValidationInputRequestClassification `json:"individualRequestDetails,omitempty"`

	// REQUIRED; Identify the nature of validation.
	ValidationCategory *string `json:"validationCategory,omitempty"`
}

// GetValidationRequest implements the ValidationRequestClassification interface for type CreateJobValidations.
func (c *CreateJobValidations) GetValidationRequest() *ValidationRequest {
	return &ValidationRequest{
		ValidationCategory:       c.ValidationCategory,
		IndividualRequestDetails: c.IndividualRequestDetails,
	}
}

// CreateOrderLimitForSubscriptionValidationRequest - Request to validate create order limit for current subscription.
type CreateOrderLimitForSubscriptionValidationRequest struct {
	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName `json:"deviceType,omitempty"`

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type CreateOrderLimitForSubscriptionValidationRequest.
func (c *CreateOrderLimitForSubscriptionValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: c.ValidationType,
	}
}

// CreateOrderLimitForSubscriptionValidationResponseProperties - Properties of create order limit for subscription validation
// response.
type CreateOrderLimitForSubscriptionValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Create order limit validation status.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type CreateOrderLimitForSubscriptionValidationResponseProperties.
func (c *CreateOrderLimitForSubscriptionValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		ValidationType: c.ValidationType,
		Error:          c.Error,
	}
}

// CustomerDiskCopyLogDetails - Copy Log Details for customer disk
type CustomerDiskCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`

	// READ-ONLY; Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty" azure:"ro"`

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty" azure:"ro"`
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type CustomerDiskCopyLogDetails.
func (c *CustomerDiskCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: c.CopyLogDetailsType,
	}
}

// CustomerDiskCopyProgress - DataBox CustomerDisk Copy Progress
type CustomerDiskCopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64 `json:"bytesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; The Status of the copy
	CopyStatus *CopyStatus `json:"copyStatus,omitempty" azure:"ro"`

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64 `json:"directoriesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64 `json:"filesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files processed
	FilesProcessed *int64 `json:"filesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64 `json:"invalidDirectoriesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64 `json:"invalidFileBytesUploaded,omitempty" azure:"ro"`

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64 `json:"invalidFilesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool `json:"isEnumerationInProgress,omitempty" azure:"ro"`

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64 `json:"renamedContainerCount,omitempty" azure:"ro"`

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Transfer type of data
	TransferType *TransferType `json:"transferType,omitempty" azure:"ro"`
}

// CustomerDiskJobDetails - Customer disk job details.
type CustomerDiskJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator `json:"jobDetailsType,omitempty"`

	// REQUIRED; Return package shipping details.
	ReturnToCustomerPackageDetails *PackageCarrierDetails `json:"returnToCustomerPackageDetails,omitempty"`

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails `json:"dataExportDetails,omitempty"`

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails `json:"dataImportDetails,omitempty"`

	// Flag to indicate if disk manifest should be backed-up in the Storage Account.
	EnableManifestBackup *bool `json:"enableManifestBackup,omitempty"`

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`

	// Contains the map of disk serial number to the disk details for import jobs.
	ImportDiskDetailsCollection map[string]*ImportDiskDetails `json:"importDiskDetailsCollection,omitempty"`

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`

	// Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty" azure:"ro"`

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification `json:"copyLogDetails,omitempty" azure:"ro"`

	// READ-ONLY; Copy progress per disk.
	CopyProgress []*CustomerDiskCopyProgress `json:"copyProgress,omitempty" azure:"ro"`

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode `json:"dataCenterCode,omitempty" azure:"ro"`

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification `json:"datacenterAddress,omitempty" azure:"ro"`

	// READ-ONLY; Delivery package shipping details.
	DeliverToDcPackageDetails *PackageCarrierInfo `json:"deliverToDcPackageDetails,omitempty" azure:"ro"`

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty" azure:"ro"`

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails `json:"deviceErasureDetails,omitempty" azure:"ro"`

	// READ-ONLY; Contains the map of disk serial number to the disk details for export jobs.
	ExportDiskDetailsCollection map[string]*ExportDiskDetails `json:"exportDiskDetailsCollection,omitempty" azure:"ro"`

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages `json:"jobStages,omitempty" azure:"ro"`

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob `json:"lastMitigationActionOnJob,omitempty" azure:"ro"`

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty" azure:"ro"`
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type CustomerDiskJobDetails.
func (c *CustomerDiskJobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		JobStages:                   c.JobStages,
		ContactDetails:              c.ContactDetails,
		ShippingAddress:             c.ShippingAddress,
		DeliveryPackage:             c.DeliveryPackage,
		ReturnPackage:               c.ReturnPackage,
		DataImportDetails:           c.DataImportDetails,
		DataExportDetails:           c.DataExportDetails,
		JobDetailsType:              c.JobDetailsType,
		Preferences:                 c.Preferences,
		CopyLogDetails:              c.CopyLogDetails,
		ReverseShipmentLabelSasKey:  c.ReverseShipmentLabelSasKey,
		ChainOfCustodySasKey:        c.ChainOfCustodySasKey,
		DeviceErasureDetails:        c.DeviceErasureDetails,
		KeyEncryptionKey:            c.KeyEncryptionKey,
		ExpectedDataSizeInTeraBytes: c.ExpectedDataSizeInTeraBytes,
		Actions:                     c.Actions,
		LastMitigationActionOnJob:   c.LastMitigationActionOnJob,
		DatacenterAddress:           c.DatacenterAddress,
		DataCenterCode:              c.DataCenterCode,
	}
}

// CustomerDiskJobSecrets - The secrets related to customer disk job.
type CustomerDiskJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator `json:"jobSecretsType,omitempty"`

	// READ-ONLY; Carrier Account Number of the customer
	CarrierAccountNumber *string `json:"carrierAccountNumber,omitempty" azure:"ro"`

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty" azure:"ro"`

	// READ-ONLY; Contains the list of secrets object for that device.
	DiskSecrets []*DiskSecret `json:"diskSecrets,omitempty" azure:"ro"`

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty" azure:"ro"`
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type CustomerDiskJobSecrets.
func (c *CustomerDiskJobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		JobSecretsType:       c.JobSecretsType,
		DcAccessSecurityCode: c.DcAccessSecurityCode,
		Error:                c.Error,
	}
}

// DataAccountDetailsClassification provides polymorphic access to related types.
// Call the interface's GetDataAccountDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DataAccountDetails, *ManagedDiskDetails, *StorageAccountDetails
type DataAccountDetailsClassification interface {
	// GetDataAccountDetails returns the DataAccountDetails content of the underlying type.
	GetDataAccountDetails() *DataAccountDetails
}

// DataAccountDetails - Account details of the data to be transferred
type DataAccountDetails struct {
	// REQUIRED; Account Type of the data to be transferred.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty"`

	// Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If
	// this is not passed, the service will generate password itself. This will not be
	// returned in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must
	// have at least one uppercase alphabet, one number and one special character.
	// Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters
	// : @#-$%^!+=;:_()]+
	SharePassword *string `json:"sharePassword,omitempty"`
}

// GetDataAccountDetails implements the DataAccountDetailsClassification interface for type DataAccountDetails.
func (d *DataAccountDetails) GetDataAccountDetails() *DataAccountDetails { return d }

// DataExportDetails - Details of the data to be used for exporting data from azure.
type DataExportDetails struct {
	// REQUIRED; Account details of the data to be transferred
	AccountDetails DataAccountDetailsClassification `json:"accountDetails,omitempty"`

	// REQUIRED; Configuration for the data transfer.
	TransferConfiguration *TransferConfiguration `json:"transferConfiguration,omitempty"`

	// Level of the logs to be collected.
	LogCollectionLevel *LogCollectionLevel `json:"logCollectionLevel,omitempty"`
}

// DataImportDetails - Details of the data to be used for importing data to azure.
type DataImportDetails struct {
	// REQUIRED; Account details of the data to be transferred
	AccountDetails DataAccountDetailsClassification `json:"accountDetails,omitempty"`

	// Level of the logs to be collected.
	LogCollectionLevel *LogCollectionLevel `json:"logCollectionLevel,omitempty"`
}

// DataLocationToServiceLocationMap - Map of data location to service location
type DataLocationToServiceLocationMap struct {
	// READ-ONLY; Location of the data.
	DataLocation *string `json:"dataLocation,omitempty" azure:"ro"`

	// READ-ONLY; Location of the service.
	ServiceLocation *string `json:"serviceLocation,omitempty" azure:"ro"`
}

// DataTransferDetailsValidationRequest - Request to validate export and import data details.
type DataTransferDetailsValidationRequest struct {
	// REQUIRED; Device type.
	DeviceType *SKUName `json:"deviceType,omitempty"`

	// REQUIRED; Type of the transfer.
	TransferType *TransferType `json:"transferType,omitempty"`

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// List of DataTransfer details to be used to export data from azure.
	DataExportDetails []*DataExportDetails `json:"dataExportDetails,omitempty"`

	// List of DataTransfer details to be used to import data to azure.
	DataImportDetails []*DataImportDetails `json:"dataImportDetails,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type DataTransferDetailsValidationRequest.
func (d *DataTransferDetailsValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: d.ValidationType,
	}
}

// DataTransferDetailsValidationResponseProperties - Properties of data transfer details validation response.
type DataTransferDetailsValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Data transfer details validation status.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type DataTransferDetailsValidationResponseProperties.
func (d *DataTransferDetailsValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		ValidationType: d.ValidationType,
		Error:          d.Error,
	}
}

// DatacenterAddressInstructionResponse - Datacenter instruction for given storage location.
type DatacenterAddressInstructionResponse struct {
	// REQUIRED; Data center address type
	DatacenterAddressType *DatacenterAddressType `json:"datacenterAddressType,omitempty"`

	// READ-ONLY; Data center communication instruction
	CommunicationInstruction *string `json:"communicationInstruction,omitempty" azure:"ro"`

	// READ-ONLY; Azure Location where the Data Center serves primarily.
	DataCenterAzureLocation *string `json:"dataCenterAzureLocation,omitempty" azure:"ro"`

	// READ-ONLY; List of supported carriers for return shipment.
	SupportedCarriersForReturnShipment []*string `json:"supportedCarriersForReturnShipment,omitempty" azure:"ro"`
}

// GetDatacenterAddressResponse implements the DatacenterAddressResponseClassification interface for type DatacenterAddressInstructionResponse.
func (d *DatacenterAddressInstructionResponse) GetDatacenterAddressResponse() *DatacenterAddressResponse {
	return &DatacenterAddressResponse{
		DatacenterAddressType:              d.DatacenterAddressType,
		SupportedCarriersForReturnShipment: d.SupportedCarriersForReturnShipment,
		DataCenterAzureLocation:            d.DataCenterAzureLocation,
	}
}

// DatacenterAddressLocationResponse - Datacenter address for given storage location.
type DatacenterAddressLocationResponse struct {
	// REQUIRED; Data center address type
	DatacenterAddressType *DatacenterAddressType `json:"datacenterAddressType,omitempty"`

	// READ-ONLY; Special instruction for shipping
	AdditionalShippingInformation *string `json:"additionalShippingInformation,omitempty" azure:"ro"`

	// READ-ONLY; Address type
	AddressType *string `json:"addressType,omitempty" azure:"ro"`

	// READ-ONLY; City name
	City *string `json:"city,omitempty" azure:"ro"`

	// READ-ONLY; Company name
	Company *string `json:"company,omitempty" azure:"ro"`

	// READ-ONLY; Contact person name
	ContactPersonName *string `json:"contactPersonName,omitempty" azure:"ro"`

	// READ-ONLY; name of the country
	Country *string `json:"country,omitempty" azure:"ro"`

	// READ-ONLY; Azure Location where the Data Center serves primarily.
	DataCenterAzureLocation *string `json:"dataCenterAzureLocation,omitempty" azure:"ro"`

	// READ-ONLY; Phone number
	Phone *string `json:"phone,omitempty" azure:"ro"`

	// READ-ONLY; Phone extension
	PhoneExtension *string `json:"phoneExtension,omitempty" azure:"ro"`

	// READ-ONLY; name of the state
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Street address line 1
	Street1 *string `json:"street1,omitempty" azure:"ro"`

	// READ-ONLY; Street address line 2
	Street2 *string `json:"street2,omitempty" azure:"ro"`

	// READ-ONLY; Street address line 3
	Street3 *string `json:"street3,omitempty" azure:"ro"`

	// READ-ONLY; List of supported carriers for return shipment.
	SupportedCarriersForReturnShipment []*string `json:"supportedCarriersForReturnShipment,omitempty" azure:"ro"`

	// READ-ONLY; Zip code
	Zip *string `json:"zip,omitempty" azure:"ro"`
}

// GetDatacenterAddressResponse implements the DatacenterAddressResponseClassification interface for type DatacenterAddressLocationResponse.
func (d *DatacenterAddressLocationResponse) GetDatacenterAddressResponse() *DatacenterAddressResponse {
	return &DatacenterAddressResponse{
		DatacenterAddressType:              d.DatacenterAddressType,
		SupportedCarriersForReturnShipment: d.SupportedCarriersForReturnShipment,
		DataCenterAzureLocation:            d.DataCenterAzureLocation,
	}
}

// DatacenterAddressRequest - Request body to get the datacenter address.
type DatacenterAddressRequest struct {
	// REQUIRED; Sku Name for which the data center address requested.
	SKUName *SKUName `json:"skuName,omitempty"`

	// REQUIRED; Storage location. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
}

// DatacenterAddressResponseClassification provides polymorphic access to related types.
// Call the interface's GetDatacenterAddressResponse() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DatacenterAddressInstructionResponse, *DatacenterAddressLocationResponse, *DatacenterAddressResponse
type DatacenterAddressResponseClassification interface {
	// GetDatacenterAddressResponse returns the DatacenterAddressResponse content of the underlying type.
	GetDatacenterAddressResponse() *DatacenterAddressResponse
}

// DatacenterAddressResponse - Datacenter address for given storage location.
type DatacenterAddressResponse struct {
	// REQUIRED; Data center address type
	DatacenterAddressType *DatacenterAddressType `json:"datacenterAddressType,omitempty"`

	// READ-ONLY; Azure Location where the Data Center serves primarily.
	DataCenterAzureLocation *string `json:"dataCenterAzureLocation,omitempty" azure:"ro"`

	// READ-ONLY; List of supported carriers for return shipment.
	SupportedCarriersForReturnShipment []*string `json:"supportedCarriersForReturnShipment,omitempty" azure:"ro"`
}

// GetDatacenterAddressResponse implements the DatacenterAddressResponseClassification interface for type DatacenterAddressResponse.
func (d *DatacenterAddressResponse) GetDatacenterAddressResponse() *DatacenterAddressResponse {
	return d
}

// DcAccessSecurityCode - Dc access security code
type DcAccessSecurityCode struct {
	// Forward Dc access security code.
	ForwardDCAccessCode *string `json:"forwardDCAccessCode,omitempty"`

	// Reverse Dc access security code.
	ReverseDCAccessCode *string `json:"reverseDCAccessCode,omitempty"`
}

type Details struct {
	// REQUIRED
	Code *string `json:"code,omitempty"`

	// REQUIRED
	Message *string `json:"message,omitempty"`
}

// DeviceErasureDetails - Device erasure details with erasure completion status and erasureordestructionlog sas key
type DeviceErasureDetails struct {
	// READ-ONLY; Holds the device erasure completion status
	DeviceErasureStatus *StageStatus `json:"deviceErasureStatus,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download cleanup or destruction certificate for device
	ErasureOrDestructionCertificateSasKey *string `json:"erasureOrDestructionCertificateSasKey,omitempty" azure:"ro"`
}

// DiskCopyLogDetails - Copy Log Details for a disk
type DiskCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`

	// READ-ONLY; Disk Serial Number.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty" azure:"ro"`
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type DiskCopyLogDetails.
func (d *DiskCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: d.CopyLogDetailsType,
	}
}

// DiskCopyProgress - DataBox Disk Copy Progress
type DiskCopyProgress struct {
	// READ-ONLY; Bytes copied during the copy of disk.
	BytesCopied *int64 `json:"bytesCopied,omitempty" azure:"ro"`

	// READ-ONLY; Indicates the percentage completed for the copy of the disk.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The serial number of the disk
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; The Status of the copy
	Status *CopyStatus `json:"status,omitempty" azure:"ro"`
}

// DiskGranularCopyLogDetails - Granular Copy Log Details for customer disk
type DiskGranularCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`

	// READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty" azure:"ro"`

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty" azure:"ro"`
}

// GetGranularCopyLogDetails implements the GranularCopyLogDetailsClassification interface for type DiskGranularCopyLogDetails.
func (d *DiskGranularCopyLogDetails) GetGranularCopyLogDetails() *GranularCopyLogDetails {
	return &GranularCopyLogDetails{
		CopyLogDetailsType: d.CopyLogDetailsType,
	}
}

// DiskGranularCopyProgress - DataBox Disk Granular Copy Progress
type DiskGranularCopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64 `json:"bytesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; The Status of the copy
	CopyStatus *CopyStatus `json:"copyStatus,omitempty" azure:"ro"`

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64 `json:"directoriesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64 `json:"filesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files processed
	FilesProcessed *int64 `json:"filesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64 `json:"invalidDirectoriesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64 `json:"invalidFileBytesUploaded,omitempty" azure:"ro"`

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64 `json:"invalidFilesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool `json:"isEnumerationInProgress,omitempty" azure:"ro"`

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64 `json:"renamedContainerCount,omitempty" azure:"ro"`

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Transfer type of data
	TransferType *TransferType `json:"transferType,omitempty" azure:"ro"`
}

// DiskJobDetails - DataBox Disk Job Details.
type DiskJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator `json:"jobDetailsType,omitempty"`

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails `json:"dataExportDetails,omitempty"`

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails `json:"dataImportDetails,omitempty"`

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`

	// User entered passkey for DataBox Disk job.
	Passkey *string `json:"passkey,omitempty"`

	// Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`

	// User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5}
	// means 5 disks of 2 TB size. Key is string but will be checked against an int.
	PreferredDisks map[string]*int32 `json:"preferredDisks,omitempty"`

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty" azure:"ro"`

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification `json:"copyLogDetails,omitempty" azure:"ro"`

	// READ-ONLY; Copy progress per disk.
	CopyProgress []*DiskCopyProgress `json:"copyProgress,omitempty" azure:"ro"`

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode `json:"dataCenterCode,omitempty" azure:"ro"`

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification `json:"datacenterAddress,omitempty" azure:"ro"`

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty" azure:"ro"`

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails `json:"deviceErasureDetails,omitempty" azure:"ro"`

	// READ-ONLY; Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks
	// are shipped to the customer.
	DisksAndSizeDetails map[string]*int32 `json:"disksAndSizeDetails,omitempty" azure:"ro"`

	// READ-ONLY; Copy progress per disk.
	GranularCopyProgress []*DiskGranularCopyProgress `json:"granularCopyProgress,omitempty" azure:"ro"`

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages `json:"jobStages,omitempty" azure:"ro"`

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob `json:"lastMitigationActionOnJob,omitempty" azure:"ro"`

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty" azure:"ro"`
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type DiskJobDetails.
func (d *DiskJobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		JobStages:                   d.JobStages,
		ContactDetails:              d.ContactDetails,
		ShippingAddress:             d.ShippingAddress,
		DeliveryPackage:             d.DeliveryPackage,
		ReturnPackage:               d.ReturnPackage,
		DataImportDetails:           d.DataImportDetails,
		DataExportDetails:           d.DataExportDetails,
		JobDetailsType:              d.JobDetailsType,
		Preferences:                 d.Preferences,
		CopyLogDetails:              d.CopyLogDetails,
		ReverseShipmentLabelSasKey:  d.ReverseShipmentLabelSasKey,
		ChainOfCustodySasKey:        d.ChainOfCustodySasKey,
		DeviceErasureDetails:        d.DeviceErasureDetails,
		KeyEncryptionKey:            d.KeyEncryptionKey,
		ExpectedDataSizeInTeraBytes: d.ExpectedDataSizeInTeraBytes,
		Actions:                     d.Actions,
		LastMitigationActionOnJob:   d.LastMitigationActionOnJob,
		DatacenterAddress:           d.DatacenterAddress,
		DataCenterCode:              d.DataCenterCode,
	}
}

// DiskJobSecrets - The secrets related to disk job.
type DiskJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator `json:"jobSecretsType,omitempty"`

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty" azure:"ro"`

	// READ-ONLY; Contains the list of secrets object for that device.
	DiskSecrets []*DiskSecret `json:"diskSecrets,omitempty" azure:"ro"`

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Whether passkey was provided by user.
	IsPasskeyUserDefined *bool `json:"isPasskeyUserDefined,omitempty" azure:"ro"`

	// READ-ONLY; PassKey for the disk Job.
	PassKey *string `json:"passKey,omitempty" azure:"ro"`
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type DiskJobSecrets.
func (d *DiskJobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		JobSecretsType:       d.JobSecretsType,
		DcAccessSecurityCode: d.DcAccessSecurityCode,
		Error:                d.Error,
	}
}

// DiskScheduleAvailabilityRequest - Request body to get the availability for scheduling disk orders.
type DiskScheduleAvailabilityRequest struct {
	// REQUIRED; The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`

	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName `json:"skuName,omitempty"`

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`

	// Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// DiskScheduleAvailabilityRequest.
func (d *DiskScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return &CommonScheduleAvailabilityRequest{
		StorageLocation: d.StorageLocation,
		SKUName:         d.SKUName,
		Country:         d.Country,
	}
}

// DiskSecret - Contains all the secrets of a Disk.
type DiskSecret struct {
	// READ-ONLY; Bit Locker key of the disk which can be used to unlock the disk to copy data.
	BitLockerKey *string `json:"bitLockerKey,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the assigned disk.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty" azure:"ro"`
}

// EncryptionPreferences - Preferences related to the Encryption.
type EncryptionPreferences struct {
	// Defines secondary layer of software-based encryption enablement.
	DoubleEncryption *DoubleEncryption `json:"doubleEncryption,omitempty"`
}

type ErrorDetail struct {
	// REQUIRED
	Code *string `json:"code,omitempty"`

	// REQUIRED
	Message *string    `json:"message,omitempty"`
	Details []*Details `json:"details,omitempty"`
	Target  *string    `json:"target,omitempty"`
}

// ExportDiskDetails - Export disk details
type ExportDiskDetails struct {
	// READ-ONLY; Path to backed up manifest, only returned if enableManifestBackup is true.
	BackupManifestCloudPath *string `json:"backupManifestCloudPath,omitempty" azure:"ro"`

	// READ-ONLY; The relative path of the manifest file on the disk.
	ManifestFile *string `json:"manifestFile,omitempty" azure:"ro"`

	// READ-ONLY; The Base16-encoded MD5 hash of the manifest file on the disk.
	ManifestHash *string `json:"manifestHash,omitempty" azure:"ro"`
}

// FilterFileDetails - Details of the filter files to be used for data transfer.
type FilterFileDetails struct {
	// REQUIRED; Path of the file that contains the details of all items to transfer.
	FilterFilePath *string `json:"filterFilePath,omitempty"`

	// REQUIRED; Type of the filter file.
	FilterFileType *FilterFileType `json:"filterFileType,omitempty"`
}

// GranularCopyLogDetailsClassification provides polymorphic access to related types.
// Call the interface's GetGranularCopyLogDetails() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DiskGranularCopyLogDetails, *GranularCopyLogDetails
type GranularCopyLogDetailsClassification interface {
	// GetGranularCopyLogDetails returns the GranularCopyLogDetails content of the underlying type.
	GetGranularCopyLogDetails() *GranularCopyLogDetails
}

// GranularCopyLogDetails - Granular Details for log generated during copy.
type GranularCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`
}

// GetGranularCopyLogDetails implements the GranularCopyLogDetailsClassification interface for type GranularCopyLogDetails.
func (g *GranularCopyLogDetails) GetGranularCopyLogDetails() *GranularCopyLogDetails { return g }

// GranularCopyProgress - Granular Copy progress.
type GranularCopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64 `json:"bytesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64 `json:"directoriesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64 `json:"filesErroredOut,omitempty" azure:"ro"`

	// READ-ONLY; Number of files processed
	FilesProcessed *int64 `json:"filesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64 `json:"invalidDirectoriesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64 `json:"invalidFileBytesUploaded,omitempty" azure:"ro"`

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64 `json:"invalidFilesProcessed,omitempty" azure:"ro"`

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool `json:"isEnumerationInProgress,omitempty" azure:"ro"`

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64 `json:"renamedContainerCount,omitempty" azure:"ro"`

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty" azure:"ro"`

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty" azure:"ro"`

	// READ-ONLY; Transfer type of data
	TransferType *TransferType `json:"transferType,omitempty" azure:"ro"`
}

// HeavyAccountCopyLogDetails - Copy log details for a storage account for Databox heavy
type HeavyAccountCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator `json:"copyLogDetailsType,omitempty"`

	// READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy logs.
	CopyLogLink []*string `json:"copyLogLink,omitempty" azure:"ro"`

	// READ-ONLY; Link for copy verbose logs. This will be set only when the LogCollectionLevel is set to verbose.
	CopyVerboseLogLink []*string `json:"copyVerboseLogLink,omitempty" azure:"ro"`
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type HeavyAccountCopyLogDetails.
func (h *HeavyAccountCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: h.CopyLogDetailsType,
	}
}

// HeavyJobDetails - Databox Heavy Device Job Details
type HeavyJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator `json:"jobDetailsType,omitempty"`

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails `json:"dataExportDetails,omitempty"`

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails `json:"dataImportDetails,omitempty"`

	// Set Device password for unlocking Databox Heavy. Should not be passed for TransferType:ExportFromAzure jobs. If this is
	// not passed, the service will generate password itself. This will not be returned
	// in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must have at
	// least one uppercase alphabet, one number and one special character. Password
	// cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+
	DevicePassword *string `json:"devicePassword,omitempty"`

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`

	// Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty" azure:"ro"`

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification `json:"copyLogDetails,omitempty" azure:"ro"`

	// READ-ONLY; Copy progress per account.
	CopyProgress []*CopyProgress `json:"copyProgress,omitempty" azure:"ro"`

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode `json:"dataCenterCode,omitempty" azure:"ro"`

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification `json:"datacenterAddress,omitempty" azure:"ro"`

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty" azure:"ro"`

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails `json:"deviceErasureDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages `json:"jobStages,omitempty" azure:"ro"`

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob `json:"lastMitigationActionOnJob,omitempty" azure:"ro"`

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty" azure:"ro"`
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type HeavyJobDetails.
func (h *HeavyJobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		JobStages:                   h.JobStages,
		ContactDetails:              h.ContactDetails,
		ShippingAddress:             h.ShippingAddress,
		DeliveryPackage:             h.DeliveryPackage,
		ReturnPackage:               h.ReturnPackage,
		DataImportDetails:           h.DataImportDetails,
		DataExportDetails:           h.DataExportDetails,
		JobDetailsType:              h.JobDetailsType,
		Preferences:                 h.Preferences,
		CopyLogDetails:              h.CopyLogDetails,
		ReverseShipmentLabelSasKey:  h.ReverseShipmentLabelSasKey,
		ChainOfCustodySasKey:        h.ChainOfCustodySasKey,
		DeviceErasureDetails:        h.DeviceErasureDetails,
		KeyEncryptionKey:            h.KeyEncryptionKey,
		ExpectedDataSizeInTeraBytes: h.ExpectedDataSizeInTeraBytes,
		Actions:                     h.Actions,
		LastMitigationActionOnJob:   h.LastMitigationActionOnJob,
		DatacenterAddress:           h.DatacenterAddress,
		DataCenterCode:              h.DataCenterCode,
	}
}

// HeavyJobSecrets - The secrets related to a databox heavy job.
type HeavyJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator `json:"jobSecretsType,omitempty"`

	// READ-ONLY; Contains the list of secret objects for a databox heavy job.
	CabinetPodSecrets []*HeavySecret `json:"cabinetPodSecrets,omitempty" azure:"ro"`

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty" azure:"ro"`

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty" azure:"ro"`
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type HeavyJobSecrets.
func (h *HeavyJobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		JobSecretsType:       h.JobSecretsType,
		DcAccessSecurityCode: h.DcAccessSecurityCode,
		Error:                h.Error,
	}
}

// HeavyScheduleAvailabilityRequest - Request body to get the availability for scheduling heavy orders.
type HeavyScheduleAvailabilityRequest struct {
	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName `json:"skuName,omitempty"`

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`

	// Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// HeavyScheduleAvailabilityRequest.
func (h *HeavyScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return &CommonScheduleAvailabilityRequest{
		StorageLocation: h.StorageLocation,
		SKUName:         h.SKUName,
		Country:         h.Country,
	}
}

// HeavySecret - The secrets related to a databox heavy.
type HeavySecret struct {
	// READ-ONLY; Per account level access credentials.
	AccountCredentialDetails []*AccountCredentialDetails `json:"accountCredentialDetails,omitempty" azure:"ro"`

	// READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty" azure:"ro"`

	// READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations []*ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty" azure:"ro"`
}

// IdentityProperties - Managed identity properties.
type IdentityProperties struct {
	// Managed service identity type.
	Type *string `json:"type,omitempty"`

	// User assigned identity properties.
	UserAssigned *UserAssignedProperties `json:"userAssigned,omitempty"`
}

// ImportDiskDetails - Import disk details
type ImportDiskDetails struct {
	// REQUIRED; BitLocker key used to encrypt the disk.
	BitLockerKey *string `json:"bitLockerKey,omitempty"`

	// REQUIRED; The relative path of the manifest file on the disk.
	ManifestFile *string `json:"manifestFile,omitempty"`

	// REQUIRED; The Base16-encoded MD5 hash of the manifest file on the disk.
	ManifestHash *string `json:"manifestHash,omitempty"`

	// READ-ONLY; Path to backed up manifest, only returned if enableManifestBackup is true.
	BackupManifestCloudPath *string `json:"backupManifestCloudPath,omitempty" azure:"ro"`
}

// JobDeliveryInfo - Additional delivery info.
type JobDeliveryInfo struct {
	// Scheduled date time.
	ScheduledDateTime *time.Time `json:"scheduledDateTime,omitempty"`
}

// JobDetails - Databox Job Details
type JobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator `json:"jobDetailsType,omitempty"`

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails `json:"dataExportDetails,omitempty"`

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails `json:"dataImportDetails,omitempty"`

	// Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed,
	// the service will generate password itself. This will not be returned in
	// Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must have at least
	// one uppercase alphabet, one number and one special character. Password cannot
	// have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+
	DevicePassword *string `json:"devicePassword,omitempty"`

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`

	// Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty" azure:"ro"`

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification `json:"copyLogDetails,omitempty" azure:"ro"`

	// READ-ONLY; Copy progress per storage account.
	CopyProgress []*CopyProgress `json:"copyProgress,omitempty" azure:"ro"`

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode `json:"dataCenterCode,omitempty" azure:"ro"`

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification `json:"datacenterAddress,omitempty" azure:"ro"`

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty" azure:"ro"`

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails `json:"deviceErasureDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages `json:"jobStages,omitempty" azure:"ro"`

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob `json:"lastMitigationActionOnJob,omitempty" azure:"ro"`

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty" azure:"ro"`

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty" azure:"ro"`
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type JobDetails.
func (j *JobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		JobStages:                   j.JobStages,
		ContactDetails:              j.ContactDetails,
		ShippingAddress:             j.ShippingAddress,
		DeliveryPackage:             j.DeliveryPackage,
		ReturnPackage:               j.ReturnPackage,
		DataImportDetails:           j.DataImportDetails,
		DataExportDetails:           j.DataExportDetails,
		JobDetailsType:              j.JobDetailsType,
		Preferences:                 j.Preferences,
		CopyLogDetails:              j.CopyLogDetails,
		ReverseShipmentLabelSasKey:  j.ReverseShipmentLabelSasKey,
		ChainOfCustodySasKey:        j.ChainOfCustodySasKey,
		DeviceErasureDetails:        j.DeviceErasureDetails,
		KeyEncryptionKey:            j.KeyEncryptionKey,
		ExpectedDataSizeInTeraBytes: j.ExpectedDataSizeInTeraBytes,
		Actions:                     j.Actions,
		LastMitigationActionOnJob:   j.LastMitigationActionOnJob,
		DatacenterAddress:           j.DatacenterAddress,
		DataCenterCode:              j.DataCenterCode,
	}
}

// JobProperties - Job Properties
type JobProperties struct {
	// REQUIRED; Type of the data transfer.
	TransferType *TransferType `json:"transferType,omitempty"`

	// Delivery Info of Job.
	DeliveryInfo *JobDeliveryInfo `json:"deliveryInfo,omitempty"`

	// Delivery type of Job.
	DeliveryType *JobDeliveryType `json:"deliveryType,omitempty"`

	// Details of a job run. This field will only be sent for expand details filter.
	Details CommonJobDetailsClassification `json:"details,omitempty"`

	// READ-ONLY; Reason for cancellation.
	CancellationReason *string `json:"cancellationReason,omitempty" azure:"ro"`

	// READ-ONLY; Top level error for the job.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty" azure:"ro"`

	// READ-ONLY; Flag to indicate cancellation of scheduled job.
	IsCancellableWithoutFee *bool `json:"isCancellableWithoutFee,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the job is deletable or not.
	IsDeletable *bool `json:"isDeletable,omitempty" azure:"ro"`

	// READ-ONLY; Is Prepare To Ship Enabled on this job
	IsPrepareToShipEnabled *bool `json:"isPrepareToShipEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the shipping address is editable or not.
	IsShippingAddressEditable *bool `json:"isShippingAddressEditable,omitempty" azure:"ro"`

	// READ-ONLY; Time at which the job was started in UTC ISO 8601 format.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Name of the stage which is in progress.
	Status *StageName `json:"status,omitempty" azure:"ro"`
}

// JobResource - Job Resource.
type JobResource struct {
	// REQUIRED; The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East
	// US, Southeast Asia, etc.). The region of a resource cannot be changed once it is
	// created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of a job.
	Properties *JobProperties `json:"properties,omitempty"`

	// REQUIRED; The sku type.
	SKU *SKU `json:"sku,omitempty"`

	// Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobResourceList - Job Resource Collection
type JobResourceList struct {
	// Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of job resources.
	Value []*JobResource `json:"value,omitempty"`
}

// JobResourceUpdateParameter - The JobResourceUpdateParameter.
type JobResourceUpdateParameter struct {
	// Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Properties of a job to be updated.
	Properties *UpdateJobProperties `json:"properties,omitempty"`

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string `json:"tags,omitempty"`
}

// JobSecrets - The secrets related to a databox job.
type JobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator `json:"jobSecretsType,omitempty"`

	// Contains the list of secret objects for a job.
	PodSecrets []*Secret `json:"podSecrets,omitempty"`

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty" azure:"ro"`

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty" azure:"ro"`
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type JobSecrets.
func (j *JobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		JobSecretsType:       j.JobSecretsType,
		DcAccessSecurityCode: j.DcAccessSecurityCode,
		Error:                j.Error,
	}
}

// JobStages - Job stages.
type JobStages struct {
	// READ-ONLY; Display name of the job stage.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Job Stage Details
	JobStageDetails interface{} `json:"jobStageDetails,omitempty" azure:"ro"`

	// READ-ONLY; Name of the job stage.
	StageName *StageName `json:"stageName,omitempty" azure:"ro"`

	// READ-ONLY; Status of the job stage.
	StageStatus *StageStatus `json:"stageStatus,omitempty" azure:"ro"`

	// READ-ONLY; Time for the job stage in UTC ISO 8601 format.
	StageTime *time.Time `json:"stageTime,omitempty" azure:"ro"`
}

// JobsClientBeginCreateOptions contains the optional parameters for the JobsClient.BeginCreate method.
type JobsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobsClientBeginDeleteOptions contains the optional parameters for the JobsClient.BeginDelete method.
type JobsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobsClientBeginUpdateOptions contains the optional parameters for the JobsClient.BeginUpdate method.
type JobsClientBeginUpdateOptions struct {
	// Defines the If-Match condition. The patch will be performed only if the ETag of the job on the server matches this value.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobsClientBookShipmentPickUpOptions contains the optional parameters for the JobsClient.BookShipmentPickUp method.
type JobsClientBookShipmentPickUpOptions struct {
	// placeholder for future optional parameters
}

// JobsClientCancelOptions contains the optional parameters for the JobsClient.Cancel method.
type JobsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// $expand is supported on details parameter for job, which provides details on the job stages.
	Expand *string
}

// JobsClientListByResourceGroupOptions contains the optional parameters for the JobsClient.ListByResourceGroup method.
type JobsClientListByResourceGroupOptions struct {
	// $skipToken is supported on Get list of jobs, which provides the next page in the list of jobs.
	SkipToken *string
}

// JobsClientListCredentialsOptions contains the optional parameters for the JobsClient.ListCredentials method.
type JobsClientListCredentialsOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListOptions contains the optional parameters for the JobsClient.List method.
type JobsClientListOptions struct {
	// $skipToken is supported on Get list of jobs, which provides the next page in the list of jobs.
	SkipToken *string
}

// JobsClientMarkDevicesShippedOptions contains the optional parameters for the JobsClient.MarkDevicesShipped method.
type JobsClientMarkDevicesShippedOptions struct {
	// placeholder for future optional parameters
}

// KeyEncryptionKey - Encryption key containing details about key to encrypt different keys.
type KeyEncryptionKey struct {
	// REQUIRED; Type of encryption key used for key encryption.
	KekType *KekType `json:"kekType,omitempty"`

	// Managed identity properties used for key encryption.
	IdentityProperties *IdentityProperties `json:"identityProperties,omitempty"`

	// Key encryption key. It is required in case of Customer managed KekType.
	KekURL *string `json:"kekUrl,omitempty"`

	// Kek vault resource id. It is required in case of Customer managed KekType.
	KekVaultResourceID *string `json:"kekVaultResourceID,omitempty"`
}

// LastMitigationActionOnJob - Last Mitigation Action Performed On Job
type LastMitigationActionOnJob struct {
	// Action performed date time
	ActionDateTimeInUTC *time.Time `json:"actionDateTimeInUtc,omitempty"`

	// Resolution code provided by customer
	CustomerResolution *CustomerResolutionCode `json:"customerResolution,omitempty"`

	// Action performed by customer, possibility is that mitigation might happen by customer or service or by ops
	IsPerformedByCustomer *bool `json:"isPerformedByCustomer,omitempty"`
}

// ManagedDiskDetails - Details of the managed disks.
type ManagedDiskDetails struct {
	// REQUIRED; Account Type of the data to be transferred.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty"`

	// REQUIRED; Resource Group Id of the compute disks.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`

	// REQUIRED; Resource Id of the storage account that can be used to copy the vhd for staging.
	StagingStorageAccountID *string `json:"stagingStorageAccountId,omitempty"`

	// Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If
	// this is not passed, the service will generate password itself. This will not be
	// returned in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must
	// have at least one uppercase alphabet, one number and one special character.
	// Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters
	// : @#-$%^!+=;:_()]+
	SharePassword *string `json:"sharePassword,omitempty"`
}

// GetDataAccountDetails implements the DataAccountDetailsClassification interface for type ManagedDiskDetails.
func (m *ManagedDiskDetails) GetDataAccountDetails() *DataAccountDetails {
	return &DataAccountDetails{
		DataAccountType: m.DataAccountType,
		SharePassword:   m.SharePassword,
	}
}

// ManagementClientMitigateOptions contains the optional parameters for the ManagementClient.Mitigate method.
type ManagementClientMitigateOptions struct {
	// placeholder for future optional parameters
}

// MarkDevicesShippedRequest - The request body to provide the delivery package details of job
type MarkDevicesShippedRequest struct {
	// REQUIRED; Delivery package details
	DeliverToDcPackageDetails *PackageCarrierInfo `json:"deliverToDcPackageDetails,omitempty"`
}

// MitigateJobRequest - The Mitigate Job captured from request body for Mitigate API
type MitigateJobRequest struct {
	// REQUIRED; Resolution code for the job
	CustomerResolutionCode *CustomerResolutionCode `json:"customerResolutionCode,omitempty"`
}

// NotificationPreference - Notification preference for a job stage.
type NotificationPreference struct {
	// REQUIRED; Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`

	// REQUIRED; Name of the stage.
	StageName *NotificationStageName `json:"stageName,omitempty"`
}

// Operation entity.
type Operation struct {
	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// READ-ONLY; Operation display values.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Name of the operation. Format: {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Origin of the operation. Can be : user|system|user,system
	Origin *string `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; Operation properties.
	Properties interface{} `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - Operation display
type OperationDisplay struct {
	// Localized description of the operation for display purpose.
	Description *string `json:"description,omitempty"`

	// Localized name of the operation for display purpose.
	Operation *string `json:"operation,omitempty"`

	// Provider name.
	Provider *string `json:"provider,omitempty"`

	// Resource name.
	Resource *string `json:"resource,omitempty"`
}

// OperationList - Operation Collection.
type OperationList struct {
	// Link for the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of operations.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PackageCarrierDetails - Package carrier details.
type PackageCarrierDetails struct {
	// Carrier Account Number of customer for customer disk.
	CarrierAccountNumber *string `json:"carrierAccountNumber,omitempty"`

	// Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`

	// Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty"`
}

// PackageCarrierInfo - package carrier info
type PackageCarrierInfo struct {
	// Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`

	// Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty"`
}

// PackageShippingDetails - package shipping details
type PackageShippingDetails struct {
	// READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty" azure:"ro"`

	// READ-ONLY; Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`

	// READ-ONLY; Url where shipment can be tracked.
	TrackingURL *string `json:"trackingUrl,omitempty" azure:"ro"`
}

// Preferences related to the order
type Preferences struct {
	// Preferences related to the Encryption.
	EncryptionPreferences *EncryptionPreferences `json:"encryptionPreferences,omitempty"`

	// Preferred data center region.
	PreferredDataCenterRegion []*string `json:"preferredDataCenterRegion,omitempty"`

	// Preferences related to the Access Tier of storage accounts.
	StorageAccountAccessTierPreferences []*string `json:"storageAccountAccessTierPreferences,omitempty"`

	// Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
}

// PreferencesValidationRequest - Request to validate preference of transport and data center.
type PreferencesValidationRequest struct {
	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName `json:"deviceType,omitempty"`

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// Preference of transport and data center.
	Preference *Preferences `json:"preference,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type PreferencesValidationRequest.
func (p *PreferencesValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: p.ValidationType,
	}
}

// PreferencesValidationResponseProperties - Properties of data center and transport preference validation response.
type PreferencesValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Validation status of requested data center and transport.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type PreferencesValidationResponseProperties.
func (p *PreferencesValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		ValidationType: p.ValidationType,
		Error:          p.Error,
	}
}

// RegionConfigurationRequest - Request body to get the configuration for the region.
type RegionConfigurationRequest struct {
	// Request body to get the datacenter address for given sku.
	DatacenterAddressRequest *DatacenterAddressRequest `json:"datacenterAddressRequest,omitempty"`

	// Request body to get the availability for scheduling orders.
	ScheduleAvailabilityRequest CommonScheduleAvailabilityRequestClassification `json:"scheduleAvailabilityRequest,omitempty"`

	// Request body to get the transport availability for given sku.
	TransportAvailabilityRequest *TransportAvailabilityRequest `json:"transportAvailabilityRequest,omitempty"`
}

// RegionConfigurationResponse - Configuration response specific to a region.
type RegionConfigurationResponse struct {
	// READ-ONLY; Datacenter address for given sku in a region.
	DatacenterAddressResponse DatacenterAddressResponseClassification `json:"datacenterAddressResponse,omitempty" azure:"ro"`

	// READ-ONLY; Schedule availability for given sku in a region.
	ScheduleAvailabilityResponse *ScheduleAvailabilityResponse `json:"scheduleAvailabilityResponse,omitempty" azure:"ro"`

	// READ-ONLY; Transport options available for given sku in a region.
	TransportAvailabilityResponse *TransportAvailabilityResponse `json:"transportAvailabilityResponse,omitempty" azure:"ro"`
}

// Resource - Model of the Resource.
type Resource struct {
	// REQUIRED; The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East
	// US, Southeast Asia, etc.). The region of a resource cannot be changed once it is
	// created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The sku type.
	SKU *SKU `json:"sku,omitempty"`

	// Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string `json:"tags,omitempty"`
}

// ResourceIdentity - Msi identity details of the resource
type ResourceIdentity struct {
	// Identity type
	Type *string `json:"type,omitempty"`

	// User Assigned Identities
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Home Tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SKU - The Sku.
type SKU struct {
	// REQUIRED; The sku name.
	Name *SKUName `json:"name,omitempty"`

	// The display name of the sku.
	DisplayName *string `json:"displayName,omitempty"`

	// The sku family.
	Family *string `json:"family,omitempty"`
}

// SKUAvailabilityValidationRequest - Request to validate sku availability.
type SKUAvailabilityValidationRequest struct {
	// REQUIRED; ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO3166-1alpha-2#Officiallyassignedcode_elements
	Country *string `json:"country,omitempty"`

	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName `json:"deviceType,omitempty"`

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`

	// REQUIRED; Type of the transfer.
	TransferType *TransferType `json:"transferType,omitempty"`

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type SKUAvailabilityValidationRequest.
func (s *SKUAvailabilityValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: s.ValidationType,
	}
}

// SKUAvailabilityValidationResponseProperties - Properties of sku availability validation response.
type SKUAvailabilityValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Sku availability validation status.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type SKUAvailabilityValidationResponseProperties.
func (s *SKUAvailabilityValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		ValidationType: s.ValidationType,
		Error:          s.Error,
	}
}

// SKUCapacity - Capacity of the sku.
type SKUCapacity struct {
	// READ-ONLY; Maximum capacity in TB.
	Maximum *string `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; Usable capacity in TB.
	Usable *string `json:"usable,omitempty" azure:"ro"`
}

// SKUCost - Describes metadata for retrieving price info.
type SKUCost struct {
	// READ-ONLY; Meter id of the Sku.
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; The type of the meter.
	MeterType *string `json:"meterType,omitempty" azure:"ro"`

	// READ-ONLY; Multiplier specifies the region specific value to be multiplied with 1$ guid. Eg: Our new regions will be using
	// 1$ shipping guid with appropriate multiplier specific to region.
	Multiplier *float64 `json:"multiplier,omitempty" azure:"ro"`
}

// SKUInformation - Information of the sku.
type SKUInformation struct {
	// READ-ONLY; The sku is enabled or not.
	Enabled *bool `json:"enabled,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the sku.
	Properties *SKUProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The Sku.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`
}

// SKUProperties - Properties of the sku.
type SKUProperties struct {
	// READ-ONLY; Api versions that support this Sku.
	APIVersions []*string `json:"apiVersions,omitempty" azure:"ro"`

	// READ-ONLY; Capacity of the Sku.
	Capacity *SKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; Cost of the Sku.
	Costs []*SKUCost `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The map of data location to service location.
	DataLocationToServiceLocationMap []*DataLocationToServiceLocationMap `json:"dataLocationToServiceLocationMap,omitempty" azure:"ro"`

	// READ-ONLY; Reason why the Sku is disabled.
	DisabledReason *SKUDisabledReason `json:"disabledReason,omitempty" azure:"ro"`

	// READ-ONLY; Message for why the Sku is disabled.
	DisabledReasonMessage *string `json:"disabledReasonMessage,omitempty" azure:"ro"`

	// READ-ONLY; Required feature to access the sku.
	RequiredFeature *string `json:"requiredFeature,omitempty" azure:"ro"`
}

// ScheduleAvailabilityRequest - Request body to get the availability for scheduling data box orders orders.
type ScheduleAvailabilityRequest struct {
	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName `json:"skuName,omitempty"`

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`

	// Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// ScheduleAvailabilityRequest.
func (s *ScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return &CommonScheduleAvailabilityRequest{
		StorageLocation: s.StorageLocation,
		SKUName:         s.SKUName,
		Country:         s.Country,
	}
}

// ScheduleAvailabilityResponse - Schedule availability for given sku in a region.
type ScheduleAvailabilityResponse struct {
	// READ-ONLY; List of dates available to schedule
	AvailableDates []*time.Time `json:"availableDates,omitempty" azure:"ro"`
}

// Secret - The secrets related to a DataBox.
type Secret struct {
	// READ-ONLY; Per account level access credentials.
	AccountCredentialDetails []*AccountCredentialDetails `json:"accountCredentialDetails,omitempty" azure:"ro"`

	// READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty" azure:"ro"`

	// READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty" azure:"ro"`

	// READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty" azure:"ro"`

	// READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations []*ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty" azure:"ro"`
}

// ServiceClientListAvailableSKUsByResourceGroupOptions contains the optional parameters for the ServiceClient.ListAvailableSKUsByResourceGroup
// method.
type ServiceClientListAvailableSKUsByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientRegionConfigurationByResourceGroupOptions contains the optional parameters for the ServiceClient.RegionConfigurationByResourceGroup
// method.
type ServiceClientRegionConfigurationByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientRegionConfigurationOptions contains the optional parameters for the ServiceClient.RegionConfiguration method.
type ServiceClientRegionConfigurationOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientValidateAddressOptions contains the optional parameters for the ServiceClient.ValidateAddress method.
type ServiceClientValidateAddressOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientValidateInputsByResourceGroupOptions contains the optional parameters for the ServiceClient.ValidateInputsByResourceGroup
// method.
type ServiceClientValidateInputsByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientValidateInputsOptions contains the optional parameters for the ServiceClient.ValidateInputs method.
type ServiceClientValidateInputsOptions struct {
	// placeholder for future optional parameters
}

// ShareCredentialDetails - Credential details of the shares in account.
type ShareCredentialDetails struct {
	// READ-ONLY; Password for the share.
	Password *string `json:"password,omitempty" azure:"ro"`

	// READ-ONLY; Name of the share.
	ShareName *string `json:"shareName,omitempty" azure:"ro"`

	// READ-ONLY; Type of the share.
	ShareType *ShareDestinationFormatType `json:"shareType,omitempty" azure:"ro"`

	// READ-ONLY; Access protocols supported on the device.
	SupportedAccessProtocols []*AccessProtocol `json:"supportedAccessProtocols,omitempty" azure:"ro"`

	// READ-ONLY; User name for the share.
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// ShipmentPickUpRequest - Shipment pick up request details.
type ShipmentPickUpRequest struct {
	// REQUIRED; Maximum date before which the pick up should commence, this must be in local time of pick up area.
	EndTime *time.Time `json:"endTime,omitempty"`

	// REQUIRED; Shipment Location in the pickup place. Eg.front desk
	ShipmentLocation *string `json:"shipmentLocation,omitempty"`

	// REQUIRED; Minimum date after which the pick up should commence, this must be in local time of pick up area.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// ShipmentPickUpResponse - Shipment pick up response.
type ShipmentPickUpResponse struct {
	// READ-ONLY; Confirmation number for the pick up request.
	ConfirmationNumber *string `json:"confirmationNumber,omitempty" azure:"ro"`

	// READ-ONLY; Time by which shipment should be ready for pick up, this is in local time of pick up area.
	ReadyByTime *time.Time `json:"readyByTime,omitempty" azure:"ro"`
}

// ShippingAddress - Shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// REQUIRED; Name of the Country.
	Country *string `json:"country,omitempty"`

	// REQUIRED; Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`

	// Type of address.
	AddressType *AddressType `json:"addressType,omitempty"`

	// Name of the City.
	City *string `json:"city,omitempty"`

	// Name of the company.
	CompanyName *string `json:"companyName,omitempty"`

	// Postal code.
	PostalCode *string `json:"postalCode,omitempty"`

	// Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`

	// Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`

	// Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`

	// Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
}

// StorageAccountDetails - Details for the storage account.
type StorageAccountDetails struct {
	// REQUIRED; Account Type of the data to be transferred.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty"`

	// REQUIRED; Storage Account Resource Id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If
	// this is not passed, the service will generate password itself. This will not be
	// returned in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must
	// have at least one uppercase alphabet, one number and one special character.
	// Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters
	// : @#-$%^!+=;:_()]+
	SharePassword *string `json:"sharePassword,omitempty"`
}

// GetDataAccountDetails implements the DataAccountDetailsClassification interface for type StorageAccountDetails.
func (s *StorageAccountDetails) GetDataAccountDetails() *DataAccountDetails {
	return &DataAccountDetails{
		DataAccountType: s.DataAccountType,
		SharePassword:   s.SharePassword,
	}
}

// SubscriptionIsAllowedToCreateJobValidationRequest - Request to validate subscription permission to create jobs.
type SubscriptionIsAllowedToCreateJobValidationRequest struct {
	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type SubscriptionIsAllowedToCreateJobValidationRequest.
func (s *SubscriptionIsAllowedToCreateJobValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: s.ValidationType,
	}
}

// SubscriptionIsAllowedToCreateJobValidationResponseProperties - Properties of subscription permission to create job validation
// response.
type SubscriptionIsAllowedToCreateJobValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Validation status of subscription permission to create job.
	Status *ValidationStatus `json:"status,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (s *SubscriptionIsAllowedToCreateJobValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		ValidationType: s.ValidationType,
		Error:          s.Error,
	}
}

// SystemData - Provides details about resource creation and update time
type SystemData struct {
	// READ-ONLY; The timestamp of resource creation (UTC)
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; A string identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; The type of identity that created the resource: user, application, managedIdentity
	CreatedByType *string `json:"createdByType,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty" azure:"ro"`

	// READ-ONLY; A string identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; The type of identity that last modified the resource: user, application, managedIdentity
	LastModifiedByType *string `json:"lastModifiedByType,omitempty" azure:"ro"`
}

// TransferAllDetails - Details to transfer all data.
type TransferAllDetails struct {
	// REQUIRED; Type of the account of data
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty"`

	// To indicate if all Azure blobs have to be transferred
	TransferAllBlobs *bool `json:"transferAllBlobs,omitempty"`

	// To indicate if all Azure Files have to be transferred
	TransferAllFiles *bool `json:"transferAllFiles,omitempty"`
}

// TransferConfiguration - Configuration for defining the transfer of data.
type TransferConfiguration struct {
	// REQUIRED; Type of the configuration for transfer.
	TransferConfigurationType *TransferConfigurationType `json:"transferConfigurationType,omitempty"`

	// Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is
	// given as TransferAll
	TransferAllDetails *TransferConfigurationTransferAllDetails `json:"transferAllDetails,omitempty"`

	// Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as
	// TransferUsingFilter.
	TransferFilterDetails *TransferConfigurationTransferFilterDetails `json:"transferFilterDetails,omitempty"`
}

// TransferConfigurationTransferAllDetails - Map of filter type and the details to transfer all data. This field is required
// only if the TransferConfigurationType is given as TransferAll
type TransferConfigurationTransferAllDetails struct {
	// Details to transfer all data.
	Include *TransferAllDetails `json:"include,omitempty"`
}

// TransferConfigurationTransferFilterDetails - Map of filter type and the details to filter. This field is required only
// if the TransferConfigurationType is given as TransferUsingFilter.
type TransferConfigurationTransferFilterDetails struct {
	// Details of the filtering the transfer of data.
	Include *TransferFilterDetails `json:"include,omitempty"`
}

// TransferFilterDetails - Details of the filtering the transfer of data.
type TransferFilterDetails struct {
	// REQUIRED; Type of the account of data.
	DataAccountType *DataAccountType `json:"dataAccountType,omitempty"`

	// Filter details to transfer Azure files.
	AzureFileFilterDetails *AzureFileFilterDetails `json:"azureFileFilterDetails,omitempty"`

	// Filter details to transfer blobs.
	BlobFilterDetails *BlobFilterDetails `json:"blobFilterDetails,omitempty"`

	// Details of the filter files to be used for data transfer.
	FilterFileDetails []*FilterFileDetails `json:"filterFileDetails,omitempty"`
}

// TransportAvailabilityDetails - Transport options availability details for given region.
type TransportAvailabilityDetails struct {
	// READ-ONLY; Transport Shipment Type supported for given region.
	ShipmentType *TransportShipmentTypes `json:"shipmentType,omitempty" azure:"ro"`
}

// TransportAvailabilityRequest - Request body to get the transport availability for given sku.
type TransportAvailabilityRequest struct {
	// Type of the device.
	SKUName *SKUName `json:"skuName,omitempty"`
}

// TransportAvailabilityResponse - Transport options available for given sku in a region.
type TransportAvailabilityResponse struct {
	// READ-ONLY; List of transport availability details for given region
	TransportAvailabilityDetails []*TransportAvailabilityDetails `json:"transportAvailabilityDetails,omitempty" azure:"ro"`
}

// TransportPreferences - Preferences related to the shipment logistics of the sku
type TransportPreferences struct {
	// REQUIRED; Indicates Shipment Logistics type that the customer preferred.
	PreferredShipmentType *TransportShipmentTypes `json:"preferredShipmentType,omitempty"`
}

// UnencryptedCredentials - Unencrypted credentials for accessing device.
type UnencryptedCredentials struct {
	// READ-ONLY; Name of the job.
	JobName *string `json:"jobName,omitempty" azure:"ro"`

	// READ-ONLY; Secrets related to this job.
	JobSecrets CommonJobSecretsClassification `json:"jobSecrets,omitempty" azure:"ro"`
}

// UnencryptedCredentialsList - List of unencrypted credentials for accessing device.
type UnencryptedCredentialsList struct {
	// Link for the next set of unencrypted credentials.
	NextLink *string `json:"nextLink,omitempty"`

	// List of unencrypted credentials.
	Value []*UnencryptedCredentials `json:"value,omitempty"`
}

// UpdateJobDetails - Job details for update.
type UpdateJobDetails struct {
	// Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`

	// Key encryption key for the job.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`

	// Return package details of job.
	ReturnToCustomerPackageDetails *PackageCarrierDetails `json:"returnToCustomerPackageDetails,omitempty"`

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
}

// UpdateJobProperties - Job Properties for update
type UpdateJobProperties struct {
	// Details of a job to be updated.
	Details *UpdateJobDetails `json:"details,omitempty"`
}

// UserAssignedIdentity - Class defining User assigned identity details.
type UserAssignedIdentity struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// UserAssignedProperties - User assigned identity properties.
type UserAssignedProperties struct {
	// Arm resource id for user assigned identity to be used to fetch MSI token.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ValidateAddress - The requirements to validate customer address where the device needs to be shipped.
type ValidateAddress struct {
	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName `json:"deviceType,omitempty"`

	// REQUIRED; Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type ValidateAddress.
func (v *ValidateAddress) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: v.ValidationType,
	}
}

// ValidationInputRequestClassification provides polymorphic access to related types.
// Call the interface's GetValidationInputRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CreateOrderLimitForSubscriptionValidationRequest, *DataTransferDetailsValidationRequest, *PreferencesValidationRequest,
// - *SKUAvailabilityValidationRequest, *SubscriptionIsAllowedToCreateJobValidationRequest, *ValidateAddress, *ValidationInputRequest
type ValidationInputRequestClassification interface {
	// GetValidationInputRequest returns the ValidationInputRequest content of the underlying type.
	GetValidationInputRequest() *ValidationInputRequest
}

// ValidationInputRequest - Minimum fields that must be present in any type of validation request.
type ValidationInputRequest struct {
	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type ValidationInputRequest.
func (v *ValidationInputRequest) GetValidationInputRequest() *ValidationInputRequest { return v }

// ValidationInputResponseClassification provides polymorphic access to related types.
// Call the interface's GetValidationInputResponse() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AddressValidationProperties, *CreateOrderLimitForSubscriptionValidationResponseProperties, *DataTransferDetailsValidationResponseProperties,
// - *PreferencesValidationResponseProperties, *SKUAvailabilityValidationResponseProperties, *SubscriptionIsAllowedToCreateJobValidationResponseProperties,
// - *ValidationInputResponse
type ValidationInputResponseClassification interface {
	// GetValidationInputResponse returns the ValidationInputResponse content of the underlying type.
	GetValidationInputResponse() *ValidationInputResponse
}

// ValidationInputResponse - Minimum properties that should be present in each individual validation response.
type ValidationInputResponse struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator `json:"validationType,omitempty"`

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty" azure:"ro"`
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type ValidationInputResponse.
func (v *ValidationInputResponse) GetValidationInputResponse() *ValidationInputResponse { return v }

// ValidationRequestClassification provides polymorphic access to related types.
// Call the interface's GetValidationRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CreateJobValidations, *ValidationRequest
type ValidationRequestClassification interface {
	// GetValidationRequest returns the ValidationRequest content of the underlying type.
	GetValidationRequest() *ValidationRequest
}

// ValidationRequest - Minimum request requirement of any validation category.
type ValidationRequest struct {
	// REQUIRED; List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails []ValidationInputRequestClassification `json:"individualRequestDetails,omitempty"`

	// REQUIRED; Identify the nature of validation.
	ValidationCategory *string `json:"validationCategory,omitempty"`
}

// GetValidationRequest implements the ValidationRequestClassification interface for type ValidationRequest.
func (v *ValidationRequest) GetValidationRequest() *ValidationRequest { return v }

// ValidationResponse - Response of pre job creation validations.
type ValidationResponse struct {
	// READ-ONLY; Properties of pre job creation validation response.
	Properties *ValidationResponseProperties `json:"properties,omitempty" azure:"ro"`
}

// ValidationResponseProperties - Properties of pre job creation validation response.
type ValidationResponseProperties struct {
	// READ-ONLY; List of response details contain validationType and its response as key and value respectively.
	IndividualResponseDetails []ValidationInputResponseClassification `json:"individualResponseDetails,omitempty" azure:"ro"`

	// READ-ONLY; Overall validation status.
	Status *OverallValidationStatus `json:"status,omitempty" azure:"ro"`
}
