//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

const (
	moduleName    = "armcdn"
	moduleVersion = "v1.0.0"
)

// AFDEndpointProtocols - Supported protocols for the customer's endpoint.
type AFDEndpointProtocols string

const (
	AFDEndpointProtocolsHTTP  AFDEndpointProtocols = "Http"
	AFDEndpointProtocolsHTTPS AFDEndpointProtocols = "Https"
)

// PossibleAFDEndpointProtocolsValues returns the possible values for the AFDEndpointProtocols const type.
func PossibleAFDEndpointProtocolsValues() []AFDEndpointProtocols {
	return []AFDEndpointProtocols{
		AFDEndpointProtocolsHTTP,
		AFDEndpointProtocolsHTTPS,
	}
}

// ActionType - Defines the action to take on rule match.
type ActionType string

const (
	ActionTypeAllow    ActionType = "Allow"
	ActionTypeBlock    ActionType = "Block"
	ActionTypeLog      ActionType = "Log"
	ActionTypeRedirect ActionType = "Redirect"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeAllow,
		ActionTypeBlock,
		ActionTypeLog,
		ActionTypeRedirect,
	}
}

// AfdCertificateType - Defines the source of the SSL certificate.
type AfdCertificateType string

const (
	AfdCertificateTypeAzureFirstPartyManagedCertificate AfdCertificateType = "AzureFirstPartyManagedCertificate"
	AfdCertificateTypeCustomerCertificate               AfdCertificateType = "CustomerCertificate"
	AfdCertificateTypeManagedCertificate                AfdCertificateType = "ManagedCertificate"
)

// PossibleAfdCertificateTypeValues returns the possible values for the AfdCertificateType const type.
func PossibleAfdCertificateTypeValues() []AfdCertificateType {
	return []AfdCertificateType{
		AfdCertificateTypeAzureFirstPartyManagedCertificate,
		AfdCertificateTypeCustomerCertificate,
		AfdCertificateTypeManagedCertificate,
	}
}

// AfdMinimumTLSVersion - TLS protocol version that will be used for Https
type AfdMinimumTLSVersion string

const (
	AfdMinimumTLSVersionTLS10 AfdMinimumTLSVersion = "TLS10"
	AfdMinimumTLSVersionTLS12 AfdMinimumTLSVersion = "TLS12"
)

// PossibleAfdMinimumTLSVersionValues returns the possible values for the AfdMinimumTLSVersion const type.
func PossibleAfdMinimumTLSVersionValues() []AfdMinimumTLSVersion {
	return []AfdMinimumTLSVersion{
		AfdMinimumTLSVersionTLS10,
		AfdMinimumTLSVersionTLS12,
	}
}

// AfdProvisioningState - Provisioning status
type AfdProvisioningState string

const (
	AfdProvisioningStateCreating  AfdProvisioningState = "Creating"
	AfdProvisioningStateDeleting  AfdProvisioningState = "Deleting"
	AfdProvisioningStateFailed    AfdProvisioningState = "Failed"
	AfdProvisioningStateSucceeded AfdProvisioningState = "Succeeded"
	AfdProvisioningStateUpdating  AfdProvisioningState = "Updating"
)

// PossibleAfdProvisioningStateValues returns the possible values for the AfdProvisioningState const type.
func PossibleAfdProvisioningStateValues() []AfdProvisioningState {
	return []AfdProvisioningState{
		AfdProvisioningStateCreating,
		AfdProvisioningStateDeleting,
		AfdProvisioningStateFailed,
		AfdProvisioningStateSucceeded,
		AfdProvisioningStateUpdating,
	}
}

// AfdQueryStringCachingBehavior - Defines how Frontdoor caches requests that include query strings. You can ignore any query
// strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific
// query strings.
type AfdQueryStringCachingBehavior string

const (
	AfdQueryStringCachingBehaviorIgnoreQueryString            AfdQueryStringCachingBehavior = "IgnoreQueryString"
	AfdQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings  AfdQueryStringCachingBehavior = "IgnoreSpecifiedQueryStrings"
	AfdQueryStringCachingBehaviorIncludeSpecifiedQueryStrings AfdQueryStringCachingBehavior = "IncludeSpecifiedQueryStrings"
	AfdQueryStringCachingBehaviorUseQueryString               AfdQueryStringCachingBehavior = "UseQueryString"
)

// PossibleAfdQueryStringCachingBehaviorValues returns the possible values for the AfdQueryStringCachingBehavior const type.
func PossibleAfdQueryStringCachingBehaviorValues() []AfdQueryStringCachingBehavior {
	return []AfdQueryStringCachingBehavior{
		AfdQueryStringCachingBehaviorIgnoreQueryString,
		AfdQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings,
		AfdQueryStringCachingBehaviorIncludeSpecifiedQueryStrings,
		AfdQueryStringCachingBehaviorUseQueryString,
	}
}

// Algorithm - Algorithm to use for URL signing
type Algorithm string

const (
	AlgorithmSHA256 Algorithm = "SHA256"
)

// PossibleAlgorithmValues returns the possible values for the Algorithm const type.
func PossibleAlgorithmValues() []Algorithm {
	return []Algorithm{
		AlgorithmSHA256,
	}
}

// AutoGeneratedDomainNameLabelScope - Indicates the endpoint name reuse scope. The default value is TenantReuse.
type AutoGeneratedDomainNameLabelScope string

const (
	AutoGeneratedDomainNameLabelScopeNoReuse            AutoGeneratedDomainNameLabelScope = "NoReuse"
	AutoGeneratedDomainNameLabelScopeResourceGroupReuse AutoGeneratedDomainNameLabelScope = "ResourceGroupReuse"
	AutoGeneratedDomainNameLabelScopeSubscriptionReuse  AutoGeneratedDomainNameLabelScope = "SubscriptionReuse"
	AutoGeneratedDomainNameLabelScopeTenantReuse        AutoGeneratedDomainNameLabelScope = "TenantReuse"
)

// PossibleAutoGeneratedDomainNameLabelScopeValues returns the possible values for the AutoGeneratedDomainNameLabelScope const type.
func PossibleAutoGeneratedDomainNameLabelScopeValues() []AutoGeneratedDomainNameLabelScope {
	return []AutoGeneratedDomainNameLabelScope{
		AutoGeneratedDomainNameLabelScopeNoReuse,
		AutoGeneratedDomainNameLabelScopeResourceGroupReuse,
		AutoGeneratedDomainNameLabelScopeSubscriptionReuse,
		AutoGeneratedDomainNameLabelScopeTenantReuse,
	}
}

// CacheBehavior - Caching behavior for the requests
type CacheBehavior string

const (
	CacheBehaviorBypassCache  CacheBehavior = "BypassCache"
	CacheBehaviorOverride     CacheBehavior = "Override"
	CacheBehaviorSetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns the possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{
		CacheBehaviorBypassCache,
		CacheBehaviorOverride,
		CacheBehaviorSetIfMissing,
	}
}

type CacheExpirationActionParametersTypeName string

const (
	CacheExpirationActionParametersTypeNameDeliveryRuleCacheExpirationActionParameters CacheExpirationActionParametersTypeName = "DeliveryRuleCacheExpirationActionParameters"
)

// PossibleCacheExpirationActionParametersTypeNameValues returns the possible values for the CacheExpirationActionParametersTypeName const type.
func PossibleCacheExpirationActionParametersTypeNameValues() []CacheExpirationActionParametersTypeName {
	return []CacheExpirationActionParametersTypeName{
		CacheExpirationActionParametersTypeNameDeliveryRuleCacheExpirationActionParameters,
	}
}

type CacheKeyQueryStringActionParametersTypeName string

const (
	CacheKeyQueryStringActionParametersTypeNameDeliveryRuleCacheKeyQueryStringBehaviorActionParameters CacheKeyQueryStringActionParametersTypeName = "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"
)

// PossibleCacheKeyQueryStringActionParametersTypeNameValues returns the possible values for the CacheKeyQueryStringActionParametersTypeName const type.
func PossibleCacheKeyQueryStringActionParametersTypeNameValues() []CacheKeyQueryStringActionParametersTypeName {
	return []CacheKeyQueryStringActionParametersTypeName{
		CacheKeyQueryStringActionParametersTypeNameDeliveryRuleCacheKeyQueryStringBehaviorActionParameters,
	}
}

// CacheType - The level at which the content needs to be cached.
type CacheType string

const (
	CacheTypeAll CacheType = "All"
)

// PossibleCacheTypeValues returns the possible values for the CacheType const type.
func PossibleCacheTypeValues() []CacheType {
	return []CacheType{
		CacheTypeAll,
	}
}

type CdnCertificateSourceParametersTypeName string

const (
	CdnCertificateSourceParametersTypeNameCdnCertificateSourceParameters CdnCertificateSourceParametersTypeName = "CdnCertificateSourceParameters"
)

// PossibleCdnCertificateSourceParametersTypeNameValues returns the possible values for the CdnCertificateSourceParametersTypeName const type.
func PossibleCdnCertificateSourceParametersTypeNameValues() []CdnCertificateSourceParametersTypeName {
	return []CdnCertificateSourceParametersTypeName{
		CdnCertificateSourceParametersTypeNameCdnCertificateSourceParameters,
	}
}

// CertificateSource - Defines the source of the SSL certificate.
type CertificateSource string

const (
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	CertificateSourceCdn           CertificateSource = "Cdn"
)

// PossibleCertificateSourceValues returns the possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{
		CertificateSourceAzureKeyVault,
		CertificateSourceCdn,
	}
}

// CertificateType - Type of certificate used
type CertificateType string

const (
	CertificateTypeDedicated CertificateType = "Dedicated"
	CertificateTypeShared    CertificateType = "Shared"
)

// PossibleCertificateTypeValues returns the possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{
		CertificateTypeDedicated,
		CertificateTypeShared,
	}
}

type ClientPortMatchConditionParametersTypeName string

const (
	ClientPortMatchConditionParametersTypeNameDeliveryRuleClientPortConditionParameters ClientPortMatchConditionParametersTypeName = "DeliveryRuleClientPortConditionParameters"
)

// PossibleClientPortMatchConditionParametersTypeNameValues returns the possible values for the ClientPortMatchConditionParametersTypeName const type.
func PossibleClientPortMatchConditionParametersTypeNameValues() []ClientPortMatchConditionParametersTypeName {
	return []ClientPortMatchConditionParametersTypeName{
		ClientPortMatchConditionParametersTypeNameDeliveryRuleClientPortConditionParameters,
	}
}

// ClientPortOperator - Describes operator to be matched
type ClientPortOperator string

const (
	ClientPortOperatorAny                ClientPortOperator = "Any"
	ClientPortOperatorBeginsWith         ClientPortOperator = "BeginsWith"
	ClientPortOperatorContains           ClientPortOperator = "Contains"
	ClientPortOperatorEndsWith           ClientPortOperator = "EndsWith"
	ClientPortOperatorEqual              ClientPortOperator = "Equal"
	ClientPortOperatorGreaterThan        ClientPortOperator = "GreaterThan"
	ClientPortOperatorGreaterThanOrEqual ClientPortOperator = "GreaterThanOrEqual"
	ClientPortOperatorLessThan           ClientPortOperator = "LessThan"
	ClientPortOperatorLessThanOrEqual    ClientPortOperator = "LessThanOrEqual"
	ClientPortOperatorRegEx              ClientPortOperator = "RegEx"
)

// PossibleClientPortOperatorValues returns the possible values for the ClientPortOperator const type.
func PossibleClientPortOperatorValues() []ClientPortOperator {
	return []ClientPortOperator{
		ClientPortOperatorAny,
		ClientPortOperatorBeginsWith,
		ClientPortOperatorContains,
		ClientPortOperatorEndsWith,
		ClientPortOperatorEqual,
		ClientPortOperatorGreaterThan,
		ClientPortOperatorGreaterThanOrEqual,
		ClientPortOperatorLessThan,
		ClientPortOperatorLessThanOrEqual,
		ClientPortOperatorRegEx,
	}
}

type CookiesMatchConditionParametersTypeName string

const (
	CookiesMatchConditionParametersTypeNameDeliveryRuleCookiesConditionParameters CookiesMatchConditionParametersTypeName = "DeliveryRuleCookiesConditionParameters"
)

// PossibleCookiesMatchConditionParametersTypeNameValues returns the possible values for the CookiesMatchConditionParametersTypeName const type.
func PossibleCookiesMatchConditionParametersTypeNameValues() []CookiesMatchConditionParametersTypeName {
	return []CookiesMatchConditionParametersTypeName{
		CookiesMatchConditionParametersTypeNameDeliveryRuleCookiesConditionParameters,
	}
}

// CookiesOperator - Describes operator to be matched
type CookiesOperator string

const (
	CookiesOperatorAny                CookiesOperator = "Any"
	CookiesOperatorBeginsWith         CookiesOperator = "BeginsWith"
	CookiesOperatorContains           CookiesOperator = "Contains"
	CookiesOperatorEndsWith           CookiesOperator = "EndsWith"
	CookiesOperatorEqual              CookiesOperator = "Equal"
	CookiesOperatorGreaterThan        CookiesOperator = "GreaterThan"
	CookiesOperatorGreaterThanOrEqual CookiesOperator = "GreaterThanOrEqual"
	CookiesOperatorLessThan           CookiesOperator = "LessThan"
	CookiesOperatorLessThanOrEqual    CookiesOperator = "LessThanOrEqual"
	CookiesOperatorRegEx              CookiesOperator = "RegEx"
)

// PossibleCookiesOperatorValues returns the possible values for the CookiesOperator const type.
func PossibleCookiesOperatorValues() []CookiesOperator {
	return []CookiesOperator{
		CookiesOperatorAny,
		CookiesOperatorBeginsWith,
		CookiesOperatorContains,
		CookiesOperatorEndsWith,
		CookiesOperatorEqual,
		CookiesOperatorGreaterThan,
		CookiesOperatorGreaterThanOrEqual,
		CookiesOperatorLessThan,
		CookiesOperatorLessThanOrEqual,
		CookiesOperatorRegEx,
	}
}

// CustomDomainResourceState - Resource status of the custom domain.
type CustomDomainResourceState string

const (
	CustomDomainResourceStateActive   CustomDomainResourceState = "Active"
	CustomDomainResourceStateCreating CustomDomainResourceState = "Creating"
	CustomDomainResourceStateDeleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns the possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{
		CustomDomainResourceStateActive,
		CustomDomainResourceStateCreating,
		CustomDomainResourceStateDeleting,
	}
}

// CustomHTTPSProvisioningState - Provisioning status of the custom domain.
type CustomHTTPSProvisioningState string

const (
	CustomHTTPSProvisioningStateDisabled  CustomHTTPSProvisioningState = "Disabled"
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = "Disabling"
	CustomHTTPSProvisioningStateEnabled   CustomHTTPSProvisioningState = "Enabled"
	CustomHTTPSProvisioningStateEnabling  CustomHTTPSProvisioningState = "Enabling"
	CustomHTTPSProvisioningStateFailed    CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns the possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{
		CustomHTTPSProvisioningStateDisabled,
		CustomHTTPSProvisioningStateDisabling,
		CustomHTTPSProvisioningStateEnabled,
		CustomHTTPSProvisioningStateEnabling,
		CustomHTTPSProvisioningStateFailed,
	}
}

// CustomHTTPSProvisioningSubstate - Provisioning substate shows the progress of custom HTTPS enabling/disabling process step
// by step.
type CustomHTTPSProvisioningSubstate string

const (
	CustomHTTPSProvisioningSubstateCertificateDeleted                            CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	CustomHTTPSProvisioningSubstateCertificateDeployed                           CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	CustomHTTPSProvisioningSubstateDeletingCertificate                           CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	CustomHTTPSProvisioningSubstateDeployingCertificate                          CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved        CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected        CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut        CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	CustomHTTPSProvisioningSubstateIssuingCertificate                            CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest      CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns the possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{
		CustomHTTPSProvisioningSubstateCertificateDeleted,
		CustomHTTPSProvisioningSubstateCertificateDeployed,
		CustomHTTPSProvisioningSubstateDeletingCertificate,
		CustomHTTPSProvisioningSubstateDeployingCertificate,
		CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved,
		CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected,
		CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut,
		CustomHTTPSProvisioningSubstateIssuingCertificate,
		CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval,
		CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest,
	}
}

// CustomRuleEnabledState - Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
type CustomRuleEnabledState string

const (
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	CustomRuleEnabledStateEnabled  CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns the possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{
		CustomRuleEnabledStateDisabled,
		CustomRuleEnabledStateEnabled,
	}
}

// DeleteRule - Describes the action that shall be taken when the certificate is removed from Key Vault.
type DeleteRule string

const (
	DeleteRuleNoAction DeleteRule = "NoAction"
)

// PossibleDeleteRuleValues returns the possible values for the DeleteRule const type.
func PossibleDeleteRuleValues() []DeleteRule {
	return []DeleteRule{
		DeleteRuleNoAction,
	}
}

// DeliveryRuleAction - The name of the action for the delivery rule.
type DeliveryRuleAction string

const (
	DeliveryRuleActionCacheExpiration            DeliveryRuleAction = "CacheExpiration"
	DeliveryRuleActionCacheKeyQueryString        DeliveryRuleAction = "CacheKeyQueryString"
	DeliveryRuleActionModifyRequestHeader        DeliveryRuleAction = "ModifyRequestHeader"
	DeliveryRuleActionModifyResponseHeader       DeliveryRuleAction = "ModifyResponseHeader"
	DeliveryRuleActionOriginGroupOverride        DeliveryRuleAction = "OriginGroupOverride"
	DeliveryRuleActionRouteConfigurationOverride DeliveryRuleAction = "RouteConfigurationOverride"
	DeliveryRuleActionURLRedirect                DeliveryRuleAction = "UrlRedirect"
	DeliveryRuleActionURLRewrite                 DeliveryRuleAction = "UrlRewrite"
	DeliveryRuleActionURLSigning                 DeliveryRuleAction = "UrlSigning"
)

// PossibleDeliveryRuleActionValues returns the possible values for the DeliveryRuleAction const type.
func PossibleDeliveryRuleActionValues() []DeliveryRuleAction {
	return []DeliveryRuleAction{
		DeliveryRuleActionCacheExpiration,
		DeliveryRuleActionCacheKeyQueryString,
		DeliveryRuleActionModifyRequestHeader,
		DeliveryRuleActionModifyResponseHeader,
		DeliveryRuleActionOriginGroupOverride,
		DeliveryRuleActionRouteConfigurationOverride,
		DeliveryRuleActionURLRedirect,
		DeliveryRuleActionURLRewrite,
		DeliveryRuleActionURLSigning,
	}
}

type DeploymentStatus string

const (
	DeploymentStatusFailed     DeploymentStatus = "Failed"
	DeploymentStatusInProgress DeploymentStatus = "InProgress"
	DeploymentStatusNotStarted DeploymentStatus = "NotStarted"
	DeploymentStatusSucceeded  DeploymentStatus = "Succeeded"
)

// PossibleDeploymentStatusValues returns the possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{
		DeploymentStatusFailed,
		DeploymentStatusInProgress,
		DeploymentStatusNotStarted,
		DeploymentStatusSucceeded,
	}
}

// DestinationProtocol - Protocol to use for the redirect. The default value is MatchRequest
type DestinationProtocol string

const (
	DestinationProtocolHTTP         DestinationProtocol = "Http"
	DestinationProtocolHTTPS        DestinationProtocol = "Https"
	DestinationProtocolMatchRequest DestinationProtocol = "MatchRequest"
)

// PossibleDestinationProtocolValues returns the possible values for the DestinationProtocol const type.
func PossibleDestinationProtocolValues() []DestinationProtocol {
	return []DestinationProtocol{
		DestinationProtocolHTTP,
		DestinationProtocolHTTPS,
		DestinationProtocolMatchRequest,
	}
}

// DomainValidationState - Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
// DCV stands for DomainControlValidation.
type DomainValidationState string

const (
	DomainValidationStateApproved                  DomainValidationState = "Approved"
	DomainValidationStateInternalError             DomainValidationState = "InternalError"
	DomainValidationStatePending                   DomainValidationState = "Pending"
	DomainValidationStatePendingRevalidation       DomainValidationState = "PendingRevalidation"
	DomainValidationStateRefreshingValidationToken DomainValidationState = "RefreshingValidationToken"
	DomainValidationStateRejected                  DomainValidationState = "Rejected"
	DomainValidationStateSubmitting                DomainValidationState = "Submitting"
	DomainValidationStateTimedOut                  DomainValidationState = "TimedOut"
	DomainValidationStateUnknown                   DomainValidationState = "Unknown"
)

// PossibleDomainValidationStateValues returns the possible values for the DomainValidationState const type.
func PossibleDomainValidationStateValues() []DomainValidationState {
	return []DomainValidationState{
		DomainValidationStateApproved,
		DomainValidationStateInternalError,
		DomainValidationStatePending,
		DomainValidationStatePendingRevalidation,
		DomainValidationStateRefreshingValidationToken,
		DomainValidationStateRejected,
		DomainValidationStateSubmitting,
		DomainValidationStateTimedOut,
		DomainValidationStateUnknown,
	}
}

// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
type EnabledState string

const (
	EnabledStateDisabled EnabledState = "Disabled"
	EnabledStateEnabled  EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns the possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{
		EnabledStateDisabled,
		EnabledStateEnabled,
	}
}

// EndpointProvisioningState - Provisioning status of the endpoint.
type EndpointProvisioningState string

const (
	EndpointProvisioningStateCreating  EndpointProvisioningState = "Creating"
	EndpointProvisioningStateDeleting  EndpointProvisioningState = "Deleting"
	EndpointProvisioningStateFailed    EndpointProvisioningState = "Failed"
	EndpointProvisioningStateSucceeded EndpointProvisioningState = "Succeeded"
	EndpointProvisioningStateUpdating  EndpointProvisioningState = "Updating"
)

// PossibleEndpointProvisioningStateValues returns the possible values for the EndpointProvisioningState const type.
func PossibleEndpointProvisioningStateValues() []EndpointProvisioningState {
	return []EndpointProvisioningState{
		EndpointProvisioningStateCreating,
		EndpointProvisioningStateDeleting,
		EndpointProvisioningStateFailed,
		EndpointProvisioningStateSucceeded,
		EndpointProvisioningStateUpdating,
	}
}

// EndpointResourceState - Resource status of the endpoint.
type EndpointResourceState string

const (
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	EndpointResourceStateRunning  EndpointResourceState = "Running"
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	EndpointResourceStateStopped  EndpointResourceState = "Stopped"
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns the possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{
		EndpointResourceStateCreating,
		EndpointResourceStateDeleting,
		EndpointResourceStateRunning,
		EndpointResourceStateStarting,
		EndpointResourceStateStopped,
		EndpointResourceStateStopping,
	}
}

// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends.
type ForwardingProtocol string

const (
	ForwardingProtocolHTTPOnly     ForwardingProtocol = "HttpOnly"
	ForwardingProtocolHTTPSOnly    ForwardingProtocol = "HttpsOnly"
	ForwardingProtocolMatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns the possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{
		ForwardingProtocolHTTPOnly,
		ForwardingProtocolHTTPSOnly,
		ForwardingProtocolMatchRequest,
	}
}

// GeoFilterActions - Action of the geo filter, i.e. allow or block access.
type GeoFilterActions string

const (
	GeoFilterActionsBlock GeoFilterActions = "Block"
	GeoFilterActionsAllow GeoFilterActions = "Allow"
)

// PossibleGeoFilterActionsValues returns the possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{
		GeoFilterActionsBlock,
		GeoFilterActionsAllow,
	}
}

// HTTPSRedirect - Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up
// this rule and it will be the first rule that gets executed.
type HTTPSRedirect string

const (
	HTTPSRedirectDisabled HTTPSRedirect = "Disabled"
	HTTPSRedirectEnabled  HTTPSRedirect = "Enabled"
)

// PossibleHTTPSRedirectValues returns the possible values for the HTTPSRedirect const type.
func PossibleHTTPSRedirectValues() []HTTPSRedirect {
	return []HTTPSRedirect{
		HTTPSRedirectDisabled,
		HTTPSRedirectEnabled,
	}
}

type HTTPVersionMatchConditionParametersTypeName string

const (
	HTTPVersionMatchConditionParametersTypeNameDeliveryRuleHTTPVersionConditionParameters HTTPVersionMatchConditionParametersTypeName = "DeliveryRuleHttpVersionConditionParameters"
)

// PossibleHTTPVersionMatchConditionParametersTypeNameValues returns the possible values for the HTTPVersionMatchConditionParametersTypeName const type.
func PossibleHTTPVersionMatchConditionParametersTypeNameValues() []HTTPVersionMatchConditionParametersTypeName {
	return []HTTPVersionMatchConditionParametersTypeName{
		HTTPVersionMatchConditionParametersTypeNameDeliveryRuleHTTPVersionConditionParameters,
	}
}

// HTTPVersionOperator - Describes operator to be matched
type HTTPVersionOperator string

const (
	HTTPVersionOperatorEqual HTTPVersionOperator = "Equal"
)

// PossibleHTTPVersionOperatorValues returns the possible values for the HTTPVersionOperator const type.
func PossibleHTTPVersionOperatorValues() []HTTPVersionOperator {
	return []HTTPVersionOperator{
		HTTPVersionOperatorEqual,
	}
}

// HeaderAction - Action to perform
type HeaderAction string

const (
	HeaderActionAppend    HeaderAction = "Append"
	HeaderActionDelete    HeaderAction = "Delete"
	HeaderActionOverwrite HeaderAction = "Overwrite"
)

// PossibleHeaderActionValues returns the possible values for the HeaderAction const type.
func PossibleHeaderActionValues() []HeaderAction {
	return []HeaderAction{
		HeaderActionAppend,
		HeaderActionDelete,
		HeaderActionOverwrite,
	}
}

type HeaderActionParametersTypeName string

const (
	HeaderActionParametersTypeNameDeliveryRuleHeaderActionParameters HeaderActionParametersTypeName = "DeliveryRuleHeaderActionParameters"
)

// PossibleHeaderActionParametersTypeNameValues returns the possible values for the HeaderActionParametersTypeName const type.
func PossibleHeaderActionParametersTypeNameValues() []HeaderActionParametersTypeName {
	return []HeaderActionParametersTypeName{
		HeaderActionParametersTypeNameDeliveryRuleHeaderActionParameters,
	}
}

// HealthProbeRequestType - The type of health probe request that is made.
type HealthProbeRequestType string

const (
	HealthProbeRequestTypeNotSet HealthProbeRequestType = "NotSet"
	HealthProbeRequestTypeGET    HealthProbeRequestType = "GET"
	HealthProbeRequestTypeHEAD   HealthProbeRequestType = "HEAD"
)

// PossibleHealthProbeRequestTypeValues returns the possible values for the HealthProbeRequestType const type.
func PossibleHealthProbeRequestTypeValues() []HealthProbeRequestType {
	return []HealthProbeRequestType{
		HealthProbeRequestTypeNotSet,
		HealthProbeRequestTypeGET,
		HealthProbeRequestTypeHEAD,
	}
}

type HostNameMatchConditionParametersTypeName string

const (
	HostNameMatchConditionParametersTypeNameDeliveryRuleHostNameConditionParameters HostNameMatchConditionParametersTypeName = "DeliveryRuleHostNameConditionParameters"
)

// PossibleHostNameMatchConditionParametersTypeNameValues returns the possible values for the HostNameMatchConditionParametersTypeName const type.
func PossibleHostNameMatchConditionParametersTypeNameValues() []HostNameMatchConditionParametersTypeName {
	return []HostNameMatchConditionParametersTypeName{
		HostNameMatchConditionParametersTypeNameDeliveryRuleHostNameConditionParameters,
	}
}

// HostNameOperator - Describes operator to be matched
type HostNameOperator string

const (
	HostNameOperatorAny                HostNameOperator = "Any"
	HostNameOperatorBeginsWith         HostNameOperator = "BeginsWith"
	HostNameOperatorContains           HostNameOperator = "Contains"
	HostNameOperatorEndsWith           HostNameOperator = "EndsWith"
	HostNameOperatorEqual              HostNameOperator = "Equal"
	HostNameOperatorGreaterThan        HostNameOperator = "GreaterThan"
	HostNameOperatorGreaterThanOrEqual HostNameOperator = "GreaterThanOrEqual"
	HostNameOperatorLessThan           HostNameOperator = "LessThan"
	HostNameOperatorLessThanOrEqual    HostNameOperator = "LessThanOrEqual"
	HostNameOperatorRegEx              HostNameOperator = "RegEx"
)

// PossibleHostNameOperatorValues returns the possible values for the HostNameOperator const type.
func PossibleHostNameOperatorValues() []HostNameOperator {
	return []HostNameOperator{
		HostNameOperatorAny,
		HostNameOperatorBeginsWith,
		HostNameOperatorContains,
		HostNameOperatorEndsWith,
		HostNameOperatorEqual,
		HostNameOperatorGreaterThan,
		HostNameOperatorGreaterThanOrEqual,
		HostNameOperatorLessThan,
		HostNameOperatorLessThanOrEqual,
		HostNameOperatorRegEx,
	}
}

// IdentityType - The type of identity that creates/modifies resources
type IdentityType string

const (
	IdentityTypeApplication     IdentityType = "application"
	IdentityTypeKey             IdentityType = "key"
	IdentityTypeManagedIdentity IdentityType = "managedIdentity"
	IdentityTypeUser            IdentityType = "user"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeApplication,
		IdentityTypeKey,
		IdentityTypeManagedIdentity,
		IdentityTypeUser,
	}
}

type IsDeviceMatchConditionParametersMatchValuesItem string

const (
	IsDeviceMatchConditionParametersMatchValuesItemDesktop IsDeviceMatchConditionParametersMatchValuesItem = "Desktop"
	IsDeviceMatchConditionParametersMatchValuesItemMobile  IsDeviceMatchConditionParametersMatchValuesItem = "Mobile"
)

// PossibleIsDeviceMatchConditionParametersMatchValuesItemValues returns the possible values for the IsDeviceMatchConditionParametersMatchValuesItem const type.
func PossibleIsDeviceMatchConditionParametersMatchValuesItemValues() []IsDeviceMatchConditionParametersMatchValuesItem {
	return []IsDeviceMatchConditionParametersMatchValuesItem{
		IsDeviceMatchConditionParametersMatchValuesItemDesktop,
		IsDeviceMatchConditionParametersMatchValuesItemMobile,
	}
}

type IsDeviceMatchConditionParametersTypeName string

const (
	IsDeviceMatchConditionParametersTypeNameDeliveryRuleIsDeviceConditionParameters IsDeviceMatchConditionParametersTypeName = "DeliveryRuleIsDeviceConditionParameters"
)

// PossibleIsDeviceMatchConditionParametersTypeNameValues returns the possible values for the IsDeviceMatchConditionParametersTypeName const type.
func PossibleIsDeviceMatchConditionParametersTypeNameValues() []IsDeviceMatchConditionParametersTypeName {
	return []IsDeviceMatchConditionParametersTypeName{
		IsDeviceMatchConditionParametersTypeNameDeliveryRuleIsDeviceConditionParameters,
	}
}

// IsDeviceOperator - Describes operator to be matched
type IsDeviceOperator string

const (
	IsDeviceOperatorEqual IsDeviceOperator = "Equal"
)

// PossibleIsDeviceOperatorValues returns the possible values for the IsDeviceOperator const type.
func PossibleIsDeviceOperatorValues() []IsDeviceOperator {
	return []IsDeviceOperator{
		IsDeviceOperatorEqual,
	}
}

type KeyVaultCertificateSourceParametersTypeName string

const (
	KeyVaultCertificateSourceParametersTypeNameKeyVaultCertificateSourceParameters KeyVaultCertificateSourceParametersTypeName = "KeyVaultCertificateSourceParameters"
)

// PossibleKeyVaultCertificateSourceParametersTypeNameValues returns the possible values for the KeyVaultCertificateSourceParametersTypeName const type.
func PossibleKeyVaultCertificateSourceParametersTypeNameValues() []KeyVaultCertificateSourceParametersTypeName {
	return []KeyVaultCertificateSourceParametersTypeName{
		KeyVaultCertificateSourceParametersTypeNameKeyVaultCertificateSourceParameters,
	}
}

type KeyVaultSigningKeyParametersTypeName string

const (
	KeyVaultSigningKeyParametersTypeNameKeyVaultSigningKeyParameters KeyVaultSigningKeyParametersTypeName = "KeyVaultSigningKeyParameters"
)

// PossibleKeyVaultSigningKeyParametersTypeNameValues returns the possible values for the KeyVaultSigningKeyParametersTypeName const type.
func PossibleKeyVaultSigningKeyParametersTypeNameValues() []KeyVaultSigningKeyParametersTypeName {
	return []KeyVaultSigningKeyParametersTypeName{
		KeyVaultSigningKeyParametersTypeNameKeyVaultSigningKeyParameters,
	}
}

// LinkToDefaultDomain - whether this route will be linked to the default endpoint domain.
type LinkToDefaultDomain string

const (
	LinkToDefaultDomainDisabled LinkToDefaultDomain = "Disabled"
	LinkToDefaultDomainEnabled  LinkToDefaultDomain = "Enabled"
)

// PossibleLinkToDefaultDomainValues returns the possible values for the LinkToDefaultDomain const type.
func PossibleLinkToDefaultDomainValues() []LinkToDefaultDomain {
	return []LinkToDefaultDomain{
		LinkToDefaultDomainDisabled,
		LinkToDefaultDomainEnabled,
	}
}

type LogMetric string

const (
	LogMetricClientRequestBandwidth LogMetric = "clientRequestBandwidth"
	LogMetricClientRequestCount     LogMetric = "clientRequestCount"
	LogMetricClientRequestTraffic   LogMetric = "clientRequestTraffic"
	LogMetricOriginRequestBandwidth LogMetric = "originRequestBandwidth"
	LogMetricOriginRequestTraffic   LogMetric = "originRequestTraffic"
	LogMetricTotalLatency           LogMetric = "totalLatency"
)

// PossibleLogMetricValues returns the possible values for the LogMetric const type.
func PossibleLogMetricValues() []LogMetric {
	return []LogMetric{
		LogMetricClientRequestBandwidth,
		LogMetricClientRequestCount,
		LogMetricClientRequestTraffic,
		LogMetricOriginRequestBandwidth,
		LogMetricOriginRequestTraffic,
		LogMetricTotalLatency,
	}
}

type LogMetricsGranularity string

const (
	LogMetricsGranularityP1D  LogMetricsGranularity = "P1D"
	LogMetricsGranularityPT1H LogMetricsGranularity = "PT1H"
	LogMetricsGranularityPT5M LogMetricsGranularity = "PT5M"
)

// PossibleLogMetricsGranularityValues returns the possible values for the LogMetricsGranularity const type.
func PossibleLogMetricsGranularityValues() []LogMetricsGranularity {
	return []LogMetricsGranularity{
		LogMetricsGranularityP1D,
		LogMetricsGranularityPT1H,
		LogMetricsGranularityPT5M,
	}
}

type LogMetricsGroupBy string

const (
	LogMetricsGroupByCacheStatus     LogMetricsGroupBy = "cacheStatus"
	LogMetricsGroupByCountryOrRegion LogMetricsGroupBy = "countryOrRegion"
	LogMetricsGroupByCustomDomain    LogMetricsGroupBy = "customDomain"
	LogMetricsGroupByHTTPStatusCode  LogMetricsGroupBy = "httpStatusCode"
	LogMetricsGroupByProtocol        LogMetricsGroupBy = "protocol"
)

// PossibleLogMetricsGroupByValues returns the possible values for the LogMetricsGroupBy const type.
func PossibleLogMetricsGroupByValues() []LogMetricsGroupBy {
	return []LogMetricsGroupBy{
		LogMetricsGroupByCacheStatus,
		LogMetricsGroupByCountryOrRegion,
		LogMetricsGroupByCustomDomain,
		LogMetricsGroupByHTTPStatusCode,
		LogMetricsGroupByProtocol,
	}
}

type LogRanking string

const (
	LogRankingBrowser         LogRanking = "browser"
	LogRankingCountryOrRegion LogRanking = "countryOrRegion"
	LogRankingReferrer        LogRanking = "referrer"
	LogRankingURL             LogRanking = "url"
	LogRankingUserAgent       LogRanking = "userAgent"
)

// PossibleLogRankingValues returns the possible values for the LogRanking const type.
func PossibleLogRankingValues() []LogRanking {
	return []LogRanking{
		LogRankingBrowser,
		LogRankingCountryOrRegion,
		LogRankingReferrer,
		LogRankingURL,
		LogRankingUserAgent,
	}
}

type LogRankingMetric string

const (
	LogRankingMetricClientRequestCount   LogRankingMetric = "clientRequestCount"
	LogRankingMetricClientRequestTraffic LogRankingMetric = "clientRequestTraffic"
	LogRankingMetricErrorCount           LogRankingMetric = "errorCount"
	LogRankingMetricHitCount             LogRankingMetric = "hitCount"
	LogRankingMetricMissCount            LogRankingMetric = "missCount"
	LogRankingMetricUserErrorCount       LogRankingMetric = "userErrorCount"
)

// PossibleLogRankingMetricValues returns the possible values for the LogRankingMetric const type.
func PossibleLogRankingMetricValues() []LogRankingMetric {
	return []LogRankingMetric{
		LogRankingMetricClientRequestCount,
		LogRankingMetricClientRequestTraffic,
		LogRankingMetricErrorCount,
		LogRankingMetricHitCount,
		LogRankingMetricMissCount,
		LogRankingMetricUserErrorCount,
	}
}

// ManagedRuleEnabledState - Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
type ManagedRuleEnabledState string

const (
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	ManagedRuleEnabledStateEnabled  ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns the possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{
		ManagedRuleEnabledStateDisabled,
		ManagedRuleEnabledStateEnabled,
	}
}

// MatchProcessingBehavior - If this rule is a match should the rules engine continue running the remaining rules or stop.
// If not present, defaults to Continue.
type MatchProcessingBehavior string

const (
	MatchProcessingBehaviorContinue MatchProcessingBehavior = "Continue"
	MatchProcessingBehaviorStop     MatchProcessingBehavior = "Stop"
)

// PossibleMatchProcessingBehaviorValues returns the possible values for the MatchProcessingBehavior const type.
func PossibleMatchProcessingBehaviorValues() []MatchProcessingBehavior {
	return []MatchProcessingBehavior{
		MatchProcessingBehaviorContinue,
		MatchProcessingBehaviorStop,
	}
}

// MatchVariable - The name of the condition for the delivery rule.
type MatchVariable string

const (
	MatchVariableClientPort       MatchVariable = "ClientPort"
	MatchVariableCookies          MatchVariable = "Cookies"
	MatchVariableHTTPVersion      MatchVariable = "HttpVersion"
	MatchVariableHostName         MatchVariable = "HostName"
	MatchVariableIsDevice         MatchVariable = "IsDevice"
	MatchVariablePostArgs         MatchVariable = "PostArgs"
	MatchVariableQueryString      MatchVariable = "QueryString"
	MatchVariableRemoteAddress    MatchVariable = "RemoteAddress"
	MatchVariableRequestBody      MatchVariable = "RequestBody"
	MatchVariableRequestHeader    MatchVariable = "RequestHeader"
	MatchVariableRequestMethod    MatchVariable = "RequestMethod"
	MatchVariableRequestScheme    MatchVariable = "RequestScheme"
	MatchVariableRequestURI       MatchVariable = "RequestUri"
	MatchVariableSSLProtocol      MatchVariable = "SslProtocol"
	MatchVariableServerPort       MatchVariable = "ServerPort"
	MatchVariableSocketAddr       MatchVariable = "SocketAddr"
	MatchVariableURLFileExtension MatchVariable = "UrlFileExtension"
	MatchVariableURLFileName      MatchVariable = "UrlFileName"
	MatchVariableURLPath          MatchVariable = "UrlPath"
)

// PossibleMatchVariableValues returns the possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{
		MatchVariableClientPort,
		MatchVariableCookies,
		MatchVariableHTTPVersion,
		MatchVariableHostName,
		MatchVariableIsDevice,
		MatchVariablePostArgs,
		MatchVariableQueryString,
		MatchVariableRemoteAddress,
		MatchVariableRequestBody,
		MatchVariableRequestHeader,
		MatchVariableRequestMethod,
		MatchVariableRequestScheme,
		MatchVariableRequestURI,
		MatchVariableSSLProtocol,
		MatchVariableServerPort,
		MatchVariableSocketAddr,
		MatchVariableURLFileExtension,
		MatchVariableURLFileName,
		MatchVariableURLPath,
	}
}

type MetricsResponseGranularity string

const (
	MetricsResponseGranularityP1D  MetricsResponseGranularity = "P1D"
	MetricsResponseGranularityPT1H MetricsResponseGranularity = "PT1H"
	MetricsResponseGranularityPT5M MetricsResponseGranularity = "PT5M"
)

// PossibleMetricsResponseGranularityValues returns the possible values for the MetricsResponseGranularity const type.
func PossibleMetricsResponseGranularityValues() []MetricsResponseGranularity {
	return []MetricsResponseGranularity{
		MetricsResponseGranularityP1D,
		MetricsResponseGranularityPT1H,
		MetricsResponseGranularityPT5M,
	}
}

type MetricsResponseSeriesItemUnit string

const (
	MetricsResponseSeriesItemUnitBitsPerSecond MetricsResponseSeriesItemUnit = "bitsPerSecond"
	MetricsResponseSeriesItemUnitBytes         MetricsResponseSeriesItemUnit = "bytes"
	MetricsResponseSeriesItemUnitCount         MetricsResponseSeriesItemUnit = "count"
	MetricsResponseSeriesItemUnitMilliSeconds  MetricsResponseSeriesItemUnit = "milliSeconds"
)

// PossibleMetricsResponseSeriesItemUnitValues returns the possible values for the MetricsResponseSeriesItemUnit const type.
func PossibleMetricsResponseSeriesItemUnitValues() []MetricsResponseSeriesItemUnit {
	return []MetricsResponseSeriesItemUnit{
		MetricsResponseSeriesItemUnitBitsPerSecond,
		MetricsResponseSeriesItemUnitBytes,
		MetricsResponseSeriesItemUnitCount,
		MetricsResponseSeriesItemUnitMilliSeconds,
	}
}

// MinimumTLSVersion - TLS protocol version that will be used for Https
type MinimumTLSVersion string

const (
	MinimumTLSVersionNone  MinimumTLSVersion = "None"
	MinimumTLSVersionTLS10 MinimumTLSVersion = "TLS10"
	MinimumTLSVersionTLS12 MinimumTLSVersion = "TLS12"
)

// PossibleMinimumTLSVersionValues returns the possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{
		MinimumTLSVersionNone,
		MinimumTLSVersionTLS10,
		MinimumTLSVersionTLS12,
	}
}

// Operator - Describes operator to be matched
type Operator string

const (
	OperatorAny                Operator = "Any"
	OperatorBeginsWith         Operator = "BeginsWith"
	OperatorContains           Operator = "Contains"
	OperatorEndsWith           Operator = "EndsWith"
	OperatorEqual              Operator = "Equal"
	OperatorGeoMatch           Operator = "GeoMatch"
	OperatorGreaterThan        Operator = "GreaterThan"
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	OperatorIPMatch            Operator = "IPMatch"
	OperatorLessThan           Operator = "LessThan"
	OperatorLessThanOrEqual    Operator = "LessThanOrEqual"
	OperatorRegEx              Operator = "RegEx"
)

// PossibleOperatorValues returns the possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{
		OperatorAny,
		OperatorBeginsWith,
		OperatorContains,
		OperatorEndsWith,
		OperatorEqual,
		OperatorGeoMatch,
		OperatorGreaterThan,
		OperatorGreaterThanOrEqual,
		OperatorIPMatch,
		OperatorLessThan,
		OperatorLessThanOrEqual,
		OperatorRegEx,
	}
}

// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize, e.g. Download, Media services.
// With this information we can apply scenario driven optimization.
type OptimizationType string

const (
	OptimizationTypeDynamicSiteAcceleration     OptimizationType = "DynamicSiteAcceleration"
	OptimizationTypeGeneralMediaStreaming       OptimizationType = "GeneralMediaStreaming"
	OptimizationTypeGeneralWebDelivery          OptimizationType = "GeneralWebDelivery"
	OptimizationTypeLargeFileDownload           OptimizationType = "LargeFileDownload"
	OptimizationTypeVideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns the possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{
		OptimizationTypeDynamicSiteAcceleration,
		OptimizationTypeGeneralMediaStreaming,
		OptimizationTypeGeneralWebDelivery,
		OptimizationTypeLargeFileDownload,
		OptimizationTypeVideoOnDemandMediaStreaming,
	}
}

type OriginGroupOverrideActionParametersTypeName string

const (
	OriginGroupOverrideActionParametersTypeNameDeliveryRuleOriginGroupOverrideActionParameters OriginGroupOverrideActionParametersTypeName = "DeliveryRuleOriginGroupOverrideActionParameters"
)

// PossibleOriginGroupOverrideActionParametersTypeNameValues returns the possible values for the OriginGroupOverrideActionParametersTypeName const type.
func PossibleOriginGroupOverrideActionParametersTypeNameValues() []OriginGroupOverrideActionParametersTypeName {
	return []OriginGroupOverrideActionParametersTypeName{
		OriginGroupOverrideActionParametersTypeNameDeliveryRuleOriginGroupOverrideActionParameters,
	}
}

// OriginGroupProvisioningState - Provisioning status of the origin group.
type OriginGroupProvisioningState string

const (
	OriginGroupProvisioningStateCreating  OriginGroupProvisioningState = "Creating"
	OriginGroupProvisioningStateDeleting  OriginGroupProvisioningState = "Deleting"
	OriginGroupProvisioningStateFailed    OriginGroupProvisioningState = "Failed"
	OriginGroupProvisioningStateSucceeded OriginGroupProvisioningState = "Succeeded"
	OriginGroupProvisioningStateUpdating  OriginGroupProvisioningState = "Updating"
)

// PossibleOriginGroupProvisioningStateValues returns the possible values for the OriginGroupProvisioningState const type.
func PossibleOriginGroupProvisioningStateValues() []OriginGroupProvisioningState {
	return []OriginGroupProvisioningState{
		OriginGroupProvisioningStateCreating,
		OriginGroupProvisioningStateDeleting,
		OriginGroupProvisioningStateFailed,
		OriginGroupProvisioningStateSucceeded,
		OriginGroupProvisioningStateUpdating,
	}
}

// OriginGroupResourceState - Resource status of the origin group.
type OriginGroupResourceState string

const (
	OriginGroupResourceStateActive   OriginGroupResourceState = "Active"
	OriginGroupResourceStateCreating OriginGroupResourceState = "Creating"
	OriginGroupResourceStateDeleting OriginGroupResourceState = "Deleting"
)

// PossibleOriginGroupResourceStateValues returns the possible values for the OriginGroupResourceState const type.
func PossibleOriginGroupResourceStateValues() []OriginGroupResourceState {
	return []OriginGroupResourceState{
		OriginGroupResourceStateActive,
		OriginGroupResourceStateCreating,
		OriginGroupResourceStateDeleting,
	}
}

// OriginProvisioningState - Provisioning status of the origin.
type OriginProvisioningState string

const (
	OriginProvisioningStateCreating  OriginProvisioningState = "Creating"
	OriginProvisioningStateDeleting  OriginProvisioningState = "Deleting"
	OriginProvisioningStateFailed    OriginProvisioningState = "Failed"
	OriginProvisioningStateSucceeded OriginProvisioningState = "Succeeded"
	OriginProvisioningStateUpdating  OriginProvisioningState = "Updating"
)

// PossibleOriginProvisioningStateValues returns the possible values for the OriginProvisioningState const type.
func PossibleOriginProvisioningStateValues() []OriginProvisioningState {
	return []OriginProvisioningState{
		OriginProvisioningStateCreating,
		OriginProvisioningStateDeleting,
		OriginProvisioningStateFailed,
		OriginProvisioningStateSucceeded,
		OriginProvisioningStateUpdating,
	}
}

// OriginResourceState - Resource status of the origin.
type OriginResourceState string

const (
	OriginResourceStateActive   OriginResourceState = "Active"
	OriginResourceStateCreating OriginResourceState = "Creating"
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns the possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{
		OriginResourceStateActive,
		OriginResourceStateCreating,
		OriginResourceStateDeleting,
	}
}

// ParamIndicator - Indicates the purpose of the parameter
type ParamIndicator string

const (
	ParamIndicatorExpires   ParamIndicator = "Expires"
	ParamIndicatorKeyID     ParamIndicator = "KeyId"
	ParamIndicatorSignature ParamIndicator = "Signature"
)

// PossibleParamIndicatorValues returns the possible values for the ParamIndicator const type.
func PossibleParamIndicatorValues() []ParamIndicator {
	return []ParamIndicator{
		ParamIndicatorExpires,
		ParamIndicatorKeyID,
		ParamIndicatorSignature,
	}
}

// PolicyEnabledState - describes if the policy is in enabled state or disabled state
type PolicyEnabledState string

const (
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	PolicyEnabledStateEnabled  PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns the possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{
		PolicyEnabledStateDisabled,
		PolicyEnabledStateEnabled,
	}
}

// PolicyMode - Describes if it is in detection mode or prevention mode at policy level.
type PolicyMode string

const (
	PolicyModeDetection  PolicyMode = "Detection"
	PolicyModePrevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns the possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{
		PolicyModeDetection,
		PolicyModePrevention,
	}
}

// PolicyResourceState - Resource status of the policy.
type PolicyResourceState string

const (
	PolicyResourceStateCreating  PolicyResourceState = "Creating"
	PolicyResourceStateDeleting  PolicyResourceState = "Deleting"
	PolicyResourceStateDisabled  PolicyResourceState = "Disabled"
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	PolicyResourceStateEnabled   PolicyResourceState = "Enabled"
	PolicyResourceStateEnabling  PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns the possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{
		PolicyResourceStateCreating,
		PolicyResourceStateDeleting,
		PolicyResourceStateDisabled,
		PolicyResourceStateDisabling,
		PolicyResourceStateEnabled,
		PolicyResourceStateEnabling,
	}
}

// PolicySettingsDefaultCustomBlockResponseStatusCode - If the action type is block, this field defines the default customer
// overridable http response status code.
type PolicySettingsDefaultCustomBlockResponseStatusCode int32

const (
	PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredFive       PolicySettingsDefaultCustomBlockResponseStatusCode = 405
	PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredSix        PolicySettingsDefaultCustomBlockResponseStatusCode = 406
	PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredThree      PolicySettingsDefaultCustomBlockResponseStatusCode = 403
	PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredTwentyNine PolicySettingsDefaultCustomBlockResponseStatusCode = 429
	PolicySettingsDefaultCustomBlockResponseStatusCodeTwoHundred            PolicySettingsDefaultCustomBlockResponseStatusCode = 200
)

// PossiblePolicySettingsDefaultCustomBlockResponseStatusCodeValues returns the possible values for the PolicySettingsDefaultCustomBlockResponseStatusCode const type.
func PossiblePolicySettingsDefaultCustomBlockResponseStatusCodeValues() []PolicySettingsDefaultCustomBlockResponseStatusCode {
	return []PolicySettingsDefaultCustomBlockResponseStatusCode{
		PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredFive,
		PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredSix,
		PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredThree,
		PolicySettingsDefaultCustomBlockResponseStatusCodeFourHundredTwentyNine,
		PolicySettingsDefaultCustomBlockResponseStatusCodeTwoHundred,
	}
}

type PostArgsMatchConditionParametersTypeName string

const (
	PostArgsMatchConditionParametersTypeNameDeliveryRulePostArgsConditionParameters PostArgsMatchConditionParametersTypeName = "DeliveryRulePostArgsConditionParameters"
)

// PossiblePostArgsMatchConditionParametersTypeNameValues returns the possible values for the PostArgsMatchConditionParametersTypeName const type.
func PossiblePostArgsMatchConditionParametersTypeNameValues() []PostArgsMatchConditionParametersTypeName {
	return []PostArgsMatchConditionParametersTypeName{
		PostArgsMatchConditionParametersTypeNameDeliveryRulePostArgsConditionParameters,
	}
}

// PostArgsOperator - Describes operator to be matched
type PostArgsOperator string

const (
	PostArgsOperatorAny                PostArgsOperator = "Any"
	PostArgsOperatorBeginsWith         PostArgsOperator = "BeginsWith"
	PostArgsOperatorContains           PostArgsOperator = "Contains"
	PostArgsOperatorEndsWith           PostArgsOperator = "EndsWith"
	PostArgsOperatorEqual              PostArgsOperator = "Equal"
	PostArgsOperatorGreaterThan        PostArgsOperator = "GreaterThan"
	PostArgsOperatorGreaterThanOrEqual PostArgsOperator = "GreaterThanOrEqual"
	PostArgsOperatorLessThan           PostArgsOperator = "LessThan"
	PostArgsOperatorLessThanOrEqual    PostArgsOperator = "LessThanOrEqual"
	PostArgsOperatorRegEx              PostArgsOperator = "RegEx"
)

// PossiblePostArgsOperatorValues returns the possible values for the PostArgsOperator const type.
func PossiblePostArgsOperatorValues() []PostArgsOperator {
	return []PostArgsOperator{
		PostArgsOperatorAny,
		PostArgsOperatorBeginsWith,
		PostArgsOperatorContains,
		PostArgsOperatorEndsWith,
		PostArgsOperatorEqual,
		PostArgsOperatorGreaterThan,
		PostArgsOperatorGreaterThanOrEqual,
		PostArgsOperatorLessThan,
		PostArgsOperatorLessThanOrEqual,
		PostArgsOperatorRegEx,
	}
}

// PrivateEndpointStatus - The approval status for the connection to the Private Link
type PrivateEndpointStatus string

const (
	PrivateEndpointStatusApproved     PrivateEndpointStatus = "Approved"
	PrivateEndpointStatusDisconnected PrivateEndpointStatus = "Disconnected"
	PrivateEndpointStatusPending      PrivateEndpointStatus = "Pending"
	PrivateEndpointStatusRejected     PrivateEndpointStatus = "Rejected"
	PrivateEndpointStatusTimeout      PrivateEndpointStatus = "Timeout"
)

// PossiblePrivateEndpointStatusValues returns the possible values for the PrivateEndpointStatus const type.
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return []PrivateEndpointStatus{
		PrivateEndpointStatusApproved,
		PrivateEndpointStatusDisconnected,
		PrivateEndpointStatusPending,
		PrivateEndpointStatusRejected,
		PrivateEndpointStatusTimeout,
	}
}

// ProbeProtocol - Protocol to use for health probe.
type ProbeProtocol string

const (
	ProbeProtocolNotSet ProbeProtocol = "NotSet"
	ProbeProtocolHTTP   ProbeProtocol = "Http"
	ProbeProtocolHTTPS  ProbeProtocol = "Https"
)

// PossibleProbeProtocolValues returns the possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{
		ProbeProtocolNotSet,
		ProbeProtocolHTTP,
		ProbeProtocolHTTPS,
	}
}

// ProfileProvisioningState - Provisioning status of the profile.
type ProfileProvisioningState string

const (
	ProfileProvisioningStateCreating  ProfileProvisioningState = "Creating"
	ProfileProvisioningStateDeleting  ProfileProvisioningState = "Deleting"
	ProfileProvisioningStateFailed    ProfileProvisioningState = "Failed"
	ProfileProvisioningStateSucceeded ProfileProvisioningState = "Succeeded"
	ProfileProvisioningStateUpdating  ProfileProvisioningState = "Updating"
)

// PossibleProfileProvisioningStateValues returns the possible values for the ProfileProvisioningState const type.
func PossibleProfileProvisioningStateValues() []ProfileProvisioningState {
	return []ProfileProvisioningState{
		ProfileProvisioningStateCreating,
		ProfileProvisioningStateDeleting,
		ProfileProvisioningStateFailed,
		ProfileProvisioningStateSucceeded,
		ProfileProvisioningStateUpdating,
	}
}

// ProfileResourceState - Resource status of the profile.
type ProfileResourceState string

const (
	ProfileResourceStateActive   ProfileResourceState = "Active"
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns the possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{
		ProfileResourceStateActive,
		ProfileResourceStateCreating,
		ProfileResourceStateDeleting,
		ProfileResourceStateDisabled,
	}
}

// ProtocolType - Defines the TLS extension protocol that is used for secure delivery.
type ProtocolType string

const (
	ProtocolTypeIPBased              ProtocolType = "IPBased"
	ProtocolTypeServerNameIndication ProtocolType = "ServerNameIndication"
)

// PossibleProtocolTypeValues returns the possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{
		ProtocolTypeIPBased,
		ProtocolTypeServerNameIndication,
	}
}

// ProvisioningState - Provisioning state of the WebApplicationFirewallPolicy.
type ProvisioningState string

const (
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCreating,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
	}
}

// QueryStringBehavior - Caching behavior for the requests
type QueryStringBehavior string

const (
	QueryStringBehaviorExclude    QueryStringBehavior = "Exclude"
	QueryStringBehaviorExcludeAll QueryStringBehavior = "ExcludeAll"
	QueryStringBehaviorInclude    QueryStringBehavior = "Include"
	QueryStringBehaviorIncludeAll QueryStringBehavior = "IncludeAll"
)

// PossibleQueryStringBehaviorValues returns the possible values for the QueryStringBehavior const type.
func PossibleQueryStringBehaviorValues() []QueryStringBehavior {
	return []QueryStringBehavior{
		QueryStringBehaviorExclude,
		QueryStringBehaviorExcludeAll,
		QueryStringBehaviorInclude,
		QueryStringBehaviorIncludeAll,
	}
}

// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings
// when caching, bypass caching to prevent requests that contain query strings from being cached, or cache
// every request with a unique URL.
type QueryStringCachingBehavior string

const (
	QueryStringCachingBehaviorIgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	QueryStringCachingBehaviorBypassCaching     QueryStringCachingBehavior = "BypassCaching"
	QueryStringCachingBehaviorUseQueryString    QueryStringCachingBehavior = "UseQueryString"
	QueryStringCachingBehaviorNotSet            QueryStringCachingBehavior = "NotSet"
)

// PossibleQueryStringCachingBehaviorValues returns the possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{
		QueryStringCachingBehaviorIgnoreQueryString,
		QueryStringCachingBehaviorBypassCaching,
		QueryStringCachingBehaviorUseQueryString,
		QueryStringCachingBehaviorNotSet,
	}
}

type QueryStringMatchConditionParametersTypeName string

const (
	QueryStringMatchConditionParametersTypeNameDeliveryRuleQueryStringConditionParameters QueryStringMatchConditionParametersTypeName = "DeliveryRuleQueryStringConditionParameters"
)

// PossibleQueryStringMatchConditionParametersTypeNameValues returns the possible values for the QueryStringMatchConditionParametersTypeName const type.
func PossibleQueryStringMatchConditionParametersTypeNameValues() []QueryStringMatchConditionParametersTypeName {
	return []QueryStringMatchConditionParametersTypeName{
		QueryStringMatchConditionParametersTypeNameDeliveryRuleQueryStringConditionParameters,
	}
}

// QueryStringOperator - Describes operator to be matched
type QueryStringOperator string

const (
	QueryStringOperatorAny                QueryStringOperator = "Any"
	QueryStringOperatorBeginsWith         QueryStringOperator = "BeginsWith"
	QueryStringOperatorContains           QueryStringOperator = "Contains"
	QueryStringOperatorEndsWith           QueryStringOperator = "EndsWith"
	QueryStringOperatorEqual              QueryStringOperator = "Equal"
	QueryStringOperatorGreaterThan        QueryStringOperator = "GreaterThan"
	QueryStringOperatorGreaterThanOrEqual QueryStringOperator = "GreaterThanOrEqual"
	QueryStringOperatorLessThan           QueryStringOperator = "LessThan"
	QueryStringOperatorLessThanOrEqual    QueryStringOperator = "LessThanOrEqual"
	QueryStringOperatorRegEx              QueryStringOperator = "RegEx"
)

// PossibleQueryStringOperatorValues returns the possible values for the QueryStringOperator const type.
func PossibleQueryStringOperatorValues() []QueryStringOperator {
	return []QueryStringOperator{
		QueryStringOperatorAny,
		QueryStringOperatorBeginsWith,
		QueryStringOperatorContains,
		QueryStringOperatorEndsWith,
		QueryStringOperatorEqual,
		QueryStringOperatorGreaterThan,
		QueryStringOperatorGreaterThanOrEqual,
		QueryStringOperatorLessThan,
		QueryStringOperatorLessThanOrEqual,
		QueryStringOperatorRegEx,
	}
}

// RedirectType - The redirect type the rule will use when redirecting traffic.
type RedirectType string

const (
	RedirectTypeFound             RedirectType = "Found"
	RedirectTypeMoved             RedirectType = "Moved"
	RedirectTypePermanentRedirect RedirectType = "PermanentRedirect"
	RedirectTypeTemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns the possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{
		RedirectTypeFound,
		RedirectTypeMoved,
		RedirectTypePermanentRedirect,
		RedirectTypeTemporaryRedirect,
	}
}

type RemoteAddressMatchConditionParametersTypeName string

const (
	RemoteAddressMatchConditionParametersTypeNameDeliveryRuleRemoteAddressConditionParameters RemoteAddressMatchConditionParametersTypeName = "DeliveryRuleRemoteAddressConditionParameters"
)

// PossibleRemoteAddressMatchConditionParametersTypeNameValues returns the possible values for the RemoteAddressMatchConditionParametersTypeName const type.
func PossibleRemoteAddressMatchConditionParametersTypeNameValues() []RemoteAddressMatchConditionParametersTypeName {
	return []RemoteAddressMatchConditionParametersTypeName{
		RemoteAddressMatchConditionParametersTypeNameDeliveryRuleRemoteAddressConditionParameters,
	}
}

// RemoteAddressOperator - Describes operator to be matched
type RemoteAddressOperator string

const (
	RemoteAddressOperatorAny      RemoteAddressOperator = "Any"
	RemoteAddressOperatorGeoMatch RemoteAddressOperator = "GeoMatch"
	RemoteAddressOperatorIPMatch  RemoteAddressOperator = "IPMatch"
)

// PossibleRemoteAddressOperatorValues returns the possible values for the RemoteAddressOperator const type.
func PossibleRemoteAddressOperatorValues() []RemoteAddressOperator {
	return []RemoteAddressOperator{
		RemoteAddressOperatorAny,
		RemoteAddressOperatorGeoMatch,
		RemoteAddressOperatorIPMatch,
	}
}

type RequestBodyMatchConditionParametersTypeName string

const (
	RequestBodyMatchConditionParametersTypeNameDeliveryRuleRequestBodyConditionParameters RequestBodyMatchConditionParametersTypeName = "DeliveryRuleRequestBodyConditionParameters"
)

// PossibleRequestBodyMatchConditionParametersTypeNameValues returns the possible values for the RequestBodyMatchConditionParametersTypeName const type.
func PossibleRequestBodyMatchConditionParametersTypeNameValues() []RequestBodyMatchConditionParametersTypeName {
	return []RequestBodyMatchConditionParametersTypeName{
		RequestBodyMatchConditionParametersTypeNameDeliveryRuleRequestBodyConditionParameters,
	}
}

// RequestBodyOperator - Describes operator to be matched
type RequestBodyOperator string

const (
	RequestBodyOperatorAny                RequestBodyOperator = "Any"
	RequestBodyOperatorBeginsWith         RequestBodyOperator = "BeginsWith"
	RequestBodyOperatorContains           RequestBodyOperator = "Contains"
	RequestBodyOperatorEndsWith           RequestBodyOperator = "EndsWith"
	RequestBodyOperatorEqual              RequestBodyOperator = "Equal"
	RequestBodyOperatorGreaterThan        RequestBodyOperator = "GreaterThan"
	RequestBodyOperatorGreaterThanOrEqual RequestBodyOperator = "GreaterThanOrEqual"
	RequestBodyOperatorLessThan           RequestBodyOperator = "LessThan"
	RequestBodyOperatorLessThanOrEqual    RequestBodyOperator = "LessThanOrEqual"
	RequestBodyOperatorRegEx              RequestBodyOperator = "RegEx"
)

// PossibleRequestBodyOperatorValues returns the possible values for the RequestBodyOperator const type.
func PossibleRequestBodyOperatorValues() []RequestBodyOperator {
	return []RequestBodyOperator{
		RequestBodyOperatorAny,
		RequestBodyOperatorBeginsWith,
		RequestBodyOperatorContains,
		RequestBodyOperatorEndsWith,
		RequestBodyOperatorEqual,
		RequestBodyOperatorGreaterThan,
		RequestBodyOperatorGreaterThanOrEqual,
		RequestBodyOperatorLessThan,
		RequestBodyOperatorLessThanOrEqual,
		RequestBodyOperatorRegEx,
	}
}

type RequestHeaderMatchConditionParametersTypeName string

const (
	RequestHeaderMatchConditionParametersTypeNameDeliveryRuleRequestHeaderConditionParameters RequestHeaderMatchConditionParametersTypeName = "DeliveryRuleRequestHeaderConditionParameters"
)

// PossibleRequestHeaderMatchConditionParametersTypeNameValues returns the possible values for the RequestHeaderMatchConditionParametersTypeName const type.
func PossibleRequestHeaderMatchConditionParametersTypeNameValues() []RequestHeaderMatchConditionParametersTypeName {
	return []RequestHeaderMatchConditionParametersTypeName{
		RequestHeaderMatchConditionParametersTypeNameDeliveryRuleRequestHeaderConditionParameters,
	}
}

// RequestHeaderOperator - Describes operator to be matched
type RequestHeaderOperator string

const (
	RequestHeaderOperatorAny                RequestHeaderOperator = "Any"
	RequestHeaderOperatorBeginsWith         RequestHeaderOperator = "BeginsWith"
	RequestHeaderOperatorContains           RequestHeaderOperator = "Contains"
	RequestHeaderOperatorEndsWith           RequestHeaderOperator = "EndsWith"
	RequestHeaderOperatorEqual              RequestHeaderOperator = "Equal"
	RequestHeaderOperatorGreaterThan        RequestHeaderOperator = "GreaterThan"
	RequestHeaderOperatorGreaterThanOrEqual RequestHeaderOperator = "GreaterThanOrEqual"
	RequestHeaderOperatorLessThan           RequestHeaderOperator = "LessThan"
	RequestHeaderOperatorLessThanOrEqual    RequestHeaderOperator = "LessThanOrEqual"
	RequestHeaderOperatorRegEx              RequestHeaderOperator = "RegEx"
)

// PossibleRequestHeaderOperatorValues returns the possible values for the RequestHeaderOperator const type.
func PossibleRequestHeaderOperatorValues() []RequestHeaderOperator {
	return []RequestHeaderOperator{
		RequestHeaderOperatorAny,
		RequestHeaderOperatorBeginsWith,
		RequestHeaderOperatorContains,
		RequestHeaderOperatorEndsWith,
		RequestHeaderOperatorEqual,
		RequestHeaderOperatorGreaterThan,
		RequestHeaderOperatorGreaterThanOrEqual,
		RequestHeaderOperatorLessThan,
		RequestHeaderOperatorLessThanOrEqual,
		RequestHeaderOperatorRegEx,
	}
}

type RequestMethodMatchConditionParametersMatchValuesItem string

const (
	RequestMethodMatchConditionParametersMatchValuesItemDELETE  RequestMethodMatchConditionParametersMatchValuesItem = "DELETE"
	RequestMethodMatchConditionParametersMatchValuesItemGET     RequestMethodMatchConditionParametersMatchValuesItem = "GET"
	RequestMethodMatchConditionParametersMatchValuesItemHEAD    RequestMethodMatchConditionParametersMatchValuesItem = "HEAD"
	RequestMethodMatchConditionParametersMatchValuesItemOPTIONS RequestMethodMatchConditionParametersMatchValuesItem = "OPTIONS"
	RequestMethodMatchConditionParametersMatchValuesItemPOST    RequestMethodMatchConditionParametersMatchValuesItem = "POST"
	RequestMethodMatchConditionParametersMatchValuesItemPUT     RequestMethodMatchConditionParametersMatchValuesItem = "PUT"
	RequestMethodMatchConditionParametersMatchValuesItemTRACE   RequestMethodMatchConditionParametersMatchValuesItem = "TRACE"
)

// PossibleRequestMethodMatchConditionParametersMatchValuesItemValues returns the possible values for the RequestMethodMatchConditionParametersMatchValuesItem const type.
func PossibleRequestMethodMatchConditionParametersMatchValuesItemValues() []RequestMethodMatchConditionParametersMatchValuesItem {
	return []RequestMethodMatchConditionParametersMatchValuesItem{
		RequestMethodMatchConditionParametersMatchValuesItemDELETE,
		RequestMethodMatchConditionParametersMatchValuesItemGET,
		RequestMethodMatchConditionParametersMatchValuesItemHEAD,
		RequestMethodMatchConditionParametersMatchValuesItemOPTIONS,
		RequestMethodMatchConditionParametersMatchValuesItemPOST,
		RequestMethodMatchConditionParametersMatchValuesItemPUT,
		RequestMethodMatchConditionParametersMatchValuesItemTRACE,
	}
}

type RequestMethodMatchConditionParametersTypeName string

const (
	RequestMethodMatchConditionParametersTypeNameDeliveryRuleRequestMethodConditionParameters RequestMethodMatchConditionParametersTypeName = "DeliveryRuleRequestMethodConditionParameters"
)

// PossibleRequestMethodMatchConditionParametersTypeNameValues returns the possible values for the RequestMethodMatchConditionParametersTypeName const type.
func PossibleRequestMethodMatchConditionParametersTypeNameValues() []RequestMethodMatchConditionParametersTypeName {
	return []RequestMethodMatchConditionParametersTypeName{
		RequestMethodMatchConditionParametersTypeNameDeliveryRuleRequestMethodConditionParameters,
	}
}

// RequestMethodOperator - Describes operator to be matched
type RequestMethodOperator string

const (
	RequestMethodOperatorEqual RequestMethodOperator = "Equal"
)

// PossibleRequestMethodOperatorValues returns the possible values for the RequestMethodOperator const type.
func PossibleRequestMethodOperatorValues() []RequestMethodOperator {
	return []RequestMethodOperator{
		RequestMethodOperatorEqual,
	}
}

type RequestSchemeMatchConditionParametersMatchValuesItem string

const (
	RequestSchemeMatchConditionParametersMatchValuesItemHTTP  RequestSchemeMatchConditionParametersMatchValuesItem = "HTTP"
	RequestSchemeMatchConditionParametersMatchValuesItemHTTPS RequestSchemeMatchConditionParametersMatchValuesItem = "HTTPS"
)

// PossibleRequestSchemeMatchConditionParametersMatchValuesItemValues returns the possible values for the RequestSchemeMatchConditionParametersMatchValuesItem const type.
func PossibleRequestSchemeMatchConditionParametersMatchValuesItemValues() []RequestSchemeMatchConditionParametersMatchValuesItem {
	return []RequestSchemeMatchConditionParametersMatchValuesItem{
		RequestSchemeMatchConditionParametersMatchValuesItemHTTP,
		RequestSchemeMatchConditionParametersMatchValuesItemHTTPS,
	}
}

// RequestSchemeMatchConditionParametersOperator - Describes operator to be matched
type RequestSchemeMatchConditionParametersOperator string

const (
	RequestSchemeMatchConditionParametersOperatorEqual RequestSchemeMatchConditionParametersOperator = "Equal"
)

// PossibleRequestSchemeMatchConditionParametersOperatorValues returns the possible values for the RequestSchemeMatchConditionParametersOperator const type.
func PossibleRequestSchemeMatchConditionParametersOperatorValues() []RequestSchemeMatchConditionParametersOperator {
	return []RequestSchemeMatchConditionParametersOperator{
		RequestSchemeMatchConditionParametersOperatorEqual,
	}
}

type RequestSchemeMatchConditionParametersTypeName string

const (
	RequestSchemeMatchConditionParametersTypeNameDeliveryRuleRequestSchemeConditionParameters RequestSchemeMatchConditionParametersTypeName = "DeliveryRuleRequestSchemeConditionParameters"
)

// PossibleRequestSchemeMatchConditionParametersTypeNameValues returns the possible values for the RequestSchemeMatchConditionParametersTypeName const type.
func PossibleRequestSchemeMatchConditionParametersTypeNameValues() []RequestSchemeMatchConditionParametersTypeName {
	return []RequestSchemeMatchConditionParametersTypeName{
		RequestSchemeMatchConditionParametersTypeNameDeliveryRuleRequestSchemeConditionParameters,
	}
}

type RequestURIMatchConditionParametersTypeName string

const (
	RequestURIMatchConditionParametersTypeNameDeliveryRuleRequestURIConditionParameters RequestURIMatchConditionParametersTypeName = "DeliveryRuleRequestUriConditionParameters"
)

// PossibleRequestURIMatchConditionParametersTypeNameValues returns the possible values for the RequestURIMatchConditionParametersTypeName const type.
func PossibleRequestURIMatchConditionParametersTypeNameValues() []RequestURIMatchConditionParametersTypeName {
	return []RequestURIMatchConditionParametersTypeName{
		RequestURIMatchConditionParametersTypeNameDeliveryRuleRequestURIConditionParameters,
	}
}

// RequestURIOperator - Describes operator to be matched
type RequestURIOperator string

const (
	RequestURIOperatorAny                RequestURIOperator = "Any"
	RequestURIOperatorBeginsWith         RequestURIOperator = "BeginsWith"
	RequestURIOperatorContains           RequestURIOperator = "Contains"
	RequestURIOperatorEndsWith           RequestURIOperator = "EndsWith"
	RequestURIOperatorEqual              RequestURIOperator = "Equal"
	RequestURIOperatorGreaterThan        RequestURIOperator = "GreaterThan"
	RequestURIOperatorGreaterThanOrEqual RequestURIOperator = "GreaterThanOrEqual"
	RequestURIOperatorLessThan           RequestURIOperator = "LessThan"
	RequestURIOperatorLessThanOrEqual    RequestURIOperator = "LessThanOrEqual"
	RequestURIOperatorRegEx              RequestURIOperator = "RegEx"
)

// PossibleRequestURIOperatorValues returns the possible values for the RequestURIOperator const type.
func PossibleRequestURIOperatorValues() []RequestURIOperator {
	return []RequestURIOperator{
		RequestURIOperatorAny,
		RequestURIOperatorBeginsWith,
		RequestURIOperatorContains,
		RequestURIOperatorEndsWith,
		RequestURIOperatorEqual,
		RequestURIOperatorGreaterThan,
		RequestURIOperatorGreaterThanOrEqual,
		RequestURIOperatorLessThan,
		RequestURIOperatorLessThanOrEqual,
		RequestURIOperatorRegEx,
	}
}

// ResourceType - Type of CDN resource used in CheckNameAvailability.
type ResourceType string

const (
	ResourceTypeMicrosoftCdnProfilesAfdEndpoints ResourceType = "Microsoft.Cdn/Profiles/AfdEndpoints"
	ResourceTypeMicrosoftCdnProfilesEndpoints    ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns the possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{
		ResourceTypeMicrosoftCdnProfilesAfdEndpoints,
		ResourceTypeMicrosoftCdnProfilesEndpoints,
	}
}

// ResourceUsageUnit - Unit of the usage. e.g. count.
type ResourceUsageUnit string

const (
	ResourceUsageUnitCount ResourceUsageUnit = "count"
)

// PossibleResourceUsageUnitValues returns the possible values for the ResourceUsageUnit const type.
func PossibleResourceUsageUnitValues() []ResourceUsageUnit {
	return []ResourceUsageUnit{
		ResourceUsageUnitCount,
	}
}

// ResponseBasedDetectedErrorTypes - Type of response errors for real user requests for which origin will be deemed unhealthy
type ResponseBasedDetectedErrorTypes string

const (
	ResponseBasedDetectedErrorTypesNone             ResponseBasedDetectedErrorTypes = "None"
	ResponseBasedDetectedErrorTypesTCPErrorsOnly    ResponseBasedDetectedErrorTypes = "TcpErrorsOnly"
	ResponseBasedDetectedErrorTypesTCPAndHTTPErrors ResponseBasedDetectedErrorTypes = "TcpAndHttpErrors"
)

// PossibleResponseBasedDetectedErrorTypesValues returns the possible values for the ResponseBasedDetectedErrorTypes const type.
func PossibleResponseBasedDetectedErrorTypesValues() []ResponseBasedDetectedErrorTypes {
	return []ResponseBasedDetectedErrorTypes{
		ResponseBasedDetectedErrorTypesNone,
		ResponseBasedDetectedErrorTypesTCPErrorsOnly,
		ResponseBasedDetectedErrorTypesTCPAndHTTPErrors,
	}
}

type RouteConfigurationOverrideActionParametersTypeName string

const (
	RouteConfigurationOverrideActionParametersTypeNameDeliveryRuleRouteConfigurationOverrideActionParameters RouteConfigurationOverrideActionParametersTypeName = "DeliveryRuleRouteConfigurationOverrideActionParameters"
)

// PossibleRouteConfigurationOverrideActionParametersTypeNameValues returns the possible values for the RouteConfigurationOverrideActionParametersTypeName const type.
func PossibleRouteConfigurationOverrideActionParametersTypeNameValues() []RouteConfigurationOverrideActionParametersTypeName {
	return []RouteConfigurationOverrideActionParametersTypeName{
		RouteConfigurationOverrideActionParametersTypeNameDeliveryRuleRouteConfigurationOverrideActionParameters,
	}
}

// RuleCacheBehavior - Caching behavior for the requests
type RuleCacheBehavior string

const (
	RuleCacheBehaviorHonorOrigin             RuleCacheBehavior = "HonorOrigin"
	RuleCacheBehaviorOverrideAlways          RuleCacheBehavior = "OverrideAlways"
	RuleCacheBehaviorOverrideIfOriginMissing RuleCacheBehavior = "OverrideIfOriginMissing"
)

// PossibleRuleCacheBehaviorValues returns the possible values for the RuleCacheBehavior const type.
func PossibleRuleCacheBehaviorValues() []RuleCacheBehavior {
	return []RuleCacheBehavior{
		RuleCacheBehaviorHonorOrigin,
		RuleCacheBehaviorOverrideAlways,
		RuleCacheBehaviorOverrideIfOriginMissing,
	}
}

// RuleIsCompressionEnabled - Indicates whether content compression is enabled. If compression is enabled, content will be
// served as compressed if user requests for a compressed version. Content won't be compressed on
// AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
type RuleIsCompressionEnabled string

const (
	RuleIsCompressionEnabledDisabled RuleIsCompressionEnabled = "Disabled"
	RuleIsCompressionEnabledEnabled  RuleIsCompressionEnabled = "Enabled"
)

// PossibleRuleIsCompressionEnabledValues returns the possible values for the RuleIsCompressionEnabled const type.
func PossibleRuleIsCompressionEnabledValues() []RuleIsCompressionEnabled {
	return []RuleIsCompressionEnabled{
		RuleIsCompressionEnabledDisabled,
		RuleIsCompressionEnabledEnabled,
	}
}

// RuleQueryStringCachingBehavior - Defines how Frontdoor caches requests that include query strings. You can ignore any query
// strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific
// query strings.
type RuleQueryStringCachingBehavior string

const (
	RuleQueryStringCachingBehaviorIgnoreQueryString            RuleQueryStringCachingBehavior = "IgnoreQueryString"
	RuleQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings  RuleQueryStringCachingBehavior = "IgnoreSpecifiedQueryStrings"
	RuleQueryStringCachingBehaviorIncludeSpecifiedQueryStrings RuleQueryStringCachingBehavior = "IncludeSpecifiedQueryStrings"
	RuleQueryStringCachingBehaviorUseQueryString               RuleQueryStringCachingBehavior = "UseQueryString"
)

// PossibleRuleQueryStringCachingBehaviorValues returns the possible values for the RuleQueryStringCachingBehavior const type.
func PossibleRuleQueryStringCachingBehaviorValues() []RuleQueryStringCachingBehavior {
	return []RuleQueryStringCachingBehavior{
		RuleQueryStringCachingBehaviorIgnoreQueryString,
		RuleQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings,
		RuleQueryStringCachingBehaviorIncludeSpecifiedQueryStrings,
		RuleQueryStringCachingBehaviorUseQueryString,
	}
}

// SKUName - Name of the pricing tier.
type SKUName string

const (
	SKUNameCustomVerizon                    SKUName = "Custom_Verizon"
	SKUNamePremiumAzureFrontDoor            SKUName = "Premium_AzureFrontDoor"
	SKUNamePremiumVerizon                   SKUName = "Premium_Verizon"
	SKUNameStandard955BandWidthChinaCdn     SKUName = "Standard_955BandWidth_ChinaCdn"
	SKUNameStandardAkamai                   SKUName = "Standard_Akamai"
	SKUNameStandardAvgBandWidthChinaCdn     SKUName = "Standard_AvgBandWidth_ChinaCdn"
	SKUNameStandardAzureFrontDoor           SKUName = "Standard_AzureFrontDoor"
	SKUNameStandardChinaCdn                 SKUName = "Standard_ChinaCdn"
	SKUNameStandardMicrosoft                SKUName = "Standard_Microsoft"
	SKUNameStandardPlus955BandWidthChinaCdn SKUName = "StandardPlus_955BandWidth_ChinaCdn"
	SKUNameStandardPlusAvgBandWidthChinaCdn SKUName = "StandardPlus_AvgBandWidth_ChinaCdn"
	SKUNameStandardPlusChinaCdn             SKUName = "StandardPlus_ChinaCdn"
	SKUNameStandardVerizon                  SKUName = "Standard_Verizon"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameCustomVerizon,
		SKUNamePremiumAzureFrontDoor,
		SKUNamePremiumVerizon,
		SKUNameStandard955BandWidthChinaCdn,
		SKUNameStandardAkamai,
		SKUNameStandardAvgBandWidthChinaCdn,
		SKUNameStandardAzureFrontDoor,
		SKUNameStandardChinaCdn,
		SKUNameStandardMicrosoft,
		SKUNameStandardPlus955BandWidthChinaCdn,
		SKUNameStandardPlusAvgBandWidthChinaCdn,
		SKUNameStandardPlusChinaCdn,
		SKUNameStandardVerizon,
	}
}

// SSLProtocol - The protocol of an established TLS connection.
type SSLProtocol string

const (
	SSLProtocolTLSv1  SSLProtocol = "TLSv1"
	SSLProtocolTLSv11 SSLProtocol = "TLSv1.1"
	SSLProtocolTLSv12 SSLProtocol = "TLSv1.2"
)

// PossibleSSLProtocolValues returns the possible values for the SSLProtocol const type.
func PossibleSSLProtocolValues() []SSLProtocol {
	return []SSLProtocol{
		SSLProtocolTLSv1,
		SSLProtocolTLSv11,
		SSLProtocolTLSv12,
	}
}

type SSLProtocolMatchConditionParametersTypeName string

const (
	SSLProtocolMatchConditionParametersTypeNameDeliveryRuleSSLProtocolConditionParameters SSLProtocolMatchConditionParametersTypeName = "DeliveryRuleSslProtocolConditionParameters"
)

// PossibleSSLProtocolMatchConditionParametersTypeNameValues returns the possible values for the SSLProtocolMatchConditionParametersTypeName const type.
func PossibleSSLProtocolMatchConditionParametersTypeNameValues() []SSLProtocolMatchConditionParametersTypeName {
	return []SSLProtocolMatchConditionParametersTypeName{
		SSLProtocolMatchConditionParametersTypeNameDeliveryRuleSSLProtocolConditionParameters,
	}
}

// SSLProtocolOperator - Describes operator to be matched
type SSLProtocolOperator string

const (
	SSLProtocolOperatorEqual SSLProtocolOperator = "Equal"
)

// PossibleSSLProtocolOperatorValues returns the possible values for the SSLProtocolOperator const type.
func PossibleSSLProtocolOperatorValues() []SSLProtocolOperator {
	return []SSLProtocolOperator{
		SSLProtocolOperatorEqual,
	}
}

// SecretType - The type of the secret resource.
type SecretType string

const (
	SecretTypeAzureFirstPartyManagedCertificate SecretType = "AzureFirstPartyManagedCertificate"
	SecretTypeCustomerCertificate               SecretType = "CustomerCertificate"
	SecretTypeManagedCertificate                SecretType = "ManagedCertificate"
	SecretTypeURLSigningKey                     SecretType = "UrlSigningKey"
)

// PossibleSecretTypeValues returns the possible values for the SecretType const type.
func PossibleSecretTypeValues() []SecretType {
	return []SecretType{
		SecretTypeAzureFirstPartyManagedCertificate,
		SecretTypeCustomerCertificate,
		SecretTypeManagedCertificate,
		SecretTypeURLSigningKey,
	}
}

// SecurityPolicyType - The type of the Security policy to create.
type SecurityPolicyType string

const (
	SecurityPolicyTypeWebApplicationFirewall SecurityPolicyType = "WebApplicationFirewall"
)

// PossibleSecurityPolicyTypeValues returns the possible values for the SecurityPolicyType const type.
func PossibleSecurityPolicyTypeValues() []SecurityPolicyType {
	return []SecurityPolicyType{
		SecurityPolicyTypeWebApplicationFirewall,
	}
}

type ServerPortMatchConditionParametersTypeName string

const (
	ServerPortMatchConditionParametersTypeNameDeliveryRuleServerPortConditionParameters ServerPortMatchConditionParametersTypeName = "DeliveryRuleServerPortConditionParameters"
)

// PossibleServerPortMatchConditionParametersTypeNameValues returns the possible values for the ServerPortMatchConditionParametersTypeName const type.
func PossibleServerPortMatchConditionParametersTypeNameValues() []ServerPortMatchConditionParametersTypeName {
	return []ServerPortMatchConditionParametersTypeName{
		ServerPortMatchConditionParametersTypeNameDeliveryRuleServerPortConditionParameters,
	}
}

// ServerPortOperator - Describes operator to be matched
type ServerPortOperator string

const (
	ServerPortOperatorAny                ServerPortOperator = "Any"
	ServerPortOperatorBeginsWith         ServerPortOperator = "BeginsWith"
	ServerPortOperatorContains           ServerPortOperator = "Contains"
	ServerPortOperatorEndsWith           ServerPortOperator = "EndsWith"
	ServerPortOperatorEqual              ServerPortOperator = "Equal"
	ServerPortOperatorGreaterThan        ServerPortOperator = "GreaterThan"
	ServerPortOperatorGreaterThanOrEqual ServerPortOperator = "GreaterThanOrEqual"
	ServerPortOperatorLessThan           ServerPortOperator = "LessThan"
	ServerPortOperatorLessThanOrEqual    ServerPortOperator = "LessThanOrEqual"
	ServerPortOperatorRegEx              ServerPortOperator = "RegEx"
)

// PossibleServerPortOperatorValues returns the possible values for the ServerPortOperator const type.
func PossibleServerPortOperatorValues() []ServerPortOperator {
	return []ServerPortOperator{
		ServerPortOperatorAny,
		ServerPortOperatorBeginsWith,
		ServerPortOperatorContains,
		ServerPortOperatorEndsWith,
		ServerPortOperatorEqual,
		ServerPortOperatorGreaterThan,
		ServerPortOperatorGreaterThanOrEqual,
		ServerPortOperatorLessThan,
		ServerPortOperatorLessThanOrEqual,
		ServerPortOperatorRegEx,
	}
}

// SharedPrivateLinkResourceStatus - Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected,
// or Timeout.
type SharedPrivateLinkResourceStatus string

const (
	SharedPrivateLinkResourceStatusPending      SharedPrivateLinkResourceStatus = "Pending"
	SharedPrivateLinkResourceStatusApproved     SharedPrivateLinkResourceStatus = "Approved"
	SharedPrivateLinkResourceStatusRejected     SharedPrivateLinkResourceStatus = "Rejected"
	SharedPrivateLinkResourceStatusDisconnected SharedPrivateLinkResourceStatus = "Disconnected"
	SharedPrivateLinkResourceStatusTimeout      SharedPrivateLinkResourceStatus = "Timeout"
)

// PossibleSharedPrivateLinkResourceStatusValues returns the possible values for the SharedPrivateLinkResourceStatus const type.
func PossibleSharedPrivateLinkResourceStatusValues() []SharedPrivateLinkResourceStatus {
	return []SharedPrivateLinkResourceStatus{
		SharedPrivateLinkResourceStatusPending,
		SharedPrivateLinkResourceStatusApproved,
		SharedPrivateLinkResourceStatusRejected,
		SharedPrivateLinkResourceStatusDisconnected,
		SharedPrivateLinkResourceStatusTimeout,
	}
}

type SocketAddrMatchConditionParametersTypeName string

const (
	SocketAddrMatchConditionParametersTypeNameDeliveryRuleSocketAddrConditionParameters SocketAddrMatchConditionParametersTypeName = "DeliveryRuleSocketAddrConditionParameters"
)

// PossibleSocketAddrMatchConditionParametersTypeNameValues returns the possible values for the SocketAddrMatchConditionParametersTypeName const type.
func PossibleSocketAddrMatchConditionParametersTypeNameValues() []SocketAddrMatchConditionParametersTypeName {
	return []SocketAddrMatchConditionParametersTypeName{
		SocketAddrMatchConditionParametersTypeNameDeliveryRuleSocketAddrConditionParameters,
	}
}

// SocketAddrOperator - Describes operator to be matched
type SocketAddrOperator string

const (
	SocketAddrOperatorAny     SocketAddrOperator = "Any"
	SocketAddrOperatorIPMatch SocketAddrOperator = "IPMatch"
)

// PossibleSocketAddrOperatorValues returns the possible values for the SocketAddrOperator const type.
func PossibleSocketAddrOperatorValues() []SocketAddrOperator {
	return []SocketAddrOperator{
		SocketAddrOperatorAny,
		SocketAddrOperatorIPMatch,
	}
}

// Status - The validation status.
type Status string

const (
	StatusAccessDenied       Status = "AccessDenied"
	StatusCertificateExpired Status = "CertificateExpired"
	StatusInvalid            Status = "Invalid"
	StatusValid              Status = "Valid"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusAccessDenied,
		StatusCertificateExpired,
		StatusInvalid,
		StatusValid,
	}
}

// Transform - Describes what transforms are applied before matching
type Transform string

const (
	TransformLowercase   Transform = "Lowercase"
	TransformRemoveNulls Transform = "RemoveNulls"
	TransformTrim        Transform = "Trim"
	TransformURLDecode   Transform = "UrlDecode"
	TransformURLEncode   Transform = "UrlEncode"
	TransformUppercase   Transform = "Uppercase"
)

// PossibleTransformValues returns the possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{
		TransformLowercase,
		TransformRemoveNulls,
		TransformTrim,
		TransformURLDecode,
		TransformURLEncode,
		TransformUppercase,
	}
}

// TransformType - Describes what transforms were applied before matching.
type TransformType string

const (
	TransformTypeLowercase   TransformType = "Lowercase"
	TransformTypeRemoveNulls TransformType = "RemoveNulls"
	TransformTypeTrim        TransformType = "Trim"
	TransformTypeURLDecode   TransformType = "UrlDecode"
	TransformTypeURLEncode   TransformType = "UrlEncode"
	TransformTypeUppercase   TransformType = "Uppercase"
)

// PossibleTransformTypeValues returns the possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{
		TransformTypeLowercase,
		TransformTypeRemoveNulls,
		TransformTypeTrim,
		TransformTypeURLDecode,
		TransformTypeURLEncode,
		TransformTypeUppercase,
	}
}

type URLFileExtensionMatchConditionParametersTypeName string

const (
	URLFileExtensionMatchConditionParametersTypeNameDeliveryRuleURLFileExtensionMatchConditionParameters URLFileExtensionMatchConditionParametersTypeName = "DeliveryRuleUrlFileExtensionMatchConditionParameters"
)

// PossibleURLFileExtensionMatchConditionParametersTypeNameValues returns the possible values for the URLFileExtensionMatchConditionParametersTypeName const type.
func PossibleURLFileExtensionMatchConditionParametersTypeNameValues() []URLFileExtensionMatchConditionParametersTypeName {
	return []URLFileExtensionMatchConditionParametersTypeName{
		URLFileExtensionMatchConditionParametersTypeNameDeliveryRuleURLFileExtensionMatchConditionParameters,
	}
}

// URLFileExtensionOperator - Describes operator to be matched
type URLFileExtensionOperator string

const (
	URLFileExtensionOperatorAny                URLFileExtensionOperator = "Any"
	URLFileExtensionOperatorBeginsWith         URLFileExtensionOperator = "BeginsWith"
	URLFileExtensionOperatorContains           URLFileExtensionOperator = "Contains"
	URLFileExtensionOperatorEndsWith           URLFileExtensionOperator = "EndsWith"
	URLFileExtensionOperatorEqual              URLFileExtensionOperator = "Equal"
	URLFileExtensionOperatorGreaterThan        URLFileExtensionOperator = "GreaterThan"
	URLFileExtensionOperatorGreaterThanOrEqual URLFileExtensionOperator = "GreaterThanOrEqual"
	URLFileExtensionOperatorLessThan           URLFileExtensionOperator = "LessThan"
	URLFileExtensionOperatorLessThanOrEqual    URLFileExtensionOperator = "LessThanOrEqual"
	URLFileExtensionOperatorRegEx              URLFileExtensionOperator = "RegEx"
)

// PossibleURLFileExtensionOperatorValues returns the possible values for the URLFileExtensionOperator const type.
func PossibleURLFileExtensionOperatorValues() []URLFileExtensionOperator {
	return []URLFileExtensionOperator{
		URLFileExtensionOperatorAny,
		URLFileExtensionOperatorBeginsWith,
		URLFileExtensionOperatorContains,
		URLFileExtensionOperatorEndsWith,
		URLFileExtensionOperatorEqual,
		URLFileExtensionOperatorGreaterThan,
		URLFileExtensionOperatorGreaterThanOrEqual,
		URLFileExtensionOperatorLessThan,
		URLFileExtensionOperatorLessThanOrEqual,
		URLFileExtensionOperatorRegEx,
	}
}

type URLFileNameMatchConditionParametersTypeName string

const (
	URLFileNameMatchConditionParametersTypeNameDeliveryRuleURLFilenameConditionParameters URLFileNameMatchConditionParametersTypeName = "DeliveryRuleUrlFilenameConditionParameters"
)

// PossibleURLFileNameMatchConditionParametersTypeNameValues returns the possible values for the URLFileNameMatchConditionParametersTypeName const type.
func PossibleURLFileNameMatchConditionParametersTypeNameValues() []URLFileNameMatchConditionParametersTypeName {
	return []URLFileNameMatchConditionParametersTypeName{
		URLFileNameMatchConditionParametersTypeNameDeliveryRuleURLFilenameConditionParameters,
	}
}

// URLFileNameOperator - Describes operator to be matched
type URLFileNameOperator string

const (
	URLFileNameOperatorAny                URLFileNameOperator = "Any"
	URLFileNameOperatorBeginsWith         URLFileNameOperator = "BeginsWith"
	URLFileNameOperatorContains           URLFileNameOperator = "Contains"
	URLFileNameOperatorEndsWith           URLFileNameOperator = "EndsWith"
	URLFileNameOperatorEqual              URLFileNameOperator = "Equal"
	URLFileNameOperatorGreaterThan        URLFileNameOperator = "GreaterThan"
	URLFileNameOperatorGreaterThanOrEqual URLFileNameOperator = "GreaterThanOrEqual"
	URLFileNameOperatorLessThan           URLFileNameOperator = "LessThan"
	URLFileNameOperatorLessThanOrEqual    URLFileNameOperator = "LessThanOrEqual"
	URLFileNameOperatorRegEx              URLFileNameOperator = "RegEx"
)

// PossibleURLFileNameOperatorValues returns the possible values for the URLFileNameOperator const type.
func PossibleURLFileNameOperatorValues() []URLFileNameOperator {
	return []URLFileNameOperator{
		URLFileNameOperatorAny,
		URLFileNameOperatorBeginsWith,
		URLFileNameOperatorContains,
		URLFileNameOperatorEndsWith,
		URLFileNameOperatorEqual,
		URLFileNameOperatorGreaterThan,
		URLFileNameOperatorGreaterThanOrEqual,
		URLFileNameOperatorLessThan,
		URLFileNameOperatorLessThanOrEqual,
		URLFileNameOperatorRegEx,
	}
}

type URLPathMatchConditionParametersTypeName string

const (
	URLPathMatchConditionParametersTypeNameDeliveryRuleURLPathMatchConditionParameters URLPathMatchConditionParametersTypeName = "DeliveryRuleUrlPathMatchConditionParameters"
)

// PossibleURLPathMatchConditionParametersTypeNameValues returns the possible values for the URLPathMatchConditionParametersTypeName const type.
func PossibleURLPathMatchConditionParametersTypeNameValues() []URLPathMatchConditionParametersTypeName {
	return []URLPathMatchConditionParametersTypeName{
		URLPathMatchConditionParametersTypeNameDeliveryRuleURLPathMatchConditionParameters,
	}
}

// URLPathOperator - Describes operator to be matched
type URLPathOperator string

const (
	URLPathOperatorAny                URLPathOperator = "Any"
	URLPathOperatorBeginsWith         URLPathOperator = "BeginsWith"
	URLPathOperatorContains           URLPathOperator = "Contains"
	URLPathOperatorEndsWith           URLPathOperator = "EndsWith"
	URLPathOperatorEqual              URLPathOperator = "Equal"
	URLPathOperatorGreaterThan        URLPathOperator = "GreaterThan"
	URLPathOperatorGreaterThanOrEqual URLPathOperator = "GreaterThanOrEqual"
	URLPathOperatorLessThan           URLPathOperator = "LessThan"
	URLPathOperatorLessThanOrEqual    URLPathOperator = "LessThanOrEqual"
	URLPathOperatorRegEx              URLPathOperator = "RegEx"
	URLPathOperatorWildcard           URLPathOperator = "Wildcard"
)

// PossibleURLPathOperatorValues returns the possible values for the URLPathOperator const type.
func PossibleURLPathOperatorValues() []URLPathOperator {
	return []URLPathOperator{
		URLPathOperatorAny,
		URLPathOperatorBeginsWith,
		URLPathOperatorContains,
		URLPathOperatorEndsWith,
		URLPathOperatorEqual,
		URLPathOperatorGreaterThan,
		URLPathOperatorGreaterThanOrEqual,
		URLPathOperatorLessThan,
		URLPathOperatorLessThanOrEqual,
		URLPathOperatorRegEx,
		URLPathOperatorWildcard,
	}
}

type URLRedirectActionParametersTypeName string

const (
	URLRedirectActionParametersTypeNameDeliveryRuleURLRedirectActionParameters URLRedirectActionParametersTypeName = "DeliveryRuleUrlRedirectActionParameters"
)

// PossibleURLRedirectActionParametersTypeNameValues returns the possible values for the URLRedirectActionParametersTypeName const type.
func PossibleURLRedirectActionParametersTypeNameValues() []URLRedirectActionParametersTypeName {
	return []URLRedirectActionParametersTypeName{
		URLRedirectActionParametersTypeNameDeliveryRuleURLRedirectActionParameters,
	}
}

type URLRewriteActionParametersTypeName string

const (
	URLRewriteActionParametersTypeNameDeliveryRuleURLRewriteActionParameters URLRewriteActionParametersTypeName = "DeliveryRuleUrlRewriteActionParameters"
)

// PossibleURLRewriteActionParametersTypeNameValues returns the possible values for the URLRewriteActionParametersTypeName const type.
func PossibleURLRewriteActionParametersTypeNameValues() []URLRewriteActionParametersTypeName {
	return []URLRewriteActionParametersTypeName{
		URLRewriteActionParametersTypeNameDeliveryRuleURLRewriteActionParameters,
	}
}

type URLSigningActionParametersTypeName string

const (
	URLSigningActionParametersTypeNameDeliveryRuleURLSigningActionParameters URLSigningActionParametersTypeName = "DeliveryRuleUrlSigningActionParameters"
)

// PossibleURLSigningActionParametersTypeNameValues returns the possible values for the URLSigningActionParametersTypeName const type.
func PossibleURLSigningActionParametersTypeNameValues() []URLSigningActionParametersTypeName {
	return []URLSigningActionParametersTypeName{
		URLSigningActionParametersTypeNameDeliveryRuleURLSigningActionParameters,
	}
}

// UpdateRule - Describes the action that shall be taken when the certificate is updated in Key Vault.
type UpdateRule string

const (
	UpdateRuleNoAction UpdateRule = "NoAction"
)

// PossibleUpdateRuleValues returns the possible values for the UpdateRule const type.
func PossibleUpdateRuleValues() []UpdateRule {
	return []UpdateRule{
		UpdateRuleNoAction,
	}
}

// UsageUnit - An enum describing the unit of measurement.
type UsageUnit string

const (
	UsageUnitCount UsageUnit = "Count"
)

// PossibleUsageUnitValues returns the possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{
		UsageUnitCount,
	}
}

type WafAction string

const (
	WafActionAllow    WafAction = "allow"
	WafActionBlock    WafAction = "block"
	WafActionLog      WafAction = "log"
	WafActionRedirect WafAction = "redirect"
)

// PossibleWafActionValues returns the possible values for the WafAction const type.
func PossibleWafActionValues() []WafAction {
	return []WafAction{
		WafActionAllow,
		WafActionBlock,
		WafActionLog,
		WafActionRedirect,
	}
}

type WafGranularity string

const (
	WafGranularityP1D  WafGranularity = "P1D"
	WafGranularityPT1H WafGranularity = "PT1H"
	WafGranularityPT5M WafGranularity = "PT5M"
)

// PossibleWafGranularityValues returns the possible values for the WafGranularity const type.
func PossibleWafGranularityValues() []WafGranularity {
	return []WafGranularity{
		WafGranularityP1D,
		WafGranularityPT1H,
		WafGranularityPT5M,
	}
}

// WafMatchVariable - Match variable to compare against.
type WafMatchVariable string

const (
	WafMatchVariableCookies       WafMatchVariable = "Cookies"
	WafMatchVariablePostArgs      WafMatchVariable = "PostArgs"
	WafMatchVariableQueryString   WafMatchVariable = "QueryString"
	WafMatchVariableRemoteAddr    WafMatchVariable = "RemoteAddr"
	WafMatchVariableRequestBody   WafMatchVariable = "RequestBody"
	WafMatchVariableRequestHeader WafMatchVariable = "RequestHeader"
	WafMatchVariableRequestMethod WafMatchVariable = "RequestMethod"
	WafMatchVariableRequestURI    WafMatchVariable = "RequestUri"
	WafMatchVariableSocketAddr    WafMatchVariable = "SocketAddr"
)

// PossibleWafMatchVariableValues returns the possible values for the WafMatchVariable const type.
func PossibleWafMatchVariableValues() []WafMatchVariable {
	return []WafMatchVariable{
		WafMatchVariableCookies,
		WafMatchVariablePostArgs,
		WafMatchVariableQueryString,
		WafMatchVariableRemoteAddr,
		WafMatchVariableRequestBody,
		WafMatchVariableRequestHeader,
		WafMatchVariableRequestMethod,
		WafMatchVariableRequestURI,
		WafMatchVariableSocketAddr,
	}
}

type WafMetric string

const (
	WafMetricClientRequestCount WafMetric = "clientRequestCount"
)

// PossibleWafMetricValues returns the possible values for the WafMetric const type.
func PossibleWafMetricValues() []WafMetric {
	return []WafMetric{
		WafMetricClientRequestCount,
	}
}

type WafMetricsResponseGranularity string

const (
	WafMetricsResponseGranularityP1D  WafMetricsResponseGranularity = "P1D"
	WafMetricsResponseGranularityPT1H WafMetricsResponseGranularity = "PT1H"
	WafMetricsResponseGranularityPT5M WafMetricsResponseGranularity = "PT5M"
)

// PossibleWafMetricsResponseGranularityValues returns the possible values for the WafMetricsResponseGranularity const type.
func PossibleWafMetricsResponseGranularityValues() []WafMetricsResponseGranularity {
	return []WafMetricsResponseGranularity{
		WafMetricsResponseGranularityP1D,
		WafMetricsResponseGranularityPT1H,
		WafMetricsResponseGranularityPT5M,
	}
}

type WafMetricsResponseSeriesItemUnit string

const (
	WafMetricsResponseSeriesItemUnitCount WafMetricsResponseSeriesItemUnit = "count"
)

// PossibleWafMetricsResponseSeriesItemUnitValues returns the possible values for the WafMetricsResponseSeriesItemUnit const type.
func PossibleWafMetricsResponseSeriesItemUnitValues() []WafMetricsResponseSeriesItemUnit {
	return []WafMetricsResponseSeriesItemUnit{
		WafMetricsResponseSeriesItemUnitCount,
	}
}

type WafRankingGroupBy string

const (
	WafRankingGroupByCustomDomain   WafRankingGroupBy = "customDomain"
	WafRankingGroupByHTTPStatusCode WafRankingGroupBy = "httpStatusCode"
)

// PossibleWafRankingGroupByValues returns the possible values for the WafRankingGroupBy const type.
func PossibleWafRankingGroupByValues() []WafRankingGroupBy {
	return []WafRankingGroupBy{
		WafRankingGroupByCustomDomain,
		WafRankingGroupByHTTPStatusCode,
	}
}

type WafRankingType string

const (
	WafRankingTypeAction          WafRankingType = "action"
	WafRankingTypeClientIP        WafRankingType = "clientIp"
	WafRankingTypeCountryOrRegion WafRankingType = "countryOrRegion"
	WafRankingTypeRuleGroup       WafRankingType = "ruleGroup"
	WafRankingTypeRuleID          WafRankingType = "ruleId"
	WafRankingTypeRuleType        WafRankingType = "ruleType"
	WafRankingTypeURL             WafRankingType = "url"
	WafRankingTypeUserAgent       WafRankingType = "userAgent"
)

// PossibleWafRankingTypeValues returns the possible values for the WafRankingType const type.
func PossibleWafRankingTypeValues() []WafRankingType {
	return []WafRankingType{
		WafRankingTypeAction,
		WafRankingTypeClientIP,
		WafRankingTypeCountryOrRegion,
		WafRankingTypeRuleGroup,
		WafRankingTypeRuleID,
		WafRankingTypeRuleType,
		WafRankingTypeURL,
		WafRankingTypeUserAgent,
	}
}

type WafRuleType string

const (
	WafRuleTypeBot     WafRuleType = "bot"
	WafRuleTypeCustom  WafRuleType = "custom"
	WafRuleTypeManaged WafRuleType = "managed"
)

// PossibleWafRuleTypeValues returns the possible values for the WafRuleType const type.
func PossibleWafRuleTypeValues() []WafRuleType {
	return []WafRuleType{
		WafRuleTypeBot,
		WafRuleTypeCustom,
		WafRuleTypeManaged,
	}
}
